RAD2ARCSEC = 206264.806247
"""Conversion from radians to arcseconds."""


FWHM2SIGMA = 2.436
"""Conversion factor between FWHM and sqrt(variance)."""


HEIGHTS = [80., 100., 120., 150.]
"""Commonly used heights (throughout the paper)."""


RS = [0.1, 0.5, 5, 10]
"""Commonly used radii, in meters (in the paper)."""


SEEINGS = [0.67, 1.3455, 1.48, 1.6353]
"""Upper and lower values for seeing for both SDSS and LSST."""


LSSTSEEING = 0.67
"""Estimated expected value of LSST seeing."""


SDSSSEEING = 1.43
"""Measured median value of SDSS seeing."""


LSST = (4180., 2558.)
"""The dimensions, in milimeters, of the primary and secondary LSST mirrors."""


SDSS = (1250., 585.)
"""The dimensions, in milimeters, of the primary and secondary SDSS mirrors."""
