>           _______           
>          / _____ \          
>         | |     | |         
>         | |     | |         
>         | |     | |   _ __ ___   __ _ _   _  ___         
>         | |     | |  | '__/ _ \ / _` | | | |/ _ \
>         | |_____| |  | | | (_) | (_| | |_| |  __/    
>          \______\_\  |_|  \___/ \__, |\__,_|\___|   
>                                  __/ |            
>                                 |___/ 
ASCII-Art generated by https://www.ascii-art-generator.org/

# Qrogue v0.2.1 #

Qrogue is a modernized Quantum Computing take of the classical game 
[Rogue](https://en.wikipedia.org/wiki/Rogue_%28video_game%29). 

You will play as Mike, a student of the great Quantum Computing 
scientist Robb, and together you will explore the universe with 
the help of Quantum Computing. Start on planet Earth with classical 
computer parts and elevate to new dimensions as Robb finds 
superposition-creating Hadamard gates on the moon!

From there on you will roam galaxies to gather more and more 
Quantum Gates from both handcrafted and randomly generated puzzle 
dungeons. Only if you can learn to use these gates you will be 
able to reach further and find out what awaits you at the end of 
your journey.


## Table of Contents ##
- Installation
  - Dependencies
  - Linux
  - Windows
- Notes
- How to play - Controls
- Outlook

## Installation ##


### Dependencies ###
- py_cui v0.1.4
- qiskit v0.32.0

However, both of these dependencies are installed automatically
in the virtual environment by the corresponding installer.

### Linux/macOS ###

#### Prerequisites ####

- Python 3.8
- python3-venv

For Linux/macOS you simply have to run 
```bash
cd installer && ./install.sh
```
in your downloaded Qrogue folder to create a new virtual environment for 
the game and install the required packages in there. 

Afterwards just run `play_qrogue.sh` to play the game.

### Windows ###

#### Prerequisites ####

- [Python 3.8](https://www.python.org/downloads/release/python-3812/)
- [Anaconda](https://anaconda.org/anaconda/python)

For Windows there is currently no script available that 
automatically installs everything you need. The best way is to 
create a new virtual environment with Anaconda Navigator (Python 3.8). 
Then open a terminal (e.g. Windows Powershell) and execute 
`installer\install.ps1`. You will be asked to provide the name of your 
newly created environment as well as the location you want to store your 
game data (e.g. save files, config) as parameter. 
This will install the required Packages in the virtual 
environment and setup a QrogueData folder in the specified location.

It is recommended to play the game in 
[Windows Terminal](https://www.microsoft.com/store/productId/9N0DX20HK701) 
for the best experience (a corresponding profile will be provided 
in the future!). However, every other console should also be fine. 
Simply execute `play_qrogue.ps1`

If you have no experience with setting up Python or Anaconda you 
can also use our provided build for Windows. However, there are 
also problems that can occur:
- It is very likely that your anti Virus program will think our 
provided .exe-file is a Virus. In this case you have to find out 
how to deal with it yourself since this depends on the software 
you're using.
- The game immediately crashes on execution. In this case an 
error occurred that you do not see because the console immediately 
closes. You can take a look at the log-File or start the .exe from 
a console. In most cases the error will be due to the console size
  (see Notes below) and can be fixed by changing your console's 
default font or window size.

## Notes ##

- `py_cui.errors.PyCUIOutOfBoundsError` 

Should you ever encounter this error
when starting the game please try to maximize the console you 
use for playing. This is because currently there is no automatic 
font size adaption so depending on your console settings a 
minimum width and height is required. Alternatively or if 
maximizing doesn't help you can also lower the font size of the 
console.

- newer Python versions

Usually also Python 3.9 and onward should perfectly work for 
playing Qrogue but testing is currently done for Python 3.8 so 
there is no official support yet for other versions. The same 
is true if you decide to manually install the dependencies; newer 
version will likely work but are not recommended.

## How to play - Controls ##
- Navigate in menus: Arrow Keys, wasd
- Move in game world: Arrow Keys, wasd
- Scroll in popup: Arrow Up/Arrow Down, W/S
- Close popup: Space, Enter, Escape
- Confirm selection (also in question popup): Space, Enter
- Cancel/back (also in question popup): Shift+A, Shift+Left, Backspace
- Pause: P, Tab
- Situational shortcut keys: 0-9
- Debug Keys (not for use in normal play through!)
  - Print screen: CTRL+P
  - Force re-render: CTRL+R 

## Outlook ##

What you can expect from Qrogue v0.2.2:
- more levels

