# 发布说明 - douyin-mcp-server1 v1.2.0

## 🎯 版本信息
- **包名**: `douyin-mcp-server1`
- **版本**: 1.2.0
- **发布日期**: 2025-01-05

## ✨ 新增功能

### 1. 智能音频压缩系统
- 自动检测音频时长，精确计算压缩参数
- 四级压缩策略，确保在 50MB 限制内最大化音质
- 动态调整比特率和采样率

### 2. 并发安全机制
- 每个处理器实例使用独立的临时目录
- 目录命名包含进程 ID 和 UUID
- 线程安全的文件管理系统
- 支持多进程并发调用

### 3. 错误恢复机制
- 完善的异常处理
- 自动清理临时文件
- 资源泄漏防护

## 🔧 重大改进

### 修复的问题
- ✅ 修复了 "Multimodal file size is too large" 错误
- ✅ 改进 API 调用方式，使用本地文件上传而不是 URL
- ✅ 修复临时文件清理问题
- ✅ 解决并发调用时的文件冲突

### 性能优化
- 流式处理，减少内存占用
- 智能压缩，减少网络传输时间
- 更快的文件清理机制

## 📦 安装说明

### 使用 uvx（推荐）
```bash
uvx install douyin-mcp-server1
```

### 使用 pip
```bash
pip install douyin-mcp-server1
```

### 从源码安装
```bash
git clone https://github.com/yzfly/douyin-mcp-server.git
cd douyin-mcp-server
pip install -e .
```

## ⚙️ 配置要求

### 系统依赖
- Python >= 3.10
- ffmpeg (必须安装)

### Python 依赖
- mcp >= 1.0.0
- requests
- ffmpeg-python
- tqdm
- dashscope

## 🚀 使用示例

### MCP 服务器配置
```json
{
  "mcpServers": {
    "douyin-mcp1": {
      "command": "uvx",
      "args": ["douyin-mcp-server1"],
      "env": {
        "DASHSCOPE_API_KEY": "your_api_key_here"
      }
    }
  }
}
```

### 命令行使用
```bash
# 安装后可直接运行
douyin-mcp-server1 --help

# 或使用 uvx
uvx douyin-mcp-server1 --help
```

## 🔍 技术细节

### 音频压缩算法
1. 获取实际音频时长（使用 ffprobe）
2. 根据目标大小计算所需比特率
3. 四级压缩策略：
   - Level 1: 44.1kHz 立体声，动态比特率
   - Level 2: 22.05kHz 立体声，降低比特率
   - Level 3: 16kHz 单声道
   - Level 4: 16kHz 单声道 32kbps

### 并发安全设计
- 临时目录格式: `douyin_{pid}_{uuid}_{timestamp}`
- 文件跟踪系统，确保只删除自己创建的文件
- 线程锁保护关键操作

## 🐛 已知问题

1. **ffmpeg 依赖**: 需要系统安装 ffmpeg，Python 包无法满足
2. **大文件处理**: 超过 1GB 的视频可能需要较长时间处理
3. **网络超时**: 某些地区的网络环境可能影响 API 调用

## 🔄 版本历史

### v1.2.0 (2025-01-05)
- 新增智能音频压缩
- 新增并发安全支持
- 修复文件大小限制问题

### v1.1.0
- 基础功能实现
- 抖音视频下载
- 音频提取

### v1.0.0
- 初始发布

## 📞 支持

- **GitHub**: https://github.com/yzfly/douyin-mcp-server
- **Issues**: https://github.com/yzfly/douyin-mcp-server/issues
- **PyPI**: https://pypi.org/project/douyin-mcp-server1/

## 📄 许可证

Apache License 2.0 - 详见 [LICENSE](LICENSE) 文件