# WARNING: Please don't edit this file. It was generated by Python/WinRT v1.0.0-beta.8

import enum
import datetime
import sys
import types
import typing

import winsdk.system
import winsdk.windows.applicationmodel
import winsdk.windows.foundation
import winsdk.windows.foundation.collections
import winsdk.windows.system
import winsdk.windows.web.http

class StoreCanLicenseStatus(enum.IntEnum):
    NOT_LICENSABLE_TO_USER = 0
    LICENSABLE = 1
    LICENSE_ACTION_NOT_APPLICABLE_TO_PRODUCT = 2
    NETWORK_ERROR = 3
    SERVER_ERROR = 4

class StoreConsumableStatus(enum.IntEnum):
    SUCCEEDED = 0
    INSUFFICENT_QUANTITY = 1
    NETWORK_ERROR = 2
    SERVER_ERROR = 3

class StoreDurationUnit(enum.IntEnum):
    MINUTE = 0
    HOUR = 1
    DAY = 2
    WEEK = 3
    MONTH = 4
    YEAR = 5

class StorePackageUpdateState(enum.IntEnum):
    PENDING = 0
    DOWNLOADING = 1
    DEPLOYING = 2
    COMPLETED = 3
    CANCELED = 4
    OTHER_ERROR = 5
    ERROR_LOW_BATTERY = 6
    ERROR_WI_FI_RECOMMENDED = 7
    ERROR_WI_FI_REQUIRED = 8

class StorePurchaseStatus(enum.IntEnum):
    SUCCEEDED = 0
    ALREADY_PURCHASED = 1
    NOT_PURCHASED = 2
    NETWORK_ERROR = 3
    SERVER_ERROR = 4

class StoreQueueItemExtendedState(enum.IntEnum):
    ACTIVE_PENDING = 0
    ACTIVE_STARTING = 1
    ACTIVE_ACQUIRING_LICENSE = 2
    ACTIVE_DOWNLOADING = 3
    ACTIVE_RESTORING_DATA = 4
    ACTIVE_INSTALLING = 5
    COMPLETED = 6
    CANCELED = 7
    PAUSED = 8
    ERROR = 9
    PAUSED_PACKAGES_IN_USE = 10
    PAUSED_LOW_BATTERY = 11
    PAUSED_WI_FI_RECOMMENDED = 12
    PAUSED_WI_FI_REQUIRED = 13
    PAUSED_READY_TO_INSTALL = 14

class StoreQueueItemKind(enum.IntEnum):
    INSTALL = 0
    UPDATE = 1
    REPAIR = 2

class StoreQueueItemState(enum.IntEnum):
    ACTIVE = 0
    COMPLETED = 1
    CANCELED = 2
    ERROR = 3
    PAUSED = 4

class StoreRateAndReviewStatus(enum.IntEnum):
    SUCCEEDED = 0
    CANCELED_BY_USER = 1
    NETWORK_ERROR = 2
    ERROR = 3

class StoreUninstallStorePackageStatus(enum.IntEnum):
    SUCCEEDED = 0
    CANCELED_BY_USER = 1
    NETWORK_ERROR = 2
    UNINSTALL_NOT_APPLICABLE = 3
    ERROR = 4

Self = typing.TypeVar('Self')

class StorePackageUpdateStatus:
    package_family_name: str
    package_download_size_in_bytes: winsdk.system.UInt64
    package_bytes_downloaded: winsdk.system.UInt64
    package_download_progress: winsdk.system.Double
    total_download_progress: winsdk.system.Double
    package_update_state: StorePackageUpdateState
    def __new__(cls: typing.Type[StorePackageUpdateStatus], package_family_name: str, package_download_size_in_bytes: winsdk.system.UInt64, package_bytes_downloaded: winsdk.system.UInt64, package_download_progress: winsdk.system.Double, total_download_progress: winsdk.system.Double, package_update_state: StorePackageUpdateState) -> StorePackageUpdateStatus: ...

class StoreAcquireLicenseResult(winsdk.system.Object):
    extended_error: winsdk.windows.foundation.HResult
    store_package_license: typing.Optional[StorePackageLicense]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StoreAcquireLicenseResult: ...

class StoreAppLicense(winsdk.system.Object):
    add_on_licenses: typing.Optional[winsdk.windows.foundation.collections.IMapView[str, StoreLicense]]
    expiration_date: datetime.datetime
    extended_json_data: str
    is_active: winsdk.system.Boolean
    is_trial: winsdk.system.Boolean
    is_trial_owned_by_this_user: winsdk.system.Boolean
    sku_store_id: str
    trial_time_remaining: datetime.timedelta
    trial_unique_id: str
    is_disc_license: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StoreAppLicense: ...

class StoreAvailability(winsdk.system.Object):
    end_date: datetime.datetime
    extended_json_data: str
    price: typing.Optional[StorePrice]
    store_id: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StoreAvailability: ...
    @typing.overload
    def request_purchase_async(self) -> winsdk.windows.foundation.IAsyncOperation[StorePurchaseResult]: ...
    @typing.overload
    def request_purchase_async(self, store_purchase_properties: typing.Optional[StorePurchaseProperties]) -> winsdk.windows.foundation.IAsyncOperation[StorePurchaseResult]: ...

class StoreCanAcquireLicenseResult(winsdk.system.Object):
    extended_error: winsdk.windows.foundation.HResult
    licensable_sku: str
    status: StoreCanLicenseStatus
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StoreCanAcquireLicenseResult: ...

class StoreCollectionData(winsdk.system.Object):
    acquired_date: datetime.datetime
    campaign_id: str
    developer_offer_id: str
    end_date: datetime.datetime
    extended_json_data: str
    is_trial: winsdk.system.Boolean
    start_date: datetime.datetime
    trial_time_remaining: datetime.timedelta
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StoreCollectionData: ...

class StoreConsumableResult(winsdk.system.Object):
    balance_remaining: winsdk.system.UInt32
    extended_error: winsdk.windows.foundation.HResult
    status: StoreConsumableStatus
    tracking_id: winsdk.system.Guid
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StoreConsumableResult: ...

class StoreContext(winsdk.system.Object):
    user: typing.Optional[winsdk.windows.system.User]
    can_silently_download_store_package_updates: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StoreContext: ...
    def acquire_store_license_for_optional_package_async(self, optional_package: typing.Optional[winsdk.windows.applicationmodel.Package]) -> winsdk.windows.foundation.IAsyncOperation[StoreAcquireLicenseResult]: ...
    def can_acquire_store_license_async(self, product_store_id: str) -> winsdk.windows.foundation.IAsyncOperation[StoreCanAcquireLicenseResult]: ...
    def can_acquire_store_license_for_optional_package_async(self, optional_package: typing.Optional[winsdk.windows.applicationmodel.Package]) -> winsdk.windows.foundation.IAsyncOperation[StoreCanAcquireLicenseResult]: ...
    def download_and_install_store_packages_async(self, store_ids: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncOperationWithProgress[StorePackageUpdateResult, StorePackageUpdateStatus]: ...
    def find_store_product_for_package_async(self, product_kinds: typing.Iterable[str], package: typing.Optional[winsdk.windows.applicationmodel.Package]) -> winsdk.windows.foundation.IAsyncOperation[StoreProductResult]: ...
    def get_app_and_optional_store_package_updates_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[StorePackageUpdate]]: ...
    def get_app_license_async(self) -> winsdk.windows.foundation.IAsyncOperation[StoreAppLicense]: ...
    def get_associated_store_products_async(self, product_kinds: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncOperation[StoreProductQueryResult]: ...
    def get_associated_store_products_with_paging_async(self, product_kinds: typing.Iterable[str], max_items_to_retrieve_per_page: winsdk.system.UInt32) -> winsdk.windows.foundation.IAsyncOperation[StoreProductPagedQueryResult]: ...
    def get_associated_store_queue_items_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[StoreQueueItem]]: ...
    def get_consumable_balance_remaining_async(self, product_store_id: str) -> winsdk.windows.foundation.IAsyncOperation[StoreConsumableResult]: ...
    def get_customer_collections_id_async(self, service_ticket: str, publisher_user_id: str) -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    def get_customer_purchase_id_async(self, service_ticket: str, publisher_user_id: str) -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    @staticmethod
    def get_default() -> typing.Optional[StoreContext]: ...
    @staticmethod
    def get_for_user(user: typing.Optional[winsdk.windows.system.User]) -> typing.Optional[StoreContext]: ...
    def get_store_product_for_current_app_async(self) -> winsdk.windows.foundation.IAsyncOperation[StoreProductResult]: ...
    @typing.overload
    def get_store_products_async(self, product_kinds: typing.Iterable[str], store_ids: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncOperation[StoreProductQueryResult]: ...
    @typing.overload
    def get_store_products_async(self, product_kinds: typing.Iterable[str], store_ids: typing.Iterable[str], store_product_options: typing.Optional[StoreProductOptions]) -> winsdk.windows.foundation.IAsyncOperation[StoreProductQueryResult]: ...
    def get_store_queue_items_async(self, store_ids: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[StoreQueueItem]]: ...
    def get_user_collection_async(self, product_kinds: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncOperation[StoreProductQueryResult]: ...
    def get_user_collection_with_paging_async(self, product_kinds: typing.Iterable[str], max_items_to_retrieve_per_page: winsdk.system.UInt32) -> winsdk.windows.foundation.IAsyncOperation[StoreProductPagedQueryResult]: ...
    def report_consumable_fulfillment_async(self, product_store_id: str, quantity: winsdk.system.UInt32, tracking_id: winsdk.system.Guid) -> winsdk.windows.foundation.IAsyncOperation[StoreConsumableResult]: ...
    def request_download_and_install_store_package_updates_async(self, store_package_updates: typing.Iterable[StorePackageUpdate]) -> winsdk.windows.foundation.IAsyncOperationWithProgress[StorePackageUpdateResult, StorePackageUpdateStatus]: ...
    @typing.overload
    def request_download_and_install_store_packages_async(self, store_ids: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncOperationWithProgress[StorePackageUpdateResult, StorePackageUpdateStatus]: ...
    @typing.overload
    def request_download_and_install_store_packages_async(self, store_ids: typing.Iterable[str], store_package_install_options: typing.Optional[StorePackageInstallOptions]) -> winsdk.windows.foundation.IAsyncOperationWithProgress[StorePackageUpdateResult, StorePackageUpdateStatus]: ...
    def request_download_store_package_updates_async(self, store_package_updates: typing.Iterable[StorePackageUpdate]) -> winsdk.windows.foundation.IAsyncOperationWithProgress[StorePackageUpdateResult, StorePackageUpdateStatus]: ...
    @typing.overload
    def request_purchase_async(self, store_id: str) -> winsdk.windows.foundation.IAsyncOperation[StorePurchaseResult]: ...
    @typing.overload
    def request_purchase_async(self, store_id: str, store_purchase_properties: typing.Optional[StorePurchaseProperties]) -> winsdk.windows.foundation.IAsyncOperation[StorePurchaseResult]: ...
    def request_rate_and_review_app_async(self) -> winsdk.windows.foundation.IAsyncOperation[StoreRateAndReviewResult]: ...
    def request_uninstall_store_package_async(self, package: typing.Optional[winsdk.windows.applicationmodel.Package]) -> winsdk.windows.foundation.IAsyncOperation[StoreUninstallStorePackageResult]: ...
    def request_uninstall_store_package_by_store_id_async(self, store_id: str) -> winsdk.windows.foundation.IAsyncOperation[StoreUninstallStorePackageResult]: ...
    def set_install_order_for_associated_store_queue_items_async(self, items: typing.Iterable[StoreQueueItem]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[StoreQueueItem]]: ...
    def try_silent_download_and_install_store_package_updates_async(self, store_package_updates: typing.Iterable[StorePackageUpdate]) -> winsdk.windows.foundation.IAsyncOperationWithProgress[StorePackageUpdateResult, StorePackageUpdateStatus]: ...
    def try_silent_download_store_package_updates_async(self, store_package_updates: typing.Iterable[StorePackageUpdate]) -> winsdk.windows.foundation.IAsyncOperationWithProgress[StorePackageUpdateResult, StorePackageUpdateStatus]: ...
    def uninstall_store_package_async(self, package: typing.Optional[winsdk.windows.applicationmodel.Package]) -> winsdk.windows.foundation.IAsyncOperation[StoreUninstallStorePackageResult]: ...
    def uninstall_store_package_by_store_id_async(self, store_id: str) -> winsdk.windows.foundation.IAsyncOperation[StoreUninstallStorePackageResult]: ...
    def add_offline_licenses_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[StoreContext, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_offline_licenses_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class StoreImage(winsdk.system.Object):
    caption: str
    height: winsdk.system.UInt32
    image_purpose_tag: str
    uri: typing.Optional[winsdk.windows.foundation.Uri]
    width: winsdk.system.UInt32
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StoreImage: ...

class StoreLicense(winsdk.system.Object):
    expiration_date: datetime.datetime
    extended_json_data: str
    in_app_offer_token: str
    is_active: winsdk.system.Boolean
    sku_store_id: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StoreLicense: ...

class StorePackageInstallOptions(winsdk.system.Object):
    allow_forced_app_restart: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StorePackageInstallOptions: ...
    def __new__(cls: typing.Type[StorePackageInstallOptions]) -> StorePackageInstallOptions:...

class StorePackageLicense(winsdk.system.Object):
    is_valid: winsdk.system.Boolean
    package: typing.Optional[winsdk.windows.applicationmodel.Package]
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StorePackageLicense: ...
    def close(self) -> None: ...
    def release_license(self) -> None: ...
    def add_license_lost(self, handler: winsdk.windows.foundation.TypedEventHandler[StorePackageLicense, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_license_lost(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class StorePackageUpdate(winsdk.system.Object):
    mandatory: winsdk.system.Boolean
    package: typing.Optional[winsdk.windows.applicationmodel.Package]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StorePackageUpdate: ...

class StorePackageUpdateResult(winsdk.system.Object):
    overall_state: StorePackageUpdateState
    store_package_update_statuses: typing.Optional[winsdk.windows.foundation.collections.IVectorView[StorePackageUpdateStatus]]
    store_queue_items: typing.Optional[winsdk.windows.foundation.collections.IVectorView[StoreQueueItem]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StorePackageUpdateResult: ...

class StorePrice(winsdk.system.Object):
    currency_code: str
    formatted_base_price: str
    formatted_price: str
    formatted_recurrence_price: str
    is_on_sale: winsdk.system.Boolean
    sale_end_date: datetime.datetime
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StorePrice: ...

class StoreProduct(winsdk.system.Object):
    description: str
    extended_json_data: str
    has_digital_download: winsdk.system.Boolean
    images: typing.Optional[winsdk.windows.foundation.collections.IVectorView[StoreImage]]
    in_app_offer_token: str
    is_in_user_collection: winsdk.system.Boolean
    keywords: typing.Optional[winsdk.windows.foundation.collections.IVectorView[str]]
    language: str
    link_uri: typing.Optional[winsdk.windows.foundation.Uri]
    price: typing.Optional[StorePrice]
    product_kind: str
    skus: typing.Optional[winsdk.windows.foundation.collections.IVectorView[StoreSku]]
    store_id: str
    title: str
    videos: typing.Optional[winsdk.windows.foundation.collections.IVectorView[StoreVideo]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StoreProduct: ...
    def get_is_any_sku_installed_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    @typing.overload
    def request_purchase_async(self) -> winsdk.windows.foundation.IAsyncOperation[StorePurchaseResult]: ...
    @typing.overload
    def request_purchase_async(self, store_purchase_properties: typing.Optional[StorePurchaseProperties]) -> winsdk.windows.foundation.IAsyncOperation[StorePurchaseResult]: ...

class StoreProductOptions(winsdk.system.Object):
    action_filters: typing.Optional[winsdk.windows.foundation.collections.IVector[str]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StoreProductOptions: ...
    def __new__(cls: typing.Type[StoreProductOptions]) -> StoreProductOptions:...

class StoreProductPagedQueryResult(winsdk.system.Object):
    extended_error: winsdk.windows.foundation.HResult
    has_more_results: winsdk.system.Boolean
    products: typing.Optional[winsdk.windows.foundation.collections.IMapView[str, StoreProduct]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StoreProductPagedQueryResult: ...
    def get_next_async(self) -> winsdk.windows.foundation.IAsyncOperation[StoreProductPagedQueryResult]: ...

class StoreProductQueryResult(winsdk.system.Object):
    extended_error: winsdk.windows.foundation.HResult
    products: typing.Optional[winsdk.windows.foundation.collections.IMapView[str, StoreProduct]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StoreProductQueryResult: ...

class StoreProductResult(winsdk.system.Object):
    extended_error: winsdk.windows.foundation.HResult
    product: typing.Optional[StoreProduct]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StoreProductResult: ...

class StorePurchaseProperties(winsdk.system.Object):
    name: str
    extended_json_data: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StorePurchaseProperties: ...
    @typing.overload
    def __new__(cls: typing.Type[StorePurchaseProperties], name: str) -> StorePurchaseProperties:...
    @typing.overload
    def __new__(cls: typing.Type[StorePurchaseProperties]) -> StorePurchaseProperties:...

class StorePurchaseResult(winsdk.system.Object):
    extended_error: winsdk.windows.foundation.HResult
    status: StorePurchaseStatus
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StorePurchaseResult: ...

class StoreQueueItem(winsdk.system.Object):
    install_kind: StoreQueueItemKind
    package_family_name: str
    product_id: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StoreQueueItem: ...
    def cancel_install_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    def get_current_status(self) -> typing.Optional[StoreQueueItemStatus]: ...
    def pause_install_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    def resume_install_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    def add_completed(self, handler: winsdk.windows.foundation.TypedEventHandler[StoreQueueItem, StoreQueueItemCompletedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_completed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_status_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[StoreQueueItem, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_status_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class StoreQueueItemCompletedEventArgs(winsdk.system.Object):
    status: typing.Optional[StoreQueueItemStatus]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StoreQueueItemCompletedEventArgs: ...

class StoreQueueItemStatus(winsdk.system.Object):
    extended_error: winsdk.windows.foundation.HResult
    package_install_extended_state: StoreQueueItemExtendedState
    package_install_state: StoreQueueItemState
    update_status: StorePackageUpdateStatus
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StoreQueueItemStatus: ...

class StoreRateAndReviewResult(winsdk.system.Object):
    extended_error: winsdk.windows.foundation.HResult
    extended_json_data: str
    status: StoreRateAndReviewStatus
    was_updated: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StoreRateAndReviewResult: ...

class StoreRequestHelper(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StoreRequestHelper: ...
    @staticmethod
    def send_request_async(context: typing.Optional[StoreContext], request_kind: winsdk.system.UInt32, parameters_as_json: str) -> winsdk.windows.foundation.IAsyncOperation[StoreSendRequestResult]: ...

class StoreSendRequestResult(winsdk.system.Object):
    extended_error: winsdk.windows.foundation.HResult
    response: str
    http_status_code: winsdk.windows.web.http.HttpStatusCode
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StoreSendRequestResult: ...

class StoreSku(winsdk.system.Object):
    availabilities: typing.Optional[winsdk.windows.foundation.collections.IVectorView[StoreAvailability]]
    bundled_skus: typing.Optional[winsdk.windows.foundation.collections.IVectorView[str]]
    collection_data: typing.Optional[StoreCollectionData]
    custom_developer_data: str
    description: str
    extended_json_data: str
    images: typing.Optional[winsdk.windows.foundation.collections.IVectorView[StoreImage]]
    is_in_user_collection: winsdk.system.Boolean
    is_subscription: winsdk.system.Boolean
    is_trial: winsdk.system.Boolean
    language: str
    price: typing.Optional[StorePrice]
    store_id: str
    subscription_info: typing.Optional[StoreSubscriptionInfo]
    title: str
    videos: typing.Optional[winsdk.windows.foundation.collections.IVectorView[StoreVideo]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StoreSku: ...
    def get_is_installed_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    @typing.overload
    def request_purchase_async(self) -> winsdk.windows.foundation.IAsyncOperation[StorePurchaseResult]: ...
    @typing.overload
    def request_purchase_async(self, store_purchase_properties: typing.Optional[StorePurchaseProperties]) -> winsdk.windows.foundation.IAsyncOperation[StorePurchaseResult]: ...

class StoreSubscriptionInfo(winsdk.system.Object):
    billing_period: winsdk.system.UInt32
    billing_period_unit: StoreDurationUnit
    has_trial_period: winsdk.system.Boolean
    trial_period: winsdk.system.UInt32
    trial_period_unit: StoreDurationUnit
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StoreSubscriptionInfo: ...

class StoreUninstallStorePackageResult(winsdk.system.Object):
    extended_error: winsdk.windows.foundation.HResult
    status: StoreUninstallStorePackageStatus
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StoreUninstallStorePackageResult: ...

class StoreVideo(winsdk.system.Object):
    caption: str
    height: winsdk.system.UInt32
    preview_image: typing.Optional[StoreImage]
    uri: typing.Optional[winsdk.windows.foundation.Uri]
    video_purpose_tag: str
    width: winsdk.system.UInt32
    @staticmethod
    def _from(obj: winsdk.system.Object) -> StoreVideo: ...

