# WARNING: Please don't edit this file. It was generated by Python/WinRT v1.0.0-beta.8

import enum
import datetime
import sys
import types
import typing

import winsdk.system
import winsdk.windows.foundation
import winsdk.windows.foundation.collections
import winsdk.windows.security.cryptography.core
import winsdk.windows.storage.streams
import winsdk.windows.system

class KeyCredentialAttestationStatus(enum.IntEnum):
    SUCCESS = 0
    UNKNOWN_ERROR = 1
    NOT_SUPPORTED = 2
    TEMPORARY_FAILURE = 3

class KeyCredentialCreationOption(enum.IntEnum):
    REPLACE_EXISTING = 0
    FAIL_IF_EXISTS = 1

class KeyCredentialStatus(enum.IntEnum):
    SUCCESS = 0
    UNKNOWN_ERROR = 1
    NOT_FOUND = 2
    USER_CANCELED = 3
    USER_PREFERS_PASSWORD = 4
    CREDENTIAL_ALREADY_EXISTS = 5
    SECURITY_DEVICE_LOCKED = 6

class WebAccountPictureSize(enum.IntEnum):
    SIZE64X64 = 64
    SIZE208X208 = 208
    SIZE424X424 = 424
    SIZE1080X1080 = 1080

class WebAccountState(enum.IntEnum):
    NONE = 0
    CONNECTED = 1
    ERROR = 2

Self = typing.TypeVar('Self')

class KeyCredential(winsdk.system.Object):
    name: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> KeyCredential: ...
    def get_attestation_async(self) -> winsdk.windows.foundation.IAsyncOperation[KeyCredentialAttestationResult]: ...
    def request_sign_async(self, data: typing.Optional[winsdk.windows.storage.streams.IBuffer]) -> winsdk.windows.foundation.IAsyncOperation[KeyCredentialOperationResult]: ...
    @typing.overload
    def retrieve_public_key(self) -> typing.Optional[winsdk.windows.storage.streams.IBuffer]: ...
    @typing.overload
    def retrieve_public_key(self, blob_type: winsdk.windows.security.cryptography.core.CryptographicPublicKeyBlobType) -> typing.Optional[winsdk.windows.storage.streams.IBuffer]: ...

class KeyCredentialAttestationResult(winsdk.system.Object):
    attestation_buffer: typing.Optional[winsdk.windows.storage.streams.IBuffer]
    certificate_chain_buffer: typing.Optional[winsdk.windows.storage.streams.IBuffer]
    status: KeyCredentialAttestationStatus
    @staticmethod
    def _from(obj: winsdk.system.Object) -> KeyCredentialAttestationResult: ...

class KeyCredentialManager(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> KeyCredentialManager: ...
    @staticmethod
    def delete_async(name: str) -> winsdk.windows.foundation.IAsyncAction: ...
    @staticmethod
    def is_supported_async() -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    @staticmethod
    def open_async(name: str) -> winsdk.windows.foundation.IAsyncOperation[KeyCredentialRetrievalResult]: ...
    @staticmethod
    def renew_attestation_async() -> winsdk.windows.foundation.IAsyncAction: ...
    @staticmethod
    def request_create_async(name: str, option: KeyCredentialCreationOption) -> winsdk.windows.foundation.IAsyncOperation[KeyCredentialRetrievalResult]: ...

class KeyCredentialOperationResult(winsdk.system.Object):
    result: typing.Optional[winsdk.windows.storage.streams.IBuffer]
    status: KeyCredentialStatus
    @staticmethod
    def _from(obj: winsdk.system.Object) -> KeyCredentialOperationResult: ...

class KeyCredentialRetrievalResult(winsdk.system.Object):
    credential: typing.Optional[KeyCredential]
    status: KeyCredentialStatus
    @staticmethod
    def _from(obj: winsdk.system.Object) -> KeyCredentialRetrievalResult: ...

class PasswordCredential(winsdk.system.Object):
    user_name: str
    resource: str
    password: str
    properties: typing.Optional[winsdk.windows.foundation.collections.IPropertySet]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> PasswordCredential: ...
    @typing.overload
    def __new__(cls: typing.Type[PasswordCredential], resource: str, user_name: str, password: str) -> PasswordCredential:...
    @typing.overload
    def __new__(cls: typing.Type[PasswordCredential]) -> PasswordCredential:...
    def retrieve_password(self) -> None: ...

class PasswordCredentialPropertyStore(winsdk.system.Object, typing.MutableMapping[str, winsdk.system.Object]):
    size: winsdk.system.UInt32
    def __len__(self) -> int: ...
    def __iter__(self) -> typing.Iterator[str]: ...
    def __contains__(self, key: object) -> bool:...
    def __setitem__(self, key: str, value: winsdk.system.Object) -> None: ...
    def __getitem__(self, key: str) -> winsdk.system.Object: ...
    def __delitem__(self, key: str) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> PasswordCredentialPropertyStore: ...
    def __new__(cls: typing.Type[PasswordCredentialPropertyStore]) -> PasswordCredentialPropertyStore:...
    def clear(self) -> None: ...
    def first(self) -> typing.Optional[winsdk.windows.foundation.collections.IIterator[winsdk.windows.foundation.collections.IKeyValuePair[str, winsdk.system.Object]]]: ...
    def get_view(self) -> typing.Optional[winsdk.windows.foundation.collections.IMapView[str, winsdk.system.Object]]: ...
    def has_key(self, key: str) -> winsdk.system.Boolean: ...
    def insert(self, key: str, value: typing.Optional[winsdk.system.Object]) -> winsdk.system.Boolean: ...
    def lookup(self, key: str) -> typing.Optional[winsdk.system.Object]: ...
    def remove(self, key: str) -> None: ...
    def add_map_changed(self, vhnd: winsdk.windows.foundation.collections.MapChangedEventHandler[str, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_map_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class PasswordVault(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> PasswordVault: ...
    def __new__(cls: typing.Type[PasswordVault]) -> PasswordVault:...
    def add(self, credential: typing.Optional[PasswordCredential]) -> None: ...
    def find_all_by_resource(self, resource: str) -> typing.Optional[winsdk.windows.foundation.collections.IVectorView[PasswordCredential]]: ...
    def find_all_by_user_name(self, user_name: str) -> typing.Optional[winsdk.windows.foundation.collections.IVectorView[PasswordCredential]]: ...
    def remove(self, credential: typing.Optional[PasswordCredential]) -> None: ...
    def retrieve(self, resource: str, user_name: str) -> typing.Optional[PasswordCredential]: ...
    def retrieve_all(self) -> typing.Optional[winsdk.windows.foundation.collections.IVectorView[PasswordCredential]]: ...

class WebAccount(winsdk.system.Object):
    state: WebAccountState
    user_name: str
    web_account_provider: typing.Optional[WebAccountProvider]
    id: str
    properties: typing.Optional[winsdk.windows.foundation.collections.IMapView[str, str]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> WebAccount: ...
    def __new__(cls: typing.Type[WebAccount], web_account_provider: typing.Optional[WebAccountProvider], user_name: str, state: WebAccountState) -> WebAccount:...
    def get_picture_async(self, desized_size: WebAccountPictureSize) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IRandomAccessStream]: ...
    @typing.overload
    def sign_out_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def sign_out_async(self, client_id: str) -> winsdk.windows.foundation.IAsyncAction: ...

class WebAccountProvider(winsdk.system.Object):
    display_name: str
    icon_uri: typing.Optional[winsdk.windows.foundation.Uri]
    id: str
    authority: str
    display_purpose: str
    user: typing.Optional[winsdk.windows.system.User]
    is_system_provider: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> WebAccountProvider: ...
    def __new__(cls: typing.Type[WebAccountProvider], id: str, display_name: str, icon_uri: typing.Optional[winsdk.windows.foundation.Uri]) -> WebAccountProvider:...

class IWebAccount(winsdk.system.Object):
    state: WebAccountState
    user_name: str
    web_account_provider: typing.Optional[WebAccountProvider]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> IWebAccount: ...

