# WARNING: Please don't edit this file. It was generated by Python/WinRT v1.0.0-beta.8

import enum
import datetime
import sys
import types
import typing

import winsdk.system
import winsdk.windows.data.xml.dom
import winsdk.windows.devices.sms
import winsdk.windows.foundation
import winsdk.windows.foundation.collections
import winsdk.windows.networking
import winsdk.windows.networking.connectivity
import winsdk.windows.storage.streams

class DataClasses(enum.IntFlag):
    NONE = 0
    GPRS = 0x1
    EDGE = 0x2
    UMTS = 0x4
    HSDPA = 0x8
    HSUPA = 0x10
    LTE_ADVANCED = 0x20
    NEW_RADIO_NON_STANDALONE = 0x40
    NEW_RADIO_STANDALONE = 0x80
    CDMA1X_RTT = 0x10000
    CDMA1X_EVDO = 0x20000
    CDMA1X_EVDO_REV_A = 0x40000
    CDMA1X_EVDV = 0x80000
    CDMA3X_RTT = 0x100000
    CDMA1X_EVDO_REV_B = 0x200000
    CDMA_UMB = 0x400000
    CUSTOM = 0x80000000

class ESimAuthenticationPreference(enum.IntEnum):
    ON_ENTRY = 0
    ON_ACTION = 1
    NEVER = 2

class ESimDiscoverResultKind(enum.IntEnum):
    NONE = 0
    EVENTS = 1
    PROFILE_METADATA = 2

class ESimOperationStatus(enum.IntEnum):
    SUCCESS = 0
    NOT_AUTHORIZED = 1
    NOT_FOUND = 2
    POLICY_VIOLATION = 3
    INSUFFICIENT_SPACE_ON_CARD = 4
    SERVER_FAILURE = 5
    SERVER_NOT_REACHABLE = 6
    TIMEOUT_WAITING_FOR_USER_CONSENT = 7
    INCORRECT_CONFIRMATION_CODE = 8
    CONFIRMATION_CODE_MAX_RETRIES_EXCEEDED = 9
    CARD_REMOVED = 10
    CARD_BUSY = 11
    OTHER = 12
    CARD_GENERAL_FAILURE = 13
    CONFIRMATION_CODE_MISSING = 14
    INVALID_MATCHING_ID = 15
    NO_ELIGIBLE_PROFILE_FOR_THIS_DEVICE = 16
    OPERATION_ABORTED = 17
    EID_MISMATCH = 18
    PROFILE_NOT_AVAILABLE_FOR_NEW_BINDING = 19
    PROFILE_NOT_RELEASED_BY_OPERATOR = 20
    OPERATION_PROHIBITED_BY_PROFILE_CLASS = 21
    PROFILE_NOT_PRESENT = 22
    NO_CORRESPONDING_REQUEST = 23
    TIMEOUT_WAITING_FOR_RESPONSE = 24
    ICCID_ALREADY_EXISTS = 25
    PROFILE_PROCESSING_ERROR = 26
    SERVER_NOT_TRUSTED = 27
    PROFILE_DOWNLOAD_MAX_RETRIES_EXCEEDED = 28

class ESimProfileClass(enum.IntEnum):
    OPERATIONAL = 0
    TEST = 1
    PROVISIONING = 2

class ESimProfileMetadataState(enum.IntEnum):
    UNKNOWN = 0
    WAITING_FOR_INSTALL = 1
    DOWNLOADING = 2
    INSTALLING = 3
    EXPIRED = 4
    REJECTING_DOWNLOAD = 5
    NO_LONGER_AVAILABLE = 6
    DENIED_BY_POLICY = 7

class ESimProfileState(enum.IntEnum):
    UNKNOWN = 0
    DISABLED = 1
    ENABLED = 2
    DELETED = 3

class ESimState(enum.IntEnum):
    UNKNOWN = 0
    IDLE = 1
    REMOVED = 2
    BUSY = 3

class ESimWatcherStatus(enum.IntEnum):
    CREATED = 0
    STARTED = 1
    ENUMERATION_COMPLETED = 2
    STOPPING = 3
    STOPPED = 4

class HotspotAuthenticationResponseCode(enum.IntEnum):
    NO_ERROR = 0
    LOGIN_SUCCEEDED = 50
    LOGIN_FAILED = 100
    RADIUS_SERVER_ERROR = 102
    NETWORK_ADMINISTRATOR_ERROR = 105
    LOGIN_ABORTED = 151
    ACCESS_GATEWAY_INTERNAL_ERROR = 255

class MobileBroadbandAccountWatcherStatus(enum.IntEnum):
    CREATED = 0
    STARTED = 1
    ENUMERATION_COMPLETED = 2
    STOPPED = 3
    ABORTED = 4

class MobileBroadbandDeviceType(enum.IntEnum):
    UNKNOWN = 0
    EMBEDDED = 1
    REMOVABLE = 2
    REMOTE = 3

class MobileBroadbandModemStatus(enum.IntEnum):
    SUCCESS = 0
    OTHER_FAILURE = 1
    BUSY = 2
    NO_DEVICE_SUPPORT = 3

class MobileBroadbandPinFormat(enum.IntEnum):
    UNKNOWN = 0
    NUMERIC = 1
    ALPHANUMERIC = 2

class MobileBroadbandPinLockState(enum.IntEnum):
    UNKNOWN = 0
    UNLOCKED = 1
    PIN_REQUIRED = 2
    PIN_UNBLOCK_KEY_REQUIRED = 3

class MobileBroadbandPinType(enum.IntEnum):
    NONE = 0
    CUSTOM = 1
    PIN1 = 2
    PIN2 = 3
    SIM_PIN = 4
    FIRST_SIM_PIN = 5
    NETWORK_PIN = 6
    NETWORK_SUBSET_PIN = 7
    SERVICE_PROVIDER_PIN = 8
    CORPORATE_PIN = 9
    SUBSIDY_LOCK = 10

class MobileBroadbandRadioState(enum.IntEnum):
    OFF = 0
    ON = 1

class MobileBroadbandSlotState(enum.IntEnum):
    UNMANAGED = 0
    UNKNOWN = 1
    OFF_EMPTY = 2
    OFF = 3
    EMPTY = 4
    NOT_READY = 5
    ACTIVE = 6
    ERROR = 7
    ACTIVE_ESIM = 8
    ACTIVE_ESIM_NO_PROFILE = 9

class MobileBroadbandUiccAppOperationStatus(enum.IntEnum):
    SUCCESS = 0
    INVALID_UICC_FILE_PATH = 1
    ACCESS_CONDITION_NOT_HELD = 2
    UICC_BUSY = 3

class NetworkDeviceStatus(enum.IntEnum):
    DEVICE_NOT_READY = 0
    DEVICE_READY = 1
    SIM_NOT_INSERTED = 2
    BAD_SIM = 3
    DEVICE_HARDWARE_FAILURE = 4
    ACCOUNT_NOT_ACTIVATED = 5
    DEVICE_LOCKED = 6
    DEVICE_BLOCKED = 7

class NetworkOperatorDataUsageNotificationKind(enum.IntEnum):
    DATA_USAGE_PROGRESS = 0

class NetworkOperatorEventMessageType(enum.IntEnum):
    GSM = 0
    CDMA = 1
    USSD = 2
    DATA_PLAN_THRESHOLD_REACHED = 3
    DATA_PLAN_RESET = 4
    DATA_PLAN_DELETED = 5
    PROFILE_CONNECTED = 6
    PROFILE_DISCONNECTED = 7
    REGISTERED_ROAMING = 8
    REGISTERED_HOME = 9
    TETHERING_ENTITLEMENT_CHECK = 10
    TETHERING_OPERATIONAL_STATE_CHANGED = 11
    TETHERING_NUMBER_OF_CLIENTS_CHANGED = 12

class NetworkRegistrationState(enum.IntEnum):
    NONE = 0
    DEREGISTERED = 1
    SEARCHING = 2
    HOME = 3
    ROAMING = 4
    PARTNER = 5
    DENIED = 6

class ProfileMediaType(enum.IntEnum):
    WLAN = 0
    WWAN = 1

class TetheringCapability(enum.IntEnum):
    ENABLED = 0
    DISABLED_BY_GROUP_POLICY = 1
    DISABLED_BY_HARDWARE_LIMITATION = 2
    DISABLED_BY_OPERATOR = 3
    DISABLED_BY_SKU = 4
    DISABLED_BY_REQUIRED_APP_NOT_INSTALLED = 5
    DISABLED_DUE_TO_UNKNOWN_CAUSE = 6
    DISABLED_BY_SYSTEM_CAPABILITY = 7

class TetheringOperationStatus(enum.IntEnum):
    SUCCESS = 0
    UNKNOWN = 1
    MOBILE_BROADBAND_DEVICE_OFF = 2
    WI_FI_DEVICE_OFF = 3
    ENTITLEMENT_CHECK_TIMEOUT = 4
    ENTITLEMENT_CHECK_FAILURE = 5
    OPERATION_IN_PROGRESS = 6
    BLUETOOTH_DEVICE_OFF = 7
    NETWORK_LIMITED_CONNECTIVITY = 8

class TetheringOperationalState(enum.IntEnum):
    UNKNOWN = 0
    ON = 1
    OFF = 2
    IN_TRANSITION = 3

class TetheringWiFiBand(enum.IntEnum):
    AUTO = 0
    TWO_POINT_FOUR_GIGAHERTZ = 1
    FIVE_GIGAHERTZ = 2

class UiccAccessCondition(enum.IntEnum):
    ALWAYS_ALLOWED = 0
    PIN1 = 1
    PIN2 = 2
    PIN3 = 3
    PIN4 = 4
    ADMINISTRATIVE5 = 5
    ADMINISTRATIVE6 = 6
    NEVER_ALLOWED = 7

class UiccAppKind(enum.IntEnum):
    UNKNOWN = 0
    M_F = 1
    M_F_SIM = 2
    M_F_RUIM = 3
    U_SIM = 4
    C_SIM = 5
    I_SIM = 6

class UiccAppRecordKind(enum.IntEnum):
    UNKNOWN = 0
    TRANSPARENT = 1
    RECORD_ORIENTED = 2

class UssdResultCode(enum.IntEnum):
    NO_ACTION_REQUIRED = 0
    ACTION_REQUIRED = 1
    TERMINATED = 2
    OTHER_LOCAL_CLIENT = 3
    OPERATION_NOT_SUPPORTED = 4
    NETWORK_TIMEOUT = 5

Self = typing.TypeVar('Self')

class ESimProfileInstallProgress:
    total_size_in_bytes: winsdk.system.Int32
    installed_size_in_bytes: winsdk.system.Int32
    def __new__(cls: typing.Type[ESimProfileInstallProgress], total_size_in_bytes: winsdk.system.Int32, installed_size_in_bytes: winsdk.system.Int32) -> ESimProfileInstallProgress: ...

class ProfileUsage:
    usage_in_megabytes: winsdk.system.UInt32
    last_sync_time: datetime.datetime
    def __new__(cls: typing.Type[ProfileUsage], usage_in_megabytes: winsdk.system.UInt32, last_sync_time: datetime.datetime) -> ProfileUsage: ...

class ESim(winsdk.system.Object):
    available_memory_in_bytes: typing.Optional[typing.Optional[winsdk.system.Int32]]
    eid: str
    firmware_version: str
    mobile_broadband_modem_device_id: str
    policy: typing.Optional[ESimPolicy]
    state: ESimState
    slot_index: typing.Optional[typing.Optional[winsdk.system.Int32]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ESim: ...
    def delete_profile_async(self, profile_id: str) -> winsdk.windows.foundation.IAsyncOperation[ESimOperationResult]: ...
    @typing.overload
    def discover(self) -> typing.Optional[ESimDiscoverResult]: ...
    @typing.overload
    def discover(self, server_address: str, matching_id: str) -> typing.Optional[ESimDiscoverResult]: ...
    @typing.overload
    def discover_async(self) -> winsdk.windows.foundation.IAsyncOperation[ESimDiscoverResult]: ...
    @typing.overload
    def discover_async(self, server_address: str, matching_id: str) -> winsdk.windows.foundation.IAsyncOperation[ESimDiscoverResult]: ...
    def download_profile_metadata_async(self, activation_code: str) -> winsdk.windows.foundation.IAsyncOperation[ESimDownloadProfileMetadataResult]: ...
    def get_profiles(self) -> typing.Optional[winsdk.windows.foundation.collections.IVectorView[ESimProfile]]: ...
    def reset_async(self) -> winsdk.windows.foundation.IAsyncOperation[ESimOperationResult]: ...
    def add_profile_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[ESim, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_profile_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class ESimAddedEventArgs(winsdk.system.Object):
    e_sim: typing.Optional[ESim]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ESimAddedEventArgs: ...

class ESimDiscoverEvent(winsdk.system.Object):
    matching_id: str
    rsp_server_address: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ESimDiscoverEvent: ...

class ESimDiscoverResult(winsdk.system.Object):
    events: typing.Optional[winsdk.windows.foundation.collections.IVectorView[ESimDiscoverEvent]]
    kind: ESimDiscoverResultKind
    profile_metadata: typing.Optional[ESimProfileMetadata]
    result: typing.Optional[ESimOperationResult]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ESimDiscoverResult: ...

class ESimDownloadProfileMetadataResult(winsdk.system.Object):
    profile_metadata: typing.Optional[ESimProfileMetadata]
    result: typing.Optional[ESimOperationResult]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ESimDownloadProfileMetadataResult: ...

class ESimManager(winsdk.system.Object):
    service_info: typing.ClassVar[typing.Optional[ESimServiceInfo]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ESimManager: ...
    @staticmethod
    def try_create_e_sim_watcher() -> typing.Optional[ESimWatcher]: ...
    @staticmethod
    def add_service_info_changed(handler: winsdk.windows.foundation.EventHandler[winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @staticmethod
    def remove_service_info_changed(token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class ESimOperationResult(winsdk.system.Object):
    status: ESimOperationStatus
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ESimOperationResult: ...

class ESimPolicy(winsdk.system.Object):
    should_enable_managing_ui: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ESimPolicy: ...

class ESimProfile(winsdk.system.Object):
    class_: ESimProfileClass
    id: str
    nickname: str
    policy: typing.Optional[ESimProfilePolicy]
    provider_icon: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStreamReference]
    provider_id: str
    provider_name: str
    state: ESimProfileState
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ESimProfile: ...
    def disable_async(self) -> winsdk.windows.foundation.IAsyncOperation[ESimOperationResult]: ...
    def enable_async(self) -> winsdk.windows.foundation.IAsyncOperation[ESimOperationResult]: ...
    def set_nickname_async(self, new_nickname: str) -> winsdk.windows.foundation.IAsyncOperation[ESimOperationResult]: ...

class ESimProfileMetadata(winsdk.system.Object):
    id: str
    is_confirmation_code_required: winsdk.system.Boolean
    policy: typing.Optional[ESimProfilePolicy]
    provider_icon: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStreamReference]
    provider_id: str
    provider_name: str
    state: ESimProfileMetadataState
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ESimProfileMetadata: ...
    @typing.overload
    def confirm_install_async(self) -> winsdk.windows.foundation.IAsyncOperationWithProgress[ESimOperationResult, ESimProfileInstallProgress]: ...
    @typing.overload
    def confirm_install_async(self, confirmation_code: str) -> winsdk.windows.foundation.IAsyncOperationWithProgress[ESimOperationResult, ESimProfileInstallProgress]: ...
    def deny_install_async(self) -> winsdk.windows.foundation.IAsyncOperation[ESimOperationResult]: ...
    def postpone_install_async(self) -> winsdk.windows.foundation.IAsyncOperation[ESimOperationResult]: ...
    def add_state_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[ESimProfileMetadata, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_state_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class ESimProfilePolicy(winsdk.system.Object):
    can_delete: winsdk.system.Boolean
    can_disable: winsdk.system.Boolean
    is_managed_by_enterprise: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ESimProfilePolicy: ...

class ESimRemovedEventArgs(winsdk.system.Object):
    e_sim: typing.Optional[ESim]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ESimRemovedEventArgs: ...

class ESimServiceInfo(winsdk.system.Object):
    authentication_preference: ESimAuthenticationPreference
    is_e_sim_ui_enabled: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ESimServiceInfo: ...

class ESimUpdatedEventArgs(winsdk.system.Object):
    e_sim: typing.Optional[ESim]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ESimUpdatedEventArgs: ...

class ESimWatcher(winsdk.system.Object):
    status: ESimWatcherStatus
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ESimWatcher: ...
    def start(self) -> None: ...
    def stop(self) -> None: ...
    def add_added(self, handler: winsdk.windows.foundation.TypedEventHandler[ESimWatcher, ESimAddedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_added(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_enumeration_completed(self, handler: winsdk.windows.foundation.TypedEventHandler[ESimWatcher, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_enumeration_completed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_removed(self, handler: winsdk.windows.foundation.TypedEventHandler[ESimWatcher, ESimRemovedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_removed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_stopped(self, handler: winsdk.windows.foundation.TypedEventHandler[ESimWatcher, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_stopped(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_updated(self, handler: winsdk.windows.foundation.TypedEventHandler[ESimWatcher, ESimUpdatedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_updated(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class FdnAccessManager(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> FdnAccessManager: ...
    @staticmethod
    def request_unlock_async(contact_list_id: str) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...

class HotspotAuthenticationContext(winsdk.system.Object):
    authentication_url: typing.Optional[winsdk.windows.foundation.Uri]
    network_adapter: typing.Optional[winsdk.windows.networking.connectivity.NetworkAdapter]
    redirect_message_url: typing.Optional[winsdk.windows.foundation.Uri]
    redirect_message_xml: typing.Optional[winsdk.windows.data.xml.dom.XmlDocument]
    wireless_network_id: winsdk.system.UInt8
    @staticmethod
    def _from(obj: winsdk.system.Object) -> HotspotAuthenticationContext: ...
    def abort_authentication(self, mark_as_manual: winsdk.system.Boolean) -> None: ...
    def issue_credentials(self, user_name: str, password: str, extra_parameters: str, mark_as_manual_connect_on_failure: winsdk.system.Boolean) -> None: ...
    def issue_credentials_async(self, user_name: str, password: str, extra_parameters: str, mark_as_manual_connect_on_failure: winsdk.system.Boolean) -> winsdk.windows.foundation.IAsyncOperation[HotspotCredentialsAuthenticationResult]: ...
    def skip_authentication(self) -> None: ...
    def trigger_attention_required(self, package_relative_application_id: str, application_parameters: str) -> None: ...
    @staticmethod
    def try_get_authentication_context(even_token: str) -> typing.Tuple[winsdk.system.Boolean, typing.Optional[HotspotAuthenticationContext]]: ...

class HotspotAuthenticationEventDetails(winsdk.system.Object):
    event_token: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> HotspotAuthenticationEventDetails: ...

class HotspotCredentialsAuthenticationResult(winsdk.system.Object):
    authentication_reply_xml: typing.Optional[winsdk.windows.data.xml.dom.XmlDocument]
    has_network_error_occurred: winsdk.system.Boolean
    logoff_url: typing.Optional[winsdk.windows.foundation.Uri]
    response_code: HotspotAuthenticationResponseCode
    @staticmethod
    def _from(obj: winsdk.system.Object) -> HotspotCredentialsAuthenticationResult: ...

class KnownCSimFilePaths(winsdk.system.Object):
    e_f_spn: typing.ClassVar[typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.system.UInt32]]]
    gid1: typing.ClassVar[typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.system.UInt32]]]
    gid2: typing.ClassVar[typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.system.UInt32]]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> KnownCSimFilePaths: ...

class KnownRuimFilePaths(winsdk.system.Object):
    e_f_spn: typing.ClassVar[typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.system.UInt32]]]
    gid1: typing.ClassVar[typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.system.UInt32]]]
    gid2: typing.ClassVar[typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.system.UInt32]]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> KnownRuimFilePaths: ...

class KnownSimFilePaths(winsdk.system.Object):
    e_f_ons: typing.ClassVar[typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.system.UInt32]]]
    e_f_spn: typing.ClassVar[typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.system.UInt32]]]
    gid1: typing.ClassVar[typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.system.UInt32]]]
    gid2: typing.ClassVar[typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.system.UInt32]]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> KnownSimFilePaths: ...

class KnownUSimFilePaths(winsdk.system.Object):
    e_f_opl: typing.ClassVar[typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.system.UInt32]]]
    e_f_pnn: typing.ClassVar[typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.system.UInt32]]]
    e_f_spn: typing.ClassVar[typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.system.UInt32]]]
    gid1: typing.ClassVar[typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.system.UInt32]]]
    gid2: typing.ClassVar[typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.system.UInt32]]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> KnownUSimFilePaths: ...

class MobileBroadbandAccount(winsdk.system.Object):
    current_device_information: typing.Optional[MobileBroadbandDeviceInformation]
    current_network: typing.Optional[MobileBroadbandNetwork]
    network_account_id: str
    service_provider_guid: winsdk.system.Guid
    service_provider_name: str
    account_experience_url: typing.Optional[winsdk.windows.foundation.Uri]
    available_network_account_ids: typing.ClassVar[typing.Optional[winsdk.windows.foundation.collections.IVectorView[str]]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandAccount: ...
    @staticmethod
    def create_from_network_account_id(network_account_id: str) -> typing.Optional[MobileBroadbandAccount]: ...
    def get_connection_profiles(self) -> typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.windows.networking.connectivity.ConnectionProfile]]: ...

class MobileBroadbandAccountEventArgs(winsdk.system.Object):
    network_account_id: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandAccountEventArgs: ...

class MobileBroadbandAccountUpdatedEventArgs(winsdk.system.Object):
    has_device_information_changed: winsdk.system.Boolean
    has_network_changed: winsdk.system.Boolean
    network_account_id: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandAccountUpdatedEventArgs: ...

class MobileBroadbandAccountWatcher(winsdk.system.Object):
    status: MobileBroadbandAccountWatcherStatus
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandAccountWatcher: ...
    def __new__(cls: typing.Type[MobileBroadbandAccountWatcher]) -> MobileBroadbandAccountWatcher:...
    def start(self) -> None: ...
    def stop(self) -> None: ...
    def add_account_added(self, handler: winsdk.windows.foundation.TypedEventHandler[MobileBroadbandAccountWatcher, MobileBroadbandAccountEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_account_added(self, cookie: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_account_removed(self, handler: winsdk.windows.foundation.TypedEventHandler[MobileBroadbandAccountWatcher, MobileBroadbandAccountEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_account_removed(self, cookie: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_account_updated(self, handler: winsdk.windows.foundation.TypedEventHandler[MobileBroadbandAccountWatcher, MobileBroadbandAccountUpdatedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_account_updated(self, cookie: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_enumeration_completed(self, handler: winsdk.windows.foundation.TypedEventHandler[MobileBroadbandAccountWatcher, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_enumeration_completed(self, cookie: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_stopped(self, handler: winsdk.windows.foundation.TypedEventHandler[MobileBroadbandAccountWatcher, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_stopped(self, cookie: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class MobileBroadbandAntennaSar(winsdk.system.Object):
    antenna_index: winsdk.system.Int32
    sar_backoff_index: winsdk.system.Int32
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandAntennaSar: ...
    def __new__(cls: typing.Type[MobileBroadbandAntennaSar], antenna_index: winsdk.system.Int32, sar_backoff_index: winsdk.system.Int32) -> MobileBroadbandAntennaSar:...

class MobileBroadbandCellCdma(winsdk.system.Object):
    base_station_id: typing.Optional[typing.Optional[winsdk.system.Int32]]
    base_station_last_broadcast_gps_time: typing.Optional[typing.Optional[datetime.timedelta]]
    base_station_latitude: typing.Optional[typing.Optional[winsdk.system.Double]]
    base_station_longitude: typing.Optional[typing.Optional[winsdk.system.Double]]
    base_station_p_n_code: typing.Optional[typing.Optional[winsdk.system.Int32]]
    network_id: typing.Optional[typing.Optional[winsdk.system.Int32]]
    pilot_signal_strength_in_d_b: typing.Optional[typing.Optional[winsdk.system.Double]]
    system_id: typing.Optional[typing.Optional[winsdk.system.Int32]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandCellCdma: ...

class MobileBroadbandCellGsm(winsdk.system.Object):
    base_station_id: typing.Optional[typing.Optional[winsdk.system.Int32]]
    cell_id: typing.Optional[typing.Optional[winsdk.system.Int32]]
    channel_number: typing.Optional[typing.Optional[winsdk.system.Int32]]
    location_area_code: typing.Optional[typing.Optional[winsdk.system.Int32]]
    provider_id: str
    received_signal_strength_in_d_bm: typing.Optional[typing.Optional[winsdk.system.Double]]
    timing_advance_in_bit_periods: typing.Optional[typing.Optional[winsdk.system.Int32]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandCellGsm: ...

class MobileBroadbandCellLte(winsdk.system.Object):
    cell_id: typing.Optional[typing.Optional[winsdk.system.Int32]]
    channel_number: typing.Optional[typing.Optional[winsdk.system.Int32]]
    physical_cell_id: typing.Optional[typing.Optional[winsdk.system.Int32]]
    provider_id: str
    reference_signal_received_power_in_d_bm: typing.Optional[typing.Optional[winsdk.system.Double]]
    reference_signal_received_quality_in_d_bm: typing.Optional[typing.Optional[winsdk.system.Double]]
    timing_advance_in_bit_periods: typing.Optional[typing.Optional[winsdk.system.Int32]]
    tracking_area_code: typing.Optional[typing.Optional[winsdk.system.Int32]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandCellLte: ...

class MobileBroadbandCellNR(winsdk.system.Object):
    cell_id: typing.Optional[typing.Optional[winsdk.system.Int64]]
    channel_number: typing.Optional[typing.Optional[winsdk.system.Int32]]
    physical_cell_id: typing.Optional[typing.Optional[winsdk.system.Int32]]
    provider_id: str
    reference_signal_received_power_in_d_bm: typing.Optional[typing.Optional[winsdk.system.Double]]
    reference_signal_received_quality_in_d_bm: typing.Optional[typing.Optional[winsdk.system.Double]]
    signal_to_noise_ratio_in_d_b: typing.Optional[typing.Optional[winsdk.system.Double]]
    timing_advance_in_nanoseconds: typing.Optional[typing.Optional[winsdk.system.Int32]]
    tracking_area_code: typing.Optional[typing.Optional[winsdk.system.Int32]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandCellNR: ...

class MobileBroadbandCellTdscdma(winsdk.system.Object):
    cell_id: typing.Optional[typing.Optional[winsdk.system.Int32]]
    cell_parameter_id: typing.Optional[typing.Optional[winsdk.system.Int32]]
    channel_number: typing.Optional[typing.Optional[winsdk.system.Int32]]
    location_area_code: typing.Optional[typing.Optional[winsdk.system.Int32]]
    path_loss_in_d_b: typing.Optional[typing.Optional[winsdk.system.Double]]
    provider_id: str
    received_signal_code_power_in_d_bm: typing.Optional[typing.Optional[winsdk.system.Double]]
    timing_advance_in_bit_periods: typing.Optional[typing.Optional[winsdk.system.Int32]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandCellTdscdma: ...

class MobileBroadbandCellUmts(winsdk.system.Object):
    cell_id: typing.Optional[typing.Optional[winsdk.system.Int32]]
    channel_number: typing.Optional[typing.Optional[winsdk.system.Int32]]
    location_area_code: typing.Optional[typing.Optional[winsdk.system.Int32]]
    path_loss_in_d_b: typing.Optional[typing.Optional[winsdk.system.Double]]
    primary_scrambling_code: typing.Optional[typing.Optional[winsdk.system.Int32]]
    provider_id: str
    received_signal_code_power_in_d_bm: typing.Optional[typing.Optional[winsdk.system.Double]]
    signal_to_noise_ratio_in_d_b: typing.Optional[typing.Optional[winsdk.system.Double]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandCellUmts: ...

class MobileBroadbandCellsInfo(winsdk.system.Object):
    neighboring_cells_cdma: typing.Optional[winsdk.windows.foundation.collections.IVectorView[MobileBroadbandCellCdma]]
    neighboring_cells_gsm: typing.Optional[winsdk.windows.foundation.collections.IVectorView[MobileBroadbandCellGsm]]
    neighboring_cells_lte: typing.Optional[winsdk.windows.foundation.collections.IVectorView[MobileBroadbandCellLte]]
    neighboring_cells_tdscdma: typing.Optional[winsdk.windows.foundation.collections.IVectorView[MobileBroadbandCellTdscdma]]
    neighboring_cells_umts: typing.Optional[winsdk.windows.foundation.collections.IVectorView[MobileBroadbandCellUmts]]
    serving_cells_cdma: typing.Optional[winsdk.windows.foundation.collections.IVectorView[MobileBroadbandCellCdma]]
    serving_cells_gsm: typing.Optional[winsdk.windows.foundation.collections.IVectorView[MobileBroadbandCellGsm]]
    serving_cells_lte: typing.Optional[winsdk.windows.foundation.collections.IVectorView[MobileBroadbandCellLte]]
    serving_cells_tdscdma: typing.Optional[winsdk.windows.foundation.collections.IVectorView[MobileBroadbandCellTdscdma]]
    serving_cells_umts: typing.Optional[winsdk.windows.foundation.collections.IVectorView[MobileBroadbandCellUmts]]
    neighboring_cells_n_r: typing.Optional[winsdk.windows.foundation.collections.IVectorView[MobileBroadbandCellNR]]
    serving_cells_n_r: typing.Optional[winsdk.windows.foundation.collections.IVectorView[MobileBroadbandCellNR]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandCellsInfo: ...

class MobileBroadbandCurrentSlotIndexChangedEventArgs(winsdk.system.Object):
    current_slot_index: winsdk.system.Int32
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandCurrentSlotIndexChangedEventArgs: ...

class MobileBroadbandDeviceInformation(winsdk.system.Object):
    cellular_class: winsdk.windows.devices.sms.CellularClass
    current_radio_state: MobileBroadbandRadioState
    custom_data_class: str
    data_classes: DataClasses
    device_id: str
    device_type: MobileBroadbandDeviceType
    firmware_information: str
    manufacturer: str
    mobile_equipment_id: str
    model: str
    network_device_status: NetworkDeviceStatus
    sim_icc_id: str
    subscriber_id: str
    telephone_numbers: typing.Optional[winsdk.windows.foundation.collections.IVectorView[str]]
    pin_manager: typing.Optional[MobileBroadbandPinManager]
    revision: str
    serial_number: str
    sim_gid1: str
    sim_pnn: str
    sim_spn: str
    slot_manager: typing.Optional[MobileBroadbandSlotManager]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandDeviceInformation: ...

class MobileBroadbandDeviceService(winsdk.system.Object):
    device_service_id: winsdk.system.Guid
    supported_commands: typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.system.UInt32]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandDeviceService: ...
    def open_command_session(self) -> typing.Optional[MobileBroadbandDeviceServiceCommandSession]: ...
    def open_data_session(self) -> typing.Optional[MobileBroadbandDeviceServiceDataSession]: ...

class MobileBroadbandDeviceServiceCommandResult(winsdk.system.Object):
    response_data: typing.Optional[winsdk.windows.storage.streams.IBuffer]
    status_code: winsdk.system.UInt32
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandDeviceServiceCommandResult: ...

class MobileBroadbandDeviceServiceCommandSession(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandDeviceServiceCommandSession: ...
    def close_session(self) -> None: ...
    def send_query_command_async(self, command_id: winsdk.system.UInt32, data: typing.Optional[winsdk.windows.storage.streams.IBuffer]) -> winsdk.windows.foundation.IAsyncOperation[MobileBroadbandDeviceServiceCommandResult]: ...
    def send_set_command_async(self, command_id: winsdk.system.UInt32, data: typing.Optional[winsdk.windows.storage.streams.IBuffer]) -> winsdk.windows.foundation.IAsyncOperation[MobileBroadbandDeviceServiceCommandResult]: ...

class MobileBroadbandDeviceServiceDataReceivedEventArgs(winsdk.system.Object):
    received_data: typing.Optional[winsdk.windows.storage.streams.IBuffer]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandDeviceServiceDataReceivedEventArgs: ...

class MobileBroadbandDeviceServiceDataSession(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandDeviceServiceDataSession: ...
    def close_session(self) -> None: ...
    def write_data_async(self, value: typing.Optional[winsdk.windows.storage.streams.IBuffer]) -> winsdk.windows.foundation.IAsyncAction: ...
    def add_data_received(self, event_handler: winsdk.windows.foundation.TypedEventHandler[MobileBroadbandDeviceServiceDataSession, MobileBroadbandDeviceServiceDataReceivedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_data_received(self, event_cookie: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class MobileBroadbandDeviceServiceInformation(winsdk.system.Object):
    device_service_id: winsdk.system.Guid
    is_data_read_supported: winsdk.system.Boolean
    is_data_write_supported: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandDeviceServiceInformation: ...

class MobileBroadbandDeviceServiceTriggerDetails(winsdk.system.Object):
    device_id: str
    device_service_id: winsdk.system.Guid
    received_data: typing.Optional[winsdk.windows.storage.streams.IBuffer]
    event_id: winsdk.system.UInt32
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandDeviceServiceTriggerDetails: ...

class MobileBroadbandModem(winsdk.system.Object):
    current_account: typing.Optional[MobileBroadbandAccount]
    current_network: typing.Optional[MobileBroadbandNetwork]
    device_information: typing.Optional[MobileBroadbandDeviceInformation]
    device_services: typing.Optional[winsdk.windows.foundation.collections.IVectorView[MobileBroadbandDeviceServiceInformation]]
    is_reset_supported: winsdk.system.Boolean
    max_device_service_command_size_in_bytes: winsdk.system.UInt32
    max_device_service_data_size_in_bytes: winsdk.system.UInt32
    is_in_emergency_call_mode: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandModem: ...
    @staticmethod
    def from_id(device_id: str) -> typing.Optional[MobileBroadbandModem]: ...
    def get_current_configuration_async(self) -> winsdk.windows.foundation.IAsyncOperation[MobileBroadbandModemConfiguration]: ...
    @staticmethod
    def get_default() -> typing.Optional[MobileBroadbandModem]: ...
    @staticmethod
    def get_device_selector() -> str: ...
    def get_device_service(self, device_service_id: winsdk.system.Guid) -> typing.Optional[MobileBroadbandDeviceService]: ...
    def get_is_passthrough_enabled(self, slotindex: winsdk.system.Int32) -> winsdk.system.Boolean: ...
    @typing.overload
    def get_is_passthrough_enabled_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    @typing.overload
    def get_is_passthrough_enabled_async(self, slotindex: winsdk.system.Int32) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def reset_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    def set_is_passthrough_enabled(self, value: winsdk.system.Boolean, slotindex: winsdk.system.Int32) -> MobileBroadbandModemStatus: ...
    @typing.overload
    def set_is_passthrough_enabled_async(self, value: winsdk.system.Boolean) -> winsdk.windows.foundation.IAsyncOperation[MobileBroadbandModemStatus]: ...
    @typing.overload
    def set_is_passthrough_enabled_async(self, value: winsdk.system.Boolean, slotindex: winsdk.system.Int32) -> winsdk.windows.foundation.IAsyncOperation[MobileBroadbandModemStatus]: ...
    def try_get_pco_async(self) -> winsdk.windows.foundation.IAsyncOperation[MobileBroadbandPco]: ...
    def add_is_in_emergency_call_mode_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[MobileBroadbandModem, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_is_in_emergency_call_mode_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class MobileBroadbandModemConfiguration(winsdk.system.Object):
    home_provider_id: str
    home_provider_name: str
    uicc: typing.Optional[MobileBroadbandUicc]
    sar_manager: typing.Optional[MobileBroadbandSarManager]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandModemConfiguration: ...

class MobileBroadbandModemIsolation(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandModemIsolation: ...
    def __new__(cls: typing.Type[MobileBroadbandModemIsolation], modem_device_id: str, rule_group_id: str) -> MobileBroadbandModemIsolation:...
    def add_allowed_host(self, host: typing.Optional[winsdk.windows.networking.HostName]) -> None: ...
    def add_allowed_host_range(self, first: typing.Optional[winsdk.windows.networking.HostName], last: typing.Optional[winsdk.windows.networking.HostName]) -> None: ...
    def apply_configuration_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    def clear_configuration_async(self) -> winsdk.windows.foundation.IAsyncAction: ...

class MobileBroadbandNetwork(winsdk.system.Object):
    access_point_name: str
    activation_network_error: winsdk.system.UInt32
    network_adapter: typing.Optional[winsdk.windows.networking.connectivity.NetworkAdapter]
    network_registration_state: NetworkRegistrationState
    packet_attach_network_error: winsdk.system.UInt32
    registered_data_class: DataClasses
    registered_provider_id: str
    registered_provider_name: str
    registration_network_error: winsdk.system.UInt32
    registration_uicc_apps: typing.Optional[winsdk.windows.foundation.collections.IVectorView[MobileBroadbandUiccApp]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandNetwork: ...
    def get_cells_info_async(self) -> winsdk.windows.foundation.IAsyncOperation[MobileBroadbandCellsInfo]: ...
    def get_voice_call_support_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def show_connection_u_i(self) -> None: ...

class MobileBroadbandNetworkRegistrationStateChange(winsdk.system.Object):
    device_id: str
    network: typing.Optional[MobileBroadbandNetwork]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandNetworkRegistrationStateChange: ...

class MobileBroadbandNetworkRegistrationStateChangeTriggerDetails(winsdk.system.Object):
    network_registration_state_changes: typing.Optional[winsdk.windows.foundation.collections.IVectorView[MobileBroadbandNetworkRegistrationStateChange]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandNetworkRegistrationStateChangeTriggerDetails: ...

class MobileBroadbandPco(winsdk.system.Object):
    data: typing.Optional[winsdk.windows.storage.streams.IBuffer]
    device_id: str
    is_complete: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandPco: ...

class MobileBroadbandPcoDataChangeTriggerDetails(winsdk.system.Object):
    updated_data: typing.Optional[MobileBroadbandPco]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandPcoDataChangeTriggerDetails: ...

class MobileBroadbandPin(winsdk.system.Object):
    attempts_remaining: winsdk.system.UInt32
    enabled: winsdk.system.Boolean
    format: MobileBroadbandPinFormat
    lock_state: MobileBroadbandPinLockState
    max_length: winsdk.system.UInt32
    min_length: winsdk.system.UInt32
    type: MobileBroadbandPinType
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandPin: ...
    def change_async(self, current_pin: str, new_pin: str) -> winsdk.windows.foundation.IAsyncOperation[MobileBroadbandPinOperationResult]: ...
    def disable_async(self, current_pin: str) -> winsdk.windows.foundation.IAsyncOperation[MobileBroadbandPinOperationResult]: ...
    def enable_async(self, current_pin: str) -> winsdk.windows.foundation.IAsyncOperation[MobileBroadbandPinOperationResult]: ...
    def enter_async(self, current_pin: str) -> winsdk.windows.foundation.IAsyncOperation[MobileBroadbandPinOperationResult]: ...
    def unblock_async(self, pin_unblock_key: str, new_pin: str) -> winsdk.windows.foundation.IAsyncOperation[MobileBroadbandPinOperationResult]: ...

class MobileBroadbandPinLockStateChange(winsdk.system.Object):
    device_id: str
    pin_lock_state: MobileBroadbandPinLockState
    pin_type: MobileBroadbandPinType
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandPinLockStateChange: ...

class MobileBroadbandPinLockStateChangeTriggerDetails(winsdk.system.Object):
    pin_lock_state_changes: typing.Optional[winsdk.windows.foundation.collections.IVectorView[MobileBroadbandPinLockStateChange]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandPinLockStateChangeTriggerDetails: ...

class MobileBroadbandPinManager(winsdk.system.Object):
    supported_pins: typing.Optional[winsdk.windows.foundation.collections.IVectorView[MobileBroadbandPinType]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandPinManager: ...
    def get_pin(self, pin_type: MobileBroadbandPinType) -> typing.Optional[MobileBroadbandPin]: ...

class MobileBroadbandPinOperationResult(winsdk.system.Object):
    attempts_remaining: winsdk.system.UInt32
    is_successful: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandPinOperationResult: ...

class MobileBroadbandRadioStateChange(winsdk.system.Object):
    device_id: str
    radio_state: MobileBroadbandRadioState
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandRadioStateChange: ...

class MobileBroadbandRadioStateChangeTriggerDetails(winsdk.system.Object):
    radio_state_changes: typing.Optional[winsdk.windows.foundation.collections.IVectorView[MobileBroadbandRadioStateChange]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandRadioStateChangeTriggerDetails: ...

class MobileBroadbandSarManager(winsdk.system.Object):
    antennas: typing.Optional[winsdk.windows.foundation.collections.IVectorView[MobileBroadbandAntennaSar]]
    hysteresis_timer_period: datetime.timedelta
    is_backoff_enabled: winsdk.system.Boolean
    is_sar_controlled_by_hardware: winsdk.system.Boolean
    is_wi_fi_hardware_integrated: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandSarManager: ...
    def disable_backoff_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    def enable_backoff_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    def get_is_transmitting_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def revert_sar_to_hardware_control_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    def set_configuration_async(self, antennas: typing.Iterable[MobileBroadbandAntennaSar]) -> winsdk.windows.foundation.IAsyncAction: ...
    def set_transmission_state_changed_hysteresis_async(self, timer_period: datetime.timedelta) -> winsdk.windows.foundation.IAsyncAction: ...
    def start_transmission_state_monitoring(self) -> None: ...
    def stop_transmission_state_monitoring(self) -> None: ...
    def add_transmission_state_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[MobileBroadbandSarManager, MobileBroadbandTransmissionStateChangedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_transmission_state_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class MobileBroadbandSlotInfo(winsdk.system.Object):
    index: winsdk.system.Int32
    state: MobileBroadbandSlotState
    icc_id: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandSlotInfo: ...

class MobileBroadbandSlotInfoChangedEventArgs(winsdk.system.Object):
    slot_info: typing.Optional[MobileBroadbandSlotInfo]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandSlotInfoChangedEventArgs: ...

class MobileBroadbandSlotManager(winsdk.system.Object):
    current_slot_index: winsdk.system.Int32
    slot_infos: typing.Optional[winsdk.windows.foundation.collections.IVectorView[MobileBroadbandSlotInfo]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandSlotManager: ...
    def set_current_slot(self, slot_index: winsdk.system.Int32) -> MobileBroadbandModemStatus: ...
    def set_current_slot_async(self, slot_index: winsdk.system.Int32) -> winsdk.windows.foundation.IAsyncOperation[MobileBroadbandModemStatus]: ...
    def add_current_slot_index_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[MobileBroadbandSlotManager, MobileBroadbandCurrentSlotIndexChangedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_current_slot_index_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_slot_info_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[MobileBroadbandSlotManager, MobileBroadbandSlotInfoChangedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_slot_info_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class MobileBroadbandTransmissionStateChangedEventArgs(winsdk.system.Object):
    is_transmitting: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandTransmissionStateChangedEventArgs: ...

class MobileBroadbandUicc(winsdk.system.Object):
    sim_icc_id: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandUicc: ...
    def get_uicc_apps_async(self) -> winsdk.windows.foundation.IAsyncOperation[MobileBroadbandUiccAppsResult]: ...

class MobileBroadbandUiccApp(winsdk.system.Object):
    id: typing.Optional[winsdk.windows.storage.streams.IBuffer]
    kind: UiccAppKind
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandUiccApp: ...
    def get_record_details_async(self, uicc_file_path: typing.Iterable[winsdk.system.UInt32]) -> winsdk.windows.foundation.IAsyncOperation[MobileBroadbandUiccAppRecordDetailsResult]: ...
    def read_record_async(self, uicc_file_path: typing.Iterable[winsdk.system.UInt32], record_index: winsdk.system.Int32) -> winsdk.windows.foundation.IAsyncOperation[MobileBroadbandUiccAppReadRecordResult]: ...

class MobileBroadbandUiccAppReadRecordResult(winsdk.system.Object):
    data: typing.Optional[winsdk.windows.storage.streams.IBuffer]
    status: MobileBroadbandUiccAppOperationStatus
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandUiccAppReadRecordResult: ...

class MobileBroadbandUiccAppRecordDetailsResult(winsdk.system.Object):
    kind: UiccAppRecordKind
    read_access_condition: UiccAccessCondition
    record_count: winsdk.system.Int32
    record_size: winsdk.system.Int32
    status: MobileBroadbandUiccAppOperationStatus
    write_access_condition: UiccAccessCondition
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandUiccAppRecordDetailsResult: ...

class MobileBroadbandUiccAppsResult(winsdk.system.Object):
    status: MobileBroadbandUiccAppOperationStatus
    uicc_apps: typing.Optional[winsdk.windows.foundation.collections.IVectorView[MobileBroadbandUiccApp]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MobileBroadbandUiccAppsResult: ...

class NetworkOperatorDataUsageTriggerDetails(winsdk.system.Object):
    notification_kind: NetworkOperatorDataUsageNotificationKind
    @staticmethod
    def _from(obj: winsdk.system.Object) -> NetworkOperatorDataUsageTriggerDetails: ...

class NetworkOperatorNotificationEventDetails(winsdk.system.Object):
    encoding_type: winsdk.system.UInt8
    message: str
    network_account_id: str
    notification_type: NetworkOperatorEventMessageType
    rule_id: str
    sms_message: typing.Optional[winsdk.windows.devices.sms.ISmsMessage]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> NetworkOperatorNotificationEventDetails: ...
    def authorize_tethering(self, allow: winsdk.system.Boolean, entitlement_failure_reason: str) -> None: ...

class NetworkOperatorTetheringAccessPointConfiguration(winsdk.system.Object):
    ssid: str
    passphrase: str
    band: TetheringWiFiBand
    @staticmethod
    def _from(obj: winsdk.system.Object) -> NetworkOperatorTetheringAccessPointConfiguration: ...
    def __new__(cls: typing.Type[NetworkOperatorTetheringAccessPointConfiguration]) -> NetworkOperatorTetheringAccessPointConfiguration:...
    def is_band_supported(self, band: TetheringWiFiBand) -> winsdk.system.Boolean: ...
    def is_band_supported_async(self, band: TetheringWiFiBand) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...

class NetworkOperatorTetheringClient(winsdk.system.Object):
    host_names: typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.windows.networking.HostName]]
    mac_address: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> NetworkOperatorTetheringClient: ...

class NetworkOperatorTetheringManager(winsdk.system.Object):
    client_count: winsdk.system.UInt32
    max_client_count: winsdk.system.UInt32
    tethering_operational_state: TetheringOperationalState
    @staticmethod
    def _from(obj: winsdk.system.Object) -> NetworkOperatorTetheringManager: ...
    def configure_access_point_async(self, configuration: typing.Optional[NetworkOperatorTetheringAccessPointConfiguration]) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    @staticmethod
    def create_from_connection_profile(profile: typing.Optional[winsdk.windows.networking.connectivity.ConnectionProfile]) -> typing.Optional[NetworkOperatorTetheringManager]: ...
    @typing.overload
    @staticmethod
    def create_from_connection_profile(profile: typing.Optional[winsdk.windows.networking.connectivity.ConnectionProfile], adapter: typing.Optional[winsdk.windows.networking.connectivity.NetworkAdapter]) -> typing.Optional[NetworkOperatorTetheringManager]: ...
    @staticmethod
    def create_from_network_account_id(network_account_id: str) -> typing.Optional[NetworkOperatorTetheringManager]: ...
    @staticmethod
    def disable_no_connections_timeout() -> None: ...
    @staticmethod
    def disable_no_connections_timeout_async() -> winsdk.windows.foundation.IAsyncAction: ...
    @staticmethod
    def enable_no_connections_timeout() -> None: ...
    @staticmethod
    def enable_no_connections_timeout_async() -> winsdk.windows.foundation.IAsyncAction: ...
    def get_current_access_point_configuration(self) -> typing.Optional[NetworkOperatorTetheringAccessPointConfiguration]: ...
    @staticmethod
    def get_tethering_capability(network_account_id: str) -> TetheringCapability: ...
    @staticmethod
    def get_tethering_capability_from_connection_profile(profile: typing.Optional[winsdk.windows.networking.connectivity.ConnectionProfile]) -> TetheringCapability: ...
    def get_tethering_clients(self) -> typing.Optional[winsdk.windows.foundation.collections.IVectorView[NetworkOperatorTetheringClient]]: ...
    @staticmethod
    def is_no_connections_timeout_enabled() -> winsdk.system.Boolean: ...
    def start_tethering_async(self) -> winsdk.windows.foundation.IAsyncOperation[NetworkOperatorTetheringOperationResult]: ...
    def stop_tethering_async(self) -> winsdk.windows.foundation.IAsyncOperation[NetworkOperatorTetheringOperationResult]: ...

class NetworkOperatorTetheringOperationResult(winsdk.system.Object):
    additional_error_message: str
    status: TetheringOperationStatus
    @staticmethod
    def _from(obj: winsdk.system.Object) -> NetworkOperatorTetheringOperationResult: ...

class ProvisionFromXmlDocumentResults(winsdk.system.Object):
    all_elements_provisioned: winsdk.system.Boolean
    provision_results_xml: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ProvisionFromXmlDocumentResults: ...

class ProvisionedProfile(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ProvisionedProfile: ...
    def update_cost(self, value: winsdk.windows.networking.connectivity.NetworkCostType) -> None: ...
    def update_usage(self, value: ProfileUsage) -> None: ...

class ProvisioningAgent(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ProvisioningAgent: ...
    def __new__(cls: typing.Type[ProvisioningAgent]) -> ProvisioningAgent:...
    @staticmethod
    def create_from_network_account_id(network_account_id: str) -> typing.Optional[ProvisioningAgent]: ...
    def get_provisioned_profile(self, media_type: ProfileMediaType, profile_name: str) -> typing.Optional[ProvisionedProfile]: ...
    def provision_from_xml_document_async(self, provisioning_xml_document: str) -> winsdk.windows.foundation.IAsyncOperation[ProvisionFromXmlDocumentResults]: ...

class TetheringEntitlementCheckTriggerDetails(winsdk.system.Object):
    network_account_id: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> TetheringEntitlementCheckTriggerDetails: ...
    def allow_tethering(self) -> None: ...
    def deny_tethering(self, entitlement_failure_reason: str) -> None: ...

class UssdMessage(winsdk.system.Object):
    payload_as_text: str
    data_coding_scheme: winsdk.system.UInt8
    @staticmethod
    def _from(obj: winsdk.system.Object) -> UssdMessage: ...
    def __new__(cls: typing.Type[UssdMessage], message_text: str) -> UssdMessage:...
    def get_payload(self) -> winsdk.system.UInt8: ...
    def set_payload(self, value: winsdk.system.Array[winsdk.system.UInt8]) -> None: ...

class UssdReply(winsdk.system.Object):
    message: typing.Optional[UssdMessage]
    result_code: UssdResultCode
    @staticmethod
    def _from(obj: winsdk.system.Object) -> UssdReply: ...

class UssdSession(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> UssdSession: ...
    def close(self) -> None: ...
    @staticmethod
    def create_from_network_account_id(network_account_id: str) -> typing.Optional[UssdSession]: ...
    @staticmethod
    def create_from_network_interface_id(network_interface_id: str) -> typing.Optional[UssdSession]: ...
    def send_message_and_get_reply_async(self, message: typing.Optional[UssdMessage]) -> winsdk.windows.foundation.IAsyncOperation[UssdReply]: ...

