# WARNING: Please don't edit this file. It was generated by Python/WinRT v1.0.0-beta.8

import enum
import datetime
import sys
import types
import typing

import winsdk.system
import winsdk.windows.devices.enumeration
import winsdk.windows.foundation
import winsdk.windows.foundation.collections
import winsdk.windows.foundation.numerics
import winsdk.windows.media
import winsdk.windows.media.capture
import winsdk.windows.media.core
import winsdk.windows.media.devices
import winsdk.windows.media.effects
import winsdk.windows.media.mediaproperties
import winsdk.windows.media.render
import winsdk.windows.media.transcoding
import winsdk.windows.storage

class AudioDeviceNodeCreationStatus(enum.IntEnum):
    SUCCESS = 0
    DEVICE_NOT_AVAILABLE = 1
    FORMAT_NOT_SUPPORTED = 2
    UNKNOWN_FAILURE = 3
    ACCESS_DENIED = 4

class AudioFileNodeCreationStatus(enum.IntEnum):
    SUCCESS = 0
    FILE_NOT_FOUND = 1
    INVALID_FILE_TYPE = 2
    FORMAT_NOT_SUPPORTED = 3
    UNKNOWN_FAILURE = 4

class AudioGraphCreationStatus(enum.IntEnum):
    SUCCESS = 0
    DEVICE_NOT_AVAILABLE = 1
    FORMAT_NOT_SUPPORTED = 2
    UNKNOWN_FAILURE = 3

class AudioGraphUnrecoverableError(enum.IntEnum):
    NONE = 0
    AUDIO_DEVICE_LOST = 1
    AUDIO_SESSION_DISCONNECTED = 2
    UNKNOWN_FAILURE = 3

class AudioNodeEmitterDecayKind(enum.IntEnum):
    NATURAL = 0
    CUSTOM = 1

class AudioNodeEmitterSettings(enum.IntFlag):
    NONE = 0
    DISABLE_DOPPLER = 0x1

class AudioNodeEmitterShapeKind(enum.IntEnum):
    OMNIDIRECTIONAL = 0
    CONE = 1

class AudioPlaybackConnectionOpenResultStatus(enum.IntEnum):
    SUCCESS = 0
    REQUEST_TIMED_OUT = 1
    DENIED_BY_SYSTEM = 2
    UNKNOWN_FAILURE = 3

class AudioPlaybackConnectionState(enum.IntEnum):
    CLOSED = 0
    OPENED = 1

class MediaSourceAudioInputNodeCreationStatus(enum.IntEnum):
    SUCCESS = 0
    FORMAT_NOT_SUPPORTED = 1
    NETWORK_ERROR = 2
    UNKNOWN_FAILURE = 3

class MixedRealitySpatialAudioFormatPolicy(enum.IntEnum):
    USE_MIXED_REALITY_DEFAULT_SPATIAL_AUDIO_FORMAT = 0
    USE_DEVICE_CONFIGURATION_DEFAULT_SPATIAL_AUDIO_FORMAT = 1

class QuantumSizeSelectionMode(enum.IntEnum):
    SYSTEM_DEFAULT = 0
    LOWEST_LATENCY = 1
    CLOSEST_TO_DESIRED = 2

class SetDefaultSpatialAudioFormatStatus(enum.IntEnum):
    SUCCEEDED = 0
    ACCESS_DENIED = 1
    LICENSE_EXPIRED = 2
    LICENSE_NOT_VALID_FOR_AUDIO_ENDPOINT = 3
    NOT_SUPPORTED_ON_AUDIO_ENDPOINT = 4
    UNKNOWN_ERROR = 5

class SpatialAudioModel(enum.IntEnum):
    OBJECT_BASED = 0
    FOLD_DOWN = 1

Self = typing.TypeVar('Self')

class AudioDeviceInputNode(winsdk.system.Object):
    device: typing.Optional[winsdk.windows.devices.enumeration.DeviceInformation]
    outgoing_connections: typing.Optional[winsdk.windows.foundation.collections.IVectorView[AudioGraphConnection]]
    emitter: typing.Optional[AudioNodeEmitter]
    outgoing_gain: winsdk.system.Double
    consume_input: winsdk.system.Boolean
    effect_definitions: typing.Optional[winsdk.windows.foundation.collections.IVector[winsdk.windows.media.effects.IAudioEffectDefinition]]
    encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.AudioEncodingProperties]
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> AudioDeviceInputNode: ...
    @typing.overload
    def add_outgoing_connection(self, destination: typing.Optional[IAudioNode]) -> None: ...
    @typing.overload
    def add_outgoing_connection(self, destination: typing.Optional[IAudioNode], gain: winsdk.system.Double) -> None: ...
    def close(self) -> None: ...
    def disable_effects_by_definition(self, definition: typing.Optional[winsdk.windows.media.effects.IAudioEffectDefinition]) -> None: ...
    def enable_effects_by_definition(self, definition: typing.Optional[winsdk.windows.media.effects.IAudioEffectDefinition]) -> None: ...
    def remove_outgoing_connection(self, destination: typing.Optional[IAudioNode]) -> None: ...
    def reset(self) -> None: ...
    def start(self) -> None: ...
    def stop(self) -> None: ...

class AudioDeviceOutputNode(winsdk.system.Object):
    device: typing.Optional[winsdk.windows.devices.enumeration.DeviceInformation]
    outgoing_gain: winsdk.system.Double
    consume_input: winsdk.system.Boolean
    effect_definitions: typing.Optional[winsdk.windows.foundation.collections.IVector[winsdk.windows.media.effects.IAudioEffectDefinition]]
    encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.AudioEncodingProperties]
    listener: typing.Optional[AudioNodeListener]
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> AudioDeviceOutputNode: ...
    def close(self) -> None: ...
    def disable_effects_by_definition(self, definition: typing.Optional[winsdk.windows.media.effects.IAudioEffectDefinition]) -> None: ...
    def enable_effects_by_definition(self, definition: typing.Optional[winsdk.windows.media.effects.IAudioEffectDefinition]) -> None: ...
    def reset(self) -> None: ...
    def start(self) -> None: ...
    def stop(self) -> None: ...

class AudioFileInputNode(winsdk.system.Object):
    playback_speed_factor: winsdk.system.Double
    loop_count: typing.Optional[typing.Optional[winsdk.system.Int32]]
    end_time: typing.Optional[typing.Optional[datetime.timedelta]]
    start_time: typing.Optional[typing.Optional[datetime.timedelta]]
    position: datetime.timedelta
    source_file: typing.Optional[winsdk.windows.storage.StorageFile]
    duration: datetime.timedelta
    outgoing_connections: typing.Optional[winsdk.windows.foundation.collections.IVectorView[AudioGraphConnection]]
    emitter: typing.Optional[AudioNodeEmitter]
    outgoing_gain: winsdk.system.Double
    consume_input: winsdk.system.Boolean
    effect_definitions: typing.Optional[winsdk.windows.foundation.collections.IVector[winsdk.windows.media.effects.IAudioEffectDefinition]]
    encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.AudioEncodingProperties]
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> AudioFileInputNode: ...
    @typing.overload
    def add_outgoing_connection(self, destination: typing.Optional[IAudioNode]) -> None: ...
    @typing.overload
    def add_outgoing_connection(self, destination: typing.Optional[IAudioNode], gain: winsdk.system.Double) -> None: ...
    def close(self) -> None: ...
    def disable_effects_by_definition(self, definition: typing.Optional[winsdk.windows.media.effects.IAudioEffectDefinition]) -> None: ...
    def enable_effects_by_definition(self, definition: typing.Optional[winsdk.windows.media.effects.IAudioEffectDefinition]) -> None: ...
    def remove_outgoing_connection(self, destination: typing.Optional[IAudioNode]) -> None: ...
    def reset(self) -> None: ...
    def seek(self, position: datetime.timedelta) -> None: ...
    def start(self) -> None: ...
    def stop(self) -> None: ...
    def add_file_completed(self, handler: winsdk.windows.foundation.TypedEventHandler[AudioFileInputNode, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_file_completed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class AudioFileOutputNode(winsdk.system.Object):
    file: typing.Optional[winsdk.windows.storage.IStorageFile]
    file_encoding_profile: typing.Optional[winsdk.windows.media.mediaproperties.MediaEncodingProfile]
    outgoing_gain: winsdk.system.Double
    consume_input: winsdk.system.Boolean
    effect_definitions: typing.Optional[winsdk.windows.foundation.collections.IVector[winsdk.windows.media.effects.IAudioEffectDefinition]]
    encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.AudioEncodingProperties]
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> AudioFileOutputNode: ...
    def close(self) -> None: ...
    def disable_effects_by_definition(self, definition: typing.Optional[winsdk.windows.media.effects.IAudioEffectDefinition]) -> None: ...
    def enable_effects_by_definition(self, definition: typing.Optional[winsdk.windows.media.effects.IAudioEffectDefinition]) -> None: ...
    def finalize_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.media.transcoding.TranscodeFailureReason]: ...
    def reset(self) -> None: ...
    def start(self) -> None: ...
    def stop(self) -> None: ...

class AudioFrameCompletedEventArgs(winsdk.system.Object):
    frame: typing.Optional[winsdk.windows.media.AudioFrame]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> AudioFrameCompletedEventArgs: ...

class AudioFrameInputNode(winsdk.system.Object):
    playback_speed_factor: winsdk.system.Double
    queued_sample_count: winsdk.system.UInt64
    outgoing_connections: typing.Optional[winsdk.windows.foundation.collections.IVectorView[AudioGraphConnection]]
    emitter: typing.Optional[AudioNodeEmitter]
    outgoing_gain: winsdk.system.Double
    consume_input: winsdk.system.Boolean
    effect_definitions: typing.Optional[winsdk.windows.foundation.collections.IVector[winsdk.windows.media.effects.IAudioEffectDefinition]]
    encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.AudioEncodingProperties]
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> AudioFrameInputNode: ...
    def add_frame(self, frame: typing.Optional[winsdk.windows.media.AudioFrame]) -> None: ...
    @typing.overload
    def add_outgoing_connection(self, destination: typing.Optional[IAudioNode]) -> None: ...
    @typing.overload
    def add_outgoing_connection(self, destination: typing.Optional[IAudioNode], gain: winsdk.system.Double) -> None: ...
    def close(self) -> None: ...
    def disable_effects_by_definition(self, definition: typing.Optional[winsdk.windows.media.effects.IAudioEffectDefinition]) -> None: ...
    def discard_queued_frames(self) -> None: ...
    def enable_effects_by_definition(self, definition: typing.Optional[winsdk.windows.media.effects.IAudioEffectDefinition]) -> None: ...
    def remove_outgoing_connection(self, destination: typing.Optional[IAudioNode]) -> None: ...
    def reset(self) -> None: ...
    def start(self) -> None: ...
    def stop(self) -> None: ...
    def add_audio_frame_completed(self, handler: winsdk.windows.foundation.TypedEventHandler[AudioFrameInputNode, AudioFrameCompletedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_audio_frame_completed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_quantum_started(self, handler: winsdk.windows.foundation.TypedEventHandler[AudioFrameInputNode, FrameInputNodeQuantumStartedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_quantum_started(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class AudioFrameOutputNode(winsdk.system.Object):
    outgoing_gain: winsdk.system.Double
    consume_input: winsdk.system.Boolean
    effect_definitions: typing.Optional[winsdk.windows.foundation.collections.IVector[winsdk.windows.media.effects.IAudioEffectDefinition]]
    encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.AudioEncodingProperties]
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> AudioFrameOutputNode: ...
    def close(self) -> None: ...
    def disable_effects_by_definition(self, definition: typing.Optional[winsdk.windows.media.effects.IAudioEffectDefinition]) -> None: ...
    def enable_effects_by_definition(self, definition: typing.Optional[winsdk.windows.media.effects.IAudioEffectDefinition]) -> None: ...
    def get_frame(self) -> typing.Optional[winsdk.windows.media.AudioFrame]: ...
    def reset(self) -> None: ...
    def start(self) -> None: ...
    def stop(self) -> None: ...

class AudioGraph(winsdk.system.Object):
    completed_quantum_count: winsdk.system.UInt64
    encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.AudioEncodingProperties]
    latency_in_samples: winsdk.system.Int32
    primary_render_device: typing.Optional[winsdk.windows.devices.enumeration.DeviceInformation]
    render_device_audio_processing: winsdk.windows.media.AudioProcessing
    samples_per_quantum: winsdk.system.Int32
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> AudioGraph: ...
    def close(self) -> None: ...
    @staticmethod
    def create_async(settings: typing.Optional[AudioGraphSettings]) -> winsdk.windows.foundation.IAsyncOperation[CreateAudioGraphResult]: ...
    def create_batch_updater(self) -> typing.Optional[AudioGraphBatchUpdater]: ...
    @typing.overload
    def create_device_input_node_async(self, category: winsdk.windows.media.capture.MediaCategory) -> winsdk.windows.foundation.IAsyncOperation[CreateAudioDeviceInputNodeResult]: ...
    @typing.overload
    def create_device_input_node_async(self, category: winsdk.windows.media.capture.MediaCategory, encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.AudioEncodingProperties]) -> winsdk.windows.foundation.IAsyncOperation[CreateAudioDeviceInputNodeResult]: ...
    @typing.overload
    def create_device_input_node_async(self, category: winsdk.windows.media.capture.MediaCategory, encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.AudioEncodingProperties], device: typing.Optional[winsdk.windows.devices.enumeration.DeviceInformation]) -> winsdk.windows.foundation.IAsyncOperation[CreateAudioDeviceInputNodeResult]: ...
    @typing.overload
    def create_device_input_node_async(self, category: winsdk.windows.media.capture.MediaCategory, encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.AudioEncodingProperties], device: typing.Optional[winsdk.windows.devices.enumeration.DeviceInformation], emitter: typing.Optional[AudioNodeEmitter]) -> winsdk.windows.foundation.IAsyncOperation[CreateAudioDeviceInputNodeResult]: ...
    def create_device_output_node_async(self) -> winsdk.windows.foundation.IAsyncOperation[CreateAudioDeviceOutputNodeResult]: ...
    @typing.overload
    def create_file_input_node_async(self, file: typing.Optional[winsdk.windows.storage.IStorageFile]) -> winsdk.windows.foundation.IAsyncOperation[CreateAudioFileInputNodeResult]: ...
    @typing.overload
    def create_file_input_node_async(self, file: typing.Optional[winsdk.windows.storage.IStorageFile], emitter: typing.Optional[AudioNodeEmitter]) -> winsdk.windows.foundation.IAsyncOperation[CreateAudioFileInputNodeResult]: ...
    @typing.overload
    def create_file_output_node_async(self, file: typing.Optional[winsdk.windows.storage.IStorageFile]) -> winsdk.windows.foundation.IAsyncOperation[CreateAudioFileOutputNodeResult]: ...
    @typing.overload
    def create_file_output_node_async(self, file: typing.Optional[winsdk.windows.storage.IStorageFile], file_encoding_profile: typing.Optional[winsdk.windows.media.mediaproperties.MediaEncodingProfile]) -> winsdk.windows.foundation.IAsyncOperation[CreateAudioFileOutputNodeResult]: ...
    @typing.overload
    def create_frame_input_node(self) -> typing.Optional[AudioFrameInputNode]: ...
    @typing.overload
    def create_frame_input_node(self, encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.AudioEncodingProperties]) -> typing.Optional[AudioFrameInputNode]: ...
    @typing.overload
    def create_frame_input_node(self, encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.AudioEncodingProperties], emitter: typing.Optional[AudioNodeEmitter]) -> typing.Optional[AudioFrameInputNode]: ...
    @typing.overload
    def create_frame_output_node(self) -> typing.Optional[AudioFrameOutputNode]: ...
    @typing.overload
    def create_frame_output_node(self, encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.AudioEncodingProperties]) -> typing.Optional[AudioFrameOutputNode]: ...
    @typing.overload
    def create_media_source_audio_input_node_async(self, media_source: typing.Optional[winsdk.windows.media.core.MediaSource]) -> winsdk.windows.foundation.IAsyncOperation[CreateMediaSourceAudioInputNodeResult]: ...
    @typing.overload
    def create_media_source_audio_input_node_async(self, media_source: typing.Optional[winsdk.windows.media.core.MediaSource], emitter: typing.Optional[AudioNodeEmitter]) -> winsdk.windows.foundation.IAsyncOperation[CreateMediaSourceAudioInputNodeResult]: ...
    @typing.overload
    def create_submix_node(self) -> typing.Optional[AudioSubmixNode]: ...
    @typing.overload
    def create_submix_node(self, encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.AudioEncodingProperties]) -> typing.Optional[AudioSubmixNode]: ...
    @typing.overload
    def create_submix_node(self, encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.AudioEncodingProperties], emitter: typing.Optional[AudioNodeEmitter]) -> typing.Optional[AudioSubmixNode]: ...
    def reset_all_nodes(self) -> None: ...
    def start(self) -> None: ...
    def stop(self) -> None: ...
    def add_quantum_processed(self, handler: winsdk.windows.foundation.TypedEventHandler[AudioGraph, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_quantum_processed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_quantum_started(self, handler: winsdk.windows.foundation.TypedEventHandler[AudioGraph, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_quantum_started(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_unrecoverable_error_occurred(self, handler: winsdk.windows.foundation.TypedEventHandler[AudioGraph, AudioGraphUnrecoverableErrorOccurredEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_unrecoverable_error_occurred(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class AudioGraphBatchUpdater(winsdk.system.Object):
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> AudioGraphBatchUpdater: ...
    def close(self) -> None: ...

class AudioGraphConnection(winsdk.system.Object):
    gain: winsdk.system.Double
    destination: typing.Optional[IAudioNode]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> AudioGraphConnection: ...

class AudioGraphSettings(winsdk.system.Object):
    quantum_size_selection_mode: QuantumSizeSelectionMode
    primary_render_device: typing.Optional[winsdk.windows.devices.enumeration.DeviceInformation]
    encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.AudioEncodingProperties]
    desired_samples_per_quantum: winsdk.system.Int32
    desired_render_device_audio_processing: winsdk.windows.media.AudioProcessing
    audio_render_category: winsdk.windows.media.render.AudioRenderCategory
    max_playback_speed_factor: winsdk.system.Double
    @staticmethod
    def _from(obj: winsdk.system.Object) -> AudioGraphSettings: ...
    def __new__(cls: typing.Type[AudioGraphSettings], audio_render_category: winsdk.windows.media.render.AudioRenderCategory) -> AudioGraphSettings:...

class AudioGraphUnrecoverableErrorOccurredEventArgs(winsdk.system.Object):
    error: AudioGraphUnrecoverableError
    @staticmethod
    def _from(obj: winsdk.system.Object) -> AudioGraphUnrecoverableErrorOccurredEventArgs: ...

class AudioNodeEmitter(winsdk.system.Object):
    position: winsdk.windows.foundation.numerics.Vector3
    gain: winsdk.system.Double
    doppler_velocity: winsdk.windows.foundation.numerics.Vector3
    doppler_scale: winsdk.system.Double
    distance_scale: winsdk.system.Double
    direction: winsdk.windows.foundation.numerics.Vector3
    decay_model: typing.Optional[AudioNodeEmitterDecayModel]
    is_doppler_disabled: winsdk.system.Boolean
    shape: typing.Optional[AudioNodeEmitterShape]
    spatial_audio_model: SpatialAudioModel
    @staticmethod
    def _from(obj: winsdk.system.Object) -> AudioNodeEmitter: ...
    @typing.overload
    def __new__(cls: typing.Type[AudioNodeEmitter], shape: typing.Optional[AudioNodeEmitterShape], decay_model: typing.Optional[AudioNodeEmitterDecayModel], settings: AudioNodeEmitterSettings) -> AudioNodeEmitter:...
    @typing.overload
    def __new__(cls: typing.Type[AudioNodeEmitter]) -> AudioNodeEmitter:...

class AudioNodeEmitterConeProperties(winsdk.system.Object):
    inner_angle: winsdk.system.Double
    outer_angle: winsdk.system.Double
    outer_angle_gain: winsdk.system.Double
    @staticmethod
    def _from(obj: winsdk.system.Object) -> AudioNodeEmitterConeProperties: ...

class AudioNodeEmitterDecayModel(winsdk.system.Object):
    kind: AudioNodeEmitterDecayKind
    max_gain: winsdk.system.Double
    min_gain: winsdk.system.Double
    natural_properties: typing.Optional[AudioNodeEmitterNaturalDecayModelProperties]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> AudioNodeEmitterDecayModel: ...
    @staticmethod
    def create_custom(min_gain: winsdk.system.Double, max_gain: winsdk.system.Double) -> typing.Optional[AudioNodeEmitterDecayModel]: ...
    @staticmethod
    def create_natural(min_gain: winsdk.system.Double, max_gain: winsdk.system.Double, unity_gain_distance: winsdk.system.Double, cutoff_distance: winsdk.system.Double) -> typing.Optional[AudioNodeEmitterDecayModel]: ...

class AudioNodeEmitterNaturalDecayModelProperties(winsdk.system.Object):
    cutoff_distance: winsdk.system.Double
    unity_gain_distance: winsdk.system.Double
    @staticmethod
    def _from(obj: winsdk.system.Object) -> AudioNodeEmitterNaturalDecayModelProperties: ...

class AudioNodeEmitterShape(winsdk.system.Object):
    cone_properties: typing.Optional[AudioNodeEmitterConeProperties]
    kind: AudioNodeEmitterShapeKind
    @staticmethod
    def _from(obj: winsdk.system.Object) -> AudioNodeEmitterShape: ...
    @staticmethod
    def create_cone(inner_angle: winsdk.system.Double, outer_angle: winsdk.system.Double, outer_angle_gain: winsdk.system.Double) -> typing.Optional[AudioNodeEmitterShape]: ...
    @staticmethod
    def create_omnidirectional() -> typing.Optional[AudioNodeEmitterShape]: ...

class AudioNodeListener(winsdk.system.Object):
    speed_of_sound: winsdk.system.Double
    position: winsdk.windows.foundation.numerics.Vector3
    orientation: winsdk.windows.foundation.numerics.Quaternion
    doppler_velocity: winsdk.windows.foundation.numerics.Vector3
    @staticmethod
    def _from(obj: winsdk.system.Object) -> AudioNodeListener: ...
    def __new__(cls: typing.Type[AudioNodeListener]) -> AudioNodeListener:...

class AudioPlaybackConnection(winsdk.system.Object):
    device_id: str
    state: AudioPlaybackConnectionState
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> AudioPlaybackConnection: ...
    def close(self) -> None: ...
    @staticmethod
    def get_device_selector() -> str: ...
    def open(self) -> typing.Optional[AudioPlaybackConnectionOpenResult]: ...
    def open_async(self) -> winsdk.windows.foundation.IAsyncOperation[AudioPlaybackConnectionOpenResult]: ...
    def start(self) -> None: ...
    def start_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    @staticmethod
    def try_create_from_id(id: str) -> typing.Optional[AudioPlaybackConnection]: ...
    def add_state_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[AudioPlaybackConnection, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_state_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class AudioPlaybackConnectionOpenResult(winsdk.system.Object):
    extended_error: winsdk.windows.foundation.HResult
    status: AudioPlaybackConnectionOpenResultStatus
    @staticmethod
    def _from(obj: winsdk.system.Object) -> AudioPlaybackConnectionOpenResult: ...

class AudioStateMonitor(winsdk.system.Object):
    sound_level: winsdk.windows.media.SoundLevel
    @staticmethod
    def _from(obj: winsdk.system.Object) -> AudioStateMonitor: ...
    @typing.overload
    @staticmethod
    def create_for_capture_monitoring() -> typing.Optional[AudioStateMonitor]: ...
    @typing.overload
    @staticmethod
    def create_for_capture_monitoring(category: winsdk.windows.media.capture.MediaCategory) -> typing.Optional[AudioStateMonitor]: ...
    @typing.overload
    @staticmethod
    def create_for_capture_monitoring(category: winsdk.windows.media.capture.MediaCategory, role: winsdk.windows.media.devices.AudioDeviceRole) -> typing.Optional[AudioStateMonitor]: ...
    @staticmethod
    def create_for_capture_monitoring_with_category_and_device_id(category: winsdk.windows.media.capture.MediaCategory, device_id: str) -> typing.Optional[AudioStateMonitor]: ...
    @typing.overload
    @staticmethod
    def create_for_render_monitoring() -> typing.Optional[AudioStateMonitor]: ...
    @typing.overload
    @staticmethod
    def create_for_render_monitoring(category: winsdk.windows.media.render.AudioRenderCategory) -> typing.Optional[AudioStateMonitor]: ...
    @typing.overload
    @staticmethod
    def create_for_render_monitoring(category: winsdk.windows.media.render.AudioRenderCategory, role: winsdk.windows.media.devices.AudioDeviceRole) -> typing.Optional[AudioStateMonitor]: ...
    @staticmethod
    def create_for_render_monitoring_with_category_and_device_id(category: winsdk.windows.media.render.AudioRenderCategory, device_id: str) -> typing.Optional[AudioStateMonitor]: ...
    def add_sound_level_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[AudioStateMonitor, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_sound_level_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class AudioSubmixNode(winsdk.system.Object):
    outgoing_connections: typing.Optional[winsdk.windows.foundation.collections.IVectorView[AudioGraphConnection]]
    emitter: typing.Optional[AudioNodeEmitter]
    outgoing_gain: winsdk.system.Double
    consume_input: winsdk.system.Boolean
    effect_definitions: typing.Optional[winsdk.windows.foundation.collections.IVector[winsdk.windows.media.effects.IAudioEffectDefinition]]
    encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.AudioEncodingProperties]
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> AudioSubmixNode: ...
    @typing.overload
    def add_outgoing_connection(self, destination: typing.Optional[IAudioNode]) -> None: ...
    @typing.overload
    def add_outgoing_connection(self, destination: typing.Optional[IAudioNode], gain: winsdk.system.Double) -> None: ...
    def close(self) -> None: ...
    def disable_effects_by_definition(self, definition: typing.Optional[winsdk.windows.media.effects.IAudioEffectDefinition]) -> None: ...
    def enable_effects_by_definition(self, definition: typing.Optional[winsdk.windows.media.effects.IAudioEffectDefinition]) -> None: ...
    def remove_outgoing_connection(self, destination: typing.Optional[IAudioNode]) -> None: ...
    def reset(self) -> None: ...
    def start(self) -> None: ...
    def stop(self) -> None: ...

class CreateAudioDeviceInputNodeResult(winsdk.system.Object):
    device_input_node: typing.Optional[AudioDeviceInputNode]
    status: AudioDeviceNodeCreationStatus
    extended_error: winsdk.windows.foundation.HResult
    @staticmethod
    def _from(obj: winsdk.system.Object) -> CreateAudioDeviceInputNodeResult: ...

class CreateAudioDeviceOutputNodeResult(winsdk.system.Object):
    device_output_node: typing.Optional[AudioDeviceOutputNode]
    status: AudioDeviceNodeCreationStatus
    extended_error: winsdk.windows.foundation.HResult
    @staticmethod
    def _from(obj: winsdk.system.Object) -> CreateAudioDeviceOutputNodeResult: ...

class CreateAudioFileInputNodeResult(winsdk.system.Object):
    file_input_node: typing.Optional[AudioFileInputNode]
    status: AudioFileNodeCreationStatus
    extended_error: winsdk.windows.foundation.HResult
    @staticmethod
    def _from(obj: winsdk.system.Object) -> CreateAudioFileInputNodeResult: ...

class CreateAudioFileOutputNodeResult(winsdk.system.Object):
    file_output_node: typing.Optional[AudioFileOutputNode]
    status: AudioFileNodeCreationStatus
    extended_error: winsdk.windows.foundation.HResult
    @staticmethod
    def _from(obj: winsdk.system.Object) -> CreateAudioFileOutputNodeResult: ...

class CreateAudioGraphResult(winsdk.system.Object):
    graph: typing.Optional[AudioGraph]
    status: AudioGraphCreationStatus
    extended_error: winsdk.windows.foundation.HResult
    @staticmethod
    def _from(obj: winsdk.system.Object) -> CreateAudioGraphResult: ...

class CreateMediaSourceAudioInputNodeResult(winsdk.system.Object):
    node: typing.Optional[MediaSourceAudioInputNode]
    status: MediaSourceAudioInputNodeCreationStatus
    extended_error: winsdk.windows.foundation.HResult
    @staticmethod
    def _from(obj: winsdk.system.Object) -> CreateMediaSourceAudioInputNodeResult: ...

class EchoEffectDefinition(winsdk.system.Object):
    wet_dry_mix: winsdk.system.Double
    feedback: winsdk.system.Double
    delay: winsdk.system.Double
    activatable_class_id: str
    properties: typing.Optional[winsdk.windows.foundation.collections.IPropertySet]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> EchoEffectDefinition: ...
    def __new__(cls: typing.Type[EchoEffectDefinition], audio_graph: typing.Optional[AudioGraph]) -> EchoEffectDefinition:...

class EqualizerBand(winsdk.system.Object):
    gain: winsdk.system.Double
    frequency_center: winsdk.system.Double
    bandwidth: winsdk.system.Double
    @staticmethod
    def _from(obj: winsdk.system.Object) -> EqualizerBand: ...

class EqualizerEffectDefinition(winsdk.system.Object):
    bands: typing.Optional[winsdk.windows.foundation.collections.IVectorView[EqualizerBand]]
    activatable_class_id: str
    properties: typing.Optional[winsdk.windows.foundation.collections.IPropertySet]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> EqualizerEffectDefinition: ...
    def __new__(cls: typing.Type[EqualizerEffectDefinition], audio_graph: typing.Optional[AudioGraph]) -> EqualizerEffectDefinition:...

class FrameInputNodeQuantumStartedEventArgs(winsdk.system.Object):
    required_samples: winsdk.system.Int32
    @staticmethod
    def _from(obj: winsdk.system.Object) -> FrameInputNodeQuantumStartedEventArgs: ...

class LimiterEffectDefinition(winsdk.system.Object):
    release: winsdk.system.UInt32
    loudness: winsdk.system.UInt32
    activatable_class_id: str
    properties: typing.Optional[winsdk.windows.foundation.collections.IPropertySet]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> LimiterEffectDefinition: ...
    def __new__(cls: typing.Type[LimiterEffectDefinition], audio_graph: typing.Optional[AudioGraph]) -> LimiterEffectDefinition:...

class MediaSourceAudioInputNode(winsdk.system.Object):
    outgoing_connections: typing.Optional[winsdk.windows.foundation.collections.IVectorView[AudioGraphConnection]]
    emitter: typing.Optional[AudioNodeEmitter]
    outgoing_gain: winsdk.system.Double
    consume_input: winsdk.system.Boolean
    effect_definitions: typing.Optional[winsdk.windows.foundation.collections.IVector[winsdk.windows.media.effects.IAudioEffectDefinition]]
    encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.AudioEncodingProperties]
    start_time: typing.Optional[typing.Optional[datetime.timedelta]]
    playback_speed_factor: winsdk.system.Double
    loop_count: typing.Optional[typing.Optional[winsdk.system.Int32]]
    end_time: typing.Optional[typing.Optional[datetime.timedelta]]
    duration: datetime.timedelta
    media_source: typing.Optional[winsdk.windows.media.core.MediaSource]
    position: datetime.timedelta
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MediaSourceAudioInputNode: ...
    @typing.overload
    def add_outgoing_connection(self, destination: typing.Optional[IAudioNode]) -> None: ...
    @typing.overload
    def add_outgoing_connection(self, destination: typing.Optional[IAudioNode], gain: winsdk.system.Double) -> None: ...
    def close(self) -> None: ...
    def disable_effects_by_definition(self, definition: typing.Optional[winsdk.windows.media.effects.IAudioEffectDefinition]) -> None: ...
    def enable_effects_by_definition(self, definition: typing.Optional[winsdk.windows.media.effects.IAudioEffectDefinition]) -> None: ...
    def remove_outgoing_connection(self, destination: typing.Optional[IAudioNode]) -> None: ...
    def reset(self) -> None: ...
    def seek(self, position: datetime.timedelta) -> None: ...
    def start(self) -> None: ...
    def stop(self) -> None: ...
    def add_media_source_completed(self, handler: winsdk.windows.foundation.TypedEventHandler[MediaSourceAudioInputNode, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_media_source_completed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class ReverbEffectDefinition(winsdk.system.Object):
    high_e_q_gain: winsdk.system.UInt8
    high_e_q_cutoff: winsdk.system.UInt8
    disable_late_field: winsdk.system.Boolean
    density: winsdk.system.Double
    position_right: winsdk.system.UInt8
    decay_time: winsdk.system.Double
    late_diffusion: winsdk.system.UInt8
    position_matrix_right: winsdk.system.UInt8
    position_matrix_left: winsdk.system.UInt8
    position_left: winsdk.system.UInt8
    low_e_q_gain: winsdk.system.UInt8
    low_e_q_cutoff: winsdk.system.UInt8
    room_filter_freq: winsdk.system.Double
    reverb_gain: winsdk.system.Double
    reverb_delay: winsdk.system.UInt8
    reflections_gain: winsdk.system.Double
    reflections_delay: winsdk.system.UInt32
    rear_delay: winsdk.system.UInt8
    wet_dry_mix: winsdk.system.Double
    early_diffusion: winsdk.system.UInt8
    room_size: winsdk.system.Double
    room_filter_main: winsdk.system.Double
    room_filter_h_f: winsdk.system.Double
    activatable_class_id: str
    properties: typing.Optional[winsdk.windows.foundation.collections.IPropertySet]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ReverbEffectDefinition: ...
    def __new__(cls: typing.Type[ReverbEffectDefinition], audio_graph: typing.Optional[AudioGraph]) -> ReverbEffectDefinition:...

class SetDefaultSpatialAudioFormatResult(winsdk.system.Object):
    status: SetDefaultSpatialAudioFormatStatus
    @staticmethod
    def _from(obj: winsdk.system.Object) -> SetDefaultSpatialAudioFormatResult: ...

class SpatialAudioDeviceConfiguration(winsdk.system.Object):
    active_spatial_audio_format: str
    default_spatial_audio_format: str
    device_id: str
    is_spatial_audio_supported: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> SpatialAudioDeviceConfiguration: ...
    @staticmethod
    def get_for_device_id(device_id: str) -> typing.Optional[SpatialAudioDeviceConfiguration]: ...
    def is_spatial_audio_format_supported(self, subtype: str) -> winsdk.system.Boolean: ...
    def set_default_spatial_audio_format_async(self, subtype: str) -> winsdk.windows.foundation.IAsyncOperation[SetDefaultSpatialAudioFormatResult]: ...
    def add_configuration_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[SpatialAudioDeviceConfiguration, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_configuration_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class SpatialAudioFormatConfiguration(winsdk.system.Object):
    mixed_reality_exclusive_mode_policy: MixedRealitySpatialAudioFormatPolicy
    @staticmethod
    def _from(obj: winsdk.system.Object) -> SpatialAudioFormatConfiguration: ...
    @staticmethod
    def get_default() -> typing.Optional[SpatialAudioFormatConfiguration]: ...
    def report_configuration_changed_async(self, subtype: str) -> winsdk.windows.foundation.IAsyncAction: ...
    def report_license_changed_async(self, subtype: str) -> winsdk.windows.foundation.IAsyncAction: ...

class SpatialAudioFormatSubtype(winsdk.system.Object):
    d_t_s_headphone_x: typing.ClassVar[str]
    d_t_s_x_ultra: typing.ClassVar[str]
    dolby_atmos_for_headphones: typing.ClassVar[str]
    dolby_atmos_for_home_theater: typing.ClassVar[str]
    dolby_atmos_for_speakers: typing.ClassVar[str]
    windows_sonic: typing.ClassVar[str]
    d_t_s_x_for_home_theater: typing.ClassVar[str]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> SpatialAudioFormatSubtype: ...

class IAudioInputNode(winsdk.system.Object):
    outgoing_connections: typing.Optional[winsdk.windows.foundation.collections.IVectorView[AudioGraphConnection]]
    consume_input: winsdk.system.Boolean
    effect_definitions: typing.Optional[winsdk.windows.foundation.collections.IVector[winsdk.windows.media.effects.IAudioEffectDefinition]]
    encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.AudioEncodingProperties]
    outgoing_gain: winsdk.system.Double
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> IAudioInputNode: ...
    @typing.overload
    def add_outgoing_connection(self, destination: typing.Optional[IAudioNode]) -> None: ...
    @typing.overload
    def add_outgoing_connection(self, destination: typing.Optional[IAudioNode], gain: winsdk.system.Double) -> None: ...
    def close(self) -> None: ...
    def disable_effects_by_definition(self, definition: typing.Optional[winsdk.windows.media.effects.IAudioEffectDefinition]) -> None: ...
    def enable_effects_by_definition(self, definition: typing.Optional[winsdk.windows.media.effects.IAudioEffectDefinition]) -> None: ...
    def remove_outgoing_connection(self, destination: typing.Optional[IAudioNode]) -> None: ...
    def reset(self) -> None: ...
    def start(self) -> None: ...
    def stop(self) -> None: ...

class IAudioInputNode2(winsdk.system.Object):
    emitter: typing.Optional[AudioNodeEmitter]
    consume_input: winsdk.system.Boolean
    effect_definitions: typing.Optional[winsdk.windows.foundation.collections.IVector[winsdk.windows.media.effects.IAudioEffectDefinition]]
    encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.AudioEncodingProperties]
    outgoing_gain: winsdk.system.Double
    outgoing_connections: typing.Optional[winsdk.windows.foundation.collections.IVectorView[AudioGraphConnection]]
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> IAudioInputNode2: ...
    @typing.overload
    def add_outgoing_connection(self, destination: typing.Optional[IAudioNode]) -> None: ...
    @typing.overload
    def add_outgoing_connection(self, destination: typing.Optional[IAudioNode], gain: winsdk.system.Double) -> None: ...
    def close(self) -> None: ...
    def disable_effects_by_definition(self, definition: typing.Optional[winsdk.windows.media.effects.IAudioEffectDefinition]) -> None: ...
    def enable_effects_by_definition(self, definition: typing.Optional[winsdk.windows.media.effects.IAudioEffectDefinition]) -> None: ...
    def remove_outgoing_connection(self, destination: typing.Optional[IAudioNode]) -> None: ...
    def reset(self) -> None: ...
    def start(self) -> None: ...
    def stop(self) -> None: ...

class IAudioNode(winsdk.system.Object):
    consume_input: winsdk.system.Boolean
    effect_definitions: typing.Optional[winsdk.windows.foundation.collections.IVector[winsdk.windows.media.effects.IAudioEffectDefinition]]
    encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.AudioEncodingProperties]
    outgoing_gain: winsdk.system.Double
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> IAudioNode: ...
    def close(self) -> None: ...
    def disable_effects_by_definition(self, definition: typing.Optional[winsdk.windows.media.effects.IAudioEffectDefinition]) -> None: ...
    def enable_effects_by_definition(self, definition: typing.Optional[winsdk.windows.media.effects.IAudioEffectDefinition]) -> None: ...
    def reset(self) -> None: ...
    def start(self) -> None: ...
    def stop(self) -> None: ...

class IAudioNodeWithListener(winsdk.system.Object):
    listener: typing.Optional[AudioNodeListener]
    consume_input: winsdk.system.Boolean
    effect_definitions: typing.Optional[winsdk.windows.foundation.collections.IVector[winsdk.windows.media.effects.IAudioEffectDefinition]]
    encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.AudioEncodingProperties]
    outgoing_gain: winsdk.system.Double
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> IAudioNodeWithListener: ...
    def close(self) -> None: ...
    def disable_effects_by_definition(self, definition: typing.Optional[winsdk.windows.media.effects.IAudioEffectDefinition]) -> None: ...
    def enable_effects_by_definition(self, definition: typing.Optional[winsdk.windows.media.effects.IAudioEffectDefinition]) -> None: ...
    def reset(self) -> None: ...
    def start(self) -> None: ...
    def stop(self) -> None: ...

