# WARNING: Please don't edit this file. It was generated by Python/WinRT v1.0.0-beta.8

import enum
import datetime
import sys
import types
import typing

import winsdk.system
import winsdk.windows.applicationmodel
import winsdk.windows.foundation
import winsdk.windows.foundation.collections
import winsdk.windows.storage

class GameListCategory(enum.IntEnum):
    CANDIDATE = 0
    CONFIRMED_BY_SYSTEM = 1
    CONFIRMED_BY_USER = 2

class GameListEntryLaunchableState(enum.IntEnum):
    NOT_LAUNCHABLE = 0
    BY_LAST_RUNNING_FULL_PATH = 1
    BY_USER_PROVIDED_PATH = 2
    BY_TILE = 3

Self = typing.TypeVar('Self')

class GameList(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> GameList: ...
    @typing.overload
    @staticmethod
    def find_all_async() -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[GameListEntry]]: ...
    @typing.overload
    @staticmethod
    def find_all_async(package_family_name: str) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[GameListEntry]]: ...
    @staticmethod
    def merge_entries_async(left: typing.Optional[GameListEntry], right: typing.Optional[GameListEntry]) -> winsdk.windows.foundation.IAsyncOperation[GameListEntry]: ...
    @staticmethod
    def unmerge_entry_async(merged_entry: typing.Optional[GameListEntry]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[GameListEntry]]: ...
    @staticmethod
    def add_game_added(handler: typing.Optional[GameListChangedEventHandler]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @staticmethod
    def remove_game_added(token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    @staticmethod
    def add_game_removed(handler: typing.Optional[GameListRemovedEventHandler]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @staticmethod
    def remove_game_removed(token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    @staticmethod
    def add_game_updated(handler: typing.Optional[GameListChangedEventHandler]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @staticmethod
    def remove_game_updated(token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class GameListEntry(winsdk.system.Object):
    category: GameListCategory
    display_info: typing.Optional[winsdk.windows.applicationmodel.AppDisplayInfo]
    properties: typing.Optional[winsdk.windows.foundation.collections.IMapView[str, winsdk.system.Object]]
    game_mode_configuration: typing.Optional[GameModeConfiguration]
    launch_parameters: str
    launchable_state: GameListEntryLaunchableState
    launcher_executable: typing.Optional[winsdk.windows.storage.IStorageFile]
    title_id: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> GameListEntry: ...
    def launch_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def set_category_async(self, value: GameListCategory) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def set_launcher_executable_file_async(self, executable_file: typing.Optional[winsdk.windows.storage.IStorageFile]) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def set_launcher_executable_file_async(self, executable_file: typing.Optional[winsdk.windows.storage.IStorageFile], launch_params: str) -> winsdk.windows.foundation.IAsyncAction: ...
    def set_title_id_async(self, id: str) -> winsdk.windows.foundation.IAsyncAction: ...

class GameModeConfiguration(winsdk.system.Object):
    percent_gpu_time_allocated_to_game: typing.Optional[typing.Optional[winsdk.system.Int32]]
    percent_gpu_memory_allocated_to_system_compositor: typing.Optional[typing.Optional[winsdk.system.Int32]]
    percent_gpu_memory_allocated_to_game: typing.Optional[typing.Optional[winsdk.system.Int32]]
    max_cpu_count: typing.Optional[typing.Optional[winsdk.system.Int32]]
    is_enabled: winsdk.system.Boolean
    cpu_exclusivity_mask_low: typing.Optional[typing.Optional[winsdk.system.Int32]]
    cpu_exclusivity_mask_high: typing.Optional[typing.Optional[winsdk.system.Int32]]
    affinitize_to_exclusive_cpus: winsdk.system.Boolean
    related_process_names: typing.Optional[winsdk.windows.foundation.collections.IVector[str]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> GameModeConfiguration: ...
    def save_async(self) -> winsdk.windows.foundation.IAsyncAction: ...

class GameModeUserConfiguration(winsdk.system.Object):
    gaming_related_process_names: typing.Optional[winsdk.windows.foundation.collections.IVector[str]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> GameModeUserConfiguration: ...
    @staticmethod
    def get_default() -> typing.Optional[GameModeUserConfiguration]: ...
    def save_async(self) -> winsdk.windows.foundation.IAsyncAction: ...

class IGameListEntry(winsdk.system.Object):
    category: GameListCategory
    display_info: typing.Optional[winsdk.windows.applicationmodel.AppDisplayInfo]
    properties: typing.Optional[winsdk.windows.foundation.collections.IMapView[str, winsdk.system.Object]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> IGameListEntry: ...
    def launch_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def set_category_async(self, value: GameListCategory) -> winsdk.windows.foundation.IAsyncAction: ...

GameListChangedEventHandler = typing.Callable[[typing.Optional[GameListEntry]], None]

GameListRemovedEventHandler = typing.Callable[[str], None]

