# WARNING: Please don't edit this file. It was generated by Python/WinRT v1.0.0-beta.8

import enum
import datetime
import sys
import types
import typing

import winsdk.system
import winsdk.windows.data.text
import winsdk.windows.foundation
import winsdk.windows.foundation.collections
import winsdk.windows.storage.streams
import winsdk.windows.system
import winsdk.windows.ui
import winsdk.windows.ui.popups
import winsdk.windows.ui.viewmanagement

class ContactAddressKind(enum.IntEnum):
    HOME = 0
    WORK = 1
    OTHER = 2

class ContactAnnotationOperations(enum.IntFlag):
    NONE = 0
    CONTACT_PROFILE = 0x1
    MESSAGE = 0x2
    AUDIO_CALL = 0x4
    VIDEO_CALL = 0x8
    SOCIAL_FEEDS = 0x10
    SHARE = 0x20

class ContactAnnotationStoreAccessType(enum.IntEnum):
    APP_ANNOTATIONS_READ_WRITE = 0
    ALL_ANNOTATIONS_READ_WRITE = 1

class ContactBatchStatus(enum.IntEnum):
    SUCCESS = 0
    SERVER_SEARCH_SYNC_MANAGER_ERROR = 1
    SERVER_SEARCH_UNKNOWN_ERROR = 2

class ContactCardHeaderKind(enum.IntEnum):
    DEFAULT = 0
    BASIC = 1
    ENTERPRISE = 2

class ContactCardTabKind(enum.IntEnum):
    DEFAULT = 0
    EMAIL = 1
    MESSAGING = 2
    PHONE = 3
    VIDEO = 4
    ORGANIZATIONAL_HIERARCHY = 5

class ContactChangeType(enum.IntEnum):
    CREATED = 0
    MODIFIED = 1
    DELETED = 2
    CHANGE_TRACKING_LOST = 3

class ContactDateKind(enum.IntEnum):
    BIRTHDAY = 0
    ANNIVERSARY = 1
    OTHER = 2

class ContactEmailKind(enum.IntEnum):
    PERSONAL = 0
    WORK = 1
    OTHER = 2

class ContactFieldCategory(enum.IntEnum):
    NONE = 0
    HOME = 1
    WORK = 2
    MOBILE = 3
    OTHER = 4

class ContactFieldType(enum.IntEnum):
    EMAIL = 0
    PHONE_NUMBER = 1
    LOCATION = 2
    INSTANT_MESSAGE = 3
    CUSTOM = 4
    CONNECTED_SERVICE_ACCOUNT = 5
    IMPORTANT_DATE = 6
    ADDRESS = 7
    SIGNIFICANT_OTHER = 8
    NOTES = 9
    WEBSITE = 10
    JOB_INFO = 11

class ContactListOtherAppReadAccess(enum.IntEnum):
    SYSTEM_ONLY = 0
    LIMITED = 1
    FULL = 2
    NONE = 3

class ContactListOtherAppWriteAccess(enum.IntEnum):
    NONE = 0
    SYSTEM_ONLY = 1
    LIMITED = 2

class ContactListSyncStatus(enum.IntEnum):
    IDLE = 0
    SYNCING = 1
    UP_TO_DATE = 2
    AUTHENTICATION_ERROR = 3
    POLICY_ERROR = 4
    UNKNOWN_ERROR = 5
    MANUAL_ACCOUNT_REMOVAL_REQUIRED = 6

class ContactMatchReasonKind(enum.IntEnum):
    NAME = 0
    EMAIL_ADDRESS = 1
    PHONE_NUMBER = 2
    JOB_INFO = 3
    YOMI_NAME = 4
    OTHER = 5

class ContactNameOrder(enum.IntEnum):
    FIRST_NAME_LAST_NAME = 0
    LAST_NAME_FIRST_NAME = 1

class ContactPhoneKind(enum.IntEnum):
    HOME = 0
    MOBILE = 1
    WORK = 2
    OTHER = 3
    PAGER = 4
    BUSINESS_FAX = 5
    HOME_FAX = 6
    COMPANY = 7
    ASSISTANT = 8
    RADIO = 9

class ContactQueryDesiredFields(enum.IntFlag):
    NONE = 0
    PHONE_NUMBER = 0x1
    EMAIL_ADDRESS = 0x2
    POSTAL_ADDRESS = 0x4

class ContactQuerySearchFields(enum.IntFlag):
    NONE = 0
    NAME = 0x1
    EMAIL = 0x2
    PHONE = 0x4
    ALL = 0xffffffff

class ContactQuerySearchScope(enum.IntEnum):
    LOCAL = 0
    SERVER = 1

class ContactRelationship(enum.IntEnum):
    OTHER = 0
    SPOUSE = 1
    PARTNER = 2
    SIBLING = 3
    PARENT = 4
    CHILD = 5

class ContactSelectionMode(enum.IntEnum):
    CONTACTS = 0
    FIELDS = 1

class ContactStoreAccessType(enum.IntEnum):
    APP_CONTACTS_READ_WRITE = 0
    ALL_CONTACTS_READ_ONLY = 1
    ALL_CONTACTS_READ_WRITE = 2

class PinnedContactSurface(enum.IntEnum):
    START_MENU = 0
    TASKBAR = 1

Self = typing.TypeVar('Self')

class AggregateContactManager(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> AggregateContactManager: ...
    def find_raw_contacts_async(self, contact: typing.Optional[Contact]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[Contact]]: ...
    def set_remote_identification_information_async(self, contact_list_id: str, remote_source_id: str, account_id: str) -> winsdk.windows.foundation.IAsyncAction: ...
    def try_link_contacts_async(self, primary_contact: typing.Optional[Contact], secondary_contact: typing.Optional[Contact]) -> winsdk.windows.foundation.IAsyncOperation[Contact]: ...
    def try_set_preferred_source_for_picture_async(self, aggregate_contact: typing.Optional[Contact], raw_contact: typing.Optional[Contact]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def unlink_raw_contact_async(self, contact: typing.Optional[Contact]) -> winsdk.windows.foundation.IAsyncAction: ...

class Contact(winsdk.system.Object):
    thumbnail: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStreamReference]
    name: str
    fields: typing.Optional[winsdk.windows.foundation.collections.IVector[IContactField]]
    id: str
    notes: str
    connected_service_accounts: typing.Optional[winsdk.windows.foundation.collections.IVector[ContactConnectedServiceAccount]]
    emails: typing.Optional[winsdk.windows.foundation.collections.IVector[ContactEmail]]
    addresses: typing.Optional[winsdk.windows.foundation.collections.IVector[ContactAddress]]
    important_dates: typing.Optional[winsdk.windows.foundation.collections.IVector[ContactDate]]
    job_info: typing.Optional[winsdk.windows.foundation.collections.IVector[ContactJobInfo]]
    data_suppliers: typing.Optional[winsdk.windows.foundation.collections.IVector[str]]
    phones: typing.Optional[winsdk.windows.foundation.collections.IVector[ContactPhone]]
    provider_properties: typing.Optional[winsdk.windows.foundation.collections.IPropertySet]
    significant_others: typing.Optional[winsdk.windows.foundation.collections.IVector[ContactSignificantOther]]
    websites: typing.Optional[winsdk.windows.foundation.collections.IVector[ContactWebsite]]
    source_display_picture: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStreamReference]
    text_tone_token: str
    display_name_override: str
    display_picture_user_update_time: datetime.datetime
    nickname: str
    remote_id: str
    ring_tone_token: str
    contact_list_id: str
    large_display_picture: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStreamReference]
    small_display_picture: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStreamReference]
    sort_name: str
    aggregate_id: str
    full_name: str
    is_aggregate: winsdk.system.Boolean
    is_display_picture_manually_set: winsdk.system.Boolean
    is_me: winsdk.system.Boolean
    yomi_given_name: str
    honorific_name_suffix: str
    yomi_family_name: str
    middle_name: str
    last_name: str
    honorific_name_prefix: str
    first_name: str
    display_name: str
    yomi_display_name: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> Contact: ...
    def __new__(cls: typing.Type[Contact]) -> Contact:...

class ContactAddress(winsdk.system.Object):
    street_address: str
    region: str
    postal_code: str
    locality: str
    kind: ContactAddressKind
    description: str
    country: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactAddress: ...
    def __new__(cls: typing.Type[ContactAddress]) -> ContactAddress:...

class ContactAnnotation(winsdk.system.Object):
    supported_operations: ContactAnnotationOperations
    remote_id: str
    contact_id: str
    annotation_list_id: str
    id: str
    is_disabled: winsdk.system.Boolean
    provider_properties: typing.Optional[winsdk.windows.foundation.collections.ValueSet]
    contact_list_id: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactAnnotation: ...
    def __new__(cls: typing.Type[ContactAnnotation]) -> ContactAnnotation:...

class ContactAnnotationList(winsdk.system.Object):
    id: str
    provider_package_family_name: str
    user_data_account_id: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactAnnotationList: ...
    def delete_annotation_async(self, annotation: typing.Optional[ContactAnnotation]) -> winsdk.windows.foundation.IAsyncAction: ...
    def delete_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    def find_annotations_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[ContactAnnotation]]: ...
    def find_annotations_by_remote_id_async(self, remote_id: str) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[ContactAnnotation]]: ...
    def get_annotation_async(self, annotation_id: str) -> winsdk.windows.foundation.IAsyncOperation[ContactAnnotation]: ...
    def try_save_annotation_async(self, annotation: typing.Optional[ContactAnnotation]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...

class ContactAnnotationStore(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactAnnotationStore: ...
    @typing.overload
    def create_annotation_list_async(self) -> winsdk.windows.foundation.IAsyncOperation[ContactAnnotationList]: ...
    @typing.overload
    def create_annotation_list_async(self, user_data_account_id: str) -> winsdk.windows.foundation.IAsyncOperation[ContactAnnotationList]: ...
    def disable_annotation_async(self, annotation: typing.Optional[ContactAnnotation]) -> winsdk.windows.foundation.IAsyncAction: ...
    def find_annotation_lists_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[ContactAnnotationList]]: ...
    def find_annotations_for_contact_async(self, contact: typing.Optional[Contact]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[ContactAnnotation]]: ...
    def find_annotations_for_contact_list_async(self, contact_list_id: str) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[ContactAnnotation]]: ...
    def find_contact_ids_by_email_async(self, email_address: str) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[str]]: ...
    def find_contact_ids_by_phone_number_async(self, phone_number: str) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[str]]: ...
    def get_annotation_list_async(self, annotation_list_id: str) -> winsdk.windows.foundation.IAsyncOperation[ContactAnnotationList]: ...

class ContactBatch(winsdk.system.Object):
    contacts: typing.Optional[winsdk.windows.foundation.collections.IVectorView[Contact]]
    status: ContactBatchStatus
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactBatch: ...

class ContactCardDelayedDataLoader(winsdk.system.Object):
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactCardDelayedDataLoader: ...
    def close(self) -> None: ...
    def set_data(self, contact: typing.Optional[Contact]) -> None: ...

class ContactCardOptions(winsdk.system.Object):
    initial_tab_kind: ContactCardTabKind
    header_kind: ContactCardHeaderKind
    server_search_contact_list_ids: typing.Optional[winsdk.windows.foundation.collections.IVector[str]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactCardOptions: ...
    def __new__(cls: typing.Type[ContactCardOptions]) -> ContactCardOptions:...

class ContactChange(winsdk.system.Object):
    change_type: ContactChangeType
    contact: typing.Optional[Contact]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactChange: ...

class ContactChangeReader(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactChangeReader: ...
    def accept_changes(self) -> None: ...
    def accept_changes_through(self, last_change_to_accept: typing.Optional[ContactChange]) -> None: ...
    def read_batch_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[ContactChange]]: ...

class ContactChangeTracker(winsdk.system.Object):
    is_tracking: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactChangeTracker: ...
    def enable(self) -> None: ...
    def get_change_reader(self) -> typing.Optional[ContactChangeReader]: ...
    def reset(self) -> None: ...

class ContactChangedDeferral(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactChangedDeferral: ...
    def complete(self) -> None: ...

class ContactChangedEventArgs(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactChangedEventArgs: ...
    def get_deferral(self) -> typing.Optional[ContactChangedDeferral]: ...

class ContactConnectedServiceAccount(winsdk.system.Object):
    service_name: str
    id: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactConnectedServiceAccount: ...
    def __new__(cls: typing.Type[ContactConnectedServiceAccount]) -> ContactConnectedServiceAccount:...

class ContactDate(winsdk.system.Object):
    year: typing.Optional[typing.Optional[winsdk.system.Int32]]
    month: typing.Optional[typing.Optional[winsdk.system.UInt32]]
    kind: ContactDateKind
    description: str
    day: typing.Optional[typing.Optional[winsdk.system.UInt32]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactDate: ...
    def __new__(cls: typing.Type[ContactDate]) -> ContactDate:...

class ContactEmail(winsdk.system.Object):
    kind: ContactEmailKind
    description: str
    address: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactEmail: ...
    def __new__(cls: typing.Type[ContactEmail]) -> ContactEmail:...

class ContactField(winsdk.system.Object):
    category: ContactFieldCategory
    name: str
    type: ContactFieldType
    value: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactField: ...
    @typing.overload
    def __new__(cls: typing.Type[ContactField], value: str, type: ContactFieldType) -> ContactField:...
    @typing.overload
    def __new__(cls: typing.Type[ContactField], value: str, type: ContactFieldType, category: ContactFieldCategory) -> ContactField:...
    @typing.overload
    def __new__(cls: typing.Type[ContactField], name: str, value: str, type: ContactFieldType, category: ContactFieldCategory) -> ContactField:...

class ContactFieldFactory(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactFieldFactory: ...
    def __new__(cls: typing.Type[ContactFieldFactory]) -> ContactFieldFactory:...
    @typing.overload
    def create_field(self, value: str, type: ContactFieldType) -> typing.Optional[ContactField]: ...
    @typing.overload
    def create_field(self, value: str, type: ContactFieldType, category: ContactFieldCategory) -> typing.Optional[ContactField]: ...
    @typing.overload
    def create_field(self, name: str, value: str, type: ContactFieldType, category: ContactFieldCategory) -> typing.Optional[ContactField]: ...
    @typing.overload
    def create_instant_message(self, user_name: str) -> typing.Optional[ContactInstantMessageField]: ...
    @typing.overload
    def create_instant_message(self, user_name: str, category: ContactFieldCategory) -> typing.Optional[ContactInstantMessageField]: ...
    @typing.overload
    def create_instant_message(self, user_name: str, category: ContactFieldCategory, service: str, display_text: str, verb: typing.Optional[winsdk.windows.foundation.Uri]) -> typing.Optional[ContactInstantMessageField]: ...
    @typing.overload
    def create_location(self, unstructured_address: str) -> typing.Optional[ContactLocationField]: ...
    @typing.overload
    def create_location(self, unstructured_address: str, category: ContactFieldCategory) -> typing.Optional[ContactLocationField]: ...
    @typing.overload
    def create_location(self, unstructured_address: str, category: ContactFieldCategory, street: str, city: str, region: str, country: str, postal_code: str) -> typing.Optional[ContactLocationField]: ...

class ContactGroup(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactGroup: ...

class ContactInformation(winsdk.system.Object):
    custom_fields: typing.Optional[winsdk.windows.foundation.collections.IVectorView[ContactField]]
    emails: typing.Optional[winsdk.windows.foundation.collections.IVectorView[ContactField]]
    instant_messages: typing.Optional[winsdk.windows.foundation.collections.IVectorView[ContactInstantMessageField]]
    locations: typing.Optional[winsdk.windows.foundation.collections.IVectorView[ContactLocationField]]
    name: str
    phone_numbers: typing.Optional[winsdk.windows.foundation.collections.IVectorView[ContactField]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactInformation: ...
    def get_thumbnail_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IRandomAccessStreamWithContentType]: ...
    def query_custom_fields(self, custom_name: str) -> typing.Optional[winsdk.windows.foundation.collections.IVectorView[ContactField]]: ...

class ContactInstantMessageField(winsdk.system.Object):
    category: ContactFieldCategory
    name: str
    type: ContactFieldType
    value: str
    display_text: str
    launch_uri: typing.Optional[winsdk.windows.foundation.Uri]
    service: str
    user_name: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactInstantMessageField: ...
    @typing.overload
    def __new__(cls: typing.Type[ContactInstantMessageField], user_name: str) -> ContactInstantMessageField:...
    @typing.overload
    def __new__(cls: typing.Type[ContactInstantMessageField], user_name: str, category: ContactFieldCategory) -> ContactInstantMessageField:...
    @typing.overload
    def __new__(cls: typing.Type[ContactInstantMessageField], user_name: str, category: ContactFieldCategory, service: str, display_text: str, verb: typing.Optional[winsdk.windows.foundation.Uri]) -> ContactInstantMessageField:...

class ContactJobInfo(winsdk.system.Object):
    title: str
    office: str
    manager: str
    description: str
    department: str
    company_yomi_name: str
    company_name: str
    company_address: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactJobInfo: ...
    def __new__(cls: typing.Type[ContactJobInfo]) -> ContactJobInfo:...

class ContactLaunchActionVerbs(winsdk.system.Object):
    call: typing.ClassVar[str]
    map: typing.ClassVar[str]
    message: typing.ClassVar[str]
    post: typing.ClassVar[str]
    video_call: typing.ClassVar[str]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactLaunchActionVerbs: ...

class ContactList(winsdk.system.Object):
    supports_server_search: winsdk.system.Boolean
    is_hidden: winsdk.system.Boolean
    other_app_write_access: ContactListOtherAppWriteAccess
    display_name: str
    other_app_read_access: ContactListOtherAppReadAccess
    change_tracker: typing.Optional[ContactChangeTracker]
    source_display_name: str
    id: str
    sync_manager: typing.Optional[ContactListSyncManager]
    user_data_account_id: str
    sync_constraints: typing.Optional[ContactListSyncConstraints]
    limited_write_operations: typing.Optional[ContactListLimitedWriteOperations]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactList: ...
    def delete_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    def delete_contact_async(self, contact: typing.Optional[Contact]) -> winsdk.windows.foundation.IAsyncAction: ...
    def get_change_tracker(self, identity: str) -> typing.Optional[ContactChangeTracker]: ...
    def get_contact_async(self, contact_id: str) -> winsdk.windows.foundation.IAsyncOperation[Contact]: ...
    def get_contact_from_remote_id_async(self, remote_id: str) -> winsdk.windows.foundation.IAsyncOperation[Contact]: ...
    @typing.overload
    def get_contact_reader(self) -> typing.Optional[ContactReader]: ...
    @typing.overload
    def get_contact_reader(self, options: typing.Optional[ContactQueryOptions]) -> typing.Optional[ContactReader]: ...
    def get_me_contact_async(self) -> winsdk.windows.foundation.IAsyncOperation[Contact]: ...
    def register_sync_manager_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    def save_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    def save_contact_async(self, contact: typing.Optional[Contact]) -> winsdk.windows.foundation.IAsyncAction: ...
    def add_contact_changed(self, value: winsdk.windows.foundation.TypedEventHandler[ContactList, ContactChangedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_contact_changed(self, value: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class ContactListLimitedWriteOperations(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactListLimitedWriteOperations: ...
    def try_create_or_update_contact_async(self, contact: typing.Optional[Contact]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def try_delete_contact_async(self, contact_id: str) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...

class ContactListSyncConstraints(winsdk.system.Object):
    can_sync_descriptions: winsdk.system.Boolean
    max_company_phone_numbers: typing.Optional[typing.Optional[winsdk.system.Int32]]
    max_child_relationships: typing.Optional[typing.Optional[winsdk.system.Int32]]
    max_business_fax_phone_numbers: typing.Optional[typing.Optional[winsdk.system.Int32]]
    max_birthday_dates: typing.Optional[typing.Optional[winsdk.system.Int32]]
    max_assistant_phone_numbers: typing.Optional[typing.Optional[winsdk.system.Int32]]
    max_other_addresses: typing.Optional[typing.Optional[winsdk.system.Int32]]
    max_anniversary_dates: typing.Optional[typing.Optional[winsdk.system.Int32]]
    max_home_addresses: typing.Optional[typing.Optional[winsdk.system.Int32]]
    max_other_dates: typing.Optional[typing.Optional[winsdk.system.Int32]]
    max_mobile_phone_numbers: typing.Optional[typing.Optional[winsdk.system.Int32]]
    max_job_info: typing.Optional[typing.Optional[winsdk.system.Int32]]
    max_home_phone_numbers: typing.Optional[typing.Optional[winsdk.system.Int32]]
    max_home_fax_phone_numbers: typing.Optional[typing.Optional[winsdk.system.Int32]]
    max_other_email_addresses: typing.Optional[typing.Optional[winsdk.system.Int32]]
    max_personal_email_addresses: typing.Optional[typing.Optional[winsdk.system.Int32]]
    max_partner_relationships: typing.Optional[typing.Optional[winsdk.system.Int32]]
    max_parent_relationships: typing.Optional[typing.Optional[winsdk.system.Int32]]
    max_pager_phone_numbers: typing.Optional[typing.Optional[winsdk.system.Int32]]
    max_other_relationships: typing.Optional[typing.Optional[winsdk.system.Int32]]
    max_other_phone_numbers: typing.Optional[typing.Optional[winsdk.system.Int32]]
    max_radio_phone_numbers: typing.Optional[typing.Optional[winsdk.system.Int32]]
    max_work_phone_numbers: typing.Optional[typing.Optional[winsdk.system.Int32]]
    max_work_email_addresses: typing.Optional[typing.Optional[winsdk.system.Int32]]
    max_work_addresses: typing.Optional[typing.Optional[winsdk.system.Int32]]
    max_websites: typing.Optional[typing.Optional[winsdk.system.Int32]]
    max_spouse_relationships: typing.Optional[typing.Optional[winsdk.system.Int32]]
    max_sibling_relationships: typing.Optional[typing.Optional[winsdk.system.Int32]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactListSyncConstraints: ...

class ContactListSyncManager(winsdk.system.Object):
    status: ContactListSyncStatus
    last_successful_sync_time: datetime.datetime
    last_attempted_sync_time: datetime.datetime
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactListSyncManager: ...
    def sync_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def add_sync_status_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[ContactListSyncManager, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_sync_status_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class ContactLocationField(winsdk.system.Object):
    category: ContactFieldCategory
    name: str
    type: ContactFieldType
    value: str
    city: str
    country: str
    postal_code: str
    region: str
    street: str
    unstructured_address: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactLocationField: ...
    @typing.overload
    def __new__(cls: typing.Type[ContactLocationField], unstructured_address: str) -> ContactLocationField:...
    @typing.overload
    def __new__(cls: typing.Type[ContactLocationField], unstructured_address: str, category: ContactFieldCategory) -> ContactLocationField:...
    @typing.overload
    def __new__(cls: typing.Type[ContactLocationField], unstructured_address: str, category: ContactFieldCategory, street: str, city: str, region: str, country: str, postal_code: str) -> ContactLocationField:...

class ContactManager(winsdk.system.Object):
    system_sort_order: typing.ClassVar[ContactNameOrder]
    system_display_name_order: typing.ClassVar[ContactNameOrder]
    include_middle_name_in_system_display_and_sort: typing.ClassVar[winsdk.system.Boolean]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactManager: ...
    @typing.overload
    @staticmethod
    def convert_contact_to_v_card_async(contact: typing.Optional[Contact]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.RandomAccessStreamReference]: ...
    @typing.overload
    @staticmethod
    def convert_contact_to_v_card_async(contact: typing.Optional[Contact], max_bytes: winsdk.system.UInt32) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.RandomAccessStreamReference]: ...
    @staticmethod
    def convert_v_card_to_contact_async(v_card: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStreamReference]) -> winsdk.windows.foundation.IAsyncOperation[Contact]: ...
    @staticmethod
    def get_for_user(user: typing.Optional[winsdk.windows.system.User]) -> typing.Optional[ContactManagerForUser]: ...
    @staticmethod
    def is_show_contact_card_supported() -> winsdk.system.Boolean: ...
    @staticmethod
    def is_show_delay_loaded_contact_card_supported() -> winsdk.system.Boolean: ...
    @staticmethod
    def is_show_full_contact_card_supported_async() -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    @staticmethod
    def request_annotation_store_async(access_type: ContactAnnotationStoreAccessType) -> winsdk.windows.foundation.IAsyncOperation[ContactAnnotationStore]: ...
    @typing.overload
    @staticmethod
    def request_store_async() -> winsdk.windows.foundation.IAsyncOperation[ContactStore]: ...
    @typing.overload
    @staticmethod
    def request_store_async(access_type: ContactStoreAccessType) -> winsdk.windows.foundation.IAsyncOperation[ContactStore]: ...
    @typing.overload
    @staticmethod
    def show_contact_card(contact: typing.Optional[Contact], selection: winsdk.windows.foundation.Rect) -> None: ...
    @typing.overload
    @staticmethod
    def show_contact_card(contact: typing.Optional[Contact], selection: winsdk.windows.foundation.Rect, preferred_placement: winsdk.windows.ui.popups.Placement) -> None: ...
    @typing.overload
    @staticmethod
    def show_contact_card(contact: typing.Optional[Contact], selection: winsdk.windows.foundation.Rect, preferred_placement: winsdk.windows.ui.popups.Placement, contact_card_options: typing.Optional[ContactCardOptions]) -> None: ...
    @typing.overload
    @staticmethod
    def show_delay_loaded_contact_card(contact: typing.Optional[Contact], selection: winsdk.windows.foundation.Rect, preferred_placement: winsdk.windows.ui.popups.Placement) -> typing.Optional[ContactCardDelayedDataLoader]: ...
    @typing.overload
    @staticmethod
    def show_delay_loaded_contact_card(contact: typing.Optional[Contact], selection: winsdk.windows.foundation.Rect, preferred_placement: winsdk.windows.ui.popups.Placement, contact_card_options: typing.Optional[ContactCardOptions]) -> typing.Optional[ContactCardDelayedDataLoader]: ...
    @staticmethod
    def show_full_contact_card(contact: typing.Optional[Contact], full_contact_card_options: typing.Optional[FullContactCardOptions]) -> None: ...

class ContactManagerForUser(winsdk.system.Object):
    system_sort_order: ContactNameOrder
    system_display_name_order: ContactNameOrder
    user: typing.Optional[winsdk.windows.system.User]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactManagerForUser: ...
    @typing.overload
    def convert_contact_to_v_card_async(self, contact: typing.Optional[Contact]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.RandomAccessStreamReference]: ...
    @typing.overload
    def convert_contact_to_v_card_async(self, contact: typing.Optional[Contact], max_bytes: winsdk.system.UInt32) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.RandomAccessStreamReference]: ...
    def convert_v_card_to_contact_async(self, v_card: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStreamReference]) -> winsdk.windows.foundation.IAsyncOperation[Contact]: ...
    def request_annotation_store_async(self, access_type: ContactAnnotationStoreAccessType) -> winsdk.windows.foundation.IAsyncOperation[ContactAnnotationStore]: ...
    def request_store_async(self, access_type: ContactStoreAccessType) -> winsdk.windows.foundation.IAsyncOperation[ContactStore]: ...
    def show_full_contact_card(self, contact: typing.Optional[Contact], full_contact_card_options: typing.Optional[FullContactCardOptions]) -> None: ...

class ContactMatchReason(winsdk.system.Object):
    field: ContactMatchReasonKind
    segments: typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.windows.data.text.TextSegment]]
    text: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactMatchReason: ...

class ContactPanel(winsdk.system.Object):
    header_color: typing.Optional[typing.Optional[winsdk.windows.ui.Color]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactPanel: ...
    def close_panel(self) -> None: ...
    def add_closing(self, handler: winsdk.windows.foundation.TypedEventHandler[ContactPanel, ContactPanelClosingEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_closing(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_launch_full_app_requested(self, handler: winsdk.windows.foundation.TypedEventHandler[ContactPanel, ContactPanelLaunchFullAppRequestedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_launch_full_app_requested(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class ContactPanelClosingEventArgs(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactPanelClosingEventArgs: ...
    def get_deferral(self) -> typing.Optional[winsdk.windows.foundation.Deferral]: ...

class ContactPanelLaunchFullAppRequestedEventArgs(winsdk.system.Object):
    handled: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactPanelLaunchFullAppRequestedEventArgs: ...

class ContactPhone(winsdk.system.Object):
    number: str
    kind: ContactPhoneKind
    description: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactPhone: ...
    def __new__(cls: typing.Type[ContactPhone]) -> ContactPhone:...

class ContactPicker(winsdk.system.Object):
    selection_mode: ContactSelectionMode
    commit_button_text: str
    desired_fields: typing.Optional[winsdk.windows.foundation.collections.IVector[str]]
    desired_fields_with_contact_field_type: typing.Optional[winsdk.windows.foundation.collections.IVector[ContactFieldType]]
    user: typing.Optional[winsdk.windows.system.User]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactPicker: ...
    def __new__(cls: typing.Type[ContactPicker]) -> ContactPicker:...
    @staticmethod
    def create_for_user(user: typing.Optional[winsdk.windows.system.User]) -> typing.Optional[ContactPicker]: ...
    @staticmethod
    def is_supported_async() -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def pick_contact_async(self) -> winsdk.windows.foundation.IAsyncOperation[Contact]: ...
    def pick_contacts_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVector[Contact]]: ...
    def pick_multiple_contacts_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[ContactInformation]]: ...
    def pick_single_contact_async(self) -> winsdk.windows.foundation.IAsyncOperation[ContactInformation]: ...

class ContactQueryOptions(winsdk.system.Object):
    include_contacts_from_hidden_lists: winsdk.system.Boolean
    desired_operations: ContactAnnotationOperations
    desired_fields: ContactQueryDesiredFields
    annotation_list_ids: typing.Optional[winsdk.windows.foundation.collections.IVector[str]]
    contact_list_ids: typing.Optional[winsdk.windows.foundation.collections.IVector[str]]
    text_search: typing.Optional[ContactQueryTextSearch]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactQueryOptions: ...
    @typing.overload
    def __new__(cls: typing.Type[ContactQueryOptions], text: str) -> ContactQueryOptions:...
    @typing.overload
    def __new__(cls: typing.Type[ContactQueryOptions], text: str, fields: ContactQuerySearchFields) -> ContactQueryOptions:...
    @typing.overload
    def __new__(cls: typing.Type[ContactQueryOptions]) -> ContactQueryOptions:...

class ContactQueryTextSearch(winsdk.system.Object):
    text: str
    search_scope: ContactQuerySearchScope
    fields: ContactQuerySearchFields
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactQueryTextSearch: ...

class ContactReader(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactReader: ...
    def get_matching_properties_with_match_reason(self, contact: typing.Optional[Contact]) -> typing.Optional[winsdk.windows.foundation.collections.IVectorView[ContactMatchReason]]: ...
    def read_batch_async(self) -> winsdk.windows.foundation.IAsyncOperation[ContactBatch]: ...

class ContactSignificantOther(winsdk.system.Object):
    name: str
    description: str
    relationship: ContactRelationship
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactSignificantOther: ...
    def __new__(cls: typing.Type[ContactSignificantOther]) -> ContactSignificantOther:...

class ContactStore(winsdk.system.Object):
    aggregate_contact_manager: typing.Optional[AggregateContactManager]
    change_tracker: typing.Optional[ContactChangeTracker]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactStore: ...
    @typing.overload
    def create_contact_list_async(self, display_name: str) -> winsdk.windows.foundation.IAsyncOperation[ContactList]: ...
    @typing.overload
    def create_contact_list_async(self, display_name: str, user_data_account_id: str) -> winsdk.windows.foundation.IAsyncOperation[ContactList]: ...
    def find_contact_lists_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[ContactList]]: ...
    @typing.overload
    def find_contacts_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[Contact]]: ...
    @typing.overload
    def find_contacts_async(self, search_text: str) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[Contact]]: ...
    def get_change_tracker(self, identity: str) -> typing.Optional[ContactChangeTracker]: ...
    def get_contact_async(self, contact_id: str) -> winsdk.windows.foundation.IAsyncOperation[Contact]: ...
    def get_contact_list_async(self, contact_list_id: str) -> winsdk.windows.foundation.IAsyncOperation[ContactList]: ...
    @typing.overload
    def get_contact_reader(self) -> typing.Optional[ContactReader]: ...
    @typing.overload
    def get_contact_reader(self, options: typing.Optional[ContactQueryOptions]) -> typing.Optional[ContactReader]: ...
    def get_me_contact_async(self) -> winsdk.windows.foundation.IAsyncOperation[Contact]: ...
    def add_contact_changed(self, value: winsdk.windows.foundation.TypedEventHandler[ContactStore, ContactChangedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_contact_changed(self, value: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class ContactStoreNotificationTriggerDetails(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactStoreNotificationTriggerDetails: ...

class ContactWebsite(winsdk.system.Object):
    uri: typing.Optional[winsdk.windows.foundation.Uri]
    description: str
    raw_value: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ContactWebsite: ...
    def __new__(cls: typing.Type[ContactWebsite]) -> ContactWebsite:...

class FullContactCardOptions(winsdk.system.Object):
    desired_remaining_view: winsdk.windows.ui.viewmanagement.ViewSizePreference
    @staticmethod
    def _from(obj: winsdk.system.Object) -> FullContactCardOptions: ...
    def __new__(cls: typing.Type[FullContactCardOptions]) -> FullContactCardOptions:...

class KnownContactField(winsdk.system.Object):
    email: typing.ClassVar[str]
    instant_message: typing.ClassVar[str]
    location: typing.ClassVar[str]
    phone_number: typing.ClassVar[str]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> KnownContactField: ...
    @staticmethod
    def convert_name_to_type(name: str) -> ContactFieldType: ...
    @staticmethod
    def convert_type_to_name(type: ContactFieldType) -> str: ...

class PinnedContactIdsQueryResult(winsdk.system.Object):
    contact_ids: typing.Optional[winsdk.windows.foundation.collections.IVector[str]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> PinnedContactIdsQueryResult: ...

class PinnedContactManager(winsdk.system.Object):
    user: typing.Optional[winsdk.windows.system.User]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> PinnedContactManager: ...
    @staticmethod
    def get_default() -> typing.Optional[PinnedContactManager]: ...
    @staticmethod
    def get_for_user(user: typing.Optional[winsdk.windows.system.User]) -> typing.Optional[PinnedContactManager]: ...
    def get_pinned_contact_ids_async(self) -> winsdk.windows.foundation.IAsyncOperation[PinnedContactIdsQueryResult]: ...
    def is_contact_pinned(self, contact: typing.Optional[Contact], surface: PinnedContactSurface) -> winsdk.system.Boolean: ...
    def is_pin_surface_supported(self, surface: PinnedContactSurface) -> winsdk.system.Boolean: ...
    @staticmethod
    def is_supported() -> winsdk.system.Boolean: ...
    def request_pin_contact_async(self, contact: typing.Optional[Contact], surface: PinnedContactSurface) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def request_pin_contacts_async(self, contacts: typing.Iterable[Contact], surface: PinnedContactSurface) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def request_unpin_contact_async(self, contact: typing.Optional[Contact], surface: PinnedContactSurface) -> winsdk.windows.foundation.IAsyncOperation[winsdk.system.Boolean]: ...
    def signal_contact_activity(self, contact: typing.Optional[Contact]) -> None: ...

class IContactField(winsdk.system.Object):
    category: ContactFieldCategory
    name: str
    type: ContactFieldType
    value: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> IContactField: ...

class IContactFieldFactory(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> IContactFieldFactory: ...
    @typing.overload
    def create_field(self, value: str, type: ContactFieldType) -> typing.Optional[ContactField]: ...
    @typing.overload
    def create_field(self, value: str, type: ContactFieldType, category: ContactFieldCategory) -> typing.Optional[ContactField]: ...
    @typing.overload
    def create_field(self, name: str, value: str, type: ContactFieldType, category: ContactFieldCategory) -> typing.Optional[ContactField]: ...

class IContactInstantMessageFieldFactory(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> IContactInstantMessageFieldFactory: ...
    @typing.overload
    def create_instant_message(self, user_name: str) -> typing.Optional[ContactInstantMessageField]: ...
    @typing.overload
    def create_instant_message(self, user_name: str, category: ContactFieldCategory) -> typing.Optional[ContactInstantMessageField]: ...
    @typing.overload
    def create_instant_message(self, user_name: str, category: ContactFieldCategory, service: str, display_text: str, verb: typing.Optional[winsdk.windows.foundation.Uri]) -> typing.Optional[ContactInstantMessageField]: ...

class IContactLocationFieldFactory(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> IContactLocationFieldFactory: ...
    @typing.overload
    def create_location(self, unstructured_address: str) -> typing.Optional[ContactLocationField]: ...
    @typing.overload
    def create_location(self, unstructured_address: str, category: ContactFieldCategory) -> typing.Optional[ContactLocationField]: ...
    @typing.overload
    def create_location(self, unstructured_address: str, category: ContactFieldCategory, street: str, city: str, region: str, country: str, postal_code: str) -> typing.Optional[ContactLocationField]: ...

