// WARNING: Please don't edit this file. It was generated by Python/WinRT v1.0.0-beta.8

#include "pybase.h"
#include "py.Windows.Devices.Enumeration.Pnp.h"


namespace py::cpp::Windows::Devices::Enumeration::Pnp
{
    struct module_state
    {
        PyObject* type_PnpObjectType;
        PyTypeObject* type_PnpObject;
        PyTypeObject* type_PnpObjectCollection;
        PyTypeObject* type_PnpObjectUpdate;
        PyTypeObject* type_PnpObjectWatcher;
    };

    static PyObject* register_PnpObjectType(PyObject* module, PyObject* type) noexcept
    {
        auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));
        assert(state);

        if (state->type_PnpObjectType)
        {
            PyErr_SetString(PyExc_RuntimeError, "type has already been registered");
            return nullptr;
        }

        if (!PyType_Check(type))
        {
            PyErr_SetString(PyExc_TypeError, "argument is not a type");
            return nullptr;
        }

        state->type_PnpObjectType = type;
        Py_INCREF(state->type_PnpObjectType);


        Py_RETURN_NONE;
    }

    // ----- PnpObject class --------------------
    constexpr const char* const type_name_PnpObject = "PnpObject";

    static PyObject* _new_PnpObject(PyTypeObject* type, PyObject* args, PyObject* kwds) noexcept
    {
        py::set_invalid_activation_error(type_name_PnpObject);
        return nullptr;
    }

    static void _dealloc_PnpObject(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObject* self) noexcept
    {
        auto tp = Py_TYPE(self);

        if (PyType_IS_GC(tp))
        {
            PyObject_GC_UnTrack(self);
        }

        std::destroy_at(&self->obj);
        tp->tp_free(self);
        Py_DECREF(tp);
    }

    static PyObject* PnpObject_CreateFromIdAsync(PyObject* /*unused*/, PyObject* args) noexcept
    {
        auto arg_count = PyTuple_Size(args);

        if (arg_count == 3)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Devices.Enumeration.Pnp.PnpObject", L"CreateFromIdAsync", 3))
            {
                py::set_arg_count_version_error(3);
                return nullptr;
            }

            try
            {
                auto param0 = py::convert_to<winrt::Windows::Devices::Enumeration::Pnp::PnpObjectType>(args, 0);
                auto param1 = py::convert_to<winrt::hstring>(args, 1);
                auto param2 = py::convert_to<winrt::Windows::Foundation::Collections::IIterable<winrt::hstring>>(args, 2);

                return py::convert(winrt::Windows::Devices::Enumeration::Pnp::PnpObject::CreateFromIdAsync(param0, param1, param2));
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* PnpObject_CreateWatcher(PyObject* /*unused*/, PyObject* args) noexcept
    {
        auto arg_count = PyTuple_Size(args);

        if (arg_count == 2)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Devices.Enumeration.Pnp.PnpObject", L"CreateWatcher", 2))
            {
                py::set_arg_count_version_error(2);
                return nullptr;
            }

            try
            {
                auto param0 = py::convert_to<winrt::Windows::Devices::Enumeration::Pnp::PnpObjectType>(args, 0);
                auto param1 = py::convert_to<winrt::Windows::Foundation::Collections::IIterable<winrt::hstring>>(args, 1);

                return py::convert(winrt::Windows::Devices::Enumeration::Pnp::PnpObject::CreateWatcher(param0, param1));
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else if (arg_count == 3)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Devices.Enumeration.Pnp.PnpObject", L"CreateWatcher", 3))
            {
                py::set_arg_count_version_error(3);
                return nullptr;
            }

            try
            {
                auto param0 = py::convert_to<winrt::Windows::Devices::Enumeration::Pnp::PnpObjectType>(args, 0);
                auto param1 = py::convert_to<winrt::Windows::Foundation::Collections::IIterable<winrt::hstring>>(args, 1);
                auto param2 = py::convert_to<winrt::hstring>(args, 2);

                return py::convert(winrt::Windows::Devices::Enumeration::Pnp::PnpObject::CreateWatcher(param0, param1, param2));
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* PnpObject_FindAllAsync(PyObject* /*unused*/, PyObject* args) noexcept
    {
        auto arg_count = PyTuple_Size(args);

        if (arg_count == 2)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Devices.Enumeration.Pnp.PnpObject", L"FindAllAsync", 2))
            {
                py::set_arg_count_version_error(2);
                return nullptr;
            }

            try
            {
                auto param0 = py::convert_to<winrt::Windows::Devices::Enumeration::Pnp::PnpObjectType>(args, 0);
                auto param1 = py::convert_to<winrt::Windows::Foundation::Collections::IIterable<winrt::hstring>>(args, 1);

                return py::convert(winrt::Windows::Devices::Enumeration::Pnp::PnpObject::FindAllAsync(param0, param1));
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else if (arg_count == 3)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Devices.Enumeration.Pnp.PnpObject", L"FindAllAsync", 3))
            {
                py::set_arg_count_version_error(3);
                return nullptr;
            }

            try
            {
                auto param0 = py::convert_to<winrt::Windows::Devices::Enumeration::Pnp::PnpObjectType>(args, 0);
                auto param1 = py::convert_to<winrt::Windows::Foundation::Collections::IIterable<winrt::hstring>>(args, 1);
                auto param2 = py::convert_to<winrt::hstring>(args, 2);

                return py::convert(winrt::Windows::Devices::Enumeration::Pnp::PnpObject::FindAllAsync(param0, param1, param2));
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* PnpObject_Update(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObject* self, PyObject* args) noexcept
    {
        auto arg_count = PyTuple_Size(args);

        if (arg_count == 1)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Devices.Enumeration.Pnp.PnpObject", L"Update", 1))
            {
                py::set_arg_count_version_error(1);
                return nullptr;
            }

            try
            {
                auto param0 = py::convert_to<winrt::Windows::Devices::Enumeration::Pnp::PnpObjectUpdate>(args, 0);

                self->obj.Update(param0);
                Py_RETURN_NONE;
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* PnpObject_get_Id(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObject* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Devices.Enumeration.Pnp.PnpObject", L"Id"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.Id());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* PnpObject_get_Properties(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObject* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Devices.Enumeration.Pnp.PnpObject", L"Properties"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.Properties());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* PnpObject_get_Type(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObject* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Devices.Enumeration.Pnp.PnpObject", L"Type"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.Type());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* _assign_array_PnpObject(PyObject* /*unused*/, PyObject* arg) noexcept
    {
        auto array = std::make_unique<py::ComArray<winrt::Windows::Devices::Enumeration::Pnp::PnpObject>>();
        if (!py::cpp::_winrt::Array_Assign(arg, std::move(array)))
        {
            return nullptr;
        }
        Py_RETURN_NONE;
    }

    static PyObject* _from_PnpObject(PyObject* /*unused*/, PyObject* arg) noexcept
    {
        try
        {
            auto return_value = py::convert_to<winrt::Windows::Foundation::IInspectable>(arg);
            return py::convert(return_value.as<winrt::Windows::Devices::Enumeration::Pnp::PnpObject>());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyMethodDef _methods_PnpObject[] = {
        { "create_from_id_async", reinterpret_cast<PyCFunction>(PnpObject_CreateFromIdAsync), METH_VARARGS | METH_STATIC, nullptr },
        { "create_watcher", reinterpret_cast<PyCFunction>(PnpObject_CreateWatcher), METH_VARARGS | METH_STATIC, nullptr },
        { "find_all_async", reinterpret_cast<PyCFunction>(PnpObject_FindAllAsync), METH_VARARGS | METH_STATIC, nullptr },
        { "update", reinterpret_cast<PyCFunction>(PnpObject_Update), METH_VARARGS, nullptr },
        { "_assign_array_", _assign_array_PnpObject, METH_O | METH_STATIC, nullptr },
        { "_from", reinterpret_cast<PyCFunction>(_from_PnpObject), METH_O | METH_STATIC, nullptr },
        { }
    };

    static PyGetSetDef _getset_PnpObject[] = {
        { "id", reinterpret_cast<getter>(PnpObject_get_Id), nullptr, nullptr, nullptr },
        { "properties", reinterpret_cast<getter>(PnpObject_get_Properties), nullptr, nullptr, nullptr },
        { "type", reinterpret_cast<getter>(PnpObject_get_Type), nullptr, nullptr, nullptr },
        { }
    };

    static PyType_Slot _type_slots_PnpObject[] = 
    {
        { Py_tp_new, _new_PnpObject },
        { Py_tp_dealloc, _dealloc_PnpObject },
        { Py_tp_methods, _methods_PnpObject },
        { Py_tp_getset, _getset_PnpObject },
        { },
    };

    static PyType_Spec type_spec_PnpObject =
    {
        "_winsdk_Windows_Devices_Enumeration_Pnp.PnpObject",
        sizeof(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObject),
        0,
        Py_TPFLAGS_DEFAULT,
        _type_slots_PnpObject
    };

    // ----- PnpObjectCollection class --------------------
    constexpr const char* const type_name_PnpObjectCollection = "PnpObjectCollection";

    static PyObject* _new_PnpObjectCollection(PyTypeObject* type, PyObject* args, PyObject* kwds) noexcept
    {
        py::set_invalid_activation_error(type_name_PnpObjectCollection);
        return nullptr;
    }

    static void _dealloc_PnpObjectCollection(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectCollection* self) noexcept
    {
        auto tp = Py_TYPE(self);

        if (PyType_IS_GC(tp))
        {
            PyObject_GC_UnTrack(self);
        }

        std::destroy_at(&self->obj);
        tp->tp_free(self);
        Py_DECREF(tp);
    }

    static PyObject* PnpObjectCollection_First(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectCollection* self, PyObject* args) noexcept
    {
        auto arg_count = PyTuple_Size(args);

        if (arg_count == 0)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Devices.Enumeration.Pnp.PnpObjectCollection", L"First", 0))
            {
                py::set_arg_count_version_error(0);
                return nullptr;
            }

            try
            {
                return py::convert(self->obj.First());
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* PnpObjectCollection_GetAt(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectCollection* self, PyObject* args) noexcept
    {
        auto arg_count = PyTuple_Size(args);

        if (arg_count == 1)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Devices.Enumeration.Pnp.PnpObjectCollection", L"GetAt", 1))
            {
                py::set_arg_count_version_error(1);
                return nullptr;
            }

            try
            {
                auto param0 = py::convert_to<uint32_t>(args, 0);

                return py::convert(self->obj.GetAt(param0));
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* PnpObjectCollection_GetMany(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectCollection* self, PyObject* args) noexcept
    {
        auto arg_count = PyTuple_Size(args);

        if (arg_count == 2)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Devices.Enumeration.Pnp.PnpObjectCollection", L"GetMany", 1))
            {
                py::set_arg_count_version_error(1);
                return nullptr;
            }

            try
            {
                auto param0 = py::convert_to<uint32_t>(args, 0);
                auto param1 = py::convert_to<py::pybuf_view<winrt::Windows::Devices::Enumeration::Pnp::PnpObject, true>>(args, 1);

                return py::convert(self->obj.GetMany(param0, param1));
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* PnpObjectCollection_IndexOf(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectCollection* self, PyObject* args) noexcept
    {
        auto arg_count = PyTuple_Size(args);

        if (arg_count == 1)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Devices.Enumeration.Pnp.PnpObjectCollection", L"IndexOf", 1))
            {
                py::set_arg_count_version_error(1);
                return nullptr;
            }

            try
            {
                auto param0 = py::convert_to<winrt::Windows::Devices::Enumeration::Pnp::PnpObject>(args, 0);
                uint32_t param1 {  };

                auto return_value = self->obj.IndexOf(param0, param1);

                py::pyobj_handle out_return_value{ py::convert(return_value) };
                if (!out_return_value)
                {
                    return nullptr;
                }
                py::pyobj_handle out1{ py::convert(param1) };
                if (!out1)
                {
                    return nullptr;
                }
                return PyTuple_Pack(2, out_return_value.get(), out1.get());
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* PnpObjectCollection_get_Size(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectCollection* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Devices.Enumeration.Pnp.PnpObjectCollection", L"Size"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.Size());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* _assign_array_PnpObjectCollection(PyObject* /*unused*/, PyObject* arg) noexcept
    {
        auto array = std::make_unique<py::ComArray<winrt::Windows::Devices::Enumeration::Pnp::PnpObjectCollection>>();
        if (!py::cpp::_winrt::Array_Assign(arg, std::move(array)))
        {
            return nullptr;
        }
        Py_RETURN_NONE;
    }

    static PyObject* _from_PnpObjectCollection(PyObject* /*unused*/, PyObject* arg) noexcept
    {
        try
        {
            auto return_value = py::convert_to<winrt::Windows::Foundation::IInspectable>(arg);
            return py::convert(return_value.as<winrt::Windows::Devices::Enumeration::Pnp::PnpObjectCollection>());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* _iterator_PnpObjectCollection(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectCollection* self) noexcept
    {
        try
        {
            return py::convert(self->obj.First());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static Py_ssize_t _seq_length_PnpObjectCollection(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectCollection* self) noexcept
    {
        try
        {
            return static_cast<Py_ssize_t>(self->obj.Size());
        }
        catch (...)
        {
            py::to_PyErr();
            return -1;
        }
    }

    static PyObject* _seq_item_PnpObjectCollection(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectCollection* self, Py_ssize_t i) noexcept
    {
        try
        {
            return py::convert(self->obj.GetAt(static_cast<uint32_t>(i)));
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* _seq_subscript_PnpObjectCollection(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectCollection* self, PyObject* slice) noexcept
    {
        try
        {
            if (PyIndex_Check(slice))
            {
                pyobj_handle index{PyNumber_Index(slice)};

                if (!index)
                {
                    return nullptr;
                }

                auto i = PyNumber_AsSsize_t(index.get(), PyExc_IndexError);

                if (i == -1 && PyErr_Occurred())
                {
                    return nullptr;
                }

                return _seq_item_PnpObjectCollection(self, i);
            }

            if (!PySlice_Check(slice))
            {
                PyErr_Format(
                    PyExc_TypeError,
                    "indicies must be integers, not '%s'",
                    Py_TYPE(slice)->tp_name);
            }

            Py_ssize_t start, stop, step, length;

            if (PySlice_GetIndicesEx(
                    slice, self->obj.Size(), &start, &stop, &step, &length)
                < 0)
            {
                return nullptr;
            }

            if (step != 1)
            {
                PyErr_SetString(
                    PyExc_NotImplementedError,
                    "slices with step other than 1 are not implemented");
                return nullptr;
            }

            winrt::com_array<winrt::Windows::Devices::Enumeration::Pnp::PnpObject> items(length, empty_instance<winrt::Windows::Devices::Enumeration::Pnp::PnpObject>::get());

            auto count = self->obj.GetMany(start, items);

            if (count != length)
            {
                PyErr_Format(
                    PyExc_RuntimeError,
                    "returned count %d did not match requested length %zd",
                    count,
                    length);
                return nullptr;
            }

            return convert(items);}
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* PnpObjectCollection_get_insert(PyObject* self) noexcept
    {
        return PyObject_GetAttrString(self, "insert_at");
    }

    static PyMethodDef _methods_PnpObjectCollection[] = {
        { "first", reinterpret_cast<PyCFunction>(PnpObjectCollection_First), METH_VARARGS, nullptr },
        { "get_at", reinterpret_cast<PyCFunction>(PnpObjectCollection_GetAt), METH_VARARGS, nullptr },
        { "get_many", reinterpret_cast<PyCFunction>(PnpObjectCollection_GetMany), METH_VARARGS, nullptr },
        { "index_of", reinterpret_cast<PyCFunction>(PnpObjectCollection_IndexOf), METH_VARARGS, nullptr },
        { "_assign_array_", _assign_array_PnpObjectCollection, METH_O | METH_STATIC, nullptr },
        { "_from", reinterpret_cast<PyCFunction>(_from_PnpObjectCollection), METH_O | METH_STATIC, nullptr },
        { }
    };

    static PyGetSetDef _getset_PnpObjectCollection[] = {
        { "size", reinterpret_cast<getter>(PnpObjectCollection_get_Size), nullptr, nullptr, nullptr },
        { }
    };

    static PyType_Slot _type_slots_PnpObjectCollection[] = 
    {
        { Py_tp_new, _new_PnpObjectCollection },
        { Py_tp_dealloc, _dealloc_PnpObjectCollection },
        { Py_tp_methods, _methods_PnpObjectCollection },
        { Py_tp_getset, _getset_PnpObjectCollection },
        { Py_tp_iter, _iterator_PnpObjectCollection },
        { Py_sq_length, _seq_length_PnpObjectCollection },
        { Py_sq_item, _seq_item_PnpObjectCollection },
        { Py_mp_subscript, _seq_subscript_PnpObjectCollection },
        { },
    };

    static PyType_Spec type_spec_PnpObjectCollection =
    {
        "_winsdk_Windows_Devices_Enumeration_Pnp.PnpObjectCollection",
        sizeof(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectCollection),
        0,
        Py_TPFLAGS_DEFAULT,
        _type_slots_PnpObjectCollection
    };

    // ----- PnpObjectUpdate class --------------------
    constexpr const char* const type_name_PnpObjectUpdate = "PnpObjectUpdate";

    static PyObject* _new_PnpObjectUpdate(PyTypeObject* type, PyObject* args, PyObject* kwds) noexcept
    {
        py::set_invalid_activation_error(type_name_PnpObjectUpdate);
        return nullptr;
    }

    static void _dealloc_PnpObjectUpdate(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectUpdate* self) noexcept
    {
        auto tp = Py_TYPE(self);

        if (PyType_IS_GC(tp))
        {
            PyObject_GC_UnTrack(self);
        }

        std::destroy_at(&self->obj);
        tp->tp_free(self);
        Py_DECREF(tp);
    }

    static PyObject* PnpObjectUpdate_get_Id(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectUpdate* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Devices.Enumeration.Pnp.PnpObjectUpdate", L"Id"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.Id());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* PnpObjectUpdate_get_Properties(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectUpdate* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Devices.Enumeration.Pnp.PnpObjectUpdate", L"Properties"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.Properties());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* PnpObjectUpdate_get_Type(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectUpdate* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Devices.Enumeration.Pnp.PnpObjectUpdate", L"Type"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.Type());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* _assign_array_PnpObjectUpdate(PyObject* /*unused*/, PyObject* arg) noexcept
    {
        auto array = std::make_unique<py::ComArray<winrt::Windows::Devices::Enumeration::Pnp::PnpObjectUpdate>>();
        if (!py::cpp::_winrt::Array_Assign(arg, std::move(array)))
        {
            return nullptr;
        }
        Py_RETURN_NONE;
    }

    static PyObject* _from_PnpObjectUpdate(PyObject* /*unused*/, PyObject* arg) noexcept
    {
        try
        {
            auto return_value = py::convert_to<winrt::Windows::Foundation::IInspectable>(arg);
            return py::convert(return_value.as<winrt::Windows::Devices::Enumeration::Pnp::PnpObjectUpdate>());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyMethodDef _methods_PnpObjectUpdate[] = {
        { "_assign_array_", _assign_array_PnpObjectUpdate, METH_O | METH_STATIC, nullptr },
        { "_from", reinterpret_cast<PyCFunction>(_from_PnpObjectUpdate), METH_O | METH_STATIC, nullptr },
        { }
    };

    static PyGetSetDef _getset_PnpObjectUpdate[] = {
        { "id", reinterpret_cast<getter>(PnpObjectUpdate_get_Id), nullptr, nullptr, nullptr },
        { "properties", reinterpret_cast<getter>(PnpObjectUpdate_get_Properties), nullptr, nullptr, nullptr },
        { "type", reinterpret_cast<getter>(PnpObjectUpdate_get_Type), nullptr, nullptr, nullptr },
        { }
    };

    static PyType_Slot _type_slots_PnpObjectUpdate[] = 
    {
        { Py_tp_new, _new_PnpObjectUpdate },
        { Py_tp_dealloc, _dealloc_PnpObjectUpdate },
        { Py_tp_methods, _methods_PnpObjectUpdate },
        { Py_tp_getset, _getset_PnpObjectUpdate },
        { },
    };

    static PyType_Spec type_spec_PnpObjectUpdate =
    {
        "_winsdk_Windows_Devices_Enumeration_Pnp.PnpObjectUpdate",
        sizeof(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectUpdate),
        0,
        Py_TPFLAGS_DEFAULT,
        _type_slots_PnpObjectUpdate
    };

    // ----- PnpObjectWatcher class --------------------
    constexpr const char* const type_name_PnpObjectWatcher = "PnpObjectWatcher";

    static PyObject* _new_PnpObjectWatcher(PyTypeObject* type, PyObject* args, PyObject* kwds) noexcept
    {
        py::set_invalid_activation_error(type_name_PnpObjectWatcher);
        return nullptr;
    }

    static void _dealloc_PnpObjectWatcher(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectWatcher* self) noexcept
    {
        auto tp = Py_TYPE(self);

        if (PyType_IS_GC(tp))
        {
            PyObject_GC_UnTrack(self);
        }

        std::destroy_at(&self->obj);
        tp->tp_free(self);
        Py_DECREF(tp);
    }

    static PyObject* PnpObjectWatcher_Start(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectWatcher* self, PyObject* args) noexcept
    {
        auto arg_count = PyTuple_Size(args);

        if (arg_count == 0)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Devices.Enumeration.Pnp.PnpObjectWatcher", L"Start", 0))
            {
                py::set_arg_count_version_error(0);
                return nullptr;
            }

            try
            {
                self->obj.Start();
                Py_RETURN_NONE;
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* PnpObjectWatcher_Stop(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectWatcher* self, PyObject* args) noexcept
    {
        auto arg_count = PyTuple_Size(args);

        if (arg_count == 0)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Devices.Enumeration.Pnp.PnpObjectWatcher", L"Stop", 0))
            {
                py::set_arg_count_version_error(0);
                return nullptr;
            }

            try
            {
                self->obj.Stop();
                Py_RETURN_NONE;
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* PnpObjectWatcher_get_Status(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectWatcher* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Devices.Enumeration.Pnp.PnpObjectWatcher", L"Status"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.Status());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* PnpObjectWatcher_add_Added(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectWatcher* self, PyObject* arg) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsEventPresent(L"Windows.Devices.Enumeration.Pnp.PnpObjectWatcher", L"Added"))
        {
            PyErr_SetString(PyExc_AttributeError, "event is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            auto param0 = py::convert_to<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::Enumeration::Pnp::PnpObjectWatcher, winrt::Windows::Devices::Enumeration::Pnp::PnpObject>>(arg);

            return py::convert(self->obj.Added(param0));
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* PnpObjectWatcher_remove_Added(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectWatcher* self, PyObject* arg) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsEventPresent(L"Windows.Devices.Enumeration.Pnp.PnpObjectWatcher", L"Added"))
        {
            PyErr_SetString(PyExc_AttributeError, "event is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            auto param0 = py::convert_to<winrt::event_token>(arg);

            self->obj.Added(param0);
            Py_RETURN_NONE;
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* PnpObjectWatcher_add_EnumerationCompleted(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectWatcher* self, PyObject* arg) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsEventPresent(L"Windows.Devices.Enumeration.Pnp.PnpObjectWatcher", L"EnumerationCompleted"))
        {
            PyErr_SetString(PyExc_AttributeError, "event is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            auto param0 = py::convert_to<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::Enumeration::Pnp::PnpObjectWatcher, winrt::Windows::Foundation::IInspectable>>(arg);

            return py::convert(self->obj.EnumerationCompleted(param0));
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* PnpObjectWatcher_remove_EnumerationCompleted(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectWatcher* self, PyObject* arg) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsEventPresent(L"Windows.Devices.Enumeration.Pnp.PnpObjectWatcher", L"EnumerationCompleted"))
        {
            PyErr_SetString(PyExc_AttributeError, "event is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            auto param0 = py::convert_to<winrt::event_token>(arg);

            self->obj.EnumerationCompleted(param0);
            Py_RETURN_NONE;
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* PnpObjectWatcher_add_Removed(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectWatcher* self, PyObject* arg) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsEventPresent(L"Windows.Devices.Enumeration.Pnp.PnpObjectWatcher", L"Removed"))
        {
            PyErr_SetString(PyExc_AttributeError, "event is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            auto param0 = py::convert_to<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::Enumeration::Pnp::PnpObjectWatcher, winrt::Windows::Devices::Enumeration::Pnp::PnpObjectUpdate>>(arg);

            return py::convert(self->obj.Removed(param0));
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* PnpObjectWatcher_remove_Removed(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectWatcher* self, PyObject* arg) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsEventPresent(L"Windows.Devices.Enumeration.Pnp.PnpObjectWatcher", L"Removed"))
        {
            PyErr_SetString(PyExc_AttributeError, "event is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            auto param0 = py::convert_to<winrt::event_token>(arg);

            self->obj.Removed(param0);
            Py_RETURN_NONE;
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* PnpObjectWatcher_add_Stopped(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectWatcher* self, PyObject* arg) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsEventPresent(L"Windows.Devices.Enumeration.Pnp.PnpObjectWatcher", L"Stopped"))
        {
            PyErr_SetString(PyExc_AttributeError, "event is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            auto param0 = py::convert_to<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::Enumeration::Pnp::PnpObjectWatcher, winrt::Windows::Foundation::IInspectable>>(arg);

            return py::convert(self->obj.Stopped(param0));
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* PnpObjectWatcher_remove_Stopped(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectWatcher* self, PyObject* arg) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsEventPresent(L"Windows.Devices.Enumeration.Pnp.PnpObjectWatcher", L"Stopped"))
        {
            PyErr_SetString(PyExc_AttributeError, "event is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            auto param0 = py::convert_to<winrt::event_token>(arg);

            self->obj.Stopped(param0);
            Py_RETURN_NONE;
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* PnpObjectWatcher_add_Updated(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectWatcher* self, PyObject* arg) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsEventPresent(L"Windows.Devices.Enumeration.Pnp.PnpObjectWatcher", L"Updated"))
        {
            PyErr_SetString(PyExc_AttributeError, "event is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            auto param0 = py::convert_to<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::Enumeration::Pnp::PnpObjectWatcher, winrt::Windows::Devices::Enumeration::Pnp::PnpObjectUpdate>>(arg);

            return py::convert(self->obj.Updated(param0));
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* PnpObjectWatcher_remove_Updated(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectWatcher* self, PyObject* arg) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsEventPresent(L"Windows.Devices.Enumeration.Pnp.PnpObjectWatcher", L"Updated"))
        {
            PyErr_SetString(PyExc_AttributeError, "event is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            auto param0 = py::convert_to<winrt::event_token>(arg);

            self->obj.Updated(param0);
            Py_RETURN_NONE;
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* _assign_array_PnpObjectWatcher(PyObject* /*unused*/, PyObject* arg) noexcept
    {
        auto array = std::make_unique<py::ComArray<winrt::Windows::Devices::Enumeration::Pnp::PnpObjectWatcher>>();
        if (!py::cpp::_winrt::Array_Assign(arg, std::move(array)))
        {
            return nullptr;
        }
        Py_RETURN_NONE;
    }

    static PyObject* _from_PnpObjectWatcher(PyObject* /*unused*/, PyObject* arg) noexcept
    {
        try
        {
            auto return_value = py::convert_to<winrt::Windows::Foundation::IInspectable>(arg);
            return py::convert(return_value.as<winrt::Windows::Devices::Enumeration::Pnp::PnpObjectWatcher>());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyMethodDef _methods_PnpObjectWatcher[] = {
        { "start", reinterpret_cast<PyCFunction>(PnpObjectWatcher_Start), METH_VARARGS, nullptr },
        { "stop", reinterpret_cast<PyCFunction>(PnpObjectWatcher_Stop), METH_VARARGS, nullptr },
        { "add_added", reinterpret_cast<PyCFunction>(PnpObjectWatcher_add_Added), METH_O, nullptr },
        { "remove_added", reinterpret_cast<PyCFunction>(PnpObjectWatcher_remove_Added), METH_O, nullptr },
        { "add_enumeration_completed", reinterpret_cast<PyCFunction>(PnpObjectWatcher_add_EnumerationCompleted), METH_O, nullptr },
        { "remove_enumeration_completed", reinterpret_cast<PyCFunction>(PnpObjectWatcher_remove_EnumerationCompleted), METH_O, nullptr },
        { "add_removed", reinterpret_cast<PyCFunction>(PnpObjectWatcher_add_Removed), METH_O, nullptr },
        { "remove_removed", reinterpret_cast<PyCFunction>(PnpObjectWatcher_remove_Removed), METH_O, nullptr },
        { "add_stopped", reinterpret_cast<PyCFunction>(PnpObjectWatcher_add_Stopped), METH_O, nullptr },
        { "remove_stopped", reinterpret_cast<PyCFunction>(PnpObjectWatcher_remove_Stopped), METH_O, nullptr },
        { "add_updated", reinterpret_cast<PyCFunction>(PnpObjectWatcher_add_Updated), METH_O, nullptr },
        { "remove_updated", reinterpret_cast<PyCFunction>(PnpObjectWatcher_remove_Updated), METH_O, nullptr },
        { "_assign_array_", _assign_array_PnpObjectWatcher, METH_O | METH_STATIC, nullptr },
        { "_from", reinterpret_cast<PyCFunction>(_from_PnpObjectWatcher), METH_O | METH_STATIC, nullptr },
        { }
    };

    static PyGetSetDef _getset_PnpObjectWatcher[] = {
        { "status", reinterpret_cast<getter>(PnpObjectWatcher_get_Status), nullptr, nullptr, nullptr },
        { }
    };

    static PyType_Slot _type_slots_PnpObjectWatcher[] = 
    {
        { Py_tp_new, _new_PnpObjectWatcher },
        { Py_tp_dealloc, _dealloc_PnpObjectWatcher },
        { Py_tp_methods, _methods_PnpObjectWatcher },
        { Py_tp_getset, _getset_PnpObjectWatcher },
        { },
    };

    static PyType_Spec type_spec_PnpObjectWatcher =
    {
        "_winsdk_Windows_Devices_Enumeration_Pnp.PnpObjectWatcher",
        sizeof(py::wrapper::Windows::Devices::Enumeration::Pnp::PnpObjectWatcher),
        0,
        Py_TPFLAGS_DEFAULT,
        _type_slots_PnpObjectWatcher
    };

    // ----- Windows.Devices.Enumeration.Pnp Initialization --------------------
    PyDoc_STRVAR(module_doc, "Windows::Devices::Enumeration::Pnp");

    static PyMethodDef module_methods[] = {
        {"_register_PnpObjectType", register_PnpObjectType, METH_O, "registers type"},
        {}};


    static int module_traverse(PyObject* module, visitproc visit, void* arg) noexcept
    {
        auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));

        if (!state)
        {
            return 0;
        }

        Py_VISIT(state->type_PnpObjectType);
        Py_VISIT(state->type_PnpObject);
        Py_VISIT(state->type_PnpObjectCollection);
        Py_VISIT(state->type_PnpObjectUpdate);
        Py_VISIT(state->type_PnpObjectWatcher);

        return 0;
    }

    static int module_clear(PyObject* module) noexcept
    {
        auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));

        if (!state)
        {
            return 0;
        }

        Py_CLEAR(state->type_PnpObjectType);
        Py_CLEAR(state->type_PnpObject);
        Py_CLEAR(state->type_PnpObjectCollection);
        Py_CLEAR(state->type_PnpObjectUpdate);
        Py_CLEAR(state->type_PnpObjectWatcher);

        return 0;
    }


    static PyModuleDef module_def
        = {PyModuleDef_HEAD_INIT,
           "_winsdk_Windows_Devices_Enumeration_Pnp",
           module_doc,
           sizeof(module_state),
           module_methods,
           nullptr,
           module_traverse,
           module_clear,
           nullptr};

} // py::cpp::Windows::Devices::Enumeration::Pnp

PyMODINIT_FUNC PyInit__winsdk_Windows_Devices_Enumeration_Pnp(void) noexcept
{
    using namespace py::cpp::Windows::Devices::Enumeration::Pnp;

    py::pyobj_handle module{PyModule_Create(&module_def)};

    if (!module)
    {
        return nullptr;
    }

    auto object_type = py::get_python_type<py::Object>();
    if (!object_type)
    {
        return nullptr;
    }

    py::pyobj_handle bases{PyTuple_Pack(1, object_type)};

    if (!bases)
    {
        return nullptr;
    }

    py::pyobj_handle collections_abc_module{PyImport_ImportModule("collections.abc")};

    if (!collections_abc_module)
    {
        return nullptr;
    }

    py::pyobj_handle sequence_type{PyObject_GetAttrString(collections_abc_module.get(), "Sequence")};

    if (!sequence_type)
    {
        return nullptr;
    }

    py::pyobj_handle sequence_bases{PyTuple_Pack(2, object_type, sequence_type.get())};

    if (!sequence_bases)
    {
        return nullptr;
    }

    py::pyobj_handle mutable_sequence_type{PyObject_GetAttrString(collections_abc_module.get(), "MutableSequence")};

    if (!mutable_sequence_type)
    {
        return nullptr;
    }

    py::pyobj_handle mutable_sequence_bases{PyTuple_Pack(2, object_type, mutable_sequence_type.get())};

    if (!mutable_sequence_bases)
    {
        return nullptr;
    }

    py::pyobj_handle mapping_type{PyObject_GetAttrString(collections_abc_module.get(), "Mapping")};

    if (!mapping_type)
    {
        return nullptr;
    }

    py::pyobj_handle mapping_bases{PyTuple_Pack(2, object_type, mapping_type.get())};

    if (!mapping_bases)
    {
        return nullptr;
    }

    py::pyobj_handle mutable_mapping_type{PyObject_GetAttrString(collections_abc_module.get(), "MutableMapping")};

    if (!mutable_mapping_type)
    {
        return nullptr;
    }

    py::pyobj_handle mutable_mapping_bases{PyTuple_Pack(2, object_type, mutable_mapping_type.get())};

    if (!mutable_mapping_bases)
    {
        return nullptr;
    }

    auto state = reinterpret_cast<module_state*>(PyModule_GetState(module.get()));
    assert(state);

    state->type_PnpObject = py::register_python_type(module.get(), type_name_PnpObject, &type_spec_PnpObject, bases.get(), nullptr);
    if (!state->type_PnpObject)
    {
        return nullptr;
    }

    state->type_PnpObjectCollection = py::register_python_type(module.get(), type_name_PnpObjectCollection, &type_spec_PnpObjectCollection, sequence_bases.get(), nullptr);
    if (!state->type_PnpObjectCollection)
    {
        return nullptr;
    }

    state->type_PnpObjectUpdate = py::register_python_type(module.get(), type_name_PnpObjectUpdate, &type_spec_PnpObjectUpdate, bases.get(), nullptr);
    if (!state->type_PnpObjectUpdate)
    {
        return nullptr;
    }

    state->type_PnpObjectWatcher = py::register_python_type(module.get(), type_name_PnpObjectWatcher, &type_spec_PnpObjectWatcher, bases.get(), nullptr);
    if (!state->type_PnpObjectWatcher)
    {
        return nullptr;
    }


    return module.detach();
}

PyObject* py::py_type<winrt::Windows::Devices::Enumeration::Pnp::PnpObjectType>::get_python_type() noexcept {
    using namespace py::cpp::Windows::Devices::Enumeration::Pnp;

    PyObject* module = PyState_FindModule(&module_def);

    if (!module) {
        PyErr_SetString(PyExc_RuntimeError, "could not find module for Windows::Devices::Enumeration::Pnp");
        return nullptr;
    }

    auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));
    assert(state);

    auto python_type = state->type_PnpObjectType;

    if (!python_type) {
        PyErr_SetString(PyExc_RuntimeError, "type winrt::Windows::Devices::Enumeration::Pnp::PnpObjectType is not registered");
        return nullptr;
    }

    return python_type;
}

PyTypeObject* py::winrt_type<winrt::Windows::Devices::Enumeration::Pnp::PnpObject>::get_python_type() noexcept {
    using namespace py::cpp::Windows::Devices::Enumeration::Pnp;

    PyObject* module = PyState_FindModule(&module_def);

    if (!module) {
        PyErr_SetString(PyExc_RuntimeError, "could not find module for Windows::Devices::Enumeration::Pnp");
        return nullptr;
    }

    auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));
    assert(state);

    auto python_type = state->type_PnpObject;

    if (!python_type) {
        PyErr_SetString(PyExc_RuntimeError, "type winrt::Windows::Devices::Enumeration::Pnp::PnpObject is not registered");
        return nullptr;
    }

    return python_type;
}

PyTypeObject* py::winrt_type<winrt::Windows::Devices::Enumeration::Pnp::PnpObjectCollection>::get_python_type() noexcept {
    using namespace py::cpp::Windows::Devices::Enumeration::Pnp;

    PyObject* module = PyState_FindModule(&module_def);

    if (!module) {
        PyErr_SetString(PyExc_RuntimeError, "could not find module for Windows::Devices::Enumeration::Pnp");
        return nullptr;
    }

    auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));
    assert(state);

    auto python_type = state->type_PnpObjectCollection;

    if (!python_type) {
        PyErr_SetString(PyExc_RuntimeError, "type winrt::Windows::Devices::Enumeration::Pnp::PnpObjectCollection is not registered");
        return nullptr;
    }

    return python_type;
}

PyTypeObject* py::winrt_type<winrt::Windows::Devices::Enumeration::Pnp::PnpObjectUpdate>::get_python_type() noexcept {
    using namespace py::cpp::Windows::Devices::Enumeration::Pnp;

    PyObject* module = PyState_FindModule(&module_def);

    if (!module) {
        PyErr_SetString(PyExc_RuntimeError, "could not find module for Windows::Devices::Enumeration::Pnp");
        return nullptr;
    }

    auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));
    assert(state);

    auto python_type = state->type_PnpObjectUpdate;

    if (!python_type) {
        PyErr_SetString(PyExc_RuntimeError, "type winrt::Windows::Devices::Enumeration::Pnp::PnpObjectUpdate is not registered");
        return nullptr;
    }

    return python_type;
}

PyTypeObject* py::winrt_type<winrt::Windows::Devices::Enumeration::Pnp::PnpObjectWatcher>::get_python_type() noexcept {
    using namespace py::cpp::Windows::Devices::Enumeration::Pnp;

    PyObject* module = PyState_FindModule(&module_def);

    if (!module) {
        PyErr_SetString(PyExc_RuntimeError, "could not find module for Windows::Devices::Enumeration::Pnp");
        return nullptr;
    }

    auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));
    assert(state);

    auto python_type = state->type_PnpObjectWatcher;

    if (!python_type) {
        PyErr_SetString(PyExc_RuntimeError, "type winrt::Windows::Devices::Enumeration::Pnp::PnpObjectWatcher is not registered");
        return nullptr;
    }

    return python_type;
}
