import calendar

from django.db.models import Q, Sum, F, DateField, ExpressionWrapper
from django.db.models.functions import Greatest, Least
from decimal import Decimal

from contribution.models import Premium
from core.datetimes.ad_datetime import date, AdDate
from product.models import Product

template = """
{
    "docElements": [
        {
            "elementType": "text",
            "id": 3,
            "containerId": "0_header",
            "x": 120,
            "y": 20,
            "width": 575,
            "height": 40,
            "content": "Contributions Distribution",
            "richText": false,
            "richTextContent": null,
            "richTextHtml": "",
            "eval": false,
            "styleId": "",
            "bold": true,
            "italic": false,
            "underline": false,
            "strikethrough": false,
            "horizontalAlignment": "center",
            "verticalAlignment": "middle",
            "textColor": "#006374",
            "backgroundColor": "",
            "font": "notosans",
            "fontSize": "24",
            "lineSpacing": 1,
            "borderColor": "#000000",
            "borderWidth": 1,
            "borderAll": false,
            "borderLeft": false,
            "borderTop": false,
            "borderRight": false,
            "borderBottom": false,
            "paddingLeft": 2,
            "paddingTop": 2,
            "paddingRight": 2,
            "paddingBottom": 2,
            "printIf": "",
            "removeEmptyElement": false,
            "alwaysPrintOnSamePage": true,
            "pattern": "",
            "link": "",
            "cs_condition": "",
            "cs_styleId": "",
            "cs_bold": false,
            "cs_italic": false,
            "cs_underline": false,
            "cs_strikethrough": false,
            "cs_horizontalAlignment": "left",
            "cs_verticalAlignment": "top",
            "cs_textColor": "#000000",
            "cs_backgroundColor": "",
            "cs_font": "helvetica",
            "cs_fontSize": 12,
            "cs_lineSpacing": 1,
            "cs_borderColor": "#000000",
            "cs_borderWidth": "1",
            "cs_borderAll": false,
            "cs_borderLeft": false,
            "cs_borderTop": false,
            "cs_borderRight": false,
            "cs_borderBottom": false,
            "cs_paddingLeft": 2,
            "cs_paddingTop": 2,
            "cs_paddingRight": 2,
            "cs_paddingBottom": 2,
            "spreadsheet_hide": false,
            "spreadsheet_column": "",
            "spreadsheet_colspan": "",
            "spreadsheet_addEmptyRow": false,
            "spreadsheet_textWrap": false
        },
        {
            "elementType": "line",
            "id": 158,
            "containerId": "0_content",
            "x": 0,
            "y": 0,
            "width": 820,
            "height": 1,
            "color": "#000000",
            "printIf": ""
        },
        {
            "elementType": "table",
            "id": 297,
            "containerId": "0_content",
            "width": 630,
            "x": 100,
            "y": 123,
            "dataSource": "",
            "columns": "2",
            "header": false,
            "contentRows": "1",
            "footer": false,
            "border": "grid",
            "borderColor": "#000000",
            "borderWidth": "1",
            "printIf": "${error}",
            "removeEmptyElement": false,
            "spreadsheet_hide": false,
            "spreadsheet_column": "",
            "spreadsheet_addEmptyRow": false,
            "headerData": {
                "elementType": "none",
                "id": 298,
                "height": 20,
                "backgroundColor": "",
                "repeatHeader": false,
                "columnData": [
                    {
                        "elementType": "table_text",
                        "id": 299,
                        "width": 260,
                        "content": "",
                        "eval": false,
                        "colspan": "",
                        "styleId": "",
                        "bold": false,
                        "italic": false,
                        "underline": false,
                        "strikethrough": false,
                        "horizontalAlignment": "left",
                        "verticalAlignment": "top",
                        "textColor": "#000000",
                        "backgroundColor": "",
                        "font": "helvetica",
                        "fontSize": 12,
                        "lineSpacing": 1,
                        "paddingLeft": 2,
                        "paddingTop": 2,
                        "paddingRight": 2,
                        "paddingBottom": 2,
                        "pattern": "",
                        "link": "",
                        "cs_condition": "",
                        "cs_styleId": "",
                        "cs_bold": false,
                        "cs_italic": false,
                        "cs_underline": false,
                        "cs_strikethrough": false,
                        "cs_horizontalAlignment": "left",
                        "cs_verticalAlignment": "top",
                        "cs_textColor": "#000000",
                        "cs_backgroundColor": "",
                        "cs_font": "helvetica",
                        "cs_fontSize": 12,
                        "cs_lineSpacing": 1,
                        "cs_paddingLeft": 2,
                        "cs_paddingTop": 2,
                        "cs_paddingRight": 2,
                        "cs_paddingBottom": 2,
                        "spreadsheet_textWrap": false,
                        "printIf": "",
                        "growWeight": 0,
                        "borderWidth": 1
                    },
                    {
                        "elementType": "table_text",
                        "id": 300,
                        "width": 370,
                        "content": "",
                        "eval": false,
                        "colspan": "",
                        "styleId": "",
                        "bold": false,
                        "italic": false,
                        "underline": false,
                        "strikethrough": false,
                        "horizontalAlignment": "left",
                        "verticalAlignment": "top",
                        "textColor": "#000000",
                        "backgroundColor": "",
                        "font": "helvetica",
                        "fontSize": 12,
                        "lineSpacing": 1,
                        "paddingLeft": 2,
                        "paddingTop": 2,
                        "paddingRight": 2,
                        "paddingBottom": 2,
                        "pattern": "",
                        "link": "",
                        "cs_condition": "",
                        "cs_styleId": "",
                        "cs_bold": false,
                        "cs_italic": false,
                        "cs_underline": false,
                        "cs_strikethrough": false,
                        "cs_horizontalAlignment": "left",
                        "cs_verticalAlignment": "top",
                        "cs_textColor": "#000000",
                        "cs_backgroundColor": "",
                        "cs_font": "helvetica",
                        "cs_fontSize": 12,
                        "cs_lineSpacing": 1,
                        "cs_paddingLeft": 2,
                        "cs_paddingTop": 2,
                        "cs_paddingRight": 2,
                        "cs_paddingBottom": 2,
                        "spreadsheet_textWrap": false,
                        "printIf": "",
                        "growWeight": 0,
                        "borderWidth": 1
                    }
                ]
            },
            "contentDataRows": [
                {
                    "elementType": "none",
                    "id": 301,
                    "height": 20,
                    "backgroundColor": "",
                    "alternateBackgroundColor": "",
                    "groupExpression": "",
                    "printIf": "",
                    "alwaysPrintOnSamePage": true,
                    "pageBreak": false,
                    "repeatGroupHeader": false,
                    "columnData": [
                        {
                            "elementType": "table_text",
                            "id": 302,
                            "width": 260,
                            "content": "${error}",
                            "eval": false,
                            "colspan": "2",
                            "styleId": "307",
                            "bold": true,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "center",
                            "verticalAlignment": "middle",
                            "textColor": "#ff0000",
                            "backgroundColor": "",
                            "font": "notosans",
                            "fontSize": "16",
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        },
                        {
                            "elementType": "table_text",
                            "id": 303,
                            "width": 370,
                            "content": "${error}",
                            "eval": false,
                            "colspan": "",
                            "styleId": "",
                            "bold": true,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "left",
                            "verticalAlignment": "middle",
                            "textColor": "#ff0000",
                            "backgroundColor": "",
                            "font": "helvetica",
                            "fontSize": 12,
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        }
                    ]
                }
            ],
            "footerData": {
                "elementType": "none",
                "id": 304,
                "height": 20,
                "backgroundColor": "",
                "columnData": [
                    {
                        "elementType": "table_text",
                        "id": 305,
                        "width": 260,
                        "content": "",
                        "eval": false,
                        "colspan": "",
                        "styleId": "",
                        "bold": false,
                        "italic": false,
                        "underline": false,
                        "strikethrough": false,
                        "horizontalAlignment": "left",
                        "verticalAlignment": "top",
                        "textColor": "#000000",
                        "backgroundColor": "",
                        "font": "helvetica",
                        "fontSize": 12,
                        "lineSpacing": 1,
                        "paddingLeft": 2,
                        "paddingTop": 2,
                        "paddingRight": 2,
                        "paddingBottom": 2,
                        "pattern": "",
                        "link": "",
                        "cs_condition": "",
                        "cs_styleId": "",
                        "cs_bold": false,
                        "cs_italic": false,
                        "cs_underline": false,
                        "cs_strikethrough": false,
                        "cs_horizontalAlignment": "left",
                        "cs_verticalAlignment": "top",
                        "cs_textColor": "#000000",
                        "cs_backgroundColor": "",
                        "cs_font": "helvetica",
                        "cs_fontSize": 12,
                        "cs_lineSpacing": 1,
                        "cs_paddingLeft": 2,
                        "cs_paddingTop": 2,
                        "cs_paddingRight": 2,
                        "cs_paddingBottom": 2,
                        "spreadsheet_textWrap": false,
                        "borderWidth": 1,
                        "growWeight": 0
                    },
                    {
                        "elementType": "table_text",
                        "id": 306,
                        "width": 370,
                        "content": "",
                        "eval": false,
                        "colspan": "",
                        "styleId": "",
                        "bold": false,
                        "italic": false,
                        "underline": false,
                        "strikethrough": false,
                        "horizontalAlignment": "left",
                        "verticalAlignment": "top",
                        "textColor": "#000000",
                        "backgroundColor": "",
                        "font": "helvetica",
                        "fontSize": 12,
                        "lineSpacing": 1,
                        "paddingLeft": 2,
                        "paddingTop": 2,
                        "paddingRight": 2,
                        "paddingBottom": 2,
                        "pattern": "",
                        "link": "",
                        "cs_condition": "",
                        "cs_styleId": "",
                        "cs_bold": false,
                        "cs_italic": false,
                        "cs_underline": false,
                        "cs_strikethrough": false,
                        "cs_horizontalAlignment": "left",
                        "cs_verticalAlignment": "top",
                        "cs_textColor": "#000000",
                        "cs_backgroundColor": "",
                        "cs_font": "helvetica",
                        "cs_fontSize": 12,
                        "cs_lineSpacing": 1,
                        "cs_paddingLeft": 2,
                        "cs_paddingTop": 2,
                        "cs_paddingRight": 2,
                        "cs_paddingBottom": 2,
                        "spreadsheet_textWrap": false,
                        "borderWidth": 1,
                        "growWeight": 0
                    }
                ]
            }
        },
        {
            "elementType": "table",
            "id": 195,
            "containerId": "0_content",
            "width": 822,
            "x": 0,
            "y": 104,
            "dataSource": "${data}",
            "columns": 7,
            "header": false,
            "contentRows": 4,
            "footer": true,
            "border": "grid",
            "borderColor": "#000000",
            "borderWidth": "1",
            "printIf": "",
            "removeEmptyElement": false,
            "spreadsheet_hide": false,
            "spreadsheet_column": "",
            "spreadsheet_addEmptyRow": false,
            "headerData": {
                "elementType": "none",
                "id": 196,
                "height": 20,
                "backgroundColor": "",
                "repeatHeader": true,
                "columnData": [
                    {
                        "elementType": "table_text",
                        "id": 197,
                        "width": 42,
                        "content": "Username: {user_name}",
                        "eval": false,
                        "colspan": "4",
                        "styleId": "286",
                        "bold": true,
                        "italic": false,
                        "underline": false,
                        "strikethrough": false,
                        "horizontalAlignment": "left",
                        "verticalAlignment": "middle",
                        "textColor": "#ffffff",
                        "backgroundColor": "#006374",
                        "font": "notosans",
                        "fontSize": 12,
                        "lineSpacing": 1,
                        "paddingLeft": 2,
                        "paddingTop": 2,
                        "paddingRight": 2,
                        "paddingBottom": 2,
                        "pattern": "",
                        "link": "",
                        "cs_condition": "",
                        "cs_styleId": "",
                        "cs_bold": false,
                        "cs_italic": false,
                        "cs_underline": false,
                        "cs_strikethrough": false,
                        "cs_horizontalAlignment": "left",
                        "cs_verticalAlignment": "top",
                        "cs_textColor": "#000000",
                        "cs_backgroundColor": "",
                        "cs_font": "helvetica",
                        "cs_fontSize": 12,
                        "cs_lineSpacing": 1,
                        "cs_paddingLeft": 2,
                        "cs_paddingTop": 2,
                        "cs_paddingRight": 2,
                        "cs_paddingBottom": 2,
                        "spreadsheet_textWrap": false,
                        "printIf": "",
                        "growWeight": 0,
                        "borderWidth": 1
                    },
                    {
                        "elementType": "table_text",
                        "id": 206,
                        "width": 80,
                        "content": "",
                        "eval": false,
                        "colspan": "",
                        "styleId": "33",
                        "bold": true,
                        "italic": false,
                        "underline": false,
                        "strikethrough": false,
                        "horizontalAlignment": "left",
                        "verticalAlignment": "middle",
                        "textColor": "#000000",
                        "backgroundColor": "",
                        "font": "notosans",
                        "fontSize": "12",
                        "lineSpacing": 1,
                        "paddingLeft": 2,
                        "paddingTop": 2,
                        "paddingRight": 2,
                        "paddingBottom": 2,
                        "pattern": "",
                        "link": "",
                        "cs_condition": "",
                        "cs_styleId": "",
                        "cs_bold": false,
                        "cs_italic": false,
                        "cs_underline": false,
                        "cs_strikethrough": false,
                        "cs_horizontalAlignment": "left",
                        "cs_verticalAlignment": "top",
                        "cs_textColor": "#000000",
                        "cs_backgroundColor": "",
                        "cs_font": "helvetica",
                        "cs_fontSize": 12,
                        "cs_lineSpacing": 1,
                        "cs_paddingLeft": 2,
                        "cs_paddingTop": 2,
                        "cs_paddingRight": 2,
                        "cs_paddingBottom": 2,
                        "spreadsheet_textWrap": false,
                        "printIf": "",
                        "growWeight": 0,
                        "borderWidth": 1
                    },
                    {
                        "elementType": "table_text",
                        "id": 592,
                        "width": 180,
                        "content": "",
                        "eval": false,
                        "colspan": "",
                        "styleId": "",
                        "bold": false,
                        "italic": false,
                        "underline": false,
                        "strikethrough": false,
                        "horizontalAlignment": "left",
                        "verticalAlignment": "top",
                        "textColor": "#000000",
                        "backgroundColor": "",
                        "font": "helvetica",
                        "fontSize": 12,
                        "lineSpacing": 1,
                        "paddingLeft": 2,
                        "paddingTop": 2,
                        "paddingRight": 2,
                        "paddingBottom": 2,
                        "pattern": "",
                        "link": "",
                        "cs_condition": "",
                        "cs_styleId": "",
                        "cs_bold": false,
                        "cs_italic": false,
                        "cs_underline": false,
                        "cs_strikethrough": false,
                        "cs_horizontalAlignment": "left",
                        "cs_verticalAlignment": "top",
                        "cs_textColor": "#000000",
                        "cs_backgroundColor": "",
                        "cs_font": "helvetica",
                        "cs_fontSize": 12,
                        "cs_lineSpacing": 1,
                        "cs_paddingLeft": 2,
                        "cs_paddingTop": 2,
                        "cs_paddingRight": 2,
                        "cs_paddingBottom": 2,
                        "spreadsheet_textWrap": false,
                        "printIf": "",
                        "growWeight": 0,
                        "borderWidth": 1
                    },
                    {
                        "elementType": "table_text",
                        "id": 381,
                        "width": 130,
                        "content": "",
                        "eval": false,
                        "colspan": "",
                        "styleId": "",
                        "bold": false,
                        "italic": false,
                        "underline": false,
                        "strikethrough": false,
                        "horizontalAlignment": "left",
                        "verticalAlignment": "top",
                        "textColor": "#000000",
                        "backgroundColor": "",
                        "font": "helvetica",
                        "fontSize": 12,
                        "lineSpacing": 1,
                        "paddingLeft": 2,
                        "paddingTop": 2,
                        "paddingRight": 2,
                        "paddingBottom": 2,
                        "pattern": "",
                        "link": "",
                        "cs_condition": "",
                        "cs_styleId": "",
                        "cs_bold": false,
                        "cs_italic": false,
                        "cs_underline": false,
                        "cs_strikethrough": false,
                        "cs_horizontalAlignment": "left",
                        "cs_verticalAlignment": "top",
                        "cs_textColor": "#000000",
                        "cs_backgroundColor": "",
                        "cs_font": "helvetica",
                        "cs_fontSize": 12,
                        "cs_lineSpacing": 1,
                        "cs_paddingLeft": 2,
                        "cs_paddingTop": 2,
                        "cs_paddingRight": 2,
                        "cs_paddingBottom": 2,
                        "spreadsheet_textWrap": false,
                        "printIf": "",
                        "growWeight": 0,
                        "borderWidth": 1
                    },
                    {
                        "elementType": "table_text",
                        "id": 391,
                        "width": 130,
                        "content": "",
                        "eval": false,
                        "colspan": "",
                        "styleId": "",
                        "bold": false,
                        "italic": false,
                        "underline": false,
                        "strikethrough": false,
                        "horizontalAlignment": "left",
                        "verticalAlignment": "top",
                        "textColor": "#000000",
                        "backgroundColor": "",
                        "font": "helvetica",
                        "fontSize": 12,
                        "lineSpacing": 1,
                        "paddingLeft": 2,
                        "paddingTop": 2,
                        "paddingRight": 2,
                        "paddingBottom": 2,
                        "pattern": "",
                        "link": "",
                        "cs_condition": "",
                        "cs_styleId": "",
                        "cs_bold": false,
                        "cs_italic": false,
                        "cs_underline": false,
                        "cs_strikethrough": false,
                        "cs_horizontalAlignment": "left",
                        "cs_verticalAlignment": "top",
                        "cs_textColor": "#000000",
                        "cs_backgroundColor": "",
                        "cs_font": "helvetica",
                        "cs_fontSize": 12,
                        "cs_lineSpacing": 1,
                        "cs_paddingLeft": 2,
                        "cs_paddingTop": 2,
                        "cs_paddingRight": 2,
                        "cs_paddingBottom": 2,
                        "spreadsheet_textWrap": false,
                        "printIf": "",
                        "growWeight": 0,
                        "borderWidth": 1
                    },
                    {
                        "elementType": "table_text",
                        "id": 401,
                        "width": 130,
                        "content": "",
                        "eval": false,
                        "colspan": "",
                        "styleId": "",
                        "bold": false,
                        "italic": false,
                        "underline": false,
                        "strikethrough": false,
                        "horizontalAlignment": "left",
                        "verticalAlignment": "top",
                        "textColor": "#000000",
                        "backgroundColor": "",
                        "font": "helvetica",
                        "fontSize": 12,
                        "lineSpacing": 1,
                        "paddingLeft": 2,
                        "paddingTop": 2,
                        "paddingRight": 2,
                        "paddingBottom": 2,
                        "pattern": "",
                        "link": "",
                        "cs_condition": "",
                        "cs_styleId": "",
                        "cs_bold": false,
                        "cs_italic": false,
                        "cs_underline": false,
                        "cs_strikethrough": false,
                        "cs_horizontalAlignment": "left",
                        "cs_verticalAlignment": "top",
                        "cs_textColor": "#000000",
                        "cs_backgroundColor": "",
                        "cs_font": "helvetica",
                        "cs_fontSize": 12,
                        "cs_lineSpacing": 1,
                        "cs_paddingLeft": 2,
                        "cs_paddingTop": 2,
                        "cs_paddingRight": 2,
                        "cs_paddingBottom": 2,
                        "spreadsheet_textWrap": false,
                        "printIf": "",
                        "growWeight": 0,
                        "borderWidth": 1
                    },
                    {
                        "elementType": "table_text",
                        "id": 599,
                        "width": 130,
                        "content": "",
                        "eval": false,
                        "colspan": "",
                        "styleId": "",
                        "bold": false,
                        "italic": false,
                        "underline": false,
                        "strikethrough": false,
                        "horizontalAlignment": "left",
                        "verticalAlignment": "top",
                        "textColor": "#000000",
                        "backgroundColor": "",
                        "font": "helvetica",
                        "fontSize": 12,
                        "lineSpacing": 1,
                        "paddingLeft": 2,
                        "paddingTop": 2,
                        "paddingRight": 2,
                        "paddingBottom": 2,
                        "pattern": "",
                        "link": "",
                        "cs_condition": "",
                        "cs_styleId": "",
                        "cs_bold": false,
                        "cs_italic": false,
                        "cs_underline": false,
                        "cs_strikethrough": false,
                        "cs_horizontalAlignment": "left",
                        "cs_verticalAlignment": "top",
                        "cs_textColor": "#000000",
                        "cs_backgroundColor": "",
                        "cs_font": "helvetica",
                        "cs_fontSize": 12,
                        "cs_lineSpacing": 1,
                        "cs_paddingLeft": 2,
                        "cs_paddingTop": 2,
                        "cs_paddingRight": 2,
                        "cs_paddingBottom": 2,
                        "spreadsheet_textWrap": false,
                        "printIf": "",
                        "growWeight": 0,
                        "borderWidth": 1
                    }
                ]
            },
            "contentDataRows": [
                {
                    "elementType": "none",
                    "id": 496,
                    "height": 20,
                    "backgroundColor": "",
                    "alternateBackgroundColor": "",
                    "groupExpression": "${location_code}",
                    "printIf": "",
                    "alwaysPrintOnSamePage": true,
                    "pageBreak": false,
                    "repeatGroupHeader": false,
                    "columnData": [
                        {
                            "elementType": "table_text",
                            "id": 497,
                            "width": 42,
                            "content": "",
                            "eval": false,
                            "colspan": "2",
                            "styleId": "",
                            "bold": false,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "left",
                            "verticalAlignment": "top",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "helvetica",
                            "fontSize": 12,
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        },
                        {
                            "elementType": "table_text",
                            "id": 499,
                            "width": 80,
                            "content": "",
                            "eval": false,
                            "colspan": "",
                            "styleId": "",
                            "bold": false,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "left",
                            "verticalAlignment": "top",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "helvetica",
                            "fontSize": 12,
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        },
                        {
                            "elementType": "table_text",
                            "id": 593,
                            "width": 180,
                            "content": "Product",
                            "eval": false,
                            "colspan": "",
                            "styleId": "349",
                            "bold": true,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "center",
                            "verticalAlignment": "middle",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "notosans",
                            "fontSize": 12,
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        },
                        {
                            "elementType": "table_text",
                            "id": 501,
                            "width": 130,
                            "content": "Month",
                            "eval": false,
                            "colspan": "1",
                            "styleId": "349",
                            "bold": true,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "center",
                            "verticalAlignment": "middle",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "notosans",
                            "fontSize": 12,
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        },
                        {
                            "elementType": "table_text",
                            "id": 502,
                            "width": 130,
                            "content": "Collected",
                            "eval": false,
                            "colspan": "",
                            "styleId": "349",
                            "bold": true,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "center",
                            "verticalAlignment": "middle",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "notosans",
                            "fontSize": 12,
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        },
                        {
                            "elementType": "table_text",
                            "id": 503,
                            "width": 130,
                            "content": "Not Allocated",
                            "eval": false,
                            "colspan": "",
                            "styleId": "349",
                            "bold": true,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "center",
                            "verticalAlignment": "middle",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "notosans",
                            "fontSize": 12,
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        },
                        {
                            "elementType": "table_text",
                            "id": 600,
                            "width": 130,
                            "content": "Allocated",
                            "eval": false,
                            "colspan": "",
                            "styleId": "349",
                            "bold": true,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "center",
                            "verticalAlignment": "middle",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "notosans",
                            "fontSize": 12,
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        }
                    ]
                },
                {
                    "elementType": "none",
                    "id": 257,
                    "height": 20,
                    "backgroundColor": "",
                    "alternateBackgroundColor": "",
                    "groupExpression": "${location_code}",
                    "printIf": "",
                    "alwaysPrintOnSamePage": true,
                    "pageBreak": false,
                    "repeatGroupHeader": false,
                    "columnData": [
                        {
                            "elementType": "table_text",
                            "id": 258,
                            "width": 42,
                            "content": "${location_name} if ${location_type} == 'N' else ('Region ' + ${location_code} + ' - ' + ${location_name} if ${location_type} == 'R' else ('District ' + ${location_code} + ' - ' + ${location_name}))",
                            "eval": true,
                            "colspan": "9",
                            "styleId": "286",
                            "bold": true,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "left",
                            "verticalAlignment": "middle",
                            "textColor": "#ffffff",
                            "backgroundColor": "#006374",
                            "font": "notosans",
                            "fontSize": 12,
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        },
                        {
                            "elementType": "table_text",
                            "id": 260,
                            "width": 80,
                            "content": "Description",
                            "eval": false,
                            "colspan": "",
                            "styleId": "33",
                            "bold": true,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "left",
                            "verticalAlignment": "middle",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "notosans",
                            "fontSize": "12",
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        },
                        {
                            "elementType": "table_text",
                            "id": 594,
                            "width": 180,
                            "content": "",
                            "eval": false,
                            "colspan": "",
                            "styleId": "",
                            "bold": false,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "left",
                            "verticalAlignment": "top",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "helvetica",
                            "fontSize": 12,
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        },
                        {
                            "elementType": "table_text",
                            "id": 382,
                            "width": 130,
                            "content": "",
                            "eval": false,
                            "colspan": "",
                            "styleId": "",
                            "bold": false,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "left",
                            "verticalAlignment": "top",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "helvetica",
                            "fontSize": 12,
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        },
                        {
                            "elementType": "table_text",
                            "id": 392,
                            "width": 130,
                            "content": "",
                            "eval": false,
                            "colspan": "",
                            "styleId": "",
                            "bold": false,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "left",
                            "verticalAlignment": "top",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "helvetica",
                            "fontSize": 12,
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        },
                        {
                            "elementType": "table_text",
                            "id": 402,
                            "width": 130,
                            "content": "",
                            "eval": false,
                            "colspan": "",
                            "styleId": "",
                            "bold": false,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "left",
                            "verticalAlignment": "top",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "helvetica",
                            "fontSize": 12,
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        },
                        {
                            "elementType": "table_text",
                            "id": 601,
                            "width": 130,
                            "content": "",
                            "eval": false,
                            "colspan": "",
                            "styleId": "",
                            "bold": false,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "left",
                            "verticalAlignment": "top",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "helvetica",
                            "fontSize": 12,
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        }
                    ]
                },
                {
                    "elementType": "none",
                    "id": 571,
                    "height": 20,
                    "backgroundColor": "",
                    "alternateBackgroundColor": "",
                    "groupExpression": "",
                    "printIf": "",
                    "alwaysPrintOnSamePage": true,
                    "pageBreak": false,
                    "repeatGroupHeader": false,
                    "columnData": [
                        {
                            "elementType": "table_text",
                            "id": 572,
                            "width": 42,
                            "content": "",
                            "eval": false,
                            "colspan": "2",
                            "styleId": "338",
                            "bold": false,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "left",
                            "verticalAlignment": "top",
                            "textColor": "#cccccc",
                            "backgroundColor": "#cccccc",
                            "font": "helvetica",
                            "fontSize": 12,
                            "lineSpacing": 1,
                            "paddingLeft": 0,
                            "paddingTop": 0,
                            "paddingRight": 0,
                            "paddingBottom": 0,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        },
                        {
                            "elementType": "table_text",
                            "id": 573,
                            "width": 80,
                            "content": "",
                            "eval": false,
                            "colspan": "",
                            "styleId": "",
                            "bold": false,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "left",
                            "verticalAlignment": "top",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "helvetica",
                            "fontSize": 12,
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        },
                        {
                            "elementType": "table_text",
                            "id": 595,
                            "width": 180,
                            "content": "${product_code} - ${product_name}",
                            "eval": false,
                            "colspan": "",
                            "styleId": "296",
                            "bold": false,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "center",
                            "verticalAlignment": "middle",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "notosans",
                            "fontSize": "11",
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        },
                        {
                            "elementType": "table_text",
                            "id": 574,
                            "width": 130,
                            "content": "${month_txt}",
                            "eval": false,
                            "colspan": "",
                            "styleId": "296",
                            "bold": false,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "center",
                            "verticalAlignment": "middle",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "notosans",
                            "fontSize": "11",
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        },
                        {
                            "elementType": "table_text",
                            "id": 575,
                            "width": 130,
                            "content": "${collected}",
                            "eval": false,
                            "colspan": "",
                            "styleId": "296",
                            "bold": false,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "center",
                            "verticalAlignment": "middle",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "notosans",
                            "fontSize": "11",
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        },
                        {
                            "elementType": "table_text",
                            "id": 576,
                            "width": 130,
                            "content": "${not_allocated}",
                            "eval": false,
                            "colspan": "",
                            "styleId": "296",
                            "bold": false,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "center",
                            "verticalAlignment": "middle",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "notosans",
                            "fontSize": "11",
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        },
                        {
                            "elementType": "table_text",
                            "id": 602,
                            "width": 130,
                            "content": "${allocated}",
                            "eval": false,
                            "colspan": "",
                            "styleId": "296",
                            "bold": false,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "center",
                            "verticalAlignment": "middle",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "notosans",
                            "fontSize": "11",
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        }
                    ]
                },
                {
                    "elementType": "none",
                    "id": 199,
                    "height": 20,
                    "backgroundColor": "",
                    "alternateBackgroundColor": "",
                    "groupExpression": "${location_code}",
                    "printIf": "",
                    "alwaysPrintOnSamePage": true,
                    "pageBreak": false,
                    "repeatGroupHeader": false,
                    "columnData": [
                        {
                            "elementType": "table_text",
                            "id": 200,
                            "width": 42,
                            "content": "",
                            "eval": false,
                            "colspan": "9",
                            "styleId": "338",
                            "bold": false,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "left",
                            "verticalAlignment": "top",
                            "textColor": "#cccccc",
                            "backgroundColor": "#cccccc",
                            "font": "helvetica",
                            "fontSize": 12,
                            "lineSpacing": 1,
                            "paddingLeft": 0,
                            "paddingTop": 0,
                            "paddingRight": 0,
                            "paddingBottom": 0,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        },
                        {
                            "elementType": "table_text",
                            "id": 209,
                            "width": 80,
                            "content": "",
                            "eval": false,
                            "colspan": "",
                            "styleId": "",
                            "bold": false,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "left",
                            "verticalAlignment": "top",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "helvetica",
                            "fontSize": 12,
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "yyyy/MM/dd",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        },
                        {
                            "elementType": "table_text",
                            "id": 597,
                            "width": 180,
                            "content": "",
                            "eval": false,
                            "colspan": "",
                            "styleId": "",
                            "bold": false,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "left",
                            "verticalAlignment": "top",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "helvetica",
                            "fontSize": 12,
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        },
                        {
                            "elementType": "table_text",
                            "id": 389,
                            "width": 130,
                            "content": "",
                            "eval": false,
                            "colspan": "",
                            "styleId": "",
                            "bold": false,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "left",
                            "verticalAlignment": "top",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "helvetica",
                            "fontSize": 12,
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        },
                        {
                            "elementType": "table_text",
                            "id": 399,
                            "width": 130,
                            "content": "",
                            "eval": false,
                            "colspan": "",
                            "styleId": "",
                            "bold": false,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "left",
                            "verticalAlignment": "top",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "helvetica",
                            "fontSize": 12,
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        },
                        {
                            "elementType": "table_text",
                            "id": 409,
                            "width": 130,
                            "content": "",
                            "eval": false,
                            "colspan": "",
                            "styleId": "",
                            "bold": false,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "left",
                            "verticalAlignment": "top",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "helvetica",
                            "fontSize": 12,
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        },
                        {
                            "elementType": "table_text",
                            "id": 604,
                            "width": 130,
                            "content": "",
                            "eval": false,
                            "colspan": "",
                            "styleId": "",
                            "bold": false,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "left",
                            "verticalAlignment": "top",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "helvetica",
                            "fontSize": 12,
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        }
                    ]
                }
            ],
            "footerData": {
                "elementType": "none",
                "id": 202,
                "height": 20,
                "backgroundColor": "",
                "columnData": [
                    {
                        "elementType": "table_text",
                        "id": 203,
                        "width": 42,
                        "content": "Grand Total:",
                        "eval": false,
                        "colspan": "4",
                        "styleId": "349",
                        "bold": true,
                        "italic": false,
                        "underline": false,
                        "strikethrough": false,
                        "horizontalAlignment": "center",
                        "verticalAlignment": "middle",
                        "textColor": "#000000",
                        "backgroundColor": "",
                        "font": "notosans",
                        "fontSize": 12,
                        "lineSpacing": 1,
                        "paddingLeft": 2,
                        "paddingTop": 2,
                        "paddingRight": 2,
                        "paddingBottom": 2,
                        "pattern": "",
                        "link": "",
                        "cs_condition": "",
                        "cs_styleId": "",
                        "cs_bold": false,
                        "cs_italic": false,
                        "cs_underline": false,
                        "cs_strikethrough": false,
                        "cs_horizontalAlignment": "left",
                        "cs_verticalAlignment": "top",
                        "cs_textColor": "#000000",
                        "cs_backgroundColor": "",
                        "cs_font": "helvetica",
                        "cs_fontSize": 12,
                        "cs_lineSpacing": 1,
                        "cs_paddingLeft": 2,
                        "cs_paddingTop": 2,
                        "cs_paddingRight": 2,
                        "cs_paddingBottom": 2,
                        "spreadsheet_textWrap": false,
                        "borderWidth": 1,
                        "growWeight": 0
                    },
                    {
                        "elementType": "table_text",
                        "id": 212,
                        "width": 80,
                        "content": "",
                        "eval": false,
                        "colspan": "",
                        "styleId": "",
                        "bold": false,
                        "italic": false,
                        "underline": false,
                        "strikethrough": false,
                        "horizontalAlignment": "left",
                        "verticalAlignment": "top",
                        "textColor": "#000000",
                        "backgroundColor": "",
                        "font": "helvetica",
                        "fontSize": 12,
                        "lineSpacing": 1,
                        "paddingLeft": 2,
                        "paddingTop": 2,
                        "paddingRight": 2,
                        "paddingBottom": 2,
                        "pattern": "",
                        "link": "",
                        "cs_condition": "",
                        "cs_styleId": "",
                        "cs_bold": false,
                        "cs_italic": false,
                        "cs_underline": false,
                        "cs_strikethrough": false,
                        "cs_horizontalAlignment": "left",
                        "cs_verticalAlignment": "top",
                        "cs_textColor": "#000000",
                        "cs_backgroundColor": "",
                        "cs_font": "helvetica",
                        "cs_fontSize": 12,
                        "cs_lineSpacing": 1,
                        "cs_paddingLeft": 2,
                        "cs_paddingTop": 2,
                        "cs_paddingRight": 2,
                        "cs_paddingBottom": 2,
                        "spreadsheet_textWrap": false,
                        "borderWidth": 1,
                        "growWeight": 0
                    },
                    {
                        "elementType": "table_text",
                        "id": 598,
                        "width": 180,
                        "content": "",
                        "eval": false,
                        "colspan": "",
                        "styleId": "",
                        "bold": false,
                        "italic": false,
                        "underline": false,
                        "strikethrough": false,
                        "horizontalAlignment": "left",
                        "verticalAlignment": "top",
                        "textColor": "#000000",
                        "backgroundColor": "",
                        "font": "helvetica",
                        "fontSize": 12,
                        "lineSpacing": 1,
                        "paddingLeft": 2,
                        "paddingTop": 2,
                        "paddingRight": 2,
                        "paddingBottom": 2,
                        "pattern": "",
                        "link": "",
                        "cs_condition": "",
                        "cs_styleId": "",
                        "cs_bold": false,
                        "cs_italic": false,
                        "cs_underline": false,
                        "cs_strikethrough": false,
                        "cs_horizontalAlignment": "left",
                        "cs_verticalAlignment": "top",
                        "cs_textColor": "#000000",
                        "cs_backgroundColor": "",
                        "cs_font": "helvetica",
                        "cs_fontSize": 12,
                        "cs_lineSpacing": 1,
                        "cs_paddingLeft": 2,
                        "cs_paddingTop": 2,
                        "cs_paddingRight": 2,
                        "cs_paddingBottom": 2,
                        "spreadsheet_textWrap": false,
                        "borderWidth": 1,
                        "growWeight": 0
                    },
                    {
                        "elementType": "table_text",
                        "id": 390,
                        "width": 130,
                        "content": "",
                        "eval": false,
                        "colspan": "1",
                        "styleId": "349",
                        "bold": true,
                        "italic": false,
                        "underline": false,
                        "strikethrough": false,
                        "horizontalAlignment": "center",
                        "verticalAlignment": "middle",
                        "textColor": "#000000",
                        "backgroundColor": "",
                        "font": "notosans",
                        "fontSize": 12,
                        "lineSpacing": 1,
                        "paddingLeft": 2,
                        "paddingTop": 2,
                        "paddingRight": 2,
                        "paddingBottom": 2,
                        "pattern": "",
                        "link": "",
                        "cs_condition": "",
                        "cs_styleId": "",
                        "cs_bold": false,
                        "cs_italic": false,
                        "cs_underline": false,
                        "cs_strikethrough": false,
                        "cs_horizontalAlignment": "left",
                        "cs_verticalAlignment": "top",
                        "cs_textColor": "#000000",
                        "cs_backgroundColor": "",
                        "cs_font": "helvetica",
                        "cs_fontSize": 12,
                        "cs_lineSpacing": 1,
                        "cs_paddingLeft": 2,
                        "cs_paddingTop": 2,
                        "cs_paddingRight": 2,
                        "cs_paddingBottom": 2,
                        "spreadsheet_textWrap": false,
                        "borderWidth": 1,
                        "growWeight": 0
                    },
                    {
                        "elementType": "table_text",
                        "id": 400,
                        "width": 130,
                        "content": "${total_collected}",
                        "eval": false,
                        "colspan": "",
                        "styleId": "349",
                        "bold": true,
                        "italic": false,
                        "underline": false,
                        "strikethrough": false,
                        "horizontalAlignment": "center",
                        "verticalAlignment": "middle",
                        "textColor": "#000000",
                        "backgroundColor": "",
                        "font": "notosans",
                        "fontSize": 12,
                        "lineSpacing": 1,
                        "paddingLeft": 2,
                        "paddingTop": 2,
                        "paddingRight": 2,
                        "paddingBottom": 2,
                        "pattern": "",
                        "link": "",
                        "cs_condition": "",
                        "cs_styleId": "",
                        "cs_bold": false,
                        "cs_italic": false,
                        "cs_underline": false,
                        "cs_strikethrough": false,
                        "cs_horizontalAlignment": "left",
                        "cs_verticalAlignment": "top",
                        "cs_textColor": "#000000",
                        "cs_backgroundColor": "",
                        "cs_font": "helvetica",
                        "cs_fontSize": 12,
                        "cs_lineSpacing": 1,
                        "cs_paddingLeft": 2,
                        "cs_paddingTop": 2,
                        "cs_paddingRight": 2,
                        "cs_paddingBottom": 2,
                        "spreadsheet_textWrap": false,
                        "borderWidth": 1,
                        "growWeight": 0
                    },
                    {
                        "elementType": "table_text",
                        "id": 410,
                        "width": 130,
                        "content": "${total_not_allocated}",
                        "eval": false,
                        "colspan": "",
                        "styleId": "349",
                        "bold": true,
                        "italic": false,
                        "underline": false,
                        "strikethrough": false,
                        "horizontalAlignment": "center",
                        "verticalAlignment": "middle",
                        "textColor": "#000000",
                        "backgroundColor": "",
                        "font": "notosans",
                        "fontSize": 12,
                        "lineSpacing": 1,
                        "paddingLeft": 2,
                        "paddingTop": 2,
                        "paddingRight": 2,
                        "paddingBottom": 2,
                        "pattern": "",
                        "link": "",
                        "cs_condition": "",
                        "cs_styleId": "",
                        "cs_bold": false,
                        "cs_italic": false,
                        "cs_underline": false,
                        "cs_strikethrough": false,
                        "cs_horizontalAlignment": "left",
                        "cs_verticalAlignment": "top",
                        "cs_textColor": "#000000",
                        "cs_backgroundColor": "",
                        "cs_font": "helvetica",
                        "cs_fontSize": 12,
                        "cs_lineSpacing": 1,
                        "cs_paddingLeft": 2,
                        "cs_paddingTop": 2,
                        "cs_paddingRight": 2,
                        "cs_paddingBottom": 2,
                        "spreadsheet_textWrap": false,
                        "borderWidth": 1,
                        "growWeight": 0
                    },
                    {
                        "elementType": "table_text",
                        "id": 605,
                        "width": 130,
                        "content": "${total_allocated}",
                        "eval": false,
                        "colspan": "",
                        "styleId": "349",
                        "bold": true,
                        "italic": false,
                        "underline": false,
                        "strikethrough": false,
                        "horizontalAlignment": "center",
                        "verticalAlignment": "middle",
                        "textColor": "#000000",
                        "backgroundColor": "",
                        "font": "notosans",
                        "fontSize": 12,
                        "lineSpacing": 1,
                        "paddingLeft": 2,
                        "paddingTop": 2,
                        "paddingRight": 2,
                        "paddingBottom": 2,
                        "pattern": "",
                        "link": "",
                        "cs_condition": "",
                        "cs_styleId": "",
                        "cs_bold": false,
                        "cs_italic": false,
                        "cs_underline": false,
                        "cs_strikethrough": false,
                        "cs_horizontalAlignment": "left",
                        "cs_verticalAlignment": "top",
                        "cs_textColor": "#000000",
                        "cs_backgroundColor": "",
                        "cs_font": "helvetica",
                        "cs_fontSize": 12,
                        "cs_lineSpacing": 1,
                        "cs_paddingLeft": 2,
                        "cs_paddingTop": 2,
                        "cs_paddingRight": 2,
                        "cs_paddingBottom": 2,
                        "spreadsheet_textWrap": false,
                        "borderWidth": 1,
                        "growWeight": 0
                    }
                ]
            }
        },
        {
            "elementType": "table",
            "id": 262,
            "containerId": "0_content",
            "width": 360,
            "x": 240,
            "y": 20,
            "dataSource": "${header}",
            "columns": "2",
            "header": false,
            "contentRows": 3,
            "footer": false,
            "border": "grid",
            "borderColor": "#000000",
            "borderWidth": "1",
            "printIf": "",
            "removeEmptyElement": false,
            "spreadsheet_hide": false,
            "spreadsheet_column": "",
            "spreadsheet_addEmptyRow": false,
            "headerData": {
                "elementType": "none",
                "id": 263,
                "height": 20,
                "backgroundColor": "",
                "repeatHeader": false,
                "columnData": [
                    {
                        "elementType": "table_text",
                        "id": 264,
                        "width": 100,
                        "content": "From",
                        "eval": false,
                        "colspan": "",
                        "styleId": "33",
                        "bold": true,
                        "italic": false,
                        "underline": false,
                        "strikethrough": false,
                        "horizontalAlignment": "left",
                        "verticalAlignment": "middle",
                        "textColor": "#000000",
                        "backgroundColor": "",
                        "font": "notosans",
                        "fontSize": "12",
                        "lineSpacing": 1,
                        "paddingLeft": 2,
                        "paddingTop": 2,
                        "paddingRight": 2,
                        "paddingBottom": 2,
                        "pattern": "",
                        "link": "",
                        "cs_condition": "",
                        "cs_styleId": "",
                        "cs_bold": false,
                        "cs_italic": false,
                        "cs_underline": false,
                        "cs_strikethrough": false,
                        "cs_horizontalAlignment": "left",
                        "cs_verticalAlignment": "top",
                        "cs_textColor": "#000000",
                        "cs_backgroundColor": "",
                        "cs_font": "helvetica",
                        "cs_fontSize": 12,
                        "cs_lineSpacing": 1,
                        "cs_paddingLeft": 2,
                        "cs_paddingTop": 2,
                        "cs_paddingRight": 2,
                        "cs_paddingBottom": 2,
                        "spreadsheet_textWrap": false,
                        "printIf": "",
                        "growWeight": 0,
                        "borderWidth": 1
                    },
                    {
                        "elementType": "table_text",
                        "id": 265,
                        "width": 260,
                        "content": "",
                        "eval": false,
                        "colspan": "",
                        "styleId": "34",
                        "bold": false,
                        "italic": false,
                        "underline": false,
                        "strikethrough": false,
                        "horizontalAlignment": "left",
                        "verticalAlignment": "middle",
                        "textColor": "#000000",
                        "backgroundColor": "",
                        "font": "notosans",
                        "fontSize": "11",
                        "lineSpacing": 1,
                        "paddingLeft": 2,
                        "paddingTop": 2,
                        "paddingRight": 2,
                        "paddingBottom": 2,
                        "pattern": "",
                        "link": "",
                        "cs_condition": "",
                        "cs_styleId": "",
                        "cs_bold": false,
                        "cs_italic": false,
                        "cs_underline": false,
                        "cs_strikethrough": false,
                        "cs_horizontalAlignment": "left",
                        "cs_verticalAlignment": "top",
                        "cs_textColor": "#000000",
                        "cs_backgroundColor": "",
                        "cs_font": "helvetica",
                        "cs_fontSize": 12,
                        "cs_lineSpacing": 1,
                        "cs_paddingLeft": 2,
                        "cs_paddingTop": 2,
                        "cs_paddingRight": 2,
                        "cs_paddingBottom": 2,
                        "spreadsheet_textWrap": false,
                        "printIf": "",
                        "growWeight": 0,
                        "borderWidth": 1
                    }
                ]
            },
            "contentDataRows": [
                {
                    "elementType": "none",
                    "id": 555,
                    "height": 20,
                    "backgroundColor": "",
                    "alternateBackgroundColor": "",
                    "groupExpression": "",
                    "printIf": "",
                    "alwaysPrintOnSamePage": true,
                    "pageBreak": false,
                    "repeatGroupHeader": false,
                    "columnData": [
                        {
                            "elementType": "table_text",
                            "id": 556,
                            "width": 100,
                            "content": "Product",
                            "eval": false,
                            "colspan": "",
                            "styleId": "33",
                            "bold": true,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "left",
                            "verticalAlignment": "middle",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "notosans",
                            "fontSize": "12",
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        },
                        {
                            "elementType": "table_text",
                            "id": 557,
                            "width": 260,
                            "content": "${product}",
                            "eval": false,
                            "colspan": "",
                            "styleId": "34",
                            "bold": false,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "left",
                            "verticalAlignment": "middle",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "notosans",
                            "fontSize": "11",
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        }
                    ]
                },
                {
                    "elementType": "none",
                    "id": 561,
                    "height": 20,
                    "backgroundColor": "",
                    "alternateBackgroundColor": "",
                    "groupExpression": "",
                    "printIf": "",
                    "alwaysPrintOnSamePage": true,
                    "pageBreak": false,
                    "repeatGroupHeader": false,
                    "columnData": [
                        {
                            "elementType": "table_text",
                            "id": 562,
                            "width": 100,
                            "content": "Year",
                            "eval": false,
                            "colspan": "",
                            "styleId": "33",
                            "bold": true,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "left",
                            "verticalAlignment": "middle",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "notosans",
                            "fontSize": "12",
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        },
                        {
                            "elementType": "table_text",
                            "id": 563,
                            "width": 260,
                            "content": "${year}",
                            "eval": false,
                            "colspan": "",
                            "styleId": "34",
                            "bold": false,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "left",
                            "verticalAlignment": "middle",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "notosans",
                            "fontSize": "11",
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        }
                    ]
                },
                {
                    "elementType": "none",
                    "id": 564,
                    "height": 20,
                    "backgroundColor": "",
                    "alternateBackgroundColor": "",
                    "groupExpression": "",
                    "printIf": "",
                    "alwaysPrintOnSamePage": true,
                    "pageBreak": false,
                    "repeatGroupHeader": false,
                    "columnData": [
                        {
                            "elementType": "table_text",
                            "id": 565,
                            "width": 100,
                            "content": "Month",
                            "eval": false,
                            "colspan": "",
                            "styleId": "33",
                            "bold": true,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "left",
                            "verticalAlignment": "middle",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "notosans",
                            "fontSize": "12",
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        },
                        {
                            "elementType": "table_text",
                            "id": 566,
                            "width": 260,
                            "content": "${month}",
                            "eval": false,
                            "colspan": "",
                            "styleId": "34",
                            "bold": false,
                            "italic": false,
                            "underline": false,
                            "strikethrough": false,
                            "horizontalAlignment": "left",
                            "verticalAlignment": "middle",
                            "textColor": "#000000",
                            "backgroundColor": "",
                            "font": "notosans",
                            "fontSize": "11",
                            "lineSpacing": 1,
                            "paddingLeft": 2,
                            "paddingTop": 2,
                            "paddingRight": 2,
                            "paddingBottom": 2,
                            "pattern": "",
                            "link": "",
                            "cs_condition": "",
                            "cs_styleId": "",
                            "cs_bold": false,
                            "cs_italic": false,
                            "cs_underline": false,
                            "cs_strikethrough": false,
                            "cs_horizontalAlignment": "left",
                            "cs_verticalAlignment": "top",
                            "cs_textColor": "#000000",
                            "cs_backgroundColor": "",
                            "cs_font": "helvetica",
                            "cs_fontSize": 12,
                            "cs_lineSpacing": 1,
                            "cs_paddingLeft": 2,
                            "cs_paddingTop": 2,
                            "cs_paddingRight": 2,
                            "cs_paddingBottom": 2,
                            "spreadsheet_textWrap": false,
                            "borderWidth": 1,
                            "growWeight": 0
                        }
                    ]
                }
            ],
            "footerData": {
                "elementType": "none",
                "id": 269,
                "height": 20,
                "backgroundColor": "",
                "columnData": [
                    {
                        "elementType": "table_text",
                        "id": 270,
                        "width": 100,
                        "content": "",
                        "eval": false,
                        "colspan": "",
                        "styleId": "",
                        "bold": false,
                        "italic": false,
                        "underline": false,
                        "strikethrough": false,
                        "horizontalAlignment": "left",
                        "verticalAlignment": "top",
                        "textColor": "#000000",
                        "backgroundColor": "",
                        "font": "helvetica",
                        "fontSize": 12,
                        "lineSpacing": 1,
                        "paddingLeft": 2,
                        "paddingTop": 2,
                        "paddingRight": 2,
                        "paddingBottom": 2,
                        "pattern": "",
                        "link": "",
                        "cs_condition": "",
                        "cs_styleId": "",
                        "cs_bold": false,
                        "cs_italic": false,
                        "cs_underline": false,
                        "cs_strikethrough": false,
                        "cs_horizontalAlignment": "left",
                        "cs_verticalAlignment": "top",
                        "cs_textColor": "#000000",
                        "cs_backgroundColor": "",
                        "cs_font": "helvetica",
                        "cs_fontSize": 12,
                        "cs_lineSpacing": 1,
                        "cs_paddingLeft": 2,
                        "cs_paddingTop": 2,
                        "cs_paddingRight": 2,
                        "cs_paddingBottom": 2,
                        "spreadsheet_textWrap": false,
                        "borderWidth": 1,
                        "growWeight": 0
                    },
                    {
                        "elementType": "table_text",
                        "id": 271,
                        "width": 260,
                        "content": "",
                        "eval": false,
                        "colspan": "",
                        "styleId": "",
                        "bold": false,
                        "italic": false,
                        "underline": false,
                        "strikethrough": false,
                        "horizontalAlignment": "left",
                        "verticalAlignment": "top",
                        "textColor": "#000000",
                        "backgroundColor": "",
                        "font": "helvetica",
                        "fontSize": 12,
                        "lineSpacing": 1,
                        "paddingLeft": 2,
                        "paddingTop": 2,
                        "paddingRight": 2,
                        "paddingBottom": 2,
                        "pattern": "",
                        "link": "",
                        "cs_condition": "",
                        "cs_styleId": "",
                        "cs_bold": false,
                        "cs_italic": false,
                        "cs_underline": false,
                        "cs_strikethrough": false,
                        "cs_horizontalAlignment": "left",
                        "cs_verticalAlignment": "top",
                        "cs_textColor": "#000000",
                        "cs_backgroundColor": "",
                        "cs_font": "helvetica",
                        "cs_fontSize": 12,
                        "cs_lineSpacing": 1,
                        "cs_paddingLeft": 2,
                        "cs_paddingTop": 2,
                        "cs_paddingRight": 2,
                        "cs_paddingBottom": 2,
                        "spreadsheet_textWrap": false,
                        "borderWidth": 1,
                        "growWeight": 0
                    }
                ]
            }
        },
        {
            "elementType": "text",
            "id": 7,
            "containerId": "0_footer",
            "x": 567,
            "y": 0,
            "width": 255,
            "height": 30,
            "content": "Page ${page_number} / ${page_count}",
            "richText": false,
            "richTextContent": null,
            "richTextHtml": "",
            "eval": false,
            "styleId": "",
            "bold": false,
            "italic": false,
            "underline": false,
            "strikethrough": false,
            "horizontalAlignment": "right",
            "verticalAlignment": "middle",
            "textColor": "#666666",
            "backgroundColor": "",
            "font": "notosans",
            "fontSize": 12,
            "lineSpacing": 1,
            "borderColor": "#000000",
            "borderWidth": 1,
            "borderAll": false,
            "borderLeft": false,
            "borderTop": false,
            "borderRight": false,
            "borderBottom": false,
            "paddingLeft": 2,
            "paddingTop": 2,
            "paddingRight": 2,
            "paddingBottom": 2,
            "printIf": "",
            "removeEmptyElement": false,
            "alwaysPrintOnSamePage": true,
            "pattern": "",
            "link": "",
            "cs_condition": "",
            "cs_styleId": "",
            "cs_bold": false,
            "cs_italic": false,
            "cs_underline": false,
            "cs_strikethrough": false,
            "cs_horizontalAlignment": "left",
            "cs_verticalAlignment": "top",
            "cs_textColor": "#000000",
            "cs_backgroundColor": "",
            "cs_font": "helvetica",
            "cs_fontSize": 12,
            "cs_lineSpacing": 1,
            "cs_borderColor": "#000000",
            "cs_borderWidth": "1",
            "cs_borderAll": false,
            "cs_borderLeft": false,
            "cs_borderTop": false,
            "cs_borderRight": false,
            "cs_borderBottom": false,
            "cs_paddingLeft": 2,
            "cs_paddingTop": 2,
            "cs_paddingRight": 2,
            "cs_paddingBottom": 2,
            "spreadsheet_hide": false,
            "spreadsheet_column": "",
            "spreadsheet_colspan": "",
            "spreadsheet_addEmptyRow": false,
            "spreadsheet_textWrap": false
        },
        {
            "elementType": "text",
            "id": 8,
            "containerId": "0_footer",
            "x": 0,
            "y": 0,
            "width": 290,
            "height": 30,
            "content": "Created on ${current_date}",
            "richText": false,
            "richTextContent": null,
            "richTextHtml": "",
            "eval": false,
            "styleId": "",
            "bold": false,
            "italic": false,
            "underline": false,
            "strikethrough": false,
            "horizontalAlignment": "left",
            "verticalAlignment": "middle",
            "textColor": "#666666",
            "backgroundColor": "",
            "font": "notosans",
            "fontSize": 12,
            "lineSpacing": 1,
            "borderColor": "#000000",
            "borderWidth": 1,
            "borderAll": false,
            "borderLeft": false,
            "borderTop": false,
            "borderRight": false,
            "borderBottom": false,
            "paddingLeft": 2,
            "paddingTop": 2,
            "paddingRight": 2,
            "paddingBottom": 2,
            "printIf": "",
            "removeEmptyElement": false,
            "alwaysPrintOnSamePage": true,
            "pattern": "",
            "link": "",
            "cs_condition": "",
            "cs_styleId": "",
            "cs_bold": false,
            "cs_italic": false,
            "cs_underline": false,
            "cs_strikethrough": false,
            "cs_horizontalAlignment": "left",
            "cs_verticalAlignment": "top",
            "cs_textColor": "#000000",
            "cs_backgroundColor": "",
            "cs_font": "helvetica",
            "cs_fontSize": 12,
            "cs_lineSpacing": 1,
            "cs_borderColor": "#000000",
            "cs_borderWidth": "1",
            "cs_borderAll": false,
            "cs_borderLeft": false,
            "cs_borderTop": false,
            "cs_borderRight": false,
            "cs_borderBottom": false,
            "cs_paddingLeft": 2,
            "cs_paddingTop": 2,
            "cs_paddingRight": 2,
            "cs_paddingBottom": 2,
            "spreadsheet_hide": false,
            "spreadsheet_column": "",
            "spreadsheet_colspan": "",
            "spreadsheet_addEmptyRow": false,
            "spreadsheet_textWrap": false
        }
    ],
    "parameters": [
        {
            "id": 1,
            "name": "page_count",
            "type": "number",
            "arrayItemType": "string",
            "eval": false,
            "nullable": false,
            "pattern": "",
            "expression": "",
            "showOnlyNameType": true,
            "testData": ""
        },
        {
            "id": 2,
            "name": "page_number",
            "type": "number",
            "arrayItemType": "string",
            "eval": false,
            "nullable": false,
            "pattern": "",
            "expression": "",
            "showOnlyNameType": true,
            "testData": ""
        },
        {
            "id": 9,
            "name": "current_date",
            "type": "date",
            "arrayItemType": "string",
            "eval": false,
            "nullable": false,
            "pattern": "d/M/yyyy H:mm",
            "expression": "",
            "showOnlyNameType": false,
            "testData": ""
        },
        {
            "id": 272,
            "name": "data",
            "type": "array",
            "arrayItemType": "string",
            "eval": false,
            "nullable": false,
            "pattern": "",
            "expression": "",
            "showOnlyNameType": false,
            "testData": "",
            "children": [
                {
                    "id": 273,
                    "name": "row_number",
                    "type": "number",
                    "arrayItemType": "string",
                    "eval": false,
                    "nullable": false,
                    "pattern": "",
                    "expression": "",
                    "showOnlyNameType": true,
                    "testData": ""
                },
                {
                    "id": 321,
                    "name": "location_code",
                    "type": "string",
                    "arrayItemType": "string",
                    "eval": false,
                    "nullable": false,
                    "pattern": "",
                    "expression": "",
                    "showOnlyNameType": false,
                    "testData": ""
                },
                {
                    "id": 322,
                    "name": "location_name",
                    "type": "string",
                    "arrayItemType": "string",
                    "eval": false,
                    "nullable": false,
                    "pattern": "",
                    "expression": "",
                    "showOnlyNameType": false,
                    "testData": ""
                },
                {
                    "id": 585,
                    "name": "product_code",
                    "type": "string",
                    "arrayItemType": "string",
                    "eval": false,
                    "nullable": false,
                    "pattern": "",
                    "expression": "",
                    "showOnlyNameType": false,
                    "testData": ""
                },
                {
                    "id": 586,
                    "name": "product_name",
                    "type": "string",
                    "arrayItemType": "string",
                    "eval": false,
                    "nullable": false,
                    "pattern": "",
                    "expression": "",
                    "showOnlyNameType": false,
                    "testData": ""
                },
                {
                    "id": 591,
                    "name": "month_txt",
                    "type": "string",
                    "arrayItemType": "string",
                    "eval": false,
                    "nullable": false,
                    "pattern": "00",
                    "expression": "",
                    "showOnlyNameType": false,
                    "testData": ""
                },
                {
                    "id": 609,
                    "name": "collected",
                    "type": "number",
                    "arrayItemType": "string",
                    "eval": false,
                    "nullable": false,
                    "pattern": "$ #,##0.00",
                    "expression": "",
                    "showOnlyNameType": false,
                    "testData": ""
                },
                {
                    "id": 610,
                    "name": "not_allocated",
                    "type": "number",
                    "arrayItemType": "string",
                    "eval": false,
                    "nullable": false,
                    "pattern": "$ #,##0.00",
                    "expression": "",
                    "showOnlyNameType": false,
                    "testData": ""
                },
                {
                    "id": 611,
                    "name": "allocated",
                    "type": "number",
                    "arrayItemType": "string",
                    "eval": false,
                    "nullable": false,
                    "pattern": "$ #,##0.00",
                    "expression": "",
                    "showOnlyNameType": false,
                    "testData": ""
                },
                {
                    "id": 617,
                    "name": "location_type",
                    "type": "string",
                    "arrayItemType": "string",
                    "eval": false,
                    "nullable": false,
                    "pattern": "",
                    "expression": "",
                    "showOnlyNameType": false,
                    "testData": ""
                },
                {
                    "id": 621,
                    "name": "month_nbr",
                    "type": "number",
                    "arrayItemType": "string",
                    "eval": false,
                    "nullable": false,
                    "pattern": "",
                    "expression": "",
                    "showOnlyNameType": false,
                    "testData": ""
                }
            ]
        },
        {
            "id": 274,
            "name": "header",
            "type": "array",
            "arrayItemType": "string",
            "eval": false,
            "nullable": false,
            "pattern": "",
            "expression": "",
            "showOnlyNameType": false,
            "testData": "",
            "children": [
                {
                    "id": 275,
                    "name": "row_number",
                    "type": "number",
                    "arrayItemType": "string",
                    "eval": false,
                    "nullable": false,
                    "pattern": "",
                    "expression": "",
                    "showOnlyNameType": true,
                    "testData": ""
                },
                {
                    "id": 278,
                    "name": "region",
                    "type": "string",
                    "arrayItemType": "string",
                    "eval": false,
                    "nullable": false,
                    "pattern": "",
                    "expression": "",
                    "showOnlyNameType": false,
                    "testData": ""
                },
                {
                    "id": 279,
                    "name": "district",
                    "type": "string",
                    "arrayItemType": "string",
                    "eval": false,
                    "nullable": false,
                    "pattern": "",
                    "expression": "",
                    "showOnlyNameType": false,
                    "testData": ""
                },
                {
                    "id": 567,
                    "name": "product",
                    "type": "string",
                    "arrayItemType": "string",
                    "eval": false,
                    "nullable": false,
                    "pattern": "",
                    "expression": "",
                    "showOnlyNameType": false,
                    "testData": ""
                },
                {
                    "id": 569,
                    "name": "year",
                    "type": "number",
                    "arrayItemType": "string",
                    "eval": false,
                    "nullable": false,
                    "pattern": "",
                    "expression": "",
                    "showOnlyNameType": false,
                    "testData": ""
                },
                {
                    "id": 570,
                    "name": "month",
                    "type": "string",
                    "arrayItemType": "string",
                    "eval": false,
                    "nullable": false,
                    "pattern": "",
                    "expression": "",
                    "showOnlyNameType": false,
                    "testData": ""
                }
            ]
        },
        {
            "id": 309,
            "name": "error",
            "type": "string",
            "arrayItemType": "string",
            "eval": false,
            "nullable": false,
            "pattern": "",
            "expression": "",
            "showOnlyNameType": false,
            "testData": ""
        },
        {
            "id": 542,
            "name": "total_collected",
            "type": "number",
            "arrayItemType": "string",
            "eval": false,
            "nullable": true,
            "pattern": "$ #,##0.00",
            "expression": "",
            "showOnlyNameType": false,
            "testData": ""
        },
        {
            "id": 613,
            "name": "total_not_allocated",
            "type": "number",
            "arrayItemType": "string",
            "eval": false,
            "nullable": false,
            "pattern": "$ #,##0.00",
            "expression": "",
            "showOnlyNameType": false,
            "testData": ""
        },
        {
            "id": 614,
            "name": "total_allocated",
            "type": "number",
            "arrayItemType": "string",
            "eval": false,
            "nullable": false,
            "pattern": "$ #,##0.00",
            "expression": "",
            "showOnlyNameType": false,
            "testData": ""
        }
    ],
    "styles": [
        {
            "id": 33,
            "name": "Table Header",
            "bold": true,
            "italic": false,
            "underline": false,
            "strikethrough": false,
            "horizontalAlignment": "left",
            "verticalAlignment": "middle",
            "textColor": "#000000",
            "backgroundColor": "",
            "font": "notosans",
            "fontSize": "12",
            "lineSpacing": 1,
            "borderColor": "#000000",
            "borderWidth": "1",
            "borderAll": false,
            "borderLeft": false,
            "borderTop": false,
            "borderRight": false,
            "borderBottom": false,
            "paddingLeft": "2",
            "paddingTop": "2",
            "paddingRight": "2",
            "paddingBottom": "2"
        },
        {
            "id": 34,
            "name": "Table Content",
            "bold": false,
            "italic": false,
            "underline": false,
            "strikethrough": false,
            "horizontalAlignment": "left",
            "verticalAlignment": "middle",
            "textColor": "#000000",
            "backgroundColor": "",
            "font": "notosans",
            "fontSize": "11",
            "lineSpacing": 1,
            "borderColor": "#000000",
            "borderWidth": "1",
            "borderAll": false,
            "borderLeft": false,
            "borderTop": false,
            "borderRight": false,
            "borderBottom": false,
            "paddingLeft": "2",
            "paddingTop": "2",
            "paddingRight": "2",
            "paddingBottom": "2"
        },
        {
            "id": 35,
            "name": "Table Content Highlight",
            "bold": true,
            "italic": false,
            "underline": false,
            "strikethrough": false,
            "horizontalAlignment": "center",
            "verticalAlignment": "middle",
            "textColor": "#3d85c6",
            "backgroundColor": "",
            "font": "notosans",
            "fontSize": "9",
            "lineSpacing": 1,
            "borderColor": "#000000",
            "borderWidth": "1",
            "borderAll": false,
            "borderLeft": false,
            "borderTop": false,
            "borderRight": false,
            "borderBottom": false,
            "paddingLeft": "2",
            "paddingTop": "2",
            "paddingRight": "2",
            "paddingBottom": "2"
        },
        {
            "id": 286,
            "name": "Content header 1",
            "bold": true,
            "italic": false,
            "underline": false,
            "strikethrough": false,
            "horizontalAlignment": "left",
            "verticalAlignment": "middle",
            "textColor": "#ffffff",
            "backgroundColor": "#006374",
            "font": "notosans",
            "fontSize": 12,
            "lineSpacing": 1,
            "borderColor": "#000000",
            "borderWidth": "1",
            "borderAll": false,
            "borderLeft": false,
            "borderTop": false,
            "borderRight": false,
            "borderBottom": false,
            "paddingLeft": "2",
            "paddingTop": "2",
            "paddingRight": "2",
            "paddingBottom": "2"
        },
        {
            "id": 295,
            "name": "Content title",
            "bold": true,
            "italic": false,
            "underline": false,
            "strikethrough": false,
            "horizontalAlignment": "center",
            "verticalAlignment": "middle",
            "textColor": "#000000",
            "backgroundColor": "",
            "font": "notosans",
            "fontSize": 12,
            "lineSpacing": 1,
            "borderColor": "#000000",
            "borderWidth": "1",
            "borderAll": false,
            "borderLeft": false,
            "borderTop": false,
            "borderRight": false,
            "borderBottom": false,
            "paddingLeft": "2",
            "paddingTop": "2",
            "paddingRight": "2",
            "paddingBottom": "2"
        },
        {
            "id": 296,
            "name": "Content content",
            "bold": false,
            "italic": false,
            "underline": false,
            "strikethrough": false,
            "horizontalAlignment": "center",
            "verticalAlignment": "middle",
            "textColor": "#000000",
            "backgroundColor": "",
            "font": "notosans",
            "fontSize": "11",
            "lineSpacing": 1,
            "borderColor": "#000000",
            "borderWidth": "1",
            "borderAll": false,
            "borderLeft": false,
            "borderTop": false,
            "borderRight": false,
            "borderBottom": false,
            "paddingLeft": "2",
            "paddingTop": "2",
            "paddingRight": "2",
            "paddingBottom": "2"
        },
        {
            "id": 307,
            "name": "Error",
            "bold": true,
            "italic": false,
            "underline": false,
            "strikethrough": false,
            "horizontalAlignment": "center",
            "verticalAlignment": "middle",
            "textColor": "#ff0000",
            "backgroundColor": "",
            "font": "notosans",
            "fontSize": "16",
            "lineSpacing": 1,
            "borderColor": "#000000",
            "borderWidth": "1",
            "borderAll": false,
            "borderLeft": false,
            "borderTop": false,
            "borderRight": false,
            "borderBottom": false,
            "paddingLeft": "2",
            "paddingTop": "2",
            "paddingRight": "2",
            "paddingBottom": "2"
        },
        {
            "id": 337,
            "name": "Content header 2",
            "bold": true,
            "italic": false,
            "underline": false,
            "strikethrough": false,
            "horizontalAlignment": "left",
            "verticalAlignment": "middle",
            "textColor": "#ffffff",
            "backgroundColor": "#80B0B9",
            "font": "notosans",
            "fontSize": 12,
            "lineSpacing": 1,
            "borderColor": "#000000",
            "borderWidth": "1",
            "borderAll": false,
            "borderLeft": false,
            "borderTop": false,
            "borderRight": false,
            "borderBottom": false,
            "paddingLeft": "2",
            "paddingTop": "2",
            "paddingRight": "2",
            "paddingBottom": "2"
        },
        {
            "id": 338,
            "name": "No content",
            "bold": false,
            "italic": false,
            "underline": false,
            "strikethrough": false,
            "horizontalAlignment": "left",
            "verticalAlignment": "top",
            "textColor": "#cccccc",
            "backgroundColor": "#cccccc",
            "font": "helvetica",
            "fontSize": 12,
            "lineSpacing": 1,
            "borderColor": "#000000",
            "borderWidth": "1",
            "borderAll": false,
            "borderLeft": false,
            "borderTop": false,
            "borderRight": false,
            "borderBottom": false,
            "paddingLeft": "",
            "paddingTop": "",
            "paddingRight": "",
            "paddingBottom": ""
        },
        {
            "id": 341,
            "name": "Content header 3",
            "bold": true,
            "italic": false,
            "underline": false,
            "strikethrough": false,
            "horizontalAlignment": "left",
            "verticalAlignment": "middle",
            "textColor": "#ffffff",
            "backgroundColor": "#F4AE2B",
            "font": "notosans",
            "fontSize": 12,
            "lineSpacing": 1,
            "borderColor": "#000000",
            "borderWidth": "1",
            "borderAll": false,
            "borderLeft": false,
            "borderTop": false,
            "borderRight": false,
            "borderBottom": false,
            "paddingLeft": "2",
            "paddingTop": "2",
            "paddingRight": "2",
            "paddingBottom": "2"
        },
        {
            "id": 349,
            "name": "Footer",
            "bold": true,
            "italic": false,
            "underline": false,
            "strikethrough": false,
            "horizontalAlignment": "center",
            "verticalAlignment": "middle",
            "textColor": "#000000",
            "backgroundColor": "",
            "font": "notosans",
            "fontSize": 12,
            "lineSpacing": 1,
            "borderColor": "#000000",
            "borderWidth": "1",
            "borderAll": false,
            "borderLeft": false,
            "borderTop": false,
            "borderRight": false,
            "borderBottom": false,
            "paddingLeft": "2",
            "paddingTop": "2",
            "paddingRight": "2",
            "paddingBottom": "2"
        },
        {
            "id": 366,
            "name": "Subtotals",
            "bold": false,
            "italic": false,
            "underline": false,
            "strikethrough": false,
            "horizontalAlignment": "right",
            "verticalAlignment": "middle",
            "textColor": "#000000",
            "backgroundColor": "",
            "font": "notosans",
            "fontSize": 12,
            "lineSpacing": 1,
            "borderColor": "#000000",
            "borderWidth": "1",
            "borderAll": false,
            "borderLeft": false,
            "borderTop": false,
            "borderRight": false,
            "borderBottom": false,
            "paddingLeft": "2",
            "paddingTop": "2",
            "paddingRight": "2",
            "paddingBottom": "2"
        },
        {
            "id": 615,
            "name": "Colored subtotal 1",
            "bold": true,
            "italic": false,
            "underline": false,
            "strikethrough": false,
            "horizontalAlignment": "center",
            "verticalAlignment": "middle",
            "textColor": "#006374",
            "backgroundColor": "",
            "font": "notosans",
            "fontSize": 12,
            "lineSpacing": 1,
            "borderColor": "#000000",
            "borderWidth": "1",
            "borderAll": false,
            "borderLeft": false,
            "borderTop": false,
            "borderRight": false,
            "borderBottom": false,
            "paddingLeft": "2",
            "paddingTop": "2",
            "paddingRight": "2",
            "paddingBottom": "2"
        }
    ],
    "version": 3,
    "documentProperties": {
        "pageFormat": "A4",
        "pageWidth": "",
        "pageHeight": "",
        "unit": "mm",
        "orientation": "landscape",
        "contentHeight": "",
        "marginLeft": "10",
        "marginTop": "10",
        "marginRight": "10",
        "marginBottom": "10",
        "header": true,
        "headerSize": "80",
        "headerDisplay": "always",
        "footer": true,
        "footerSize": "30",
        "footerDisplay": "always",
        "patternLocale": "en",
        "patternCurrencySymbol": "$"
    }
}
"""

ALL_MONTHS = -42
DEFAULT_PRODUCT = -1
DEFAULT_YEAR = 0

CATEGORY_COLLECTED = "C"
CATEGORY_ALLOCATED = "A"
CATEGORY_NOT_ALLOCATED = "N"

NO_LOCATION_CODE = "XXXX"
LOCATION_NATIONAL = "National"
LOCATION_REGIONAL = "Regional"


def generate_subtotal():
    return {
        CATEGORY_COLLECTED: Decimal(0.00),
        CATEGORY_ALLOCATED: Decimal(0.00),
        CATEGORY_NOT_ALLOCATED: Decimal(0.00),
    }


def calculate_start_end_month_dates(year: int, month: int):
    num_days = calendar.monthrange(year, month)[1]
    start_date = date(year, month, 1)
    end_date = date(year, month, num_days)
    return start_date, end_date


def prepare_location_info(product: Product):
    location_info = {}
    product_location = product.location
    if not product_location:
        location_info["location_code"] = NO_LOCATION_CODE
        location_info["location_name"] = LOCATION_NATIONAL
        location_info["type"] = "N"
    else:
        location_info["location_code"] = product_location.code
        location_info["location_name"] = product_location.name
        location_info["type"] = product_location.type
    return location_info


def fetch_collected_contributions(search_filters: Q, start_date: AdDate, end_date: AdDate):
    # Returns the total amount that was collected in a given time period.
    total_collected = Decimal(0.00)
    premiums = Premium.objects.filter(search_filters,
                                      ~Q(policy__status=1),
                                      pay_date__range=[start_date, end_date]) \
                              .values(product_id=F("policy__product_id")) \
                              .annotate(collected=Sum("amount")) \
                              .order_by()
    for premium in premiums:
        total_collected += premium["collected"]
    return total_collected


def fetch_not_allocated_contributions(search_filters: Q, start_date: AdDate, end_date: AdDate):
    # Returns the total amount that was not allocated in a given time period.
    # 'Not allocated' means that the amount was collected for a policy that will start in the future
    # (after the given time period).
    total_not_allocated = Decimal(0.00)
    premiums = Premium.objects.filter(search_filters,
                                      Q(Q(policy__status=1) | Q(pay_date__gt=F("policy__expiry_date"))),
                                      pay_date__range=[start_date, end_date]) \
                              .values(product_id=F("policy__product_id")) \
                              .annotate(not_allocated=Sum("amount")) \
                              .order_by()
    for premium in premiums:
        total_not_allocated += premium["not_allocated"]
    return total_not_allocated


def fetch_allocated_contributions(search_filters: Q, start_date: AdDate, end_date: AdDate):
    # Returns the total amount that was allocated in a given time period.
    # 'Allocated' means the proportionally calculated amount that was paid for the given time period.
    total_allocated = Decimal(0.00)
    contributions = Premium.objects.filter(search_filters,
                                           ~Q(policy__status=1),
                                           Q(pay_date__lte=F("policy__expiry_date")),
                                           policy__expiry_date__gte=start_date,
                                           pay_date__lte=end_date,
                                           policy__effective_date__lte=end_date) \
                                   .values("amount",
                                           "pay_date",
                                           effective_date=F("policy__effective_date"),
                                           expiry_date=F("policy__expiry_date"),
                                           product_id=F("policy__product_id"),
                                           location_id=F("policy__product__location_id")) \
                                   .annotate(numerator_date_1=ExpressionWrapper(Greatest(start_date, F("pay_date"), F("effective_date")), output_field=DateField())) \
                                   .annotate(numerator_date_2=ExpressionWrapper(Least(F("expiry_date"), end_date), output_field=DateField())) \
                                   .annotate(denominator_date=ExpressionWrapper(Greatest(F("pay_date"), F("effective_date")), output_field=DateField()))

    for contribution in contributions:
        # Basically this checks how much money was paid and divides it by the number of days covered
        expiry_date = contribution["expiry_date"]
        numerator_date_1 = contribution["numerator_date_1"]
        numerator_date_2 = contribution["numerator_date_2"]
        denominator_date = contribution["denominator_date"]

        delta_numerator = numerator_date_2 - numerator_date_1
        delta_denominator = expiry_date - denominator_date

        numerator = (1 + delta_numerator.days) * contribution["amount"]
        denominator = delta_denominator.days if delta_denominator.days > 0 else 1
        total_allocated += numerator / denominator

    return total_allocated


def format_totals(subtotals: dict, report_data: dict):
    # Adds and formats total figures to the report data
    report_data["total_collected"] = subtotals[CATEGORY_COLLECTED]
    report_data["total_not_allocated"] = subtotals[CATEGORY_NOT_ALLOCATED]
    report_data["total_allocated"] = subtotals[CATEGORY_ALLOCATED]


def contributions_distribution_query(user,
                                     requested_month=ALL_MONTHS,
                                     requested_year=DEFAULT_YEAR,
                                     requested_product_id=DEFAULT_PRODUCT,
                                     **kwargs):
    # This report calculates the various amounts that were paid for a given product and time window, and splits
    # them into 3 categories (collected, not allocated, allocated).
    # Please refer to the documentation above for explications about these categories.
    # /!\ The initial legacy report contains a region and a district, but they were not used,
    # they simply restricted the product picker options. So they were removed from this report.

    # Checking the parameters received and returning an error if anything is wrong
    month = int(requested_month)
    if month not in range(1, 13) and month != ALL_MONTHS:
        return {"error": "Error - the selected month is invalid"}
    year = int(requested_year)
    if year not in range(2010, 2100):
        return {"error": "Error - the selected year is invalid"}
    product_id = int(requested_product_id)
    product = Product.objects.filter(validity_to__isnull=True, id=product_id).first()
    if not product:
        return {"error": "Error - the requested product does not exist"}

    # Preparing reference data that will be used later
    location_information = prepare_location_info(product)
    months_txt = calendar.month_name[1:]

    # Preparing data for the header table
    header = {
        "product": f"{product.code} - {product.name}",
        "month": months_txt[month - 1] if month != ALL_MONTHS else "All months",
        "year": year,
    }
    report_data = {
        "header": [header],
    }

    # Preparing the search criteria based on the received parameters
    search_filters = (Q(validity_to__isnull=True)
                      & Q(policy__validity_to__isnull=True)
                      & Q(policy__product_id=product_id)
                      & Q(policy__product__validity_to__isnull=True))

    data = []
    totals = generate_subtotal()
    working_months = list(range(1, 13)) if month == ALL_MONTHS else [month]

    for current_month in working_months:

        start_date, end_date = calculate_start_end_month_dates(year, current_month)

        collected = fetch_collected_contributions(search_filters, start_date, end_date)
        not_allocated = fetch_not_allocated_contributions(search_filters, start_date, end_date)
        allocated = fetch_allocated_contributions(search_filters, start_date, end_date)

        new_data_element = {
            "month_nbr": current_month,
            "month_txt": months_txt[current_month - 1],
            "year": year,
            "product_code": product.code,
            "product_name": product.name,
            "location_code": location_information["location_code"],
            "location_name": location_information["location_name"],
            "location_type": location_information["type"],
            "collected": collected,
            "not_allocated": not_allocated,
            "allocated": allocated,
        }

        totals[CATEGORY_COLLECTED] += collected
        totals[CATEGORY_NOT_ALLOCATED] += not_allocated
        totals[CATEGORY_ALLOCATED] += allocated

        data.append(new_data_element)

    format_totals(totals, report_data)
    report_data["data"] = data
    return report_data
