"""
    local-api

    local api for linksaas desktop  # noqa: E501

    The version of the OpenAPI document: 0.1.3
    Contact: panleiming@linksaas.pro
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from linksaas_local_api.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from linksaas_local_api.exceptions import ApiAttributeError



class BugInfo(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('state',): {
            'PLAN': "plan",
            'PROCESS': "process",
            'CHECK': "check",
            'CLOSE': "close",
        },
        ('level',): {
            'MINOR': "minor",
            'MAJOR': "major",
            'CRITICAL': "critical",
            'BLOCKER': "blocker",
        },
        ('priority',): {
            'LOW': "low",
            'NORMAL': "normal",
            'HIGH': "high",
            'URGENT': "urgent",
            'IMMEDIATE': "immediate",
        },
    }

    validations = {
        ('exec_award_point',): {
            'inclusive_minimum': 0,
        },
        ('check_award_point',): {
            'inclusive_minimum': 0,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'bug_id': (str,),  # noqa: E501
            'title': (str,),  # noqa: E501
            'state': (str,),  # noqa: E501
            'create_user_id': (str,),  # noqa: E501
            'create_display_name': (str,),  # noqa: E501
            'exec_user_id': (str,),  # noqa: E501
            'exec_display_name': (str,),  # noqa: E501
            'check_user_id': (str,),  # noqa: E501
            'check_display_name': (str,),  # noqa: E501
            'exec_award_point': (int,),  # noqa: E501
            'check_award_point': (int,),  # noqa: E501
            'create_time': (int,),  # noqa: E501
            'update_time': (int,),  # noqa: E501
            'software_version': (str,),  # noqa: E501
            'level': (str,),  # noqa: E501
            'priority': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'bug_id': 'bugId',  # noqa: E501
        'title': 'title',  # noqa: E501
        'state': 'state',  # noqa: E501
        'create_user_id': 'createUserId',  # noqa: E501
        'create_display_name': 'createDisplayName',  # noqa: E501
        'exec_user_id': 'execUserId',  # noqa: E501
        'exec_display_name': 'execDisplayName',  # noqa: E501
        'check_user_id': 'checkUserId',  # noqa: E501
        'check_display_name': 'checkDisplayName',  # noqa: E501
        'exec_award_point': 'execAwardPoint',  # noqa: E501
        'check_award_point': 'checkAwardPoint',  # noqa: E501
        'create_time': 'createTime',  # noqa: E501
        'update_time': 'updateTime',  # noqa: E501
        'software_version': 'softwareVersion',  # noqa: E501
        'level': 'level',  # noqa: E501
        'priority': 'priority',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """BugInfo - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            bug_id (str): 缺陷ID. [optional]  # noqa: E501
            title (str): 标题. [optional]  # noqa: E501
            state (str): 状态. [optional]  # noqa: E501
            create_user_id (str): 创建人ID. [optional]  # noqa: E501
            create_display_name (str): 创建人名称. [optional]  # noqa: E501
            exec_user_id (str): 执行人ID. [optional]  # noqa: E501
            exec_display_name (str): 执行人名称. [optional]  # noqa: E501
            check_user_id (str): 检查人ID. [optional]  # noqa: E501
            check_display_name (str): 检查人名称. [optional]  # noqa: E501
            exec_award_point (int): 执行奖励. [optional]  # noqa: E501
            check_award_point (int): 检查奖励. [optional]  # noqa: E501
            create_time (int): 创建时间. [optional]  # noqa: E501
            update_time (int): 更新时间. [optional]  # noqa: E501
            software_version (str): 软件版本. [optional]  # noqa: E501
            level (str): 缺陷级别. [optional]  # noqa: E501
            priority (str): 优先级. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """BugInfo - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            bug_id (str): 缺陷ID. [optional]  # noqa: E501
            title (str): 标题. [optional]  # noqa: E501
            state (str): 状态. [optional]  # noqa: E501
            create_user_id (str): 创建人ID. [optional]  # noqa: E501
            create_display_name (str): 创建人名称. [optional]  # noqa: E501
            exec_user_id (str): 执行人ID. [optional]  # noqa: E501
            exec_display_name (str): 执行人名称. [optional]  # noqa: E501
            check_user_id (str): 检查人ID. [optional]  # noqa: E501
            check_display_name (str): 检查人名称. [optional]  # noqa: E501
            exec_award_point (int): 执行奖励. [optional]  # noqa: E501
            check_award_point (int): 检查奖励. [optional]  # noqa: E501
            create_time (int): 创建时间. [optional]  # noqa: E501
            update_time (int): 更新时间. [optional]  # noqa: E501
            software_version (str): 软件版本. [optional]  # noqa: E501
            level (str): 缺陷级别. [optional]  # noqa: E501
            priority (str): 优先级. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
