"""
    local-api

    local api for linksaas desktop  # noqa: E501

    The version of the OpenAPI document: 0.1.3
    Contact: panleiming@linksaas.pro
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from linksaas_local_api.api_client import ApiClient, Endpoint as _Endpoint
from linksaas_local_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from linksaas_local_api.model.channel_info import ChannelInfo
from linksaas_local_api.model.err_info import ErrInfo
from linksaas_local_api.model.msg_info import MsgInfo


class ProjectChannelApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.project_project_id_channel_msg_channel_id_get_endpoint = _Endpoint(
            settings={
                'response_type': ([MsgInfo],),
                'auth': [],
                'endpoint_path': '/project/{projectId}/channel/msg/{channelId}',
                'operation_id': 'project_project_id_channel_msg_channel_id_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'channel_id',
                    'access_token',
                    'limit',
                    'ref_msg_id',
                ],
                'required': [
                    'project_id',
                    'channel_id',
                    'access_token',
                    'limit',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'channel_id':
                        (str,),
                    'access_token':
                        (str,),
                    'limit':
                        (int,),
                    'ref_msg_id':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'channel_id': 'channelId',
                    'access_token': 'accessToken',
                    'limit': 'limit',
                    'ref_msg_id': 'refMsgId',
                },
                'location_map': {
                    'project_id': 'path',
                    'channel_id': 'path',
                    'access_token': 'query',
                    'limit': 'query',
                    'ref_msg_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.project_project_id_channel_my_get_endpoint = _Endpoint(
            settings={
                'response_type': ([ChannelInfo],),
                'auth': [],
                'endpoint_path': '/project/{projectId}/channel/my',
                'operation_id': 'project_project_id_channel_my_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'access_token',
                ],
                'required': [
                    'project_id',
                    'access_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'access_token':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'access_token': 'accessToken',
                },
                'location_map': {
                    'project_id': 'path',
                    'access_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.project_project_id_channel_not_join_get_endpoint = _Endpoint(
            settings={
                'response_type': ([ChannelInfo],),
                'auth': [],
                'endpoint_path': '/project/{projectId}/channel/notJoin',
                'operation_id': 'project_project_id_channel_not_join_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'access_token',
                ],
                'required': [
                    'project_id',
                    'access_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'access_token':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'access_token': 'accessToken',
                },
                'location_map': {
                    'project_id': 'path',
                    'access_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.project_project_id_channel_orphan_get_endpoint = _Endpoint(
            settings={
                'response_type': ([ChannelInfo],),
                'auth': [],
                'endpoint_path': '/project/{projectId}/channel/orphan',
                'operation_id': 'project_project_id_channel_orphan_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'access_token',
                ],
                'required': [
                    'project_id',
                    'access_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'access_token':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'access_token': 'accessToken',
                },
                'location_map': {
                    'project_id': 'path',
                    'access_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def project_project_id_channel_msg_channel_id_get(
        self,
        project_id,
        channel_id,
        access_token,
        limit,
        **kwargs
    ):
        """列出沟通内容  # noqa: E501

        列出沟通内容(从后往前)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.project_project_id_channel_msg_channel_id_get(project_id, channel_id, access_token, limit, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str): 项目ID
            channel_id (str): 频道ID
            access_token (str): 访问令牌
            limit (int): 列表大小

        Keyword Args:
            ref_msg_id (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [MsgInfo]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['project_id'] = \
            project_id
        kwargs['channel_id'] = \
            channel_id
        kwargs['access_token'] = \
            access_token
        kwargs['limit'] = \
            limit
        return self.project_project_id_channel_msg_channel_id_get_endpoint.call_with_http_info(**kwargs)

    def project_project_id_channel_my_get(
        self,
        project_id,
        access_token,
        **kwargs
    ):
        """我的沟通频道  # noqa: E501

        列出我的沟通频道  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.project_project_id_channel_my_get(project_id, access_token, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str): 项目ID
            access_token (str): 访问令牌

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [ChannelInfo]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['project_id'] = \
            project_id
        kwargs['access_token'] = \
            access_token
        return self.project_project_id_channel_my_get_endpoint.call_with_http_info(**kwargs)

    def project_project_id_channel_not_join_get(
        self,
        project_id,
        access_token,
        **kwargs
    ):
        """我未加入的频道  # noqa: E501

        列出我未加入的频道(需要管理员权限)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.project_project_id_channel_not_join_get(project_id, access_token, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str): 项目ID
            access_token (str): 访问令牌

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [ChannelInfo]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['project_id'] = \
            project_id
        kwargs['access_token'] = \
            access_token
        return self.project_project_id_channel_not_join_get_endpoint.call_with_http_info(**kwargs)

    def project_project_id_channel_orphan_get(
        self,
        project_id,
        access_token,
        **kwargs
    ):
        """孤儿频道  # noqa: E501

        列出孤儿频道  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.project_project_id_channel_orphan_get(project_id, access_token, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str): 项目ID
            access_token (str): 访问令牌

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [ChannelInfo]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['project_id'] = \
            project_id
        kwargs['access_token'] = \
            access_token
        return self.project_project_id_channel_orphan_get_endpoint.call_with_http_info(**kwargs)

