"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.addCdkConstructVersionTag = exports.Datadog = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const loglevel_1 = require("loglevel");
const transport_1 = require("./common/transport");
const index_1 = require("./index");
const versionJson = require("../version.json");
/**
 * @stability stable
 */
class Datadog extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        if (((_b = process.env.DD_CONSTRUCT_DEBUG_LOGS) === null || _b === void 0 ? void 0 : _b.toLowerCase()) == "true") {
            loglevel_1.default.setLevel("debug");
        }
        super(scope, id);
        this.scope = scope;
        this.props = props;
        index_1.validateProps(this.props);
        this.transport = new transport_1.Transport(this.props.flushMetricsToLogs, this.props.site, this.props.apiKey, this.props.apiKeySecretArn, this.props.apiKmsKey, this.props.extensionLayerVersion);
    }
    /**
     * @stability stable
     */
    addLambdaFunctions(lambdaFunctions) {
        const baseProps = index_1.handleSettingPropDefaults(this.props);
        if (this.props !== undefined && lambdaFunctions.length > 0) {
            const region = `${lambdaFunctions[0].env.region}`;
            loglevel_1.default.debug(`Using region: ${region}`);
            if (baseProps.addLayers) {
                index_1.applyLayers(this.scope, region, lambdaFunctions, this.props.pythonLayerVersion, this.props.nodeLayerVersion, this.props.extensionLayerVersion);
            }
            index_1.redirectHandlers(lambdaFunctions, baseProps.addLayers);
            if (this.props.forwarderArn !== undefined) {
                if (this.props.extensionLayerVersion !== undefined) {
                    loglevel_1.default.debug(`Skipping adding subscriptions to the lambda log groups since the extension is enabled`);
                }
                else {
                    loglevel_1.default.debug(`Adding log subscriptions using provided Forwarder ARN: ${this.props.forwarderArn}`);
                    index_1.addForwarder(this.scope, lambdaFunctions, this.props.forwarderArn);
                }
            }
            else {
                loglevel_1.default.debug("Forwarder ARN not provided, no log group subscriptions will be added");
            }
            addCdkConstructVersionTag(lambdaFunctions);
            index_1.applyEnvVariables(lambdaFunctions, baseProps);
            index_1.setDDEnvVariables(lambdaFunctions, this.props);
            setTags(lambdaFunctions, this.props);
            this.transport.applyEnvVars(lambdaFunctions);
        }
    }
    /**
     * @stability stable
     */
    addGitCommitMetadata(lambdaFunctions, gitCommitSha) {
        index_1.setGitCommitHashEnvironmentVariable(lambdaFunctions, gitCommitSha);
    }
    /**
     * @stability stable
     */
    addForwarderToNonLambdaLogGroups(logGroups) {
        if (this.props.forwarderArn !== undefined) {
            index_1.addForwarderToLogGroups(this.scope, logGroups, this.props.forwarderArn);
        }
        else {
            loglevel_1.default.debug("Forwarder ARN not provided, no non lambda log group subscriptions will be added");
        }
    }
}
exports.Datadog = Datadog;
_a = JSII_RTTI_SYMBOL_1;
Datadog[_a] = { fqn: "datadog-cdk-constructs.Datadog", version: "0.8.3" };
function addCdkConstructVersionTag(lambdaFunctions) {
    loglevel_1.default.debug(`Adding CDK Construct version tag: ${versionJson.version}`);
    lambdaFunctions.forEach((functionName) => {
        cdk.Tags.of(functionName).add(index_1.TagKeys.CDK, `v${versionJson.version}`, {
            includeResourceTypes: ["AWS::Lambda::Function"],
        });
    });
}
exports.addCdkConstructVersionTag = addCdkConstructVersionTag;
function setTags(lambdaFunctions, props) {
    loglevel_1.default.debug(`Adding datadog tags`);
    lambdaFunctions.forEach((functionName) => {
        if (props.forwarderArn) {
            if (props.env) {
                cdk.Tags.of(functionName).add(index_1.TagKeys.ENV, props.env);
            }
            if (props.service) {
                cdk.Tags.of(functionName).add(index_1.TagKeys.SERVICE, props.service);
            }
            if (props.version) {
                cdk.Tags.of(functionName).add(index_1.TagKeys.VERSION, props.version);
            }
            if (props.tags) {
                const tagsArray = props.tags.split(",");
                tagsArray.forEach((tag) => {
                    const [key, value] = tag.split(":");
                    if (key && value) {
                        cdk.Tags.of(functionName).add(key, value);
                    }
                });
            }
        }
    });
}
//# sourceMappingURL=data:application/json;base64,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