"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.govCloudRegions = exports.runtimeToLayerName = exports.runtimeLookup = exports.TagKeys = exports.DefaultDatadogProps = exports.RuntimeType = exports.SUBSCRIPTION_FILTER_PREFIX = exports.JS_HANDLER = exports.JS_HANDLER_WITH_LAYERS = exports.PYTHON_HANDLER = exports.DD_HANDLER_ENV_VAR = exports.DD_GOV_ACCOUNT_ID = exports.DD_ACCOUNT_ID = exports.EXTENSION_LAYER_PREFIX = exports.LAYER_PREFIX = void 0;
exports.LAYER_PREFIX = "DatadogLayer";
exports.EXTENSION_LAYER_PREFIX = "DatadogExtension";
exports.DD_ACCOUNT_ID = "464622532012";
exports.DD_GOV_ACCOUNT_ID = "002406178527";
exports.DD_HANDLER_ENV_VAR = "DD_LAMBDA_HANDLER";
exports.PYTHON_HANDLER = "datadog_lambda.handler.handler";
exports.JS_HANDLER_WITH_LAYERS = "/opt/nodejs/node_modules/datadog-lambda-js/handler.handler";
exports.JS_HANDLER = "node_modules/datadog-lambda-js/dist/handler.handler";
exports.SUBSCRIPTION_FILTER_PREFIX = "DatadogSubscriptionFilter";
/**
 * @stability stable
 */
var RuntimeType;
(function (RuntimeType) {
    RuntimeType[RuntimeType["NODE"] = 0] = "NODE";
    RuntimeType[RuntimeType["PYTHON"] = 1] = "PYTHON";
    RuntimeType[RuntimeType["UNSUPPORTED"] = 2] = "UNSUPPORTED";
})(RuntimeType = exports.RuntimeType || (exports.RuntimeType = {}));
exports.DefaultDatadogProps = {
    addLayers: true,
    enableDatadogTracing: true,
    injectLogContext: true,
    enableDatadogLogs: true,
    architecture: "X86_64",
    captureLambdaPayload: false,
};
/**
 * @stability stable
 */
var TagKeys;
(function (TagKeys) {
    TagKeys["CDK"] = "dd_cdk_construct";
    TagKeys["ENV"] = "env";
    TagKeys["SERVICE"] = "service";
    TagKeys["VERSION"] = "version";
})(TagKeys = exports.TagKeys || (exports.TagKeys = {}));
exports.runtimeLookup = {
    "nodejs12.x": RuntimeType.NODE,
    "nodejs14.x": RuntimeType.NODE,
    "nodejs16.x": RuntimeType.NODE,
    "python3.6": RuntimeType.PYTHON,
    "python3.7": RuntimeType.PYTHON,
    "python3.8": RuntimeType.PYTHON,
    "python3.9": RuntimeType.PYTHON,
};
exports.runtimeToLayerName = {
    "nodejs12.x": "Datadog-Node12-x",
    "nodejs14.x": "Datadog-Node14-x",
    "nodejs16.x": "Datadog-Node16-x",
    "python3.6": "Datadog-Python36",
    "python3.7": "Datadog-Python37",
    "python3.8": "Datadog-Python38",
    "python3.9": "Datadog-Python39",
};
exports.govCloudRegions = ["us-gov-east-1", "us-gov-west-1"];
//# sourceMappingURL=data:application/json;base64,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