import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GroupSamlLinkConfig extends cdktf.TerraformMetaArguments {
    /**
    * Access level for members of the SAML group. Valid values are: `guest`, `reporter`, `developer`, `maintainer`, `owner`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_saml_link#access_level GroupSamlLink#access_level}
    */
    readonly accessLevel: string;
    /**
    * The ID or path of the group to add the SAML Group Link to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_saml_link#group GroupSamlLink#group}
    */
    readonly group: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_saml_link#id GroupSamlLink#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the SAML group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_saml_link#saml_group_name GroupSamlLink#saml_group_name}
    */
    readonly samlGroupName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/group_saml_link gitlab_group_saml_link}
*/
export declare class GroupSamlLink extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_group_saml_link";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/group_saml_link gitlab_group_saml_link} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupSamlLinkConfig
    */
    constructor(scope: Construct, id: string, config: GroupSamlLinkConfig);
    private _accessLevel?;
    get accessLevel(): string;
    set accessLevel(value: string);
    get accessLevelInput(): string | undefined;
    private _group?;
    get group(): string;
    set group(value: string);
    get groupInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _samlGroupName?;
    get samlGroupName(): string;
    set samlGroupName(value: string);
    get samlGroupNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
