# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['sesame']

package_data = \
{'': ['*']}

install_requires = \
['django>=3.2']

extras_require = \
{'ua': ['ua-parser>=0.10']}

setup_kwargs = {
    'name': 'django-sesame',
    'version': '3.1',
    'description': 'Frictionless authentication with "Magic Links" for your Django project.',
    'long_description': '.. image:: logo/horizontal.svg\n   :width: 400px\n   :alt: django-sesame\n\ndjango-sesame provides frictionless authentication with "Magic Links" for\nyour Django project.\n\nIt generates URLs containing authentication tokens such as:\nhttps://example.com/?sesame=zxST9d0XT9xgfYLvoa9e2myN\n\nThen it authenticates users based on tokens found in URLs.\n\nMore broadly, it supports a wide range of `use cases`_ for\nstateless, token-based authentication.\n\nPlease review `(in)security`_ considerations before using django-sesame.\n\n----\n\n`Documentation is available on ReadTheDocs.`__\n\n----\n\n__ https://django-sesame.readthedocs.io/en/stable/\n\nRequirements\n------------\n\ndjango-sesame is tested with:\n\n- Django 3.2 (LTS) and 4.0;\n- Python ≥ 3.6.\n\nIt requires ``django.contrib.auth``.\n\nGetting started\n---------------\n\nInstall django-sesame:\n\n.. code-block:: console\n\n    $ pip install django-sesame\n\nOpen your project settings and add ``"sesame.backends.ModelBackend"`` to the\n``AUTHENTICATION_BACKENDS`` setting. Extending the default value, this\nlooks like:\n\n.. code-block:: python\n\n    AUTHENTICATION_BACKENDS = [\n        "django.contrib.auth.backends.ModelBackend",\n        "sesame.backends.ModelBackend",\n    ]\n\nNow, your project can authenticate users based on django-sesame tokens.\n\nQuick example\n-------------\n\nConfigure ``LoginView`` in your URLconf:\n\n.. code-block:: python\n\n    from django.urls import path\n    from sesame.views import LoginView\n\n    urlpatterns = [\n        ...,\n        path("sesame/login/", LoginView.as_view(), name="sesame-login"),\n        ...,\n    ]\n\nLoad a user from the database:\n\n.. code-block:: pycon\n\n    >>> from django.contrib.auth import get_user_model\n    >>> User = get_user_model()\n    >>> user = User.objects.first()\n\nGenerate a login URL for this user:\n\n.. code-block:: pycon\n\n    >>> from sesame.utils import get_query_string\n    >>> LOGIN_URL = "https://127.0.0.1:8000/sesame/login/"\n    >>> LOGIN_URL + get_query_string(user)\n    \'https://127.0.0.1:8000/sesame/login/?sesame=zxST9d0XT9xgfYLvoa9e2myN\'\n\n(Your token will be different from this example.)\n\nMake sure that you\'re logged out. Open the login URL. You are logged in!\n\nUse cases\n---------\n\nKnown use cases for django-sesame include:\n\n1. Login by email, an attractive option on mobile where typing passwords\n   is uncomfortable. This technique is prominently deployed by Slack.\n\n   If you\'re doing this, you should define a small ``SESAME_MAX_AGE``, perhaps\n   10 minutes.\n\n2. Authenticated links. For example, you can generate a report offline\n   and, when it\'s ready, email a link to access it. Authenticated links work\n   even if the user isn\'t logged in on the device where they\'re opening it.\n\n   Likewise, you should configure an appropriate ``SESAME_MAX_AGE``,\n   probably a few days.\n\n   Since emails may be forwarded, authenticated links shouldn\'t log the user\n   in. They should only allow access to specific views.\n\n3. Sharing links, which are a variant of authenticated links. When a user shares\n   content with a guest, you may create a phantom account for the guest and\n   generate an authenticated link tied to that account or you may reuse the\n   user\'s account.\n\n   Email forwarding is also likely in this context. Make sure that sharing links\n   don\'t log the user in.\n\n4. Authentication of WebSocket connections. The web application gets a token\n   generated by the Django server and sends it over the WebSocket connection.\n   The WebSocket server authenticate the connection with the token.\n\n   Here\'s an `example with the websockets library`__.\n\n   __ https://websockets.readthedocs.io/en/stable/howto/django.html\n\n5. Non-critical private websites, for example for a family or club site,\n   where users don\'t expect to manage a personal account with a password.\n   Authorized users can bookmark personalized authenticated URLs.\n\n   Here you can rely on the default settings because that\'s the original —\n   admittedly, niche — use case for which django-sesame was built.\n\n(In)security\n------------\n\nThe major security weakness in django-sesame is a direct consequence of the\nfeature it implements: **whoever obtains an authentication token is able to\nauthenticate to your website.**\n\nURLs end up in countless insecure places: emails, referer headers, proxy logs,\nbrowser history, etc. You can\'t avoid that. At best you can mitigate it by\ncreating short-lived or single-use tokens.\n\nOtherwise, a reasonable attempt was made to provide a secure solution. Tokens\nare secured with modern cryptography. There are configurable options for token\ninvalidation.\n',
    'author': 'Aymeric Augustin',
    'author_email': 'aymeric.augustin@m4x.org',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/aaugustin/django-sesame',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.6.2',
}


setup(**setup_kwargs)
