from quick_resto_API.operations_with_objects.operations_with_objects import OperationsWithObjects
from quick_resto_API.operations_with_objects.system_object import SystemObject
from quick_resto_API.quick_resto_api import QuickRestoApi
from quick_resto_API.quick_resto_objects.modules.crm.customer import CrmCustomer

class CrmCustomerOperations(SystemObject):
    def __init__(self, api: QuickRestoApi):
        self._operations_with_objects = OperationsWithObjects(api)

        self._module_name:str = "crm.customer"

    def get_list_of_crm_customer(self, ownerContextId: int = None, ownerContextClassName: str = None,
                           showDeleted: bool = False) -> list[CrmCustomer]:

        json_response = self._operations_with_objects.getList(self._module_name,
                                                              ownerContextId, ownerContextClassName, showDeleted).json()

        result:list[CrmCustomer] = list()

        for object in json_response:
            result.append(CrmCustomer(**object))

        return result

    def get_tree_of_crm_customer(self, ownerContextId: int = None, ownerContextClassName: str = None,
                           showDeleted: bool = False) -> list[CrmCustomer]:

        json_response = self._operations_with_objects.getTree(self._module_name,
                                                              ownerContextId, ownerContextClassName, showDeleted).json()

        result:list[CrmCustomer] = list()

        for object in json_response:
            result.append(CrmCustomer(**object))

        return result

    def get_crm_customer(self, objectId: int, objectRid: int = None) -> CrmCustomer:
        json_response = self._operations_with_objects.getObject(self._module_name, objectId, objectRid).json()

        return CrmCustomer(**json_response)

    def get_crm_customer_with_subobjects(self, objectId: int, objectRid: int = None) -> CrmCustomer:
        json_response = self._operations_with_objects.getObjectWithSubobjects(self._module_name, objectId, objectRid).json()

        return CrmCustomer(**json_response)

    def create_crm_customer(self, object: CrmCustomer,ownerContextId: int = None,
                                                ownerContextClassName: str = None, parentContextId: int = None,
                                                parentContextClassName: str = None) -> CrmCustomer:

        json_response = self._operations_with_objects.createObject(object, self._module_name, ownerContextId, 
                                                ownerContextClassName, parentContextId, parentContextClassName).json()

        return CrmCustomer(**json_response)

    def update_crm_customer(self, object: CrmCustomer,ownerContextId: int = None,
                                                ownerContextClassName: str = None, parentContextId: int = None,
                                                parentContextClassName: str = None) -> CrmCustomer:

        json_response = self._operations_with_objects.updateObject(object, self._module_name, ownerContextId, 
                                                ownerContextClassName, parentContextId, parentContextClassName).json()

        return CrmCustomer(**json_response)

    def remove_crm_customer(self, object: CrmCustomer,ownerContextId: int = None,
                                                ownerContextClassName: str = None, parentContextId: int = None,
                                                parentContextClassName: str = None) -> CrmCustomer:

        json_response = self._operations_with_objects.removeObject(object, self._module_name, ownerContextId, 
                                                ownerContextClassName, parentContextId, parentContextClassName).json()

        return CrmCustomer(**json_response)

    def recover_crm_customer(self, object: CrmCustomer,ownerContextId: int = None,
                                                ownerContextClassName: str = None, parentContextId: int = None,
                                                parentContextClassName: str = None) -> CrmCustomer:

        json_response = self._operations_with_objects.recoverObject(object, self._module_name, ownerContextId, 
                                                ownerContextClassName, parentContextId, parentContextClassName).json()

        return CrmCustomer(**json_response)