# -*- coding: utf-8 -*-
"""
| ----------------------------------------------------------------------------------------------------------------------
| Date                : March 2020
| Copyright           : © 2020 by Ann Crabbé (KU Leuven)
| Email               : acrabbe.foss@gmail.com
|
| This file is part of the QGIS Neural Network MLP Classifier plugin and mlp-image-classifier python package.
|
| This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
| License as published by the Free Software Foundation, either version 3 of the License, or any later version.
|
| This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
| warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
|
| You should have received a copy of the GNU General Public License along with Foobar.  If not see www.gnu.org/licenses.
| ----------------------------------------------------------------------------------------------------------------------
"""
package_name_pip = 'mesma'
qgis_plugin_name = 'MESMA'
read_the_docs_name = 'mesma'

author = 'Ann Crabbé (KU Leuven)'
author_doc = 'Ann Crabbé (KU Leuven)'
author_email = 'ann.crabbe@kuleuven.be'
author_copyright = '2020, Ann Crabbé'
short_version = '1.0'
long_version = '1.0.5'

bitbucket_home = 'https://bitbucket.org/kul-reseco/mesma'
bitbucket_src = 'https://bitbucket.org/kul-reseco/mesma/src'
bitbucket_issues = 'https://bitbucket.org/kul-reseco/mesma/issues'

read_the_docs = 'https://mesma.readthedocs.io'

keywords = ['sma', 'mesma', 'szu', 'remote sensing']

qgis_min_version = '3.10'

short_description = 'The MESMA software package is a QGIS plugin and command line interface package ' \
                    'that provides a suite of processing tools for the MESMA ' \
                    '(Multiple Endmember Spectral Mixture Analysis) unmixing algorithm in the field of Remote Sensing.'
long_description = 'Unmixing with MESMA (with multi-level fusion, stable zone unmixing, ...) and post-processing ' \
                   'of the MESMA results (visualisation tool, shade normalisation, soft to hard classification).'

icon = 'images/lumos_h60.png'
qgis_category = 'Raster'

sphinx_title = 'MESMA Software Documentation'
