An AEA is an intelligent agent whose goal is generating economic value for its owner. It can represent machines, humans (individuals or organisations), or data. 

## General application areas

As described in the guide on <a href="../agent-oriented-development">agent-oriented development</a>, AEAs are designed to operate in an environment with:

* multiple stakeholders, which
* are represented by AEAs, that
* interact autonomously and
* communicate _via_ a peer-to-peer network.

There are at least five general application areas for AEAs:

* **Inhabitants**: agents paired with real world hardware devices such as drones, laptops, heat sensors, etc. An example is the thermometer agent that can be found <a href="../thermometer-skills">here</a>.
* **Interfaces**: facilitation agents which provide the necessary API interfaces for interaction between old (Web 2.0) and new (Web 3.0) economic models. An example is the http skill in <a href="../http-connection-and-skill">this</a> agent.
* **Pure software**: software agents living in the digital space that interact with inhabitant and interface agents and others.
* **Digital data sales agents**: pure software agents that attach to data sources and sell it via the open economic framework. An example can be found <a href="../ml-skills">here</a>.
* **Representative**: an agent which represents an individual's activities on the Fetch.ai network. An example can be found <a href="../tac-skills">here</a>.

## Likely short-term applications

In the short-term we see AEAs primarily deployed in three areas:

* Off-load repetitive tasks: AEAs can automate well defined processes in supply chain, transport and finance.

* Micro transactions: AEAs make it economically viable to execute trades which involve small value transfers. This is particularly relevant in areas where there is a (data) supply side constituted of many small actors and a single demand side.

* Wallet agents: AEAs can simplify the interactions with blockchains for end users. For instance, they can act as "smart wallets" which optimize blockchain interactions on behalf of the user.


## Multi-agent system versus agent-based modelling

The Fetch.ai multi-agent system is a real world multi-agent technological system and, although there is some overlap, it is not the same as agent based modelling where the goal is scientific behavioural observation rather than practical economic gain.

Moreover, there is no restriction to *multi*. Single-agent applications are also supported.

<br />
