from powerml import PowerML
import logging
import sys

# Uncomment to print out logging statements
# logging.basicConfig(stream=sys.stdout, level=logging.DEBUG)


def testFitAndPredict(model, prompt_template, prompt):
    # LOL we should probably revisit this .fit method to figure out how to pass in custom prompts better.
    model.set_prompt(prompt_template)
    # After .fit() model will remember tMhe name of the model just fit.
    output = model.predict(
        prompt, max_tokens=500, temperature=0.7)
    return output


def demo(model):
    prompt_template = """{{input}}\nHI:"""
    prompt = "test"
    output = testFitAndPredict(
        model, prompt_template=prompt_template, prompt=prompt,)
    print(output)


def demo2(model):
    topics = [
        'API',
        'VSCode',
        'SourceMark',
        'Auth',
        'Slack',
        'Git',
        'Thread',
        'GitHub',
        'UI',
        'Video',
        'Gradle',
        'Threads',
        'Extension',
        'Dashboard',
        'DB',
        'Hub',
        'Search',
        'Web',
        'Helm',
        'Cache',
        'Styling',
        'PR',
        'Intercom',
        'Deployment',
        'Ingestion',
        'Token',
        'Editor',
        'Logging',
        'CDK',
        'Repo',
        'Sourcemark',
        'Store',
        'Pusher',
        'CI',
        'Login',
        'Notifications',
        'Redis',
        'Chat',
        'Client',
        'IAM',
        'Message',
        'Discussion',
        'S3',
        'OpenAPI',
        'Ktor',
        'ECR',
        'Assets',
        'Config',
        'Refresh',
        'Schema',
        'Webview',
        'Admin',
        'Notification',
        'CloudFront',
        'GraphQL',
        'EKS',
        'JSON',
        'Database',
        'Delete',
        'Onboarding',
        'Download',
        'AWS',
        'ALB',
        'IPC',
        'Ktlint',
        'Build',
        'Secrets',
        'PullRequest',
        'Service',
        'Unread',
        'Filter',
        'URL',
        'Installer',
        'Permissions',
        'Honeycomb',
        'Gutter',
        'Rendering',
        'Sidebar',
        'Upload',
        'Stream',
        'Webpack',
        'SourceMarks',
        'Storybook',
        'SM',
        'Bother',
        'Status',
        'Polling',
        'Commit',
        'Kubernetes',
        'Audio',
        'Mentions',
        'Pull',
        'Cloudfront',
        'Snippet',
        'Adminweb',
        'Path',
        'Point',
        'Email',
        'Transcription',
        'Exceptions',
        'Recording',
        'Icon',
        'Exception',
        'Context',
        'Mark',
        'SCM',
        'Actions',
        'Sort',
        'Screen',
        'Lambda',
        'Repos',
        'Network',
        'Explorer',
        'Person',
        'Team',
        'Logout',
        'Flaky',
        'Authentication',
        'TLC',
        'Merge',
        'User',
        'WAF',
        'UUID',
        'Elasticache',
        'Kotlin',
        'Calico',
        'Timestamp',
        'Migration',
        'ScreenShare',
        'Reactions',
        'Badge',
        'Landing',
        'ThreadStore',
        'Version',
        'Error',
        'Queues',
        'Custom',
        'Button',
        'Headers',
        'Types',
        'Compare',
        'Move',
        'Channels',
        'Screenshare',
        'Retry',
        'Kube',
        'Deployments',
        'Upgrade',
        'DNS',
        'Engine',
        'Release',
        'Grafana',
        'Poller',
        'Turbo',
        'Project',
        'Plugin',
        'Race',
        'Safari',
        'Default',
        'Form',
        'Expose',
        'Badges',
        'Versions',
        'Codegen',
        'Caching',
        'SourcePoints',
        'Deploy',
        'Invite',
        'Job',
        'Take',
        'CPU',
        'Makefile',
        'Proto',
        'Github',
        'EC2',
        'Fixtures',
        'Extractor',
        'Index',
        'Push',
        'RDS',
        'MessageEditor',
        'Transcript',
        'SSL',
        'Agent',
        'Resolution',
        'Probes',
        'Refactor',
        'Install',
        'Resiliency',
        'Walkthrough',
        'Rename',
        'Enable',
        'Contributors',
        'Swift',
        'Teams',
        'Lookup',
        'Images',
        'TreeView',
        'Postgres',
        'Webhook',
        'Upsert',
        'Sourcemarks',
        'Topics',
        'Unblocked',
        'Tests',
        'Tabs',
        'DAO',
        'Debug',
        'Stop',
        'PRs',
        'Insight',
        'Agora',
        'Model',
        'Update',
        'Tokens',
        'Bug',
        'Twilio',
        'Identity',
        'Title',
        'Shiki',
        'KMS',
        'AuthStore',
        'Webhooks',
        'GRPC',
        'Models',
        'Recommendation',
        'Deduplication',
        'Command',
        'Logic',
        'Org',
        'Tooltip',
        'Serialization',
        'Transaction',
        'XForwardedHeaderSupport',
        'Sharing',
        'Input',
        'Health',
        'NPM',
        'Logger',
        'Set',
        'Data',
        'Accessibility',
        'Installation',
        'Builder',
        'File',
        'Metrics',
        'Clients',
        'Query',
        'Overlay',
        'References',
        'Bastion',
        'Heap',
        'Node',
        'Ansible',
        'SSH',
        'Rename: GitHub',
        'Error: Handling',
        'Recording: File',
        'Cache: ThreadInfos',
        'Safari: Archive',
        'Compare: Versions',
        'Refactor: Mocked',
        'Thread: Queries',
        'Drop: Columns',
        'Onboarding: Fill',
        'Move: Utils',
        'Fix: DiffStatParser',
        'Add: Insights',
        'Status: Bar',
        'Basic: Video',
        'Update: Forms',
        'Asking: Question',
        'InstallationsAPI: Setting',
        'Add: Version',
        'Editor: Console',
        'ThreadModel',
        'IP',
        'Flex',
        'Grid',
        'Chrome',
        'Sourcemap',
        'Syncing',
        'Components',
        'GradleCache',
        'Optional-Chaining',
        'Interfaces',
        'Muxer',
        'Recalculate',
        'Filtering',
        'Refactoring',
        'Queueing',
        'Indexing',
        'Normalizing',
        'Deleting',
        'Paddings',
        'Showing',
        '2Redirect',
        '3Index',
        '4Recalculation',
        '5Linter',
        '6Wizard',
        '7Login',
        '8Styling',
        '9CI/CD',
        '10Ingest',
        '11Spinner',
        '12Chat',
        '13CloudFront',
        '14Indexing',
        '15Asset',
        '16Slack',
        '17AWS',
        '18WAF',
        'Template',
        'Anti-affinity',
        'OpenTelemetry',
        'Scoped',
        'Godmode',
        'Static',
        'Matrix',
        'Bandaid',
        'Tweak',
        'Diff',
        'Ownership',
        'Archive',
        'Pinning',
        'App',
        'Socket',
        'Feature',
        'RABC',
        'ComputeStack',
        'Statuses',
        'Header',
        'Modal',
        'Colors',
        'Enum',
        'ThreadRank',
        'Sourcepoint',
        'Invitation',
        'Fuzzy',
        'Optional',
        'SearchModel',
        'Resources',
        'DAU',
        'Endpoints',
        'Validation',
        'Code',
        'Flow',
        'Knowledge',
        'Markdown',
        'Spacing',
        'HLS',
        'REST',
        'Editing',
        'Pagination',
        'Columns',
        'Fetch',
        'Optimize',
        'Performance',
        'Getstream',
        'Net',
        'Pod',
        'Create',
        'Compress',
        'Paging',
        'Querying',
        'Streams',
        'Persistence',
        'Stitching',
        'Redirects',
        'Sanitizing',
        'Uploads',
        'Renaming',
        'UUIDs',
        'Splitting',
        'Sentry',
        'Promises',
        'Configs',
        'Messages',
        'JDBC',
        'Checkbox',
        'Theming',
        'Wait-For-Auth',
        'Tutorial',
        'Amazon',
        'Promise',
        'Preference',
        'Sheet',
        'Endpoint',
        'Vault',
        'Put',
        'Generator',
        'Comments',
        'Worker',
        'Node-fetch',
        'HTML',
        'Rust',
        'Failsafe',
        'Assertion',
        'ThreadInfo',
        'Installs',
        'Wizard',
        'Peering',
        'Permission',
        'Alert',
        'Digest',
        'Calculator',
        'Static Site',
        'VPN',
        'Dev',
        'CI/CD',
        'Tree',
        'Linter',
        'Panel',
        'BasicAuth',
        'Utility',
        'Identifier',
        'gRPC',
        'Color',
        'TeamMembers',
        'Breakpoint',
        'Building',
        'Batch',
        'Errors',
        'Funnel',
        'Connect',
        'Sequence',
        'Utilities',
        'Changes',
        'Blame',
        'Flag',
        'Wildcard',
        'Gate',
        'Progress',
        'Embed',
        'Paginate',
        'Codeblocks',
        'RSS',
        'Regression',
        'Signal',
        'Ktors',
        'Slate',
        'TreeCache',
        'GH',
        'Zustand',
        'Docker',
        'gzip',
        'Highlighting',
        'GH Install',
        'Web Extension',
        'Parsing',
        'Triggering',
        'Annotation',
        'Signatures',
        '<tr>',
        'Favicons',
        'Junit5',
        'Protos',
        'FIFO',
        'AssemblyAI',
        'Logz',
        'Tracks',
        'Trace',
        'Cursor',
        'Notes',
        'CORS',
        'Documentation',
        'Provider',
        'Graph',
        'getRelatedTopics - Operation',
        'Thread - Participant',
        'Toggle - Sidebar',
        'Bastion - Host',
        'Reset - Menu',
        'Cdk - IAM',
        'Delay - Rate',
        'Login - Dialog',
        'Hide - Scrollbars',
        'Port - SMA',
        'Fix - Cache',
        'Thread - Multiple',
        'Breaks - API',
        'Move - Files',
        'Change - RDS',
        'Add - Treeview',
        'Scm - Webhook',
        'Use - Pre-loaded',
        'Trigger',
        'Anchor',
        'Settings',
        'Buffer',
    ]
    prompt_template = "{{topics_in_list}}\nRemoving duplicates and topics that are not {{topic_type}} gets this instead:\n['"""
    topic_type = "technical system-level topics"
    # we need the empty input string here because this gets appended to the end of the prompt_template automatically
    prompt = {
        "{{topics_in_list}}": f"{topics}", "{{topic_type}}": topic_type, "{{input}}": ""}
    output = testFitAndPredict(
        model, prompt_template=prompt_template, prompt=prompt,)
    print(output)


def main():
    model = PowerML()
    demo(model)
    demo2(model)


if __name__ == "__main__":
    main()
