# BUG DESCRIPTION
#
# This script is designed to test a bug with how PowerML calculates max token sizes when it generates prompts.
#
# When input messages are anywhere above 2000+ characters, we are hitting issues where the api completely stalls on POST requests.
# It is clear that if the subsample messages are bordering anywhere near 2000+ characters, we can hit api stalls.
import json
import os

from powerml import CreateTopicsModel

# Local
model_output_directory = "/tmp"

# PowerML
powerml_token = "cb01626747049cb05e1132c4f88b412c5ee8d169"

powerml_config = {
    "powerml": {"key": powerml_token},
}

test_data_truncation = 8000

test_data = [
    "Bump @types/mocha from 7.0.2 to 9.1.1Bumps @types/mocha from 7.0.2 to 9.1.1.\n\nCommits\n\nSee full diff in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump eslint-plugin-jsdoc from 30.0.3 to 39.2.8Bumps eslint-plugin-jsdoc from 30.0.3 to 39.2.8.\n\nRelease notes\nSourced from eslint-plugin-jsdoc's releases.\n\nv39.2.8\n39.2.8 (2022-04-24)\nBug Fixes\n\nupdate jsdoccomment (56966d0)\n\nv39.2.7\n39.2.7 (2022-04-21)\nBug Fixes\n\nrequire-jsdoc: report missing blocks to next line of function with explicit column, but only as far as needed (not as far as first line's column) (e53b441)\n\nv39.2.6\n39.2.6 (2022-04-20)\nBug Fixes\n\nrequire-jsdoc: add column to end line (#881); fixes #843 (b65fb3b)\n\nv39.2.5\n39.2.5 (2022-04-20)\nBug Fixes\n\nupdate jsdoccomment and devDep. (fb0c83f)\n\nv39.2.4\n39.2.4 (2022-04-20)\nBug Fixes\n\nrequire-jsdoc: proper reporting of end line numbers; fixes #843 (4270b75)\n\nv39.2.3\n39.2.3 (2022-04-18)\nBug Fixes\n\nrequire-param-type: report column=1 (#875) (2f104f8)\n\nv39.2.2\n39.2.2 (2022-04-17)\n\n\n... (truncated)\n\n\nCommits\n\n56966d0 fix: update jsdoccomment\n6101370 test: check for jsdoccomment bug\n36f23af chore: update devDeps.\ne25132b docs(contributing): spelling and grammar fixes (#879)\ne53b441 fix(require-jsdoc): report missing blocks to next line of function with exp...\nb65fb3b fix(require-jsdoc): add column to end line (#881); fixes #843\nfb0c83f fix: update jsdoccomment and devDep.\n3213594 ci: upgrade to Ubuntu 20 LTS\n21233bc build: add Node 18 support\n71e0772 chore(.husky): remove unnecessary .gitignore\nAdditional commits viewable in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump eslint-plugin-jsdoc from 30.0.3 to 39.2.9Bumps eslint-plugin-jsdoc from 30.0.3 to 39.2.9.\n\nRelease notes\nSourced from eslint-plugin-jsdoc's releases.\n\nv39.2.9\n39.2.9 (2022-04-26)\nBug Fixes\n\ncheck-values: handle mismatched licensePattern; fixes #884 (f4a9249)\n\nv39.2.8\n39.2.8 (2022-04-24)\nBug Fixes\n\nupdate jsdoccomment (56966d0)\n\nv39.2.7\n39.2.7 (2022-04-21)\nBug Fixes\n\nrequire-jsdoc: report missing blocks to next line of function with explicit column, but only as far as needed (not as far as first line's column) (e53b441)\n\nv39.2.6\n39.2.6 (2022-04-20)\nBug Fixes\n\nrequire-jsdoc: add column to end line (#881); fixes #843 (b65fb3b)\n\nv39.2.5\n39.2.5 (2022-04-20)\nBug Fixes\n\nupdate jsdoccomment and devDep. (fb0c83f)\n\nv39.2.4\n39.2.4 (2022-04-20)\nBug Fixes\n\nrequire-jsdoc: proper reporting of end line numbers; fixes #843 (4270b75)\n\nv39.2.3\n39.2.3 (2022-04-18)\n\n\n... (truncated)\n\n\nCommits\n\nf4a9249 fix(check-values): handle mismatched licensePattern; fixes #884\n56966d0 fix: update jsdoccomment\n6101370 test: check for jsdoccomment bug\n36f23af chore: update devDeps.\ne25132b docs(contributing): spelling and grammar fixes (#879)\ne53b441 fix(require-jsdoc): report missing blocks to next line of function with exp...\nb65fb3b fix(require-jsdoc): add column to end line (#881); fixes #843\nfb0c83f fix: update jsdoccomment and devDep.\n3213594 ci: upgrade to Ubuntu 20 LTS\n21233bc build: add Node 18 support\nAdditional commits viewable in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump eslint-plugin-jsdoc from 30.0.3 to 39.3.0Bumps eslint-plugin-jsdoc from 30.0.3 to 39.3.0.\n\nRelease notes\nSourced from eslint-plugin-jsdoc's releases.\n\nv39.3.0\n39.3.0 (2022-05-19)\nFeatures\n\nupdate es-joy/jsdoccomment with jsdoc-type-pratt-parser update (new() keyword for TypeScript types) (66658c0)\n\nv39.2.9\n39.2.9 (2022-04-26)\nBug Fixes\n\ncheck-values: handle mismatched licensePattern; fixes #884 (f4a9249)\n\nv39.2.8\n39.2.8 (2022-04-24)\nBug Fixes\n\nupdate jsdoccomment (56966d0)\n\nv39.2.7\n39.2.7 (2022-04-21)\nBug Fixes\n\nrequire-jsdoc: report missing blocks to next line of function with explicit column, but only as far as needed (not as far as first line's column) (e53b441)\n\nv39.2.6\n39.2.6 (2022-04-20)\nBug Fixes\n\nrequire-jsdoc: add column to end line (#881); fixes #843 (b65fb3b)\n\nv39.2.5\n39.2.5 (2022-04-20)\nBug Fixes\n\nupdate jsdoccomment and devDep. (fb0c83f)\n\nv39.2.4\n39.2.4 (2022-04-20)\n\n\n... (truncated)\n\n\nCommits\n\n66658c0 feat: update es-joy/jsdoccomment with jsdoc-type-pratt-parser update (new...\n747db99 refactor: more descriptive var. naming; better use of jsdoc ourselves\nf4a9249 fix(check-values): handle mismatched licensePattern; fixes #884\n56966d0 fix: update jsdoccomment\n6101370 test: check for jsdoccomment bug\n36f23af chore: update devDeps.\ne25132b docs(contributing): spelling and grammar fixes (#879)\ne53b441 fix(require-jsdoc): report missing blocks to next line of function with exp...\nb65fb3b fix(require-jsdoc): add column to end line (#881); fixes #843\nfb0c83f fix: update jsdoccomment and devDep.\nAdditional commits viewable in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump @types/chai from 4.2.11 to 4.2.12Bumps @types/chai from 4.2.11 to 4.2.12.\n\nCommits\n\nSee full diff in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump eslint-plugin-jsdoc from 30.0.3 to 39.3.2Bumps eslint-plugin-jsdoc from 30.0.3 to 39.3.2.\n\nRelease notes\nSourced from eslint-plugin-jsdoc's releases.\n\nv39.3.2\n39.3.2 (2022-05-24)\nBug Fixes\n\nno-undefined-types: ensure parsing takes into account template names with defaults (374daac)\n\nv39.3.1\n39.3.1 (2022-05-24)\nBug Fixes\n\nupdate jsdoccomment to support default template values; fixes #887 (53e4174)\n\nv39.3.0\n39.3.0 (2022-05-19)\nFeatures\n\nupdate es-joy/jsdoccomment with jsdoc-type-pratt-parser update (new() keyword for TypeScript types) (66658c0)\n\nv39.2.9\n39.2.9 (2022-04-26)\nBug Fixes\n\ncheck-values: handle mismatched licensePattern; fixes #884 (f4a9249)\n\nv39.2.8\n39.2.8 (2022-04-24)\nBug Fixes\n\nupdate jsdoccomment (56966d0)\n\nv39.2.7\n39.2.7 (2022-04-21)\nBug Fixes\n\nrequire-jsdoc: report missing blocks to next line of function with explicit column, but only as far as needed (not as far as first line's column) (e53b441)\n\nv39.2.6\n39.2.6 (2022-04-20)\n\n\n... (truncated)\n\n\nCommits\n\n374daac fix(no-undefined-types): ensure parsing takes into account template names w...\n53e4174 fix: update jsdoccomment to support default template values; fixes #887\n66658c0 feat: update es-joy/jsdoccomment with jsdoc-type-pratt-parser update (new...\n747db99 refactor: more descriptive var. naming; better use of jsdoc ourselves\nf4a9249 fix(check-values): handle mismatched licensePattern; fixes #884\n56966d0 fix: update jsdoccomment\n6101370 test: check for jsdoccomment bug\n36f23af chore: update devDeps.\ne25132b docs(contributing): spelling and grammar fixes (#879)\ne53b441 fix(require-jsdoc): report missing blocks to next line of function with exp...\nAdditional commits viewable in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump eslint-plugin-jsdoc from 30.0.3 to 39.3.3Bumps eslint-plugin-jsdoc from 30.0.3 to 39.3.3.\n\nRelease notes\nSourced from eslint-plugin-jsdoc's releases.\n\nv39.3.3\n39.3.3 (2022-06-18)\nBug Fixes\n\ncheck-line-alignment: if no types are present, avoid allocating extra space; fixes #891 (26e7357)\n\nv39.3.2\n39.3.2 (2022-05-24)\nBug Fixes\n\nno-undefined-types: ensure parsing takes into account template names with defaults (374daac)\n\nv39.3.1\n39.3.1 (2022-05-24)\nBug Fixes\n\nupdate jsdoccomment to support default template values; fixes #887 (53e4174)\n\nv39.3.0\n39.3.0 (2022-05-19)\nFeatures\n\nupdate es-joy/jsdoccomment with jsdoc-type-pratt-parser update (new() keyword for TypeScript types) (66658c0)\n\nv39.2.9\n39.2.9 (2022-04-26)\nBug Fixes\n\ncheck-values: handle mismatched licensePattern; fixes #884 (f4a9249)\n\nv39.2.8\n39.2.8 (2022-04-24)\nBug Fixes\n\nupdate jsdoccomment (56966d0)\n\nv39.2.7\n39.2.7 (2022-04-21)\n\n\n... (truncated)\n\n\nCommits\n\n26e7357 fix(check-line-alignment): if no types are present, avoid allocating extra ...\n374daac fix(no-undefined-types): ensure parsing takes into account template names w...\n53e4174 fix: update jsdoccomment to support default template values; fixes #887\n66658c0 feat: update es-joy/jsdoccomment with jsdoc-type-pratt-parser update (new...\n747db99 refactor: more descriptive var. naming; better use of jsdoc ourselves\nf4a9249 fix(check-values): handle mismatched licensePattern; fixes #884\n56966d0 fix: update jsdoccomment\n6101370 test: check for jsdoccomment bug\n36f23af chore: update devDeps.\ne25132b docs(contributing): spelling and grammar fixes (#879)\nAdditional commits viewable in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump eslint-plugin-jsdoc from 30.0.3 to 39.3.4Bumps eslint-plugin-jsdoc from 30.0.3 to 39.3.4.\n\nRelease notes\nSourced from eslint-plugin-jsdoc's releases.\n\nv39.3.4\n39.3.4 (2022-07-29)\nBug Fixes\n\navoid erring out with missing function and any context (07a9fe3)\n\nv39.3.3\n39.3.3 (2022-06-18)\nBug Fixes\n\ncheck-line-alignment: if no types are present, avoid allocating extra space; fixes #891 (26e7357)\n\nv39.3.2\n39.3.2 (2022-05-24)\nBug Fixes\n\nno-undefined-types: ensure parsing takes into account template names with defaults (374daac)\n\nv39.3.1\n39.3.1 (2022-05-24)\nBug Fixes\n\nupdate jsdoccomment to support default template values; fixes #887 (53e4174)\n\nv39.3.0\n39.3.0 (2022-05-19)\nFeatures\n\nupdate es-joy/jsdoccomment with jsdoc-type-pratt-parser update (new() keyword for TypeScript types) (66658c0)\n\nv39.2.9\n39.2.9 (2022-04-26)\nBug Fixes\n\ncheck-values: handle mismatched licensePattern; fixes #884 (f4a9249)\n\nv39.2.8\n39.2.8 (2022-04-24)\n\n\n... (truncated)\n\n\nCommits\n\n07a9fe3 fix: avoid erring out with missing function and any context\n0c0e8ee docs: update generated README\n8257794 docs: typo in rules (#895)\nafb23c0 refactor: begin splitting up large utils file\n26e7357 fix(check-line-alignment): if no types are present, avoid allocating extra ...\n374daac fix(no-undefined-types): ensure parsing takes into account template names w...\n53e4174 fix: update jsdoccomment to support default template values; fixes #887\n66658c0 feat: update es-joy/jsdoccomment with jsdoc-type-pratt-parser update (new...\n747db99 refactor: more descriptive var. naming; better use of jsdoc ourselves\nf4a9249 fix(check-values): handle mismatched licensePattern; fixes #884\nAdditional commits viewable in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump eslint-plugin-jsdoc from 30.0.3 to 39.3.6Bumps eslint-plugin-jsdoc from 30.0.3 to 39.3.6.\n\nRelease notes\nSourced from eslint-plugin-jsdoc's releases.\n\nv39.3.6\n39.3.6 (2022-08-08)\nBug Fixes\n\nensure TSDeclareFunction is checked by default where function contexts are expected; closes #897 (25d2a7f)\n\nv39.3.5\n39.3.5 (2022-08-08)\nBug Fixes\n\ncheck-tag-names: constructor tag and tagNamePreference (#899) (4f8d242)\n\nv39.3.4\n39.3.4 (2022-07-29)\nBug Fixes\n\navoid erring out with missing function and any context (07a9fe3)\n\nv39.3.3\n39.3.3 (2022-06-18)\nBug Fixes\n\ncheck-line-alignment: if no types are present, avoid allocating extra space; fixes #891 (26e7357)\n\nv39.3.2\n39.3.2 (2022-05-24)\nBug Fixes\n\nno-undefined-types: ensure parsing takes into account template names with defaults (374daac)\n\nv39.3.1\n39.3.1 (2022-05-24)\nBug Fixes\n\nupdate jsdoccomment to support default template values; fixes #887 (53e4174)\n\nv39.3.0\n39.3.0 (2022-05-19)\n\n\n... (truncated)\n\n\nCommits\n\n25d2a7f fix: ensure TSDeclareFunction is checked by default where function contexts...\n4f8d242 fix(check-tag-names): constructor tag and tagNamePreference (#899)\n7d21369 build(.npmignore): add CONTRIBUTING.md (#900)\n6a297e2 chore: remove link to gitspo\n07a9fe3 fix: avoid erring out with missing function and any context\n0c0e8ee docs: update generated README\n8257794 docs: typo in rules (#895)\nafb23c0 refactor: begin splitting up large utils file\n26e7357 fix(check-line-alignment): if no types are present, avoid allocating extra ...\n374daac fix(no-undefined-types): ensure parsing takes into account template names w...\nAdditional commits viewable in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump eslint-plugin-tsdoc from 0.2.5 to 0.2.17Bumps eslint-plugin-tsdoc from 0.2.5 to 0.2.17.\n\nChangelog\nSourced from eslint-plugin-tsdoc's changelog.\n\n0.2.17\nWed, 14 Sep 2022 02:55:06 GMT\nVersion update only\n0.2.16\nSat, 09 Apr 2022 02:28:41 GMT\nPatches\n\nRename the master branch to main.\n\n0.2.15\nThu, 07 Apr 2022 22:51:07 GMT\nVersion update only\n0.2.14\nTue, 20 Apr 2021 04:25:13 GMT\nVersion update only\n0.2.13\nMon, 19 Apr 2021 21:22:32 GMT\nVersion update only\n0.2.12\nFri, 16 Apr 2021 23:22:26 GMT\nVersion update only\n0.2.11\nFri, 22 Jan 2021 18:07:19 GMT\nVersion update only\n0.2.10\nThu, 03 Dec 2020 08:07:55 GMT\nVersion update only\n0.2.9\nThu, 03 Dec 2020 04:31:52 GMT\nVersion update only\n0.2.8\nMon, 30 Nov 2020 06:16:21 GMT\n\n\n... (truncated)\n\n\nCommits\n\nSee full diff in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump mocha and @types/mochaBumps mocha and @types/mocha. These dependencies needed to be updated together.\nUpdates mocha from 8.1.1 to 10.0.0\n\nRelease notes\nSourced from mocha's releases.\n\nv10.0.0\n10.0.0 / 2022-05-01\n:boom: Breaking Changes\n\n\n#4845: Drop Node.js v12.x support (@\u200bjuergba)\n\n\n#4848: Drop Internet-Explorer-11 support (@\u200bjuergba)\n\n\n#4857: Drop AMD/RequireJS support (@\u200bjuergba)\n\n\n#4866: Drop Growl notification support (@\u200bjuergba)\n\n\n#4863: Rename executable bin/mocha to bin/mocha.js (@\u200bjuergba)\n\n\n#4865: --ignore option in Windows: upgrade Minimatch (@\u200bjuergba)\n\n\n#4861: Remove deprecated Runner signature (@\u200bjuergba)\n\n\n:nut_and_bolt: Other\n\n\n#4878: Update production dependencies (@\u200bjuergba)\n\n\n#4876: Add Node.js v18 to CI test matrix (@\u200boutsideris)\n\n\n#4852: Replace deprecated String.prototype.substr() (@\u200bCommanderRoot)\n\n\nAlso thanks to @\u200bea2305 and @\u200bSukkaW for improvements to our documentation.\nv9.2.2\n9.2.2 / 2022-03-11\nPlease also note our announcements.\n:bug: Fixes\n\n\n#4842: Loading of reporter throws wrong error (@\u200bjuergba)\n\n\n#4839: dry-run: prevent potential call-stack crash (@\u200bjuergba)\n\n\n:nut_and_bolt: Other\n\n#4843: Update production dependencies (@\u200bjuergba)\n\nv9.2.1\n9.2.1 / 2022-02-19\nPlease also note our announcements.\n:bug: Fixes\n\n\n... (truncated)\n\n\nChangelog\nSourced from mocha's changelog.\n\n10.0.0 / 2022-05-01\n:boom: Breaking Changes\n\n\n#4845: Drop Node.js v12.x support (@\u200bjuergba)\n\n\n#4848: Drop Internet-Explorer-11 support (@\u200bjuergba)\n\n\n#4857: Drop AMD/RequireJS support (@\u200bjuergba)\n\n\n#4866: Drop Growl notification support (@\u200bjuergba)\n\n\n#4863: Rename executable bin/mocha to bin/mocha.js (@\u200bjuergba)\n\n\n#4865: --ignore option in Windows: upgrade Minimatch (@\u200bjuergba)\n\n\n#4861: Remove deprecated Runner signature (@\u200bjuergba)\n\n\n:nut_and_bolt: Other\n\n\n#4878: Update production dependencies (@\u200bjuergba)\n\n\n#4876: Add Node.js v18 to CI test matrix (@\u200boutsideris)\n\n\n#4852: Replace deprecated String.prototype.substr() (@\u200bCommanderRoot)\n\n\nAlso thanks to @\u200bea2305 and @\u200bSukkaW for improvements to our documentation.\n9.2.2 / 2022-03-11\n:bug: Fixes\n\n\n#4842: Loading of reporter throws wrong error (@\u200bjuergba)\n\n\n#4839: dry-run: prevent potential call-stack crash (@\u200bjuergba)\n\n\n:nut_and_bolt: Other\n\n#4843: Update production dependencies (@\u200bjuergba)\n\n9.2.1 / 2022-02-19\n:bug: Fixes\n\n\n#4832: Loading of config files throws wrong error (@\u200bjuergba)\n\n\n#4799: Reporter: configurable maxDiffSize reporter-option (@\u200bnorla)\n\n\n9.2.0 / 2022-01-24\n\n\n... (truncated)\n\n\nCommits\n\n023f548 build(v10.0.0): release\n62b1566 build(v10.0.0): update CHANGELOG\nfbe7a24 chore: update dependencies (#4878)\n2b98521 docs: replace 'git.io' short links (#4877) [ci skip]\n007fa65 chore(ci): add Node v18 to test matrix (#4876)\nf6695f0 chore(esm): remove code for Node v12 (#4874)\n59f6192 chore(ci): conditionally skip 'push' event (#4872)\nb863359 docs: fix 'fgrep' url (#4873)\nbaaa41a chore(ci): ignore changes to docs files (#4871)\nac81cc5 refactor!: drop support of 'growl' notification (#4866)\nAdditional commits viewable in compare view\n\n\n\nUpdates @types/mocha from 7.0.2 to 10.0.0\n\nCommits\n\nSee full diff in compare view\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump eslint-plugin-jsdoc from 30.0.3 to 39.3.23Bumps eslint-plugin-jsdoc from 30.0.3 to 39.3.23.\n\nRelease notes\nSourced from eslint-plugin-jsdoc's releases.\n\nv39.3.23\n39.3.23 (2022-10-23)\nBug Fixes\n\nrequire-returns-check: allow implicit-return finally if other try-catch branches returning; fixes #926 (12da503)\n\nv39.3.22\n39.3.22 (2022-10-23)\nBug Fixes\n\nvalid-types: report problems with name parsing (e247d67)\n\nv39.3.21\n39.3.21 (2022-10-23)\nBug Fixes\n\nrequire-param: do not cache by comment node; fixes #901 (867edc3)\n\nv39.3.20\n39.3.20 (2022-10-23)\nBug Fixes\n\nrequire-returns-check: allow for missing catch or finalizer and missing case contents; fixes #924 (4fabdd6)\n\nv39.3.19\n39.3.19 (2022-10-22)\nBug Fixes\n\nrequire-param: be tolerant if this is not included as [@param](); fixes #919 (c1f21f8)\n\nv39.3.18\n39.3.18 (2022-10-22)\nBug Fixes\n\nrequire-returns-check: check child nodes of consequents; fixes #923 (dc1f875)\n\nv39.3.17\n39.3.17 (2022-10-22)\n\n\n... (truncated)\n\n\nCommits\n\n12da503 fix(require-returns-check): allow implicit-return finally if other try-catc...\ne247d67 fix(valid-types): report problems with name parsing\n87841e8 test(valid-types): example demonstrating array object properties; closes #596\n867edc3 fix(require-param): do not cache by comment node; fixes #901\n4fabdd6 fix(require-returns-check): allow for missing catch or finalizer and missin...\nc1f21f8 fix(require-param): be tolerant if this is not included as @param; fixe...\ndc1f875 fix(require-returns-check): check child nodes of consequents; fixes #923\n64b1ead test(require-param): add test limiting function to those with @param\n87c1c2a fix(require-returns-check): throw statements to be exempted from final chec...\n5d20bdf fix(check-param-names): tolerate documented this param; fixes #919\nAdditional commits viewable in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump eslint-plugin-jsdoc from 30.0.3 to 39.4.0Bumps eslint-plugin-jsdoc from 30.0.3 to 39.4.0.\n\nRelease notes\nSourced from eslint-plugin-jsdoc's releases.\n\nv39.4.0\n39.4.0 (2022-10-29)\nFeatures\n\nrequire-param-type, require-param-description: add exemptDestructuredRootsFromChecks setting; fixes #752 (da1c85f)\n\nv39.3.25\n39.3.25 (2022-10-25)\nBug Fixes\n\nupdate jsdoccomment and devDep. (94f784f)\n\nv39.3.24\n39.3.24 (2022-10-24)\nBug Fixes\n\nrequire-returns-check, require-yields-check: check for undefined/void within union; fixes #925 (cfbdf8b)\n\nv39.3.23\n39.3.23 (2022-10-23)\nBug Fixes\n\nrequire-returns-check: allow implicit-return finally if other try-catch branches returning; fixes #926 (12da503)\n\nv39.3.22\n39.3.22 (2022-10-23)\nBug Fixes\n\nvalid-types: report problems with name parsing (e247d67)\n\nv39.3.21\n39.3.21 (2022-10-23)\nBug Fixes\n\nrequire-param: do not cache by comment node; fixes #901 (867edc3)\n\nv39.3.20\n39.3.20 (2022-10-23)\n\n\n... (truncated)\n\n\nCommits\n\nda1c85f feat(require-param-type, require-param-description): add `exemptDestructu...\n36f6f9c test: demo disabling param tags with name props\nbeb169c docs(require-param): dot missing\ne60c70f docs(check-param-names): clarify rule description\n94f784f fix: update jsdoccomment and devDep.\ncfbdf8b fix(require-returns-check, require-yields-check): check for undefined/voi...\n12da503 fix(require-returns-check): allow implicit-return finally if other try-catc...\ne247d67 fix(valid-types): report problems with name parsing\n87841e8 test(valid-types): example demonstrating array object properties; closes #596\n867edc3 fix(require-param): do not cache by comment node; fixes #901\nAdditional commits viewable in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump eslint-plugin-jsdoc from 30.0.3 to 39.6.2Bumps eslint-plugin-jsdoc from 30.0.3 to 39.6.2.\n\nRelease notes\nSourced from eslint-plugin-jsdoc's releases.\n\nv39.6.2\n39.6.2 (2022-11-02)\nBug Fixes\n\nupdate jsdoccomment (26141cb)\n\nv39.6.1\n39.6.1 (2022-11-02)\nBug Fixes\n\nno-restricted-syntax: update jsdoccomment to be able to use new descriptionStartLine, descriptionEndLine, and hasPreterminalDescription properties; fixes #830 (d68d742)\n\nv39.6.0\n39.6.0 (2022-11-02)\nFeatures\n\ncheck-types: add skipRootChecking option to preferredTypes setting; fixes #863 (e5da5bb)\n\nv39.5.1\n39.5.1 (2022-11-02)\nBug Fixes\n\nrequire-returns-check: ensure breaks in final switch do not fulfill check for all branches returning (691a414)\n\nv39.5.0\n39.5.0 (2022-11-01)\nFeatures\n\ntext-escaping rule; fixes #864 (1776e18)\n\nv39.4.0\n39.4.0 (2022-10-29)\nFeatures\n\nrequire-param-type, require-param-description: add exemptDestructuredRootsFromChecks setting; fixes #752 (da1c85f)\n\nv39.3.25\n39.3.25 (2022-10-25)\n\n\n... (truncated)\n\n\nCommits\n\n26141cb fix: update jsdoccomment\nd68d742 fix(no-restricted-syntax): update jsdoccomment to be able to use new `descr...\ne5da5bb feat(check-types): add skipRootChecking option to preferredTypes settin...\n691a414 fix(require-returns-check): ensure breaks in final switch do not fulfill ch...\n5fcb62e chore: update devDeps.\n1776e18 feat: text-escaping rule; fixes #864\nda1c85f feat(require-param-type, require-param-description): add `exemptDestructu...\n36f6f9c test: demo disabling param tags with name props\nbeb169c docs(require-param): dot missing\ne60c70f docs(check-param-names): clarify rule description\nAdditional commits viewable in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump eslint-plugin-jsdoc from 30.0.3 to 39.6.4Bumps eslint-plugin-jsdoc from 30.0.3 to 39.6.4.\n\nRelease notes\nSourced from eslint-plugin-jsdoc's releases.\n\nv39.6.4\n39.6.4 (2022-11-24)\nBug Fixes\n\nrequire-return-checks: check return statements prior to last line; fixes #935 (65e927b)\n\nv39.6.3\n39.6.3 (2022-11-24)\nBug Fixes\n\nupdate jsdoccomment; fixes #934 (124d327)\n\nv39.6.2\n39.6.2 (2022-11-02)\nBug Fixes\n\nupdate jsdoccomment (26141cb)\n\nv39.6.1\n39.6.1 (2022-11-02)\nBug Fixes\n\nno-restricted-syntax: update jsdoccomment to be able to use new descriptionStartLine, descriptionEndLine, and hasPreterminalDescription properties; fixes #830 (d68d742)\n\nv39.6.0\n39.6.0 (2022-11-02)\nFeatures\n\ncheck-types: add skipRootChecking option to preferredTypes setting; fixes #863 (e5da5bb)\n\nv39.5.1\n39.5.1 (2022-11-02)\nBug Fixes\n\nrequire-returns-check: ensure breaks in final switch do not fulfill check for all branches returning (691a414)\n\nv39.5.0\n39.5.0 (2022-11-01)\n\n\n... (truncated)\n\n\nCommits\n\n65e927b fix(require-return-checks): check return statements prior to last line; fix...\n124d327 fix: update jsdoccomment; fixes #934\ndc571c0 chore: update devDeps.\nfb4ac92 chore(.husky): shell path and arg updates\n26141cb fix: update jsdoccomment\nd68d742 fix(no-restricted-syntax): update jsdoccomment to be able to use new `descr...\ne5da5bb feat(check-types): add skipRootChecking option to preferredTypes settin...\n691a414 fix(require-returns-check): ensure breaks in final switch do not fulfill ch...\n5fcb62e chore: update devDeps.\n1776e18 feat: text-escaping rule; fixes #864\nAdditional commits viewable in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump eslint-plugin-jsdoc from 30.0.3 to 30.1.0Bumps eslint-plugin-jsdoc from 30.0.3 to 30.1.0.\n\nRelease notes\nSourced from eslint-plugin-jsdoc's releases.\n\nv30.1.0\n30.1.0 (2020-07-31)\nFeatures\n\ncheck-param-names: add checkDestructured option to allow disabling of destructured checking; fixes part of #616 (c4d1b80)\n\n\n\n\nCommits\n\nfbe767b docs(require-param, check-param-names): add docs for checkDestructured`\nc4d1b80 feat(check-param-names): add checkDestructured option to allow disabling ...\n24c5377 docs: more details for bug report\nSee full diff in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump eslint-plugin-array-func from 3.1.6 to 3.1.8Bumps eslint-plugin-array-func from 3.1.6 to 3.1.8.\n\nRelease notes\nSourced from eslint-plugin-array-func's releases.\n\nv3.1.8\n\nFix crash when passing callbacks as variables in from-map. Fixes #344\nFixed some false positives with from-map potentially leading to map callbacks missing the third parameter\nImproved error message formatting\nFix .flatmap() description for 'prefer-flat-map' #221\n\nv3.1.7\n\ndocs: plugins not plugin  4f261c1\ndocs: add config examples for all rules  aef1987\ndocs: make it clearer how the reverse rules works from the doc examples (fixes #68)  74cea8f\ndocs: don't claim that Array.from is faster (fixes #69)  2957434\nfix: update ranging for fixes to be eslint 7 compatible  0565317\n\n\n\n\n\nCommits\n\n36e7a2b 3.1.8\ndd13167 chore: bump actions/checkout from 2 to 3\ndcbf209 chore: bump codecov/codecov-action from 1 to 3\n6709bab chore: bump actions/setup-node from 2 to 3\nc99acc8 ci: add dependabot for gh actions\n10f26f1 fix: crash in from-map rule with identifiers as callbacks and some invalid fi...\ne8c486b chore: bump packages\n56b559e chore: bump @\u200btypescript-eslint/parser from 5.47.0 to 5.47.1\nd2896d6 chore: bump eslint from 8.30.0 to 8.31.0\n111a8f0 chore: bump @\u200btypescript-eslint/parser from 5.46.1 to 5.47.0\nAdditional commits viewable in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump eslint-plugin-tsdoc from 0.2.5 to 0.2.6Bumps eslint-plugin-tsdoc from 0.2.5 to 0.2.6.\n\nCommits\n\nSee full diff in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump @types/mocha from 7.0.2 to 8.0.1Bumps @types/mocha from 7.0.2 to 8.0.1.\n\nCommits\n\nSee full diff in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump mocha from 8.0.1 to 8.1.1Bumps mocha from 8.0.1 to 8.1.1.\n\nRelease notes\nSourced from mocha's releases.\n\nv8.1.1\n8.1.1 / 2020-08-04\n:bug: Fixes\n\n#4394: Fix regression wherein certain reporters did not correctly detect terminal width (@boneskull)\n\nv8.1.0\n8.1.0 / 2020-07-30\nIn this release, Mocha now builds its browser bundle with Rollup and Babel, which will provide the project's codebase more flexibility and consistency.\nWhile we've been diligent about backwards compatibility, it's possible consumers of the browser bundle will encounter differences (other than an increase in the bundle size). If you do encounter an issue with the build, please report it here.\nThis release does not drop support for IE11.\nOther community contributions came from @Devjeel, @Harsha509 and @sharath2106. Thank you to everyone who contributed to this release!\n\nDo you read Korean? See this guide to running parallel tests in Mocha, translated by our maintainer, @outsideris.\n\n:tada: Enhancements\n\n#4287: Use background colors with inline diffs for better visual distinction (@michael-brade)\n\n:bug: Fixes\n\n#4328: Fix watch mode when Mocha run in parallel (@boneskull)\n#4382: Fix root hook execution in watch mode (@indieisaconcept)\n#4383: Consistent auto-generated hook titles (@cspotcode)\n#4359: Better errors when running mocha init (@boneskull)\n#4341: Fix weirdness when using delay option in browser (@craigtaub)\n\n:lock: Security Fixes\n\n#4378, #4333: Update javascript-serialize (@martinoppitz, @wnghdcjfe)\n#4354: Update yargs-unparser (@martinoppitz)\n\n:book: Documentation  Website\n\n#4173: Document how to use --enable-source-maps with Mocha (@bcoe)\n#4343: Clean up some API docs (@craigtaub)\n#4318: Sponsor images are now self-hosted (@Munter)\n\n:nut_and_bolt: Other\n\n#4293: Use Rollup and Babel in build pipeline; add source map to published files (@Munter)\n\n\n\n\nChangelog\nSourced from mocha's changelog.\n\n8.1.1 / 2020-08-04\n:bug: Fixes\n\n#4394: Fix regression wherein certain reporters did not correctly detect terminal width (@boneskull)\n\n8.1.0 / 2020-07-30\nIn this release, Mocha now builds its browser bundle with Rollup and Babel, which will provide the project's codebase more flexibility and consistency.\nWhile we've been diligent about backwards compatibility, it's possible consumers of the browser bundle will encounter differences (other than an increase in the bundle size). If you do encounter an issue with the build, please report it here.\nThis release does not drop support for IE11.\nOther community contributions came from @Devjeel, @Harsha509 and @sharath2106. Thank you to everyone who contributed to this release!\n\nDo you read Korean? See this guide to running parallel tests in Mocha, translated by our maintainer, @outsideris.\n\n:tada: Enhancements\n\n#4287: Use background colors with inline diffs for better visual distinction (@michael-brade)\n\n:bug: Fixes\n\n#4328: Fix watch mode when Mocha run in parallel (@boneskull)\n#4382: Fix root hook execution in watch mode (@indieisaconcept)\n#4383: Consistent auto-generated hook titles (@cspotcode)\n#4359: Better errors when running mocha init (@boneskull)\n#4341: Fix weirdness when using delay option in browser (@craigtaub)\n\n:lock: Security Fixes\n\n#4378, #4333: Update javascript-serialize (@martinoppitz, @wnghdcjfe)\n#4354: Update yargs-unparser (@martinoppitz)\n\n:book: Documentation  Website\n\n#4173: Document how to use --enable-source-maps with Mocha (@bcoe)\n#4343: Clean up some API docs (@craigtaub)\n#4318: Sponsor images are now self-hosted (@Munter)\n\n:nut_and_bolt: Other\n\n#4293: Use Rollup and Babel in build pipeline; add source map to published files (@Munter)\n\n\n\n\nCommits\n\n78d979d Release v8.1.1\n84fb640 update CHANGELOG.md for v8.1.1\n962c816 fix window width problem; closes #4393\n7e250ef Release v8.1.0\na6203c6 add git tag message to .npmrc\n60858dc devDependency updates for v8.1.0\ncf736fe handle errors in supporter images during 11ty build\nf966c94 Fixing typos\n8970429 update CHANGELOG for v8.1.0\nedc09bf Ensure root level hooks are called when running in watch mode\nAdditional commits viewable in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump eslint-plugin-jsdoc from 28.5.1 to 28.7.0Bumps eslint-plugin-jsdoc from 28.5.1 to 28.7.0.\n\nRelease notes\nSourced from eslint-plugin-jsdoc's releases.\n\nv28.7.0\n28.7.0 (2020-07-08)\nFeatures\n\nrequire-jsdoc: add exemptEmptyConstructors and set true as default; fixes #600 (5409f25)\n\nv28.6.1\n28.6.1 (2020-07-01)\nBug Fixes\n\nrequire-throws: arrow function expressions should check body only; fixes #597 (e5387f1)\n\nv28.6.0\n28.6.0 (2020-06-30)\nFeatures\n\nrequire-jsdoc: add enableFixer option; if set to false, will avoid fixer; fixes #372 (c39fd75)\n\n\n\n\nCommits\n\n5409f25 feat(require-jsdoc): add exemptEmptyConstructors and set true as defaul...\na2c2f7c docs: fix Discord invite link\n307db3e chore: disable array-element-newline for now so linting is passing; update ...\n8604bde - Add link to Discord chat.\nb8f7060 refactor: Extract out a new exemptSpeciaMethods into jsdocUtils for potenti...\nd7a669b refactor: Move isConstructor, isGetter, and isSetter to jsdocUtils to a...\nef35f91 docs(require-throws): avoid copy-paste naming errors\ne5387f1 fix(require-throws): arrow function expressions should check body only; fix...\nc39fd75 feat(require-jsdoc): add enableFixer option; if set to false, will avoi...\n693773e chore: update devDep. (semantic release)\nAdditional commits viewable in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump eslint-plugin-jsdoc from 30.0.3 to 30.2.1Bumps eslint-plugin-jsdoc from 30.0.3 to 30.2.1.\n\nRelease notes\nSourced from eslint-plugin-jsdoc's releases.\n\nv30.2.1\n30.2.1 (2020-08-05)\nBug Fixes\n\ncheck-examples: disable jsdoc/require-jsdoc (88c93bb)\n\nv30.2.0\n30.2.0 (2020-08-04)\nFeatures\n\nrequire-param: add checkDestructuredRoots option; fixes #616 (3c06f09)\n\nv30.1.0\n30.1.0 (2020-07-31)\nFeatures\n\ncheck-param-names: add checkDestructured option to allow disabling of destructured checking; fixes part of #616 (c4d1b80)\n\n\n\n\nCommits\n\n88c93bb fix(check-examples): disable jsdoc/require-jsdoc\n86af2c9 chore: update devDeps.\nde49b36 chore: update deps (jsdoctypeparser, lodash) and devDeps; lint per latest\n3c06f09 feat(require-param): add checkDestructuredRoots option; fixes #616\nfbe767b docs(require-param, check-param-names): add docs for checkDestructured`\nc4d1b80 feat(check-param-names): add checkDestructured option to allow disabling ...\n24c5377 docs: more details for bug report\nSee full diff in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump @types/node-forge from 0.9.4 to 0.9.5Bumps @types/node-forge from 0.9.4 to 0.9.5.\n\nCommits\n\nSee full diff in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump eslint-plugin-jsdoc from 30.0.3 to 30.2.3Bumps eslint-plugin-jsdoc from 30.0.3 to 30.2.3.\n\nRelease notes\nSourced from eslint-plugin-jsdoc's releases.\n\nv30.2.3\n30.2.3 (2020-08-16)\nBug Fixes\n\nno-defaults: adjust fixed AST to fully unset default as new comment-parser adjustment would otherwise not wholly remove the default; also updates devDeps and tests use of opening jsdoc; fixes #568 (5cbc823)\n\nv30.2.2\n30.2.2 (2020-08-13)\nBug Fixes\n\nvalid-types: Parse multiple names in template tags for non-jsdoc modes; fixes #622 (7818dde)\n\nv30.2.1\n30.2.1 (2020-08-05)\nBug Fixes\n\ncheck-examples: disable jsdoc/require-jsdoc (88c93bb)\n\nv30.2.0\n30.2.0 (2020-08-04)\nFeatures\n\nrequire-param: add checkDestructuredRoots option; fixes #616 (3c06f09)\n\nv30.1.0\n30.1.0 (2020-07-31)\nFeatures\n\ncheck-param-names: add checkDestructured option to allow disabling of destructured checking; fixes part of #616 (c4d1b80)\n\n\n\n\nCommits\n\n5cbc823 fix(no-defaults): adjust fixed AST to fully unset default as new `comment...\n3b643de chore: update devDeps. and lint as per latest canonical\n7818dde fix(valid-types): Parse multiple names in template tags for non-jsdoc mod...\n905f689 docs: change docs URLs to link readme\ne044289 docs: add meta docs url for all rules\n88c93bb fix(check-examples): disable jsdoc/require-jsdoc\n86af2c9 chore: update devDeps.\nde49b36 chore: update deps (jsdoctypeparser, lodash) and devDeps; lint per latest\n3c06f09 feat(require-param): add checkDestructuredRoots option; fixes #616\nfbe767b docs(require-param, check-param-names): add docs for checkDestructured`\nAdditional commits viewable in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump @types/mocha from 7.0.2 to 8.0.2Bumps @types/mocha from 7.0.2 to 8.0.2.\n\nCommits\n\nSee full diff in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump @typescript-eslint/parser from 3.5.0 to 3.6.1Bumps @typescript-eslint/parser from 3.5.0 to 3.6.1.\n\nRelease notes\nSourced from @typescript-eslint/parser's releases.\n\nv3.6.1\n3.6.1 (2020-07-13)\nBug Fixes\n\neslint-plugin: [no-unnecessary-condition] handle computed member access (#2288) (3a187ca)\neslint-plugin: [prefer-literal-enum-member] allow negative numbers (#2277) (00ac9c3)\neslint-plugin: [space-before-function-paren] incorrect handling of abstract methods (#2275) (ced6591), closes #2274\neslint-plugin: [switch-exhaustiveness-check] handle special characters in enum keys (#2207) (98ab010)\n\nv3.6.0\n3.6.0 (2020-07-06)\nBug Fixes\n\neslint-plugin: [no-namespace] allow namespaces in nested declarations with allowDeclarations (#2238) (c1df669)\neslint-plugin: [space-before-function-paren] handle abstract functions (#2199) (88a3edf)\n\nFeatures\n\neslint-plugin: add rule prefer-literal-enum-member (#1898) (fe2b2ec)\n\n\n\n\nChangelog\nSourced from @typescript-eslint/parser's changelog.\n\n3.6.1 (2020-07-13)\nNote: Version bump only for package @typescript-eslint/parser\n3.6.0 (2020-07-06)\nNote: Version bump only for package @typescript-eslint/parser\n\n\n\nCommits\n\nadcee02 chore: publish v3.6.1\n2d80c51 chore: publish v3.6.0\nSee full diff in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump @types/mocha from 7.0.2 to 8.0.3Bumps @types/mocha from 7.0.2 to 8.0.3.\n\nCommits\n\nSee full diff in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump eslint-plugin-jsdoc from 30.0.3 to 30.2.4Bumps eslint-plugin-jsdoc from 30.0.3 to 30.2.4.\n\nRelease notes\nSourced from eslint-plugin-jsdoc's releases.\n\nv30.2.4\n30.2.4 (2020-08-17)\nBug Fixes\n\ncheck-param-names: avoid erring upon TSCallSignatureDeclaration; fixes #624 (8341f97)\n\nv30.2.3\n30.2.3 (2020-08-16)\nBug Fixes\n\nno-defaults: adjust fixed AST to fully unset default as new comment-parser adjustment would otherwise not wholly remove the default; also updates devDeps and tests use of opening jsdoc; fixes #568 (5cbc823)\n\nv30.2.2\n30.2.2 (2020-08-13)\nBug Fixes\n\nvalid-types: Parse multiple names in template tags for non-jsdoc modes; fixes #622 (7818dde)\n\nv30.2.1\n30.2.1 (2020-08-05)\nBug Fixes\n\ncheck-examples: disable jsdoc/require-jsdoc (88c93bb)\n\nv30.2.0\n30.2.0 (2020-08-04)\nFeatures\n\nrequire-param: add checkDestructuredRoots option; fixes #616 (3c06f09)\n\nv30.1.0\n30.1.0 (2020-07-31)\nFeatures\n\ncheck-param-names: add checkDestructured option to allow disabling of destructured checking; fixes part of #616 (c4d1b80)\n\n\n\n\nCommits\n\nae2f76a chore: fix lint-staged condition\n8341f97 fix(check-param-names): avoid erring upon TSCallSignatureDeclaration; fix...\nc140060 chore: add lint-staged to only lint relevant staged files and add `hkdobrev...\n5cbc823 fix(no-defaults): adjust fixed AST to fully unset default as new `comment...\n3b643de chore: update devDeps. and lint as per latest canonical\n7818dde fix(valid-types): Parse multiple names in template tags for non-jsdoc mod...\n905f689 docs: change docs URLs to link readme\ne044289 docs: add meta docs url for all rules\n88c93bb fix(check-examples): disable jsdoc/require-jsdoc\n86af2c9 chore: update devDeps.\nAdditional commits viewable in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump eslint-plugin-array-func from 3.1.6 to 3.1.7Bumps eslint-plugin-array-func from 3.1.6 to 3.1.7.\n\nRelease notes\nSourced from eslint-plugin-array-func's releases.\n\nv3.1.7\n\ndocs: plugins not plugin  4f261c1\ndocs: add config examples for all rules  aef1987\ndocs: make it clearer how the reverse rules works from the doc examples (fixes #68)  74cea8f\ndocs: don't claim that Array.from is faster (fixes #69)  2957434\nfix: update ranging for fixes to be eslint 7 compatible  0565317\n\n\n\n\n\nCommits\n\n3602302 3.1.7\n4f261c1 docs: plugins not plugin\naef1987 docs: add config examples for all rules\n74cea8f docs: make it clearer how the reverse rules works from the doc examples (fixe...\n2957434 fix: don't claim that Array.from is faster (fixes #69)\n7c12f63 chore: switch to dependabot\n0565317 fix: update ranging for fixes to be eslint 7 compatible\n7cbf4a9 chore: dump snyk\nSee full diff in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump eslint-plugin-jsdoc from 30.0.3 to 30.3.0Bumps eslint-plugin-jsdoc from 30.0.3 to 30.3.0.\n\nRelease notes\nSourced from eslint-plugin-jsdoc's releases.\n\nv30.3.0\n30.3.0 (2020-08-26)\nBug Fixes\n\nno-bad-blocks: allow TypeScript directive comments (41dcc19)\n\nFeatures\n\nno-bad-blocks: make ignored tags customizable (a1e0c13)\n\nv30.2.4\n30.2.4 (2020-08-17)\nBug Fixes\n\ncheck-param-names: avoid erring upon TSCallSignatureDeclaration; fixes #624 (8341f97)\n\nv30.2.3\n30.2.3 (2020-08-16)\nBug Fixes\n\nno-defaults: adjust fixed AST to fully unset default as new comment-parser adjustment would otherwise not wholly remove the default; also updates devDeps and tests use of opening jsdoc; fixes #568 (5cbc823)\n\nv30.2.2\n30.2.2 (2020-08-13)\nBug Fixes\n\nvalid-types: Parse multiple names in template tags for non-jsdoc modes; fixes #622 (7818dde)\n\nv30.2.1\n30.2.1 (2020-08-05)\nBug Fixes\n\ncheck-examples: disable jsdoc/require-jsdoc (88c93bb)\n\nv30.2.0\n30.2.0 (2020-08-04)\nFeatures\n\n\n\n\nCommits\n\n4b67bf8 docs: include no-bad-blocks and no-defaults and document ignore option ...\n20fa942 Avoid use of @ when specifying directives to ignore\na1e0c13 feat(no-bad-blocks): make ignored tags customizable\n41dcc19 fix(no-bad-blocks): allow TypeScript directive comments\n2bc9152 chore: update devDeps\nae2f76a chore: fix lint-staged condition\n8341f97 fix(check-param-names): avoid erring upon TSCallSignatureDeclaration; fix...\nc140060 chore: add lint-staged to only lint relevant staged files and add `hkdobrev...\n5cbc823 fix(no-defaults): adjust fixed AST to fully unset default as new `comment...\n3b643de chore: update devDeps. and lint as per latest canonical\nAdditional commits viewable in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n",
    "Bump eslint-plugin-jsdoc from 30.0.3 to 30.3.2Bumps eslint-plugin-jsdoc from 30.0.3 to 30.3.2.\n\nRelease notes\nSourced from eslint-plugin-jsdoc's releases.\n\nv30.3.2\n30.3.2 (2020-09-06)\nBug Fixes\n\ncheck-examples: disable jsdoc/require-file-overview by default; fixes #633 (dd4a985)\n\nv30.3.1\n30.3.1 (2020-09-02)\nBug Fixes\n\nno-undefined-types: avoid checking private member of scopeManager; fixes #629 (d900a70)\n\nv30.3.0\n30.3.0 (2020-08-26)\nBug Fixes\n\nno-bad-blocks: allow TypeScript directive comments (41dcc19)\n\nFeatures\n\nno-bad-blocks: make ignored tags customizable (a1e0c13)\n\nv30.2.4\n30.2.4 (2020-08-17)\nBug Fixes\n\ncheck-param-names: avoid erring upon TSCallSignatureDeclaration; fixes #624 (8341f97)\n\nv30.2.3\n30.2.3 (2020-08-16)\nBug Fixes\n\nno-defaults: adjust fixed AST to fully unset default as new comment-parser adjustment would otherwise not wholly remove the default; also updates devDeps and tests use of opening jsdoc; fixes #568 (5cbc823)\n\nv30.2.2\n30.2.2 (2020-08-13)\nBug Fixes\n\n\n\n\nCommits\n\ndd4a985 fix(check-examples): disable jsdoc/require-file-overview by default; fixe...\ne93736c docs(check-types): update generated docs\n71649e5 Fixed typo in check-types.md\nd900a70 fix(no-undefined-types): avoid checking private member of scopeManager; fix...\n96d5cab chore: update devDeps.\n4b67bf8 docs: include no-bad-blocks and no-defaults and document ignore option ...\n20fa942 Avoid use of @ when specifying directives to ignore\na1e0c13 feat(no-bad-blocks): make ignored tags customizable\n41dcc19 fix(no-bad-blocks): allow TypeScript directive comments\n2bc9152 chore: update devDeps\nAdditional commits viewable in compare view\n\n\n\n\nDependabot will resolve any conflicts with this PR as long as you don't alter it yourself. You can also trigger a rebase manually by commenting @dependabot rebase.\n\n\nDependabot commands and options\n\n\nYou can trigger Dependabot actions by commenting on this PR:\n- `@dependabot rebase` will rebase this PR\n- `@dependabot recreate` will recreate this PR, overwriting any edits that have been made to it\n- `@dependabot merge` will merge this PR after your CI passes on it\n- `@dependabot squash and merge` will squash and merge this PR after your CI passes on it\n- `@dependabot cancel merge` will cancel a previously requested merge and block automerging\n- `@dependabot reopen` will reopen this PR if it is closed\n- `@dependabot close` will close this PR and stop Dependabot recreating it. You can achieve the same result by closing it manually\n- `@dependabot ignore this major version` will close this PR and stop Dependabot creating any more for this major version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this minor version` will close this PR and stop Dependabot creating any more for this minor version (unless you reopen the PR or upgrade to it yourself)\n- `@dependabot ignore this dependency` will close this PR and stop Dependabot creating any more for this dependency (unless you reopen the PR or upgrade to it yourself)\n\n\n"]


class PowerMLRunner:
    powerml_token = ""
    openapi_token = ""
    config = {}

    def __init__(self, openapi_token="", powerml_token=""):
        self.powerml_token = powerml_token
        self.openapi_token = openapi_token
        self.config = {
            "powerml": {"key": powerml_token},
            "openai": {"key": openapi_token}
        }

    def get_topics(self, messages):
        model = CreateTopicsModel()
        model.fit(messages, topic_type='one-word system components')
        return model.predict()


# These strings are truncated to 8000 characters.
def get_topic_messages():
    return [message[:test_data_truncation] for message in test_data]


def get_topics(topic_messages):
    powerml_runner = PowerMLRunner(powerml_token=powerml_token)
    return powerml_runner.get_topics(topic_messages)


def get_topics_scored(topics):
    topics_scored = dict()
    topics_len = len(topics)
    for idx, topic in enumerate(topics):
        topics_scored[topic] = topics_len - idx
    return topics_scored


topic_messages = get_topic_messages()
print(len(topic_messages))
print(json.dumps(topic_messages, indent=4))


print([len(message) for message in topic_messages])
print([len(message) // 4 for message in topic_messages])


# PowerML does random shuffling of data, so we need to iterate until we hit stall
for i in range(1000):
    print("=================================")
    print(
        "Running iteration: *{0}* to reproduce api stall bug with PowerML api with test data truncated at *{1}* characters. Due to random shuffling with PowerML, we have to do this until we hit the bug.".format(
            i, test_data_truncation))
    topics = get_topics(topic_messages)
    topics = [topic["name"] for topic in topics]
    topics_scored = get_topics_scored(topics)

    json_object = json.dumps(topics_scored, indent=4)
    print(json_object)

    model_json_output_file = os.path.join(
        model_output_directory, "topics.json")
    with open(model_json_output_file, 'w') as f:
        json.dump(topics_scored, f)
