# -*- coding: utf-8 -*-
from smart_module.module_system.header_common import *
from smart_module.module_system.header_dialogs import *
from smart_module.module_system.header_operations import *
from smart_module.module_system.header_parties import *
from smart_module.module_system.header_item_modifiers import *
from smart_module.module_system.header_skills import *
from smart_module.module_system.header_triggers import *
from smart_module.module_system.ID_troops import *
from smart_module.module_system.ID_party_templates import *

from smart_module.module_system.module_constants import *


####################################################################################################################
# During a dialog, the dialog lines are scanned from top to bottom.
# If the dialog-line is spoken by the player, all the matching lines are displayed for the player to pick from.
# If the dialog-line is spoken by another, the first (top-most) matching line is selected.
#
#  Each dialog line contains the following fields:
# 1) Dialogue partner: This should match the person player is talking to.
#    Usually this is a troop-id.
#    You can also use a party-template-id by appending '|party_tpl' to this field.
#    Use the constant 'anyone' if you'd like the line to match anybody.
#    Appending '|plyr' to this field means that the actual line is spoken by the player
#    Appending '|other(troop_id)' means that this line is spoken by a third person on the scene.
#       (You must make sure that this third person is present on the scene)
#
# 2) Starting dialog-state:
#    During a dialog there's always an active Dialog-state.
#    A dialog-line's starting dialog state must be the same as the active dialog state, for the line to be a possible candidate.
#    If the dialog is started by meeting a party on the map, initially, the active dialog state is "start"
#    If the dialog is started by speaking to an NPC in a town, initially, the active dialog state is "start"
#    If the dialog is started by helping a party defeat another party, initially, the active dialog state is "party_relieved"
#    If the dialog is started by liberating a prisoner, initially, the active dialog state is "prisoner_liberated"
#    If the dialog is started by defeating a party led by a hero, initially, the active dialog state is "enemy_defeated"
#    If the dialog is started by a trigger, initially, the active dialog state is "event_triggered"
# 3) Conditions block (list): This must be a valid operation block. See header_operations.py for reference.  
# 4) Dialog Text (string):
# 5) Ending dialog-state:
#    If a dialog line is picked, the active dialog-state will become the picked line's ending dialog-state.
# 6) Consequences block (list): This must be a valid operation block. See header_operations.py for reference.
# 7) Voice-over (string): sound filename for the voice over. Leave here empty for no voice over
####################################################################################################################

dialogs = [
  [anyone ,"start", [(store_conversation_troop, "$g_talk_troop"),
                     (store_conversation_agent, "$g_talk_agent"),
                     (store_troop_faction, "$g_talk_troop_faction", "$g_talk_troop"),
#                     (troop_get_slot, "$g_talk_troop_relation", "$g_talk_troop", slot_troop_player_relation),
                     (call_script, "script_troop_get_player_relation", "$g_talk_troop"),
                     (assign, "$g_talk_troop_relation", reg0),
					 
					 #This may be different way to handle persuasion, which might be a little more transparent to the player in its effects
					 #Persuasion will affect the player's relation with the other character -- but only for 1 on 1 conversations
					 (store_skill_level, ":persuasion", "skl_persuasion", "trp_player"),
					 (assign, "$g_talk_troop_effective_relation", "$g_talk_troop_relation"),
					 (val_add, "$g_talk_troop_effective_relation", ":persuasion"),
					 (try_begin),
						(gt, "$g_talk_troop_effective_relation", 0),
						(store_add, ":persuasion_modifier", 10, ":persuasion"),
						(val_mul, "$g_talk_troop_effective_relation", ":persuasion_modifier"),
						(val_div, "$g_talk_troop_effective_relation", 10),
					 (else_try),
						(lt, "$g_talk_troop_effective_relation", 0),
						(store_sub, ":persuasion_modifier", 20, ":persuasion"),
						(val_mul, "$g_talk_troop_effective_relation", ":persuasion_modifier"),
						(val_div, "$g_talk_troop_effective_relation", 20),
					 (try_end),
					 (val_clamp, "$g_talk_troop_effective_relation", -100, 101), 
					 (try_begin),
						(eq, "$cheat_mode", 1),
						(assign, reg3, "$g_talk_troop_effective_relation"),
						(display_message, "str_test_effective_relation_=_reg3"),
					 (try_end),
					 
                     (try_begin),
                       (this_or_next|is_between, "$g_talk_troop", village_elders_begin, village_elders_end),
                       (is_between, "$g_talk_troop", mayors_begin, mayors_end),
                       (party_get_slot, "$g_talk_troop_relation", "$current_town", slot_center_player_relation),
                     (try_end),
                     (store_relation, "$g_talk_troop_faction_relation", "$g_talk_troop_faction", "fac_player_faction"),
                     
                     (assign, "$g_talk_troop_party", "$g_encountered_party"),
                     (try_begin),
                       (troop_slot_ge, "$g_talk_troop", slot_troop_leaded_party, 1),
                       (troop_get_slot, "$g_talk_troop_party", "$g_talk_troop", slot_troop_leaded_party),
                     (try_end),
                     
#                     (assign, "$g_talk_troop_kingdom_relation", 0),
#                     (try_begin),
#                       (gt, "$players_kingdom", 0),
#                       (store_relation, "$g_talk_troop_kingdom_relation", "$g_talk_troop_faction", "$players_kingdom"),
#                     (try_end),


                     
                     (store_current_hours, "$g_current_hours"),
                     (troop_get_slot, "$g_talk_troop_last_talk_time", "$g_talk_troop", slot_troop_last_talk_time),
                     (troop_set_slot, "$g_talk_troop", slot_troop_last_talk_time, "$g_current_hours"),
                     (store_sub, "$g_time_since_last_talk","$g_current_hours","$g_talk_troop_last_talk_time"),
                     (troop_get_slot, "$g_talk_troop_met", "$g_talk_troop", slot_troop_met),
					 (val_min, "$g_talk_troop_met", 1), #the global variable goes no higher than one
					 (try_begin),
					    (troop_slot_eq, "$g_talk_troop", slot_troop_met, 0),
						(troop_set_slot, "$g_talk_troop", slot_troop_met, 1),
						
						#Possible later activations of notes
						(try_begin),
							(is_between, "$g_talk_troop", kingdom_ladies_begin, kingdom_ladies_end),
						(try_end),
						
					 (try_end),
					 
                     (try_begin),
#                       (this_or_next|eq, "$talk_context", tc_party_encounter),
#                       (this_or_next|eq, "$talk_context", tc_castle_commander),
                       (call_script, "script_party_calculate_strength", "p_collective_enemy",0),
                       (assign, "$g_enemy_strength", reg0),
                       (call_script, "script_party_calculate_strength", "p_main_party",0),
                       (assign, "$g_ally_strength", reg0),
                       (store_mul, "$g_strength_ratio", "$g_ally_strength", 100),
					   (assign, ":enemy_strength", "$g_enemy_strength"), #these two lines added to avoid div by zero error
					   (val_max, ":enemy_strength", 1),
                       (val_div, "$g_strength_ratio", ":enemy_strength"),
                     (try_end),

                     (assign, "$g_comment_found", 0),

					 (assign, "$g_comment_has_rejoinder", 0),
					 (assign, "$g_romantic_comment_made", 0),
					 (assign, "$skip_lord_assumes_argument", 0), #a lord pre-empts a player's issue, ie, when the player is conducting a rebellion
					 (assign, "$bypass_female_vassal_explanation", 0),
					 (assign, "$g_done_wedding_comment", 0),
					 
#					 (assign, "$g_time_to_spare", 0),
					 
					 
                     (try_begin),
                       (troop_is_hero, "$g_talk_troop"),
                       (talk_info_show, 1),
                       (call_script, "script_setup_talk_info"),
                     (try_end),

					 (assign, "$g_last_comment_copied_to_s42", 0),
                     (try_begin),
                       (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_hero),
                       (call_script, "script_get_relevant_comment_to_s42"),
                       (assign, "$g_comment_found", reg0),
                     (try_end),

                     (troop_get_type, reg65, "$g_talk_troop"),
                     (try_begin),
                       (faction_slot_eq,"$g_talk_troop_faction",slot_faction_leader,"$g_talk_troop"),
                       (str_store_string,s64,"@{reg65?my Lady:my Lord}"), #bug fix
                       (str_store_string,s65,"@{reg65?my Lady:my Lord}"),
                       (str_store_string,s66,"@{reg65?My Lady:My Lord}"),
                       (str_store_string,s67,"@{reg65?My Lady:My Lord}"), #bug fix
                     (else_try),
                       (str_store_string,s64,"@{reg65?madame:sir}"), #bug fix
                       (str_store_string,s65,"@{reg65?madame:sir}"),
                       (str_store_string,s66,"@{reg65?Madame:Sir}"),
                       (str_store_string,s67,"@{reg65?Madame:Sir}"), #bug fix
                     (try_end),

					 (try_begin),
						(gt, "$cheat_mode", 0),
						(assign, reg4, "$talk_context"),
						(display_message, "@{!}DEBUG -- Talk context: {reg4}"),
					 (try_end),

					 (try_begin),
						(gt, "$cheat_mode", 0),
						(assign, reg4, "$g_time_since_last_talk"),
						(display_message, "@{!}DEBUG -- Time since last talk: {reg4}"),
					 (try_end),
					 
					 
					 (try_begin),
						(eq, "$cheat_mode", 0),
						(store_partner_quest, ":quest"),
						(ge, ":quest", 0),
						(str_store_quest_name, s4, ":quest"),
						
					 (try_end),
					 
                     (eq, 1, 0)],
   "{!}Warning: This line is never displayed. It is just for storing conversation variables.", "close_window", []],

  [anyone ,"member_chat", [
					(store_conversation_troop, "$g_talk_troop"),
                    (try_begin),
                        (is_between, "$g_talk_troop", companions_begin, companions_end),
                        (talk_info_show, 1),
                        (call_script, "script_setup_talk_info_companions"),
                    (else_try),
                        (is_between, "$g_talk_troop", pretenders_begin, pretenders_end),
                        (talk_info_show, 1),
                        (call_script, "script_setup_talk_info"),
                    (try_end),
	   
					(troop_get_type, reg65, "$g_talk_troop"),
                           
                    (troop_get_type, reg65, "$g_talk_troop"),
                    (try_begin),
                        (faction_slot_eq,"$g_talk_troop_faction",slot_faction_leader,"$g_talk_troop"),
                        (str_store_string,s64,"@{reg65?my Lady:my Lord}"), #bug fix
                        (str_store_string,s65,"@{reg65?my Lady:my Lord}"),
                        (str_store_string,s66,"@{reg65?My Lady:My Lord}"),
                    (else_try),
                        (str_store_string,s64,"@{reg65?madame:sir}"), #bug fix
                        (str_store_string,s65,"@{reg65?madame:sir}"),
                        (str_store_string,s66,"@{reg65?Madame:Sir}"),
                    (try_end),

					(store_current_hours, "$g_current_hours"),
					(troop_set_slot, "$g_talk_troop", slot_troop_last_talk_time, "$g_current_hours"),					 
					 
                    (eq, 1, 0)],  
   "{!}Warning: This line is never displayed. It is just for storing conversation variables.", "close_window", []],

  [anyone ,"event_triggered", [(store_conversation_troop, "$g_talk_troop"),
                           (try_begin),
                               (is_between, "$g_talk_troop", companions_begin, companions_end),
                               (talk_info_show, 1),
                               (call_script, "script_setup_talk_info_companions"),
                           (try_end),
                               
                     (troop_get_type, reg65, "$g_talk_troop"),
                     (try_begin),
                       (faction_slot_eq,"$g_talk_troop_faction",slot_faction_leader,"$g_talk_troop"),
                       (str_store_string,s64,"@{reg65?my Lady:my Lord}"), #bug fix
                       (str_store_string,s65,"@{reg65?my Lady:my Lord}"),
                       (str_store_string,s66,"@{reg65?My Lady:My Lord}"),
                     (else_try),
                       (str_store_string,s64,"@{reg65?madame:sir}"), #bug fix
                       (str_store_string,s65,"@{reg65?madame:sir}"),
                       (str_store_string,s66,"@{reg65?Madame:Sir}"),
                     (try_end),

					 
                     (eq, 1, 0)],  
   "{!}Warning: This line is never displayed. It is just for storing conversation variables.", "close_window", []],

  [anyone, "event_triggered",
   [
     (eq, "$talk_context", tc_give_center_to_fief),

     (assign, ":there_are_vassals", 0),
     (assign, ":end_cond", active_npcs_end),
     (try_for_range, ":troop_no", active_npcs_begin, ":end_cond"),
       (troop_slot_eq, ":troop_no", slot_troop_occupation, slto_kingdom_hero),
       (neq, "trp_player", ":troop_no"),
       (store_troop_faction, ":faction_no", ":troop_no"),
       (eq, ":faction_no", "fac_player_supporters_faction"),
       (val_add, ":there_are_vassals", 1),
       (assign, ":end_cond", 0),
     (try_end),
     
     (try_begin),
       (gt, ":there_are_vassals", 0),
       (str_store_string, s2, "str_do_you_wish_to_award_it_to_one_of_your_vassals"),
     (else_try),
       (str_store_string, s2, "str_who_do_you_wish_to_give_it_to"),
     (try_end),

     (str_store_party_name, s1, "$g_center_taken_by_player_faction"),
  	 (str_store_string, s5, "str_sire_my_lady_we_have_taken_s1_s2"),
     ],
   "{!}{s5}", "award_fief_to_vassal", 
   []],

  [anyone|plyr, "award_fief_to_vassal",
   [
   (is_between, "$g_player_court", centers_begin, centers_end), 
   (store_faction_of_party, ":player_court_faction", "$g_player_court"),
   (eq, ":player_court_faction", "fac_player_supporters_faction"),
	 ],
   "I wish to defer the appointment of a lord, until I take the counsel of my subjects", "award_fief_to_vassal_defer",
   [
     ]],

  [anyone, "award_fief_to_vassal_defer",
   [
     ],
   "As you wish, {sire/my lady}. You may decide this matter at a later date.", "close_window",
   [
	 (try_begin),
		(faction_slot_eq, "$players_kingdom", slot_faction_political_issue, -1),
		(faction_set_slot, "$players_kingdom", slot_faction_political_issue, "$g_center_taken_by_player_faction"),
	 (try_end),	 
	 (call_script, "script_give_center_to_lord", "$g_center_taken_by_player_faction", -1, 0), #-1 for the faction lord in this script is used exclusively in this context
	 #It is only used because script_give_center_to_faction does not reset the town lord if fac_player_supporters_faction is the attacker

     (assign, "$g_center_taken_by_player_faction", -1),
	 
     #new start
     (try_begin),
       (eq, "$g_next_menu", "mnu_castle_taken"), 
       (jump_to_menu, "$g_next_menu"),
     (try_end),  
     #new end
	 
     ]],
   
   
   
   [anyone|plyr|repeat_for_troops,"award_fief_to_vassal",
   [  
     (store_repeat_object, ":troop_no"),
     (troop_slot_eq, ":troop_no", slot_troop_occupation, slto_kingdom_hero),
     (neq, "trp_player", ":troop_no"),
     (store_troop_faction, ":faction_no", ":troop_no"),
     (eq, ":faction_no", "fac_player_supporters_faction"),
     (str_store_troop_name, s11, ":troop_no"),
     (call_script, "script_print_troop_owned_centers_in_numbers_to_s0", ":troop_no"),
	 
	 (try_begin),
	   (troop_slot_eq, "$g_talk_troop", slot_lord_recruitment_argument, argument_benefit),
	   (str_store_string, s12, "str__promised_fief"),
	 (else_try),
	   (str_clear, s12),
	 (try_end),
	 
     (try_begin),
       (eq, reg0, 0),
       (str_store_string, s1, "str_no_fiefss12"),
     (else_try),
       (str_store_string, s1, "str_fiefs_s0s12"),
     (try_end),
    ],
   "{!}{s11} {s1}.", "award_fief_to_vassal_2",[(store_repeat_object, "$temp")]],

  [anyone|plyr, "award_fief_to_vassal",
   [
     (call_script, "script_print_troop_owned_centers_in_numbers_to_s0", "trp_player"),
     (str_store_party_name, s1, "$g_center_taken_by_player_faction"),

	 (try_begin),
		(is_between, "$g_talk_troop", pretenders_begin, pretenders_end),
		(str_store_string, s12, "str_please_s65_"),
	 (else_try),	
		(str_clear, s12),
	 (try_end),	
	 
     (assign, ":there_are_vassals", 0),
     (assign, ":end_cond", active_npcs_end),
     (try_for_range, ":troop_no", active_npcs_begin, ":end_cond"),
       (troop_slot_eq, ":troop_no", slot_troop_occupation, slto_kingdom_hero),
       (neq, "trp_player", ":troop_no"),
       (store_troop_faction, ":faction_no", ":troop_no"),
       (eq, ":faction_no", "fac_player_supporters_faction"),
       (val_add, ":there_are_vassals", 1),
       (assign, ":end_cond", 0),
     (try_end),
     
     (try_begin),
       (gt, ":there_are_vassals", 0),
  	   (str_store_string, s2, "str_fiefs_s0"),
  	 (else_try),
  	   (str_clear, s2),
  	 (try_end),
  	 
  	 (str_store_string, s5, "str_s12i_want_to_have_s1_for_myself"),
	 ],
   "{!}{s5}", "award_fief_to_vassal_2",      
   [
     (assign, "$temp", "trp_player"),
     ]],  

  [anyone, "award_fief_to_vassal_2",
   [
     ],
   "As you wish, {sire/my lady}. {reg6?I:{reg7?You:{s11}}} will be the new {reg3?lady:lord} of {s1}.", "close_window",
   [
     (assign, ":new_owner", "$temp"),
	 
     (call_script, "script_give_center_to_lord", "$g_center_taken_by_player_faction", ":new_owner", 0),
	 (try_begin),
		(faction_slot_eq, "$players_kingdom", slot_faction_political_issue, "$g_center_taken_by_player_faction"),
		(faction_set_slot, "$players_kingdom", slot_faction_political_issue, -1),
	 (try_end),
   
     (assign, reg6, 0),
     (assign, reg7, 0),
     (try_begin),
       (eq, ":new_owner", "$g_talk_troop"),
       (assign, reg6, 1),
     (else_try),
       (eq, ":new_owner", "trp_player"),
       (assign, reg7, 1),
     (else_try),
       (str_store_troop_name, s11, ":new_owner"),
     (try_end),
     (str_store_party_name, s1, "$g_center_taken_by_player_faction"),
     (troop_get_type, reg3, ":new_owner"),
     
     (assign, "$g_center_taken_by_player_faction", -1),	 	           

     #new start
     (try_begin),
       (eq, "$g_next_menu", "mnu_castle_taken"), 
       (jump_to_menu, "$g_next_menu"),
     (try_end),  
     #new end
     ]],

# Awarding fiefs in rebellion...
	 
  [anyone, "event_triggered",
   [
     (faction_slot_eq, "fac_player_supporters_faction", slot_faction_leader, "$g_talk_troop"),
     (ge, "$g_center_taken_by_player_faction", 0),
     (str_store_party_name, s1, "$g_center_taken_by_player_faction"),
     ],
   "{s1} is not being managed by anyone. Whom shall I put in charge?", "center_captured_rebellion",
   []],

  [anyone|plyr|repeat_for_troops, "center_captured_rebellion",
   [
     (store_repeat_object, ":troop_no"),
     (troop_slot_eq, ":troop_no", slot_troop_occupation, slto_kingdom_hero),
     (neq, "$g_talk_troop", ":troop_no"),
     (neq, "trp_player", ":troop_no"),
     (store_troop_faction, ":faction_no", ":troop_no"),
     (eq, ":faction_no", "fac_player_supporters_faction"),
     (str_store_troop_name, s11, ":troop_no"),
     (call_script, "script_print_troop_owned_centers_in_numbers_to_s0", ":troop_no"),
     (try_begin),
       (eq, reg0, 0),
       (str_store_string, s1, "@(no fiefs)"),
     (else_try),
       (str_store_string, s1, "@(fiefs: {s0})"),
     (try_end),
     ],
   "{s11}. {s1}", "center_captured_rebellion_2",
   [
     (store_repeat_object, "$temp"),
     ]],

  [anyone|plyr, "center_captured_rebellion",
   [
     (call_script, "script_print_troop_owned_centers_in_numbers_to_s0", "trp_player"),
     (str_store_party_name, s1, "$g_center_taken_by_player_faction"),
    ],
   "Please {s65}, I want to have {s1} for myself. (fiefs: {s0})", "center_captured_rebellion_2",
   [
     (assign, "$temp", "trp_player"),
     ]],

  [anyone|plyr, "center_captured_rebellion",
   [
     (call_script, "script_print_troop_owned_centers_in_numbers_to_s0", "$g_talk_troop"),
     (str_store_party_name, s1, "$g_center_taken_by_player_faction"),
     ],
   "{s66}, you should have {s1} for yourself. (fiefs: {s0})", "center_captured_rebellion_2",
   [
     (assign, "$temp", "$g_talk_troop"),
     ]],

  [anyone, "center_captured_rebellion_2",
   [
#     (faction_slot_eq, "fac_player_supporters_faction", slot_faction_leader, "$g_talk_troop"),
#     (ge, "$g_center_taken_by_player_faction", 0),
     ],
   "Hmmm. All right, {playername}. I value your counsel highly. {reg6?I:{reg7?You:{s11}}} will be the new {reg3?lady:lord} of {s1}.", "close_window",
   [
     (assign, ":new_owner", "$temp"),
     (call_script, "script_calculate_troop_score_for_center", ":new_owner", "$g_center_taken_by_player_faction"),
     (assign, ":new_owner_score", reg0),
     (assign, ":total_negative_effect"),
     (try_for_range, ":cur_troop", active_npcs_begin, active_npcs_end),
	   (troop_slot_eq, ":cur_troop", slot_troop_occupation, slto_kingdom_hero),     
       (store_troop_faction, ":cur_faction", ":cur_troop"),
       (eq, ":cur_faction", "fac_player_supporters_faction"),
       (neq, ":cur_troop", ":new_owner"),
	   (neg|troop_slot_eq, ":cur_troop", slot_troop_stance_on_faction_issue, ":new_owner"),
	   (call_script, "script_troop_get_relation_with_troop", ":cur_troop", ":new_owner"),
	   (lt, reg0, 25),
	   
	   
       (call_script, "script_calculate_troop_score_for_center", ":cur_troop", "$g_center_taken_by_player_faction"),
       (assign, ":cur_troop_score", reg0),
       (gt, ":cur_troop_score", ":new_owner_score"),
       (store_sub, ":difference", ":cur_troop_score", ":new_owner_score"),
       (store_random_in_range, ":random_dif", 0, ":difference"),
       (val_div, ":random_dif", 1000),
       (gt, ":random_dif", 0),
       (val_add, ":total_negative_effect", ":random_dif"),
       (val_mul, ":random_dif", -1),
       (call_script, "script_change_player_relation_with_troop", ":cur_troop", ":random_dif"),
     (try_end),
     (val_mul, ":total_negative_effect", 2),
     (val_div, ":total_negative_effect", 3),
     (val_add, ":total_negative_effect", 5),
     (try_begin),
       (neq, ":new_owner", "trp_player"),
       (val_min, ":total_negative_effect", 30),
       (call_script, "script_change_player_relation_with_troop", ":new_owner", ":total_negative_effect"),
     (try_end),
     
     (call_script, "script_give_center_to_lord", "$g_center_taken_by_player_faction", ":new_owner", 0),
	 (try_begin),
		(faction_slot_eq, "$players_kingdom", slot_faction_political_issue, "$g_center_taken_by_player_faction"),
		(faction_set_slot, "$players_kingdom", slot_faction_political_issue, -1),
	 (try_end),
	    
     (assign, reg6, 0),
     (assign, reg7, 0),
     (try_begin),
       (eq, ":new_owner", "$g_talk_troop"),
       (assign, reg6, 1),
     (else_try),
       (eq, ":new_owner", "trp_player"),
       (assign, reg7, 1),
     (else_try),
       (str_store_troop_name, s11, ":new_owner"),
     (try_end),
     (str_store_party_name, s1, "$g_center_taken_by_player_faction"),
     (troop_get_type, reg3, ":new_owner"),
     
     (assign, "$g_center_taken_by_player_faction", -1),	 	           

     #new start
     (try_begin),
       (eq, "$g_next_menu", "mnu_castle_taken"), 
       (jump_to_menu, "$g_next_menu"),
     (try_end),  
     #new end
     ]],

  #TUTORIAL START
  [anyone, "start",
   [
     (is_between, "$g_talk_troop", tutorial_fighters_begin, tutorial_fighters_end),
     (eq, "$g_tutorial_training_ground_conversation_state", 0),
     (eq, "$g_tutorial_fighter_talk_before", 0)],
   "Hello there. We are polishing off our combat skills here with a bit of sparring practice.\
 You look like you could use a bit of training. Why don't you join us, and we can show you a few tricks.\
 And if you need explanation of any combat concepts, just ask, and I will do my best to fill you in.", "fighter_talk",
   [
     (try_begin),
       (eq, "$g_tutorial_training_ground_intro_message_being_displayed", 1),
       (assign, "$g_tutorial_training_ground_intro_message_being_displayed", 0),
       (tutorial_message, -1), #remove tutorial intro immediately before a conversation
     (try_end),
     (assign, "$g_tutorial_fighter_talk_before", 1)]],

   [anyone, "start",
   [(is_between, "$g_talk_troop", tutorial_fighters_begin, tutorial_fighters_end),
   (eq, "$g_tutorial_training_ground_conversation_state", 0)],
   "What do you want to practice?", "fighter_talk", []],

   [anyone, "fighter_pretalk", [],
   "Tell me what kind of practice you want.", "fighter_talk", []],
   
   [anyone|plyr, "fighter_talk",
   [],
   "I want to practice attacking.", "fighter_talk_train_attack", []],

  [anyone|plyr, "fighter_talk",
   [],
   "I want to practice blocking with my weapon.", "fighter_talk_train_parry", []],

  [anyone|plyr, "fighter_talk",
   [],
   "Let's do some sparring practice.", "fighter_talk_train_combat", []],

  [anyone|plyr, "fighter_talk",
   [(eq,1,0)],
   "{!}TODO: Let's train chamber blocking.", "fighter_talk_train_chamber", []],

  [anyone|plyr, "fighter_talk",
   [],
   "[Leave]", "close_window", []],
  
  [anyone, "fighter_talk_train_attack",
   [
     (get_player_agent_no, ":player_agent"),
     (agent_has_item_equipped, ":player_agent", "itm_practice_sword"), #TODO: add other melee weapons
     ],
   "All right. There are four principle directions for attacking. These are overhead swing, right swing, left swing and thrust.\
 Now, I will tell you which direction to attack from and you must try to do the correct attack.\
 ^^(Move your mouse while you press the left mouse button to specify attack direction. For example, to execute an overhead attack, move the mouse up at the instant you press the left mouse button.\
 The icons on your screen will help you do the correct action.)" , "fighter_talk_train_attack_2",
   []],

  [anyone|plyr, "fighter_talk_train_attack_2",  [],
   "Let's begin then. I am ready.", "close_window",
   [
     (assign, "$g_tutorial_training_ground_melee_trainer_attack", "$g_talk_troop"),
     (assign, "$g_tutorial_training_ground_melee_state", 0),
     (assign, "$g_tutorial_training_ground_melee_trainer_action_state", 0),
     (assign, "$g_tutorial_training_ground_current_score", 0),
     (assign, "$g_tutorial_training_ground_current_score_2", 0),
     (assign, "$g_tutorial_update_mouse_presentation", 0),
     ]],

  [anyone|plyr, "fighter_talk_train_attack_2",  [],
   "Actually I want to do something else.", "fighter_pretalk", []],
	 
  [anyone, "fighter_talk_train_attack",
   [(str_store_string, s3, "str_tutorial_training_ground_warning_no_weapon")],
   "{!}{s3}", "close_window",
   []],

  [anyone, "fighter_talk_train_parry",
   [
     (get_player_agent_no, ":player_agent"),
     (agent_has_item_equipped, ":player_agent", "itm_practice_sword"), #TODO: add other melee weapons
     ],
   "Unlike a shield, blocking with a weapon can only stop attacks coming from one direction.\
 For example if you block up, you'll deflect overhead attacks, but you can still be hit by side swings or thrust attacks.\
 ^^(You must press and hold down the right mouse button to block.)", "fighter_talk_train_parry_2", [ ]],

	 [anyone, "fighter_talk_train_parry_2", [],
   "I'll now attack you with different types of strokes, and I will wait until you do the correct block before attacking.\
 Try to do the correct block as soon as you can.\
 ^^(This practice is easy to do with the 'automatic block direction' setting which is the default.\
 If you go to the Options menu and change defend direction control to 'mouse movement' or 'keyboard', you'll need to manually choose block direction. This is much more challenging, but makes the game much more interesting.\
 This practice can be very useful if you use manual blocking.)", "fighter_talk_train_parry_3",
   []],
	 
  [anyone|plyr, "fighter_talk_train_parry_3",  [],
   "Let's begin then. I am ready.", "close_window",
   [
     (assign, "$g_tutorial_training_ground_melee_trainer_parry", "$g_talk_troop"),
     (assign, "$g_tutorial_training_ground_melee_state", 0),
     (assign, "$g_tutorial_training_ground_melee_trainer_action_state", 0),
     (assign, "$g_tutorial_training_ground_current_score", 0),
     ]],

  [anyone|plyr, "fighter_talk_train_parry_3",  [],
   "Actually I want to do something else.", "fighter_pretalk", []],
	 
	 

  [anyone, "fighter_talk_train_parry",
   [(str_store_string, s3, "str_tutorial_training_ground_warning_no_weapon")],
   "{!}{s3}", "close_window",
   []],

  [anyone, "fighter_talk_train_chamber",
   [
     (get_player_agent_no, ":player_agent"),
     (agent_has_item_equipped, ":player_agent", "itm_practice_sword"), #TODO: add other melee weapons
     ],
   "{!}TODO: OK.", "close_window",
   [
     (assign, "$g_tutorial_training_ground_melee_trainer_chamber", "$g_talk_troop"),
     (assign, "$g_tutorial_training_ground_melee_state", 0),
     (assign, "$g_tutorial_training_ground_melee_trainer_action_state", 0),
     (assign, "$g_tutorial_training_ground_current_score", 0),
     ]],

  [anyone, "fighter_talk_train_chamber",
   [(str_store_string, s3, "str_tutorial_training_ground_warning_no_weapon")],
   "{!}{s3}", "close_window",
   []],

  [anyone, "fighter_talk_train_combat",
   [
     (get_player_agent_no, ":player_agent"),
     (agent_has_item_equipped, ":player_agent", "itm_practice_sword"), #TODO: add other melee weapons
     ],
   "Sparring is an excellent way to prepare for actual combat.\
 We'll fight each other with non-lethal weapons now, until one of us falls to the ground.\
 You can get some bruises of course, but better that than being cut down in the real thing.", "fighter_talk_train_combat_2",
   []],

  [anyone|plyr, "fighter_talk_train_combat_2",  [],
   "Let's begin then. I am ready.", "close_window", [
     (assign, "$g_tutorial_training_ground_melee_trainer_combat", "$g_talk_troop"),
     (assign, "$g_tutorial_training_ground_melee_state", 0),
     (assign, "$g_tutorial_training_ground_melee_trainer_action_state", 0),
     ]],

  [anyone|plyr, "fighter_talk_train_combat_2",  [],
   "Actually I want to do something else.", "fighter_pretalk", []],
	 
  [anyone, "fighter_talk_train_combat",
   [(str_store_string, s3, "str_tutorial_training_ground_warning_no_weapon")],
   "{!}{s3}", "close_window",
   []],

  [anyone, "start",
   [(is_between, "$g_talk_troop", tutorial_fighters_begin, tutorial_fighters_end),
   (eq, "$g_tutorial_training_ground_conversation_state", 1)], #parry complete
   "Good. You were able to block my attacks successfully. You may repeat this practice and try to get faster each time, until you are confident of your defense skills. Do you want to have another go?", "fighter_parry_try_again",
   [
     (assign, "$g_tutorial_training_ground_conversation_state", 0),
     ]],
	 
  [anyone, "start",
   [(is_between, "$g_talk_troop", tutorial_fighters_begin, tutorial_fighters_end),
   (eq, "$g_tutorial_training_ground_conversation_state", 2)], #player knocked down in parry
   "Well that didn't go too well, did it? (Remember, you must press and hold down the right mouse button to keep your block effective.) Do you want to try again?", "fighter_parry_try_again",
   [
     (assign, "$g_tutorial_training_ground_conversation_state", 0),
     ]],
	 
  [anyone|plyr, "fighter_parry_try_again",
   [],
   "Yes. Let's try again.", "fighter_talk_train_parry", []],

  [anyone|plyr, "fighter_parry_try_again",
   [],
   "No, I think I am done for now.", "fighter_talk_leave_parry", []],
	 
  [anyone, "start",
   [(is_between, "$g_talk_troop", tutorial_fighters_begin, tutorial_fighters_end),
   (eq, "$g_tutorial_training_ground_conversation_state", 3)], #trainer knocked down in parry
   "Hey! We are doing a blocking practice, mate! You are supposed to block my attacks, not attack me back.", "fighter_parry_warn",
   [
     (assign, "$g_tutorial_training_ground_conversation_state", 0),
     ]],
	 
  [anyone|plyr, "fighter_parry_warn",
   [],
   "I am sorry. Let's try once again.", "fighter_talk_train_parry", []],

  [anyone|plyr, "fighter_parry_warn",
   [],
   "Sorry. I must leave this practice now.", "fighter_talk_leave_parry", []],

  [anyone, "fighter_talk_leave_parry",
   [],
   "All right. As you wish.", "close_window", []],

  [anyone, "start",
   [(is_between, "$g_talk_troop", tutorial_fighters_begin, tutorial_fighters_end),
   (eq, "$g_tutorial_training_ground_conversation_state", 4)], #player knocked down in combat
   "Well that didn't go too well, did it?  Don't feel bad, and try not to do same mistakes next time. Do you want to have a go again?", "fighter_combat_try_again",
   [
     (assign, "$g_tutorial_training_ground_conversation_state", 0),
     ]],
	 
  [anyone|plyr, "fighter_combat_try_again",
   [],
   "Yes. Let's do another round.", "fighter_talk_train_combat", []],

  [anyone|plyr, "fighter_combat_try_again",
   [],
   "No. That was enough for me.", "fighter_talk_leave_combat", []],

  [anyone, "fighter_talk_leave_combat",
   [],
   "Well, all right. Talk to me again if you change your mind.", "close_window", []],

  [anyone, "start",
   [(is_between, "$g_talk_troop", tutorial_fighters_begin, tutorial_fighters_end),
   (eq, "$g_tutorial_training_ground_conversation_state", 5)], #trainer knocked down in combat
   "Hey, that was good sparring. You defeated me, but next time I'll be more careful. Do you want to have a go again?", "fighter_combat_try_again",
   [
     (assign, "$g_tutorial_training_ground_conversation_state", 0),
     ]],
	 
  # [anyone, "start",
   # [(is_between, "$g_talk_troop", tutorial_fighters_begin, tutorial_fighters_end),
   # (eq, "$g_tutorial_training_ground_conversation_state", 6)], #chamber complete
   # "{!}TODO: Congratulations. Anything else?", "fighter_talk",
   # [
     # (assign, "$g_tutorial_training_ground_conversation_state", 0),
     # ]],
	 
  # [anyone, "start",
   # [(is_between, "$g_talk_troop", tutorial_fighters_begin, tutorial_fighters_end),
   # (eq, "$g_tutorial_training_ground_conversation_state", 7)], #player knocked down in chamber
   # "{!}TODO: Want to try again?", "fighter_chamber_try_again",
   # [
     # (assign, "$g_tutorial_training_ground_conversation_state", 0),
     # ]],

  # [anyone|plyr, "fighter_chamber_try_again",
   # [],
   # "{!}TODO: OK let's try again.", "fighter_talk_train_chamber", []],

  # [anyone|plyr, "fighter_chamber_try_again",
   # [],
   # "TODO: No, let's leave it there.", "fighter_talk_leave_chamber", []],

  # [anyone, "fighter_talk_leave_chamber",
   # [],
   # "{!}TODO: OK. Bye.", "close_window", []],

  [anyone, "start",
   [(is_between, "$g_talk_troop", tutorial_fighters_begin, tutorial_fighters_end),
   (eq, "$g_tutorial_training_ground_conversation_state", 8)], #trainer knocked down in chamber
   "{!}TODO: What are you doing? Don't attack me except while chambering!", "fighter_chamber_warn",
   [
     (assign, "$g_tutorial_training_ground_conversation_state", 0),
     ]],
	 
  [anyone, "start",
   [(is_between, "$g_talk_troop", tutorial_fighters_begin, tutorial_fighters_end),
   (eq, "$g_tutorial_training_ground_conversation_state", 9)], #attack complete
   "Very good. You have learned how to attack from any direction you want. If you like we can try this again or move to a different exercise.", "fighter_talk",
   [
     (assign, "$g_tutorial_training_ground_conversation_state", 0),
     ]],
	 

  [anyone|plyr, "fighter_chamber_warn", # unused
   [],
   "{!}TODO: Sorry, let's try once again.", "fighter_talk_train_chamber", []],

  [anyone|plyr, "fighter_chamber_warn", # unused
   [],
   "{!}TODO: Sorry. I want to leave the exercise.", "close_window", []],

  [trp_tutorial_archer_1|auto_proceed, "start",
   [],
   "{!}.", "tutorial_troop_default",
   []],

  [trp_tutorial_master_archer, "start",
   [
     (eq, "$g_tutorial_training_ground_archer_trainer_completed_chapters", 1),
     ],
   "Not bad. Not bad at all! You seem to have grasped the basics of archery. Now, try to do the same thing with a crossbow.\
 Take the crossbow and the bolts over there and shoot those three targets. The crossbow is much easier to shoot with compared with the bow,\
 but you need to reload it after each shot.", "archer_challenge_2", []],

	 [trp_tutorial_master_archer, "start",
   [
     (eq, "$g_tutorial_training_ground_archer_trainer_completed_chapters", 2),
     ],
   "Good. You didn't have too much difficulty using the crossbow either. Next you will learn to use throwing weapons.\
 Pick up the javelins you see over there and try to hit those three targets. ", 
 "archer_challenge_2", []],

  [trp_tutorial_master_archer, "start",
   [
     (eq, "$g_tutorial_training_ground_archer_trainer_completed_chapters", 3),
     ],
   "Well, with that you have recevied the basic skills to use all three types of ranged weapons. The rest will come with practice. Train each and every day, and in time you will be as good as the best marksmen in Calradia.", 
   "ranged_end", []],
	 
	 [trp_tutorial_master_archer, "ranged_end", [],
   "Now, you can go talk with the melee fighters or the horsemanship trainer if you haven't already done so. They can teach you important skills too.", 
   "close_window", []],

  [trp_tutorial_master_archer, "start",
   [
     (try_begin),
       (eq, "$g_tutorial_training_ground_intro_message_being_displayed", 1),
       (assign, "$g_tutorial_training_ground_intro_message_being_displayed", 0),
       (tutorial_message, -1), #remove tutorial intro immediately before a conversation
     (try_end),

     ],
   "Good day to you, young fellow. I spend my days teaching about ranged weapons to anyone that is willing to learn.\
 If you need a tutor, let me know and I'll teach you how to use the bow, the crossbow and the javelin.", "archer_talk",
   []],

  [anyone|plyr, "archer_talk",
   [
     (eq, "$g_tutorial_training_ground_archer_trainer_completed_chapters", 0),
     ],
   "Yes, show me how to use ranged weapons.", "archer_challenge", []],

  # [anyone|plyr, "archer_talk",
   # [
     # (gt, "$g_tutorial_training_ground_archer_trainer_completed_chapters", 0),
     # ],
   # "{!}TODO: I want to move to the next stage.", "archer_challenge", []],

  [anyone|plyr, "archer_talk",
   [],
   "No, not now.", "close_window", []],

  [trp_tutorial_master_archer, "archer_challenge",
   [
     (eq, "$g_tutorial_training_ground_archer_trainer_completed_chapters", 0),
     ],
   "All right. Your first training will be in bowmanship. The bow is a difficult weapon to master. But once you are sufficiently good at it, you can shoot quickly and with great power.\
 Go pick up the bow and arrows you see over there now and shoot those targets.", "archer_challenge_2",
   []],

  # [trp_tutorial_master_archer, "archer_challenge",
   # [
     # (eq, "$g_tutorial_training_ground_archer_trainer_completed_chapters", 1),
     # ],
   # "{!}TODO: Make 3 shots with crossbow.", "archer_challenge_2",
   # []],

  # [trp_tutorial_master_archer, "archer_challenge",
   # [],
   # "{!}TODO: Make 3 shots with javelin.", "archer_challenge_2",
   # []],

  [anyone|plyr, "archer_challenge_2",
   [],
   "All right. I am ready.", "close_window",
   [
     (assign, "$g_tutorial_training_ground_archer_trainer_state", 1),
     (try_begin),
       (eq, "$g_tutorial_training_ground_archer_trainer_completed_chapters", 0),
       (assign, "$g_tutorial_training_ground_archer_trainer_item_1", "itm_practice_bow"),
       (assign, "$g_tutorial_training_ground_archer_trainer_item_2", "itm_practice_arrows"),
     (else_try),
       (eq, "$g_tutorial_training_ground_archer_trainer_completed_chapters", 1),
       (assign, "$g_tutorial_training_ground_archer_trainer_item_1", "itm_practice_crossbow"),
       (assign, "$g_tutorial_training_ground_archer_trainer_item_2", "itm_practice_bolts"),
     (else_try),
       (assign, "$g_tutorial_training_ground_archer_trainer_item_1", "itm_practice_javelin"),
       (assign, "$g_tutorial_training_ground_archer_trainer_item_2", -1),
     (try_end),
     ]],

  [anyone|plyr, "archer_challenge_2",
   [],
   "Just a minute. I want to do something else first.", "close_window",
   []],


  [trp_tutorial_master_horseman, "start",
   [
     (eq, "$g_tutorial_training_ground_horseman_trainer_completed_chapters", 1),
     ],
   "I hope you enjoyed the ride. Now we move on to something a bit more difficult. Grab the lance you see over there and ride around the course hitting each target at least once.", 
   "horseman_melee_challenge_2", []],
   
  [trp_tutorial_master_horseman, "start",
   [
     (eq, "$g_tutorial_training_ground_horseman_trainer_completed_chapters", 2),
     ],
   "Good! You have been able to hit all targets on horseback. That's no easy feat for a starter. Your next challange will be using a bow and arrows to shoot at the archery targets by the road. You need to put an arrow to each target to consider yourself successful.", 
   "horseman_melee_challenge_2", []],

  [trp_tutorial_master_horseman, "start",
   [
     (eq, "$g_tutorial_training_ground_horseman_trainer_completed_chapters", 3),
     ],
   "Very good. You were able to shoot all targets from horseback. Keep riding and practicing each day and in time you will be an expert horseman.", "horsemanship_end",
   [
     ]],
	 
	 [trp_tutorial_master_horseman, "horsemanship_end",
   [
     ],
   "Now, you can go talk with the melee fighters or the archery trainer if you haven't already done so. You need to learn everything you can to be prepared when you have to defend yourself.", "close_window",
   []],
	 

	 
  [trp_tutorial_master_horseman, "start",
   [
     (try_begin),
       (eq, "$g_tutorial_training_ground_intro_message_being_displayed", 1),
       (assign, "$g_tutorial_training_ground_intro_message_being_displayed", 0),
       (tutorial_message, -1), #remove tutorial intro immediately before a conversation
     (try_end),
     ],
   "Good day! I have come here for some riding practice, but my old bones are aching badly so I decided to give myself a rest today.\
 If you would like to practice your horsemanship, you can take my horse here. The exercise would be good for her.", "horseman_talk",
   []],

  [anyone|plyr, "horseman_talk",
   [],
   "Yes, I would like to practice riding.", "horseman_challenge", []],

  [anyone|plyr, "horseman_talk",
   [],
   "Uhm. Maybe later.", "close_window", []],

  # [trp_tutorial_master_horseman, "horseman_challenge",
   # [
     # (eq, "$g_tutorial_training_ground_player_continue_without_basics", 0),
     # (this_or_next|eq, "$g_tutorial_training_ground_melee_trainer_attack_completed", 0),
     # (eq, "$g_tutorial_training_ground_archer_trainer_completed_chapters", 0),
    # ],
   # "Hmm. Do you know how to use your weapons? You'd better learn to use those on foot before you start to train using them on horseback.", "horseman_ask",
   # []],

  # [anyone|plyr, "horseman_ask",
   # [],
   # "Yes, I know ", "horseman_challenge",
   # [
     # (assign, "$g_tutorial_training_ground_player_continue_without_basics", 1),
     # ]],

  # [anyone|plyr, "horseman_ask",
   # [],
   # "{!}TODO: No", "horseman_ask_2",
   # []],

  # [trp_tutorial_master_horseman, "horseman_ask_2",
   # [],
   # "{!}TODO: Come back later then.", "close_window",
   # []],

  [trp_tutorial_master_horseman, "horseman_challenge",
   [
     (eq, "$g_tutorial_training_ground_horseman_trainer_completed_chapters", 0),
    ],
   "Good. Now, I will give you a few exercises that'll teach you riding and horseback weapon use.\
 Your first assignment is simple. Just take your horse for a ride around the course.\
 Go as slow or as fast as you like.\
 Come back when you feel confident as a rider and I'll give you some tougher exercises.", "horseman_melee_challenge_2",
   []],

  [anyone|plyr, "horseman_melee_challenge_2",
   [],
   "All right. I am ready.", "close_window",
   [
     (assign, "$g_tutorial_training_ground_horseman_trainer_state", 1),
     (try_begin),
       (eq, "$g_tutorial_training_ground_horseman_trainer_completed_chapters", 0),
       (assign, "$g_tutorial_training_ground_horseman_trainer_item_1", -1),
       (assign, "$g_tutorial_training_ground_horseman_trainer_item_2", -1),
     (else_try),
       (eq, "$g_tutorial_training_ground_horseman_trainer_completed_chapters", 1),
       (assign, "$g_tutorial_training_ground_horseman_trainer_item_1", "itm_arena_lance"),
       (assign, "$g_tutorial_training_ground_horseman_trainer_item_2", -1),
     (else_try),
       (assign, "$g_tutorial_training_ground_horseman_trainer_item_1", "itm_practice_bow_2"),
       (assign, "$g_tutorial_training_ground_horseman_trainer_item_2", "itm_practice_arrows_2"),
     (try_end),
     ]],

  [anyone|plyr, "horseman_melee_challenge_2",
   [],
   "Just a minute. I need to do something else first.", "close_window", []],

  [trp_tutorial_rider_1|auto_proceed, "start",
   [],
   "{!}Warning: This line is never displayed.", "tutorial_troop_default",
   []],

  [trp_tutorial_rider_2|auto_proceed, "start",
   [],
   "{!}Warning: This line is never displayed.", "tutorial_troop_default",
   []],

  [anyone, "tutorial_troop_default",
   [
     (try_begin),
       (eq, "$g_tutorial_training_ground_intro_message_being_displayed", 1),
       (assign, "$g_tutorial_training_ground_intro_message_being_displayed", 0),
       (tutorial_message, -1), #remove tutorial intro immediately before a conversation
     (try_end),
     ],
   "Hey, I am trying to practice here. Go, talk with the archery trainer if you need guidance about ranged weapons.", "close_window", []],


   #PRISON BREAK START
   [anyone,"start",
   [                    
     (eq, "$talk_context", tc_prison_break),                    
     (troop_slot_eq, "$g_talk_troop", slot_troop_prisoner_of_party, "$g_encountered_party"),
     (troop_slot_ge, "$g_talk_troop", slot_troop_mission_participation, mp_stay_out),
   ],
   "Is there a change of plans?", "lord_prison_break_confirm_3",[]],
   
   [anyone,"start",
   [
     (eq, "$talk_context", tc_prison_break),
     (try_begin),
       (eq, "$cheat_mode", 1),
       (assign, reg0, "$g_talk_troop"),
       (assign, reg1, "$g_encountered_party"),
       (troop_get_slot, reg2, "$g_talk_troop", slot_troop_prisoner_of_party),
       (display_message, "@{!}g_talk_troop = {reg0} , g_encountered_party = {reg1} , slot value = {reg2}"),
     (try_end),
     (troop_slot_eq, "$g_talk_troop", slot_troop_prisoner_of_party, "$g_encountered_party"),
   ],
   "What's going on?", "lord_prison_break",[]],
   
   
   #TAVERN DRUNK DIALOGS
   [anyone, "start", 
   [
	(eq, "$g_talk_troop", "trp_belligerent_drunk"),
	],
   "What are you looking at?", "drunk_response", 
   [
     (try_begin),
       (eq, "$g_main_attacker_agent", 0),
       (call_script, "script_activate_tavern_attackers"),       
     (try_end),
     (mission_disable_talk),
   ]],

   [anyone, "start", 
   [
	(eq, "$g_talk_troop", "trp_hired_assassin"),
	],
   "Are you looking at me?", "drunk_response", 
   [
     (try_begin),
       (eq, "$g_main_attacker_agent", 0),
       (call_script, "script_activate_tavern_attackers"),       
     (try_end),
     (mission_disable_talk),
   ]],

   [anyone, "start", 
   [
	(eq, "$g_talk_troop", "trp_hired_assassin"),
		(eq,1,0),
	],
   "{!}Added to match dialog ids with translations.", "close_window", 
   []],
 
   
  [anyone, "start", [
  (is_between, "$g_talk_troop", tavernkeepers_begin, tavernkeepers_end),
  (gt, "$g_main_attacker_agent", 0),
  (neg|agent_is_alive, "$g_main_attacker_agent"),
  
  (try_begin),
 	(neg|agent_is_alive, "$g_main_attacker_agent"),
	(agent_get_troop_id, ":type", "$g_main_attacker_agent"),
	(eq, ":type", "trp_hired_assassin"),
	
	(str_store_string, s9, "str_strange_that_one_didnt_seem_like_your_ordenary_troublemaker_he_didnt_drink_all_that_much__he_just_stood_there_quietly_and_watched_the_door_you_may_wish_to_consider_whether_you_have_any_enemies_who_know_you_are_in_town_a_pity_that_blood_had_to_be_spilled_in_my_establishment"),

    (assign, "$g_main_attacker_agent", 0),
	(troop_add_gold, "trp_player", 50),
	(troop_add_item, "trp_player", "itm_sword_viking_1", 0),
	
  (else_try),
	#(display_message, "str_wielded_item_reg3"),
	
	(lt, "$g_attacker_drawn_weapon", "itm_tutorial_spear"),
	(str_store_string, s9, "str_you_never_let_him_draw_his_weapon_still_it_looked_like_he_was_going_to_kill_you_take_his_sword_and_purse_i_suppose_he_was_trouble_but_its_not_good_for_an_establishment_to_get_a_name_as_a_place_where_men_are_killed"),

    (assign, "$g_main_attacker_agent", 0),
	(troop_add_gold, "trp_player", 50),
	(troop_add_item, "trp_player", "itm_sword_viking_1", 0),
	(call_script, "script_troop_change_relation_with_troop", "trp_player", "$g_talk_troop", -1),
  (else_try),
	(neg|agent_is_alive, "$g_main_attacker_agent"),
	(str_store_string, s9, "str_well_id_say_that_he_started_it_that_entitles_you_to_his_sword_and_purse_i_suppose_have_a_drink_on_the_house_as_i_daresay_youve_saved_a_patron_or_two_a_broken_skull_still_i_hope_he_still_has_a_pulse_its_not_good_for_an_establishment_to_get_a_name_as_a_place_where_men_are_killed"),
    (assign, "$g_main_attacker_agent", 0),
	(troop_add_gold, "trp_player", 50),
	(troop_add_item, "trp_player", "itm_sword_viking_1", 0),
	(call_script, "script_troop_change_relation_with_troop", "trp_player", "$g_talk_troop", 1),
  (try_end),	
  (troop_set_slot, "trp_hired_assassin", slot_troop_cur_center, -1),
  ],
   "{!}{s9}", "player_duel_response", [
   ]],

   
  [anyone, "start", [
  (is_between, "$g_talk_troop", tavernkeepers_begin, tavernkeepers_end),
  (gt, "$g_main_attacker_agent", 0),
  (try_begin),
	(get_player_agent_no, ":player_agent"),
	(agent_get_wielded_item, ":wielded_item", ":player_agent", 0),
	(is_between, ":wielded_item", "itm_darts", "itm_torch"),
	(neq, ":wielded_item", "itm_javelin_melee"),
	(neq, ":wielded_item", "itm_throwing_spear_melee"),
	(neq, ":wielded_item", "itm_jarid_melee"),
	(neq, ":wielded_item", "itm_light_throwing_axes_melee"),
	(neq, ":wielded_item", "itm_throwing_axes_melee"),
	(neq, ":wielded_item", "itm_heavy_throwing_axes_melee"),
	(str_store_string, s9, "str_stop_no_shooting_no_shooting"),

    (assign, ":default_item", -1),
	(troop_get_inventory_capacity, ":end_cond", "trp_player"), 
	(try_for_range, ":i_slot", 0, ":end_cond"),
      (troop_get_inventory_slot, ":item_id", "trp_player", ":i_slot"),
      
      (is_between, ":item_id", weapons_begin, weapons_end),
      (neg|is_between, ":item_id", ranged_weapons_begin, ranged_weapons_end),
      
      (assign, ":default_item", ":item_id"),
      (assign, ":end_cond", 0), #break
    (try_end),
	
	(agent_set_wielded_item, ":player_agent", ":default_item"),
  (else_try),
	(str_store_string, s9, "str_em_ill_stay_out_of_this"),
  (try_end),
  ],
   "{!}{s9}", "close_window", [
   ]],

  [anyone|plyr, "player_duel_response", [],
   "Such a waste...", "close_window", [
   ]],
   
  [anyone|plyr, "player_duel_response", [],
   "Better him than me", "close_window", [
   ]],

   
  [anyone|plyr, "drunk_response", [],
   "I'm not sure... Some sort of animal, clearly", "drunk_fight_start", [
   ]],
   
  [anyone|plyr, "drunk_response", [],
   "Excuse me -- please accept my apologies", "drunk_fight_start", [
   ]],
   
  [anyone, "drunk_fight_start", [],
   "I'll wipe that smirk right off your face!", "close_window", [
	(troop_set_slot, "trp_belligerent_drunk", slot_troop_cur_center, 0),	
   ]],
      
  [anyone|plyr, "drunk_response", 
  [
    (troop_slot_ge, "trp_player", slot_troop_renown, 150),
  ],
   "Do you have any idea who I am?", "drunk_player_high_renown", [
   ]],

  [anyone, "drunk_player_high_renown", [
  (eq, "$g_talk_troop", "trp_hired_assassin"),
  ],
   "Do I care?", "drunk_fight_start", [
   ]],
   
  [anyone, "drunk_player_high_renown", [],
   "Emmm... Actually... Yes, yes, I do know who you are, {sir/madame}. Please forgive me, your grace -- it must be the drink. I'll be leaving, now...", "drunk_player_high_renown", [
   ]],
   
  [anyone|plyr, "drunk_player_high_renown", [],
   "Why, if you want a fight, you shall have one!", "drunk_fight_start", [
   ]],
   
  [anyone|plyr, "drunk_player_high_renown", [],
   "I thought as much. Now, remove yourself from here", "close_window", 
   [
     (assign, "$drunks_dont_pick_fights", 1),
     (troop_set_slot, "trp_belligerent_drunk", slot_troop_cur_center, 0),
          
     (call_script, "script_deactivate_tavern_attackers"),
     
     (assign, "$g_belligerent_drunk_leaving", "$g_main_attacker_agent"),
     
     (mission_enable_talk),
     
     (try_for_agents, ":agent"),
       (agent_is_alive, ":agent"),
       (agent_get_position, pos4, ":agent"),
       (agent_set_scripted_destination, ":agent", pos4),
     (try_end),
     
     (entry_point_get_position, pos1, 0),
     (agent_set_scripted_destination, "$g_main_attacker_agent", pos1),
     
     (assign, "$g_main_attacker_agent", 0),
   ]],
   
   
   [anyone, "start", 
   [
	 (eq, "$g_talk_troop", "trp_fight_promoter"),	
   ],
   "You look like a {fellow/lady} who can take a few hard knocks -- and deal them out, too. I have a business proposition for you.", "fistfight_response", [
   ]],
   
  [anyone|plyr, "fistfight_response", [],
   "How's that?", "fistfight_response_2", [
   ]],

  [anyone, "fistfight_response_2", [
  ],
   "Good -- I'm glad you're interested. Here's the plan... It's a little complicated, so listen well. ", "fistfight_response_2a", [
   ]],

  [anyone, "fistfight_response_2a", [
  ],
	"You and this other fellow will start up a fight here. No weapons, no armor -- I'll sit back and take bets, and split the profits with the winner. If we make a loss, then I'll cover it. You've got nothing to lose -- except a bit of blood, of course.", "fistfight_response_3", [
   ]],

  [anyone, "fistfight_response_3", [
  ],
   "However, we can't organize this like one of those nice arena bouts, where everyone places their bets beforehand. People will walk in, drawn by the noise, and put a denar or two on whichever one of your two they think is winning. I'll give 'em even odds -- anything else is going to be too tricky for someone who's already on his third flagon of ale.", "fistfight_response_4", [
   ]],
   
  [anyone, "fistfight_response_4", [
  ],
   "So, as you can see, the trick is to stretch things out for as long as possible where it looks like you're losing, and people bet against you -- and then come back fast, and win, before the betting can turn. The best way to make money is for you to be battered almost to the floor, and then jump back off your feet and take the other guy down. However, you have to win in the end in order for me, and you, to make money. ", "fistfight_response_4a", [
   ]],
   
  [anyone, "fistfight_response_4a", [
  ],
   "Also, you can't stretch the fight out too long, or people will suspect a fix. So, one of you has to take a punch every so often. I don't care whose blood is spilled, but there has to be some blood.", "fistfight_response_5", [
   ]],

  [anyone, "fistfight_response_5", [
  ],
   "And one other thing -- my mate, your opponent, he doesn't take to well to complexity. So he's just going to come straight at you. It's up to you to supply the artistry.", "fistfight_response_5a", [
   ]],
   
  [anyone, "fistfight_response_5a", [
  ],
   "So, what do you think?", "fistfight_response_confirm", [
   ]],

  [anyone|plyr, "fistfight_response_confirm", [
  ],
   "{!}[Yes -- not yet implemented]", "close_window", [
   ]],

  [anyone|plyr, "fistfight_response_confirm", [
  ],
   "I have better things to do", "close_window", [
   ]],
   
   
   
  [trp_ramun_the_slave_trader, "start", [
   (troop_slot_eq, "$g_talk_troop", slot_troop_met_previously, 0),
   ], "Good day to you, {young man/lassie}.", "ramun_introduce_1",[]],
  [trp_ramun_the_slave_trader|plyr, "ramun_introduce_1", [], "Forgive me, you look like a trader, but I see none of your merchandise.", "ramun_introduce_2",[
   (troop_set_slot, "$g_talk_troop", slot_troop_met_previously, 1),
  ]],
  [trp_ramun_the_slave_trader|plyr, "ramun_introduce_1", [], "Never mind.", "close_window",[]],
  [trp_ramun_the_slave_trader, "ramun_introduce_2", [], "A trader? Oh, aye, I certainly am that.\
 My merchandise is a bit different from most, however. It has to be fed and watered twice a day and tries to run away if I turn my back.", "ramun_introduce_3",[]],
  [trp_ramun_the_slave_trader|plyr, "ramun_introduce_3", [], "Livestock?", "ramun_introduce_4",[]],
  [trp_ramun_the_slave_trader, "ramun_introduce_4", [], "Close enough. I like to call myself the man who keeps every boat on this ocean moving.\
 Boats are driven by oars, you see, and oars need men to pull them or they stop. That's where I come in.", "ramun_introduce_5",[]],
  [trp_ramun_the_slave_trader|plyr, "ramun_introduce_5", [], "Galley slaves.", "ramun_introduce_6",[]],
  [trp_ramun_the_slave_trader, "ramun_introduce_6", [], "Now you're catching on! A trading port like this couldn't survive without them.\
 The ships lose a few hands on every voyage, so there's always a high demand. The captains come to me and they pay well.", "ramun_introduce_7",[]],
  [trp_ramun_the_slave_trader|plyr, "ramun_introduce_7", [], "Where do the slaves come from?", "ramun_introduce_8",[]],
  [trp_ramun_the_slave_trader, "ramun_introduce_8", [], "Mostly I deal in convicted criminals bought from the authorities.\
 Others are prisoners of war from various nations, brought to me because I offer the best prices.\
 However, on occasion I'll buy from privateers and other . . . 'individuals'. You can't be picky about your suppliers in this line of work.\
 You wouldn't happen to have any prisoners with you, would you?", "ramun_introduce_9",[]],
  [trp_ramun_the_slave_trader|plyr, "ramun_introduce_9", [], "Me? ", "ramun_introduce_10",[]],
  [trp_ramun_the_slave_trader, "ramun_introduce_10", [], "Why not? If you intend to set foot outside this town,\
 you're going to cross swords with someone sooner or later. And, God willing, you'll come out on top.\
 Why not make some extra money off the whole thing? Take them alive, bring them back to me, and I'll pay you fifty denars for each head.\
 Don't much care who they are or where they come from.", "ramun_introduce_11",[]],
  [trp_ramun_the_slave_trader|plyr, "ramun_introduce_11", [], "Hmm. I'll think about it.", "ramun_introduce_12",[]],
  [trp_ramun_the_slave_trader, "ramun_introduce_12", [], "Do think about it!\
 There's a lot of silver to be made, no mistake. More than enough for the both of us.", "close_window",[]],

  [trp_ramun_the_slave_trader,"start", [], "Hello, {playername}.", "ramun_talk",[]],
  [trp_ramun_the_slave_trader,"ramun_pre_talk", [], "Anything else?", "ramun_talk",[]],

  [trp_ramun_the_slave_trader|plyr,"ramun_talk",
   [[store_num_regular_prisoners,reg(0)],[ge,reg(0),1]],
   "I've brought you some prisoners, Ramun. Would you like a look?", "ramun_sell_prisoners",[]],
  [trp_ramun_the_slave_trader,"ramun_sell_prisoners", [],
  "Let me see what you have...", "ramun_sell_prisoners_2",
   [[change_screen_trade_prisoners]]],
  [trp_ramun_the_slave_trader, "ramun_sell_prisoners_2", [], "A pleasure doing business with you.", "close_window",[]],

  [trp_ramun_the_slave_trader|plyr,"ramun_talk", [(neg|troop_slot_ge,"$g_talk_troop",slot_troop_met_previously,1)], "How do I take somebody as prisoner?", "ramun_ask_about_capturing",[]],
  [trp_ramun_the_slave_trader|plyr,"ramun_talk", [(troop_slot_ge,"$g_talk_troop", slot_troop_met_previously, 1)], "Can you tell me again about capturing prisoners?", "ramun_ask_about_capturing",[(troop_set_slot,"$g_talk_troop", slot_troop_met_previously, 2)]],

  [trp_ramun_the_slave_trader,"ramun_ask_about_capturing", [(neg|troop_slot_ge,"$g_talk_troop",slot_troop_met_previously,1)],
 "You're new to this, aren't you? Let me explain it in simple terms.\
 The basic rule of taking someone prisoner is knocking him down with a blunt weapon, like a mace or a club,\
 rather than cutting him open with a sword. That way he goes to sleep for a little while rather than bleeding to death, you see?\
 I'm assuming you have a blunt weapon with you . . .", "ramun_have_blunt_weapon",[]],
  [trp_ramun_the_slave_trader|plyr,"ramun_have_blunt_weapon", [],
 "Of course.", "ramun_have_blunt_weapon_yes",[]],
  [trp_ramun_the_slave_trader|plyr,"ramun_have_blunt_weapon", [],
 "As a matter of fact, I don't.", "ramun_have_blunt_weapon_no",[]],
  [trp_ramun_the_slave_trader,"ramun_have_blunt_weapon_yes", [],
 "Good. Then all you need to do is beat the bugger down with your weapon, and when the fighting's over you clap him in irons.\
 It's a bit different for nobles and such, they tend to be protected enough that it won't matter what kind of weapon you use,\
 but your average rabble-rouser will bleed like a stuck pig if you get him with something sharp. I don't have many requirements in my merchandise,\
 but I do insist they be breathing when I buy them.", "ramun_ask_about_capturing_2",[]],
  [trp_ramun_the_slave_trader,"ramun_have_blunt_weapon_no", [],
 "No? Heh, well, this must be your lucky day. I've got an old club lying around that I was going to throw away.\
 It a bit battered, but still good enough bash someone until he stops moving.\
 Here, have it.","ramun_have_blunt_weapon_no_2",[(troop_add_item, "trp_player","itm_club",imod_cracked)]],
  [trp_ramun_the_slave_trader|plyr,"ramun_have_blunt_weapon_no_2", [],
 "Thanks, Ramun. Perhaps I may try my hand at it.", "ramun_have_blunt_weapon_yes",[]],
  [trp_ramun_the_slave_trader,"ramun_ask_about_capturing", [],
 "Alright, I'll try and expain it again in simple terms. The basic rule of taking someone prisoner is knocking him down with a blunt weapon, like a mace or a club,\
 rather than cutting him open with a sword. That way he goes to sleep for a little while rather than bleeding to death, you see?\
 It's a bit different for nobles and such, they tend to be protected enough that it won't matter what kind of weapon you use,\
 but your average rabble-rouser will bleed like a stuck pig if you get him with something sharp.", "ramun_ask_about_capturing_2",[]],
  [trp_ramun_the_slave_trader|plyr,"ramun_ask_about_capturing_2", [], "Alright, I think I understand. Anything else?", "ramun_ask_about_capturing_3",[]],
  [trp_ramun_the_slave_trader,"ramun_ask_about_capturing_3", [],
 "Well, it's not as simple as all that. Blunt weapons don't do as much damage as sharp ones, so they won't bring your enemies down as quickly.\
 And trust me, given the chance, most of the scum you run across would just as soon kill you as look at you, so don't expect any courtesy when you pull out a club instead of a sword.\
 Moreover, having to drag prisoners to and fro will slow down your party, which is why some people simply set their prisoners free after the fighting's done.\
 It's madness. How could anyone turn down all that silver, eh?", "ramun_ask_about_capturing_4",[]],
  [trp_ramun_the_slave_trader|plyr,"ramun_ask_about_capturing_4", [],
 "Is that everything?", "ramun_ask_about_capturing_5",[]],
  [trp_ramun_the_slave_trader,"ramun_ask_about_capturing_5", [],
 "Just one final thing. Managing prisoners safely is not an easy thing to do, you could call it a skill in itself.\
 If you want to capture a lot of prisoners, you should try and learn the tricks of it yourself,\
 or you won't be able to hang on to a single man you catch.", "ramun_ask_about_capturing_7",[]],
  [trp_ramun_the_slave_trader|plyr,"ramun_ask_about_capturing_7", [],
 "Thanks, I'll keep it in mind.", "ramun_pre_talk",[]],

  [trp_ramun_the_slave_trader|plyr,"ramun_talk", [], "I'd better be going.", "ramun_leave",[]],
  [trp_ramun_the_slave_trader,"ramun_leave", [], "Remember, any prisoners you've got, bring them to me. I'll pay you good silver for every one.", "close_window",[]],

  

  
  
  
  [trp_nurse_for_lady, "start", [
#  (eq, "$talk_context", tc_garden),
  ], "I humbly request that your lordship keeps his hands where I can see them.", "close_window",[]],

##  [trp_tutorial_trainer, "start", [(eq, "$tutorial_1_state", 1),], "TODO: Watch me.", "tutorial_1_1_1",[]],
##  [trp_tutorial_trainer, "tutorial_1_1_1", [], "TODO: This is up.", "tutorial_1_1_2",[(agent_set_attack_action, "$g_talk_agent", 3),]],
##  [trp_tutorial_trainer, "tutorial_1_1_2", [], "TODO: This is left.", "tutorial_1_1_3",[(agent_set_attack_action, "$g_talk_agent", 2),]],
##  [trp_tutorial_trainer, "tutorial_1_1_3", [], "TODO: This is right.", "tutorial_1_1_4",[(agent_set_attack_action, "$g_talk_agent", 1),]],
##  [trp_tutorial_trainer|plyr, "tutorial_1_1_4", [], "TODO: OK.", "close_window",[]],


#old tutorial is below

##  [trp_tutorial_trainer,"start", [(eq, "$tutorial_quest_award_taken", 1),], "I think you have trained enough. Perhaps you should go to Zendar for the next step of your adventure.", "close_window",[]],
##  [trp_tutorial_trainer,"start", [(store_character_level, ":player_level", "trp_player"),(gt, ":player_level", 1)], "I think you have trained enough. Perhaps you should go to Zendar for the next step of your adventure.", "close_window",[]],
##  [trp_tutorial_trainer,"start", [(eq, "$tutorial_quest_taken", 0),], "Greetings stranger. What's your name?", "tutorial1_1",[]],
##  [trp_tutorial_trainer|plyr, "tutorial1_1", [], "Greetings sir, it's {playername}.", "tutorial1_2", []],
##  [trp_tutorial_trainer, "tutorial1_2", [], "Well {playername}, this place you see is the training ground. Locals come here to practice their combat skills. Since you are here you may have a go as well.", "tutorial1_3", []],
##  [trp_tutorial_trainer|plyr, "tutorial1_3", [], "I'd like that very much sir. Thank you.", "tutorial1_4", []],
##  [trp_tutorial_trainer, "tutorial1_4", [], "You will learn the basics of weapons and riding a horse here.\
##  First you'll begin with melee weapons. Then you'll enter an archery range to test your skills. And finally you'll see a horse waiting for you.\
##  I advise you to train in all these 3 areas. But you can skip some of them, it's up to you.", "tutorial1_6", []],
##  [trp_tutorial_trainer, "tutorial1_6", [], "Tell you what, if you destroy at least 10 dummies while training, I will give you my old knife as a reward. It's a little rusty but it's a good blade.", "tutorial1_7", []],
##  [trp_tutorial_trainer|plyr, "tutorial1_7", [], "Sounds nice, I'm ready for training.", "tutorial1_9", []],
##  [trp_tutorial_trainer, "tutorial1_9", [], "Good. Return to me when you have earned your reward.", "close_window", [(eq, "$tutorial_quest_taken", 0),
##                                                                                                                     (str_store_troop_name, 1, "trp_tutorial_trainer"),
##                                                                                                                     (str_store_party_name, 2, "p_training_ground"),
##                                                                                                                     (setup_quest_giver, "qst_destroy_dummies", "str_given_by_s1_at_s2"),
##                                                                                                                     (str_store_string, s2, "@Trainer ordered you to destroy 10 dummies in the training camp."),
##                                                                                                                     (call_script, "script_start_quest", "qst_destroy_dummies", "$g_talk_troop"),
##                                                                                                                     (assign, "$tutorial_quest_taken", 1)]],
##
##  [trp_tutorial_trainer,"start", [(eq, "$tutorial_quest_taken", 1),
##                                  (eq, "$tutorial_quest_succeeded", 1),], "Well done {playername}. Now you earned this knife. There you go.", "tutorial2_1",[]],
##  [trp_tutorial_trainer|plyr, "tutorial2_1", [], "Thank you master.", "close_window", [(call_script, "script_end_quest", "qst_destroy_dummies"),(assign, "$tutorial_quest_award_taken", 1),(add_xp_to_troop, 100, "trp_player"),(troop_add_item, "trp_player","itm_knife",imod_chipped),]],
##
##  [trp_tutorial_trainer,"start", [(eq, "$tutorial_quest_taken", 1),
##                                  (eq, "$tutorial_quest_succeeded", 1),], "Greetings {playername}. Feel free to train with the targets.", "tutorial2_1",[]],
##
##  [trp_tutorial_trainer,"start", [(eq, "$tutorial_quest_taken", 1),
##                                  (eq, "$tutorial_quest_succeeded", 0),], "I don't see 10 dummies on the floor from here. You haven't earned your reward yet.", "tutorial3_1",[]],
##  [trp_tutorial_trainer|plyr, "tutorial3_1", [], "Alright alright, I was just tired and wanted to talk to you while resting.", "tutorial3_2", []],
##  [trp_tutorial_trainer, "tutorial3_2", [], "Less talk, more work.", "close_window", []],


##  [party_tpl|pt_peasant,"start", [(eq,"$talk_context",tc_party_encounter)], "Greetings traveller.", "peasant_talk_1",[(play_sound,"snd_encounter_farmers")]],
##  [party_tpl|pt_peasant|plyr,"peasant_talk_1", [[eq,"$quest_accepted_zendar_looters"]], "Greetings to you too.", "close_window",[(assign, "$g_leave_encounter",1)]],
##  [party_tpl|pt_peasant|plyr,"peasant_talk_1", [[neq,"$quest_accepted_zendar_looters"],[eq,"$peasant_misunderstanding_said"]], "I have been charged with hunting down outlaws in this area...", "peasant_talk_2",[[assign,"$peasant_misunderstanding_said",1]]],
##  [party_tpl|pt_peasant|plyr,"peasant_talk_1", [[neq,"$quest_accepted_zendar_looters"],[neq,"$peasant_misunderstanding_said"]], "Greetings. I am hunting outlaws. Have you seen any around here?", "peasant_talk_2b",[]],
##  [party_tpl|pt_peasant,"peasant_talk_2", [], "I swear to God {sir/madam}. I am not an outlaw... I am just a simple peasant. I am taking my goods to the market, see.", "peasant_talk_3",[]],
##  [party_tpl|pt_peasant|plyr,"peasant_talk_3", [], "I was just going to ask if you saw any outlaws around here.", "peasant_talk_4",[]],
##  [party_tpl|pt_peasant,"peasant_talk_4", [], "Oh... phew... yes, outlaws are everywhere. They are making life miserable for us.\
## I pray to God you will kill them all.", "close_window",[(assign, "$g_leave_encounter",1)]],
##  [party_tpl|pt_peasant,"peasant_talk_2b", [], "Outlaws? They are everywhere. They are making life miserable for us.\
## I pray to God you will kill them all.", "close_window",[(assign, "$g_leave_encounter",1)]],

  [party_tpl|pt_manhunters,"start", [(eq,"$talk_context",tc_party_encounter)], "Hey, you there! You seen any outlaws around here?", "manhunter_talk_b",[]],
  [party_tpl|pt_manhunters|plyr,"manhunter_talk_b", [], "Yes, they went this way about an hour ago.", "manhunter_talk_b1",[]],
  [party_tpl|pt_manhunters,"manhunter_talk_b1", [], "I knew it! Come on, lads, lets go get these bastards! Thanks a lot, friend.", "close_window",[(assign, "$g_leave_encounter",1)]],
  [party_tpl|pt_manhunters|plyr,"manhunter_talk_b", [], "No, haven't seen any outlaws lately.", "manhunter_talk_b2",[]],
  [party_tpl|pt_manhunters,"manhunter_talk_b2", [], "Bah. They're holed up in this country like rats, but we'll smoke them out yet. Sooner or later.", "close_window",[(assign, "$g_leave_encounter",1)]],

  [party_tpl|pt_looters|auto_proceed,"start", [(eq,"$talk_context",tc_party_encounter),(encountered_party_is_attacker),], "{!}Warning: This line should never be displayed.", "looters_1",[
	(str_store_string, s11, "@It's your money or your life, {mate/girlie}. No sudden moves or we'll run you through."),
	(str_store_string, s12, "@Lucky for you, you caught me in a good mood. Give us all your coin and I might just let you live."),
	(str_store_string, s13, "@This a robbery, eh? I givin' you one chance to hand over everythin' you got, or me and my mates'll kill you. Understand?"),
	(store_random_in_range, ":random", 11, 14),
	(str_store_string_reg, s4, ":random"),
	(play_sound, "snd_encounter_looters")
  ]],
  [party_tpl|pt_looters,"looters_1", [], "{s4}", "looters_2",[]],
  [party_tpl|pt_looters|plyr,"looters_2", [[store_character_level,reg(1),"trp_player"],[lt,reg(1),4]], "I'm not afraid of you lot. Fight me if you dare!", "close_window",
   [[encounter_attack]]],
  [party_tpl|pt_looters|plyr,"looters_2", [[store_character_level,reg(1),"trp_player"],[ge,reg(1),4]], "You'll have nothing of mine but cold steel, scum.", "close_window",
   [[encounter_attack]]],

  [party_tpl|pt_village_farmers,"start", [(eq,"$talk_context",tc_party_encounter),
                                          (agent_play_sound, "$g_talk_agent", "snd_encounter_farmers"),
  ],
   " My {lord/lady}, we're only poor farmers from the village of {s11}. {reg1?We are taking our products to the market at {s12}.:We are returning from the market at {s12} back to our village.}", "village_farmer_talk",
   [(party_get_slot, ":target_center", "$g_encountered_party", slot_party_ai_object),
    (party_get_slot, ":home_center", "$g_encountered_party", slot_party_home_center),
    (party_get_slot, ":market_town", ":home_center", slot_village_market_town),
    (str_store_party_name, s11, ":home_center"),
    (str_store_party_name, s12, ":market_town"),
    (assign, reg1, 1),
    (try_begin),
      (party_slot_eq, ":target_center", slot_party_type, spt_village),
      (assign, reg1, 0),
    (try_end),
    ]],

  [anyone|plyr,"village_farmer_talk",
  [(check_quest_active, "qst_track_down_bandits"),
   (neg|check_quest_succeeded, "qst_track_down_bandits"),
   
  ], "I am hunting a group of bandits with the following description... Have you seen them?", "farmer_bandit_information",[]],
  
  [anyone,"farmer_bandit_information", [
	(call_script, "script_get_manhunt_information_to_s15", "qst_track_down_bandits"),
  ], "{s15}", "village_farmer_talk",[]],
			
	
  [anyone|plyr,"village_farmer_talk", 
  [ 
    (store_faction_of_party, ":faction_of_villager", "$g_encountered_party"),
    
    (neq, ":faction_of_villager", "$players_kingdom"),
    (neq, ":faction_of_villager", "fac_player_supporters_faction"),
  ], 
  "We'll see how poor you are after I take what you've got!", "close_window",
   [(party_get_slot, ":home_center", "$g_encountered_party", slot_party_home_center),
    (party_get_slot, ":market_town", ":home_center", slot_village_market_town),
    (party_get_slot, ":village_owner", ":home_center", slot_town_lord),
    (call_script, "script_change_player_relation_with_center", ":home_center", -4),
    (call_script, "script_change_player_relation_with_center", ":market_town", -2),
    (call_script, "script_change_player_relation_with_troop", ":village_owner", -2),
	(call_script, "script_diplomacy_party_attacks_neutral", "p_main_party", "$g_encountered_party"),
	
    (store_relation,":rel", "$g_encountered_party_faction","fac_player_supporters_faction"),
    (try_begin),
      (gt, ":rel", 0),
      (val_sub, ":rel", 5),
    (try_end),
	
    (val_sub, ":rel", 3),
    (call_script, "script_set_player_relation_with_faction", "$g_encountered_party_faction", ":rel"),
    
    (assign,"$encountered_party_hostile",1),
    (assign,"$encountered_party_friendly",0),
    ]],
  [anyone|plyr,"village_farmer_talk", [], "Carry on, then. Farewell.", "close_window",[(assign, "$g_leave_encounter",1)]],


### COMPANIONS

  [anyone,"start", [(gt,"$g_talk_troop", 0),
                    (eq, "$g_talk_troop", "$g_player_minister"),
					(neg|troop_slot_eq, "trp_player", slot_troop_spouse, "$g_talk_troop")],
   "I am at your service, {sire/my lady}", "minister_issues",[]],

  [anyone,"start", [(eq,"$g_talk_troop", "trp_temporary_minister"),
                    (neq, "$g_talk_troop", "$g_player_minister")],
   "It has been an honor to serve you, {sire/my lady}", "close_window",[]],
   
   
  [anyone,"start", [(troop_slot_eq,"$g_talk_troop", slot_troop_occupation, slto_player_companion),
                    (party_slot_eq, "$g_encountered_party", slot_party_type, spt_castle),
                    (party_get_num_companion_stacks, ":num_stacks", "$g_encountered_party"),
                    (ge, ":num_stacks", 1),
                    (party_stack_get_troop_id, ":castle_leader", "$g_encountered_party", 0),
                    (eq, ":castle_leader", "$g_talk_troop"),
                    (eq, "$talk_context", 0)],
   "Yes, {playername}? What can I do for you?", "member_castellan_talk",[]],
  
  [anyone,"member_castellan_pretalk", [], "Anything else?", "member_castellan_talk",[]],
  
  [anyone|plyr,"member_castellan_talk", [],
   "I want to review the castle garrison.", "member_review_castle_garrison",[]],
  [anyone,"member_review_castle_garrison", [], "Of course. Here are our lists, let me know of any changes you require...", "member_castellan_pretalk",[(change_screen_exchange_members,0)]],
  [anyone|plyr,"member_castellan_talk", [],
   "Let me see your equipment.", "member_review_castellan_equipment",[]],
  [anyone,"member_review_castellan_equipment", [], "Very well, it's all here...", "member_castellan_pretalk",[(change_screen_equip_other)]],
  [anyone|plyr,"member_castellan_talk", [],
   "I want you to abandon the castle and join my party.", "member_castellan_join",[]],
  [anyone,"member_castellan_join", [(party_can_join_party,"$g_encountered_party","p_main_party")],
   "I've grown quite fond of the place... But if it is your wish, {playername}, I'll come with you.", "close_window", [
       (assign, "$g_move_heroes", 1),
       (call_script, "script_party_add_party", "p_main_party", "$g_encountered_party"),
       (party_clear, "$g_encountered_party"),
       ]],
  [anyone,"member_castellan_join", [],
   "And where would we sleep? You're dragging a whole army with you, {playername}, there's no more room for all of us.", "member_castellan_pretalk",[]],
  
  [anyone|plyr,"member_castellan_talk", [], "[Leave]", "close_window",[]],


  [anyone,"start", [(troop_slot_eq,"$g_talk_troop", slot_troop_occupation, slto_player_companion),
                    (neg|main_party_has_troop,"$g_talk_troop"),
                    (eq, "$talk_context", tc_party_encounter)],
   "{!}Do you want me to rejoin you?", "close_window",[]], # unused
  [anyone,"start", [(neg|main_party_has_troop,"$g_talk_troop"),(eq, "$g_encountered_party", "p_four_ways_inn")], "{!}Do you want me to rejoin you?", "close_window",[]], # unused
#  [anyone,"member_separate_inn", [], "I don't know what you will do without me, but you are the boss. I'll wait for you at the Four Ways inn.", "close_window",
#  [anyone,"member_separate_inn", [], "All right then. I'll meet you at the four ways inn. Good luck.", "close_window",
#   [(remove_member_from_party,"$g_talk_troop", "p_main_party"),(add_troop_to_site, "$g_talk_troop", "scn_four_ways_inn", borcha_inn_entry)]],

#Quest heroes member chats

  [trp_kidnapped_girl,"member_chat", [], "Are we home yet?", "kidnapped_girl_chat_1",[]],
  [trp_kidnapped_girl|plyr,"kidnapped_girl_chat_1", [], "Not yet.", "kidnapped_girl_chat_2",[]],
  [trp_kidnapped_girl,"kidnapped_girl_chat_2", [], "I can't wait to get back. I've missed my family so much, I'd give anything to see them again.", "close_window",[]],

  [anyone,"member_chat",
   [
    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
    ], "{playername}, when do you think we can reach our destination?", "member_lady_1",[]],
  [anyone|plyr, "member_lady_1", [],  "We still have a long way ahead of us.", "member_lady_2a", []],
  [anyone|plyr, "member_lady_1", [],  "Very soon. We're almost there.", "member_lady_2b", []],

  [anyone ,"member_lady_2a", [],  "Ah, I am going to enjoy the road for a while longer then. I won't complain.\
 I find riding out in the open so much more pleasant than sitting in the castle all day.\
 You know, I envy you. You can live like this all the time.", "close_window", []],
  [anyone ,"member_lady_2b", [],  "That's good news. Not that I don't like your company, but I did miss my little luxuries.\
 Still I am sorry that I'll leave you soon. You must promise me, you'll come visit me when you can.", "close_window", []],

  [anyone ,"member_chat", [(is_between, "$g_talk_troop", pretenders_begin, pretenders_end),],
   "Greetings, {playername}, my first and foremost vassal. I await your counsel.", "supported_pretender_talk", []],
  [anyone ,"supported_pretender_pretalk", [],
   "Anything else?", "supported_pretender_talk", []],

  [anyone|plyr,"supported_pretender_talk", [],
   "What do you think about our progress so far?", "pretender_progress",[]],

  [anyone,"pretender_progress", [
       (assign, reg11, 0),(assign, reg13, 0),(assign, reg14, 0),(assign, reg15, 0),
       (assign, reg21, 0),(assign, reg23, 0),(assign, reg24, 0),(assign, reg25, 0),
       
       (try_for_range, ":troop_no", active_npcs_begin, active_npcs_end),
	     (troop_slot_eq, ":troop_no", slot_troop_occupation, slto_kingdom_hero),
         (store_troop_faction, ":troop_faction", ":troop_no"),
         (try_begin),
           (eq, ":troop_faction", "fac_player_supporters_faction"),
           (neq, ":troop_no", "trp_player"),
           (neq, ":troop_no", "$supported_pretender"),
           (val_add, reg11, 1),
         (else_try),
           (eq, ":troop_faction", "$supported_pretender_old_faction"),
           (neg|faction_slot_eq, "$supported_pretender_old_faction", slot_faction_leader, ":troop_no"),
           (val_add, reg21, 1),
         (try_end),
       (try_end),
       (try_for_range, ":center_no", centers_begin, centers_end),
         (store_faction_of_party, ":center_faction", ":center_no"),
         (try_begin),
           (eq, ":center_faction", "fac_player_supporters_faction"),
           (try_begin),
             (party_slot_eq, ":center_no", slot_party_type, spt_town),
             (val_add, reg13, 1),
           (else_try),
             (party_slot_eq, ":center_no", slot_party_type, spt_castle),
             (val_add, reg14, 1),
           (else_try),
             (party_slot_eq, ":center_no", slot_party_type, spt_village),
             (val_add, reg15, 1),
           (try_end),
         (else_try),
           (eq, ":center_faction", "$supported_pretender_old_faction"),
           (try_begin),
             (party_slot_eq, ":center_no", slot_party_type, spt_town),
             (val_add, reg23, 1),
           (else_try),
             (party_slot_eq, ":center_no", slot_party_type, spt_castle),
             (val_add, reg24, 1),
           (else_try),
             (party_slot_eq, ":center_no", slot_party_type, spt_village),
             (val_add, reg25, 1),
           (try_end),
         (try_end),
       (try_end),
       (store_add, reg19, reg13, reg14),
       (val_add, reg19, reg15),
       (store_add, reg29, reg23, reg24),
       (val_add, reg29, reg25),
       (store_add, ":our_score", reg13, reg14),
       (val_add, ":our_score", reg11),
       (store_add, ":their_score", reg23, reg24),
       (val_add, ":their_score", reg21),
       (store_add, ":total_score", ":our_score", ":their_score"),
       (val_mul, ":our_score", 100),
       (store_div, ":our_ratio", ":our_score", ":total_score"),
       (try_begin),
         (lt, ":our_ratio", 10),
         (str_store_string, s30, "@we have made very little progress so far"),
       (else_try),
         (lt, ":our_ratio", 30),
         (str_store_string, s30, "@we have suceeded in gaining some ground, but we still have a long way to go"),
       (else_try),
         (lt, ":our_ratio", 50),
         (str_store_string, s30, "@we have become a significant force, and we have an even chance of victory"),
       (else_try),
         (lt, ":our_ratio", 75),
         (str_store_string, s30, "@we are winning the war, but our enemies are still holding on."),
       (else_try),
         (str_store_string, s30, "@we are on the verge of victory. The remaining enemies pose no threat, but we still need to hunt them down."),
       (try_end),
       (faction_get_slot, ":enemy_king", "$supported_pretender_old_faction", slot_faction_leader),
       (str_store_troop_name, s9, ":enemy_king"),
      ],
   "{reg11?We have {reg11} lords on our side:We have no lord with us yet},\
 whereas {reg21?{s9} still has {reg21} lords supporting him:{s9} has no loyal lords left}.\
 {reg19?We control {reg13?{reg13} towns:} {reg14?{reg14} castles:} {reg15?and {reg15} villages:}:We don't control any settlements},\
 while {reg29?they have {reg23?{reg23} towns:} {reg24?{reg24} castles:} {reg25?and {reg25} villages:}:they have no remaining settlements}.\
 Overall, {s30}.", "pretender_progress_2",[]],

  [anyone|plyr,"pretender_progress_2", [],
   "Then, we must keep fighting and rally our supporters!", "supported_pretender_pretalk",[]],

  [anyone|plyr,"pretender_progress_2", [],
   "It seems this rebellion is not going anywhere. We must give up.", "pretender_quit_rebel_confirm",[]],
  
  [anyone,"pretender_quit_rebel_confirm", [],
   "{playername}, you can't abandon me now. Are you serious?", "pretender_quit_rebel_confirm_2",[]],
  
  [anyone|plyr,"pretender_quit_rebel_confirm_2", [],
   "Indeed, I am. I can't support you any longer.", "pretender_quit_rebel_confirm_3",[]],
  
  [anyone|plyr,"pretender_quit_rebel_confirm_2", [],
   "I was jesting. I will fight for you until we succeed.", "supported_pretender_pretalk",[]],
 
   [anyone,"pretender_quit_rebel_confirm_3", [],
   "Are you absolutely sure? I will never forgive you if you abandon my cause.", "pretender_quit_rebel_confirm_4",[]],
  
  [anyone|plyr,"pretender_quit_rebel_confirm_4", [],
   "I am sure.", "pretender_quit_rebel",[]],
  
  [anyone|plyr,"pretender_quit_rebel_confirm_4", [],
   "Let me think about this some more.", "supported_pretender_pretalk",[]],
 
  [anyone,"pretender_quit_rebel", [],
   "So be it. Then my cause is lost. There is only one thing to do for me now. I will go from Calradia and never come back. With me gone, you may try to make your peace with {s4}.", "close_window",
   [
     (troop_get_slot, ":original_faction", "$g_talk_troop", slot_troop_original_faction),
	 (faction_get_slot, ":original_faction_leader", ":original_faction", slot_faction_leader),
	 (str_store_troop_name, s4, ":original_faction_leader"),
	 
     (try_for_range, ":cur_troop", active_npcs_begin, active_npcs_end),
	   (troop_slot_eq, ":cur_troop", slot_troop_occupation, slto_kingdom_hero),
	   (neq, "$supported_pretender", ":cur_troop"),
       (store_troop_faction, ":cur_faction", ":cur_troop"),
       (eq, ":cur_faction", "fac_player_supporters_faction"),
       (call_script, "script_change_troop_faction", ":cur_troop", ":original_faction"),
     (try_end),
     (troop_set_faction, "$g_talk_troop", "fac_neutral"),
     (faction_set_slot, "fac_player_supporters_faction", slot_faction_leader, "trp_player"),
     (assign, ":has_center", 0),
     (try_for_range, ":cur_center", centers_begin, centers_end),
       (store_faction_of_party, ":cur_faction", ":cur_center"),
       (eq, ":cur_faction", "fac_player_supporters_faction"),
       (assign, ":has_center", 1),
       (neg|party_slot_eq, ":cur_center", slot_town_lord, "trp_player"),
       (call_script, "script_give_center_to_lord", ":cur_center", "trp_player", 0),
     (try_end),
     (party_remove_members, "p_main_party", "$supported_pretender", 1),
     (faction_set_slot, ":original_faction", slot_faction_has_rebellion_chance, 0),
     (assign, "$supported_pretender", 0),
     (try_begin), #Still has center
       (eq, ":has_center", 1),
       (faction_set_color, "fac_player_supporters_faction", 0xFF0000),
	   (try_begin), #added to prevent no minister if player gives up rebellion
		(eq, "$g_player_minister", 0),
		(assign, "$g_player_minister", "trp_temporary_minister"),
	   (try_end), 
     (else_try), #No center
       (call_script, "script_deactivate_player_faction"),
     (try_end),
     (call_script, "script_change_player_honor", -20),
     (call_script, "script_fail_quest", "qst_rebel_against_kingdom"),
     (call_script, "script_end_quest", "qst_rebel_against_kingdom"),
    ]],


  [anyone|plyr,"supported_pretender_talk", [],
   "{reg65?My lady:My lord}, would you allow me to check out your equipment?", "supported_pretender_equip",[]],
  [anyone,"supported_pretender_equip", [], "Very well, it's all here...", "supported_pretender_pretalk",[
      (change_screen_equip_other),
      ]],

  [anyone|plyr,"supported_pretender_talk", [], "If it would please you, can you tell me about your skills?", "pretneder_view_char_requested",[]],
  [anyone,"pretneder_view_char_requested", [], "Well, all right.", "supported_pretender_pretalk",[(change_screen_view_character)]],

  
  [anyone|plyr,"supported_pretender_talk", [
  
  (assign, ":center_found", 0),
  (try_for_range, ":fief_to_grant", centers_begin, centers_end),
	(store_faction_of_party, ":fief_faction", ":fief_to_grant"),
	(eq, ":fief_faction", "fac_player_supporters_faction"),  
	(party_slot_eq, ":fief_to_grant", slot_town_lord, -1),
    (assign, ":center_found", 1),
  (try_end),
  (eq, ":center_found", 1),
  
  ],
   "I suggest that you decide who should hold a fief that does not have a lord.", "supported_pretender_grant_fief",[]],
  
  [anyone,"supported_pretender_grant_fief", [
  ],
   "Which fief did you have in mind?", "supported_pretender_grant_fief_select",[]],

  [anyone|plyr|repeat_for_parties,"supported_pretender_grant_fief_select", [
  (store_repeat_object, ":fief_to_grant"),
  (is_between, ":fief_to_grant", centers_begin, centers_end),
  (store_faction_of_party, ":fief_faction", ":fief_to_grant"),
  (eq, ":fief_faction", "fac_player_supporters_faction"),  
  (party_slot_eq, ":fief_to_grant", slot_town_lord, -1),
  (str_store_party_name, s4, ":fief_to_grant"),
  ],
   "{s4}", "supported_pretender_grant_fief_choose_recipient",[
   (store_repeat_object, "$g_center_taken_by_player_faction"),   
   ]],

  [anyone,"supported_pretender_grant_fief_choose_recipient", [
  ],
   "And who should receive it?", "center_captured_rebellion",[
   (str_store_party_name, s4, "$g_center_taken_by_player_faction"),
   ]],
   
  [anyone|plyr,"supported_pretender_grant_fief_select", [
  ],
   "Never mind.", "supported_pretender_pretalk",[]],
  
  
  

  [anyone|plyr,"supported_pretender_talk", [],
   "Let us keep going, {reg65?my lady:sir}.", "close_window",[]],


  [anyone,"do_member_trade", [], "Anything else?", "member_talk",[]],

  [anyone,"member_pretalk", [], "Anything else?", "member_talk",[]],

  
  
  
  [anyone,"member_chat", 
  [
    (store_conversation_troop,"$g_talk_troop"),
    (troop_is_hero,"$g_talk_troop"),
    (troop_get_slot, ":honorific", "$g_talk_troop", slot_troop_honorific),
    (str_store_string, s5, ":honorific"),
  ], "Yes, {s5}?", "member_talk",
  [
    (try_begin),
      (is_between, "$g_talk_troop", companions_begin, companions_end),
      (unlock_achievement, ACHIEVEMENT_TALKING_HELPS),
    (try_end),
  ]],
						  
  [anyone|plyr,"member_talk", [
	(is_between, "$players_kingdom", kingdoms_begin, kingdoms_end),
	(faction_slot_eq,  "$players_kingdom", slot_faction_marshall, "trp_player"),
  ], "As marshal, I wish you to send a message to the vassals of the realm", "member_direct_campaign",[]],
						  
						  
  [anyone|plyr,"member_talk", [],

   "Let me see your equipment.", "member_trade",[]],
  [anyone,"member_trade", [], "Very well, it's all here...", "do_member_trade",[
#      (change_screen_trade)
      (change_screen_equip_other),
      ]],

  [anyone,"do_member_trade", [], "Anything else?", "member_talk",[]],

  [anyone|plyr,"member_talk", [], "What can you tell me about your skills?", "view_member_char_requested",[]],
  [anyone,"view_member_char_requested", [], "All right, let me tell you...", "do_member_view_char",[(change_screen_view_character)]],

  [anyone|plyr,"member_talk", [], "We need to separate for a while.", "member_separate",[
            (call_script, "script_npc_morale", "$g_talk_troop"),
            (assign, "$npc_quit_morale", reg0),
      ]],

  [anyone,"member_separate", [
            (gt, "$npc_quit_morale", 30),
      ], "Oh really? Well, I'm not just going to wait around here. I'm going to go to the towns to look for other work. Is that what you want?", "member_separate_confirm",
   []],

  [anyone,"member_separate", [
      ], "Well, actually, there was something I needed to tell you.", "companion_quitting",
   [
        (assign, "$player_can_refuse_npc_quitting", 0),
        (assign, "$player_can_persuade_npc", 0),
       ]],


  [anyone|plyr,"member_separate_confirm", [], "That's right. We need to part ways.", "member_separate_yes",[]],
  [anyone|plyr,"member_separate_confirm", [], "No, I'd rather have you at my side.", "do_member_trade",[]],

  [anyone,"member_separate_yes", [
      ], "Well. I'll be off, then. Look me up if you need me.", "close_window",
   [
            (troop_set_slot, "$g_talk_troop", slot_troop_occupation, 0),
            (troop_set_slot, "$g_talk_troop", slot_troop_playerparty_history, pp_history_dismissed),
            (remove_member_from_party, "$g_talk_troop"),
       ]],


  [anyone|plyr,"member_talk", [], "I'd like to ask you something.", "member_question",[]],

  [anyone|plyr,"member_talk", [], "Never mind.", "close_window",[]],

  [anyone,"member_question", [], "Very well. What did you want to ask?", "member_question_2",[]],

  [anyone|plyr,"member_question_2", [], "How do you feel about the way things are going in this company?", "member_morale",[]],
  [anyone|plyr,"member_question_2", [], "Tell me your story again.", "member_background_recap",[]],
  [anyone|plyr,"member_question_2", [
	(troop_slot_eq, "$g_talk_troop", slot_troop_kingsupport_state, 0),
  ], "I suppose you know that I aspire to be {king/queen} of this land?", "member_kingsupport_1",[]],

  [anyone|plyr,"member_question_2", [
  ], "Do you have any connections that we could use to our advantage?", "member_intelgathering_1",[]],
  
  [anyone|plyr,"member_question_2", [
	(faction_slot_eq, "$players_kingdom", slot_faction_leader, "trp_player"),
  ], "Would you be interested in holding a fief?", "member_fief_grant_1",[]],
  
  
  [anyone,"member_morale", [
        (call_script, "script_npc_morale", "$g_talk_troop"),
      ], "{s21}", "do_member_trade",[]],

  [anyone,"member_background_recap", [
          (troop_get_slot, ":first_met", "$g_talk_troop", slot_troop_first_encountered),
          (str_store_party_name, 20, ":first_met"),
          (troop_get_slot, ":home", "$g_talk_troop", slot_troop_home),
          (str_store_party_name, 21, ":home"),
          (troop_get_slot, ":recap", "$g_talk_troop", slot_troop_home_recap),
          (str_store_string, 5, ":recap"),
      ], "{s5}", "member_background_recap_2",[]],

  [anyone,"member_background_recap_2", [
          (str_clear, 19),
          (troop_get_slot, ":background", "$g_talk_troop", slot_troop_backstory_b),
          (str_store_string, 5, ":background"),
      ], "{s5}", "member_background_recap_3",[]],

	  [anyone,"member_background_recap_3", [
      ], "Then shortly after, I joined up with you.", "do_member_trade",[]],

  [anyone,"do_member_view_char", [], "Anything else?", "member_talk",[]],

  
  [anyone,"member_kingsupport_1", [
		 (troop_get_slot, ":morality_grievances", "$g_talk_troop", slot_troop_morality_penalties),
		 (gt, ":morality_grievances", 10),
        ], "Um... Yes. I had heard.", "do_member_trade",[]],

  [anyone,"member_kingsupport_1", [
		 (store_sub, ":npc_no", "$g_talk_troop", "trp_npc1"),
		 (store_add, ":string", "str_npc1_kingsupport_1", ":npc_no"),
#		 (troop_get_slot, ":string", "$g_talk_troop", slot_troop_kingsupport_string_1),
		 (str_store_string, s21, ":string"),
        ], "{s21}", "member_kingsupport_1a",[]],
  
  [anyone|plyr,"member_kingsupport_1a", [
        ], "Would you then support my cause?", "member_kingsupport_2",[]],

  [anyone|plyr,"member_kingsupport_1a", [
        ], "Very good. I shall keep that in mind.", "do_member_trade",[]],


  [anyone,"member_kingsupport_2", [
		(assign, ":companion_already_on_mission", -1),
		(try_for_range, ":companion", companions_begin, companions_end),
			(troop_slot_eq, ":companion", slot_troop_occupation, slto_player_companion),
			(troop_get_slot, ":days_on_mission", ":companion", slot_troop_days_on_mission),
			(gt, ":days_on_mission", 17),
			(neg|main_party_has_troop, ":companion"),
			(assign, ":companion_already_on_mission", ":companion"),
		(try_end),

		(gt, ":companion_already_on_mission", -1),
		(troop_get_slot, ":honorific", "$g_talk_troop", slot_troop_honorific),
		(str_store_string, s21, ":honorific"),
		(str_store_troop_name, s22, ":companion_already_on_mission"),

		], "I would, {s21}. Moreover, I have a proposal on how I might help you attain your throne. But you recently sent {s22} off on a similar mission. Perhaps we should wait for a couple of weeks to avoid drawing too much attention to ourselves.", "do_member_trade",[]],

		
  [anyone,"member_kingsupport_2", [
		 (store_sub, ":npc_no", "$g_talk_troop", "trp_npc1"),
		 (store_add, ":string", "str_npc1_kingsupport_2", ":npc_no"),
#		 (troop_get_slot, ":string", "$g_talk_troop", slot_troop_kingsupport_string_2),
		 (str_store_string, s21, ":string"),
        ], "{s21}", "member_kingsupport_2a",[]],
  
  [anyone|plyr,"member_kingsupport_2a", [
		 (store_sub, ":npc_no", "$g_talk_troop", "trp_npc1"),
		 (store_add, ":string", "str_npc1_kingsupport_2a", ":npc_no"),
#  		 (troop_get_slot, ":string", "$g_talk_troop", slot_troop_kingsupport_string_2a),
		 (str_store_string, s21, ":string"),
        ], "{s21}", "member_kingsupport_3",[]],

  [anyone|plyr,"member_kingsupport_2a", [
		 (store_sub, ":npc_no", "$g_talk_troop", "trp_npc1"),
		 (store_add, ":string", "str_npc1_kingsupport_2b", ":npc_no"),
#    	 (troop_get_slot, ":string", "$g_talk_troop", slot_troop_kingsupport_string_2b),
		 (str_store_string, s21, ":string"),

        ], "{s21}", "do_member_trade",[]],

  [anyone,"member_kingsupport_3", [
		 (store_sub, ":npc_no", "$g_talk_troop", "trp_npc1"),
		 (store_add, ":string", "str_npc1_kingsupport_3", ":npc_no"),
#		 (troop_get_slot, ":string", "$g_talk_troop", slot_troop_kingsupport_string_3),
		 (str_store_string, s21, ":string"),
        ], "{s21}", "member_kingsupport_3a",[]],


  [anyone|plyr,"member_kingsupport_3a", [
        ], "Very good. You do that", "member_kingsupport_4",[
		]],

  [anyone|plyr,"member_kingsupport_3a", [
        ], "On second thought, stay with me for a while", "do_member_trade",[]],

  [anyone,"member_kingsupport_4", [
  		 (troop_set_slot, "$g_talk_troop", slot_troop_days_on_mission, 21),
  		 (troop_set_slot, "$g_talk_troop", slot_troop_current_mission, npc_mission_kingsupport),

		 (remove_member_from_party, "$g_talk_troop", "p_main_party"),
		 		 
		 (troop_get_slot, ":string", "$g_talk_troop", slot_troop_honorific),
		 (str_store_string, s21, ":string"),

		 ], "Farewell then, {s21}, for a little while", "close_window",[]],

  [anyone,"member_intelgathering_1", [
		 (troop_get_slot, ":town_with_contacts", "$g_talk_troop", slot_troop_town_with_contacts),
		 (str_store_party_name, s17, ":town_with_contacts"),
		 (store_faction_of_party, ":contact_town_faction", ":town_with_contacts"),
		 (str_store_faction_name, s18, ":contact_town_faction"),
		 
		 (store_sub, ":npc_no", "$g_talk_troop", "trp_npc1"),
		 (store_add, ":connections_string", "str_npc1_intel_mission", ":npc_no"),
		 (str_store_string, s21, ":connections_string"),
		 ], "{s21}", "member_intelgathering_3",[]],
		
  [anyone,"member_intelgathering_3", [ #change back to member_intelgathering_2 if this will be used
		(eq, 1, 0),
  ], "Of course, as few people should know of this as possible. If you want to collect the information, or pull me out, then don't send a messenger. Come and get me yourself -- even if that means you have to sneak through the gates.", "member_intelgathering_3",[]],
		
  [anyone|plyr,"member_intelgathering_3", [
		 ], "Splendid idea -- you do that.", "member_intelgathering_4",[]],
		
  [anyone|plyr,"member_intelgathering_3", [
		 ], "Actually, hold off for now.", "do_member_trade",[]],

  [anyone,"member_intelgathering_4", [
  		 (troop_set_slot, "$g_talk_troop", slot_troop_days_on_mission, 5),
  		 (troop_set_slot, "$g_talk_troop", slot_troop_current_mission, npc_mission_gather_intel),
		 
		 (remove_member_from_party, "$g_talk_troop", "p_main_party"),
		 		 
		 (troop_get_slot, ":string", "$g_talk_troop", slot_troop_honorific),
		 (str_store_string, s21, ":string"),

		 ], "Good. I should be ready to report in about five days. Farewell then, {s21}, for a little while.", "close_window",[]],
		 
		 
		 
[anyone|auto_proceed, "start", 
  [  
    (is_between, "$g_talk_troop", "trp_swadian_merchant", "trp_startup_merchants_end"),
    (eq, "$talk_context", tc_town_talk),    
  ],  
  "{!}.", "merchant_quest_4_start", 
  [
  ]],
  
[anyone, "merchant_quest_4_start", 
  [
  ],  
  "It's time, lads! Up and at them!", "close_window", 
  [
    (try_for_agents, ":agent_no"),
  	  (agent_get_troop_id, ":agent_troop_id", ":agent_no"),
  	  (ge, ":agent_troop_id", "trp_looter"),
  	  (le, ":agent_troop_id", "trp_desert_bandit"),
  	  (agent_set_team, ":agent_no", 1),
  	(try_end),      

    (get_player_agent_no, ":player_agent"),

    (assign, ":minimum_distance", 1000),
    (try_for_agents, ":agent_id_1"),
      (neq, ":agent_id_1", ":player_agent"),
      (agent_get_team, ":agent_team_1", ":agent_id_1"),
      (eq, ":agent_team_1", 0),
      (agent_get_position, pos0, ":agent_id_1"),
      
      (try_for_agents, ":agent_id_2"),
        (agent_get_team, ":agent_team_2", ":agent_id_2"),
        (eq, ":agent_team_2", 1),
        (agent_get_position, pos1, ":agent_id_2"),
        
        (get_distance_between_positions, ":dist", pos0, pos1),
        
        (le, ":dist", ":minimum_distance"),
        (assign, ":minimum_distance", ":dist"),
        (copy_position, pos2, pos1),
      (try_end),
      
      (agent_set_scripted_destination, ":agent_id_1", pos2, 0),
      (agent_set_speed_limit, ":agent_id_1", 10),
    (try_end),
  ]],

[anyone, "start", 
  [
    (is_between, "$g_talk_troop", "trp_relative_of_merchant", "trp_relative_of_merchants_end"),
    
    (try_begin),
      (check_quest_active, "qst_save_relative_of_merchant"),
      (call_script, "script_succeed_quest", "qst_save_relative_of_merchant"),      
    (try_end),  
    
    (str_store_party_name, s9, "$g_starting_town"),
    
    (assign, "$relative_of_merchant_is_found", 1),
  ],  
  "Thank you! Thank you, {sir/my lady}, for rescuing me from those fiends. Did my brother in {s9} put you onto their track?", "relative_saved_1a", 
  [
  ]],
  
[anyone|plyr, "relative_saved_1a", 
  [],  
  "Yes. I told him that I would find you. I advise you to return to your family as quickly as you can -- and be careful on the road.", "close_window", 
  [    
  ]],


  
[anyone, "start", 
  [
    (is_between, "$g_talk_troop", "trp_sea_raider_leader", "trp_bandit_leaders_end"),
    (eq,"$talk_context",tc_hero_defeated),
  ],  
  "Ay! Spare me! Spare my life! Let me go, and I'll go far away from here, and learn an honest trade, and you'll never hear of me again!", "bandit_leader_1a", 
  []],

[anyone|plyr, "bandit_leader_1a", 
  [
    (is_between, "$g_talk_troop", "trp_sea_raider_leader", "trp_bandit_leaders_end"),
  ],  
  "I'll spare your life -- but in exchange, I want information. Either you or your mates kidnapped the brother of a prominent merchant in town. Tell me where you're hiding him, and give me your word that you'll stop troubling the people of these parts, and you can go free.", "bandit_leader_1b", 
  []],





[anyone,"start", 
  [
    (eq,"$talk_context",tc_party_encounter),
    (is_between, "$g_talk_troop", "trp_sea_raider_leader", "trp_bandit_leaders_end"),
  ],
   "What do you want?", "looter_leader_1",
   []],

[anyone|plyr,"looter_leader_1", 
  [
    (store_faction_of_party, ":starting_town_faction", "$g_starting_town"),    
    (try_begin),
      (eq, ":starting_town_faction", "fac_kingdom_1"),
      (assign, ":troop_of_merchant", "trp_swadian_merchant"),
    (else_try),  
      (eq, ":starting_town_faction", "fac_kingdom_2"),
      (assign, ":troop_of_merchant", "trp_vaegir_merchant"),
    (else_try),                   
      (eq, ":starting_town_faction", "fac_kingdom_3"),
      (assign, ":troop_of_merchant", "trp_khergit_merchant"),
    (else_try),  
      (eq, ":starting_town_faction", "fac_kingdom_4"),
      (assign, ":troop_of_merchant", "trp_nord_merchant"),
    (else_try),  
      (eq, ":starting_town_faction", "fac_kingdom_5"),
      (assign, ":troop_of_merchant", "trp_rhodok_merchant"),
    (else_try),  
      (eq, ":starting_town_faction", "fac_kingdom_6"),
      (assign, ":troop_of_merchant", "trp_sarranid_merchant"),
    (try_end),
    
    (str_store_troop_name, s9, ":troop_of_merchant"),
  ],
   "I've been looking for you. Tell me where you keep your prisoners, and I'll let you go.", "looter_leader_2", 
  []],

[anyone|plyr,"looter_leader_1", 
  [],
   "Nothing. We'll leave you in peace.", "close_window", 
   [
     (assign, "$g_leave_encounter", 1),     
   ]],

[anyone,"looter_leader_2", 
  [],
   "Hah! Those prisoners are only going free if you pay their ransom. Did you bring any silver?", "looter_leader_3", 
   []],

[anyone|plyr,"looter_leader_3", 
  [],
   "No, but I brought steel.", "close_window", 
   []],



[anyone, "bandit_leader_1b", 
  [
    (is_between, "$g_talk_troop", "trp_sea_raider_leader", "trp_bandit_leaders_end"),

    (assign, ":possible_villages", 0),
    (try_for_range, ":village_no", villages_begin, villages_end),
      (party_slot_eq, ":village_no", slot_village_bound_center, "$g_starting_town"),      
      (val_add, ":possible_villages", 1),
    (try_end),
    
    (store_random_in_range, ":random_village", 0, ":possible_villages"),
    (val_add, ":random_village", 1),
      
    (try_for_range, ":village_no", villages_begin, villages_end),
      (party_slot_eq, ":village_no", slot_village_bound_center, "$g_starting_town"),      
      (val_sub, ":random_village", 1),
      (eq, ":random_village", 0),
      (assign, "$lair_neighboor_village", ":village_no"),
    (try_end), 
       
    (str_store_party_name_link, s9, "$lair_neighboor_village"),   

    (set_spawn_radius, 4),
    (spawn_around_party, "$lair_neighboor_village", "pt_looter_lair"),
    (party_set_flags, reg0, pf_always_visible, 1),
  ],  
  "Oh bless you, {sir/my lady}. Bless you. We've done the lad no harm. We've been keeping him in our hideout near {s9}. I'll describe the area nearby in detail, so there's no mistaking it...", "close_window", 
  [
    (call_script, "script_succeed_quest", "qst_learn_where_merchant_brother_is"),
    (call_script, "script_end_quest", "qst_learn_where_merchant_brother_is"),
    
    (store_faction_of_party, ":starting_town_faction", "$g_starting_town"),    
    (try_begin),
      (eq, ":starting_town_faction", "fac_kingdom_1"),
      (assign, ":troop_of_merchant", "trp_swadian_merchant"),
    (else_try),  
      (eq, ":starting_town_faction", "fac_kingdom_2"),
      (assign, ":troop_of_merchant", "trp_vaegir_merchant"),
    (else_try),                   
      (eq, ":starting_town_faction", "fac_kingdom_3"),
      (assign, ":troop_of_merchant", "trp_khergit_merchant"),
    (else_try),  
      (eq, ":starting_town_faction", "fac_kingdom_4"),
      (assign, ":troop_of_merchant", "trp_nord_merchant"),
    (else_try),  
      (eq, ":starting_town_faction", "fac_kingdom_5"),
      (assign, ":troop_of_merchant", "trp_rhodok_merchant"),
    (else_try),  
      (eq, ":starting_town_faction", "fac_kingdom_6"),
      (assign, ":troop_of_merchant", "trp_sarranid_merchant"),
    (try_end),
    (str_store_troop_name, s10, ":troop_of_merchant"),
	
    (str_store_string, s2, "str_find_the_lair_near_s9_and_free_the_brother_of_the_prominent_s10_merchant"),            
    (call_script, "script_start_quest", "qst_save_relative_of_merchant", ":troop_of_merchant"),
  ]],




  [anyone,"start", [        
    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_hero),
    (check_quest_active, "qst_rescue_prisoner"),
    (check_quest_succeeded, "qst_rescue_prisoner"),
    (quest_slot_eq, "qst_rescue_prisoner", slot_quest_giver_troop, "$g_talk_troop"),
	(quest_get_slot, ":cur_lord", "qst_rescue_prisoner", slot_quest_target_troop), 
    (call_script, "script_troop_get_family_relation_to_troop", ":cur_lord", "$g_talk_troop"),
    ],
   "{playername}, you saved him! Thank you ever so much for rescuing my {s11}.\
 Please, take this as some small repayment for your noble deed.", "rescue_prisoner_succeed_2",
   [   
     (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 8),
     (add_xp_as_reward, 2000),
     (call_script, "script_troop_add_gold", "trp_player", 1500),
     (call_script, "script_end_quest", "qst_rescue_prisoner"),
     ]],#rescuerescue               
   [anyone|plyr,"rescue_prisoner_succeed_2", [], "Always an honour to serve, {s65}.", "lord_pretalk",[]],     



  #Quest 0 - Alley talk
  [anyone|auto_proceed, "start", 
  [
    (is_between, "$g_talk_troop", "trp_swadian_merchant", "trp_startup_merchants_end"),
    (eq, "$talk_context", tc_back_alley),
    (eq, "$talked_with_merchant", 0),    
  ],  
  "{!}.", "start_up_quest_1_next", 
  []],

  [anyone, "start_up_quest_1_next", 
  [],  
  "Are you all right? Well.... I guess you're alive, at any rate. I'm not sure that we can say the same for the other fellow. That's one less thief to trouble our streets at night, although Heaven knows he won't be the last.... Anyway, maybe you can help me with something. Let's talk more inside. Out here, we don't know who's listening", "close_window", 
  [    
    (assign, "$talked_with_merchant", 1),
    (mission_disable_talk),
  ]],


  #Quest 1 - Repeating dialog sentence
  [anyone|auto_proceed, "start", 
  [
    (is_between, "$g_talk_troop", "trp_swadian_merchant", "trp_startup_merchants_end"),
    (eq, "$talk_context", tc_tavern_talk),
    
    (call_script, "script_party_count_members_with_full_health", "p_main_party"),
    (assign, ":total_party_size", reg0),

    (assign, ":continue", 0),
    (try_begin),
      (check_quest_active, "qst_collect_men"),
      (neg|check_quest_succeeded, "qst_collect_men"),        

      (le, ":total_party_size", 5),
      
      (try_begin),
        (le, ":total_party_size", 1),
        (str_store_string, s11, "str_please_sir_my_lady_go_find_some_volunteers_i_do_not_know_how_much_time_we_have"),
      (else_try),  
        (str_store_string, s11, "str_you_need_more_men_sir_my_lady"),
      (try_end),  
      (assign, ":continue", 1),
    (else_try),  
      (check_quest_active, "qst_learn_where_merchant_brother_is"),
      (neg|check_quest_succeeded, "qst_learn_where_merchant_brother_is"),              
      (str_store_string, s11, "str_do_not_waste_time_go_and_learn_where_my_brother_is"),
      (assign, ":continue", 1),
    (try_end),      
    (eq, ":continue", 1),
  ],  
  "{!}.", "start_up_quest_2_next", 
  []],
  
  [anyone, "start_up_quest_2_next", 
  [],
  "{!}{s11}", "close_window", 
  []],

  #Quest 2 - First dialog sentence
  [anyone, "start", 
  [
    (is_between, "$g_talk_troop", "trp_swadian_merchant", "trp_startup_merchants_end"),
    (eq, "$talk_context", tc_tavern_talk),
    
    (check_quest_active, "qst_collect_men"),
    (neg|check_quest_succeeded, "qst_duel_for_lady"),
    (call_script, "script_party_count_members_with_full_health", "p_main_party"),
    (ge, reg0, 6),
    
    (str_store_party_name, s9, "$current_town"),
  ],
  "Splendid work. You have hired enough men to take on the bandits. Now -- travellers entering {s9} have told us that there is a small group of robbers lurking on the outside of town. I suspect that they are all from the same band, the one that took my brother. Hunt them down and defeat them, and make them disclose the location of their lair!", "merchant_quest_2a", 
  [    
    (call_script, "script_succeed_quest", "qst_collect_men"),          
    (call_script, "script_end_quest", "qst_collect_men"),
  ]],

  #Quest 3 - First dialog sentence/Repeating dialog sentence
  [anyone, "start", 
  [
    (is_between, "$g_talk_troop", "trp_swadian_merchant", "trp_startup_merchants_end"),
    (eq, "$talk_context", tc_tavern_talk),
        
    (check_quest_active, "qst_save_relative_of_merchant"),
    (neg|check_quest_succeeded, "qst_save_relative_of_merchant"),
        
    (str_store_party_name, s9, "$current_town"),
  ],
  "So, you've found out where they hid my brother? Splendid work. I flatter myself that I'm a fine judge of character, and you look to be a {man/woman} who can get things done. Now, go out and save his unworthy hide!", "merchant_quest_3a", 
  [    
  ]],

  #Quest 3 - All succeeded - First dialog sentence
  [anyone, "start", 
  [
    (is_between, "$g_talk_troop", "trp_swadian_merchant", "trp_startup_merchants_end"),
    (eq, "$talk_context", tc_tavern_talk),
        
    (check_quest_active, "qst_save_relative_of_merchant"),
    (check_quest_succeeded, "qst_save_relative_of_merchant"),
  ],
  "Well... My brother is home safe. I'm not sure what to do with him -- maybe pack him off to a university outside Calradia. That way, if he gets knocked on the head in a street brawl, no one can say it's my fault. But that's not your problem. Here's the rest of your reward. It was well-earned.", "merchant_quest_3b", 
  [    
    (call_script, "script_finish_quest", "qst_save_relative_of_merchant", 100),
    (troop_add_gold, "trp_player", 200),
  ]],

  [anyone|plyr, "merchant_quest_3b", #was startup
  [
  ],
  "The money is most welcome, and I am glad to have been of service", "merchant_quest_4a", 
  [  
  ]],

  [anyone, "merchant_quest_4a", #was startup
  [
  ],
  "Good! Now... Are you interested in making some more?", "merchant_quest_4b", 
  [  
  ]],

  [anyone|plyr, "merchant_quest_4b",
  [
  ],
  "Possibly. What do you need?", "merchant_quest_4b1", 
  [  
  ]],
  
  
  [anyone, "merchant_quest_4b1", 
  [],
  "Remember how I told you that the bandits had an ally inside the walls? I think I know who it is -- the captain of the watch, no less. Some months ago this captain, seeing the amount of profit we merchants were making from trade across the frontiers, decided to borrow some money to sponsor a caravan. Unfortunately, like many who are new to commerce, he failed to realize that great profit only comes with great risk. So he sank all his money into the most expensive commodities, and of course his caravan was captured and looted, and he lost everything.", "merchant_quest_4b2", 
  []],
  
  [anyone, "merchant_quest_4b2", 
  [],
  "As a consequence, it seems, our captain turned to villainy to recoup his fortune. I supposed I'd do the same if, the Heavens forbid, I ever faced indebtedness and ruination. Now, any watch captain worth his salary will have a few thieves and robbers on his payroll, to inform on the rest, but our captain decides to employ these bastards wholesale. He brings them into the town, lets them do as they will, and takes a share of their take. You've heard of poachers turning gamekeepers? Well, in the unfortunate land of Calradia, sometimes gamekeepers will turn poacher. Luckily, there's are still a few brave, honest souls in the watch who've told me how he works.", "merchant_quest_4b3", 
  []],

  [anyone, "merchant_quest_4b3", 
  [
  (faction_get_slot, ":local_ruler", "$g_encountered_party_faction", slot_faction_leader),
  (str_store_troop_name, s4, ":local_ruler"),
  ],
  "Now -- here's my plan. I could bring this to the attention of {s4}, lord of the city, but that would mean an inquiry, my word against the captain's, and witnesses can be bought and evidence destroyed, or maybe the whole thing will be forgotten if the enemy comes across the border again, and all I'll get for my trouble is a knife in the ribs. In time of war, you see, a king's eye wanders far from his domain, and his subjects suffer. So I've got another idea. I've got a small group of townsfolk together, some men in my employ and some others who've lost relatives to these bandits, and we'll storm the captain's home and bring him in chains before {s4}, hopefully with a few captured bandits to explain how things stack up.", "merchant_quest_4b4", 
  []],

  [anyone, "merchant_quest_4b4", 
  [
  ],
  "All I need now is someone to lead my little army into battle -- and I can't think of anyone better than you. So, what do you say?", "merchant_quest_4b5", 
  [ 
  ]],

   [anyone|plyr, "merchant_quest_4b5", 
  [
  ],
  "How do I know that you're telling me the truth?", "merchant_quest_4b6", 
  [ 
  ]], 
  
   [anyone, "merchant_quest_4b6", 
  [
  (str_store_party_name, s4, "$g_encountered_party"),
  ],
  "Oh, well, I suppose it's possible that I found a dozen bandits who were willing to give their lives to give a passing stranger a false impression of life in old {s4}... Well, I guess you can't really know if my word is good, but I reckon you've learned by now that my money is good, and there's another 100 denars, or maybe a bit more, that's waiting for you if you'll do me this last little favor. So what do you say?", "merchant_quest_4b7", 
  [ 
  ]], 
  
  
  [anyone|plyr, "merchant_quest_4b7", 
  [
  ],
  "All right. I'll lead your men.", "merchant_quest_4b8", 
  [ 
  ]],
  
  [anyone|plyr, "merchant_quest_4b7", 
  [
  ],
  "I'm sorry. This is too much, too fast. I need time to think.", "merchant_quest_4_decline", 
  [  
  ]],

  [anyone, "merchant_quest_4b8", 
  [
  ],
  "Splendid. It's been a long time since I staked so much on a single throw of the dice, and frankly I find it exhilarating. My men are ready to move on your word. Are you ready?", "merchant_quest_4b9", 
  [  
  ]],
 
  [anyone|plyr, "merchant_quest_4b9", 
  [
  ],
  "Yes. Give them the sign.", "merchant_quest_4_accept", 
  [  
  ]],
  
  [anyone|plyr, "merchant_quest_4b9", 
  [
  ],
  "Not now. I will need to rest before I can fight again.", "merchant_quest_4_decline", 
  [  
  ]],

  [anyone, "merchant_quest_4_accept", 
  [
  ],
  "Good! Now -- strike hard, strike fast, and the captain and his henchmen won't know what hit them. May the heavens be with you!", "close_window", 
  [            
    (assign, "$current_startup_quest_phase", 3),
    (jump_to_menu, "mnu_start_phase_3"),
    (finish_mission),
  ]],
 
  [anyone, "merchant_quest_4_decline", #was startup
  [
  ],
  "Right. I can keep my men standing by. If you let this go too long, then I suppose that I shall have to finish this affair without you, but I would be most pleased if you could be part of it as well. For now, take what time you need.", "close_window", 
  []],
  
  
  
  #QUEST 2 - Learning where prominent's brother is.
  [anyone|plyr, "merchant_quest_2a", 
  [
  ],
  "Very well. I shall hunt for bandits.", "close_window", 
  [  
    (str_store_party_name, s9, "$current_town"),
    (str_store_string, s2, "str_start_up_quest_message_2"),
    (call_script, "script_start_quest", "qst_learn_where_merchant_brother_is", "$g_talk_troop"),    
        
    (set_spawn_radius, 2),
    (spawn_around_party, "$current_town", "pt_leaded_looters"),
    (assign, ":spawned_bandits", reg0),    
    
    (party_get_position, pos0, "$current_town"),    
    (party_set_ai_behavior, ":spawned_bandits", ai_bhvr_patrol_location),
    (party_set_ai_patrol_radius, ":spawned_bandits", 3),
    (party_set_ai_target_position, ":spawned_bandits", pos0),                                                         
  ]],
  
  [anyone|plyr, "merchant_quest_2a", 
  [
  ],
  "Why don't you come with us?", "merchant_quest_2a_whynotcome", 
  [  
  ]],
  
  [anyone, "merchant_quest_2a_whynotcome", 
  [
  ],
  "Because I'm paying you to go take care of it. That's the short answer. The long answer is that I've got some leads to follow up here in town, and I have just as much chance of getting knocked on my head as you, if that's what you're asking. But I respect your question. Now, what do you say?", "merchant_quest_2a", 
  [  
  ]],
  
  
  [anyone|plyr, "merchant_quest_2a", 
  [
  ],
  "I cannot deal with this matter at this time.", "close_window", 
  [  
  ]],

  #Quest 3 - Saving merchant's brother.
  [anyone|plyr, "merchant_quest_3a", 
  [
  ],
  "Very well. I go now to attack the bandits in their lair, and find your brother.", "close_window", 
  [    
    #no need to below three lines anymore, this quest is auto starting after player learn where bandits are hiding merchant's brother.
    #(str_store_party_name, s9, "$lair_neighboor_village"),    
    #(str_store_string, s2, "str_start_up_quest_message_3"),
    #(call_script, "script_start_quest", "qst_save_relative_of_merchant", "$g_talk_troop"),    
  ]],


  
  
  
  [anyone|plyr, "merchant_quest_3a", 
  [
  ],
  "I cannot deal with this matter at this time.", "close_window", 
  [  
    #think about placing end_quest here. Because it is auto-starting. If player do not want this quest he/she should have a way to avoid it.
  ]],


  [anyone, "start", 
  [
    (is_between, "$g_talk_troop", "trp_swadian_merchant", "trp_startup_merchants_end"),
    
    (this_or_next|eq, "$talk_context", tc_tavern_talk),
    (neq, "$dialog_with_merchant_ended", 0), 
    
    (assign, ":continue", 0),
    (try_begin),
      (neg|check_quest_succeeded, "qst_collect_men"),
      (neg|check_quest_active, "qst_collect_men"),
      (assign, ":continue", 1),
    (else_try),  
      (neg|check_quest_active, "qst_collect_men"),
      (neg|check_quest_succeeded, "qst_learn_where_merchant_brother_is"),
      (neg|check_quest_active, "qst_learn_where_merchant_brother_is"),
      (assign, ":continue", 1),
    (else_try),  
      (neg|check_quest_active, "qst_collect_men"),
      (neg|check_quest_active, "qst_learn_where_merchant_brother_is"),
      (neg|check_quest_succeeded, "qst_save_relative_of_merchant"),
      (neg|check_quest_active, "qst_save_relative_of_merchant"),
      (assign, ":continue", 1),
    (try_end),  
    
    (eq, ":continue", 1),
  ],
  "You may do as you wish, {sir/my lady}, but I am disappointed. You would do well to reconsider. I am a rich men, and would show you my gratitude in coin.", "merchant_quest_persuasion",
  [        
  ]],

  [anyone|auto_proceed, "start", 
  [
    (is_between, "$g_talk_troop", "trp_swadian_merchant", "trp_startup_merchants_end"),
    
    (this_or_next|eq, "$talk_context", tc_tavern_talk),
    (neq, "$dialog_with_merchant_ended", 0), 

    (check_quest_finished, "qst_save_relative_of_merchant"),
    (neg|check_quest_succeeded, "qst_save_town_from_bandits"),
    (neg|check_quest_active, "qst_save_town_from_bandits"),
  ],
  "{!}.", "merchant_quest_4b4",
  [        
  ]],

  [anyone|plyr, "merchant_quest_persuasion", 
  [
    (neg|check_quest_finished, "qst_collect_men"),
    (neg|check_quest_active, "qst_collect_men"),
  ],
  "You make a persuasive case. I will help you.", "merchant_quest_1_prologue_3", 
  [  
  ]],

  [anyone|plyr, "merchant_quest_persuasion", 
  [
    (check_quest_finished, "qst_collect_men"),
    (neg|check_quest_finished, "qst_learn_where_merchant_brother_is"),
    (neg|check_quest_active, "qst_learn_where_merchant_brother_is"),
  ],
  "You make a persuasive case. I will help you.", "merchant_quest_2", 
  [  
  ]],

  [anyone|plyr, "merchant_quest_persuasion", 
  [
    (check_quest_finished, "qst_collect_men"),
    (check_quest_finished, "qst_learn_where_merchant_brother_is"),
    (neg|check_quest_finished, "qst_save_relative_of_merchant"),
    (neg|check_quest_active, "qst_save_relative_of_merchant"),
  ],
  "You make a persuasive case. I will help you.", "merchant_quest_3", 
  [  
  ]],

  [anyone|plyr, "merchant_quest_persuasion", 
  [
    (check_quest_finished, "qst_collect_men"),
    (check_quest_finished, "qst_learn_where_merchant_brother_is"),
    (check_quest_finished, "qst_save_relative_of_merchant"),
    (neg|check_quest_finished, "qst_save_town_from_bandits"),
    (neg|check_quest_active, "qst_save_town_from_bandits"),
  ],
  "You make a persuasive case. I will help you.", "merchant_quest_4b8", 
  [  
  ]],

  [anyone|plyr, "merchant_quest_persuasion", 
  [
  ],
  "As I say, I have more important business elsewhere.", "close_window", 
  [  
  ]],
    
  [anyone, "merchant_quest_2", 
  [
  ],
  "Now -- go find and defeat that group of bandits.", "merchant_quest_2a", 
  [  
  ]],

  [anyone, "merchant_quest_3", 
  [
  ],
  "Now -- go attack that bandit hideout, get my brother back, and show those brigands what happens to those who threaten my household.", "merchant_quest_3a", 
  [  
  ]],
  
  [anyone, "start", 
  [
    (is_between, "$g_talk_troop", "trp_relative_of_merchant", "trp_relative_of_merchant"),
  ],
  "Oh -- thank the heavens... Thank the heavens... Am I safe?", "close_window",
  []],


  [anyone,"start", 
  [
    (is_between, "$g_talk_troop", "trp_swadian_merchant", "trp_startup_merchants_end"),
    (eq, "$g_do_one_more_meeting_with_merchant", 1),
    (faction_get_slot, ":faction_leader", "$g_encountered_party_faction", slot_faction_leader),
    (str_store_troop_name, s5, ":faction_leader"),
  ], 
  "Ah... {playername}. Things didn't go quite so well as I had hoped. {s5} couldn't quite find it in him to overlook my little breach of the peace. Oh, he's grateful enough that I got rid of his crooked captain -- a guard who'll let in bandits will let in an enemy army, if the price is right -- but he can't exactly have me running around here as a lasting reminder of his failure to take care of things himself.", "merchant_closing_statement_2",
  []],  
  
  [anyone|plyr,"merchant_closing_statement_2", 
  [],   
  "That hardly seems fair...", "merchant_closing_statement_3",
  []],    

  [anyone,"merchant_closing_statement_3", 
  [],   
  "Fair? This is Calradia, {my boy/my lady}! Kings do what they will, and the rest of us do as they must. He didn't string me up, and instead gave me time to sell my properties -- even put in a word with the other merchants that they best pay me a fair price, too. That's gracious enough, as kings go -- but he's a weak king, as they all are here, and weak kings must always look to their authority first, and justice second. I suppose I'd do the same, in his shoes.", "merchant_closing_statement_4",
  []],    
  
  [anyone,"merchant_closing_statement_4", 
  [],   
  "Anyway, I wouldn't go rubbing your part in this affair in {s5}'s face -- but he's taken note of you, and decided that you're not worth hanging, and that's something to which I'll raise a glass any day of the week. He might even have work for you, further down the road. Or, you can sell your sword to one of his competitors. Anyway, I hope you've learned a bit about what it will take to stay alive in this troubled land, and I suspect that the money you've earned won't go to waste. Good luck.", "close_window",
  [
    (assign, "$g_do_one_more_meeting_with_merchant", 2),
  ]], 
  
  [anyone|auto_proceed, "start",
   [
    (is_between, "$g_talk_troop", "trp_swadian_merchant", "trp_startup_merchants_end"),
    (check_quest_finished, "qst_save_town_from_bandits"),
    (eq, "$g_do_one_more_meeting_with_merchant", 2),
   ],
   "{!}.", "merchant_quests_last_word",
   []],
  
  [anyone,"merchant_quests_last_word", 
  [
  ],   
  "I am preparing to leave town in a short while. It's been an honor to know you. Good luck.", "close_window",
  [
  ]], 
  
  
  
  

  
  
  [anyone|plyr, "member_intel_liaison", [],
   "What have you discovered?", "member_intel_liaison_results", []],


  [anyone, "start", [(is_between, "$g_talk_troop", companions_begin, companions_end),
                     (eq, "$talk_context", tc_tavern_talk),
                     (troop_slot_eq, "$g_talk_troop", slot_troop_current_mission, npc_mission_gather_intel)],
   "Greetings, stranger.", "member_intel_liaison", []],

  [anyone|plyr, "member_intel_liaison", [
],
   "What have you discovered?", "member_intel_liaison_results", []],

  [anyone|plyr, "member_intel_liaison", [],
   "It's time to pull you out. Let's leave town separately, but join me soon after", "close_window", [
   (assign, "$npc_to_rejoin_party", "$g_talk_troop"),
   ]],
   
  [anyone|plyr, "member_intel_liaison", [],
   "You're doing good work. Stay here for a little longer", "close_window", []],


   
  [anyone, "member_intel_liaison_results", [
		(store_faction_of_party, ":town_faction", "$g_encountered_party"),
		(call_script, "script_update_faction_political_notes", ":town_faction"),
		(assign, ":instability_index", reg0),
		(val_add, ":instability_index", reg0),
		(val_add, ":instability_index", reg1),
		
		(try_for_range, ":lord", active_npcs_begin, active_npcs_end),
			(troop_slot_eq, ":lord", slot_troop_occupation, slto_kingdom_hero),
			(store_faction_of_troop, ":lord_faction", ":lord"),
			(eq, ":lord_faction", ":town_faction"),
			(call_script, "script_update_troop_political_notes", ":lord"),
		(try_end),
		
		(str_store_faction_name, s12, ":town_faction"),
		(try_begin),
			(gt, ":instability_index", 60),
			(str_store_string, s11, "str_the_s12_is_a_labyrinth_of_rivalries_and_grudges_lords_ignore_their_lieges_summons_and_many_are_ripe_to_defect"),
		(else_try),	
			(is_between, ":instability_index", 40, 60),
			(str_store_string, s11, "str_the_s12_is_shaky_many_lords_do_not_cooperate_with_each_other_and_some_might_be_tempted_to_defect_to_a_liege_that_they_consider_more_worthy"),
		(else_try),	
			(is_between, ":instability_index", 20, 40),
			(str_store_string, s11, "str_the_s12_is_fairly_solid_some_lords_bear_enmities_for_each_other_but_they_tend_to_stand_together_against_outside_enemies"),
		(else_try),	
			(lt, ":instability_index", 20),
			(str_store_string, s11, "str_the_s12_is_a_rock_of_stability_politically_speaking_whatever_the_lords_may_think_of_each_other_they_fight_as_one_against_the_common_foe"),
		(try_end),
  
],
   "{s11} I notice that you have been keeping some notes about individual lords. I have annotated those with my findings.", "member_intel_liaison", []],
		 

		 
  [anyone,"member_fief_grant_1", [
        ], "Which fief did you have in mind?", "member_fief_grant_2",[]],
		 
  [anyone|plyr|repeat_for_parties,"member_fief_grant_2", [
		(store_repeat_object, ":center"),
        (is_between, ":center", centers_begin, centers_end),
		(neq, ":center", "$g_player_court"),
		(store_faction_of_party, ":center_faction", ":center"),
		(eq, ":center_faction", "fac_player_supporters_faction"),
		(neg|party_slot_ge, ":center", slot_town_lord, active_npcs_begin), #ie, owned by player or unassigned
		(str_store_party_name, s11, ":center"),
		
        ], "{s11}", "member_fief_grant_3",[
		(store_repeat_object, "$temp"),
		]],
		 
  [anyone|plyr, "member_fief_grant_2", [
        ], "Never mind -- there is no fief I can offer.", "do_member_trade",[
		]],

		
  [anyone,"member_fief_grant_3", [
        ], "{s5}", "close_window",[
		(call_script, "script_npc_morale", "$g_talk_troop"),
		(assign, ":npc_morale", reg0),
		
		(remove_member_from_party, "$g_talk_troop", "p_main_party"),
		
		
		(try_begin),
          (neg|troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_hero),
          
          (assign, ":banner_offset", banners_end_offset),
          (val_sub, ":banner_offset", 1),
          (val_sub, ":banner_offset", "$g_companions_banner_id"),                            
          (store_add, ":banner_id", banner_scene_props_begin, ":banner_offset"),                    
          (troop_set_slot, "$g_talk_troop", slot_troop_banner_scene_prop, ":banner_id"),          
          (val_add, "$g_companions_banner_id", 1), 
		  
          (troop_set_slot, "$g_talk_troop", slot_troop_occupation, slto_kingdom_hero),
		(try_end),
				
		(troop_set_faction, "$g_talk_troop", "fac_player_supporters_faction"),
		(call_script, "script_give_center_to_lord", "$temp", "$g_talk_troop", 0),
		(try_begin),
			(faction_slot_eq, "$players_kingdom", slot_faction_political_issue, "$temp"),
			(faction_set_slot, "$players_kingdom", slot_faction_political_issue, -1),
		(try_end),
   
		(try_begin),
		  (troop_slot_eq, "$g_talk_troop", slot_troop_original_faction, 0),
		  (party_get_slot, ":fief_culture", "$temp", slot_center_original_faction),
		  (troop_set_slot, "$g_talk_troop", slot_troop_original_faction, ":fief_culture"),
		(try_end),

		(store_character_level, ":renown", "$g_talk_troop"),
		(val_mul, ":renown", 15),
		(val_max, ":renown", 200),
		(troop_set_slot, "$g_talk_troop", slot_troop_renown, ":renown"),
		
		(troop_set_slot, "$g_talk_troop", slot_troop_wealth, 2500), #represents accumulated loot
#		(troop_set_slot, "$g_talk_troop", slot_troop_readiness_to_join_army, 100), 
#		(troop_set_slot, "$g_talk_troop", slot_troop_readiness_to_follow_orders, 100), 
		
		(str_store_troop_name_plural, s12, "$g_talk_troop"),
		(troop_get_type, ":is_female", "$g_talk_troop"),
		(try_begin),
			(eq, "$g_talk_troop", "trp_npc10"),
			(str_store_string, s14, "str_tribune_s12"),
		(else_try),
			(eq, ":is_female", 1),
			(str_store_string, s14, "str_lady_s12"),
		(else_try),	
			(str_store_string, s14, "str_lord_s12"),
		(try_end),
		(troop_set_name, "$g_talk_troop", s14),
		(unlock_achievement, ACHIEVEMENT_I_DUB_THEE),
		
                (call_script, "script_check_concilio_calradi_achievement"),
		
		(try_begin),
			(troop_add_item, "$g_talk_troop", "itm_saddle_horse", 0),
			(troop_add_item, "$g_talk_troop", "itm_courser", 0),
			(troop_add_item, "$g_talk_troop", "itm_courtly_outfit",0),
			(troop_add_item, "$g_talk_troop", "itm_heraldic_mail_with_tabard",0),
			(troop_add_item, "$g_talk_troop", "itm_red_gambeson",0),
			(troop_add_item, "$g_talk_troop", "itm_sword_medieval_c",0),
			(troop_add_item, "$g_talk_troop", "itm_tab_shield_kite_cav_b",0),
			(troop_add_item, "$g_talk_troop", "itm_light_lance",0),
		(try_end),
		(troop_equip_items, "$g_talk_troop"),

		(store_div, ":relation_boost", ":npc_morale", 3),
#		(val_add, ":relation_boost", 10),
		(call_script, "script_troop_change_relation_with_troop", "$g_talk_troop", "trp_player", ":relation_boost"), 
		
		(str_store_party_name, s17, "$temp"),
		(store_sub, ":npc_no", "$g_talk_troop", "trp_npc1"),
		(store_add, ":speech", "str_npc1_fief_acceptance", ":npc_no"),
#        (troop_get_slot, ":speech", "$g_talk_troop", slot_troop_fief_acceptance_string),
        (str_store_string, s5, ":speech"),  		
		]],
		

		 
  [anyone, "start", [(is_between, "$g_talk_troop", companions_begin, companions_end),
                     (this_or_next|eq, "$talk_context", tc_tavern_talk),
						(eq, "$talk_context", tc_court_talk),
                     (main_party_has_troop, "$g_talk_troop")],
   "Let's leave whenever you are ready.", "close_window", []],

  [anyone, "start", [(is_between, "$g_talk_troop", companions_begin, companions_end),
                     (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, 0),
                     (troop_slot_eq, "$g_talk_troop", slot_troop_turned_down_twice, 1),
   ],
   "Please do not waste any more of my time today, {sir/madame}. Perhaps we shall meet again in our travels.", "close_window", [
       ]],


  [anyone, "start", [(is_between, "$g_talk_troop", companions_begin, companions_end),
                     (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, 0),
                     (eq, "$g_talk_troop_met", 0),
                     (troop_get_slot, ":intro", "$g_talk_troop", slot_troop_intro),
                     (str_store_string, 5, ":intro"),
                     (str_store_party_name, 20, "$g_encountered_party"),
   ],
   "{s5}", "companion_recruit_intro_response", [
                    (troop_set_slot, "$g_talk_troop", slot_troop_first_encountered, "$g_encountered_party"),
       ]],


  [anyone|plyr, "companion_recruit_intro_response", [
                     (troop_get_slot, ":intro_response", "$g_talk_troop", slot_troop_intro_response_1),
                     (str_store_string, 6, ":intro_response")
      ], "{s6}", "companion_recruit_backstory_a", []],

  [anyone|plyr, "companion_recruit_intro_response", [
                     (troop_get_slot, ":intro_response", "$g_talk_troop", slot_troop_intro_response_2),
                     (str_store_string, 7, ":intro_response")
      ],  "{s7}", "close_window", [
          ]],

  [anyone, "companion_recruit_backstory_a", [(troop_get_slot, ":backstory_a", "$g_talk_troop", slot_troop_backstory_a),
                     (str_store_string, 5, ":backstory_a"),
                     (str_store_string, 19, "str_here_plus_space"),
                     (str_store_party_name, 20, "$g_encountered_party"),
   ],
   "{s5}", "companion_recruit_backstory_b", []],

  [anyone, "companion_recruit_backstory_b", [(troop_get_slot, ":backstory_b", "$g_talk_troop", slot_troop_backstory_b),
                     (str_store_string, 5, ":backstory_b"),
                     (str_store_party_name, 20, "$g_encountered_party"),
   ],
   "{s5}", "companion_recruit_backstory_c", []],

  [anyone, "companion_recruit_backstory_c", [(troop_get_slot, ":backstory_c", "$g_talk_troop", slot_troop_backstory_c),
                     (str_store_string, 5, ":backstory_c"),
   ],
   "{s5}", "companion_recruit_backstory_response", []],

  [anyone|plyr, "companion_recruit_backstory_response", [
                     (troop_get_slot, ":backstory_response", "$g_talk_troop", slot_troop_backstory_response_1),
                     (str_store_string, 6, ":backstory_response")
      ], "{s6}", "companion_recruit_signup", []],

  [anyone|plyr, "companion_recruit_backstory_response", [
                     (troop_get_slot, ":backstory_response", "$g_talk_troop", slot_troop_backstory_response_2),
                     (str_store_string, 7, ":backstory_response")
      ],  "{s7}", "close_window", [
          ]],

  [anyone, "companion_recruit_signup", [(troop_get_slot, ":signup", "$g_talk_troop", slot_troop_signup),
                     (str_store_string, 5, ":signup"),
                     (str_store_party_name, 20, "$g_encountered_party"),

   ],
   "{s5}", "companion_recruit_signup_b", []],

  [anyone, "companion_recruit_signup_b", [
      (troop_get_slot, ":signup", "$g_talk_troop", slot_troop_signup_2),
      (troop_get_slot, reg3, "$g_talk_troop", slot_troop_payment_request),#

      (str_store_string, 5, ":signup"),
      (str_store_party_name, 20, "$g_encountered_party"),

   ],
   "{s5}", "companion_recruit_signup_response", []],

  [anyone|plyr, "companion_recruit_signup_response", [(neg|hero_can_join, "p_main_party"),], "Unfortunately, I can't take on any more hands in my party right now.", "close_window", [
     ]],

  [anyone|plyr, "companion_recruit_signup_response", [
                    (hero_can_join, "p_main_party"),
                    (troop_get_slot, ":signup_response", "$g_talk_troop", slot_troop_signup_response_1),
                    (str_store_string, 6, ":signup_response")
      ], "{s6}", "companion_recruit_payment", []],

  [anyone|plyr, "companion_recruit_signup_response", [
                    (hero_can_join, "p_main_party"),
                     (troop_get_slot, ":signup_response", "$g_talk_troop", slot_troop_signup_response_2),
                     (str_store_string, 7, ":signup_response")
      ],  "{s7}", "close_window", [
          ]],

  [anyone|auto_proceed, "companion_recruit_payment", [
      (troop_slot_eq, "$g_talk_troop", slot_troop_payment_request, 0),
   ],
   ".", "companion_recruit_signup_confirm", []],
  
  [anyone, "companion_recruit_payment", [
      (store_sub, ":npc_offset", "$g_talk_troop", "trp_npc1"),
      (store_add, ":dialog_line", "str_npc1_payment", ":npc_offset"),
      (str_store_string, s5, ":dialog_line"),
      (troop_get_slot, reg3, "$g_talk_troop", slot_troop_payment_request),
      (str_store_party_name, s20, "$g_encountered_party"),
   ],
   "{s5}", "companion_recruit_payment_response", []],

  [anyone|plyr, "companion_recruit_payment_response", [
                    (hero_can_join, "p_main_party"),
                    (troop_get_slot, ":amount_requested", "$g_talk_troop", slot_troop_payment_request),#
                    (store_troop_gold, ":gold", "trp_player"),#
                    (ge, ":gold", ":amount_requested"),#
                    (assign, reg3, ":amount_requested"),
                    (store_sub, ":npc_offset", "$g_talk_troop", "trp_npc1"),
                    (store_add, ":dialog_line", "str_npc1_payment_response", ":npc_offset"),
                    (str_store_string, s6, ":dialog_line"),
      ], "{s6}", "companion_recruit_signup_confirm", [
                    (troop_get_slot, ":amount_requested", "$g_talk_troop", slot_troop_payment_request),#
                    (gt, ":amount_requested", 0),#
                    (troop_remove_gold, "trp_player", ":amount_requested"),  #                  
                    (troop_set_slot, "$g_talk_troop", slot_troop_payment_request, 0),#
          ]],

  [anyone|plyr, "companion_recruit_payment_response", [
                     (troop_get_slot, ":signup_response", "$g_talk_troop", slot_troop_signup_response_2),
                     (str_store_string, s7, ":signup_response")
      ],  "Sorry. I can't afford that at the moment.", "close_window", [
          ]],

  [anyone, "start", [(is_between, "$g_talk_troop", companions_begin, companions_end),
                     (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, 0),
                     (troop_slot_eq, "$g_talk_troop", slot_troop_met_previously, 1),
                     (troop_slot_eq, "$g_talk_troop", slot_troop_playerparty_history, 0),

    ],
   "We meet again.", "companion_recruit_meet_again", [
                     (troop_set_slot, "$g_talk_troop", slot_troop_turned_down_twice, 1),
       ]],

  [anyone|plyr, "companion_recruit_meet_again", [
      ], "So... What have you been doing since our last encounter?", "companion_recruit_backstory_delayed", []],

  [anyone|plyr, "companion_recruit_meet_again", [
      ],  "Good day to you.", "close_window", [
          ]],


  [anyone, "start", [(is_between, "$g_talk_troop", companions_begin, companions_end),
                     (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, 0),
                     (troop_slot_eq, "$g_talk_troop", slot_troop_met_previously, 0),
                     (troop_slot_eq, "$g_talk_troop", slot_troop_playerparty_history, 0),
   ],
   "Yes?", "companion_recruit_secondchance", [
                     (troop_set_slot, "$g_talk_troop", slot_troop_turned_down_twice, 1),
       ]],


  [anyone|plyr, "companion_recruit_secondchance", [
      ], "My apologies if I was rude, earlier. What was your story again?", "companion_recruit_backstory_b", []],

  [anyone|plyr, "companion_recruit_secondchance", [
      ],  "Never mind.", "close_window", [
          ]],

  [anyone, "companion_recruit_backstory_delayed",
   [(troop_get_slot, ":backstory_delayed", "$g_talk_troop", slot_troop_backstory_delayed),
     (str_store_string, 5, ":backstory_delayed")
   ],
   "{s5}", "companion_recruit_backstory_delayed_response", []],

  [anyone|plyr, "companion_recruit_backstory_delayed_response", [
      ], "I might be able to use you in my company.", "companion_recruit_signup_b", [
          ]],

  [anyone|plyr, "companion_recruit_backstory_delayed_response", [
      ],  "I'll let you know if I hear of anything.", "close_window", [
          ]],

  [anyone, "companion_recruit_signup_confirm", [], "Good! Give me a few moments to prepare and I'll be ready to move.", "close_window",
   [(call_script, "script_recruit_troop_as_companion", "$g_talk_troop")]],



### Rehire dialogues
  [anyone, "start", [(is_between, "$g_talk_troop", companions_begin, companions_end),
					 (neg|troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_hero),
                     (troop_slot_eq, "$g_talk_troop", slot_troop_playerparty_history, pp_history_indeterminate),
					 
                     (troop_get_slot, ":prison_center", "$g_talk_troop", slot_troop_prisoner_of_party),
                     (lt, ":prison_center", centers_begin),
   ],
   "My offer to rejoin you still stands, if you'll have me.", "companion_rehire", []],

### If the companion and the player were separated in battle
  [anyone, "start", 
  [
    (is_between, "$g_talk_troop", companions_begin, companions_end),
	(neg|troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_hero),
    (troop_slot_eq, "$g_talk_troop", slot_troop_playerparty_history, pp_history_scattered),
        
    (this_or_next|eq, "$talk_context", tc_hero_freed),
    (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
    
    (neq, "$talk_context", tc_prison_break),
					 
    (assign, ":battle_fate", "str_battle_fate_1"),
    (store_random_in_range, ":fate_roll", 0, 5),
    (val_add, ":battle_fate", ":fate_roll"),
    (str_store_string, s6, ":battle_fate"),
    (troop_get_slot, ":honorific", "$g_talk_troop", slot_troop_honorific),
    (str_store_string, s5, ":honorific"),
  ],
  "It is good to see you alive, {s5}! {s6}, and I did not know whether you had been captured, or slain, or got away. I've been roaming around since then, looking for you. Shall I get my gear together and rejoin your company?","companion_rehire", 
  [
    (troop_set_slot, "$g_talk_troop", slot_troop_playerparty_history, pp_history_indeterminate),
    (troop_set_slot, "$g_talk_troop", slot_troop_prisoner_of_party, -1),
  ]],

  [anyone|plyr,"start", 
  [
    (is_between, "$g_talk_troop", companions_begin, companions_end),
	(neg|troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_hero),
    (troop_slot_eq, "$g_talk_troop", slot_troop_playerparty_history, pp_history_scattered),
                     
    (troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
    
    (neq, "$talk_context", tc_prison_break),
					 
    (assign, ":battle_fate", "str_battle_fate_1"),
    (store_random_in_range, ":fate_roll", 0, 5),
    (val_add, ":battle_fate", ":fate_roll"),
    (str_store_string, s6, ":battle_fate"),
    (troop_get_slot, ":honorific", "$g_talk_troop", slot_troop_honorific),
    (str_store_string, s5, ":honorific"),
  ],
  "I've come to break you out of here.", "companion_prison_break_chains",[]],

  [anyone,"companion_prison_break_chains", [],   
  "Thank the heavens you came! However, I'm not going anywhere with these chains on my legs. You'll need to get the key away from the guard somehow.", "close_window",[]],			




### If the player and the companion parted on bad terms
  [anyone, "start", [(is_between, "$g_talk_troop", companions_begin, companions_end),
                     (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, 0),
                     (troop_slot_eq, "$g_talk_troop", slot_troop_turned_down_twice, 0),
                     (troop_slot_eq, "$g_talk_troop", slot_troop_playerparty_history, pp_history_quit),
                     (troop_get_slot, ":speech", "$g_talk_troop", slot_troop_rehire_speech),
                     (str_store_string, 5, ":speech"),
   ],
   "{s5}", "companion_rehire", [
                     (troop_set_slot, "$g_talk_troop", slot_troop_playerparty_history, pp_history_indeterminate),
      ]],


###If the player and the companion parted on good terms
  [anyone, "start", [(is_between, "$g_talk_troop", companions_begin, companions_end),
                     (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, 0),
                     (troop_slot_eq, "$g_talk_troop", slot_troop_playerparty_history, pp_history_dismissed),
                     (troop_get_slot, ":honorific", "$g_talk_troop", slot_troop_honorific),
                     (str_store_string, 21, ":honorific"),
                     (troop_get_slot, ":speech", "$g_talk_troop", slot_troop_backstory_delayed),
                     (str_store_string, 5, ":speech"),
   ],
   "It is good to see you, {s21}! To tell you the truth, I had hoped to run into you.",
   "companion_was_dismissed", [
                     (troop_set_slot, "$g_talk_troop", slot_troop_playerparty_history, pp_history_indeterminate),
      ]],

  [anyone, "companion_was_dismissed", [
					 (neg|troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_hero),
                      (troop_get_slot, ":speech", "$g_talk_troop", slot_troop_backstory_delayed),
                     (str_store_string, 5, ":speech"),
   ],
   "{s5}. Would you want me to rejoin your company?", "companion_rehire", [
      ]],


  [anyone|plyr, "companion_rehire", 
  [
    (hero_can_join, "p_main_party"),
  ], "Welcome back, my friend!", "companion_recruit_signup_confirm", []],

  [anyone|plyr, "companion_rehire", 
  [],  
  "Sorry, I can't take on anyone else right now.", "companion_rehire_refused", []],

  [anyone, "companion_rehire_refused", [], "Well... Look me up if you change your mind, eh?", "close_window",
   [
     (troop_get_slot, ":current_town_no", "$g_talk_troop", slot_troop_cur_center),  
   
     (try_begin),
       (neg|is_between, ":current_town_no", towns_begin, towns_end),
              
       (store_random_in_range, ":town_no", towns_begin, towns_end),       
       (troop_set_slot, "$g_talk_troop", slot_troop_cur_center, ":town_no"),  
     
       (try_begin),
         (ge, "$cheat_mode", 1),
         (assign, reg1, ":current_town_no"),
         (str_store_party_name, s7, ":town_no"),
         (display_message, "@{!}current town was {reg1}, now moved to {s7}"),
       (try_end),
     (try_end),  
   ]],

   #Default dialog added - for rehire
  [anyone, "start", [
  (is_between, "$g_talk_troop", companions_begin, companions_end),  
  (neg|troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_hero),
  
  (troop_get_slot, ":prison_center", "$g_talk_troop", slot_troop_prisoner_of_party),
  (lt, ":prison_center", centers_begin),  
  ], "So... Do you want me back yet?", "companion_rehire",
   []],
#Ministerial issues
   



   [anyone, "minister_issues",
   [
    (check_quest_active, "qst_consult_with_minister"),
	(eq, "$g_minister_notification_quest", "qst_resolve_dispute"),

    (setup_quest_text,"qst_resolve_dispute"),
	
	(quest_get_slot, ":lord_1", "qst_resolve_dispute", slot_quest_target_troop),
	(str_store_troop_name, s11, ":lord_1"),
	
	(quest_get_slot, ":lord_2", "qst_resolve_dispute", slot_quest_object_troop),
	(str_store_troop_name, s12, ":lord_2"),	

	(str_store_string, s2, "str_resolve_the_dispute_between_s11_and_s12"),
	(call_script, "script_start_quest", "qst_resolve_dispute", -1),
	(quest_set_slot, "qst_resolve_dispute", slot_quest_expiration_days, 30),
	(quest_set_slot, "qst_resolve_dispute", slot_quest_giver_troop, "$g_player_minister"),
	(quest_set_slot, "qst_resolve_dispute", slot_quest_target_state, 0),
	(quest_set_slot, "qst_resolve_dispute", slot_quest_object_state, 0),
	
	(quest_get_slot, ":lord_1", "qst_resolve_dispute", slot_quest_target_troop), #this block just to check if the slots work
	(str_store_troop_name, s11, ":lord_1"),
	(quest_get_slot, ":lord_2", "qst_resolve_dispute", slot_quest_object_troop),
	(str_store_troop_name, s12, ":lord_2"),	
	
     ],
   "There is a matter which needs your attention. The quarrel between {s11} and {s12} has esclatated to a point where it has become unseemly. If you do intervene, you risk offending one of the lords. However, if you do nothing, you risk appearing weak. Such are the burdens of kingship, {sire/my lady}.", "minister_pretalk",
   [
   (call_script, "script_end_quest", "qst_consult_with_minister"),
   ]],
   
   [anyone, "minister_issues",
   [
    (assign, "$g_center_taken_by_player_faction", -1),
    (try_for_range, ":center_no", centers_begin, centers_end),
      (eq, "$g_center_taken_by_player_faction", -1),
      (store_faction_of_party, ":center_faction", ":center_no"),
      (eq, ":center_faction", "fac_player_supporters_faction"),
      (neg|party_slot_ge, ":center_no", slot_town_lord, 0),
      (assign, "$g_center_taken_by_player_faction", ":center_no"),
    (try_end),
    (is_between, "$g_center_taken_by_player_faction", centers_begin, centers_end),
    (str_store_party_name, s1, "$g_center_taken_by_player_faction"),
     ],
   "{s1} currently does not have a lord. You may wish to keep it this way, as lords will sometimes gravitate towards lieges who have land to offer, but for the time being, no one is collecting any of its rents.", "minister_talk",
   []],
   
   [anyone, "minister_issues",
   [
   (neg|is_between, "$g_player_minister", active_npcs_begin, kingdom_ladies_end),
   ],
   "At this point, there are no particularly urgent matters which need your attention. I should point out though, sire, that I am not very skilled in the ways of politics, and that I am anxious to return to private life. If you wish to issue any but the most basic directives, I suggest appointing a trusted companion in my stead. In the meantime, is there anything you wish done?", "minister_talk",[]],

   [anyone, "minister_issues",
   [
   (eq, 1, 0),
   ],
   "{!}[Should not appear - there to prevent error related to center_captured_lord_advice]", "center_captured_lord_advice",[]],
   
   [anyone, "minister_issues",
   [
   (lt, "$player_right_to_rule", 30),
   ],
   "If I may offer you a world of advice, my {lord/lady}, it seems that your right to rule as an independent monarch is not sufficiently recognized, and this may bring us problems further down the road. It may be advisable to find another kingdom with whom you have shared interests and seek its recognition, to establish yourself as an equal with Calradia's other kings.", "minister_talk",[]],

   
   [anyone, "minister_issues",
   [],
   "At this point, there are no particularly urgent matters which need your attention. Is there anything you wish done?", "minister_talk",[]],

   [anyone, "minister_pretalk",
   [],
   "Is there anything you wish done?", "minister_talk", 
   []],
   
  [anyone|plyr,"minister_talk",
   [
   (is_between, "$g_player_minister", active_npcs_begin, kingdom_ladies_end),
   ],
   "Do you have any ideas to strengthen our kingdom's unity?", "combined_political_quests",[
   (call_script, "script_get_political_quest", "$g_talk_troop"),
   (assign, "$political_quest_found", reg0),
   (assign, "$political_quest_target_troop", reg1),
   (assign, "$political_quest_object_troop", reg2),
   
 ]],
   
   
  [anyone|plyr,"minister_talk",
   [
   (assign, "$political_quest_to_cancel", -1),
   (try_begin),
	(check_quest_active, "qst_offer_gift"),
	(quest_slot_eq, "qst_offer_gift", slot_quest_giver_troop, "$g_talk_troop"),
    (assign, "$political_quest_to_cancel", "qst_offer_gift"),
	(str_store_string, s10, "str_offer_gift_description"),
   (else_try),
	(check_quest_active, "qst_resolve_dispute"),
	(quest_slot_eq, "qst_resolve_dispute", slot_quest_giver_troop, "$g_talk_troop"),
    (assign, "$political_quest_to_cancel", "qst_resolve_dispute"),
	(str_store_string, s10, "str_resolve_dispute_description"),
   (try_end),	
   (gt, "$political_quest_to_cancel", 0),
   ],
   "Let's abandon our plan to {s10}.", "minister_cancel_political_quest",[
 ]],
 
  [anyone,"minister_cancel_political_quest",
   [],
   "Are you sure you want to drop that idea?", "minister_cancel_political_quest_confirm",[
 ]],
 
  [anyone|plyr,"minister_cancel_political_quest_confirm",
   [],
   "Yes, I am sure. Let's abandon that idea.", "minister_pretalk",[
   (call_script, "script_abort_quest", "$political_quest_to_cancel", 1),
 ]],
 
  [anyone|plyr,"minister_cancel_political_quest_confirm",
   [],
   "Actually, never mind.", "minister_pretalk",[
 ]],   
   
   
   
   [anyone|plyr, "minister_talk",
   [
   (is_between, "$g_player_minister", active_npcs_begin, kingdom_ladies_end),
   ],
   "I wish to dispatch an emissary.", "minister_diplomatic_kingdoms",
   []],

   [anyone|plyr, "minister_talk",
   [
   (is_between, "$g_player_minister", active_npcs_begin, kingdom_ladies_end),
   ],
   "I wish to indict a disloyal vassal for treason.", "minister_indict",
   []],   

   [anyone|plyr, "minister_talk",
   [
   (faction_get_slot, ":current_marshal", "$players_kingdom", slot_faction_marshall),
   (ge, ":current_marshal", 0),
   (try_begin),
    (gt, ":current_marshal", 0),
	(str_store_troop_name, s4, ":current_marshal"),
   (else_try),	
	(str_store_string, s4, "str_myself"),
   (try_end),
   ],
   "I wish to replace {s4} as marshal.", "minister_change_marshal",
   []],
   
   [anyone|plyr, "minister_talk",
   [
   (faction_slot_eq,  "$players_kingdom", slot_faction_marshall, -1),
   ],
   "I wish to appoint a new marshal.", "minister_change_marshal",
   []],
   
   [anyone, "minister_change_marshal",
   [
   (store_current_hours, ":hours"),
   (val_sub, ":hours", "$g_player_faction_last_marshal_appointment"),
   (lt, ":hours", 48),
   ],
   "You have just made such an appointment, {sire/my lady}. If you countermand your decree so soon, there will be great confusion. We will need to wait a few days.", "minister_pretalk",
   []],

   
   [anyone|plyr, "minister_talk",
   [
   (neg|is_between, "$g_player_minister", active_npcs_begin, active_npcs_end),
   ],
   "I wish for you to retire as minister.", "minister_replace",
   []],

   [anyone|plyr, "minister_talk",
   [
   (is_between, "$g_player_minister", active_npcs_begin, active_npcs_end),
	(neg|troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_hero),
   
   ],
   "I wish you to rejoin my party.", "minister_replace",
   []],

   [anyone|plyr, "minister_talk",
   [
   (is_between, "$g_player_minister", active_npcs_begin, kingdom_ladies_end),
   ],
   "I wish you to grant one of my vassals a fief.", "minister_grant_fief",
   []],

   [anyone|plyr, "minister_talk",
   [
   (is_between, "$g_player_minister", active_npcs_begin, kingdom_ladies_end),
   (assign, ":fief_found", -1),
   (try_for_range, ":center", centers_begin, centers_end),
    (eq, ":fief_found", -1),
	(store_faction_of_party, ":center_faction", ":center"),
    (eq, ":center_faction", "fac_player_supporters_faction"),
	(party_get_slot, ":town_lord", ":center", slot_town_lord),
	(try_begin),
		(ge, ":town_lord", active_npcs_begin),
		(store_faction_of_troop, ":town_lord_faction", ":town_lord"),
		(neq, ":town_lord_faction", "fac_player_supporters_faction"),
		(assign, ":town_lord", -1),
	(try_end),
	(lt, ":town_lord", 0),
	(assign, ":fief_found", ":center"),
   (try_end),
   (gt, ":fief_found", -1),
   (str_store_party_name, s4, ":fief_found"),
   ],
   "I wish to make myself lord of {s4}.", "minister_grant_self_fief",
   []],

   [anyone, "minister_grant_self_fief",
   [
   ],
   "As you wish. You shall be lord of {s4}.", "minister_pretalk",
   [
   (assign, ":fief_found", -1),
   (try_for_range, ":center", centers_begin, centers_end),
    (eq, ":fief_found", -1),
	(store_faction_of_party, ":center_faction", ":center"),
    (eq, ":center_faction", "fac_player_supporters_faction"),
	(party_get_slot, ":town_lord", ":center", slot_town_lord),
	(try_begin),
		(ge, ":town_lord", active_npcs_begin),
		(store_faction_of_troop, ":town_lord_faction", ":town_lord"),
		(neq, ":town_lord_faction", "fac_player_supporters_faction"),
		(assign, ":town_lord", -1),
	(try_end),
	(lt, ":town_lord", 0),
	(assign, ":fief_found", ":center"),	
   (try_end),
   
   
   (call_script, "script_give_center_to_lord", ":fief_found", "trp_player", 0),
   (try_begin),
	(faction_slot_eq, "$players_kingdom", slot_faction_political_issue, ":fief_found"),
	(faction_set_slot, "$players_kingdom", slot_faction_political_issue, -1),
   (try_end),   
   (str_store_party_name, s4, ":fief_found"),
   
   ]],
   
   
   
   [anyone|plyr, "minister_talk",
   [],
   "That is all for now.", "close_window",
   []],


   [anyone, "minister_change_marshal",
	[],
	"Who should be the new marshal?", "minister_change_marshal_choose",
	[]],

   [anyone|plyr, "minister_change_marshal_choose",
	[],
	"I shall be marshal", "minister_pretalk",
	[
	(call_script, "script_appoint_faction_marshall", "fac_player_supporters_faction", "trp_player"),
    (store_current_hours, ":hours"),
	(assign, "$g_recalculate_ais", 1),
    (assign, "$g_player_faction_last_marshal_appointment", ":hours"),


	(try_begin),
		(faction_slot_eq, "fac_player_supporters_faction", slot_faction_political_issue, 1),
		
		(faction_set_slot, "fac_player_supporters_faction", slot_faction_political_issue, 0),
		(troop_set_slot, "trp_player",  slot_troop_stance_on_faction_issue, -1),
		(try_for_range, ":active_npc", active_npcs_begin, active_npcs_end),
			(store_faction_of_troop, ":active_npc_faction", ":active_npc"),
			(eq, ":active_npc_faction", "fac_player_supporters_faction"),
			(troop_set_slot, ":active_npc", slot_troop_stance_on_faction_issue, -1),
		(try_end),	
	(try_end),		
	]],

	[anyone|plyr, "minister_change_marshal_choose",
	[],
	"For a short while, we should have no marshal", "minister_pretalk",
	[
	(call_script, "script_appoint_faction_marshall", "fac_player_supporters_faction", -1),
	(try_begin),
		(faction_slot_eq, "fac_player_supporters_faction", slot_faction_political_issue, 1),
		(faction_set_slot, "fac_player_supporters_faction", slot_faction_political_issue, 0),

		(troop_set_slot, "trp_player",  slot_troop_stance_on_faction_issue, -1),
		(try_for_range, ":active_npc", active_npcs_begin, active_npcs_end),
			(store_faction_of_troop, ":active_npc_faction", ":active_npc"),
			(eq, ":active_npc_faction", "fac_player_supporters_faction"),
			(troop_set_slot, ":active_npc", slot_troop_stance_on_faction_issue, -1),
		(try_end),	
	(try_end),	
	
	(assign, "$g_recalculate_ais", 1),
	
	]],
	
   [anyone|plyr|repeat_for_troops, "minister_change_marshal_choose",
	[
	(store_repeat_object, ":lord"),
	(is_between, ":lord", active_npcs_begin, active_npcs_end),
	(troop_slot_eq, ":lord", slot_troop_occupation, slto_kingdom_hero),
	(store_faction_of_troop, ":lord_faction", ":lord"),
	(eq, ":lord_faction", "fac_player_supporters_faction"),
	(str_store_troop_name, s4, ":lord"),
	],
	"{s4}", "minister_pretalk",
	[
	(store_repeat_object, ":lord"),
	(call_script, "script_appoint_faction_marshall", "fac_player_supporters_faction", ":lord"),
    (store_current_hours, ":hours"),
    (assign, "$g_player_faction_last_marshal_appointment", ":hours"),
	(try_begin),
		(faction_slot_eq, "fac_player_supporters_faction", slot_faction_political_issue, 1),
		
		(faction_set_slot, "fac_player_supporters_faction", slot_faction_political_issue, 0),

		(troop_set_slot, "trp_player",  slot_troop_stance_on_faction_issue, -1),
		(try_for_range, ":active_npc", active_npcs_begin, active_npcs_end),
			(store_faction_of_troop, ":active_npc_faction", ":active_npc"),
			(eq, ":active_npc_faction", "fac_player_supporters_faction"),
			(troop_set_slot, ":active_npc", slot_troop_stance_on_faction_issue, -1),
		(try_end),	
	(try_end),
	(assign, "$g_recalculate_ais", 1),
	]],
	
	
   [anyone|plyr, "minister_change_marshal_choose",
	[],
	"Never mind", "minister_pretalk",
	[]],



   [anyone, "minister_diplomatic_kingdoms",
   [
   (assign, ":companion_found", 0),
   (try_for_range, ":emissary", companions_begin, companions_end),
	(main_party_has_troop, ":emissary"),
	(assign, ":companion_found", 1),
   (try_end),
   (eq, ":companion_found", 1),
   
   ],
   "To whom do you wish to send this emissary?", "minister_diplomatic_kingdoms_select",
   []],

   [anyone, "minister_diplomatic_kingdoms",
   [
   ],
   "Unfortunately, there is no one to send right now.", "minister_pretalk",
   []],


   
   [anyone, "minister_diplomatic_kingdoms",
   [],
   "To whom do you wish to send this emissary?", "minister_diplomatic_kingdoms_select",
   []],

  [anyone|plyr|repeat_for_factions, "minister_diplomatic_kingdoms_select",
   [
     (store_repeat_object, ":faction_no"),
	 (is_between, ":faction_no", kingdoms_begin, kingdoms_end),
	 (neq, ":faction_no", "fac_player_supporters_faction"),
     (faction_slot_eq, ":faction_no", slot_faction_state, sfs_active),
     (faction_get_slot, ":leader_no", ":faction_no", slot_faction_leader),
     (str_store_troop_name, s10, ":leader_no"),
     (str_store_faction_name, s11, ":faction_no"),
	 (str_clear, s14),
	 #Has/has not recognized us a monarch
     ],
   "{s10} of the {s11}{s14}", "minister_diplomatic_initiative_type",
   [
     (store_repeat_object, "$g_faction_selected"),
     ]],

   [anyone|plyr, "minister_diplomatic_kingdoms_select",
   [],
   "Never mind", "minister_pretalk",
   []],
	 
	 
   [anyone, "minister_diplomatic_initiative_type",
   [],
   "What do you wish to tell him?", "minister_diplomatic_initiative_type_select",
   []],

  [anyone|plyr, "minister_diplomatic_initiative_type_select",
   [(store_relation, ":relation", "fac_player_supporters_faction", "$g_faction_selected"),
    (lt, ":relation", 0),],
   "That our two kingdoms should enter into truce.", "minister_diplomatic_emissary",
   [(assign, "$g_initiative_selected", npc_mission_peace_request)]],

  [anyone|plyr, "minister_diplomatic_initiative_type_select",
   [],
   "That I wish to put myself under his protection, as his vassal.", "minister_diplomatic_emissary",
   [(assign, "$g_initiative_selected", npc_mission_pledge_vassal)]],
   
  [anyone|plyr, "minister_diplomatic_initiative_type_select",
   [(store_relation, ":relation", "fac_player_supporters_faction", "$g_faction_selected"),
    (faction_slot_eq, "$g_faction_selected", slot_faction_recognized_player, 0),
    (ge, ":relation", 0),],
   "That I wish to express my goodwill, as one monarch to another.", "minister_diplomatic_emissary",
   [(assign, "$g_initiative_selected", npc_mission_seek_recognition),]],
 
  [anyone|plyr, "minister_diplomatic_initiative_type_select",
   [(store_relation, ":relation", "fac_player_supporters_faction", "$g_faction_selected"),
    (ge, ":relation", 0),],
   "That I declare war upon him.", "minister_declare_war",
   []],
 
  [anyone|plyr, "minister_diplomatic_initiative_type_select",[], "Never mind", "close_window",[]],

  [anyone, "minister_declare_war",
   [(try_begin),
   		(call_script, "script_diplomacy_faction_get_diplomatic_status_with_faction", "fac_player_supporters_faction", "$g_faction_selected"),
		(eq, reg0, 1),
		(str_store_string, s12, "str_in_doing_so_you_will_be_in_violation_of_your_truce_is_that_what_you_want"),
	(else_try),
   		(call_script, "script_diplomacy_faction_get_diplomatic_status_with_faction", "fac_player_supporters_faction", "$g_faction_selected"),
		(neq, reg0, -1),
		(str_store_string, s12, "str_if_you_attack_without_provocation_some_of_your_vassals_may_consider_you_to_be_too_warlike_is_that_what_you_want"),
	(else_try),
		(str_store_string, s12, "str_our_men_are_ready_to_ride_forth_at_your_bidding_are_you_sure_this_is_what_you_want"),
    (try_end),
   ], "{s12}", "minister_declare_war_confirm",
   []],

  [anyone|plyr, "minister_declare_war_confirm",
   [(str_store_faction_name, s12, "$g_faction_selected"),
   ],
   "It is. I wish to make war on {s12}.", "minister_declare_war_confirm_yes",
   [
    (call_script, "script_diplomacy_start_war_between_kingdoms",  "fac_player_supporters_faction", "$g_faction_selected", 1),
	]],

  [anyone|plyr, "minister_declare_war_confirm",
   [(str_store_faction_name, s12, "$g_faction_selected"),
   ],
   "Hmm. Perhaps not.", "minister_pretalk",
   [
	]],
	
  [anyone, "minister_declare_war_confirm_yes",
   [(str_store_faction_name, s12, "$g_faction_selected"),
   ],
   "As you command. We are now at war with the {s12}. May the heavens grant us victory.", "minister_pretalk",
   [
	]],
   

   [anyone, "minister_diplomatic_emissary",
   [], "Who shall be your emissary? You should choose one whom you trust, but who is also persuasive -- one who can negotiate without giving offense.", "minister_emissary_select",
   []],

  [anyone|plyr|repeat_for_troops, "minister_emissary_select",[
  (store_repeat_object, ":emissary"),
  (main_party_has_troop, ":emissary"),
  (is_between, ":emissary", companions_begin, companions_end),
  (troop_slot_eq, ":emissary", slot_troop_prisoner_of_party, -1),
  (is_between, ":emissary", active_npcs_begin, active_npcs_end),
  (str_store_troop_name, s11, ":emissary"),
  ], "{s11}", "minister_emissary_dispatch",[
  (store_repeat_object, "$g_emissary_selected"),
  ]],
   
  [anyone|plyr, "minister_emissary_select",[
  ], "Actually, I can't think of anyone.", "minister_pretalk",[]],

  [anyone, "minister_emissary_dispatch",
   [
   (str_store_troop_name, s11, "$g_emissary_selected"),
   (str_store_faction_name, s12, "$g_faction_selected"),
   (try_begin),
		(eq, "$g_initiative_selected", npc_mission_seek_recognition),
		(str_store_string, s14, "str_seek_recognition"),
   (else_try),
		(eq, "$g_initiative_selected", npc_mission_pledge_vassal),
		(str_store_string, s14, "str_seek_vassalhood"),
   (else_try),
		(eq, "$g_initiative_selected", npc_mission_peace_request),
		(str_store_string, s14, "str_seek_a_truce"),
   (try_end),
   ], "Very well -- I shall send {s11} to the {s12} to {s14}.", "minister_diplomatic_dispatch_confirm",[]],

  [anyone|plyr, "minister_diplomatic_dispatch_confirm",[], "Yes, do that", "minister_pretalk",[
    (troop_set_slot, "$g_emissary_selected", slot_troop_days_on_mission, 3),
  	(troop_set_slot, "$g_emissary_selected", slot_troop_current_mission, "$g_initiative_selected"),
  	(troop_set_slot, "$g_emissary_selected", slot_troop_mission_object, "$g_faction_selected"),

	(remove_member_from_party, "$g_emissary_selected", "p_main_party"),
  ]],
   
   
  [anyone|plyr, "minister_diplomatic_dispatch_confirm",[], "Actually, hold off on that", "minister_pretalk",[]],

  [anyone, "minister_replace",
   [], "Very good. Whom will you appoint in my stead?", "minister_replace_select",
   []],

  [anyone|plyr|repeat_for_troops, "minister_replace_select",
   [
   (store_repeat_object, ":troop_no"),
   (is_between, ":troop_no", companions_begin, companions_end),
   (main_party_has_troop, ":troop_no"),
   (troop_slot_eq, ":troop_no", slot_troop_prisoner_of_party, -1),
   (str_store_troop_name, s4, ":troop_no"),
   ], "{s4}", "minister_replace_confirm",
   [
   (store_repeat_object, "$g_player_minister"),
   ]],

   [anyone|plyr, "minister_replace_select",
   [
   (troop_get_slot, ":spouse", "trp_player", slot_troop_spouse),
   (gt, ":spouse", 0),
   (troop_get_type, ":is_female", ":spouse"),
   (neg|troop_slot_eq, ":spouse", slot_troop_occupation, slto_kingdom_hero),
   (eq, ":is_female", 1),
   (str_store_troop_name, s4, ":spouse"),
   (neq, ":spouse", "$g_talk_troop"),
   
   ], "My wife, {s4}.", "minister_replace_confirm", #husband disabled, as he's an active lord
   [
   (troop_get_slot, "$g_player_minister", "trp_player", slot_troop_spouse),
   ]],

  [anyone|plyr, "minister_replace_select",
   [], "Actually, hold off on that.", "minister_pretalk",
   []],



   
  [anyone, "minister_replace_confirm",
   [
   (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_player_companion),
   ], "Very good. {s9} is your new minister. I shall make ready to rejoin you.", "close_window",
   [
   (str_store_troop_name, s9, "$g_player_minister"),
   (party_add_members, "p_main_party", "$g_talk_troop", 1), 
   (assign, "$g_leave_encounter", 1),
   (try_begin),
	  (main_party_has_troop, "$g_player_minister"),
      (party_remove_members, "p_main_party", "$g_player_minister", 1), 
   (try_end),
   
   (try_for_range, ":minister_quest", all_quests_begin, all_quests_end),
	(quest_slot_eq, ":minister_quest", slot_quest_giver_troop, "$g_talk_troop"),
	(call_script, "script_abort_quest", ":minister_quest", 0),
   (try_end),
   ]],
   
  [anyone, "minister_replace_confirm",
   [
   ], "Very good. {s9} is your new minister. It has been an honor to serve you.", "close_window",
   [
   (str_store_troop_name, s9, "$g_player_minister"),
   (try_begin),
	(main_party_has_troop, "$g_player_minister"),
    (party_remove_members, "p_main_party", "$g_player_minister", 1), 
   (try_end),
   
   ]],
   


   [anyone, "minister_grant_fief",
   [
   (faction_get_slot, ":fief_on_agenda", "$players_kingdom", slot_faction_political_issue),
   (str_clear, s12),
   (try_begin),
	(is_between, ":fief_on_agenda", centers_begin, centers_end),
    (str_store_party_name, s4, ":fief_on_agenda"),
	(str_store_string, s12, "str_minister_advice_select_fief"),
   (else_try),
    (eq, ":fief_on_agenda", 1),
	(str_store_string, s12, "str_minister_advice_select_fief_wait"),
   (try_end),
   ],
   "Which of your fiefs did you wish to grant?{s12}", "minister_grant_fief_select",
   []],


   [anyone|plyr|repeat_for_parties, "minister_grant_fief_select",
   [
   (store_repeat_object, ":center_no"),
   (is_between, ":center_no", centers_begin, centers_end),
   (store_faction_of_party, ":center_faction", ":center_no"),
   (eq, ":center_faction", "fac_player_supporters_faction"),
   (neq, ":center_no", "$g_player_court"),
	(party_get_slot, ":town_lord", ":center_no", slot_town_lord),
	(try_begin),
		(ge, ":town_lord", active_npcs_begin),
		(store_faction_of_troop, ":town_lord_faction", ":town_lord"),
		(neq, ":town_lord_faction", "fac_player_supporters_faction"),
		(assign, ":town_lord", -1),
	(try_end),
	(le, ":town_lord", 0),
   
   (str_store_party_name, s1, ":center_no"),
   (str_clear, s12),
   (try_begin),
	(party_slot_eq, ":center_no", slot_town_lord, -1),
	(str_store_string, s12, "str_unassigned_center"),
   (try_end),
   
   ],"{s1}{s12}", "minister_grant_fief_select_recipient",
   [
   (store_repeat_object, "$fief_selected"),
   ]],   

   [anyone|plyr, "minister_grant_fief_select",
   [
   ],"Never mind", "minister_pretalk",
   []],   
   
   [anyone, "minister_grant_fief_select_recipient",
   [
   (str_clear, s12),
   (try_begin),
	(faction_slot_eq, "$players_kingdom", slot_faction_political_issue, "$fief_selected"),
   
	(try_for_range, ":active_npc", active_npcs_begin, active_npcs_end),
		(troop_set_slot, ":active_npc", slot_troop_temp_slot, 0),
	(try_end),
   
	(assign, ":popular_favorite", -1),
    (assign, ":votes_for_popular_favorite", 0),
	(try_for_range, ":active_npc", active_npcs_begin, active_npcs_end),
		(store_faction_of_troop, ":active_npc_faction", ":active_npc"),
		(eq, ":active_npc_faction", "fac_player_supporters_faction"),
		(troop_get_slot, ":selected_npc", ":active_npc", slot_troop_stance_on_faction_issue),
		(ge, ":selected_npc", 0),
		
		(troop_get_slot, ":votes_accumulated", ":selected_npc", slot_troop_temp_slot),
		(val_add, ":votes_accumulated", 1),
		(troop_set_slot, ":selected_npc", slot_troop_temp_slot, ":votes_accumulated"),
		
		(gt, ":votes_accumulated", ":votes_for_popular_favorite"),
		(assign,  ":votes_for_popular_favorite", ":votes_accumulated"),
		(assign, ":popular_favorite", ":selected_npc"),
	(try_end),
   
    (is_between, ":popular_favorite", active_npcs_begin, active_npcs_end), 
    (str_store_troop_name, s4, ":popular_favorite"),
    (assign, reg4, ":votes_for_popular_favorite"),
	
	(str_store_string, s12, "str_minister_advice_fief_leading_vassal"),
  (try_end),
   
   ],"And who will you choose to receive the fief?{s12}", "minister_grant_fief_select_recipient_choice",
   []],   
      
   [anyone|plyr|repeat_for_troops, "minister_grant_fief_select_recipient_choice",
   [
   (store_repeat_object, ":troop_no"),
   (troop_slot_eq, ":troop_no", slot_troop_occupation, slto_kingdom_hero),
   (is_between, ":troop_no", active_npcs_begin, active_npcs_end),
   (store_faction_of_troop, ":troop_faction", ":troop_no"),
   (eq, ":troop_faction", "fac_player_supporters_faction"),
   (str_store_troop_name, s1, ":troop_no"),
   
   
   ],"{s1}", "minister_grant_fief_complete",
   [
   (store_repeat_object, "$lord_selected"),
   ]],      
   
   [anyone|plyr, "minister_grant_fief_select_recipient_choice",
   [
   ],"Never mind", "minister_pretalk",
   []],   
   
   [anyone, "minister_grant_fief_complete",
   [
   ],"Very well - {s2} shall receive {s1}.", "minister_pretalk",
   [
   (call_script, "script_give_center_to_lord", "$fief_selected", "$lord_selected", 0),
   (str_store_party_name, s1, "$fief_selected"),
   (str_store_troop_name, s2, "$lord_selected"),
   
   (try_begin),
	(faction_slot_eq, "$players_kingdom", slot_faction_political_issue, "$fief_selected"),
	(faction_set_slot, "$players_kingdom", slot_faction_political_issue, -1),
   (try_end),
   
   (call_script, "script_add_log_entry", logent_castle_given_to_lord_by_player, "trp_player", "$fief_selected", "$lord_selected", "$g_encountered_party_faction"),
   ]],   
   
   
   
   
   
   
   [anyone, "minister_indict",
   [], "Grim news, {sire/my lady}. Who do you believe is planning to betray you?", "minister_indict_select",
   []],   
   
   [anyone|plyr|repeat_for_troops, "minister_indict_select",
   [
   (store_repeat_object, ":troop_no"),
   (troop_slot_eq, ":troop_no", slot_troop_occupation, slto_kingdom_hero),
   (store_faction_of_troop, ":faction", ":troop_no"),
   (eq, ":faction", "fac_player_supporters_faction"),
   (str_store_troop_name, s11, ":troop_no"),
   ], "{s11}", "minister_indict_confirm",
   [
   (store_repeat_object, "$lord_selected"),
   ]],   
   
   [anyone|plyr, "minister_indict_select",
   [], "Never mind.", "minister_pretalk",
   []],   
   
   
   [anyone, "minister_indict_confirm",
   [
   (str_store_troop_name, s4, "$lord_selected"),
   (troop_get_type, reg4, "$lord_selected"),
   ], "Think carefully on this, {sire/my lady}. If you indict {s4} for treason unjustly, you may find that others become nervous about serving you. On the other hand, if you truly believe that {reg4?she:he} is about to betray you, then perhaps it is best to move first, to secure control of {reg4?her:his} fortresses.", "minister_indict_confirm_answer",
   []],   

  [anyone|plyr, "minister_indict_confirm_answer",[], "I have thought long enough. Issue the indictment!", "minister_indict_conclude",[]],
  
  [anyone|plyr, "minister_indict_confirm_answer",[], "Perhaps I should wait a little while longer..", "minister_pretalk",[]],
   
   [anyone, "minister_indict_conclude",
   [], "It has been sent, {sire/my lady}.", "minister_pretalk",
   [
   (call_script, "script_indict_lord_for_treason", "$lord_selected", "fac_player_supporters_faction"),
   ]],      	


	 
	 
	 
	 
	 
	 
	 

   [anyone|plyr|repeat_for_troops, "center_captured_lord_advice",
   [
     (store_repeat_object, ":troop_no"),
     (troop_slot_eq, ":troop_no", slot_troop_occupation, slto_kingdom_hero),
     (neq, "$g_talk_troop", ":troop_no"),
     (neq, "trp_player", ":troop_no"),
     (store_troop_faction, ":faction_no", ":troop_no"),
     (eq, ":faction_no", "fac_player_supporters_faction"),
     (str_store_troop_name, s11, ":troop_no"),
     (call_script, "script_print_troop_owned_centers_in_numbers_to_s0", ":troop_no"),
	 
	 (try_begin),
	   (troop_slot_eq, "$g_talk_troop", slot_lord_recruitment_argument, argument_benefit),
	   (str_store_string, s12, "str__promised_fief"),
	 (else_try),
	   (str_clear, s12),
	 (try_end),
	 
     (try_begin),
       (eq, reg0, 0),
       (str_store_string, s1, "str_no_fiefss12"),
     (else_try),
       (str_store_string, s1, "str_fiefs_s0s12"),
     (try_end),
     ],
   "{s11}. {s1}", "center_captured_lord_advice_2",
   [
     (store_repeat_object, "$temp"),
     ]],

  [anyone|plyr, "center_captured_lord_advice",
   [
     (call_script, "script_print_troop_owned_centers_in_numbers_to_s0", "trp_player"),
     (str_store_party_name, s1, "$g_center_taken_by_player_faction"),

	 (try_begin),
		(is_between, "$g_talk_troop", pretenders_begin, pretenders_end),
		(str_store_string, s12, "str_please_s65_"),
	 (else_try),	
		(str_clear, s12),
	 (try_end),	
	 ],
   "{s12}I want to have {s1} for myself. (fiefs: {s0})", "center_captured_lord_advice_2",
   [
     (assign, "$temp", "trp_player"),
     ]],

  [anyone|plyr, "center_captured_lord_advice",
   [
     (call_script, "script_print_troop_owned_centers_in_numbers_to_s0", "$g_talk_troop"),
     (str_store_party_name, s1, "$g_center_taken_by_player_faction"),
	 (is_between, "$g_talk_troop", pretenders_begin, pretenders_end),
     ],
   "{s66}, you should have {s1} for yourself. (fiefs: {s0})", "center_captured_lord_advice_2",
   [
     (assign, "$temp", "$g_talk_troop"),
     ]],

	 
  [anyone, "center_captured_lord_advice_2",
   [
     (eq, "$g_talk_troop", "$g_player_minister"),
     ],
   "As you wish, {sire/my lady}. {reg6?I:{reg7?You:{s11}}} will be the new {reg3?lady:lord} of {s1}.", "minister_issues",
   [
     (assign, ":new_owner", "$temp"),
	 
     (call_script, "script_give_center_to_lord", "$g_center_taken_by_player_faction", ":new_owner", 0),
	 
	 (try_begin),
		(faction_slot_eq, "$players_kingdom", slot_faction_political_issue, "$g_center_taken_by_player_faction"),
		(faction_set_slot, "$players_kingdom", slot_faction_political_issue, -1),
	 (try_end),	 
	 
     (try_begin),
       (neq, ":new_owner", "trp_player"),
       (try_for_range, ":unused", 0, 4),
         (call_script, "script_cf_reinforce_party", "$g_center_taken_by_player_faction"),
       (try_end),
     (try_end),

     (assign, reg6, 0),
     (assign, reg7, 0),
     (try_begin),
       (eq, ":new_owner", "$g_talk_troop"),
       (assign, reg6, 1),
     (else_try),
       (eq, ":new_owner", "trp_player"),
       (assign, reg7, 1),
     (else_try),
       (str_store_troop_name, s11, ":new_owner"),
     (try_end),
     (str_store_party_name, s1, "$g_center_taken_by_player_faction"),
     (troop_get_type, reg3, ":new_owner"),
     (assign, "$g_center_taken_by_player_faction", -1),	 	 
     ]],
	 
	 
	 
  [anyone, "center_captured_lord_advice_2",
   [
     ],
   "Hmmm. All right, {playername}. I value your counsel highly. {reg6?I:{reg7?You:{s11}}} will be the new {reg3?lady:lord} of {s1}.", "close_window",
   [
     (assign, ":new_owner", "$temp"),
	 
	 (troop_set_slot, ":new_owner", slot_lord_recruitment_argument, 0),
	 
     (call_script, "script_give_center_to_lord", "$g_center_taken_by_player_faction", ":new_owner", 0),
	 (try_begin),
		(faction_slot_eq, "$players_kingdom", slot_faction_political_issue, "$g_center_taken_by_player_faction"),
		(faction_set_slot, "$players_kingdom", slot_faction_political_issue, -1),
	 (try_end),	 
   
     (try_begin),
       (neq, ":new_owner", "trp_player"),
       (try_for_range, ":unused", 0, 4),
         (call_script, "script_cf_reinforce_party", "$g_center_taken_by_player_faction"),
       (try_end),
     (try_end),

     (assign, reg6, 0),
     (assign, reg7, 0),
     (try_begin),
       (eq, ":new_owner", "$g_talk_troop"),
       (assign, reg6, 1),
     (else_try),
       (eq, ":new_owner", "trp_player"),
       (assign, reg7, 1),
     (else_try),
       (str_store_troop_name, s11, ":new_owner"),
     (try_end),
     (str_store_party_name, s1, "$g_center_taken_by_player_faction"),
     (troop_get_type, reg3, ":new_owner"),
     (assign, "$g_center_taken_by_player_faction", -1),	 	 
     ]],



  [anyone, "event_triggered", [
                     (eq, "$g_infinite_camping", 0),
                     (store_conversation_troop, "$map_talk_troop"),
					 (is_between, "$map_talk_troop", companions_begin, companions_end),
                     (eq, "$map_talk_troop", "$npc_is_quitting"), 
                     (troop_get_slot, ":honorific", "$map_talk_troop", slot_troop_honorific), 
                     (str_store_string, 5, ":honorific")],
   "Excuse me {s5} -- there is something I need to tell you.", "companion_quitting", [
                    (assign, "$npc_is_quitting", 0),
                    (assign, "$player_can_persuade_npc", 1),
                    (assign, "$player_can_refuse_npc_quitting", 1),
       ]],

### This is also where the dialogue jumps if the player initiates quitting dialogue and the companion has low morale
  [anyone, "companion_quitting", [
                     (store_conversation_troop, "$map_talk_troop"),
                     (troop_get_slot, ":speech", "$map_talk_troop", slot_troop_retirement_speech), 
                     (str_store_string, 5, ":speech")
                     ],
   "{s5}", "companion_quitting_2", [
       ]],

## The companion explains his/her reasons for quitting
  [anyone, "companion_quitting_2", [
                    (call_script, "script_npc_morale", "$map_talk_troop"),
                     ],
   "To tell you the truth, {s21}", "companion_quitting_response", [
       ]],

  [anyone|plyr, "companion_quitting_response", [
      ], "Very well. You be off, then.", "companion_quitting_yes", [
          ]],

  [anyone|plyr, "companion_quitting_response", [
                (eq, "$player_can_persuade_npc", 1),
      ], "Perhaps I can persuade you to change your mind.", "companion_quitting_persuasion", [
            (assign, "$player_can_persuade_npc", 0),
          ]],

  [anyone, "companion_quitting_persuasion", [
                (store_random_in_range, ":random", -2, 13),
                (store_skill_level, ":persuasion", "skl_persuasion", "trp_player"),
                (le, ":random", ":persuasion"),
                     ],
   "Hm. When you put it like that, I suppose I can stay a while longer, see if things improve.", "close_window",
   [
                (troop_get_slot, ":morality_penalties", "$map_talk_troop", slot_troop_morality_penalties),
                (val_div, ":morality_penalties", 2),
                (troop_set_slot, "$map_talk_troop", slot_troop_morality_penalties, ":morality_penalties"),

                (troop_get_slot, ":personalityclash_penalties", "$map_talk_troop", slot_troop_personalityclash_penalties),
                (val_div, ":personalityclash_penalties", 2),
                (troop_set_slot, "$map_talk_troop", slot_troop_personalityclash_penalties, ":personalityclash_penalties"),
       ]],

  [anyone, "companion_quitting_persuasion", [
                     ],
   "I'm sorry, but I don't see your point. I am leaving whether you like it or not.", "companion_quitting_response",
   [
       ]],

  [anyone|plyr, "companion_quitting_response", [
            (eq, 1, 0),
            (eq, "$player_can_refuse_npc_quitting", 1),
      ], "We hang deserters in this company.", "companion_quitting_no", [
          ]],

  [anyone, "companion_quitting_no", [],
   "Oh... Right... Do you mean that?", "companion_quitting_no_confirm", [
       ]],

  [anyone|plyr, "companion_quitting_no_confirm", [],
   "Absolutely. You either leave this company by my command, or are carried out on your shield.", "companion_quitting_no_confirmed", [
       ]],

  [anyone|plyr, "companion_quitting_no_confirm", [],
   "No, actually I don't mean that. You are free to leave.", "companion_quitting_yes", [
       ]],

  [anyone, "companion_quitting_yes", [
                     ],
   "Then this is goodbye. Perhaps I'll see you around, {playername}.", "close_window", [
          (troop_set_slot, "$map_talk_troop", slot_troop_playerparty_history, pp_history_quit), 
          (call_script, "script_retire_companion", "$map_talk_troop", 100),
       ]],

  [anyone, "companion_quitting_no_confirmed", [
      ],
   "Hm. I suppose I'm staying, then.", "close_window", [
       ]],


#Morality objections
  [anyone, "event_triggered", [
                     (store_conversation_troop, "$map_talk_troop"),
					 (is_between, "$map_talk_troop", companions_begin, companions_end),	
					 
                     (eq, "$map_talk_troop", "$npc_with_grievance"), 
                     (eq, "$npc_map_talk_context", slot_troop_morality_state), 
					 
					 
                     (try_begin),
                         (eq, "$npc_grievance_slot", slot_troop_morality_state),
                         (troop_get_slot, ":speech", "$map_talk_troop", slot_troop_morality_speech),
                     (else_try),
                         (troop_get_slot, ":speech", "$map_talk_troop", slot_troop_2ary_morality_speech),
                     (try_end),
                     (str_store_string, 21, "$npc_grievance_string"),
                     (str_store_string, 5, ":speech"),
                     ],
   "{s5}", "companion_objection_response", [
                    (assign, "$npc_with_grievance", 0),
       ]],



  [anyone|plyr, "companion_objection_response", [
                    (eq, "$npc_praise_not_complaint", 1),
      ], "Thanks, I appreciate your support.", "close_window", [
                    (troop_set_slot, "$map_talk_troop", "$npc_grievance_slot", tms_acknowledged),
          ]],

  [anyone|plyr, "companion_objection_response", [
                    (eq, "$npc_praise_not_complaint", 0),
      ], "Hopefully it won't happen again.", "close_window", [
                    (troop_set_slot, "$map_talk_troop", "$npc_grievance_slot", tms_acknowledged),
          ]],

  [anyone|plyr, "companion_objection_response", [
                    (eq, "$npc_praise_not_complaint", 0),
      ],  "Your objection is noted. Now fall back in line.", "close_window", [
                    (troop_set_slot, "$map_talk_troop", "$npc_grievance_slot", tms_dismissed),
                    (troop_get_slot, ":grievance", "$map_talk_troop", slot_troop_morality_penalties),
                    (val_add, ":grievance", 10),
                    (troop_set_slot, "$map_talk_troop", slot_troop_morality_penalties, ":grievance"),
          ]],


##  [anyone|plyr, "companion_objection_response", [
##      ],  "I prefer my followers to keep their opinions to themselves.", "close_window", [
##                    (troop_set_slot, "$map_talk_troop", "$npc_grievance_slot", tms_dismissed),
##                    (troop_get_slot, ":grievance", "$map_talk_troop", slot_troop_morality_penalties),
##                    (val_add, ":grievance", 10),
##                    (troop_set_slot, "$map_talk_troop", slot_troop_morality_penalties, ":grievance"),
##                    (assign, "$disable_npc_complaints", 1),
##          ]],



# Personality clash 2 objections
  [anyone, "event_triggered", [
                     (store_conversation_troop, "$map_talk_troop"),
					 (is_between, "$map_talk_troop", companions_begin, companions_end),
					 
                     (eq, "$map_talk_troop", "$npc_with_personality_clash_2"), 
                     (eq, "$npc_map_talk_context", slot_troop_personalityclash2_state), 

                     (troop_get_slot, ":speech", "$map_talk_troop", slot_troop_personalityclash2_speech),
                     (troop_get_slot, ":object", "$map_talk_troop", slot_troop_personalityclash2_object),
                     (str_store_troop_name, 11, ":object"),
                     (str_store_string, 5, ":speech"),
                     ],
   "{s5}", "companion_personalityclash2_b", [
                    (assign, "$npc_with_personality_clash_2", 0),
                    (troop_get_slot, ":grievance", "$map_talk_troop", slot_troop_personalityclash_penalties),
                    (val_add, ":grievance", 5),
                    (troop_set_slot, "$map_talk_troop", slot_troop_personalityclash_penalties, ":grievance"),
					
                    (troop_get_slot, ":object", "$map_talk_troop", slot_troop_personalityclash2_object),
					(call_script, "script_troop_change_relation_with_troop", "$map_talk_troop", ":object", -15),
       ]],

  [anyone, "companion_personalityclash2_b", [
      ],  "{s5}", "companion_personalityclash2_response", [
                     (troop_get_slot, ":speech", "$map_talk_troop", slot_troop_personalityclash2_speech_b),
                     (troop_get_slot, ":object", "$map_talk_troop", slot_troop_personalityclash2_object),
                     (str_store_troop_name, 11, ":object"),
                     (str_store_string, 5, ":speech"),
          ]],



  [anyone|plyr, "companion_personalityclash2_response", [
      (troop_get_slot, ":object", "$map_talk_troop", slot_troop_personalityclash2_object),
      (str_store_troop_name, s11, ":object"),
      (troop_get_type, reg11, ":object"),
      ],  "{s11} is a valuable member of this company. I don't want you picking any more fights with {reg11?her:him}.", "close_window", [
                    (troop_set_slot, "$map_talk_troop", slot_troop_personalityclash2_state, pclash_penalty_to_self),
          ]],

  [anyone|plyr, "companion_personalityclash2_response", [
      (troop_get_slot, ":object", "$map_talk_troop", slot_troop_personalityclash2_object),
      (str_store_troop_name, s11, ":object"),
      (troop_get_type, reg11, ":object"),
      ],  "Tell {s11} you have my support in this, and {reg11?she:he} should hold {reg11?her:his} tongue.", "close_window", [
                    (troop_set_slot, "$map_talk_troop", slot_troop_personalityclash2_state, pclash_penalty_to_other),
          ]],
  
  [anyone|plyr, "companion_personalityclash2_response", [
      ],  "I don't have time for your petty dispute. Do not bother me with this again.", "close_window", [
                    (troop_set_slot, "$map_talk_troop", slot_troop_personalityclash2_state, pclash_penalty_to_both),
          ]],

  
##  [anyone|plyr, "companion_personalityclash2_response", [
##      ],  "Your grievance is noted. Now fall back in line.", "close_window", [
##                    (troop_set_slot, "$map_talk_troop", slot_troop_personalityclash2_state, 1),
##          ]],

##  [anyone|plyr, "companion_personalityclash2_response", [
##      ],  "I prefer my followers to keep their opinions to themselves.", "close_window", [
##                    (troop_set_slot, "$map_talk_troop", slot_troop_personalityclash2_state, 1),
##                    (assign, "$disable_npc_complaints", 1),
##          ]],




# Personality clash objections

  [anyone, "event_triggered", [
                     (store_conversation_troop, "$map_talk_troop"),
					 (is_between, "$map_talk_troop", companions_begin, companions_end),
					 
                     (eq, "$map_talk_troop", "$npc_with_personality_clash"),
                     (eq, "$npc_map_talk_context", slot_troop_personalityclash_state), 

                     (troop_get_slot, ":speech", "$map_talk_troop", slot_troop_personalityclash_speech),
                     (troop_get_slot, ":object", "$map_talk_troop", slot_troop_personalityclash_object),
                     (str_store_troop_name, 11, ":object"),
                     (str_store_string, 5, ":speech"),
                     ],
   "{s5}", "companion_personalityclash_b", [
                    (assign, "$npc_with_personality_clash", 0),
                    (troop_get_slot, ":grievance", "$map_talk_troop", slot_troop_personalityclash_penalties),
                    (val_add, ":grievance", 5),
                    (troop_set_slot, "$map_talk_troop", slot_troop_personalityclash_penalties, ":grievance"),

                    (troop_get_slot, ":object", "$map_talk_troop", slot_troop_personalityclash_object),
					(call_script, "script_troop_change_relation_with_troop", "$map_talk_troop", ":object", -15),
				
       ]],

  [anyone, "companion_personalityclash_b", [
      ],  "{s5}", "companion_personalityclash_response", [
                     (troop_get_slot, ":speech", "$map_talk_troop", slot_troop_personalityclash_speech_b),
                     (troop_get_slot, ":object", "$map_talk_troop", slot_troop_personalityclash_object),
                     (str_store_troop_name, 11, ":object"),
                     (str_store_string, 5, ":speech"),
          ]],

  [anyone|plyr, "companion_personalityclash_response", [
      (troop_get_slot, ":object", "$map_talk_troop", slot_troop_personalityclash_object),
      (str_store_troop_name, s11, ":object"),
      (troop_get_type, reg11, ":object"),
      ],  "{s11} is a capable member of this company. I don't want you picking any more fights with {reg11?her:him}.", "close_window", [
                    (troop_set_slot, "$map_talk_troop", slot_troop_personalityclash_state, pclash_penalty_to_self),
          ]],

  [anyone|plyr, "companion_personalityclash_response", [
      (troop_get_slot, ":object", "$map_talk_troop", slot_troop_personalityclash_object),
      (str_store_troop_name, s11, ":object"),
      (troop_get_type, reg11, ":object"),
      ],  "Tell {s11} you have my support in this, and {reg11?she:he} should hold {reg11?her:his} tongue.", "close_window", [
                    (troop_set_slot, "$map_talk_troop", slot_troop_personalityclash_state, pclash_penalty_to_other),
          ]],
  
  [anyone|plyr, "companion_personalityclash_response", [
      ],  "I don't have time for your petty dispute. Do not bother me with this again.", "close_window", [
                    (troop_set_slot, "$map_talk_troop", slot_troop_personalityclash_state, pclash_penalty_to_both),
          ]],


##  [anyone|plyr, "companion_personalityclash_response", [
##      ],  "Your grievance is noted. Now fall back in line.", "close_window", [
##                    (troop_set_slot, "$map_talk_troop", slot_troop_personalityclash_state, 1),
##          ]],

##  [anyone|plyr, "companion_personalityclash_response", [
##      ],  "I prefer my followers to keep their opinions to themselves.", "close_window", [
##                    (troop_set_slot, "$map_talk_troop", slot_troop_personalityclash_state, 1),
##                    (assign, "$disable_npc_complaints", 1),
##          ]],



# Personality match

  [anyone, "event_triggered", [
                     (eq, "$npc_map_talk_context", slot_troop_personalitymatch_state), 
                     (store_conversation_troop, "$map_talk_troop"),
					 (is_between, "$map_talk_troop", companions_begin, companions_end),
					 
                     (eq, "$map_talk_troop", "$npc_with_personality_match"),

                     (troop_get_slot, ":speech", "$map_talk_troop", slot_troop_personalitymatch_speech),
                     (troop_get_slot, ":object", "$map_talk_troop", slot_troop_personalitymatch_object),
                     (str_store_troop_name, 11, ":object"),
                     (str_store_string, 5, ":speech"),
					 
                     ],
   "{s5}", "companion_personalitymatch_b", [
                    (assign, "$npc_with_personality_match", 0),
                    (troop_get_slot, ":object", "$map_talk_troop", slot_troop_personalitymatch_object),
					(call_script, "script_troop_change_relation_with_troop", "$map_talk_troop", ":object", 15),					 
					
       ]],

  [anyone, "companion_personalitymatch_b", [
                    (troop_get_slot, ":speech", "$map_talk_troop", slot_troop_personalitymatch_speech_b),
                    (troop_get_slot, ":object", "$map_talk_troop", slot_troop_personalitymatch_object),
                    (str_store_troop_name, 11, ":object"),
                    (str_store_string, 5, ":speech"),
					 
                     ],
   "{s5}", "companion_personalitymatch_response", [
       ]],


  [anyone|plyr, "companion_personalitymatch_response", [
      ],  "Very good.", "close_window", [
                    (troop_set_slot, "$map_talk_troop", slot_troop_personalitymatch_state, 1),

					]],

					
					
##  [anyone|plyr, "companion_personalitymatch_response", [
##      ],  "I prefer my followers to keep their opinions to themselves.", "close_window", [
##                    (troop_set_slot, "$map_talk_troop", slot_troop_personalitymatch_state, 1),
##                    (assign, "$disable_npc_complaints", 1),
##          ]],

  [anyone, "event_triggered", [
                     (eq, "$npc_map_talk_context", slot_troop_woman_to_woman_string), 
                     (store_conversation_troop, "$map_talk_troop"),
					 (is_between, "$map_talk_troop", companions_begin, companions_end),					 
					 
		             (store_sub, ":npc_no", "$map_talk_troop", "trp_npc1"),
		             (store_add, ":speech", "str_npc1_woman_to_woman", ":npc_no"),
#                     (troop_get_slot, ":speech", "$map_talk_troop", slot_troop_woman_to_woman_string),
                     (str_store_string, s5, ":speech"),
                     ],
   "{s5}", "companion_sisterly_advice", [
                    (troop_set_slot, "$map_talk_troop", slot_troop_woman_to_woman_string, -1),
					(assign, "$npc_with_sisterly_advice", 0),
       ]],

  [anyone|plyr, "companion_sisterly_advice", [
      ],  "Thank you.", "close_window", [
          ]],

  [anyone|plyr, "companion_sisterly_advice", [
      ],  "I would prefer not to discuss such things.", "close_window", [
	  (assign, "$disable_sisterly_advice", 1),
          ]],
	   
	   

  [anyone, "event_triggered", [
                     (eq, "$g_infinite_camping", 0),
                     (eq, "$npc_map_talk_context", slot_troop_home), 
                     (store_conversation_troop, "$map_talk_troop"),
					 (is_between, "$map_talk_troop", companions_begin, companions_end),					 
					 
                     (troop_get_slot, ":speech", "$map_talk_troop", slot_troop_home_intro),
                     (str_store_string, s5, ":speech"),
                     ],
   "{s5}", "companion_home_description", [
                    (troop_set_slot, "$map_talk_troop", slot_troop_home_speech_delivered, 1),
       ]],

  [anyone|plyr, "companion_home_description", [
      ],  "Tell me more.", "companion_home_description_2", [
          ]],

  [anyone|plyr, "companion_home_description", [
      ],  "We don't have time to chat just now.", "close_window", [
          ]],

  [anyone|plyr, "companion_home_description", [
      ],  "I prefer my companions not to bother me with such trivialities.", "close_window", [
                    (assign, "$disable_local_histories", 1),
          ]],


  [anyone, "companion_home_description_2", [
                     (troop_get_slot, ":speech", "$map_talk_troop", slot_troop_home_description),
                     (str_store_string, 5, ":speech"),
      ],  "{s5}", "companion_home_description_3", [
          ]],

  [anyone, "companion_home_description_3", [
                     (troop_get_slot, ":speech", "$map_talk_troop", slot_troop_home_description_2),
                     (str_store_string, 5, ":speech"),
      ],  "{s5}", "close_window", [
          ]],

  [anyone,"event_triggered", [
    (eq, "$talk_context", tc_rebel_thanks),
    (store_conversation_troop, "$g_talk_troop"),
	(is_between, "$g_talk_troop", pretenders_begin, pretenders_end),	
	
    (troop_get_slot, ":old_faction", "$g_talk_troop", slot_troop_original_faction),
    (str_store_faction_name, s3, ":old_faction"),
    (str_store_string, s6, "@{playername}, when we started our long walk, few people had the courage to support me.\
 And fewer still would be willing to put their lives at risk for my cause.\
 But you didn't hesitate for a moment in throwing yourself at my enemies.\
 We have gone through a lot together, and there were times I came close to losing all hope.\
 But with God's help, we prevailed. It is now time for me to leave your company and take what's rightfully mine.\
 From now on, I will carry out the great responsibility of ruling {s3}.\
 There still lie many challanges ahead and I count on your help in overcoming those.\
 And of course, you will always remain as my foremost vassal."),
    ],
   "{s6}", "rebel_thanks_answer",
   [   
     (unlock_achievement, ACHIEVEMENT_KINGMAKER),
     (call_script, "script_end_quest", "qst_rebel_against_kingdom"),

     (try_begin),
       (troop_get_type, ":is_female", "trp_player"),
       (eq, ":is_female", 1),

       (troop_get_type, ":is_female", "$g_talk_troop"),
       (eq, ":is_female", 1),	   

       (unlock_achievement, ACHIEVEMENT_GIRL_POWER),
     (try_end),
	 ]],

  [anyone|plyr,"rebel_thanks_answer", [], "It was an honour to fight for your cause, {reg65?madame:my lord}.", "rebel_thanks_answer_2", []],
  [anyone|plyr,"rebel_thanks_answer", [], "You will always have my loyal support, {reg65?my lady:sir}.", "rebel_thanks_answer_2", []],

  [anyone,"rebel_thanks_answer_2", [], "I will miss living this life of adventure with you, but my duties await me. So... farewell for now, {playername}.\
 I hope I'll see you again soon.", "close_window", []],


 
  [anyone, "event_triggered", [
                     (store_conversation_troop, "$map_talk_troop"),
					 (is_between, "$map_talk_troop", companions_begin, companions_end),
					 
                     (eq, "$map_talk_troop", "$npc_with_political_grievance"), 
                     (eq, "$npc_map_talk_context", slot_troop_kingsupport_objection_state), 

					 (store_sub, ":npc_no", "$g_talk_troop", "trp_npc1"),
					 (store_add, ":string", "str_npc1_kingsupport_objection", ":npc_no"),
#					 (troop_get_slot, ":string", "$map_talk_troop", slot_troop_kingsupport_objection_string),
                     (str_store_string, 21, ":string"),
                     ],
   "{s21}", "companion_political_grievance_response", [
                    (assign, "$npc_with_political_grievance", 0),
					(troop_set_slot, "$map_talk_troop", slot_troop_kingsupport_objection_state, 2),
					
       ]],

  [anyone|plyr, "companion_political_grievance_response", [
#                    (eq, "$npc_praise_not_complaint", 0),
      ],  "Your opinion is noted.", "close_window", [
                    (troop_get_slot, ":grievance", "$map_talk_troop", slot_troop_morality_penalties),
                    (val_add, ":grievance", 25),
                    (troop_set_slot, "$map_talk_troop", slot_troop_morality_penalties, ":grievance"),
          ]],


		  
  [anyone, "event_triggered", [
                     (store_conversation_troop, "$map_talk_troop"),
					 (is_between, "$map_talk_troop", companions_begin, companions_end),
					 
                     (eq, "$map_talk_troop", "$npc_to_rejoin_party"), 
					 (neg|main_party_has_troop, "$map_talk_troop"),
					 
                     (troop_slot_eq, "$map_talk_troop", slot_troop_current_mission, npc_mission_rejoin_when_possible),
					 (troop_slot_eq, "$map_talk_troop", slot_troop_occupation, slto_player_companion),
					 (troop_get_slot, ":string", "$map_talk_troop", slot_troop_honorific),
                     (str_store_string, 21, ":string"),
					 ],
	"Greetings, {s21}. Are you ready for me to rejoin you?"	,			 
					 "companion_rejoin_response",
					[
                    (assign, "$npc_to_rejoin_party", 0),
					]],
					
  [anyone, "event_triggered", [
                     (store_conversation_troop, "$map_talk_troop"),
					 (is_between, "$map_talk_troop", companions_begin, companions_end),					 
					 
                     (eq, "$map_talk_troop", "$npc_to_rejoin_party"), 
#                     (eq, "$npc_map_talk_context", slot_troop_days_on_mission), 
                     (troop_slot_eq, "$g_talk_troop", slot_troop_current_mission, npc_mission_kingsupport), 
					 
					 (troop_get_slot, ":string", "$map_talk_troop", slot_troop_honorific),
                     (str_store_string, 21, ":string"),
                     ],
   "Well, {s21}, at last I've found you. I've been out spreading the word about your claim, and am now ready to rejoin the company.", "companion_rejoin_response", [
                    (assign, "$npc_to_rejoin_party", 0),
					(call_script, "script_change_player_right_to_rule", 3),
					(troop_set_slot, "$g_talk_troop", slot_troop_kingsupport_state, 1),
					
					(try_begin),
						(is_between, "$player_right_to_rule", 10, 15),
						(call_script, "script_add_log_entry", logent_player_claims_throne_1, "trp_player", 0, 0, 0),
					(else_try),
						(is_between, "$player_right_to_rule", 20, 25),
						(call_script, "script_add_log_entry", logent_player_claims_throne_2, "trp_player", 0, 0, 0),
					(try_end),
					]],

					
	[anyone, "event_triggered", [
	    (store_conversation_troop, "$map_talk_troop"),
		(is_between, "$map_talk_troop", companions_begin, companions_end),		
	    (eq, "$map_talk_troop", "$npc_to_rejoin_party"), 
	#                     (eq, "$npc_map_talk_context", slot_troop_days_on_mission), 
	    (troop_slot_eq, "$map_talk_troop", slot_troop_current_mission, npc_mission_gather_intel), 
						 
		(troop_get_slot, ":string", "$map_talk_troop", slot_troop_honorific),
	    (str_store_string, 21, ":string"),
		
		(troop_get_slot, ":town_with_contacts", "$map_talk_troop", slot_troop_town_with_contacts),			
		(store_faction_of_party, ":town_faction", ":town_with_contacts"),

		(call_script, "script_update_faction_political_notes", ":town_faction"),
		(assign, ":instability_index", reg0),
		(val_add, ":instability_index", reg0),
		(val_add, ":instability_index", reg1),

		
		(str_store_faction_name, s12, ":town_faction"),
		(try_begin),
			(ge, ":instability_index", 60),
			(str_store_string, s11, "str_the_s12_is_a_labyrinth_of_rivalries_and_grudges_lords_ignore_their_lieges_summons_and_many_are_ripe_to_defect"),
		(else_try),	
			(ge, ":instability_index", 40),
			(str_store_string, s11, "str_the_s12_is_shaky_many_lords_do_not_cooperate_with_each_other_and_some_might_be_tempted_to_defect_to_a_liege_that_they_consider_more_worthy"),
		(else_try),	
			(ge, ":instability_index", 20),
			(str_store_string, s11, "str_the_s12_is_fairly_solid_some_lords_bear_enmities_for_each_other_but_they_tend_to_stand_together_against_outside_enemies"),
		(else_try),	
			(str_store_string, s11, "str_the_s12_is_a_rock_of_stability_politically_speaking_whatever_the_lords_may_think_of_each_other_they_fight_as_one_against_the_common_foe"),
		(try_end),

		(try_for_range, ":lord", active_npcs_begin, active_npcs_end),
			(troop_slot_eq, ":lord", slot_troop_occupation, slto_kingdom_hero),
			(store_faction_of_troop, ":lord_faction", ":lord"),
			(eq, ":lord_faction", ":town_faction"),
			(call_script, "script_update_troop_political_notes", ":lord"),
		(try_end),		
		
	    ],
	   "Well, {s21}, at last I've found you. {s11}. The rest of my report I submit to you in writing.", "companion_rejoin_response", [
		]],
					

					
  [anyone, "event_triggered", [
                     (store_conversation_troop, "$map_talk_troop"),
					 (is_between, "$map_talk_troop", companions_begin, companions_end),
					 
                     (eq, "$map_talk_troop", "$npc_to_rejoin_party"), 
#                     (eq, "$npc_map_talk_context", slot_troop_days_on_mission), 
                     (troop_get_slot, ":mission", "$g_talk_troop", slot_troop_current_mission), 
					 (this_or_next|eq, ":mission", npc_mission_peace_request),
					 (this_or_next|eq, ":mission", npc_mission_pledge_vassal),
					 (this_or_next|eq, ":mission", npc_mission_test_waters),
					 (this_or_next|eq, ":mission", npc_mission_non_aggression),
						(eq, ":mission", npc_mission_seek_recognition),
						
					 (troop_get_slot, ":string", "$map_talk_troop", slot_troop_honorific),
                     (str_store_string, 21, ":string"),
					 (troop_get_slot, ":mission_object", "$g_talk_troop", slot_troop_mission_object),
					 (str_store_faction_name, s31, ":mission_object"),
					 
					 (call_script, "script_npc_decision_checklist_peace_or_war", ":mission_object", "fac_player_supporters_faction", "$g_talk_troop"),
					 (assign, "$g_mission_result", reg0),

					 
                     ],
   "Well, {s21}, at last I've found you. I have returned from my mission to {s31}. In general, I would say, {s14}.","companion_embassy_results", [
					]],

  [anyone, "companion_embassy_results", [
                   (troop_slot_eq, "$g_talk_troop", slot_troop_current_mission, npc_mission_seek_recognition), 
				   (troop_get_slot, ":mission_object", "$g_talk_troop", slot_troop_mission_object),
				   
				   (this_or_next|ge, "$g_mission_result", 2),
						(faction_slot_eq, ":mission_object", slot_faction_recognized_player, 1),
					
				   (is_between, "$g_player_court", centers_begin, centers_end),
				   
				   (faction_get_slot, ":emissary_object", ":mission_object", slot_faction_leader),
				   (str_store_troop_name, s12, ":emissary_object"),
				   (neg|party_slot_eq, "$g_player_court", slot_center_original_faction, ":mission_object"),
				   (str_store_party_name, s4, "$g_player_court"),
  ],					
   "In this letter, {s12} addresses you as {Lord/Lady} of {s4}, which implies some sort of recognition that you are a sovereign and independent monarch.","companion_rejoin_response", [
   				   (troop_get_slot, ":mission_object", "$g_talk_troop", slot_troop_mission_object),
				   (try_begin),
						(faction_slot_eq, ":mission_object", slot_faction_recognized_player, 0),
						(faction_set_slot, ":mission_object", slot_faction_recognized_player, 1),
						(call_script, "script_change_player_right_to_rule", 10),
				   (try_end),
					]],


					
  [anyone, "companion_embassy_results", [
                    (troop_slot_eq, "$g_talk_troop", slot_troop_current_mission, npc_mission_seek_recognition), 
				   (troop_get_slot, ":mission_object", "$g_talk_troop", slot_troop_mission_object),
				   (faction_get_slot, ":emissary_object", ":mission_object", slot_faction_leader),
				   (str_store_troop_name, s12, ":emissary_object"),
					
  ],					
   "In his letter, {s12} merely refers to you as {playername}, omitting any title. This does not constitute recognition of your right to rule.","companion_rejoin_response", [
					]],

  [anyone, "companion_embassy_results", [
                    (troop_slot_eq, "$g_talk_troop", slot_troop_current_mission, npc_mission_peace_request),
					(troop_get_slot, ":mission_object", "$g_talk_troop", slot_troop_mission_object),
					(faction_slot_ge, ":mission_object", slot_faction_truce_days_with_factions_begin, 1),
				   (faction_get_slot, ":emissary_object", ":mission_object", slot_faction_leader),
				   (str_store_troop_name, s12, ":emissary_object"),
					
  ],					
   "{s12} says that your current truce should suffice.","companion_rejoin_response", [
					]],
					
					
  [anyone, "companion_embassy_results", [
                    (troop_slot_eq, "$g_talk_troop", slot_troop_current_mission, npc_mission_peace_request), 
					(ge, "$g_mission_result", 1),
				   (troop_get_slot, ":mission_object", "$g_talk_troop", slot_troop_mission_object),
				   (faction_get_slot, ":emissary_object", ":mission_object", slot_faction_leader),
				   (str_store_troop_name, s12, ":emissary_object"),
					
  ],					
   "{s12} says that he is willing to consider a truce of forty days.","companion_truce_confirm", [
					]],

  [anyone, "companion_embassy_results", [
                   (troop_slot_eq, "$g_talk_troop", slot_troop_current_mission, npc_mission_peace_request), 
				   (troop_get_slot, ":mission_object", "$g_talk_troop", slot_troop_mission_object),
				   (faction_get_slot, ":emissary_object", ":mission_object", slot_faction_leader),
				   (str_store_troop_name, s12, ":emissary_object"),
					
  ],					
   "{s12} says that he is unwilling to conclude a peace.","companion_rejoin_response", [
					]],
					

  [anyone|plyr, "companion_truce_confirm", [
	(troop_get_slot, ":mission_object", "$g_talk_troop", slot_troop_mission_object),
	(str_store_faction_name, s4, ":mission_object"),
  ],					
   "Very well - let this truce with the {s4} be concluded.","companion_rejoin_response", [
	(troop_get_slot, ":mission_object", "$g_talk_troop", slot_troop_mission_object),
    (call_script, "script_diplomacy_start_peace_between_kingdoms", ":mission_object", "$players_kingdom", 1), 
	(str_store_faction_name, s4, ":mission_object"),
	]],

  [anyone|plyr, "companion_truce_confirm", [],					
   "On second thought, perhaps this is currently not in our interests.","companion_rejoin_response", [
					]],


  [anyone, "companion_embassy_results", [
                    (troop_slot_eq, "$g_talk_troop", slot_troop_current_mission, npc_mission_pledge_vassal),
#					(troop_get_slot, ":mission_object", "$g_talk_troop", slot_troop_mission_object),
					(this_or_next|check_quest_active, "qst_join_faction"),
						(is_between, "$players_kingdom", npc_kingdoms_begin, npc_kingdoms_end),
				   (troop_get_slot, ":mission_object", "$g_talk_troop", slot_troop_mission_object),
				   (faction_get_slot, ":emissary_object", ":mission_object", slot_faction_leader),
				   (str_store_troop_name, s12, ":emissary_object"),
						
  ],					
   "{s12} says that you are already pledged to another ruler.","companion_rejoin_response", [
					]],
					
  [anyone, "companion_embassy_results", [
                    (troop_slot_eq, "$g_talk_troop", slot_troop_current_mission, npc_mission_pledge_vassal),
#					(troop_get_slot, ":mission_object", "$g_talk_troop", slot_troop_mission_object),
					(lt, "$g_mission_result", -2),
				   (troop_get_slot, ":mission_object", "$g_talk_troop", slot_troop_mission_object),
				   (faction_get_slot, ":emissary_object", ":mission_object", slot_faction_leader),
				   (str_store_troop_name, s12, ":emissary_object"),
					
  ],					
   "{s12} says that he does not believe that you would honor your obligations as a vassal, and suspects that your offer is just a ploy.","companion_rejoin_response", [
					]],

  [anyone, "companion_embassy_results", [
                    (troop_slot_eq, "$g_talk_troop", slot_troop_current_mission, npc_mission_pledge_vassal),
				   (troop_get_slot, ":mission_object", "$g_talk_troop", slot_troop_mission_object),
				   (faction_get_slot, ":emissary_object", ":mission_object", slot_faction_leader),
				   (str_store_troop_name, s12, ":emissary_object"),
					
  ],					
   "{s12} says that he accepts your offer of vassalage. He will give you 30 days to seek him out, in which time he will refrain from making war on you.","vassalage_offer_confirm", [
					]],
					
  [anyone|plyr, "vassalage_offer_confirm", [],					
   "Tell him that I accept his terms...", "companion_rejoin_response", [
   
		(troop_get_slot, "$g_invite_faction", "$g_talk_troop", slot_troop_mission_object),
		(faction_get_slot, "$g_invite_faction_lord", "$g_invite_faction", slot_faction_leader),

		(str_store_troop_name,s1,"$g_invite_faction_lord"),
        (setup_quest_text,"qst_join_faction"),

        (str_store_troop_name_link, s3, "$g_invite_faction_lord"),
        (str_store_faction_name_link, s4, "$g_invite_faction"),
        (quest_set_slot, "qst_join_faction", slot_quest_giver_troop, "$g_invite_faction_lord"),
        (quest_set_slot, "qst_join_faction", slot_quest_expiration_days, 30),
		
		(try_begin),
			(store_relation, ":relation", "$g_invite_faction", "fac_player_supporters_faction"),
			(lt, ":relation", 0),
			(call_script, "script_diplomacy_start_peace_between_kingdoms", "$g_invite_faction", "fac_player_supporters_faction", 0),
			(quest_set_slot, "qst_join_faction", slot_quest_failure_consequence, 1),
		(try_end),
		
        (str_store_string, s2, "@Find and speak with {s3} of {s4} to give him your oath of homage."),
        (call_script, "script_start_quest", "qst_join_faction", "$g_invite_faction_lord"),
        (call_script, "script_report_quest_troop_positions", "qst_join_faction", "$g_invite_faction_lord", 3),
		]],	



		

					
					
  [anyone|plyr, "companion_rejoin_response", [
	(hero_can_join, "p_main_party"),
	(neg|main_party_has_troop, "$map_talk_troop"),
      ],  "Welcome back, friend!", "close_window", [
        (party_add_members, "p_main_party", "$map_talk_troop", 1),
		(assign, "$npc_to_rejoin_party", 0),
        (troop_set_slot, "$map_talk_troop", slot_troop_current_mission, 0), 
		(troop_set_slot, "$map_talk_troop", slot_troop_days_on_mission, 0),
          ]],

  [anyone|plyr, "companion_rejoin_response", [
      ],  "Unfortunately, I cannot take you back just yet.", "companion_rejoin_refused", [
        (troop_set_slot, "$map_talk_troop", slot_troop_current_mission, npc_mission_rejoin_when_possible), 
		(troop_set_slot, "$map_talk_troop", slot_troop_days_on_mission, 0),
		(assign, "$npc_to_rejoin_party", 0),
          ]],

  [anyone, "companion_rejoin_refused", [
      ],  "As you wish. I will take care of some business, and try again in a few days.", "close_window", [
          ]],

		  
  [anyone, "event_triggered", [
	(is_between, "$g_talk_troop", companions_begin, companions_end),
	(neg|troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_hero),
	(neg|main_party_has_troop, "$g_talk_troop"),
                     ],
   "Would you have me rejoin you?", "companion_rejoin_response", [
    (assign, "$map_talk_troop", "$g_talk_troop"),
       ]],

#caravan merchants
  [anyone, "event_triggered",  
   [(eq, "$caravan_escort_state",1),
    (eq, "$g_encountered_party","$caravan_escort_party_id"),
    (le, "$talk_context",tc_party_encounter),
    (store_distance_to_party_from_party, reg0, "$caravan_escort_destination_town", "$caravan_escort_party_id"),
    (lt, reg0, 5),
    (str_store_party_name, s3, "$caravan_escort_destination_town"),
    (assign, reg3, "$caravan_escort_agreed_reward"),
    ],
   "There! I can see the walls of {s3} in the distance. We've made it safely.\
 Here, take this purse of {reg3} denars, as I promised. I hope we can travel together again someday.", "close_window",
   [
    (assign,"$caravan_escort_state",0),
    (call_script, "script_troop_add_gold", "trp_player", "$caravan_escort_agreed_reward"),
    (assign,reg(4), "$caravan_escort_agreed_reward"),
    (val_mul,reg(4), 1),
    (add_xp_as_reward,reg(4)),
    (assign, "$g_leave_encounter",1),
    ]],
 
  [anyone, "event_triggered", [
                     ],
   "{!}Sorry -- just talking to myself [ERROR- {s51}]", "close_window", [
       ]],






#KINGDOM LORD DIALOGS BEGINS HERE




#FEMALE PLAYER CHACTER WEDDING (also go to the feast, 'lift a glass' speeches for npc lords)
#Feast not yet organized  
  [anyone, "start", [
  (lt, "$talk_context", tc_siege_commander),
  
  (check_quest_active, "qst_wed_betrothed_female"),
  (quest_slot_eq, "qst_wed_betrothed_female", slot_quest_giver_troop, "$g_talk_troop"),
  (neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_feast),
  
  (store_current_hours, ":hours_since_betrothal"),
  (troop_get_slot, ":betrothal_time", "$g_talk_troop", slot_troop_betrothal_time),
  (val_sub, ":hours_since_betrothal", ":betrothal_time"),
  (lt, ":hours_since_betrothal", 720), #30 days
  (str_clear, s12),
  (try_begin),
	(neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_feast),
	(neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_default),
    (str_store_string, s12, "@ We will of course need to wait until the realm is no longer on campaign."),
  (try_end),
  ],
   "My lady, I look forward to our marriage, as soon as there is an opportunity to hold a proper feast.{s12}", "lord_start", [
   ]],

#Feast, but not at the venue  
  [anyone, "start", [
  (lt, "$talk_context", tc_siege_commander),
  
  (check_quest_active, "qst_wed_betrothed_female"),
  (quest_slot_eq, "qst_wed_betrothed_female", slot_quest_giver_troop, "$g_talk_troop"),
  (faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_feast),
  (faction_get_slot, ":feast_venue", "$g_talk_troop_faction", slot_faction_ai_object),
  (party_slot_eq, "$g_talk_troop_party", slot_party_ai_state, spai_holding_center),
  (party_slot_eq, "$g_talk_troop_party", slot_party_ai_object, ":feast_venue"),
  
  (neq, ":feast_venue", "$g_encountered_party"),
  (str_store_party_name, s4, ":feast_venue"),
  ],
   "My lady, if you wish to marry, we can proceed to the feast at {s4} to exchange vows before the lords of the realm.", "lord_start", [
   ]],

#Over a month, and heading to a center  
  [anyone, "start", [
  (lt, "$talk_context", tc_siege_commander),
  
  (check_quest_active, "qst_wed_betrothed_female"),
  (quest_slot_eq, "qst_wed_betrothed_female", slot_quest_giver_troop, "$g_talk_troop"),

  (store_current_hours, ":hours_since_betrothal"),
  (troop_get_slot, ":betrothal_time", "$g_talk_troop", slot_troop_betrothal_time),
  (val_sub, ":hours_since_betrothal", ":betrothal_time"),
  (ge, ":hours_since_betrothal", 720), #30 days

  (party_get_attached_to, ":attached", "$g_talk_troop_party"),
  (neg|is_between, ":attached", walled_centers_begin, walled_centers_end),

  (party_slot_eq, "$g_talk_troop_party", slot_party_ai_state, spai_holding_center),
  (party_get_slot, ":object", "$g_talk_troop_party", slot_party_ai_object),
  (str_store_party_name, s4, ":object"),
  ],
   "My lady, I grow tired of waiting for the lords of this realm to assemble. Come with me to {s4} exchange our vows.", "lord_start", [
   ]],

#Over a month, but not in a center  
  [anyone, "start", [
  (lt, "$talk_context", tc_siege_commander),
  (check_quest_active, "qst_wed_betrothed_female"),
  (quest_slot_eq, "qst_wed_betrothed_female", slot_quest_giver_troop, "$g_talk_troop"),

  (store_current_hours, ":hours_since_betrothal"),
  (troop_get_slot, ":betrothal_time", "$g_talk_troop", slot_troop_betrothal_time),
  (val_sub, ":hours_since_betrothal", ":betrothal_time"),
  (ge, ":hours_since_betrothal", 0), #30 days

  (party_get_attached_to, ":attached", "$g_talk_troop_party"),
  (neg|is_between, ":attached", walled_centers_begin, walled_centers_end),

  ],
   "My lady, I grow tired of waiting for the lords of this realm to assemble. Perhaps we should take the first opportunity to marry, in any great hall that is open to us.", "lord_start", [
   ]],

  [anyone, "start", [
  (lt, "$talk_context", tc_siege_commander),
  (check_quest_active, "qst_wed_betrothed_female"),
  (quest_slot_eq, "qst_wed_betrothed_female", slot_quest_giver_troop, "$g_talk_troop"),
  (this_or_next|neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_feast),
  (neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_object, "$g_encountered_party"),
  ],
   "My lady, I have grown tired of waiting. Let us proceed with the vows immediately.", "lord_groom_vows", [
   ]],
   
  [anyone, "start", [
  (lt, "$talk_context", tc_siege_commander),  
  (check_quest_active, "qst_wed_betrothed_female"),
  (quest_slot_eq, "qst_wed_betrothed_female", slot_quest_giver_troop, "$g_talk_troop"),
  ],
   "My lady, my eyes rejoice to see you. We may proceed with the vows.", "lord_groom_vows", [
   ]],

  [anyone, "lord_groom_vows", [
  ],
   "My lady, with this assembly as my witness, I vow to take you as my wife, to honor, cherish, and protect you. My the heavens bless us with health, prosperity, and children.", "female_pc_marriage_vow", [
   ]],
   
  [anyone|plyr, "female_pc_marriage_vow", [
  ],
   "I vow to take you as my husband.", "lord_groom_wedding_complete", [
   (call_script, "script_courtship_event_bride_marry_groom", "trp_player", "$g_talk_troop", 0),
   (call_script, "script_end_quest", "qst_wed_betrothed_female"),
   ]],
   
  [anyone|plyr, "female_pc_marriage_vow", [
  ],
   "Wait -- I need to think about this.", "close_window", [
   (assign, "$g_leave_encounter", 1),
   ]],
   
  [anyone, "lord_groom_wedding_complete", [
  ],
   "We are now husband and wife. Let the festivities commence!", "close_window",
   []],   

   
# KINGDOM LORD DUEL OUTCOMES
  [anyone,"start",
  [(eq, "$talk_context", tc_after_duel),
   (check_quest_active, "qst_denounce_lord"),
   (check_quest_succeeded, "qst_denounce_lord"),
   (quest_slot_eq, "qst_denounce_lord", slot_quest_target_troop, "$g_talk_troop"),
  ],
   "Very well. You've made your point. I have nothing more to say.", "close_window", [
   (call_script, "script_change_troop_renown", "trp_player", 10),
   (assign, "$g_leave_encounter", 1),
   ]],

  [anyone,"start",
  [(eq, "$talk_context", tc_after_duel),
   (check_quest_active, "qst_denounce_lord"),
   (check_quest_failed, "qst_denounce_lord"),
   (quest_slot_eq, "qst_denounce_lord", slot_quest_target_troop, "$g_talk_troop"),
  ],
   "Well, {sir/my lady}! Please, do not trouble yourself to rise from the ground, as I would simply have to knock you down again. I shall take your silence as an apology. Good day to you.", "close_window", [
   (call_script, "script_change_troop_renown", "trp_player", -10),
   (assign, "$g_leave_encounter", 1),
   ]],



  [anyone,"start",
  [(eq, "$talk_context", tc_after_duel),
   (assign, "$temp", 0),
   (try_begin),
     (check_quest_active, "qst_duel_avenge_insult"),
     (check_quest_succeeded, "qst_duel_avenge_insult"),
     (quest_slot_eq, "qst_duel_avenge_insult", slot_quest_target_troop, "$g_talk_troop"),
     (assign, "$temp", 1),
   (else_try),
     (check_quest_active, "qst_duel_for_lady"),
     (check_quest_succeeded, "qst_duel_for_lady"),
     (quest_slot_eq, "qst_duel_for_lady", slot_quest_target_troop, "$g_talk_troop"),
     (assign, "$temp", 2),
   (try_end),
   (gt, "$temp", 0),
  ],
   "Very well. You've made your point. I retract what I said. I hope you have obtained satisfaction.", "close_window", [
   (try_begin),
     (eq, "$temp", 1),
     (call_script, "script_change_troop_renown", "trp_player", 10),
     (call_script, "script_end_quest", "qst_duel_avenge_insult"),
   (try_end),
   (assign, "$g_leave_encounter", 1),
   ]],

   [anyone,"start",
  [(eq, "$talk_context", tc_after_duel),
   (assign, "$temp", 0),
   (try_begin),
     (check_quest_active, "qst_duel_avenge_insult"),
     (check_quest_failed, "qst_duel_avenge_insult"),
     (quest_slot_eq, "qst_duel_avenge_insult", slot_quest_target_troop, "$g_talk_troop"),
     (assign, "$temp", 1),
   (else_try),
     (check_quest_active, "qst_duel_for_lady"),
     (check_quest_failed, "qst_duel_for_lady"),
     (quest_slot_eq, "qst_duel_for_lady", slot_quest_target_troop, "$g_talk_troop"),
     (assign, "$temp", 2),
   (try_end),
   (gt, "$temp", 0),
  ],
   "Hah! Not so gallant now, are we? Now trouble me no more.", "close_window", [
   (try_begin),
     (eq, "$temp", 1),
     (call_script, "script_change_troop_renown", "trp_player", -10),
     (call_script, "script_end_quest", "qst_duel_avenge_insult"),
   (try_end),
   (assign, "$g_leave_encounter", 1),
   ]],
   
  [anyone,"start",
  [(eq, "$talk_context", tc_after_duel),
   (check_quest_active, "qst_duel_courtship_rival"),
   (check_quest_succeeded, "qst_duel_courtship_rival"),
   (quest_slot_eq, "qst_duel_courtship_rival", slot_quest_target_troop, "$g_talk_troop"),
   (quest_get_slot, ":duel_object", "qst_duel_courtship_rival", slot_quest_giver_troop),
   (str_store_troop_name, s10, ":duel_object"),
  ],
   "Very well -- you have won. Let all those present today witness that you have defeated me, and I shall abandon my suit of {s10}. Are you satisfied, you heartless bastard?", "close_window", [
	(quest_get_slot, ":duel_object", "qst_duel_courtship_rival", slot_quest_giver_troop),
	(call_script, "script_courtship_event_lady_break_relation_with_suitor", ":duel_object", "$g_talk_troop"),
	(assign, "$g_leave_encounter", 1),
   ]],
   
   
  [anyone,"start",
  [(eq, "$talk_context", tc_after_duel),
   (check_quest_active, "qst_duel_courtship_rival"),
   (check_quest_failed, "qst_duel_courtship_rival"),
   (quest_slot_eq, "qst_duel_courtship_rival", slot_quest_target_troop, "$g_talk_troop"),
   (quest_get_slot, ":duel_object", "qst_duel_courtship_rival", slot_quest_giver_troop),
   (str_store_troop_name, s10, ":duel_object"),
  ],
   "Get up. Let all those present today witness that I have defeated you, and you are now bound to relinquish your suit of the {s10}. I will permit you one final visit, to make your farewells. After that, if you persist in attempting to see her, everyone shall know that you are a man of scant honor.", "close_window", [
   (assign, "$g_leave_encounter", 1),
   ]],
   
   
   
  [anyone,"start", [(eq, "$talk_context", tc_castle_commander)],
   "What do you want?", "player_siege_castle_commander_1", []],
  [anyone|plyr,"player_siege_castle_commander_1", [],
   "Surrender! Your situation is hopeless!", "player_siege_ask_surrender", []],
  [anyone|plyr,"player_siege_castle_commander_1", [], "Nothing. I'll leave you now.", "close_window", []],

  
  [anyone,"player_siege_ask_surrender", [(lt, "$g_enemy_strength", 100), (store_mul,":required_str","$g_enemy_strength",5),(ge, "$g_ally_strength", ":required_str")],
   "Perhaps... Do you give your word of honour that we'll be treated well?", "player_siege_ask_surrender_treatment", []],
  [anyone,"player_siege_ask_surrender", [(lt, "$g_enemy_strength", 200), (store_mul,":required_str","$g_enemy_strength",3),(ge, "$g_ally_strength", ":required_str")],
   "We are ready to leave this castle to you and march away if you give me your word of honour that you'll let us leave unmolested.", "player_siege_ask_leave_unmolested", []],
  [anyone,"player_siege_ask_surrender", [],
   "Surrender? Hah! We can hold these walls until we all die of old age.", "close_window", []],

  
  [anyone|plyr,"player_siege_ask_surrender_treatment", [],
   "I give you nothing. Surrender now or prepare to die!", "player_siege_ask_surrender_treatment_reject", []],
  [anyone,"player_siege_ask_surrender_treatment_reject", [],
   "Bastard. We will fight you to the last man!", "close_window", []],
  [anyone|plyr,"player_siege_ask_surrender_treatment", [],
   "You will be ransomed and your soldiers will live. I give you my word.", "player_siege_ask_surrender_treatment_accept", []],
  [anyone,"player_siege_ask_surrender_treatment_accept", [],
   "Very well then. Under those terms, I offer you my surrender.", "close_window", [(assign,"$g_enemy_surrenders",1)]],

  [anyone|plyr,"player_siege_ask_leave_unmolested", [],
   "You have my word. You will not come under attack if you leave the castle.", "player_siege_ask_leave_unmolested_accept", []],
  [anyone,"player_siege_ask_leave_unmolested_accept", [],
   "Very well. Then we leave this castle to you. You have won this day. But we'll meet again.", "close_window", [(assign,"$g_castle_left_to_player",1)]],
  [anyone|plyr,"player_siege_ask_leave_unmolested", [],
   "Unacceptable. I want prisoners.", "player_siege_ask_leave_unmolested_reject", []],
  [anyone,"player_siege_ask_leave_unmolested_reject", [],
   "Then we will defend this castle to the death, and this parley is done. Farewell.", "close_window", []],


#Prison break

  [anyone|plyr,"lord_prison_break", [],
   "I've come to get you out of here", "lord_prison_break_confirm",
   []],
   
  [anyone|plyr,"lord_prison_break", [],
   "Never mind -- just stay quiet", "close_window",
   [
   (troop_set_slot, "$g_talk_troop", slot_troop_mission_participation, mp_stay_out),
   (assign, "$g_reset_mission_participation", 1),
   ]],
   
  [anyone,"lord_prison_break_confirm", [],
   "Thank the heavens! I don't know how long I could have lasted in here", "lord_prison_break_confirm_2",
   []],

  [anyone,"lord_prison_break_confirm_2", [],
   "But wait -- how will we escape? We'll be rushed by the garrison the moment we step out that door. I can help you hold them off -- but I'll tell you now, they have fed me nothing but watery porridge and a few scraps, and I'm not as strong as I could be.", "lord_prison_break_confirm_3",
   []],

  [anyone|plyr,"lord_prison_break_confirm_3", [],
   "You keep well behind me, and try to stay out of the fighting.", "lord_prison_break_confirm_4",
   [
   (troop_set_slot, "$g_talk_troop", slot_troop_mission_participation, mp_prison_break_stand_back),
   (assign, "$g_reset_mission_participation", 1),
   (agent_set_team, "$g_talk_agent", 0),
   ]],

  [anyone|plyr,"lord_prison_break_confirm_3", [],
   "I'll need you to grab a weapon and help me, despite your weakness.", "lord_prison_break_confirm_4",
   [
   (troop_set_slot, "$g_talk_troop", slot_troop_mission_participation, mp_prison_break_fight),
   (assign, "$g_reset_mission_participation", 1),
   (agent_set_team, "$g_talk_agent", 0),
   ]],
   
  [anyone|plyr,"lord_prison_break_confirm_3", [],
   "Actually, don't get involved in this.", "close_window",
   [
   (troop_set_slot, "$g_talk_troop", slot_troop_mission_participation, mp_stay_out),
   (assign, "$g_reset_mission_participation", 1),
   ]],
   
   
  [anyone,"lord_prison_break_confirm_4", [
  
  (str_clear, s14),
  (try_for_range, ":other_prisoner", active_npcs_begin, kingdom_ladies_end),        
	(troop_slot_eq, ":other_prisoner", slot_troop_prisoner_of_party, "$g_encountered_party"),	
	(neq, ":other_prisoner", "$g_talk_troop"),
	
	(assign, ":granted_parole", 0),
	(try_begin),
		(call_script, "script_cf_prisoner_offered_parole", ":other_prisoner"),
		(assign, ":granted_parole", 1),
	(try_end),
	(eq, ":granted_parole", 0),
	
	(troop_slot_eq, ":other_prisoner", slot_troop_mission_participation, 0),
	
	(str_store_troop_name, s15, ":other_prisoner"),
	
	(troop_get_type, reg4, ":other_prisoner"),
	(str_store_string, s14, "str__s15_is_also_being_held_here_and_you_may_wish_to_see_if_reg4shehe_will_join_us"), 
  (try_end),
  ],
   "Let's go!{s14}", "close_window",
   []],
   
   

   
#After battle texts
  
  [anyone,"start", [
    (eq, "$talk_context", tc_hero_freed), 
    (troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_hero)],
   "I am in your debt for freeing me, friend.", "freed_lord_answer",
   [
     (try_begin),
       (check_quest_active, "qst_rescue_lord_by_replace"),
       (quest_slot_eq, "qst_rescue_lord_by_replace", slot_quest_target_troop, "$g_talk_troop"),
       (call_script, "script_succeed_quest", "qst_rescue_lord_by_replace"),
       (assign, "$do_not_cancel_quest", 1),
     (try_end),  
     
     (try_begin),
       (check_quest_active, "qst_rescue_prisoner"),
       (quest_slot_eq, "qst_rescue_prisoner", slot_quest_target_troop, "$g_talk_troop"),
       (call_script, "script_succeed_quest", "qst_rescue_prisoner"),
       (assign, "$do_not_cancel_quest", 1),
     (try_end),  
            
     (call_script, "script_remove_troop_from_prison", "$g_talk_troop"),
     (assign, "$do_not_cancel_quest", 0),
   ]],

  [anyone|plyr,"freed_lord_answer", [(lt, "$g_talk_troop_faction_relation", 0)],
   "You're not going anywhere, 'friend'. You're my prisoner now.", "freed_lord_answer_1",
   [#(troop_set_slot, "$g_talk_troop", slot_troop_is_prisoner, 1),
    (troop_set_slot, "$g_talk_troop", slot_troop_prisoner_of_party, "p_main_party"),
    (party_force_add_prisoners, "p_main_party", "$g_talk_troop", 1),
    (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", -30),
    (call_script, "script_change_player_relation_with_faction_ex", "$g_talk_troop_faction", -2),
    (call_script, "script_event_hero_taken_prisoner_by_player", "$g_talk_troop"),
    ]],#take prisoner

  [anyone,"freed_lord_answer_1", [],
   "I'll have your head on a pike for this, you bastard! Someday!", "close_window", []],

  [anyone|plyr,"freed_lord_answer", [
  ],
   "You are free to go wherever you want, sir.", "freed_lord_answer_2",
   [(call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 7),
    (call_script, "script_change_player_honor", 2),
#    (troop_get_slot, ":cur_rank", "$g_talk_troop", slot_troop_kingdom_rank),
#    (val_mul, ":cur_rank", 1),
    (call_script, "script_change_player_relation_with_faction_ex", "$g_talk_troop_faction", 2)]],

  [anyone,"freed_lord_answer_2", [],
   "Thank you, good {sire/lady}. I never forget someone who's done me a good turn.", "close_window",
   [
   (assign, "$g_leave_encounter", 1), #Not sure why this is necessary
   ]],

##  [anyone|plyr,"freed_lord_answer", [(neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"), #he is not a faction leader!
##                                     (call_script, "script_get_number_of_hero_centers", "$g_talk_troop"),
##                                     (eq, reg0, 0), #he has no castles or towns
##                                     (hero_can_join)],
##   "I need capable men like you. Would you like to join me?", "knight_offer_join",
##   []],
##
##  [anyone,"freed_lord_answer_3", [(store_random_in_range, ":random_no",0,2),(eq, ":random_no", 0)],
##   "Alright I will join you.", "close_window",
##   [
###     (troop_set_slot, "$g_talk_troop", slot_troop_is_player_companion, 1),
##     (troop_set_slot, "$g_talk_troop", slot_troop_occupation, slto_player_companion),
##     (store_conversation_troop, ":cur_troop_id"), 
##     (party_add_members, "p_main_party", ":cur_troop_id", 1),#join hero
##   ]],
##
##  [anyone,"freed_lord_answer_3", [],
##   "No, I want to go on my own.", "close_window", []],


#Troop commentary changes begin
  [anyone,"start", [(eq,"$talk_context",tc_hero_defeated),
                    (troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_hero)],
   "{s43}", "defeat_lord_answer",
   [(troop_set_slot, "$g_talk_troop", slot_troop_leaded_party, -1),
    (call_script, "script_lord_comment_to_s43", "$g_talk_troop", "str_surrender_offer_default"),
    ]],

  [anyone|plyr,"defeat_lord_answer", [],
   "You are my prisoner now.", "defeat_lord_answer_1",
   [
     #(troop_set_slot, "$g_talk_troop", slot_troop_is_prisoner, 1),
     (troop_set_slot, "$g_talk_troop", slot_troop_prisoner_of_party, "p_main_party"),
     (party_force_add_prisoners, "p_main_party", "$g_talk_troop", 1),#take prisoner
     (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", -3),
     (call_script, "script_change_player_relation_with_faction_ex", "$g_talk_troop_faction", -3),
     (call_script, "script_event_hero_taken_prisoner_by_player", "$g_talk_troop"),
     (call_script, "script_add_log_entry", logent_lord_captured_by_player, "trp_player",  -1, "$g_talk_troop", "$g_talk_troop_faction"),
     ]],

  [anyone,"defeat_lord_answer_1", [],
   "I am at your mercy.", "close_window", []],

  [anyone|plyr,"defeat_lord_answer", [],
   "You have fought well. You are free to go.", "defeat_lord_answer_2",
   [(call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 5),
    (call_script, "script_change_player_honor", 3),
    (call_script, "script_add_log_entry", logent_lord_defeated_but_let_go_by_player, "trp_player",  -1, "$g_talk_troop", "$g_talk_troop_faction")]],

  [anyone,"defeat_lord_answer_2", [],
   "{s43}", "close_window", [
    (call_script, "script_lord_comment_to_s43", "$g_talk_troop", "str_prisoner_released_default"),
       ]],
#Troop commentary changes end

#Troop commentaries changes begin
  [anyone,"start", [(eq,"$talk_context",tc_party_encounter),
                    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_hero),
                    (lt,"$g_encountered_party_relation",0),
                    (encountered_party_is_attacker),
                    (eq, "$g_talk_troop_met", 1),                    ],
   "{playername}!", "party_encounter_lord_hostile_attacker", [
                    ]],

  [anyone,"start", [(eq,"$talk_context",tc_party_encounter),
                    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_hero),
                    (lt,"$g_encountered_party_relation",0),
                    (encountered_party_is_attacker),                ],
   "Halt!", "party_encounter_lord_hostile_attacker", [
                    ]],

  [anyone,"party_encounter_lord_hostile_attacker", [
      (gt, "$g_comment_found", 0),
                    ],
   "{s42}", "party_encounter_lord_hostile_attacker", [
                         (try_begin),
                           (neq, "$log_comment_relation_change", 0),
                           (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", "$log_comment_relation_change"),
                         (try_end),
                         (assign, "$g_comment_found", 0),
                    ]],

#Troop commentaries changes end
  [anyone,"party_encounter_lord_hostile_attacker", [
                    ],
   "{s43}", "party_encounter_lord_hostile_attacker_2",
   [
    (call_script, "script_lord_comment_to_s43", "$g_talk_troop", "str_surrender_demand_default"),
       ]],

  [anyone|plyr,"party_encounter_lord_hostile_attacker_2", [
                    ],
   "We will fight you to the end!", "close_window", []],

  [anyone|plyr,"party_encounter_lord_hostile_attacker_2", [
	(is_between, "$g_talk_troop", active_npcs_begin, active_npcs_end),
	(neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
                    ],
   "Stay your hand! There is something I must tell you in private.", "lord_recruit_1_relation", []],

  [anyone|plyr,"party_encounter_lord_hostile_attacker_2", [
                    ],
   "Is there no way to avoid this battle? I don't want to fight with you.", "party_encounter_offer_dont_fight", []],
  
#TODO: Add a verification step.
  [anyone|plyr,"party_encounter_lord_hostile_attacker_2", [
                    ],
   "Don't attack! We surrender.", "close_window", [(assign,"$g_player_surrenders",1)]],

  [anyone, "party_encounter_offer_dont_fight", [(gt, "$g_talk_troop_effective_relation", 30),
#TODO: Add adition conditions, lord personalities, battle advantage, etc...                                                
                    ],
   "I owe you a favor, don't I. Well... all right then. I will let you go just this once.", "close_window", [
    (call_script, "script_change_player_relation_with_troop","$g_talk_troop", -7),
    (store_current_hours,":protected_until"),
    (val_add, ":protected_until", 72),
    (party_set_slot,"$g_encountered_party",slot_party_ignore_player_until,":protected_until"),
    (party_ignore_player, "$g_encountered_party", 72),
    (assign, "$g_leave_encounter",1)
       ]],
  
  [anyone, "party_encounter_offer_dont_fight", [
	(call_script, "script_lord_comment_to_s43", "$g_talk_troop", "str_lord_declines_negotiation_offer_default"),
                    ],
   "{s43}", "close_window", []],
  
##  [anyone,"start", [(eq,"$talk_context",tc_party_encounter),
##                    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_hero),
##                    (lt,"$g_encountered_party_relation",0),
##                    (neg|encountered_party_is_attacker),
##                    ],
##   "What do you want?", "party_encounter_lord_hostile_defender",
##   []],


#  [anyone|plyr,"party_encounter_lord_hostile_defender", [],
#   "Nothing. We'll leave you in peace.", "close_window", [(assign, "$g_leave_encounter",1)]],



 
#Betrayal texts should go here


##  [anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_hero),
##                     (troop_slot_eq,"$g_talk_troop",slot_troop_last_quest_betrayed, 1),
##                     (troop_slot_eq,"$g_talk_troop",slot_troop_last_quest, "qst_deliver_message_to_lover"),
##                     (le,"$talk_context",tc_siege_commander),
##                     ],
##   "I had trusted that letter to you, thinking you were a {man/lady} of honor, and you handed it directly to the girl's father.\
## I should have known you were not to be trusted. Anyway, I have learned my lesson and I won't make that mistake again.", "close_window",
##   [(call_script, "script_clear_last_quest", "$g_talk_troop")]],


#Lord to be recruited

  [anyone ,"start",
   [
	(eq, "$g_talk_troop_faction", "fac_player_supporters_faction"),
	(is_between, "$g_talk_troop", active_npcs_begin, active_npcs_end),
	(troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_inactive),
	(neq, "$g_talk_troop", "$g_player_minister"),
	(troop_get_slot, ":original_faction", "$g_talk_troop", slot_troop_original_faction),
	(faction_get_slot, ":original_faction_leader", ":original_faction", slot_faction_leader), 
	(str_store_troop_name, s10, ":original_faction_leader"),
	(str_store_string, s9, "str_lord_indicted_dialog_approach"),
	], 
	#Greetings, {my lord/my lady}. You may have heard of my ill treatment at the hands of {s10}. You have a reputation as one who treats {his/her} vassals well, and if you will have me, I would be honored to pledge myself as your vassal.
	"{s9}", "lord_requests_recruitment", []],
	
  [anyone|plyr ,"lord_requests_recruitment",	
	[
	(str_store_string, s9, "str_lord_indicted_dialog_approach_yes"),
	], #And I would be honored to accept your pledge.
	"{s9}", "close_window", [
	(troop_set_slot, "$g_talk_troop", slot_troop_occupation, slto_kingdom_hero),
	#This should be enough, scriptwise, but if there is a string somewhere to confirm the pledge, I should link
	]],
	
  [anyone|plyr ,"lord_requests_recruitment",	
	[
	(str_store_string, s9, "str_lord_indicted_dialog_approach_no"),
	], #I'm sorry. Your service is not required.
	"{s9}", "lord_requests_recruitment_refuse", []],

  [anyone ,"lord_requests_recruitment_refuse",	
	[
	(str_store_string, s9, "str_lord_indicted_dialog_rejected"),
	], #Indeed? Well, perhaps your reputation is misleading. Good day, {my lord/my lady} -- I go to see if another ruler in Calradia is more appreciative of my talents.
	"{s9}", "close_window", [
	#Seek alternative liege
	(assign, "$g_leave_encounter", 1),
	(call_script, "script_troop_change_relation_with_troop", "$g_talk_troop", "trp_player", -10),
	(call_script, "script_lord_find_alternative_faction", "$g_talk_troop"),
	(assign, ":new_faction", reg0),
	
	(try_begin),
		(is_between, ":new_faction", kingdoms_begin, kingdoms_end),
		(troop_get_slot, ":old_faction", "$g_talk_troop", slot_troop_original_faction),
		(str_store_troop_name, s1, "$g_talk_troop"),
		(str_store_faction_name, s2, ":new_faction"),	
		(str_store_faction_name, s3, ":old_faction"),
	
		(call_script, "script_change_troop_faction", "$g_talk_troop", ":new_faction"),
	
		(troop_get_type, reg4, "$g_talk_troop"),
		(display_message, "str_lord_defects_ordinary"),
	(else_try),
		(call_script, "script_change_troop_faction", "$g_talk_troop", "fac_outlaws"),
	(try_end),
	]],

	
	
	
	
#Rebellion changes begin
  [anyone ,"start",
   [
     (is_between, "$g_talk_troop", pretenders_begin, pretenders_end),
     (eq, "$g_talk_troop", "$supported_pretender"),
     ],
   "I await your counsel, {playername}.", "supported_pretender_talk", [
     ]],

  [anyone ,"start",
   [
     (is_between, "$g_talk_troop", pretenders_begin, pretenders_end),
	 (neg|troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_hero),
     (assign, "$pretender_told_story", 0),
     (eq, "$g_talk_troop_met", 0),
     (neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
     ],
   "Do I know you?.", "pretender_intro_1", []],
  [anyone|plyr ,"pretender_intro_1", [], "My name is {playername}. At your service.", "pretender_intro_2", []],
  [anyone|plyr ,"pretender_intro_1", [], "I am {playername}. Perhaps you have heard of my exploits.", "pretender_intro_2", []],

  [anyone ,"pretender_intro_2", [(troop_get_slot, ":rebellion_string", "$g_talk_troop", slot_troop_original_faction),
                                 (val_sub, ":rebellion_string", "fac_kingdom_1"),
                                 (val_add, ":rebellion_string", "str_swadian_rebellion_pretender_intro"),
                                 (str_store_string, 48, ":rebellion_string"),],
   "{s48}", "pretender_intro_3", []],

  [anyone|plyr ,"pretender_intro_3", [(troop_get_slot, ":original_faction", "$g_talk_troop", slot_troop_original_faction),
                                      (str_store_faction_name, s12, ":original_faction"),
                                      (faction_get_slot, ":original_ruler", ":original_faction", slot_faction_leader),
                                      (str_store_troop_name, s11, ":original_ruler"),],
   "I thought {s12} was ruled by {s11}?", "pretender_rebellion_cause_1", [
   (troop_set_slot, "$g_talk_troop", slot_troop_discussed_rebellion, 1)
   ]],

  [anyone ,"start",
   [
     (is_between, "$g_talk_troop", pretenders_begin, pretenders_end),
     (neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
	 (neg|troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_hero),
     ],
   "Greetings, {playername}", "pretender_start", [(assign, "$pretender_told_story", 0)]],

  [anyone|plyr ,"pretender_start",
   [
     (troop_slot_eq, "$g_talk_troop", slot_troop_discussed_rebellion, 1),
     (eq, "$pretender_told_story", 0)
     ],
   "What was your story again, {reg65?my lady:sir}?", "pretender_rebellion_cause_prelim", [
     ]],

  [anyone,"pretender_rebellion_cause_prelim", [],
   "I shall tell you.", "pretender_rebellion_cause_1", [
                     ]],


  [anyone,"pretender_rebellion_cause_1", [],
   "{s48}", "pretender_rebellion_cause_2", [
                     (assign, "$pretender_told_story", 1),
                     (troop_get_slot, ":rebellion_string", "$g_talk_troop", slot_troop_original_faction),
                     (val_sub, ":rebellion_string", "fac_kingdom_1"),                                
                     (val_add, ":rebellion_string", "str_swadian_rebellion_pretender_story_1"),
                     (str_store_string, 48, ":rebellion_string"),
                     ]],

  [anyone,"pretender_rebellion_cause_2", [],
   "{s48}", "pretender_rebellion_cause_3", [
                     (troop_get_slot, ":rebellion_string", "$g_talk_troop", slot_troop_original_faction),
                     (val_sub, ":rebellion_string", "fac_kingdom_1"),                                
                     (val_add, ":rebellion_string", "str_swadian_rebellion_pretender_story_2"),
                     (str_store_string, 48, ":rebellion_string"),
                     ]],

  [anyone,"pretender_rebellion_cause_3", [],
   "{s48}", "pretender_start", [
                     (troop_get_slot, ":rebellion_string", "$g_talk_troop", slot_troop_original_faction),
                     (val_sub, ":rebellion_string", "fac_kingdom_1"),                                
                     (val_add, ":rebellion_string", "str_swadian_rebellion_pretender_story_3"),
                     (str_store_string, 48, ":rebellion_string"),
                     ]],

  [anyone|plyr ,"pretender_start", [
                    (troop_slot_eq, "$g_talk_troop", slot_troop_discussed_rebellion, 1),
                     ],
   "I want to take up your cause and help you reclaim your throne!", "pretender_discuss_rebellion_1", [
     ]],

  [anyone|plyr ,"pretender_start", [
                     ],
   "I must leave now.", "pretender_end", [
     ]],
	 
	 
  [anyone ,"pretender_discuss_rebellion_1", [(troop_get_slot, ":original_faction", "$g_talk_troop", slot_troop_original_faction),
                                             (faction_get_slot, ":original_ruler", ":original_faction", slot_faction_leader),
                                             (str_store_troop_name, s11, ":original_ruler")],
   "Are you sure you will be up to the task, {playername}? Reclaiming my throne will be no simple matter.\
 The lords of our realm have all sworn oaths of homage to {s11}.\
 Such oaths to a usurper are of course invalid, and we can expect some of the lords to side with us, but it will be a very tough and challenging struggle ahead.", "pretender_discuss_rebellion_2a", []],

  [anyone ,"pretender_discuss_rebellion_2a",[
											(troop_get_slot, ":original_faction", "$g_talk_troop", slot_troop_original_faction),
                                            (faction_get_slot, ":original_ruler", ":original_faction", slot_faction_leader),
											(str_store_troop_name, s12, ":original_ruler"),
                                            (call_script, "script_evaluate_realm_stability", ":original_faction"),
											(assign, ":instability_index", reg0),
											(val_add, ":instability_index", reg0),
											(val_add, ":instability_index", reg1),											 
											(try_begin),
												(gt, ":instability_index", 60),
												(str_store_string, s11, "str_one_thing_in_our_favor_is_that_s12s_grip_is_very_shaky_he_rules_over_a_labyrinth_of_rivalries_and_grudges_lords_often_fail_to_cooperate_and_many_would_happily_seek_a_better_liege"),
											(else_try),	
												(is_between, ":instability_index", 40, 60),
												(str_store_string, s11, "str_thankfully_s12s_grip_is_fairly_shaky_many_lords_do_not_cooperate_with_each_other_and_some_might_be_tempted_to_seek_a_better_liege"),
											(else_try),	
												(is_between, ":instability_index", 20, 40),
												(str_store_string, s11, "str_unfortunately_s12s_grip_is_fairly_strong_until_we_can_shake_it_we_may_have_to_look_long_and_hard_for_allies"),
											(else_try),	
												(lt, ":instability_index", 20),
												(str_store_string, s11, "str_unfortunately_s12s_grip_is_very_strong_unless_we_can_loosen_it_it_may_be_difficult_to_find_allies"),
											(try_end),
											 ],
   "{s11}", "pretender_discuss_rebellion_2", []],
 
 
 
  [anyone|plyr ,"pretender_discuss_rebellion_2", [],  "I am ready for this struggle.", "pretender_discuss_rebellion_3", []],
  [anyone|plyr ,"pretender_discuss_rebellion_2", [],  "You are right. Perhaps, I should think about this some more.", "pretender_end", []],

  
  [anyone ,"pretender_discuss_rebellion_3", [(this_or_next|neg|faction_slot_eq, "fac_player_supporters_faction", slot_faction_state, sfs_active),
											 (neg|faction_slot_eq, "fac_player_supporters_faction", slot_faction_leader, "trp_player"),
											 (neg|troop_slot_ge, "trp_player",slot_troop_renown, 200),
                                             (troop_get_slot, ":original_faction", "$g_talk_troop", slot_troop_original_faction),
                                             (faction_get_slot, ":original_ruler", ":original_faction", slot_faction_leader),
                                             (str_store_troop_name, s11, ":original_ruler")],
   "I have no doubt that your support for my cause is heartfelt, {playername}, and I am grateful to you for it.\
 But I don't think we have much of a chance of success.\
 If you can gain renown in the battlefield and make a name for yourself as a great commander, then our friends would not hesitate to join our cause,\
 and our enemies would be wary to take up arms against us. When that time comes, I will come with you gladly.\
 But until that time, it will be wiser not to openly challange the usurper, {s11}.", "close_window", []],

  [anyone ,"pretender_discuss_rebellion_3", [(this_or_next|neg|faction_slot_eq, "fac_player_supporters_faction", slot_faction_state, sfs_active),
											 (neg|faction_slot_eq, "fac_player_supporters_faction", slot_faction_leader, "trp_player"),
											 (gt, "$supported_pretender", 0),
                                             (str_store_troop_name, s17, "$supported_pretender")],
   "Haven't you already taken up the cause of {s17}?\
 You must have a very strong sense of justice, indeed.\
 But no, thank you. I will not be part of your game.", "close_window", []],

  [anyone ,"pretender_discuss_rebellion_3", [(this_or_next|neg|faction_slot_eq, "fac_player_supporters_faction", slot_faction_state, sfs_active),
											 (neg|faction_slot_eq, "fac_player_supporters_faction", slot_faction_leader, "trp_player"),
											 (gt, "$players_kingdom", 0),
                                             (neq, "$players_kingdom", "fac_player_supporters_faction"),
                                             (neq, "$players_kingdom", "fac_player_faction"),
                                             (troop_get_slot, ":original_faction", "$g_talk_troop", slot_troop_original_faction),
                                             (neq, "$players_kingdom", ":original_faction"),
                                             (eq, "$player_has_homage", 1),
												
                                             (str_store_faction_name, s16, "$players_kingdom"),
                                             (faction_get_slot, ":player_ruler", "$players_kingdom", slot_faction_leader),
                                             (str_store_troop_name, s15, ":player_ruler"),
                                             (str_store_faction_name, s17, ":original_faction"),
                                             ],
   "{playername}, you are already oath-bound to serve {s15}.\
 As such, I cannot allow you to take up my cause, and let my enemies claim that I am but a mere puppet of {s16}.\
 No, if I am to have the throne of {s17}, I must do it due to the righteousness of my cause and the support of my subjects alone.\
 If you want to help me, you must first free yourself of your oath to {s15}.", "close_window", []],
 
  [anyone ,"pretender_discuss_rebellion_3", [(faction_slot_eq, "fac_player_supporters_faction", slot_faction_state, sfs_active),
											 (faction_slot_eq, "fac_player_supporters_faction", slot_faction_leader, "trp_player")],
   "You are a monarch in your own right, {sir/my lady}. If you were to back me, I would be merely your puppet.", "close_window", []],
 

  [anyone ,"pretender_discuss_rebellion_3", [(troop_get_slot, ":original_faction", "$g_talk_troop", slot_troop_original_faction),
                                             (str_store_faction_name, s12, ":original_faction"),
                                             (faction_get_slot, ":original_ruler", ":original_faction", slot_faction_leader),
                                             (str_store_troop_name, s11, ":original_ruler")],
   "You are a capable warrior, {playername}, and I am sure with your renown as a commander, and my righteous cause, the nobles and the good people of {s12} will flock to our support.\
 The time is ripe for us to act! I will come with you, and together, we will topple the usurper {s11} and take the throne from his bloodied hands.\
 But first, you must give me your oath of homage and accept me as your liege {reg65?lady:lord}.", "pretender_rebellion_ready", []],


  [anyone|plyr ,"pretender_rebellion_ready", [
                     (troop_get_type, reg3, "$g_talk_troop"),
                     ],
   "I am ready to pledge myself to your cause, {reg3?my lady:sir}.", "lord_give_oath_2", [
     ]],

  [anyone|plyr ,"pretender_rebellion_ready", [
                     ],
   "Let us bide our time a little longer.", "pretender_end", [
     ]],

  [anyone ,"lord_give_conclude_2", [(is_between, "$g_talk_troop", pretenders_begin, pretenders_end),
									(neg|troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_hero),
                     ],
   "Forward, then! Our first task is to take hold of a fortress and persuade other lords to join us. You lead the way!", "close_window", [

            (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 50), #should be higher
            (faction_set_slot, "$g_talk_troop_faction", slot_faction_state, sfs_active),
##            (faction_set_slot, "$g_talk_troop_faction", slot_faction_ai_state, sfai_nascent_rebellion),

            (party_force_add_members, "p_main_party", "$supported_pretender", 1),
            (troop_set_slot, "$supported_pretender", slot_troop_cur_center, 0),
            (troop_set_auto_equip, "$supported_pretender",0),
            (str_store_troop_name_link, s6, "$supported_pretender"),
            (display_message, "@{s6} has joined your party."),
            
#            (faction_get_slot, ":location", "$g_talk_troop_faction", slot_faction_inactive_leader_location),
#            (faction_set_slot, "$g_talk_troop_faction", slot_faction_inactive_leader_location, 0),

#            (call_script, "script_create_kingdom_hero_party", "$g_talk_troop", ":location"),
#            (party_set_slot, "$pout_party", slot_party_commander_party, "p_main_party"),
#            (call_script, "script_party_decide_next_ai_state_under_command", "$pout_party"),
#            (store_current_hours, ":follow_until_time"),
#            (store_add, ":follow_period", 60, "$g_talk_troop_relation"),
#            (val_div, ":follow_period", 2),
#            (val_add, ":follow_until_time", ":follow_period"),
#            (party_set_slot, "$pout_party", slot_party_follow_player_until_time, ":follow_until_time"),
#            (party_set_slot, "$pout_party", slot_party_following_player, 1),




#            (assign, ":rebellion_target", "$supported_pretender_old_faction"),
            (store_relation, ":reln", "$supported_pretender_old_faction", "fac_player_supporters_faction"),
            (val_min, ":reln", -50),
            (call_script, "script_set_player_relation_with_faction", "$supported_pretender_old_faction", ":reln"),
			(faction_get_slot, ":adjective_string", "$supported_pretender_old_faction", slot_faction_adjective),
            (str_store_string, s1, ":adjective_string"),
			
            (faction_set_name, "fac_player_supporters_faction", "@{s1} Rebels"),
            (faction_set_color, "fac_player_supporters_faction", 0xFF0000),

## Let us handle relation with other kingdoms later.
##            (try_for_range, ":existing_kingdom", kingdoms_begin, kingdoms_end),
##                (store_relation, ":relation", ":existing_kingdom", ":rebellion_target"),
##                (store_sub, ":relation_w_rebels", 0, ":relation"),
##                (store_relation, ":player_relation", ":existing_kingdom", "fac_player_supporters_faction"),
##                (val_div, ":player_relation", 3),
##                (val_add, ":relation_w_rebels", ":player_relation"),
##				  #WARNING: Never use set_relation!
##                (set_relation, ":existing_kingdom", "$g_talk_troop_faction", ":relation_w_rebels"),
##            (try_end),

# we have alrady joined.
##            (str_store_faction_name, 4, "$g_talk_troop_faction"),
##            (display_message, "@Player joins {s4}"),
##            (call_script, "script_player_join_faction", "$g_talk_troop_faction"),
            (call_script, "script_update_all_notes"),
            ]],





  [anyone ,"pretender_end", [
                     ],
   "Farewell for now, then.", "close_window", [
     ]],



# Events....
# Choose friend.  
#Post 0907 changes begin
  [anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_hero),
                     (neq, "$g_talk_troop_met", 0),
                     (gt, "$g_time_since_last_talk", 24),
                     (gt, "$g_talk_troop_relation", -10),
                     (store_random_in_range, ":random_num", 0, 100),
                     (lt, ":random_num", 30),
                     (eq,"$talk_context",tc_town_talk),
                     (call_script, "script_cf_troop_get_random_enemy_troop_with_occupation", "$g_talk_troop", slto_kingdom_hero),
                     (assign, ":other_lord",reg0),
                     (troop_get_slot, ":other_lord_relation", ":other_lord", slot_troop_player_relation),
                     (ge, ":other_lord_relation", 20),
                     (str_store_troop_name, s6, ":other_lord"),
                     (assign, "$temp", ":other_lord"),
                     ],
   "I heard that you have befriended that {s43} called {s6}.\
 Believe me, you can't trust that man.\
 You should end your dealings with him.", "lord_event_choose_friend", [
    (call_script, "script_lord_comment_to_s43", "$g_talk_troop", "str_lord_insult_default"),

     ]],

  [anyone|plyr ,"lord_event_choose_friend", [],  "I assure you, {s65}, I am no friend of {s6}.", "lord_event_choose_friend_renounce", [
      (call_script, "script_change_player_relation_with_troop","$g_talk_troop",5),
      (call_script, "script_change_player_relation_with_troop","$temp",-10),
      ]],

  [anyone ,"lord_event_choose_friend_renounce", [],  "Glad news, {playername}. I would fear for your safety otherwise.\
 If you do encounter {s6}, be on your guard and don't believe a word.", "lord_pretalk", []],
  
  [anyone|plyr ,"lord_event_choose_friend", [],  "{s6} is an honourable man, you've no right to speak of him thus.", "lord_event_choose_friend_defend", [
      (call_script, "script_change_player_relation_with_troop","$g_talk_troop",-10),
      (call_script, "script_change_player_relation_with_troop","$temp",5),
      ]],
  [anyone ,"lord_event_choose_friend_defend", [],  "As you like, {playername}.\
 A fool you might be, but a loyal fool at the least. {s6}'s loyalty may not be so steadfast, however...", "lord_pretalk", []],
#Post 0907 changes end
  
  [anyone|plyr ,"lord_event_choose_friend", [],  "I don't want to be involved in your quarrel with {s6}.", "lord_event_choose_friend_neutral", [
      (call_script, "script_change_player_relation_with_troop","$g_talk_troop",-2),
      (call_script, "script_change_player_relation_with_troop","$temp",-3),
      ]],

  [anyone ,"lord_event_choose_friend_neutral", [],  "Hmph. As you wish, {playername}.\
 Just remember that a {man/woman} needs friends in this world, and you'll never make any if you never stand with anyone.", "lord_pretalk", []],

#Meeting.
  [anyone ,"start", [(troop_slot_eq, "$g_talk_troop",slot_troop_occupation, slto_kingdom_hero),
                     (troop_slot_eq, "trp_player", slot_troop_spouse, "$g_talk_troop"),
                     ],
   "Yes, my wife?", "lord_start",
   []],


  [anyone ,"start", [(faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "trp_player"),
					 (troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_hero),
                     (le,"$talk_context",tc_siege_commander),
                     ],
   "Yes, {sire/my lady}?", "lord_start",
   []],

   
  [anyone ,"start", [(is_between, "$g_talk_troop", companions_begin, companions_end),
					 (troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_hero),
                     (le,"$talk_context",tc_siege_commander),
                     ],
   "It is good to see you, old friend.", "lord_start",
   []],

   
  [anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_hero),
                     (check_quest_active, "qst_join_faction"),
                     (eq, "$g_invite_faction_lord", "$g_talk_troop"),
					 (eq, "$players_kingdom", "fac_player_supporters_faction"),
                     ],
   #TODO: change conversations according to relation.
   "Well, {playername}. I am willing to forgive your impudence in proclaiming yourself {king/queen}, and will welcome you into my realm with full honor, as one of my vassals. Shall we proceed to the oath of allegiance?", "lord_invite_player_monarch_1",
   []],
   
  [anyone|plyr ,"lord_invite_player_monarch_1", [],  "Yes... my lord.", "lord_invite_2",  []],
  [anyone|plyr ,"lord_invite_player_monarch_1", [],  "No. That oath sticks in my throat.", "lord_enter_service_reject",  []],
   
   

  [anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_hero),
                     (check_quest_active, "qst_join_faction"),
                     (eq, "$g_invite_faction_lord", "$g_talk_troop"),
                     (try_begin),
                       (gt, "$g_invite_offered_center", 0),
                       (store_faction_of_party, ":offered_center_faction", "$g_invite_offered_center"),
                       (neq, ":offered_center_faction", "$g_talk_troop_faction"),
                       (call_script, "script_get_poorest_village_of_faction", "$g_talk_troop_faction"),
                       (assign, "$g_invite_offered_center", reg0),
                     (try_end),
                     ],
   #TODO: change conversations according to relation.
   "{playername}, I've been expecting you. Word has reached my ears of your exploits.\
 Why, I keep hearing such tales of prowess and bravery that my mind was quickly made up.\
 I knew that I had found someone worthy of becoming my vassal.", "lord_invite_1",
   []],


  [anyone|plyr ,"lord_invite_1", [],  "Thank you, {s65}, you honour me with your offer.", "lord_invite_2",  []],
  [anyone|plyr ,"lord_invite_1", [],  "It is good to have my true value recognised.", "lord_invite_2",  []],
   
  [anyone ,"lord_invite_2", [],  "Aye. Let us dispense with the formalities, {playername}; are you ready to swear homage to me?", "lord_invite_3",  []],
    
  [anyone|plyr ,"lord_invite_3", [],  "Yes, {s65}.", "lord_give_oath_2",  []],
  [anyone|plyr ,"lord_invite_3", [],  "No, {s65}. I cannot serve you right now.", "lord_enter_service_reject",  []],

  [anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_met, 2),
                     (gt, "$g_talk_troop_relation", 10),
					 (gt, "$g_time_since_last_talk", 3),
					 (troop_get_type, ":is_female", "trp_player"),
					 (eq, ":is_female", 1),
					 (troop_slot_eq, "trp_player", slot_troop_spouse, -1),
					 (troop_slot_eq, "trp_player", slot_troop_betrothed, -1),
					 (troop_slot_eq, "$g_talk_troop", slot_troop_spouse, -1),
					 (troop_slot_eq, "$g_talk_troop", slot_troop_betrothed, -1),
					 (call_script, "script_npc_decision_checklist_marry_female_pc", "$g_talk_troop"),
					 (ge, reg0, 1),
                     ],
   "My lady, I have been giving much thought to our recent conversation. It is time for me to ask. Would you do me the honor of becoming my wife?", "lord_female_pc_marriage_proposal",  [
					]],  
  
  [anyone|plyr ,"lord_female_pc_marriage_proposal", [],  "Yes. I would.", "lord_marriage_proposal_female_pc_next_step",  []],
  [anyone|plyr ,"lord_female_pc_marriage_proposal", [],  "Let me think about this some more.", "lord_female_pc_marriage_proposal_postponed",  []],
  [anyone|plyr ,"lord_female_pc_marriage_proposal", [],  "No. I have decided that it would not be appropriate", "lord_female_pc_marriage_proposal_rejected",  []],
  
  [anyone ,"lord_female_pc_marriage_proposal_postponed", [],  "Of course, my lady. Take all the time you need.", "lord_start",  []],

  [anyone ,"lord_female_pc_marriage_proposal_rejected", [],  "Do you mean to reject my suit outright, my lady?", "lord_female_pc_marriage_proposal_rejected_confirm",  []],
  
  [anyone|plyr ,"lord_female_pc_marriage_proposal_rejected_confirm", [],  "Yes. I do.", "lord_female_pc_marriage_proposal_rejected_confirm_yes",  []],
  [anyone|plyr ,"lord_female_pc_marriage_proposal_rejected_confirm", [],  "No, you misunderstand. I just need some more time to think", "lord_female_pc_marriage_proposal_postponed",  []],
  
  [anyone ,"lord_female_pc_marriage_proposal_rejected_confirm_yes", [
  (this_or_next|troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_debauched),
  (this_or_next|troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_selfrighteous),
	(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_quarrelsome),
  ],  "Well, in that case, let me tell you something -- with those harsh words, you have removed the scales from my eyes. I would agree that it would not be appropriate for me to marry one such as you. Good day, my lady.", "close_window",  [
  (call_script, "script_troop_change_relation_with_troop", "$g_talk_troop", "trp_player", -20),
  (troop_set_slot, "$g_talk_troop", slot_troop_met, 4),
  (assign, "$g_leave_encounter", 1),
  ]],
  
  [anyone ,"lord_female_pc_marriage_proposal_rejected_confirm_yes", [],  "Such is your right, my lady. If you ever wished to reconsider, I would be overwhelmed with joy.", "close_window",  [
  (call_script, "script_troop_change_relation_with_troop", "$g_talk_troop", "trp_player", -5),
  (troop_set_slot, "$g_talk_troop", slot_troop_met, 4),
  (assign, "$g_leave_encounter", 1),
  ]],
  
  
  [anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_met, 2),
                     (gt, "$g_time_since_last_talk", 24),
                     (gt, "$g_talk_troop_relation", 0),
					 (troop_get_type, ":is_female", "trp_player"),
					 (eq, ":is_female", 1),
					 (troop_slot_eq, "trp_player", slot_troop_spouse, -1),
					 (troop_slot_eq, "trp_player", slot_troop_betrothed, -1),
					 (troop_slot_eq, "$g_talk_troop", slot_troop_spouse, -1),
					 (troop_slot_eq, "$g_talk_troop", slot_troop_betrothed, -1),
                     ],
   "My lady, it brings my heart great joy to see you again...", "lord_start",  [
					 (call_script, "script_troop_change_relation_with_troop", "trp_player", "$g_talk_troop", 2),
					]],  
					
  [anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_met, 2),
                     (gt, "$g_talk_troop_relation", 0),
					 (troop_get_type, ":is_female", "trp_player"),
					 (eq, ":is_female", 1),
                     ],
   "My lady, I am always your humble servant", "lord_start",  [
					]],  
					
  
  [anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_hero),
                     (neq, "$g_talk_troop_met", 0),
                     (gt, "$g_time_since_last_talk", 24),
                     (gt, "$g_talk_troop_relation", 50),
                     (gt, "$g_talk_troop_faction_relation", 10),
                     (le,"$talk_context",tc_siege_commander),
                     ],
   "If it isn't my brave champion, {playername}...", "lord_start",  []],
  
  [anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_hero),
                     (neq, "$g_talk_troop_met", 0),
                     (gt, "$g_time_since_last_talk", 24),
                     (gt, "$g_talk_troop_relation", 10),
                     (le,"$talk_context",tc_siege_commander),
                     ],
   "Good to see you again {playername}...", "lord_start", []],

  [anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_hero),
                     (neq, "$g_talk_troop_met", 0),
                     (gt, "$g_time_since_last_talk", 24),
                     (le,"$talk_context",tc_siege_commander),
                     ],
   "We meet again, {playername}...", "lord_start", []],

  [anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_hero),
                     (eq, "$g_talk_troop_met", 0),
                     (ge, "$g_talk_troop_faction_relation", 0),
                     (le,"$talk_context",tc_siege_commander),
                     ],
   "Do I know you?", "lord_meet_neutral", []],
  [anyone|plyr ,"lord_meet_neutral", [],  "I am {playername}.", "lord_intro", []],
  [anyone|plyr ,"lord_meet_neutral", [],  "My name is {playername}. At your service sir.", "lord_intro", []],

  [anyone ,"lord_intro", [],
   "{s11}", "lord_start", [(faction_get_slot, ":faction_leader", "$g_talk_troop_faction", slot_faction_leader),
                          (str_store_faction_name, s6, "$g_talk_troop_faction"),
                          (assign, reg4, 0),
                          (str_store_troop_name, s4, "$g_talk_troop"),
                          (try_begin),
                            (eq, ":faction_leader", "$g_talk_troop"),
                            (str_store_string, s9, "@I am {s4}, the ruler of {s6}", 0),
                          (else_try),
                            (str_store_string, s9, "@I am {s4}, a vassal of {s6}", 0),
                          (try_end),
                          (assign, ":num_centers", 0),
                          (str_clear, s8),
                          (try_for_range_backwards, ":cur_center", centers_begin, centers_end),
                            (party_slot_eq, ":cur_center", slot_town_lord, "$g_talk_troop"),
                            (try_begin),
                              (eq, ":num_centers", 0),
                              (str_store_party_name, s8, ":cur_center"),
                            (else_try),
                              (eq, ":num_centers", 1),
                              (str_store_party_name, s7, ":cur_center"),
                              (str_store_string, s8, "@{s7} and {s8}"),
                            (else_try),
                              (str_store_party_name, s7, ":cur_center"),
                              (str_store_string, s8, "@{!}{s7}, {s8}"),
                            (try_end),
                            (val_add, ":num_centers", 1),
                          (try_end),
                          (assign, reg5, ":num_centers"),
                          (str_store_string, s11, "@{s9}{reg5? and the lord of {s8}.:.", 0),
                          ]],

#  [anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_hero),
#                     (eq, "$g_talk_troop_met", 0),
#                     (ge, "$g_talk_troop_faction_relation", 0),
#                     (le,"$talk_context",tc_siege_commander),
#                     ],
#   "Who is this then?", "lord_meet_ally", []],
#  [anyone|plyr ,"lord_meet_ally", [],  "I am {playername} sir. A warrior of {s4}.", "lord_start", []],
#  [anyone|plyr ,"lord_meet_ally", [],  "I am but a soldier of {s4} sir. My name is {playername}.", "lord_start", []],

  [anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_hero),
                     (eq, "$g_talk_troop_met", 0),
                     (lt, "$g_talk_troop_faction_relation", 0),
#                     (str_store_faction_name, s4,  "$players_kingdom"),
                     (le,"$talk_context",tc_siege_commander),
                     ],
   "{s43}", "lord_meet_enemy", [
    (call_script, "script_lord_comment_to_s43", "$g_talk_troop", "str_enemy_meet_default"),
       ]],
  [anyone|plyr ,"lord_meet_enemy", [],  "I am {playername}, {s65}.", "lord_intro", []],  #A warrior of {s4}.
  [anyone|plyr ,"lord_meet_enemy", [],  "They know me as {playername}. Mark it down, you shall be hearing of me a lot.", "lord_intro", []],
#  [anyone, "lord_meet_enemy_2", [],  "{playername} eh? Never heard of you. What do want?", "lord_talk", []],






  [anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_hero),
                     (le,"$talk_context",tc_siege_commander),
					 (try_begin),
					    (this_or_next|troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_debauched),
							(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_quarrelsome),
					    (lt, "$g_talk_troop_relation", -15),
						(str_store_string, s8, "str_playername_come_to_plague_me_some_more_have_you"),
					 (else_try),	
					    (lt, "$g_talk_troop_relation", -5),
						(str_store_string, s8, "str_ah_it_is_you_again"),
					 (else_try),
						(str_store_string, s8, "str_well_playername"),
					 (try_end),	
                     ],
   "{s8}", "lord_start",
   []],


   
   
  [anyone,"lord_start", [(gt, "$g_comment_found", 0), #changed to s32 from s62 because overlaps with setup_talk_info strings                         
						 (str_store_string, s1, "$g_last_comment_copied_to_s42"),
						 (try_begin),
						   (eq, "$cheat_mode", 1),
						   (display_message, "str_comment_found_s1"),
						 (try_end),
  
                        ],  "{s42}", "lord_start", [
#                         (store_current_hours, ":cur_time"),
#                         (troop_set_slot, "$g_talk_troop", slot_troop_last_comment_time, ":cur_time"),
                         (try_begin),
                           (neq, "$log_comment_relation_change", 0),
                           (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", "$log_comment_relation_change"),
                         (try_end),
						 
						 
						 (assign, "$g_comment_has_rejoinder", 0),
						 (try_begin),
							(gt, "$g_rejoinder_to_last_comment", 0),
							(try_begin),
							  (eq, "$cheat_mode", 1),
							  (display_message, "str_rejoinder_noted"),	
							(try_end),
							(assign, "$g_comment_has_rejoinder", 1),
						 (try_end),
						 
                         (assign, "$g_comment_found", 0),
                         ]],  

    [anyone|auto_proceed,"lord_start", 
    [
      (check_quest_active, "qst_destroy_bandit_lair"),
      (check_quest_succeeded, "qst_destroy_bandit_lair"),
      (quest_slot_eq, "qst_destroy_bandit_lair", slot_quest_giver_troop, "$g_talk_troop"),
    ], "{!}.", "lair_quest_intermediate_1", 
    [
    ]],

    [anyone,"lair_quest_intermediate_1", 
    [
    ], "Splendid work, {playername} -- your audacious attack is the talk of the realm. No doubt they, or others like them, will soon be back, but for a short while you have bought this land a small respite. We are most grateful to you.", "lord_pretalk", 
    [
      (quest_get_slot, ":quest_gold_reward", "qst_destroy_bandit_lair", slot_quest_gold_reward),
      (call_script, "script_troop_add_gold", "trp_player", ":quest_gold_reward"),
      (assign, ":xp_reward", ":quest_gold_reward"),
      (val_mul, ":xp_reward", 2),
      (add_xp_as_reward, ":xp_reward"),
      (call_script, "script_change_troop_renown", "trp_player", 3),
	  (call_script, "script_troop_change_relation_with_troop", "trp_player", "$g_talk_troop", 4),
      (call_script, "script_end_quest", "qst_destroy_bandit_lair"),
      (assign, reg5, ":quest_gold_reward"),
    ]],
	
  [anyone|auto_proceed,"lord_start", 
  [
    (check_quest_active, "qst_destroy_bandit_lair"),
    (check_quest_failed, "qst_destroy_bandit_lair"),
    (quest_slot_eq, "qst_destroy_bandit_lair", slot_quest_giver_troop, "$g_talk_troop"),
  ], "{!}.", "lair_quest_intermediate_2", 
  []],

  [anyone,"lair_quest_intermediate_2", 
  [], "Well, {playername}, I guess that at least some of those brigands eluded you -- and of course, it will be the peaceful travellers of this land who will pay the price. Still, it was good of you to try.", "lord_pretalk",
  [
    (call_script, "script_end_quest", "qst_destroy_bandit_lair"),
  ]],

  [anyone,"lord_start", 
  [
    (store_partner_quest,":lords_quest"),
    (eq,":lords_quest","qst_lend_surgeon"),
    (quest_slot_eq, "qst_lend_surgeon", slot_quest_giver_troop, "$g_talk_troop")
  ], "Your surgeon managed to convince my friend and made the operation.  The matter is in God's hands now,, and all we can do is pray for his recovery.\
 Anyway, I thank you for lending your surgeon to me {sir/madam}. You have a noble spirit. I will not forget it.", "lord_generic_mission_completed",
  [
    (call_script, "script_finish_quest", "qst_lend_surgeon", 100),
    (troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1),
  ]],
  
##### TODO: QUESTS COMMENT OUT BEGIN

##
##  [anyone,"lord_start", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                         (store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_bring_prisoners_to_enemy"),
##                         (quest_slot_eq, "qst_bring_prisoners_to_enemy", slot_quest_current_state, 0),
##                         (check_quest_succeeded, "qst_bring_prisoners_to_enemy"),
##                         (quest_get_slot, ":quest_target_amount", "qst_bring_prisoners_to_enemy", slot_quest_target_amount),
##                         (assign, reg1, ":quest_target_amount")],
##   "TODO: You have brought the prisoners and received {reg1} denars. Give me the money now.", "lord_bring_prisoners_complete_2",[]],
##
##  [anyone,"lord_start", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                         (store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_bring_prisoners_to_enemy"),
##                         (quest_slot_eq, "qst_bring_prisoners_to_enemy", slot_quest_current_state, 1),#Some of them were brought only
##                         (check_quest_succeeded, "qst_bring_prisoners_to_enemy"),
##                         (quest_get_slot, ":quest_target_amount", "qst_bring_prisoners_to_enemy", slot_quest_target_amount),
##                         (assign, reg1, ":quest_target_amount")],
##   "TODO: You have brought the prisoners but some of them died during your expedition. Give me the full money of {reg1} denars.", "lord_bring_prisoners_complete_2",[]],
##
##
##  [anyone|plyr,"lord_bring_prisoners_complete_2", [(store_troop_gold, ":cur_gold", "trp_player"),
##                                                   (quest_get_slot, ":quest_target_amount", "qst_bring_prisoners_to_enemy", slot_quest_target_amount),
##                                                   (ge, ":cur_gold", ":quest_target_amount")],
##   "TODO: Here it is.", "lord_generic_mission_thank", [(quest_get_slot, ":quest_target_amount", "qst_bring_prisoners_to_enemy", slot_quest_target_amount),
##                                                  (troop_remove_gold, "trp_player", ":quest_target_amount"),
##                                                  (call_script, "script_finish_quest", "qst_bring_prisoners_to_enemy", 100)]],
##  
##  [anyone|plyr,"lord_bring_prisoners_complete_2", [(store_troop_gold, ":cur_gold", "trp_player"),
##                                                   (quest_get_slot, ":quest_target_amount", "qst_bring_prisoners_to_enemy", slot_quest_target_amount),
##                                                   (lt, ":cur_gold", ":quest_target_amount")],
##   "TODO: I'm afraid I spent some of it, I don't have that much money with me.", "lord_bring_prisoners_no_money", [(quest_get_slot, ":quest_target_amount", "qst_bring_prisoners_to_enemy", slot_quest_target_amount),
##                                                                                                                   (call_script, "script_change_debt_to_troop", "$g_talk_troop", ":quest_target_amount"),#Adding the taken money as a debt
##                                                                                                                   (call_script, "script_finish_quest", "qst_bring_prisoners_to_enemy", 100)]],
##
##  [anyone,"lord_bring_prisoners_no_money", [],
##   "TODO: You owe me that money!", "lord_pretalk", []],
##
##



#MALE PLAYER CHARACTER WEDDING
#wedding allowed
  [anyone ,"lord_start", [(troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_hero),
						  (check_quest_active, "qst_wed_betrothed"),

						  (quest_slot_eq, "qst_wed_betrothed", slot_quest_giver_troop, "$g_talk_troop"),
						  (quest_get_slot, ":bride", "qst_wed_betrothed", slot_quest_target_troop),
						  (troop_slot_eq, ":bride", slot_troop_cur_center, "$g_encountered_party"),
						  (faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_feast),
						  (faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_object, "$g_encountered_party"),
						  						  
						  (call_script, "script_troop_get_family_relation_to_troop", ":bride", "$g_talk_troop"),
						  (str_store_troop_name, s4, ":bride"),
                     ],
   "May the heavens witness that I am ready to give you my {s11} {s4}, to have in marriage...", "wedding_ceremony_bride_vow",
   [
						  (quest_get_slot, "$g_player_bride", "qst_wed_betrothed", slot_quest_target_troop),
   ]],


 [anyone, "lord_start", [ (check_quest_active, "qst_wed_betrothed"),
						  (quest_slot_eq, "qst_wed_betrothed", slot_quest_giver_troop, "$g_talk_troop"),
						  (quest_get_slot, ":expiration_days", "qst_wed_betrothed", slot_quest_expiration_days),
						  (lt, ":expiration_days", 362),
						  (eq, "$g_done_wedding_comment", 0),
						  (str_clear, s12),
						  (try_begin),
							(neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_feast),
							(neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_default),
						    (str_store_string, s12, "@ We will of course need to wait until the realm is no longer on campaign."),
						  (try_end),
						  
                     ],
   "It is good to see you, {playername}. We look forward to the wedding, as soon as we can all gather together for the feast.{s12}", "lord_wedding_reschedule",
   [
	 (assign, "$g_done_wedding_comment", 1),
   ]],



  [anyone|plyr, "lord_wedding_reschedule", [],
   "It is no problem. I can wait.", "lord_start",
   [
   ]],

  [anyone|plyr, "lord_wedding_reschedule", [],
   "I have no faith that this wedding will be concluded. Please return my dower.", "lord_return_dower", #add in new dialog
   []],

  [anyone, "lord_return_dower", [],
   "Well, that is your right, if you indeed have no confidence in our family's commitments. Take your money.", "close_window",
   [
   (quest_get_slot, ":bride", "qst_wed_betrothed", slot_quest_target_troop),
   (fail_quest, "qst_wed_betrothed"),
   (call_script, "script_end_quest", "qst_wed_betrothed"),
  
   (troop_set_slot, "trp_player", slot_troop_betrothed, -1),
   (troop_set_slot, ":bride", slot_troop_betrothed, -1),
   
   (assign, "$marriage_dowry", 0),
   (troop_add_gold, "trp_player", "$marriage_dower"),
   (assign, "$marriage_dower", 0),   
   
   (call_script, "script_troop_change_relation_with_troop", "trp_player", "$g_talk_troop", -3),
   (assign, "$g_leave_encounter", 1),
   ]],

   
   



  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
                         (eq,":lords_quest","qst_incriminate_loyal_commander"),
                         (check_quest_succeeded, "qst_incriminate_loyal_commander"),
                         (quest_get_slot, ":quest_target_troop", "qst_incriminate_loyal_commander", slot_quest_target_troop),
                         (str_store_troop_name, s3, ":quest_target_troop"),
                         (quest_get_slot, reg5, "qst_incriminate_loyal_commander", slot_quest_gold_reward),
                         ],
   "Hah! Our little plot against {s3} worked perfectly, {playername}.\
 The fool has lost one of his most valuable retainers, and we are one step closer to bringing him to his knees.\
 Here, this purse contains {reg5} denars, and I wish you to have it. You deserve every copper.\
 And, need I remind you, there could be much more to come if you've a mind to earn it...", "lord_generic_mission_completed",[
     (call_script, "script_end_quest", "qst_incriminate_loyal_commander"),
     (call_script, "script_change_player_relation_with_troop","$g_talk_troop",5),
     (call_script, "script_change_player_honor", -10),
     ]],

  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
                         (eq,":lords_quest","qst_incriminate_loyal_commander"),
                         (check_quest_failed, "qst_incriminate_loyal_commander")],
   "You werent't able to complete a simple task. I had set up everything.\
 The only thing you needed to do was sacrifice a messenger, and we would be celebrating now.\
 But no, you were too damned honorable, weren't you?", "close_window",[
     (call_script, "script_end_quest", "qst_incriminate_loyal_commander"),
     (call_script, "script_change_player_relation_with_troop","$g_talk_troop",-5),
     (call_script, "script_change_player_honor", 3),
 ]],
  #TODO: NO GENERIC MISSION FAILED ANYMORE!!!!


  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
                         (eq,":lords_quest","qst_meet_spy_in_enemy_town"),
                         (check_quest_succeeded, "qst_meet_spy_in_enemy_town"),
                         ],
   "Have you brought me any news about that task I gave you? You know the one I mean...", "quest_meet_spy_in_enemy_town_completed",
   []],

  [anyone|plyr, "quest_meet_spy_in_enemy_town_completed", [],
   "I have the reports you wanted right here.", "quest_meet_spy_in_enemy_town_completed_2",[]],

  [anyone, "quest_meet_spy_in_enemy_town_completed_2", [],
   "Ahh, well done. It's good to have competent {men/people} on my side. Here is the payment I promised you.", "lord_pretalk",
   [
     (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 3),
     (add_xp_as_reward, 500),
     (quest_get_slot, ":gold", "qst_meet_spy_in_enemy_town", slot_quest_gold_reward),
     (call_script, "script_troop_add_gold", "trp_player", ":gold"),
     (call_script, "script_end_quest", "qst_meet_spy_in_enemy_town"),
     ]],

  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
                         (eq,":lords_quest","qst_cause_provocation"),
                         (check_quest_succeeded, "qst_cause_provocation"),
                         (quest_get_slot, ":quest_target_faction", "qst_cause_provocation", slot_quest_target_faction),
                         (str_store_faction_name, s13, ":quest_target_faction"),
                         ],
   "Brilliant work, {playername}! Whatever you did, the nobles of the {s13} are clamoring for war!\
 Soon, the time will come for us to reap the benefits of our hard work, from fields ripe for plunder.\
 This war is going to make us rich, mark my words!", "lord_pretalk",
   [
    (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 10),
    (try_for_range, ":vassal", active_npcs_begin, active_npcs_end),
		(troop_slot_eq, ":vassal", slot_troop_occupation, slto_kingdom_hero),
		(store_troop_faction, ":vassal_fac", ":vassal"),
      (eq, ":vassal_fac", "$players_kingdom"),
      (neq,  ":vassal", "$g_talk_troop"),
      (store_random_in_range, ":rel_change", -5, 4),
      (call_script, "script_change_player_relation_with_troop", ":vassal", ":rel_change"),
    (try_end),
    #TODO: Add gold reward notification before the quest is given. 500 gold is not mentioned anywhere.
    (call_script, "script_troop_add_gold", "trp_player", 500),
    (add_xp_as_reward, 2000),
    (call_script, "script_change_player_honor", -5),
    (call_script, "script_end_quest", "qst_cause_provocation")
    ]],

#  [anyone,"lord_start", [(store_partner_quest, ":lords_quest"),
 #                        (eq, ":lords_quest", "qst_raid_caravan_to_start_war"),
  #                       (check_quest_failed, "qst_raid_caravan_to_start_war"),
   #                      ],
   #"You incompetent buffoon!\
 #What in Hell made you think that getting yourself captured while trying to start a war was a good idea?\
 #These plans took months to prepare, and now everything's been ruined! I will not forget this, {playername}.\
 #Oh, be assured that I will not.", "lord_pretalk",
 #  [
  #  (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", -10),
  #  (call_script, "script_end_quest", "qst_raid_caravan_to_start_war")
  #  ]],

  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
                         (eq,":lords_quest","qst_collect_debt"),
                         (quest_slot_eq, "qst_collect_debt", slot_quest_current_state, 1),
                         (quest_get_slot, ":target_troop", "qst_collect_debt", slot_quest_target_troop),
                         (str_store_troop_name, s7, ":target_troop"),
                         (quest_get_slot, ":total_collected","qst_collect_debt",slot_quest_target_amount),
                         (store_div, reg3, ":total_collected", 5),
                         (store_sub, reg4, ":total_collected", reg3)],
   "I'm told that you've collected the money owed me from {s7}. Good, it's past time I had it back.\
 I believe I promised to give you one-fifth of it all, eh?\
 Well, that makes {reg3} denars, so if you give me my share -- that's {reg4} denars -- you can keep the rest.", "lord_collect_debt_completed", []],

  
  [anyone|plyr,"lord_collect_debt_completed", [(store_troop_gold, ":gold", "trp_player"),
                                               (ge, ":gold", reg4)],
   "Of course, {s65}. {reg4} denars, all here.", "lord_collect_debt_pay",[]],

  [anyone,"lord_collect_debt_pay", [],
   "I must admit I'm impressed, {playername}. I had lost hope of ever getting this money back.\
 Please accept my sincere thanks.", "lord_pretalk",[
     (troop_remove_gold, "trp_player", reg4),
     (call_script, "script_change_player_relation_with_troop","$g_talk_troop", 2),
     (add_xp_as_reward, 100),
     (call_script, "script_end_quest", "qst_collect_debt")
     ]],
  
  [anyone|plyr,"lord_collect_debt_completed", [], "I am afraid I don't have the money with me sir.", "lord_collect_debt_no_pay",[]],
  [anyone,"lord_collect_debt_no_pay", [], "Is this a joke?\
 I know full well that {s7} gave you the money, and I want every denar owed to me, {sir/madam}.\
 As far as I'm concerned, I hold you personally in my debt until I see that silver.", "close_window",[
     (call_script, "script_change_debt_to_troop", "$g_talk_troop", reg4),
     (call_script, "script_end_quest", "qst_collect_debt"),

     (call_script, "script_objectionable_action", tmt_honest, "str_squander_money"),
     ]],

  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
                         (eq,":lords_quest","qst_kill_local_merchant"),
                         (check_quest_succeeded, "qst_kill_local_merchant"),
                         (quest_slot_eq, "qst_kill_local_merchant", slot_quest_current_state, 1)],
   "I heard you got rid of that poxy merchant that was causing me so much grief.\
 I can see you're not afraid to get your hands dirty, eh? I like that in a {man/woman}.\
 Here's your reward. Remember, {playername}, stick with me and we'll go a long, long way together.", "close_window",
   [ (call_script, "script_troop_add_gold", "trp_player", 600),
     (call_script, "script_change_player_relation_with_troop","$g_talk_troop",4),
     (add_xp_as_reward, 300),
     (call_script, "script_end_quest", "qst_kill_local_merchant"),

     (call_script, "script_objectionable_action", tmt_humanitarian, "str_murder_merchant"), 
     
     (assign, "$g_leave_encounter", 1)]],

  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
                         (eq,":lords_quest","qst_kill_local_merchant"),
                         (check_quest_failed, "qst_kill_local_merchant")],
   "Oh, it's you. Enlighten me, how exactly does one lose a simple fight to some poxy, lowborn merchant?\
 Truly, if I ever need my guardsmen to take a lesson in how to lay down and die, I'll be sure to come to you.\
 Just leave me be, {playername}, I have things to do.", "close_window",
   [(call_script, "script_end_quest", "qst_kill_local_merchant"),
    (assign, "$g_leave_encounter", 1)]],

  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
                         (eq,":lords_quest","qst_kill_local_merchant"),
                         (check_quest_succeeded, "qst_kill_local_merchant"),
                         (quest_slot_eq, "qst_kill_local_merchant", slot_quest_current_state, 2)],
   "You! Do you have sawdust between your ears? Did you think that when I said to kill the merchant,\
 I meant you to have a nice chat with him and then let him go?! What possessed you?", "lord_kill_local_merchant_let_go",[]],

  [anyone|plyr,"lord_kill_local_merchant_let_go", [],
   "Sir, I made sure he will not act against you.", "lord_kill_local_merchant_let_go_2",[]],

  [anyone,"lord_kill_local_merchant_let_go_2", [],
   "Piffle. You were supposed to remove him, not give him a sermon and send him on his way.\
 He had better do as you say, or you'll both regret it.\
 Here, this is half the money I promised you. Don't say a word, {playername}, you're lucky to get even that.\
 I have little use for {men/people} who cannot follow orders.", "lord_pretalk",
   [(call_script, "script_troop_add_gold", "trp_player", 300),
     (call_script, "script_change_player_relation_with_troop","$g_talk_troop",2),
     (add_xp_as_reward, 500),
     (call_script, "script_end_quest", "qst_kill_local_merchant"),
     (assign, "$g_leave_encounter", 1)
    ]],

##  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_hunt_down_raiders"),
##                         (check_quest_failed, "qst_hunt_down_raiders")],
##   "I heard that those raiders you were after have got away. Do you have an explanation?", "quest_hunt_down_raiders_failed",[]],
##  [anyone|plyr,"quest_hunt_down_raiders_failed", [],  "They were too quick for us my lord. But next time we'll get them", "quest_hunt_down_raiders_failed_2",[]],
##  [anyone|plyr,"quest_hunt_down_raiders_failed", [],  "They were too strong and well armed my lord. But we'll be ready for them next time.", "quest_hunt_down_raiders_failed_2",[]],
##  
##  [anyone|plyr,"quest_hunt_down_raiders_failed", [],  "Well, it was a long call anyway. Next time do make sure that you are better prepared.",
##   "lord_pretalk",[(call_script, "script_end_quest", "qst_hunt_down_raiders")]],
##
##
##
##  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_hunt_down_raiders"),
##                         (check_quest_succeeded, "qst_hunt_down_raiders")],
##   "I heard that you have given those raiders the punishment they deserved. Well done {playername}.\
## ", "lord_generic_mission_completed",[(call_script, "script_finish_quest", "qst_hunt_down_raiders", 100),
##                                      (call_script, "script_change_player_relation_with_troop","$g_talk_troop",3)]],
##


##  [anyone,"lord_start", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                         (store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_defend_nobles_against_peasants"),
##                         (this_or_next|check_quest_succeeded, "qst_defend_nobles_against_peasants"),
##                         (check_quest_failed, "qst_defend_nobles_against_peasants"),
##                         (assign, ":num_saved", "$qst_defend_nobles_against_peasants_num_nobles_saved"),
##                         (party_count_companions_of_type, ":num_nobles", "p_main_party", "trp_noble_refugee"),
##                         (val_add, ":num_saved", ":num_nobles"),
##                         (party_count_companions_of_type, ":num_nobles", "p_main_party", "trp_noble_refugee_woman"),
##                         (val_add, ":num_saved", ":num_nobles"),
##                         (assign, "$qst_defend_nobles_against_peasants_num_nobles_saved", ":num_saved"),
##                         (eq, ":num_saved", "$qst_defend_nobles_against_peasants_num_nobles_to_save")],
##   "TODO: You have saved all of them. Good boy.", "lord_generic_mission_completed",
##   [(party_remove_members, "p_main_party", "trp_noble_refugee", "$qst_defend_nobles_against_peasants_num_nobles_saved"),
##    (party_remove_members, "p_main_party", "trp_noble_refugee_woman", "$qst_defend_nobles_against_peasants_num_nobles_saved"),
##    (call_script, "script_finish_quest", "qst_defend_nobles_against_peasants", 100)]],
##
##  [anyone,"lord_start", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                         (store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_defend_nobles_against_peasants"),
##                         (this_or_next|check_quest_succeeded, "qst_defend_nobles_against_peasants"),
##                         (check_quest_failed, "qst_defend_nobles_against_peasants"),
##                         (assign, ":num_saved", "$qst_defend_nobles_against_peasants_num_nobles_saved"),
##                         (party_count_companions_of_type, ":num_nobles", "p_main_party", "trp_noble_refugee"),
##                         (val_add, ":num_saved", ":num_nobles"),
##                         (party_count_companions_of_type, ":num_nobles", "p_main_party", "trp_noble_refugee_woman"),
##                         (val_add, ":num_saved", ":num_nobles"),
##                         (assign, "$qst_defend_nobles_against_peasants_num_nobles_saved", ":num_saved"),
##                         (lt, ":num_saved", "$qst_defend_nobles_against_peasants_num_nobles_to_save"),
##                         (gt, "$qst_defend_nobles_against_peasants_num_nobles_saved", 0)],
##   "TODO: You have saved some of them. Half good boy.", "lord_capture_conspirators_half_completed",
##   [(party_remove_members, "p_main_party", "trp_noble_refugee", "$qst_defend_nobles_against_peasants_num_nobles_saved"),
##    (party_remove_members, "p_main_party", "trp_noble_refugee_woman", "$qst_defend_nobles_against_peasants_num_nobles_saved"),
##    (assign, ":ratio", 100),
##    (val_mul, ":ratio", "$qst_defend_nobles_against_peasants_num_nobles_saved"),
##    (val_div, ":ratio", "$qst_defend_nobles_against_peasants_num_nobles_to_save"),
##    (call_script, "script_finish_quest", "qst_defend_nobles_against_peasants", ":ratio")]],
##
##  [anyone,"lord_start", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                         (store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_defend_nobles_against_peasants"),
##                         (this_or_next|check_quest_succeeded, "qst_defend_nobles_against_peasants"),
##                         (check_quest_failed, "qst_defend_nobles_against_peasants"),
##                         (assign, ":num_saved", "$qst_defend_nobles_against_peasants_num_nobles_saved"),
##                         (party_count_companions_of_type, ":num_nobles", "p_main_party", "trp_noble_refugee"),
##                         (val_add, ":num_saved", ":num_nobles"),
##                         (party_count_companions_of_type, ":num_nobles", "p_main_party", "trp_noble_refugee_woman"),
##                         (val_add, ":num_saved", ":num_nobles"),
##                         (eq, ":num_saved", 0)],
##   "TODO: You have saved none of them. Bad boy.", "lord_generic_mission_failed", []],
##
##
##  [anyone,"lord_start", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                         (store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_capture_conspirators"),
##                         (this_or_next|check_quest_succeeded, "qst_capture_conspirators"),
##                         (check_quest_failed, "qst_capture_conspirators"),
##                         (party_count_prisoners_of_type, ":num_conspirators", "p_main_party", "trp_conspirator"),
##                         (party_count_prisoners_of_type, ":num_conspirator_leaders", "p_main_party", "trp_conspirator_leader"),
##                         (store_add, ":sum_captured", ":num_conspirators", ":num_conspirator_leaders"),
##                         (ge, ":sum_captured", "$qst_capture_conspirators_num_troops_to_capture")],
##   "TODO: You have captured all of them. Good boy.", "lord_generic_mission_completed",
##   [(party_remove_prisoners, "p_main_party", "trp_conspirator_leader", "$qst_capture_conspirators_num_troops_to_capture"),
##    (party_remove_prisoners, "p_main_party", "trp_spy_partner", "$qst_capture_conspirators_num_troops_to_capture"),
##    (call_script, "script_finish_quest", "qst_capture_conspirators", 100)]],
##
##  [anyone,"lord_start", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                         (store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_capture_conspirators"),
##                         (this_or_next|check_quest_succeeded, "qst_capture_conspirators"),
##                         (check_quest_failed, "qst_capture_conspirators"),
##                         (party_count_prisoners_of_type, ":num_conspirators", "p_main_party", "trp_conspirator"),
##                         (party_count_prisoners_of_type, ":num_conspirator_leaders", "p_main_party", "trp_conspirator_leader"),
##                         (store_add, ":sum_captured", ":num_conspirators", ":num_conspirator_leaders"),
##                         (lt, ":sum_captured", "$qst_capture_conspirators_num_troops_to_capture"),
##                         (gt, ":sum_captured", 0)],
##   "TODO: You have captured some of them. Half good boy.", "lord_capture_conspirators_half_completed",
##   [(assign, ":sum_removed", 0),
##    (party_remove_prisoners, "p_main_party", "trp_conspirator_leader", "$qst_capture_conspirators_num_troops_to_capture"),
##    (val_add, ":sum_removed", reg0),
##    (party_remove_prisoners, "p_main_party", "trp_conspirator", "$qst_capture_conspirators_num_troops_to_capture"),
##    (val_add, ":sum_removed", reg0),
##    (val_mul, ":sum_removed", 100),
##    (val_div, ":sum_removed", "$qst_capture_conspirators_num_troops_to_capture"),
##    (call_script, "script_finish_quest", "qst_capture_conspirators", ":sum_removed")]],
##
##  [anyone,"lord_start", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                         (store_partner_quest,":lords_quest"),
##                         (eq,":lords_quest","qst_capture_conspirators"),
##                         (this_or_next|check_quest_succeeded, "qst_capture_conspirators"),
##                         (check_quest_failed, "qst_capture_conspirators"),
##                         (party_count_prisoners_of_type, ":num_conspirators", "p_main_party", "trp_conspirator"),
##                         (party_count_prisoners_of_type, ":num_conspirator_leaders", "p_main_party", "trp_conspirator_leader"),
##                         (store_add, ":sum_captured", ":num_conspirators", ":num_conspirator_leaders"),
##                         (eq, ":sum_captured", 0)],
##   "TODO: You have captured none of them. Bad boy.", "lord_generic_mission_failed", []],
##
##  [anyone|plyr,"lord_capture_conspirators_half_completed", [],
##   "TODO: That's all I can do.", "lord_pretalk", []],


  [anyone,"lord_start", [#(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
						 (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
                         (store_partner_quest,":lords_quest"),
                         (eq,":lords_quest","qst_follow_spy"),
                         (eq, "$qst_follow_spy_no_active_parties", 1),
                         (party_count_prisoners_of_type, ":num_spies", "p_main_party", "trp_spy"),
                         (party_count_prisoners_of_type, ":num_spy_partners", "p_main_party", "trp_spy_partner"),
                         (gt, ":num_spies", 0),
                         (gt, ":num_spy_partners", 0)],
   "Beautiful work, {playername}! You captured both the spy and his handler, just as I'd hoped,\
 and the pair are now safely ensconced in my dungeon, waiting to be questioned.\
 My torturer shall be busy tonight! Anyway, I'm very pleased with your success, {playername}, and I give you\
 this purse as a token of my appreciation.", "lord_follow_spy_completed",
   [(party_remove_prisoners, "p_main_party", "trp_spy", 1),
    (party_remove_prisoners, "p_main_party", "trp_spy_partner", 1),
    (call_script, "script_change_player_relation_with_troop","$g_talk_troop",4),
    (call_script, "script_troop_add_gold", "trp_player", 2000),
    (add_xp_as_reward, 4000),
    (call_script, "script_end_quest", "qst_follow_spy")]],

  [anyone,"lord_start", [#(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
						 (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
                         (store_partner_quest,":lords_quest"),
                         (eq,":lords_quest","qst_follow_spy"),
                         (eq, "$qst_follow_spy_no_active_parties", 1),
                         (party_count_prisoners_of_type, ":num_spies", "p_main_party", "trp_spy"),
                         (party_count_prisoners_of_type, ":num_spy_partners", "p_main_party", "trp_spy_partner"),
                         (gt, ":num_spies", 0),
                         (eq, ":num_spy_partners", 0),],
   "Blast and damn you! I wanted TWO prisoners, {playername} -- what you've brought me is one step short of\
 useless! I already know everything the spy knows, it was the handler I was after.\
 Here, half a job gets you half a reward. Take it and begone.", "lord_follow_spy_half_completed",
   [(party_remove_prisoners, "p_main_party", "trp_spy", 1),
    (call_script, "script_change_player_relation_with_troop","$g_talk_troop",-1),
    (call_script, "script_troop_add_gold", "trp_player", 1000),
    (add_xp_as_reward, 400),
    (call_script, "script_end_quest", "qst_follow_spy")]],

  [anyone,"lord_start", [#(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
					     (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
                         (store_partner_quest,":lords_quest"),
                         (eq,":lords_quest","qst_follow_spy"),
                         (eq, "$qst_follow_spy_no_active_parties", 1),
                         (party_count_prisoners_of_type, ":num_spies", "p_main_party", "trp_spy"),
                         (party_count_prisoners_of_type, ":num_spy_partners", "p_main_party", "trp_spy_partner"),
                         (eq, ":num_spies", 0),
                         (gt, ":num_spy_partners", 0),
                         ],
   "I asked you for two prisoners, {playername}, not one. Two. Still, I suppose you did capture the spy's handler,\
 the more important one of the pair. The spy will not dare return here and will prove quite useless to\
 whatever master he served. 'Tis better than nothing.\
 However, you'll understand if I pay you half the promised reward for what is but half a success.", "lord_follow_spy_half_completed",
   [(party_remove_prisoners, "p_main_party", "trp_spy_partner", 1),
    (call_script, "script_change_player_relation_with_troop","$g_talk_troop",1),
    (call_script, "script_troop_add_gold", "trp_player", 1000),
    (add_xp_as_reward, 400),
    (call_script, "script_end_quest", "qst_follow_spy")]],

  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
                         (eq,":lords_quest","qst_follow_spy"),
                         (eq, "$qst_follow_spy_no_active_parties", 1),
                         (party_count_prisoners_of_type, ":num_spies", "p_main_party", "trp_spy"),
                         (party_count_prisoners_of_type, ":num_spy_partners", "p_main_party", "trp_spy_partner"),
                         (eq, ":num_spies", 0),
                         (eq, ":num_spy_partners", 0),
                         ],
   "Truly, {playername}, you are nothing short of totally incompetent.\
 Failing to capture both the spy AND his handler plumbs astonishing new depths of failure.\
 Forget any reward I offered you. You've done nothing to earn it.", "lord_follow_spy_failed",
   [
    (call_script, "script_change_player_relation_with_troop","$g_talk_troop",-2),
    (call_script, "script_end_quest", "qst_follow_spy"),
    ]],

  [anyone|plyr,"lord_follow_spy_half_completed", [],
   "I did my best, {s65}.", "lord_pretalk", []],

  [anyone|plyr,"lord_follow_spy_completed", [],
   "Thank you, {s65}.", "lord_pretalk", []],

  [anyone|plyr,"lord_follow_spy_failed", [],
   "Hrm. As you like, {s65}.", "lord_pretalk", []],


  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
                         (eq,":lords_quest","qst_bring_back_runaway_serfs"),
                         (check_quest_succeeded, "qst_bring_back_runaway_serfs")],
   "Splendid work, {playername}. All the serfs are back, properly cowed, and they're busy preparing for the harvest.\
 You certainly earned your reward. Here, take it, with my compliments.", "lord_generic_mission_completed",
   [(call_script, "script_change_player_relation_with_troop","$g_talk_troop", 2),
    (call_script, "script_troop_add_gold", "trp_player", 300),
    (add_xp_as_reward, 300),
    (call_script, "script_end_quest", "qst_bring_back_runaway_serfs"),
    (call_script, "script_objectionable_action", tmt_humanitarian, "str_round_up_serfs"),
    ]],

  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
                         (eq,":lords_quest","qst_bring_back_runaway_serfs"),
                         (check_quest_failed, "qst_bring_back_runaway_serfs"),],
   "{playername}. I have been waiting patiently for my serfs, yet none have returned. Have you an explanation?\
 Were you outwitted by simple fieldhands, or are you merely incompetent?\
 Or perhaps you are plotting with my enemies, intending to ruin me...", "lord_bring_back_runaway_serfs_failed", []],
  [anyone|plyr,"lord_bring_back_runaway_serfs_failed", [],
   "Forgive me, {s65}, those serfs were slippery as eels.", "lord_bring_back_runaway_serfs_failed_1a", []],
  [anyone|plyr,"lord_bring_back_runaway_serfs_failed", [],
   "Perhaps if you had treated them better...", "lord_bring_back_runaway_serfs_failed_1b", []],
  [anyone,"lord_bring_back_runaway_serfs_failed_1a", [],
   "Hmph, that is hardly an excuse for failure, {playername}.\
 Now if you will excuse me, I need to recruit new men to work these fields before we all starve.", "lord_pretalk",
   [(call_script, "script_change_player_relation_with_troop","$g_talk_troop",-1),
    (call_script, "script_end_quest", "qst_bring_back_runaway_serfs")]],
  [anyone,"lord_bring_back_runaway_serfs_failed_1b", [],
   "Hah, now you reveal your true colours, traitor! Your words match your actions all too well. I should never have trusted you.", "close_window",
   [(call_script, "script_change_player_relation_with_troop","$g_talk_troop",-10),
    (quest_get_slot, ":home_village", "qst_bring_back_runaway_serfs", slot_quest_object_center),
    (call_script, "script_change_player_relation_with_center",":home_village",6),
    (call_script, "script_end_quest", "qst_bring_back_runaway_serfs"),
    (assign, "$g_leave_encounter", 1),
    ]],

  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
                         (eq,":lords_quest","qst_bring_back_runaway_serfs"),
                         (check_quest_concluded, "qst_bring_back_runaway_serfs"),
                         (assign, reg17, "$qst_bring_back_runaway_serfs_num_parties_returned")],
   "You disappoint me, {playername}. There were 3 groups of serfs that I charged you to return. 3. Not {reg17}.\
 I suppose the ones who did come back shall have to work twice as hard to make up for those that got away.\
 As for your reward, {playername}, I'll only pay you for the serfs you returned, not the ones you let fly.\
 Here. Take it, and let this business be done.", "lord_runaway_serf_half_completed",
   [(store_mul, ":reward", "$qst_bring_back_runaway_serfs_num_parties_returned", 100),
    (val_div, ":reward", 2),
#	(store_div, ":relation_boost", "$qst_bring_back_runaway_serfs_num_parties_returned", 1),
#    (call_script, "script_change_player_relation_with_troop","$g_talk_troop", ":relation_boost"),
    (call_script, "script_troop_add_gold", "trp_player", ":reward"),
    (add_xp_as_reward, ":reward"),


    (call_script, "script_objectionable_action", tmt_humanitarian, "str_round_up_serfs"),
    
    (call_script, "script_end_quest", "qst_bring_back_runaway_serfs"),
    ]],

  [anyone|plyr,"lord_runaway_serf_half_completed", [],
   "Thank you, {s65}. You are indeed generous.", "lord_pretalk", []],
  [anyone|plyr,"lord_runaway_serf_half_completed", [],
   "Bah, this proved to be a waste of my time.", "lord_pretalk", []],

  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
                         (eq,":lords_quest","qst_deal_with_bandits_at_lords_village"),
                         (check_quest_succeeded, "qst_deal_with_bandits_at_lords_village")],
   "{playername}, I was told that you have crushed the bandits at my village of {s5}. Please know that I am most grateful to you for that.\
 Please, let me pay the expenses of your campaign. Here, I hope these {reg14} denars will be adequate.", "lord_deal_with_bandits_completed",
   [
       (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 3),
       (store_character_level, ":level", "trp_player"),
       (store_mul, ":reward", ":level", 20),
       (val_add, ":reward", 300),
       (call_script, "script_troop_add_gold", "trp_player", ":reward"),
       (add_xp_as_reward, 350),
       (call_script, "script_end_quest", "qst_deal_with_bandits_at_lords_village"),
       (assign, reg14, ":reward"),
       (quest_get_slot, ":village", "qst_deal_with_bandits_at_lords_village", slot_quest_target_center),
       (str_store_party_name, s5, ":village"),
       ]],

  [anyone|plyr, "lord_deal_with_bandits_completed", [],
   "Not a problem, {s65}.", "lord_pretalk",[]],
  [anyone|plyr, "lord_deal_with_bandits_completed", [],
   "Glad to be of service.", "lord_pretalk",[]],
  [anyone|plyr, "lord_deal_with_bandits_completed", [],
   "It was mere child's play.", "lord_pretalk",[]],

  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
                         (eq,":lords_quest","qst_deal_with_bandits_at_lords_village"),
                         (check_quest_concluded, "qst_deal_with_bandits_at_lords_village")],
   "Damn it, {playername}. I heard that you were unable to drive off the bandits from my village of {s5}, and thanks to you, my village now lies in ruins.\
 Everyone said that you were a capable warrior, but appearently, they were wrong.", "lord_pretalk",
   [
       (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", -5),
       (call_script, "script_end_quest", "qst_deal_with_bandits_at_lords_village"),
       (quest_get_slot, ":village", "qst_deal_with_bandits_at_lords_village", slot_quest_target_center),
       (str_store_party_name, s5, ":village"),
       ]],


  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
                         (eq, ":lords_quest", "qst_deliver_cattle_to_army"),
                         (check_quest_succeeded, "qst_deliver_cattle_to_army"),
                         (quest_get_slot, reg13, "qst_deliver_cattle_to_army", slot_quest_target_amount),
                         ],
   "Ah, {playername}. My quartermaster has informed me of your delivery, {reg13} heads of cattle, as I requested. I'm impressed.", "lord_deliver_cattle_to_army_thank",
   [
     (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 2),
     (quest_get_slot, ":quest_target_amount", "qst_deliver_cattle_to_army", slot_quest_target_amount),
     #TODO: Change reward
     (store_mul, ":reward", ":quest_target_amount", 100),
     (call_script, "script_troop_add_gold", "trp_player", ":reward"),
     (val_div, ":reward", 5),
     (add_xp_as_reward, ":reward"),
     (call_script, "script_end_quest", "qst_deliver_cattle_to_army"),
     #Reactivating follow army quest
     (str_store_troop_name_link, s9, "$g_talk_troop"),
     (setup_quest_text, "qst_follow_army"),
     (str_store_string, s2, "str_follow_army_quest_brief_2"),
     (call_script, "script_start_quest", "qst_follow_army", "$g_talk_troop"),
     (assign, "$g_player_follow_army_warnings", 0),
     ]],

  [anyone|plyr, "lord_deliver_cattle_to_army_thank", [],
   "Not a problem, {s65}.", "lord_pretalk",[]],
  [anyone|plyr, "lord_deliver_cattle_to_army_thank", [],
   "Glad to be of service.", "lord_pretalk",[]],
  [anyone|plyr, "lord_deliver_cattle_to_army_thank", [],
   "Mere child's play.", "lord_pretalk",[]],

  [anyone,"lord_start", [(store_partner_quest,":lords_quest"),
                         (eq, ":lords_quest", "qst_scout_waypoints"),
                         (check_quest_succeeded, "qst_scout_waypoints"),
                         (str_store_party_name, s13, "$qst_scout_waypoints_wp_1"),
                         (str_store_party_name, s14, "$qst_scout_waypoints_wp_2"),
                         (str_store_party_name, s15, "$qst_scout_waypoints_wp_3"),
                         ],
   "You make a good scout, {playername}. My runner just brought me your reports of the mission to {s13}, {s14} and {s15}. Well done.", "lord_scout_waypoints_thank",
   [
     #TODO: Change reward
     (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 1),
#     (call_script, "script_troop_add_gold", "trp_player", 100),
     (add_xp_as_reward, 100),
     (call_script, "script_end_quest", "qst_scout_waypoints"),
     #Reactivating follow army quest
     (str_store_troop_name_link, s9, "$g_talk_troop"),
     (setup_quest_text, "qst_follow_army"),
     (str_store_string, s2, "str_follow_army_quest_brief_2"),
     (call_script, "script_start_quest", "qst_follow_army", "$g_talk_troop"),
     (assign, "$g_player_follow_army_warnings", 0),
     ]],

  [anyone|plyr, "lord_scout_waypoints_thank", [],
   "A simple task, {s65}.", "lord_pretalk",[]],
  [anyone|plyr, "lord_scout_waypoints_thank", [],
   "Nothing I couldn't handle.", "lord_pretalk",[]],
  [anyone|plyr, "lord_scout_waypoints_thank", [],
   "My pleasure, {s65}.", "lord_pretalk",[]],
  


  [anyone, "lord_start",
   [
     (check_quest_active, "qst_follow_army"),
     (faction_slot_eq, "$g_talk_troop_faction", slot_faction_marshall, "$g_talk_troop"),
     (eq, "$g_random_army_quest", "qst_deliver_cattle_to_army"),
     (quest_get_slot, ":quest_target_amount", "$g_random_army_quest", slot_quest_target_amount),
     (assign, reg3, ":quest_target_amount"),
     ],
   "The army's supplies are dwindling too quickly, {playername}. I need you to bring me {reg3} heads of cattle so I can keep the troops fed. I care very little about where you get them, just bring them to me as soon as you can.", "lord_mission_told_deliver_cattle_to_army",
   [
   ]
   ],

  [anyone|plyr,"lord_mission_told_deliver_cattle_to_army", [], "Very well, I can find you some cattle.", "lord_mission_told_deliver_cattle_to_army_accepted",[]],
  [anyone|plyr,"lord_mission_told_deliver_cattle_to_army", [], "Sorry, sir, I have other plans.", "lord_mission_told_deliver_cattle_to_army_rejected",[]],

  [anyone,"lord_mission_told_deliver_cattle_to_army_accepted", [], "Excellent! You know what to do, {playername}, now get to it. I need that cattle sooner rather than later.", "close_window",
   [
     (call_script, "script_end_quest", "qst_follow_army"),
     (quest_get_slot, ":quest_target_amount", "$g_random_army_quest", slot_quest_target_amount),
     (str_store_troop_name_link, s13, "$g_talk_troop"),
     (assign, reg3, ":quest_target_amount"),
     (setup_quest_text, "$g_random_army_quest"),
     (str_store_string, s2, "@{s13} asked you to gather {reg3} heads of cattle and deliver them back to him."),
     (call_script, "script_start_quest", "$g_random_army_quest", "$g_talk_troop"),
     #TODO: Change this value
     (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 1),
     (assign, "$g_leave_encounter",1),
    ]],

  [anyone, "lord_mission_told_deliver_cattle_to_army_rejected", [], "That . . . is unfortunate, {playername}. I shall have to find someone else who's up to the task. Please go now, I've work to do.", "close_window",
   [(troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1),
    (assign, "$g_leave_encounter",1),]],
  

  [anyone,"lord_start",[(check_quest_active,"qst_report_to_army"),
                        (quest_slot_eq, "qst_report_to_army", slot_quest_target_troop, "$g_talk_troop"),
						(assign, ":kingdom_at_war", 0),
						(try_for_range, ":kingdom", kingdoms_begin, kingdoms_end),
							(store_relation, ":relation", ":kingdom", "$players_kingdom"),
							(lt, ":relation", 0),
							(assign, ":kingdom_at_war", 1),
						(try_end),
						(eq, ":kingdom_at_war", 0),
                        ],
   "Thank you for answering the summons, {playername}. However, as we are now at peace, we do not need your services. You may attend to your other business.", "lord_pretalk",
   [
    (call_script, "script_end_quest", "qst_report_to_army"),
	(quest_set_slot, "qst_report_to_army", slot_quest_giver_troop, "$g_talk_troop"),
     #TODO: Change this value
    (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 1),
   ]],

  [anyone,"lord_start",[
					    (check_quest_active,"qst_report_to_army"),
                        (quest_slot_eq, "qst_report_to_army", slot_quest_target_troop, "$g_talk_troop"),
                        ],
   "Ah, you have arrived at last, {playername}. We've been expecting you. I hope you have brought with you troops of sufficient number and experience.", "lord_report_to_army_asked",
   []],

  [anyone|plyr,"lord_report_to_army_asked", [(quest_get_slot, ":quest_target_amount", "qst_report_to_army", slot_quest_target_amount),
                                             (call_script, "script_party_count_fit_for_battle", "p_main_party"),
                                             (gt, reg0, ":quest_target_amount"), # +1 for player
                                             ],
   "I have a company of good, hardened soldiers with me. We are ready to join you.", "lord_report_to_army_completed",
   []],

  [anyone|plyr,"lord_report_to_army_asked", [],
   "I don't have the sufficient number of troops yet. I will need some more time.", "lord_report_to_army_continue",
   []],

  [anyone,"lord_report_to_army_completed", [], "Excellent. We'll be moving soon. Now -- you are a {man/warrior} of sound judgement, and we trust that you will do what is necessary to support our campaign. I do not require you to remain close at hand, and I will not count it against you if you believe that your forces would be of better use elsewhere. But if you do choose to remain with me, to support me in battle, that would be appreciated. I may also have additional tasks for you to perform.", "close_window",[
     (call_script, "script_end_quest", "qst_report_to_army"),
     (quest_set_slot, "qst_report_to_army", slot_quest_giver_troop, "$g_talk_troop"),
     #TODO: Change this value
     (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 1),
     #Activating follow army quest
     (str_store_troop_name_link, s9, "$g_talk_troop"),
     (setup_quest_text, "qst_follow_army"),
     (str_store_string, s2, "@{s9} wants you to follow his army until further notice."),
     (call_script, "script_start_quest", "qst_follow_army", "$g_talk_troop"),
     (assign, "$g_player_follow_army_warnings", 0),
     (assign, "$g_leave_encounter", 1),
   ]],

  [anyone,"lord_report_to_army_continue", [], "Then you'd better hurry. We'll be moving out soon against the enemy and I need every able hand we can muster.", "close_window",
   [(assign, "$g_leave_encounter",1),
    #Must be closed because of not letting player to terminate this quest on the general conversation
    ]],


  [anyone, "lord_start",
   [
     (check_quest_active, "qst_follow_army"),
     (faction_slot_eq, "$players_kingdom", slot_faction_marshall, "$g_talk_troop"),
     (eq, "$g_random_army_quest", "qst_scout_waypoints"),
     (str_store_party_name, s13, "$qst_scout_waypoints_wp_1"),
     (str_store_party_name, s14, "$qst_scout_waypoints_wp_2"),
     (str_store_party_name, s15, "$qst_scout_waypoints_wp_3"),
     ],
   "{playername}, I need a volunteer to scout the area. We're sorely lacking on information,\
 and I simply must have a better picture of the situation before we can proceed.\
 I want you to go to {s13}, {s14} and {s15} and report back whatever you find.", "lord_mission_told_scout_waypoints",
   [
   ]],

  [anyone|plyr, "lord_mission_told_scout_waypoints", [], "You've found your volunteer, sir.", "lord_mission_told_scout_waypoints_accepted",[]],
  [anyone|plyr, "lord_mission_told_scout_waypoints", [], "I fear I must decline.", "lord_mission_told_scout_waypoints_rejected",[]],

  [anyone,"lord_mission_told_scout_waypoints_accepted", [], "Good {man/lass}! Simply pass near {s13}, {s14} and {s15} and check out what's there. Make a note of anything you find and return to me as soon as possible.", "close_window",
   [
     (call_script, "script_end_quest", "qst_follow_army"),
     (str_store_troop_name_link, s9, "$g_talk_troop"),
     (str_store_party_name_link, s13, "$qst_scout_waypoints_wp_1"),
     (str_store_party_name_link, s14, "$qst_scout_waypoints_wp_2"),
     (str_store_party_name_link, s15, "$qst_scout_waypoints_wp_3"),
     (setup_quest_text, "$g_random_army_quest"),
     (str_store_string, s2, "@{s9} asked you to scout {s13}, {s14} and {s15}, then report back."),
     (call_script, "script_start_quest", "$g_random_army_quest", "$g_talk_troop"),
     #TODO: Change this value
     (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 1),
     (assign, "$g_leave_encounter",1),
    ]],

  [anyone,"lord_mission_told_scout_waypoints_rejected", [], "Hm. I'm disappointed, {playername}. Very disappointed. We'll talk later, I need to go and find somebody to scout for us.", "lord_pretalk",
   [(troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1)]],


  

##
##  [anyone,"lord_start",[(check_quest_active,"qst_rescue_lady_under_siege"),
##                        (quest_slot_eq, "qst_rescue_lady_under_siege", slot_quest_target_troop, "$g_talk_troop"),
##                        (quest_slot_eq, "qst_rescue_lady_under_siege", slot_quest_current_state, 1)],
##   "I heard that you have rescued my {s7} from the siege of {s5} and brought her to safety.\
## I am in your debt for this {playername}. Thank you.", "lord_generic_mission_completed",
##   [(quest_get_slot, ":quest_object_troop", "qst_rescue_lady_under_siege", slot_quest_object_troop),
##    (try_begin),
##      (troop_slot_eq, "$g_talk_troop", slot_troop_daughter, ":quest_object_troop"),
##      (str_store_string, s7, "str_daughter"),
##    (else_try),
##      (str_store_string, s7, "str_wife"),
##    (try_end),
##    (remove_member_from_party, ":quest_object_troop"),
##    (try_begin),
##      (is_between, "$g_encountered_party", centers_begin, centers_end),#Lord might be in wilderness
##      (troop_set_slot, ":quest_object_troop", slot_troop_cur_center, "$g_encountered_party"),
##    (try_end),
##    (call_script, "script_finish_quest", "qst_rescue_lady_under_siege", 100),
##    (call_script, "script_change_player_relation_with_troop","$g_talk_troop", 4),    
##    ]],
##
##### TODO: QUESTS COMMENT OUT END
  [anyone,"lord_generic_mission_thank", [],
   "You have been most helpful, {playername}. My thanks.", "lord_generic_mission_completed",[]],

  [anyone|plyr,"lord_generic_mission_completed", [],
   "It was an honour to serve.", "lord_pretalk",[]],

##  [anyone|plyr,"lord_generic_mission_failed", [],
##   "I'm sorry I failed you sir. It won't happen again.", "lord_pretalk",
##   [(store_partner_quest,":lords_quest"),
##    (call_script, "script_finish_quest", ":lords_quest"),
##    ]],
  
  [anyone,"lord_start", [#(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
                         (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
                         (troop_get_slot, ":cur_debt", "$g_talk_troop", slot_troop_player_debt),
                         (gt, ":cur_debt", 0),
                         (assign, reg1, ":cur_debt")],
   "I think you owe me {reg1} denars, {playername}. Do you intend to pay your debt anytime soon?", "lord_pay_debt_2",[]],

  [anyone|plyr, "lord_pay_debt_2", [(troop_get_slot, ":cur_debt", "$g_talk_troop", slot_troop_player_debt),
                                    (store_troop_gold, ":cur_gold", "trp_player"),
                                    (le, ":cur_debt", ":cur_gold")],
   "That is why I came, {s65}. Here it is, every denar I owe you.", "lord_pay_debt_3_1", [(troop_get_slot, ":cur_debt", "$g_talk_troop", slot_troop_player_debt),
                                                   (troop_remove_gold, "trp_player", ":cur_debt"),
                                                   (troop_set_slot, "$g_talk_troop", slot_troop_player_debt, 0)]],

  [anyone|plyr, "lord_pay_debt_2", [],
   "Alas, I don't have sufficient funds, {s65}. But I'll pay you soon enough.", "lord_pay_debt_3_2", []],

  [anyone, "lord_pay_debt_3_1", [],
   "Ah, excellent. You are a {man/woman} of honour, {playername}. I am satisfied. Your debt to me has been paid in full.", "lord_pretalk", []],

  [anyone, "lord_pay_debt_3_2", [],
   "Well, don't keep me waiting much longer.", "lord_pretalk", []],

##  [anyone,"lord_start", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                         (is_between,"$g_talk_troop_faction_relation",0,3),
###                         (eq,"$players_kingdom",0),
##                         ],
##   "Why don't you join us in our cause? You seem to be an able fighter.\
## We need {men/people} like you who will take part in our glory and share the spoils of our victory.", "lord_talk",[]],


#Claim center begin
##  [anyone,"lord_start", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                         (eq,"$g_talk_troop_faction","$players_kingdom"),
##                         (faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
##                         (call_script, "script_get_number_of_unclaimed_centers_by_player"),
##                         (gt, reg1, 0),
##                         (assign, "$center_to_be_claimed", reg1),
##                         (str_store_party_name, s4, "$center_to_be_claimed"),
##                         ],
##   "I heard that your forces have taken {s4}. I commend you for your victory {playername}.\
## But we need to decide what to do with this new castle now.", "lord_claim_center_begin", []],


##  [anyone,"lord_start", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                         (ge,"$g_talk_troop_faction_relation",0),
##                         (call_script, "script_get_number_of_unclaimed_centers_by_player"),
##                         (gt, reg1, 0),
##                         (assign, "$center_wanted_to_be_bought", reg1),
##                         (str_store_party_name, s4, "$center_wanted_to_be_bought"),
##                         (call_script, "script_get_number_of_hero_centers", "$g_talk_troop"),
##                         (assign, ":no_of_owned_centers", reg0),
##                         (neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
##                         (lt, ":no_of_owned_centers", 2),
##                         (troop_get_slot, ":wealth", "$g_talk_troop", slot_troop_wealth),
##                         (ge, ":wealth", 6000)],
##   "I heard that your forces have taken {s4}. I applaud your victory {playername}, but you know as well as I do that\
## as a person of low rank and status you cannot be permitted to hold that castle for yourself.\
## It is to your benefit to sell it to a Lord like myself who can hold and protect the castle and the surrounding estates.\
## Anyway, I am ready to make you an offer of 5000 denars, should you decide to sell that castle.", "lord_buy_center", []],
##
##
##  [anyone|plyr,"lord_buy_center", [],
##   "I accept your offer sir. The castle is yours for 5000 denars.", "lord_buy_center_accept", []],
##  [anyone|plyr,"lord_buy_center", [],
##   "I am afraid I can't accept that offer.", "lord_buy_center_deny", []],
##
##  [anyone,"lord_buy_center_accept", [],
##   "Excellent, {playername}! You have decided wisely.\
## Why bother yourself with the necessities of keeping a castle while you can leave all those boring details to noble Lords like me?\
## I am sure money will be much more useful to you than a castle would.", "lord_buy_center_accept_2", []],
##
##  [anyone|plyr,"lord_buy_center_accept_2", [],
##   "One day sir, one day I'll have my own castle.", "lord_buy_center_accept_3", []],
##  [anyone|plyr,"lord_buy_center_accept_2", [],
##   "Everyone needs money sir. I can take another castle anytime.", "lord_buy_center_accept_3", []],
##
##  [anyone,"lord_buy_center_accept_3", [],
##   "Of course, of course, {playername}.  Then let us conclude our deal. Here's the 5000 denars I offered you.\
## I'll have my clerk handle the necessary details.\
## I guess from now on, {s4} belongs to me. Well, that worked very well for both of us, I guess.", "lord_pretalk",
##   [(troop_get_slot, ":wealth", "$g_talk_troop", slot_troop_wealth),
##    (val_sub, ":wealth", 6000),
##    (troop_set_slot, "$g_talk_troop", slot_troop_wealth, ":wealth"),
##    (call_script, "script_troop_add_gold", "trp_player", 5000),
##    (party_set_slot, "$center_wanted_to_be_bought", slot_town_lord, "$g_talk_troop"),
##    #Changing center faction
##    (party_set_faction, "$center_wanted_to_be_bought", "$g_talk_troop_faction"),
##    (set_spawn_radius, 1),
##    (spawn_around_party, "$center_wanted_to_be_bought", "pt_old_garrison"),
##    (assign, ":new_party", reg0),
##    (party_set_ai_behavior, ":new_party", ai_bhvr_attack_party),
##    (party_set_ai_object, ":new_party", "p_main_party"),
##    (party_set_flags, ":new_party", pf_default_behavior, 0),
##    (call_script, "script_party_copy", ":new_party", "$center_wanted_to_be_bought"),
##    (party_clear, "$center_wanted_to_be_bought"),
##
##    (faction_get_slot, ":reinforcement_template_archers", "$g_talk_troop_faction", slot_faction_reinforcements_archers),
##    (faction_get_slot, ":reinforcement_template_infantry", "$g_talk_troop_faction", slot_faction_reinforcements_infantry),
##    (party_add_template, "$center_wanted_to_be_bought", ":reinforcement_template_archers"),
##    (party_add_template, "$center_wanted_to_be_bought", ":reinforcement_template_infantry"),
##    ]],
##
##  [anyone,"lord_buy_center_deny", [],
##   "As you wish {playername}. But don't forget, the great lords of the country won't like a low born {man/woman} like you holding such an estate without their consent.\
## It is the nature of this world {playername}. Everyone should know their place.", "lord_pretalk", []],


  [anyone,"lord_start",[
						(eq, "$g_romantic_comment_made", 0),
						(ge, "$g_talk_troop_relation", 20),
						(troop_slot_ge, "trp_player", slot_troop_renown, 250),
						(neg|troop_slot_ge, "trp_player", slot_troop_spouse, kingdom_ladies_begin),
						
						(troop_get_type, ":is_female", "trp_player"),
						(eq, ":is_female", 0),
						
						(assign, ":third_party_introduce", 0),
						
						(try_for_range, ":lady", kingdom_ladies_begin, kingdom_ladies_end),
							(troop_slot_eq, ":lady", slot_troop_spouse, -1),
							(troop_slot_eq, ":lady", slot_troop_betrothed, -1),
							(troop_slot_eq, ":lady", slot_troop_cur_center, "$g_encountered_party"),
							(neg|troop_slot_ge, ":lady", slot_troop_met, 4),
							
							(call_script, "script_get_kingdom_lady_social_determinants", ":lady"),
							(eq, reg0, "$g_talk_troop"),
							
							(assign, "$marriage_candidate", ":lady"), 
							(call_script, "script_npc_decision_checklist_male_guardian_assess_suitor", "$g_talk_troop", "trp_player"),
							(gt, reg0, 0),
							
							(assign, ":third_party_introduce", ":lady"),
						(try_end),
						(gt, ":third_party_introduce", 0),
						(troop_slot_eq, ":third_party_introduce", slot_troop_met, 0),

						(call_script, "script_troop_get_family_relation_to_troop", ":third_party_introduce", "$g_talk_troop"),
						(str_store_troop_name, s14, ":third_party_introduce"),
						],
   "By the way, I hope you get a chance to meet my {s11}, {s14}.  ", "lord_start",
   [
						(troop_set_slot, "$g_talk_troop", slot_lord_granted_courtship_permission, 1),
						(assign, "$g_romantic_comment_made", 1),
     ]],


  [anyone,"lord_start",[
						(eq, "$g_romantic_comment_made", 0),
						(ge, "$g_talk_troop_relation", 20),
						(troop_slot_ge, "trp_player", slot_troop_renown, 250),
						(assign, ":third_party_introduce", 0),
						
						(neg|troop_slot_ge, "trp_player", slot_troop_spouse, kingdom_ladies_begin),
						(troop_get_type, ":is_female", "trp_player"),
						(eq, ":is_female", 0),
						
						(try_for_range, ":lady", kingdom_ladies_begin, kingdom_ladies_end),
							(troop_slot_eq, ":lady", slot_troop_spouse, -1),
							(troop_slot_eq, ":lady", slot_troop_betrothed, -1),
							(troop_slot_eq, ":lady", slot_troop_cur_center, "$g_encountered_party"),
							(neg|troop_slot_ge, ":lady", slot_troop_met, 4),
							
							(call_script, "script_get_kingdom_lady_social_determinants", ":lady"),
							(eq, reg0, "$g_talk_troop"),
							
							(assign, "$marriage_candidate", ":lady"), 
							(call_script, "script_npc_decision_checklist_male_guardian_assess_suitor", "$g_talk_troop", "trp_player"),
							(gt, reg0, 0),
							
							(troop_slot_ge, ":lady", slot_troop_met, 1),
							
							(store_current_hours, ":hours"),
							(troop_get_slot, ":lady_last_met_hour", ":lady", slot_troop_last_talk_time),
							(val_sub, ":hours", ":lady_last_met_hour"),
							(ge, ":hours", 24),
							
							(assign, ":third_party_introduce", ":lady"),
						(try_end),
						
						(gt, ":third_party_introduce", 0),
						(call_script, "script_troop_get_family_relation_to_troop", ":third_party_introduce", "$g_talk_troop"),
						(str_store_troop_name, s14, ":third_party_introduce"),
						
						],
   "By the way, I am sure that my {s11}, {s14}, would be delighted were you to pay her a visit. She awaits you in her chambers.", "lord_start",
   [
		(troop_set_slot, "$g_talk_troop", slot_lord_granted_courtship_permission, 1),
		(assign, "$g_romantic_comment_made", 1),
		
     ]],



  [anyone,"lord_start", [(party_slot_eq, "$g_encountered_party",slot_town_lord, "$g_talk_troop"),#we are talking to Town's Lord.
                         (ge,"$g_talk_troop_faction_relation",0),
                         (neq, "$g_ransom_offer_rejected", 1),
                         (lt, "$g_encountered_party_2", 0), #town is not under siege
                         (hero_can_join_as_prisoner, "$g_encountered_party"),
                         (store_random_in_range, ":random_no", 0, 100),
                         (lt, ":random_no", 10),#start this conversation with a 10% chance
                         (party_get_num_prisoner_stacks,":num_prisoner_stacks","p_main_party"),
                         (assign, "$prisoner_lord_to_buy", -1),
                         (try_for_range,":i_pris_stack",0,":num_prisoner_stacks"),
                           (party_prisoner_stack_get_troop_id, ":t_id", "p_main_party", ":i_pris_stack"),
                           (troop_slot_eq, ":t_id", slot_troop_occupation, slto_kingdom_hero),
                           (store_troop_faction, ":fac", ":t_id"),
                           (store_relation, ":rel", ":fac", "$g_talk_troop_faction"),
                           (lt,  ":rel", 0),
                           (assign, "$prisoner_lord_to_buy", ":t_id"),
                         (try_end),
                         (gt, "$prisoner_lord_to_buy", 0), #we have a prisoner lord.
                         (assign, ":continue", 1),
                         (try_begin),
                           (check_quest_active, "qst_capture_enemy_hero"),
                           (store_troop_faction, ":prisoner_faction", "$prisoner_lord_to_buy"),
                           (quest_slot_eq, "qst_capture_enemy_hero", slot_quest_target_faction, ":prisoner_faction"),
                           (assign, ":continue", 0),
                         (try_end),
                         (eq, ":continue", 1),
                         (str_store_troop_name, s3, "$prisoner_lord_to_buy"),
                         (assign, reg5, "$prisoner_lord_to_buy"),
                         (call_script, "script_calculate_ransom_amount_for_troop", "$prisoner_lord_to_buy"),
                         (assign, reg6, reg0),
                         (val_div, reg6, 2),
                         (assign, "$temp", reg6),
                         ],
   "I heard that you have captured our enemy {s3} and he is with you at the moment.\
 I can pay you {reg6} denars for him if you want to get rid of him.\
 You can wait for his family to pay his ransom of course, but there is no telling how long that will take, eh?\
", "lord_buy_prisoner", []],

  [anyone|plyr,"lord_buy_prisoner", [],
   "I accept your offer. I'll leave {s3} to you for {reg6} denars.", "lord_buy_prisoner_accept", []],
  [anyone|plyr,"lord_buy_prisoner", [],
   "I fear I can't accept your offer.", "lord_buy_prisoner_deny", [(assign, "$g_ransom_offer_rejected", 1),]],

  [anyone,"lord_buy_prisoner_accept", [],
   "Excellent! Here's your {reg6} denars.\
 I'll send some men to take him to our prison with due haste.", "lord_pretalk", [
     (remove_troops_from_prisoners,  "$prisoner_lord_to_buy", 1),
     (call_script, "script_troop_add_gold", "trp_player", "$temp"),
     (party_add_prisoners, "$g_encountered_party", "$prisoner_lord_to_buy", 1),
     #(troop_set_slot, "$prisoner_lord_to_buy", slot_troop_is_prisoner, 1),
     (troop_set_slot, "$prisoner_lord_to_buy", slot_troop_prisoner_of_party, "$g_encountered_party"),
     ]],

  [anyone,"lord_buy_prisoner_deny", [],
   "Mmm. As you wish, {playername}, but you'll not get a better offer. Take it from me.", "lord_pretalk", []],


   
   [anyone,"lord_start", [
	(faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_feast),
	(faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_object, "$g_encountered_party"),
	
	(check_quest_active, "qst_organize_feast"),
	(quest_slot_eq, "qst_organize_feast", slot_quest_target_center, "$g_encountered_party"),

	
	(try_begin),
		(eq, "$g_talk_troop_faction", "fac_kingdom_4"),
		(str_store_string, s5, "str_flagon_of_mead"),
	(else_try),
		(store_mod, ":mode", "$g_talk_troop", 2),
		(eq, ":mode", 0),
		(eq, "$g_talk_troop_faction", "fac_kingdom_3"),
		(str_store_string, s5, "str_skin_of_kumis"),
	(else_try),
		(store_mod, ":mode", "$g_talk_troop", 2),
		(eq, ":mode", 0),
		(eq, "$g_talk_troop_faction", "fac_kingdom_2"),
		(str_store_string, s5, "str_mug_of_kvass"),
	(else_try),
		(str_store_string, s5, "str_cup_of_wine"),
	(try_end),


	
   ],
   "I lift a {s5} to your health, {playername}! You are most gracious to host us on this occasion. Now, what is it?", "lord_talk",[
   (call_script, "script_internal_politics_rate_feast_to_s9", "trp_household_possessions", 120, "$players_kingdom", 0),
   (assign, ":quality_of_feast", reg0),
   
   (try_begin),
    (ge, ":quality_of_feast", 20),
    (ge, "$g_time_since_last_talk", 24),
	(call_script, "script_troop_change_relation_with_troop", "$g_talk_troop", "trp_player", 1),
   (try_end),   
   ]],
   
   

   [anyone,"lord_start", [
   (faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "trp_player"),
   (faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_feast),
   (faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_object, "$g_encountered_party"),
   
   ],
   "To your health, {sire/your Highness}. Long may you reign. What is your bidding?", "lord_talk",[
   (try_begin),
	(this_or_next|party_slot_eq, "$g_encountered_party", slot_town_lord, "trp_player"),
		(party_slot_eq, "$g_encountered_party", slot_town_lord, "$g_talk_troop"),
    (ge, "$g_time_since_last_talk", 24),
	(ge, "$g_talk_troop_relation", 0),
	(call_script, "script_troop_change_relation_with_troop", "$g_talk_troop", "trp_player", 1),
   (try_end),
   
   ]],

   
   
   [anyone,"lord_start", [
   (faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "trp_player"),
   ],
   "What is your bidding?", "lord_talk",[]],

   [anyone,"lord_start", [
   (faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_feast),
   (faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_object, "$g_encountered_party"),
   (ge, "$g_encountered_party_relation", 0),   
   (party_slot_eq, "$g_encountered_party", slot_town_lord, "$g_talk_troop"),
   (neq, "$talk_context", tc_castle_gate),
   ],
   "I wish to welcome you to my hall on this auspicious occasion. Now, what is it?", "lord_talk",[
   (try_begin),
	(is_between, "$g_talk_troop_relation", 0, 10),
    (ge, "$g_time_since_last_talk", 24),
	(call_script, "script_troop_change_relation_with_troop", "$g_talk_troop", "trp_player", 2),
   (try_end),
   ]],


   [anyone,"lord_start", [
	(faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_feast),
	(faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_object, "$g_encountered_party"),
	(ge, "$g_encountered_party_relation", 0),
	(party_get_slot, ":town_lord", "$g_encountered_party", slot_town_lord),
	(str_store_troop_name, s4, ":town_lord"),

    (neq, "$talk_context", tc_castle_gate),

	
	(try_begin),
		(eq, "$g_talk_troop_faction", "fac_kingdom_4"),
		(str_store_string, s5, "str_flagon_of_mead"),
	(else_try),
		(store_mod, ":mode", "$g_talk_troop", 2),
		(eq, ":mode", 0),
		(eq, "$g_talk_troop_faction", "fac_kingdom_3"),
		(str_store_string, s5, "str_skin_of_kumis"),
	(else_try),
		(store_mod, ":mode", "$g_talk_troop", 2),
		(eq, ":mode", 0),
		(eq, "$g_talk_troop_faction", "fac_kingdom_2"),
		(str_store_string, s5, "str_mug_of_kvass"),
	(else_try),
		(str_store_string, s5, "str_cup_of_wine"),
	(try_end),
	   
   ],
   "Let us lift a {s5} to the health of our host, {s4}. Now, what is it?", "lord_talk",[]],

   


#  [anyone,"lord_start_2", [],
#   "Yes?", "lord_talk",[]],


#Player lord_talk responses begin

#Political quests begin
   [anyone|plyr,"lord_talk", [
	(check_quest_active, "qst_offer_gift"),
    (quest_slot_eq, "qst_offer_gift", slot_quest_giver_troop, "$g_talk_troop"),
	
    (quest_get_slot, ":target_troop", "qst_offer_gift", slot_quest_target_troop),
	(str_store_troop_name, s4, ":target_troop"),
	(player_has_item, "itm_furs"),
	(player_has_item, "itm_velvet"),
   ],
   "I have the materials for {s4}'s gift.", "offer_gift_quest_complete",[
   ]],

   [anyone,"offer_gift_quest_complete", [
   (quest_get_slot, ":target_troop", "qst_offer_gift", slot_quest_target_troop),
   (troop_get_type, reg4, ":target_troop"),
   ],
   "Ah, let me take those. Hopefully this will mend the quarrel between you two. You may wish to speak to {reg4?her:him}, and see if I had any success.", "close_window",[
   (quest_set_slot, "qst_offer_gift", slot_quest_current_state, 2),
   (troop_remove_item, "trp_player", "itm_furs"),
   (troop_remove_item, "trp_player", "itm_velvet"),
   (assign, "$g_leave_encounter", 1),
   ]],
   
   
   
   [anyone|plyr,"lord_talk", [
    (check_quest_active, "qst_intrigue_against_lord"),
    (neg|check_quest_succeeded, "qst_intrigue_against_lord"),
    (neg|check_quest_failed, "qst_intrigue_against_lord"),
	
    (quest_get_slot, ":target_troop", "qst_intrigue_against_lord", slot_quest_target_troop), #was qst_offer_gift
	(store_faction_of_troop, ":target_troop_faction", ":target_troop"),
	(faction_slot_eq, ":target_troop_faction", slot_faction_leader, "$g_talk_troop"), 
    ],
   "My lord -- there is something I wish to tell you in confidence, about one of your vassals.", "intrigue_quest_state_complaint",[
   ]],

   [anyone,"intrigue_quest_state_complaint", [
	(assign, ":continue", 1),
	(try_begin),
		(call_script, "script_cf_troop_can_intrigue", "$g_talk_troop", 1),
		(assign, ":continue", 0),
	(try_end),
	(eq, ":continue", 1),   
    ],
   "Whatever you have to say, I would ask you to wait until we are alone.", "lord_pretalk",[
   ]],

   [anyone,"intrigue_quest_state_complaint", [
   ],
   "What is it? I value your opinion, although I hope that you are not trying to sew dissension among my vassals? ", "intrigue_quest_state_complaint_plyr",[
	
    (quest_get_slot, ":target_troop", "qst_intrigue_against_lord", slot_quest_target_troop),
	(call_script, "script_troop_get_relation_with_troop", ":target_troop", "$g_talk_troop"),
	(assign, reg4, reg0),
    (str_store_troop_name, s4, ":target_troop"),
	(assign, reg5, "$g_talk_troop_effective_relation"),
    
    (try_begin),
	  (eq, "$cheat_mode", 1),
      (str_store_string, s12, "str_intrigue_success_chance"),
      (display_message, "str_s12"),
    (try_end),
   ]],

   
   
   [anyone|plyr,"intrigue_quest_state_complaint_plyr", [
	(check_quest_active, "qst_intrigue_against_lord"),
    (quest_get_slot, ":target_troop", "qst_intrigue_against_lord", slot_quest_target_troop),
    (str_store_troop_name, s4, ":target_troop"),
	(troop_get_slot, ":reputation_string", ":target_troop", slot_lord_reputation_type),
	(val_add, ":reputation_string", "str_lord_derogatory_default"),
	(str_store_string, s5, ":reputation_string"),
   ],
   "My liege -- {s4} is widely held by your vassals to be {s5}, and a liability to your realm", "lord_intrigue_quest_complaint_stated",[
   ]],
   
   [anyone|plyr,"intrigue_quest_state_complaint_plyr", [
   ],
   "Actually, my liege, never mind.", "lord_pretalk",[
   (call_script, "script_fail_quest", "qst_intrigue_against_lord"),
   ]],
   
   [anyone,"lord_intrigue_quest_complaint_stated", [
	(store_random_in_range, ":random", -50, 50),
	(store_add, ":score", "$g_talk_troop_effective_relation", ":random"),

    (quest_get_slot, ":target_troop", "qst_intrigue_against_lord", slot_quest_target_troop),
	(call_script, "script_troop_get_relation_with_troop", ":target_troop", "$g_talk_troop"),
	(ge, ":score", reg0),
	
   ],
   "Hmm... This is troubling to hear. Although I do not encourage my vassals to speak ill of each other, I value your opinion. Perhaps I should think twice about granting {s4} any further fiefs or offices...", "lord_pretalk",[
    (quest_get_slot, ":target_troop", "qst_intrigue_against_lord", slot_quest_target_troop),
    (call_script, "script_troop_change_relation_with_troop", "$g_talk_troop", ":target_troop", -10),
    (call_script, "script_succeed_quest", "qst_intrigue_against_lord"),
   ]],

   [anyone,"lord_intrigue_quest_complaint_stated", [
   ],
   "Sew discord among my vassals, will you? With everything else going on, do you think I appreciate my nobles turning on each other like quarreling dogs? Let me ask you this -- did someone put you up this?", "intrigue_quest_state_complaint_failed",[
   (call_script, "script_fail_quest", "qst_intrigue_against_lord"),
   (call_script, "script_troop_change_relation_with_troop", "$g_talk_troop", "trp_player", -5),
   ]],

   [anyone|plyr,"intrigue_quest_state_complaint_failed", [
   ],
   "I stand by my words, my liege.", "intrigue_quest_state_accept_blame",[
   (call_script, "script_change_player_honor", 1),
   ]],

   [anyone|plyr,"intrigue_quest_state_complaint_failed", [
   (quest_get_slot, ":giver_troop", "qst_intrigue_against_lord", slot_quest_giver_troop),
   (quest_get_slot, ":target_troop", "qst_intrigue_against_lord", slot_quest_target_troop),

   (str_store_troop_name, s4, ":giver_troop"),
   (str_store_troop_name, s5, ":target_troop"),
   ],
   "Yes, sire -- {s4} put me up to denouncing {s5}!", "intrigue_quest_state_deflect_blame",[
   (quest_get_slot, ":giver_troop", "qst_intrigue_against_lord", slot_quest_giver_troop),
   (call_script, "script_troop_change_relation_with_troop", "$g_talk_troop", ":giver_troop", -5),
   (call_script, "script_troop_change_relation_with_troop", "$g_talk_troop", "trp_player", 4),
   (call_script, "script_change_player_honor", -2),
   ]],

   [anyone,"intrigue_quest_state_accept_blame", [
   ],
   "Indeed. You may stand by your words, but keep them to yourself. I will not have you undercutting my faithful follower {s4}.", "lord_pretalk",[
   ]],
   
   [anyone,"intrigue_quest_state_deflect_blame", [
   ],
   "I thought as much. Here's some advice for you, {lad/lassie} -- don't meddle in the quarrels of others. Now, enough of this.", "lord_pretalk",[
   ]],
            
   [anyone|plyr,"lord_talk", [
	(check_quest_active, "qst_denounce_lord"),
	(neg|check_quest_succeeded, "qst_denounce_lord"),
	(neg|check_quest_failed, "qst_denounce_lord"),
	
	(quest_slot_eq, "qst_denounce_lord", slot_quest_target_troop, "$g_talk_troop"),
	

   (troop_get_slot, ":reputation_string", "$g_talk_troop", slot_lord_reputation_type),
   (val_add, ":reputation_string", "str_lord_derogatory_default"),
   (str_store_string, s4, ":reputation_string"),	
   ],
   "I want to tell you something -- we have had enough of your {s4} ways", "lord_denounce_1",[
   ]],
   
   [anyone,"lord_denounce_1", [
   ],
   "I'm sorry... What did you say?", "lord_denounce_2",[
   ]],
   
   [anyone|plyr,"lord_denounce_2", [

   (troop_get_slot, ":reputation_string", "$g_talk_troop", slot_lord_reputation_type),
   (val_add, ":reputation_string", "str_lord_derogatory_result"),
   (str_store_string, s4, ":reputation_string"),  

   ],
   "You heard me. You will {s4}", "lord_denounce_3",[
   (call_script, "script_troop_change_relation_with_troop", "$g_talk_troop", "trp_player", -15),


   (store_div, ":impact", "$g_talk_troop_relation", 10),
   (val_add, ":impact", 1),
   (val_max, ":impact", 1),
   (val_mul, ":impact", -1),
   
   #Change his respect level, slightly.  In the future game, there should be more sophisticated metrics for this
   (try_for_range, ":other_lord", active_npcs_begin, active_npcs_end),
     (neq, "$g_talk_troop", ":other_lord"),
	 (store_faction_of_troop, ":other_lord_faction",":other_lord"),
	 (eq, ":other_lord_faction", "$g_talk_troop_faction"),
	 (call_script, "script_troop_get_relation_with_troop", ":other_lord", "$g_talk_troop"),
	 (lt, reg0, 15),
	 (call_script, "script_troop_change_relation_with_troop", ":other_lord", "$g_talk_troop", ":impact"),
   (try_end),
   
 
   
   ]],

   [anyone|plyr,"lord_denounce_2", [
   ],
   "Never mind. You must have misheard me.", "lord_pretalk",[
   ]],
   
   
   [anyone,"lord_denounce_3", [
   (ge, "$g_talk_troop_relation", 10),
   (this_or_next|neg|troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_quarrelsome),
	(neg|troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_martial),
   ],
   "Why would you say such a thing? To insult me like this, in spite of our friendship -- how much crueler is a knife in my back from an erstwhile friends, than the sword of a sworn foe. I do not know what game you are playing, but I want no part of it. Go away. I do not want to look at you.", "close_window",[
   (call_script, "script_succeed_quest", "qst_denounce_lord"),
   ]],
   
   [anyone,"lord_denounce_3", [
   (troop_slot_ge, "trp_player", slot_troop_renown, 300),
   (this_or_next|troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_cunning),
   (this_or_next|troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_upstanding),
	(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_goodnatured),
   ],
   "Hmf. Really? Is that your opinion, or did one of my rivals put those words in your mouth? Never mind. I will not play your game. Go away, and take your intrigues with you.", "close_window",[
   (call_script, "script_succeed_quest", "qst_denounce_lord"),
   ]],

   [anyone,"lord_denounce_3", [
   (this_or_next|troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_martial),
   (this_or_next|troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_cunning),
   (this_or_next|troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_upstanding),
	(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_goodnatured),
   ],
   "I will not have you shame me in public, {sir/my lady}. Retract your words, or meet me on the duelling ground.", "lord_denounce_4",[
   ]],
   
   [anyone,"lord_denounce_3", [
   ],
   "Is that so? Well, hear this -- you're a snake, and a knave, and -- if you don't meet me on the duelling ground -- a coward. What say you to that? Do you retract your words, or shall we cross swords?", "lord_denounce_4",[
   ]],
   
   [anyone|plyr,"lord_denounce_4", [
   ],
   "It would be a pleasure to fight you.", "lord_respond_to_insult_challenge_duel_confirm",[
   ]],

   [anyone|plyr,"lord_denounce_4", [
   ],
   "I spoke rashly. I retract my words.", "lord_denounce_retract",[
   (call_script, "script_fail_quest", "qst_denounce_lord"),
  
   ]],
   
   [anyone,"lord_denounce_retract", [
   ],
   "I thought as much. Now, be gone from here.", "lord_pretalk",[
   ]],
   
   
   
   
   
   
   [anyone|plyr,"lord_talk", [
	(eq, "$g_comment_has_rejoinder", 1),
	(assign, "$g_comment_has_rejoinder", 0),
	(str_store_string, s9, "$g_rejoinder_to_last_comment"),
   ],
   "{s9}", "lord_respond_to_insult",[

        (try_begin),
            (troop_get_type, ":is_female", "trp_player"),
            (eq, ":is_female", 1),
            (unlock_achievement, ACHIEVEMENT_SASSY),
        (try_end),
   ]],


#lord recruitment changes begin
  [anyone,"lord_pretalk", [
	(lt, "$g_encountered_party_relation", 0),
	(encountered_party_is_attacker),
  ],
   "But enough talking - yield or fight!", "party_encounter_lord_hostile_attacker_2",[]],
#lord recruitment changes end




  [anyone,"lord_pretalk", [],
   "Anything else?", "lord_talk",[]],


   
  [anyone,"hero_pretalk", [],
   "Anything else?", "lord_talk",[]],

##### TODO: QUESTS COMMENT OUT BEGIN


	#lord recruitment changes begin
  [anyone|plyr,"lord_talk",[
                            (check_quest_active, "qst_resolve_dispute"),
							(quest_get_slot, ":lord_1", "qst_resolve_dispute", slot_quest_target_troop),
							(quest_get_slot, ":lord_2", "qst_resolve_dispute", slot_quest_object_troop),
							
							(assign, ":other_lord", 0),
							(try_begin),
								(eq, ":lord_1", "$g_talk_troop"),
								(quest_slot_eq, "qst_resolve_dispute", slot_quest_target_state, 0),
								(assign, "$g_other_lord", ":lord_2"),
								(assign, ":other_lord", ":lord_2"),
								
							(else_try),
								(eq, ":lord_2", "$g_talk_troop"),
								(quest_slot_eq, "qst_resolve_dispute", slot_quest_object_state, 0),
								(assign, "$g_other_lord", ":lord_1"),
								(assign, ":other_lord", ":lord_1"),
								
							(try_end),
							(gt, ":other_lord", 0),
							(str_store_troop_name, s11, "$g_other_lord"),
                            ],
   "I wish to address your quarrel with {s11}", "lord_quarrel_intervention_1",
   []],


	
  [anyone|plyr,"lord_talk",[#(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
                            (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
							(encountered_party_is_attacker),
							(neg|is_between, "$g_talk_troop", pretenders_begin, pretenders_end),
							(neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
							
                            ],
   "Stay your hand! There is something I must say to you in private.", "lord_recruit_1_relation",
   []],
	

  [anyone|plyr,"lord_talk",
  [(check_quest_active, "qst_track_down_bandits"),
   (neg|check_quest_succeeded, "qst_track_down_bandits"),
   (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 1),

   
  ], "I am hunting a group of bandits with the following description... Have you seen them?", "lord_bandit_information",[]],
  [anyone,"lord_bandit_information", [
	(call_script, "script_get_manhunt_information_to_s15", "qst_track_down_bandits"),
  ], "{s15}", "lord_pretalk",[]],


  [anyone|plyr,"lord_talk",[#(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
                            (eq, "$g_talk_troop_faction", "$players_kingdom"),
							(faction_slot_eq, "$players_kingdom", slot_faction_political_issue, 1),
                            ],
   "Who do you think should be made the marshal of our realm?", "lord_internal_politics_cur_stance",
   []],

  [anyone|plyr,"lord_talk",[#(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
                            (eq, "$g_talk_troop_faction", "$players_kingdom"),
							(faction_get_slot, ":political_issue", "$players_kingdom", slot_faction_political_issue),
							(is_between, ":political_issue", centers_begin, centers_end),
							(str_store_party_name, s4, ":political_issue"),
                            ],
   "Whom do you think should receive the fief of {s4}?", "lord_internal_politics_cur_stance",
   []],


  [anyone|plyr,"lord_talk",[(troop_slot_eq, "trp_player", slot_troop_spouse, "$g_talk_troop"),
							(troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_hero),
							(is_between, "$players_kingdom", kingdoms_begin, kingdoms_end),
							(neq, "$g_talk_troop_faction", "$players_kingdom"),
							(faction_slot_eq, "fac_player_supporters_faction", slot_faction_state, sfs_active),
#							(faction_slot_eq, "fac_player_supporters_faction", slot_faction_leader, "trp_player"),
							(faction_get_slot, ":faction_leader", "$g_talk_troop_faction", slot_faction_leader),
							(str_store_troop_name, s4, ":faction_leader"),
							(str_store_faction_name, s5, "$players_kingdom"),
                            ],
   "I need you to renounce your allegiance to {s4} and join the {s5} now, my husband.", "lord_husband_auto_recruit",
   []],
   
   
  [anyone,"lord_husband_auto_recruit",
	[
	(is_between, "$g_encountered_party", centers_begin, centers_end),						
	(neg|party_slot_eq, "$g_encountered_party", slot_town_lord, "$g_talk_troop"),						
	],
   "Ask me again when we are outside of these walls, my wife.", "lord_pretalk",
   []],
   
   
  [anyone,"lord_husband_auto_recruit",
							[],
   "As you wish, my wife.", "close_window",
   [
    (assign, "$g_leave_encounter", 1),
    (call_script, "script_change_troop_faction", "$g_talk_troop", "$players_kingdom"),
      
    (try_begin), #Actually, perhaps do provocation rather than war
        (store_relation, ":relation", "$players_kingdom", "$g_talk_troop_faction"), 
        (ge, ":relation", 0),
        
        (try_begin),
          (eq, "$cheat_mode", 1),
          (display_message, "str_lord_recruitment_provokes_home_faction"),
        (try_end),  
        
        (call_script, "script_add_log_entry", logent_border_incident_troop_suborns_lord, "trp_player", -1, "$g_talk_troop","$g_talk_troop_faction"),
        (store_add, ":slot_provocation_days", "$players_kingdom", slot_faction_provocation_days_with_factions_begin),
        (val_sub, ":slot_provocation_days", kingdoms_begin),
        (faction_set_slot, "$g_talk_troop_faction", ":slot_provocation_days", 30),
        
        (faction_get_slot, ":other_liege", "$g_talk_troop_faction", slot_faction_leader),
        (call_script, "script_troop_change_relation_with_troop", "trp_player", ":other_liege", -3),
    (try_end),
    
	(try_begin),
		(faction_slot_eq, "$players_kingdom", slot_faction_leader, "trp_player"),
		(call_script, "script_change_player_right_to_rule", 5),
    (try_end),
   ]],
   
   
   
  [anyone|plyr,"lord_talk",[#(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
                            (troop_slot_eq, "trp_player", slot_troop_spouse, "$g_talk_troop"),
                            ],
   "There is a matter which I would like to discuss in private.", "lord_recruit_1_relation",
   []],


   
  [anyone|plyr,"lord_talk",[#(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
                            (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
							(neg|encountered_party_is_attacker),
							(neg|is_between, "$g_talk_troop", pretenders_begin, pretenders_end),
							(neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
                            (neg|troop_slot_eq, "trp_player", slot_troop_spouse, "$g_talk_troop"),
							(neq, "$g_talk_troop_faction", "fac_player_supporters_faction"),
							#other requirements							
                            ],
   "There is something which I would like to discuss with to you in private.", "lord_recruit_1_relation",
   []],

   
  [anyone|plyr,"lord_talk",[#(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
                            (troop_slot_ge, "$g_talk_troop", slot_troop_intrigue_impatience, 1),
							(eq, "$cheat_mode", 1),
							
							#other requirements
							
                            ],
   "CHEAT -- Reset lord decision seed and intrigue impatience", "lord_talk",
   [
    (troop_set_slot, "$g_talk_troop", slot_troop_intrigue_impatience, 0),
    (store_random_in_range, ":random", 0, 9999),
    (troop_set_slot, "$g_talk_troop", slot_troop_temp_decision_seed, ":random"),	
   ]],
   
  [anyone|plyr,"lord_talk",[(eq, "$cheat_mode", 1),
                            ],
   "CHEAT -- Let's duel (insult)", "lord_respond_to_insult_challenge_duel",
   [
   ]],


   
#Respond to insult
  [anyone,"lord_respond_to_insult", [
	(eq, "$g_last_comment_copied_to_s42", "str_comment_intro_female_sadistic_admiring"),
  ], "Hah! I admire a quick tongue. Perhaps some day I shall remove it, with tongs, to admire it at greater leisure, but today, at least, I shall salute your wit and courage.", "lord_pretalk", [
   (call_script, "script_troop_change_relation_with_troop", "trp_player", "$g_talk_troop", 5),
   (call_script, "script_change_troop_renown", "trp_player", 2),
  ]],


  [anyone,"lord_respond_to_insult", [
	(this_or_next|eq, "$g_last_comment_copied_to_s42", "str_comment_intro_female_pitiless_admiring"),
	(this_or_next|eq, "$g_last_comment_copied_to_s42", "str_comment_intro_female_common_upstanding"),
	(this_or_next|eq, "$g_last_comment_copied_to_s42", "str_comment_intro_female_noble_upstanding"),
	(this_or_next|eq, "$g_last_comment_copied_to_s42", "str_comment_intro_female_common_martial"),
		(eq, "$g_last_comment_copied_to_s42", "str_comment_intro_female_badtempered_admiring"),
  ], "I meant no offense, madame.", "lord_pretalk", [
   (call_script, "script_troop_change_relation_with_troop", "trp_player", "$g_talk_troop", -2),
   (call_script, "script_change_troop_renown", "trp_player", 2),
  ]],
  
  
  [anyone,"lord_respond_to_insult", [
  (troop_slot_eq, "$g_talk_troop", slot_troop_leaded_party, "$g_encountered_party"),
  (store_party_size_wo_prisoners, ":lord_party_size", "$g_talk_troop_party"),
  (store_party_size_wo_prisoners, ":player_party_size", "p_main_party"),
  (val_mul, ":player_party_size", 3),
  (val_div, ":player_party_size", 2),
  (gt, ":lord_party_size", ":player_party_size"),
  (neq, "$players_kingdom",  "$g_talk_troop_faction"), 
  ], "Are you trying to provoke me? Well, I would have you know that I am under no obligation to duel women, commoners, rebels, or brigands. I could, however, order my men to seize you and horsewhip you. Would you like them to do that?", "lord_respond_to_insult_challenge_battle",
	[
   (call_script, "script_troop_change_relation_with_troop", "trp_player", "$g_talk_troop", -10),
   (call_script, "script_change_troop_renown", "trp_player", 2),
	]],

  [anyone,"lord_respond_to_insult", [
  ], "Are you trying to provoke me? Well, I would have you know that I am under no obligation to duel women, commoners, rebels, or brigands. However, in your case, I would be delighted to make an exception. Are you ready for a lesson in deference to your betters, {varlot/girl}?", "lord_respond_to_insult_challenge_duel",
	[
   (call_script, "script_troop_change_relation_with_troop", "trp_player", "$g_talk_troop", -10),
   (call_script, "script_change_troop_renown", "trp_player", 2),
	]],
   
  [anyone,"lord_respond_to_insult", [
  ], "Are you trying to provoke me? Well, I would have you know that I am under no obligation to duel women, commoners, rebels, or brigands. You are lucky that I am in a good mood, because I am perfectly within my rights to order my men to seize you and horsewhip you. Now begone -- I have had enough of you.", "close_window",
	[
    (call_script, "script_troop_change_relation_with_troop", "trp_player", "$g_talk_troop", -10),
    (call_script, "script_change_troop_renown", "trp_player", 2),
	(assign, "$g_leave_encounter", 1),
	]],

  
  [anyone|plyr,"lord_respond_to_insult_challenge_battle", [
  ], "I would like to see them try.", "lord_respond_to_insult_challenge_battle_confirm",
	[
	(call_script, "script_troop_change_relation_with_troop", "trp_player", "$g_talk_troop", -10),
	(call_script, "script_change_troop_renown", "trp_player", 3),
	]],
  
  [anyone|plyr,"lord_respond_to_insult_challenge_battle", [
  ], "This is not worth the shedding of blood.", "close_window",
	[
	(assign, "$g_leave_encounter", 1),
	]],

  [anyone,"lord_respond_to_insult_challenge_battle_confirm", [
  ], "Enough of your insolence! At {him/her}, lads!", "close_window",
	[
	(assign, "$g_private_battle_with_troop", "$g_talk_troop"),
	(assign, "$cant_leave_encounter", 1),
	(assign, "$encountered_party_friendly", 0),
	(jump_to_menu, "mnu_simple_encounter"),
	]],

  [anyone|plyr,"lord_respond_to_insult_challenge_duel", [
  ], "I am ready to teach you one.", "lord_respond_to_insult_challenge_duel_confirm",
	[
    (str_store_troop_name_link, s13, "$g_talk_troop"),
    (setup_quest_text, "qst_duel_avenge_insult"),
    (str_store_string, s2, "str_you_intend_to_challenge_s13_to_force_him_to_retract_an_insult"),
	
    (call_script, "script_start_quest", "qst_duel_avenge_insult", "$g_talk_troop"),
    (quest_set_slot, "qst_duel_avenge_insult", slot_quest_target_troop, "$g_talk_troop"),
	
	(call_script, "script_troop_change_relation_with_troop", "trp_player", "$g_talk_troop", -10),
	]],
  
  [anyone|plyr,"lord_respond_to_insult_challenge_duel", [
  ], "This is not worth the shedding of blood.", "close_window",
	[
	(assign, "$g_leave_encounter", 1),
	]],
	

  [anyone,"lord_respond_to_insult_challenge_duel_confirm", [
  ], "So be it. Defend yourself!", "close_window",
	[
	(call_script, "script_set_up_duel_with_troop", "$g_talk_troop"),
	]],
	
	

  [anyone,"lord_quarrel_intervention_1", [
  
    (str_store_string, s14, "str_general_quarrel"),
    (assign, "$temp", "$g_other_lord"),
	
    (assign, ":specific_quarrel_found", 0),
    (store_add, ":log_entries_plus_one", "$num_log_entries", 1),
    (try_for_range, ":log_entry_no", 1, ":log_entries_plus_one"),
      (troop_slot_eq, "trp_log_array_entry_type", ":log_entry_no", logent_ruler_intervenes_in_quarrel),
      (troop_slot_eq, "trp_log_array_troop_object", ":log_entry_no", "$temp"),
      (troop_slot_eq, "trp_log_array_center_object", ":log_entry_no", "$g_talk_troop"),
      (troop_slot_eq, "trp_log_array_faction_object", ":log_entry_no", "$g_talk_troop_faction"),
	  
      (call_script, "script_get_relevant_comment_for_log_entry", ":log_entry_no"),
      (str_store_string, s14, reg0),
      (assign, ":specific_quarrel_found", 1),
    (else_try),
      (troop_slot_eq, "trp_log_array_entry_type", ":log_entry_no", logent_lord_protests_marshall_appointment),
      (troop_slot_eq, "trp_log_array_actor", ":log_entry_no", "$g_talk_troop"),
      (troop_slot_eq, "trp_log_array_center_object", ":log_entry_no", "$temp"),
      (call_script, "script_get_relevant_comment_for_log_entry", ":log_entry_no"),
      (str_store_string, s14, reg0),
      (assign, ":specific_quarrel_found", 1),
    (else_try),
      (troop_slot_eq, "trp_log_array_entry_type", ":log_entry_no", logent_lord_blames_defeat),
      (troop_slot_eq, "trp_log_array_actor", ":log_entry_no", "$g_talk_troop"),
      (troop_slot_eq, "trp_log_array_center_object", ":log_entry_no", "$temp"),
      (call_script, "script_get_relevant_comment_for_log_entry", ":log_entry_no"),
      (str_store_string, s14, reg0),
      (assign, ":specific_quarrel_found", 1),
    (else_try),
      (troop_slot_eq, "trp_log_array_entry_type", ":log_entry_no", logent_troop_feels_cheated_by_troop_over_land),
      (troop_slot_eq, "trp_log_array_actor", ":log_entry_no", "$g_talk_troop"),
      (troop_slot_eq, "trp_log_array_troop_object", ":log_entry_no",  "$temp"),
      (call_script, "script_get_relevant_comment_for_log_entry", ":log_entry_no"),
      (str_store_string, s14, reg0),
      (assign, ":specific_quarrel_found", 1),
    (else_try),
      (troop_slot_eq, "trp_log_array_entry_type", ":log_entry_no", logent_lords_quarrel_over_woman),
      (troop_slot_eq, "trp_log_array_actor", ":log_entry_no", "$g_talk_troop"),
      (troop_slot_eq, "trp_log_array_center_object", ":log_entry_no", "$temp"),
      (call_script, "script_get_relevant_comment_for_log_entry", ":log_entry_no"),
      (str_store_string, s14, reg0),
      (assign, ":specific_quarrel_found", 1),
    (else_try),
      (troop_slot_eq, "trp_log_array_entry_type",  ":log_entry_no", logent_lords_quarrel_over_woman),
      (troop_slot_eq, "trp_log_array_actor", ":log_entry_no", "$temp"),
      (troop_slot_eq, "trp_log_array_center_object", ":log_entry_no", "$g_talk_troop"),
      (call_script, "script_get_relevant_comment_for_log_entry", ":log_entry_no"),
      (str_store_string, s14, reg0),
      (assign, ":specific_quarrel_found", 1),
    (try_end),
    
    (try_begin),
      (eq, ":specific_quarrel_found", 0),
      (call_script, "script_troop_describes_quarrel_with_troop_to_s14", "$g_talk_troop", "$temp"),
    (try_end),  
	
	], 
	"{s14}", "lord_quarrel_intervention_2",
	[]],
   
   
  [anyone|plyr,"lord_quarrel_intervention_2",[],
   "Ah, well. It sounds like you're in the right, then.", "lord_quarrel_intervention_3a",
   [
	(call_script, "script_troop_change_relation_with_troop", "trp_player", "$g_other_lord", -20), 
	(call_script, "script_troop_change_relation_with_troop", "trp_player", "$g_talk_troop", 10), 
	(try_begin),
		(faction_slot_eq, "fac_player_supporters_faction", slot_faction_leader, "trp_player"),
		(call_script, "script_add_log_entry", logent_ruler_intervenes_in_quarrel, "trp_player",  "$g_other_lord", "$g_talk_troop", "fac_player_supporters_faction"), 
	(try_end),
	(call_script, "script_end_quest", "qst_resolve_dispute"),
   
   ]],
   
  [anyone|plyr,"lord_quarrel_intervention_2",[
	(faction_slot_eq, "$players_kingdom", slot_faction_leader, "trp_player"),
  ], 
   "Whatever your differences, I want you to settle them.", "lord_quarrel_intervention_3b",
   []],

  [anyone|plyr,"lord_quarrel_intervention_2",[
	(neg|faction_slot_eq, "$players_kingdom", slot_faction_leader, "trp_player"),
  ], 
   "Could you not be convinced to settle your differences?", "lord_quarrel_intervention_3b",
   []],

   
  [anyone|plyr,"lord_quarrel_intervention_2",[], 
   "On second thought, I want nothing to do with this.", "lord_pretalk",
   [
   (call_script, "script_abort_quest", "qst_resolve_dispute", 1),

   ]],
   
  [anyone,"lord_quarrel_intervention_3a", [
  ], "I'm glad that you think so.", "lord_pretalk",
	[]],
   
  [anyone,"lord_quarrel_intervention_3b", [
  (store_random_in_range, ":random", 0, 21),
  (le, ":random", "$g_talk_troop_effective_relation"),
  (str_store_troop_name, s11, "$g_other_lord"),

  ], "For the sake of our friendship, I defer to your judgment. I will try to make amends with {s11}.", "lord_quarrel_intervention_4",
	[
	(try_begin),
		(quest_slot_eq, "qst_resolve_dispute", slot_quest_target_troop, "$g_talk_troop"),
		(quest_set_slot, "qst_resolve_dispute", slot_quest_target_state, 1),
	(else_try),
		(quest_slot_eq, "qst_resolve_dispute", slot_quest_object_troop, "$g_talk_troop"),
		(quest_set_slot, "qst_resolve_dispute", slot_quest_object_state, 1),
	(try_end),
	]],

  [anyone,"lord_quarrel_intervention_3b", [
  #fails reconciliation test
    (str_store_troop_name, s11, "$g_other_lord"),
  ], "I will not reconcile with {s11}. I know my rights.", "lord_pretalk",
	[
	(call_script, "script_troop_change_relation_with_troop", "trp_player", "$g_talk_troop", -15), 
	(call_script, "script_troop_change_relation_with_troop", "trp_player", "$g_other_lord", 10), 
	(try_begin),
		(eq, "$players_kingdom", "fac_player_supporters_faction"),
		(call_script, "script_add_log_entry", logent_ruler_intervenes_in_quarrel, "trp_player",  "$g_talk_troop", "$g_other_lord", "fac_player_supporters_faction"),
	(try_end),
	(call_script, "script_end_quest", "qst_resolve_dispute"),
	]],

  [anyone,"lord_quarrel_intervention_4", [
	(quest_slot_eq, "qst_resolve_dispute", slot_quest_object_state, 1),
	(quest_slot_eq, "qst_resolve_dispute", slot_quest_target_state, 1),
  ], "Let it be as though our quarrel never occurred.", "lord_pretalk",
	[
	(call_script, "script_troop_change_relation_with_troop", "$g_talk_troop", "$g_other_lord", 20),
	(call_script, "script_succeed_quest", "qst_resolve_dispute"),	
	(call_script, "script_end_quest", "qst_resolve_dispute"),
	(call_script, "script_change_player_honor", 3),
	(call_script, "script_change_troop_renown", "trp_player",  25),
	(add_xp_as_reward, 500),
	
	]],
   
  [anyone,"lord_quarrel_intervention_4", [
    (str_store_troop_name, s11, "$g_other_lord"),
  ], "I suppose that you should speak to {s11}, and see if he will do the same for me.", "lord_pretalk",
	[
	]],
   

  [anyone,"lord_internal_politics_cur_stance", [
	(troop_slot_eq, "$g_talk_troop", slot_troop_stance_on_faction_issue, "trp_player"),
   ],
   "I had already made up my mind to support you.", "lord_internal_politics_cur_stance_plyr_response",
   [
   ]], 


   
  [anyone,"lord_internal_politics_cur_stance", [
	(call_script, "script_npc_decision_checklist_take_stand_on_issue", "$g_talk_troop"),
	(eq, reg0, -1),
   ],
   "I am unable to decide at this time", "lord_internal_politics_cur_stance_plyr_response",
   [
   ]], 


  [anyone,"lord_internal_politics_cur_stance", [
   ],
   "I support {s15}. {s10}", "lord_internal_politics_cur_stance_plyr_response",
   [
	(call_script, "script_npc_decision_checklist_take_stand_on_issue", "$g_talk_troop"),
	(assign, ":supported_candidate", reg0),
	(assign, ":explainer_string", reg1),
	(troop_set_slot, "$g_talk_troop", slot_troop_stance_on_faction_issue, ":supported_candidate"),
	
    (str_store_string, s10, ":explainer_string"),
	(try_begin),
		(eq, ":supported_candidate", "$g_talk_troop"),
		(str_clear, s10),
	(try_end),
	(call_script, "script_troop_describes_troop_to_s15", "$g_talk_troop", ":supported_candidate"),
	
   ]], 

  [anyone|plyr,"lord_internal_politics_cur_stance_plyr_response", [
  (troop_slot_eq, "trp_player", slot_troop_stance_on_faction_issue, -1),
  (eq, "$player_has_homage", 1),
   ],
   "Let me tell you whom I support...", "lord_internal_politics_plyr_choose_candidate",
   [

   ]], 

  [anyone|plyr,"lord_internal_politics_cur_stance_plyr_response", [
  (eq, "$cheat_mode", 1),
  (eq, "$player_has_homage", 1),
   ],
   "CHEAT -- Reset support", "lord_internal_politics_cur_stance_plyr_response",
   [
   (troop_set_slot, "trp_player", slot_troop_stance_on_faction_issue, -1),	
   ]], 

   
   [anyone,"lord_internal_politics_plyr_choose_candidate", [
   ],
   "Whom do you support?", "lord_internal_politics_plyr_choose_candidate_select",
   [
   ]],   
   
   [anyone|plyr,"lord_internal_politics_plyr_choose_candidate_select", [
   ],
   "I would like to nominate myself for that honor", "lord_internal_politics_pretalk",
   [
   (troop_set_slot, "trp_player", slot_troop_stance_on_faction_issue, "trp_player"),	
   ]],   
   
   [anyone|plyr,"lord_internal_politics_plyr_choose_candidate_select", [
   (troop_get_slot, ":spouse", "trp_player", slot_troop_spouse),
   (neq, ":spouse", "$g_talk_troop"),
   
   (is_between, ":spouse", active_npcs_begin, active_npcs_end),
   (troop_slot_eq, ":spouse", slot_troop_occupation, slto_kingdom_hero),
   (store_faction_of_troop, ":spouse_faction", ":spouse"),
   (eq, ":spouse_faction", "$players_kingdom"),
   (str_store_troop_name, s4, ":spouse"),
   
   ],
   "I support my husband, {s4}", "lord_internal_politics_pretalk",
   [
   (troop_get_slot, ":spouse", "trp_player", slot_troop_spouse),
   
   (troop_set_slot, "trp_player", slot_troop_stance_on_faction_issue, ":spouse"),	
   ]],   
   
   [anyone|plyr,"lord_internal_politics_plyr_choose_candidate_select", [
   (str_store_troop_name, s4, "$g_talk_troop"),
   ],
   "I would support you, {s4}", "lord_internal_politics_support_acknowledge",
   [
   ]],   

   [anyone|plyr,"lord_internal_politics_plyr_choose_candidate_select", [
   
   (troop_get_slot, ":talk_troop_choice", "$g_talk_troop", slot_troop_stance_on_faction_issue),
   (is_between, ":talk_troop_choice", active_npcs_begin, active_npcs_end),
   (str_store_troop_name, s4, ":talk_troop_choice"),
   (neq, ":talk_troop_choice", "$g_talk_troop"),
   ],
   "I would support your choice, {s4}", "lord_internal_politics_support_same_acknowledge",
   [
   ]],   
   
   [anyone|plyr,"lord_internal_politics_plyr_choose_candidate_select", [
   ],
   "Never mind", "lord_pretalk",
   [
   ]],

   
   
   [anyone,"lord_internal_politics_support_acknowledge", [
   (troop_get_slot, ":supported_candidate", "$g_talk_troop", slot_troop_stance_on_faction_issue),
   (neq, "$g_talk_troop", ":supported_candidate"),
   
   ],
   "That is most gracious of you, but I do not seek the honor, and I decline your support.", "lord_pretalk",
   [
   (troop_set_slot, "trp_player", slot_troop_stance_on_faction_issue, -1),	
   ]],
   
   
   [anyone,"lord_internal_politics_support_acknowledge", [
   (lt, "$g_talk_troop_effective_relation", -5),
   ],
   "I do not trust you, and I do not need your support.", "lord_pretalk",
   [
   (troop_set_slot, "trp_player", slot_troop_stance_on_faction_issue, -1),	
   ]],
   
   [anyone,"lord_internal_politics_support_acknowledge", [
   ],
   "That is most gracious of you", "lord_pretalk",
   [
   (call_script, "script_troop_change_relation_with_troop", "trp_player", "$g_talk_troop", 3),
   (troop_set_slot, "trp_player", slot_troop_stance_on_faction_issue, "$g_talk_troop"),	
   ]],

   

   [anyone,"lord_internal_politics_support_same_acknowledge", [
   (lt, "$g_talk_troop_effective_relation", -5),
   ],
   "You may tell him that yourself. I do not trust you, and I will have no part in any game which you are playing.", "lord_pretalk",
   [
   (troop_set_slot, "trp_player", slot_troop_stance_on_faction_issue, -1),	
   ]],

   [anyone,"lord_internal_politics_support_same_acknowledge", [
   (troop_get_slot, ":talk_troop_choice", "$g_talk_troop", slot_troop_stance_on_faction_issue),
   (call_script, "script_troop_get_relation_with_troop", "trp_player", ":talk_troop_choice"),
   (lt, reg0,  -5),
   (str_store_troop_name, s4, ":talk_troop_choice"),   
   ],
   "Given your relation with {s4}, I do not think that he would welcome your support.", "lord_pretalk",
   [
   (troop_set_slot, "trp_player", slot_troop_stance_on_faction_issue, -1),	
   ]],
   
   [anyone,"lord_internal_politics_support_same_acknowledge", [
   (troop_get_slot, ":talk_troop_choice", "$g_talk_troop", slot_troop_stance_on_faction_issue),
   (str_store_troop_name, s4, ":talk_troop_choice"),   
   ],
   "I will tell {s4}. He will no doubt be grateful for your support.", "lord_pretalk",
   [
   (troop_get_slot, ":talk_troop_choice", "$g_talk_troop", slot_troop_stance_on_faction_issue),
   (call_script, "script_troop_change_relation_with_troop", "trp_player", ":talk_troop_choice", 2),
   (call_script, "script_troop_change_relation_with_troop", "trp_player", "$g_talk_troop", 1),
   (troop_set_slot, "trp_player", slot_troop_stance_on_faction_issue, ":talk_troop_choice"),	
   
   ]],


   
   
   [anyone|plyr|repeat_for_troops,"lord_internal_politics_plyr_choose_candidate_select", [
   (store_repeat_object, ":candidate"),
   (eq, 1, 0),
   (troop_slot_eq, ":candidate", slot_troop_occupation, slto_kingdom_hero),
   (store_faction_of_troop, ":candidate_faction", ":candidate"),
   (eq, ":candidate_faction", "$players_kingdom"),
   (neg|troop_slot_eq, "trp_player", slot_troop_spouse, ":candidate"),
   (str_store_troop_name, s4, ":candidate"),
   ],
   "I support {s4}", "lord_internal_politics_pretalk",
   [
   (store_repeat_object, ":candidate"),
   (troop_set_slot, "trp_player", slot_troop_stance_on_faction_issue, ":candidate"),	
   ]],   

   
 [anyone,"lord_internal_politics_pretalk", [
   ],
   "Ah. Most interesting.", "lord_internal_politics_cur_stance_plyr_response",
   [
   ]], 

   
   
  [anyone|plyr,"lord_internal_politics_cur_stance_plyr_response", [
  (eq, "$player_has_homage" ,1),
  (neg|troop_slot_eq, "$g_talk_troop", slot_troop_stance_on_faction_issue, "$g_talk_troop"),	
  (neg|troop_slot_ge, "trp_player", slot_troop_stance_on_faction_issue, active_npcs_begin),	
  (neg|troop_slot_eq, "$g_talk_troop", slot_troop_stance_on_faction_issue, "trp_player"),
  ],
   "Can I convince you to support me instead?", "lord_internal_politics_plyr_request_support",
   [
   ]], 
   
  [anyone|plyr,"lord_internal_politics_cur_stance_plyr_response", [
   ],
   "Anyway, enough of politics for the time being.", "lord_pretalk",
   [
   ]], 


  [anyone,"lord_internal_politics_plyr_request_support", [
  (troop_slot_ge, "trp_player", slot_troop_controversy, 25),
  (this_or_next|faction_slot_eq, "$players_kingdom", slot_faction_political_issue, 1),
	(troop_slot_ge, "trp_player", slot_troop_controversy, 50),
   ],
   "You have engendered too much controversy to be a viable candidate right now. I would advise you to wait a little while before seeking any further honors for yourself.", "lord_pretalk",
   [
   ]], 
 
  [anyone,"lord_internal_politics_plyr_request_support", [
  (troop_get_slot, ":current_candidate", "$g_talk_troop", slot_troop_stance_on_faction_issue),
  (gt, ":current_candidate", 0),
  (str_store_troop_name, s4, ":current_candidate"),
  (call_script, "script_troop_get_relation_with_troop", "$g_talk_troop", ":current_candidate"),
  (ge, reg0, "$g_talk_troop_effective_relation"),
   ],
   "I am sorry. I would not wish to strain my relationship with {s4}", "lord_pretalk",
   [
   ]], 

  [anyone,"lord_internal_politics_plyr_request_support", [
    (faction_get_slot, ":faction_issue", "$players_kingdom", slot_faction_political_issue),
    (is_between, ":faction_issue", centers_begin, centers_end),
    (troop_get_slot, ":player_renown", "trp_player", slot_troop_renown),
	(assign, ":total_faction_renown", ":player_renown"),
	
	(try_for_range, ":active_npc", active_npcs_begin, active_npcs_end),
		(store_faction_of_troop, ":active_npc_faction", ":active_npc"),
		(eq, ":active_npc_faction", "$players_kingdom"),
	
		(troop_get_slot, ":renown", ":active_npc", slot_troop_renown),
		(val_add, ":total_faction_renown", ":renown"),
	(try_end),
	
	(assign, ":total_faction_center_value", 0),
	(assign, ":center_points_held_by_player", 0),
	(try_for_range, ":center", centers_begin, centers_end),
		(store_faction_of_party, ":center_faction", ":center"),
		(eq, ":center_faction", "$players_kingdom"),
		
		(assign, ":center_value", 1),
		(try_begin),
			(is_between, ":center", towns_begin, towns_end),
			(assign, ":center_value", 2),
		(try_end),
		
		(val_add, ":total_faction_center_value", ":center_value"),
		
		(party_slot_eq, ":center", slot_town_lord, "trp_player"),
		(val_add, ":center_points_held_by_player", ":center_value"),
	(try_end),
	(val_max, ":total_faction_center_value", 1),
	(val_max, ":center_points_held_by_player", 1),
	
	(store_div, ":average_renown_per_center_point", ":total_faction_renown", ":total_faction_center_value"),
	(store_div, ":player_renown_per_center_point", ":player_renown", ":center_points_held_by_player"),
	
	(store_mul, ":threshhold", ":average_renown_per_center_point", 3),
	(val_div, ":threshhold", 4),
    (lt, ":player_renown_per_center_point", ":threshhold"),
  
   ],
   "You have already been well-rewarded with fiefs appropriate to your accomplishments, I would say.", "lord_pretalk",
   [
   ]], 
   
  [anyone,"lord_internal_politics_plyr_request_support", [
    (faction_slot_eq, "$players_kingdom", slot_faction_political_issue, 1),
    (troop_get_slot, ":player_renown", "trp_player", slot_troop_renown),
	(lt, ":player_renown", 400),
   ],
   "I think you would need to prove yourself further before you are eligible for that position.", "lord_pretalk",
   [
   ]], 
   
   #You already have too many holdings
  [anyone,"lord_internal_politics_plyr_request_support", [
  (lt, "$g_talk_troop_effective_relation", 10),
   ],
   "Hmm... That is too much to ask, given the state of our relationship. ", "lord_pretalk",
   [
   ]], 
 
  [anyone,"lord_internal_politics_plyr_request_support", [
   ],
   "I would support you with pleasure. ", "lord_pretalk",
   [
   (troop_set_slot, "$g_talk_troop", slot_troop_stance_on_faction_issue, "trp_player"),
   ]], 



 
 
  [anyone,"lord_internal_politics_plyr_request_support", [
   ],
   "{!}[Placeholder - sorry, not yet]", "lord_pretalk",
   [
   ]], 
 
 
 
 
   
  [anyone,"lord_recruit_1_relation", [
	(troop_slot_ge, "$g_talk_troop", slot_troop_intrigue_impatience, 100),
   ],
   "I am a bit weary of talking politics. Perhaps at a later date", "lord_pretalk",
   [
	(troop_get_slot, reg3, "$g_talk_troop", slot_troop_intrigue_impatience),
	(try_begin),
	  (eq, "$cheat_mode", 1),
	  (display_message, "str_intrigue_impatience=_reg3_must_be_less_than_100"),
	(try_end),
   ]], 
   
   #lord proximity
  [anyone,"lord_recruit_1_relation", [ #can't use the nearby scripts, because it would include the player party
    (assign, ":continue", 1),
    (try_begin),
      (call_script, "script_cf_troop_can_intrigue", "$g_talk_troop", 1),
      (assign, ":continue", 0),
    (try_end),       

    (eq, ":continue", 1),
    
    (str_store_string, s12, "str_youll_have_to_speak_to_me_at_some_other_time_then"),	
    (try_begin),
      (lt,"$g_encountered_party_relation",0),
      (encountered_party_is_attacker), 
      (str_store_string, s12, "str_this_is_no_time_for_words"),			
    (try_end),
    (try_begin),
	  (eq, "$cheat_mode", 1),				
	  (display_message, "str_lord_not_alone"),
	(try_end),
  ],
   "{s12}", "lord_pretalk",[]],

   

  [anyone,"lord_recruit_1_relation", [

	(is_between, "$supported_pretender", pretenders_begin, pretenders_end),
	(troop_slot_eq, "$supported_pretender", slot_troop_original_faction, "$g_talk_troop_faction"),
	(troop_get_type, reg3, "$supported_pretender"),
	(str_store_troop_name, s16, "$supported_pretender"),
    (eq, "$skip_lord_assumes_argument", 0),
    
	],
   "You have raised the standard of rebellion on behalf of {s16}. Have you come to plead {reg3?her:his} case?", "lord_recruit_pretender",[
   ]],
		
  [anyone|plyr,"lord_recruit_pretender", [
  ],
   "I have", "lord_recruit_3_dilemma_1",[
   (troop_set_slot, "$g_talk_troop", slot_lord_recruitment_candidate, "$supported_pretender"),   
   ]],

  [anyone|plyr,"lord_recruit_pretender", [
  ],
   "No, that's not it. There's another issue I wish to discuss.", "lord_recruit_1_relation",[
   (assign, "$skip_lord_assumes_argument", 1),
   ]],
   
   
   
   
   
  #relation
  [anyone,"lord_recruit_1_relation", 
  [
    (try_begin),
		(troop_slot_eq, "trp_player", slot_troop_spouse, "$g_talk_troop"),

		(assign, ":willingness_to_intrigue", 20),

		(str_store_string, s13, "str_of_course_my_wife"),
		(str_store_string, s14, "str_perhaps_not_our_marriage_has_become_a_bit_strained_dont_you_think"),
		(str_store_string, s15, "str_why_is_that_my_wife_actually_our_marriage_has_become_such_that_i_prefer_to_have_a_witness_for_all_of_our_converations"),		
	(else_try),
		(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_quarrelsome),
		
		(assign, ":willingness_to_intrigue", 6),

		(str_store_string, s13, "str_all_right_then_what_do_you_have_to_say_out_with_it"),
		(str_store_string, s14, "str_bah__im_in_no_mood_for_whispering_in_the_corner"),
		(str_store_string, s15, "str_bah_i_dont_like_you_that_much_im_not_going_to_go_plot_with_you_in_some_corner"),		
	(else_try),
		(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_debauched),
		(assign, ":willingness_to_intrigue", 8),

		(str_store_string, s13, "str_well__now_what_do_you_have_to_propose"),
		(str_store_string, s14, "str_trying_our_hand_at_intrigue_are_we_i_think_not"),
		(str_store_string, s15, "str_hah_i_trust_you_as_a_i_would_a_serpent_i_think_not"),
	(else_try),
		(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_upstanding),
		(assign, ":willingness_to_intrigue", -10),

		(str_store_string, s13, "str_i_do_not_like_to_conduct_my_business_in_the_shadows_but_sometimes_it_must_be_done_what_do_you_have_to_say"),
		(str_store_string, s14, "str_i_would_prefer_to_conduct_our_affairs_out_in_the_open"),
		(str_store_string, s15, "str_do_not_take_this_amiss_but_with_you_i_would_prefer_to_conduct_our_affairs_out_in_the_open"),
	(else_try),
		(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_cunning),
		(assign, ":willingness_to_intrigue", 4),
		
		(str_store_string, s13, "str_hmm_you_have_piqued_my_interest_what_do_you_have_to_say"),
		(str_store_string, s14, "str_em_lets_keep_our_affairs_out_in_the_open_for_the_time_being"),
		(str_store_string, s15, "str_em_lets_keep_our_affairs_out_in_the_open_for_the_time_being"),		
	(else_try),
		(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_selfrighteous),
		(assign, ":willingness_to_intrigue", 0),

		(str_store_string, s13, "str_thats_sensible__the_world_is_full_of_churls_who_poke_their_noses_into_their_betters_business_now_tell_me_what_it_is_that_you_have_to_say"),
		(str_store_string, s14, "str_what_do_you_take_me_for_a_plotter"),
		(str_store_string, s15, "str_hah_i_trust_you_as_a_i_would_a_serpent_i_think_not"),				
	(else_try),	
		(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_goodnatured),
		(assign, ":willingness_to_intrigue", -10),

		(str_store_string, s13, "str_well_i_normally_like_to_keep_things_out_in_the_open_but_im_sure_someone_like_you_would_not_want_to_talk_in_private_unless_heshe_had_a_good_reason_what_is_it"),
		(str_store_string, s14, "str_surely_we_can_discuss_whatever_you_want_to_discuss_out_here_in_the_open_cant_we"),
		(str_store_string, s15, "str_surely_we_can_discuss_whatever_you_want_to_discuss_out_here_in_the_open_cant_we"),
	(else_try),	
		(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_martial),
		(assign, ":willingness_to_intrigue", -5),

		(str_store_string, s13, "str_im_a_simple__man_not_one_for_intrigue_but_id_guess_that_you_have_something_worthwhile_to_say_what_is_it"),
		(str_store_string, s14, "str_forgive_me_but_im_not_one_for_going_off_in_corners_to_plot"),
		(str_store_string, s15, "str_please_do_not_take_this_amiss_but_i_do_not_trust_you"),
	(else_try),	
		(troop_slot_ge, "$g_talk_troop", slot_lord_reputation_type, lrep_roguish),
		(assign, ":willingness_to_intrigue", 10),

		(str_store_string, s13, "str_certainly_playername_what_is_it"),
		(str_store_string, s14, "str_forgive_me_but_id_prefer_to_keep_our_conversations_in_the_open"),
		(str_store_string, s15, "str_please_do_not_take_this_amiss_but_im_not_sure_you_and_i_are_still_on_those_terms"),				
	(try_end),	

	(assign, ":continue", 0),
	(store_skill_level, ":persuasion", "skl_persuasion", "trp_player"),
			
	(try_begin),	    
		(lt, "$g_talk_troop_relation", -5),
		(try_begin),
		  (eq, "$cheat_mode", 1),
		  (display_message, "str_persuasion__relation_less_than_5"),
		(try_end),
		(str_store_string, s12, "str_s15"),
	(else_try),	    
	    (store_add, ":score", ":persuasion", "$g_talk_troop_relation"),
		(val_add, ":score", ":willingness_to_intrigue"),
		
		(game_get_reduce_campaign_ai, ":reduce_campaign_ai"),
		(try_begin),
		  (eq, ":reduce_campaign_ai", 0), #hard
		  (val_sub, ":score", 5),
		(else_try),
		  (eq, ":reduce_campaign_ai", 1), #medium
		(else_try),
		  (eq, ":reduce_campaign_ai", 2), #easy
	      (val_add, ":score", 5),
        (try_end),

		(lt, ":score", 10),
		
		(str_store_string, s12, "str_s14"),
		(try_begin),
		  (eq, "$cheat_mode", 1),
		  (display_message, "str_persuasion__2__lord_reputation_modifier__relation_less_than_10"),
		(try_end),

		(str_store_string, s12, "str_s14"),
	(else_try),
		(str_store_string, s12, "str_s13"),
		(assign, ":continue", 1),
	(try_end),
	
	(eq, ":continue", 0),
	],
   "{s12}", "lord_pretalk",[]],
   
  [anyone,"lord_recruit_1_relation", [],
   "{s12}", "lord_recruit_2",[]],
   
  #check for discontent 
  
  [anyone|plyr,"lord_recruit_2", [
  ],
   "What do you think, in general terms, about kings, lords, and politics?", "lord_recruit_2_philosophy",[
   ]],

   
   
   
  [anyone|plyr,"lord_recruit_2", [
  (troop_slot_eq, "$g_talk_troop", slot_troop_spouse, "trp_player"),
  (neq, "$players_kingdom", "fac_player_supporters_faction"),
  (troop_get_type, ":type", "$g_talk_troop"),
  (eq, ":type", 0),
  (faction_get_slot, ":faction_leader", "$g_encountered_party_faction", slot_faction_leader),
  (str_store_troop_name, s11, ":faction_leader"),
  ],
   "My husband, I believe that you should rethink you allegiance to {s11}", "lord_spouse_leave_faction",[
   ]],
   
  [anyone,"lord_spouse_leave_faction", [
  (faction_get_slot, ":faction_liege", "$g_talk_troop_faction", slot_faction_leader),
  (call_script, "script_troop_get_relation_with_troop", "$g_talk_troop", ":faction_liege"),
  (gt, reg0, 25),
  (str_store_troop_name, s9, ":faction_liege"),
  ],
   "{s9} has always been a good liege to me, but I will hear you out. What do you suggest we do?", "lord_spouse_leave_faction_2",[]],

  [anyone,"lord_spouse_leave_faction", [
  (faction_get_slot, ":faction_liege", "$g_talk_troop_faction", slot_faction_leader),
  (call_script, "script_troop_get_relation_with_troop", "$g_talk_troop", ":faction_liege"),
  (gt, reg0, -5),
  (str_store_troop_name, s9, ":faction_liege"),
  ],
   "I see no particular reason to abandon {s9}, but I will heed your advice. What do you suggest we do?", "lord_spouse_leave_faction_2",[]],
   
  [anyone,"lord_spouse_leave_faction", [
  (faction_get_slot, ":faction_liege", "$g_talk_troop_faction", slot_faction_leader),
  (call_script, "script_troop_get_relation_with_troop", "$g_talk_troop", ":faction_liege"),
  (str_store_troop_name, s9, ":faction_liege"),
  ],
   "Yes -- as a liege, {s9} is a great disappointment. What do you suggest we do?", "lord_spouse_leave_faction_2",[]],
   
   
#  [anyone|plyr,"lord_spouse_leave_faction_2", [
#  ],
#   "Perhaps we should find another liege", "lord_spouse_leave_faction_other_liege",[]],

  [anyone|plyr,"lord_spouse_leave_faction_2", [
  ],
   "I believe you should be king, my husband!", "lord_spouse_leave_faction_husband_king",[]],

  [anyone|plyr,"lord_spouse_leave_faction_2", [
  ],
   "I am the rightful queen of Calradia", "lord_spouse_leave_faction_proclaim_queen",[]],

  [anyone|plyr,"lord_spouse_leave_faction_2", [
  ],
   "Never mind", "lord_pretalk",[]],

  [anyone,"lord_spouse_leave_faction_husband_king", [
  (assign, ":lord_has_fortress", 0),
  (try_for_range, ":walled_center", walled_centers_begin, walled_centers_end),
	(this_or_next|party_slot_eq, ":walled_center", slot_town_lord, "trp_player"),
		(party_slot_eq, ":walled_center", slot_town_lord, "$g_talk_troop"),
    (assign, ":lord_has_fortress", 1),  
  (try_end),
  (eq, ":lord_has_fortress", 0),  
  ],
   "Perhaps some day, my wife -- but before I declare myself king, I should like for one of us to hold a fortress which could serve as our court before we declare ourselves publically.",
  "lord_pretalk",[]],
   
  [anyone,"lord_spouse_leave_faction_proclaim_queen", [
  (assign, ":lord_has_fortress", 0),
  (try_for_range, ":walled_center", walled_centers_begin, walled_centers_end),
	(this_or_next|party_slot_eq, ":walled_center", slot_town_lord, "trp_player"),
		(party_slot_eq, ":walled_center", slot_town_lord, "$g_talk_troop"),
    (assign, ":lord_has_fortress", 1),  
  (try_end),
  (eq, ":lord_has_fortress", 0),  
  ],
   "While I do not contest your claim, my wife, I should like for one of us to hold a fortress which could serve as our court before we declare ourselves publically.", "lord_pretalk",[]],
   
   
  #Proclaim yourself queen 
  [anyone,"lord_spouse_leave_faction_proclaim_queen", [
  (assign, ":player_has_enough_right", 0),
  (try_begin),
    (le, "$player_right_to_rule", 5),
	(str_store_string, s11, "str_really_well_this_is_the_first_i_have_heard_of_it_unless_you_build_up_support_for_that_claim_you_may_find_it_difficult_to_find_allies_however_whenever_you_see_fit_to_declare_yourself_publically_as_queen_i_should_be_honored_to_be_your_consort"),
    (assign, "$player_right_to_rule", 5),
  (else_try),  
    (lt, "$player_right_to_rule", 20),
	(str_store_string, s11, "str_yes_i_have_heard_such_talk_while_it_is_good_that_you_are_building_up_your_support_i_do_not_think_that_you_are_quite_ready_to_proclaim_yourself_yet_however_i_will_let_you_be_the_judge_of_that_and_when_you_decide_i_should_be_honored_to_be_your_consort"),
  (else_try),
	(str_store_string, s11, "str_yes_and_many_others_in_calradia_think_so_as_well_perhaps_it_is_time_that_you_declared_yourself_and_we_shall_ride_forth_together_to_claim_your_throne_i_should_be_honored_to_be_your_consort"),
    (assign, ":player_has_enough_right", 1),
  (try_end),
  (eq, ":player_has_enough_right", 1),
  ],
   "{s11}", "lord_spouse_leave_faction_proclaim_queen_confirm",[]],

  [anyone,"lord_spouse_leave_faction_proclaim_queen", [
  ],
   "{s11}", "lord_pretalk",[]],

  [anyone|plyr,"lord_spouse_leave_faction_proclaim_queen_confirm", [
  ],
   "I am ready now, my husband. Let us go forth to seek our throne.", "close_window",[
    (call_script, "script_activate_player_faction", "trp_player"),
    (call_script, "script_change_troop_faction", "$g_talk_troop", "fac_player_supporters_faction"),  
	(assign, "$g_leave_encounter", 1),
   ]],
   
  [anyone|plyr,"lord_spouse_leave_faction_proclaim_queen_confirm", [
  ],
   "Perhaps I am not yet ready.", "lord_pretalk",[]],




  #Declare husband as pretender 
  [anyone,"lord_spouse_leave_faction_husband_king", [
	(eq, "$players_kingdom", "fac_player_supporters_faction"),
	(gt, "$supported_pretender", 0),
	(str_store_troop_name, s4, "$supported_pretender"),
  ],
   "Perhaps, but I would need your full support to press that claim. You would want to resolve {s4}'s rebellion before pushing this any further.", "lord_pretalk",[]],

  [anyone,"lord_spouse_leave_faction_husband_king", [
  (faction_get_slot, ":talk_troop_liege", "$g_talk_troop_faction", slot_faction_leader),
  (str_store_troop_name, s4, ":talk_troop_liege"),
  ],
   "Most of the great families of this land have a claim to the throne... Given the recent issues with the succession, I should be as legitimate a king as {s4}. ", "lord_spouse_leave_faction_husband_king_2",[]],

  [anyone,"lord_spouse_leave_faction_husband_king_2", [
  ],
   "While king, I will defer to your judgment in the appointment of ministers, the conduct of diplomacy, and other such matters.", "lord_spouse_leave_faction_husband_king_3",[]],
   
  [anyone|plyr,"lord_spouse_leave_faction_husband_king_3", [
  ],
   "Very well, my husband. Let us ride forth to press your claim! ", "close_window",[
    (call_script, "script_change_troop_faction", "$g_talk_troop", "fac_player_supporters_faction"),  
    (call_script, "script_activate_player_faction", "$g_talk_troop"),
	(assign, "$g_leave_encounter", 1),
   ]],

  [anyone|plyr,"lord_spouse_leave_faction_husband_king_3", [
  ],
   "Actually, let us bide out time for a bit.", "lord_pretalk",[
   ]],

   
  [anyone,"lord_recruit_2_philosophy", [
  (call_script, "script_lord_comment_to_s43", "$g_talk_troop", "str_political_philosophy_default"),
  ],
   "{s43} Did you wish to speak of anything else?", "lord_recruit_2",[]],
    
  [anyone|plyr,"lord_recruit_2", [
  (troop_slot_eq, "$g_talk_troop", slot_troop_recruitment_random, 0), 
  (faction_get_slot, ":leader", "$g_talk_troop_faction", slot_faction_leader),
  (neq, "$g_talk_troop", ":leader"),
  (neq, "trp_player", ":leader"),
  (str_store_troop_name, s15, ":leader"),
  ],
   "How do you feel about {s15}?", "lord_recruit_2_discontent",[
   ]],

  [anyone|plyr,"lord_recruit_2", [
    #(troop_slot_ge, "$g_talk_troop", slot_troop_recruitment_candidate, 1),
    (troop_slot_ge, "$g_talk_troop", slot_lord_recruitment_argument, 1),
    (neq, "$g_talk_troop_faction", "$players_kingdom"),  
  ],
   "Do you remember what I had told you earlier?", "lord_recruit_3_a",[
   ]],
                  
  [anyone|plyr|repeat_for_troops,"lord_recruit_2", [
	(store_repeat_object, ":troop_no"),
	(is_between, ":troop_no", active_npcs_begin, active_npcs_end),
	(store_faction_of_troop, ":faction", ":troop_no"),
	(eq, ":faction", "$g_talk_troop_faction"),
	(neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, ":troop_no"), #yields wrong string
	(call_script, "script_troop_get_relation_with_troop", "$g_talk_troop", ":troop_no"),
	(lt, reg0, -9),
	(str_store_troop_name, s16, ":troop_no"),
  ],
   "I have heard that you have quarreled with {s16}", "lord_recruit_quarrel_describe",[
	(store_repeat_object, "$temp"),
   ]],

  [anyone,"lord_recruit_quarrel_describe", 
  [
    (assign, ":specific_quarrel_found", 0),
    (store_add, ":log_entries_plus_one", "$num_log_entries", 1),
    (try_for_range, ":log_entry_no", 1, ":log_entries_plus_one"),
      (troop_slot_eq, "trp_log_array_entry_type", ":log_entry_no", logent_ruler_intervenes_in_quarrel),
      (troop_slot_eq, "trp_log_array_troop_object", ":log_entry_no", "$temp"),
      (troop_slot_eq, "trp_log_array_center_object", ":log_entry_no", "$g_talk_troop"),
      (troop_slot_eq, "trp_log_array_faction_object", ":log_entry_no", "$g_talk_troop_faction"),
	  
      (call_script, "script_get_relevant_comment_for_log_entry", ":log_entry_no"),
      (str_store_string, s14, reg0),
      (assign, ":specific_quarrel_found", 1),
    (else_try),
      (troop_slot_eq, "trp_log_array_entry_type", ":log_entry_no", logent_lord_protests_marshall_appointment),
      (troop_slot_eq, "trp_log_array_actor", ":log_entry_no", "$g_talk_troop"),
      (troop_slot_eq, "trp_log_array_center_object", ":log_entry_no", "$temp"),
      (call_script, "script_get_relevant_comment_for_log_entry", ":log_entry_no"),
      (str_store_string, s14, reg0),
      (assign, ":specific_quarrel_found", 1),
    (else_try),
      (troop_slot_eq, "trp_log_array_entry_type", ":log_entry_no", logent_lord_blames_defeat),
      (troop_slot_eq, "trp_log_array_actor", ":log_entry_no", "$g_talk_troop"),
      (troop_slot_eq, "trp_log_array_center_object", ":log_entry_no", "$temp"),
      (call_script, "script_get_relevant_comment_for_log_entry", ":log_entry_no"),
      (str_store_string, s14, reg0),
      (assign, ":specific_quarrel_found", 1),
    (else_try),
      (troop_slot_eq, "trp_log_array_entry_type", ":log_entry_no", logent_troop_feels_cheated_by_troop_over_land),
      (troop_slot_eq, "trp_log_array_actor", ":log_entry_no", "$g_talk_troop"),
      (troop_slot_eq, "trp_log_array_troop_object", ":log_entry_no",  "$temp"),
      (call_script, "script_get_relevant_comment_for_log_entry", ":log_entry_no"),
      (str_store_string, s14, reg0),
      (assign, ":specific_quarrel_found", 1),
    (else_try),
      (troop_slot_eq, "trp_log_array_entry_type", ":log_entry_no", logent_lords_quarrel_over_woman),
      (troop_slot_eq, "trp_log_array_actor", ":log_entry_no", "$g_talk_troop"),
      (troop_slot_eq, "trp_log_array_center_object", ":log_entry_no", "$temp"),
      (call_script, "script_get_relevant_comment_for_log_entry", ":log_entry_no"),
      (str_store_string, s14, reg0),
      (assign, ":specific_quarrel_found", 1),
    (else_try),
      (troop_slot_eq, "trp_log_array_entry_type",  ":log_entry_no", logent_lords_quarrel_over_woman),
      (troop_slot_eq, "trp_log_array_actor", ":log_entry_no", "$temp"),
      (troop_slot_eq, "trp_log_array_center_object", ":log_entry_no", "$g_talk_troop"),
      (call_script, "script_get_relevant_comment_for_log_entry", ":log_entry_no"),
      (str_store_string, s14, reg0),
      (assign, ":specific_quarrel_found", 1),
    (try_end),
    
    (try_begin),
      (eq, ":specific_quarrel_found", 0),
      (call_script, "script_troop_describes_quarrel_with_troop_to_s14", "$g_talk_troop", "$temp"),
    (try_end),
    
    (call_script, "script_add_rumor_string_to_troop_notes", "$g_talk_troop", "$temp", 14),
	],
   "It is no secret. {s14}", "lord_recruit_2",[
   ]],
   
  [anyone|plyr,"lord_recruit_2", [
  ],
   "Never mind", "lord_pretalk",[]],
   
  [anyone,"lord_recruit_2_discontent", [       
    (faction_get_slot, ":leader", "$g_talk_troop_faction", slot_faction_leader),
	
    (call_script, "script_calculate_troop_political_factors_for_liege", "$g_talk_troop", ":leader"),
    (assign, ":result_for_political", reg3),    

    (try_begin),
      (eq, "$cheat_mode", 1),
      (display_message, "@{!}DEBUG : result_for_political is {reg3}"),
    (try_end),  
    
    (call_script, "script_troop_get_relation_with_troop", "$g_talk_troop", ":leader"),
    (assign, ":liege_relation", reg0),
    
    (str_store_troop_name, s15, ":leader"),
	(troop_get_type, reg15, ":leader"),
	
    (try_begin),
      (troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_upstanding),
      (assign, ":intrigue_willingness", -5),
      (str_store_string, s12, "str_i_am_disturbed_about_my_lord_s15s_choice_of_companions"), 
    (else_try),
      (troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_martial),
      (assign, ":intrigue_willingness", -1),				
      (str_store_string, s12, "str_well_ill_be_honest_i_feel_that_sometimes_s15_overlooks_my_rights_and_extends_his_protection_to_the_unworthy"), 							
    (else_try),
      (troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_quarrelsome),
      (assign, ":intrigue_willingness", 5),
      (str_store_string, s12, "str_heh_one_thing_that_ill_say_about_s15_is_that_he_has_a_ripe_batch_of_bastards_in_his_court"), 							
    (else_try),
      (troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_goodnatured),
      (assign, ":intrigue_willingness", -4),
      (str_store_string, s12, "str_well_sometimes_i_have_to_say_that_i_question_s15s_judgment_regarding_those_who_he_keeps_in_his_court"), 								
    (else_try),
      (troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_selfrighteous),
      (assign, ":intrigue_willingness", 1),
      (str_store_string, s12, "str_s15_is_a_weak_man_who_too_easily_lends_his_ear_to_evil_council_and_gives_his_protection_to_some_who_have_done_me_wrong"), 				
    (else_try),
      (troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_cunning),
      (assign, ":intrigue_willingness", 3),
      (str_store_string, s12, "str_i_will_confess_that_sometimes_i_worry_about_s15s_judgment_particularly_in_the_matter_of_the_counsel_that_he_keeps"), 
    (else_try),
      (troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_debauched),
      (assign, ":intrigue_willingness", 5),
      (str_store_string, s12, "str_what_do_i_think_i_think_that_s15_is_a_vile_pretender_a_friend_to_the_flatterer_and_the_hypocrite"), 			
    (else_try),
      (troop_slot_ge, "$g_talk_troop", slot_lord_reputation_type, lrep_roguish),
      (assign, ":intrigue_willingness", 5),
      (str_store_string, s12, "str_well_s15_is_not_like_you_ill_say_that_much"), 			
    (try_end),
    
    #is there a specific quarrel?
    (store_add, ":log_entries_plus_one", "$num_log_entries", 1),
    (try_for_range, ":log_entry_no", 1, ":log_entries_plus_one"),
      (troop_slot_eq, "trp_log_array_entry_type", ":log_entry_no", logent_ruler_intervenes_in_quarrel),
      (troop_slot_eq, "trp_log_array_actor", ":log_entry_no", ":leader"),
      (troop_slot_eq, "trp_log_array_center_object", ":log_entry_no", "$g_talk_troop"),
      (call_script, "script_get_relevant_comment_for_log_entry", ":log_entry_no"),		
      (str_store_string, s12, reg0),
    (else_try),	
      (troop_slot_eq, "trp_log_array_entry_type", ":log_entry_no", logent_lord_protests_marshall_appointment),
      (troop_slot_eq, "trp_log_array_actor", ":log_entry_no", "$g_talk_troop"),
      (troop_slot_eq, "trp_log_array_troop_object", ":log_entry_no",  ":leader"),
      (call_script, "script_get_relevant_comment_for_log_entry", ":log_entry_no"),		
      (str_store_string, s12, reg0),
    (else_try),
      (troop_slot_eq, "trp_log_array_entry_type", ":log_entry_no", logent_lord_blames_defeat),
      (troop_slot_eq, "trp_log_array_actor", ":log_entry_no", "$g_talk_troop"),
      (troop_slot_eq, "trp_log_array_troop_object", ":log_entry_no", ":leader"),
      (call_script, "script_get_relevant_comment_for_log_entry", ":log_entry_no"),		
      (str_store_string, s12, reg0),
    (else_try),
      (troop_slot_eq, "trp_log_array_entry_type", ":log_entry_no", logent_troop_feels_cheated_by_troop_over_land),
      (troop_slot_eq, "trp_log_array_actor", ":log_entry_no", "$g_talk_troop"),
      (troop_slot_eq, "trp_log_array_faction_object", ":log_entry_no", "$g_talk_troop_faction"),
      (call_script, "script_get_relevant_comment_for_log_entry", ":log_entry_no"),		
      (str_store_string, s12, reg0),				
    (try_end),
        
    (val_mul, ":intrigue_willingness", 2), #-10 to 10
    
    (assign, "$lord_might_open_up", 0),
    (try_begin),      
      (gt, ":result_for_political", 12),
      (gt, ":liege_relation", 0),
      (str_store_string, s12, "str_s15_long_may_he_live"),
    (else_try),
      (ge, ":result_for_political", ":intrigue_willingness"),
      (str_store_string, s12, "str_he_is_my_liege_that_is_all_that_i_will_say_on_this_matter"),
      (assign, "$lord_might_open_up", 1),
    (try_end),
  
    (lt, ":result_for_political", ":intrigue_willingness"),    
  
    (call_script, "script_add_rumor_string_to_troop_notes", "$g_talk_troop", ":leader", 12),
  ],
   "{s12}", "lord_recruit_2_discontent_b",[   
   ]],
   
  [anyone, "lord_recruit_2_discontent", [
  ],
   "{s12}", "lord_recruit_hesitant", []],
   
  [anyone, "lord_recruit_2_discontent_b", [  ],
   "Sometimes, I do worry about the state of the realm.", "lord_recruit_3", []],
   
  [anyone|plyr,"lord_recruit_hesitant", 
  [
    (eq, "$lord_might_open_up", 1),
  ],
   "Can't I persuade you to say a little more?", "lord_recruit_hesitant_persuade",[
   ]],

  [anyone|plyr,"lord_recruit_hesitant", [],
   "Ah. Very good.", "lord_pretalk", []],
   
  [anyone, "lord_recruit_hesitant_persuade", 
  [  
    (faction_get_slot, ":leader", "$g_talk_troop_faction", slot_faction_leader),   
    (call_script, "script_calculate_troop_political_factors_for_liege", "$g_talk_troop", ":leader"),
    (assign, ":result_for_political", reg3),
    (store_sub, ":open_up_desire", 12, ":result_for_political"),
    (assign, reg3, ":open_up_desire"),
    (val_div, ":open_up_desire", 3),
    
	#(store_random_in_range, ":random", -2, ":max_random_value"),
    (store_sub, ":max_random_value", 14, ":open_up_desire"),
	(troop_get_slot, ":temp_ai_seed", "$g_talk_troop", slot_troop_temp_decision_seed),
    (store_mod, ":random", ":temp_ai_seed", ":max_random_value"), 
    (val_sub, ":random", 2), #random changes between -2 to (14 - (":result_for_political" div 3))
    
	#(val_sub, ":random", 20), #open this line when you want to 100% pass this step and remove again after making tests.
	(store_skill_level, ":persuasion_skill", "skl_persuasion", "trp_player"),
	(lt, ":random", ":persuasion_skill"),
  ],
   "If you put it that way, I admit that I do sometimes worry about the state of the realm.", "lord_recruit_3", []],

  [anyone, "lord_recruit_hesitant_persuade", [
    (troop_set_slot, "$g_talk_troop", slot_troop_intrigue_impatience, 100),
    (call_script, "script_troop_change_relation_with_troop", "$g_talk_troop", "trp_player", -1),
  ],
   "You try my patience. I said that I have nothing to say.", "lord_pretalk", []],
      
  [anyone|plyr,"lord_recruit_3", [
				],
   "Well, I have something to tell you.", "lord_recruit_3_a",[
   ]],

  [anyone|plyr,"lord_recruit_3", [
				],
   "Well, that's interesting to know. But enough about politics.", "lord_pretalk",[
   ]],
   

   [anyone, "lord_recruit_3_a", [
	(troop_slot_ge, "$g_talk_troop", slot_lord_recruitment_argument, 1),

	(troop_get_slot, ":candidate", "$g_talk_troop", slot_lord_recruitment_candidate),
	(str_store_troop_name, s14, ":candidate"),
	
	(try_begin),
		(eq, ":candidate", "trp_player"),
		(str_store_string, s14, "@you"),
	(try_end),
	
	(try_begin),
		(troop_slot_eq, "$g_talk_troop", slot_lord_recruitment_argument, argument_claim),
		(eq, ":candidate", "trp_player"),
		(str_store_string, s12, "str_that_you_are_the_rightful_heir_to_the_throne_of_calradia"),
	(else_try),
		(troop_slot_eq, "$g_talk_troop", slot_lord_recruitment_argument, argument_claim),
		(str_store_troop_name, s14, ":candidate"),
		(str_store_string, s12, "str_that_s14_is_the_rightful_ruler_of_calradia"),		
	(else_try),
		(troop_slot_eq, "$g_talk_troop", slot_lord_recruitment_argument, argument_ruler),
		(str_store_string, s12, "str_that_s14_will_rule_this_land_justly"),
	(else_try),
		(troop_slot_eq, "$g_talk_troop", slot_lord_recruitment_argument, argument_lords),
		(str_store_string, s12, "str_that_s14_will_protect_our_rights_as_nobles"),
	(else_try),
		(troop_slot_eq, "$g_talk_troop", slot_lord_recruitment_argument, argument_victory),
		(str_store_string, s12, "str_that_s14_will_unify_this_land_and_end_this_war"),
	(else_try),
		(troop_slot_eq, "$g_talk_troop", slot_lord_recruitment_argument, argument_benefit),
		(str_store_string, s12, "str_that_s14_will_reward_me_with_a_fief"),		
	(try_end),
   ],
   "{s12}", "lord_recruit_3_reset_claim", []],


   [anyone|plyr, "lord_recruit_3_reset_claim", [  ],
   "Yes, that's it.", "lord_recruit_3_claim", [
  
   ]],

   [anyone|plyr, "lord_recruit_3_reset_claim", [  ],
   "Let me phrase that a little differently.", "lord_recruit_3_a_reset", []],
   

   [anyone, "lord_recruit_3_a", 
   [ 
	#(display_message, "str_prior_arguments"),
	#(assign, reg3, "$claim_arguments_made"),
	#(display_message, "str_legal_reg3"),
	
	#(assign, reg3, "$ruler_arguments_made"),
	#(display_message, "str_just_king_reg3"),
	
	#(assign, reg3, "$victory_arguments_made"),
	#(display_message, "str_bring_peace_reg3"),

	#(assign, reg3, "$lords_arguments_made"),
	#(display_message, "str_only_best_counsel_reg3"),
	
	#(assign, reg3, "$benefit_arguments_made"),
	#(display_message, "str_reward_lords_reg3"),	
   ],
   "Yes?", "lord_recruit_3_b", []],

   [anyone, "lord_recruit_3_a_reset", [],
   "Yes?", "lord_recruit_3_b", []],
   
   
   [anyone|plyr, "lord_recruit_3_b", [ 	
    (faction_get_slot, ":players_liege", "$players_kingdom", slot_faction_leader),
	(eq, ":players_liege", "trp_player"),	
   ],
   "I ask for your support for the throne of Calradia", "lord_recruit_3_why",
   [
     (troop_set_slot, "$g_talk_troop", slot_lord_recruitment_candidate, "trp_player"),
     (try_begin),
       (troop_slot_eq, "$g_talk_troop", slot_troop_recruitment_random, 0),       
       
       #(store_random_in_range, ":random", 1, 101), #replaced with below 3 lines to provide a constant history (not changable by save-loads).
       (troop_get_slot, ":temp_ai_seed", "$g_talk_troop", slot_troop_temp_decision_seed),
       (store_div, ":random", ":temp_ai_seed", 100),  #I used div instead of mod to have a different random value, value generated from (mod 100) will be used in next steps. These two values should be non-related.       
       (val_add, ":random", 1),
       
       (troop_set_slot, "$g_talk_troop", slot_troop_recruitment_random, ":random"),
     (try_end),	
   ]],


   [anyone|plyr, "lord_recruit_3_b", [ 	
    (faction_get_slot, ":players_liege", "$players_kingdom", slot_faction_leader),
	(neq, ":players_liege", "trp_player"),
	(neq, "$players_kingdom", "$g_talk_troop_faction"),
	(str_store_troop_name, s45, ":players_liege"),
	
   ],
   "I ask you to pledge allegiance to my liege, {s45}, as monarch of all Calradia", "lord_recruit_3_why",
   [
     (faction_get_slot, ":players_liege", "$players_kingdom", slot_faction_leader),
     (troop_set_slot, "$g_talk_troop", slot_lord_recruitment_candidate, ":players_liege"),
     (try_begin),
       (troop_slot_eq, "$g_talk_troop", slot_troop_recruitment_random, 0),
       
       #(store_random_in_range, ":random", 1, 101), #replaced with below 3 lines to provide a constant history (not changable by save-loads).
       (troop_get_slot, ":temp_ai_seed", "$g_talk_troop", slot_troop_temp_decision_seed),
       (store_div, ":random", ":temp_ai_seed", 100),  #I used div instead of mod to have a different random value, value generated from (mod 100) will be used in next steps. These two values should be non-related.       
       (val_add, ":random", 1),

       (troop_set_slot, "$g_talk_troop", slot_troop_recruitment_random, ":random"),
     (try_end),
	]],
	
   [anyone|plyr, "lord_recruit_3_b", [ 	
   ],
   "Never mind", "lord_pretalk",
   [
	]],
			
   [anyone, "lord_recruit_3_dilemma_1", [ #explain the political dilemma
    (troop_get_slot, ":players_liege", "$g_talk_troop", slot_lord_recruitment_candidate),
	(str_store_troop_name, s45, ":players_liege"),
    (troop_get_type, reg3, ":players_liege"),
	
    (faction_get_slot, ":current_liege", "$g_talk_troop_faction", slot_faction_leader),
	(str_store_troop_name, s46, ":current_liege"),
    
	(call_script, "script_lord_comment_to_s43", "$g_talk_troop", "str_rebellion_dilemma_default"),
 ], "{s43}", "lord_recruit_3_dilemma_2",
   []],
   
   [anyone, "lord_recruit_3_dilemma_2", [
	(call_script, "script_lord_comment_to_s43", "$g_talk_troop", "str_rebellion_dilemma_2_default"),
 ], "{s43}", "lord_recruit_3_why",
   []],



   [anyone, "lord_recruit_3_why", 
   [
    (troop_slot_eq, "$g_talk_troop", slot_lord_recruitment_candidate, "trp_player"),
	
	(assign, ":one_fortress_found", 0),
	(try_for_range, ":walled_center", walled_centers_begin, walled_centers_end),
		(this_or_next|party_slot_eq, ":walled_center", slot_town_lord, "$g_talk_troop"),
			(party_slot_eq, ":walled_center", slot_town_lord, "trp_player"),
		(assign, ":one_fortress_found", 1),
	(try_end),
	(eq, ":one_fortress_found", 0),
	
   ],
   "Neither of us has so much as a single fortress to our name. Would you rule your kingdom from an outlaw's den in the woods?", "lord_pretalk",
   [   
    ]],



   
   [anyone, "lord_recruit_3_why", 
   [
     (troop_get_slot, ":recruitment_candidate", "$g_talk_troop", slot_lord_recruitment_candidate),
     (try_begin),
       (eq, ":recruitment_candidate", "trp_player"),
       (str_store_string, s44, "@you"),
     (else_try),	
       (str_store_troop_name, s44, ":recruitment_candidate"),
     (try_end),   
   ],
   "Why should I support {s44}?", "lord_recruit_3_d",
   [   
     (troop_get_slot, ":recruitment_candidate", "$g_talk_troop", slot_lord_recruitment_candidate),
	 (try_begin),
       (troop_get_type, ":is_female", ":recruitment_candidate"),
       (str_store_string, s45, "str_he"),
       (str_store_string, s47, "str_king"),
		
       (try_begin),
         (eq, ":is_female", 1),
         (str_store_string, s45, "str_she"),
         (str_store_string, s47, "str_queen"),
       (try_end),
     
       (try_begin),
         (eq, ":recruitment_candidate", "$supported_pretender"),
         (eq, "$supported_pretender_old_faction", "fac_kingdom_3"),
         (str_store_string, s47, "str_khan"),
       (try_end),

       (try_begin),
         (eq, ":recruitment_candidate", "trp_player"),
         (str_store_string, s45, "str_i"),
       (try_end),
	 (try_end),      
    ]],
   
  [anyone|plyr,"lord_recruit_3_d", 
  [
    (troop_get_slot, ":recruitment_candidate", "$g_talk_troop", slot_lord_recruitment_candidate),

    (str_store_string, s43, "str_according_to_the_ancient_law_and_custom_of_the_calradians_s45_should_be_s47"),
    (try_begin),
      (gt, "$supported_pretender", 0),
      (eq, ":recruitment_candidate", "$supported_pretender"),
      (str_store_faction_name, s46, "$supported_pretender_old_faction"),
      (str_store_string, s43, "str_because_s44_is_the_rightful_s47_of_the_s46"),
    (try_end),	
  ],
   "{s43}", "lord_recruit_3_claim",
   [
    (troop_set_slot, "$g_talk_troop", slot_lord_recruitment_argument, argument_claim),
    (val_add, "$claim_arguments_made", 1),
    (assign, "$opposed_arguments_made", "$victory_arguments_made"),   
   ]],
   
  [anyone|plyr,"lord_recruit_3_d", 
  [],
   "If {s45} were {s47}, {s45} would deal with all men fairly and uphold the rights of the commons.", "lord_recruit_3_claim",
   [
     (troop_set_slot, "$g_talk_troop", slot_lord_recruitment_argument, argument_ruler),   
     (val_add, "$ruler_arguments_made", 1),
     (assign, "$opposed_arguments_made", "$lords_arguments_made"),
   ]],

  [anyone|plyr,"lord_recruit_3_d", 
  [],
   "If {s45} were {s47}, {s45} would uphold your ancient rights as a noble of this land.", "lord_recruit_3_claim",
   [
    (troop_set_slot, "$g_talk_troop", slot_lord_recruitment_argument, argument_lords),   
    (val_add, "$lords_arguments_made", 1),
    (assign, "$opposed_arguments_made", "$ruler_arguments_made"),
   ]],
         
  [anyone|plyr,"lord_recruit_3_d", 
  [],
   "Because {s45} can unify Calradia and end this discord.", "lord_recruit_3_claim",
   [
     (troop_set_slot, "$g_talk_troop", slot_lord_recruitment_argument, argument_victory),
     (val_add, "$victory_arguments_made", 1),
     (assign, "$opposed_arguments_made", "$claim_arguments_made"),   
   ]],

  [anyone|plyr,"lord_recruit_3_d", 
  [],
   "Because {s45} will reward you with lands.", "lord_recruit_3_claim",[
   (troop_set_slot, "$g_talk_troop", slot_lord_recruitment_argument, argument_benefit),   
   (val_add, "$benefit_arguments_made", 1),
   ]],

  [anyone|plyr,"lord_recruit_3_d", 
  [],
   "Never mind", "lord_pretalk",[
    (troop_set_slot, "$g_talk_troop", slot_troop_recruitment_random, 0),
   ]],

  [anyone,"lord_recruit_3_claim", [
	(neg|troop_slot_eq, "$g_talk_troop", slot_lord_recruitment_argument, argument_benefit),
  
	(gt, "$opposed_arguments_made", 0),	
    (troop_get_slot, ":recruitment_random", "$g_talk_troop", slot_troop_recruitment_random),
    (store_mul, ":opposed_number", "$opposed_arguments_made", 10),
    (val_add, ":opposed_number", ":recruitment_random"),
    (gt, ":opposed_number", 100),

	(try_begin),
		(troop_slot_eq, "$g_talk_troop", slot_lord_recruitment_argument, argument_claim),
		(str_store_string, s12, "str_you_speak_of_claims_and_legalities_yet_to_others_you_talk_of_bringing_peace_by_force"),
	(else_try),
		(troop_slot_eq, "$g_talk_troop", slot_lord_recruitment_argument, argument_victory),
		(str_store_string, s12, "str_you_speak_of_bringing_peace_by_force_yet_to_others_you_make_legal_claims"),
	(else_try),
		(troop_slot_eq, "$g_talk_troop", slot_lord_recruitment_argument, argument_commons),
		(str_store_string, s12, "str_you_speak_to_some_of_upholding_the_rights_of_the_commons_yet_you_speak_to_others_of_uphold_the_rights_of_nobles_what_if_those_rights_are_in_conflict"),
	(else_try),
		(troop_slot_eq, "$g_talk_troop", slot_lord_recruitment_argument, argument_lords),
		(str_store_string, s12, "str_you_speak_to_me_of_upholding_my_rights_as_a_lord_but_to_others_you_talk_of_upholding_the_rights_of_all_commons_what_if_those_rights_come_into_conflict"),		
	(try_end),
	],
	"Do you perhaps tell each person what you think they most want to hear? {s12}", "lord_recruit_3_claim",
	[
	(assign, "$opposed_arguments_made", -1),	
	]],
   
   #Is the candidate  worthy of being king?
  [anyone,"lord_recruit_3_claim", [
   
    (assign, "$g_persuasion_trump_used", 0),
	
	(troop_get_slot, ":recruitment_candidate", "$g_talk_troop", slot_lord_recruitment_candidate),
	
	(assign, ":continue", 0),
	
	(str_store_string, s12, "str_a_claim_should_be_strong_indeed_before_one_starts_talking_about_it"),
	
	(try_begin), #non-player candidates are automatically considered worthy
		(neq, ":recruitment_candidate", "trp_player"),

		(str_store_string, s12, "str_indeed_please_continue"),
		(assign, ":continue", 1),		
	(else_try),
		(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_martial),
		
		(str_store_string, s12, "str_a_claim_should_be_strong_indeed_before_one_starts_talking_about_it"),
		
		#(assign, reg0, "$player_right_to_rule"),
		#(assign, reg1, ":recruitment_candidate"),
		#(troop_get_slot, reg2, ":recruitment_candidate", slot_troop_renown),
		#(display_message, "@{!}DEBUG : player_right_to_rule = {reg0}"),
		#(display_message, "@{!}DEBUG : recruitment_candidate = {reg1}"),
		#(display_message, "@{!}DEBUG : renown = {reg2}"),
		
		(ge, "$player_right_to_rule", 10),
		
		(str_store_string, s12, "str_a_king_should_prove_his_valor_beyond_any_doubt_before_he_starts_talking_about_a_claim_to_the_throne"),
		(troop_slot_ge, ":recruitment_candidate", slot_troop_renown, 400),
		
		(assign, ":continue", 1),		
	(else_try),
		(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_goodnatured),
		 
		(str_store_string, s12, "str_you_must_prove_yourself_a_great_warrior_before_men_will_follow_you_as_king"),
		(troop_slot_ge, ":recruitment_candidate", slot_troop_renown, 200),
		
		(assign, ":continue", 1),				
	(else_try),		
		(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_upstanding),
		
		(str_store_string, s12, "str_a_claim_to_the_throne_should_be_strong_indeed_before_one_presses_it"),
		(ge, "$player_right_to_rule", 20),
		
		(str_store_string, s12, "str_indeed_but_a_man_must_also_prove_himself_a_great_warrior_before_men_will_follow_you_as_king"),
		(troop_slot_ge, ":recruitment_candidate", slot_troop_renown, 200),
		
		(assign, ":continue", 1),		
	(else_try),	
		(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_quarrelsome),
		
		(str_store_string, s12, "str_my_pigherd_can_declare_himself_king_if_he_takes_he_fancy_i_think_you_need_to_break_a_few_more_heads_on_tbe_battlefield_before_men_will_follow_you"),
		(troop_slot_ge, ":recruitment_candidate", slot_troop_renown, 200),
		
		(assign, ":continue", 1),		
	(else_try),	
		(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_selfrighteous),

		(str_store_string, s12, "str_if_you_do_not_wish_to_die_on_a_scaffold_like_so_many_failed_pretenders_before_you_i_would_suggest_that_you_to_build_your_claim_on_stronger_foundations_so_that_men_will_follow_you"),
		(ge, "$player_right_to_rule", 10),

		(str_store_string, s12, "str_if_you_do_not_wish_to_die_on_a_scaffold_like_so_many_failed_pretenders_before_you_i_would_advise_you_prove_yourself_on_the_field_of_battle_so_that_men_will_follow_you"),
		(troop_slot_ge, ":recruitment_candidate", slot_troop_renown, 200),
		
		(assign, ":continue", 1),		
	(else_try),	
		(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_debauched),

		(str_store_string, s12, "str_talk_is_for_heralds_and_lawyers_real_kings_prove_themselves_with_their_swords"),
		(troop_slot_ge, ":recruitment_candidate", slot_troop_renown, 200),
		
		(assign, ":continue", 1),		
	(else_try),		
		(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_cunning),
		
		(str_store_string, s12, "str_i_were_you_i_would_try_to_prove_myself_a_bit_more_before_i_went_about_pressing_my_claim"),
		(troop_slot_ge, ":recruitment_candidate", slot_troop_renown, 400),
		
		(assign, ":continue", 1),						
	(try_end),
	
	#Trump to overlook player unworthiness
	(str_clear, s14),
	(try_begin),
		(eq, ":continue", 1),
		(str_store_string, s12, "str_indeed_please_continue"),
		
	(else_try),
		(eq, ":continue", 0),
		(eq, "$g_persuasion_trump_used", 0),
		(assign, "$g_persuasion_trump_used", 1),
		#persuasion check
		(store_skill_level, ":persuasion_skill", "skl_persuasion", "trp_player"),
		
		(troop_get_slot, ":persuasion_random", "$g_talk_troop", slot_troop_recruitment_random),

        (try_begin),
          (eq, "$cheat_mode", 1),          
		  #(assign, reg3, ":persuasion_skill"),
		  #(assign, reg4, ":persuasion_random"), 
		  #(display_message, "str_trump_check_random_reg4_skill_reg3"),
		(try_end),  

		(val_mul, ":persuasion_skill", 7),
		(ge, ":persuasion_skill", ":persuasion_random"),
		
		(assign, ":continue", 1),
		
		(call_script, "script_lord_comment_to_s43", "$g_talk_troop", "str_changed_my_mind_default"), 
		(str_store_string, s14, "str_s12_s43"),
		(str_store_string, s12, s14),
	(try_end),
	
	(eq, ":continue", 1),

	],
   "{s12}", "lord_recruit_4",[
   ]],

   
	#the lord refuses. s12 is set by the previous 
    [anyone,"lord_recruit_3_claim",  [
								],
   "{s12}", "lord_pretalk",[
   ]],
   
   
  [anyone|plyr,"lord_recruit_4", [
    (troop_get_slot, ":recruitment_candidate", "$g_talk_troop", slot_lord_recruitment_candidate),
    (str_store_troop_name, s16,  ":recruitment_candidate"),
	
	(try_begin),
		(eq,  ":recruitment_candidate", "trp_player"),
		(str_store_string, s16, "str_me"),
	(try_end),
  ],
   "I ask you to pledge your allegiance to {s16}.", "lord_recruit_4_objective_conditions",[]],
   
  [anyone|plyr,"lord_recruit_4", [
    (troop_set_slot, "$g_talk_troop", slot_troop_recruitment_random, 0),
						    ],
   "Never mind.", "lord_pretalk",[]],

  [anyone,"lord_recruit_4_objective_conditions", [
			(troop_get_slot, ":recruitment_candidate", "$g_talk_troop", slot_lord_recruitment_candidate),
			
			(call_script, "script_calculate_troop_political_factors_for_liege", "$g_talk_troop", ":recruitment_candidate"),
			(str_store_string, s33, s14),
			
			(assign, ":result_for_security", reg2),		
            (assign, ":result_for_political", reg4),	
            
			#this will store 
			(try_begin),
			  (eq, "$cheat_mode", 1),
			  (display_message, "str_preliminary_result_for_political_=_reg4"),
			(try_end),  
			
#			(assign, ":result_for_ideological", reg6),
#			(assign, ":result_for_material", reg8),		
			(assign, ":change_penalty", reg10),		
			(assign, ":result_for_new_liege", reg0),
			
			(faction_get_slot, ":cur_liege", "$g_talk_troop_faction", slot_faction_leader),
			(call_script, "script_calculate_troop_political_factors_for_liege", "$g_talk_troop", ":cur_liege"),
			
			(store_sub, ":result_for_security_comparative", ":result_for_security", reg2),
			(store_sub, ":result_for_political_comparative", ":result_for_political", reg4),		
#			(store_sub, ":result_for_ideological_comparative", ":result_for_ideological", reg6), #to be used if NPC lords ever have different ideologies		
#			(store_sub, ":result_for_material_comparative", ":result_for_material", reg8), #result for material (meaning, promised new fiefs or bribes) currently disabled 		
			(assign, ":result_for_old_liege", reg0),
			
			(try_begin),
			  (eq, "$cheat_mode", 1),
			  (assign, reg31, ":result_for_new_liege"),
			  (assign, reg32, ":result_for_old_liege"),
			  
			  (display_message, "@{!}DEBUG : result_for_new_liege : {reg31}"),
			  (display_message, "@{!}DEBUG : result_for_old_liege : {reg32}"),
			(try_end),

			(store_sub, "$pledge_chance", ":result_for_new_liege", ":result_for_old_liege"),
			(val_add, "$pledge_chance", 50),
			(val_div, "$pledge_chance", 2),						
						
			(try_begin),
				(lt, ":result_for_political", 0),

				(try_begin),
					(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_upstanding),
					(str_store_string, s31, "str_i_worry_about_those_with_whom_you_have_chosen_to_surround_yourself" ),
				(else_try),
					(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_martial),
					(str_store_string, s31, "str_there_are_some_outstanding_matters_between_me_and_some_of_your_vassals_"),										
					(try_begin),
					  (assign, reg41, ":result_for_political"),
					  (display_message, "str_result_for_political_=_reg41"),
					(try_end),  					  
				(else_try),
					(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_quarrelsome),
					(str_store_string, s31, "str_my_liege_has_his_faults_but_i_dont_care_for_your_toadies"),
				(else_try),
					(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_goodnatured),
					(str_store_string, s31, "str_i_think_youre_a_good_man_but_im_worried_that_you_might_be_pushed_in_the_wrong_direction_by_some_of_those_around_you"),
				(else_try),
					(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_selfrighteous),
					(str_store_string, s31, "str_i_am_loathe_to_fight_alongside_you_so_long_as_you_take_under_your_wing_varlots_and_base_men"),
				(else_try),
					(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_cunning),
					(str_store_string, s31, "str_ill_be_honest__with_some_of_those_who_follow_you_i_think_id_be_more_comfortable_fighting_against_you_than_with_you"),
				(else_try),
					(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_debauched),
					(str_store_string, s31, "str_i_say_that_you_can_judge_a_man_by_the_company_he_keeps_and_you_have_surrounded_yourself_with_vipers_and_vultures"),
				(else_try),
					(troop_slot_ge, "$g_talk_troop", slot_lord_reputation_type, lrep_roguish),
					(str_store_string, s31, "str_you_know_that_i_have_always_had_a_problem_with_some_of_our_companions"),										
				(try_end),				
			(else_try),
				(lt, ":result_for_political_comparative", 0),
				(str_store_string, s31, "str_politically_i_would_be_a_better_position_in_the_court_of_my_current_liege_than_in_yours"),
			(else_try),
				(str_store_string, s31, "str_i_am_more_comfortable_with_you_and_your_companions_than_with_my_current_liege"),
			(try_end),
			#end political string
			
			#end 
			(try_begin),
				(lt, ":result_for_security", 10),
				
				(try_begin),
					(this_or_next|troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_cunning),
					(troop_slot_ge, "$g_talk_troop", slot_lord_reputation_type, lrep_roguish),
					(str_store_string, s32, "str_militarily_youre_in_no_position_to_protect_me_should_i_be_attacked_id_be_reluctant_to_join_you_until_you_could"),
				(else_try),	
					(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_upstanding),
					(str_store_string, s32, "str_militarily_when_i_consider_the_lay_of_the_land_i_realize_that_to_pledge_myself_to_you_now_would_endanger_my_faithful_retainers_and_my_family"),
				(else_try),	
					(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_martial),
					(str_store_string, s32, "str_militarily_youre_in_no_position_to_come_to_my_help_if_someone_attacked_me_i_dont_mind_a_good_fight_but_i_like_to_have_a_chance_of_winning"),
				(else_try),	
					(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_goodnatured),
					(str_store_string, s32, "str_militarily_youre_in_no_position_to_come_to_my_help_if_someone_attacked_me_i_dont_mind_a_good_fight_but_i_like_to_have_a_chance_of_winning"),									
				(else_try),	
					(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_debauched),
					(str_store_string, s32, "str_militarily_you_would_have_me_join_you_only_to_find_myself_isolated_amid_a_sea_of_enemies"),
				(else_try),	
					(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_selfrighteous),
					(str_store_string, s32, "str_militarily_you_would_have_me_join_you_only_to_find_myself_isolated_amid_a_sea_of_enemies"),
				(else_try),	 
					(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_quarrelsome),
					(str_store_string, s32, "str_militarily_youre_in_no_position_to_come_to_my_help_if_someone_attacked_me_youd_let_me_be_cut_down_like_a_dog_id_bet"),					
				(try_end),
			(else_try),
				(lt, ":result_for_security_comparative", 0),
				(str_store_string, s32, "str_militarily_i_wouldnt_be_any_safer_if_i_joined_you"),
			(else_try),
				(str_store_string, s32, "str_militarily_i_might_be_safer_if_i_joined_you"),
			(try_end),
			
			(try_begin),
				(gt, ":change_penalty", 40),
				(str_store_string, s34, "str_finally_there_is_a_cost_to_ones_reputation_to_change_sides_in_this_case_the_cost_would_be_very_high"),
			(else_try),
				(gt, ":change_penalty", 20),
				(str_store_string, s34, "str_finally_there_is_a_cost_to_ones_reputation_to_change_sides_in_this_case_the_cost_would_be_significant"),
			(else_try),
				(str_store_string, s34, "str_finally_there_is_a_cost_to_ones_reputation_to_change_sides_in_this_case_however_many_men_would_understand"),
			(try_end),						
			],
   "Let me think...", "lord_recruit_5_security",[
   ]],

    [anyone,"lord_recruit_5_security",  [
	],
	"{s32}", "lord_recruit_5_political",
	[]],
   
   
    [anyone,"lord_recruit_5_political",  [
	],
	"{s31}", "lord_recruit_5_ideological",
	[]],
	
#    [anyone,"lord_recruit_5_material",  [

#	],
#	"{!}[Anticipated material gains currently not counted]", "lord_recruit_5_ideological",
#	[]],
	
    [anyone,"lord_recruit_5_ideological",  [
	],
	"{s33}", "lord_recruit_5_change_sides",
	[

	]],
		
    [anyone,"lord_recruit_5_change_sides",  [
	],
	"{s34}", "lord_recruit_6",
	[
	  (try_begin),
	    (eq, "$cheat_mode", 1),
	    (assign, reg1, "$pledge_chance"),
	    (display_message, "str_chance_of_success_=_reg1"),
	  (try_end),  
	]],
		
  [anyone|plyr,"lord_recruit_6",[
                            ],
   "It is time for you to make a decision.", "lord_recruit_6_reaction",
   [
   ]],
		
  [anyone|plyr,"lord_recruit_6",[
                            ],
   "No need to decide anything -- we can speak of this at a later time.", "lord_pretalk",
   [   
   ]],

	  	  
  [anyone,"lord_recruit_6_reaction",
   [
   ],
   "Very well...", "lord_recruit_7_decision",
   [
   (troop_set_slot, "$g_talk_troop", slot_troop_recruitment_random, 0),
   ]],
	  
	  	  	  
    [anyone,"lord_recruit_7_decision",
    [
      #(store_random_in_range, ":random", 0, 100),
      (troop_get_slot, ":temp_ai_seed", "$g_talk_troop", slot_troop_temp_decision_seed),
      (store_mod, ":random", ":temp_ai_seed", 100),                   
      
      (try_begin),
        (eq, "$cheat_mode", 1),
        (assign, reg3, ":random"),
        (display_message, "str_random_=_reg3"),
      (try_end),  
      
      (faction_get_slot, ":leader", "$g_talk_troop_faction", slot_faction_leader),
      (str_store_troop_name, s14, ":leader"),
      
      (assign, ":continue_to_pledge", 0),
      
      (try_begin),
        (troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_selfrighteous),
        (gt, ":random", "$pledge_chance"),
        (str_store_string, s12, "str_i_will_not_have_it_be_said_about_me_that_i_am_a_traitor_that_is_my_final_decision_i_have_nothing_more_to_say_on_this_matter"),
      (else_try),
        (troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_martial),
        (gt, ":random", "$pledge_chance"),
        
        (str_store_string, s12, "str_i_am_pledged_to_defend_s14_i_am_sorry_though_we_may_meet_on_the_battlefield_i_hope_that_we_will_still_be_friends"),
      (else_try),
        (this_or_next|troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_goodnatured),
        (troop_slot_ge, "$g_talk_troop", slot_lord_reputation_type, lrep_roguish),
        (gt, ":random", "$pledge_chance"),
        
        (str_store_string, s12, "str_i_really_cannot_bring_myself_to_renounce_s14_i_am_sorry_please_lets_not_talk_about_this_any_more"),
      (else_try),
        (troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_upstanding),
        (gt, ":random", "$pledge_chance"),
        
        (str_store_string, s12, "str_however_i_have_decided_that_i_must_remain_loyal_to_s14_i_am_sorry"),
      (else_try),
        (troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_debauched),
        (gt, ":random", "$pledge_chance"),
        
        (str_store_string, s12, "str_however_i_will_not_let_you_lead_me_into_treason_do_not_talk_to_me_of_this_again"),
      (else_try),
        (troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_cunning),
        (gt, ":random", "$pledge_chance"),
        
        (str_store_string, s12, "str_its_not_good_to_get_a_reputation_as_one_who_abandons_his_liege_that_is_my_decision_let_us_speak_no_more_of_this_matter"),
      (else_try),
        (troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_quarrelsome),
        (gt, ":random", "$pledge_chance"),
        
        (str_store_string, s12, "str_ive_decided_to_stick_with_s14_i_dont_want_to_talk_about_this_matter_any_more"),
      (else_try),
        (assign, ":continue_to_pledge", 1),
      (try_end),
      
      (eq, ":continue_to_pledge", 0),      
    ],
    "{s12}", "lord_pretalk",
    [
      (troop_set_slot, "$g_talk_troop", slot_troop_intrigue_impatience, 500),
    ]],
      
    [anyone,"lord_recruit_7_decision",  
    [
      (troop_get_slot, ":recruitment_candidate", "$g_talk_troop", slot_lord_recruitment_candidate),
      (str_store_troop_name, s4, ":recruitment_candidate"),
      
      (try_begin),
        (eq, "$cheat_mode", 1),
        (display_message, "str_lord_pledges_to_s4"),
      (try_end),  
    ],
    "Very well -- I am ready to pledge myself to {s4} as my {reg4?queen:king}.", "lord_recruit_pledge",
    [
      (troop_get_slot, ":recruitment_candidate", "$g_talk_troop", slot_lord_recruitment_candidate),
      
      (try_begin),
        (eq, ":recruitment_candidate", "trp_player"),
        (faction_slot_eq, "fac_player_supporters_faction", slot_faction_state, sfs_inactive),
        (call_script, "script_activate_player_faction", "trp_player"),
      (try_end),
      
      (assign, "$lord_expects_fief", 0),
      (try_begin),
        (troop_slot_eq, "$g_talk_troop", slot_lord_recruitment_argument, argument_benefit),
        (assign, "$lord_expects_fief", 1),
      (try_end),
            
      (call_script, "script_change_troop_faction", "$g_talk_troop", "$players_kingdom"),
      
      (try_begin), #Actually, perhaps do provocation rather than war
        (store_relation, ":relation", "$players_kingdom", "$g_talk_troop_faction"), 
        (ge, ":relation", 0),
        
        (try_begin),
          (eq, "$cheat_mode", 1),
          (display_message, "str_lord_recruitment_provokes_home_faction"),
        (try_end),  
        
        (call_script, "script_add_log_entry", logent_border_incident_troop_suborns_lord, "trp_player", -1, "$g_talk_troop","$g_talk_troop_faction"),
        (store_add, ":slot_provocation_days", "$players_kingdom", slot_faction_provocation_days_with_factions_begin),
        (val_sub, ":slot_provocation_days", kingdoms_begin),
        (faction_set_slot, "$g_talk_troop_faction", ":slot_provocation_days", 30),
        
        (faction_get_slot, ":other_liege", "$g_talk_troop_faction", slot_faction_leader),
        (call_script, "script_troop_change_relation_with_troop", "trp_player", ":other_liege", -3),
      (try_end),
      
      (troop_get_type, reg4, ":recruitment_candidate"),
      (try_begin),
        (eq, ":recruitment_candidate", "trp_player"),
        (str_store_string, s4, "@you"),
		(call_script, "script_change_player_right_to_rule", 5),
      (else_try),
        (str_store_troop_name, s4, ":recruitment_candidate"),
      (try_end),		
	]],

	
    [anyone,"lord_recruit_pledge",  
    [
      (eq, "$lord_expects_fief", 1),
	],
    "Remember. You have promised me a fief. I will hold you to that promise.", "lord_recruit_pledge",
    [
	  (assign, "$lord_expects_fief", 0),
	  (troop_set_slot, "$g_talk_troop", slot_lord_recruitment_argument, 0),
	  (call_script, "script_add_log_entry", logent_liege_promises_fief_to_vassal, "trp_player", 0, "$g_talk_troop", "$players_kingdom"),
	  (troop_set_slot, "$g_talk_troop", slot_troop_promised_fief, 1),
	]],
	
    [anyone,"lord_recruit_pledge",  
    [
	  (troop_get_slot, ":recruitment_candidate", "$g_talk_troop", slot_lord_recruitment_candidate),
	  (eq, ":recruitment_candidate", "trp_player"),
	],
    "So be it -- I pledge allegiance to you as your faithful vassal. I shall stand at your side to fight your enemies should you need my sword, and uphold your claims and those of your legitimate heirs. I expect in turn that you will protect me and recognize my rights as your vassal.", "lord_recruit_pledge_conclude",
	[
	  (assign, "$g_leave_encounter", 1),
	]],
	
    [anyone,"lord_recruit_pledge",  [
	(troop_get_slot, ":recruitment_candidate", "$g_talk_troop", slot_lord_recruitment_candidate),
	(str_store_troop_name, s4, ":recruitment_candidate"),
	],
    "So be it -- you may inform {s4} that I am now {reg4?her:him} faithful vassal, that I will follow {reg4?her:him} as long as my breath remains, and I will be at {reg4?her:his} side to fight your enemies should you need my sword, and that I uphold your lawful claims and those of your legitimate heirs. In turn, I expect his protection and his recognition of my rights as his vassal.", "lord_recruit_pledge_conclude",
	[]],
	
    [anyone,"lord_recruit_pledge_conclude",  [
	],
    "Now... It is a momentous step I have taken. I will take my leave, as I may need some time prepare myself for what comes next.", "close_window",
	[]],
	#lord recruitment changes end


	#POLITICAL QUESTS RESOLUTIONS	
 [anyone, "lord_start",   [

  (check_quest_active, "qst_offer_gift"),
  (quest_slot_eq, "qst_offer_gift", slot_quest_target_troop, "$g_talk_troop"), 
  (quest_slot_eq, "qst_offer_gift", slot_quest_current_state, 2),
  
  (this_or_next|troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_upstanding),
  (this_or_next|troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_goodnatured),
	(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_martial),
  (store_random_in_range, ":random", 3),
  (eq, ":random", 0),  

  (quest_get_slot, ":giver_troop", "qst_offer_gift", slot_quest_giver_troop), 
  (str_store_troop_name, s10, ":giver_troop"),
  (call_script, "script_troop_get_family_relation_to_troop", ":giver_troop",  "$g_talk_troop"),
  ],
    "I received the gift, presented to me through my {s11} {s10}. It was a noble gesture, {sir/my lady}, and I regret that we ever quarreled.", "close_window",
	[
	(call_script, "script_troop_get_relation_with_troop", "$g_talk_troop", "trp_player"),
	(store_sub, ":difference", 0, reg0),
	(val_add, ":difference", 5),
	(val_max, ":difference", 5), 
	(call_script, "script_troop_change_relation_with_troop", "$g_talk_troop", "trp_player", ":difference"),
	(call_script, "script_end_quest", "qst_offer_gift"),
	(assign, "$g_leave_encounter", 1),
	
	]],	

	
	
  [anyone,"lord_start",[
  (check_quest_active, "qst_offer_gift"),
  (quest_slot_eq, "qst_offer_gift", slot_quest_target_troop, "$g_talk_troop"), 
  (quest_slot_eq, "qst_offer_gift", slot_quest_current_state, 2),
  
  (store_random_in_range, ":random", 3),
  (neq, ":random", 0),  
  
  (quest_get_slot, ":giver_troop", "qst_offer_gift", slot_quest_giver_troop), 
  (str_store_troop_name, s10, ":giver_troop"),
  (call_script, "script_troop_get_family_relation_to_troop", ":giver_troop",  "$g_talk_troop"),
  
  ],
    "I received the gift, presented to me through my {s11} {s10}. For {reg4?her:his} sake, I am willing to let bygones be bygones.", "close_window",	[
	(call_script, "script_troop_get_relation_with_troop", "$g_talk_troop", "trp_player"),
	(store_sub, ":difference", 0, reg0),
	(val_max, ":difference", 2),
	(call_script, "script_troop_change_relation_with_troop", "$g_talk_troop", "trp_player", ":difference"),
	(call_script, "script_end_quest", "qst_offer_gift"),
	(assign, "$g_leave_encounter", 1),
	]],	

  [anyone,"lord_start",[
  (check_quest_active, "qst_offer_gift"),
  (quest_slot_eq, "qst_offer_gift", slot_quest_target_troop, "$g_talk_troop"), 
  (quest_slot_eq, "qst_offer_gift", slot_quest_current_state, 2),

  (this_or_next|troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_quarrelsome),
  (this_or_next|troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_debauched),
	(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_selfrighteous),

  (quest_get_slot, ":giver_troop", "qst_offer_gift", slot_quest_giver_troop), 
  (str_store_troop_name, s10, ":giver_troop"),
  (call_script, "script_troop_get_family_relation_to_troop", ":giver_troop",  "$g_talk_troop"),
  
  ],
    "I received the gift, presented to me through my {s11} {s10}. Bah! Do you think you can buy my friendship?", "close_window",	[
	(call_script, "script_end_quest", "qst_offer_gift"),
	(assign, "$g_leave_encounter", 1),
	
	]],	
	
	

	[anyone,"lord_start",[
  (check_quest_active, "qst_offer_gift"),
  (quest_slot_eq, "qst_offer_gift", slot_quest_target_troop, "$g_talk_troop"), 
  (quest_slot_eq, "qst_offer_gift", slot_quest_current_state, 2),

  (quest_get_slot, ":giver_troop", "qst_offer_gift", slot_quest_giver_troop), 
  (str_store_troop_name, s10, ":giver_troop"),
  (call_script, "script_troop_get_family_relation_to_troop", ":giver_troop",  "$g_talk_troop"),
 
  ],
    "I received the gift, presented to me through my {s11} {s10}. As dear as {reg?she:he} is to me, however, I cannot forget our differences.", "close_window",
	[
	(assign, "$g_leave_encounter", 1),
	(call_script, "script_end_quest", "qst_offer_gift"),
	]],	


	
  [anyone|plyr,"lord_talk",[
  (check_quest_active, "qst_denounce_lord"),
  (quest_slot_eq, "qst_denounce_lord", slot_quest_giver_troop, "$g_talk_troop"), 
  (this_or_next|check_quest_succeeded, "qst_denounce_lord"),
	(check_quest_failed, "qst_denounce_lord"),
  (quest_get_slot, ":target_troop", "qst_denounce_lord", slot_quest_giver_troop), 
  (str_store_troop_name, s4, ":target_troop"),	
  ],
    "I did as you suggested, and denounced {s4}", "denounce_lord_results"  ,
	[
	]],	

	
  [anyone,"denounce_lord_results",[
  (check_quest_succeeded, "qst_denounce_lord"),
  (faction_get_slot, ":faction_leader", "$g_talk_troop_faction", slot_faction_leader),
  (str_store_troop_name, s4, ":faction_leader"),	
  
  ],
    "Yes, and hopefully now {s4} will think twice before entrusting him with any additional fiefs, honors, or offices. We are grateful to you.", "lord_pretalk",
	[
	(call_script, "script_succeed_quest", "qst_denounce_lord"),
	(call_script, "script_end_quest", "qst_denounce_lord"),
	(call_script, "script_troop_change_relation_with_troop", "$g_talk_troop", "trp_player", 8),
	(add_xp_as_reward, 1000),
	]],	
	
	
  [anyone,  
"denounce_lord_results",[
#	(check_quest_failed, "qst_denounce_lord"),
  ],
    "So you did -- and we have heard that he forced you to retract your words, and thus emerged from this affair looking stronger than before. You will forgive me, {sir/my lady}, if my gratitude to you is somewhat muted.", "close_window",
	[
	(call_script, "script_end_quest", "qst_denounce_lord"),
	
	]],	
	
	

	[anyone|plyr,"lord_talk",[
  (check_quest_active, "qst_intrigue_against_lord"),
  (quest_slot_eq, "qst_intrigue_against_lord", slot_quest_giver_troop, "$g_talk_troop"), 
  
  (this_or_next|check_quest_succeeded, "qst_intrigue_against_lord"),
	(check_quest_failed, "qst_intrigue_against_lord"),
	
  (quest_get_slot, ":target_troop", "qst_intrigue_against_lord", slot_quest_target_troop), 
  (str_store_troop_name, s4, ":target_troop"), 	
  (faction_get_slot, ":liege", "$players_kingdom", slot_faction_leader),	
  (str_store_troop_name, s5, ":liege"), 	
	
	
  ],
    "I did as you asked, and spoke to {s5} about the danger posed by {s4}.", "lord_quest_intrigue_result"  ,
	[
	]],	
	
  [anyone,"lord_quest_intrigue_result",[
  (check_quest_succeeded, "qst_intrigue_against_lord"),
  ],
    "So we hear. Hopefully now {s5} will think twice before entrusting him with any additional fiefs, honors, or offices. We are grateful to you.", "lord_pretalk"  ,
	[
	(call_script, "script_end_quest", "qst_intrigue_against_lord"),
	(quest_set_slot, "qst_intrigue_against_lord", slot_quest_dont_give_again_remaining_days, 30),
	(call_script, "script_troop_change_relation_with_troop", "$g_talk_troop", "trp_player", 8),
	(add_xp_as_reward, 500),
	]],	
	
  [anyone,"lord_quest_intrigue_result",[
  (check_quest_failed, "qst_intrigue_against_lord"),
  ],
    "So we hear -- but alas, {s5} seems not to have listened. Still, we are grateful to you for trying.", "close_window"  ,
	[
	(call_script, "script_end_quest", "qst_intrigue_against_lord"),
	(quest_set_slot, "qst_intrigue_against_lord", slot_quest_dont_give_again_remaining_days, 30),
#	(call_script, "script_troop_change_relation_with_troop", "$g_talk_troop", "trp_player", 2),
	]],	
	
	

  [anyone|plyr,"lord_talk",[#(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
                            (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
                            (check_quest_active,"qst_lend_companion"),
                            (quest_slot_eq, "qst_lend_companion", slot_quest_giver_troop, "$g_talk_troop"),
                            (store_current_day, ":cur_day"),
                            (quest_get_slot, ":quest_target_amount", "qst_lend_companion", slot_quest_target_amount),
                            (ge, ":cur_day", ":quest_target_amount"),
                            (quest_get_slot, ":quest_target_troop", "qst_lend_companion", slot_quest_target_troop),
                            (str_store_troop_name,s14,":quest_target_troop"),
                            (troop_get_type, reg3, ":quest_target_troop"),
                            ],
   "I should like {s14} returned to me, {s65}, if you no longer require {reg3?her:his} services.", "lord_lend_companion_end",
   []],

  [anyone,"lord_lend_companion_end",[(neg|hero_can_join, "p_main_party")],
   "You've too many men in your company already, {playername}. You could not lead any more at the moment.", "lord_pretalk",
   []],

  [anyone,"lord_lend_companion_end",[],
   "Certainly, {playername}. {reg3?She:He} is a bright {reg3?girl:fellow}, you're a lucky {man/woman} to have such worthy companions.", "lord_pretalk",
   [(quest_get_slot, ":quest_target_troop", "qst_lend_companion", slot_quest_target_troop),
    (party_add_members, "p_main_party", ":quest_target_troop", 1),
    (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 3),
    (add_xp_as_reward, 100),
    (call_script, "script_end_quest", "qst_lend_companion"),
    (str_store_troop_name,s14,":quest_target_troop"),
    (troop_get_type, reg3, ":quest_target_troop"),
    ]],
   
  [anyone|plyr,"lord_talk",[(check_quest_active,"qst_collect_debt"),
                            (quest_slot_eq,  "qst_collect_debt", slot_quest_current_state, 0),
                            (quest_get_slot, ":quest_target_troop", "qst_collect_debt", slot_quest_target_troop),
                            (eq,"$g_talk_troop",":quest_target_troop"),
                            (quest_get_slot, ":quest_giver_troop", "qst_collect_debt", slot_quest_giver_troop),
                            (str_store_troop_name,1,":quest_giver_troop")],
   "I've come to collect the debt you owe to {s1}.", "lord_ask_to_collect_debt",
   [(assign, "$g_convince_quest", "qst_collect_debt")]],

  [anyone,"lord_ask_to_collect_debt", [],  "Oh. Well, {s1} did lend me some silver a ways back,\
 but I've done him many favours in the past and I consider that money as my due payment.", "lord_ask_to_collect_debt_2",[]],
  [anyone|plyr,"lord_ask_to_collect_debt_2", [],  "{s1} considers it a debt. He asked me to speak to you on his behalf.", "convince_begin",[]],
  [anyone|plyr,"lord_ask_to_collect_debt_2", [],  "Then I will not press the matter any further.", "lord_pretalk",[]],


  [anyone,"convince_accept",[(check_quest_active, "qst_collect_debt"),
                             (quest_slot_eq, "qst_collect_debt", slot_quest_target_troop, "$g_talk_troop"),
                             (quest_get_slot, ":quest_giver_troop", "qst_collect_debt", slot_quest_giver_troop),
                             (str_store_troop_name,s8,":quest_giver_troop"),
                             (quest_get_slot, reg10, "qst_collect_debt", slot_quest_target_amount)],
   "My debt to {s8} has long been overdue and was a source of great discomfort to me.\
 Thank you for accepting to take the money to him.\
 Please give him these {reg10} denars and thank him on my behalf.", "close_window",
   [(call_script, "script_troop_add_gold", "trp_player", reg10),
    (quest_set_slot,  "qst_collect_debt", slot_quest_current_state, 1),
    (call_script, "script_succeed_quest", "qst_collect_debt"),
    (assign, "$g_leave_encounter", 1),
    ]],


  [anyone|plyr,"lord_talk",[(check_quest_active,"qst_persuade_lords_to_make_peace"),
                            (quest_get_slot, ":quest_target_troop", "qst_persuade_lords_to_make_peace", slot_quest_target_troop),
                            (quest_get_slot, ":quest_object_troop", "qst_persuade_lords_to_make_peace", slot_quest_object_troop),
                            (this_or_next|eq, ":quest_target_troop", "$g_talk_troop"),
                            (eq, ":quest_object_troop", "$g_talk_troop"),
                            (quest_get_slot, ":quest_target_faction", "qst_persuade_lords_to_make_peace", slot_quest_target_faction),
                            (quest_get_slot, ":quest_object_faction", "qst_persuade_lords_to_make_peace", slot_quest_object_faction),
                            (str_store_faction_name, s12, ":quest_target_faction"),
                            (str_store_faction_name, s13, ":quest_object_faction"),
                            ],
   "Please, {s64}, it's time to end this war between {s12} and {s13}.", "lord_ask_to_make_peace",
   [(assign, "$g_convince_quest", "qst_persuade_lords_to_make_peace")]],

  [anyone,"lord_ask_to_make_peace", [], "Eh? I'm not sure I heard you right, {playername}.\
 War is not easily forgotten by either side of the conflict, and I have a very long memory.\
 Why should I take any interest in brokering peace with those dogs?", "lord_ask_to_make_peace_2",[]],

  [anyone|plyr,"lord_ask_to_make_peace_2", [],  "Perhaps I can talk you into it...", "convince_begin",[]],
  [anyone|plyr,"lord_ask_to_make_peace_2", [],  "Never mind, peace can wait for now.", "lord_pretalk",[]],

  [anyone,"convince_accept",[(check_quest_active, "qst_persuade_lords_to_make_peace"),
                             (this_or_next|quest_slot_eq, "qst_persuade_lords_to_make_peace", slot_quest_target_troop, "$g_talk_troop"),
                             (quest_slot_eq, "qst_persuade_lords_to_make_peace", slot_quest_object_troop, "$g_talk_troop"),
                             (quest_get_slot, ":quest_object_faction", "qst_persuade_lords_to_make_peace", slot_quest_object_faction),
                             (quest_get_slot, ":quest_target_faction", "qst_persuade_lords_to_make_peace", slot_quest_target_faction),
                             (str_store_faction_name, s12, ":quest_object_faction"),
                             (str_store_faction_name, s13, ":quest_target_faction"),
                             (try_begin), # store name of other faction
                               (eq,":quest_object_faction","$g_talk_troop_faction"),
                               (str_store_faction_name, s14, ":quest_target_faction"),
                               (else_try),
                               (str_store_faction_name, s14, ":quest_object_faction"),
                             (try_end),
                             ],
   "You... have convinced me, {playername}. Very well then, you've my blessing to bring a peace offer to {s14}. I cannot guarantee they will accept it, but on the off-chance they do, I will stand by it.", "close_window",
   [(store_mul, ":new_value", "$g_talk_troop", -1),
    (try_begin),
      (quest_slot_eq, "qst_persuade_lords_to_make_peace", slot_quest_target_troop, "$g_talk_troop"),
      (quest_set_slot, "qst_persuade_lords_to_make_peace", slot_quest_target_troop, ":new_value"),
    (else_try),
      (quest_set_slot, "qst_persuade_lords_to_make_peace", slot_quest_object_troop, ":new_value"),
    (try_end),
    (quest_set_slot, "qst_persuade_lords_to_make_peace", slot_quest_convince_value, 1500),#reseting convince value for the second persuasion
    (assign, "$g_leave_encounter", 1),
    (neg|quest_slot_ge, "qst_persuade_lords_to_make_peace", slot_quest_target_troop, 0),
    (neg|quest_slot_ge, "qst_persuade_lords_to_make_peace", slot_quest_object_troop, 0),
    (call_script, "script_succeed_quest", "qst_persuade_lords_to_make_peace"),
    ]],


##
##
##  [anyone|plyr,"lord_talk",[(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                            (check_quest_active,"qst_bring_reinforcements_to_siege"),
##                             (quest_get_slot, ":quest_target_troop", "qst_bring_reinforcements_to_siege", slot_quest_target_troop),
##                             (eq,"$g_talk_troop",":quest_target_troop"),
##                             (quest_get_slot, ":quest_giver_troop", "qst_bring_reinforcements_to_siege", slot_quest_giver_troop),
##                             (quest_get_slot, ":quest_target_amount", "qst_bring_reinforcements_to_siege", slot_quest_target_amount),
##                             (quest_get_slot, ":quest_object_troop", "qst_bring_reinforcements_to_siege", slot_quest_object_troop),
##                             (party_count_companions_of_type, ":num_companions", "p_main_party", ":quest_object_troop"),
##                             (ge, ":num_companions", ":quest_target_amount"),
##                             (str_store_troop_name,1,":quest_giver_troop"),
##                             (assign, reg1, ":quest_target_amount"),
##                             (str_store_troop_name,2,":quest_object_troop")],
##   "Sir, {s1} ordered me to bring {reg1} {s2} to reinforce your siege.", "lord_reinforcement_brought",
##   [(quest_get_slot, ":quest_target_amount", "qst_bring_reinforcements_to_siege", slot_quest_target_amount),
##    (quest_get_slot, ":quest_target_party", "qst_bring_reinforcements_to_siege", slot_quest_target_party),
##    (quest_get_slot, ":quest_object_troop", "qst_bring_reinforcements_to_siege", slot_quest_object_troop),
##    (party_remove_members, "p_main_party", ":quest_object_troop", ":quest_target_amount"),
##    (party_add_members, ":quest_target_party", ":quest_object_troop", ":quest_target_amount"),
##    (call_script, "script_finish_quest", "qst_bring_reinforcements_to_siege", 100),
##    ]],
##
##  [anyone|plyr,"lord_talk",[(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                            (check_quest_active,"qst_bring_reinforcements_to_siege"),
##                             (quest_get_slot, ":quest_target_troop", "qst_bring_reinforcements_to_siege", slot_quest_target_troop),
##                             (eq,"$g_talk_troop",":quest_target_troop"),
##                             (quest_get_slot, ":quest_giver_troop", "qst_bring_reinforcements_to_siege", slot_quest_giver_troop),
##                             (quest_get_slot, ":quest_target_amount", "qst_bring_reinforcements_to_siege", slot_quest_target_amount),
##                             (quest_get_slot, ":quest_object_troop", "qst_bring_reinforcements_to_siege", slot_quest_object_troop),
##                             (party_count_companions_of_type, ":num_companions", "p_main_party", ":quest_object_troop"),
##                             (lt, ":num_companions", ":quest_target_amount"),
##                             (gt, ":num_companions", 0),
##                             (str_store_troop_name,1,":quest_giver_troop"),
##                             (assign, reg1, ":quest_target_amount"),
##                             (str_store_troop_name,2,":quest_object_troop")],
##   "Sir, {s1} ordered me to bring {reg1} {s2} as a reinforcement to your siege, but unfortunately I lost some of them during my expedition.", "lord_reinforcement_brought_some",
##   [(quest_get_slot, ":quest_target_amount", "qst_bring_reinforcements_to_siege", slot_quest_target_amount),
##    (quest_get_slot, ":quest_target_party", "qst_bring_reinforcements_to_siege", slot_quest_target_party),
##    (quest_get_slot, ":quest_object_troop", "qst_bring_reinforcements_to_siege", slot_quest_object_troop),
##    (party_count_companions_of_type, ":num_companions", "p_main_party", ":quest_object_troop"),
##    (party_remove_members, "p_main_party", ":quest_object_troop", ":num_companions"),
##    (party_add_members, ":quest_target_party", ":quest_object_troop", ":num_companions"),
##    (assign, ":percentage_completed", 100),
##    (val_mul, ":percentage_completed", ":num_companions"),
##    (val_div, ":percentage_completed", ":quest_target_amount"),
##    (call_script, "script_finish_quest", "qst_bring_reinforcements_to_siege", ":percentage_completed"),
##     ]],
##
##  [anyone,"lord_reinforcement_brought", [], "Well done {playername}. These men will no doubt be very useful. I will speak to {s1} of your help.", "lord_pretalk",[]],
##  [anyone,"lord_reinforcement_brought_some", [], "That's not quite good enough {playername}. But I suppose it is better than no reinforcements at all. Whatever, I'll tell {s1} you tried your best.", "lord_pretalk",[]],
##

  [anyone|plyr,"lord_talk",
  [
    (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
    (check_quest_active,"qst_duel_for_lady"),
    (neg|check_quest_concluded,"qst_duel_for_lady"),
    (quest_slot_eq, "qst_duel_for_lady", slot_quest_target_troop, "$g_talk_troop"),
    (quest_get_slot, ":quest_giver_troop", "qst_duel_for_lady", slot_quest_giver_troop),
    (str_store_troop_name, s1, ":quest_giver_troop")
  ],
   "I want you to take back your accusations against {s1}.", "lord_challenge_duel_for_lady", []],

   [anyone,"lord_challenge_duel_for_lady", [], "What accusations?\
 Everyone knows that she beds her stable boys and anyone else she can lay hands on while her husband is away.\
 I merely repeat the words of many.", "lord_challenge_duel_for_lady_2",[]],
  [anyone|plyr,"lord_challenge_duel_for_lady_2", [], "You will recant these lies, sirrah, or prove them against my sword!", "lord_challenge_duel",[]],
  [anyone|plyr,"lord_challenge_duel_for_lady_2", [], "If you say so...", "lord_pretalk",[]],

  [anyone,"lord_challenge_duel", 
  [
    (str_store_string, s15, "str_error__wrong_quest_type"),
    (try_begin),
      (check_quest_active,"qst_duel_for_lady"),
      (neg|check_quest_concluded,"qst_duel_for_lady"),
      (quest_slot_eq, "qst_duel_for_lady", slot_quest_target_troop, "$g_talk_troop"),
      (str_store_string, s15, "@You are challenging me to a duel? How droll!\
 As you wish, {playername}, it will be good sport to bash your head in."),
    (else_try),
      (check_quest_active,"qst_duel_courtship_rival"),
      (neg|check_quest_concluded,"qst_duel_courtship_rival"),
      (quest_slot_eq, "qst_duel_courtship_rival", slot_quest_target_troop, "$g_talk_troop"),
      (str_store_string, s15, "str_call_me_coward_very_well_you_leave_me_no_choice"),
    (try_end),  
  ], "{s15}", "close_window",
   [
     (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", -15),
     (call_script, "script_set_up_duel_with_troop", "$g_talk_troop"),
   ]],

  [anyone|plyr,"lord_talk",[#(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
                            (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
                            (check_quest_active,"qst_duel_courtship_rival"),
                            (neg|check_quest_concluded,"qst_duel_courtship_rival"),
                            (quest_slot_eq, "qst_duel_courtship_rival", slot_quest_target_troop, "$g_talk_troop"),
                            (quest_get_slot, ":quest_giver_troop", "qst_duel_courtship_rival", slot_quest_giver_troop),
                            (str_store_troop_name, s5, ":quest_giver_troop")],
   "Relinquish your suit of {s5}!", "lord_challenge_courtship_rival", []],
   
  [anyone,"lord_challenge_courtship_rival",[], "Or what? Do you intend to duel over a lady? I'll let you know -- our liege frowns on this sort of hot-headed challenge, when every man must stand together against the foreign foe.", "lord_challenge_courtship_rival_2",[]],

  [anyone|plyr,"lord_challenge_courtship_rival_2", [], "Do you fear to fight me?", "lord_challenge_duel",[]],
  [anyone|plyr,"lord_challenge_courtship_rival_2", [], "My pardon. I have spoken rashly...", "lord_pretalk",[
  (call_script, "script_end_quest", "qst_duel_courtship_rival"),
  ]],



	
  [anyone|plyr,"lord_talk",[(check_quest_active,"qst_deliver_message"),
                             (quest_get_slot, ":quest_target_troop", "qst_deliver_message", slot_quest_target_troop),
                             (eq,"$g_talk_troop",":quest_target_troop"),
                             (quest_get_slot, ":quest_giver_troop", "qst_deliver_message", slot_quest_giver_troop),
                             (str_store_troop_name,s9,":quest_giver_troop")],
   "I bring a message from {s9}.", "lord_message_delivered",
   []],

  [anyone,"lord_message_delivered", [], "Oh? Let me see that...\
 Well, well, well! It was good of you to bring me this, {playername}. Take my seal as proof that I've received it,\
 and give my regards to {s9} when you see him again.", "lord_pretalk",[
     (call_script, "script_end_quest", "qst_deliver_message"),
     (quest_get_slot, ":quest_giver", "qst_deliver_message", slot_quest_giver_troop),
     (str_store_troop_name,s9,":quest_giver"),
	 (call_script, "script_change_player_relation_with_troop", ":quest_giver", 1),
     (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 1),
   ]],

  [anyone|plyr,"lord_talk",[(check_quest_active,"qst_deliver_message_to_enemy_lord"),
                            (quest_get_slot, ":quest_target_troop", "qst_deliver_message_to_enemy_lord", slot_quest_target_troop),
                            (eq,"$g_talk_troop",":quest_target_troop"),
                            (quest_get_slot, ":quest_giver_troop", "qst_deliver_message_to_enemy_lord", slot_quest_giver_troop),
                            (str_store_troop_name,s9,":quest_giver_troop")],
   "I bring a message from {s9}.", "lord_message_delivered_enemy",
   []],


  [anyone,"lord_message_delivered_enemy", [], "Oh? Let me see that...\
 Hmmm. It was good of you to bring me this, {playername}. Take my seal as proof that I've received it,\
 with my thanks.", "close_window",[
     (call_script, "script_end_quest", "qst_deliver_message_to_enemy_lord"),
     (quest_get_slot, ":quest_giver", "qst_deliver_message_to_enemy_lord", slot_quest_giver_troop),
     (call_script, "script_change_player_relation_with_troop", ":quest_giver", 1),
     (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 1),
     (assign, "$g_leave_encounter", 1),
     ]],



  [anyone|plyr,"lord_talk", [(check_quest_active,"qst_deliver_message_to_prisoner_lord"),
                             (quest_slot_eq, "qst_deliver_message_to_prisoner_lord", slot_quest_target_troop, "$g_talk_troop"),
                             (quest_get_slot, ":quest_giver_troop", "qst_deliver_message_to_prisoner_lord", slot_quest_giver_troop),
                             (str_store_troop_name, s11, ":quest_giver_troop")],
   "I bring a message from {s11}.", "lord_deliver_message_prisoner",
   [
     #TODO: Add reward
     (call_script, "script_end_quest", "qst_deliver_message_to_prisoner_lord"),
     ]],

  [anyone,"lord_deliver_message_prisoner", [], "Can it be true?\
 Oh, thank you kindly, {playername}! You have brought hope and some small ray of light to these bleak walls.\
 Perhaps one day I will be able to repay you.", "lord_deliver_message_prisoner_2",[]],
  [anyone|plyr,"lord_deliver_message_prisoner_2", [], " 'Twas the least I could do, {s65}.", "lord_deliver_message_prisoner_2a",[]],
  [anyone,"lord_deliver_message_prisoner_2a", [], "You've no idea how grateful I am, {playername}. A thousand thanks and more.", "close_window",[]],
  [anyone|plyr,"lord_deliver_message_prisoner_2", [], "Worry not, {s65}. You'll have ample opportunity once you are free again.", "lord_deliver_message_prisoner_2b",[]],
  [anyone,"lord_deliver_message_prisoner_2b", [], "Hah, of course, {playername}. My eternal thanks go with you.", "close_window",[]],

  [anyone|plyr,"lord_talk", [#(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 1),
                             (troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
                             (check_quest_active,"qst_rescue_lord_by_replace"),
                             (quest_slot_eq, "qst_rescue_lord_by_replace", slot_quest_target_troop, "$g_talk_troop"),
                             (neg|check_quest_succeeded, "qst_rescue_lord_by_replace")],
   "Fear not, I am here to rescue you.", "lord_rescue_by_replace_offer",[]],
   
  [anyone,"lord_rescue_by_replace_offer", [],
   "By God, are you serious? What is your plan?", "lord_rescue_by_replace_offer_2",[]],
  [anyone|plyr,"lord_rescue_by_replace_offer_2", [],
   "A simple ruse, {s65}. If we exchange garments, I shall take your place here in prison,\
 while you make your escape disguised as myself.\
 I paid the guards a handsome bribe, with which I am sure they have already purchased half the wine stocks of the nearest tavern.\
 With some luck they'll soon get so drunk they'd have trouble\
 recognising their own mothers, let alone telling one of us from the other.\
 At least not until you are safely away.", "lord_rescue_by_replace_offer_3",[]],
  [anyone,"lord_rescue_by_replace_offer_3", [],
   "Hmm, it might just work... But what of you, my {friend/lady}? The guards won't take kindly to this trickery.\
 You may end up spending some time in this cell yourself.", "lord_rescue_by_replace_offer_4",[]],
  [anyone|plyr,"lord_rescue_by_replace_offer_4", [],
   "Not to worry, {s65}. The place is already starting to grow on me.", "lord_rescue_by_replace_offer_5a",[]],
  [anyone|plyr,"lord_rescue_by_replace_offer_4", [],
   "I shall be fine as long there is an ample reward waiting at the end.", "lord_rescue_by_replace_offer_5b",[]],
  [anyone,"lord_rescue_by_replace_offer_5a",[],
   "You are a brave soul indeed. I won't forget this.", "lord_rescue_by_replace_offer_6",[]],
  [anyone,"lord_rescue_by_replace_offer_5b",[],
   "Of course, my {friend/lady}, of course! Come to me when you have regained your freedom,\
 and perhaps I shall be able to repay the debt I owe you.", "lord_rescue_by_replace_offer_6",[]],
  [anyone|plyr,"lord_rescue_by_replace_offer_6",[],
   "Quickly, {s65}, let us change garments. It is past time you were away from here.", "close_window",
   [(call_script, "script_succeed_quest", "qst_rescue_lord_by_replace"),
    (quest_get_slot, ":quest_target_troop", "qst_rescue_lord_by_replace", slot_quest_target_troop),
    (quest_get_slot, ":quest_target_center", "qst_rescue_lord_by_replace", slot_quest_target_center),
    (party_remove_prisoners, ":quest_target_center", ":quest_target_troop", 1),
    #(troop_set_slot, ":quest_target_troop", slot_troop_is_prisoner, 0),
    (troop_set_slot, ":quest_target_troop", slot_troop_prisoner_of_party, -1),
    (assign, "$auto_menu", -1),
    (assign, "$capturer_party", "$g_encountered_party"),
    (jump_to_menu, "mnu_captivity_rescue_lord_taken_prisoner"),
    (finish_mission),
    ]],

##  
##  [anyone|plyr,"lord_talk", [(check_quest_active, "qst_deliver_message_to_lover"),
##                             (troop_get_slot, ":cur_daughter", "$g_talk_troop", slot_troop_daughter),
##                             (quest_slot_eq, "qst_deliver_message_to_lover", slot_quest_target_troop, ":cur_daughter"),
##                             (quest_get_slot, ":troop_no", "qst_deliver_message_to_lover", slot_quest_giver_troop),
##                             (str_store_troop_name, 3, ":troop_no"),
##                             (str_store_troop_name, 4, ":cur_daughter")],
##   "My lord, {s3} asked me to give this letter to your daughter, but I think you should read it first.", "lord_deliver_message_to_lover_tell_father",[]],
##
##  [anyone,"lord_deliver_message_to_lover_tell_father", [],
##   "That swine called {s3} is trying to approach my daughter eh? You have made the right decision by bringing this letter to me. I'll have a long talk with {s4} about it.", "lord_pretalk",
##   [(add_xp_as_reward, 200),
##    (call_script, "script_troop_add_gold", "trp_player", 1000),
##    (quest_get_slot, ":quest_giver", "qst_deliver_message_to_lover", slot_quest_giver_troop),
##    (quest_get_slot, ":target_troop", "qst_deliver_message_to_lover", slot_quest_target_troop),
##    (call_script, "script_change_player_relation_with_troop", ":quest_giver", -20),
##    (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 10),
##    (call_script, "script_change_player_relation_with_troop", ":target_troop", -10),
##    (call_script, "script_end_quest", "qst_deliver_message_to_lover"),
##    #Adding betrayal to the quest giver
##    (troop_set_slot, ":quest_giver", slot_troop_last_quest, "qst_deliver_message_to_lover"),
##    (troop_set_slot, ":quest_giver", slot_troop_last_quest_betrayed, 1)]],
##
##
##### TODO: QUESTS COMMENT OUT END



##  [anyone|plyr,"lord_talk", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                             (ge,"$g_talk_troop_faction_relation",0),
##                             (party_slot_eq, "$g_encountered_party", slot_party_type, spt_castle),
##                             (party_slot_eq, "$g_encountered_party", slot_town_lord, "$g_talk_troop"),
##                             (eq, "$g_permitted_to_center",0),
##                             (party_get_num_companions, reg7, "p_main_party"),
##                             (val_sub, reg7, 1),
##                             ],
##   "{reg7?Me and my men:I} need shelter for the night my lord. Can we rest in your castle for a while?", "lord_castle_let_in",[]],
##
##  [anyone, "lord_castle_let_in", [(lt,"$g_talk_troop_relation",-10)],
##   "What? Do I look like I am running an inn here? I have no place here for {reg7?you and your lot:you}. Now get off my lands...", "close_window",[(assign, "$g_permitted_to_center",1)]],
##  [anyone, "lord_castle_let_in", [(lt,"$g_talk_troop_relation",2), (lt, "$g_talk_troop_faction_relation", 10),(assign, reg6, 100)],
##   "I'll give you shelter if you pay a toll of {reg6} denars.", "lord_castle_let_in_toll",[]],
##  [anyone|plyr,"lord_castle_let_in_toll", [(store_troop_gold, ":gold", "trp_player"),(gt,":gold",reg6)], "Of course sir. I'll pay the toll.", "lord_castle_let_in_toll_pay",
##   [(troop_remove_gold, "trp_player",reg6)]],
##  [anyone, "lord_castle_let_in_toll_pay", [(str_store_party_name, s1, "$g_encountered_party")],
##   "Then you are welcome to {s1}.", "close_window",[(assign, "$g_permitted_to_center",1),(jump_to_menu, "mnu_town")]],
##  [anyone|plyr,"lord_castle_let_in_toll", [], "I can't pay that sum sir.", "lord_castle_let_in_toll_nopay",[]],
##  [anyone,"lord_castle_let_in_toll_nopay", [], "Then you are out of luck, I guess.", "lord_pretalk",[]],
##  
##  [anyone, "lord_castle_let_in", [(str_store_party_name, s1, "$g_encountered_party")],
##   "Of course {playername}. You are welcome here. You may rest at {s1} as long as you wish.", "close_window",[(assign, "$g_permitted_to_center",1)]],

  [anyone|plyr,"lord_talk", [#(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
							 (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
                             (eq, "$players_oath_renounced_against_kingdom", "$g_talk_troop_faction"),
                             (str_store_faction_name, s4, "$g_talk_troop_faction"),],
   "{s66}, I wish to restore my old oath to {s4}.", "lord_ask_pardon_after_oath_renounced",[]],

  [anyone,"lord_ask_pardon_after_oath_renounced",
   [
     (faction_get_slot, ":faction_leader", "$g_talk_troop_faction", slot_faction_leader),
     (neq, ":faction_leader", "$g_talk_troop"),
     (str_store_troop_name, s4, ":faction_leader"),
     ], "That is too great a matter for me to decide, {playername}. You should seek out {s4}. Such clemency is his alone to grant or deny.", "lord_pretalk",[]],

  [anyone,"lord_ask_pardon_after_oath_renounced",
   [
     (assign, ":num_centers_captured_by_player"),
     (try_for_range, ":cur_center", walled_centers_begin, walled_centers_end),
       (store_faction_of_party, ":cur_center_faction", ":cur_center"),
       (eq, ":cur_center_faction", "fac_player_supporters_faction"),
       (party_slot_eq, ":cur_center", slot_center_faction_when_oath_renounced, "$g_talk_troop_faction"),
       (val_add, ":num_centers_captured_by_player", 1),
     (try_end),
     (store_mul, ":peace_score", ":num_centers_captured_by_player", 500),
     (store_current_hours, ":cur_hours"),
     (val_sub, ":cur_hours", "$players_oath_renounced_begin_time"),
     (val_add, ":peace_score", ":cur_hours"),
     (try_begin),
       (gt, ":peace_score", 800),
       #Do not agree to give any centers but agree to make peace
       (assign, ":given_center", -1),
       (try_begin),
         (gt, ":peace_score", 1500),
         (try_begin),
           #Agree to give one center
           (eq, "$players_oath_renounced_given_center", 0),
           (store_random_in_range, ":given_center", 0, ":num_centers_captured_by_player"),
         (try_end),
       (else_try),
         (assign, "$players_oath_renounced_given_center", 0),
       (try_end),
       (assign, ":num_centers_written", 0),
       (try_for_range, ":cur_center", walled_centers_begin, walled_centers_end),
         (store_faction_of_party, ":cur_center_faction", ":cur_center"),
         (eq, ":cur_center_faction", "fac_player_supporters_faction"),
         (party_slot_eq, ":cur_center", slot_center_faction_when_oath_renounced, "$g_talk_troop_faction"),
         (try_begin),
           (eq, ":given_center", 0),
           (assign, "$players_oath_renounced_given_center", ":cur_center"),
         (else_try),
           (neq, "$players_oath_renounced_given_center", ":cur_center"),
           (try_begin),
             (eq, ":num_centers_written", 0),
             (str_store_party_name, s17, ":cur_center"),
           (else_try),
             (eq, ":num_centers_written", 1),
             (str_store_party_name, s16, ":cur_center"),
             (str_store_string, s17, "@{s16} and {s17}"),
           (else_try),
             (str_store_party_name, s16, ":cur_center"),
             (str_store_string, s17, "@{!}{s16}, {s17}"),
           (try_end),
           (val_add, ":num_centers_written", 1),
         (try_end),
         (val_sub, ":given_center", 1),
       (try_end),
       (try_begin),
         (eq, ":num_centers_written", 0),#white peace
         (str_store_string, s11, "@Very well, I will accept you back into my ranks, if you're ready to swear your solemn oath once more."),
         (assign, "$players_oath_renounced_terms_state", 1),
       (else_try),
         (str_store_string, s11, "@A pardon will only be possible if you are willing to cede {s17} to me. Do you agree my terms?"),
         (assign, "$players_oath_renounced_terms_state", 2),
       (try_end),
     (else_try),
       #Do not agree to make peace
       (str_store_string, s11, "@No. There is no chance of peace between us, I am not interested."),
       (assign, "$players_oath_renounced_terms_state", 0),
     (try_end),
     ], "{s11}.", "lord_ask_pardon_terms",[]],


  [anyone|plyr,"lord_ask_pardon_terms",
   [(eq, "$players_oath_renounced_terms_state", 0),
    ],
   "As you like, {s65}. I will accept your judgment.", "lord_pretalk",[]],
  [anyone|plyr,"lord_ask_pardon_terms",
   [(eq, "$players_oath_renounced_terms_state", 0),
    ],
   "A shame, {s65}. A shame.", "lord_pretalk",[]],
  [anyone|plyr,"lord_ask_pardon_terms",
   [(eq, "$players_oath_renounced_terms_state", 0),
    ],
   "Very well, go and die without me.", "lord_pretalk",[]],

  [anyone|plyr,"lord_ask_pardon_terms",
   [(eq, "$players_oath_renounced_terms_state", 1),
    ],
   "Aye, I am ready.", "lord_ask_pardon_after_renounce_peace",[]],

  [anyone|plyr,"lord_ask_pardon_terms",
   [(eq, "$players_oath_renounced_terms_state", 1),
    ],
   "On second thought, no. I don't wish to be in your service again.", "lord_ask_pardon_terms_rejected",[]],

  [anyone|plyr,"lord_ask_pardon_terms",
   [(eq, "$players_oath_renounced_terms_state", 2),
    ],
   "Aye, I agree to those terms.", "lord_ask_pardon_after_renounce_peace",[]],

  [anyone|plyr,"lord_ask_pardon_terms",
   [(eq, "$players_oath_renounced_terms_state", 2),
    ],
   "That is too high a price, {s65}. I must decline.", "lord_ask_pardon_terms_rejected",[]],


  [anyone,"lord_ask_pardon_after_renounce_peace",
   [], "Excellent. Though you strayed from us, {playername}, it gladdens all our hearts that you have found your way back to the right path. I hereby restore your homage to me. Rise once more as an honoured {man/warrior} in my service.", "lord_pretalk",
   [
     (try_for_range, ":cur_center", walled_centers_begin, walled_centers_end),
       (store_faction_of_party, ":cur_center_faction", ":cur_center"),
       (eq, ":cur_center_faction", "fac_player_supporters_faction"),
       (party_slot_eq, ":cur_center", slot_center_faction_when_oath_renounced, "$g_talk_troop_faction"),
       (neq, ":cur_center", "$players_oath_renounced_given_center"),
       (call_script, "script_give_center_to_faction", ":cur_center", "$g_talk_troop_faction"),
     (try_end),

     (call_script, "script_player_join_faction", "$g_talk_troop_faction"),
     (assign, "$player_has_homage", 1),
     (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 3),
     ]],


  [anyone,"lord_ask_pardon_terms_rejected",
   [], "Then get out of my sight, traitor! Begone with you, and do not come back!", "close_window",
   [
     (assign, "$g_leave_encounter", 1),
     #TODO: Add relation drop. $players_oath_renounced_begin_time can also be reset to current time for worse conditions in the next conversation.
     (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", -5),
     ]],


  [anyone|plyr,"lord_talk", [#(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
                             (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
                             (lt, "$g_talk_troop_faction_relation", 0),
							 
							 (store_relation, ":players_kingdom_relation", "$g_talk_troop_faction", "$players_kingdom"),
							 
							 (this_or_next|ge, ":players_kingdom_relation", 0),
                             (this_or_next|eq, "$players_kingdom", 0),
								(eq, "$players_kingdom", "fac_player_supporters_faction"),
								
								
                             (neq, "$players_oath_renounced_against_kingdom", "$g_talk_troop_faction"),
                             (assign, ":continue", 1),
                             (try_begin),
                               (gt, "$supported_pretender", 0),
                               (eq, "$supported_pretender_old_faction", "$g_talk_troop_faction"),
                               (assign, ":continue", 0),
                             (try_end),
                             (eq, ":continue", 1),
							 (is_between, "$g_talk_troop_faction", kingdoms_begin, kingdoms_end),
                             (str_store_faction_name, s4, "$g_talk_troop_faction"),],
   "I wish to make peace with the {s4}.", "lord_ask_pardon",[]],
   
  [anyone,"lord_ask_pardon", [(lt, "$g_talk_troop_relation", -10)], "Do you indeed, {playername}? Then go and trip on your sword. Give us all peace.", "lord_pretalk",[]],

  [anyone,"lord_ask_pardon",
   [
     (faction_slot_eq, "fac_player_supporters_faction", slot_faction_leader, "trp_player"),
     (assign, ":has_center", 0),
     (try_for_range, ":cur_center", centers_begin, centers_end),
       (store_faction_of_party, ":cur_center_faction", ":cur_center"),
       (eq, ":cur_center_faction", "fac_player_supporters_faction"),
       (assign, ":has_center", 1),
     (try_end),
     (eq, ":has_center", 1),
	 (lt, "$player_right_to_rule", 10),
	 
    ], "{playername}, you are a {lord/lady} without a master, holding lands in your name, with only the barest scrap of a claim to legitimacy.\
 No king in Calradia would accept a lasting peace with you.", "lord_pretalk",[]],
 
  [anyone,"lord_ask_pardon",
   [
     (assign, ":has_center", 0),
     (try_for_range, ":cur_center", centers_begin, centers_end),
       (store_faction_of_party, ":cur_center_faction", ":cur_center"),
       (eq, ":cur_center_faction", "fac_player_supporters_faction"),
       (assign, ":has_center", 1),
     (try_end),
     (eq, ":has_center", 1),
	 (encountered_party_is_attacker),
	 
    ], "Make peace when I have you at an advantage? I think not.", "lord_pretalk",[]], 
 
    #If the player faction is active
  [anyone,"lord_ask_pardon",
   [
	(faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
   
    (assign, ":has_center", 0),
    (try_for_range, ":cur_center", centers_begin, centers_end),
       (store_faction_of_party, ":cur_center_faction", ":cur_center"),
       (eq, ":cur_center_faction", "fac_player_supporters_faction"),
       (assign, ":has_center", 1),
    (try_end),
    (eq, ":has_center", 1),
	 
        (call_script, "script_npc_decision_checklist_peace_or_war", "$g_talk_troop_faction", "fac_player_supporters_faction", "trp_player"), #moto fix here 
	(lt, reg0, 0),
    ], "I do not see it as being in my current interest to make peace.", "lord_pretalk",[]], 

  [anyone,"lord_ask_pardon",
   [
	(faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
    (assign, ":has_center", 0),
    (try_for_range, ":cur_center", centers_begin, centers_end),
       (store_faction_of_party, ":cur_center_faction", ":cur_center"),
       (eq, ":cur_center_faction", "fac_player_supporters_faction"),
       (assign, ":has_center", 1),
    (try_end),
    (eq, ":has_center", 1),
    ], "Yes... I am weary of fighting you. I could offer you a truce of forty days. If you keep your word and do not molest my lands and subjects, we may talk again...", "lord_truce_offer",[]], 

  [anyone|plyr,"lord_truce_offer",
   [
   (call_script, "script_diplomacy_start_peace_between_kingdoms", "$g_talk_troop_faction", "$players_kingdom", 1), #moto fix here 
    ], "I accept. Let us stop making war upon each other, for the time being anyway", "close_window",[]], 
 
   [anyone|plyr,"lord_truce_offer",
   [], "On second thought, such an accord would not be in my interests.", "lord_pretalk",[]], 
 
  [anyone,"lord_ask_pardon", [	
	(neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
	(faction_slot_eq, "fac_player_supporters_faction", slot_faction_leader, "trp_player"),
	(assign, ":has_center", 0),
	(try_for_range, ":cur_center", centers_begin, centers_end),
		(store_faction_of_party, ":cur_center_faction", ":cur_center"),
		(eq, ":cur_center_faction", "fac_player_supporters_faction"),
		(assign, ":has_center", 1),
	(try_end),
	(eq, ":has_center", 0),
  
	(store_sub, ":hostility", 4, "$g_talk_troop_faction_relation"),
    (val_mul, ":hostility", ":hostility"), #square it
    (store_mul, reg16, ":hostility", 10),
    (str_store_faction_name, s4, "$g_talk_troop_faction"),
      ], "Hmm. I could use my considerable influence to arrange a pardon for you, {playername},\
 but there are some who see you as an enemy and will not be satisfied unless you pay tribute.\
 All in all, you'd need to bring no less than {reg16} denars to make any friends in {s4}.", "lord_ask_pardon_2",[]],

  [anyone,"lord_ask_pardon",
   [
	(faction_get_slot, ":faction_leader", "$g_talk_troop_faction", slot_faction_leader),
	(neq, "$g_talk_troop", ":faction_leader"),
	(str_store_troop_name, s7, ":faction_leader"),
    ], "I am in no position to offer you anything. You must speak to {s7}.", "lord_pretalk",[]],  
 
  [anyone,"lord_ask_pardon",
   [
	(faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
	(neg|faction_slot_ge, "fac_player_supporters_faction", slot_faction_leader, 1),
	
	(store_sub, ":hostility", 4, "$g_talk_troop_faction_relation"),
    (val_mul, ":hostility", ":hostility"), #square it
    (store_mul, reg16, ":hostility", 10),
	
    (str_store_faction_name, s4, "$g_talk_troop_faction"),
    ], "Yes... I have bigger worries than you or your followers. However, you have wronged my subjects, and wrongs demand compensation. For the sume of {reg16} denars, I suppose that I could agree to grant you a pardon. What do you say?", "lord_ask_pardon_2",[
	]], 

  [anyone,"lord_ask_pardon",
   [
    ], "I am sorry. I am in no position to offer you a pardon", "lord_pretalk",[
	]], 



	
 
  [anyone|plyr,"lord_ask_pardon_2", [(store_troop_gold, ":gold","trp_player"),(ge, ":gold", reg16)], "I have the money here. {reg16} denars.", "lord_ask_pardon_tribue_accept",[]],
  [anyone|plyr,"lord_ask_pardon_2", [], "I fear I cannot pay that much.", "lord_ask_pardon_tribue_deny",[]],

  [anyone,"lord_ask_pardon_tribue_accept", [
  (faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
  ], "Excellent, {playername}.\
 I will use this to make amends to those you have wronged, and I will let it be known that you are no longer an enemy of the {s4}.", "close_window",
   [
     (troop_remove_gold, "trp_player", reg16),
	 (store_relation, ":players_kingdom_relation", "$g_talk_troop_faction", "$players_kingdom"),
	 
     (try_begin),
       (this_or_next|eq, "$players_kingdom", 0),
		(ge, ":players_kingdom_relation", 0),
       (call_script, "script_set_player_relation_with_faction", "$g_talk_troop_faction", 0),
     (try_end),
     (assign,"$g_leave_town_outside",1),
     (assign, "$g_leave_encounter", 1),
     ]],
  
  [anyone,"lord_ask_pardon_tribue_accept", [], "Excellent, {playername}.\
 I'll use the coin to smooth the feathers of those that can oppose your pardon, and I'm sure that word will soon spread that you are no longer an enemy of {s4}.", "close_window",
   [
     (troop_remove_gold, "trp_player", reg16),
	 (store_relation, ":players_kingdom_relation", "$g_talk_troop_faction", "$players_kingdom"),
	 
     (try_begin),
       (this_or_next|eq, "$players_kingdom", 0),
		(ge, ":players_kingdom_relation", 0),
       (call_script, "script_set_player_relation_with_faction", "$g_talk_troop_faction", 0),
     (else_try),
       (call_script, "script_diplomacy_start_peace_between_kingdoms", "$g_talk_troop_faction", "$players_kingdom", 1),
     (try_end),
     (assign,"$g_leave_town_outside",1),
     (assign, "$g_leave_encounter", 1),
     ]],

  [anyone,"lord_ask_pardon_tribue_deny", [], "Then there's nothing I can do for you, {playername}. No silver, no pardon.", "lord_pretalk",[]],


  [anyone|plyr,"lord_talk", [(store_partner_quest,":lords_quest"),
                             (ge,":lords_quest",0),
                             ],
   "About the task you gave me...", "lord_active_mission_1",[]],

# This is done automatically now.
##  [anyone|plyr,"lord_talk", [(faction_slot_eq,"$g_talk_troop_faction",slot_faction_leader, "$g_talk_troop"),
##                             (eq, "$players_kingdom", "$g_talk_troop_faction"),
##                             (eq, "$player_has_homage", 0),
##                             (gt, "$mercenary_service_accumulated_pay", 0),
##                             ],
##   "{s67}, I humbly request the weekly payment for my service.", "lord_pay_mercenary",[]],
##
##  [anyone,"lord_pay_mercenary", [(assign, reg8, "$mercenary_service_accumulated_pay")],
##   "Hmm, let me see... According to my ledgers, we owe you {reg8} denars for your work. Here you are.", "lord_pay_mercenary_2",
##   [(troop_add_gold, "trp_player", "$mercenary_service_accumulated_pay"),
##    (assign, "$mercenary_service_accumulated_pay", 0)]],
##
##  [anyone|plyr,"lord_pay_mercenary_2", [], "Thank you, sir.", "lord_pretalk", []],

  [anyone|plyr,"lord_talk", [#(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
                             (troop_slot_eq, "trp_player", slot_troop_spouse, "$g_talk_troop"),
                             ],
   "Let us discuss matters related to our household.", "lord_switch_to_spouse",[]],

  [anyone,"lord_switch_to_spouse", [
    (assign, ":feast_venue", -1),
	
    (try_begin),
		(is_between, "$current_town", walled_centers_begin, walled_centers_end),
		(this_or_next|party_slot_eq, "$current_town", slot_town_lord, "trp_player"),
			(party_slot_eq, "$current_town", slot_town_lord, "$g_talk_troop"),
		(assign, ":feast_venue", "$current_town"),	
	(else_try),
		(try_for_range, ":center", walled_centers_begin, walled_centers_end),
			(eq, ":feast_venue", -1),
			(this_or_next|party_slot_eq, ":center", slot_town_lord, "trp_player"),
				(party_slot_eq, ":center", slot_town_lord, "$g_talk_troop"),
			(assign, ":feast_venue", ":center"),	
		(try_end),
		(is_between, ":feast_venue", walled_centers_begin, walled_centers_end), #unless there's a try/fail, will not do last check
		
	(else_try),
		(is_between, "$current_town", walled_centers_begin, walled_centers_end),
		(assign, ":feast_venue", "$current_town"),
    (try_end),
	
	(neg|is_between, ":feast_venue", walled_centers_begin, walled_centers_end),
	],
   "Let us wait until we are in a hall, my wife, as it is difficult to deal with household inventories and such matters in the field.", "lord_pretalk",[]],
   
  [anyone,"lord_switch_to_spouse", [],
   "Certainly, my wife", "spouse_talk",[]],

   
   

  [anyone|plyr,"lord_talk", [#(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
                             (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
                             (ge, "$g_talk_troop_faction_relation", 0),
                             (store_partner_quest,":lords_quest"),
                             (lt,":lords_quest",0),
							 (neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "trp_player"),
							 (neg|troop_slot_eq, "trp_player", slot_troop_spouse, "$g_talk_troop"),
							 #                             (eq,"$g_talk_troop_faction","$players_kingdom")
                             ],
   "Do you have any tasks for me?", "lord_request_mission_ask",[]],

  [anyone|plyr,"lord_talk",
   [
   (eq, "$g_talk_troop_faction", "$players_kingdom"),
   (eq, "$player_has_homage", 1),
   (neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "trp_player"),
   (neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
     
   ],
   "Do you think we can work together to advance our standings in this realm?", "combined_political_quests",[
   (call_script, "script_get_political_quest", "$g_talk_troop"),
   (assign, "$political_quest_found", reg0),
   (assign, "$political_quest_target_troop", reg1),
   (assign, "$political_quest_object_troop", reg2),
   ]],

   [anyone,"combined_political_quests", [
    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_hero),
    (lt, "$g_talk_troop_effective_relation", -5),   
    ],
   "I do not imagine that you and I have many mutual interests.", "lord_pretalk",[
   ]],
   
   
   [anyone,"combined_political_quests", [
    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_hero),
	(gt, "$political_quest_found", 0),
	(assign, ":continue", 1),
	(try_begin),
		(call_script, "script_cf_troop_can_intrigue", "$g_talk_troop", 1),
		(assign, ":continue", 0),
	(try_end),
	(eq, ":continue", 1),   
    ],
   "Hmm.. Perhaps we can discuss this matter in a more private setting, at a later date.", "lord_pretalk",[
   ]],

   [anyone,"combined_political_quests", [
    (this_or_next|eq, "$political_quest_found", "qst_intrigue_against_lord"),
		(eq, "$political_quest_found", "qst_denounce_lord"),
	
	(troop_slot_ge, "trp_player", slot_troop_controversy, 30),

    ],
   "Hmm.. I do have an idea, but it would require you that you be free of controversy. If you were to wait some time without getting into any arguments with the other lords of our realm, perhaps we could proceed further.", "lord_pretalk",[
   ]],

   
  [anyone|plyr,"lord_talk", [(le,"$talk_context", tc_party_encounter),
                             (faction_slot_eq, "$players_kingdom", slot_faction_leader, "$g_talk_troop"),
                             (faction_slot_eq, "$players_kingdom", slot_faction_marshall, "trp_player"),
                            ],
   "I wish to resign the marshalship", "lord_ask_resign_marshalship",[]],   
   
  [anyone,"lord_ask_resign_marshalship", [],
   "So be it. I shall have to find someone else.", "lord_pretalk",[
		(assign, ":faction_no", "$players_kingdom"),
		(faction_set_slot, ":faction_no", slot_faction_political_issue, 1), #Appointment of marshal
		(store_current_hours, ":hours"),
		(val_max, ":hours", 0),
		(faction_set_slot, ":faction_no", slot_faction_political_issue_time, ":hours"), #Appointment of marshal
		
        (faction_get_slot, ":old_marshall", ":faction_no", slot_faction_marshall),
        (try_begin),
          (ge, ":old_marshall", 0),
		  (troop_get_slot, ":old_marshall_party", ":old_marshall", slot_troop_leaded_party),
          (party_is_active, ":old_marshall_party"),
          (party_set_marshall, ":old_marshall_party", 0),
        (try_end),  

		(faction_set_slot, ":faction_no", slot_faction_marshall, -1),
		
		(try_for_range, ":active_npc", active_npcs_begin, active_npcs_end),
			(store_faction_of_troop, ":active_npc_faction", ":active_npc"),
			(eq, ":active_npc_faction", ":faction_no"),
			(troop_set_slot, ":active_npc", slot_troop_stance_on_faction_issue, -1),
		(try_end),		
		(try_begin),
			(eq, "$players_kingdom", ":faction_no"),
			(troop_set_slot, "trp_player", slot_troop_stance_on_faction_issue, -1),
		(try_end),
		(call_script, "script_add_notification_menu", "mnu_notification_relieved_as_marshal", 0, 0),
   ]],   
   
   

  [anyone|plyr,"lord_talk", [(le,"$talk_context", tc_party_encounter),
                             (ge, "$g_talk_troop_faction_relation", 0),
                             #(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
                             (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
                             (faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
                             (neq, "$players_kingdom", "$g_talk_troop_faction"),
                             (store_partner_quest, ":lords_quest"),
                             (neq, ":lords_quest", "qst_join_faction"),
                            ],
   "{s66}, I have come to offer you my sword in vassalage!", "lord_ask_enter_service",[]],


  [anyone|plyr,"lord_talk", [(le,"$talk_context", tc_party_encounter),
                             (faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
                             (eq, "$players_kingdom", "$g_talk_troop_faction"),
                             (eq, "$player_has_homage", 0),
                             (store_partner_quest, ":lords_quest"),
                             (neq, ":lords_quest", "qst_join_faction"),
                            ],
   "{s66}, I wish to become your sworn {man/woman} and fight for your honour.", "lord_ask_enter_service",[]],

  [anyone|plyr,"lord_talk", [(le,"$talk_context", tc_party_encounter),
                             (ge, "$g_talk_troop_faction_relation", 0),
                             #(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
                             (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
                             (faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
                             (eq, "$players_kingdom", "$g_talk_troop_faction"),
                             (eq, "$player_has_homage", 1),
                            ],
   "{s66}, I wish to be released from my oath to you.", "lord_ask_leave_service",[]],

##  [anyone|plyr,"lord_talk", [(le,"$talk_context", tc_party_encounter),
##                             (ge, "$g_talk_troop_faction_relation", 0),
##                             (troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                             (neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
##                             (eq, "$players_kingdom", 0),
##                             (eq,1,0)],
##   "TODO2:I want to fight alongside you against your enemies.", "close_window",[]],

  [anyone|plyr,"lord_talk", [(eq, 1, 0),(le,"$talk_context", tc_party_encounter),(ge, "$g_talk_troop_faction_relation", 0)],
   "I have an offer for you.", "lord_talk_preoffer",[]],

  
  [anyone|plyr,"lord_talk", [(eq, "$g_talk_troop_faction", "fac_player_supporters_faction"),
                             #(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
                             (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
                             ],
   "I want to give some troops to you.", "lord_give_troops",[]],

  [anyone,"lord_give_troops", [],
   "Well, I could use some good soldiers. Thank you.", "lord_pretalk",
   [
     (change_screen_give_members, "$g_talk_troop_party"),
     ]],
  
  
  


  [anyone|plyr,"lord_talk",
   [
     (eq, "$g_talk_troop_faction", "$players_kingdom"),
     (faction_slot_eq, "$players_kingdom", slot_faction_marshall, "trp_player"),
     #(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
     (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
     ],
   "I have a new task for you.", "lord_give_order_ask",[]],

   
  [anyone|plyr,"lord_talk",
   [
     (eq, "$g_talk_troop_faction", "$players_kingdom"),
     (neg|faction_slot_eq, "$players_kingdom", slot_faction_marshall, "trp_player"),
     #(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
     (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
     ],
   "May I suggest a course of action?", "lord_give_suggestion_ask",[]],


  [anyone,"lord_give_order_ask", [],
   "Yes?", "lord_give_order",[]],

  [anyone,"lord_give_suggestion_ask", [
	 (faction_slot_eq, "$players_kingdom", slot_faction_leader, "trp_player"),
  ], 
   "I will gladly follow your direction, {sire/your Highness}. If you intend to direct an extensive campaign, however, you may also wish to declare yourself marshal, so there is no cause for confusion.", "lord_give_order",[]],

   
  [anyone,"lord_give_suggestion_ask", [
	 (lt, "$g_talk_troop_effective_relation", 5), #was five
  ], 
   "My apologies. I don't know you well enough to take your advice.", "lord_pretalk",[]],
   
  [anyone,"lord_give_suggestion_ask", [
  ],
   "What is it?", "lord_give_order",[
   ]],
   
  [anyone|plyr,"lord_give_order", [
    (faction_slot_eq, "$players_kingdom", slot_faction_marshall, "trp_player"),
  ],
   "Follow me.", "lord_give_order_answer",
   [
     (assign, "$temp", spai_accompanying_army),
     (assign, "$temp_2", "p_main_party"),
	 
	(store_current_hours, ":hours"),
	(party_set_slot, "$g_talk_troop_party", slot_party_following_orders_of_troop, "trp_kingdom_heroes_including_player_begin"),
	(party_set_slot, "$g_talk_troop_party", slot_party_orders_type, "$temp"),
	(party_set_slot, "$g_talk_troop_party", slot_party_orders_object, "$temp_2"),
	(party_set_slot, "$g_talk_troop_party", slot_party_orders_time, ":hours"),	 
     ]],

  [anyone|plyr,"lord_give_order", [
    (neg|faction_slot_eq, "$players_kingdom", slot_faction_marshall, "trp_player"),
  ],
   "Will you follow me? I have a plan...", "lord_give_order_answer",
   [
     (assign, "$temp", spai_accompanying_army),
     (assign, "$temp_2", "p_main_party"),
	 
	 (store_current_hours, ":hours"),
	 (party_set_slot, "$g_talk_troop_party", slot_party_following_orders_of_troop, "trp_kingdom_heroes_including_player_begin"),
	 (party_set_slot, "$g_talk_troop_party", slot_party_orders_type, "$temp"),
	 (party_set_slot, "$g_talk_troop_party", slot_party_orders_object, "$temp_2"),
	 (party_set_slot, "$g_talk_troop_party", slot_party_orders_time, ":hours"),	 	 
   ]],
	 	 
  [anyone|plyr,"lord_give_order", [
    (faction_slot_eq, "$players_kingdom", slot_faction_marshall, "trp_player"),

  ],
   "Go to...", "lord_give_order_details_ask",
   [
     (assign, "$temp", spai_holding_center),
     ]],
	 	 
	 
  [anyone|plyr,"lord_give_order", [
    (faction_slot_eq, "$players_kingdom", slot_faction_marshall, "trp_player"),

  ],
   "Raid around the village of...", "lord_give_order_details_ask",
   [
     (assign, "$temp", spai_raiding_around_center),
     ]],

  [anyone|plyr,"lord_give_order", [
    (faction_slot_eq, "$players_kingdom", slot_faction_marshall, "trp_player"),

  ],
   "Patrol around...", "lord_give_order_details_ask",
   [
     (assign, "$temp", spai_patrolling_around_center),
     ]],

#only as suggestion
  [anyone|plyr,"lord_give_order", [
	    (party_slot_eq, "$g_talk_troop_party", slot_party_ai_state, spai_besieging_center),
        (party_get_slot, ":ai_object", "$g_talk_troop_party", slot_party_ai_object),
		(party_slot_eq, ":ai_object", slot_center_is_besieged_by, "$g_talk_troop_party"),
		(party_slot_eq, ":ai_object", slot_village_state, svs_under_siege),
		(str_store_party_name, s11, ":ai_object"),
		],
   "Together, you and I can take {s11}. You should assault immediately...", "lord_give_order_assault",
   [
    #for this one and another one, if the $g_talk_troop is a _t
#     (assign, "$temp", spai_patrolling_around_center),
     ]],	 
	 
#only as suggestion
  [anyone|plyr,"lord_give_order", [
    (neg|faction_slot_eq, "$players_kingdom", slot_faction_marshall, "trp_player"), #not an order,  only a suggestion

  ],
   "We are under attack, but the enemy can be repulsed. You should ride towards...", "lord_give_order_details_ask",
   [
     (assign, "$temp", spai_patrolling_around_center),
     ]],

#only as suggestion
  [anyone|plyr,"lord_give_order", [
    (faction_slot_eq, "$g_talk_troop_faction", slot_faction_marshall, "$g_talk_troop"),

  ],
   "We are under attack, but the enemy can be repulsed. You should assemble the army and march to...", "lord_give_order_details_ask",
   [
     (assign, "$temp", spai_patrolling_around_center),
     ]],
	 

  [anyone,"lord_give_order_assault", [
		(party_get_slot, ":ai_object", "$g_talk_troop_party", slot_party_ai_object),
		(party_get_slot, ":besieging_party", ":ai_object", slot_center_is_besieged_by),
        (neq, ":besieging_party", "$g_talk_troop_party"),
		(party_stack_get_troop_id, ":siege_commander", ":besieging_party", 0),
		(str_store_troop_name, s4, ":siege_commander"),
		(troop_get_type, reg4, ":siege_commander"),
		],
   "{s4} is directing this siege. I suggest you speak to {reg4?her:him}", "lord_pretalk",
   []],
		
				
  [anyone,"lord_give_order_assault", [
    (party_get_slot, ":ai_object", "$g_talk_troop_party", slot_party_ai_object),
    (party_get_slot, ":siege_begun", ":ai_object", slot_center_siege_begin_hours),
	(store_current_hours, ":cur_hour"),
	(store_sub, ":hours_of_siege", ":cur_hour", ":siege_begun"),
	
	(try_begin),
		(assign, ":hours_required", 9),
	(try_end),
	(val_sub, ":hours_required", ":hours_of_siege"),
	(gt, ":hours_required", 0),
	(try_begin),
		(gt, ":hours_required", 1),
		(assign, reg3, ":hours_required"),
		(str_store_string, s11, "str_reg3_hours"),
	(else_try),
		(str_store_string, s11, "str_hour"),
	(try_end),
  ],
   "Our preparations are not yet ready. We need another {s11}", "lord_pretalk",
   [
     ]],


  [anyone,"lord_give_order_assault", [
  ],
   "Very well -- to the walls!", "close_window",
   [
    (party_get_slot, ":ai_object", "$g_talk_troop_party", slot_party_ai_object),
	(call_script, "script_begin_assault_on_center", ":ai_object"),

	(party_set_slot, "$g_talk_troop_party", slot_party_under_player_suggestion, spai_besieging_center),
    (assign, "$g_leave_encounter", 1),
		
     ]],
	 
	 
	 
	 
#only as suggestion
	   [anyone|plyr,"lord_give_order", [
    (neg|faction_slot_eq, "$players_kingdom", slot_faction_marshall, "trp_player"), #not an order,  only a suggestion
],
   "There is a fortress which can easily be taken. Go to..", "lord_give_order_details_ask",
   [
     (assign, "$temp", spai_besieging_center),
     ]],

  [anyone|plyr,"lord_give_order", [
#    (neg|faction_slot_eq, "$players_kingdom", slot_faction_marshall, "trp_player"),
  ],
   "The enemy is coming in force. Flee in the direction of...", "lord_give_order_details_ask",
   [
     (assign, "$temp", spai_retreating_to_center),
     ]],



	 

  [anyone|plyr,"lord_give_order",
   [
	(faction_slot_eq, "$players_kingdom", slot_faction_marshall, "trp_player"),
#    (neg|troop_slot_eq, "$g_talk_troop", slot_troop_player_order_state, spai_undefined),
     ],
   "I won't need you for some time. You are free to do as you like.", "lord_give_order_stop",
   []],

  [anyone|plyr,"lord_give_order",
   [
	(neg|faction_slot_eq, "$players_kingdom", slot_faction_marshall, "trp_player"),
	(party_slot_eq, "$g_talk_troop_party", slot_party_ai_state, spai_accompanying_army),
	(party_slot_eq, "$g_talk_troop_party", slot_party_ai_object, "p_main_party"),
     ],
   "You no longer need to accompany me.", "lord_give_order_stop",
   []],
   
   
   
  [anyone|plyr,"lord_give_order", [],
   "Never mind.", "lord_pretalk",
   []],

   
  [anyone,"lord_give_order_details_ask", [
    (neg|faction_slot_eq, "$players_kingdom", slot_faction_marshall, "trp_player"),
	(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_martial),
	(eq, "$temp", spai_retreating_to_center),

  ],
   "It is not my way to turn tail and run, without even laying eyes on the enemy.", "lord_pretalk",[]],
   
  [anyone,"lord_give_order_details_ask", [
    (neg|faction_slot_eq, "$players_kingdom", slot_faction_marshall, "trp_player"),
	(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_debauched),
	(eq, "$temp", spai_besieging_center),

  ],
   "You want me to shed my blood outside a fortress while others stand by and watch? I think not.", "lord_pretalk",[]],
      
  [anyone,"lord_give_order_details_ask", [],
   "Where?", "lord_give_order_details",[]],

  [anyone|plyr|repeat_for_parties, "lord_give_order_details",
   [
     (store_repeat_object, ":party_no"),
     (store_faction_of_party, ":party_faction", ":party_no"),
     (store_relation, ":relation", ":party_faction", "$players_kingdom"),
     (assign, ":continue", 0),
     (try_begin),
       (this_or_next|eq, "$temp", spai_retreating_to_center),
         (eq, "$temp", spai_holding_center),
       (try_begin),
         (this_or_next|party_slot_eq, ":party_no", slot_party_type, spt_castle),
			(party_slot_eq, ":party_no", slot_party_type, spt_town),
         (eq, ":party_faction", "$players_kingdom"),
         (assign, ":continue", 1),
       (try_end),
     (else_try),
       (eq, "$temp", spai_raiding_around_center),
       (try_begin),
         (party_slot_eq, ":party_no", slot_party_type, spt_village),
         (lt, ":relation", 0),
         (assign, ":continue", 1),
       (try_end),
     (else_try),
       (eq, "$temp", spai_besieging_center),
       (try_begin),
         (this_or_next|party_slot_eq, ":party_no", slot_party_type, spt_castle),
			(party_slot_eq, ":party_no", slot_party_type, spt_town),
		 (party_slot_eq, ":party_no", slot_center_is_besieged_by, -1),
         (lt, ":relation", 0),
         (assign, ":continue", 1),
       (try_end),	   	   
     (else_try),
       (eq, "$temp", spai_patrolling_around_center),
       (try_begin),
         (eq, ":party_faction", "$players_kingdom"),
         (is_between, ":party_no", centers_begin, centers_end),
         (assign, ":continue", 1),
	   (else_try),	 
         (is_between, ":party_no", centers_begin, centers_end),	   
		 (store_distance_to_party_from_party, ":distance", ":party_no", "p_main_party"),
		 (le, ":distance", 25),
         (assign, ":continue", 1),		 
       (try_end),
     (try_end),
     (eq, ":continue", 1),
     (neq, ":party_no", "$g_encountered_party"),
     (str_store_party_name, s1, ":party_no")],
   "{s1}", "lord_give_order_answer",
   [
     (store_repeat_object, "$temp_2"),
     (store_current_hours, ":hours"),
     (party_set_slot, "$g_talk_troop_party", slot_party_following_orders_of_troop, "trp_kingdom_heroes_including_player_begin"),
     (party_set_slot, "$g_talk_troop_party", slot_party_orders_type, "$temp"),
     (party_set_slot, "$g_talk_troop_party", slot_party_orders_object, "$temp_2"),
     (party_set_slot, "$g_talk_troop_party", slot_party_orders_time, ":hours"),
	]],

  [anyone|plyr, "lord_give_order_details",
   [], "Never mind.", "lord_pretalk",[]],

   #Simple stop order
  [anyone,"lord_give_order_stop", [],
   "All right. I will stop here.", "lord_pretalk",
   [
     (party_set_slot, "$g_talk_troop_party", slot_party_orders_type, spai_undefined),
     (party_set_slot, "$g_talk_troop_party", slot_party_orders_object, -1),
     #this is not set above, so should be set here
     (store_current_hours, ":hours"),
     (val_sub, ":hours", 36),
     (val_max, ":hours", 0),
     
     (party_set_slot, "$g_talk_troop_party", slot_party_following_orders_of_troop, "trp_kingdom_heroes_including_player_begin"),
     (party_set_slot, "$g_talk_troop_party", slot_party_orders_type, spai_undefined),
     (party_set_slot, "$g_talk_troop_party", slot_party_orders_object, -1),
     (party_set_slot, "$g_talk_troop_party", slot_party_orders_time, ":hours"),
     
     #same variable as above
     (troop_get_slot, ":party_no", "$g_talk_troop", slot_troop_leaded_party),
     (try_begin),
       (gt, ":party_no", 0),
       (call_script, "script_party_set_ai_state", ":party_no", spai_undefined, -1),
       (party_set_slot, ":party_no", slot_party_commander_party, -1),
     (try_end),	 
   ]],

  [anyone,"lord_give_order_answer",
   [
     (eq, "$temp", spai_accompanying_army),
     
     (neg|faction_slot_eq, "$players_kingdom", slot_faction_marshall, "trp_player"),
     (neg|faction_slot_eq, "$players_kingdom", slot_faction_leader, "trp_player"),
     
     (call_script, "script_troop_get_player_relation", "$g_talk_troop"),
     (assign, ":player_relation", reg0),    
     
     (troop_get_slot, ":troop_renown", "$g_talk_troop", slot_troop_renown),
     (troop_get_slot, ":player_renown", "trp_player", slot_troop_renown),
     #(val_mul, ":troop_renown", 3),
     #(val_div, ":troop_renown", 4),
     #(this_or_next|lt, ":player_renown", ":troop_renown"),
     #(lt, ":player_relation", 0),
     
     (store_skill_level, ":player_persuasion_level", "skl_persuasion", "trp_player"),
     (store_div, ":player_relation_div_5", ":player_relation", 5),
     (val_min, ":player_relation_div_5", 10),
     (store_add, ":player_persuasion_power", ":player_relation_div_5", ":player_persuasion_level"),	   	 
     
     (store_sub, ":needed_lowest_renown", 20, ":player_persuasion_power"),
     (val_mul, ":needed_lowest_renown", ":troop_renown"),
     (val_div, ":needed_lowest_renown", 10),
          
     (this_or_next|lt, ":player_renown", ":needed_lowest_renown"),
     (lt, ":player_relation", 0),
   ],
   "That would hardly be proper. It would be more appropriate for you to follow me instead. Did you have any other ideas?", "lord_give_order",
   [
     (party_set_slot, "$g_talk_troop_party", slot_party_following_orders_of_troop, 0),
     (party_set_slot, "$g_talk_troop_party", slot_party_orders_type, 0),
     (party_set_slot, "$g_talk_troop_party", slot_party_orders_object, 0),
     (party_set_slot, "$g_talk_troop_party", slot_party_orders_time, 0),
   ]],
	
   #More complicated order
  [anyone,"lord_give_order_answer",
   [
    (call_script, "script_npc_decision_checklist_party_ai", "$g_talk_troop"),
	
	(eq, reg0, "$temp"),
	(eq, reg1, "$temp_2"),

    (str_clear, s12),	
	(try_begin),
		(neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_marshall, "trp_player"), 
		(neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "trp_player"), 
		(str_store_string, s12, "str_but_if_this_goes_badly"),
	(try_end),   	
	],
   "All right. I will do that.{s12}", "lord_pretalk",
   [
     (call_script, "script_party_set_ai_state", "$g_talk_troop_party", "$temp", "$temp_2"),
     (str_clear, s12),
     (try_begin),
       (neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_marshall, "trp_player"), 
       (neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "trp_player"), 
       (str_store_string, s12, "str_but_if_this_goes_badly"),
     (try_end),
     #Set courage and aggressiveness in party_set_ai_astate
     (assign, "$g_leave_encounter", 1),
   ]],

  #Recalculated orders do not match 
  [anyone,"lord_give_order_answer", [],
   "I am sorry. I need to attend my own business at the moment.", "lord_pretalk",
   [
     (call_script, "script_npc_decision_checklist_party_ai", "$g_talk_troop"),
     (call_script, "script_party_set_ai_state", "$g_talk_troop_party", reg0, reg1),
   ]],
   
#generic lord comments - must be far down
   [anyone,"lord_start", [],
   "What is it?", "lord_talk",[]],   

                     
  [anyone|plyr,"lord_talk",
   [
     (eq, "$g_talk_troop_faction", "$players_kingdom"),
     (faction_slot_eq, "$players_kingdom", slot_faction_marshall, "trp_player"),
     #(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
     (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
     (this_or_next|faction_slot_eq, "$players_kingdom", slot_faction_ai_state, sfai_default),
     (faction_slot_eq, "$players_kingdom", slot_faction_ai_state, sfai_feast),
   ],
   "I want to start a new campaign. Let us assemble the army here.", "lord_give_order_call_to_arms_verify",
   []],

  [anyone,"lord_give_order_call_to_arms_verify", [],
   "You wish to summon all lords for a new campaign?", "lord_give_order_call_to_arms_verify_2",[]],

  [anyone|plyr,"lord_give_order_call_to_arms_verify_2", [], "Yes. We must gather all our forces before we march on the enemy.", "lord_give_order_call_to_arms",[]],
  [anyone|plyr,"lord_give_order_call_to_arms_verify_2", [], "On second thought, it won't be necessary to summon everyone.", "lord_pretalk",[]],

  [anyone,"lord_give_order_call_to_arms",
   [],
   "All right then. I will send messengers and tell everyone to come here.", "lord_pretalk",
   [
	 (assign, "$player_marshal_ai_state", sfai_gathering_army),
	 (assign, "$player_marshal_ai_object", "p_main_party"),
     (call_script, "script_decide_faction_ai", "$players_kingdom"),
	 (assign, "$g_recalculate_ais", 1),
     ]],

  [anyone|plyr,"lord_talk",
   [
     (eq, "$g_talk_troop_faction", "$players_kingdom"),
     (faction_slot_eq, "$players_kingdom", slot_faction_marshall, "trp_player"),
     #(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
     (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
     (neg|faction_slot_eq, "$players_kingdom", slot_faction_ai_state, sfai_default),
     (neg|faction_slot_eq, "$players_kingdom", slot_faction_ai_state, sfai_feast),
     ],
   "I want to end the campaign and let everyone return home.", "lord_give_order_disband_army_verify", []],

  [anyone,"lord_give_order_disband_army_verify", [],
   "You want to end the current campaign and release all lords from duty?", "lord_give_order_disband_army_2",[]],

  [anyone|plyr,"lord_give_order_disband_army_2", [], "Yes. We no longer need all our forces here.", "lord_give_order_disband_army",[]],
  [anyone|plyr,"lord_give_order_disband_army_2", [], "On second thought, it will be better to stay together for now.", "lord_pretalk",[]],

  [anyone,"lord_give_order_disband_army",
   [],
   "All right. I will let everyone know that they are released from duty.", "lord_pretalk",
   [
     (assign, "$player_marshal_ai_state", sfai_default),
	 (assign, "$player_marshal_ai_object", -1),
     (call_script, "script_decide_faction_ai", "$players_kingdom"),
     (assign, "$g_recalculate_ais", 1),
     ]],

  [anyone|plyr,"lord_talk", [
    (ge,"$g_encountered_party_relation",0),
    (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
  ],
   "I wish to ask you something.", "lord_talk_ask_something",[]],

  [anyone,"lord_talk_ask_something", [],
   "Aye? What is it?", "lord_talk_ask_something_2",[]],

  [anyone,"lord_talk_ask_something_again", [],
   "Is there anything else?", "lord_talk_ask_something_2",[]],   
   
   
  [anyone|plyr,"lord_talk_ask_something_2", [#(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
			                                             (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
  ],
   "I want to know the location of someone.", "lord_talk_ask_location",[]],

  [anyone|plyr,"lord_talk_ask_something_2", [
    (neg|troop_slot_eq, "$g_talk_troop", slot_troop_leaded_party, -1)
  ],
   "What are you and your men doing?", "lord_tell_objective",[
	(party_get_slot, ":ai_behavior", "$g_talk_troop_party", slot_party_ai_state),
	(party_get_slot, ":ai_object", "$g_talk_troop_party", slot_party_ai_object),

	(try_begin),
		(eq, "$cheat_mode", 1),
		(party_get_ai_initiative, reg4, "$g_talk_troop_party"),
		(party_get_helpfulness, reg5, "$g_talk_troop_party"),
		(display_message, "@{!}DEBUG : Initiative {reg4}, helpfulness {reg5}"),
	(try_end),	
		
    (str_clear, s14),
    (str_clear, s15),
    (str_clear, s16),
	
    (try_begin),
	  (call_script, "script_npc_decision_checklist_party_ai", "$g_talk_troop"),
	  (eq, reg0, ":ai_behavior"),
	  (eq, reg1, ":ai_object"),	  
	(else_try),
	  (call_script, "script_party_set_ai_state", "$g_talk_troop_party", reg0, reg1),
      (str_store_string, s14, "str_however_circumstances_have_changed_since_we_made_that_decision_and_i_may_reconsider_shortly_s16"),
	  (try_begin),
		(ge, "$cheat_mode", 1),
		(display_message, "@{!}DEBUG -- ai behavior: {reg0}, ai object: {reg1}"),
	  (try_end),
	(try_end),
   ]],

  [anyone|plyr,"lord_talk_ask_something_2", [
  #(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
	(neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
	
  ],
   "What is the realm doing?", "lord_talk_ask_about_strategy",[]],

  [anyone,"lord_talk_ask_about_strategy", [
    (eq, "$players_kingdom", "$g_talk_troop_faction"),
	(faction_slot_eq, "$g_talk_troop_faction", slot_faction_marshall, "trp_player"),
	(neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_feast),
  ],
   "You should decide that, as you are the marshal.", "lord_pretalk",[]],
   
   
   
  [anyone|plyr,"lord_talk_ask_something_2", [#(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
											 (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
  ],
   "How goes the war?", "lord_talk_ask_about_war",[]],

  #Marriage proposal 
  [anyone|plyr,"lord_talk_ask_something_2",[
	(check_quest_active, "qst_formal_marriage_proposal"),
	(neg|check_quest_failed, "qst_formal_marriage_proposal"),
	(neg|check_quest_succeeded, "qst_formal_marriage_proposal"),

    (neg|troop_slot_ge, "trp_player", slot_troop_spouse, active_npcs_begin),
	
	(quest_slot_eq, "qst_formal_marriage_proposal", slot_quest_target_troop, "$g_talk_troop"),
	(quest_get_slot, ":bride", "qst_formal_marriage_proposal", slot_quest_giver_troop),
	
	(str_store_troop_name, s10, ":bride"),
	(call_script, "script_troop_get_family_relation_to_troop", ":bride", "$g_talk_troop"),
	
	(call_script, "script_troop_get_relation_with_troop", "trp_player", ":bride"),
	
	(try_begin),
		(gt, reg0, 20),
		(str_store_string, s19, "str_i_wish_to_marry_your_s11_s10_i_ask_for_your_blessing"),
	(else_try),
		(str_store_string, s19, "str_i_wish_to_marry_your_s11_s10_i_ask_for_your_help"),
	(try_end),
	
	],
    "{s19}", "lord_marriage_permission",
[

]],   
   
   #no permission
  [anyone,"lord_marriage_permission", [
	(neg|troop_slot_eq, "$g_talk_troop", slot_lord_granted_courtship_permission, 1),
  ],
   "Great heaven, man -- if I haven't given you permission to see her, do you think I'm going to give you permission to marry her?", "lord_pretalk",[
   (call_script, "script_fail_quest", "qst_formal_marriage_proposal"),
   (call_script, "script_end_quest", "qst_formal_marriage_proposal"),
   ]],

  #unwilling bride -- failed due to lord personality
  [anyone,"lord_marriage_permission", [
	(troop_slot_eq, "$g_talk_troop", slot_lord_granted_courtship_permission, 1),
	(quest_get_slot, ":bride", "qst_formal_marriage_proposal", slot_quest_giver_troop),
	(call_script, "script_troop_get_relation_with_troop", "trp_player", ":bride"),
	(lt, reg0, 20),
	(neg|troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_debauched),
	(neg|troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_selfrighteous),
	(neg|troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_quarrelsome),
		
	(call_script, "script_troop_get_family_relation_to_troop", ":bride", "$g_talk_troop"),
  ],
   "It is not my way to push my {s11} to marry against her will or her better judgment", "lord_pretalk",[
   (call_script, "script_fail_quest", "qst_formal_marriage_proposal"),
   (call_script, "script_end_quest", "qst_formal_marriage_proposal"),
   
   ]],

   
  #unwilling bride -- failed due to competitor
  [anyone,"lord_marriage_permission", [
	(troop_slot_eq, "$g_talk_troop", slot_lord_granted_courtship_permission, 1),
	(quest_get_slot, ":bride", "qst_formal_marriage_proposal", slot_quest_giver_troop),
	(call_script, "script_troop_get_relation_with_troop", "trp_player", ":bride"),
	(lt, reg0, 20),
	(assign, ":highest_competitor_score", "$g_talk_troop_relation"),
	(try_for_range, ":competitor", lords_begin, lords_end),
		(this_or_next|troop_slot_eq, ":competitor", slot_troop_love_interest_1, ":bride"),
		(this_or_next|troop_slot_eq, ":competitor", slot_troop_love_interest_2, ":bride"),
			(troop_slot_eq, ":competitor", slot_troop_love_interest_3, ":bride"),
		(call_script, "script_troop_get_relation_with_troop", "$g_talk_troop", ":competitor"),	
		(gt, reg0, ":highest_competitor_score"),
		(assign, ":highest_competitor_score", reg0),
		
		(str_store_troop_name, s12, ":competitor"),
	(try_end),
	(gt, ":highest_competitor_score", "$g_talk_troop_relation"),
	(call_script, "script_troop_get_family_relation_to_troop",  ":bride", "$g_talk_troop"),
	
  ],
   "Sorry, lad -- I'm not going to make my {s11} marry you, when I'd rather see her married to {s12}", "lord_pretalk",[
   (call_script, "script_fail_quest", "qst_formal_marriage_proposal"),
   (call_script, "script_end_quest", "qst_formal_marriage_proposal"),
   ]],

 
   #Permission granted
  [anyone,"lord_marriage_permission", [
	(quest_get_slot, ":bride", "qst_formal_marriage_proposal", slot_quest_giver_troop),
	(str_store_troop_name, s11, ":bride"),
  ],
   "Splendid news, my young man -- I shall be proud to have you in our family. Now, let us talk the terms of the marriage. As per our custom, the two of us must make sure that {s11} has sufficient finances to support herself, in the event of any unforeseen circumstances..", "lord_marriage_permission_endowment",[
    (troop_get_slot, ":player_renown", "trp_player", slot_troop_renown),
    (troop_get_slot, ":guardian_renown", "$g_talk_troop", slot_troop_renown),

	(store_mul, "$marriage_dowry", ":player_renown", 20),
	(val_min, "$marriage_dowry", 20000),

	(store_mul, "$marriage_dower", ":guardian_renown", 20),
	(val_min, "$marriage_dower", 20000),
   ]],
 
  
  [anyone,"lord_marriage_permission_endowment", [
	(assign, reg3, "$marriage_dower"),
	(assign, reg4, "$marriage_dowry"),
  ],
   "I would say that, taking into consideration the prestige of our two houses, that you can provide a dower of {reg3} denars, while I will supply a dowry of {reg4} denars. This shall be her ladyship's property, as a security, lest for any reason you are unable to provide for her. What say you to that?", "lord_marriage_permission_endowment_answer",[
   ]],

  [anyone|plyr,"lord_marriage_permission_endowment_answer", [
  (store_troop_gold, ":gold", "trp_player"),
  (ge, ":gold", "$marriage_dower"),
  ],
   "Very well -- so let it be.", "lord_marriage_permission_engagement_date",[
   ]],
   
  [anyone|plyr,"lord_marriage_permission_endowment_answer", [],
   "I cannot afford that right now.", "lord_marriage_permission_endowment_answer_delay",[
   ]],

  [anyone|plyr,"lord_marriage_permission_endowment_answer", [
  (eq, 1, 0),
  ],
   "That is too much to pay.", "lord_marriage_permission_endowment_answer_no",[
   ]],

  [anyone,"lord_marriage_permission_endowment_answer_no", [],
   "Well. I cannot in all decency allow my daughter to marry without some security, can I? Let me know if you change your mind.", "close_window",[
   (assign, "$g_leave_encounter", 1),
   ]],
   
   
  [anyone,"lord_marriage_permission_engagement_date", [
  (quest_get_slot, ":bride", "qst_formal_marriage_proposal", slot_quest_giver_troop),
  (call_script, "script_get_kingdom_lady_social_determinants", ":bride"),
  (assign, ":venue", reg1),
  (is_between, ":venue", walled_centers_begin, walled_centers_end),
  (party_slot_eq, ":venue", slot_village_state, svs_normal),
  (str_store_party_name, s24, ":venue"),
  ],
   "Splendid! You two may now consider yourselves offically betrothed. Very well -- I shall plan to hold a great feast in {s24}, as soon as circumstances permit. We will be sure to notify you when the day comes.", "close_window",
   [
   (quest_get_slot, ":bride", "qst_formal_marriage_proposal", slot_quest_giver_troop),
   (troop_set_slot, "trp_player", slot_troop_betrothed, ":bride"), 
   (troop_set_slot, ":bride", slot_troop_betrothed, "trp_player"), 

   (call_script, "script_end_quest", "qst_formal_marriage_proposal"),


   (troop_remove_gold, "trp_player", "$marriage_dower"),
   (call_script, "script_get_kingdom_lady_social_determinants", ":bride"),
   (assign, ":venue", reg1),

   (str_store_troop_name, s3, ":bride"),
   (str_store_troop_name, s4, "$g_talk_troop"),
   (str_store_party_name, s5, ":venue"),
   
   (setup_quest_text, "qst_wed_betrothed"),
   (str_store_string, s2, "str_you_plan_to_marry_s3_at_a_feast_hosted_by_s4_in_s5_you_should_be_notifed_of_the_feast_as_soon_as_it_is_held"),

   (call_script, "script_start_quest", "qst_wed_betrothed", "$g_talk_troop"),

   (quest_set_slot, "qst_wed_betrothed", slot_quest_expiration_days, 365),
   (quest_set_slot, "qst_wed_betrothed", slot_quest_giver_troop, "$g_talk_troop"),
   (quest_set_slot, "qst_wed_betrothed", slot_quest_target_troop, ":bride"),

   (try_begin),
		(eq,"$talk_context",tc_party_encounter),   
		(assign, "$g_leave_encounter", 1),
   (try_end),
   
   ]],

   
  [anyone,"lord_marriage_permission_engagement_date", [],
   "Unfortunately, there is one final complication -- there is no safe place to hold the wedding. Let us hold off on finalizing this, for the time being.", "close_window",
   []],

  [anyone,"lord_marriage_permission_endowment_answer_delay", [],
   "No matter -- take the time you need to raise the money. I want her ladyship to be well looked after.", "lord_pretalk",[
   ]],

  [anyone,"lord_marriage_permission_endowment_answer_delay", [],
   "That is a shame, but I would be remiss in my duty if I allowed her ladyship to face an uncertain future.", "lord_pretalk",[
   (call_script, "script_fail_quest", "qst_formal_marriage_proposal"),
   (call_script, "script_end_quest", "qst_formal_marriage_proposal"),
   ]],


   
 #courtship
 [anyone|plyr,"lord_talk_ask_something_2",[
	(neg|troop_slot_eq, "$g_talk_troop", slot_lord_granted_courtship_permission, 1),
	
	(assign, "$marriage_candidate", 0),
	(try_for_range, ":lady", kingdom_ladies_begin, kingdom_ladies_end),
		(eq, "$marriage_candidate", 0),
		(troop_slot_ge, ":lady", slot_troop_courtship_state, 2),
		(neg|troop_slot_eq, ":lady", slot_troop_courtship_state, 4),
		(neg|troop_slot_ge, ":lady", slot_troop_spouse, 0),
		(call_script, "script_get_kingdom_lady_social_determinants", ":lady"),
		(eq, reg0, "$g_talk_troop"),

		(assign, "$marriage_candidate", ":lady"),
		
		(str_clear, s14),
		(call_script, "script_troop_get_family_relation_to_troop", ":lady", "$g_talk_troop"),
		(gt, reg0, 0),
		(str_store_string, s14, "str_your_s11_"),
	(try_end),
	(gt, "$marriage_candidate", 0),
	(str_store_troop_name, s12, "$marriage_candidate"),

	(str_clear, s10),
	(try_begin),
		(troop_slot_eq, "$g_talk_troop", slot_lord_granted_courtship_permission, -1),
		(str_store_string, s10, "str_i_ask_again_may"),
	(else_try),
		(str_store_string, s10, "str_may"),
	(try_end),
	],
    "{s10} I have the honor of visiting with {s14}{s12}?", "lord_courtship_permission",
[]],   

   
  [anyone,"lord_courtship_permission", [ 
    (troop_slot_ge, "$marriage_candidate", slot_troop_met, 2),
	(neg|troop_slot_eq, "$marriage_candidate", slot_troop_met, 4),
	(this_or_next|troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_debauched),
		(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_quarrelsome),

	(call_script, "script_troop_get_relation_with_troop", "$marriage_candidate", "trp_player"),
	(gt, reg0, 0),
		],
    "From what I hear, you have already spoken to her -- without my permission. Let me tell you this: I am her lord and guardian, and I have plans for her. I will not be mocked behind my back as a man who cannot control the women of his household. I would ask you not to discuss this matter with me again.", "lord_pretalk",
[
	(troop_set_slot, "$g_talk_troop", slot_lord_granted_courtship_permission, -1),
	(call_script, "script_troop_change_relation_with_troop", "$g_talk_troop", "trp_player", -1),
]],  


  [anyone,"lord_courtship_permission", [
	(call_script, "script_npc_decision_checklist_male_guardian_assess_suitor", "$g_talk_troop", "trp_player"),
	(lt, reg0, 1),
	(str_store_string, s14, reg1),
 ],
    "{s14}", "lord_pretalk",
[
	(troop_set_slot, "$g_talk_troop", slot_lord_granted_courtship_permission, -1),
]], 


  [anyone,"lord_courtship_permission", [
	(try_begin),
		(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_goodnatured),
		(str_store_string, s12, "str_very_well_as_far_as_im_concerned_i_suppose_she_can_see_most_anyone_she_likes__within_reason_of_course"),
	(else_try),
		(this_or_next|troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_debauched),
			(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_quarrelsome),
		(str_store_string, s12, "str_very_well_an_alliance_with_you_could_be_valuable_go_chat_with_her_and_see_if_you_can_get_her_to_take_a_fancy_to_you_if_she_doesnt_and_if_we_still_want_to_conclude_this_business_then_i_can_make_her_see_reason"),	
	(else_try),
		(str_store_string, s12, "str_you_have_my_blessing_to_pay_suit_to_her__so_long_as_your_intentions_are_honorable_of_course_depending_on_how_things_proceed_between_you_two_we_may_have_more_to_discuss_at_a_later_date"),
	(try_end),
 ],
    "{s12}", "lord_pretalk",
[
	(troop_set_slot, "$g_talk_troop", slot_lord_granted_courtship_permission, 1),
]],   

#Ask for marriage, following courtship, both with or against lady's wishes   
   
  [anyone|plyr,"lord_talk_ask_something_2", [ 
	(neg|troop_slot_eq, "$g_talk_troop", slot_lord_granted_courtship_permission, 1),
	(neg|troop_slot_ge, "trp_player", slot_troop_spouse, active_npcs_begin),
	(troop_get_type, ":is_female", "$g_talk_troop"),
	(neq, ":is_female", 1),
  ],
   "What would it take to cement a lasting alliance with your house?", "lord_talk_ask_marriage_1",[]],




   
  [anyone|plyr,"lord_talk_ask_something_2", [],
   "Never mind.", "lord_pretalk",[]],

  [anyone,"lord_talk_ask_location", [],
   "Very well, I may or may not have an answer for you. About whom do you wish to hear?", "lord_talk_ask_location_2",[]],

  [anyone|plyr|repeat_for_troops,"lord_talk_ask_location_2", [(store_repeat_object, ":troop_no"),
                                                              (neq, "$g_talk_troop", ":troop_no"),
                                                              (is_between, ":troop_no", active_npcs_begin, kingdom_ladies_end),
															  (neq, ":troop_no", "trp_player"),
                                                              (this_or_next|troop_slot_eq, ":troop_no", slot_troop_occupation, slto_kingdom_hero),
																(troop_slot_eq, ":troop_no", slot_troop_occupation, slto_kingdom_lady),
                                                              (store_troop_faction, ":faction_no", ":troop_no"),
                                                              (eq, "$g_encountered_party_faction", ":faction_no"),
                                                              (str_store_troop_name, s1, ":troop_no"),
															  (try_begin),
																(faction_slot_eq, "$players_kingdom", slot_faction_marshall, ":troop_no"),
															    (str_store_string, s1, "@Our marshal, {s1}"),
															  (try_end),
															  
															  ],
   "{s1}", "lord_talk_ask_location_3",[(store_repeat_object, "$hero_requested_to_learn_location")]],

  [anyone|plyr,"lord_talk_ask_location_2", [
     (is_between, "$g_talk_troop", kingdom_ladies_begin, kingdom_ladies_end),
  ], "Never mind.", "lady_pretalk",[]],
   
  [anyone|plyr,"lord_talk_ask_location_2", [
     (neg|is_between, "$g_talk_troop", kingdom_ladies_begin, kingdom_ladies_end),
  ], "Never mind.", "lord_pretalk",[]],

  [anyone,"lord_talk_ask_location_3",
   [
     (is_between, "$g_talk_troop", kingdom_ladies_begin, kingdom_ladies_end),
     (call_script, "script_update_troop_location_notes", "$hero_requested_to_learn_location", 1),
     (call_script, "script_get_information_about_troops_position", "$hero_requested_to_learn_location", 0),
     ],
   "{s1}", "lady_pretalk",[]],
  
  
  
  [anyone,"lord_talk_ask_location_3",
   [
     (call_script, "script_update_troop_location_notes", "$hero_requested_to_learn_location", 1),
     (call_script, "script_get_information_about_troops_position", "$hero_requested_to_learn_location", 0),
     ],
   "{s1}", "lord_pretalk",[]],

  [anyone,"lord_talk_ask_about_war", [],
   "{s12}", "lord_talk_ask_about_war_2",[
                                                                      (assign, ":num_enemies", 0),
                                                                      (try_for_range_backwards, ":cur_faction", kingdoms_begin, kingdoms_end),
                                                                        (faction_slot_eq, ":cur_faction", slot_faction_state, sfs_active),
                                                                        (store_relation, ":cur_relation", ":cur_faction", "$g_talk_troop_faction"),
                                                                        (lt, ":cur_relation", 0),
                                                                        (try_begin),
                                                                          (eq, ":num_enemies", 0),
                                                                          (str_store_faction_name_link, s12, ":cur_faction"),
                                                                        (else_try),
                                                                          (eq, ":num_enemies", 1),
                                                                          (str_store_faction_name_link, s11, ":cur_faction"),
                                                                          (str_store_string, s12, "@{s11} and {s12}"),
                                                                        (else_try),
                                                                          (str_store_faction_name_link, s11, ":cur_faction"),
                                                                          (str_store_string, s12, "@{!}{s11}, {s12}"),
                                                                        (try_end),
                                                                        (val_add, ":num_enemies", 1),
                                                                      (try_end),
                                                                      (try_begin),
                                                                        (eq, ":num_enemies", 0),
                                                                        (str_store_string, s12, "@We are not at war with anyone."),
                                                                      (else_try),
                                                                        (str_store_string, s12, "@We are at war with {s12}."),
                                                                      (try_end),
                                                                      ]],

  [anyone|plyr|repeat_for_factions, "lord_talk_ask_about_war_2", [(store_repeat_object, ":faction_no"),
                                                                  (is_between, ":faction_no", kingdoms_begin, kingdoms_end),
                                                                  (faction_slot_eq, ":faction_no", slot_faction_state, sfs_active),
                                                                     (store_relation, ":cur_relation", ":faction_no", "$g_talk_troop_faction"),
                                                                     (lt, ":cur_relation", 0),
                                                                     (str_store_faction_name, s1, ":faction_no")],
   "Tell me more about the war with {s1}.", "lord_talk_ask_about_war_details",[(store_repeat_object, "$faction_requested_to_learn_more_details_about_the_war_against")]],

  [anyone|plyr,"lord_talk_ask_about_war_2", [], "That's all I wanted to know. Thank you.", "lord_pretalk",[]],

  [anyone,"lord_talk_ask_about_war_details", [],
#   "We have {reg5?{reg5}:no} {reg3?armies:army} and they have {reg6?{reg6}:none}. Overall, {s9}.",
   "{s9}.",
   "lord_talk_ask_about_war_2",
   [#(call_script, "script_faction_get_number_of_armies", "$g_encountered_party_faction"),
    #(assign, reg5, reg0),
    #(assign, reg3, 1),
    #(try_begin),
                                #  (eq, reg5, 1),
                                #  (assign, reg3, 0),
                                #(try_end),
                                #(call_script, "script_faction_get_number_of_armies", "$faction_requested_to_learn_more_details_about_the_war_against"),
                                #(assign, reg6, reg0),
                                #(assign, reg4, 1),
                                #(try_begin),
                                #  (eq, reg6, 1),
                                #  (assign, reg4, 0),
                                #(try_end),
                                #(store_div, ":our_str", reg5, 2),
                                #(store_div, ":enemy_str", reg6, 2),
                                #(store_sub, ":advantage", ":our_str", ":enemy_str"),
                                #(val_clamp, ":advantage", -4, 5),
                                #(val_add, ":advantage", 4),
                                #(store_add, ":adv_str", "str_war_report_minus_4", ":advantage"),
                                #(str_store_string, s9, ":adv_str"),
								
		(store_add, ":war_damage_slot", "$faction_requested_to_learn_more_details_about_the_war_against", slot_faction_war_damage_inflicted_on_factions_begin),
		(val_sub, ":war_damage_slot", kingdoms_begin),
	    (faction_get_slot, ":war_damage_inflicted", "$g_talk_troop_faction", ":war_damage_slot"),
		
		(store_add, ":war_damage_slot", "$g_talk_troop_faction", slot_faction_war_damage_inflicted_on_factions_begin),
		(val_sub, ":war_damage_slot", kingdoms_begin),
	    (faction_get_slot, ":war_damage_suffered", "$faction_requested_to_learn_more_details_about_the_war_against", ":war_damage_slot"),

		(val_max, ":war_damage_suffered", 1),

		(store_mul, ":war_damage_ratio", ":war_damage_inflicted", 100),
		(val_div, ":war_damage_ratio", ":war_damage_suffered"),
		
		(try_begin),
			(eq, "$cheat_mode", 1),
			(assign, reg3, ":war_damage_inflicted"),
			(assign, reg4, ":war_damage_suffered"),
			(assign, reg5, ":war_damage_ratio"),
			(display_message, "str_war_damage_inflicted_reg3_suffered_reg4_ratio_reg5"),
		(try_end),
		
		(str_store_string, s9, "str_error__did_not_calculate_war_progress_string_properly"),
		(try_begin),
			(lt, ":war_damage_inflicted", 5),
			(str_store_string, s9, "str_the_war_has_barely_begun_so_and_it_is_too_early_to_say_who_is_winning_and_who_is_losing"),
		(else_try),	
			(gt, ":war_damage_inflicted", 100),
			(gt, ":war_damage_ratio", 200),
			(str_store_string, s9, "str_we_have_been_hitting_them_very_hard_and_giving_them_little_chance_to_recover"),
		(else_try),	
			(gt, ":war_damage_inflicted", 80),
			(gt, ":war_damage_ratio", 150),
			(str_store_string, s9, "str_the_fighting_has_been_hard_but_we_have_definitely_been_getting_the_better_of_them"),
		(else_try),	
			(gt, ":war_damage_suffered", 100),
			(lt, ":war_damage_ratio", 50),
			(str_store_string, s9, "str_they_have_been_hitting_us_very_hard_and_causing_great_suffering"),
		(else_try),	
			(gt, ":war_damage_suffered", 80),
			(lt, ":war_damage_ratio", 68),
			(str_store_string, s9, "str_the_fighting_has_been_hard_and_i_am_afraid_that_we_have_been_having_the_worst_of_it"),
		(else_try),	
			(gt, ":war_damage_suffered", 50),
			(gt, ":war_damage_inflicted", 50),
			(gt, ":war_damage_ratio", 65),
			(str_store_string, s9, "str_both_sides_have_suffered_in_the_fighting"),
		(else_try),
			(gt, ":war_damage_ratio", 125),
			(str_store_string, s9, "str_no_clear_winner_has_yet_emerged_in_the_fighting_but_i_think_we_are_getting_the_better_of_them"),
		(else_try),
			(gt, ":war_damage_ratio", 80),
			(str_store_string, s9, "str_no_clear_winner_has_yet_emerged_in_the_fighting_but_i_fear_they_may_be_getting_the_better_of_us"),
		(else_try),
			(str_store_string, s9, "str_no_clear_winner_has_yet_emerged_in_the_fighting"),
		(try_end),

		(try_begin),
			(neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
			(call_script, "script_npc_decision_checklist_peace_or_war", "$g_talk_troop_faction", "$faction_requested_to_learn_more_details_about_the_war_against", -1),
			(str_store_string, s9, "str_s9_s14"),
        (try_end),
		]],


		
  [anyone,"lord_talk_ask_about_strategy", [
  (faction_get_slot, ":ai_state", "$g_encountered_party_faction", slot_faction_ai_state),
  (faction_get_slot, ":ai_object", "$g_encountered_party_faction", slot_faction_ai_object),
  
  
  
  (faction_get_slot, ":ai_decider", "$g_encountered_party_faction", slot_faction_marshall),
  (try_begin),
	(eq, ":ai_decider", -1),
	(faction_get_slot, ":ai_decider", "$g_encountered_party_faction", slot_faction_leader),
  (try_end),
  
  (call_script, "script_npc_decision_checklist_faction_ai_alt", ":ai_decider"),
  (assign, ":planned_state", reg0),
  (assign, ":planned_object", reg1),


  (try_begin),
	(gt, ":ai_object", -1),
    (str_store_party_name, s8, ":ai_object"),
  (try_end),
  
  (try_begin),
	(eq, ":ai_state", sfai_default),
    (str_store_string, s7, "str_there_is_no_campaign_currently_in_progress"),
  (else_try),
	(eq, ":ai_state", sfai_gathering_army),
    (str_store_string, s7, "str_we_are_assembling_the_army"),
  (else_try),
	(eq, ":ai_state", sfai_attacking_center),
    (str_store_string, s7, "str_we_aim_to_take_the_fortress_of_s8"),
  (else_try),
	(eq, ":ai_state", sfai_raiding_village),
    (str_store_string, s7, "str_we_are_on_a_raid_and_are_now_targeting_s8"),
  (else_try),
	(eq, ":ai_state", sfai_attacking_enemy_army),
    (str_store_string, s7, "str_we_are_trying_to_seek_out_and_defeat_s8"),
  (else_try),
	(eq, ":ai_state", sfai_attacking_enemies_around_center),
    (str_store_string, s7, "str_we_are_riding_to_the_defense_of_s8"),
  (else_try),
	(eq, ":ai_state", sfai_feast),
    (str_store_string, s7, "str_we_are_gathering_for_a_feast_at_s8"),
  (try_end),

  #Additional information for gathering the army
  (str_clear, s9),
  (try_begin),
	(eq, ":ai_state", sfai_gathering_army),
	(faction_get_slot, ":faction_marshal", "$g_talk_troop_faction", slot_faction_marshall),	
	(gt, ":faction_marshal", -1),
	(troop_get_slot, ":marshal_party", ":faction_marshal", slot_troop_leaded_party),
	(party_is_active, ":marshal_party"),
	
	(this_or_next|eq, "$g_talk_troop", ":faction_marshal"),
		(party_slot_eq, "$g_talk_troop_party", slot_party_ai_object, ":marshal_party"),
	
	(party_get_slot, ":marshal_object", ":marshal_party", slot_party_ai_object),
	
    (try_begin),
		(eq, ":marshal_object", -1),
		(str_store_string, s9, "str_we_are_waiting_here_for_vassals"),
	(else_try),
		(str_store_party_name, s11, ":marshal_object"),
		(str_store_string, s9, "str_we_are_travelling_to_s11_for_vassals"),
    (try_end),
  (try_end),
  
  
  (try_begin),
	(this_or_next|neq, ":ai_state", ":planned_state"),
		(neq, ":ai_object", ":planned_object"),
	
	(str_store_string, s14, "str__however_that_may_change_shortly_s14"),	
  (try_end),
  
  ],		
	"{s7} {s9} {s14}", "lord_strategy_follow_evaluation",
	[]],

  [anyone, "lord_strategy_follow_evaluation", [
	(this_or_next|faction_slot_eq, "$g_talk_troop_faction", slot_faction_marshall, "$g_talk_troop"),
	(this_or_next|faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_default),
		(faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_feast),
  ],
   "Did you have any other questions?",
   "lord_talk_ask_something_2",[
   ]],
	
	
  [anyone, "lord_strategy_follow_evaluation", [
  (faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_gathering_army),
  (call_script, "script_npc_decision_checklist_faction_ai_alt", "$g_talk_troop"),
  (assign, ":talk_troop_preferred_strategy", reg0),  
  (neq, ":talk_troop_preferred_strategy", sfai_gathering_army),

  (store_current_hours, ":hours_at_current_state"),
  (faction_get_slot, ":current_state_started", "$g_talk_troop_faction", slot_faction_ai_current_state_started),
  (val_sub, ":hours_at_current_state", ":current_state_started"),  
  (ge, ":hours_at_current_state", 40),
  
  (faction_get_slot, ":faction_marshal", "$g_talk_troop_faction", slot_faction_marshall),
  (is_between, ":faction_marshal", active_npcs_begin, active_npcs_end),
  (neq, ":faction_marshal", "$g_talk_troop"),
  (str_store_troop_name, s4, ":faction_marshal"),
  ],
   "Our leader {s4} is far too cautious. {reg4?She:He} should either use the army to attack the enemy, or let it go home.",
   "lord_strategy_follow_up",[
  (assign, "$g_talk_troop_disagrees_with_marshal", 1),
   
   ]],	
	

  [anyone, "lord_strategy_follow_evaluation", [
  (faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_gathering_army),

  (store_current_hours, ":hours_at_current_state"),
  (faction_get_slot, ":current_state_started", "$g_talk_troop_faction", slot_faction_ai_current_state_started),
  (val_sub, ":hours_at_current_state", ":current_state_started"),  
  (ge, ":hours_at_current_state", 40),
  
  (faction_get_slot, ":faction_marshal", "$g_talk_troop_faction", slot_faction_marshall),
  (is_between, ":faction_marshal", active_npcs_begin, active_npcs_end),
  (neq, ":faction_marshal", "$g_talk_troop"),  
  
  (call_script, "script_troop_get_relation_with_troop", "$g_talk_troop", ":faction_marshal"),
  (lt, reg0, 5),
  
  (str_store_troop_name, s4, ":faction_marshal"),
  
  ],
   "Our army sits, doing nothing. Apparently, too few vassals have answered the call to arms. Perhaps {s4} does not enjoy the confidence of the great lords of this realm.",
   "lord_strategy_follow_up",[
  (assign, "$g_talk_troop_disagrees_with_marshal", 1),
   
   ]],	

  #To Steve - Why we need this dialog? It already included in below lord_strategy_follow_evaluation dialogs
  #[anyone, "lord_strategy_follow_evaluation", 
  #[
  #  (this_or_next|faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_attacking_center),
  #  (faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_raiding_village),        
  #  
  #  (faction_get_slot, ":cur_object", "$g_talk_troop_faction", slot_faction_ai_object),
  #  (call_script, "script_npc_decision_checklist_evaluate_enemy_center_for_attack", "$g_talk_troop", ":cur_object", 1, 0),
  #  (lt, reg0, 0),
  #  
  #  (str_store_string, s9, reg1),
  #  (str_store_party_name, s8, ":cur_object"),
  #],
  # "I disagree with the marshal's decision. I believe that {s8} {s9}",
  # "lord_strategy_why_not",[
  # ]],

  #This dialog appears when lord disagrees with marshal about the selected faction ai (attack/defend/gather/other).
  #To Steve - I took that dialog upper from below one. Lord should compare his faction ai choice with marshal's one before comparing preffered ai objects.
  [anyone, "lord_strategy_follow_evaluation", 
  [
    (call_script, "script_npc_decision_checklist_faction_ai_alt", "$g_talk_troop"),
    (assign, ":talk_troop_preferred_strategy", reg0),
        
    (neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, ":talk_troop_preferred_strategy"),    
    
    (assign, ":continue", 1),
    (try_begin),
      (eq, ":talk_troop_preferred_strategy", sfai_raiding_village),
      (str_store_string, s4, "@go on the offensive now."),		
    (else_try),
      (eq, ":talk_troop_preferred_strategy", sfai_attacking_center),
      (str_store_string, s4, "@go on the offensive now."),		
    (else_try),
      (eq, ":talk_troop_preferred_strategy", sfai_attacking_enemies_around_center),
      (str_store_string, s4, "@act to defend our lands."),
    (else_try),
      (eq, ":talk_troop_preferred_strategy", sfai_gathering_army),
      (str_store_string, s4, "@take more time to gather the army."),	
    (else_try),
      (assign, ":continue", 0),
    (try_end),
    
	(eq, ":continue", 1),	
	
	(faction_get_slot, ":faction_marshal", "$g_talk_troop_faction", slot_faction_marshall),	
  (is_between, ":faction_marshal", active_npcs_begin, active_npcs_end),
  (neq, ":faction_marshal", "$g_talk_troop"),	
	
    (str_store_troop_name, s10, ":faction_marshal"),  
    (assign, "$g_talk_troop_disagrees_with_marshal", 1),
	
  ],
   "I disagree with this strategy. I would prefer to {s4}.",
   "lord_strategy_follow_up", [
    (assign, "$g_talk_troop_disagrees_with_marshal", 1),
   
   ]],

  #This dialog appears when lord disagrees with marshal about the city will be attacked.
  [anyone, "lord_strategy_follow_evaluation", 
  [
    (this_or_next|faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_attacking_center),
    (faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_raiding_village),  
    
    (call_script, "script_find_center_to_attack_alt", "$g_talk_troop", 1, 0),
    (assign, ":preferred_center", reg0),    
	(is_between, ":preferred_center", centers_begin, centers_end),
	
    (faction_get_slot, ":cur_object", "$g_talk_troop_faction", slot_faction_ai_object),
    (neq, ":cur_object", ":preferred_center"),
    
    #To Steve - if lord's preffered center is different from marshal's current one then this should be enough for lord to say I disagree with marshal isn't this better?
    #Because it is not easy for any lord to return minus score for a center, so if we do not do this, we will not be able to see lords which disagree with marshal.
    #Conclusion : I removed condition of (lt, reg0, 0),  
    
    (faction_get_slot, ":faction_marshal", "$g_talk_troop_faction", slot_faction_marshall),  	
  (is_between, ":faction_marshal", active_npcs_begin, active_npcs_end),
  (neq, ":faction_marshal", "$g_talk_troop"),
	
    (call_script, "script_npc_decision_checklist_evaluate_enemy_center_for_attack", ":faction_marshal", ":preferred_center", 1, 0),
    #(lt, reg0, 0),  
    
    (str_store_string, s9, reg1),
    (str_store_party_name, s8, ":preferred_center"),

    (faction_get_slot, ":faction_marshal", "$g_talk_troop_faction", slot_faction_marshall),  	
  (is_between, ":faction_marshal", active_npcs_begin, active_npcs_end),
  (neq, ":faction_marshal", "$g_talk_troop"),	
	
    (str_store_troop_name, s10, ":faction_marshal"),  
	
  ],
   "I personally would prefer to attack {s8}, but our marshal {s10} believes that it {s9}",
   "lord_strategy_follow_up",[
    (assign, "$g_talk_troop_disagrees_with_marshal", 1),
   
   ]],
   
  #This dialog appears when lord disagrees with marshal about the city will be defended.
  [anyone, "lord_strategy_follow_evaluation", 
  [  
    (faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_attacking_enemies_around_center),    
    
    (call_script, "script_find_center_to_defend", "$g_talk_troop"),
    (assign, ":preferred_center", reg0),
	(is_between, ":preferred_center", centers_begin, centers_end),
    (faction_get_slot, ":cur_object", "$g_talk_troop_faction", slot_faction_ai_object),
    (neq, ":cur_object", ":preferred_center"),

    (faction_get_slot, ":faction_marshal", "$g_talk_troop_faction", slot_faction_marshall),  	
  (is_between, ":faction_marshal", active_npcs_begin, active_npcs_end),
  (neq, ":faction_marshal", "$g_talk_troop"),	
	
    (str_store_party_name, s8, ":preferred_center"),
    (str_store_party_name, s9, ":cur_object"),
	
  ],
   "I personally would prefer to defend {s8}, instead of {s9}.",
   "lord_strategy_follow_up",[
    (assign, "$g_talk_troop_disagrees_with_marshal", 1),
   ]],

  
   
   
   
  [anyone, "lord_strategy_follow_evaluation", 
  [
  (faction_get_slot, ":faction_marshal", "$g_talk_troop_faction", slot_faction_marshall),  	
  (this_or_next|neg|is_between, ":faction_marshal", active_npcs_begin, active_npcs_end),
	(eq, ":faction_marshal", "$g_talk_troop"),  
  ],
   "Is there anything else?",
   "lord_talk",[
   ]],  
  
  
  [anyone, "lord_strategy_follow_evaluation", 
  [],
   "This strategy seems reasonable to me.",
   "lord_strategy_follow_up",[
  (assign, "$g_talk_troop_disagrees_with_marshal", 0),
   ]],
   
  [anyone|plyr, "lord_strategy_follow_up", [
  (this_or_next|faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_attacking_center),
	(faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_raiding_village),
  ],
   "If you're attacking, why aren't you...",
   "lord_strategy_why_not",[
   ]],

  [anyone|plyr, "lord_strategy_follow_up", [
  ],
   "I see....",
   "lord_talk_ask_something_again",[
   ]],

  [anyone|plyr, "lord_strategy_follow_up", [
  (eq, "$g_talk_troop_disagrees_with_marshal", 1),
  (neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
  (faction_get_slot, ":faction_marshal", "$g_talk_troop_faction", slot_faction_marshall),
  (is_between, ":faction_marshal", active_npcs_begin, active_npcs_end),  
  (str_store_troop_name, s4, ":faction_marshal"),
  ],
   "Would you say, then, that {s4} should no longer be marshal?",
   "lord_talk_replace_marshal",[
   ]],

  [anyone, "lord_talk_replace_marshal", [
  (faction_get_slot, ":faction_issue", "$g_talk_troop_faction", slot_faction_political_issue),
  (is_between, ":faction_issue", centers_begin, centers_end),
  (str_store_party_name, s4, ":faction_issue"),
  ],
   "I believe that our realm should resolve the issue of {s4} before we begin to debate replacing the marshal.",
   "lord_talk_ask_something_again",[
   ]],

   
  [anyone, "lord_talk_replace_marshal", [
  (faction_slot_eq, "$g_talk_troop_faction", slot_faction_political_issue, 1),
  (troop_get_slot, ":stance_on_faction_issue", "$g_talk_troop", slot_troop_stance_on_faction_issue),
  (faction_get_slot, ":faction_marshal", "$g_talk_troop_faction", slot_faction_marshall),
  (neq, ":stance_on_faction_issue", ":faction_marshal"),
  (str_store_troop_name, s4,  ":stance_on_faction_issue"),
  (str_store_troop_name, s5,  ":faction_marshal"),

  ],
   "Yes. I have already made my position on this matter clear. I believe that {s4} should be marshal instead of {s5}.",
   "lord_talk_ask_something_again",[
   ]],
   
  [anyone, "lord_talk_replace_marshal", [
  (faction_get_slot, ":faction_marshal", "$g_talk_troop_faction", slot_faction_marshall),
  (call_script, "script_troop_get_relation_with_troop", "$g_talk_troop", ":faction_marshal"),
  (assign, ":relation_with_marshal", reg0),
  (gt, ":relation_with_marshal", "$g_talk_troop_effective_relation"),
  ],
   "I will make up my mind on this matter without your persuasion, {sir/my lady}.",
   "lord_talk_ask_something_again",[
   ]],

  [anyone, "lord_talk_replace_marshal", [
  ],
   "Hmm...",
   "lord_talk_replace_marshal_decision",[
   (faction_set_slot, "$g_talk_troop_faction", slot_faction_political_issue, 1),
   ]],
   
   
  [anyone, "lord_talk_replace_marshal_decision", [
  (call_script, "script_npc_decision_checklist_take_stand_on_issue", "$g_talk_troop"),
  (assign, ":replacement_candidate", reg0),
  (neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_marshall, ":replacement_candidate"),
  (call_script, "script_troop_describes_troop_to_s15", "$g_talk_troop", ":replacement_candidate"),
  ],
   "Yes, I would say that. At this point, I would be tempted to say that I support {s15} instead. I am glad that you and I had this discussion, so that I know that we are of the same mind on this matter.",
   "lord_talk_ask_something_again",[
  (call_script, "script_npc_decision_checklist_take_stand_on_issue", "$g_talk_troop"),
  (assign, ":replacement_candidate", reg0),
  (troop_set_slot, "$g_talk_troop", slot_troop_stance_on_faction_issue, ":replacement_candidate"),   
  
  (faction_get_slot, ":faction_marshal", "$g_talk_troop_faction", slot_faction_marshall),
  (troop_get_slot, ":marshal_controversy",  ":faction_marshal", slot_troop_controversy),   
  (val_add, ":marshal_controversy", 5),
  (troop_set_slot, ":faction_marshal", slot_troop_controversy, ":marshal_controversy"),   
  
  
  (call_script, "script_troop_describes_troop_to_s15", "$g_talk_troop", ":replacement_candidate"),
  
   ]],


  [anyone, "lord_talk_replace_marshal_decision", [
  (faction_get_slot, ":faction_marshal", "$g_talk_troop_faction", slot_faction_marshall),
  (str_store_troop_name, s4, ":faction_marshal"),
  ],
   "Not necessarily. It is possible for {s4} and I have to have an honest disagreement over strategy, without my seeking to replace him.",
   "lord_talk_ask_something_again",[
   ]],

   
   
   
  [anyone, "lord_strategy_why_not", [
  ],
   "Yes?",
   "lord_strategy_why_not_select",[
   ]],
   
  [anyone|plyr, "lord_strategy_why_not_select", [
  ],
   "Never mind",
   "lord_talk_ask_something_again",[]],   

  [anyone|plyr, "lord_strategy_why_not_select", 
  [
    (this_or_next|faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_raiding_village),
    (faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_attacking_center),
    
    (faction_get_slot, ":cur_object", "$g_talk_troop_faction", slot_faction_ai_object),
    (faction_get_slot, ":faction_marshal", "$g_talk_troop_faction", slot_faction_marshall),
    (gt, ":faction_marshal", -1), 
    (call_script, "script_find_center_to_attack_alt", ":faction_marshal", 1, 0),
    (neq, reg0, ":cur_object"),
    (str_store_party_name,s4, ":cur_object"),
  ],
   "..planning to continue with the attack on {s4}?",
   "lord_strategy_why_not_reason",[
   ]],

  [anyone|plyr|repeat_for_parties, "lord_strategy_why_not_select", 
  [
    (store_repeat_object, ":selected_center"),
    (is_between, ":selected_center", centers_begin, centers_end),
    
    (store_faction_of_party, ":selected_center_faction", ":selected_center"),
    (eq, ":selected_center_faction", "$g_talk_troop_faction"),        
    
    (neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_object, ":selected_center"),
    (neq, "$g_target_after_gathering", ":selected_center"),
    
    (party_slot_ge, ":selected_center", slot_center_sortie_enemy_strength, 1),
    (str_store_party_name,s4, ":selected_center"),
  ],
   "..defending {s4}?",
   "lord_strategy_why_not_reason",[
   (store_repeat_object, "$temp"),
   ]],
      
  [anyone|plyr|repeat_for_parties, "lord_strategy_why_not_select", 
  [
    (store_repeat_object, ":selected_center"),
    (is_between, ":selected_center", centers_begin, centers_end),
    
    (store_faction_of_party, ":selected_center_faction", ":selected_center"), 
    (store_relation, ":relation", ":selected_center_faction", "$g_talk_troop_faction"),
    (lt, ":relation", 0),
    
    (neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_object, ":selected_center"),
    (str_store_party_name,s4, ":selected_center"),
   ],
   "..attacking {s4}?",
   "lord_strategy_why_not_reason",
   [
     (store_repeat_object, "$temp"),
     
     (try_begin),
       (eq, "$cheat_mode", 1),
       (store_sub, ":faction_recce_slot", "$g_talk_troop_faction", kingdoms_begin),
       (val_add, ":faction_recce_slot", slot_center_last_reconnoitered_by_faction_time),
       (store_current_hours, ":hours_since_last_recon"),
       (party_get_slot, ":last_recon_time", "$temp", ":faction_recce_slot"), 
       (val_sub, ":hours_since_last_recon", ":last_recon_time"),
     (try_end),   
   ]],
   
  [anyone, "lord_strategy_why_not_reason", 
  [
    (assign, ":selected_center", "$temp"),
    (store_faction_of_party, ":selected_center_faction", ":selected_center"),    
    (eq, ":selected_center_faction", "$g_talk_troop_faction"),
    (faction_get_slot, ":faction_marshal", "$g_talk_troop_faction", slot_faction_marshall),
    (call_script, "script_find_center_to_defend", ":faction_marshal"),
    (assign, ":most_threatened_center", reg0),
    (assign, ":threat_danger_level", reg1),
    (assign, ":enemy_strength_near_threatened_center", reg2),
        
    (try_begin),
      (call_script, "script_find_center_to_attack_alt", ":faction_marshal", 1, 0),
      (assign, ":target_value_level", reg1),
      (call_script, "script_find_center_to_attack_alt", ":faction_marshal", 1, 1),
      (assign, ":target_value_level_all_vassals", reg1),
      
      (try_begin),
        (ge, ":target_value_level_all_vassals", ":target_value_level"),
        (assign, ":target_value_level_max", ":target_value_level_all_vassals"),
      (else_try),
        (assign, ":target_value_level_max", ":target_value_level"),
      (try_end),
      
      (gt, ":target_value_level_max", ":threat_danger_level"),
      (assign, reg4, ":target_value_level"),
      (assign, reg5, ":threat_danger_level"),
      (str_store_string, s9, "str_reason_1"),
    (else_try),
      (assign, ":continue", 0),
      (try_begin),
        (is_between, ":selected_center", villages_begin, villages_end),  
        (is_between, ":most_threatened_center", walled_centers_begin, walled_centers_end),  
        (assign, ":continue", 1),
      (try_end),  
      
      (try_begin),
        (is_between, ":selected_center", castles_begin, castles_end),  
        (is_between, ":most_threatened_center", towns_begin, towns_end),  
        (assign, ":continue", 1),
      (try_end),  
      
      (eq, ":continue", 1),
      
      (str_store_party_name, s8, ":most_threatened_center"),
      #values of centers : town > castle > village
      #Situation : We are going to defend more valueable center. 
      #To Steve - Please find a better explaining string for below line.
      (str_store_string, s9, "str_reason_2"),
    (else_try),
      (neq, ":most_threatened_center", ":selected_center"),
      (str_store_party_name, s8, ":most_threatened_center"),
      (str_store_string, s9, "str_reason_3"),
    (else_try),
      (troop_get_slot, ":marshal_party", ":faction_marshal", slot_troop_leaded_party),
      (party_is_active, ":marshal_party"),
      (party_get_slot, ":cached_strength", ":marshal_party", slot_party_cached_strength),
      (party_get_slot, ":follower_strength", ":marshal_party", slot_party_follower_strength),
      (store_add, ":total_strength", ":cached_strength", ":follower_strength"),
      (ge, ":enemy_strength_near_threatened_center", ":total_strength"),
      (assign, reg4, ":enemy_strength_near_threatened_center"),
      (assign, reg5, ":total_strength"),
      (str_store_string, s9, "str_reason_4"),
    (else_try),
      (str_store_string, s9, "str_reason_5"),
    (try_end),  
  ],
   "{s9}",
   "lord_talk_why_not_repeat",[]],
         
  [anyone, "lord_strategy_why_not_reason", 
  [
    (assign, ":selected_center", "$temp"),
    (faction_get_slot, ":faction_marshal", "$g_talk_troop_faction", slot_faction_marshall),
    
    (faction_get_slot, ":faction_ai_object", "$g_talk_troop_faction", slot_faction_ai_object),    

    (call_script, "script_npc_decision_checklist_evaluate_enemy_center_for_attack", ":faction_marshal", ":faction_ai_object", 1, 0),
    (assign, "$g_faction_object_score", reg0),
    
    (assign, "$g_do_not_skip_other_than_current_ai_object", 1),
    (call_script, "script_npc_decision_checklist_evaluate_enemy_center_for_attack", ":faction_marshal", ":selected_center", 1, 0),
    (assign, "$g_do_not_skip_other_than_current_ai_object", 0),    
        
    (lt, reg0, 0),
    (assign, ":explainer_string", reg1),
    (try_begin),
      (eq, "$g_use_current_ai_object_as_s8", 0),
      (str_store_party_name, s8, ":selected_center"),
    (else_try),  
      (str_store_party_name, s8, ":faction_ai_object"),
    (try_end),
    (str_store_string, s9, ":explainer_string"),
    (str_clear, s10),
	(str_store_troop_name, s11, ":faction_marshal"),
	#s10 will say that 
  ],
   "Our marshal {s11} believes that {s8} {s9}{s10}",
   "lord_talk_why_not_repeat",[]],                  
         
  [anyone, "lord_strategy_why_not_reason", 
  [
    (faction_get_slot, ":faction_marshal", "$g_talk_troop_faction", slot_faction_marshall),
    (faction_get_slot, ":cur_object", "$g_talk_troop_faction", slot_faction_ai_object),        
    
    (call_script, "script_npc_decision_checklist_evaluate_enemy_center_for_attack", ":faction_marshal", ":cur_object", 1, 0),
    (assign, ":power_ratio_for_cur_object", reg2),
    (call_script, "script_npc_decision_checklist_evaluate_enemy_center_for_attack", ":faction_marshal", "$temp", 1, 0),
    (assign, ":power_ratio_for_selected_center", reg2),
    
    (try_begin),
      (eq, ":power_ratio_for_selected_center", 0),
      (str_store_string, s7, "str_reason_6"),
    (else_try),
      (lt, ":power_ratio_for_selected_center", 200),
      (str_store_string, s7, "str_reason_7"),
    (else_try),
      (is_between, ":power_ratio_for_selected_center", 200, 300),
      (str_store_string, s7, "str_reason_8"),
    (else_try),
      (ge, ":power_ratio_for_selected_center", 300),
      (str_store_string, s7, "str_reason_9"),
    (else_try),	
      (str_store_string, s7, "str_error_string"),
	(try_end),
	
	(try_begin),
	  (eq, ":power_ratio_for_cur_object", 0),
	  (str_store_string, s8, "str_reason_6"),
	(else_try),
	  (lt, ":power_ratio_for_cur_object", 200),
	  (str_store_string, s8, "str_reason_7"),
	(else_try),
	  (is_between, ":power_ratio_for_cur_object", 200, 300),
	  (str_store_string, s8, "str_reason_8"),
	(else_try),
	  (ge, ":power_ratio_for_cur_object", 300),
	  (str_store_string, s8, "str_reason_9"),
	(else_try),	
	  (str_store_string, s8, "str_error_string"),
	(try_end),
	
	(try_begin),
	  (ge, ":cur_object", 0),
	  (str_store_party_name, s4, ":cur_object"),
	(else_try),  
	  (ge, "$g_target_after_gathering", 0),
	  (str_store_party_name, s4, "$g_target_after_gathering"),
	(else_try),
	  (str_store_party_name, s4, "str_error_string"),
	(try_end),  
	
	(str_store_troop_name, s5, ":faction_marshal"),	
	
	(try_begin),
	  (eq, "$cheat_mode", 1),
	  (store_sub, ":faction_recce_slot", "$g_talk_troop_faction", kingdoms_begin),
	  (val_add, ":faction_recce_slot", slot_center_last_reconnoitered_by_faction_time),
	  (store_current_hours, ":hours_since_last_recon"),
	  (party_get_slot, ":last_recon_time", "$temp", ":faction_recce_slot"), 
	  (val_sub, ":hours_since_last_recon", ":last_recon_time"),
	  
	  (store_sub, ":faction_recce_slot", "$g_talk_troop_faction", kingdoms_begin),
	  (val_add, ":faction_recce_slot", slot_center_last_reconnoitered_by_faction_time),
	  (store_current_hours, ":hours_since_last_recon"),
	  (party_get_slot, ":last_recon_time", ":cur_object", ":faction_recce_slot"), 
	  (val_sub, ":hours_since_last_recon", ":last_recon_time"),
	(try_end),					
	
	(try_begin),
	  (assign, ":continue", 0),
	  (try_begin),
	    (party_slot_eq, "$g_talk_troop_party", slot_party_ai_state, sfai_gathering_army),
	    (lt, "$g_target_after_gathering", 0), #then this means faction is gathering army to attack a center.
	    (assign, ":continue", 1),
	  (try_end),  

      (this_or_next|eq, ":continue", 1),
	  (this_or_next|faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_attacking_center),
	  (faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_raiding_village),
	  
	  (str_store_string, s3, "str_has_decided_that_an_attack_on_"),
	  (str_store_string, s6, "str_this_would_be_better_worth_the_effort"),
	(else_try),  
	  (str_store_string, s3, "str_has_decided_to_defend_"),
	  (str_store_party_name, s9, "$temp"),
	  (str_store_string, s6, "str_before_going_offensive_we_should_protect_our_lands_if_there_is_any_threat_so_this_can_be_reason_marshall_choosed_defending_s4"),
	  (str_clear, s8),
	(try_end),  
  ],
   "We could go there. {s7} However, {s5} {s3} {s4}. {s6} {s8}.",
   "lord_talk_why_not_repeat",[
   ]],

  [anyone,"lord_talk_why_not_repeat", [
  ],
   "Did you have any similar questions? Why we are not...",
   "lord_strategy_why_not_select",[
   ]],
			   				
  [anyone,"lord_talk_ask_marriage_1", [
  (faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
  ],
   "You will not take offense if I tell you that, as a king, I have other plans for my children.",
   "lord_pretalk",[
   ]],
								
   
  [anyone,"lord_talk_ask_marriage_1", [
    (assign, "$marriage_candidate", -1),
	(try_begin),
		(troop_get_type, ":is_female", "trp_player"),
		(eq, ":is_female", 1),
		(troop_slot_eq, "$g_talk_troop", slot_troop_spouse, -1),
		(assign, "$marriage_candidate", "$g_talk_troop"),
	(else_try),	
		(troop_get_type, ":is_female", "trp_player"),
		(eq, ":is_female", 0),
		(assign, "$marriage_candidate", -1),
		(try_for_range, ":lady", kingdom_ladies_begin, kingdom_ladies_end),
			(troop_slot_eq, ":lady", slot_troop_spouse, -1),
			(troop_slot_eq, ":lady", slot_troop_betrothed, -1),
			(call_script, "script_get_kingdom_lady_social_determinants", ":lady"),
			
			(eq, reg0, "$g_talk_troop"),
			
			(call_script, "script_troop_get_family_relation_to_troop", ":lady", "$g_talk_troop"),
			(assign, "$marriage_candidate", ":lady"),
			(str_store_troop_name, s14, "$marriage_candidate"),
			
			(str_store_string, s15, "str_it_is_our_custom_to_seal_any_such_alliances_with_marriage_and_in_fact_we_have_been_looking_for_a_suitable_groom_for_my_s11_s14"),

		(try_end),
	(try_end),
	(eq, "$marriage_candidate", -1),
  ],
   "It is our custom to seal any such alliances with marriage. Unfortunately, no one in my household is eligible to wed.",
   "lord_pretalk",[
   ]],
								
  [anyone,"lord_talk_ask_marriage_1", [
  (troop_get_type, ":type", "trp_player"),
  (eq, ":type", 0),
  ],
   "{s15}",
   "lord_courtship_pre_permission",[
   ]],

  [anyone,"lord_talk_ask_marriage_1", [
  (eq, "$marriage_candidate", "$g_talk_troop"),
  ],
   "Are you proposing that you and I marry?",
   "lord_marriage_proposal_female_pc_confirm",[
   ]],
   


   
  [anyone|plyr,"lord_courtship_pre_permission", [
  (neg|troop_slot_ge, "trp_player", slot_troop_spouse, 1),
  (neg|troop_slot_ge, "trp_player", slot_troop_betrothed, 1),

  (troop_get_type, ":is_female", "trp_player"),
  (eq, ":is_female", 0),
  
  (str_clear, s15),
  (try_begin),
	(troop_slot_eq, "$g_talk_troop", slot_lord_granted_courtship_permission, -1),
	(str_store_string, s15, "str_once_again_"),
  (try_end),
  ],
   "May I {s15}suggest that I be considered as a groom?",
   "lord_courtship_permission",[
   ]],

   
  [anyone|plyr,"lord_courtship_pre_permission", [
  (eq, "$cheat_mode", 2),
  ],
   "CHEAT -- Start engagement",
   "lord_marriage_permission_engagement_date",[
   
   (setup_quest_text, "qst_formal_marriage_proposal"),
   (str_store_string, s2, "str_cheat__marriage_proposal"),
   
   (call_script, "script_start_quest", "qst_formal_marriage_proposal", "$marriage_candidate"),
   (quest_set_slot, "qst_formal_marriage_proposal", slot_quest_giver_troop, "$marriage_candidate"),
   ]],
   
   
      
  [anyone|plyr,"lord_courtship_pre_permission", [
  ],
   "Never mind",
   "lord_pretalk",[
   ]],

   
   
   

  [anyone|plyr,"lord_marriage_proposal_female_pc_confirm", [
  ],
   "Yes. That is my proposal.",
   "lord_marriage_proposal_female_pc_reax",[
   ]],

  [anyone|plyr,"lord_marriage_proposal_female_pc_confirm", [
  ],
   "No, I think you have misunderstood me.",
   "lord_pretalk",[
   ]],

  [anyone,"lord_marriage_proposal_female_pc_reax", [
  (call_script, "script_npc_decision_checklist_marry_female_pc", "$g_talk_troop"),
  (le, reg0, 0),
  ],
   "{s14}",
   "lord_pretalk",[
   ]],

  [anyone,"lord_marriage_proposal_female_pc_reax", [
  (call_script, "script_npc_decision_checklist_marry_female_pc", "$g_talk_troop"),
  (eq, reg0, 2),
  ],
   "{s14}",
   "lord_pretalk",[
   (troop_set_slot, "$g_talk_troop", slot_troop_met, 2),
   ]],
   
  [anyone,"lord_marriage_proposal_female_pc_reax", [
  ],
   "{s14}",
   "lord_marriage_proposal_female_pc_next_step",[
   ]],

#  [anyone,"lord_marriage_proposal_female_pc_next_step", [
#  ],
#   "I must say, though. You live your life like a man, riding where you will, with the company you choose. This will not make it easy for the other lords to accept our marriage. I don't suppose that you would give up adventuring, for the sake of our marriage?",
#   "lord_marriage_proposal_female_pc_next_step_2",[
#   ]],
   
#   [anyone|plyr,"lord_marriage_proposal_female_pc_next_step_2", [
#  ],
#   "I think not!",
#   "lord_marriage_proposal_female_pc_next_step_3",[
#   ]],  
   
  [anyone,"lord_marriage_proposal_female_pc_next_step", [
  ],
   "I suppose the next step would be for me to send a message to your family, asking for their permission to marry you, but I suppose that you make your own decisions.",
   "lord_marriage_proposal_female_pc_next_step_4",[
   ]],   
   
   [anyone|plyr,"lord_marriage_proposal_female_pc_next_step_4", [
  ],
   "You assume correctly.",
   "lord_marriage_proposal_female_pc_next_step_5",[
   ]],
   
   [anyone,"lord_marriage_proposal_female_pc_next_step_5", [
  ],
   "Very well, then. As there are no obstacles to our marriage, should we then consider ourselves engaged to be wed? I will organize a great feast, and we can exchange our vows before all the lords of the realm. If you are willing, that is...",
   "lord_marriage_proposal_female_pc_confirm_engagement",[
   ]],    
   
   [anyone|plyr,"lord_marriage_proposal_female_pc_confirm_engagement", [
  ],
   "I am willing.",
   "lord_marriage_proposal_female_pc_confirm_engagement_yes",[
   (troop_set_slot, "$g_talk_troop", slot_troop_betrothed, "trp_player"),
   (troop_set_slot, "trp_player", slot_troop_betrothed, "$g_talk_troop"),

   (assign, "$g_other_quest", 0),
   (try_begin),
	(store_partner_quest, ":other_quest", "$g_talk_troop"),
    (gt, ":other_quest", 0),
	(assign, "$g_other_quest", ":other_quest"),
   (try_end),
   
   (str_store_troop_name, s4, "$g_talk_troop"),
   
   (setup_quest_text, "qst_wed_betrothed_female"),
   (str_store_string, s2, "str_you_plan_to_marry_s4_as_you_have_no_family_in_calradia_he_will_organize_the_wedding_feast"),

   (call_script, "script_start_quest", "qst_wed_betrothed_female", "$g_talk_troop"),

   (quest_set_slot, "qst_wed_betrothed_female", slot_quest_expiration_days, 120),
   (quest_set_slot, "qst_wed_betrothed_female", slot_quest_giver_troop, "$g_talk_troop"),
   
   ]],    
   
   [anyone|plyr,"lord_marriage_proposal_female_pc_confirm_engagement", [
  ],
   "Actually, I would like to reconsider.",
   "lord_marriage_proposal_female_pc_confirm_engagement_no",[
   
   ]],    
   
   [anyone,"lord_marriage_proposal_female_pc_confirm_engagement_yes", [
   
   (str_clear, s12),
   (try_begin),
	(gt, "$g_other_quest", 0),
	(call_script, "script_succeed_quest", "$g_other_quest"),
	(call_script, "script_end_quest", "$g_other_quest"),
	(str_store_string, s12, "str_cancel_fiancee_quest"),
   (try_end),
  ],
   "Very well. Hopefully, a little over a month from now, we shall be wed.{s12}",
   "close_window",[
   (assign, "$g_leave_encounter", 1),
   ]],
   
   [anyone,"lord_marriage_proposal_female_pc_confirm_engagement_no", [
  ],
   "Take whatever time you need, my lady.",
   "close_window",[
   (assign, "$g_leave_encounter", 1),
   ]],
   
   
   
#continue marriage talks here								

  [anyone|plyr,"lord_talk", [(eq,"$talk_context",tc_party_encounter),
                             (lt, "$g_encountered_party_relation", 0),
                             (str_store_troop_name,s4,"$g_talk_troop")],
   "I say this only once, {s4}! Surrender or die!", "party_encounter_lord_hostile_ultimatum_surrender", []],
   
  [anyone,"party_encounter_lord_hostile_ultimatum_surrender", [],
   "{s43}", "close_window", [
       (call_script, "script_lord_comment_to_s43", "$g_talk_troop", "str_lord_challenged_default"),

       (call_script, "script_make_kingdom_hostile_to_player", "$g_encountered_party_faction", -3),
	   
       (try_begin),
         (gt, "$g_talk_troop_relation", -10),
         (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", -1),
       (try_end),
       (assign,"$encountered_party_hostile",1),
       (assign,"$encountered_party_friendly",0),]],


  [anyone|plyr,"lord_talk", [(eq,"$talk_context", tc_party_encounter),
                             (neq,"$g_encountered_party_faction","$players_kingdom"),
                             (ge, "$g_encountered_party_relation", 0),
                                 ], "I'm here to deliver you my demands!", "lord_predemand",[]],
  [anyone,"lord_predemand", [], "Eh? What do you want?", "lord_demand",[]],

  [anyone|plyr,"lord_demand", [(neq,"$g_encountered_party_faction","$players_kingdom"),
                               (ge, "$g_encountered_party_relation", 0),], "I offer you one chance to surrender or die.", "lord_ultimatum_surrender",[]],

	#Neutral attack on lord						   
  [anyone,"lord_ultimatum_surrender", [(ge, "$g_encountered_party_relation", 0)], "{s43}", "lord_attack_verify",[#originally, speak you rascal
        (call_script, "script_lord_comment_to_s43", "$g_talk_troop", "str_unprovoked_attack_default"),
	    (try_begin),
			(faction_slot_ge, "$g_encountered_party_faction", slot_faction_truce_days_with_factions_begin, 1),
			(str_store_faction_name, s34, "$g_encountered_party_faction"),
			(str_store_string, s43, "str_s43_just_so_you_know_if_you_attack_me_you_will_be_in_violation_of_the_truce_you_signed_with_the_s34"),
	    (try_end),
	    (try_begin),
			(eq, "$players_kingdom", "fac_player_supporters_faction"),
			(faction_slot_eq, "fac_player_supporters_faction", slot_faction_leader, "trp_player"),
			(str_store_string, s43, "str_s43_also_you_should_know_that_an_unprovoked_assault_is_declaration_of_war"),
	    (try_end),
	
      ]],
  
  [anyone|plyr,"lord_attack_verify", [], "Forgive me sir. I don't know what I was thinking.", "lord_attack_verify_cancel",[]],
  [anyone,"lord_attack_verify_cancel", [], "Be gone, then.", "close_window",[(call_script, "script_change_player_relation_with_troop", "$g_talk_troop", -1),(assign, "$g_leave_encounter",1)]],
  [anyone|plyr,"lord_attack_verify", [], "That is none of your business. Prepare to fight!", "lord_attack_verify_commit",[
  ]],

  #The kingdoms are already at war
  [anyone,"lord_ultimatum_surrender", [], "{s43}", "lord_attack_verify_b", #originally, you will not survive this
   [
    (call_script, "script_lord_comment_to_s43", "$g_talk_troop", "str_unnecessary_attack_default"),
    (call_script, "script_make_kingdom_hostile_to_player", "$g_encountered_party_faction", -3),
    (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", -5),

    (assign,"$encountered_party_hostile",1),
    (assign,"$encountered_party_friendly",0),
    ]],

  [anyone|plyr,"lord_attack_verify_b", [], "Forgive me sir. I don't know what I was thinking.", "lord_attack_verify_cancel",[]],
  [anyone|plyr,"lord_attack_verify_b", [], "I stand my ground. Prepare to fight!", "lord_attack_verify_commit",[]],

  [anyone,"lord_attack_verify_commit", [], "{s43}", "close_window",
   [
    (call_script, "script_lord_comment_to_s43", "$g_talk_troop", "str_lord_challenged_default"),
	(try_begin),
		(ge, "$g_encountered_party_relation", 0),	
		(call_script, "script_diplomacy_party_attacks_neutral", "p_main_party", "$g_encountered_party"),
	(try_end),
	(try_begin), #this try is added so that a player  monarch ccannot spark a war by attacking a neutral. The player does however cause a provocation, which may allow the other side to go to war
		#If a player can create a hostile faction simply by attacking, this will allow a number of exploits. Therefore, it is quite important to keep this condition in here for active player kingdoms
		(neq, "$players_kingdom", "fac_player_supporters_faction"),
		(call_script, "script_make_kingdom_hostile_to_player", "$g_encountered_party_faction", -3),
	(else_try),	
		(eq, "$players_kingdom", "fac_player_supporters_faction"),
		(call_script, "script_diplomacy_start_war_between_kingdoms",  "fac_player_supporters_faction", "$g_encountered_party_faction", 1),
	(try_end),

#   (call_script, "script_make_kingdom_hostile_to_player", "$g_encountered_party_faction", -3),
   (assign,"$encountered_party_hostile",1),
   (assign,"$encountered_party_friendly",0),
    (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", -30),
    ]],
#Post 0907 changes end
  
  [anyone|plyr,"lord_demand", [], "Forgive me. It's nothing.", "lord_pretalk",[]],


##  [anyone|plyr,"lord_talk", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                             (ge, "$g_talk_troop_faction_relation", 0),
##                             ],
##   "I wish to ask for a favor.", "lord_ask_for_favor_ask",[]],



  [anyone|plyr,"lord_talk", [
                            (faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
                            (troop_slot_eq, "$g_talk_troop", slot_troop_discussed_rebellion, 0),                      
                            (assign, ":pretender", 0),
                            (try_for_range, ":possible_pretender", pretenders_begin, pretenders_end),
                                (troop_slot_eq, ":possible_pretender", slot_troop_original_faction, "$g_talk_troop_faction"),
                                (assign, ":pretender", ":possible_pretender"),
                            (try_end),
                            (troop_slot_ge, ":pretender", slot_troop_met, 1),
                            (str_store_troop_name, s45, ":pretender"),
                            (troop_get_type, reg3, ":pretender"),
                             ],
   "I have met in my travels one who calls {reg3?herself:himself} {s45}...", "liege_defends_claim_1",[
       ]],

  [anyone,"liege_defends_claim_1", [],
   "Oh really? It is not everyone who dares mention that name in my presence. I am not sure whether to reward your bravery, or punish you for your impudence.", "liege_defends_claim_2", [
                            (troop_set_slot, "$g_talk_troop", slot_troop_discussed_rebellion, 1),
                    ]],

  [anyone,"liege_defends_claim_2", [],
   "Very well. I will indulge your curiosity. But listen closely, because I do not wish to speak of this matter again.", "liege_defends_claim_3", [
                    ]],

  [anyone,"liege_defends_claim_3", [],
   "{s48}", "liege_defends_claim_4", [
                     (store_sub, ":rebellion_string", "$g_talk_troop_faction", "fac_kingdom_1"),                                
                     (val_add, ":rebellion_string", "str_swadian_rebellion_monarch_response_1"),
                     (str_store_string, 48, ":rebellion_string"),
                     ]],

  [anyone,"liege_defends_claim_4", [],
   "{s48}", "lord_talk", [
                     (store_sub, ":rebellion_string", "$g_talk_troop_faction", "fac_kingdom_1"),                                
                     (val_add, ":rebellion_string", "str_swadian_rebellion_monarch_response_2"),
                     (str_store_string, 48, ":rebellion_string"),
                     ]],


#Rebellion changes begin
#  [anyone|plyr,"lord_talk", [
#                             (gt, "$supported_pretender", 0),
#                             (eq, "$supported_pretender_old_faction", "$g_talk_troop_faction"),
#                             (troop_slot_eq, "$g_talk_troop", slot_troop_discussed_rebellion, 0),
#                             (neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
#                             (troop_slot_ge, "$g_talk_troop", slot_troop_leaded_party, 1),
#                             (str_store_troop_name, s12, "$supported_pretender"),
#                             (str_store_faction_name, s14, "$supported_pretender_old_faction"),
#                             (faction_get_slot, ":old_faction_lord", "$supported_pretender_old_faction", slot_faction_leader),
#                             (str_store_troop_name, s15, ":old_faction_lord"),
#                             ],
#   "{s12} is the rightful ruler of {s14}. Join our cause against the usurper, {s15}!", "lord_join_rebellion_suggest",[]],

   [anyone|plyr,"lord_talk",
   [
     (eq, "$cheat_mode", 2),
     (gt, "$supported_pretender", 0),
     (eq, "$supported_pretender_old_faction", "$g_talk_troop_faction"),
     (neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
     (troop_slot_ge, "$g_talk_troop", slot_troop_leaded_party, 1),
     ],
   "{!}CHEAT - Join our cause by force.", "lord_join_rebellion_suggest_cheat",[]],

  [anyone|plyr,"party_encounter_lord_hostile_attacker_2",
   [
     (eq, "$cheat_mode", 2),
     (gt, "$supported_pretender", 0),
     (eq, "$supported_pretender_old_faction", "$g_talk_troop_faction"),
     (neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
     (troop_slot_ge, "$g_talk_troop", slot_troop_leaded_party, 1),
     ],
   "{!}CHEAT - Join our cause by force.", "lord_join_rebellion_suggest_cheat",[]],

  [anyone,"lord_join_rebellion_suggest_cheat",
   [], "Cheat:Allright.",
   "close_window", # unused
   [
     (troop_set_slot, "$g_talk_troop", slot_troop_discussed_rebellion, 1),
     (call_script, "script_change_troop_faction", "$g_talk_troop", "$players_kingdom"),
     (assign, "$g_leave_encounter", 1),
     ]],

#  [anyone|plyr,"party_encounter_lord_hostile_attacker_2", [
#                             (gt, "$supported_pretender", 0),
#                             (eq, "$supported_pretender_old_faction", "$g_talk_troop_faction"),
#                             (neg|troop_slot_ge, "$g_talk_troop", slot_troop_intrigue_impatience, 100),
#                             (neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
#                             (troop_slot_ge, "$g_talk_troop", slot_troop_leaded_party, 1),
#                             (str_store_troop_name, s12, "$supported_pretender"),
#                             (str_store_faction_name, s14, "$supported_pretender_old_faction"),
#                             (faction_get_slot, ":old_faction_lord", "$supported_pretender_old_faction", slot_faction_leader),
#                             (str_store_troop_name, s15, ":old_faction_lord"),
#                             ],
#   "{s12} is your rightful ruler. Join our cause against the usurper, {s15}!", "lord_join_rebellion_suggest",[]],


   
#  [anyone,"lord_join_rebellion_suggest", [
#                    (eq,"$talk_context",tc_party_encounter),
#                    (encountered_party_is_attacker),
#                    (lt, "$g_talk_troop_relation", -5),
#      ], "I have no time to bandy words with the likes of you. Now defend yourself!",
#   "party_encounter_lord_hostile_attacker_2",
#   [
#    (try_begin),
#		(neg|troop_slot_ge, "$g_talk_troop", slot_troop_intrigue_impatience, 100),
#		(troop_set_slot, "$g_talk_troop", slot_troop_intrigue_impatience, 100),
#	(try_end),	
   
#    ]],

	
	#removed a number of rebellion scripts...

#Rebellion changes end


  [anyone|plyr,"lord_talk", 
  [
    (troop_get_slot, ":prison_location", "$g_talk_troop", slot_troop_prisoner_of_party),
    (is_between, ":prison_location", centers_begin, centers_end),
    (neg|party_slot_eq, ":prison_location", slot_town_lord, "trp_player"),
    (neq, "$talk_context", tc_prison_break),
  ],
  "I've come to break you out of here.", "lord_prison_break_chains",[]],

  [anyone,"lord_prison_break_chains", [],   
  "Thank the heavens you came! However, I'm not going anywhere with these chains on my legs. You'll need to get the key away from the guard somehow.", "close_window",[]],			
				
  [anyone|plyr,"lord_talk", 
  [
    (ge, "$cheat_mode", 1),
    (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
  ],
  "{!}CHEAT - Take the following action.", "lord_suggest_action_ask",[]],
   
   
  [anyone,"lord_tell_objective", 
  [
    (troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
  ],
  "What am I doing? What does it look like I'm doing?! I'm a prisoner here!", "lord_pretalk",[]],

  [anyone,"lord_tell_objective", 
  [
    (troop_slot_eq, "$g_talk_troop", slot_troop_leaded_party, -1)
  ],
  "I am not commanding any men at the moment.", "lord_pretalk",[]],



  [anyone,"lord_tell_objective", [
  (party_slot_eq, "$g_talk_troop_party", slot_party_ai_state, spai_holding_center),
  (party_get_attached_to, ":cur_center_no", "$g_talk_troop_party"),
  (try_begin),
    (lt, ":cur_center_no", 0),
    (party_get_cur_town, ":cur_center_no", "$g_talk_troop_party"),
  (try_end),
  (is_between, ":cur_center_no", centers_begin, centers_end),
  ],
   "We are resting at {s1}. {s14}{s15}",
   "lord_pretalk",
   [(party_get_slot, ":ai_object", "$g_talk_troop_party", slot_party_ai_object),
    (str_store_party_name, s1, ":ai_object")]],
	




	

  [anyone,"lord_tell_objective", [(party_slot_eq, "$g_talk_troop_party", slot_party_ai_state, spai_holding_center)],
   "We are travelling to {s1}. {s14}{s15}", "lord_pretalk",
   [(party_get_slot, ":ai_object", "$g_talk_troop_party", slot_party_ai_object),
    (str_store_party_name, s1, ":ai_object"),
	]],

  [anyone|auto_proceed,"lord_tell_objective", [
  (faction_slot_eq, "$g_talk_troop_faction", slot_faction_marshall, "$g_talk_troop"),
  (party_slot_eq, "$g_talk_troop_party", slot_party_ai_state, spai_visiting_village)],
   "{!}Warning: This line should never display.", "lord_tell_objective_2",
   []],

#fix for translation variable changes
  [anyone,"lord_tell_objective_2", [],
   "I am heading to the vicinity of {s1}. {s14}{s15}", "lord_pretalk",
   [(party_get_slot, ":ai_object", "$g_talk_troop_party", slot_party_ai_object),
    (str_store_party_name, s1, ":ai_object")]],

  [anyone,"lord_tell_objective", [
  (party_slot_eq, "$g_talk_troop_party", slot_party_ai_state, spai_visiting_village)],
   "We are recruiting new soldiers from {s1}. {s14}{s15}", "lord_pretalk",
   [(party_get_slot, ":ai_object", "$g_talk_troop_party", slot_party_ai_object),
    (str_store_party_name, s1, ":ai_object")]],
	
	
	
	
  [anyone,"lord_tell_objective", [(party_slot_eq, "$g_talk_troop_party", slot_party_ai_state, spai_patrolling_around_center)],
   "We are scouting for the enemy around {s1}. {s14}{s15}", "lord_pretalk",
   [(party_get_slot, ":ai_object", "$g_talk_troop_party", slot_party_ai_object),
    (str_store_party_name, s1, ":ai_object"),
	]],

#  [anyone,"lord_tell_objective", [(party_slot_eq, "$g_talk_troop_party", slot_party_ai_state, spai_raiding_around_center)],
#   "We ride out to lay waste to village of {s1} to punish the foe for his misdeeds.", "lord_pretalk",[(party_get_slot, ":ai_object", "$g_talk_troop_party", slot_party_ai_object),
#                                                               (str_store_party_name, s1, ":ai_object")]],

  [anyone,"lord_tell_objective", [
  (party_slot_eq, "$g_talk_troop_party", slot_party_ai_state, spai_raiding_around_center),
  (party_get_slot, ":ai_object", "$g_talk_troop_party", slot_party_ai_object),
  (str_store_party_name, s1, ":ai_object")  
  ],
   "We are laying waste to the village of {s1}. {s14}{s15}", "lord_pretalk",[]],

  [anyone,"lord_tell_objective", [(party_slot_eq, "$g_talk_troop_party", slot_party_ai_state, spai_retreating_to_center)],
   "We are retreating to {s1}. {s14}{s15}", "lord_pretalk",[(party_get_slot, ":ai_object", "$g_talk_troop_party", slot_party_ai_object),
                                                               (str_store_party_name, s1, ":ai_object")]],

  [anyone,"lord_tell_objective", [(party_slot_eq, "$g_talk_troop_party", slot_party_ai_state, spai_besieging_center)],
   "We are besieging {s1}. {s14}{s15}", "lord_pretalk",[(party_get_slot, ":ai_object", "$g_talk_troop_party", slot_party_ai_object),
                                                               (str_store_party_name, s1, ":ai_object")]],

  [anyone,"lord_tell_objective", [(party_slot_eq, "$g_talk_troop_party", slot_party_ai_state, spai_engaging_army),
                                  (party_get_slot, ":ai_object", "$g_talk_troop_party", slot_party_ai_object),
                                  (party_is_active, ":ai_object"),
                                  ],
   "We are fighting against {s1}. {s14}{s15}", "lord_pretalk",
   [
     (party_get_slot, ":ai_object", "$g_talk_troop_party", slot_party_ai_object),
     (str_store_party_name, s1, ":ai_object")
     ]],

  [anyone,"lord_tell_objective", [
  (party_slot_eq, "$g_talk_troop_party", slot_party_ai_state, spai_screening_army)],
   "I am screening {s1}'s advance. {s14}{s15}", "lord_pretalk",[
    (party_get_slot, ":ai_object", "$g_talk_troop_party", slot_party_ai_object),
	(party_stack_get_troop_id, ":ai_object_commander", ":ai_object", 0),
    (str_store_troop_name, s1, ":ai_object_commander")
	]],
	 
	 
  [anyone,"lord_tell_objective", [(party_slot_eq, "$g_talk_troop_party", slot_party_ai_state, spai_accompanying_army)],
   "We are accompanying {s1}. {s14}{s15}", "lord_pretalk",[(party_get_slot, ":ai_object", "$g_talk_troop_party", slot_party_ai_object),
                                                      (str_store_party_name, s1, ":ai_object")]],


  [anyone,"lord_tell_objective",
   [
    (faction_slot_eq, "$g_talk_troop_faction", slot_faction_marshall, "$g_talk_troop"),
	(neg|faction_slot_eq,  "$g_talk_troop_faction", slot_faction_ai_state, sfai_default),
	(neg|faction_slot_eq,  "$g_talk_troop_faction", slot_faction_ai_state, sfai_feast),
     ],
   "I am leading the army of the realm.", "lord_talk_ask_about_strategy",[]],
													  
													  
  [anyone,"lord_tell_objective",
   [
     (assign, ":pass", 0),
     (try_begin),
       (party_slot_eq, "$g_talk_troop_party", slot_party_ai_state, spai_undefined),
       (assign, ":pass", 1),
     (else_try),
       (party_slot_eq, "$g_talk_troop_party", slot_party_ai_state, spai_engaging_army),
       (party_get_slot, ":ai_object", "$g_talk_troop_party", slot_party_ai_object),
       (neg|party_is_active, ":ai_object"),
       (assign, ":pass", 1),
     (try_end),
     (eq, ":pass", 1),
     ],
   "We are reconsidering our next objective.", "lord_pretalk",[]],

  [anyone,"lord_tell_objective", [],
   "I don't know: {reg1} {s1} (ERROR)", "lord_pretalk",[(party_get_slot, reg1, "$g_talk_troop_party", slot_party_ai_state),
                                                (party_get_slot, ":ai_object", "$g_talk_troop_party", slot_party_ai_object),
                                                               (str_store_party_name, s1, ":ai_object")]],

  [anyone|plyr,"lord_talk",
   [
     (eq, "$talk_context", tc_party_encounter),
	 (eq, 1, 0),
     (eq, "$g_talk_troop_faction", "$players_kingdom"),
     (party_slot_eq, "$g_encountered_party", slot_party_following_player, 0),
     (neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_marshall, "trp_player"),
     ],
   "Will you follow me? I have a plan.", "lord_ask_follow",[]],

  [anyone,"lord_ask_follow", [(party_get_slot, ":dont_follow_until_time", "$g_encountered_party", slot_party_dont_follow_player_until_time),
                              (store_current_hours, ":cur_time"),
                              (lt, ":cur_time", ":dont_follow_until_time")],
   "I enjoy your company, {playername}, but there are other things I must attend to. Perhaps in a few days I can ride with you again.", "close_window",
   [(assign, "$g_leave_encounter",1)]],

  [anyone,"lord_ask_follow", [(troop_get_slot, ":troop_renown", "$g_talk_troop", slot_troop_renown),
                              (troop_get_slot, ":player_renown", "trp_player", slot_troop_renown),
                              (val_mul, ":troop_renown", 3),
                              (val_div, ":troop_renown", 4),
                              (lt, ":player_renown", ":troop_renown"),
                              ],
   "That would hardly be proper, {playername}. Why don't you follow me instead?", "close_window",
   [(assign, "$g_leave_encounter",1)]],

  [anyone,"lord_ask_follow", [(lt, "$g_talk_troop_effective_relation", 25)],
   "{s43}", "close_window",
   [
       (call_script, "script_lord_comment_to_s43", "$g_talk_troop", "str_lord_follow_refusal_default"),
       (assign, "$g_leave_encounter",1)]],
#Post 0907 changes end

  [anyone,"lord_ask_follow", [],
   "Lead the way, {playername}! Let us bring death and defeat to all our enemies.", "close_window",
   [(party_set_slot, "$g_talk_troop_party", slot_party_commander_party, "p_main_party"),
    #(call_script, "script_party_decide_next_ai_state_under_command", "$g_talk_troop_party"),    
    (call_script, "script_npc_decision_checklist_party_ai", "$g_talk_troop"), #This handles AI for both marshal and other parties		
	(call_script, "script_party_set_ai_state", "$g_talk_troop_party", reg0, reg1),
    
    (store_current_hours, ":follow_until_time"),
    (store_add, ":follow_period", 30, "$g_talk_troop_relation"),
    (val_div, ":follow_period", 2),
    (val_add, ":follow_until_time", ":follow_period"),
    (party_set_slot, "$g_encountered_party", slot_party_follow_player_until_time, ":follow_until_time"),
    (party_set_slot, "$g_encountered_party", slot_party_following_player, 1),
    (assign, "$g_leave_encounter",1)]],

  [anyone,"lord_talk_preoffer", [], "Yes?", "lord_talk_offer",[]],

  
##  [anyone|plyr,"lord_talk_offer", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                             (neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"), #he is not a faction leader!
##                             (call_script, "script_get_number_of_hero_centers", "$g_talk_troop"),
##                             (eq, reg0, 0), #he has no castles or towns
##                             (hero_can_join),
##                             ],
##   "I need capable men like you. Will you join me?", "knight_offer_join",[
##       ]],

  [anyone|plyr,"lord_talk_offer", [(eq,1,0)],
   "I wish to ransom one of your prisoners.", "knight_offer_join",[
       ]],

  [anyone|plyr,"lord_talk_offer", [], "Never mind.", "lord_pretalk",[]],

  [anyone ,"knight_offer_join", [(call_script, "script_cf_is_quest_troop", "$g_talk_troop")],
   "I fear I cannot join you at the moment, {playername}, I've important business to attend to and it cannot wait.", "hero_pretalk",[]],

  [anyone ,"knight_offer_join", [(lt, "$g_talk_troop_relation", 5),
                                 (store_character_level,":player_level","trp_player"),
                                 (store_character_level,":talk_troop_level","$g_talk_troop"),
                                 (val_mul,":player_level",2),
                                 (lt, ":player_level", ":talk_troop_level")],
   "You forget your place, {sir/madam}. I do not take orders from the likes of you.", "hero_pretalk",[]],
  
  [anyone ,"knight_offer_join", [
       (assign, ":num_player_companions",0),
       (try_for_range, ":hero_id", heroes_begin, heroes_end),
         (troop_slot_eq, ":hero_id",slot_troop_occupation, slto_player_companion),
         (val_add, ":num_player_companions",1),
       (try_end),
       (assign, reg5, ":num_player_companions"),
       (store_add, reg6, reg5, 1),
       (val_mul, reg6,reg6),
       (val_mul, reg6, 1000),
       (gt, reg6,0)], #note that we abuse the value of reg6 in the next line.
 "I would be glad to fight at your side, my friend, but there is a problem...\
 The thing is, I've found myself in a bit of debt that I must repay very soon. {reg6} denars altogether,\
 and I am honour-bound to return every coin. Unless you've got {reg6} denars with you that you can spare,\
 I've to keep my mind on getting this weight off my neck.", "knight_offer_join_2",[]],
  [anyone ,"knight_offer_join", [(gt,reg6, 100000)], "Join you? I think not.", "close_window",[]],
  [anyone ,"knight_offer_join", [], "Aye, my friend, I'll be happy to join you.", "knight_offer_join_2",[]],

  [anyone|plyr,"knight_offer_join_2", [(gt, reg6,0),(store_troop_gold, ":gold", "trp_player"),(gt,":gold",reg6)],
   "Here, take it, all {reg6} denars you need. 'Tis only money.", "knight_offer_join_accept",[(troop_remove_gold, "trp_player",reg6)]],
  [anyone|plyr,"knight_offer_join_2", [(le, reg6,0)], "Then let us ride together, my friend.", "knight_offer_join_accept",[]],
   
  [anyone|plyr,"knight_offer_join_2", [(eq, "$talk_context", tc_hero_freed)], "That's good to know. I will think on it.", "close_window",[]],
  [anyone|plyr,"knight_offer_join_2", [(neq, "$talk_context", tc_hero_freed)], "That's good to know. I will think on it.", "hero_pretalk",[]],
  
  
  [anyone ,"knight_offer_join_accept", [(troop_slot_ge, "$g_talk_troop", slot_troop_leaded_party, 1)],
   "I've some trusted men in my band who could be of use to you. What do you wish to do with them?", "knight_offer_join_accept_party",[
      ]],
  [anyone ,"knight_offer_join_accept", [], "Ah, certainly, it might be fun!", "close_window",[
      (call_script, "script_recruit_troop_as_companion", "$g_talk_troop"),
      (assign, "$g_leave_encounter",1)
      ]],
  
  [anyone|plyr,"knight_offer_join_accept_party", [], "You may disband your men. I've no need for other troops.", "knight_join_party_disband",[]],
  [anyone|plyr,"knight_offer_join_accept_party", [(troop_get_slot, ":companions_party","$g_talk_troop", slot_troop_leaded_party),
                                       (party_can_join_party,":companions_party","p_main_party"),
      ], "Your men may join as well. We need every soldier we can muster.", "knight_join_party_join",[]],
  [anyone|plyr,"knight_offer_join_accept_party", [(is_between,"$g_encountered_party",centers_begin, centers_end)], "Lead your men out of the town. I shall catch up with you on the road.", "knight_join_party_lead_out",[]],
  [anyone|plyr,"knight_offer_join_accept_party", [(neg|is_between,"$g_encountered_party",centers_begin, centers_end)],
   "Keep doing what you were doing. I'll catch up with you later.", "knight_join_party_lead_out",[]],


  [anyone ,"knight_join_party_disband", [], "Ah . . . Very well, {playername}. Much as I dislike losing good men,\
 the decision is yours. I'll disband my troops and join you.", "close_window",[
      (call_script, "script_recruit_troop_as_companion", "$g_talk_troop"),

      (troop_get_slot, ":companions_party","$g_talk_troop", slot_troop_leaded_party),
      (party_detach, ":companions_party"),
      (remove_party, ":companions_party"),
      (assign, "$g_leave_encounter",1)
      ]],

  [anyone ,"knight_join_party_join", [], "Excellent.\
 My lads and I will ride with you.", "close_window",[
      (call_script, "script_recruit_troop_as_companion", "$g_talk_troop"),
      (party_remove_members, "p_main_party", "$g_talk_troop", 1),
      
      (troop_get_slot, ":companions_party","$g_talk_troop", slot_troop_leaded_party),
      (assign, "$g_move_heroes", 1),
      (call_script, "script_party_add_party", "p_main_party", ":companions_party"),
      (party_detach, ":companions_party"),
      (remove_party, ":companions_party"),
      (assign, "$g_leave_encounter",1)
      ]],

  [anyone ,"knight_join_party_lead_out", [], "Very well then.\
 I shall maintain a patrol of this area. Return if you have further orders for me.", "close_window",[
      (call_script, "script_recruit_troop_as_companion", "$g_talk_troop"),
      (party_remove_members, "p_main_party", "$g_talk_troop", 1),
      
      (troop_get_slot, ":companions_party","$g_talk_troop", slot_troop_leaded_party),
      (party_set_faction, ":companions_party", "fac_player_supporters_faction"),
      (party_detach, ":companions_party"),
      (party_set_ai_behavior, ":companions_party", ai_bhvr_patrol_location),
      (party_set_flags, ":companions_party", pf_default_behavior, 0),
      ]],

  [anyone,"lord_enter_service_reject", [
     (eq, "$players_kingdom", "fac_player_supporters_faction"),
  ], "Indeed.... Did you offer vassalage, then, just to by time? Very well -- you shall have time to reconsider, but if you are toying with me, it will do your reputation no credit.", "close_window",
   [
     (assign, "$g_leave_encounter", 1),
    ]],	  
	  
  [anyone,"lord_give_oath_give_up", [
     (eq, "$players_kingdom", "fac_player_supporters_faction"),
  ], "Indeed.... Did you offer vassalage, then, just to buy time? Very well -- you shall have time to reconsider, but if you are toying with me, it will do your reputation no credit.", "close_window",
   [
     (assign, "$g_leave_encounter", 1),
    ]],	  
	  
	  

  [anyone,"lord_enter_service_reject", [], "What pigswill!\
 And to think I would offer you a place among my nobles. Begone, beggar, before I lose my temper!", "close_window",
   [
     (try_begin),
       (store_partner_quest, ":lords_quest"),
       (eq, ":lords_quest", "qst_join_faction"),
       (call_script, "script_abort_quest", "qst_join_faction", 1),
     (try_end),
     (assign, "$g_invite_faction", 0),
     (assign, "$g_invite_faction_lord", 0),
     (assign, "$g_invite_offered_center", 0),
     (assign, "$g_leave_encounter", 1),
    ]],

  [anyone,"lord_ask_enter_service", [(gt, "$players_kingdom", 0),
                                     (neq, "$players_kingdom", "$g_talk_troop_faction"),
                                     (faction_get_slot, ":players_lord", "$players_kingdom", slot_faction_leader),
                                     (neq, ":players_lord", "trp_player"),
                                     (str_store_troop_name, s5, ":players_lord"),
                                     ], "You are already oath-bound to serve {s5}, are you not?", "lord_give_oath_under_oath_already",[]],
  [anyone|plyr ,"lord_give_oath_under_oath_already", [], "Indeed I am, {s65}. Forgive my rambling.", "lord_pretalk",[]],

  [anyone,"lord_ask_enter_service", [(lt, "$g_talk_troop_effective_relation", -5)], "I accept oaths only from those I can trust to keep them, {playername}.", "lord_pretalk",[]],

  [anyone,"lord_ask_enter_service", [
  (troop_get_type, ":type", "trp_player"),
  (eq, ":type", 1),
  
  
  (try_for_range, ":center", centers_begin, centers_end),
	(party_slot_eq, ":center", slot_town_lord, "trp_player"),
    (assign, "$bypass_female_vassal_explanation", 1),
  (try_end),
  (eq, "$bypass_female_vassal_explanation", 0),
  
#  (troop_get_slot, ":husband", "trp_player", slot_troop_spouse),
  ], "My lady, you seem to have the makings of a good war leader. For a woman to show such skill is an uncommon thing in Calradia, but not completely without precedent. Noblewomen have often taken command of armies after their husbands or fathers were slain or captured, for example.", "lord_ask_enter_service_female_2",[
  (assign, "$bypass_female_vassal_explanation", 1),

  ]],
  
  [anyone,"lord_ask_enter_service_female_2", [
  ], "However, I have never heard of a king who granted a fief to a woman, no matter how valorous, simply because he needed an extra vassal. Were I to do such a thing, I would raise eyebrows across Calradia. Men would say that I was besotted or bewitched, or that I aimed to overturn the natural order of things. As much as I regret it, I cannot afford to grant you a fief.", "lord_ask_enter_service_female_response",[]],

  [anyone|plyr, "lord_ask_enter_service_female_response", [],
  "What if I were to take one of your enemy's castles by force?", "lord_ask_enter_service_female_solution_capture", []],
  
  [anyone|plyr, "lord_ask_enter_service_female_response", [
  (neg|troop_slot_ge, "trp_player", slot_troop_spouse, active_npcs_begin),
  ],
  "What if I were to marry one of your lords?", "lord_ask_enter_service_female_solution_marriage", []],
  
  [anyone|plyr, "lord_ask_enter_service_female_response", [],
  "Perhaps one of your competitors will prove to be more open-minded.", "lord_ask_enter_service_female_solution_competitor", []],

  [anyone|plyr, "lord_ask_enter_service_female_response", [],
  "I would be willing to fight for you, even without the fief.", "lord_ask_enter_service", []],
   
  [anyone|plyr, "lord_ask_enter_service_female_response", [],
  "Never mind.", "lord_pretalk", []],

  [anyone,"lord_ask_enter_service_female_solution_marriage", [
  ], "Well, I still would not be willing to grant you any fiefs. However, you would no doubt have the use of your husband's properties, which would allow you to act as one of my vassals in all but name. Did you have an other questions?", "lord_ask_enter_service_female_response",[]],
  
  [anyone,"lord_ask_enter_service_female_solution_competitor", [
  ], "Oh, perhaps you might find someone who was truly desperate -- but then, I would think, they would not have many fiefs to bestow. Did you have an other questions?", "lord_ask_enter_service_female_response",[]],

    [anyone,"lord_ask_enter_service_female_solution_capture", [
  ], "Well, in that case, depending on the circumstances, I might be inclined to let you keep it. Did you have an other questions?", "lord_ask_enter_service_female_response",[]],
  

    [anyone,"lord_ask_enter_service",
   [
     (assign, "$g_invite_offered_center", -1),
     (troop_get_slot, ":renown", "trp_player", slot_troop_renown),
     (store_mul, ":vassal_potential", "$g_talk_troop_effective_relation", 5),
     (val_add, ":vassal_potential", ":renown"),
     (call_script, "script_get_number_of_hero_centers", "trp_player"),
     (assign, ":num_centers_owned", reg0),
     (store_mul, ":center_affect", ":num_centers_owned", 50),
     (val_add, ":vassal_potential", ":center_affect"),
     (ge, ":vassal_potential", 150),
     (try_begin),
	   (troop_get_type, ":is_female", "trp_player"),
	   (eq, ":is_female", 0),
       (eq, ":num_centers_owned", 0),
       (call_script, "script_get_poorest_village_of_faction", "$g_talk_troop_faction"),
       (gt, reg0, 0),
       (assign, "$g_invite_offered_center", reg0),
     (try_end),
     ],
   "You are known as a brave {man-at-arms/warrior} and a fine leader of men, {playername}.\
 I shall be pleased to accept your sword into my service and bestow vassalage upon you,\
 if you are ready to swear homage to me.", "lord_give_oath_1",[]],

  [anyone,"lord_ask_enter_service", [], "You've yet to show yourself as a competent commander, {playername}.\
 Take your sword to my enemies and prove to me that you are worthy of becoming my vassal.\
 Then we may speak more of this.", "lord_pretalk",[]],

  [anyone|plyr,"lord_give_oath_1", [],  "I am ready, {s65}.", "lord_give_oath_2", []],
  [anyone|plyr,"lord_give_oath_1", [],  "Forgive me, {s65}, I must give the matter more thought first...", "lord_give_oath_give_up", []],

  [anyone,"lord_give_oath_give_up", [
  (troop_get_type, ":type", "trp_player"),
  (eq, ":type", 1),
  ],  "Take whatever time you need, my lady.", "lord_pretalk", []],

  [anyone,"lord_give_oath_give_up", [],  "What are you playing at, {playername}? Go and make up your mind, and stop wasting my time.", "close_window", [(assign, "$g_leave_encounter",1)]],
  [anyone,"lord_give_oath_2", [],  "Good. Then repeat the words of the oath with me: I swear homage to you as lawful ruler of the {s41}.", "lord_give_oath_3", [
            (str_store_faction_name, 41, "$g_talk_troop_faction"),
            (try_begin),
                (is_between, "$g_talk_troop", pretenders_begin, pretenders_end),
				(neg|troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_hero),
				
                (troop_get_slot, ":rebel_faction", "$g_talk_troop", slot_troop_original_faction),
                (str_store_faction_name, 41, ":rebel_faction"),
            (try_end),
      ]],

  [anyone|plyr,"lord_give_oath_3", [],  "I pledge homage to you as lawful ruler of the {s41}.", "lord_give_oath_4", []],
  [anyone|plyr,"lord_give_oath_3", [],  "Excuse me, {reg65?my lady:sir}. But I feel I need to think about this.", "lord_give_oath_give_up", []],

  [anyone,"lord_give_oath_4", [],  "I will remain as your loyal and devoted {man/follower} as long as my breath remains....", "lord_give_oath_5", []],

  [anyone|plyr,"lord_give_oath_5", [],  "I will remain as your loyal and devoted {man/follower} as long as my breath remains...", "lord_give_oath_6", []],
  [anyone|plyr,"lord_give_oath_5", [],  "{reg65?My lady:Sir}, may I ask for some time to think about this?", "lord_give_oath_give_up", []],

  [anyone,"lord_give_oath_6", [],  "...and I will be at your side to fight your enemies should you need my sword.", "lord_give_oath_7", []],

  [anyone|plyr,"lord_give_oath_7", [],  "...and I will be at your side to fight your enemies should you need my sword.", "lord_give_oath_8", []],
  [anyone|plyr,"lord_give_oath_7", [],  "{reg65?My lady:My lord}, please give me more time to think about this.", "lord_give_oath_give_up", []],

  [anyone,"lord_give_oath_8", [],  "Finally, I will uphold your lawful claims and those of your legitimate heirs.", "lord_give_oath_9", []],

  [anyone|plyr,"lord_give_oath_9", [],  "Finally, I will uphold your lawful claims and those of your legitimate heirs.", "lord_give_oath_10", []],
  [anyone|plyr,"lord_give_oath_9", [],  "{reg65?My lady:Sir}, I must have more time to consider this.", "lord_give_oath_give_up", []],

  [anyone,"lord_give_oath_10", [],  "Very well. You have given me your solemn oath, {playername}. May you uphold it always, with proper courage and devotion.", "lord_give_oath_go_on_2", []],

  [anyone,"lord_give_oath_go_on_2",
   [
     (assign, reg1, 1),
     (try_begin),
       (le, "$g_invite_offered_center", 0),
       (assign, reg1, 0),
     (else_try),
       (str_store_party_name, s1, "$g_invite_offered_center"),
     (try_end),
     ],
   "Let it be known that from this day forward, you are my sworn {man/follower} and vassal.\
 I give you my protection and grant you the right to bear arms in my name, and I pledge that I shall not deprive you of your life, liberty or properties except by the lawful judgment of your peers or by the law and custom of the land.{reg1? Furthermore I give you the fief of {s1} with all its rents and revenues.:}", "lord_give_oath_go_on_3", []],

  [anyone,"lord_give_oath_go_on_3",
   [
     ],

   "You have done a wise thing, {playername}. Serve me well and I promise, you will rise high.", "lord_give_conclude", []],


  
##  [anyone,"lord_give_oath_go_on_2", [],  "Then let it be know that from now on, you are my sworn {man/follower}.\
## I give you my protection and grant you the right to bear arms in my name.\
## You have done wisely {playername}. Serve me well and I promise, you will rise high.", "lord_give_oath_5", []],
  
#  [anyone,"lord_ask_enter_service", [(lt, "$g_talk_troop_relation", 10),
#                                     (store_character_level, ":player_level", "trp_player"),
#                                     (lt, ":player_level", 10),
#                                     ], "I know not much about you. Keep serving me {playername}. Prove your loyality, then I will know I can trust you and accept your oath.", "lord_pretalk",[]],

##  [anyone,"lord_ask_enter_service", [], "What kind of oath are you willing to make?", "lord_oath_what_kind",[]],
##
##  [anyone|plyr ,"lord_oath_what_kind", [], "I will give you my oath to serve you for two months.", "lord_oath_what_kind_2",[(assign, "$temp", 60)]],
##  [anyone|plyr ,"lord_oath_what_kind", [], "I will give you my oath to serve you for three months.", "lord_oath_what_kind_2",[(assign, "$temp", 90)]],
##  [anyone|plyr ,"lord_oath_what_kind", [], "I will give you my oath to serve you for six months.", "lord_oath_what_kind_2",[(assign, "$temp", 180)]],
##  [anyone|plyr ,"lord_oath_what_kind", [], "I will give you my oath to serve you indefinitely.", "lord_oath_what_kind_2",[(assign, "$temp", 720)]],
##  [anyone|plyr ,"lord_oath_what_kind", [], "Maybe I should give more thought to this, my lord.", "lord_oath_what_kind_cancel",[]],
##  [anyone ,"lord_oath_what_kind_cancel", [], "What nonsense is this? Now go make up your mind and stop wasting my time.", "close_window",[]],
##
##  [anyone, "lord_oath_what_kind_2", [], "Hmmm. Do you ask for anything in return?", "lord_oath_what_do_you_want",[]],
##  
##  [anyone|plyr, "lord_oath_what_do_you_want", [], "I ask for nothing but your blessing, my lord.", "lord_oath_consider",[(assign,"$temp2",0)]],
##  [anyone|plyr, "lord_oath_what_do_you_want", [], "I only ask for the right to have my own banner, my lord.", "lord_oath_consider",[(assign,"$temp2",1)]],
##  [anyone|plyr, "lord_oath_what_do_you_want", [], "I just ask for the right to hold one castle, my lord.", "lord_oath_consider",[(assign,"$temp2",2)]],
##  [anyone|plyr, "lord_oath_what_do_you_want", [], "I ask for the right to hold two castles, my lord.", "lord_oath_consider",[(assign,"$temp2",4)]],
##  [anyone|plyr, "lord_oath_what_do_you_want", [], "I ask for the right to hold three castles, my lord.", "lord_oath_consider",[(assign,"$temp2",6)]],
##  [anyone|plyr ,"lord_oath_what_do_you_want", [], "Maybe I should give more thought to this, my lord.", "lord_oath_what_kind_cancel",[]],
##  
##  [anyone ,"lord_oath_consider", [
##      (store_character_level, ":player_level", "trp_player"),
##      (store_mul, ":benefit", ":player_level", 5),
##      (val_add, ":benefit", "$temp"),
##      (val_add, ":benefit", "$g_talk_troop_relation"),
##      
##      (store_mul, ":cost", "$temp2", 100),
##      (lt, ":cost", ":benefit"),
##      ], "That is agreeable {playername}. Give me your oath now and I will accept you as my follower and offer you my protection.", "lord_give_oath_go_on",[]],
##
##  [anyone ,"lord_oath_consider", [], "Hmmm. What you ask for is not acceptible {playername}.", "close_window",[]],
##
##  [anyone|plyr,"lord_give_oath_go_on", [(eq, "$temp", 60)],  "I give you my oath lord, that I will remain in your service for two months.\
## During this time, I will be faithful to you,\
## I will not act in a way to cause you harm, and I will be at your side to fight your enemies should you need my sword.", "lord_give_oath_go_on_2", []],
##  [anyone|plyr,"lord_give_oath_go_on", [(eq, "$temp", 90)],  "I give you my oath lord, that I will remain in your service for three months.\
## During this time, I will be faithful to you,\
## I will not act in a way to cause you harm, and I will be at your side to fight your enemies should you need my sword.", "lord_give_oath_go_on_2", []],
##  [anyone|plyr,"lord_give_oath_go_on", [(eq, "$temp", 180)],  "I give you my oath lord, that I will remain in your service for six months.\
## During this time, I will be faithful to you,\
## I will not act in a way to cause you harm, and I will be at your side to fight your enemies should you need my sword.", "lord_give_oath_go_on_2", []],
##  [anyone|plyr,"lord_give_oath_go_on", [(gt, "$temp", 700)],  "I give you my oath lord, that I will remain as your loyal and devoted {man/follower} as long as my breath remains.\
## I will never act in a way to cause you harm, and I will be at your side to fight your enemies should you need my sword.", "lord_give_oath_go_on_2", []],
##  
##  [anyone,"lord_give_oath_go_on_2", [(eq,"$temp2",0)],  "Then let it be know that from now on, you are my sworn {man/follower}.\
## I give you my protection and grant you the right to bear arms in my name.\
## You have done wisely {playername}. Serve me well and I promise, you will rise high.", "lord_give_oath_5", []],
##
##  [anyone,"lord_give_oath_go_on_2", [(eq,"$temp2",1)],  "Then let it be know that from now on, you are my sworn {man/follower}.\
## I give you my protection and grant you the right to hold your own banner.\
## You have done wisely {playername}. Serve me well and I promise, you will rise high.", "lord_give_oath_5", []],
##  
##  [anyone,"lord_give_oath_go_on_2", [(eq,"$temp2",2)],  "Then let it be know that from now on, you are my sworn {man/follower} and vassal.\
## I give you my protection and grant you the right to hold a castle.\
## You have done wisely {playername}. Serve me well and I promise, you will rise high.", "lord_give_oath_5", []],
##
##  [anyone,"lord_give_oath_go_on_2", [(eq,"$temp2",4)],  "Then let it be know that from now on, you are my sworn {man/follower} and vassal.\
## I give you my protection and grant you the right to hold two castles.\
## You have done wisely {playername}. Serve me well and I promise, you will rise high.", "lord_give_oath_5", []],
##
##  [anyone,"lord_give_oath_go_on_2", [],  "Then let it be know that from now on, you are my sworn {man/follower} and vassal.\
## I give you my protection and grant you the right to hold three castles.\
## You have done wisely {playername}. Serve me well and I promise, you will rise high.", "lord_give_oath_5", []],

  [anyone|plyr,"lord_give_conclude", 
  [
    (troop_get_type, reg39, "$g_talk_troop"),
    (try_begin), #activate husband as pretender
      (troop_slot_eq, "$g_talk_troop", slot_troop_spouse, "trp_player"),
      (str_store_string, s41, "str_very_well__you_are_now_my_liege_as_well_as_my_husband"),
    (else_try),	#all other situations
      (str_store_string, s41, "str_i_thank_you_reg39my_ladylord"),
    (try_end),
  ],  "{s41}", "lord_give_conclude_2", 
  [
	#Pretender changes  
	(assign, ":is_pretender", 0),
    (try_begin),
      (this_or_next|is_between, "$g_talk_troop", pretenders_begin, pretenders_end),
      (troop_slot_eq, "$g_talk_troop", slot_troop_spouse, "trp_player"),
      (neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
      (assign, ":is_pretender", 1),
	  
      (assign, "$supported_pretender", "$g_talk_troop"),
      (troop_get_slot, "$supported_pretender_old_faction", "$g_talk_troop", slot_troop_original_faction),
      (troop_set_faction, "$g_talk_troop", "fac_player_supporters_faction"),
      (faction_set_slot, "fac_player_supporters_faction", slot_faction_leader, "$g_talk_troop"),
      (assign, "$g_talk_troop_faction", "fac_player_supporters_faction"),

      (quest_set_slot, "qst_rebel_against_kingdom", slot_quest_giver_troop, "$g_talk_troop"),
      (quest_set_slot, "qst_rebel_against_kingdom", slot_quest_target_faction, "$supported_pretender_old_faction"),

      (str_store_faction_name_link, s14, "$supported_pretender_old_faction"),
      (str_store_troop_name_link, s13, "$g_talk_troop"),
      (setup_quest_text,"qst_rebel_against_kingdom"),
      (str_store_string, s2, "@You promised to help {s13} claim the throne of {s14}."),
      (call_script, "script_start_quest", "qst_rebel_against_kingdom", "$g_talk_troop"),
    (try_end),
            
	(try_begin),
		(eq, "$players_kingdom", "fac_player_supporters_faction"),
		(call_script, "script_deactivate_player_faction"),
		(try_for_range, ":npc", active_npcs_begin, active_npcs_end),
			(store_faction_of_troop, ":npc_faction", ":npc"),
			(eq, ":npc_faction", "fac_player_supporters_faction"),
			(troop_slot_eq, ":npc", slot_troop_occupation, slto_kingdom_hero),
			(call_script, "script_change_troop_faction", ":npc", "$g_talk_troop_faction"),
		(try_end),
	(try_end),
	  
    (try_begin),
      (is_between, "$players_oath_renounced_against_kingdom", kingdoms_begin, kingdoms_end),
      (neq, "$players_oath_renounced_against_kingdom", "$g_talk_troop_faction"),
      (store_relation, ":relation", "fac_player_supporters_faction", "$players_oath_renounced_against_kingdom"),
      (val_min, ":relation", -40),
      (call_script, "script_set_player_relation_with_faction", "$players_oath_renounced_against_kingdom", ":relation"),
      (call_script, "script_update_all_notes"),
      (assign, "$g_recalculate_ais", 1),
    (try_end),
        
    (try_begin),
      (is_between, "$players_kingdom", kingdoms_begin, kingdoms_end),
      (neq, "$players_kingdom", "fac_player_supporters_faction"),
	  (neq, "$players_kingdom", "$g_talk_troop_faction"), #ie, don't leave faction if the player is already part of the same kingdom
	  
      (faction_get_slot, ":old_leader", "$players_kingdom", slot_faction_leader),
      (call_script, "script_add_log_entry", logent_renounced_allegiance,   "trp_player",  -1, ":old_leader", "$players_kingdom"),
      (try_begin),
        (eq, ":is_pretender", 1),
        (call_script, "script_activate_player_faction", "$g_talk_troop"),
      (try_end),
      (call_script, "script_player_leave_faction", 0),
    (try_end),
        
    (call_script, "script_player_join_faction", "$g_talk_troop_faction"),
        
    (try_begin),
		(gt, "$g_invite_offered_center", 0),
		(call_script, "script_give_center_to_lord", "$g_invite_offered_center", "trp_player", 0),
		(try_begin),
			(faction_slot_eq, "$players_kingdom", slot_faction_political_issue, "$g_invite_offered_center"),
			(faction_set_slot, "$players_kingdom", slot_faction_political_issue, -1),
		(try_end),	  
    (try_end),
    (call_script, "script_add_log_entry", logent_pledged_allegiance,   "trp_player",  -1, "$g_talk_troop", "$g_talk_troop_faction"),
        
    (try_begin),
      (check_quest_active, "qst_join_faction"),
      (eq, "$g_invite_faction_lord", "$g_talk_troop"),
      (call_script, "script_end_quest", "qst_join_faction"),
    (else_try),
      (check_quest_active, "qst_join_faction"),
      (call_script, "script_abort_quest", "qst_join_faction", 0),
    (try_end),
    (assign, "$player_has_homage" ,1),
    (assign, "$g_player_banner_granted", 1),
    (assign, "$g_invite_faction", 0),
    (assign, "$g_invite_faction_lord", 0),
    (assign, "$g_invite_offered_center", 0),
    (assign, "$g_leave_encounter",1)]],

  [anyone,"lord_give_conclude_2", [
  (troop_slot_eq, "$g_talk_troop", slot_troop_spouse, "trp_player"),
  ],  "So be it, my wife. May all my vassals be as valiant and loyal as you.", "close_window", [(assign, "$g_leave_encounter",1)]],
	
  [anyone,"lord_give_conclude_2", [],  "I have great hopes for you {playername}.\
 I know you shall prove yourself worthy of the trust I have placed in you.", "close_window", [(assign, "$g_leave_encounter",1)]],

  

  [anyone,"lord_ask_enter_service", [(str_store_faction_name,5,"$g_talk_troop_faction")], "Heh, a wise move,\
 {playername}. With loyal service, a {man/woman} in my service could become wealthy and powerful,\
 and our enemies... Well, our enemies are as wheat before a scythe.\
 However, to enter my service you must first renounce all worldly oaths and bonds,\
 and swear to serve only the {s5}.", "lord_enter_service_swear",[]],
  [anyone|plyr ,"lord_enter_service_swear", [], "I do so swear, {s65}.", "lord_enter_service_swear_accepted",[]],
  [anyone|plyr ,"lord_enter_service_swear", [], "I need some time to think about this.", "lord_enter_service_swear_denied",[]],
  [anyone ,"lord_enter_service_swear_denied", [], "Are you having me on? I've no time for games, {playername}.\
 Make up your mind and stop wasting my time.", "close_window",[(assign, "$g_leave_encounter",1)]],

  [anyone ,"lord_enter_service_swear_accepted", [(str_store_faction_name,5,"$g_talk_troop_faction")],
 "Then it is my pleasure to welcome you to the service of my house. From this day on, {playername},\
 you are a soldier of the {s5} with all the duties and privileges that come with it.", "lord_enter_service_swear_accepted_2",
   [
   ]],

  [anyone ,"lord_enter_service_swear_accepted_2", [(str_store_faction_name,5,"$g_talk_troop_faction")],
 "I charge you with rooting out and destroying the forces of our enemies wherever you may find them.\
 Moreover, I will have special tasks for you from time to time, as may some of my other vassal lords.\
 Serve, fight, and honour your oaths. These things will take you far, if you've a mind for promotion.\
 May God grant us long lives and many victories to toast in my hall!", "close_window",[(assign, "$g_leave_encounter",1)]],

  [anyone,"lord_ask_leave_service", [(ge, "$g_talk_troop_relation", 1)], "Hrm.\
 Has your oath become burdensome, {playername}? It is unusual to request release from homage,\
 but in respect of your fine service, I will not hold you if you truly wish to end it.\
 Though you would be sorely missed.", "lord_ask_leave_service_verify",[]],
  [anyone,"lord_ask_leave_service", [], "Release from homage? Hmm, perhaps it would be for the best...\
 However, {playername}, you must be sure that release is what you desire. This is not a thing done lightly.", "lord_ask_leave_service_verify",[]],

  [anyone|plyr ,"lord_ask_leave_service_verify", [], "It is something I must do, {s65}.", "lord_ask_leave_service_2",[]],
  [anyone|plyr ,"lord_ask_leave_service_verify", [], "You are right, {s65}. My place is here.", "lord_ask_leave_service_giveup",[]],

  [anyone,"lord_ask_leave_service_giveup", [], "I am pleased to hear it, {playername}.\
 I hope you'll banish such unworthy thoughts from your mind from now on.", "lord_pretalk",[]],

  [anyone,"lord_ask_leave_service_2", [], "Then you are sure? Also, be aware that if you leave my services, you will be surrendering to me all the fiefs which you hold in my name.", "lord_ask_leave_service_verify_again",[]],
  [anyone|plyr ,"lord_ask_leave_service_verify_again", [], "Yes, {s65}.", "lord_ask_leave_service_3",[]],
  [anyone|plyr ,"lord_ask_leave_service_verify_again", [], "Of course not, {s65}. I am ever your loyal vassal.", "lord_ask_leave_service_giveup",[]],

  [anyone,"lord_ask_leave_service_3", [], "As you wish. I hereby declare your oaths to be null and void.\
 You will no longer hold land or titles in my name, and you are released from your duties to my house.\
 You are free, {playername}.", "lord_ask_leave_service_end",
   [
        (call_script, "script_add_log_entry", logent_renounced_allegiance,   "trp_player",  -1, "$g_talk_troop", "$g_talk_troop_faction"),
        (call_script, "script_player_leave_faction", 1), #1 means give back fiefs
    ]],

  [anyone|plyr ,"lord_ask_leave_service_end", [], "Thank you, sir. It was an honour to serve you..", "lord_ask_leave_service_end_2",[]],
  [anyone|plyr ,"lord_ask_leave_service_end", [], "My thanks. It feels good to be {a free man/free} once again.", "lord_ask_leave_service_end_2",[]],

  [anyone ,"lord_ask_leave_service_end_2", [], "Farewell then, {playername}, and good luck go with you.", "close_window",
   [(assign, "$g_leave_encounter", 1)]],

#Active quests
##### TODO: QUESTS COMMENT OUT BEGIN

  [anyone,"lord_active_mission_1", [(store_partner_quest,":lords_quest"),
                                    (eq,":lords_quest","qst_lend_companion"),
                                    #(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
                                    (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
                                    (check_quest_active,"qst_lend_companion"),
                                    (quest_slot_eq, "qst_lend_companion", slot_quest_giver_troop, "$g_talk_troop"),
                                    (store_current_day, ":cur_day"),
                                    (quest_get_slot, ":quest_target_amount", "qst_lend_companion", slot_quest_target_amount),
                                    (ge, ":cur_day", ":quest_target_amount"),
##                                    (quest_get_slot, ":quest_target_troop", "qst_lend_companion", slot_quest_target_troop),
##                                    (str_store_troop_name,s14,":quest_target_troop"),
##                                    (troop_get_type, reg3, ":quest_target_troop"),
                                    ],
   "Oh, you want your companion back? I see...", "lord_lend_companion_end",[]],




  [anyone,"lord_active_mission_1", [(store_partner_quest,":lords_quest"),
									(eq,":lords_quest","qst_lend_companion")],
   "{playername}, I must beg your patience, I still have need of your companion. Please return later when things have settled.", "lord_pretalk",[]],
   #default
  [anyone,"lord_active_mission_1", [], "Yes, have you made any progress on it?", "lord_active_mission_2",[]],

  [anyone|plyr,"lord_active_mission_2",[#(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
                            (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
                            (check_quest_active,"qst_capture_prisoners"),
                            (quest_slot_eq, "qst_capture_prisoners", slot_quest_giver_troop, "$g_talk_troop"),
                            (quest_get_slot, ":quest_target_amount", "qst_capture_prisoners", slot_quest_target_amount),
                            (quest_get_slot, ":quest_target_troop", "qst_capture_prisoners", slot_quest_target_troop),
                            (party_count_prisoners_of_type, ":count_prisoners", "p_main_party", ":quest_target_troop"),
                            (ge, ":count_prisoners", ":quest_target_amount"),
                            (assign, reg1, ":quest_target_amount"),
                            (str_store_troop_name_plural, s1, ":quest_target_troop")],
   "Indeed. I brought you {reg1} {s1} as prisoners.", "lord_generic_mission_thank",
   [(quest_get_slot, ":quest_target_amount", "qst_capture_prisoners", slot_quest_target_amount),
    (quest_get_slot, ":quest_target_troop", "qst_capture_prisoners", slot_quest_target_troop),
    (party_remove_prisoners, "p_main_party", ":quest_target_troop", ":quest_target_amount"),
    (party_add_prisoners, "$g_encountered_party", ":quest_target_troop", ":quest_target_amount"),
    (call_script, "script_finish_quest", "qst_capture_prisoners", 100)]],


  [anyone|plyr,"lord_active_mission_2",
   [
     #(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
     (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
     (store_partner_quest, ":lords_quest"),
     (eq, ":lords_quest", "qst_capture_enemy_hero"),
     (assign, ":has_prisoner", 0),
     (quest_get_slot, ":quest_target_faction", "qst_capture_enemy_hero", slot_quest_target_faction),
     (party_get_num_prisoner_stacks, ":num_stacks", "p_main_party"),
     (try_for_range, ":i_stack", 0, ":num_stacks"),
       (party_prisoner_stack_get_troop_id, ":stack_troop", "p_main_party", ":i_stack"),
       (troop_is_hero, ":stack_troop"),
       (store_troop_faction, ":stack_faction", ":stack_troop"),
       (eq, ":quest_target_faction", ":stack_faction"),
       (troop_slot_eq, ":stack_troop", slot_troop_occupation, slto_kingdom_hero),
       (assign, ":has_prisoner", 1),
       (quest_set_slot, "qst_capture_enemy_hero", slot_quest_target_troop, ":stack_troop"),
     (try_end),
     (eq, ":has_prisoner", 1),
     (str_store_faction_name, s13, ":quest_target_faction")
     ],
   "Oh, indeed. I've captured a lord from {s13} for you.", "capture_enemy_hero_thank",
   []],

  [anyone,"capture_enemy_hero_thank", [],
   "Many thanks, my friend. He will serve very well for a bargain. You've done a fine work here. Please accept these {reg5} denars for your help.", "capture_enemy_hero_thank_2",
   [(quest_get_slot, ":quest_target_troop", "qst_capture_enemy_hero", slot_quest_target_troop),
     (quest_get_slot, ":quest_target_faction", "qst_capture_enemy_hero", slot_quest_target_faction),
     (party_remove_prisoners, "p_main_party", ":quest_target_troop", 1),
     (store_relation, ":reln", "$g_encountered_party_faction", ":quest_target_faction"),
     (try_begin),
       (lt, ":reln", 0),
       (party_add_prisoners, "$g_encountered_party", ":quest_target_troop", 1), #Adding him to the dungeon
     (else_try),
       #Do not add a non-enemy lord to the dungeon (due to recent diplomatic changes or due to a neutral town/castle)
       #(troop_set_slot, ":quest_target_troop", slot_troop_is_prisoner, 0),
       (troop_set_slot, ":quest_target_troop", slot_troop_prisoner_of_party, -1),
     (try_end),
     (quest_get_slot, ":reward", "qst_capture_enemy_hero", slot_quest_gold_reward),
     (assign, reg5, ":reward"),
     (call_script, "script_troop_add_gold", "trp_player", ":reward"),
     (add_xp_as_reward, 2500),
     (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 4),
     (call_script, "script_end_quest", "qst_capture_enemy_hero"),
   ]],

  [anyone|plyr,"capture_enemy_hero_thank_2", [],
   "Certainly, {s65}.", "lord_pretalk",[]],
  [anyone|plyr,"capture_enemy_hero_thank_2", [],
   "It was nothing.", "lord_pretalk",[]],
  [anyone|plyr,"capture_enemy_hero_thank_2", [],
   "Give me more of a challenge next time.", "lord_pretalk",[]],

##
##  [anyone|plyr,"lord_active_mission_2", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                                         (store_partner_quest,":lords_quest"),
##                                         (eq,":lords_quest","qst_capture_messenger"),
##                                         (quest_get_slot, ":quest_target_troop", ":lords_quest", slot_quest_target_troop),
##                                         (quest_get_slot, ":quest_target_amount", ":lords_quest", slot_quest_target_amount),
##                                         (store_num_parties_destroyed_by_player, ":num_destroyed", "pt_messenger_party"),
##                                         (gt, ":num_destroyed", ":quest_target_amount"),
##                                         (party_count_prisoners_of_type, ":num_prisoners", "p_main_party", ":quest_target_troop"),
##                                         (ge, ":num_prisoners", 1),
##                                         (str_store_troop_name, 3, ":quest_target_troop")],
##   "Indeed sir. I have captured a {s3} my lord.", "lord_generic_mission_thank",[(quest_get_slot, ":quest_target_troop", "qst_capture_messenger", slot_quest_target_troop),
##                                                                     (party_remove_prisoners, "p_main_party", ":quest_target_troop", 1),
##                                                                     (party_add_prisoners, "$g_encountered_party", ":quest_target_troop", 1),#Adding him to the dungeon
##                                                                     (call_script, "script_finish_quest", "qst_capture_messenger", 100)]],
##  
##
  [anyone|plyr,"lord_active_mission_2", [#(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
										 (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
                                         (store_partner_quest,":lords_quest"),
                                         (eq,":lords_quest","qst_raise_troops"),
                                         (quest_get_slot, ":quest_target_troop", ":lords_quest", slot_quest_target_troop),
                                         (quest_get_slot, ":quest_target_amount", ":lords_quest", slot_quest_target_amount),
                                         (party_count_companions_of_type, ":num_companions", "p_main_party", ":quest_target_troop"),
                                         (ge, ":num_companions", ":quest_target_amount"),
                                         (assign, reg1, ":quest_target_amount"),
                                         (str_store_troop_name_plural, s13, ":quest_target_troop")],
   "Indeed. I have raised {reg1} {s13}. You can take them.", "lord_raise_troops_thank",[(quest_get_slot, ":quest_target_troop", "qst_raise_troops", slot_quest_target_troop),
                                                                                         (quest_get_slot, ":quest_target_amount", "qst_raise_troops", slot_quest_target_amount),
                                                                                         (call_script,"script_change_player_relation_with_troop","$g_talk_troop", 3),
                                                                                         (party_remove_members, "p_main_party", ":quest_target_troop", ":quest_target_amount"),
                                                                                         (call_script, "script_end_quest", "qst_raise_troops"),
                                                                                         (troop_get_slot, ":cur_lords_party", "$g_talk_troop", slot_troop_leaded_party),
                                                                                         (gt, ":cur_lords_party", 0),
                                                                                         (party_add_members, ":cur_lords_party", ":quest_target_troop", ":quest_target_amount"),
                                                                                         ]],

  [anyone,"lord_raise_troops_thank", [],
   "These men may well turn the tide in my plans, {playername}. I am confident you've trained them well. My thanks and my compliments to you.", "lord_raise_troops_thank_2",[]],

  [anyone|plyr,"lord_raise_troops_thank_2", [],
   "Well, the lads are at your command now, sir. I am sure you will take good care of them.", "lord_pretalk",[]],
  

  [anyone|plyr,"lord_active_mission_2", [#(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
									     (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),

#                                         (store_partner_quest,":lords_quest"),
#                                         (eq, ":lords_quest", "qst_collect_taxes"),
										  (check_quest_active, "qst_collect_taxes"),
										  (quest_slot_eq, "qst_collect_taxes", slot_quest_giver_troop, "$g_talk_troop"),

                                         (check_quest_succeeded, "qst_collect_taxes"),
                                         (eq, "$qst_collect_taxes_halve_taxes", 0),
                                         (quest_get_slot, ":quest_gold_reward", "qst_collect_taxes", slot_quest_gold_reward),
                                         (store_mul, ":required_gold", ":quest_gold_reward", 8),
                                         (val_div, ":required_gold", 10),
                                         (store_troop_gold, ":gold", "trp_player"),
                                         (ge, ":gold", ":required_gold"),
                                         (assign, reg19, ":quest_gold_reward"),
                                         (quest_get_slot, ":quest_target_center", "qst_collect_taxes", slot_quest_target_center),
                                         (str_store_party_name, s3, ":quest_target_center"),
                                         ],
   "Here are all the taxes from {s3}. It comes up to {reg19} denars.", "lord_collect_taxes_success",
   []],

  [anyone|plyr,"lord_active_mission_2", [#(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
                                         (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
										  (check_quest_active, "qst_collect_taxes"),
										  (quest_slot_eq, "qst_collect_taxes", slot_quest_giver_troop, "$g_talk_troop"),
										 
#                                         (store_partner_quest,":lords_quest"),
#                                         (eq, ":lords_quest", "qst_collect_taxes"),
                                         (check_quest_succeeded, "qst_collect_taxes"),
                                         (eq, "$qst_collect_taxes_halve_taxes", 1),
                                         (quest_get_slot, ":quest_gold_reward", "qst_collect_taxes", slot_quest_gold_reward),
                                         (store_mul, ":required_gold", ":quest_gold_reward", 95),
                                         (val_div, ":required_gold", 100),
                                         (store_troop_gold, ":gold", "trp_player"),
                                         (ge, ":gold", ":required_gold"),
                                         (assign, reg19, ":quest_gold_reward"),
                                         (quest_get_slot, ":quest_target_center", "qst_collect_taxes", slot_quest_target_center),
                                         (str_store_party_name, s3, ":quest_target_center"),
                                         ],
   "Here are the taxes from {s3}. It comes up to {reg19} denars.", "lord_collect_taxes_half_success",
   []],

  [anyone|plyr,"lord_active_mission_2", [#(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
										 (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
										  (check_quest_active, "qst_collect_taxes"),
										  (quest_slot_eq, "qst_collect_taxes", slot_quest_giver_troop, "$g_talk_troop"),
										 
#                                         (store_partner_quest,":lords_quest"),
#                                         (eq, ":lords_quest", "qst_collect_taxes"),
                                         (check_quest_failed, "qst_collect_taxes"),
                                         (quest_get_slot, ":quest_gold_reward", "qst_collect_taxes", slot_quest_gold_reward),
                                         (store_troop_gold, ":gold", "trp_player"),
                                         (ge, ":gold", ":quest_gold_reward"),
                                         (assign, reg19, ":quest_gold_reward"),
                                         (quest_get_slot, ":quest_target_center", "qst_collect_taxes", slot_quest_target_center),
                                         (str_store_party_name, s3, ":quest_target_center"),
                                         ],
   "Unfortunately, a revolt broke up while I was collecting the taxes.\
 I could only collect {reg19} denars.", "lord_collect_taxes_fail",
   []],

  [anyone,"lord_collect_taxes_success", [(quest_get_slot, ":total_revenue", "qst_collect_taxes", slot_quest_gold_reward),
                                         (store_mul, ":owner_share", ":total_revenue", 8),
                                         (val_div, ":owner_share", 10),
                                         (assign, reg20, ":owner_share"),
                                         (store_sub, reg21, ":total_revenue", ":owner_share")],
   "Well done, {playername}, very well done indeed! You were truly the right {man/person} for the job.\
 I promised you a fifth of the taxes, so that amounts to {reg21} denars.\
 If you give me {reg20} denars, you may keep the difference.\
 A good result for everyone, eh?", "lord_pretalk",
   [
    (troop_remove_gold, "trp_player", reg20),
    (quest_set_slot, "qst_collect_taxes", slot_quest_gold_reward, 0),
    (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 2),
    (call_script, "script_end_quest", "qst_collect_taxes"),
    ]],


  [anyone,"lord_collect_taxes_half_success", [(quest_get_slot, ":gold_reward", "qst_collect_taxes", slot_quest_gold_reward),
                                         (val_mul, ":gold_reward", 95),
                                         (val_div, ":gold_reward", 100),
                                         (assign, reg20, ":gold_reward")],
   "What?! Is this some scheme of yours, {playername}? That's less than half the taxes I'm owed!\
 You have let them get away with murder as well as my money. What a farce!\
 You can forget the money I promised you, I'm taking {reg20} denars from what you collected,\
 and you're lucky I'm leaving you a few coins for honour's sake.", "lord_pretalk",
   [(troop_remove_gold, "trp_player", reg20),
    (quest_set_slot, "qst_collect_taxes", slot_quest_gold_reward, 0),
    (call_script, "script_end_quest", "qst_collect_taxes"),
    ]],


  [anyone,"lord_collect_taxes_fail", [],
   "God, what a bloody mess you've gotten us into, {playername}.\
This could turn very ugly if I do not take immediate action.\
I certainly hope you're not here expecting to be paid for failure.\
Hand over my {reg19} denars, if you please, and end our business together.", "lord_pretalk",
   [(call_script, "script_change_player_relation_with_troop", "$g_talk_troop", -1),
    (quest_get_slot, ":gold_reward", "qst_collect_taxes", slot_quest_gold_reward),
    (troop_remove_gold, "trp_player", ":gold_reward"),
    (quest_set_slot, "qst_collect_taxes", slot_quest_gold_reward, 0),
    (call_script, "script_end_quest", "qst_collect_taxes"),
    ]],

  [anyone|plyr,"lord_active_mission_2", [ (check_quest_active, "qst_hunt_down_fugitive"),
										  (quest_slot_eq, "qst_hunt_down_fugitive", slot_quest_giver_troop, "$g_talk_troop"),

                                         (check_quest_succeeded, "qst_hunt_down_fugitive"),
                                         (quest_get_slot, ":quest_target_center", "qst_hunt_down_fugitive", slot_quest_target_center),
                                         (str_store_party_name, s3, ":quest_target_center"),
                                         (quest_get_slot, ":quest_target_dna", "qst_hunt_down_fugitive", slot_quest_target_dna),
                                         (call_script, "script_get_name_from_dna_to_s50", ":quest_target_dna"),
                                         (str_store_string, s4, s50),],
   "I found {s4} hiding at {s3} and gave him his punishment.", "lord_hunt_down_fugitive_success",
   []],

  [anyone|plyr,"lord_active_mission_2", [
										(check_quest_active, "qst_hunt_down_fugitive"),
										(quest_slot_eq, "qst_hunt_down_fugitive", slot_quest_giver_troop, "$g_talk_troop"),
  
                                         (check_quest_failed, "qst_hunt_down_fugitive"),
                                         ],
   "I'm afraid he got away.", "lord_hunt_down_fugitive_fail",
   []],

  [anyone,"lord_hunt_down_fugitive_success", [],
   "And we'll all be a lot better off without him! Thank you, {playername},\
 for removing this long-festering thorn from my side. 'Tis good to know you can be trusted to handle things\
 with an appropriate level of tactfulness.\
 A bounty I promised, and a bounty you shall have. 300 denars and not a copper less!", "lord_hunt_down_fugitive_success_2",
   [
     (add_xp_as_reward, 300),
    ]],
  
  [anyone|plyr,"lord_hunt_down_fugitive_success_2", [],
   "Let me take the money, {s65}. Thank you.", "lord_hunt_down_fugitive_reward_accept",[]],
  [anyone|plyr,"lord_hunt_down_fugitive_success_2", [],
   "This is blood money. I can't accept it.", "lord_hunt_down_fugitive_reward_reject",[]],

#Post 0907 changes begin
  [anyone,"lord_hunt_down_fugitive_reward_accept", [],
   "Of course, {playername}. Here you are. Once again, you've my thanks for ridding me of that {s43}.", "lord_pretalk",[
		(call_script, "script_lord_comment_to_s43", "$g_talk_troop", "str_lord_insult_default"),

		(call_script, "script_troop_add_gold", "trp_player", 300),
		(call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 1),
		(call_script, "script_end_quest", "qst_hunt_down_fugitive"),
		]],

  [anyone,"lord_hunt_down_fugitive_reward_reject", [],
   "You are a {man/woman} for whom justice is its own reward, eh? As you wish it, {playername}, as you wish it.\
 An honourable sentiment, to be true. Regardless, you've my thanks for ridding me of that {s43}.", "lord_pretalk",[

 		(call_script, "script_lord_comment_to_s43", "$g_talk_troop", "str_lord_insult_default"),

       
       (call_script, "script_change_player_honor", 3),
       (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 1),
       (call_script, "script_end_quest", "qst_hunt_down_fugitive"),
       ]],

  [anyone,"lord_hunt_down_fugitive_fail", [],
   "It is a sad day when that {s43} manages to avoid the hand of justice yet again.\
 I thought you would be able to do this, {playername}. Clearly I was wrong.", "lord_pretalk",
   [
 	(call_script, "script_lord_comment_to_s43", "$g_talk_troop", "str_lord_insult_default"),

    (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", -1),
    (call_script, "script_end_quest", "qst_hunt_down_fugitive"),
    ]],
#Post 0907 changes end



##
##
##  [anyone|plyr,"lord_active_mission_2", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                                         (store_partner_quest,":lords_quest"),
##                                         (eq,":lords_quest","qst_bring_back_deserters"),
##                                         (quest_get_slot, ":quest_target_troop", ":lords_quest", slot_quest_target_troop),
##                                         (quest_get_slot, ":quest_target_amount", ":lords_quest", slot_quest_target_amount),
##                                         (party_count_prisoners_of_type, ":num_prisoners", "p_main_party", ":quest_target_troop"),
##                                         (ge, ":num_prisoners", ":quest_target_amount"),
##                                         (assign, reg1, ":quest_target_amount")],
##   "Yes sir. I have brought {reg1} deserters as you asked me to.", "lord_generic_mission_thank",[(quest_get_slot, ":quest_target_troop", "qst_bring_back_deserters", slot_quest_target_troop),
##                                                                                     (quest_get_slot, ":quest_target_amount", "qst_bring_back_deserters", slot_quest_target_amount),
##                                                                                     (party_remove_prisoners, "p_main_party", ":quest_target_troop", ":quest_target_amount"),
##                                                                                     (faction_get_slot, ":faction_tier_2_troop", "$g_talk_troop_faction", slot_faction_tier_2_troop),
##                                                                                     (try_begin),
##                                                                                       (gt, ":faction_tier_2_troop", 0),
##                                                                                       (troop_get_slot, ":cur_lords_party", "$g_talk_troop", slot_troop_leaded_party),
##                                                                                       (gt, ":cur_lords_party", 0),
##                                                                                       (party_add_members, ":cur_lords_party", ":faction_tier_2_troop", ":quest_target_amount"),
##                                                                                     (try_end),
##                                                                                     (call_script, "script_finish_quest", "qst_bring_back_deserters", 100)]],
## 
##
##### TODO: QUESTS COMMENT OUT END
  [anyone|plyr,"lord_active_mission_2", [], "I am still working on it.", "lord_active_mission_3",[]],
  [anyone|plyr,"lord_active_mission_2", [], "I am afraid I won't be able to do this quest.", "lord_mission_failed",[]],
                                                                                                                                                   
  [anyone,"lord_active_mission_3", [], "Good. Remember, I am counting on you.", "lord_pretalk",[]],
  
  
  
  
#Post 0907 changes begin
  [anyone,"lord_mission_failed", [], "{s43}", "lord_pretalk",
   [
    (call_script, "script_lord_comment_to_s43", "$g_talk_troop", "str_lord_mission_failed_default"),
    (store_partner_quest,":lords_quest"),
    (call_script, "script_abort_quest", ":lords_quest", 1)]],
#Post 0907 changes end
  

#Claim center
##  [anyone,"lord_claim_center_begin", [],
##   "What do you want to do with {s4}?", "lord_claim_center_ask",[]],
##
##  [anyone|plyr,"lord_claim_center_ask", [],
##   "I want to claim it for myself.", "lord_claim_center_2",[]],
##  [anyone|plyr,"lord_claim_center_ask", [],
##   "I will leave it to you my lord. I have no interest in holding {s4}.", "lord_claim_center_leave_to_lord",[]],


##  [anyone,"lord_claim_center_2", [(eq, "$g_player_permitted_castles", 0),],
##   "You are an able warrior {playername} and there is no question of your bravery.\
## Alas, you are not noble born, and there are those who will be upset if I allow you to hold a castle.\
## So, it saddens me but I must decline your request.", "lord_claim_center_deny", []],
##  
##  [anyone|plyr,"lord_claim_center_deny", [],
##   "This is not fair my lord. I shed my blood to take {s4}. Now another {man/master} will rule over it.", "lord_claim_center_deny_2", []],
##  [anyone|plyr,"lord_claim_center_deny", [],
##   "I understand sir. Do as you will.", "lord_claim_center_leave_to_lord", []],
##  [anyone,"lord_claim_center_deny_2", [],
##   "Remember that you gave me your oath {playername}. And you agreed to do as told.", "lord_claim_center_deny_3", []],
##  [anyone,"lord_claim_center_deny_3", [],
##   "Yes sir.", "lord_claim_center_leave_to_lord", []],
##
##  [anyone,"lord_claim_center_leave_to_lord", [],
##   "Very well.  Then I will find a suitable master for {s4}.\
## In recognition of your bravery and service, I give you these 5000 denars.", "lord_pretalk",
##   [(troop_get_slot, ":wealth", "$g_talk_troop", slot_troop_wealth),
##    (val_sub, ":wealth", 6000),
##    (troop_set_slot, "$g_talk_troop", slot_troop_wealth, ":wealth"),
##    (call_script, "script_troop_add_gold", "trp_player", 5000),
##
##    (assign, ":new_master", "$g_talk_troop"),
##    (assign, ":max_wealth", 0),
##
##    (try_for_range, ":hero_no", kingdom_heroes_begin, kingdom_heroes_end),
##      (troop_slot_eq, ":hero_no", slot_troop_is_prisoner, 0),
##      (troop_slot_eq, ":hero_no", slot_troop_occupation, slto_kingdom_hero),
##      (store_troop_faction, ":hero_faction", ":hero_no"),
##      (eq, ":hero_faction", "$players_kingdom"),
##      (call_script, "script_get_number_of_hero_centers", "$g_talk_troop"),
##      (assign, ":no_of_owned_centers", reg0),
##      (neg|faction_slot_eq, "$players_kingdom", slot_faction_leader, ":hero_no"),
##      (lt, ":no_of_owned_centers", 2),
##      (troop_get_slot, ":wealth", "$g_talk_troop", slot_troop_wealth),
##      (ge, ":wealth", ":max_wealth"),
##      (assign, ":new_master", ":hero_no"),
##      (assign, ":max_wealth", ":wealth"),
##    (try_end),
##
##    (call_script, "script_give_center_to_lord", "$center_to_be_claimed", ":new_master"),
##    (set_spawn_radius, 1),
##    (spawn_around_party, "$center_to_be_claimed", "pt_old_garrison"),
##    (assign, ":new_party", reg0),
##    (party_set_ai_behavior, ":new_party", ai_bhvr_attack_party),
##    (party_set_ai_object, ":new_party", "p_main_party"),
##    (party_set_flags, ":new_party", pf_default_behavior, 0),
##    (call_script, "script_party_copy", ":new_party", "$center_to_be_claimed"),
##    (party_clear, "$center_to_be_claimed"),
##
##    (faction_get_slot, ":reinforcement_template_a", "$g_talk_troop_faction", slot_faction_reinforcements_a),
##    (faction_get_slot, ":reinforcement_template_b", "$g_talk_troop_faction", slot_faction_reinforcements_b),
##    (party_add_template, "$center_to_be_claimed", ":reinforcement_template_a"),
##    (party_add_template, "$center_to_be_claimed", ":reinforcement_template_b"),
##    ]],
##  
##
##  [anyone,"lord_claim_center_2", [(assign, ":number_of_claimed_centers", 0),
##                                  (try_for_range, ":center_no", centers_begin, centers_end),
##                                    (party_slot_eq, ":center_no", slot_party_type, spt_castle),
##                                    (store_faction_of_party, ":faction_no", ":center_no"),
##                                    (eq, ":faction_no", "fac_player_supporters_faction"),
##                                    (party_slot_eq, ":center_no", slot_town_claimed_by_player, 1),
##                                    (val_add, ":number_of_claimed_centers", 1),
##                                  (try_end),
##                                  (lt, ":number_of_claimed_centers", "$g_player_permitted_castles"),
##                                  (assign, reg7, ":number_of_claimed_centers"),
##                                  ],
##   "I had promised you to defend your right to hold {reg7?a:another} castle {playername}. Now I honor that promise.\
## I can think of {no man finer than you/no one better than you} to be the {lord/lady} of {s4}.\
## Renew your oath to me now. Then I will be your liege,\
## and I'll support you and protect you against all those who oppose your claim.",
##  "lord_claim_center_give_oath",[]],
##
##                                    
##  [anyone|plyr,"lord_claim_center_give_oath", [],  "I give you my oath lord, I will forever be faithful to you,\
## I will never act in a way to cause you harm, and I will be at your side to fight your enemies should you need my sword.", "lord_claim_center_direct_3", []],
##  [anyone,"lord_claim_center_direct_3", [],  "You have given your oath of fealty {playername}. I accept your oath and give you the fief of {s4}.\
## Rule it wisely and protect it against our enemies.", "lord_claim_center_direct_4", [
##     (party_set_slot, "$center_to_be_claimed", slot_town_claimed_by_player, 1),
##     (call_script, "script_give_center_to_lord", "$center_to_be_claimed", "trp_player")]],
##  [anyone|plyr,"lord_claim_center_direct_4", [],  "I thank you lord.", "close_window", [(assign, "$g_leave_encounter",1)]],

#Ask for favor
##  [anyone,"lord_ask_for_favor_ask", [],
##   "What is it? I don't have time for personal requests.", "lord_ask_for_favor",[]],
##  [anyone,"lord_ask_for_favor_ask", [],
##   "Say it then. If it's something possible...", "lord_ask_for_favor",[]],
##
##  [anyone|plyr,"lord_ask_for_favor", [],
##   "Nothing my lord. It's not important.", "lord_pretalk",[]],
#Suggest action
  [anyone,"lord_suggest_action_ask", [],
   "{!}What do you suggest?", "lord_suggest_action",[]],

##  [anyone|plyr,"lord_suggest_action",
##   [(troop_get_type, ":is_female", "trp_player"),
##    (eq, ":is_female", 1),
##    (lt, "$talk_context", tc_siege_commander),
##    ],
##   "{!}CHEAT: I want to marry you! (1)", "lord_groom_vows",[]],

  [anyone|plyr,"lord_suggest_action", [],
   "{!}CHEAT: I want to join your faction.", "lord_suggest_join_faction",[]],
  [anyone,"lord_suggest_join_faction", [],
   "{!}Alright then.", "lord_give_oath_5",[]],

  [anyone|plyr,"lord_suggest_action", [],
   "{!}CHEAT: I want to know your leaded party ID.", "lord_suggest_learn_party_id",[]],
  [anyone,"lord_suggest_learn_party_id", [
  (assign, reg1, "$g_encountered_party"),
  (troop_get_slot, reg0, "$g_talk_troop", slot_troop_leaded_party)],
   "{!}It is {reg0}. Encountered party is {reg1}", "lord_pretalk",[]],

  [anyone|plyr,"lord_suggest_action", [],
   "{!}CHEAT: I want to know your AI initiative.", "lord_suggest_learn_ai_initiative",[]],
  [anyone,"lord_suggest_learn_ai_initiative", [(party_get_ai_initiative, reg0, "$g_encountered_party")],
   "{!}It is {reg0}.", "lord_pretalk",[]],


  [anyone|plyr,"lord_suggest_action", [(eq, "$players_kingdom", "$g_talk_troop_faction"),],
   "{!}CHEAT: I want to be your kingdom's marshall.", "lord_suggest_become_marshall",[]],
  [anyone,"lord_suggest_become_marshall", [],
   "{!}Alright then.", "lord_pretalk",
   [
     (faction_get_slot, ":old_marshall", "$g_talk_troop_faction", slot_faction_marshall),
        (try_begin),
          (ge, ":old_marshall", 0),
		  (troop_get_slot, ":old_marshall_party", ":old_marshall", slot_troop_leaded_party),
          (party_is_active, ":old_marshall_party"),
          (party_set_marshall, ":old_marshall_party", 0),
        (try_end),  
     
     (faction_set_slot, "$g_talk_troop_faction", slot_faction_marshall, "trp_player"),
     (faction_set_slot, "$g_talk_troop_faction", slot_faction_ai_state, sfai_default),
     (assign, "$g_recalculate_ais", 1),
   ]],

  [anyone|plyr,"lord_suggest_action", [(neq, "$talk_context", tc_siege_commander)],
   "{!}CHEAT: Let us attack an enemy town or castle.", "lord_suggest_attack_enemy_castle",[]],
  [anyone|plyr,"lord_suggest_action", [(neq, "$talk_context", tc_siege_commander)],
   "{!}CHEAT: Let us return back to a friendly town.", "lord_suggest_go_to_friendly_town",[]],
  [anyone|plyr,"lord_suggest_action", [(neq, "$talk_context", tc_siege_commander)],
   "{!}CHEAT: Let us attack an enemy war party.", "lord_suggest_attack_enemy_party",[]],
  [anyone|plyr,"lord_suggest_action", [(eq, "$talk_context", tc_siege_commander)],
   "{!}CHEAT: Let us lift this siege.", "lord_suggest_lift_siege",[]],
  [anyone|plyr,"lord_suggest_action", [(neq, "$talk_context", tc_siege_commander)],
   "{!}CHEAT: Follow me.", "lord_suggest_follow_me",[]],
  [anyone|plyr,"lord_suggest_action", [(neq, "$talk_context", tc_siege_commander)],
   "{!}CHEAT: Follow someone.", "lord_suggest_follow_other",[]],
  [anyone|plyr,"lord_suggest_action", [(neq, "$talk_context", tc_siege_commander)],
   "{!}CHEAT: Raid a village.", "lord_suggest_raid_village",[]],
  [anyone|plyr,"lord_suggest_action", [],
   "{!}CHEAT: Like me.", "lord_pretalk",[(call_script,"script_change_player_relation_with_troop","$g_talk_troop",20)]],

  [anyone,"lord_suggest_lift_siege", [],
   "{!}As you wish, {playername}.", "close_window",[(call_script, "script_party_set_ai_state", "$g_talk_troop_party", spai_undefined),
                                           (party_leave_cur_battle, "$g_talk_troop_party"),
                                           (assign, "$g_leave_encounter", 1)]],
  
  [anyone,"lord_suggest_go_to_friendly_town", [],
   "{!}Hmm. Which town or castle do you suggest we go to?", "lord_suggest_go_to_friendly_town2",[]],
  [anyone|plyr|repeat_for_parties,"lord_suggest_go_to_friendly_town2", [
                                                                       (store_repeat_object, ":center_no"),
                                                                       (this_or_next|party_slot_eq,":center_no",slot_party_type, spt_castle),
                                                                       (party_slot_eq,":center_no",slot_party_type, spt_town),
                                                                       (neq, ":center_no", "$g_encountered_party"),
                                                                       (store_faction_of_party, ":town_faction", ":center_no"),
                                                                       (eq, ":town_faction", "$g_talk_troop_faction"),
                                                                       (str_store_party_name, s1, ":center_no")],
   "{!}CHEAT: {s1}", "lord_suggest_go_to_friendly_town3",[(store_repeat_object, "$town_suggested_to_go_to")]],
  [anyone|plyr,"lord_suggest_go_to_friendly_town2", [],
   "{!}CHEAT: Never mind.", "lord_pretalk",[]],

  [anyone,"lord_suggest_go_to_friendly_town3", [(str_store_party_name, 1, "$town_suggested_to_go_to")],
   "{!}Very well, we go to {s1}.", "lord_pretalk",
   [
       (call_script, "script_party_set_ai_state", "$g_talk_troop_party", spai_holding_center, "$town_suggested_to_go_to"),
       ]],

  
  
  [anyone,"lord_suggest_attack_enemy_party", [],
   "{!}Hmm. Which party do you suggest we attack?", "lord_suggest_attack_enemy_party2",[]],
  [anyone|plyr|repeat_for_parties,"lord_suggest_attack_enemy_party2", [
                                                                       (store_repeat_object, ":party_no"),
                                                                       (party_slot_eq,":party_no",slot_party_type, spt_kingdom_hero_party),
                                                                       (party_is_active, ":party_no"),
                                                                       (store_faction_of_party, ":party_faction", ":party_no"),
                                                                       (store_relation, ":party_relation", ":party_faction", "$g_talk_troop_faction"),
                                                                       (le, ":party_relation", -10),
                                                                       (call_script, "script_get_closest_walled_center", ":party_no"),
                                                                       (assign, ":center_no", reg0),
                                                                       (str_store_party_name, s3, ":center_no"),
                                                                       (str_store_faction_name, s2, ":party_faction"),
                                                                       (str_store_party_name, s1, ":party_no")],
   "{!}CHEAT: {s1} of {s2} around {s3}", "lord_suggest_attack_enemy_party3",[(store_repeat_object, "$suggested_to_attack_party")]],
  [anyone|plyr,"lord_suggest_attack_enemy_party2", [],
   "{!}CHEAT: Never mind.", "lord_pretalk",[]],

  [anyone,"lord_suggest_attack_enemy_party3", [(str_store_party_name, 1, "$suggested_to_attack_party")],
   "{!}As you wish, we will attack {s1}.", "lord_pretalk",
   [
       (call_script, "script_party_set_ai_state", "$g_talk_troop_party", spai_engaging_army, "$suggested_to_attack_party"),
       ]],


##  [anyone,"lord_suggest_attack_enemy_castle", [(troop_get_slot, ":player_favor", "$g_talk_troop", slot_troop_player_favor),
##                                               (lt, ":player_favor", 20)],
##   "Hmm. No, I don't think that's a good idea.", "lord_pretalk",[]],

  [anyone,"lord_suggest_attack_enemy_castle", [],
   "{!}Hmm. Which one do you suggest we attack?", "lord_suggets_attack_enemy_castle2",[]],
  [anyone|plyr|repeat_for_parties,"lord_suggets_attack_enemy_castle2", [
                                                                       (store_repeat_object, ":center_no"),
                                                                       (this_or_next|party_slot_eq,":center_no",slot_party_type, spt_castle),
                                                                       (party_slot_eq,":center_no",slot_party_type, spt_town),
                                                                       (store_faction_of_party, ":town_faction", ":center_no"),
                                                                       (store_relation, ":town_relation", ":town_faction", "$g_talk_troop_faction"),
                                                                       (le, ":town_relation", -10),
                                                                       (str_store_faction_name, s2, ":town_faction"),
                                                                       (str_store_party_name, s1, ":center_no")],
   "{!}CHEAT: {s1} of {s2}", "lord_suggets_attack_enemy_castle3",[(store_repeat_object, "$suggested_to_attack_center")]],

  [anyone|plyr,"lord_suggets_attack_enemy_castle2", [],
   "{!}CHEAT: Never mind my lord.", "lord_pretalk",[]],

  [anyone,"lord_suggets_attack_enemy_castle3", [(str_store_party_name, 1, "$suggested_to_attack_center")],
   "That should be possible. Very well, we'll attack {s1}.", "lord_pretalk",
   [
       (call_script, "script_party_set_ai_state", "$g_talk_troop_party", spai_besieging_center, "$suggested_to_attack_center"),
       
       ]],

  [anyone,"lord_suggest_raid_village", [],
   "{!}Hmm. Which village do you suggest we attack?", "lord_suggest_raid_village_2",[]],
  [anyone|plyr|repeat_for_parties,"lord_suggest_raid_village_2", [
                                                                       (store_repeat_object, ":center_no"),
                                                                       (party_slot_eq,":center_no",slot_party_type, spt_village),
                                                                       (store_faction_of_party, ":town_faction", ":center_no"),
                                                                       (store_relation, ":town_relation", ":town_faction", "$g_talk_troop_faction"),
                                                                       (le, ":town_relation", -10),
                                                                       (str_store_faction_name, s2, ":town_faction"),
                                                                       (str_store_party_name, s1, ":center_no")],
   "{!}CHEAT: {s1} of {s2}", "lord_suggest_raid_village_3",[(store_repeat_object, "$suggested_to_attack_center")]],
  [anyone|plyr,"lord_suggest_raid_village_2", [],
   "{!}CHEAT: Never mind.", "lord_pretalk",[]],

  [anyone,"lord_suggest_raid_village_3", [(str_store_party_name, s1, "$suggested_to_attack_center")],
   "{!}That should be possible. Very well, we'll attack {s1}.", "lord_pretalk",
   [
     (call_script, "script_party_set_ai_state", "$g_talk_troop_party", spai_raiding_around_center, "$suggested_to_attack_center"),
   ]],


  [anyone,"lord_suggest_follow_me", [],
   "{!}Aye, I'll follow you.", "lord_pretalk",
   [
     (party_set_slot, "$g_talk_troop_party", slot_party_commander_party, "p_main_party"),
     #(call_script, "script_party_decide_next_ai_state_under_command", "$g_talk_troop_party")
     (call_script, "script_npc_decision_checklist_party_ai", "$g_talk_troop"), 
	 (call_script, "script_party_set_ai_state", "$g_talk_troop_party", reg0, reg1),
   ]],


  [anyone,"lord_suggest_follow_other", [],
   "{!}Who do you want me to follow?", "lord_suggest_follow_other_2",[]],
  [anyone|plyr|repeat_for_parties,"lord_suggest_follow_other_2", [
                                                                       (store_repeat_object, ":party_no"),
                                                                       (party_slot_eq,":party_no",slot_party_type, spt_kingdom_hero_party),
                                                                       (neq, ":party_no", "$g_talk_troop"),
                                                                       (store_faction_of_party, ":party_faction", ":party_no"),
                                                                       (eq, ":party_faction", "$g_talk_troop_faction"),
                                                                       (str_store_party_name, s1, ":party_no")],
   "{!}CHEAT: {s1}", "lord_suggest_follow_other_3",[(store_repeat_object, "$town_suggested_to_go_to")]],
  [anyone|plyr,"lord_suggest_follow_other_2", [],
   "{!}CHEAT: Never mind.", "lord_pretalk",[]],

  [anyone,"lord_suggest_follow_other_3", [(str_store_party_name, 1, "$town_suggested_to_go_to")],
   "{!}As you wish, I shall be accompanying {s1}.", "lord_pretalk",
   [
     (party_set_slot, "$g_talk_troop_party", slot_party_commander_party, "$town_suggested_to_go_to"),
     #(call_script, "script_party_decide_next_ai_state_under_command", "$g_talk_troop_party"),
     (call_script, "script_npc_decision_checklist_party_ai", "$g_talk_troop"), 
     (call_script, "script_party_set_ai_state", "$g_talk_troop_party", reg0, reg1),       
   ]],

  [anyone|plyr,"lord_suggest_action", [],
   "{!}CHEAT: Nothing, {s65}. It's not important.", "lord_pretalk",[]],


##### TODO: QUESTS COMMENT OUT BEGIN
#Request Mission

  [anyone|auto_proceed,"lord_request_mission_ask",
   [(eq, "$players_kingdom", 0),
    (ge, "$g_talk_troop_faction_relation", 0),
    (ge, "$g_talk_troop_relation", 0),
    (troop_slot_ge, "trp_player", slot_troop_renown, 30),
    (neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
    (faction_get_slot, ":last_offer_time", "$g_talk_troop_faction", slot_faction_last_mercenary_offer_time),

    (assign, ":num_enemies", 0),
    (try_for_range, ":faction_no", kingdoms_begin, kingdoms_end),
      (faction_slot_eq, "$g_talk_troop_faction", slot_faction_state, sfs_active),
      (store_relation, ":reln", "$g_talk_troop_faction", ":faction_no"),
      (lt, ":reln", 0),
      (val_add, ":num_enemies", 1),
    (try_end),
    (ge, ":num_enemies", 1),
    (store_current_hours, ":cur_hours"),
    (store_add,  ":week_past_last_offer_time", ":last_offer_time", 7 * 24),
    (val_add,  ":last_offer_time", 24),
    (ge, ":cur_hours", ":last_offer_time"),
    (store_random_in_range, ":rand", 0, 100),
    (this_or_next|lt, ":rand", 20),
		(ge, ":cur_hours", ":week_past_last_offer_time"),
		
		
	(troop_get_type, ":type", "trp_player"),
	(this_or_next|eq, ":type", 0),
	(this_or_next|troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_cunning),
		(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_goodnatured),
    ],
   "{!}Warning: This line should never display.", "lord_propose_mercenary",[(store_current_hours, ":cur_hours"),
                                  (faction_set_slot, "$g_talk_troop_faction", slot_faction_last_mercenary_offer_time,  ":cur_hours")]],

								  
								  
								  
								  
  [anyone,"lord_propose_mercenary", [(call_script, "script_party_calculate_strength", "p_main_party", 0),
                                     (assign, ":offer_value", reg0),
                                     (val_add, ":offer_value", 100),
                                     (call_script, "script_round_value", ":offer_value"),
                                     (assign, ":offer_value", reg0),
                                     (assign, "$temp", ":offer_value"),
                                     (faction_get_slot, ":faction_leader", "$g_talk_troop_faction", slot_faction_leader),
                                     (neq, ":faction_leader", "$g_talk_troop"),
                                     (str_store_faction_name, s9, "$g_talk_troop_faction"),
                                     (str_store_troop_name, s10, ":faction_leader"),

									 (troop_get_type, ":is_female", "trp_player"),
									 (try_begin),
										(eq, ":is_female", 3), #disabled
										(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_martial),
									    (str_store_string, s11, "str_now_some_might_say_that_women_have_no_business_leading_mercenary_companies_but_i_suspect_that_you_would_prove_them_wrong_what_do_you_say"),
									 (else_try), 	
									    (str_store_string, s11, "@What do you say to entering the service of {s9} as a mercenary captain?\
 I have no doubt that you would be up to the task."),
									 (try_end)
									 ],
  
   "As it happens, {playername}, I promised {s10} that I would hire a company of mercenaries for an upcoming campaign.\
","lord_mercenary_service", []],
  [anyone|plyr,"lord_mercenary_service", [], "I'm not interested, thank you.", "lord_mercenary_service_reject", []],
  [anyone|plyr,"lord_mercenary_service", [], "Aye, I'll join {s9}.", "lord_mercenary_service_accept", []],
  [anyone|plyr,"lord_mercenary_service", [], "I'm interested. Please tell me more.", "lord_mercenary_elaborate_pay", []],

  [anyone,"lord_mercenary_service_accept", [(str_store_faction_name, s9, "$g_talk_troop_faction")],
   "Perfect. Of course you shall have to make a formal declaration of allegiance,\
 and give your oath that you and your company will remain in service to {s9}\
 for a period of no less than one month.", "lord_mercenary_service_verify", []],
  [anyone|plyr,"lord_mercenary_service_verify", [], "As you wish. Your enemies are my enemies.", "lord_mercenary_service_verify_2", []],
  [anyone|plyr,"lord_mercenary_service_verify", [], "On second thought, forget it.", "lord_mercenary_service_reject", []],

  [anyone,"lord_mercenary_service_verify_2", [], "That will do. You've made a wise choice, my friend.\
 {s9} does well by its loyal fighters, you will receive many rewards for your service.", "lord_mercenary_service_accept_3", [
     (call_script, "script_troop_add_gold", "trp_player", "$temp"),
     (store_current_day, ":cur_day"),
     (store_add, "$mercenary_service_next_renew_day", ":cur_day", 30),
     (call_script, "script_player_join_faction", "$g_talk_troop_faction"),
     (str_store_faction_name, s9, "$g_talk_troop_faction"),]],

  [anyone,"lord_mercenary_service_accept_3", [], "Now, I suggest you prepare for a serious campaign.\
 Train and equip your soldiers as best you can in the meantime, and respond quickly when you are summoned for duty.", "lord_pretalk", []],

  [anyone,"lord_mercenary_service_reject", [(str_store_faction_name, s9, "$g_talk_troop_faction")],
   "I'm very sorry to hear that. You'll find no better place than {s9}, be sure of that.", "lord_pretalk", []],

  [anyone,"lord_mercenary_elaborate_pay", [(assign, reg12, "$temp")],
   "I can offer you a contract for one month. At the end of this period, it can be extended on a monthly basis.\
 An initial sum of {reg12} denars will be paid to you to seal the contract.\
 After that, you'll receive wages from {s10} each week, according to the number and quality of the soldiers in your company.\
 You still have your rights to battlefield loot and salvage, as well as any prisoners you capture.\
 War can be very profitable at times...", "lord_mercenary_elaborate_1",
   [(faction_get_slot, ":faction_leader", "$g_talk_troop_faction", slot_faction_leader),
    (str_store_troop_name, s10, ":faction_leader")]],

  
  [anyone,"lord_mercenary_service_elaborate_duty", [], 
   "Duties... There are only a few, none of them difficult. The very first thing is to declare your allegiance.\
 An oath of loyalty to our cause. Once that's done, you shall be required to fulfill certain responsibilities.\
 You'll participate in military campaigns, fulfill any duties given to you by your commanders,\
 and most of all you shall attack the enemies of our kingdom wherever you might find them.", "lord_mercenary_elaborate_1",
   [(faction_get_slot, ":faction_leader", "$g_talk_troop_faction", slot_faction_leader),
    (str_store_troop_name, s10, ":faction_leader")]],
  
  [anyone|plyr,"lord_mercenary_elaborate_1", [], "And what about my duties as a mercenary?", "lord_mercenary_service_elaborate_duty", []],
  [anyone|plyr,"lord_mercenary_elaborate_1", [], "Can I hold on to any castles I take?", "lord_mercenary_elaborate_castle", []],
  [anyone|plyr,"lord_mercenary_elaborate_1",
   [
     (neg|troop_slot_ge, "trp_player", slot_troop_banner_scene_prop, 1),
#custom_banner begin  	
##    (eq, "trp_player", slot_troop_custom_banner_flag_type, -1),
#custom_banner end
     ], "Can I fly my own banner?", "lord_mercenary_elaborate_banner", []],
  [anyone|plyr,"lord_mercenary_elaborate_1", [], "How much will you pay me for my service?", "lord_mercenary_elaborate_pay", []],
  [anyone|plyr,"lord_mercenary_elaborate_1", [], "Sounds good. I wish to enter your service as a mercenary.", "lord_mercenary_service_accept", []],
  [anyone|plyr,"lord_mercenary_elaborate_1", [], "Apologies, my sword is not for hire.", "lord_mercenary_service_reject", []],

  
  [anyone,"lord_mercenary_elaborate_castle", [(troop_get_type, ":type", "trp_player"),(eq, ":type", 1),
  (faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop")
  ],
   "Only my loyal vassals can own lands and castles in my realm -- and all my vassals are men.\I am not inclined to depart from this tradition without a very good reason. If you prove yourself in battle, you can swear an oath of homage to me and become my vassal.\We may then discuss how you may obtain a castle.",
   "lord_mercenary_elaborate_1", []],

  [anyone,"lord_mercenary_elaborate_castle", [(troop_get_type, ":type", "trp_player"),(eq, ":type", 1),
  ],
   "Hmm... Only loyal vassals of {s10} can own lands and castles. While kings will sometimes accept vassalage from men who prove themselves in battle, and grant them land, I have never heard of a king who gave fiefs to women. You had best discuss that issue with {s10} himself.",
   "lord_mercenary_elaborate_1", []],

   
  [anyone,"lord_mercenary_elaborate_castle", [(faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop")],
   "Only my loyal vassals can own lands and castles in my realm.\
 A mercenary can not be trusted with such a responsibility.\
 However, after serving for some time, you can swear homage to me and become my vassal.\
 Then you will be rewarded with a fief.", "lord_mercenary_elaborate_1", []],
 
  [anyone,"lord_mercenary_elaborate_castle", [], "Only loyal vassals of {s10} can own lands and castles.\
 You understand, a simple mercenary cannot be trusted with such responsibility.\
 However, after serving for some time, you may earn the right to swear homage to {s10} and become his vassal.\
 Then you would be rewarded with a fief.", "lord_mercenary_elaborate_1", []],

  [anyone,"lord_mercenary_elaborate_banner", [(faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop")],
   "Only my noble vassals have the honour of carrying their own banners.\
 However, after some time in mercenary service, you may earn the opportunity to swear homage to me and become my vassal,\
 gaining the right to choose a banner of your own and fight under it in battle.", "lord_mercenary_elaborate_1", []],
  [anyone,"lord_mercenary_elaborate_banner", [], "Only noble vassals of {s10} have the honour of carrying their own banners.\
 However, after some time of mercenary service, perhaps you can earn the opportunity to swear homage to {s10} and become his vassal,\
 gaining the right to choose a banner of your own and fight under it in battle.", "lord_mercenary_elaborate_1", []],

  [anyone,"lord_request_mission_ask", [(store_partner_quest,":lords_quest"),(ge,":lords_quest",0)],
   "You still haven't finished the last job I gave you, {playername}. You should be working on that, not asking me for other things to do.", "lord_pretalk",[]],

   
  [anyone,"lord_request_mission_ask", [(troop_slot_eq, "$g_talk_troop", slot_troop_does_not_give_quest, 1)],
   "I don't have any other jobs for you right now.", "lord_pretalk",[]],



   
  [anyone|auto_proceed,"lord_request_mission_ask", [], "A task?", "lord_tell_mission",
   [
       (call_script, "script_get_quest", "$g_talk_troop"),
       (assign, "$random_quest_no", reg0),
   ]],

#check with armagan on this 

   
  [anyone,"lord_request_mission_ask", [
  (this_or_next|troop_slot_eq, "$g_talk_troop", slot_troop_met, 2),
	(troop_slot_eq, "trp_player", slot_troop_betrothed, "$g_talk_troop"),
  (troop_get_type, ":is_female", "trp_player"),
  (eq, ":is_female", 1),
  ],
   "My lady, by the traditions of courtship, I should be offering my services to you. Unfortunately, I have little time right now, so I beg you to take this declaration of my esteem in its place.", "lord_pretalk",[]],


  [anyone,"lord_tell_mission", [
  (eq, "$player_has_homage" ,1),
  (neq, "$random_quest_no", "qst_rescue_prisoner"),
  (neq, "$random_quest_no", "qst_destroy_bandit_lair"),
  (neq, "$random_quest_no", "qst_raise_troops"),
  (neq, "$random_quest_no", "qst_escort_lady"),
  (neq, "$random_quest_no", "qst_lend_companion"),
  (neq, "$random_quest_no", "qst_capture_enemy_hero"),
  (neq, "$random_quest_no", "qst_cause_provocation"),
  
  
  ],
   "There are some minor errands which I need completed, but it would be more appropriate to give them to one of my own men, not to a sworn vassal of the realm.", "lord_tell_mission_sworn_vassal",[]],

   
   
   
  [anyone,"lord_tell_mission_sworn_vassal", [
	(this_or_next|party_slot_eq, "$g_talk_troop_party", slot_party_ai_state, spai_besieging_center),
		(party_slot_eq, "$g_talk_troop_party", slot_party_ai_state, spai_raiding_around_center),
		
	(party_get_slot, ":cur_object", "$g_talk_troop_party", slot_party_ai_object),
	(is_between, ":cur_object", centers_begin, centers_end),
	(str_store_party_name, s4, ":cur_object"),
  ], 
	"If you are looking for action against our foes, you may join our attack on {s4}. The enemy may come in force to oppose us, so it is good to have as many men as possible.", "lord_pretalk",[]],

   
   
  [anyone,"lord_tell_mission_sworn_vassal", [
    (eq, "$g_talk_troop_faction", "$players_kingdom"),
  
	(party_get_slot, ":cur_object", "$g_talk_troop_party", slot_party_ai_object),
	(is_between, ":cur_object", centers_begin, centers_end),
	(party_get_slot, ":last_spotted_enemy", ":cur_object", slot_center_last_spotted_enemy),
	(party_is_active, ":last_spotted_enemy"),
	(store_faction_of_party, ":last_spotted_enemy_faction", ":last_spotted_enemy"),
	(store_relation, ":relation",":last_spotted_enemy_faction", "$g_talk_troop_faction"),
	(lt, ":relation", 0),
	
	(is_between, ":last_spotted_enemy_faction", kingdoms_begin, kingdoms_end),
	(str_store_party_name, s4, ":cur_object"),
	(str_store_faction_name, s5, ":last_spotted_enemy_faction"),
	
  ], 
	"If you are looking for action against our foes, you may try venturing out to {s4}. We have received word that a force of the {s5} is in the area, and I am going there myself. I cannot guarantee you that our enemies will be there when you arrive, of course.", "lord_pretalk",[]],
	
  [anyone,"lord_tell_mission_sworn_vassal", [
    (eq, "$g_talk_troop_faction", "$players_kingdom"),
	(assign, ":alarmed_center_found", -1),
	(assign, ":score_to_beat", 9999),
	
	(try_for_range, ":center_no", centers_begin, centers_end),
		(store_faction_of_party, ":center_faction", ":center_no"),
		(eq, ":center_faction", "$g_talk_troop_faction"),
		(party_get_slot, ":last_spotted_enemy", ":center_no", slot_center_last_spotted_enemy),
		(party_is_active, ":last_spotted_enemy"),
		(store_faction_of_party, ":last_spotted_enemy_faction", ":last_spotted_enemy"),
		(is_between, ":last_spotted_enemy_faction", kingdoms_begin, kingdoms_end),
		
		(store_relation, ":relation", ":last_spotted_enemy_faction", "$g_talk_troop_faction"),
		(lt, ":relation", 0),
		
		(store_distance_to_party_from_party, ":distance", ":center_no", "p_main_party"),
		(lt, ":distance", ":score_to_beat"),
		
		(assign, ":alarmed_center_found", ":center_no"),
		(assign, ":score_to_beat", ":distance"),
		(str_store_faction_name, s5, ":last_spotted_enemy_faction"),
	(try_end),
	(is_between, ":alarmed_center_found", centers_begin, centers_end),
	(str_store_party_name, s4, ":alarmed_center_found"),
  ], 
	"If you are looking for action against our foes, you may try venturing out to {s4}. We have received word that a force of the {s5} is in the area. I am not currently headed that way, but others may be.  I cannot guarantee you that our enemies will be there when you arrive, of course.", "lord_pretalk",[]],


	
  [anyone,"lord_tell_mission_sworn_vassal", [  ], 
	"If a worthy task presents itself, however, I may have a favor to ask of you at a later date.", "lord_pretalk",[]],
   
   
   
   
  [anyone,"lord_tell_mission", [
  (eq,"$random_quest_no", "qst_destroy_bandit_lair"),
  (quest_get_slot, ":bandit_lair", "qst_destroy_bandit_lair", slot_quest_target_party),
  
  (party_stack_get_troop_id, ":bandit_type", ":bandit_lair", 0),
  (str_store_troop_name_plural, s4, ":bandit_type"),
  
  ], "Yes -- there is something you can do for us. We have heard reports that a group of {s4} have established a hideout in this area, and have been attacking travellers. If you could find their lair and destroy it, we would be very grateful.", "destroy_lair_quest_brief", #s48 is bandits, s42 is the road information
   []],
   
   
  [anyone,"lord_tell_mission", 
  [(eq,"$random_quest_no","qst_rescue_prisoner")],
   "My {s11}, {s13}, has been taken prisoner by {s14} of the {s15}. Normally, honorable nobles will grant prisoners of gentle blood the privilege of parole, and treat them as honored guests so long as they give their word that they will not attempt to escape, until such time as a ransom can be paid.  But {s14}, instead of granting {s13} parole, has consigned my {s11} to his dungeons -- no doubt in the hope that he can demand more from us.", "lord_mission_rescue_prisoner",
   [
     (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
     (troop_get_slot, ":quest_target_center", ":quest_target_troop", slot_troop_prisoner_of_party),
	 (call_script, "script_troop_get_family_relation_to_troop", ":quest_target_troop", "$g_talk_troop"),
	 
     (str_store_troop_name_link, s9, "$g_talk_troop"),
     (str_store_troop_name_link, s13, ":quest_target_troop"),
     (str_store_party_name_link, s24, ":quest_target_center"),
	 (party_get_slot, ":captor", ":quest_target_center", slot_town_lord),
     (str_store_troop_name, s14, ":captor"),
	 (store_faction_of_party, ":target_faction", ":quest_target_center"),
     (str_store_faction_name, s15, ":target_faction"),
	 
	 
     (setup_quest_text,"$random_quest_no"),
##     (try_begin),
##       (is_between, "$g_encountered_party", centers_begin, centers_end),
##       (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##     (else_try),
##       (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##     (try_end),
     (str_store_string, s2, "str_s9_asked_you_to_rescue_s13_who_is_prisoner_at_s24"),
   ]],


  [anyone,"lord_mission_rescue_prisoner", [],
   "We need you to get my {s11} out of prison. You may be able to pay a ransom -- in which case we could cover your expenses, up to 5000 denars. If you have connections within {s24}, you may be able to use them to sneak him out. Or, you may try a more direct approach -- walk up to the gaoler, take the keys by force, and then fight your way out. Can you do this for us?", "lord_mission_rescue_prisoner_confirm",
   [
   ]],

  [anyone|plyr,"lord_mission_rescue_prisoner_confirm", [],
  "I can try.", "lord_mission_rescue_prisoner_accepted",[]],
  
  [anyone|plyr,"lord_mission_rescue_prisoner_confirm", [], "I don't think that I can help you.", "lord_mission_rescue_prisoner_rejected",[]],
  [anyone,"lord_mission_rescue_prisoner_rejected", [], "It would not have been an easy task. Perhaps we will find another way.", "close_window",[
    (assign, "$g_leave_encounter",1),
  ]],
   
  [anyone,"lord_mission_rescue_prisoner_accepted", [], "We are most grateful. Could I ask you how you were planning to proceed?", "lord_mission_rescue_prisoner_method",
   [(call_script, "script_start_quest", "$random_quest_no", "$g_talk_troop"),
    (call_script, "script_change_player_relation_with_troop","$g_talk_troop",1),
   ]],

  [anyone,"lord_mission_rescue_other_ideas", [], "Did you have any other ideas which you wished to discuss?", "lord_mission_rescue_prisoner_method",
   []],

   
  [anyone|plyr,"lord_mission_rescue_prisoner_method", [
  (eq, 1, 0),
  ], # unused
  "{!}I am thinking of paying the ransom.", "lord_mission_rescue_prisoner_method_ransom",[]],

  [anyone|plyr,"lord_mission_rescue_prisoner_method", [
  (eq, 1, 0),
  ], # unused
  "{!}I am thinking of using my connections in {s24}.", "close_window",[]],
   
  [anyone|plyr,"lord_mission_rescue_prisoner_method", [],
  "I am thinking of breaking into the prison in {s24}, finding {s13}, and fighting my way out.", "lord_mission_rescue_prisoner_method_prisonbreak",[]],

  [anyone|plyr,"lord_mission_rescue_prisoner_method", [],
  "I am thinking of taking {s24} by storm.", "lord_mission_rescue_prisoner_method_siege",[]],

  [anyone|plyr,"lord_mission_rescue_prisoner_method", [],
  "I have done enough planning. Time to act!", "lord_mission_rescue_prisoner_planning_end",[]],

  [anyone,"lord_mission_rescue_prisoner_planning_end", [],
  "May the heavens protect you.", "close_window",[
  (assign, "$g_leave_encounter", 1),
  ]],

  [anyone,"lord_mission_rescue_prisoner_method_ransom", [],
  "{!}[Ransom option not yet implemented]", "lord_mission_rescue_other_ideas",[]],
  
  [anyone,"lord_mission_rescue_prisoner_method_prisonbreak", [],
  "I had discussed this idea with some of my men. One could enter {s24}, either in disguise or openly, then walk up to the prison guard and try to take the keys by force. However, getting out may be difficult. The garrison may be slow to react, but even so, you are likely to find yourself fighting a half dozen or more of the enemy at once, with limited space in which to maneuver. If you can fight your way past them, though, you can probably get out.", "lord_mission_rescue_prisoner_method_prisonbreak_2",[]],

  [anyone,"lord_mission_rescue_prisoner_method_prisonbreak_2", [],
  "You may find it useful to create a distraction, to divert the attention of some of the garrison. If you have any connections in the villages near {s24}, this may be a time to put them to use.", "lord_mission_rescue_other_ideas",[]],
  
  
  [anyone,"lord_mission_rescue_prisoner_method_siege", [],
  "Well, that is certainly the most direct approach.", "lord_mission_rescue_other_ideas",[]],



  
  

  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_deliver_message")],
   "I need to send a letter to {s13} who should be currently at {s4}.\
 If you will be heading towards there, would you deliver it to him?\
 The letter needs to be in his hands in 30 days.", "lord_mission_deliver_message",
   [
     (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
     (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
     (str_store_troop_name_link,s9,"$g_talk_troop"),
     (str_store_troop_name_link,s13,":quest_target_troop"),
     (str_store_party_name_link,s4,":quest_target_center"),
     (setup_quest_text,"$random_quest_no"),
##     (try_begin),
##       (is_between, "$g_encountered_party", centers_begin, centers_end),
##       (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##     (else_try),
##       (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##     (try_end),
     (str_store_string, s2, "@{s9} asked you to take a message to {s13}. {s13} was believed to be at {s4} when you were given this quest."),
   ]],

  [anyone|plyr,"lord_mission_deliver_message", [], "Certainly, I intend to pass by {s4} and it would be no trouble.", "lord_mission_deliver_message_accepted",[]],
  [anyone|plyr,"lord_mission_deliver_message", [], "I doubt I'll be seeing {s13} anytime soon, {s65}. You'd best send it with someone else.", "lord_mission_deliver_message_rejected",[]],
  [anyone|plyr,"lord_mission_deliver_message", [], "I am no errand boy, sir. Hire a courier for your trivialities.", "lord_mission_deliver_message_rejected_rudely",[]],

  [anyone,"lord_mission_deliver_message_accepted", [], "I appreciate it, {playername}. Here's the letter,\
 and a small sum to cover your travel expenses. Give my regards to {s13} when you see him.", "close_window",
   [(call_script, "script_start_quest", "$random_quest_no", "$g_talk_troop"),
    (call_script, "script_troop_add_gold", "trp_player", 30),    (assign, "$g_leave_encounter",1),
   ]],

  [anyone,"lord_mission_deliver_message_rejected", [], "Ah, all right then. Well, I am sure I will find someone else.", "lord_pretalk",
   [(troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1)]],
  
  [anyone,"lord_mission_deliver_message_rejected_rudely", [], "Hm, is this how you respond to a polite request\
 for a small favor? A poor show, {playername}. I didn't know you would take offence.", "lord_mission_deliver_message_rejected_rudely_2",[]],
    
  [anyone|plyr,"lord_mission_deliver_message_rejected_rudely_2", [], "Then you shall know better from now on.", "lord_mission_deliver_message_rejected_rudely_3",[]],
  [anyone|plyr,"lord_mission_deliver_message_rejected_rudely_2", [], "Forgive my temper, {s65}. I'll deliver your letter.", "lord_mission_deliver_message_accepted",[]],

  [anyone,"lord_mission_deliver_message_rejected_rudely_3", [], "All right. I will remember that.", "close_window",[
    (call_script, "script_change_player_relation_with_troop","$g_talk_troop",-4),
    (quest_set_slot, "$random_quest_no", slot_quest_dont_give_again_remaining_days, 150),
    (troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1),    
    (assign, "$g_leave_encounter",1),
      ]],

  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_deliver_message_to_enemy_lord")],
   "I need to deliver a letter to {s13} of {s15}, who must be at {s4} currently.\
 If you are going towards there, would you deliver my letter to him? The letter needs to reach him in 40 days.", "lord_mission_deliver_message",
   [
     (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
     (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
     (str_store_troop_name_link,s9,"$g_talk_troop"),
##     (str_store_party_name,2,"$g_encountered_party"),
     (str_store_troop_name_link,s13,":quest_target_troop"),
     (str_store_party_name_link,s4,":quest_target_center"),
     (store_troop_faction, ":target_faction", ":quest_target_troop"),
     (str_store_faction_name_link,s15,":target_faction"),
     (setup_quest_text,"$random_quest_no"),
##     (try_begin),
##       (is_between, "$g_encountered_party", centers_begin, centers_end),
##       (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##     (else_try),
##       (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##     (try_end),
     (str_store_string, s2, "@{s9} asked you to take a message to {s13} of {s15}. {s13} was believed to be at {s4} when you were given this quest."),
   ]],

  
  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_escort_lady")],
   "There is a small thing... My {s17} {s13} is due for a visit to her relatives at {s14}.\
 The visit has been postponed several times already with all the trouble on the roads,\
 but this time she is adamant about going. So, I want to at least make sure she's well-guarded.\
 I trust you well, {playername} so I would be very grateful if you could escort her to {s14}\
 and make sure she arrives safe and sound.", "lord_mission_told",
   [
     (quest_get_slot, ":quest_object_troop", "$random_quest_no", slot_quest_object_troop),
     (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
     (try_begin),
       (troop_slot_eq, ":quest_object_troop", slot_troop_father, "$g_talk_troop"),
       (str_store_string, s17, "str_daughter"),
     (else_try),
       (str_store_string, s17, "str_wife"),
     (try_end),
     (str_store_troop_name_link, s11, "$g_talk_troop"),
     (str_store_troop_name_link, s13, ":quest_object_troop"),
     (str_store_party_name_link, s14, ":quest_target_center"),
     (setup_quest_text,"$random_quest_no"),
     (str_store_string, s2, "@{s11} asked you to escort his {s17} {s13} to {s14}."),
   ]],

##
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_hunt_down_raiders")],
## "A messenger came with important news a few hours ago.\
## A group of enemy raiders have attacked a village near {s3}.\
## They have murdered anyone who tried to resist, stolen everything they could carry and put the rest to fire.\
## Now, they must be on their way back to their base at {s4}.\
## You must catch them on the way and make them pay for their crimes.", "lord_mission_told",
##   [
##       (quest_get_slot, ":quest_object_center", "$random_quest_no", slot_quest_object_center),
##       (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
##       (str_store_party_name_link,3,":quest_object_center"),
##       (str_store_party_name_link,4,":quest_target_center"),
##    ]],
##  
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_bring_back_deserters")],
## "I am worried about the growing number of deserters. If we don't do something about it, we may soon have noone left to fight in our wars.\
## I want you to go now and bring back {reg1} {s3}. I would ask you to hang the bastards but we are short of men and we need them back in the ranks.", "lord_mission_told",
##   [
##       (quest_get_slot, ":quest_target_amount", "$random_quest_no", slot_quest_target_amount),
##       (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
##      
##       (str_store_troop_name_link,1,"$g_talk_troop"),
##       (str_store_party_name_link,2,"$g_encountered_party"),
##       (str_store_troop_name_plural,3,":quest_target_troop"),
##       (assign, reg1, ":quest_target_amount"),
##       (setup_quest_text,"$random_quest_no"),
##       (try_begin),
##         (is_between, "$g_encountered_party", centers_begin, centers_end),
##         (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##       (else_try),
##         (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##       (try_end),
##    ]],
##
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_deliver_supply_to_center_under_siege")],
## "The enemy has besieged {s5}. Our brothers there are doing their best to fend off attacks, but they can't hold for long without supplies.\
## We need someone to take the supplies they need and make it into the town as soon as possible.\
## It's a very dangerous job, but if there's one person who can do it, it's you {playername}.\
## You can take the supplies from seneschal {s3}. When you arrive at {s5}, give them to the seneschal of that town.", "lord_mission_told",
##   [
##       (quest_get_slot, ":quest_target_amount", "$random_quest_no", slot_quest_target_amount),
##       (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
##       (quest_get_slot, ":quest_object_troop", "$random_quest_no", slot_quest_object_troop),
##       (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
##      
##       (str_store_troop_name_link,1,"$g_talk_troop"),
##       (str_store_party_name_link,2,"$g_encountered_party"),
##       (str_store_troop_name_link,3,":quest_object_troop"),
##       (str_store_troop_name,4,":quest_target_troop"),
##       (str_store_party_name_link,5,":quest_target_center"),
##       (assign, reg1, ":quest_target_amount"),
##       (setup_quest_text,"$random_quest_no"),
##       (try_begin),
##         (is_between, "$g_encountered_party", centers_begin, centers_end),
##         (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##       (else_try),
##         (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##       (try_end),
##    ]],
##
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_bring_reinforcements_to_siege")],
## "{s4} has besieged {s5} and God willing, that town will not hold for long.\
## Still I promised him to send {reg1} {s3} as reinforcements and I need someone to lead those men.\
## Can you take them to {s4}?", "lord_mission_told",
##   [
##       (quest_get_slot, ":quest_target_amount", "$random_quest_no", slot_quest_target_amount),
##       (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
##       (quest_get_slot, ":quest_object_troop", "$random_quest_no", slot_quest_object_troop),
##       (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
##      
##       (str_store_troop_name_link,1,"$g_talk_troop"),
##       (str_store_party_name_link,2,"$g_encountered_party"),
##       (str_store_troop_name_plural,3,":quest_object_troop"),
##       (str_store_troop_name_link,4,":quest_target_troop"),
##       (str_store_party_name_link,5,":quest_target_center"),
##       (assign, reg1, ":quest_target_amount"),
##       (setup_quest_text,"$random_quest_no"),
##       (try_begin),
##         (is_between, "$g_encountered_party", centers_begin, centers_end),
##         (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##       (else_try),
##         (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##       (try_end),
##    ]],
##
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_rescue_lady_under_siege")],
## "The enemy has besieged {s4} and my dear {s7} {s3} has been trapped within the town walls.\
## As you may guess, I am greatly distressed by this. I need a very reliable commander, to rescue her from the town and bring her back to me.\
## Will you do that {playername}?", "lord_mission_told",
##   [
##       (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
##       (quest_get_slot, ":quest_object_troop", "$random_quest_no", slot_quest_object_troop),
##
##       (try_begin),
##         (troop_slot_eq, "$g_talk_troop", slot_troop_daughter, ":quest_object_troop"),
##         (str_store_string, s7, "str_daughter"),
##       (else_try),
##         (str_store_string, s7, "str_wife"),
##       (try_end),
##      
##       (str_store_troop_name_link,1,"$g_talk_troop"),
##       (str_store_party_name_link,2,"$g_encountered_party"),
##       (str_store_troop_name_link,3,":quest_object_troop"),
##       (str_store_party_name_link,4,":quest_target_center"),
##       (setup_quest_text,"$random_quest_no"),
##       (try_begin),
##         (is_between, "$g_encountered_party", centers_begin, centers_end),
##         (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##       (else_try),
##         (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##       (try_end),
##    ]],
##
##
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_bring_prisoners_to_enemy")],
##   "The enemy wants to ransom some of their soldiers that we captured at the last battle.\
## They'll pay 100 denars in return for giving them back {reg1} {s3}.\
## God knows I can use that money so I accepted their offer.\
## Now, what I need is someone to take the prisoners to {s4} and come back with the money.", "lord_mission_told",
##   [
##     (quest_get_slot, ":quest_object_troop", "$random_quest_no", slot_quest_object_troop),
##     (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
##     (quest_get_slot, reg1, "$random_quest_no", slot_quest_target_amount),
##     (str_store_troop_name_link,1,"$g_talk_troop"),
##     (str_store_party_name_link,2,"$g_encountered_party"),
##     (str_store_troop_name_plural,3,":quest_object_troop"),
##     (str_store_party_name_link,4,":quest_target_center"),
##     (setup_quest_text,"$random_quest_no"),
##     (try_begin),
##       (is_between, "$g_encountered_party", centers_begin, centers_end),
##       (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##     (else_try),
##       (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##     (try_end),
##   ]],
##


# Deal with bandits
  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_deal_with_bandits_at_lords_village")],
   "A group of bandits have taken refuge in my village of {s15}.\
 They are plundering nearby farms, and getting rich and fat stealing my taxes and feasting on my cattle.\
I'd like nothing better than to go out there and teach them a lesson,\
 but I have my hands full at the moment, so I can't do anything about it.", "lord_mission_deal_with_bandits_told",
   [
     (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
     (str_store_party_name_link,s15,":quest_target_center"),
     (str_store_troop_name_link,s13,"$g_talk_troop"),
     (setup_quest_text,"$random_quest_no"),
     (str_store_string, s2, "@{s13} asked you to deal with the bandits who are occupying the village of {s15} and then report back to him."),
   ]],

  [anyone|plyr,"lord_mission_deal_with_bandits_told", [],
   "Worry not, I can go to {s15} and deal with these scum for you.", "lord_mission_deal_with_bandits_accepted",[]],
  [anyone|plyr,"lord_mission_deal_with_bandits_told", [], "You shall have to find help elsewhere, I am too busy.", "lord_mission_deal_with_bandits_rejected",[]],

  [anyone,"lord_mission_deal_with_bandits_accepted", [], "Will you do that?\
 Know that, I will be grateful to you. Here is some money for the expenses of your campaign.\
 Make an example of those {s43}s.", "close_window",
   [

 	(call_script, "script_lord_comment_to_s43", "$g_talk_troop", "str_lord_insult_default"),

    (call_script, "script_start_quest", "$random_quest_no", "$g_talk_troop"),
    (call_script, "script_troop_add_gold", "trp_player", 200),
    (call_script, "script_change_player_relation_with_troop","$g_talk_troop",1),
    (assign, "$g_leave_encounter",1),
   ]],

  [anyone,"lord_mission_deal_with_bandits_rejected", [], "Ah... Very well then, forget I brought it up.", "lord_pretalk",
   [(troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1)]],

# Raise troops
  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_raise_troops")],
   "No lord should have to admit this, {playername}, but I was inspecting my soldiers the other day\
 and there are men here who don't know which end of a sword to hold.\
 {s43}\
 You are a warrior of renown, {playername}. Will you train some troops for me?\
 I would be grateful to you.", "lord_tell_mission_raise_troops",[
 	(call_script, "script_lord_comment_to_s43", "$g_talk_troop", "str_troop_train_request_default"),

     ]],

  [anyone|plyr,"lord_tell_mission_raise_troops", [], "How many men do you need?", "lord_tell_mission_raise_troops_2",[]],

  [anyone,"lord_tell_mission_raise_troops_2", [], "If you can raise {reg1} {s14} and bring them to me, that will probably be enough.", "lord_mission_raise_troops_told",
   [
     (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
     (quest_get_slot, reg1, "$random_quest_no", slot_quest_target_amount),
     (str_store_troop_name_link,s9,"$g_talk_troop"),
     (str_store_troop_name_plural,s14,":quest_target_troop"),
     (setup_quest_text,"$random_quest_no"),
     (str_store_string, s2, "@{s9} asked you to raise {reg1} {s14} and bring them to him."),
   ]],

  [anyone|plyr,"lord_mission_raise_troops_told", [(quest_get_slot, reg1, "$random_quest_no", slot_quest_target_amount)],
   "Of course, {s65}. Give me {reg1} fresh recruits and I'll train them to be {s14}.", "lord_mission_raise_troops_accepted",[]],
  [anyone|plyr,"lord_mission_raise_troops_told", [], "I am too busy these days to train anyone.", "lord_mission_raise_troops_rejected",[]],

  [anyone,"lord_mission_raise_troops_accepted", [], "You've taken a weight off my shoulders, {playername}.\
 I shall tell my sergeants to send you the recruits and attach them to your command.\
 Also, I'll advance you some money to help with expenses. Here, this purse should do it.\
 Thank you for your help.", "close_window",
   [(call_script, "script_start_quest", "$random_quest_no", "$g_talk_troop"),
    (call_script, "script_troop_add_gold", "trp_player", 100),
    (quest_get_slot, ":recruit_troop", "$random_quest_no", slot_quest_object_troop),
    (quest_get_slot, ":num_recruits", "$random_quest_no", slot_quest_target_amount),
    (party_add_members, "p_main_party", ":recruit_troop", ":num_recruits"),
    (call_script, "script_change_player_relation_with_troop","$g_talk_troop",1),
    (assign, "$g_leave_encounter",1),
   ]],

  [anyone,"lord_mission_raise_troops_rejected", [], "Oh, of course. I had expected as much. Well, good luck to you then.", "lord_pretalk",
   [(troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1)]],
  

#Collect Taxes
  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_collect_taxes"),
                                (assign, reg9, 0),
                                (try_begin),
                                  (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
                                  (party_slot_eq, ":quest_target_center", slot_party_type, spt_town),
                                  (assign, reg9, 1),
                                (try_end),
                                ], "You probably know that I am the lord of the {reg9?town:village} of {s3}.\
 However, it has been months since {s3} has delivered the taxes and rents due me as its rightful lord.\
 Apparently the populace there has grown unruly lately and I need someone to go there and remind them of\
 their obligations. And to . . . persuade them if they won't listen.\
 If you go there and raise the taxes they owe me, I will grant you one-fifth of everything you collect.", "lord_mission_collect_taxes_told",
   [
     (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
     (str_store_troop_name_link,s9,"$g_talk_troop"),
     (str_store_party_name_link,s3,":quest_target_center"),
     (setup_quest_text,"$random_quest_no"),
     (str_store_string, s2, "@{s9} asked you to collect taxes from {s3}. He offered to leave you one-fifth of all the money you collect there."),
   ]],

  [anyone|plyr,"lord_mission_collect_taxes_told", [],
   "A fair offer, {s65}. We have an agreement.", "lord_mission_collect_taxes_accepted",[]],
  [anyone|plyr,"lord_mission_collect_taxes_told", [], "Forgive me, I don't have the time.", "lord_mission_collect_taxes_rejected",[]],

  [anyone,"lord_mission_collect_taxes_accepted", [], "Welcome news, {playername}.\
 I will entrust this matter to you.\
 Remember, those {reg9?townsmen:peasants} are foxy beasts, they will make every excuse not to pay me my rightful incomes.\
 Do not let them fool you.", "close_window",
   [(call_script, "script_start_quest", "$random_quest_no", "$g_talk_troop"),
    (call_script, "script_change_player_relation_with_troop","$g_talk_troop",1),
    (assign, "$g_leave_encounter",1),
    (assign, reg9, 0),
    (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
    (try_begin),
      (party_slot_eq, ":quest_target_center", slot_party_type, spt_town),
      (assign, reg9, 1),
    (try_end),
   ]],
  
  [anyone,"lord_mission_collect_taxes_rejected", [], "Oh, yes. Well, good luck to you then.", "lord_pretalk",
   [(troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1)]],

#Hunt down fugitive
  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_hunt_down_fugitive")],
   "I have something you could help with, an issue with the lawless villain known as {s4}. \
 He murdered one of my men and has been on the run from his judgment ever since.\
 I can't let him get away with avoiding justice, so I've put a bounty of 300 denars on his head.\
 Friends of the murdered man reckon that this assassin may have taken refuge with his kinsmen at {s3}.\
 You might be able to hunt him down and give him what he deserves, and claim the bounty for yourself.", "lord_mission_hunt_down_fugitive_told",
   [
     (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
     (quest_get_slot, ":quest_target_dna", "$random_quest_no", slot_quest_target_dna),
     (str_store_troop_name_link,s9, "$g_talk_troop"),
     (str_store_party_name_link,s3, ":quest_target_center"),
     (call_script, "script_get_name_from_dna_to_s50", ":quest_target_dna"),
     (str_store_string, s4, s50),
     (setup_quest_text, "$random_quest_no"),
     (str_store_string, s2, "@{s9} asked you to hunt down a fugitive named {s4}. He is currently believed to be at {s3}."),
   ]],

  [anyone|plyr,"lord_mission_hunt_down_fugitive_told", [],
   "Then I will hunt him down and execute the law.", "lord_mission_hunt_down_fugitive_accepted",[]],
  [anyone|plyr,"lord_mission_hunt_down_fugitive_told", [], "I am too busy to go after him at the moment.", "lord_mission_hunt_down_fugitive_rejected",[]],

  [anyone,"lord_mission_hunt_down_fugitive_accepted", [], "That's excellent, {playername}.\
 I will be grateful to you and so will the family of the man he murdered.\
 And of course the bounty on his head will be yours if you can get him.\
 Well, good hunting to you.", "close_window",
   [(call_script, "script_start_quest", "$random_quest_no", "$g_talk_troop"),
    (call_script, "script_change_player_relation_with_troop","$g_talk_troop",1),
    (assign, "$g_leave_encounter",1),
   ]],

  [anyone,"lord_mission_hunt_down_fugitive_rejected", [], "As you wish, {playername}.\
I suppose there are plenty of bounty hunters around to get the job done . . .", "lord_pretalk",
   [(troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1)]],



##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_capture_messenger")],
##   "The enemy seems to be preparing for some kind of action and I want to know what their plans are.\
## Capture one of their messengers and bring him to me.", "lord_mission_told",
##   [
##       (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
##      
##       (str_store_troop_name_link,1,"$g_talk_troop"),
##       (str_store_party_name_link,2,"$g_encountered_party"),
##       (str_store_troop_name,3,":quest_target_troop"),
##       (setup_quest_text,"$random_quest_no"),
##       (try_begin),
##         (is_between, "$g_encountered_party", centers_begin, centers_end),
##         (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##       (else_try),
##         (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##       (try_end),
##   ]],
##
  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_kill_local_merchant")],
   "The wretched truth is that I owe a considerable sum of money to one of the merchants here in {s3}.\
 I've no intention of paying it back, of course, but that loud-mouthed fool is making a terrible fuss about it.\
 He even had the audacity to come and threaten me -- me! --\
 with a letter of complaint to the trade guilds and bankers. Why, he'd ruin my good reputation!\
 So I need a {man/woman} I can trust, someone who will guarantee the man's silence. For good.", "lord_mission_told_kill_local_merchant",
   [
       (str_store_troop_name_link,s9,"$g_talk_troop"),
       (str_store_party_name_link,s3,"$current_town"),
       (setup_quest_text,"$random_quest_no"),
       (str_store_string, s2, "@{s9} asked you to assassinate a local merchant at {s3}."),
   ]],
  
  [anyone|plyr,"lord_mission_told_kill_local_merchant", [], "Worry not, he shan't breathe a word.", "lord_mission_accepted_kill_local_merchant",[]],
  [anyone|plyr,"lord_mission_told_kill_local_merchant", [], "I'm no common murderer, sir. Find someone else for your dirty job.", "lord_mission_rejected",[]],

  [anyone,"lord_mission_accepted_kill_local_merchant", [], "Very good. I trust in your skill and discretion,\
 {playername}. Do not disappoint me.\
 Go now and wait for my word, I'll send you a message telling when and where you can catch the merchant.\
 Dispose of him for me and I shall reward you generously.", "close_window",
   [(call_script, "script_start_quest", "$random_quest_no", "$g_talk_troop"),
    (assign, "$g_leave_town",1),
    (assign, "$qst_kill_local_merchant_center", "$current_town"),
    (rest_for_hours, 10, 4, 0),
    (finish_mission),
    ]],

  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_meet_spy_in_enemy_town"),
                                (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
                                (str_store_party_name, s13, ":quest_target_center"),
                                (store_faction_of_party,":quest_target_center_faction",),
                                (str_store_faction_name, s14, ":quest_target_center_faction"),
                                ],
   "I have a sensitive matter which needs tending to, {playername}, and no trustworthy retainers to take care of it. The fact is that I have a spy in {s13} to keep an eye on things for me, and report anything that might warrant my attention. Every week I send someone to collect the spy's reports and bring them back to me. The job's yours if you wish it.", "lord_mission_told_meet_spy_in_enemy_town",
   [
   ]],

  [anyone|plyr,"lord_mission_told_meet_spy_in_enemy_town", [], "I don't mind a bit of skullduggery. Count me in.", "quest_meet_spy_in_enemy_town_accepted",[]],
  [anyone|plyr,"lord_mission_told_meet_spy_in_enemy_town", [], "I must decline. This cloak-and-dagger work isn't fit for me.", "quest_meet_spy_in_enemy_town_rejected",[]],

  [anyone,"quest_meet_spy_in_enemy_town_accepted", [], "Excellent! Make your way to {s13} as soon as you can, the spy will be waiting.", "quest_meet_spy_in_enemy_town_accepted_response",
   [
     (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
     (quest_get_slot, ":secret_sign", "$random_quest_no", slot_quest_target_amount),
     (store_sub, ":countersign", ":secret_sign", secret_signs_begin),
     (val_add, ":countersign", countersigns_begin),
     (str_store_troop_name_link, s9, "$g_talk_troop"),
     (str_store_string, s11, ":secret_sign"),
     (str_store_string, s12, ":countersign"),
     (str_store_party_name_link, s13, ":quest_target_center"),
     (setup_quest_text, "$random_quest_no"),
     (str_store_string, s2, "@{s9} has asked you to meet with a spy in {s13}."),
     (call_script, "script_start_quest", "$random_quest_no", "$g_talk_troop"),
     (call_script, "script_cf_center_get_free_walker", ":quest_target_center"),
     (call_script, "script_center_set_walker_to_type", ":quest_target_center", reg0, walkert_spy),
     (str_store_item_name,s14,"$spy_item_worn"),
     #TODO: Change this value
     (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 1),
     (assign, "$g_leave_encounter",1),
    ]],
  [anyone|plyr,"quest_meet_spy_in_enemy_town_accepted_response", [(quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
                                                                  (str_store_party_name_link, s13, ":quest_target_center")],
   "{s13} is heavily defended. How can I get close without being noticed?", "quest_meet_spy_in_enemy_town_accepted_2",
   []],
  [anyone,"quest_meet_spy_in_enemy_town_accepted_2", [], "You shall have to use stealth. Take care to avoid enemy strongholds, villages and patrols, and don't bring too many men with you. If you fail to sneak in the first time, give it a while for the garrison to lower its guard again, or you may have a difficult time infiltrating the town.", "quest_meet_spy_in_enemy_town_accepted_response",
   []],
  [anyone|plyr,"quest_meet_spy_in_enemy_town_accepted_response", [], "How will I recognise the spy?", "quest_meet_spy_in_enemy_town_accepted_3",
   []],
  [anyone,"quest_meet_spy_in_enemy_town_accepted_3", [(quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
                                                      (str_store_party_name_link, s13, ":quest_target_center"),
                                                      (troop_get_type, reg7, "$spy_quest_troop"),
                                                      (quest_get_slot, ":secret_sign", "$random_quest_no", slot_quest_target_amount),
                                                      (store_sub, ":countersign", ":secret_sign", secret_signs_begin),
                                                      (val_add, ":countersign", countersigns_begin),
                                                      (str_store_string, s11, ":secret_sign"),
                                                      (str_store_string, s12, ":countersign"),],
   "Once you get to {s13} you must talk to the locals, the spy will be one of them. If you think you've found the spy, say the phrase '{s11}' The spy will respond with the phrase '{s12}' Thus you will know the other, and {reg7?she:he} will give you any information {reg7?she:he}'s gathered in my service.", "quest_meet_spy_in_enemy_town_accepted_response",
   []],
  [anyone|plyr,"quest_meet_spy_in_enemy_town_accepted_response", [], "Will I be paid?", "quest_meet_spy_in_enemy_town_accepted_4",
   []],
  [anyone,"quest_meet_spy_in_enemy_town_accepted_4", [], "Of course, I have plenty of silver in my coffers for loyal {men/women} like you. Do well by me, {playername}, and you'll rise high.", "quest_meet_spy_in_enemy_town_accepted_response",
   []],
  [anyone|plyr,"quest_meet_spy_in_enemy_town_accepted_response", [], "I know what to do. Farewell, my lord.", "quest_meet_spy_in_enemy_town_accepted_end",
   []],
  [anyone,"quest_meet_spy_in_enemy_town_accepted_end", [(quest_get_slot, ":secret_sign", "$random_quest_no", slot_quest_target_amount),
                                                        (store_sub, ":countersign", ":secret_sign", secret_signs_begin),
                                                        (val_add, ":countersign", countersigns_begin),
                                                        (str_store_string, s11, ":secret_sign"),
                                                        (str_store_string, s12, ":countersign")],
   "Good luck, {playername}. Remember, the secret phrase is '{s11}' The counterphrase is '{s12}' Bring any reports back to me, and I'll compensate you for your trouble.", "lord_pretalk",
   []],

  [anyone,"quest_meet_spy_in_enemy_town_rejected", [], "As you wish, {playername}, but I strongly advise you to forget anything I told you about any spies. They do not exist, have never existed, and no one will ever find them. Remember that.", "lord_pretalk",
   [(troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1)]],


    

  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_cause_provocation"),
                                (quest_get_slot, ":quest_target_faction", "$random_quest_no", slot_quest_target_faction),
                                (str_store_faction_name_link, s13, ":quest_target_faction")],
   "This peace with {s13} ill suits me, {playername}. We've let those swine have their way for far too long.\
 Now they get stronger with each passing and their arrogance knows no bounds.\
 I say, we must wage war on them before it's too late!\
 Unfortunately, some of the bleeding hearts among our realm's lords are blocking a possible declaration of war.\
 Witless cowards with no stomach for blood.", "lord_mission_told_raid_caravan_to_start_war",
   [
   ]],

  [anyone|plyr,"lord_mission_told_raid_caravan_to_start_war", [], "You are right, {s65}, but what can we do?", "lord_mission_tell_raid_caravan_to_start_war_2",[]],
  [anyone|plyr,"lord_mission_told_raid_caravan_to_start_war", [], "I disagree, sir. It is better that there be peace.", "quest_raid_caravan_to_start_war_rejected_1",[]],

  [anyone,"lord_mission_tell_raid_caravan_to_start_war_2", [(quest_get_slot, ":quest_target_faction", "$random_quest_no", slot_quest_target_faction),
                                                            (str_store_faction_name_link, s13, ":quest_target_faction"),
															(str_store_faction_name, s14, "$g_talk_troop_faction")],
   "Ah, 'tis good to hear someone who understands!\
 As a matter of fact, there is something we can do, {playername}. A little bit of provocation...\
 If one of our war parties managed to enter their territory and pillage one of their caravans, or raided one of their villages,\
 and perhaps left behind a little token or two of the {s14},\
 they would have ample cause to declare war on us.\
 And then, well, even the cowards among us must rise to defend themselves.\
 So what do you say? Are you interested?", "lord_mission_tell_raid_caravan_to_start_war_3",[]],

  [anyone|plyr,"lord_mission_tell_raid_caravan_to_start_war_3", [], "An excellent plan. Count me in.", "quest_raid_caravan_to_start_war_accepted",[]],
  [anyone|plyr,"lord_mission_tell_raid_caravan_to_start_war_3", [], "Why don't you do that yourself?", "lord_mission_tell_raid_caravan_to_start_war_4",[]],

  [anyone,"lord_mission_tell_raid_caravan_to_start_war_4", [
  	], "Well, {playername}, some of the lords in our kingdom\
 won't like the idea of someone inciting a war without their consent.\
 They are already looking for an excuse to get at me, and if I did this they could make me pay for it dearly.\
 You, on the other hand, are young and well-liked and daring, so you might just get away with it.\
 And of course I will back you up and defend your actions against your opponents.\
 All in all, a few lords might be upset at your endeavour, but I am sure you won't be bothered with that.", "lord_mission_tell_raid_caravan_to_start_war_5",[]],

  [anyone|plyr,"lord_mission_tell_raid_caravan_to_start_war_5", [], "That seems reasonable. I am willing to do this.", "quest_raid_caravan_to_start_war_accepted",[]],
  [anyone|plyr,"lord_mission_tell_raid_caravan_to_start_war_5", [], "I don't like this. Find yourself someone else to take the blame for your schemes.", "quest_raid_caravan_to_start_war_rejected_2",[]],

  [anyone,"quest_raid_caravan_to_start_war_accepted", [], "Very good!\
 A raid on a caravan, or, if you can't manage that, an attack on one of their villages, should do the trick.\
 Now, good luck and good hunting. Go set the borders aflame!", "close_window",
   [
     (quest_get_slot, ":quest_target_faction", "$random_quest_no", slot_quest_target_faction),
     (quest_get_slot, ":quest_target_amount", "$random_quest_no", slot_quest_target_amount),
     (str_store_troop_name_link, s9, "$g_talk_troop"),
     (str_store_faction_name_link, s13, ":quest_target_faction"),
     (assign, reg13, ":quest_target_amount"),
     (setup_quest_text,"$random_quest_no"),
     (str_store_string, s2, "str_s9_asked_you_to_attack_a_village_or_some_caravans_as_to_provoke_a_war_with_s13"),
     (call_script, "script_start_quest", "$random_quest_no", "$g_talk_troop"),
#     (call_script, "script_change_player_relation_with_troop","$g_talk_troop",5),
     (assign, "$g_leave_encounter",1),
    ]],

  [anyone,"quest_raid_caravan_to_start_war_rejected_1", [], "Ah, you think so? But how long will your precious peace last? Not long, believe me.", "lord_pretalk",
   [(troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1)]],
  [anyone,"quest_raid_caravan_to_start_war_rejected_2", [], "Hm. As you wish, {playername}.\
 I thought you had some fire in you, but it seems I was wrong.", "lord_pretalk",
   [(troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1)]],


   
   
  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_bring_back_runaway_serfs")],
 "Well, some of the serfs working my fields in {s4} have run away. The ungrateful swine,\
 I let them plough my fields and rent my cottages, and this is how they repay me!\
 From what I've been hearing, they're running to {s3} as fast as they can,\
 and have split up into three groups to try and avoid capture.\
 I want you to capture all three groups and fetch them back to {s4} by whatever means necessary.\
 I should really have them hanged for attempting to escape, but we need hands for the upcoming harvest,\
 so I'll let them go off this time with a good beating.", "lord_mission_told",
   [
       (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
       (quest_get_slot, ":quest_object_center", "$random_quest_no", slot_quest_object_center),
      
       (str_store_troop_name_link, s9, "$g_talk_troop"),
       (str_store_party_name_link, s3, ":quest_target_center"),
       (str_store_party_name_link, s4, ":quest_object_center"),
       (setup_quest_text,"$random_quest_no"),
       (str_store_string, s2, "str_s9_asked_you_to_catch_the_three_groups_of_runaway_serfs_and_bring_them_back_to_s4_alive_and_breathing_he_said_that_all_three_groups_are_heading_towards_s3"),
    ]],

  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_follow_spy")],
 "I have good information that a man in this very town is actually an enemy spy.\
 He should be seized and hanged for his impudence,\
 but we also believe that very soon he will leave town to meet with his master,\
 the man to whom the spy feeds all his little whispers.\
 The spy himself is of little import, but the master is a dangerous man, and could tell us a great deal\
 if we could only get our hands on him...", "lord_tell_mission_follow_spy",[]],
  [anyone,"lord_tell_mission_follow_spy", [],
 "I want you to wait here until the spy leaves town. Then you must follow him, stealthily, to the meeting place.\
 You must take absolute care not to be seen by the spy on your way, else he may suspect foul play and turn back.\
 When the master appears, you must ambush and arrest them and bring the pair back to me.\
 Alive, if you please.", "lord_tell_mission_follow_spy_2",
   [
    ]],

  [anyone|plyr, "lord_tell_mission_follow_spy_2", [],
 "I'll do it, {s65}.", "lord_tell_mission_follow_spy_accepted", []],
  [anyone|plyr, "lord_tell_mission_follow_spy_2", [],
 "No, this skulking is not for me.", "lord_tell_mission_follow_spy_rejected", []],


  [anyone,"lord_tell_mission_follow_spy_accepted", [],
   "Good, I'm sure you'll do a fine job of it. One of my men will point the spy out to you when he leaves,\
 so you will know the man to follow. Remember, I want them both, and I want them alive.", "close_window",
   [
     (str_store_troop_name_link, s11, "$g_talk_troop"),
     (str_store_party_name_link, s12, "$g_encountered_party"),
     (setup_quest_text, "$random_quest_no"),
     (str_store_string, s2, "@{s11} asked you to follow the spy that will leave {s12}. Be careful not to let the spy see you on the way, or he may get suspicious and turn back. Once the spy meets with his accomplice, you are to capture them and bring them back to {s11}."),
     (call_script, "script_start_quest", "$random_quest_no", "$g_talk_troop"),
     #TODO: Change this value
     (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 1),

     (spawn_around_party, "p_main_party", "pt_spy_partners"),
     (assign, "$qst_follow_spy_spy_partners_party", reg0),
     (party_set_position, "$qst_follow_spy_spy_partners_party", pos63),
     (party_set_ai_behavior, "$qst_follow_spy_spy_partners_party", ai_bhvr_hold),
     (party_set_flags, "$qst_follow_spy_spy_partners_party", pf_default_behavior, 0),
     (set_spawn_radius, 0),
     (spawn_around_party, "$g_encountered_party", "pt_spy"),
     (assign, "$qst_follow_spy_spy_party", reg0),
     (party_set_ai_behavior, "$qst_follow_spy_spy_party", ai_bhvr_travel_to_party),
     (party_set_ai_object, "$qst_follow_spy_spy_party", "$qst_follow_spy_spy_partners_party"),
     (party_set_flags, "$qst_follow_spy_spy_party", pf_default_behavior, 0),
     (assign, "$g_leave_town", 1),
     (rest_for_hours, 2, 4, 0),
     #no need to set g_leave_encounter to 1 since this quest can only be given at a town
   ]],

  [anyone,"lord_tell_mission_follow_spy_rejected", [],
   "A shame. Well, carry on as you were, {playername}...", "lord_pretalk",
   [(troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1)]],




  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_capture_enemy_hero")],
 "There is a difficult job I need done, {playername}, and you may be the {man/one} who can carry it off.\
 I need someone to capture one of the noble lords of {s13} and bring him to me.\
 Afterwards, I'll be able to exchange him in return for a relative of mine held by {s13}.\
 It is a simple enough job, but whomever you choose will be guarded by an elite band of personal retainers.\
 Are you up for a fight?", "lord_tell_mission_capture_enemy_hero",
   [
     (quest_get_slot, ":quest_target_faction", "$random_quest_no", slot_quest_target_faction),
     (str_store_faction_name, s13, ":quest_target_faction"),
    ]],

  [anyone|plyr, "lord_tell_mission_capture_enemy_hero", [],
 "Consider it done, {s65}.", "lord_tell_mission_capture_enemy_hero_accepted", []],
  [anyone|plyr, "lord_tell_mission_capture_enemy_hero", [],
 "I must refuse, {s65}. I am not a kidnapper.", "lord_tell_mission_capture_enemy_hero_rejected", []],

  [anyone,"lord_tell_mission_capture_enemy_hero_accepted", [],
   "I like your spirit! Go and bring me one of our enemies,\
 and I'll toast your name in my hall when you return! And reward you for your efforts, of course...", "close_window",
   [
     (quest_get_slot, ":quest_target_faction", "$random_quest_no", slot_quest_target_faction),
     (str_store_troop_name_link, s11, "$g_talk_troop"),
     (str_store_faction_name_link, s13, ":quest_target_faction"),
     (setup_quest_text, "$random_quest_no"),
     (str_store_string, s2, "@{s11} asked you to capture a lord from {s13}, any lord, and then drag your victim back to {s11} for safekeeping."),
     (call_script, "script_start_quest", "$random_quest_no", "$g_talk_troop"),
     #TODO: Change this value
     (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 1),
     (assign, "$g_leave_encounter",1),
   ]],

  [anyone,"lord_tell_mission_capture_enemy_hero_rejected", [],
   "Clearly you lack the mettle I had thought you possessed. Very well, {playername}, I will find someone else.", "lord_pretalk",
   [(troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1)]],




  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_lend_companion")],
 "I don't have a job for you right now, but your companion {s3} is a skilled {reg3?lass:fellow}\
 and I need someone with {reg3?her:his} talents. Will you lend {reg3?her:him} to me for a while?", "lord_tell_mission_lend_companion",
   [
       (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
       (quest_get_slot, ":quest_target_amount", "$random_quest_no", slot_quest_target_amount),
       (val_add, ":quest_target_amount", 1),
       (assign, reg1, ":quest_target_amount"),
       (str_store_troop_name_link,s9,"$g_talk_troop"),
       (str_store_troop_name,s3,":quest_target_troop"),
       (setup_quest_text,"$random_quest_no"),
       (troop_get_type, reg3, ":quest_target_troop"),
       (str_store_string, s2, "@{s9} asked you to lend your companion {s3} to him for a week."),
    ]],
  [anyone|plyr,"lord_tell_mission_lend_companion", [],
 "How long will you be needing {reg3?her:him}?", "lord_tell_mission_lend_companion_2", []],
  [anyone,"lord_tell_mission_lend_companion_2", [],
 "Just a few days, a week at most.", "lord_mission_lend_companion_told", []],

  [anyone|plyr,"lord_mission_lend_companion_told",
   [(quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),(str_store_troop_name,s3,":quest_target_troop"),],
   "Then I will leave {s3} with you for one week.", "lord_tell_mission_lend_companion_accepted", []],
  [anyone|plyr,"lord_mission_lend_companion_told", [(quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
                                                    (str_store_troop_name,s3,":quest_target_troop"),],
   "I am sorry, but I cannot do without {s3} for a whole week.", "lord_tell_mission_lend_companion_rejected", []],

  [anyone,"lord_tell_mission_lend_companion_accepted", [],
   "I cannot thank you enough, {playername}. Worry not, your companion shall be returned to you with due haste.", "close_window",
   [(call_script, "script_start_quest", "$random_quest_no", "$g_talk_troop"),
    (call_script, "script_change_player_relation_with_troop","$g_talk_troop",1),
    (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
    (party_remove_members, "p_main_party", ":quest_target_troop", 1),
    (assign, "$g_leave_encounter",1),
   ]],

  [anyone,"lord_tell_mission_lend_companion_rejected", [],
   "Well, that's damned unfortunate, but I suppose I cannot force you or {s3} to agree.\
 I shall have to make do without.", "lord_pretalk",
   [(troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1)]],

 
  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_collect_debt")],
   "Some time ago, I loaned out a considerable sum of money to {s3}. {reg4} denars, to be precise.\
 He was supposed to pay it back within a month but I haven't received a copper from him since.\
 That was months ago. If you could collect the debt from him on my behalf,\
 I would be grateful indeed. I would even let you keep one fifth of the money for your trouble.\
 What do you say?", "lord_tell_mission_collect_debt",
   [
     (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
     (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
     (quest_get_slot, reg4, "$random_quest_no", slot_quest_target_amount),
     (str_store_troop_name_link,s9,"$g_talk_troop"),
     (str_store_troop_name_link,s3,":quest_target_troop"),
     (str_store_party_name_link,s4,":quest_target_center"),
     (setup_quest_text,"$random_quest_no"),
     (str_store_string, s2, "@{s9} asked you to collect the debt of {reg4} denars {s3} owes to him. {s3} was at {s4} when you were given this quest."),
   ]],
  [anyone|plyr,"lord_tell_mission_collect_debt", [],
 "Do you know where I can find {s3}, {s65}?", "lord_tell_mission_collect_debt_2", []],
  [anyone,"lord_tell_mission_collect_debt_2", [],
 "If you leave now, you should be able to find him at {s4}.\
 I've no doubt that he will be suitably embarassed by his conduct and give you all the money he owes me.", "lord_tell_mission_collect_debt_3", []],
  [anyone|plyr,"lord_tell_mission_collect_debt_3", [], "Then I will talk to {s3} on your behalf.", "lord_tell_mission_collect_debt_accepted", []],
  [anyone|plyr,"lord_tell_mission_collect_debt_3", [], "Forgive me, {s65}, but I doubt I would be more successful than yourself.", "lord_tell_mission_collect_debt_rejected", []],

  [anyone,"lord_tell_mission_collect_debt_accepted", [], "You made me very happy by accepting this {playername}. Please, talk to {s3} and don't leave him without my money.", "close_window",
   [(call_script, "script_start_quest", "$random_quest_no", "$g_talk_troop"),
    (call_script, "script_change_player_relation_with_troop","$g_talk_troop", 1),
    (assign, "$g_leave_encounter",1),
   ]],

  [anyone,"lord_tell_mission_collect_debt_rejected", [], "Perhaps not, {playername}. I suppose I'm never getting that money back...", "lord_pretalk",
   [(troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1)]],
 
##
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_capture_conspirators")],
## "TODO: I want you to capture troops in {reg1} conspirator parties that plan to rebel against me and join {s3}.", "lord_mission_told",
##   [
##       (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
##       (assign, reg1, "$qst_capture_conspirators_num_parties_to_spawn"),
##       (str_store_troop_name_link,1,"$g_talk_troop"),
##       (str_store_party_name_link,2,"$g_encountered_party"),
##       (str_store_troop_name,3,":quest_target_troop"),
##       (setup_quest_text,"$random_quest_no"),
##       (try_begin),
##         (is_between, "$g_encountered_party", centers_begin, centers_end),
##         (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##       (else_try),
##         (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##       (try_end),
##    ]],
##
##
##  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_defend_nobles_against_peasants")],
## "TODO: I want you to defend {reg1} noble parties against peasants.", "lord_mission_told",
##   [
##       (assign, reg1, "$qst_defend_nobles_against_peasants_num_noble_parties_to_spawn"),
##       (str_store_troop_name_link,1,"$g_talk_troop"),
##       (str_store_party_name_link,2,"$g_encountered_party"),
##       (setup_quest_text,"$random_quest_no"),
##       (try_begin),
##         (is_between, "$g_encountered_party", centers_begin, centers_end),
##         (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##       (else_try),
##         (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##       (try_end),
##    ]],
##
##
  [anyone,"lord_tell_mission", [(eq, "$random_quest_no", "qst_incriminate_loyal_commander"),
                                (quest_get_slot, ":quest_target_troop", "qst_incriminate_loyal_commander", slot_quest_target_troop),
                                (quest_get_slot, ":quest_object_troop", "qst_incriminate_loyal_commander", slot_quest_object_troop),
                                (quest_get_slot, ":quest_target_center", "qst_incriminate_loyal_commander", slot_quest_target_center),
                                (str_store_troop_name_link, s13,":quest_target_troop"),
                                (str_store_party_name_link, s14,":quest_target_center"),
                                (str_store_troop_name_link, s15,":quest_object_troop"),
                                ],
 "I tell you, that blubbering fool {s13} is not fit to rule {s14}.\
 God knows he would be divested of his lands in an instant were it not for one of his loyal vassals, {s15}.\
 As long as he has his vassal aiding him, it will be a difficult job beating him.\
 So I need to get {s15} out of the picture, and I have a plan just to do that...\
 With your help, naturally.", "lord_tell_mission_incriminate_commander",[]],

  [anyone|plyr,"lord_tell_mission_incriminate_commander", [], "{s66}, I am all ears.", "lord_tell_mission_incriminate_commander_2",[]],
  [anyone|plyr,"lord_tell_mission_incriminate_commander", [], "I don't wish to involve myself in anything dishonourable against {s15}.", "lord_tell_mission_incriminate_commander_rejected",[]],

  [anyone,"lord_tell_mission_incriminate_commander_rejected", [], "Dishonourable? Bah!\
 I was hoping I could count on you, {playername}, but you've shown me what a fool I was.\
 I shall have to find someone whose loyalty I can trust.", "lord_pretalk",
   [(call_script, "script_change_player_relation_with_troop","$g_talk_troop",-5),
    (call_script, "script_change_player_honor", 2)]],

  [anyone,"lord_tell_mission_incriminate_commander_2", [], "I have written a fake letter to {s15},\
 bearing my own seal, which implicates him in a conspiracy with us to stage a coup in {s14}, in my favour.\
 If we can make {s13} believe the letter is genuine, he will deal with {s15} very swiftly.\
 Of course, the challenge there is to convince {s13} that the letter is indeed real...", "lord_tell_mission_incriminate_commander_3",[]],

  [anyone|plyr,"lord_tell_mission_incriminate_commander_3", [], "Please continue, {s65}...", "lord_tell_mission_incriminate_commander_4",[]],
  [anyone|plyr,"lord_tell_mission_incriminate_commander_3", [], "No, I will not sully myself with this dishonourable scheme.", "lord_tell_mission_incriminate_commander_rejected",[]],

  [anyone,"lord_tell_mission_incriminate_commander_4", [], "This is where you come into play.\
 You'll take the letter to {s14}, then give it to one of your soldiers and instruct him to take it to {s15}.\
 I will have one of my spies inform the town garrison so that your man will be arrested on his way.\
 The guards will then find the letter and take it to {s13}.\
 They'll torture your man, of course, to try and get the truth out of him,\
 but all he knows is that you ordered the letter to be delivered to {s15} under the utmost secrecy.\
 {s13} knows you serve me, and the fool will certainly believe the whole charade.", "lord_tell_mission_incriminate_commander_5",[]],
  
  [anyone|plyr,"lord_tell_mission_incriminate_commander_5", [], "Is that all?", "lord_tell_mission_incriminate_commander_7",[]],
  [anyone,"lord_tell_mission_incriminate_commander_7", [(str_store_troop_name, s8, "$incriminate_quest_sacrificed_troop"),
                                                        (str_store_troop_name_plural, s9, "$incriminate_quest_sacrificed_troop"),
      ], "There is one more thing...\
 Your messenger must be someone trustworthy. If you sent the letter with a simple peasant, someone expendable,\
 {s13} might suspect a plot. He may have the wits of a snail, but even a snail can see the obvious.\
 Give the letter to someone of rank. One of your {s9}, perhaps.", "lord_tell_mission_incriminate_commander_8",[]],
  [anyone|plyr,"lord_tell_mission_incriminate_commander_8", [], "What? I can't send one of my trusted {s9} to his death!", "lord_tell_mission_incriminate_commander_9",[]],
  [anyone|plyr,"lord_tell_mission_incriminate_commander_8", [], "Then a {s8} it will be.", "lord_tell_mission_incriminate_commander_fin",[]],
  [anyone,"lord_tell_mission_incriminate_commander_9", [], "Come now, {playername}.\
 There is a place for sentimentality, but this is not it. Believe me, you shall be generously compensated,\
 and what is the purpose of soldiers if not to die at our say-so?", "lord_tell_mission_incriminate_commander_10",[]],
  [anyone|plyr,"lord_tell_mission_incriminate_commander_10", [], "A {s8} it is.", "lord_tell_mission_incriminate_commander_fin",[]],
  [anyone|plyr,"lord_tell_mission_incriminate_commander_10", [], "No, I'll not sacrifice one of my chosen men.", "lord_tell_mission_incriminate_commander_rejected",[]],
   
 [anyone,"lord_tell_mission_incriminate_commander_fin", [], "I can't tell you how pleased I am to hear that,\
 {playername}. You are removing one of the greatest obstacles in my path.\
 Here is the letter, as well as 300 denars for your expenses.\
 Remember, there'll be more once you succeed. Much, much more...", "lord_pretalk",
   [
       (quest_get_slot, ":quest_target_troop", "qst_incriminate_loyal_commander", slot_quest_target_troop),
       (quest_get_slot, ":quest_object_troop", "qst_incriminate_loyal_commander", slot_quest_object_troop),
       (quest_get_slot, ":quest_target_center", "qst_incriminate_loyal_commander", slot_quest_target_center),
       (call_script, "script_troop_add_gold", "trp_player", 300),
       (call_script, "script_change_player_relation_with_troop","$g_talk_troop",2),
       (str_store_troop_name_link, s11,"$g_talk_troop"),
       (str_store_troop_name_link, s13,":quest_target_troop"),
       (str_store_party_name_link, s14,":quest_target_center"),
       (str_store_troop_name_plural, s15,"$incriminate_quest_sacrificed_troop"),
       (str_store_troop_name_link, s16,":quest_object_troop"),
       (setup_quest_text,"$random_quest_no"),
       (str_store_string, s2, "@{s11} gave you a fake letter to fool {s13} into banishing his vassal {s16}.\
 You are to go near {s14}, give the letter to one of your {s15} and send him into the town as a messenger,\
 believing his orders to be genuine."),
       (call_script, "script_start_quest", "$random_quest_no", "$g_talk_troop"),
    ]],

  [anyone,"lord_tell_mission", [(eq,"$random_quest_no","qst_capture_prisoners")],
 "A group of my soldiers were captured in a recent skirmish with the enemy.\
 Thankfully we have a mutual agreement of prisoner exchange, and they will release my men,\
 but they want us to give them prisoners of equal rank and number. Prisoners I don't currently have.\
 So, I need a good {man/warrior} to find me {reg1} {s3} as prisoners, that I may exchange them.", "lord_mission_told",
   [
       (quest_get_slot, ":quest_target_troop", "qst_capture_prisoners", slot_quest_target_troop),
       (quest_get_slot, ":quest_target_amount", "qst_capture_prisoners", slot_quest_target_amount),
       (assign,reg1,":quest_target_amount"),
       (str_store_troop_name_link,s9,"$g_talk_troop"),
       (str_store_troop_name_by_count,s3,":quest_target_troop",":quest_target_amount"),
       (setup_quest_text,"$random_quest_no"),
       (str_store_string, s2, "@{s9} has requested you to bring him {reg1} {s3} as prisoners."),
    ]],
  

  [anyone,"lord_tell_mission", [], "No {playername}. I do not need your help at this time.", "lord_pretalk",[]],


  [anyone|plyr,"lord_mission_told", [], "You can count on me, {s65}.", "lord_mission_accepted",[]],
  [anyone|plyr,"lord_mission_told", [], "I fear I cannot accept such a mission at the moment.", "lord_mission_rejected",[]],

  [anyone,"lord_mission_accepted", [], "Excellent, {playername}, excellent. I have every confidence in you.", "close_window",
   [(assign, "$g_leave_encounter",1),
    (try_begin),
      (eq, "$random_quest_no", "qst_escort_lady"),
      (quest_get_slot, ":quest_object_troop", "$random_quest_no", slot_quest_object_troop),
      (troop_set_slot, ":quest_object_troop", slot_troop_cur_center, 0),
      (troop_join, ":quest_object_troop"),
    (else_try),
      (eq, "$random_quest_no", "qst_deliver_message_to_enemy_lord"),
      (call_script, "script_troop_add_gold", "trp_player", 10),
    (else_try),
      (eq, "$random_quest_no", "qst_bring_back_runaway_serfs"),
      (quest_get_slot, ":quest_giver_center", "$random_quest_no", slot_quest_giver_center),
      (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
      (quest_get_slot, ":quest_target_party_template", "$random_quest_no", slot_quest_target_party_template),

      (set_spawn_radius, 3),
      (spawn_around_party,":quest_giver_center",":quest_target_party_template"),
      (assign, "$qst_bring_back_runaway_serfs_party_1", reg0),
      (party_set_ai_behavior,"$qst_bring_back_runaway_serfs_party_1",ai_bhvr_travel_to_party),
      (party_set_ai_object,"$qst_bring_back_runaway_serfs_party_1",":quest_target_center"),
      (party_set_flags, "$qst_bring_back_runaway_serfs_party_1", pf_default_behavior, 0),
      (spawn_around_party,":quest_giver_center",":quest_target_party_template"),
      (assign, "$qst_bring_back_runaway_serfs_party_2", reg0),
      (party_set_ai_behavior,"$qst_bring_back_runaway_serfs_party_2",ai_bhvr_travel_to_party),
      (party_set_ai_object,"$qst_bring_back_runaway_serfs_party_2",":quest_target_center"),
      (party_set_flags, "$qst_bring_back_runaway_serfs_party_2", pf_default_behavior, 0),
      (spawn_around_party,":quest_giver_center",":quest_target_party_template"),
      (assign, "$qst_bring_back_runaway_serfs_party_3", reg0),
      (party_set_ai_behavior,"$qst_bring_back_runaway_serfs_party_3",ai_bhvr_travel_to_party),
      (party_set_ai_object,"$qst_bring_back_runaway_serfs_party_3",":quest_target_center"),
      (party_set_flags, "$qst_bring_back_runaway_serfs_party_3", pf_default_behavior, 0),
      (rest_for_hours, 1, 4),
    (try_end),
    (call_script, "script_start_quest", "$random_quest_no", "$g_talk_troop"),
    (try_begin),
      (eq, "$random_quest_no", "qst_lend_surgeon"),
      (assign, "$g_leave_town_outside", 1),
      (assign,"$auto_enter_town","$g_encountered_party"),
      (rest_for_hours, 4),
      (assign, "$lord_requested_to_talk_to", "$g_talk_troop"),
    (try_end),
    ]],

  [anyone,"lord_mission_rejected", [], "Is that so? Well, I suppose you're just not up to the task.\
 I shall have to look for somebody with more mettle.", "close_window",
   [(assign, "$g_leave_encounter",1),
    (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", -1),
    (try_begin),
      (quest_slot_eq, "$random_quest_no", slot_quest_dont_give_again_remaining_days, 0),
      (quest_set_slot, "$random_quest_no", slot_quest_dont_give_again_remaining_days, 1),
    (try_end),
    (troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1),
    ]],


##### TODO: QUESTS COMMENT OUT END

#Leave
  [anyone|plyr,"lord_talk", 
  [
    (troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
  ], "I must leave now.", "lord_leave_prison",[]],
  
  [anyone|plyr,"lord_talk", 
  [
    (lt, "$g_talk_troop_faction_relation", 0),
    (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
  ], "This audience is over. I leave now.", "lord_leave",[]],
    
  [anyone|plyr,"lord_talk", 
  [
    (ge, "$g_talk_troop_faction_relation", 0),
    (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
  ], "I must beg my leave.", "lord_leave",[]],

  [anyone,"lord_leave", [#(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
      (neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
      (lt, "$g_talk_troop_faction_relation", 0),
      (store_partner_quest,":enemy_lord_quest"),
      (lt, ":enemy_lord_quest", 0),
      (troop_slot_eq, "$g_talk_troop", slot_troop_does_not_give_quest, 0),      
      (call_script, "script_get_quest", "$g_talk_troop"),
      (assign, "$random_quest_no", reg0),
      (ge, "$random_quest_no", 0),
	  (this_or_next|eq, "$random_quest_no", "qst_lend_surgeon"), #so far only for quest lend surgeon
		(eq, 2, 1),
    ],
   "Before you go, {playername}, I have something to ask of you... We may be enemies in this war,\
 but I pray that you believe, as I do, that we can still be civil towards each other.\
 Thus I hoped that you would be kind enough to assist me in something important to me.", "lord_leave_give_quest",[]],

  [anyone|plyr,"lord_leave_give_quest", [],
   "I am listening.", "enemy_lord_tell_mission",[]],


  [anyone,"enemy_lord_tell_mission", [(eq,"$random_quest_no","qst_lend_surgeon")],
   "I have a friend here, an old warrior, who is very sick. Pestilence has infected an old battle wound,\
 and unless he is seen to by a surgeon soon,  he will surely die. This man is dear to me, {playername},\
 but he's also stubborn as a hog and refuses to have anyone look at his injury because he doesn't trust the physicians here.\
 I have heard that you've a capable surgeon with you. If you would let your surgeon come here and have a look,\
 {reg3?she:he} may be able to convince him to give his consent to an operation.\
 Please, I will be deeply indebted to you if you grant me this request.", "lord_mission_told",
   [
     (quest_get_slot, ":quest_object_troop", "$random_quest_no", slot_quest_object_troop),
     (str_store_troop_name_link,1,"$g_talk_troop"),
##     (str_store_party_name,2,"$g_encountered_party"),
     (str_store_troop_name,3,":quest_object_troop"),
     (troop_get_type, reg3, ":quest_object_troop"),
     (setup_quest_text,"$random_quest_no"),
##     (try_begin),
##       (is_between, "$g_encountered_party", centers_begin, centers_end),
##       (setup_quest_giver, "$random_quest_no", "str_given_by_s1_at_s2"),
##     (else_try),
##       (setup_quest_giver,"$random_quest_no", "str_given_by_s1_in_wilderness"),
##     (try_end),
     (str_store_string, s2, "@Lend your experienced surgeon {s3} to {s1}."),
   ]],

  [anyone,"enemy_lord_tell_mission", [(str_store_quest_name, s7, "$random_quest_no")],
   "{!}ERROR: MATCHED WITH QUEST: {s7}.", "close_window",
   []],

  [anyone,"lord_leave_prison", [],
   "We'll meet again.", "close_window",[]],

 [anyone|auto_proceed,"lord_leave", [
	(troop_get_type, ":type", "trp_player"),
	(eq, ":type", 1),
	(call_script, "script_troop_get_romantic_chemistry_with_troop", "trp_player", "$g_talk_troop"),
	(gt, reg0, 7),
	(ge, "$g_talk_troop_relation", 0),
	(neg|troop_slot_ge, "$g_talk_troop", slot_troop_betrothed, active_npcs_begin),
	(neg|troop_slot_ge, "$g_talk_troop", slot_troop_spouse, active_npcs_begin),
	(neg|troop_slot_ge, "trp_player", slot_troop_betrothed, active_npcs_begin),
	(neg|troop_slot_ge, "trp_player", slot_troop_spouse, active_npcs_begin),
	
	(neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"),
	
 ],
   "Farewell, my lady. I shall remain your most ardent admirer.", "close_window",
   [(eq,"$talk_context",tc_party_encounter),
   (assign, "$g_leave_encounter", 1)]],
    
   
  [anyone|auto_proceed,"lord_leave", [(faction_slot_eq,"$g_talk_troop_faction",slot_faction_leader,"$g_talk_troop")],
   "Of course, {playername}. Farewell.", "close_window",[(eq,"$talk_context",tc_party_encounter),(assign, "$g_leave_encounter", 1)]],
  [anyone|auto_proceed,"lord_leave", [(ge,"$g_talk_troop_relation",10)],
   "Good journeys to you, {playername}.", "close_window",[(eq,"$talk_context",tc_party_encounter),(assign, "$g_leave_encounter", 1)]],
  [anyone|auto_proceed,"lord_leave", [(ge, "$g_talk_troop_faction_relation", 0)],
   "Yes, yes. Farewell.", "close_window",[(eq,"$talk_context",tc_party_encounter),(assign, "$g_leave_encounter", 1)]],
  [anyone|auto_proceed,"lord_leave", [],
   "We will meet again.", "close_window",[(eq,"$talk_context",tc_party_encounter),(assign, "$g_leave_encounter", 1)]],


#Royal family members


  [anyone|plyr,"member_chat", [(troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady)],
   "Are you enjoying the journey, {s65}?", "lady_journey_1",[]],
  [anyone,"lady_journey_1", [],
   "I am doing quite fine, {playername}. Thank you for your concern.", "close_window",[]],
  

#Spouse
  [anyone,"start",
   [
    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
#    (troop_slot_eq, "$g_talk_troop", slot_troop_spouse, "trp_player"),
    (troop_slot_eq, "trp_player", slot_troop_spouse, "$g_talk_troop"),
    ],
   "Yes, my husband?", "spouse_talk",[
 ]],

  [anyone|plyr,"spouse_talk",
   [
   (eq, "$g_player_minister", "$g_talk_troop"),
   ],
   "As you are my chief minister, I wish to speak to about affairs of state", "minister_issues",[
 ]],

  [anyone|plyr,"spouse_talk",
   [
   (assign, "$political_quest_to_cancel", -1),
   (try_begin),
	(check_quest_active, "qst_offer_gift"),
	(quest_slot_eq, "qst_offer_gift", slot_quest_giver_troop, "$g_talk_troop"),
    (assign, "$political_quest_to_cancel", "qst_offer_gift"),
	(str_store_string, s10, "str_offer_gift_description"),
   (else_try),
	(check_quest_active, "qst_resolve_dispute"),
	(quest_slot_eq, "qst_resolve_dispute", slot_quest_giver_troop, "$g_talk_troop"),
    (assign, "$political_quest_to_cancel", "qst_resolve_dispute"),
	(str_store_string, s10, "str_resolve_dispute_description"),
   (try_end),	
   (gt, "$political_quest_to_cancel", 0),
   ],
   "Let's abandon our plan to {s10}.", "spouse_cancel_political_quest",[
 ]],
 
  [anyone,"spouse_cancel_political_quest",
   [],
   "Are you sure you want to drop that idea?", "spouse_cancel_political_quest_confirm",[
 ]],
  [anyone|plyr,"spouse_cancel_political_quest_confirm",
   [],
   "Yes, I am sure. Let's abandon that idea.", "spouse_pretalk",[
   (call_script, "script_abort_quest", "$political_quest_to_cancel", 1),
 ]],
  [anyone|plyr,"spouse_cancel_political_quest_confirm",
   [],
   "Actually, never mind.", "spouse_pretalk",[
 ]],


 
  [anyone|plyr,"spouse_talk",
   [],
   "Let us think of a way to improve our standing in this realm", "combined_political_quests",[
   (call_script, "script_get_political_quest", "$g_talk_troop"),
   (assign, "$political_quest_found", reg0),
   (assign, "$political_quest_target_troop", reg1),
   (assign, "$political_quest_object_troop", reg2),   
 ]],

  [anyone|plyr, "spouse_talk", 
   [
	(neg|check_quest_active, "qst_organize_feast"),
   ],
   "I was thinking that perhaps we could host a feast", "spouse_organize_feast",[
 ]],

  [anyone|plyr, "spouse_talk", 
   [
   ],
   "Let us take inventory of our household possessions", "spouse_household_possessions",[
   (change_screen_loot, "trp_household_possessions"),
 ]],

  [anyone, "spouse_household_possessions", 
   [
   ],
   "Anyway, that is the content of our larder.", "spouse_pretalk",[
 ]],
 
 
  [anyone|plyr,"spouse_talk",
   [],
   "We shall speak later, my {wife/husband}", "close_window",[
   (assign, "$g_leave_encounter", 1),
 ]],

 
 

#Bride
  [anyone,"wedding_ceremony_bride_vow",
   [
#    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
#	(check_quest_active, "qst_wed_betrothed"),
#	(quest_slot_eq, "qst_wed_betrothed", slot_quest_target_troop, "$g_talk_troop"),
#	(quest_slot_eq, "qst_wed_betrothed", slot_quest_current_state, 2),
#	(neg|quest_slot_ge, "qst_wed_betrothed", slot_quest_expiration_days, 2),
    ],
   "My husband, I hearby pledge to be your wife, to stand with you in good times and bad. May the heavens smile upon us and bless us with children, livestock, and land.", "wedding_ceremony_player_vow",[
   (quest_get_slot, ":bride", "qst_wed_betrothed", slot_quest_target_troop),
   (set_conversation_speaker_troop, ":bride"),
 ]],

  [anyone|plyr,"wedding_ceremony_player_vow",
   [],
   "I pledge the same. Let us be husband and wife.", "wedding_ceremony_vows_complete",[
 ]],
 
  [anyone|plyr,"wedding_ceremony_player_vow",
   [],
   "Wait -- hold on... I'm not quite ready for this.", "close_window",[
 ]],
 
  [anyone,"wedding_ceremony_vows_complete",
   [],
   "I now declare you and {s3} to be husband and wife. Go now to the chamber prepared for you, and we shall make arrangements for your bride to join you in your hall in {s11}.", "close_window",[
   	(call_script, "script_courtship_event_bride_marry_groom", "$g_player_bride", "trp_player", 0), #parameters from dialog
	(call_script, "script_get_kingdom_lady_social_determinants", "$g_player_bride"),
	(str_store_troop_name, s3, "$g_player_bride"),
	
    (try_begin),
		(neq, reg0, "trp_player"),
		(str_store_string, s11, "str_error__player_not_logged_as_groom"),
	(else_try),
		(str_store_party_name, s11, reg1),
		(troop_set_slot, "$g_player_bride", slot_troop_cur_center, reg1),
	(try_end),
 ]],
 #WEDDING CUTSCENE BEGINS HERE

  [anyone, "spouse_pretalk", 
   [],
   "Is there anything else, my {husband/wife}?", "spouse_talk",[
 ]],


 
 
 
 
#take inventory
 [anyone,"spouse_organize_feast",
   [
   (faction_slot_eq, "$players_kingdom", slot_faction_ai_state, sfai_feast),
   (faction_slot_eq, "$players_kingdom", slot_faction_ai_object, "$g_encountered_party"),
   ],
   "A splendid idea, my {husband/wife}. However, let us wait for the current feast here to conclude, before organizing another.", "spouse_pretalk",[
 ]],

 [anyone,"spouse_organize_feast",
   [
   (eq, "$players_kingdom", "fac_player_supporters_faction"),
   (neg|is_between, "$g_player_court", centers_begin, centers_end),
   ],
   "A splendid idea, my {husband/wife}. However, we must establish a court before hosting a feast.", "spouse_pretalk",[
 ]],
 
 [anyone,"spouse_organize_feast",
   [
   (eq, "$players_kingdom", "fac_player_supporters_faction"),
   (store_current_hours, ":hours_since_last_feast"),
   (faction_get_slot, ":last_feast_time", "$players_kingdom", slot_faction_last_feast_start_time),
   (val_sub, ":hours_since_last_feast", ":last_feast_time"),
   (try_begin),
	(ge, "$cheat_mode", 1),
	(assign, reg4, ":hours_since_last_feast"),
	(str_store_faction_name, s4, "$players_kingdom"),
	(display_message, "@{!}DEBUG -- {reg4} hours since last feast for {s4}"),
   (try_end),
   (lt, ":hours_since_last_feast", 120),
   (store_sub, ":days_to_wait", 168, ":hours_since_last_feast"),
   (val_div, ":days_to_wait", 24),
   (assign, reg3, ":days_to_wait"),   
   ],
   "A splendid idea, my {husband/wife}. However, our realm has recently had a feast. Perhaps we should wait another {reg3} days before we organize another one.", "spouse_pretalk",[
 ]],



 
 
 [anyone,"spouse_organize_feast",
   [],
   "A splendid idea, my {husband/wife}. However, to not insult our guests, we must make sure that we can provide a large and varied repast, for the lords, their families, and their retinues. All told, we should count on a couple of hundred mouths to feed, over several days. Let us take an inventory of our household possessions...", "spouse_evaluate_larder_for_feast",[
 ]],

  [anyone, "spouse_evaluate_larder_for_feast",
   [
   (call_script, "script_internal_politics_rate_feast_to_s9", "trp_household_possessions", 600, "$players_kingdom", 0),   #party, number of guests, taste, consume items
   (assign, "$feast_quality", reg0),
   ],
   "{s9}",   "spouse_feast_confirm",[]],


  [anyone|plyr, "spouse_feast_confirm",
   [
   ],
   "Let me add more items to our storehouses",   "spouse_feast_added_items", [
   (change_screen_loot, "trp_household_possessions"),
   ]],

  [anyone, "spouse_feast_added_items",
   [],
   "All right -- let me reevalute what is there...",   "spouse_evaluate_larder_for_feast",[]],
   
   
   
  [anyone|plyr, "spouse_feast_confirm",
   [
   (gt, "$feast_quality", 1),
   ],
   "Let us dispatch the invitations",   "spouse_feast_confirm_yes", []],
   
  [anyone|plyr, "spouse_feast_confirm",
   [
   ],
   "Let us wait, then",   "spouse_pretalk",[]],

   
  [anyone, "spouse_feast_confirm_yes",
   [ (neq, "$players_kingdom", "fac_player_supporters_faction"),],
   "I shall send word, then, that we will host a feast as soon as conditions in the realm permit. You perhaps should continue to stock our larder, so that we may do justice to our reputation for hospitality.",   "spouse_pretalk",[

   
    (assign, ":feast_venue", -1),
    (try_begin),
		(is_between, "$g_encountered_party", walled_centers_begin, walled_centers_end),
		(this_or_next|party_slot_eq, "$g_encountered_party", slot_town_lord, "trp_player"),
			(party_slot_eq, "$g_encountered_party", slot_town_lord, "$g_talk_troop"),
		(assign, ":feast_venue", "$g_encountered_party"),	
	(else_try),
		(try_for_range, ":center", walled_centers_begin, walled_centers_end),
			(eq, ":feast_venue", -1),
			(this_or_next|party_slot_eq, ":center", slot_town_lord, "trp_player"),
				(party_slot_eq, ":center", slot_town_lord, "$g_talk_troop"),
			(assign, ":feast_venue", ":center"),	
		(try_end),
	(else_try),
		(is_between, "$g_encountered_party", walled_centers_begin, walled_centers_end),
		(assign, ":feast_venue", "$g_encountered_party"),
    (try_end),


	(str_store_party_name, s9, ":feast_venue"),
	(setup_quest_text, "qst_organize_feast"),
	(str_store_string, s2, "str_you_intend_to_bring_goods_to_s9_in_preparation_for_the_feast_which_will_be_held_as_soon_as_conditions_permit"),
	
	(quest_set_slot, "qst_organize_feast", slot_quest_target_center, ":feast_venue"),
	(quest_set_slot, "qst_organize_feast", slot_quest_expiration_days, 30),
	(call_script, "script_start_quest", "qst_organize_feast", "$g_talk_troop"),
   ]],
 
   [anyone, "spouse_feast_confirm_yes",
   [
   ],
   "Very well, then. Let the feast begin immediately at our court {reg4?here:} in {s9}. You perhaps should continue to stock our larder, so that we may do justice to our reputation for hospitality. You may declare the feast to be concluded at any time, either by beginning a campaign or by letting it be known that the vassals can return to their homes.",   "spouse_pretalk",[

   (str_store_party_name, s9, "$g_player_court"),
   (setup_quest_text, "qst_organize_feast"),
   (str_store_string, s2, "str_you_intend_to_bring_goods_to_s9_in_preparation_for_the_feast_which_will_be_held_as_soon_as_conditions_permit"),
   
   (quest_set_slot, "qst_organize_feast", slot_quest_target_center, "$g_player_court"),
   (quest_set_slot, "qst_organize_feast", slot_quest_expiration_days, 30),
   (call_script, "script_start_quest", "qst_organize_feast", "$g_talk_troop"),
   
   (faction_set_slot, "$players_kingdom", slot_faction_ai_state, sfai_feast),
   (faction_set_slot, "$players_kingdom", slot_faction_ai_object, "$g_player_court"),
   
   (assign, "$player_marshal_ai_state", sfai_feast),
   (assign, "$player_marshal_ai_object", "$g_player_court"),
   
   (assign, "$g_recalculate_ais", 1),
   (assign, reg4, 1),
   (try_begin),
	(neq, "$g_encountered_party", "$g_player_court"),
	(assign, reg4, 0),
   (try_end),
   ]],

  [anyone,"start",	#too early
   [
    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
	(check_quest_active, "qst_wed_betrothed"),
	(quest_slot_eq, "qst_wed_betrothed", slot_quest_target_troop, "$g_talk_troop"),
	(quest_slot_ge, "qst_wed_betrothed", slot_quest_expiration_days, 2),
    ],
   "How wonderful it is... In a short while we shall be married! However, I should point out that, in the remaining few days, it is not customary for us to speak too much together.", "close_window",[
	(try_begin),
		(check_quest_active, "qst_visit_lady"),
		(quest_slot_eq, "qst_visit_lady", slot_quest_giver_troop, "$g_talk_troop"),
		(call_script, "script_end_quest", "qst_visit_lady"),
	(try_end),
 ]],
 
  [anyone,"start",
   [
    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
	(check_quest_active, "qst_wed_betrothed"),
	(quest_slot_eq, "qst_wed_betrothed", slot_quest_target_troop, "$g_talk_troop"),
	(call_script, "script_get_kingdom_lady_social_determinants", "$g_talk_troop"),
	(assign, ":guardian", reg0),
#	(call_script, "script_get_heroes_attached_to_center", "$g_encountered_party", "p_temp_party"),
	(troop_get_slot, ":guardian_led_party", ":guardian", slot_troop_leaded_party),
	(party_is_active, ":guardian_led_party"),
	(party_get_attached_to, ":guardian_led_party_attached", ":guardian_led_party"),
	(eq, ":guardian_led_party_attached", "$g_encountered_party"),
	
	(call_script, "script_troop_get_family_relation_to_troop", ":guardian", "$g_talk_troop"),
	(str_store_troop_name, s4, ":guardian"),
	#use current location, or party is in?
    ],
   "Em, {playername}, you might not be used to our wedding customs, but I had hoped that someone would tell you... Speak first to my {s11}, {s4}.", "close_window",[
 ]],

  [anyone,"start",
   [
    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
	(check_quest_active, "qst_wed_betrothed"),
	(quest_slot_eq, "qst_wed_betrothed", slot_quest_target_troop, "$g_talk_troop"),
	(quest_get_slot, ":giver_troop", "qst_wed_betrothed", slot_quest_giver_troop),
	(call_script, "script_troop_get_family_relation_to_troop", ":giver_troop", "$g_talk_troop"),
    (str_store_troop_name, s10, ":giver_troop"),	
    ],
   "I do not know where to find my {s11} {s10}, who by tradition should preside over our wedding. Perhaps we should wait until he can be found...", "close_window",[
   (assign, "$g_leave_encounter", 1),
 ]],
 
 
 
#Captive 
  [anyone,"start",
   [
    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
	(neq, "$g_talk_troop_faction", "$g_encountered_party_faction"),
	(party_get_slot, ":town_lord", "$g_encountered_party"),
	(ge, ":town_lord", active_npcs_begin),
	(str_store_troop_name, s12, ":town_lord"),
    ],
   "The honorable {s12} has agreed to allow us to return home to our families. We shall be departing shortly.", "close_window",[
 ]],

  [anyone,"start", #default for time since last talk
   [
    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
	(neg|troop_slot_eq, "trp_player", slot_troop_spouse, "$g_talk_troop"),
	(neq, "$g_talk_troop_faction", "$g_encountered_party_faction"),
    (troop_slot_eq, "$g_talk_troop", slot_troop_prisoner_of_party, "$g_encountered_party"),
	(gt, "$g_time_since_last_talk", 24),
    ],
   "So great is my loneliness! How I miss my family!", "kingdom_lady_captive",[
 ]],

 
 
  [anyone,"start",
   [
    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
	(neg|troop_slot_eq, "trp_player", slot_troop_spouse, "$g_talk_troop"),
	(neq, "$g_talk_troop_faction", "$g_encountered_party_faction"),
    (troop_slot_eq, "$g_talk_troop", slot_troop_prisoner_of_party, "$g_encountered_party"),
	(lt, "$g_talk_troop_relation", 1),
    ],
   "You are a cad, {sir/madame}, to hold a lady like this...", "kingdom_lady_captive",[
 ]],
 
  [anyone,"start",
   [
    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
	(neg|troop_slot_eq, "trp_player", slot_troop_spouse, "$g_talk_troop"),
	(neq, "$g_talk_troop_faction", "$g_encountered_party_faction"),
    (troop_slot_eq, "$g_talk_troop", slot_troop_prisoner_of_party, "$g_encountered_party"),
	(lt, "$g_talk_troop_relation", 11),
    ],
   "It is strange. On occasion you have shown me such kindness, and yet you continue to hold me here against my will.", "kingdom_lady_captive",[
 ]],

  [anyone,"start",
   [
    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
	(neg|troop_slot_eq, "trp_player", slot_troop_spouse, "$g_talk_troop"),
	(neq, "$g_talk_troop_faction", "$g_encountered_party_faction"),
    (troop_slot_eq, "$g_talk_troop", slot_troop_prisoner_of_party, "$g_encountered_party"),
    ],
   "Why haven't my family paid my ransom? You may hold me as prisoner, but it seems that you care for me more than they do!", "kingdom_lady_captive",[
 ]],


  [anyone|auto_proceed, "start", 
  [
    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
	(neg|troop_slot_eq, "trp_player", slot_troop_spouse, "$g_talk_troop"),
	(neq, "$g_talk_troop_faction", "$g_encountered_party_faction"),
    (troop_slot_eq, "$g_talk_troop", slot_troop_cur_center, "$g_encountered_party"),
	
	(call_script, "script_get_kingdom_lady_social_determinants", "$g_talk_troop"),
	(assign, ":guardian", reg0),
	(neq, "$g_encountered_party_faction", "fac_player_supporters_faction"),
	
	(store_faction_of_troop, ":guardian_faction", ":guardian"),
	(neq, ":guardian_faction", "$g_encountered_party_faction"),
  ],  
  "{!}.", "lady_stranded_next", 
  []],

  [anyone,"lady_stranded_next",
   [],
   "Greetings, {sir/my lady}. The tides of war have left me stranded here in this fortress, but I will shortly be departing. ", "close_window",[
 ]],


 
  [anyone,"start",
   [
    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
	(neg|troop_slot_eq, "trp_player", slot_troop_spouse, "$g_talk_troop"),
	(neq, "$g_talk_troop_faction", "$g_encountered_party_faction"),
    (troop_slot_eq, "$g_talk_troop", slot_troop_cur_center, "$g_encountered_party"),
	
	(call_script, "script_get_kingdom_lady_social_determinants", "$g_talk_troop"),
	(assign, ":guardian", reg0),
	(store_faction_of_troop, ":guardian_faction", ":guardian"),
	(neq, ":guardian_faction", "$g_encountered_party_faction"),
	
    ],
   "{playername} -- I assume that you, as a {man/lady} of honor, will accord gentle-born ladies such as ourselves the right to return to our families, and not demand a ransom.", "lady_talk_refugee",[
 ]],


  [anyone,"start", [(troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
                    (check_quest_active, "qst_escort_lady"),
                    (eq, "$talk_context", tc_entering_center_quest_talk),
                    (quest_slot_eq, "qst_escort_lady", slot_quest_object_troop, "$g_talk_troop")],
   "Thank you for escorting me here, {playername}. Please accept this gift as a token of my gratitude.\
 I hope we shall meet again sometime in the future.", "lady_escort_lady_succeeded",
   [
     (quest_get_slot, ":cur_center", "qst_escort_lady", slot_quest_target_center),
     (add_xp_as_reward, 300),
     (call_script, "script_troop_add_gold", "trp_player", 250),
     (call_script, "script_end_quest", "qst_escort_lady"),
     (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 2),
     (troop_set_slot, "$g_talk_troop", slot_troop_cur_center, ":cur_center"),
     (remove_member_from_party,"$g_talk_troop"),
     ]],

	[anyone|plyr,"lady_escort_lady_succeeded", [], "It was an honor to serve you, {s65}.", "close_window",[]],


  [anyone,"start",
   [
    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
	(neg|troop_slot_eq, "trp_player", slot_troop_spouse, "$g_talk_troop"),
	(neq, "$g_talk_troop_faction", "$g_encountered_party_faction"),
    (troop_get_slot, ":new_location", "$g_talk_troop", slot_troop_cur_center),
	(str_clear, s5),
	(try_begin),
		(is_between, ":new_location", centers_begin, centers_end),
		(str_store_party_name, s4, ":new_location"),
		(str_store_string, s5, "str_for_s4"),
	(try_end),
    ],
   "We will shortly depart{s5}. It is good to know that some people in this world retain a sense of honor.", "close_window",[
 ]],
 
 
  [anyone|plyr,"lady_talk_refugee",
   [],
   "Of course, my lady", "close_window",[
    (troop_get_slot, ":current_location", "$g_talk_troop", slot_troop_cur_center),
	(call_script, "script_get_kingdom_lady_social_determinants", "$g_talk_troop"),
	(assign, ":new_location", reg1),
	(troop_set_slot, "$g_talk_troop", slot_troop_cur_center, ":new_location"),
	(try_begin),
		(neq, ":current_location", ":new_location"),
		(call_script, "script_troop_change_relation_with_troop", "trp_player", "$g_talk_troop", 1),
    (try_end),
 ]],

  [anyone|plyr,"lady_talk_refugee",
   [],
   "You assume wrong, my lady!", "lady_captive_talk",[
 ]],

  [anyone,"lady_captive_talk",
   [],
   "What?! What infamy is this?", "lady_captive_confirm",[
 ]],

  [anyone|plyr,"lady_captive_confirm",
   [],
   "My apologies - you must have misunderstood me. Of course you may leave.", "close_window",[
 ]],

  [anyone|plyr,"lady_captive_confirm",
   [],
   "Contact your family to arrange for a ransom, my lady.", "close_window",[
    (troop_set_slot, "$g_talk_troop", slot_troop_prisoner_of_party, "$g_encountered_party"),
	(call_script, "script_change_player_honor", -2),
	(call_script, "script_troop_change_relation_with_troop", "trp_player", "$g_talk_troop", -10),

#incomplete -- make sure ransoms are offered for ladies
 ]],
 
 
  [anyone|plyr,"kingdom_lady_captive",
   [],
   "Then write to your family, and ask them to hurry up with the ransom!", "close_window",[
 ]],#incomplete
 


#  [anyone|plyr,"kingdom_lady_captive",
#   [
#    (troop_get_slot, ":is_female", "trp_player"),
#	(eq, ":is_female", 0),
   
#   (troop_slot_eq, "$g_talk_troop", slot_troop_spouse, -1),
#   (troop_slot_eq, "trp_player", slot_troop_spouse, -1),
#   ],
#   "Then marry me forthwith, and stay here as my wife", "close_window",[
# ]],#incomplete

 
  [anyone|plyr,"kingdom_lady_captive",
   [],
   "I have changed my mind -- you are free to go", "close_window",[
    (troop_set_slot, "$g_talk_troop", slot_troop_prisoner_of_party, -1),
	(troop_set_slot, "$g_talk_troop", slot_troop_met, 1),
	]],#incomplete

	


 
#Kingdom ladies quest resolution  

  [anyone,"start",
   [
    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
	(check_quest_active, "qst_duel_courtship_rival"),
    (check_quest_failed, "qst_duel_courtship_rival"),
    (quest_slot_eq, "qst_duel_courtship_rival", slot_quest_giver_troop, "$g_talk_troop"),
    (quest_get_slot, ":quest_target_troop", "qst_duel_courtship_rival", slot_quest_target_troop),
    (str_store_troop_name, s10, ":quest_target_troop"),
	(lt, "$g_talk_troop_relation", 0),
    ],
   "Well, {playername} -- you fought a duel with {s10}, and lost. According to our custom and tradition, I should no longer receive you. Farewell, {playername}.", "close_window",[
    (call_script, "script_end_quest", "qst_duel_courtship_rival"),
	(troop_set_slot, "$g_talk_troop", slot_troop_met, 4),
 ]],#incomplete

 
  [anyone,"start",
   [
    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
	(check_quest_active, "qst_duel_courtship_rival"),
    (check_quest_failed, "qst_duel_courtship_rival"),
    (quest_slot_eq, "qst_duel_courtship_rival", slot_quest_giver_troop, "$g_talk_troop"),
    (quest_get_slot, ":quest_target_troop", "qst_duel_courtship_rival", slot_quest_target_troop),
    (str_store_troop_name, s10, ":quest_target_troop"),
    ],
   "Oh {playername} -- I heard of your duel with {s10}. I wish now that you had never fought him, for our honor and tradition demand that, having lost to him, you now break off your suit with me. Farewell, {playername}.", "lady_duel_lost",[
	(troop_set_slot, "$g_talk_troop", slot_troop_met, 4),
    (call_script, "script_end_quest", "qst_duel_courtship_rival"),
 ]],
 
  [anyone|plyr,"lady_duel_lost",
	[], "Very well - we must do as tradition demands... Farewell, my lady", "close_window", [
 ]],
	
  [anyone|plyr,"lady_duel_lost",
	[], "Let honor and tradition hang!", "lady_duel_lost_flaunt_conventions", [
	]],

  [anyone, "lady_duel_lost_flaunt_conventions", 
	[], "Oh, {playername}! Although people will talk, it would so break my heart to no longer be able to see you. We shall ignore this silly, cruel tradition.", "close_window", [
	(troop_set_slot, "$g_talk_troop", slot_troop_met, 2),
	(call_script, "script_change_player_honor", -5),
	]],
	
  [anyone, "lady_duel_lost_flaunt_conventions", 
	[], "No, {playername} -- I cannot afford to fritter away my good name, and neither can you.", "close_window", [
	]],
	
	
  [anyone,"start",
   [
    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
	(check_quest_active, "qst_duel_courtship_rival"),
    (check_quest_succeeded, "qst_duel_courtship_rival"),
    (quest_slot_eq, "qst_duel_courtship_rival", slot_quest_giver_troop, "$g_talk_troop"),
    (quest_get_slot, ":quest_target_troop", "qst_duel_courtship_rival", slot_quest_target_troop),
	(call_script, "script_troop_get_relation_with_troop", "$g_talk_troop", ":quest_target_troop"),
	(lt, reg0, 0),
    (str_store_troop_name_link, s10, ":quest_target_troop"),
    ],
   "Oh, {playername} -- I have heard that you won your duel with {s10}. I'm grateful that you have delivered me from that man's attentions!", "lady_start",[
	(call_script, "script_end_quest", "qst_duel_courtship_rival"),
	(call_script, "script_troop_change_relation_with_troop", "trp_player", "$g_talk_troop", 3),
    (add_xp_as_reward, 1000),
	
 ]],#incomplete


 [anyone,"start",
   [
    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
	(check_quest_active, "qst_duel_courtship_rival"),
    (check_quest_succeeded, "qst_duel_courtship_rival"),
    (quest_slot_eq, "qst_duel_courtship_rival", slot_quest_giver_troop, "$g_talk_troop"),
    (quest_get_slot, ":quest_target_troop", "qst_duel_courtship_rival", slot_quest_target_troop),
	(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_ambitious),
	(call_script, "script_troop_get_relation_with_troop", "$g_talk_troop", ":quest_target_troop"),
    (str_store_troop_name_link, s10, ":quest_target_troop"),
	
    ],
   "Well, {playername} --  you won your duel with {s10}. Clearly, he was not worthy of my affections.", "lady_start",[
	(call_script, "script_end_quest", "qst_duel_courtship_rival"),
	(call_script, "script_troop_change_relation_with_troop", "trp_player", "$g_talk_troop", 2),
    (add_xp_as_reward, 1000),
 ]],
 
[anyone|auto_proceed,"start",
   [
    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
	(check_quest_active, "qst_duel_courtship_rival"),
    (check_quest_succeeded, "qst_duel_courtship_rival"),
    (quest_slot_eq, "qst_duel_courtship_rival", slot_quest_giver_troop, "$g_talk_troop"),
    (quest_get_slot, ":quest_target_troop", "qst_duel_courtship_rival", slot_quest_target_troop),
	(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_conventional),
	(call_script, "script_troop_get_relation_with_troop", "$g_talk_troop", ":quest_target_troop"),
    (str_store_troop_name_link, s10, ":quest_target_troop"),
    ],
   "{!}.", "lady_duel_rep_1",[]],
 
[anyone,"lady_duel_rep_1",
   [],
   "Well, {playername} --  you won your duel with {s10}. Oh, such foolishness, that men should fight over me! Sigh... But it is a bit romantic, I suppose.", "lady_start",[
	(call_script, "script_end_quest", "qst_duel_courtship_rival"),
	(call_script, "script_troop_change_relation_with_troop", "trp_player", "$g_talk_troop", 1),
    (add_xp_as_reward, 1000),
 ]],
 
 
 
 
 
   [anyone|auto_proceed,"start",
   [
    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
	(check_quest_active, "qst_duel_courtship_rival"),
    (check_quest_succeeded, "qst_duel_courtship_rival"),
    (quest_slot_eq, "qst_duel_courtship_rival", slot_quest_giver_troop, "$g_talk_troop"),
    (quest_get_slot, ":quest_target_troop", "qst_duel_courtship_rival", slot_quest_target_troop),
	(call_script, "script_troop_get_relation_with_troop", "$g_talk_troop", ":quest_target_troop"),
    (str_store_troop_name_link, s10, ":quest_target_troop"),
    ],
   "{!}.", "lady_duel_rep_2",[]],
 
   [anyone,"lady_duel_rep_2",
   [],
   "Well, {playername} --  you won your duel with {s10}. Honor now demands that he and I no longer meet... I was fond of him, you know. You did me no service by fighting him, sir.", "lady_start",[
	(call_script, "script_end_quest", "qst_duel_courtship_rival"),
	(call_script, "script_troop_change_relation_with_troop", "trp_player", "$g_talk_troop", -2),
    (add_xp_as_reward, 1000),
 ]],

 
  
  [anyone,"start",
   [
    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
    (check_quest_active, "qst_duel_for_lady"),
    (check_quest_succeeded, "qst_duel_for_lady"),
    (quest_slot_eq, "qst_duel_for_lady", slot_quest_giver_troop, "$g_talk_troop"),
    (le, "$talk_context", tc_siege_commander),
    (quest_get_slot, ":quest_target_troop", "qst_duel_for_lady", slot_quest_target_troop),
    (str_store_troop_name_link, s13, ":quest_target_troop"),
    ],
   "My dear {playername}, how joyous to see you again! I heard you gave that vile {s13} a well-deserved lesson.\
 I hope he never forgets his humiliation.\
 I've a reward for you, but I fear it's little compared to what you've done for me.", "lady_qst_duel_for_lady_succeeded_1",[]],

 [anyone|plyr,"lady_qst_duel_for_lady_succeeded_1", [], "Oh, it will just have to do.", "lady_qst_duel_for_lady_succeeded_2",[
  (str_store_string,s10,"@Then take it, with my eternal thanks. You are a noble {man/woman}.\
 I will never forget that you helped me in my time of need.")
  ]],

  [anyone|plyr,"lady_qst_duel_for_lady_succeeded_1", [], "{s66}, this is far too much!", "lady_qst_duel_for_lady_succeeded_2",[
  (str_store_string,s10,"@Forgive me, {playername}, but I must insist you accept it.\
 The money means little to me, and I owe you so much.\
 Here, take it, and let us speak no more of this."),
    (call_script, "script_change_player_honor", 1),
  ]],

  [anyone|plyr,"lady_qst_duel_for_lady_succeeded_1", [], "Please, {s65}, no reward is necessary.", "lady_qst_duel_for_lady_succeeded_2",[
  (str_store_string,s10,"@{playername}, what a dear {man/woman} you are,\
 but I will not allow you to refuse this. I owe you far more than I can say,\
 and I am sure you can put this money to far better use than I."),
    (call_script, "script_change_player_honor", 2),
  ]],
  [anyone,"lady_qst_duel_for_lady_succeeded_2", [], "{s10}", "lady_pretalk",
   [(call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 10),
    (add_xp_as_reward, 1000),
    (call_script, "script_troop_add_gold", "trp_player", 2000),
    (call_script, "script_end_quest", "qst_duel_for_lady"),
    ]],

  [anyone,"start",
   [
     (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
     (check_quest_active, "qst_duel_for_lady"),
     (check_quest_failed, "qst_duel_for_lady"),
     (quest_slot_eq, "qst_duel_for_lady", slot_quest_giver_troop, "$g_talk_troop"),
     (le, "$talk_context", tc_siege_commander),
     (quest_get_slot, ":quest_target_troop", "qst_duel_for_lady", slot_quest_target_troop),
     (str_store_troop_name_link, s13, ":quest_target_troop"),
     ],
   "I was told that you sought satisfaction from {s13} to prove my innocence, {playername}.\
 It was a fine gesture, and I thank you for your efforts.", "lady_qst_duel_for_lady_failed", []],
  [anyone|plyr,"lady_qst_duel_for_lady_failed", [], "I beg your forgiveness for my defeat, {s65}...", "lady_qst_duel_for_lady_failed_2",[]],
  [anyone,"lady_qst_duel_for_lady_failed_2", [], "It matters not, dear {playername}. You tried.\
 The truth cannot be proven at the point of a sword, but you willingly put your life at stake for my honour.\
 That alone will convince many of my innocence.", "lady_pretalk",
   [(call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 6),
    (add_xp_as_reward, 400),
    (call_script, "script_end_quest", "qst_duel_for_lady"),
    ]],

	[anyone,"start", [
	(troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
  	(troop_set_slot, "$g_talk_troop", slot_lady_no_messages, 0), #do this for all
    (check_quest_active, "qst_visit_lady"),
    (quest_slot_eq, "qst_visit_lady", slot_quest_giver_troop, "$g_talk_troop"),
	], "Ah {playername} - you must have received my message. How happy I am that you could come!", "lady_start",[
	(call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 1),
    (call_script, "script_end_quest", "qst_visit_lady"),
#	(assign, "$g_time_to_spare", 1),
	]],


	[anyone,"start", [
	(troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
    (check_quest_active, "qst_formal_marriage_proposal"),
    (quest_slot_eq, "qst_formal_marriage_proposal", slot_quest_giver_troop, "$g_talk_troop"),
	(neg|check_quest_succeeded, "qst_formal_marriage_proposal"),
	(neg|check_quest_failed, "qst_formal_marriage_proposal"),
	], "{playername} - is there any word from my family?", "lady_proposal_pending",[
	]],

	[anyone,"start",
	[
	(troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
    (check_quest_active, "qst_formal_marriage_proposal"),
    (quest_slot_eq, "qst_formal_marriage_proposal", slot_quest_giver_troop, "$g_talk_troop"),
	(check_quest_failed, "qst_formal_marriage_proposal"),
	(call_script, "script_get_kingdom_lady_social_determinants", "$g_talk_troop"),
	(assign, ":guardian", reg0),
	(call_script, "script_troop_get_family_relation_to_troop", ":guardian", "$g_talk_troop"),
    ],
   "I hear that my {s11} has refused your request to marry me. Does that mean that we must part?", "lady_betrothed",[
	(call_script, "script_end_quest", "qst_formal_marriage_proposal"),
   ]],

	#Marriage success

	
  [anyone,"start", [
    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
    (le, "$talk_context", tc_siege_commander),
    (check_quest_active, "qst_rescue_lord_by_replace"),
    (check_quest_succeeded, "qst_rescue_lord_by_replace"),
    (quest_slot_eq, "qst_rescue_lord_by_replace", slot_quest_giver_troop, "$g_talk_troop"),
	(quest_get_slot, ":cur_lord", "qst_rescue_lord_by_replace", slot_quest_target_troop), 
    (call_script, "script_troop_get_family_relation_to_troop", ":cur_lord", "$g_talk_troop"),
    ],
   "Oh, {playername}, you brought him back to me! Thank you ever so much for rescuing my {s11}.\
 Please, take this as some small repayment for your noble deed.", "lady_generic_mission_succeeded",
   [
     (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 8),
     (add_xp_as_reward, 2000),
     (call_script, "script_troop_add_gold", "trp_player", 1500),
     (call_script, "script_end_quest", "qst_rescue_lord_by_replace"),
     ]],
	
	
  [anyone,"start", [   
    (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),     
    (check_quest_active, "qst_rescue_prisoner"),
    (check_quest_succeeded, "qst_rescue_prisoner"),
    (quest_slot_eq, "qst_rescue_prisoner", slot_quest_giver_troop, "$g_talk_troop"),
	(quest_get_slot, ":cur_lord", "qst_rescue_prisoner", slot_quest_target_troop), 
    (call_script, "script_troop_get_family_relation_to_troop", ":cur_lord", "$g_talk_troop"),
    ],
   "Oh, {playername}, you brought him back to me! Thank you ever so much for rescuing my {s11}.\
 Please, take this as some small repayment for your noble deed.", "rescue_prisoner_succeed_1",
   [   
     (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 8),
     (add_xp_as_reward, 2000),
     (call_script, "script_troop_add_gold", "trp_player", 1500),
     (call_script, "script_end_quest", "qst_rescue_prisoner"),
     ]],#rescuerescue               
   [anyone|plyr,"rescue_prisoner_succeed_1", [], "Always an honour to serve, {s65}.", "lady_pretalk",[]],     
   


  #first time greetings
	[anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_lady),
                     (eq, "$g_talk_troop_met", 0),
                     (gt, "$g_player_tournament_placement", 4),
					 (str_clear, s8),
					 
                     ],
   "You must be {playername}. We have just had the honor of watching you distinguish yourself in the recent tournament{s8}.",
   "lady_meet_end", []],
  
  
  [anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_lady),
                     (eq, "$g_talk_troop_met", 0),
                     (le,"$talk_context",tc_siege_commander),
					 
					 (assign, ":known_by_relative", 0),
					 (str_clear, s15),
					 (try_for_range, ":lord", lords_begin, lords_end),
						(call_script, "script_troop_get_family_relation_to_troop", ":lord", "$g_talk_troop"),
						(gt, reg0, 5),
						
						(call_script, "script_troop_get_relation_with_troop", "trp_player", ":lord"),
						(gt, reg0, 10),
						
						(str_store_string, s15, s11),
						(str_store_troop_name, s16, ":lord"),
						(assign, ":known_by_relative", ":lord"),
					 (try_end),
					 
					 
					 (gt, ":known_by_relative", 0),
					 
                     ],
   "You must be {playername}. My {s15} {s16} has spoken most highly of you. I am delighted to make your acquaintance.",
   "lady_meet_end", []],
  
  
  [anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_lady),
                     (eq, "$g_talk_troop_met", 0),
                     (le,"$talk_context",tc_siege_commander),
                     ],
   "I say, you don't look familiar...", "lady_premeet", []],

   #default greet
  [anyone,"start",
   [(troop_slot_eq, "$g_talk_troop", slot_troop_met, 4),
    (lt, "$g_talk_troop_relation", 0),
    ],
   "Ah, {playername}. How good it is to see you again. However, I believe that I am required elsewhere.", "close_window",[]],
   
  [anyone,"start",
   [(troop_slot_eq, "$g_talk_troop", slot_troop_met, 4),
    ],
   "{playername} -- how good it is to see you. (Whispers:) I still remember your visits fondly.", "lady_start",[]],
  
	[anyone ,"start", [(troop_slot_eq,"$g_talk_troop",slot_troop_occupation, slto_kingdom_lady),
                     (eq, "$g_talk_troop_met", 0),
                     (gt, "$g_player_tournament_placement", 4),
					 (ge, "$g_talk_troop_relation", 0),
                     ],
   "Ah, {playername}. How spendid it was to see you distinguish yourself in the recent tournament.",
   "lady_meet_end", []],

  
  [anyone,"start", [
					(troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
					(str_store_string, s12, "str_hello_playername"),
#					(assign, "$g_time_to_spare", 1),
                    ],
   "{s12}", "lady_start",[]],	
	
  
	#lady_start - contains news, quest assignments
	[anyone,"lady_start", [
					(troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
					(troop_slot_ge, "$g_talk_troop", slot_troop_met, 2),
					(neg|troop_slot_eq, "$g_talk_troop", slot_troop_met, 4),
					(troop_get_slot, ":betrothed", "$g_talk_troop", slot_troop_betrothed),
					(gt, ":betrothed", -1),
					(neq, ":betrothed", "trp_player"),
					(str_store_troop_name, s5, ":betrothed"),
					(call_script, "script_troop_get_relation_with_troop", "$g_talk_troop", ":betrothed"),
					(lt, reg0, 0),
					(ge, "$g_talk_troop_relation", 10),
					],
    "I have sad news. I have become betrothed to {s5} -- against my will, I should say! Oh {playername} - I would so much rather be wed to you!", "lady_betrothed",[]],

	[anyone,"lady_start", [
					(troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
					(troop_slot_ge, "$g_talk_troop", slot_troop_met, 2),
					(troop_get_slot, ":betrothed", "$g_talk_troop", slot_troop_betrothed),
					(gt, ":betrothed", -1),
					(neq, ":betrothed", "trp_player"),
					(str_store_troop_name, s5, ":betrothed"),
					],
    "Good {playername} -- I have become betrothed to {s5}. It is now no longer seemly for us to see each other like this.", "lady_betrothed",[
#	(try_begin),
#		(check_quest_active, "qst_visit_lady"),
#		(quest_slot_eq, "qst_visit_lady", slot_quest_giver_troop, "$g_talk_troop"),
#		(call_script, "script_end_quest", "qst_visit_lady"),
#	(try_end),
	]],

	[anyone,"lady_start", 
	[
	  (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
	  (troop_slot_eq, "$g_talk_troop", slot_troop_met, 2), 
	  (neg|troop_slot_eq, "$g_talk_troop", slot_troop_met, 4),
	  (neg|troop_slot_ge, "trp_player", slot_troop_spouse, active_npcs_begin),
	  (neg|troop_slot_ge, "$g_talk_troop", slot_troop_spouse, active_npcs_begin),
	  
	  (gt, "$g_talk_troop_relation", 0),
	  (assign, "$romantic_rival", -1),
	  
	  (try_for_range, ":rival_lord", lords_begin, lords_end),
	    (this_or_next|troop_slot_eq, ":rival_lord", slot_troop_love_interest_1, "$g_talk_troop"), 
	    (this_or_next|troop_slot_eq, ":rival_lord", slot_troop_love_interest_2, "$g_talk_troop"), 
	    (troop_slot_eq, ":rival_lord", slot_troop_love_interest_2, "$g_talk_troop"), 
	    (call_script, "script_troop_get_relation_with_troop", "$g_talk_troop", ":rival_lord"),
	    (le, reg0, -4), 
	    
	    (this_or_next|troop_slot_eq, ":rival_lord", slot_lord_reputation_type, lrep_debauched), 
	    (this_or_next|troop_slot_eq, ":rival_lord", slot_lord_reputation_type, lrep_quarrelsome), 
	    (this_or_next|troop_slot_eq, ":rival_lord", slot_lord_reputation_type, lrep_roguish), 	    
	    (troop_slot_eq, ":rival_lord", slot_lord_reputation_type, lrep_selfrighteous), 
	    
	    (assign, "$romantic_rival", ":rival_lord"),
	  (try_end),
	  
	  (gt, "$romantic_rival", 0),
	],
    "I must tell you -- there is another lord who has been paying me attentions, although I cannot abide him. I fear he has designs on me, and may try to force me to wed against my will.", "lady_other_suitor",[]],        
	
	#romantic news/quest assignments end
  [anyone,"lady_start", [ #friendly reminder that time is short	  
					(troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
					(lt, "$g_time_since_last_talk", 24),
					(troop_slot_eq, "$g_talk_troop", slot_troop_met, 2),
					(gt, "$g_talk_troop_relation", 0),
					(try_begin),
						(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_adventurous),
						(str_store_string, s11, "str_i_do_enjoy_speaking_to_you_but_i_am_sure_you_understand_that_our_people_cluck_their_tongues_at_a_woman_to_spend_too_long_conversing_with_a_man_outside_her_family__although_the_heavens_know_its_never_the_man_who_is_held_to_blame_"),
					(else_try),
						(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_ambitious),
						(str_store_string, s11, "str_as_much_as_i_enjoy_speaking_to_you_i_do_not_care_to_be_gossiped_about_by_others_who_might_lack_my_grace_and_beauty_"),
					(else_try),
						(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_moralist),					
						(str_store_string, s11, "str_i_do_so_enjoy_speaking_to_you_but_as_a_daughter_of_one_of_the_great_families_of_this_land_i_must_set_an_example_of_propriety_"),
					(else_try),
						(str_store_string, s11, "str_i_do_so_enjoy_speaking_to_you_but_as_a_daughter_of_good_family_i_must_protect_my_reputation_"),
					(try_end),
					],
   "{s11}It is probably not suitable for us to tarry too long here in conversation, but I would hope to see you again soon.", "lady_talk",[]],	
   
  [anyone,"lady_start", [ #unfriendly reminder that time is short
					(troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
					(lt, "$g_time_since_last_talk", 24),
					(troop_slot_eq, "$g_talk_troop", slot_troop_met, 2),
					(try_begin),
						(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_adventurous),
						(str_store_string, s11, "str_although_it_is_kind_of_you_to_pay_me_such_attentions_i_suspect_that_you_might_find_other_ladies_who_may_be_more_inclined_to_return_your_affection"),
					(else_try),
						(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_ambitious),
						(str_store_string, s11, "str_as_flattered_as_i_am_by_your_attentions_perhaps_you_should_seek_out_another_lady_of_somewhat_shall_we_say_different_tastes"),
					(else_try),
						(str_store_string, s11, "str_as_flattered_as_i_am_by_your_attentions_i_am_a_daughter_of_good_family_and_must_be_aware_of_my_reputation_it_is_not_seemly_that_i_converse_too_much_at_one_time_with_one_man_i_am_sure_you_understand_now_if_you_will_excuse_me"),					
					(try_end),
					
					],
   "{s11}", "lady_talk",[]],	
	
	[anyone, "lady_start", [
	(eq, "$lady_flirtation_location", "$g_encountered_party"),
	(troop_slot_eq, "$g_talk_troop", slot_troop_met, 1),
	],  "I was planning to retire for a little while, but perhaps we may have a chance to speak more later...", "lady_talk", []],

	
	#Defeault lady_start - no news, assignments
	[anyone,"lady_start", [
	(troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
	(troop_slot_eq, "$g_talk_troop", slot_troop_met, 2),
	(gt, "$g_talk_troop_relation", 0),
	(str_clear, s12),
	(try_begin),
		(troop_slot_eq, "$g_talk_troop", slot_troop_met, 2),
		(gt, "$g_talk_troop_relation", 0),
		(gt, "$g_time_since_last_talk", 24),
						(try_begin),
							(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_otherworldly),
							(str_store_string, s12, "str_ah_my_gentle_playername_how_much_good_it_does_my_heart_to_see_you_again"),
						(else_try),
							(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_adventurous),
							(str_store_string, s12, "str_playername__i_am_so_glad_to_see_you_again_i_must_say_i_do_envy_your_freedom_to_ride_out_and_experience_the_world"),
						(else_try),
							(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_moralist),
							(str_store_string, s12, "str_playername__i_am_so_glad_to_see_you_i_trust_that_you_have_been_behaving_honorably_since_last_we_met"),
						(else_try),
							(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_ambitious),
							(str_store_string, s12, "str_greetings_playername__it_is_good_to_see_you_i_hope_that_you_have_had_success_in_your_efforts_to_make_your_name_in_the_world"),
						(else_try),
							(str_store_string, s12, "str_playername__i_am_so_glad_that_you_were_able_to_come"),				
						(try_end),
	(try_end),
	
	
	],"It is so delightful to have a chance to spend some time together.{s12}","lady_talk", []],

	
	[anyone,"lady_start", [
		(troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_lady),
	],"What brings you here today?","lady_talk", []],
	
	
	
	
	#Betrothed
	[anyone|plyr, "lady_proposal_pending", [],
    "No word so far...", "close_window",[]],

	[anyone|plyr, "lady_proposal_pending", [],
    "On second thought, now is not the time for us to marry", "lady_proposal_pending_end",[]],
	
	[anyone,"lady_proposal_pending_end", [
	(try_begin),
		(gt, "$g_talk_troop_effective_relation", 19),
		(str_store_string, s11, "str_very_well__i_will_let_you_choose_the_time"),
	(else_try),
		(str_store_string, s11, "str_good_i_am_glad_that_you_have_abandoned_the_notion_of_pushing_me_into_marriage_before_i_was_ready"),
	(try_end),
	],
    "{s11}", "close_window",[
	(call_script, "script_end_quest", "qst_formal_marriage_proposal"),
	]],
	
	
	
	[anyone|plyr,"lady_betrothed", [],
    "Never! We must elope together at once!", "lady_suggest_elope",[]],

	[anyone|plyr,"lady_betrothed", [
	(troop_slot_eq, "$g_talk_troop", slot_troop_betrothed, -1),
	(call_script, "script_get_kingdom_lady_social_determinants", "$g_talk_troop"),
	(call_script, "script_troop_get_family_relation_to_troop", reg0, "$g_talk_troop"),
	],
    "Perhaps I may still be able to change your {s11}'s mind", "lady_pretalk",[]],

	[anyone|plyr,"lady_betrothed", [],
    "So be it -- let us then part", "lady_conclude_relationship",[
	]],

	
	[anyone,"lady_suggest_elope", [(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_conventional)],
    "Good {playername} -- you are a good and kind man, but a lady cannot defy her family. Such things are not done!", "lady_conclude_relationship",[]],


  [anyone,"lady_suggest_elope",
    [
      (assign, "$romantic_rival", -1),
	  (try_for_range, ":possible_rival", lords_begin, lords_end),
	    (this_or_next|troop_slot_eq, ":possible_rival", slot_troop_love_interest_1, "$g_talk_troop"),
	    (this_or_next|troop_slot_eq, ":possible_rival", slot_troop_love_interest_2, "$g_talk_troop"),
	    (troop_slot_eq, ":possible_rival", slot_troop_love_interest_2, "$g_talk_troop"),
	    (call_script, "script_troop_get_relation_with_troop", "$g_talk_troop", ":possible_rival"),
	    
	    (try_begin),
	      (eq, "$cheat_mode", 1),
	      (str_store_troop_name, s4, ":possible_rival"),
	      (display_message, "str_rival_found_s4_reg0_relation"),
		(try_end),
		(gt, reg0, "$g_talk_troop_relation"),
		(assign, "$romantic_rival", ":possible_rival"),
      (try_end),
      
      (gt, "$romantic_rival", -1),
    ],
    "Sir -- as you may know, I have been entertaining offers from a number of gentlemen such as yourself. I am not yet at a stage where I can commit to any of them.", "lady_other_suitor",[
    ]],

	
	[anyone,"lady_suggest_elope", [
	(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_ambitious),
	(neg|troop_slot_ge, "trp_player", slot_troop_renown, 350)
	],
    "Ah {playername}, you must realize. You are still finding your way in the world. I have great affection for you, {playername}, but I will not consign myself to obscurity.", "lady_conclude_relationship",[]],
	
	[anyone,"lady_suggest_elope", [
	(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_moralist),
	(lt, "$player_honor", 20)
	],
    "Ah {playername}, although you are kind to me, I am not certain enough of your moral fiber to risk such a thing. Although I bare little affection for my husband, it would be a weighty thing to go against my family's wishes, and I am not certain enough of you to take that step.", "lady_conclude_relationship",[]],
	
	[anyone,"lady_suggest_elope", [(le, "$g_talk_troop_effective_relation", 20),],
    "Good {playername} -- to elope would be to throw away my ties with my family, which are everything to me! I have a considerable affection for you, but I am not sure that I am prepared to risk that.", "lady_conclude_relationship",[]],

	[anyone,"lady_suggest_elope", [
	(assign, "$home_for_spouse", -1),
	(try_for_range, ":player_center", centers_begin, centers_end),
		(eq, "$home_for_spouse", -1),
		(party_slot_eq, ":player_center", slot_town_lord, "trp_player"),
		(is_between, ":player_center", walled_centers_begin, walled_centers_end),
#		(this_or_next|is_between, ":player_center", walled_centers_begin, walled_centers_end),
#			(party_slot_eq, ":player_center", slot_center_has_manor, 1),
		(assign, "$home_for_spouse", ":player_center"),	
	(try_end),
	(eq, "$home_for_spouse", -1),
	],
    "Good {playername} -- I am not used to the hardships of campaigning as you are. I want a home to call my own. If you were lord of a castle or town with a great hall, I would gladly go there as your wife, to be mistress of the household. But I do not wish to live like a hunted animal.", "lady_conclude_relationship",[]],
	
	
	[anyone,"lady_suggest_elope", [
	(call_script, "script_get_kingdom_lady_social_determinants", "$g_talk_troop"),
	(call_script, "script_troop_get_family_relation_to_troop", reg0, "$g_talk_troop"),
	],
    "Elope with you? Yes -- we could do that. It is a great step to defy my family -- but a loveless marriage, and life without you, might be a far worse thing! But be warned -- this will be a terrible blow to my {s11}'s prestige, and he will do everything in his power to bring you down.", "lady_elope_agree",[]],

	[anyone|plyr,"lady_elope_agree", [],
    "Quickly, then! There is no time to lose.", "lady_elope_agree_nurse",[
	]],
	
	[anyone|plyr,"lady_elope_agree", [],
    "Everything in his power, you say? Em... Let me think about this...", "close_window",[
	]],

	[anyone, "lady_elope_agree_nurse", [],
    "Your lordship... Your ladyship... Would you like me to witness your exchange of vows?", "lady_elope_agree_lady_vows",[
    (set_conversation_speaker_troop, trp_nurse_for_lady),
	]],

	[anyone, "lady_elope_agree_lady_vows", [
	(str_store_troop_name, s4, "$g_talk_troop"),
	],
    "Yes, do that. For my part, I make the following vow: I, {s4}, do swear that I accept {playername} as my husband, according to the ancient law and custom of our land...", "lady_elope_agree_nurse_2",[
	]],

	[anyone, "lady_elope_agree_nurse_2", [],
    "Very good. Do you, {playername}, swear similarly to accept {s4} as your wife?", "lady_elope_agree_player_vows",[
    (set_conversation_speaker_troop, trp_nurse_for_lady),
	]],
	
	[anyone|plyr,"lady_elope_agree_player_vows", [],
    "I do.", "close_window",[
	(call_script, "script_courtship_event_bride_marry_groom", "$g_talk_troop", "trp_player", 1), #1 is elopement
	]],
	
	[anyone|plyr,"lady_elope_agree_player_vows", [],
    "Eh, what? This is all moving too fast...", "close_window",[
	]],



	
	#markspot - do elopement here
	
	[anyone|plyr,"lady_elope_agree", [],
    "Oh, really? My dear -- I could never separate a lady from her family like that...", "lady_conclude_relationship",[
	]],

	[anyone,"lady_conclude_relationship", [],
	"So I suppose our time together must come to an end...", "lady_conclude_relationship_confirm", []],

	[anyone|plyr,"lady_conclude_relationship_confirm", [],
	"Yes -- it must be...", "lady_conclude_relationship_confirm_yes", []],
	
	[anyone|plyr,"lady_conclude_relationship_confirm", [],
	"Wait -- perhaps there is still a chance for us!", "lady_conclude_relationship_confirm_no", []],
	
	[anyone,"lady_conclude_relationship_confirm_yes", [],
	"Farewell, {playername}. We will see each other, in the courts and castles of this realm, but we must keep our distance from each other. I will remember these days fondly, nonetheless.", "close_window", [
	(troop_set_slot, "$g_talk_troop", slot_troop_met, 4),
	]],

	[anyone,"lady_conclude_relationship_confirm_no", [],
	"In that case, we shall see what the future brings.", "close_window", [
	]],
   
   
  
  


  [anyone|plyr,"lady_generic_mission_succeeded", [], "Always an honour to serve, {s65}.", "lady_pretalk",[]],

  [anyone|plyr ,"lady_premeet", [],  "I am {playername}.", "lady_meet", []],
  [anyone|plyr ,"lady_premeet", [],  "My name is {playername}. At your service.", "lady_meet", []],

  
  [anyone, "lady_meet", [
  (troop_slot_ge, "trp_player", slot_troop_renown, 200),
  ],  "Of course. How splendid to finally make your acquaintance.", "lady_meet_end", []],
  
  [anyone, "lady_meet", [],  "{playername}? I do not believe I've heard of you before.", "lady_meet_end", []],

  [anyone, "lady_meet_end", [
	(eq, "$lady_flirtation_location", "$g_encountered_party"),
  ],  "I am about to retire for a little while, but perhaps we may have a chance to speak more later...", "lady_talk", []],
  
  
  [anyone, "lady_meet_end", [
    (troop_slot_eq, "$g_talk_troop", slot_troop_spouse, -1),
	(call_script, "script_troop_get_romantic_chemistry_with_troop", "$g_talk_troop", "trp_player"),
	(le, reg0, 0),
	(call_script, "script_troop_get_relation_with_troop", "$g_talk_troop", "trp_player"),
	(le, reg0, 0),
	],  "Now, if you will excuse me...", "lady_talk", []],

  [anyone, "lady_meet_end", [],  "Can I help you with anything?", "lady_talk", []],

  
  [anyone|plyr,"lady_talk", [(neg|troop_slot_ge, "$g_talk_troop", slot_troop_prisoner_of_party, 0),
							 (ge, "$g_encountered_party_relation", 0),
  ],
   "I want to know the location of someone.", "lord_talk_ask_location",[]],


##### TODO: QUESTS COMMENT OUT BEGIN
##  [anyone|plyr,"lady_talk", [(check_quest_active, "qst_deliver_message_to_lover"),
##                             (quest_slot_eq, "qst_deliver_message_to_lover", slot_quest_target_troop, "$g_talk_troop"),
##                             (quest_get_slot, ":troop_no", "qst_deliver_message_to_lover", slot_quest_giver_troop),
##                             (str_store_troop_name_link, 3, ":troop_no")],
##   "I have brought you a message from {s3}", "lady_message_from_lover_success",[(call_script, "script_finish_quest", "qst_deliver_message_to_lover", 100)]],
##
##  [anyone|plyr,"lady_talk", [(check_quest_active, "qst_rescue_lady_under_siege"),
##                             (quest_slot_eq, "qst_rescue_lady_under_siege", slot_quest_object_troop, "$g_talk_troop"),
##                             (quest_slot_eq, "qst_rescue_lady_under_siege", slot_quest_current_state, 0)],
##   "TODO: I'm taking you home!", "lady_rescue_from_siege_check",[]],
##
##
##  [anyone,"lady_rescue_from_siege_check", [(neg|hero_can_join)],
##   "TODO: You don't have enough room for me!", "close_window",[]],
##
##
##  [anyone,"lady_rescue_from_siege_check", [], "TODO: Thank you so much!", "lady_pretalk",[(quest_set_slot, "qst_rescue_lady_under_siege", slot_quest_current_state, 1),
##                                                                                          (troop_set_slot, "$g_talk_troop", slot_troop_cur_center, 0),
##                                                                                          (troop_join, "$g_talk_troop")]],
##  [anyone,"lady_message_from_lover_success", [], "TODO: Thank you so much!", "lady_pretalk",[]],
##

  [anyone,"lady_pretalk", [
    (troop_slot_eq, "$g_talk_troop", slot_troop_spouse, -1),
	(call_script, "script_troop_get_romantic_chemistry_with_troop", "$g_talk_troop", "trp_player"),
	(le, reg0, 0),
	(call_script, "script_troop_get_relation_with_troop", "$g_talk_troop", "trp_player"),
	(le, reg0, 0),
], "Now, if you will excuse me...", "lady_talk",[]],


  [anyone,"lady_pretalk", [], "Is there anything else?", "lady_talk",[]],

##[anyone|plyr,"lady_talk",
##   [(troop_get_type, ":is_female", "trp_player"),
##    (eq, ":is_female", 0),],
##   "{!}CHEAT: I want to marry you! (1)", "wedding_ceremony_bride_vow",[]],
##[anyone|plyr,"lady_talk",
##   [(troop_get_type, ":is_female", "trp_player"),
##    (eq, ":is_female", 0),],
##   "{!}CHEAT: I want to marry you! (2)", "lady_elope_agree_nurse_2",[]],
  
  [anyone|plyr,"lady_talk",
   [],
   "May I have the honor of knowing more about you, my lady?", "lady_relations",[]],
  
  [anyone,"lady_relations",
   [
    (str_store_string, s12, "str_i_am"),
	(assign, ":relation_found", 0),
	(assign, ":in_castle_of_relative", 0),
	
    (try_for_range, ":lord", active_npcs_begin, kingdom_ladies_end), #use this as the basis for "troop_describe_relation_with_troop"
		(call_script, "script_troop_get_family_relation_to_troop", "$g_talk_troop", ":lord"), #The normal order is reversed, because the lady is describing herself
		(this_or_next|gt, reg0, 5),
			(party_slot_eq, "$g_encountered_party", slot_town_lord, ":lord"),
		(gt, reg0, 0),
		
		(str_store_troop_name, s14, ":lord"),
		(try_begin),
			(eq, ":relation_found", 1),
			(str_store_string, s12, "str_s12"),
		(try_end),
		(str_store_string, s12, "str_s12_s11_to_s14"),
		(assign, ":relation_found", 1),
		
		(try_begin),
			(party_slot_eq, "$g_encountered_party", slot_town_lord, ":lord"),
			(assign, ":in_castle_of_relative", 1),
		(try_end),
    (try_end),
	
	(try_begin),
		(eq, ":in_castle_of_relative", 1),
		(str_store_string, s12, "str_s12"),
	(else_try),
		(eq, ":in_castle_of_relative", 0),
		(faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_state, sfai_feast),
		(faction_slot_eq, "$g_talk_troop_faction", slot_faction_ai_object, "$g_encountered_party"),
		(str_store_string, s12, "str_s12_i_am_here_for_the_feast"),
	(else_try),
		(str_store_string, s12, "str_s12"),
	(try_end),
	
   ],
   "{s12}", "lady_pretalk",[]],

   
  [anyone|plyr,"lady_talk",
   [
    (troop_get_type, ":is_female", "trp_player"),
	(eq, ":is_female", 0),
    (troop_slot_eq, "$g_talk_troop", slot_troop_met, 1),
	(troop_slot_eq, "$g_talk_troop", slot_troop_spouse, -1),
    (neg|troop_slot_ge, "trp_player", slot_troop_spouse, active_npcs_begin),
	
	(neq, "$lady_flirtation_location", "$g_encountered_party"),
	],
   "My lady, I would like to profess myself your most ardent admirer", "lady_profess_admiration",  
	[
	(call_script, "script_troop_get_romantic_chemistry_with_troop", "$g_talk_troop", "trp_player"),
	(assign, ":reaction_change", reg0),
	
#	(try_begin),
#		(gt, "$g_player_tournament_placement", 3),
#		(val_sub, "$g_player_tournament_placement", 3),
#		(val_mul, "$g_player_tournament_placement", 4), #Twice normal, but is divided by two
#	(else_try),	
#		(assign, "$g_player_tournament_placement", 0),
#	(try_end),
	
#	(try_begin),
#		(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_conventional),
#		(val_mul, "$g_player_tournament_placement", 2),
#	(else_try),	
#		(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_moralist),
#		(val_div, "$g_player_tournament_placement", 2),
#	(try_end),
	
#	(val_add, ":reaction_change", "$g_player_tournament_placement"),
#	(assign, "$g_player_tournament_placement", 0),
	
	(val_div, ":reaction_change", 2),
	(val_max, ":reaction_change", -2),
	
	(call_script, "script_troop_change_relation_with_troop", "$g_talk_troop", "trp_player", ":reaction_change"),
	(assign, "$g_time_to_spare", 0),
	
	]],

  [anyone|plyr,"lady_talk",
   [
    (troop_get_type, ":is_female", "trp_player"),
	(eq, ":is_female", 0),
	(gt, "$g_player_tournament_placement", 3),
	(neg|troop_slot_ge, "trp_player", slot_troop_spouse, active_npcs_begin),
	],
   "My lady, I would like to dedicate my successes in this recent tournament to you", "lady_tournament_dedication_reaction",  
	[
	
	(try_begin),
		(gt, "$g_player_tournament_placement", 3),
		(val_sub, "$g_player_tournament_placement", 3),
		(val_mul, "$g_player_tournament_placement", 2),
	(else_try),	
		(assign, "$g_player_tournament_placement", 0),
	(try_end),
	
	(try_begin),
		(troop_slot_eq, "$g_talk_troop", slot_lady_used_tournament, 1),
		(val_div, "$g_player_tournament_placement", 3),
		(str_store_string, s9, "str_another_tournament_dedication_oh_i_suppose_it_is_always_flattering"),
	(else_try),
		(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_conventional),
		(val_mul, "$g_player_tournament_placement", 2),
		(str_store_string, s9, "str_do_you_why_what_a_most_gallant_thing_to_say"),
	(else_try),	
		(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_moralist),
		(val_div, "$g_player_tournament_placement", 2),
		(str_store_string, s9, "str_hmm_i_cannot_say_that_i_altogether_approve_of_such_frivolity_but_i_must_confess_myself_a_bit_flattered"),
	(else_try),
		(str_store_string, s9, "str_why_thank_you_you_are_most_kind_to_do_so"),
	(try_end),	
	
	(call_script, "script_troop_change_relation_with_troop", "$g_talk_troop", "trp_player", "$g_player_tournament_placement"),
	(assign, "$g_player_tournament_placement", 0),
	(troop_set_slot, "$g_talk_troop", slot_lady_used_tournament, 1),
	]],
	
  [anyone,"lady_tournament_dedication_reaction", [],
   "{s9}", "lady_pretalk",
   []],
	
	
	
  [anyone,"lady_profess_admiration", [
	(call_script, "script_troop_get_relation_with_troop", "$g_talk_troop", "trp_player"),
    (gt, reg0, 0),
	
	(try_begin),
		(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_moralist),
		(str_store_string, s11, "str_you_are_most_courteous_and_courtesy_is_a_fine_virtue_"),
	(else_try),
		(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_ambitious),
		(str_store_string, s11, "str_hmm_youre_a_bold_one_but_i_like_that_"),
	(else_try),
		(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_adventurous),
		(str_store_string, s11, "str_ah_well_they_all_say_that_but_no_matter_a_compliment_well_delivered_is_at_least_a_good_start_"),
	(else_try),
		(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_otherworldly),
		(str_store_string, s11, "str_oh_do_you_mean_that_such_a_kind_thing_to_say"),
	(else_try),
		(str_store_string, s11, "str_you_are_a_most_gallant_young_man_"),
	(try_end),
	
  ],
   "{s11}I would like it very much if we could see more of each other.", "close_window",
   [(troop_set_slot, "$g_talk_troop", slot_troop_met, 2),
	(assign, "$lady_flirtation_location", "$g_encountered_party"),
   ]],
  
  [anyone,"lady_profess_admiration", [
  ],
   "Ah... You are too kind... My, the hour is getting rather late, isn't it? I really must be going.", "lady_pretalk",
   [(troop_set_slot, "$g_talk_troop", slot_troop_met, 2),
   ]],
  

  [anyone|plyr,"lady_talk",
   [
	 (troop_slot_eq, "$g_talk_troop", slot_troop_met, 2),
	 (eq, "$g_time_to_spare", 1),
	 (eq, "$talk_context", tc_courtship),
     ],
   "Do you like poetry, my lady?", "lady_recite_poetry",[
	 (assign, "$g_time_to_spare", 0),
   ]],

  [anyone,"lady_recite_poetry", [
  ],
   "That would depend on the poem. Did you intend to recite a verse?", "lady_recite_poetry",
   []],

   
  [anyone|plyr,"lady_recite_poetry",
   [
	 (gt, "$tragic_poem_recitations", 0),
	 (troop_slot_eq, "$g_talk_troop", slot_lady_courtship_tragic_recited, 0),
	 
     ],
   "The wind that blows the dry steppe dust...", "lady_recite_poetry_response",[
   (assign, "$poem_selected", courtship_poem_tragic),
   (troop_set_slot, "$g_talk_troop", slot_lady_courtship_tragic_recited, 1),

   ]],
   
  [anyone|plyr,"lady_recite_poetry",
   [
	 (gt, "$comic_poem_recitations", 0),
	 (troop_slot_eq, "$g_talk_troop", slot_lady_courtship_comic_recited, 0),
	 
     ],
   "All the silks of Veluca/All the furs of Khudan...", "lady_recite_poetry_response",[
   (assign, "$poem_selected", courtship_poem_comic),
   (troop_set_slot, "$g_talk_troop", slot_lady_courtship_comic_recited, 1),
   
   ]],
   
  [anyone|plyr,"lady_recite_poetry",
   [
	(gt, "$mystic_poem_recitations", 0),
	(troop_slot_eq, "$g_talk_troop", slot_lady_courtship_mystic_recited, 0),
	
    ],
   "You are the first and the last/the outer and the inner...", "lady_recite_poetry_response",[
   (assign, "$poem_selected", courtship_poem_mystic),
   (troop_set_slot, "$g_talk_troop", slot_lady_courtship_mystic_recited, 1),
   
   ]],

  [anyone|plyr,"lady_recite_poetry",
   [
	(gt, "$heroic_poem_recitations", 0),
	(troop_slot_eq, "$g_talk_troop", slot_lady_courtship_heroic_recited, 0),
     ],
   "A light pierced the gloom over Wercheg cliffs...", "lady_recite_poetry_response",[
    (assign, "$poem_selected", courtship_poem_heroic),
	(troop_set_slot, "$g_talk_troop", slot_lady_courtship_heroic_recited, 1),
   
   ]],

  [anyone|plyr,"lady_recite_poetry",
   [
	(gt, "$allegoric_poem_recitations", 0),
	(troop_slot_eq, "$g_talk_troop", slot_lady_courtship_allegoric_recited, 0),

     ],
   "I deflected her skeptical questioning darts/with armor made of purest devotion...", "lady_recite_poetry_response",[
    (assign, "$poem_selected", courtship_poem_allegoric),
	(troop_set_slot, "$g_talk_troop", slot_lady_courtship_allegoric_recited, 1),
   ]],

   
  [anyone|plyr,"lady_recite_poetry",
   [],"Actually, I can't think of any that I would care to recite...", "lady_pretalk",[]],   
   
   [anyone,"lady_recite_poetry_response",
   [
    (call_script, "script_courtship_poem_reactions", "$g_talk_troop", "$poem_selected"),
   ],
   "{s11}", "lady_private_conversation_end",[
    (assign, ":reaction", reg0),
	(call_script, "script_troop_change_relation_with_troop", "$g_talk_troop", "trp_player", ":reaction"),
    (call_script, "script_courtship_poem_reactions", "$g_talk_troop", "$poem_selected"), #this needs to be twice, as the above resets s11
   ]],  

   [anyone,"lady_private_conversation_end",
	[
	(str_clear, s11),
	(try_begin),
		(call_script, "script_troop_get_relation_with_troop", "$g_talk_troop", "trp_player"),
		(gt, reg0, 0),
		(str_store_string, s11, "str__do_come_and_see_me_again_soon"),
	(try_end),
	],
	"Time is passing quickly, and we cannot linger here too long.", "lady_pretalk",
	[
	(assign, "$g_time_to_spare", 0),
	]],

	
  [anyone|plyr,"lady_talk",
    [
	(neg|check_quest_active, "qst_formal_marriage_proposal"),
	(neg|troop_slot_ge, "trp_player", slot_troop_betrothed, active_npcs_begin),
	(neg|troop_slot_ge, "trp_player", slot_troop_spouse, active_npcs_begin),

	
	(troop_slot_eq, "$g_talk_troop", slot_troop_met, 2),
	(eq, "$talk_context", tc_courtship),
    ],
    "Do you think that we may have a future together, my lady?", "lady_marriage_discussion",[
    ]],

	
  [anyone,"lady_marriage_discussion",
    [
	(assign, "$romantic_rival", -1),
	(try_for_range, ":possible_rival", lords_begin, lords_end),
		(this_or_next|troop_slot_eq, ":possible_rival", slot_troop_love_interest_1, "$g_talk_troop"),
		(this_or_next|troop_slot_eq, ":possible_rival", slot_troop_love_interest_2, "$g_talk_troop"),
			(troop_slot_eq, ":possible_rival", slot_troop_love_interest_2, "$g_talk_troop"),
		(call_script, "script_troop_get_relation_with_troop", "$g_talk_troop", ":possible_rival"),

		(try_begin),
			(eq, "$cheat_mode", 1),
			(str_store_troop_name, s4, ":possible_rival"),
			(display_message, "str_rival_found_s4_reg0_relation"),
		(try_end),
		(gt, reg0, "$g_talk_troop_relation"),
		(assign, "$romantic_rival", ":possible_rival"),
	(try_end),
	(gt, "$romantic_rival", -1),
	
    ],
    "Sir -- as you may know, I have been entertaining offers from a number of gentlemen such as yourself. I am not yet at a stage where I can commit to any of them.", "lady_other_suitor",[
    ]],

	
  [anyone,"lady_marriage_discussion",
    [
    (troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_ambitious),
	(neg|troop_slot_ge, "trp_player", slot_troop_renown, 350),
	],
    "It is good to hear that you are thinking seriously about the future. However, I would like to see you rise a little further in the world before I am ready to commit to marry you.", "lady_proposal_refused",[
    ]],	

  [anyone,"lady_marriage_discussion",
    [
    (troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_moralist),
	(lt, "$player_honor", 10)
	],
    "It is good to hear that your intentions are honorable. However, I have resolved only to marry a man of the strongest moral fiber. I would like you to prove yourself more in that regard.", "lady_proposal_refused",[
    ]],	
	
	
  [anyone,"lady_marriage_discussion",
    [
	(lt, "$g_talk_troop_relation", 20),
    ],
    "Sir -- it is comforting to hear that your intentions towards me are honorable. But perhaps we should take the time to get to allow our affections for each other to grow a little stronger, before making any such decision.", "lady_proposal_refused",[
    ]],	
	

	
  [anyone,"lady_marriage_discussion",
    [
	(call_script, "script_get_kingdom_lady_social_determinants", "$g_talk_troop"),
	(assign, ":guardian", reg0),
	(troop_slot_eq, ":guardian", slot_lord_granted_courtship_permission, -1),
	(str_store_troop_name, s4, reg0),	
	(call_script, "script_troop_get_family_relation_to_troop", ":guardian", "$g_talk_troop"),
	],
    "Oh {playername}, how happy that would make me! But my {s11} {s4} would never allow it... Perhaps it is best that we part...", "lady_betrothed", []],	
	
  [anyone,"lady_marriage_discussion",
    [
	(call_script, "script_get_kingdom_lady_social_determinants", "$g_talk_troop"),
	(assign, ":guardian", reg0),
	(call_script, "script_troop_get_family_relation_to_troop", ":guardian", "$g_talk_troop"),
	(str_store_troop_name, s4, ":guardian"),
	
	],
    "Oh {playername}, how happy that would make me! Go ask my {s11} {s4} for permission!", "close_window",[
	(call_script, "script_get_kingdom_lady_social_determinants", "$g_talk_troop"),
	(assign, ":guardian", reg0),
	(str_store_troop_name, s12, ":guardian"),
	(str_store_troop_name, s15, "$g_talk_troop"),
    (setup_quest_text, "qst_formal_marriage_proposal"),
    (str_store_string, s2, "str_you_intend_to_ask_s12_for_permission_to_marry_s15"),
	
    (quest_set_slot, "qst_formal_marriage_proposal", slot_quest_target_troop, ":guardian"),
    (quest_set_slot, "qst_formal_marriage_proposal", slot_quest_expiration_days, 30),
    (quest_set_slot, "qst_formal_marriage_proposal", slot_quest_current_state, 0),
	(call_script, "script_start_quest", "qst_formal_marriage_proposal", "$g_talk_troop"),
	(quest_set_slot, "qst_formal_marriage_proposal", slot_quest_giver_troop, "$g_talk_troop"),
	
	#Repeated to ensure strings work correctly
	(call_script, "script_troop_get_family_relation_to_troop", ":guardian", "$g_talk_troop"),
	(str_store_troop_name, s4, ":guardian"),
    ]],	

  [anyone|plyr,"lady_proposal_refused",
    [
	(is_between, "$g_talk_troop_relation", 12, 20),
    (this_or_next|neg|troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_ambitious),
		(troop_slot_ge, "trp_player", slot_troop_renown, 350),	
    (this_or_next|neg|troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_moralist),
		(ge, "$player_honor", 10),
	],
    "Perhaps I can persuade you to delay no further.", "lady_proposal_refused_persuade_check",[
    ]],	
	
  [anyone,"lady_proposal_refused_persuade_check",
    [
	],
    "What do you have to say?", "lady_proposal_refused_persuade_player_response",[
	
	(assign, reg4, 20),
	(call_script, "script_troop_get_relation_with_troop", "$g_talk_troop", "trp_player"),
	(assign, ":cur_relation", reg0),
	(assign, reg5, ":cur_relation"),
	(assign, reg9, 1),
    (store_skill_level, ":persuasion_level", "skl_persuasion", "trp_player"),
	(store_sub, ":difference", 20, ":cur_relation"),
	(val_mul, ":persuasion_level", 2), 
	(try_begin),
		(gt, ":difference", ":persuasion_level"),
		(assign, "$g_persuasion_failure_chance", 100),
	(else_try),
		(store_mul, "$g_persuasion_failure_chance", ":difference", 100),
		(val_div, "$g_persuasion_failure_chance", ":persuasion_level"),
	(try_end),
	(assign, reg8, "$g_persuasion_failure_chance"),
	(store_sub, reg7, 100, "$g_persuasion_failure_chance"),
	(dialog_box, "str_persuasion_opportunity"),

    ]],	
	
  [anyone|plyr,"lady_proposal_refused_persuade_player_response",
    [
	],
    "Love is as a rose, my lady. Left unplucked, it may wither.", "lady_proposal_refused_persuade_result",[
    ]],	
	
  [anyone|plyr,"lady_proposal_refused_persuade_player_response",
    [],
    "Oh, never mind.", "lady_pretalk",
    []],	
	
	
  [anyone,"lady_proposal_refused_persuade_result",
    [
	(store_random_in_range, ":random", 0, 100),
	(lt, ":random", "$g_persuasion_failure_chance"),
	],
    "Enough, sir! I shall not be rushed into marriage, with you or with anyone else! You have made me very cross. Please, leave me alone for a while. I shall let you know when I am ready to speak to you again.", "close_window", [
	(call_script, "script_troop_change_relation_with_troop", "$g_talk_troop", "trp_player", -1),
	(jump_to_menu, "mnu_town"),
	(finish_mission),
	]],	


  [anyone,"lady_proposal_refused_persuade_result",
    [
	(call_script, "script_get_kingdom_lady_social_determinants", "$g_talk_troop"),
	(assign, ":guardian", reg0),
	(troop_slot_eq, ":guardian", slot_lord_granted_courtship_permission, -1),
	(str_store_troop_name, s4, reg0),	
	(call_script, "script_troop_get_family_relation_to_troop", ":guardian", "$g_talk_troop"),
	],
    "Oh {playername}, I could never allow that to happen! Oh, if only we could be wed! But my {s11} {s4} would never give his permission... Perhaps it is best that we part...", "lady_betrothed", [
	(call_script, "script_troop_change_relation_with_troop", "$g_talk_troop", "trp_player", 5),
	]],	
	
  [anyone,"lady_proposal_refused_persuade_result",
    [
	(call_script, "script_get_kingdom_lady_social_determinants", "$g_talk_troop"),
	(assign, ":guardian", reg0),
	(call_script, "script_troop_get_family_relation_to_troop", ":guardian", "$g_talk_troop"),
	(str_store_troop_name, s4, ":guardian"),
	
	],
    "Oh {playername}, I could never allow that to happen! Go ask my {s11} {s4} his permission for us to be wed!", "close_window",[
	
	(call_script, "script_troop_change_relation_with_troop", "$g_talk_troop", "trp_player", 5),
	(call_script, "script_get_kingdom_lady_social_determinants", "$g_talk_troop"),
	(assign, ":guardian", reg0),
	(str_store_troop_name, s12, ":guardian"),
	(str_store_troop_name, s15, "$g_talk_troop"),
    (setup_quest_text, "qst_formal_marriage_proposal"),
    (str_store_string, s2, "str_you_intend_to_ask_s12_for_permission_to_marry_s15"),
	
    (quest_set_slot, "qst_formal_marriage_proposal", slot_quest_target_troop, ":guardian"),
    (quest_set_slot, "qst_formal_marriage_proposal", slot_quest_expiration_days, 30),
    (quest_set_slot, "qst_formal_marriage_proposal", slot_quest_current_state, 0),
	(call_script, "script_start_quest", "qst_formal_marriage_proposal", "$g_talk_troop"),
	(quest_set_slot, "qst_formal_marriage_proposal", slot_quest_giver_troop, "$g_talk_troop"),
    ]],	

  [anyone|plyr,"lady_proposal_refused",
    [],
    "Very well -- I shall continue to strive to be worthy of your esteem!", "close_window",[
    ]],	

  [anyone|plyr,"lady_proposal_refused",
    [
	(eq, 1, 0),
	(neg|check_quest_active, "qst_formal_marriage_proposal"),
	],
    "I am tired of these games! I will speak to your family about arranging a wedding immediately..", "lady_player_threatens_compel",[
    ]],	
	
  [anyone,"lady_player_threatens_compel",
    [],
    "What? Do you mean that?", "lady_player_threatens_compel_2",[
    ]],	
	
  [anyone|plyr,"lady_player_threatens_compel_2",
    [],
    "No, of couse not. Please forgive my burst of temper", "lady_private_conversation_end",[
    ]],	
	
  [anyone|plyr,"lady_player_threatens_compel_2",
    [],
    "Yes -- you clearly do not know what is in your best interests.", "close_window",[
	(call_script, "script_get_kingdom_lady_social_determinants", "$g_talk_troop"),
	(assign, ":guardian", reg0),
	(str_store_troop_name, s10, "$g_talk_troop"),
	(str_store_troop_name, s12, ":guardian"),
    (setup_quest_text, "qst_formal_marriage_proposal"),
    (str_store_string, s2, "str_you_intend_to_ask_s12_to_pressure_s10_to_marry_you"),
	
    (quest_set_slot, "qst_formal_marriage_proposal", slot_quest_target_troop, ":guardian"),
    (quest_set_slot, "qst_formal_marriage_proposal", slot_quest_expiration_days, 30),
    (quest_set_slot, "qst_formal_marriage_proposal", slot_quest_current_state, 0),
	(call_script, "script_start_quest", "qst_formal_marriage_proposal", "$g_talk_troop"),
	(quest_set_slot, "qst_formal_marriage_proposal", slot_quest_giver_troop, "$g_talk_troop"), 
    ]],	
	
	
	
	#rival suitor sequence
  [anyone|plyr,"lady_other_suitor",
    [],
	"It grieves me to hear that, my lady, but such things must be", "lady_pretalk",
	[]],
	
  [anyone|plyr,"lady_other_suitor",
	[],
	"Who is the miscreant! Tell me his name!", "lady_other_suitor_challenge",
	[]],
	
  [anyone|plyr,"lady_other_suitor", #similar to other
    [
	(eq, 1, 0),
	],
    "I am tired of these games! I will demand that your family compel you to marry me..", "lady_player_threatens_compel",[
    ]],		
	
  [anyone,"lady_other_suitor_challenge",
	[
	  (check_quest_active,"qst_duel_courtship_rival"),
      (call_script, "script_troop_get_relation_with_troop", "$g_talk_troop", "$romantic_rival"),
	  (lt, reg0, 0)
	],
	"I would be so grateful! But from what I understand, you already have a duel on your hands. He is not honor-bound to fight you, if you are committed to another combat. Please, conclude your other business in a hurry, to rescue me from that man's attentions!.", "lady_pretalk",
	[]],
		
  [anyone,"lady_other_suitor_challenge",
	[
	(check_quest_active,"qst_duel_courtship_rival")
	],
	"Ah! Such talk. But from what I hear, you already have a duel on your hands. Finish one before you start another! Sigh... You men can be so silly...", "lady_pretalk",
	[]],
	
  [anyone,"lady_other_suitor_challenge",
	[
    (call_script, "script_troop_get_relation_with_troop", "$g_talk_troop", "$romantic_rival"),
	(lt, reg0, 0),
	(str_store_troop_name, s5, "$romantic_rival"),	
	],
	"It is {s5}. Please, rescue me from that man's attentions!", "lady_other_suitor_challenge_confirm",
	[]],

	
  
  [anyone,"lady_other_suitor_challenge",
	[
	(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_ambitious),
	(str_store_troop_name, s5, "$romantic_rival"),
	],
	"Will you now? This should be interesting. Very well. Your rival is {s5}. Let us see which of you has the greater mettle.", "lady_other_suitor_challenge_confirm",
	[
	(assign, "$quarrel_penalty", 0),
	]],
  
  [anyone,"lady_other_suitor_challenge",
	[
	(troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_conventional),
	(str_store_troop_name, s5, "$romantic_rival"),
	],
	"Oh, fie! I wish that this were not a matter of honor, so I could refuse such a request. But alas, I feel compelled to tell you that your rival is {s5}. I wish that heaven had not granted me such a fair visage, so that I would not inspire such passions in men!", "lady_other_suitor_challenge_confirm",
	[
	(assign, "$quarrel_penalty", -1),
	]],
  
  [anyone,"lady_other_suitor_challenge",
	[
	(str_store_troop_name, s5, "$romantic_rival"),
	],
	"I will have none of such talk! It is nonsense for you and {s5} to fight over -- whoops! I beg of you, sir, forget the name that just escaped my lips...", "lady_other_suitor_challenge_confirm",
	[
	(assign, "$quarrel_penalty", -3),
	]],
	
  [anyone|plyr,"lady_other_suitor_challenge_confirm",
	[],
	"So be it! I shall challenge him to a trial of arms!", "lady_other_suitor_challenge_confirm_yes",
	[]],
	
  [anyone|plyr,"lady_other_suitor_challenge_confirm",
	[],
	"On second thought, I let my passions run away with me there. Never mind.", "lady_other_suitor_challenge_confirm_no",
	[]],

  [anyone,"lady_other_suitor_challenge_confirm_yes",
	[
	  (try_begin),
	    (call_script, "script_troop_get_relation_with_troop", "$g_talk_troop", "$romantic_rival"),
	    (lt, reg0, 0),
	    (str_store_string, s15, "str_do_be_careful_i_am_so_much_endebted_to_you_for_this"),
	  (else_try),
	    (troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_ambitious),
	    (str_store_string, s15, "str_go_then__we_shall_see_which_of_you_triumphs"),
	  (else_try),
	    (str_store_string, s15, "str_sigh_i_will_never_truly_understand_men_and_their_rash_actions"),
	  (try_end),
	],
	"{s15}", "lady_pretalk",
	[
	  (call_script, "script_troop_change_relation_with_troop", "trp_player", "$g_talk_troop", "$quarrel_penalty"),
	  (str_store_troop_name, s11, "$g_talk_troop"),
	  (str_store_troop_name_link, s13, "$romantic_rival"),
	  (setup_quest_text, "qst_duel_courtship_rival"),
	  (str_store_string, s2, "str_you_intend_to_challenge_s13_to_force_him_to_relinquish_his_suit_of_s11"),
	  
	  (call_script, "script_start_quest", "qst_duel_courtship_rival", "$g_talk_troop"),
	  
	  (quest_set_slot, "qst_duel_courtship_rival", slot_quest_target_troop, "$romantic_rival"),
	  
	  (quest_set_slot, "qst_duel_courtship_rival", slot_quest_xp_reward, 400),
	  (quest_set_slot, "qst_duel_courtship_rival", slot_quest_expiration_days, 60),
	  (quest_set_slot, "qst_duel_courtship_rival", slot_quest_current_state, 0),
	]],

  [anyone,"lady_other_suitor_challenge_confirm_no",
	[],
	"Good. You are wise not to let your temper guide you.", "lady_private_conversation_end",
	[]],


	

	
	
  [anyone|plyr,"lady_talk",
   [
	 (troop_slot_ge, "$g_talk_troop", slot_troop_spouse, 0),
#     (troop_slot_ge, "$g_talk_troop", slot_troop_met, 2),
     (store_partner_quest, ":ladys_quest"),
     (lt, ":ladys_quest", 0)
     ],
   "Is there anything I can do to win your favour?", "lady_ask_for_quest",[(call_script, "script_get_quest", "$g_talk_troop"),
                                                                 (assign, "$random_quest_no", reg0)]],
                                                                 
  [anyone,"lady_ask_for_quest", 
  [        
    (troop_slot_eq, "$g_talk_troop", slot_troop_does_not_give_quest, 1),
  ],
   "I don't have anything else for you to do right now.", "lady_pretalk", []],
  
  [anyone,"lady_ask_for_quest", 
  [   
	 (this_or_next|eq, "$random_quest_no", "qst_rescue_lord_by_replace"),
	 (eq, "$random_quest_no", "qst_rescue_prisoner"),
	 
     (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
     (call_script, "script_troop_get_family_relation_to_troop", ":quest_target_troop", "$g_talk_troop"),
     (str_store_string, s17, s11),
  ],
   "Oh, I fear I may never see my {s17}, {s13}, again... He is a prisoner in the dungeon of {s14}.\
 We have tried to negotiate his ransom, but it has been set too high.\
 We can never hope to raise that much money without selling everything we own,\
 and God knows {s13} would rather spend his life in prison than make us destitute.\
 Instead I came up with a plan to get him out of there, but it requires someone to make a great sacrifice,\
 and so far my pleas have fallen on deaf ears...", "lady_mission_told",
   [
     (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
     (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
     (call_script, "script_troop_get_family_relation_to_troop", ":quest_target_troop", "$g_talk_troop"),
     (str_store_string, s17, s11),
    
     (str_store_troop_name, s11, "$g_talk_troop"),
     (str_store_troop_name_link, s13, ":quest_target_troop"),
     (str_store_party_name_link, s14, ":quest_target_center"),
     (setup_quest_text,"$random_quest_no"),
     
     (try_begin),
       (eq, "$random_quest_no", "qst_rescue_lord_by_replace"),
       (str_store_string, s2, "@{s11} asked you to rescue her {s17}, {s13}, from {s14} by switching clothes and taking his place in prison."),
     (else_try),  
       (str_store_string, s2, "@{s11} asked you to rescue her {s17}, {s13}, from {s14}."),
     (try_end),
    ]],

  [anyone,"lady_ask_for_quest", [
     (eq, "$random_quest_no", "qst_deliver_message_to_prisoner_lord"),
     (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
     (call_script, "script_troop_get_family_relation_to_troop", ":quest_target_troop", "$g_talk_troop"),
	 
  ],
   "My poor {s11}, {s13}, is a prisoner in the {s14} dungeons.\
 The only way we can talk to each other is by exchanging letters whenever we can,\
 but the journey is so dangerous that we get little chance to do so.\
 Please, would you deliver one for me?", "lady_mission_told",
   [
     (quest_get_slot, ":quest_target_center", "$random_quest_no", slot_quest_target_center),
     (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),

	
     (str_store_troop_name, s11, "$g_talk_troop"),
     (str_store_troop_name_link, s13, ":quest_target_troop"),
     (str_store_party_name_link, s14, ":quest_target_center"),
     (setup_quest_text,"$random_quest_no"),
     (str_store_string, s2, "@{s11} asked you to deliver a message to {s13}, who is imprisoned at {s14}."),
    ]],
  

  [anyone,"lady_ask_for_quest", [(eq, "$random_quest_no", "qst_duel_for_lady")],
   "Dear {playername}, you are kind to ask, but you know little of my troubles\
 and I can't possibly ask you to throw yourself into danger on my behalf.", "lady_quest_duel_for_lady",[]],
 
  [anyone|plyr,"lady_quest_duel_for_lady", [], "Tell me what the problem is, and I can make my own decision.", "lady_quest_duel_for_lady_2",
   [
     (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),

     (str_store_troop_name, s11, "$g_talk_troop"),
     (str_store_troop_name_link, s13, ":quest_target_troop"),
     (str_store_string, s2, "@You agreed to challenge {s13} to defend {s11}'s honour."),
     (setup_quest_text,"$random_quest_no"),
    ]],
    
  [anyone,"lady_quest_duel_for_lady_2", [], "Very well, as you wish it...\
 My husband has made certain enemies in his life, {playername}. One of the most insidious is {s13}.\
 He is going around making terrible accusations against me, impugning my honour at every turn!\
 Because he cannot harm my husband directly, he is using me as a target to try and stain our name.\
 You should hear the awful things he's said! I only wish there was someone brave enough to make him recant his slander,\
 but {s13} is a very fine swordsman, and he's widely feared...", "lady_quest_duel_for_lady_3",[]],

  [anyone|plyr,"lady_quest_duel_for_lady_3", [], "I fear him not, {s65}. I will make him take back his lies.", "lady_quest_duel_for_lady_3_accepted",[]],
  [anyone,"lady_quest_duel_for_lady_3_accepted", [], "Oh! I can't ask that of you, {playername}, but...\
 I would be forever indebted to you, and you are so sure. It would mean so much if you would defend my honour.\
 Thank you a thousand times, all my prayers and my favour go with you.", "close_window",
   [

     (quest_get_slot, ":quest_target_troop", "$random_quest_no", slot_quest_target_troop),
     (call_script, "script_start_quest", "$random_quest_no", "$g_talk_troop"),
     (call_script, "script_report_quest_troop_positions", "$random_quest_no", ":quest_target_troop", 3),
     (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", 3),
     ]],

  [anyone|plyr,"lady_quest_duel_for_lady_3", [], "If he's that dangerous, perhaps maybe it would be better to ignore him...", "lady_quest_duel_for_lady_3_rejected",[]],
  [anyone,"lady_quest_duel_for_lady_3_rejected", [], "Oh... Perhaps you're right, {playername}.\
 I should let go of these silly childhood ideas of chivalry and courage. {Men/People} are not like that,\
 not anymore. Good day to you.", "close_window",
   [(troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1),
    (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", -1),
    ]],


  [anyone,"lady_ask_for_quest", [], "No, {playername}, I've no need for a champion right now.", "lady_pretalk",[]],

  [anyone|plyr,"lady_mission_told", [], "As you wish it, {s65}, it shall be done.", "lady_mission_accepted",[]],
  [anyone|plyr,"lady_mission_told", [], "{s66}, I fear I cannot help you right now.", "lady_mission_rejected",[]],

  [anyone,"lady_mission_accepted", [], "You are a true {gentleman/lady}, {playername}.\
 Thank you so much for helping me", "close_window",
   [
     (try_begin),
       (eq, "$random_quest_no", "qst_deliver_message_to_prisoner_lord"),
       (call_script, "script_troop_add_gold", "trp_player", 10),
     (try_end),
     (call_script, "script_start_quest", "$random_quest_no", "$g_talk_troop"),
    ]],
  [anyone,"lady_mission_rejected", [], "You'll not help a woman in need? You should be ashamed, {playername}...\
 Please leave me, I have some important embroidery to catch up.", "close_window",
   [
     (call_script, "script_change_player_relation_with_troop", "$g_talk_troop", -1),
     (troop_set_slot, "$g_talk_troop", slot_troop_does_not_give_quest, 1),
    ]],

#Leave
  [anyone|plyr,"lady_talk", [
  (troop_slot_ge, "$g_talk_troop", slot_troop_spouse, 0),
  ], "I want to improve my relation with a lord. Can you help me?", "lady_restore_relation",[]],
  [anyone,"lady_restore_relation", [(le, "$g_talk_troop_relation", 0)], "{playername}, I don't know you well enough to act on your behalf. I am sorry.", "lady_pretalk",[]],
  [anyone,"lady_restore_relation", [], "Hmm. I guess you got on the wrong side of somebody. Very well, who do you want to restore your relation with?", "lady_restore_relation_2",[]],

  [anyone|plyr|repeat_for_troops,"lady_restore_relation_2", [(store_repeat_object, ":troop_no"),
                                                             (is_between, ":troop_no", active_npcs_begin, active_npcs_end),
                                                             (store_troop_faction, ":faction_no", ":troop_no"),
                                                             (eq, "$g_talk_troop_faction", ":faction_no"),
                                                             (call_script, "script_troop_get_player_relation", ":troop_no"),
                                                             (lt, reg0, 0),
                                                             (str_store_troop_name, s1, ":troop_no")],
   "{s1}", "lady_restore_relation_2b",[(store_repeat_object, "$troop_to_restore_relations_with")]],
  [anyone|plyr,"lady_restore_relation_2", [], "Never mind. I get along with everyone well enough.", "lady_pretalk",[]],

  [anyone,"lady_restore_relation_2b", [(str_store_troop_name, s10, "$troop_to_restore_relations_with")], "Well I can try to help you there.\
 I am sure a few expensive gifts will make {s10} look at you more favorably.", "lady_restore_relation_3",[]],
  
  [anyone,"lady_restore_relation_3", [(str_store_troop_name, s10, "$troop_to_restore_relations_with"),
                                      (assign, "$lady_restore_cost_1", 1000),
                                      (assign, "$lady_restore_cost_2", 2000),
                                      (assign, "$lady_restore_cost_3", 3000),
                                      (assign, reg10, "$lady_restore_cost_1"),
                                      (assign, reg11, "$lady_restore_cost_2"),
                                      (assign, reg12, "$lady_restore_cost_3"),
                                      (troop_get_type, reg4, "$troop_to_restore_relations_with"),
                                      ],
   "You can improve your relation with {s10} by sending {reg4?her:him} a gift worth {reg10} denars.\
 But if you can afford spending {reg11} denars on the gift, it would make a good impression on {reg4?her:him}.\
 And if you can go up to {reg12} denars, that would really help smooth things out.", "lady_restore_relation_4",[]],

  [anyone|plyr,"lady_restore_relation_4", [(store_troop_gold,":gold", "trp_player"),
                                           (ge, ":gold", "$lady_restore_cost_1"),
                                           (assign, reg10, "$lady_restore_cost_1")],
   "I think a gift of {reg10} denars will do.", "lady_restore_relation_5",[(assign, "$temp", 1), (assign, "$temp_2", "$lady_restore_cost_1")]],
  [anyone|plyr,"lady_restore_relation_4", [(store_troop_gold,":gold", "trp_player"),
                                           (ge, ":gold", "$lady_restore_cost_2"),
                                           (assign, reg11, "$lady_restore_cost_2")],
   "Maybe I can afford {reg11} denars.", "lady_restore_relation_5",[(assign, "$temp", 2), (assign, "$temp_2", "$lady_restore_cost_2")]],
  [anyone|plyr,"lady_restore_relation_4", [(store_troop_gold,":gold", "trp_player"),
                                           (ge, ":gold", "$lady_restore_cost_3"),
                                           (assign, reg12, "$lady_restore_cost_3")],
   "In that case, I am ready to spend {reg12} denars.", "lady_restore_relation_5",[(assign, "$temp", 3), (assign, "$temp_2", "$lady_restore_cost_3")]],
  
  [anyone|plyr,"lady_restore_relation_4", [], "I don't think I can afford a gift at the moment.", "lady_restore_relation_cant_afford",[]],
  
  [anyone,"lady_restore_relation_5", [], "Excellent. Then I'll choose an appropriate gift for you and send it to {s10} with your compliments.\
 I am sure {reg4?she:he} will appreciate the gesture.", "lady_restore_relation_6",[
     (troop_remove_gold, "trp_player","$temp_2"),
     (call_script, "script_change_player_relation_with_troop", "$troop_to_restore_relations_with", "$temp"),
     (troop_get_type, reg4, "$troop_to_restore_relations_with"),
     ]],

  [anyone|plyr,"lady_restore_relation_6", [], "Thank you for your help, madame.", "lady_pretalk",[]],

  [anyone,"lady_restore_relation_cant_afford", [], "I am afraid, I can't be of much help in that case, {playername}. I am sorry.", "lady_pretalk",[]],
 
  [anyone|plyr,"lady_talk", [], "I must beg my leave.", "lady_leave",[]],
  
  [anyone|auto_proceed,"lady_leave", [
  (call_script, "script_troop_get_relation_with_troop", "$g_talk_troop", "trp_player"),
  (try_begin),
	(lt, reg0, 0),
	(str_store_string, s12, "str_farewell"),
  (else_try),
	(str_store_string, s12, "str_farewell_playername"),
  (try_end),
  ], "{s12}", "close_window",[(eq,"$talk_context",tc_party_encounter),(assign, "$g_leave_encounter", 1)]],



#Convincing bargaining
  [anyone,"convince_begin", [], "I still don't see why I should accept what you're asking of me.", "convince_options",
   [(quest_get_slot, "$convince_value", "$g_convince_quest", slot_quest_convince_value),
    ]],
    
  [anyone|plyr,"convince_options", [(assign, reg8, "$convince_value")], "Then I'll make it worth your while. ({reg8} denars)", "convince_bribe",[]],
  [anyone|plyr,"convince_options", 
  [(store_div, "$convince_relation_penalty", "$convince_value", 300),
   (val_add, "$convince_relation_penalty", 1),
   (assign, reg9, "$convince_relation_penalty")], 
   "Please, do it for the sake of our friendship. (-{reg9} to relation)", "convince_friendship",[]],
  [anyone|plyr,"convince_options", [], "Let me try and convince you. (Persuasion)", "convince_persuade_begin", []],
  [anyone|plyr,"convince_options", [], "Never mind.", "lord_pretalk",[]],

  [anyone,"convince_bribe", [], "Mmm, a generous gift to my coffers would certainly help matters...\
 {reg8} denars should do it. If you agree, then I'll go with your suggestion.", "convince_bribe_verify",[]],

  [anyone|plyr,"convince_bribe_verify", [(store_troop_gold, ":gold", "trp_player"),
                                         (lt, ":gold", "$convince_value")],
   "I'm afraid my finances will not allow for such a gift.", "convince_bribe_cant_afford",[]],
  [anyone|plyr,"convince_bribe_verify", [(store_troop_gold, ":gold", "trp_player"),
                                         (ge, ":gold", "$convince_value")],
  "Very well, please accept these {reg8} denars as a token of my gratitude.", "convince_bribe_goon",[]],
  [anyone|plyr,"convince_bribe_verify", [], "Let me think about this some more.", "convince_begin",[]],

  [anyone,"convince_bribe_cant_afford", [], "Ah. In that case, there is little I can do,\
 unless you have some further argument to make.", "convince_options",[]],
   [anyone,"convince_bribe_goon", [], "My dear {playername}, your generous gift has led me to reconsider what you ask,\
 and I have come to appreciate the wisdom of your proposal.", "convince_accept",[(troop_remove_gold, "trp_player","$convince_value")]],

  [anyone,"convince_friendship",
   [(store_add, ":min_relation", 5, "$convince_relation_penalty"),
    (ge, "$g_talk_troop_effective_relation", ":min_relation")], "You've done well by me in the past, {playername},\
 and for that I will go along with your request, but know that I do not like you using our relationship this way.", "convince_friendship_verify",[]],

  [anyone|plyr,"convince_friendship_verify", [], "I am sorry, my friend, but I need your help in this.", "convince_friendship_go_on",[]],
  [anyone|plyr,"convince_friendship_verify", [], "If it will not please you, then I'll try something else.", "lord_pretalk",[]],

  [anyone,"convince_friendship_go_on", [], "All right then, {playername}, I will accept this for your sake. But remember, you owe me for this.", "convince_accept",
   [(store_sub, ":relation_change", 0, "$convince_relation_penalty"),
    (call_script, "script_change_player_relation_with_troop","$g_talk_troop",":relation_change")]],

  [anyone,"convince_friendship",
   [(ge, "$g_talk_troop_relation", -5)], "I don't think I owe you such a favor {playername}.\
 I see no reason to accept this for you.", "lord_pretalk",[]],

  [anyone,"convince_friendship", [], "Is this a joke? You've some nerve asking me for favours, {playername},\
 and let me assure you you'll get none.", "lord_pretalk",[]],

  [anyone,"convince_persuade_begin", 
  [(troop_get_slot, ":last_persuasion_time", "$g_talk_troop", slot_troop_last_persuasion_time),
   (store_current_hours, ":cur_hours"),
   (store_add, ":valid_time", ":last_persuasion_time", 24),
   (gt, ":cur_hours", ":valid_time"),
   ], 
   "Very well. Make your case.", "convince_persuade_begin_2",[]],
   
   
  [anyone|plyr,"convince_persuade_begin_2", [], "[Attempt to persuade]", "convince_persuade",[
        (try_begin),
          (store_random_in_range, ":rand", 0, 100),
          (lt, ":rand", 30),
          (store_current_hours, ":cur_hours"),
          (troop_set_slot, "$g_talk_troop", slot_troop_last_persuasion_time, ":cur_hours"),
        (try_end),
        (store_skill_level, ":persuasion_level", "skl_persuasion", "trp_player"),
        (store_add, ":persuasion_potential", ":persuasion_level", 5),

        (store_random_in_range, ":random_1", 0, ":persuasion_potential"),
        (store_random_in_range, ":random_2", 0, ":persuasion_potential"),
        (store_add, ":rand", ":random_1", ":random_2"),

        (assign, ":persuasion_difficulty", "$convince_value"),
        (convert_to_fixed_point, ":persuasion_difficulty"),
        (store_sqrt, ":persuasion_difficulty", ":persuasion_difficulty"),
        (convert_from_fixed_point, ":persuasion_difficulty"),
        (val_div, ":persuasion_difficulty", 10),
        (val_add, ":persuasion_difficulty", 4),

        (store_sub, "$persuasion_strength", ":rand", ":persuasion_difficulty"),
        (val_mul, "$persuasion_strength", 20),
        (assign, reg5, "$persuasion_strength"),
        (val_sub, "$convince_value", "$persuasion_strength"),
        (quest_set_slot, "$g_convince_quest", slot_quest_convince_value, "$convince_value"),
        (str_store_troop_name, s50, "$g_talk_troop"),
        (troop_get_type, reg51, "$g_talk_troop"),
        (try_begin),
          (lt, "$persuasion_strength", -30),
          (str_store_string, s5, "str_persuasion_summary_very_bad"),
        (else_try),
          (lt, "$persuasion_strength", -10),
          (str_store_string, s5, "str_persuasion_summary_bad"),
        (else_try),
          (lt, "$persuasion_strength", 10),
          (str_store_string, s5, "str_persuasion_summary_average"),
        (else_try),
          (lt, "$persuasion_strength", 30),
          (str_store_string, s5, "str_persuasion_summary_good"),
        (else_try),
          (str_store_string, s5, "str_persuasion_summary_very_good"),
        (try_end),
        (dialog_box, "@{s5} (Persuasion strength: {reg5})", "@Persuasion Attempt"),
  ]],
  [anyone|plyr,"convince_persuade_begin_2", [], "Wait, perhaps there is another way to convince you.", "convince_begin",[]],

  [anyone,"convince_persuade_begin", [], "By God's grace, {playername}!\
 Haven't we talked enough already? I am tired of listening to you,\
 and I do not want to hear any more of it right now.", "lord_pretalk",[]],
 
  [anyone,"convince_persuade", [(le, "$convince_value", 0)], "All right, all right. You have persuaded me to it.\
 I'll go ahead with what you suggest.", "convince_accept",[]],
  [anyone,"convince_persuade", [(gt, "$persuasion_strength", 5)], "You've a point, {playername},\
 I'll admit that much. However I am not yet convinced I should do as you bid.", "convince_options",[]],
  [anyone,"convince_persuade", [(gt, "$persuasion_strength", -5)], "Enough, {playername}.\
 You've a lot of arguments, but I find none of them truly convincing. I stand by what I said before.", "convince_options",[]],
  [anyone,"convince_persuade", [], "Truthfully, {playername}, I fail to see the virtue of your reasoning.\
 What you ask for makes even less sense now than it did before.", "convince_options",[]],

#Seneschal

  [anyone,"start", [(troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_seneschal),
                    (eq, "$talk_context", tc_siege_won_seneschal),
                    (str_store_party_name, s1, "$g_encountered_party"),
                    ],
   "I must congratulate you on your victory, my {lord/lady}. Welcome to {s1}.\
 We, the housekeepers of this castle, are at your service.", "siege_won_seneschal_1",[]],
  [anyone|plyr,"siege_won_seneschal_1", [], "Are you the seneschal?", "siege_won_seneschal_2",[]],
  [anyone,"siege_won_seneschal_2", [], "Indeed I am, my {lord/lady}.\
 I have always served the masters of {s1} to the best of my ability, whichever side they might be on.\
 Thus you may count on my utmost loyalty for as long as you are the {lord/lady} of this place.\
 Now, do you intend to keep me on as the seneschal? I promise you will not be disappointed.", "siege_won_seneschal_3",[]],
  [anyone|plyr,"siege_won_seneschal_3", [], "Very well, you may keep your post for the time being.", "siege_won_seneschal_4",[]],
  [anyone|plyr,"siege_won_seneschal_3", [], "You can stay, but I shall be keeping a close watch on you.", "siege_won_seneschal_4",[]],
  [anyone,"siege_won_seneschal_4", [], "Thank you, my {lord/lady}. If you do not mind my impudence,\
 may I inquire as to what you wish to do with the castle?", "siege_won_seneschal_5",[]],

  [anyone|plyr,"siege_won_seneschal_5", [], "I will sell it to another lord.", "siege_won_seneschal_6",[]],
  [anyone|plyr,"siege_won_seneschal_5", [], "I intend to claim it for myself.", "siege_won_seneschal_6",[]],
  
  [anyone|plyr,"siege_won_seneschal_5", [], "I haven't given it much thought. What are my options?", "siege_won_seneschal_list_options",[]],

  [anyone,"siege_won_seneschal_list_options", [], "According to our laws and traditions,\
 you can do one of several things.\
 First, you could station a garrison here to protect the castle from any immediate counterattacks,\
 then request an audience with some wealthy lord and ask him to make you an offer.\
 It would be worth a tidy sum, believe you me.\
 If you do not wish to sell, then you will have to find yourself a liege lord and protector who would accept homage from you.\
 Without a royal investiture and an army at your back, you would have a difficult time holding on to the castle.\
 Both you and {s1} would become great big targets for any man with a few soldiers and a scrap of ambition.\
 ", "siege_won_seneschal_list_options_2",[]],

  [anyone|plyr,"siege_won_seneschal_list_options_2", [], "What do you mean, a liege lord and protector? I won this place by my own hand, I don't need anyone else!", "siege_won_seneschal_list_options_3",[]],
  [anyone,"siege_won_seneschal_list_options_3", [], "Of course you don't, my {lord/lady}.\
 However, no lord in the land will recognize your claim to the castle unless it is verified by royal decree.\
 They would call {s1} an outlaw stronghold and take it from you at the earliest opportunity.\
 Surely not even you could stand against a whole army.", "siege_won_seneschal_list_options_4",[]],
  [anyone|plyr,"siege_won_seneschal_list_options_4", [], "Hmm. I'll give it some thought.", "siege_won_seneschal_6",[]],

  [anyone,"siege_won_seneschal_6", [], "I am very pleased to hear it, my {lord/lady}.\
 I am only trying to serve you to the best of my ability. Now,\
 if at any time you find you have further need of me,\
 I will be in the great hall arranging a smooth handover of the castle to your forces.\
 ", "close_window",[]],

  
  [anyone,"start", [(troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_seneschal),(eq,"$g_talk_troop_met",0),(str_store_party_name,s1,"$g_encountered_party")],
   "Good day, {sir/madam}. I do nott believe I've seen you here before.\
 Let me extend my welcome to you as the seneschal of {s1}.", "seneschal_intro_1",[]],

  [anyone|plyr,"seneschal_intro_1", [],  "A pleasure to meet you, {s65}.", "seneschal_intro_1a",[]],
  [anyone,"seneschal_intro_1a", [], "How can I help you?", "seneschal_talk",[]],
  [anyone|plyr,"seneschal_intro_1", [],  "What exactly do you do here?", "seneschal_intro_1b",[]],
  [anyone,"seneschal_intro_1b", [], "Ah, a seneschal's duties are many, good {sire/woman}.\
 For example, I collect the rents from my lord's estates, I manage the castle's storerooms,\
 I deal with the local peasantry, I take care of castle staff, I arrange supplies for the garrison...\
 All mundane matters on this fief are my responsibility, on behalf of my lord.\
 Everything except commanding the soldiers themselves.", "seneschal_talk",[]],
  
  [anyone,"start", [(troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_seneschal)],
   "Good day, {sir/madam}.", "seneschal_talk",[]],

  [anyone,"seneschal_pretalk", [], "Anything else?", "seneschal_talk",[]],


##### TODO: QUESTS COMMENT OUT BEGIN
##  [anyone|plyr,"seneschal_talk", [(check_quest_active, "qst_deliver_supply_to_center_under_siege"),
##                                  (quest_slot_eq, "qst_deliver_supply_to_center_under_siege", slot_quest_target_troop, "$g_talk_troop"),
##                                  (quest_slot_eq, "qst_deliver_supply_to_center_under_siege", slot_quest_current_state, 1),
##                                  (store_item_kind_count, ":no_supplies", "itm_siege_supply"),
##                                  (quest_get_slot, ":target_amount", "qst_deliver_supply_to_center_under_siege", slot_quest_target_amount),
##                                  (ge, ":no_supplies", ":target_amount")],
##   "TODO: Here are the supplies.", "seneschal_supplies_given",[]],
##
##  [anyone|plyr,"seneschal_talk", [(check_quest_active, "qst_deliver_supply_to_center_under_siege"),
##                                  (quest_slot_eq, "qst_deliver_supply_to_center_under_siege", slot_quest_target_troop, "$g_talk_troop"),
##                                  (quest_slot_eq, "qst_deliver_supply_to_center_under_siege", slot_quest_current_state, 1),
##                                  (store_item_kind_count, ":no_supplies", "itm_siege_supply"),
##                                  (quest_get_slot, ":target_amount", "qst_deliver_supply_to_center_under_siege", slot_quest_target_amount),
##                                  (lt, ":no_supplies", ":target_amount"),
##                                  (gt, ":no_supplies", 0)],
##   "TODO: Here are the supplies, but some of them are missing.", "seneschal_supplies_given_missing",[]],
##  
##  [anyone|plyr,"seneschal_talk", [(check_quest_active, "qst_deliver_supply_to_center_under_siege"),
##                                  (quest_slot_eq, "qst_deliver_supply_to_center_under_siege", slot_quest_object_troop, "$g_talk_troop"),
##                                  (quest_slot_eq, "qst_deliver_supply_to_center_under_siege", slot_quest_current_state, 0)],
##   "TODO: Give me the supplies.", "seneschal_supplies",[]],
##  
##  [anyone,"seneschal_supplies", [(store_free_inventory_capacity, ":free_inventory"),
##                                 (quest_get_slot, ":quest_target_amount", "qst_deliver_supply_to_center_under_siege", slot_quest_target_amount),
##                                 (ge, ":free_inventory", ":quest_target_amount"),
##                                 (quest_get_slot, ":quest_target_center", "qst_deliver_supply_to_center_under_siege", slot_quest_target_center),
##                                 (str_store_party_name, 0, ":quest_target_center"),
##                                 (troop_add_items, "trp_player", "itm_siege_supply", ":quest_target_amount")],
##   "TODO: Here, take these supplies. You must deliver them to {s0} as soon as possible.", "seneschal_pretalk",[(quest_set_slot, "qst_deliver_supply_to_center_under_siege", slot_quest_current_state, 1)]],
##
##  [anyone,"seneschal_supplies", [],
##   "TODO: You don't have enough space to take the supplies. Free your inventory and return back to me.", "seneschal_pretalk",[]],
##
##
##  [anyone,"seneschal_supplies_given", [],
##   "TODO: Thank you.", "seneschal_pretalk",[(party_get_slot, ":town_siege_days", "$g_encountered_party", slot_town_siege_days),
##                                            (quest_get_slot, ":target_amount", "qst_deliver_supply_to_center_under_siege", slot_quest_target_amount),
##                                            (val_sub, ":town_siege_days", ":target_amount"),
##                                            (try_begin),
##                                              (lt, ":town_siege_days", 0),
##                                              (assign, ":town_siege_days", 0),
##                                            (try_end),
##                                            (party_set_slot, "$g_encountered_party", slot_town_siege_days, ":town_siege_days"),
##                                            (troop_remove_items, "trp_player", "itm_siege_supply", ":target_amount"),
##                                            (call_script, "script_finish_quest", "qst_deliver_supply_to_center_under_siege", 100)]],
##
##  [anyone,"seneschal_supplies_given_missing", [],
##   "TODO: Thank you but it's not enough...", "seneschal_pretalk",[(store_item_kind_count, ":no_supplies", "itm_siege_supply"),
##                                                                  (quest_get_slot, ":target_amount", "qst_deliver_supply_to_center_under_siege", slot_quest_target_amount),
##                                                                  (assign, ":percentage_completed", 100),
##                                                                  (val_mul, ":percentage_completed", ":no_supplies"),
##                                                                  (val_div, ":percentage_completed", ":target_amount"),
##                                                                  (call_script, "script_finish_quest", "qst_deliver_supply_to_center_under_siege", ":percentage_completed"),
##                                                                  (party_get_slot, ":town_siege_days", "$g_encountered_party", slot_town_siege_days),
##                                                                  (val_sub, ":town_siege_days", ":no_supplies"),
##                                                                  (try_begin),
##                                                                    (lt, ":town_siege_days", 0),
##                                                                    (assign, ":town_siege_days", 0),
##                                                                  (try_end),
##                                                                  (party_set_slot, "$g_encountered_party", slot_town_siege_days, ":town_siege_days"),
##                                                                  (troop_remove_items, "trp_player", "itm_siege_supply", ":no_supplies"),
##                                                                  (call_script, "script_end_quest", "qst_deliver_supply_to_center_under_siege")]],
##
##### TODO: QUESTS COMMENT OUT END

  [anyone|plyr,"seneschal_talk", [(store_relation, ":cur_rel", "fac_player_supporters_faction", "$g_encountered_party_faction"),
                                  (ge, ":cur_rel", 0),],
   "I would like to ask you a question...", "seneschal_ask_something",[]],

  [anyone|plyr,"seneschal_talk", [(store_relation, ":cur_rel", "fac_player_supporters_faction", "$g_encountered_party_faction"),
                                  (ge, ":cur_rel", 0),],
   "I wish to know more about someone...", "seneschal_ask_about_someone",[]],

  [anyone,"seneschal_ask_about_someone", [],
   "Perhaps I may be able to help. Whom did you have in mind?", "seneschal_ask_about_someone_2",[]],

#  [anyone|plyr|repeat_for_troops,"seneschal_ask_about_someone_2", [(store_repeat_object, ":troop_no"),
#                                                                 (is_between, ":troop_no", heroes_begin, heroes_end),
#                                                                  (store_troop_faction, ":faction_no", ":troop_no"),
 #                                                                 (eq, "$g_encountered_party_faction", ":faction_no"),
 #                                                                 (str_store_troop_name, s1, ":troop_no")],
 #  "{s1}", "seneschal_ask_about_someone_3",[(store_repeat_object, "$hero_requested_to_learn_relations")]],

  [anyone|plyr,"seneschal_ask_about_someone_2", [], "Never mind.", "seneschal_pretalk",[]],

#  [anyone, "seneschal_ask_about_someone_3", [(call_script, "script_troop_write_family_relations_to_s1", "$hero_requested_to_learn_relations"),
 #                                          (call_script, "script_troop_write_owned_centers_to_s2", "$hero_requested_to_learn_relations")
#										   ],
#   "{s2}{s1}", "seneschal_ask_about_someone_4",[(add_troop_note_from_dialog, "$hero_requested_to_learn_relations", 2)]],
  
#  [anyone, "seneschal_ask_about_someone_relation", [(call_script, "script_troop_count_number_of_enemy_troops", "$hero_requested_to_learn_relations"),
#                                            (assign, ":no_enemies", reg0),
#                                            (try_begin),
#                                              (gt, ":no_enemies", 1),
#                                              (try_for_range, ":i_enemy", 1, ":no_enemies"),
#                                                (store_add, ":slot_no", slot_troop_enemies_begin, ":i_enemy"),
#                                                (troop_get_slot, ":cur_enemy", "$hero_requested_to_learn_relations", ":slot_no"),
#                                                (str_store_troop_name_link, s50, ":cur_enemy"),
#                                                (try_begin),
#                                                  (eq, ":i_enemy", 1),
#                                                  (troop_get_slot, ":cur_enemy", "$hero_requested_to_learn_relations", slot_troop_enemy_1),
#                                                  (str_store_troop_name_link, s51, ":cur_enemy"),
#                                                  (str_store_string, s51, "str_s50_and_s51"),
#                                                (else_try),
#                                                  (str_store_string, s51, "str_s50_comma_s51"),
#                                                (try_end),
#                                              (try_end),
#                                            (else_try),
#                                              (eq, ":no_enemies", 1),
#                                              (troop_get_slot, ":cur_enemy", "$hero_requested_to_learn_relations", slot_troop_enemy_1),
#                                              (str_store_troop_name_link, s51, ":cur_enemy"),
#                                            (else_try),
#                                              (str_store_string, s51, "str_noone"),
#                                            (try_end),
#                                            (troop_get_type, reg1, "$hero_requested_to_learn_relations")],
#   "{reg1?She:He} hates {s51}.", "seneschal_ask_about_someone_4",[(add_troop_note_from_dialog, "$hero_requested_to_learn_relations", 3)]],
# Ryan END

#  [anyone|plyr,"seneschal_ask_about_someone_4", [], "Where does {s1} stand with others?.", "seneschal_ask_about_someone_relation",[]],
#  [anyone|plyr,"seneschal_ask_about_someone_4", [], "My thanks, that was helpful.", "seneschal_pretalk",[]],

 
  [anyone|plyr,"seneschal_talk", [], "I must take my leave of you now. Farewell.", "close_window",[]],


  [anyone,"seneschal_ask_something", [],
   "I'll do what I can to help, of course. What did you wish to ask?", "seneschal_ask_something_2",[]],

  [anyone|plyr,"seneschal_ask_something_2", [],
   "Perhaps you know where to find someone...", "seneschal_ask_location",[]],

  [anyone,"seneschal_ask_location", [],
   "Well, a man in my position does hear a lot of things. Of whom were you thinking?", "seneschal_ask_location_2",[]],

  [anyone|plyr|repeat_for_troops,"seneschal_ask_location_2", [(store_repeat_object, ":troop_no"),
                                                              (is_between, ":troop_no", heroes_begin, heroes_end),
                                                              (store_troop_faction, ":faction_no", ":troop_no"),
                                                              (eq, "$g_encountered_party_faction", ":faction_no"),
                                                              (str_store_troop_name, s1, ":troop_no")],
   "{s1}", "seneschal_ask_location_3",[(store_repeat_object, "$hero_requested_to_learn_location")]],

  [anyone|plyr,"seneschal_ask_location_2", [], "Never mind.", "seneschal_pretalk",[]],

  [anyone,"seneschal_ask_location_3", [(call_script, "script_get_information_about_troops_position", "$hero_requested_to_learn_location", 0)],
   "{s1}", "seneschal_pretalk",[]],

#caravan merchants
  [anyone,"start",  
   [(eq, "$caravan_escort_state",1),
    (eq, "$g_encountered_party","$caravan_escort_party_id"),
    (le, "$talk_context",tc_party_encounter),
    (store_distance_to_party_from_party, reg0, "$caravan_escort_destination_town", "$caravan_escort_party_id"),
    (lt, reg0, 5),
    (str_store_party_name, s3, "$caravan_escort_destination_town"),
    (assign, reg3, "$caravan_escort_agreed_reward"),
    ],
   "There! I can see the walls of {s3} in the distance. We've made it safely.\
 Here, take this purse of {reg3} denars, as I promised. I hope we can travel together again someday.", "close_window",
   [
    (assign,"$caravan_escort_state",0),
    (call_script, "script_troop_add_gold", "trp_player", "$caravan_escort_agreed_reward"),
    (assign,reg(4), "$caravan_escort_agreed_reward"),
    (val_mul,reg(4), 1),
    (add_xp_as_reward,reg(4)),
    (assign, "$g_leave_encounter",1),
    ]],
  
  [anyone,"start",
   [(eq, "$caravan_escort_state", 1),
    (eq, "$g_encountered_party", "$caravan_escort_party_id"),
    (eq, "$talk_context", tc_party_encounter),
    ],
   "We've made it this far... Is everything clear up ahead?", "talk_caravan_escort",[]],
  [anyone|plyr,"talk_caravan_escort", [],
   "There might be bandits nearby. Stay close.", "talk_caravan_escort_2a",[]],
  [anyone,"talk_caravan_escort_2a", [],
   "Trust me, {playername}, we're already staying as close to you as we can. Lead the way.", "close_window",[(assign, "$g_leave_encounter",1)]],
  [anyone|plyr,"talk_caravan_escort", [],
   "No sign of trouble, we can breathe easy.", "talk_caravan_escort_2b",[]],
  [anyone,"talk_caravan_escort_2b", [],
   "I'll breathe easy when we reach {s1} and not a moment sooner. Let's keep moving.", "close_window",[[str_store_party_name,s1,"$caravan_escort_destination_town"],(assign, "$g_leave_encounter",1)]],

  [anyone,"start", [(eq,"$talk_context", tc_party_encounter),
                    (eq, "$g_encountered_party_type", spt_kingdom_caravan),
                    (party_slot_ge, "$g_encountered_party", slot_party_last_toll_paid_hours, "$g_current_hours"),
                    ],
   "What do you want? We paid our toll to you less than three days ago.", "merchant_talk",[]],

  [anyone,"start", [(eq,"$talk_context", tc_party_encounter),(eq, "$g_encountered_party_type", spt_kingdom_caravan),(ge,"$g_encountered_party_relation",0)],
   "Hail, friend.", "merchant_talk",[]],

  [anyone,"start", [(eq,"$talk_context", tc_party_encounter),
                    (eq, "$g_encountered_party_type", spt_kingdom_caravan),
                    (lt,"$g_encountered_party_relation",0),
                    (eq, "$g_encountered_party_faction", "fac_merchants"),
                    ],
   "What do you want? We are but simple merchants, we've no quarrel with you, so leave us alone.", "merchant_talk",[]],

  [anyone,"start", [(eq,"$talk_context", tc_party_encounter),
                    (eq, "$g_encountered_party_type", spt_kingdom_caravan),
                    (lt,"$g_encountered_party_relation",0),
                    (faction_get_slot, ":faction_leader", "$g_encountered_party_faction",slot_faction_leader),
                    (str_store_troop_name, s9, ":faction_leader"),
                    ],
   "Be warned, knave! This caravan is under the protection of {s9}.\
 Step out of our way or you will face his fury!", "merchant_talk",[]],


  [anyone,"start", [(party_slot_eq, "$g_encountered_party", slot_party_type, spt_kingdom_caravan),(this_or_next|eq,"$talk_context", tc_party_encounter),(eq,"$talk_context", 0)],
   "Yes? What do you want?", "merchant_talk",[]],
  [anyone,"merchant_pretalk", [], "Anything else?", "merchant_talk",[]],

  [anyone|plyr,"merchant_talk", [(le,"$talk_context", tc_party_encounter),
                                 (check_quest_active, "qst_cause_provocation"),
                                 (neg|check_quest_concluded, "qst_cause_provocation"),
                                 (quest_slot_eq, "qst_cause_provocation", slot_quest_target_faction, "$g_encountered_party_faction"),
                                 (quest_get_slot, ":giver_troop", "qst_cause_provocation", slot_quest_giver_troop),
								 (store_faction_of_troop, ":giver_troop_faction", ":giver_troop"),
                                 (str_store_faction_name, s17, ":giver_troop_faction"),
                                 ],
   "You are trespassing in the territory of the {s17}. I am confiscating this caravan and all its goods!", "caravan_start_war_quest_1",[]],
  [anyone,"caravan_start_war_quest_1", [(quest_get_slot, ":giver_troop", "qst_cause_provocation", slot_quest_giver_troop),
								 (store_faction_of_troop, ":giver_troop_faction", ":giver_troop"),
                                 (str_store_faction_name, s17, ":giver_troop_faction"),
  ],
   "What? What nonsense is this? We are at peace with the {s17}, and are free to cross its lands!", "caravan_start_war_quest_2",[]],
  [anyone|plyr,"caravan_start_war_quest_2", [], "We'll see about that! Defend yourselves!", "merchant_attack",[]],
  [anyone|plyr,"caravan_start_war_quest_2", [], "Hmm. Maybe this was all a misunderstanding. Farewell.", "close_window",[(assign, "$g_leave_encounter",1)]],


  [anyone|plyr,"merchant_talk", [(le,"$talk_context", tc_party_encounter),(eq, "$g_encountered_party_faction", "$players_kingdom")], "I have an offer for you.", "merchant_talk_offer",[]],
  [anyone,"merchant_talk_offer", [], "What is it?", "merchant_talk_offer_2",[]],
  
  [anyone|plyr,"merchant_talk_offer_2", [(eq,"$talk_context", tc_party_encounter),(eq, "$g_encountered_party_faction", "$players_kingdom")],
   "I can escort you to your destination for a price.", "caravan_offer_protection",[]],


   
##  [anyone|plyr,"merchant_talk_offer_2", [(troop_slot_eq, "$g_talk_troop", slot_troop_is_prisoner, 0),
##                                 (neg|faction_slot_eq, "$g_talk_troop_faction", slot_faction_leader, "$g_talk_troop"), #he is not a faction leader!
##                                 (call_script, "script_get_number_of_hero_centers", "$g_talk_troop"),
##                                 (eq, reg0, 0), #he has no castles or towns
##                                 (hero_can_join),
##                             ],
##   "I need capable men like you. Will you join me?", "knight_offer_join",[
##       ]],
  
  [anyone|plyr,"merchant_talk_offer_2", [], "Nothing. Forget it", "merchant_pretalk",[]],

  [anyone|plyr,"merchant_talk", [(check_quest_active, "qst_track_down_bandits"),
  ], "I am hunting a group of bandits with the following description... Have you seen them?", "merchant_bandit_information",[]],
  [anyone,"merchant_bandit_information", [
	(call_script, "script_get_manhunt_information_to_s15", "qst_track_down_bandits"),
  ], "{s15}", "merchant_pretalk",[]],


  [anyone|plyr,"merchant_talk", [(eq,"$talk_context", tc_party_encounter), #TODO: For the moment don't let attacking if merchant has paid toll.
                                 ], "Tell me about your journey", "merchant_trip_explanation",[]],
  
  [anyone, "merchant_trip_explanation", [
  	  (party_get_slot, ":origin", "$g_encountered_party", slot_party_last_traded_center),
  	  (party_get_slot, ":destination", "$g_encountered_party", slot_party_ai_object),
	  (str_store_party_name, s11, ":origin"),
	  (str_store_party_name, s12, ":destination"),
	  
	  (str_store_string, s14, "str___we_believe_that_there_is_money_to_be_made_selling_"),
      (store_sub, ":item_to_price_slot", slot_town_trade_good_prices_begin, trade_goods_begin),
	  (assign, ":at_least_one_item_found", 0),
	  (try_for_range, ":cur_goods", trade_goods_begin, trade_goods_end),
        (store_add, ":cur_goods_price_slot", ":cur_goods", ":item_to_price_slot"),
		(party_get_slot, ":origin_price", ":origin", ":cur_goods_price_slot"),
		(party_get_slot, ":destination_price", ":destination", ":cur_goods_price_slot"),
						
		(gt, ":destination_price", ":origin_price"),
		(store_sub, ":price_dif", ":destination_price", ":origin_price"),
			
		(gt, ":price_dif", 200),
		(str_store_item_name, s15, ":cur_goods"),
		(str_store_string, s14, "str_s14s15_"),
		
		(assign, ":at_least_one_item_found", 1),
	  (try_end),

	  (try_begin),
		(eq, ":at_least_one_item_found", 0),
	    (str_store_string, s14, "str__we_carry_a_selection_of_goods_although_the_difference_in_prices_for_each_is_not_so_great_we_hope_to_make_a_profit_off_of_the_whole"),
	  (else_try),
		(str_store_string, s14, "str_s14and_other_goods"),
	  
	  (try_end),
	  
  ], "We are coming from {s11} and heading to {s12}.{s14}", "merchant_pretalk", []],
  
  
  
  [anyone|plyr,"merchant_talk", [(eq,"$talk_context", tc_party_encounter), #TODO: For the moment don't let attacking if merchant has paid toll.
                                 (neg|party_slot_ge, "$g_encountered_party", slot_party_last_toll_paid_hours, "$g_current_hours"),
                                 ], "I demand something from you!", "merchant_demand",[]],
  [anyone,"merchant_demand", [(eq,"$talk_context", tc_party_encounter)], "What do you want?", "merchant_demand_2",[]],

  [anyone|plyr,"merchant_demand_2", [(neq,"$g_encountered_party_faction","$players_kingdom")], "There is a toll for free passage here!", "merchant_demand_toll",[]],
  
  [anyone,"merchant_demand_toll", [(gt, "$g_strength_ratio", 70),
                                        (store_div, reg6, "$g_ally_strength", 2),
                                        (val_add, reg6, 40),
                                        (assign, "$temp", reg6),
                                        ], "Please, I don't want any trouble. I can give you {reg6} denars, just let us go.", "merchant_demand_toll_2",[]],
  [anyone,"merchant_demand_toll", [(store_div, reg6, "$g_ally_strength", 4),
                                        (val_add, reg6, 10),
                                        (assign, "$temp", reg6),
                                        ], "I don't want any trouble. I can give you {reg6} denars if you'll let us go.", "merchant_demand_toll_2",[]],
  
  [anyone|plyr,"merchant_demand_toll_2", [], "Agreed, hand it over and you may go in peace.", "merchant_demand_toll_accept",[]],
  [anyone,"merchant_demand_toll_accept", [(assign, reg6, "$temp")], "Very well then. Here's {reg6} denars. ", "close_window",
   [(assign, "$g_leave_encounter",1),
    (call_script, "script_troop_add_gold", "trp_player", "$temp"),
    (store_add, ":toll_finish_time", "$g_current_hours", merchant_toll_duration),
    (party_set_slot, "$g_encountered_party", slot_party_last_toll_paid_hours, ":toll_finish_time"),
    (try_begin),
      (ge, "$g_encountered_party_relation", -5),
      (store_relation,":rel", "$g_encountered_party_faction","fac_player_supporters_faction"),
      (try_begin),
        (gt, ":rel", 0),
        (val_sub, ":rel", 1),
      (try_end),
      (val_sub, ":rel", 1),
      (call_script, "script_set_player_relation_with_faction", "$g_encountered_party_faction", ":rel"),
    (try_end),
### Troop commentaries changes begin
    (call_script, "script_add_log_entry", logent_caravan_accosted, "trp_player",  -1, -1, "$g_encountered_party_faction"),
### Troop commentaries changes end
    (assign, reg6, "$temp"),
    ]],
  
  [anyone|plyr,"merchant_demand_toll_2", [], "I changed my mind, I can't take your money.", "merchant_pretalk",[]],
  
  [anyone|plyr,"merchant_demand_toll_2", [], "No, I want everything you have! [Attack]", "merchant_attack",[]],
  
  [anyone|plyr,"merchant_demand_2", [(neq,"$g_encountered_party_faction","$players_kingdom")], "Hand over your gold and valuables now!", "merchant_attack_begin",[]],
  [anyone|plyr,"merchant_demand_2", [], "Nothing. Forget it.", "merchant_pretalk",[]],
  
  
  [anyone,"merchant_attack_begin", [], "Are you robbing us?{s11}", "merchant_attack_verify",[
  (str_clear, s11),
  (try_begin),
	(faction_slot_ge, "$g_encountered_party_faction", slot_faction_truce_days_with_factions_begin, 1),
	(str_store_string, s11, "str__have_you_not_signed_a_truce_with_our_lord"),
  (try_end),
  ]],
  [anyone|plyr,"merchant_attack_verify", [], "Robbing you? No, no! It was a joke.", "merchant_attack_verify_norob",[]],
  [anyone,"merchant_attack_verify_norob", [], "God, don't joke about that, {lad/lass}. For a moment I thought we were in real trouble.", "close_window",[(assign, "$g_leave_encounter",1)]],
  [anyone|plyr,"merchant_attack_verify", [], "Of course I'm robbing you. Now hand over your goods.", "merchant_attack",[
	(call_script, "script_diplomacy_party_attacks_neutral", "p_main_party", "$g_encountered_party"), 
  ]],
  
  [anyone,"merchant_attack", [], "Damn you, you won't get anything from us without a fight!", "close_window",
   [(store_relation,":rel", "$g_encountered_party_faction","fac_player_supporters_faction"),
    (try_begin),
      (gt, ":rel", 0),
      (val_sub, ":rel", 10),
    (try_end),
    (val_sub, ":rel", 5),
    (call_script, "script_set_player_relation_with_faction", "$g_encountered_party_faction", ":rel"),
### Troop commentaries changes begin
	(call_script, "script_diplomacy_party_attacks_neutral", "p_main_party", "$g_encountered_party"),
### Troop commentaries changes end
    ]],

  [anyone,"caravan_offer_protection", [],
   "These roads are dangerous indeed. One can never have enough protection.", "caravan_offer_protection_2",
   [(get_party_ai_object,":caravan_destination","$g_encountered_party"),
    (store_distance_to_party_from_party, "$caravan_distance_to_target",":caravan_destination","$g_encountered_party"),
    (assign,"$caravan_escort_offer","$caravan_distance_to_target"),
    (val_sub, "$caravan_escort_offer", 10),
    (call_script, "script_party_calculate_strength", "p_main_party",0),
    (assign, ":player_strength", reg0),
    (val_min, ":player_strength", 200),
    (val_add, ":player_strength", 20),
    (val_mul,"$caravan_escort_offer",":player_strength"),
    (val_div,"$caravan_escort_offer",50),
    (val_max, "$caravan_escort_offer", 5),
    ]],
  [anyone,"caravan_offer_protection_2", [[lt,"$caravan_distance_to_target",10]],
   "An escort? We're almost there already! Thank you for the offer, though.", "close_window",[(assign, "$g_leave_encounter",1)]],
  [anyone,"caravan_offer_protection_2", [(get_party_ai_object,":caravan_destination","$g_encountered_party"),
    (str_store_party_name,1,":caravan_destination"),
    (assign,reg(2),"$caravan_escort_offer")],
   "We are heading to {s1}. I will pay you {reg2} denars if you escort us there.", "caravan_offer_protection_3",
   []],
  [anyone|plyr,"caravan_offer_protection_3", [],
   "Agreed.", "caravan_offer_protection_4",[]],
  [anyone,"caravan_offer_protection_4", [],
   "I want you to stay close to us along the way.\
 We'll need your help if we get ambushed by bandits.", "caravan_offer_protection_5",[]],
  [anyone|plyr,"caravan_offer_protection_5", [],
   "Don't worry, you can trust me.", "caravan_offer_protection_6",[]],
  [anyone,"caravan_offer_protection_6", [(get_party_ai_object,":caravan_destination","$g_encountered_party"),
    (str_store_party_name,1,":caravan_destination")],
   "Good. Come and collect your money when we're within sight of {s1}. For now, let's just get underway.", "close_window",
   [(get_party_ai_object,":caravan_destination","$g_encountered_party"),
    (assign, "$caravan_escort_destination_town", ":caravan_destination"),
    (assign, "$caravan_escort_party_id", "$g_encountered_party"),
    (assign, "$caravan_escort_agreed_reward", "$caravan_escort_offer"),
    (assign, "$caravan_escort_state", 1),
    (assign, "$g_leave_encounter",1)
   ]],
  [anyone|plyr,"caravan_offer_protection_3", [],
   "Forget it.", "caravan_offer_protection_4b",[]],
  [anyone,"caravan_offer_protection_4b", [],
   "Perhaps another time, then.", "close_window",[(assign, "$g_leave_encounter",1)]],

  [anyone|plyr,"merchant_talk", [(eq,"$talk_context", tc_party_encounter),(lt, "$g_talk_troop_faction_relation", 0)],
   "Not so fast. First, hand over all your goods and money.", "talk_caravan_enemy_2",[]],

  [anyone,"talk_caravan_enemy_2", [],
   "Never. It is our duty to protect these goods. You shall have to fight us, brigand!", "close_window",
   [
    (store_relation,":rel","$g_encountered_party_faction","fac_player_supporters_faction"),
    (val_min,":rel",0),
    (val_sub,":rel",4),
    (call_script, "script_set_player_relation_with_faction", "$g_encountered_party_faction", ":rel"),
	(call_script, "script_diplomacy_party_attacks_neutral", "p_main_party", "$g_encountered_party"), 
    ]],

  [anyone|plyr,"merchant_talk", [], "[Leave]", "close_window",[(assign, "$g_leave_encounter",1)]],




# Prison Guards
  [anyone,"start", [(eq, "$talk_context", 0),(faction_slot_eq, "$g_encountered_party_faction", slot_faction_prison_guard_troop, "$g_talk_troop"),
                    (this_or_next|eq, "$g_encountered_party_faction", "fac_player_supporters_faction"),
                    (             party_slot_eq, "$g_encountered_party", slot_town_lord, "trp_player")
                    ],
   "Good day, my {lord/lady}. Will you be visiting the prison?", "prison_guard_players",[]],
  [anyone|plyr,"prison_guard_players", [],
   "Yes. Unlock the door.", "close_window",[(call_script, "script_enter_dungeon", "$current_town", "mt_visit_town_castle")]],
  [anyone|plyr,"prison_guard_players", [],
   "No, not now.", "close_window",[]],

  [anyone,"start", [(eq, "$talk_context", 0),(faction_slot_eq, "$g_encountered_party_faction", slot_faction_prison_guard_troop, "$g_talk_troop")],
   "Yes? What do you want?", "prison_guard_talk",[]],

  [anyone|plyr,"prison_guard_talk", [],
   "Who is imprisoned here?", "prison_guard_ask_prisoners",[]],
  [anyone|plyr,"prison_guard_talk", [],
   "I want to speak with a prisoner.", "prison_guard_visit_prison",[]],

  [anyone,"prison_guard_ask_prisoners", [],
   "Currently, {s50} {reg1?are:is} imprisoned here.{s49}","prison_guard_talk",[
    (party_clear, "p_temp_party"),
	(party_clear, "p_temp_party_2"),
    (assign, ":num_heroes_in_dungeon", 0),
    (assign, ":num_heroes_given_parole", 0),
	
    (party_get_num_prisoner_stacks, ":num_stacks","$g_encountered_party"),
    (try_for_range, ":i_stack", 0, ":num_stacks"),
        (party_prisoner_stack_get_troop_id, ":stack_troop","$g_encountered_party",":i_stack"),
        (troop_is_hero, ":stack_troop"),
		(try_begin),
			(call_script, "script_cf_prisoner_offered_parole", ":stack_troop"),
			(party_add_members, "p_temp_party_2", ":stack_troop", 1),
			(val_add, ":num_heroes_given_parole", 1),
		(else_try),
			(party_add_members, "p_temp_party", ":stack_troop", 1),
			(val_add, ":num_heroes_in_dungeon", 1),
		(try_end),
    (try_end),
    (call_script, "script_print_party_members", "p_temp_party"),
	(str_store_string, s50, "str_s51"),
    (try_begin),
        (gt, ":num_heroes_in_dungeon", 1),
        (assign, reg1, 1),
    (else_try),
        (assign, reg1, 0),
    (try_end),

	(str_clear, s49),
    (try_begin),
        (ge, ":num_heroes_given_parole", 1),
		(call_script, "script_print_party_members", "p_temp_party_2"),
		(try_begin),
			(ge, ":num_heroes_given_parole", 2),
			(assign, reg2, 1),
		(else_try),
			(assign, reg2, 0),
		(try_end),
		(str_store_string, s49, "str__meanwhile_s51_reg2areis_being_held_in_the_castle_but_reg2havehas_made_pledges_not_to_escape_and_reg2areis_being_held_in_more_comfortable_quarters" ), #somewhat awkward wording prevents both gender and singular/plural pronoun issues
    (try_end)
	
	
	]],
  
  [anyone,"prison_guard_visit_prison", 
  [
    (this_or_next|faction_slot_eq, "$g_encountered_party_faction", slot_faction_marshall, "trp_player"),
    (this_or_next|party_slot_eq, "$g_encountered_party", slot_town_lord, "trp_player"),
    (eq, "$g_encountered_party_faction", "$players_kingdom"),
  ],
   "Of course, {sir/madam}. Go in.", "close_window",
   [
     (call_script, "script_enter_dungeon", "$current_town", "mt_visit_town_castle")
   ]],

  [anyone, "prison_guard_visit_prison", 
  [
    #below condition is added by ozan, please lets discuss if it is needed or not. But I think this condition is needed because if there is nobody in prison
    #prison guard should not say you need to get permission, or take me money ext to let player go inside.   
    (assign, ":num_heroes_in_dungeon", 0),	
    (party_get_num_prisoner_stacks, ":num_stacks", "$g_encountered_party"),
    (assign, ":end_condition", ":num_stacks"),
    (try_for_range, ":i_stack", 0, ":end_condition"),
      (party_prisoner_stack_get_troop_id, ":stack_troop","$g_encountered_party",":i_stack"),
      (troop_is_hero, ":stack_troop"),
      (try_begin),
        (call_script, "script_cf_prisoner_offered_parole", ":stack_troop"),
      (else_try),
        (val_add, ":num_heroes_in_dungeon", 1),
        (assign, ":end_condition", 0),
      (try_end),
    (try_end),

    (ge, ":num_heroes_in_dungeon", 1),   
   ],
   "You need to get permission from the lord to talk to prisoners.", "prison_guard_visit_prison_2",[]],

  [anyone, "prison_guard_visit_prison", [], "There is nobody inside, therefore you can freely go inside and look around.", "prison_guard_visit_prison_nobody", []],   
  
  [anyone|plyr,"prison_guard_visit_prison_nobody", [], "All right then. I'll take a look at the prison.", "close_window",
  [
    (call_script, "script_enter_dungeon", "$current_town", "mt_visit_town_castle"),
  ]],
  
  [anyone|plyr,"prison_guard_visit_prison_nobody", [], "I have more important business to do.", "close_window",[]],

  [anyone|plyr,"prison_guard_visit_prison_2", [], "All right then. I'll try that.", "close_window",[]],
  [anyone|plyr,"prison_guard_visit_prison_2", [], "Come on now. I thought you were the boss here.", "prison_guard_visit_prison_3",[]],
  [anyone,"prison_guard_visit_prison_3", [], "He-heh. You got that right. Still, I can't let you into the prison.", "prison_guard_visit_prison_4",[]],
  
  [anyone|plyr,"prison_guard_visit_prison_4", [], "All right then. I'll leave now.", "close_window",[]],
  [anyone|plyr,"prison_guard_visit_prison_4", [(store_troop_gold,":gold","trp_player"),(ge,":gold",100)],
   "I found a purse with 100 denars a few paces away. I reckon it belongs to you.", "prison_guard_visit_prison_5",[]],

  [anyone,"prison_guard_visit_prison_5", [], "Ah! I was looking for this all day. How good of you to bring it back {sir/madam}.\
 Well, now that I know what an honest {man/lady} you are, there can be no harm in letting you inside for a look. Go in.... Just so you know, though -- I'll be hanging onto the keys, in case you were thinking about undoing anyone's chains.", "close_window",
 [(troop_remove_gold, "trp_player",100),(call_script, "script_enter_dungeon", "$current_town", "mt_visit_town_castle")]],

  [anyone|plyr,"prison_guard_visit_prison_4", [],
   "Give me the keys to the cells -- now!", "prison_guard_visit_break",[
   ]],
 
  [anyone,"prison_guard_visit_break", [], "Help! Help! Prison break!", "close_window",[
  (call_script, "script_activate_town_guard"),
  (assign, "$g_main_attacker_agent", "$g_talk_agent"),
  (assign, "$talk_context", tc_prison_break),
#  (try_begin),
#		(store_relation, ":relation", "fac_player_faction", "$g_encountered_party_faction"),
#	Reduce relation with town
# (try_end),

	 (assign, ":end_cond", kingdom_ladies_end),
     (try_for_range, ":prisoner", active_npcs_begin, ":end_cond"),
	   (troop_set_slot, ":prisoner", slot_troop_mission_participation, 0), #new	  
	 (try_end),  
  ]],
 
 
  [anyone|plyr,"prison_guard_talk", [],
   "Never mind.", "close_window",[]],




# Castle Guards
  [anyone,"start", [(eq, "$talk_context", 0),(faction_slot_eq, "$g_encountered_party_faction", slot_faction_castle_guard_troop, "$g_talk_troop"),
                    (this_or_next|eq, "$g_encountered_party_faction", "fac_player_supporters_faction"),
                    (             party_slot_eq, "$g_encountered_party", slot_town_lord, "trp_player")
                    ],
   "Your orders, {Lord/Lady}?", "castle_guard_players",[]],
  [anyone|plyr,"castle_guard_players", [],
   "Open the door. I'll go in.", "close_window",[(call_script, "script_enter_court", "$current_town")]],
  [anyone|plyr,"castle_guard_players", [],
   "Never mind.", "close_window",[]],


  [anyone,"start", [(eq, "$talk_context", 0),(faction_slot_eq, "$g_encountered_party_faction", slot_faction_castle_guard_troop, "$g_talk_troop"),(eq, "$sneaked_into_town",1),
                    (gt,"$g_time_since_last_talk",0)],
   "Get out of my sight, beggar! You stink!", "castle_guard_sneaked_intro_1",[]],
  [anyone,"start", [(eq, "$talk_context", 0),(faction_slot_eq, "$g_encountered_party_faction", slot_faction_castle_guard_troop, "$g_talk_troop"),(eq, "$sneaked_into_town",1)],
   "Get lost before I lose my temper you vile beggar!", "close_window",[]],
  [anyone|plyr,"castle_guard_sneaked_intro_1", [], "I want to enter the hall and speak to the lord.", "castle_guard_sneaked_intro_2",[]],
  [anyone|plyr,"castle_guard_sneaked_intro_1", [], "[Leave]", "close_window",[]],
  [anyone,"castle_guard_sneaked_intro_2", [], "Are you out of your mind, {man/woman}?\
 Beggars are not allowed into the hall. Now get lost or I'll beat you bloody.", "close_window",[]],
  
  
  [anyone,"start", [(eq, "$talk_context", 0),(faction_slot_eq, "$g_encountered_party_faction", slot_faction_castle_guard_troop, "$g_talk_troop")],
   "What do you want?", "castle_guard_intro_1",[]],
  [anyone|plyr,"castle_guard_intro_1", [],
   "I want to enter the hall and speak to the lord.", "castle_guard_intro_2",[]],
  [anyone|plyr,"castle_guard_intro_1", [],
   "Never mind.", "close_window",[]],

   [anyone,"castle_guard_intro_2", [
	(faction_slot_eq, "$g_encountered_party_faction", slot_faction_ai_state, sfai_feast),
	(faction_slot_eq, "$g_encountered_party_faction", slot_faction_ai_object, "$current_town"),
	
	(this_or_next|neq, "$players_kingdom", "$g_encountered_party_faction"),
		(neg|troop_slot_ge, "trp_player", slot_troop_renown, 50),
		
	(neg|troop_slot_ge, "trp_player", slot_troop_renown, 125),
	(neq, "$g_player_eligible_feast_center_no", "$current_town"),

	(neg|check_quest_active, "qst_wed_betrothed"),
	(neg|check_quest_active, "qst_wed_betrothed_female"),
			 
	(neg|troop_slot_ge, "trp_player", slot_troop_spouse, 1), #Married players always make the cut
	
   ], "I'm afraid there is a feast in progress, and you are not invited.", "close_window",
   []],


   [anyone,"castle_guard_intro_2", [], "You can go in after leaving your weapons with me. No one is allowed to carry arms into the lord's hall.", "castle_guard_intro_3",
   []],
   
  [anyone|plyr,"castle_guard_intro_3", [], "Here, take my arms. I'll go in.", "close_window", [(call_script, "script_enter_court", "$current_town")]],
  
  [anyone|plyr,"castle_guard_intro_3", [], "No, I give my arms to no one.", "castle_guard_intro_2b", []],
  [anyone,"castle_guard_intro_2b", [], "Then you can't go in.", "close_window", []],
  
##  [anyone|plyr,"castle_guard_intro_1", [],
##   "Never mind.", "close_window",[]],
##  [anyone,"castle_guard_intro_2", [],
##   "Does the lord expect you?", "castle_guard_intro_3",[]],
##  [anyone|plyr,"castle_guard_intro_3", [], "Yes.", "castle_guard_intro_check",[]],
##  [anyone|plyr,"castle_guard_intro_3", [], "No.", "castle_guard_intro_no",[]],
##  [anyone,"castle_guard_intro_check", [], "Hmm. All right {sir/madam}.\
## You can go in. But you must leave your weapons with me. Noone's allowed into the court with weapons.", "close_window",[]],
##  [anyone,"castle_guard_intro_check", [], "You liar!\
## Our lord would have no business with a filthy vagabond like you. Get lost now before I kick your butt.", "close_window",[]],
##  [anyone,"castle_guard_intro_no", [], "Well... What business do you have here then?", "castle_guard_intro_4",[]],
##  [anyone|plyr,"castle_guard_intro_4", [], "I wish to present the lord some gifts.", "castle_guard_intro_gifts",[]],
##  [anyone|plyr,"castle_guard_intro_4", [], "I have an important matter to discuss with the lord. Make way now.", "castle_guard_intro_check",[]],
##  [anyone,"castle_guard_intro_gifts", [], "Really? What gifts?", "castle_guard_intro_5",[]],
##  [anyone|plyr,"castle_guard_intro_4", [], "Many gifts. For example, I have a gift of 20 denars here for his loyal servants.", "castle_guard_intro_gifts",[]],
##  [anyone|plyr,"castle_guard_intro_4", [], "My gifts are of no concern to you. They are for your lords and ladies..", "castle_guard_intro_check",[]],
##  [anyone,"castle_guard_intro_gifts", [], "Oh! you can give those 20 denars to me. I can distribute them for you.\
## You can enter the court and present your gifts to the lord. I'm sure he'll be pleased.\
## But you must leave your weapons with me. Noone's allowed into the court with weapons.", "close_window",[]],

#Kingdom Parties
#  [anyone,"start", [(this_or_next|eq,"$g_encountered_party_template","pt_swadian_foragers"),
#                    (eq,"$g_encountered_party_template","pt_vaegir_foragers"),
##  [anyone,"start", [(this_or_next|party_slot_eq,"$g_encountered_party",slot_party_type, spt_forager),
##                    (this_or_next|party_slot_eq,"$g_encountered_party",slot_party_type, spt_scout),
##                    (party_slot_eq,"$g_encountered_party",slot_party_type, spt_patrol),
##                    (str_store_faction_name,5,"$g_encountered_party_faction")],
##   "In the name of the {s5}.", "kingdom_party_encounter",[]],
##  
##  [anyone,"kingdom_party_encounter", [(le,"$g_encountered_party_relation",-10)],
##   "Surrender now, and save yourself the indignity of defeat!", "kingdom_party_encounter_war",[]],
##  [anyone|plyr,"kingdom_party_encounter_war", [],  "[Go to Battle]", "close_window",[(encounter_attack)]],
##
##  [anyone,"kingdom_party_encounter", [(ge,"$g_encountered_party_relation",10)],
##   "Greetings, fellow warrior.", "close_window",[(eq,"$talk_context",tc_party_encounter),(assign, "$g_leave_encounter", 1)]],
##
##  [anyone,"kingdom_party_encounter", [],
##   "You can go.", "close_window",[]],








#Player Parties
##  [party_tpl|pt_old_garrison,"start", [],
##   "They told us to leave the castle to the new garrison {sir/madam}. So we left and came to rejoin you.", "player_old_garrison_encounter",[]],
##  
##  [anyone|plyr,"player_old_garrison_encounter", [(party_can_join)],
##   "You have done well. You'll join my command now.", "close_window",[(assign, "$g_move_heroes", 1),
##                                        (call_script, "script_party_add_party", "p_main_party", "$g_encountered_party"),
##                                        (remove_party, "$g_encountered_party"),
##                                        (assign, "$g_leave_encounter", 1)]],
##  [anyone|plyr,"player_old_garrison_encounter", [(assign, reg1, 0),
##                                                 (try_begin),
##                                                   (neg|party_can_join),
##                                                   (assign, reg1, 1),
##                                                 (try_end)],
##   "You can't join us now{reg1?, I can't command all the lot of you:}. Follow our lead.", "close_window",[(party_set_ai_behavior, "$g_encountered_party", ai_bhvr_attack_party),
##                                                                         (party_set_ai_object, "$g_encountered_party", "p_main_party"),
##                                                                         (party_set_flags, "$g_encountered_party", pf_default_behavior, 0),
##                                                                         (assign, "$g_leave_encounter", 1)]],
##
##  [anyone|plyr,"player_old_garrison_encounter", [(assign, reg1, 0),
##                                                 (try_begin),
##                                                   (neg|party_can_join),
##                                                   (assign, reg1, 1),
##                                                 (try_end)],
##   "You can't join us now{reg1?, I can't command all the lot of you:}. Stay here and wait for me.", "close_window",[
##       (party_set_ai_behavior, "$g_encountered_party", ai_bhvr_travel_to_point),
##       (party_get_position, pos1, "$g_encountered_party"),
##       (party_set_ai_target_position, "$g_encountered_party", pos1),
##       (party_set_flags, "$g_encountered_party", pf_default_behavior, 0),
##       (assign, "$g_leave_encounter", 1)]],
##






  [anyone,"start", [(eq, "$talk_context", tc_castle_gate)],
   "What do you want?", "castle_gate_guard_talk",[]],

  [anyone,"castle_gate_guard_pretalk", [],
   "Yes?", "castle_gate_guard_talk",[]],

  [anyone|plyr,"castle_gate_guard_talk", [(ge, "$g_encountered_party_relation", 0)], 
  "We need shelter for the night. Will you let us in?", "castle_gate_open",[]],
  [anyone|plyr,"castle_gate_guard_talk", [(party_slot_ge, "$g_encountered_party", slot_town_lord, 1)], "I want to speak with the lord of the castle.", "request_meeting_castle_lord",[]],
  [anyone|plyr,"castle_gate_guard_talk", [], "I want to speak with someone in the castle.", "request_meeting_other",[]],

  [anyone|plyr,"castle_gate_guard_talk", [], "[Leave]", "close_window",[]],

  [anyone,"request_meeting_castle_lord", [(party_get_slot, ":castle_lord", "$g_encountered_party", slot_town_lord),
                                         (call_script, "script_get_troop_attached_party", ":castle_lord"),
                                         (eq, "$g_encountered_party", reg0),
                                         (str_store_troop_name, s2, ":castle_lord"),
                                         (assign, "$lord_requested_to_talk_to", ":castle_lord"),
                                          ],  "Wait here. {s2} will see you.", "close_window",[]],
  
  [anyone,"request_meeting_castle_lord", [],  "My lord is not here now.", "castle_gate_guard_pretalk",[]],

  [anyone,"request_meeting_other", [],  "Who is that?", "request_meeting_3",[]],

  [anyone|plyr|repeat_for_troops,"request_meeting_3", [(store_repeat_object, ":troop_no"),
                                                       (troop_is_hero, ":troop_no"),
                                                       (troop_slot_eq, ":troop_no", slot_troop_occupation, slto_kingdom_hero),
                                                       (call_script, "script_get_troop_attached_party", ":troop_no"),
                                                       (eq, "$g_encountered_party", reg0),
                                                       (str_store_troop_name, s3, ":troop_no"),
                                                       ],
   "{s3}", "request_meeting_4",[(store_repeat_object, "$lord_requested_to_talk_to")]],

  [anyone|plyr,"request_meeting_3", [], "Never mind.", "close_window",[(assign, "$lord_requested_to_talk_to", 0)]],

  [anyone,"request_meeting_4", [], "Wait there. I'll send him your request.", "request_meeting_5",[]],

  [anyone|plyr,"request_meeting_5", [], "I'm waiting...", "request_meeting_6",[]],

  [anyone,"request_meeting_6",
   [
     (call_script, "script_troop_get_player_relation", "$lord_requested_to_talk_to"),
     (assign, ":lord_relation", reg0),
     (gt, ":lord_relation", -20),
    ], "All right. {s2} will talk to you now.", "close_window",[(str_store_troop_name, s2, "$lord_requested_to_talk_to")]],

  [anyone,"request_meeting_6", [(str_store_troop_name, s2, "$lord_requested_to_talk_to")], "{s2} says he will not see you. Begone now.", "close_window",[]],

  [anyone,"castle_gate_open", [(party_get_slot, ":castle_lord", "$g_encountered_party", slot_town_lord),
                                         (call_script, "script_get_troop_attached_party", ":castle_lord"),
                                         (eq, "$g_encountered_party", reg0),
                                         (ge, "$g_encountered_party_relation", 0),
                                         (call_script, "script_troop_get_player_relation", ":castle_lord"),
                                         (assign, ":castle_lord_relation", reg0),
                                         #(troop_get_slot, ":castle_lord_relation", ":castle_lord", slot_troop_player_relation),
                                         (ge, ":castle_lord_relation", 5),
                                         (str_store_troop_name, s2, ":castle_lord")
                                         ],  "My lord {s2} will be happy to see you {sir/madam}.\
 Come on in. I am opening the gates for you.", "close_window",[(assign,"$g_permitted_to_center",1)]],


  [anyone,"castle_gate_open", [(party_get_slot, ":castle_lord", "$g_encountered_party", slot_town_lord),
                                         (call_script, "script_get_troop_attached_party", ":castle_lord"),
                                         (neq, "$g_encountered_party", reg0),
                                         (ge, "$g_encountered_party_relation", 0),
                                         (call_script, "script_troop_get_player_relation", ":castle_lord"),
                                         (assign, ":castle_lord_relation", reg0),
                                         #(troop_get_slot, ":castle_lord_relation", ":castle_lord", slot_troop_player_relation),
                                         (ge, ":castle_lord_relation", 5),
                                         (str_store_troop_name, s2, ":castle_lord")
                                         ],  "My lord {s2} is not in the castle now.\
 But I think he would approve of you taking shelter here.\
 Come on in. I am opening the gates for you.", "close_window",[(assign,"$g_permitted_to_center",1)]],
 
  [anyone,"castle_gate_open", [(party_get_slot, ":castle_lord", "$g_encountered_party", slot_town_lord),
                               (call_script, "script_troop_get_player_relation", ":castle_lord"),
                               (assign, ":castle_lord_relation", reg0),
                               #(troop_get_slot, ":castle_lord_relation", ":castle_lord", slot_troop_player_relation),
                               (ge, ":castle_lord_relation", -2),
                                         ],  "Come on in. I am opening the gates for you.", "close_window",[(assign,"$g_permitted_to_center",1)]],
                                         
  [anyone,"castle_gate_open", [(party_get_slot, ":castle_lord", "$g_encountered_party", slot_town_lord),
                               (call_script, "script_troop_get_player_relation", ":castle_lord"),
                               (assign, ":castle_lord_relation", reg0),
                               #(troop_get_slot, ":castle_lord_relation", ":castle_lord", slot_troop_player_relation),
                               (ge, ":castle_lord_relation", -19),
                               (str_store_troop_name, s2, ":castle_lord")
                                         ],  "Come on in. But make sure your men behave sensibly within the walls.\
 My lord {s2} does not want trouble here.", "close_window",[(assign,"$g_permitted_to_center",1)]],
 
  [anyone,"castle_gate_open", [(party_get_slot, ":castle_lord", "$g_encountered_party", slot_town_lord),
                               (str_store_troop_name, s2, ":castle_lord"),
  ],  "My lord {s2} does not want you here. Begone now.", "close_window",[]],


#Enemy Kingdom Meetings


#  [anyone,"start", [(eq, "$talk_context", tc_lord_talk_in_center)],
#   "Greetings {playername}.", "request_meeting_1",[]],

#  [anyone,"request_meeting_pretalk", [(eq, "$talk_context", tc_lord_talk_in_center)],
#   "Yes?", "request_meeting_1",[]],
  
#  [anyone|plyr,"request_meeting_1", [(ge, "$g_encountered_party_faction", 0)], "Open the gates and let me in!", "request_meeting_open_gates",[]],
  
#  [anyone|plyr,"request_meeting_1", [(party_slot_ge, "$g_encountered_party", slot_town_lord, 1)], "I want to speak with the lord of the castle.", "request_meeting_castle_lord",[]],
#  [anyone|plyr,"request_meeting_1", [], "I want to speak with someone in the castle.", "request_meeting_other",[]],

##### TODO: QUESTS COMMENT OUT BEGIN
##  [anyone|plyr,"request_meeting_1",[(check_quest_active,"qst_bring_prisoners_to_enemy"),
##                                    (neg|check_quest_succeeded, "qst_bring_prisoners_to_enemy"),
##                                    (quest_get_slot, ":quest_giver_troop", "qst_bring_prisoners_to_enemy", slot_quest_giver_troop),
##                                    (quest_get_slot, ":quest_target_amount", "qst_bring_prisoners_to_enemy", slot_quest_target_amount),
##                                    (quest_get_slot, ":quest_object_troop", "qst_bring_prisoners_to_enemy", slot_quest_object_troop),
##                                    (quest_slot_eq, "qst_bring_prisoners_to_enemy", slot_quest_target_center, "$g_encountered_party"),
##                                    (party_count_prisoners_of_type, ":num_prisoners", "p_main_party", ":quest_object_troop"),
##                                    (ge, ":num_prisoners", ":quest_target_amount"),
##                                    (str_store_troop_name,1,":quest_giver_troop"),
##                                    (assign, reg1, ":quest_target_amount"),
##                                    (str_store_troop_name_plural,2,":quest_object_troop")],
##   "TODO: Sir, lord {s1} ordered me to bring {reg1} {s2} for ransom.", "guard_prisoners_brought",
##   [(quest_get_slot, ":quest_target_amount", "qst_bring_prisoners_to_enemy", slot_quest_target_amount),
##    (quest_get_slot, ":quest_target_center", "qst_bring_prisoners_to_enemy", slot_quest_target_center),
##    (quest_get_slot, ":quest_object_troop", "qst_bring_prisoners_to_enemy", slot_quest_object_troop),
##    (party_remove_prisoners, "p_main_party", ":quest_object_troop", ":quest_target_amount"),
##    (party_add_members, ":quest_target_center", ":quest_object_troop", ":quest_target_amount"),
##    (call_script, "script_game_get_join_cost", ":quest_object_troop"),
##    (assign, ":reward", reg0),
##    (val_mul, ":reward", ":quest_target_amount"),
##    (val_div, ":reward", 2),
##    (call_script, "script_troop_add_gold", "trp_player", ":reward"),
##    (party_get_slot, ":cur_lord", "$g_encountered_party", slot_town_lord),#Removing gold from the town owner's wealth
##    (troop_get_slot, ":cur_wealth", ":cur_lord", slot_troop_wealth),
##    (val_sub, ":cur_wealth", ":reward"),
##    (troop_set_slot, ":cur_lord", slot_troop_wealth, ":cur_wealth"),
##    (quest_set_slot, "qst_bring_prisoners_to_enemy", slot_quest_target_amount, ":reward"),
##    (succeed_quest, "qst_bring_prisoners_to_enemy"),
##    ]],
##
##  [anyone|plyr,"request_meeting_1",[(check_quest_active,"qst_bring_prisoners_to_enemy"),
##                                    (neg|check_quest_succeeded, "qst_bring_prisoners_to_enemy"),
##                                    (quest_get_slot, ":quest_giver_troop", "qst_bring_prisoners_to_enemy", slot_quest_giver_troop),
##                                    (quest_get_slot, ":quest_target_amount", "qst_bring_prisoners_to_enemy", slot_quest_target_amount),
##                                    (quest_get_slot, ":quest_object_troop", "qst_bring_prisoners_to_enemy", slot_quest_object_troop),
##                                    (quest_slot_eq, "qst_bring_prisoners_to_enemy", slot_quest_target_center, "$g_encountered_party"),
##                                    (party_count_prisoners_of_type, ":num_prisoners", "p_main_party", ":quest_object_troop"),
##                                    (lt, ":num_prisoners", ":quest_target_amount"),
##                                    (gt, ":num_prisoners", 0),
##                                    (str_store_troop_name,1,":quest_giver_troop"),
##                                    (assign, reg1, ":quest_target_amount"),
##                                    (str_store_troop_name_plural,2,":quest_object_troop")],
##   "TODO: Sir, lord {s1} ordered me to bring {reg1} {s2} for ransom, but some of them died during my expedition.", "guard_prisoners_brought_some",
##   [(quest_get_slot, ":quest_target_amount", "qst_bring_prisoners_to_enemy", slot_quest_target_amount),
##    (quest_get_slot, ":quest_target_center", "qst_bring_prisoners_to_enemy", slot_quest_target_center),
##    (quest_get_slot, ":quest_object_troop", "qst_bring_prisoners_to_enemy", slot_quest_object_troop),
##    (party_count_prisoners_of_type, ":num_prisoners", "p_main_party", ":quest_object_troop"),
##    (party_remove_prisoners, "p_main_party", ":quest_object_troop", ":num_prisoners"),
##    (party_add_members, ":quest_target_center", ":quest_object_troop", ":num_prisoners"),
##    (call_script, "script_game_get_join_cost", ":quest_object_troop"),
##    (assign, ":reward", reg0),
##    (val_mul, ":reward", ":num_prisoners"),
##    (val_div, ":reward", 2),
##    (call_script, "script_troop_add_gold", "trp_player", ":reward"),
##    (party_get_slot, ":cur_lord", "$g_encountered_party", slot_town_lord),#Removing gold from the town owner's wealth
##    (troop_get_slot, ":cur_wealth", ":cur_lord", slot_troop_wealth),
##    (val_sub, ":cur_wealth", ":reward"),
##    (troop_set_slot, ":cur_lord", slot_troop_wealth, ":cur_wealth"),
##    (call_script, "script_game_get_join_cost", ":quest_object_troop"),
##    (assign, ":reward", reg0),
##    (val_mul, ":reward", ":quest_target_amount"),
##    (val_div, ":reward", 2),
##    (quest_set_slot, "qst_bring_prisoners_to_enemy", slot_quest_current_state, 1),#Some of the prisoners are given, so it's state will change for remembering that.
##    (quest_set_slot, "qst_bring_prisoners_to_enemy", slot_quest_target_amount, ":reward"),#Still needs to pay the lord the full price of the prisoners
##    (succeed_quest, "qst_bring_prisoners_to_enemy"),
##    ]],
##
##
##  [anyone,"guard_prisoners_brought", [],
##   "TODO: Thank you. Here is the money for prisoners.", "request_meeting_pretalk",[]],
##
##  [anyone,"guard_prisoners_brought_some", [],
##   "TODO: Thank you, but that's not enough. Here is the money for prisoners.", "request_meeting_pretalk",[]],

#  [anyone|plyr,"request_meeting_1", [], "[Leave]", "close_window",[]],




  
##  [anyone,"request_meeting_open_gates", [(party_get_slot, ":castle_lord", "$g_encountered_party", slot_town_lord),
##                                         (call_script, "script_get_troop_attached_party", ":castle_lord"),
##                                         (eq, "$g_encountered_party", reg0),
##                                         (str_store_troop_name, 1, ":castle_lord")
##                                         ],  "My lord {s1} is in the castle now. You must ask his permission to enter.", "request_meeting_pretalk",[]],
##
##  [anyone,"request_meeting_open_gates", [(party_get_slot, ":castle_lord", "$g_encountered_party", slot_town_lord),
##                                         (call_script, "script_get_troop_attached_party", ":castle_lord"),
##                                         (neq, "$g_encountered_party", reg0),
##                                         (ge, "$g_encountered_party_relation", 0),
##                                         (troop_get_slot, ":castle_lord_relation", ":castle_lord", slot_troop_player_relation),
##                                         (ge, ":castle_lord_relation", 20),
##                                         (str_store_troop_name, 1, ":castle_lord")
##                                         ],  "My lord {s1} is not in the castle now.\
## But I think he would approve of you taking shelter here, {sir/madam}.\
## Come on in. I am opening the gates for you.", "close_window",[]],
##  
##  [anyone,"request_meeting_open_gates", [(party_get_slot, ":castle_lord", "$g_encountered_party", slot_town_lord),(str_store_troop_name, 1, ":castle_lord")],
##   "My lord {s1} is not in the castle now. I can't allow you into the castle without his orders.", "request_meeting_pretalk",[]],
  

  

# Quest conversations

##### TODO: QUESTS COMMENT OUT BEGIN
  
##  [party_tpl|pt_peasant_rebels,"start", [],
##   "TODO: What.", "peasant_rebel_talk",[]],
##  [anyone|plyr, "peasant_rebel_talk", [], "TODO: Die.", "close_window",[]],
##  [anyone|plyr, "peasant_rebel_talk", [], "TODO: Nothing.", "close_window",[(assign, "$g_leave_encounter",1)]],
##
##  [party_tpl|pt_noble_refugees,"start", [],
##   "TODO: What.", "noble_refugee_talk",[]],
##  [anyone|plyr, "noble_refugee_talk", [], "TODO: Nothing.", "close_window",[(assign, "$g_leave_encounter",1)]],
##


  [anyone,"start", [(eq,"$talk_context",tc_join_battle_ally),
                    ],
   "You have come just in time. Let us join our forces now and teach our enemy a lesson.", "close_window",
   []],

  [anyone,"start", [(eq,"$talk_context",tc_join_battle_enemy),
                    ],
   "You are making a big mistake by fighting against us.", "close_window",
   []],

  [anyone,"start", [(eq,"$talk_context",tc_ally_thanks),
                    (troop_is_hero, "$g_talk_troop"),
                    (eq, "$g_talk_troop_met", 0),
                    (ge, "$g_talk_troop_relation", 17),
                    ],
   "I don't think we have met properly my friend. You just saved my life out there, and I still don't know your name...", "ally_thanks_meet", []],


  [anyone,"start", [(eq,"$talk_context",tc_ally_thanks),
                    (troop_is_hero, "$g_talk_troop"),
                    (eq, "$g_talk_troop_met", 0),
                    (ge, "$g_talk_troop_relation", 5),
					(str_store_troop_name, s1, "$g_talk_troop"),
                    ],
   "Your help was most welcome stranger. My name is {s1}. Can I learn yours?", "ally_thanks_meet", []],

  [anyone,"start", [(eq,"$talk_context",tc_ally_thanks),
                    (troop_is_hero, "$g_talk_troop"),
                    (eq, "$g_talk_troop_met", 0),
                    (ge, "$g_talk_troop_relation", 0),
                    (str_store_troop_name, s1, "$g_talk_troop"),
                    ],
   "Thanks for your help, stranger. We haven't met properly yet, have we? What is your name?", "ally_thanks_meet", []],

  [anyone|plyr,"ally_thanks_meet", [], "My name is {playername}.", "ally_thanks_meet_2", []],

  [anyone, "ally_thanks_meet_2", [(ge, "$g_talk_troop_relation", 15),(str_store_troop_name, s1, "$g_talk_troop")],
   "Well met indeed {playername}. My name is {s1} and I am forever in your debt. If there is ever anything I can help you with, just let me know...", "close_window", []],
  [anyone, "ally_thanks_meet_2", [(ge, "$g_talk_troop_relation", 5),], "Well met {playername}. I am in your debt for what you just did. I hope one day I will find a way to repay it.", "close_window", []],
  [anyone, "ally_thanks_meet_2", [], "Well met {playername}. I am {s1}. Thanks for your help and I hope we meet again.", "close_window", []],

#Post 0907 changes begin
  [anyone,"start", [(eq,"$talk_context",tc_ally_thanks),
                    (troop_is_hero, "$g_talk_troop"),
                    (ge, "$g_talk_troop_relation", 30),
                    (ge, "$g_relation_boost", 10),
                    ],
   "Again you save our necks, {playername}! Truly, you are the best of friends. {s43}", "close_window", [
       (call_script, "script_lord_comment_to_s43", "$g_talk_troop", "str_battle_won_default"),
       (try_begin),
         (party_stack_get_troop_id, ":enemy_party_leader", "p_encountered_party_backup", 0),
         (is_between, ":enemy_party_leader", active_npcs_begin, active_npcs_end),
         (call_script, "script_add_log_entry", logent_lord_helped_by_player, "trp_player",  -1, ":enemy_party_leader", -1),
       (try_end),
       ]],
  
  [anyone,"start", [(eq,"$talk_context",tc_ally_thanks),
                    (troop_is_hero, "$g_talk_troop"),
                    (ge, "$g_talk_troop_relation", 20),
                    (ge, "$g_relation_boost", 5),
                    ],
   "You arrived just in the nick of time! {playername}. You have my deepest thanks! {s43}", "close_window", [
       (call_script, "script_lord_comment_to_s43", "$g_talk_troop", "str_battle_won_default"),
#       (try_begin),
#         (party_stack_get_troop_id, ":enemy_party_leader", "p_encountered_party_backup", 0),
#         (is_between, ":enemy_party_leader", active_npcs_begin, active_npcs_end),
       (call_script, "script_add_log_entry", logent_lord_helped_by_player, "trp_player",  -1, "$g_talk_troop", -1),
#       (try_end),
       ]],
  
  [anyone,"start", [(eq,"$talk_context",tc_ally_thanks),
                    (troop_is_hero, "$g_talk_troop"),
                    (ge, "$g_talk_troop_relation", 0),
                    (ge, "$g_relation_boost", 3),
                    ],
   "You turned up just in time, {playername}. I will not forget your help. {s43}", "close_window", [
       (call_script, "script_lord_comment_to_s43", "$g_talk_troop", "str_battle_won_default"),
#       (try_begin),
#         (party_stack_get_troop_id, ":enemy_party_leader", "p_encountered_party_backup", 0),
#         (is_between, ":enemy_party_leader", active_npcs_begin, active_npcs_end),
       (call_script, "script_add_log_entry", logent_lord_helped_by_player, "trp_player",  -1, "$g_talk_troop", -1),
#       (try_end),
       ]],

  [anyone,"start", [(eq,"$talk_context",tc_ally_thanks),
                    (troop_is_hero, "$g_talk_troop"),
                    (ge, "$g_talk_troop_relation", -5),
                    ],
   "Good to see you here, {playername}. {s43}", "close_window", [
                    (call_script, "script_lord_comment_to_s43", "$g_talk_troop", "str_battle_won_default"),
					(call_script, "script_troop_change_relation_with_troop", "$g_talk_troop", "trp_player", 1),
       ]],


  [anyone,"start", [(eq,"$talk_context",tc_ally_thanks),
                    (troop_is_hero, "$g_talk_troop"),
                    (ge, "$g_relation_boost", 4),
                    ],
   "{s43}", "close_window", [
                    (call_script, "script_lord_comment_to_s43", "$g_talk_troop", "str_battle_won_grudging_default"),
                    ]],


  [anyone,"start", [(eq,"$talk_context",tc_ally_thanks),
                    (troop_is_hero, "$g_talk_troop"),
                    ],
   "{s43}", "close_window", [
                    (call_script, "script_lord_comment_to_s43", "$g_talk_troop", "str_battle_won_unfriendly_default"),
                    ]],


#  [anyone,"start", [(eq,"$talk_context",tc_ally_thanks),
#                    (troop_is_hero, "$g_talk_troop"),
#                    (ge, "$g_talk_troop_relation", -20),
#                    ],
#   "So, this is {playername}. Well, your help wasn't really needed, but I guess you had nothing better to do, right?", "close_window", []],

#  [anyone,"start", [(eq,"$talk_context",tc_ally_thanks),
#                    (troop_is_hero, "$g_talk_troop"),
#                    ],
#   "Who told you to come to our help? I certainly didn't. Begone now. I want nothing from you and I will not let you steal my victory.", "close_window", []],

#Post 0907 changes begin

  [anyone,"start", [(eq,"$talk_context",tc_ally_thanks),
                    (ge, "$g_relation_boost", 10),
                    (party_get_num_companions, reg1, "$g_encountered_party"),
                    (val_sub, reg1, 1),
                    ],
   "Thank you for your help {sir/madam}. You saved {reg1?our lives:my life} out there.", "close_window", []],

  [anyone,"start", [(eq,"$talk_context",tc_ally_thanks),
                    (ge, "$g_relation_boost", 5),
                    ],
   "Thank you for your help {sir/madam}. Things didn't look very well for us but then you came up and everything changed.", "close_window", []],

  [anyone,"start", [(eq,"$talk_context",tc_ally_thanks)],
   "Thank you for your help, {sir/madam}. It was fortunate to have you nearby.", "close_window", []],
  
  [anyone,"start", [(eq, "$talk_context", tc_hero_freed),
                    (store_conversation_troop,":cur_troop"),
                    (eq,":cur_troop","trp_kidnapped_girl"),],
   "Oh {sir/madam}. Thank you so much for rescuing me. Will you take me to my family now?", "kidnapped_girl_liberated_battle",[]],

  [anyone,"start", [(eq,"$talk_context",tc_hero_freed)],
   "I am in your debt for freeing me friend.", "freed_hero_answer",
   []],

  [anyone|plyr,"freed_hero_answer", [],
   "You're not going anywhere. You'll be my prisoner now!", "freed_hero_answer_1",
   [
     (store_conversation_troop, ":cur_troop_id"), 
     (party_add_prisoners, "p_main_party", ":cur_troop_id", 1),#take prisoner
    ]],

  [anyone,"freed_hero_answer_1", [],
   "Alas. Will my luck never change?", "close_window",
   []],

  [anyone|plyr,"freed_hero_answer", [],
   "You're free to go, {s65}.", "freed_hero_answer_2",
   [
    ]],

  [anyone,"freed_hero_answer_2", [],
   "Thank you, good {sire/lady}. I never forget someone who's done me a good turn.", "close_window",
   []],

  [anyone|plyr,"freed_hero_answer", [],
   "Would you like to join me?", "freed_hero_answer_3",
   []],

  [anyone,"freed_hero_answer_3", [(store_random_in_range, ":random_no",0,2),(eq, ":random_no", 0)],
   "All right I will join you.", "close_window",
   [
     (store_conversation_troop, ":cur_troop_id"), 
     (party_add_members, "p_main_party", ":cur_troop_id", 1),#join hero
   ]],

  [anyone,"freed_hero_answer_3", [],
   "No, I want to go on my own.", "close_window",
   [
    ]],

  [anyone,"start", [(eq,"$talk_context",tc_hero_defeated)],
   "You'll not live long to enjoy your victory. My kinsmen will soon wipe out the stain of this defeat.", "defeat_hero_answer",
   [
    ]],

  [anyone|plyr,"defeat_hero_answer", [],
   "You are my prisoner now.", "defeat_hero_answer_1",
   [
     (party_add_prisoners, "p_main_party", "$g_talk_troop", 1),#take prisoner
     #(troop_set_slot, "$g_talk_troop", slot_troop_is_prisoner, 1),
     (troop_set_slot, "$g_talk_troop", slot_troop_prisoner_of_party, "p_main_party"),
     (call_script, "script_event_hero_taken_prisoner_by_player", "$g_talk_troop"),
    ]],

  [anyone,"defeat_hero_answer_1", [],
   "Damn you. You will regret this.", "close_window",
   []],

  [anyone|plyr,"defeat_hero_answer", [],
   "You're free to go this time, but don't cross my path again.", "defeat_hero_answer_2",
   []],

  [anyone,"defeat_hero_answer_2", [],
   "We will meet again.", "close_window",
   []],


   

  [anyone,"combined_political_quests", [
  (eq, "$political_quest_found", "qst_resolve_dispute"),
	],
   "{s9}", "political_quest_suggested",
   [
   (quest_set_slot, "qst_resolve_dispute", slot_quest_target_troop, "$political_quest_target_troop"),
   (quest_set_slot, "qst_resolve_dispute", slot_quest_object_troop, "$political_quest_object_troop"),
   
   (quest_get_slot, ":target_troop", "qst_resolve_dispute", slot_quest_target_troop),
   (quest_get_slot, ":object_troop", "qst_resolve_dispute", slot_quest_object_troop),
   (str_store_troop_name, s4, ":target_troop"),
   (str_store_troop_name, s5, ":object_troop"),
   (faction_get_slot, ":faction_leader", "$players_kingdom", slot_faction_leader),
   (str_store_troop_name, s7, ":faction_leader"),
   (try_begin),
      (eq, "$players_kingdom", "fac_player_supporters_faction"),
	  (faction_slot_eq, "fac_player_supporters_faction", slot_faction_leader, "trp_player"),
	  (str_store_string, s9, "str_you_may_be_aware_my_lord_of_the_quarrel_between_s4_and_s5_which_is_damaging_the_unity_of_this_realm_and_sapping_your_authority_if_you_could_persuade_the_lords_to_reconcile_it_would_boost_your_own_standing_however_in_taking_this_on_you_run_the_risk_of_one_the_lords_deciding_that_you_have_taken_the_rivals_side"),
   (else_try),
	  (str_store_string, s9, "str_you_may_be_aware_my_lord_of_the_quarrel_between_s4_and_s5_which_is_damaging_the_unity_of_this_realm_and_sapping_your_authority_if_you_could_persuade_the_lords_to_reconcile_i_imagine_that_s7_would_be_most_pleased_however_in_taking_this_on_you_run_the_risk_of_one_the_lords_deciding_that_you_have_taken_the_rivals_side"),
   (try_end),
   ]],

  [anyone,"political_quest_follow_on", [
  (eq, "$political_quest_found", "qst_resolve_dispute"),
	],
   "I think that is a wise move. Good luck to you.", "close_window",
   [
    (assign, "$g_leave_encounter", 1),
    (setup_quest_text,"qst_resolve_dispute"),
	
	(quest_get_slot, ":lord_1", "qst_resolve_dispute", slot_quest_target_troop),
	(str_store_troop_name_link, s11, ":lord_1"),
	
	(quest_get_slot, ":lord_2", "qst_resolve_dispute", slot_quest_object_troop),
	(str_store_troop_name_link, s12, ":lord_2"),	

	(str_store_string, s2, "str_resolve_the_dispute_between_s11_and_s12"),
	(call_script, "script_start_quest", "qst_resolve_dispute", -1),
	(quest_set_slot, "qst_resolve_dispute", slot_quest_expiration_days, 30),
	(quest_set_slot, "qst_resolve_dispute", slot_quest_giver_troop, "$g_talk_troop"),
	(quest_set_slot, "qst_resolve_dispute", slot_quest_target_state, 0),
	(quest_set_slot, "qst_resolve_dispute", slot_quest_object_state, 0),
	
	(quest_get_slot, ":lord_1", "qst_resolve_dispute", slot_quest_target_troop), #this block just to check if the slots work
	(str_store_troop_name, s11, ":lord_1"),
	(quest_get_slot, ":lord_2", "qst_resolve_dispute", slot_quest_object_troop),
	(str_store_troop_name, s12, ":lord_2"),	
	],
   ],
   
   
   [anyone,"combined_political_quests", [

  (eq, "$political_quest_found", "qst_offer_gift"),
  (quest_set_slot, "qst_offer_gift", slot_quest_target_troop, "$political_quest_target_troop"),
  
  (quest_get_slot, ":target_troop", "qst_offer_gift", slot_quest_target_troop),
  (str_store_troop_name, s4, ":target_troop"),
  (troop_get_type, reg4, ":target_troop"),
  (call_script, "script_troop_get_family_relation_to_troop", ":target_troop", "$g_talk_troop"),
  
	],
   "Your relations with {s4} are not all that they could be. As {reg4?she:he} is my {s11}, I can mediate to attempt to mend your quarrel. Perhaps the best way for me to do this would be to send {reg4?her:him} a gift -- a fur-trimmed velvet robe, perhaps. If you can provide me with a bolt of velvet and a length of furs, I can have one made and sent to {reg4?her:him.}", "political_quest_suggested",
   [
   (quest_get_slot, ":target_troop", "qst_offer_gift", slot_quest_target_troop),
   (troop_get_type, reg4, ":target_troop"),
   ]],

   
   
  [anyone,"political_quest_follow_on", [
  (eq, "$political_quest_found", "qst_offer_gift"),
  ],
   "Splendid. I shall await the materials.", "close_window",
   [
   (assign, "$g_leave_encounter", 1),
    (setup_quest_text,"qst_offer_gift"),
	
	(quest_get_slot, ":lord_1", "qst_offer_gift", slot_quest_target_troop),
	(str_store_troop_name, s14, ":lord_1"),
	(str_store_troop_name, s12, "$g_talk_troop"),	
	(troop_get_type, reg4, "$g_talk_troop"),
	
	(str_store_string, s2, "str_you_intend_to_bring_gift_for_s14"),   
   
   (call_script, "script_start_quest", "qst_offer_gift", "$g_talk_troop"),
   (quest_set_slot, "qst_offer_gift", slot_quest_expiration_days, 30),
   ]],
   
   
   
   
   [anyone,"combined_political_quests", [
   (eq, "$political_quest_found", "qst_denounce_lord"),
   (this_or_next|eq, "$g_talk_troop", "$g_player_minister"),
		(troop_slot_eq, "trp_player", slot_troop_spouse, "$g_talk_troop"),
		
   (str_store_troop_name, s4, "$political_quest_target_troop"),
   (troop_get_type, reg4, "$political_quest_target_troop"),
   (str_store_faction_name, s5, "$players_kingdom"),
   
   (troop_get_slot, ":reputation_string", "$political_quest_target_troop", slot_lord_reputation_type),
   (val_add, ":reputation_string", "str_lord_derogatory_default"),
   (str_store_string, s7, ":reputation_string"),

   (troop_get_slot, ":reputation_string", "$political_quest_target_troop", slot_lord_reputation_type),
   (val_add, ":reputation_string", "str_lord_derogatory_result"),
   (str_store_string, s8, ":reputation_string"),
   
	],
   "As you may realize, {s4} has many enemies among the lords of the {s5}. In particular, they feel that {reg4?she:he} is {s7}, and worry that {reg4?she:he} will {s8}. Were you to denounce {s4} to {reg4?her:his} face, you may reap much popularity -- although, of course, you would make an enemy of {reg4?her:him}, and risk being challenged to a duel.", "political_quest_suggested",
   [
   ]],

    [anyone,"combined_political_quests", [
    (eq, "$political_quest_found", "qst_denounce_lord"),
    (troop_get_type, reg4, "$political_quest_target_troop"),
	
	(str_clear, s9),
	(call_script, "script_troop_get_relation_with_troop", "trp_player", "$g_talk_troop"),
	(assign, ":player_relation_with_target", reg0),

    (str_store_troop_name, s4, "$political_quest_target_troop"),
	(try_begin),
		(ge, ":player_relation_with_target", 2),
		(neg|troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_debauched),
		(neg|troop_slot_eq, "$g_talk_troop", slot_lord_reputation_type, lrep_quarrelsome),
		(str_store_string, s9, "str_i_realize_that_you_are_on_good_terms_with_s4_but_we_ask_you_to_do_this_for_the_good_of_the_realm"),
	(else_try),
		(ge, ":player_relation_with_target", 2),
		(str_store_string, s9, "str_i_realize_that_you_are_on_good_terms_with_s4_but_the_blow_will_hurt_him_more"),
	(try_end),
	
    (str_store_faction_name, s5, "$players_kingdom"),
    (str_store_troop_name, s4, "$political_quest_target_troop"),
	
    (troop_get_slot, ":reputation_string", "$political_quest_target_troop", slot_lord_reputation_type),
    (val_add, ":reputation_string", "str_lord_derogatory_default"),
    (str_store_string, s7, ":reputation_string"),

    (troop_get_slot, ":reputation_string", "$political_quest_target_troop", slot_lord_reputation_type),
    (val_add, ":reputation_string", "str_lord_derogatory_result"),
    (str_store_string, s8, ":reputation_string"),
	
	
	],
	
    "As you may realize, many of us in the peerage of the {s5} consider {s4} to be {s7}, and a liability to our cause. We worry that {reg4?she:he} will {s8}. People know my views on {s4} already, but if you were to denounce {reg4?her:him} to {reg4?her:his} face, you would further erode his standing -- and discourage our liege from entrusting {reg4?her:him} with any more power or responsibility. Of course, you would make an enemy of {reg4?her:him}, and risk being challenged to a duel.{s9}", "political_quest_suggested",
    [
	
	
	]],


	[anyone,"political_quest_follow_on", [
	(eq, "$political_quest_found", "qst_denounce_lord"),
	(this_or_next|eq, "$g_talk_troop", "$g_player_minister"),
		(troop_slot_eq, "trp_player", slot_troop_spouse, "$g_talk_troop"),
  ],
   "We appreciate what you are doing. I find such intrigues distasteful, but it is all for the good of the {s5}.", "close_window",
   [
   (quest_set_slot, "qst_denounce_lord", slot_quest_target_troop, "$political_quest_target_troop"),
   
   (quest_get_slot, ":target_troop", "qst_denounce_lord", slot_quest_target_troop),
   (str_store_troop_name_link, s14, ":target_troop"),
   (str_store_troop_name_link, s12, "$g_talk_troop"),

   (str_store_string, s2, "str_you_intend_to_denounce_s14_to_his_face_on_behalf_of_s14"), 
   (setup_quest_text, "qst_denounce_lord"),
   
   (call_script, "script_start_quest", "$political_quest_found", "$g_talk_troop"),
   (quest_set_slot, "qst_denounce_lord", slot_quest_expiration_days, 60),
   
   (str_store_faction_name, s5, "$players_kingdom"),
   (assign, "$g_leave_encounter", 1),
   ]],

   
	[anyone,"political_quest_follow_on", [
	(eq, "$political_quest_found", "qst_denounce_lord"),
  ],
   "Very well. It is always risky to involve yourself in intrigues of this sort, but in this case, I think you will benefit.", "close_window",
   [
   (quest_set_slot, "qst_denounce_lord", slot_quest_target_troop, "$political_quest_target_troop"),
   
   (quest_get_slot, ":target_troop", "qst_denounce_lord", slot_quest_target_troop),
   (str_store_troop_name_link, s14, ":target_troop"),
   (str_store_troop_name_link, s12, "$g_talk_troop"),

   (str_store_string, s2, "str_you_intend_to_denounce_s14_to_his_face_on_behalf_of_s14"),
   (setup_quest_text, "qst_denounce_lord"),
   
   (call_script, "script_start_quest", "$political_quest_found", "$g_talk_troop"),
   (assign, "$g_leave_encounter", 1),
]],



	
   [anyone,"combined_political_quests", [
    (eq, "$political_quest_found", "qst_intrigue_against_lord"),
    (str_store_troop_name, s4, "$political_quest_target_troop"),
    (troop_get_type, reg4, "$political_quest_target_troop"),
    (str_store_faction_name, s5, "$players_kingdom"),
    (troop_get_slot, ":reputation_string", "$political_quest_target_troop", slot_lord_reputation_type),
    (val_add, ":reputation_string", "str_lord_derogatory_default"),
    (str_store_string, s7, ":reputation_string"),

    (troop_get_slot, ":reputation_string_2", "$political_quest_target_troop", slot_lord_reputation_type),
    (val_add, ":reputation_string_2", "str_lord_derogatory_result"),
    (str_store_string, s8, ":reputation_string_2"),
	
	(faction_get_slot, ":faction_leader", "$players_kingdom", slot_faction_leader),
	(str_store_troop_name, s9, ":faction_leader"),
	],
   "You and I have a common interest in seeking to curtail the rise of {s4}. I feel that {reg4?she:he} is {s7}, and worry that {reg4?she:he} will {s8}. Were you to tell our liege {s9} your opinion of {s4}, it might discourage {s9} from granting {s4} any further powers or responsibilities, at least for a while, and I would be much obliged to you.", "political_quest_suggested",
   []],

   #Intrigue lord for 
	[anyone,"political_quest_follow_on", [
	(eq, "$political_quest_found", "qst_intrigue_against_lord"),
#	(this_or_next|eq, "$g_talk_troop", "$g_player_minister"),
#		(troop_slot_eq, "trp_player", slot_troop_spouse, "$g_talk_troop"),
    (str_store_faction_name, s5, "$players_kingdom"),
		
  ],
   "We appreciate what you are doing. I find such intrigues distasteful, but it is all for the good of the {s5}.", "close_window",
   [
   (quest_set_slot, "qst_intrigue_against_lord", slot_quest_target_troop, "$political_quest_target_troop"),

   (quest_get_slot, ":target_troop", "qst_intrigue_against_lord", slot_quest_target_troop),
   (store_faction_of_troop, ":target_troop_faction", ":target_troop"),
   (faction_get_slot, ":faction_liege", ":target_troop_faction", slot_faction_leader),
   (str_store_troop_name_link, s14, ":target_troop"),
   (str_store_troop_name_link, s13, ":faction_liege"),
   (str_store_troop_name_link, s12, "$g_talk_troop"),

   (str_store_string, s2, "str_you_intend_to_denounce_s14_to_s13_on_behalf_of_s12"),
   (setup_quest_text, "qst_intrigue_against_lord"),
   
   (call_script, "script_start_quest", "$political_quest_found", "$g_talk_troop"),
   (quest_set_slot, "qst_intrigue_against_lord", slot_quest_expiration_days, 60),
   (assign, "$g_leave_encounter", 1),
   ]],
	
	
  [anyone,"combined_political_quests", [],
   "I cannot think of anything right now, but we will have some items of mutual interest in the future.", "political_quest_suggested",
   []],
   
  [anyone|plyr,"political_quest_suggested", [
  (gt, "$political_quest_found", 0),
  ],
   "I like that idea.", "political_quest_follow_on",
   [
   ]],
   
  [anyone|plyr,"political_quest_suggested", [
  (gt, "$political_quest_found", 0),
  ],
   "Hmm.. Maybe you can think of something else?", "combined_political_quests",
   [
   (quest_set_slot, "$political_quest_found", slot_quest_dont_give_again_remaining_days, 3),
   (call_script, "script_get_political_quest", "$g_talk_troop"),
   (assign, "$political_quest_found", reg0),
   (assign, "$political_quest_target_troop", reg1),
   (assign, "$political_quest_object_troop", reg2),
   
   ]],
   
  [anyone|plyr,"political_quest_suggested", [],
   "Let us discuss another topic", "political_quests_end",
   []],

   
   
   
   
   
   
   
  [anyone,"political_quests_end", [
  (troop_slot_eq, "$g_talk_troop", slot_troop_occupation, slto_kingdom_hero),
  ],
   "Very well.", "lord_pretalk",
   []],
   
  [anyone,"political_quests_end", [
  (troop_slot_eq, "trp_player", slot_troop_spouse, "$g_talk_troop"),
  ],
   "Very well.", "spouse_pretalk",
   []],

  [anyone,"political_quests_end", [
  (eq, "$g_talk_troop", "$g_player_minister"),
  ],
   "Very well.", "minister_pretalk",
   []],

  [anyone,"political_quests_end", [
  ],
   "Very well.", "close_window",
   [
   (assign, "$g_leave_encounter", 1),
   ]],



   
# Local merchant

  [trp_local_merchant,"start", [], "Mercy! Please don't kill me!", "local_merchant_mercy",[]],
  [anyone|plyr,"local_merchant_mercy", [(quest_get_slot, ":quest_giver_troop", "qst_kill_local_merchant", slot_quest_giver_troop),(str_store_troop_name, s2, ":quest_giver_troop")],
   "I have nothing against you man. But {s2} wants you dead. Sorry.", "local_merchant_mercy_no",[]],
  [anyone,"local_merchant_mercy_no", [], "Damn you! May you burn in Hell!", "close_window",[]],
  [anyone|plyr,"local_merchant_mercy", [], "I'll let you live, if you promise me...", "local_merchant_mercy_yes",[]],

  [anyone,"local_merchant_mercy_yes", [], "Of course, I promise, I'll do anything. Just spare my life... ", "local_merchant_mercy_yes_2",[]],
  [anyone|plyr,"local_merchant_mercy_yes_2", [], "You are going to forget about {s2}'s debt to you.\
 And you will sign a paper stating that he owes you nothing.", "local_merchant_mercy_yes_3",[]],
  [anyone,"local_merchant_mercy_yes_3", [], "Yes, of course. I'll do as you say.", "local_merchant_mercy_yes_4",[]],
  [anyone|plyr,"local_merchant_mercy_yes_4", [], "And if my lord hears so much of a hint of a complaint about this issue, then I'll come back for you,\
 and it won't matter how much you scream for mercy then.\
 Do you understand me?", "local_merchant_mercy_yes_5",[]],
  [anyone,"local_merchant_mercy_yes_5", [], "Yes {sir/madam}. Don't worry. I won't make any complaint.", "local_merchant_mercy_yes_6",[]],
  [anyone|plyr,"local_merchant_mercy_yes_6", [], "Good. Go now, before I change my mind.", "close_window",
   [(quest_set_slot, "qst_kill_local_merchant", slot_quest_current_state, 2),
    (call_script, "script_succeed_quest", "qst_kill_local_merchant"),
    (finish_mission),
    ]],

# Village traitor

  [trp_fugitive,"start", [], "What do you want?", "fugitive_1",[]],
  [trp_fugitive|plyr,"fugitive_1", [
     (quest_get_slot, ":quest_target_dna", "qst_hunt_down_fugitive", slot_quest_target_dna),
     (call_script, "script_get_name_from_dna_to_s50", ":quest_target_dna"),
     (str_store_string, s4, s50),
      ], "I am looking for a murderer by the name of {s4}. You fit his description.", "fugitive_2",[]],
  [trp_fugitive|plyr,"fugitive_1", [], "Nothing. Sorry to trouble you.", "close_window",[]],
  [trp_fugitive,"fugitive_2", [], "I don't understand, {sir/madam}.\
 I never killed anyone. I think you've got the wrong man.", "fugitive_3",[]],
  [trp_fugitive|plyr,"fugitive_3", [], "Then drop your sword. If you are innocent, you have nothing to fear.\
 We'll go now and talk to your neighbours, and if they verify your story, I'll go on my way.", "fugitive_4",[]],
  [anyone,"fugitive_4", [], "I'm not going anywhere, friend. You're going to have to fight for your silver, today.", "fugitive_5",
   []],

  [trp_fugitive|plyr,"fugitive_5", [], "No problem. I really just need your head, anyway.", "fugitive_fight_start",[]],
  [trp_fugitive|plyr,"fugitive_5", [], "I come not for money, but to execute the law!", "fugitive_fight_start",[]],
  [trp_fugitive|plyr,"fugitive_5", [], "Alas, that you cannot be made to see reason.", "fugitive_fight_start",[]],
	
  [anyone,"fugitive_fight_start", [], "Die, dog!", "close_window",
   [
	(set_party_battle_mode),
    (quest_set_slot, "qst_hunt_down_fugitive", slot_quest_current_state, 1),
    (call_script, "script_activate_tavern_attackers"),
   ]],
	
	
  [anyone,"member_chat", [(check_quest_active, "qst_incriminate_loyal_commander"),
                          (quest_slot_eq, "qst_incriminate_loyal_commander", slot_quest_current_state, 0),
                          (store_conversation_troop, "$g_talk_troop"),
                          (eq, "$g_talk_troop", "$incriminate_quest_sacrificed_troop"),
                          (quest_get_slot, ":quest_target_center", "qst_incriminate_loyal_commander", slot_quest_target_center),
                          (store_distance_to_party_from_party, ":distance", "p_main_party", ":quest_target_center"),
                          (lt, ":distance", 10),
                          ], "Yes {sir/madam}?", "sacrificed_messenger_1",[]],

  [anyone|plyr,"sacrificed_messenger_1", [(quest_get_slot, ":quest_target_center", "qst_incriminate_loyal_commander", slot_quest_target_center),
                                          (str_store_party_name, s1, ":quest_target_center"),
                                          (quest_get_slot, ":quest_object_troop", "qst_incriminate_loyal_commander", slot_quest_object_troop),
                                          (str_store_troop_name, s2, ":quest_object_troop"),],
   "Take this letter to {s1} and give it to {s2}.", "sacrificed_messenger_2",[]],
  [anyone|plyr,"sacrificed_messenger_1", [],
   "Nothing. Nothing at all.", "close_window",[]],

  [anyone,"sacrificed_messenger_2", [],
   "Yes {sir/madam}. You can trust me. I will not fail you.", "sacrificed_messenger_3",[]],

  [anyone|plyr,"sacrificed_messenger_3", [],
   "Good. I will not forget your service. You will be rewarded when you return.", "close_window",[(party_remove_members, "p_main_party", "$g_talk_troop", 1),
                                     (set_spawn_radius, 0),
                                     (spawn_around_party, "p_main_party", "pt_sacrificed_messenger"),
                                     (assign, ":new_party", reg0),
                                     (party_add_members, ":new_party", "$g_talk_troop", 1),
                                     (party_set_ai_behavior, ":new_party", ai_bhvr_travel_to_party),
                                     (quest_get_slot, ":quest_target_center", "qst_incriminate_loyal_commander", slot_quest_target_center),
                                     (party_set_ai_object, ":new_party", ":quest_target_center"),
                                     (party_set_flags, ":new_party", pf_default_behavior, 0),
                                     (quest_set_slot, "qst_incriminate_loyal_commander", slot_quest_current_state, 2),
                                     (quest_set_slot, "qst_incriminate_loyal_commander", slot_quest_target_party, ":new_party")]],
  [anyone|plyr,"sacrificed_messenger_3", [], "Arggh! I can't do this. I can't send you to your own death!", "sacrificed_messenger_cancel",[]],
  [anyone,"sacrificed_messenger_cancel", [], "What do you mean {sir/madam}", "sacrificed_messenger_cancel_2",[]],
  [anyone|plyr,"sacrificed_messenger_cancel_2", [(quest_get_slot, ":quest_giver", "qst_incriminate_loyal_commander", slot_quest_giver_troop),
                                                 (str_store_troop_name, s3, ":quest_giver"),
      ], "There's a trap set up for you in the town.\
 {s3} ordered me to sacrifice one of my chosen warriors to fool the enemy,\
 but he will just need to find another way.", "sacrificed_messenger_cancel_3",[
     (quest_get_slot, ":quest_giver", "qst_incriminate_loyal_commander", slot_quest_giver_troop),
     (quest_set_slot, "qst_incriminate_loyal_commander", slot_quest_current_state, 1),
     (call_script, "script_change_player_relation_with_troop",":quest_giver",-5),
     (call_script, "script_change_player_honor", 3),
     (call_script, "script_fail_quest", "qst_incriminate_loyal_commander"),
     ]],
  [anyone,"sacrificed_messenger_cancel_3", [], "Thank you, {sir/madam}.\
 I will follow you to the gates of hell. But this would not be a good death.", "close_window",[]],

  [party_tpl|pt_sacrificed_messenger,"start", [],
   "Don't worry, {sir/madam}, I'm on my way.", "close_window",[(assign, "$g_leave_encounter",1)]],

#Spy

  [party_tpl|pt_spy,"start", [], "Good day {sir/madam}. Such fine weather don't you think? If you'll excuse me now I must go on my way.", "follow_spy_talk",[]],

  [anyone|plyr, "follow_spy_talk",
   [
     (quest_get_slot, ":quest_giver", "qst_follow_spy", slot_quest_giver_troop),
     (str_store_troop_name, s1, ":quest_giver"),
     ],
   "In the name of {s1}, you are under arrest!", "follow_spy_talk_2", []],
  [anyone, "follow_spy_talk_2", [], "You won't get me alive!", "close_window", []],
  [anyone|plyr, "follow_spy_talk", [], "Never mind me. I was just passing by.", "close_window", [(assign, "$g_leave_encounter",1)]],

  [party_tpl|pt_spy_partners,"start", [], "Greetings.", "spy_partners_talk",[]],

  [anyone|plyr,"spy_partners_talk",
   [
     (quest_get_slot, ":quest_giver", "qst_follow_spy", slot_quest_giver_troop),
     (str_store_troop_name, s1, ":quest_giver"),
     ],
   "In the name of {s1} You are under arrest!", "spy_partners_talk_2",[]],
  [anyone,"spy_partners_talk_2", [], "You will have to fight us first!", "close_window",[]],
  [anyone|plyr,"spy_partners_talk", [], "Never mind me. I was just passing by.", "close_window",[(assign, "$g_leave_encounter",1)]],


###Conspirator
##
##  [party_tpl|pt_conspirator_leader,"start", [], "TODO: Hello.", "conspirator_talk",[]],
##  [party_tpl|pt_conspirator,"start", [], "TODO: Hello.", "conspirator_talk",[]],
##
##  [anyone|plyr,"conspirator_talk", [(gt, "$qst_capture_conspirators_leave_meeting_counter", 0),
##                                    (quest_get_slot,":quest_giver","qst_capture_conspirators",slot_quest_giver_troop),
##                                    (str_store_troop_name,s1,":quest_giver")],
##   "TODO: In the name of {s1}, you are under arrest!", "conspirator_talk_2",[]],
##
##  [anyone|plyr,"conspirator_talk", [], "TODO: Bye.", "close_window",[(assign, "$g_leave_encounter",1)]],
##
##  [anyone,"conspirator_talk_2", [], "You won't get me alive!", "close_window",[]],
##
#Runaway Peasants


  [party_tpl|pt_runaway_serfs,"start", [(party_slot_eq, "$g_encountered_party", slot_town_center, 0)],#slot_town_center is used for first time meeting
   "Good day {sir/madam}.", "runaway_serf_intro_1",
   [(party_set_slot, "$g_encountered_party", slot_town_center, 1)]],
  
  [anyone|plyr,"runaway_serf_intro_1", [(quest_get_slot, ":lord", "qst_bring_back_runaway_serfs", slot_quest_giver_troop),
                                        (str_store_troop_name, s4, ":lord")],
   "I have been sent by your {s4} whom you are running from. He will not punish you if you return now.", "runaway_serf_intro_2",[]],
   
  [anyone,"runaway_serf_intro_2", [(quest_get_slot, ":target_center", "qst_bring_back_runaway_serfs", slot_quest_target_center),
                                   (str_store_party_name, s6, ":target_center"),
                                   (quest_get_slot, ":quest_object_center", "qst_bring_back_runaway_serfs", slot_quest_object_center),
                                   (str_store_party_name, s1, ":quest_object_center")],
   "My good {sir/madam}. Our lives at our village {s1} was unbearable. We worked all day long and still went to bed hungry.\
 We are going to {s6} to start a new life, where we will be treated like humans.", "runaway_serf_intro_3",[]],

  [anyone|plyr,"runaway_serf_intro_3", [(quest_get_slot, ":quest_object_center", "qst_bring_back_runaway_serfs", slot_quest_object_center),
                                        (str_store_party_name, s1, ":quest_object_center"),],
   "You have gone against our laws by running from your bondage. You will go back to {s1} now!", "runaway_serf_go_back",
   [(quest_get_slot, ":quest_object_center", "qst_bring_back_runaway_serfs", slot_quest_object_center),
    (call_script, "script_change_player_relation_with_center", ":quest_object_center", -1)]],

  [anyone|plyr,"runaway_serf_intro_3", [], "Well, maybe you are right. All right then. If anyone asks, I haven't seen you.", "runaway_serf_let_go",
   [(quest_get_slot, ":quest_object_center", "qst_bring_back_runaway_serfs", slot_quest_object_center),
    (call_script, "script_change_player_relation_with_center", ":quest_object_center", 1)]],

  [party_tpl|pt_runaway_serfs,"runaway_serf_go_back", [(quest_get_slot, ":home_center", "qst_bring_back_runaway_serfs", slot_quest_object_center),
                                                       (str_store_party_name, s5, ":home_center")],
   "All right {sir/madam}. As you wish. We'll head back to {s5} now.", "close_window",
   [(quest_get_slot, ":quest_object_center", "qst_bring_back_runaway_serfs", slot_quest_object_center),
    (party_set_ai_object, "$g_encountered_party", ":quest_object_center"),
    (assign, "$g_leave_encounter",1)]],
  
  [anyone,"runaway_serf_let_go", [], "God bless you, {sir/madam}. We will not forget your help.", "close_window",
   [(party_set_slot, "$g_encountered_party", slot_town_castle, 1),
    (assign, "$g_leave_encounter",1)]],
  

  [party_tpl|pt_runaway_serfs,"start", [(party_slot_eq, "$g_encountered_party", slot_town_castle, 1),
                                        ],
   "Good day {sir/madam}. Don't worry. If anyone asks, we haven't seen you.", "runaway_serf_reconsider",[]],

  [anyone|plyr,"runaway_serf_reconsider", [], "I have changed my mind. You must back to your village!", "runaway_serf_go_back",
   [(party_set_slot, "$g_encountered_party", slot_town_castle, 0),
    (quest_get_slot, ":quest_object_center", "qst_bring_back_runaway_serfs", slot_quest_object_center),
    (call_script, "script_change_player_relation_with_center", ":quest_object_center", -2)]],

  [anyone|plyr,"runaway_serf_reconsider", [], "Good. Go quickly now before I change my mind.", "runaway_serf_let_go",[]],
  
  
  [party_tpl|pt_runaway_serfs,"start", [(party_slot_eq, "$g_encountered_party", slot_town_castle, 0),
                                        (get_party_ai_object, ":cur_ai_object"),
                                        (quest_get_slot, ":home_center", "qst_bring_back_runaway_serfs", slot_quest_object_center),
                                        (neq, ":home_center", ":cur_ai_object")],
   "Good day {sir/madam}. We were heading back to {s5}, but I am afraid we lost our way.", "runaway_serf_talk_caught",[]],

  [anyone|plyr,"runaway_serf_talk_caught", [], "Do not test my patience. You are going back now!", "runaway_serf_go_back",[]],
  [anyone|plyr,"runaway_serf_talk_caught", [], "Well, if you are that eager to go, then go.", "runaway_serf_let_go",
   [(quest_get_slot, ":quest_object_center", "qst_bring_back_runaway_serfs", slot_quest_object_center),
    (call_script, "script_change_player_relation_with_center", ":quest_object_center", 1)]],
  
  [party_tpl|pt_runaway_serfs,"start",
   [(quest_get_slot, ":home_center", "qst_bring_back_runaway_serfs", slot_quest_object_center),
    (str_store_party_name, s5, ":home_center")], "We are on our way back to {s5} {sir/madam}.", "runaway_serf_talk_again_return",[]],
  
  [anyone|plyr,"runaway_serf_talk_again_return", [], "Make haste now. The sooner you return the better.", "runaway_serf_talk_again_return_2",[]],
  [anyone|plyr,"runaway_serf_talk_again_return", [], "Good. Keep going.", "runaway_serf_talk_again_return_2",[]],
  
  [anyone|plyr,"runaway_serf_talk_again_return_2", [], "Yes {sir/madam}. As you wish.", "close_window",[(assign, "$g_leave_encounter",1)]],
  

  
#Quest bandits
  [anyone,"start", [
  (check_quest_active, "qst_track_down_bandits"),
  (quest_slot_eq, "qst_track_down_bandits", slot_quest_target_party, "$g_encountered_party"),
  (neg|is_between, "$g_encountered_party_faction", kingdoms_begin, kingdoms_end), #ie, the party has not respawned as a non-bandit
  ],
   "This must be your unlucky day, mate. We're just about the worst people you could run into, in these parts.", "troublesome_bandits_intro_1",[
   ]],
 
 [anyone|plyr,"troublesome_bandits_intro_1", [],
   "Heh. For me, you are nothing more than walking money bags.\
 A merchant in {s1} offered me good money for your heads.",
   "troublesome_bandits_intro_2", [(quest_get_slot, ":quest_giver_center", "qst_track_down_bandits", slot_quest_giver_center),
                                   (str_store_party_name, s1, ":quest_giver_center")
                                   ]],
  [anyone,"troublesome_bandits_intro_2", [],
   "A bounty hunter! Kill {him/her}! Kill {him/her} now!", "close_window",[
   (encounter_attack)]],  
  

#Deserters
  [party_tpl|pt_deserters, "start", [(eq,"$talk_context",tc_party_encounter),
                                     (party_get_slot,":protected_until_hours", "$g_encountered_party",slot_party_ignore_player_until),
                                     (store_current_hours,":cur_hours"),
                                     (store_sub, ":protection_remaining",":protected_until_hours",":cur_hours"),
                                     (gt, ":protection_remaining", 0)], "What do you want?\
 You want to pay us some more money?", "deserter_paid_talk",[]],
  [anyone|plyr,"deserter_paid_talk", [], "Sorry to trouble you. I'll be on my way now.", "deserter_paid_talk_2a",[]],
  [anyone,"deserter_paid_talk_2a", [], "Yeah. Stop fooling around and go make some money.\
 I want to see that purse full next time I see you.", "close_window",[(assign, "$g_leave_encounter",1)]],
  [anyone|plyr,"deserter_paid_talk", [], "No. It's your turn to pay me this time.", "deserter_paid_talk_2b",[]],
  [anyone,"deserter_paid_talk_2b", [], "What nonsense are you talking about? You want trouble? You got it.", "close_window",[
       (party_set_slot,"$g_encountered_party",slot_party_ignore_player_until,0),
       (party_ignore_player, "$g_encountered_party", 0),
    ]],

  
  [party_tpl|pt_deserters,"start", [
      (eq,"$talk_context",tc_party_encounter)
                    ], "We are the free brothers.\
 We will fight only for ourselves from now on.\
 Now give us your gold or taste our steel.", "deserter_talk",[]],
##  [anyone|plyr,"deserter_talk", [(check_quest_active, "qst_bring_back_deserters"),
##                                 (quest_get_slot, ":target_deserter_troop", "qst_bring_back_deserters", slot_quest_target_troop),
##                                 (party_count_members_of_type, ":num_deserters", "$g_encountered_party",":target_deserter_troop"),
##                                 (gt, ":num_deserters", 1)],
##   "If you surrender to me now, you will rejoin the army of your kingdom without being punished. Otherwise you'll get a taste of my sword.", "deserter_join_as_prisoner",[]],
  [anyone|plyr,"deserter_talk", [], "When I'm done with you, you'll regret ever leaving your army.", "close_window",[]],
  [anyone|plyr,"deserter_talk", [], "There's no need to fight. I am ready to pay for free passage.", "deserter_barter",[]],

##  [anyone,"deserter_join_as_prisoner", [(call_script, "script_party_calculate_strength", "p_main_party"),
##                                        (assign, ":player_strength", reg0),
##                                        (store_encountered_party,":encountered_party"),
##                                        (call_script, "script_party_calculate_strength", ":encountered_party"),
##                                        (assign, ":enemy_strength", reg0),
##                                        (val_mul, ":enemy_strength", 2),
##                                        (ge, ":player_strength", ":enemy_strength")],
##   "All right we join you then.", "close_window",[(assign, "$g_enemy_surrenders", 1)]],
##  [anyone,"deserter_join_as_prisoner", [], "TODO: We will never surrender!", "close_window",[(encounter_attack)]],

  [anyone,"deserter_barter", [], "Good. You are clever. Now, having a look at your baggage, I reckon a fellow like you could pretty easily afford {reg5} denars. We wouldn't want to be too greedy, now would we? Pay us, and then you can go.", "deserter_barter_2",[
    (store_troop_gold, ":total_value", "trp_player"),
    (troop_get_inventory_capacity, ":inv_size", "trp_player"),
    (try_for_range, ":i_slot", 0, ":inv_size"),
         (troop_get_inventory_slot, ":item_id", "trp_player", ":i_slot"),
         (ge, ":item_id", 0),
         (try_begin),
           (is_between, ":item_id", trade_goods_begin, trade_goods_end),
           (store_item_value, ":item_value", ":item_id"),
           (val_add, ":total_value", ":item_value"),
         (try_end),
    (try_end),
    (store_div, "$g_tribute_amount", ":total_value", 10), #10000 gold = excellent_target
    (val_max, "$g_tribute_amount", 10),
    (assign,reg(5),"$g_tribute_amount")]],
  [anyone|plyr,"deserter_barter_2", [(store_troop_gold,reg(2)),(ge,reg(2),"$g_tribute_amount"),(assign,reg(5),"$g_tribute_amount")],
   "All right here's your {reg5} denars.", "deserter_barter_3a",[(troop_remove_gold, "trp_player","$g_tribute_amount")]],
  [anyone|plyr,"deserter_barter_2", [],
   "I don't have that much money with me", "deserter_barter_3b",[]],
  [anyone,"deserter_barter_3b", [],
   "Too bad. Then we'll have to sell you to the slavers.", "close_window",[]],


  [anyone,"deserter_barter_3a", [], "Heh. That wasn't difficult, now, was it? All right. Go now.", "close_window",[
    (store_current_hours,":protected_until"),
    (val_add, ":protected_until", 72),
    (party_set_slot,"$g_encountered_party",slot_party_ignore_player_until,":protected_until"),
    (party_ignore_player, "$g_encountered_party", 72),
      
    (assign, "$g_leave_encounter",1)
    ]],

##### TODO: QUESTS COMMENT OUT END

#Tavernkeepers

  [anyone ,"start", [(store_conversation_troop,reg(1)),(ge,reg(1),tavernkeepers_begin),(lt,reg(1),tavernkeepers_end)],
   "Good day dear {sir/madam}. How can I help you?", "tavernkeeper_talk",
   [
#    (store_encountered_party,reg(2)),
#    (party_get_slot,"$tavernkeeper_party",reg(2),slot_town_mercs),
    ]],
  
  [anyone,"tavernkeeper_pretalk", [], "Anything else?", "tavernkeeper_talk",[]],

  [anyone|plyr,"tavernkeeper_talk", [(check_quest_active,"qst_deliver_wine"),
                                     (quest_slot_eq, "qst_deliver_wine", slot_quest_target_center, "$g_encountered_party"),
                                     (quest_get_slot, ":quest_target_item", "qst_deliver_wine", slot_quest_target_item),
                                     (quest_get_slot, ":quest_target_amount", "qst_deliver_wine", slot_quest_target_amount),
                                     (store_item_kind_count, ":item_count", ":quest_target_item"),
                                     (ge, ":item_count", ":quest_target_amount"),
                                     (assign, reg9, ":quest_target_amount"),
                                     (str_store_item_name, s4, ":quest_target_item"),
                                     ],
   "I was told to deliver you {reg9} units of {s