"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCopySnapshotPresignedUrlPlugin = exports.copySnapshotPresignedUrlMiddlewareOptions = exports.copySnapshotPresignedUrlMiddleware = void 0;
const middleware_endpoint_1 = require("@aws-sdk/middleware-endpoint");
const protocol_http_1 = require("@aws-sdk/protocol-http");
const signature_v4_1 = require("@aws-sdk/signature-v4");
const util_format_url_1 = require("@aws-sdk/util-format-url");
const version = "2016-11-15";
function copySnapshotPresignedUrlMiddleware(options) {
    return (next, context) => async (args) => {
        const { input } = args;
        if (!input.PresignedUrl) {
            const region = await options.region();
            const resolvedEndpoint = typeof options.endpoint === "function" ? await options.endpoint() : (0, middleware_endpoint_1.toEndpointV1)(context.endpointV2);
            if (typeof options.regionInfoProvider === "function") {
                const regionInfo = await options.regionInfoProvider(input.SourceRegion);
                resolvedEndpoint.hostname = (regionInfo === null || regionInfo === void 0 ? void 0 : regionInfo.hostname) || `ec2.${input.SourceRegion}.amazonaws.com`;
            }
            else {
                resolvedEndpoint.hostname = `ec2.${input.SourceRegion}.amazonaws.com`;
            }
            const request = new protocol_http_1.HttpRequest({
                ...resolvedEndpoint,
                protocol: "https",
                headers: {
                    host: resolvedEndpoint.hostname,
                },
                query: {
                    Action: "CopySnapshot",
                    Version: version,
                    SourceRegion: input.SourceRegion,
                    SourceSnapshotId: input.SourceSnapshotId,
                    DestinationRegion: region,
                },
            });
            const signer = new signature_v4_1.SignatureV4({
                credentials: options.credentials,
                region: input.SourceRegion,
                service: "ec2",
                sha256: options.sha256,
                uriEscapePath: options.signingEscapePath,
            });
            const presignedRequest = await signer.presign(request, {
                expiresIn: 3600,
            });
            args = {
                ...args,
                input: {
                    ...args.input,
                    DestinationRegion: region,
                    PresignedUrl: (0, util_format_url_1.formatUrl)(presignedRequest),
                },
            };
        }
        return next(args);
    };
}
exports.copySnapshotPresignedUrlMiddleware = copySnapshotPresignedUrlMiddleware;
exports.copySnapshotPresignedUrlMiddlewareOptions = {
    step: "serialize",
    tags: ["CROSS_REGION_PRESIGNED_URL"],
    name: "crossRegionPresignedUrlMiddleware",
    override: true,
    relation: "after",
    toMiddleware: "endpointV2Middleware",
};
const getCopySnapshotPresignedUrlPlugin = (config) => ({
    applyToStack: (clientStack) => {
        clientStack.add(copySnapshotPresignedUrlMiddleware(config), exports.copySnapshotPresignedUrlMiddlewareOptions);
    },
});
exports.getCopySnapshotPresignedUrlPlugin = getCopySnapshotPresignedUrlPlugin;
