import { ExceptionOptionType as __ExceptionOptionType } from "@aws-sdk/smithy-client";
import { IAMServiceException as __BaseException } from "./IAMServiceException";
export declare enum AccessAdvisorUsageGranularityType {
  ACTION_LEVEL = "ACTION_LEVEL",
  SERVICE_LEVEL = "SERVICE_LEVEL",
}
export interface AccessDetail {
  ServiceName: string | undefined;
  ServiceNamespace: string | undefined;
  Region?: string;
  EntityPath?: string;
  LastAuthenticatedTime?: Date;
  TotalAuthenticatedEntities?: number;
}
export declare enum StatusType {
  Active = "Active",
  Inactive = "Inactive",
}
export interface AccessKey {
  UserName: string | undefined;
  AccessKeyId: string | undefined;
  Status: StatusType | string | undefined;
  SecretAccessKey: string | undefined;
  CreateDate?: Date;
}
export interface AccessKeyLastUsed {
  LastUsedDate: Date | undefined;
  ServiceName: string | undefined;
  Region: string | undefined;
}
export interface AccessKeyMetadata {
  UserName?: string;
  AccessKeyId?: string;
  Status?: StatusType | string;
  CreateDate?: Date;
}
export interface AddClientIDToOpenIDConnectProviderRequest {
  OpenIDConnectProviderArn: string | undefined;
  ClientID: string | undefined;
}
export declare class InvalidInputException extends __BaseException {
  readonly name: "InvalidInputException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidInputException, __BaseException>
  );
}
export declare class LimitExceededException extends __BaseException {
  readonly name: "LimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<LimitExceededException, __BaseException>
  );
}
export declare class NoSuchEntityException extends __BaseException {
  readonly name: "NoSuchEntityException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<NoSuchEntityException, __BaseException>
  );
}
export declare class ServiceFailureException extends __BaseException {
  readonly name: "ServiceFailureException";
  readonly $fault: "server";
  constructor(
    opts: __ExceptionOptionType<ServiceFailureException, __BaseException>
  );
}
export interface AddRoleToInstanceProfileRequest {
  InstanceProfileName: string | undefined;
  RoleName: string | undefined;
}
export declare class EntityAlreadyExistsException extends __BaseException {
  readonly name: "EntityAlreadyExistsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<EntityAlreadyExistsException, __BaseException>
  );
}
export declare class UnmodifiableEntityException extends __BaseException {
  readonly name: "UnmodifiableEntityException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<UnmodifiableEntityException, __BaseException>
  );
}
export interface AddUserToGroupRequest {
  GroupName: string | undefined;
  UserName: string | undefined;
}
export declare enum AssignmentStatusType {
  Any = "Any",
  Assigned = "Assigned",
  Unassigned = "Unassigned",
}
export declare enum PermissionsBoundaryAttachmentType {
  Policy = "PermissionsBoundaryPolicy",
}
export interface AttachedPermissionsBoundary {
  PermissionsBoundaryType?: PermissionsBoundaryAttachmentType | string;
  PermissionsBoundaryArn?: string;
}
export interface AttachedPolicy {
  PolicyName?: string;
  PolicyArn?: string;
}
export interface AttachGroupPolicyRequest {
  GroupName: string | undefined;
  PolicyArn: string | undefined;
}
export declare class PolicyNotAttachableException extends __BaseException {
  readonly name: "PolicyNotAttachableException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<PolicyNotAttachableException, __BaseException>
  );
}
export interface AttachRolePolicyRequest {
  RoleName: string | undefined;
  PolicyArn: string | undefined;
}
export interface AttachUserPolicyRequest {
  UserName: string | undefined;
  PolicyArn: string | undefined;
}
export interface ChangePasswordRequest {
  OldPassword: string | undefined;
  NewPassword: string | undefined;
}
export declare class EntityTemporarilyUnmodifiableException extends __BaseException {
  readonly name: "EntityTemporarilyUnmodifiableException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      EntityTemporarilyUnmodifiableException,
      __BaseException
    >
  );
}
export declare class InvalidUserTypeException extends __BaseException {
  readonly name: "InvalidUserTypeException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidUserTypeException, __BaseException>
  );
}
export declare class PasswordPolicyViolationException extends __BaseException {
  readonly name: "PasswordPolicyViolationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      PasswordPolicyViolationException,
      __BaseException
    >
  );
}
export interface CreateAccessKeyRequest {
  UserName?: string;
}
export interface CreateAccessKeyResponse {
  AccessKey: AccessKey | undefined;
}
export interface CreateAccountAliasRequest {
  AccountAlias: string | undefined;
}
export interface CreateGroupRequest {
  Path?: string;
  GroupName: string | undefined;
}
export interface Group {
  Path: string | undefined;
  GroupName: string | undefined;
  GroupId: string | undefined;
  Arn: string | undefined;
  CreateDate: Date | undefined;
}
export interface CreateGroupResponse {
  Group: Group | undefined;
}
export declare class ConcurrentModificationException extends __BaseException {
  readonly name: "ConcurrentModificationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ConcurrentModificationException,
      __BaseException
    >
  );
}
export interface Tag {
  Key: string | undefined;
  Value: string | undefined;
}
export interface CreateInstanceProfileRequest {
  InstanceProfileName: string | undefined;
  Path?: string;
  Tags?: Tag[];
}
export interface RoleLastUsed {
  LastUsedDate?: Date;
  Region?: string;
}
export interface Role {
  Path: string | undefined;
  RoleName: string | undefined;
  RoleId: string | undefined;
  Arn: string | undefined;
  CreateDate: Date | undefined;
  AssumeRolePolicyDocument?: string;
  Description?: string;
  MaxSessionDuration?: number;
  PermissionsBoundary?: AttachedPermissionsBoundary;
  Tags?: Tag[];
  RoleLastUsed?: RoleLastUsed;
}
export interface InstanceProfile {
  Path: string | undefined;
  InstanceProfileName: string | undefined;
  InstanceProfileId: string | undefined;
  Arn: string | undefined;
  CreateDate: Date | undefined;
  Roles: Role[] | undefined;
  Tags?: Tag[];
}
export interface CreateInstanceProfileResponse {
  InstanceProfile: InstanceProfile | undefined;
}
export interface CreateLoginProfileRequest {
  UserName: string | undefined;
  Password: string | undefined;
  PasswordResetRequired?: boolean;
}
export interface LoginProfile {
  UserName: string | undefined;
  CreateDate: Date | undefined;
  PasswordResetRequired?: boolean;
}
export interface CreateLoginProfileResponse {
  LoginProfile: LoginProfile | undefined;
}
export interface CreateOpenIDConnectProviderRequest {
  Url: string | undefined;
  ClientIDList?: string[];
  ThumbprintList: string[] | undefined;
  Tags?: Tag[];
}
export interface CreateOpenIDConnectProviderResponse {
  OpenIDConnectProviderArn?: string;
  Tags?: Tag[];
}
export interface CreatePolicyRequest {
  PolicyName: string | undefined;
  Path?: string;
  PolicyDocument: string | undefined;
  Description?: string;
  Tags?: Tag[];
}
export interface Policy {
  PolicyName?: string;
  PolicyId?: string;
  Arn?: string;
  Path?: string;
  DefaultVersionId?: string;
  AttachmentCount?: number;
  PermissionsBoundaryUsageCount?: number;
  IsAttachable?: boolean;
  Description?: string;
  CreateDate?: Date;
  UpdateDate?: Date;
  Tags?: Tag[];
}
export interface CreatePolicyResponse {
  Policy?: Policy;
}
export declare class MalformedPolicyDocumentException extends __BaseException {
  readonly name: "MalformedPolicyDocumentException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      MalformedPolicyDocumentException,
      __BaseException
    >
  );
}
export interface CreatePolicyVersionRequest {
  PolicyArn: string | undefined;
  PolicyDocument: string | undefined;
  SetAsDefault?: boolean;
}
export interface PolicyVersion {
  Document?: string;
  VersionId?: string;
  IsDefaultVersion?: boolean;
  CreateDate?: Date;
}
export interface CreatePolicyVersionResponse {
  PolicyVersion?: PolicyVersion;
}
export interface CreateRoleRequest {
  Path?: string;
  RoleName: string | undefined;
  AssumeRolePolicyDocument: string | undefined;
  Description?: string;
  MaxSessionDuration?: number;
  PermissionsBoundary?: string;
  Tags?: Tag[];
}
export interface CreateRoleResponse {
  Role: Role | undefined;
}
export interface CreateSAMLProviderRequest {
  SAMLMetadataDocument: string | undefined;
  Name: string | undefined;
  Tags?: Tag[];
}
export interface CreateSAMLProviderResponse {
  SAMLProviderArn?: string;
  Tags?: Tag[];
}
export interface CreateServiceLinkedRoleRequest {
  AWSServiceName: string | undefined;
  Description?: string;
  CustomSuffix?: string;
}
export interface CreateServiceLinkedRoleResponse {
  Role?: Role;
}
export interface CreateServiceSpecificCredentialRequest {
  UserName: string | undefined;
  ServiceName: string | undefined;
}
export interface ServiceSpecificCredential {
  CreateDate: Date | undefined;
  ServiceName: string | undefined;
  ServiceUserName: string | undefined;
  ServicePassword: string | undefined;
  ServiceSpecificCredentialId: string | undefined;
  UserName: string | undefined;
  Status: StatusType | string | undefined;
}
export interface CreateServiceSpecificCredentialResponse {
  ServiceSpecificCredential?: ServiceSpecificCredential;
}
export declare class ServiceNotSupportedException extends __BaseException {
  readonly name: "ServiceNotSupportedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ServiceNotSupportedException, __BaseException>
  );
}
export interface CreateUserRequest {
  Path?: string;
  UserName: string | undefined;
  PermissionsBoundary?: string;
  Tags?: Tag[];
}
export interface User {
  Path: string | undefined;
  UserName: string | undefined;
  UserId: string | undefined;
  Arn: string | undefined;
  CreateDate: Date | undefined;
  PasswordLastUsed?: Date;
  PermissionsBoundary?: AttachedPermissionsBoundary;
  Tags?: Tag[];
}
export interface CreateUserResponse {
  User?: User;
}
export interface CreateVirtualMFADeviceRequest {
  Path?: string;
  VirtualMFADeviceName: string | undefined;
  Tags?: Tag[];
}
export interface VirtualMFADevice {
  SerialNumber: string | undefined;
  Base32StringSeed?: Uint8Array;
  QRCodePNG?: Uint8Array;
  User?: User;
  EnableDate?: Date;
  Tags?: Tag[];
}
export interface CreateVirtualMFADeviceResponse {
  VirtualMFADevice: VirtualMFADevice | undefined;
}
export interface DeactivateMFADeviceRequest {
  UserName: string | undefined;
  SerialNumber: string | undefined;
}
export interface DeleteAccessKeyRequest {
  UserName?: string;
  AccessKeyId: string | undefined;
}
export interface DeleteAccountAliasRequest {
  AccountAlias: string | undefined;
}
export declare class DeleteConflictException extends __BaseException {
  readonly name: "DeleteConflictException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DeleteConflictException, __BaseException>
  );
}
export interface DeleteGroupRequest {
  GroupName: string | undefined;
}
export interface DeleteGroupPolicyRequest {
  GroupName: string | undefined;
  PolicyName: string | undefined;
}
export interface DeleteInstanceProfileRequest {
  InstanceProfileName: string | undefined;
}
export interface DeleteLoginProfileRequest {
  UserName: string | undefined;
}
export interface DeleteOpenIDConnectProviderRequest {
  OpenIDConnectProviderArn: string | undefined;
}
export interface DeletePolicyRequest {
  PolicyArn: string | undefined;
}
export interface DeletePolicyVersionRequest {
  PolicyArn: string | undefined;
  VersionId: string | undefined;
}
export interface DeleteRoleRequest {
  RoleName: string | undefined;
}
export interface DeleteRolePermissionsBoundaryRequest {
  RoleName: string | undefined;
}
export interface DeleteRolePolicyRequest {
  RoleName: string | undefined;
  PolicyName: string | undefined;
}
export interface DeleteSAMLProviderRequest {
  SAMLProviderArn: string | undefined;
}
export interface DeleteServerCertificateRequest {
  ServerCertificateName: string | undefined;
}
export interface DeleteServiceLinkedRoleRequest {
  RoleName: string | undefined;
}
export interface DeleteServiceLinkedRoleResponse {
  DeletionTaskId: string | undefined;
}
export interface DeleteServiceSpecificCredentialRequest {
  UserName?: string;
  ServiceSpecificCredentialId: string | undefined;
}
export interface DeleteSigningCertificateRequest {
  UserName?: string;
  CertificateId: string | undefined;
}
export interface DeleteSSHPublicKeyRequest {
  UserName: string | undefined;
  SSHPublicKeyId: string | undefined;
}
export interface DeleteUserRequest {
  UserName: string | undefined;
}
export interface DeleteUserPermissionsBoundaryRequest {
  UserName: string | undefined;
}
export interface DeleteUserPolicyRequest {
  UserName: string | undefined;
  PolicyName: string | undefined;
}
export interface DeleteVirtualMFADeviceRequest {
  SerialNumber: string | undefined;
}
export interface DetachGroupPolicyRequest {
  GroupName: string | undefined;
  PolicyArn: string | undefined;
}
export interface DetachRolePolicyRequest {
  RoleName: string | undefined;
  PolicyArn: string | undefined;
}
export interface DetachUserPolicyRequest {
  UserName: string | undefined;
  PolicyArn: string | undefined;
}
export interface EnableMFADeviceRequest {
  UserName: string | undefined;
  SerialNumber: string | undefined;
  AuthenticationCode1: string | undefined;
  AuthenticationCode2: string | undefined;
}
export declare class InvalidAuthenticationCodeException extends __BaseException {
  readonly name: "InvalidAuthenticationCodeException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidAuthenticationCodeException,
      __BaseException
    >
  );
}
export declare enum ReportStateType {
  COMPLETE = "COMPLETE",
  INPROGRESS = "INPROGRESS",
  STARTED = "STARTED",
}
export interface GenerateCredentialReportResponse {
  State?: ReportStateType | string;
  Description?: string;
}
export interface GenerateOrganizationsAccessReportRequest {
  EntityPath: string | undefined;
  OrganizationsPolicyId?: string;
}
export interface GenerateOrganizationsAccessReportResponse {
  JobId?: string;
}
export declare class ReportGenerationLimitExceededException extends __BaseException {
  readonly name: "ReportGenerationLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ReportGenerationLimitExceededException,
      __BaseException
    >
  );
}
export interface GenerateServiceLastAccessedDetailsRequest {
  Arn: string | undefined;
  Granularity?: AccessAdvisorUsageGranularityType | string;
}
export interface GenerateServiceLastAccessedDetailsResponse {
  JobId?: string;
}
export interface GetAccessKeyLastUsedRequest {
  AccessKeyId: string | undefined;
}
export interface GetAccessKeyLastUsedResponse {
  UserName?: string;
  AccessKeyLastUsed?: AccessKeyLastUsed;
}
export declare enum EntityType {
  AWSManagedPolicy = "AWSManagedPolicy",
  Group = "Group",
  LocalManagedPolicy = "LocalManagedPolicy",
  Role = "Role",
  User = "User",
}
export interface GetAccountAuthorizationDetailsRequest {
  Filter?: (EntityType | string)[];
  MaxItems?: number;
  Marker?: string;
}
export interface PolicyDetail {
  PolicyName?: string;
  PolicyDocument?: string;
}
export interface GroupDetail {
  Path?: string;
  GroupName?: string;
  GroupId?: string;
  Arn?: string;
  CreateDate?: Date;
  GroupPolicyList?: PolicyDetail[];
  AttachedManagedPolicies?: AttachedPolicy[];
}
export interface ManagedPolicyDetail {
  PolicyName?: string;
  PolicyId?: string;
  Arn?: string;
  Path?: string;
  DefaultVersionId?: string;
  AttachmentCount?: number;
  PermissionsBoundaryUsageCount?: number;
  IsAttachable?: boolean;
  Description?: string;
  CreateDate?: Date;
  UpdateDate?: Date;
  PolicyVersionList?: PolicyVersion[];
}
export interface RoleDetail {
  Path?: string;
  RoleName?: string;
  RoleId?: string;
  Arn?: string;
  CreateDate?: Date;
  AssumeRolePolicyDocument?: string;
  InstanceProfileList?: InstanceProfile[];
  RolePolicyList?: PolicyDetail[];
  AttachedManagedPolicies?: AttachedPolicy[];
  PermissionsBoundary?: AttachedPermissionsBoundary;
  Tags?: Tag[];
  RoleLastUsed?: RoleLastUsed;
}
export interface UserDetail {
  Path?: string;
  UserName?: string;
  UserId?: string;
  Arn?: string;
  CreateDate?: Date;
  UserPolicyList?: PolicyDetail[];
  GroupList?: string[];
  AttachedManagedPolicies?: AttachedPolicy[];
  PermissionsBoundary?: AttachedPermissionsBoundary;
  Tags?: Tag[];
}
export interface GetAccountAuthorizationDetailsResponse {
  UserDetailList?: UserDetail[];
  GroupDetailList?: GroupDetail[];
  RoleDetailList?: RoleDetail[];
  Policies?: ManagedPolicyDetail[];
  IsTruncated?: boolean;
  Marker?: string;
}
export interface PasswordPolicy {
  MinimumPasswordLength?: number;
  RequireSymbols?: boolean;
  RequireNumbers?: boolean;
  RequireUppercaseCharacters?: boolean;
  RequireLowercaseCharacters?: boolean;
  AllowUsersToChangePassword?: boolean;
  ExpirePasswords?: boolean;
  MaxPasswordAge?: number;
  PasswordReusePrevention?: number;
  HardExpiry?: boolean;
}
export interface GetAccountPasswordPolicyResponse {
  PasswordPolicy: PasswordPolicy | undefined;
}
export declare enum SummaryKeyType {
  AccessKeysPerUserQuota = "AccessKeysPerUserQuota",
  AccountAccessKeysPresent = "AccountAccessKeysPresent",
  AccountMFAEnabled = "AccountMFAEnabled",
  AccountSigningCertificatesPresent = "AccountSigningCertificatesPresent",
  AttachedPoliciesPerGroupQuota = "AttachedPoliciesPerGroupQuota",
  AttachedPoliciesPerRoleQuota = "AttachedPoliciesPerRoleQuota",
  AttachedPoliciesPerUserQuota = "AttachedPoliciesPerUserQuota",
  GlobalEndpointTokenVersion = "GlobalEndpointTokenVersion",
  GroupPolicySizeQuota = "GroupPolicySizeQuota",
  Groups = "Groups",
  GroupsPerUserQuota = "GroupsPerUserQuota",
  GroupsQuota = "GroupsQuota",
  MFADevices = "MFADevices",
  MFADevicesInUse = "MFADevicesInUse",
  Policies = "Policies",
  PoliciesQuota = "PoliciesQuota",
  PolicySizeQuota = "PolicySizeQuota",
  PolicyVersionsInUse = "PolicyVersionsInUse",
  PolicyVersionsInUseQuota = "PolicyVersionsInUseQuota",
  ServerCertificates = "ServerCertificates",
  ServerCertificatesQuota = "ServerCertificatesQuota",
  SigningCertificatesPerUserQuota = "SigningCertificatesPerUserQuota",
  UserPolicySizeQuota = "UserPolicySizeQuota",
  Users = "Users",
  UsersQuota = "UsersQuota",
  VersionsPerPolicyQuota = "VersionsPerPolicyQuota",
}
export interface GetAccountSummaryResponse {
  SummaryMap?: Record<string, number>;
}
export interface GetContextKeysForCustomPolicyRequest {
  PolicyInputList: string[] | undefined;
}
export interface GetContextKeysForPolicyResponse {
  ContextKeyNames?: string[];
}
export interface GetContextKeysForPrincipalPolicyRequest {
  PolicySourceArn: string | undefined;
  PolicyInputList?: string[];
}
export declare class CredentialReportExpiredException extends __BaseException {
  readonly name: "CredentialReportExpiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      CredentialReportExpiredException,
      __BaseException
    >
  );
}
export declare class CredentialReportNotPresentException extends __BaseException {
  readonly name: "CredentialReportNotPresentException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      CredentialReportNotPresentException,
      __BaseException
    >
  );
}
export declare class CredentialReportNotReadyException extends __BaseException {
  readonly name: "CredentialReportNotReadyException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      CredentialReportNotReadyException,
      __BaseException
    >
  );
}
export declare enum ReportFormatType {
  text_csv = "text/csv",
}
export interface GetCredentialReportResponse {
  Content?: Uint8Array;
  ReportFormat?: ReportFormatType | string;
  GeneratedTime?: Date;
}
export interface GetGroupRequest {
  GroupName: string | undefined;
  Marker?: string;
  MaxItems?: number;
}
export interface GetGroupResponse {
  Group: Group | undefined;
  Users: User[] | undefined;
  IsTruncated?: boolean;
  Marker?: string;
}
export interface GetGroupPolicyRequest {
  GroupName: string | undefined;
  PolicyName: string | undefined;
}
export interface GetGroupPolicyResponse {
  GroupName: string | undefined;
  PolicyName: string | undefined;
  PolicyDocument: string | undefined;
}
export interface GetInstanceProfileRequest {
  InstanceProfileName: string | undefined;
}
export interface GetInstanceProfileResponse {
  InstanceProfile: InstanceProfile | undefined;
}
export interface GetLoginProfileRequest {
  UserName: string | undefined;
}
export interface GetLoginProfileResponse {
  LoginProfile: LoginProfile | undefined;
}
export interface GetOpenIDConnectProviderRequest {
  OpenIDConnectProviderArn: string | undefined;
}
export interface GetOpenIDConnectProviderResponse {
  Url?: string;
  ClientIDList?: string[];
  ThumbprintList?: string[];
  CreateDate?: Date;
  Tags?: Tag[];
}
export declare enum SortKeyType {
  LAST_AUTHENTICATED_TIME_ASCENDING = "LAST_AUTHENTICATED_TIME_ASCENDING",
  LAST_AUTHENTICATED_TIME_DESCENDING = "LAST_AUTHENTICATED_TIME_DESCENDING",
  SERVICE_NAMESPACE_ASCENDING = "SERVICE_NAMESPACE_ASCENDING",
  SERVICE_NAMESPACE_DESCENDING = "SERVICE_NAMESPACE_DESCENDING",
}
export interface GetOrganizationsAccessReportRequest {
  JobId: string | undefined;
  MaxItems?: number;
  Marker?: string;
  SortKey?: SortKeyType | string;
}
export interface ErrorDetails {
  Message: string | undefined;
  Code: string | undefined;
}
export declare enum JobStatusType {
  COMPLETED = "COMPLETED",
  FAILED = "FAILED",
  IN_PROGRESS = "IN_PROGRESS",
}
export interface GetOrganizationsAccessReportResponse {
  JobStatus: JobStatusType | string | undefined;
  JobCreationDate: Date | undefined;
  JobCompletionDate?: Date;
  NumberOfServicesAccessible?: number;
  NumberOfServicesNotAccessed?: number;
  AccessDetails?: AccessDetail[];
  IsTruncated?: boolean;
  Marker?: string;
  ErrorDetails?: ErrorDetails;
}
export interface GetPolicyRequest {
  PolicyArn: string | undefined;
}
export interface GetPolicyResponse {
  Policy?: Policy;
}
export interface GetPolicyVersionRequest {
  PolicyArn: string | undefined;
  VersionId: string | undefined;
}
export interface GetPolicyVersionResponse {
  PolicyVersion?: PolicyVersion;
}
export interface GetRoleRequest {
  RoleName: string | undefined;
}
export interface GetRoleResponse {
  Role: Role | undefined;
}
export interface GetRolePolicyRequest {
  RoleName: string | undefined;
  PolicyName: string | undefined;
}
export interface GetRolePolicyResponse {
  RoleName: string | undefined;
  PolicyName: string | undefined;
  PolicyDocument: string | undefined;
}
export interface GetSAMLProviderRequest {
  SAMLProviderArn: string | undefined;
}
export interface GetSAMLProviderResponse {
  SAMLMetadataDocument?: string;
  CreateDate?: Date;
  ValidUntil?: Date;
  Tags?: Tag[];
}
export interface GetServerCertificateRequest {
  ServerCertificateName: string | undefined;
}
export interface ServerCertificateMetadata {
  Path: string | undefined;
  ServerCertificateName: string | undefined;
  ServerCertificateId: string | undefined;
  Arn: string | undefined;
  UploadDate?: Date;
  Expiration?: Date;
}
export interface ServerCertificate {
  ServerCertificateMetadata: ServerCertificateMetadata | undefined;
  CertificateBody: string | undefined;
  CertificateChain?: string;
  Tags?: Tag[];
}
export interface GetServerCertificateResponse {
  ServerCertificate: ServerCertificate | undefined;
}
export interface GetServiceLastAccessedDetailsRequest {
  JobId: string | undefined;
  MaxItems?: number;
  Marker?: string;
}
export interface TrackedActionLastAccessed {
  ActionName?: string;
  LastAccessedEntity?: string;
  LastAccessedTime?: Date;
  LastAccessedRegion?: string;
}
export interface ServiceLastAccessed {
  ServiceName: string | undefined;
  LastAuthenticated?: Date;
  ServiceNamespace: string | undefined;
  LastAuthenticatedEntity?: string;
  LastAuthenticatedRegion?: string;
  TotalAuthenticatedEntities?: number;
  TrackedActionsLastAccessed?: TrackedActionLastAccessed[];
}
export interface GetServiceLastAccessedDetailsResponse {
  JobStatus: JobStatusType | string | undefined;
  JobType?: AccessAdvisorUsageGranularityType | string;
  JobCreationDate: Date | undefined;
  ServicesLastAccessed: ServiceLastAccessed[] | undefined;
  JobCompletionDate: Date | undefined;
  IsTruncated?: boolean;
  Marker?: string;
  Error?: ErrorDetails;
}
export interface GetServiceLastAccessedDetailsWithEntitiesRequest {
  JobId: string | undefined;
  ServiceNamespace: string | undefined;
  MaxItems?: number;
  Marker?: string;
}
export declare enum PolicyOwnerEntityType {
  GROUP = "GROUP",
  ROLE = "ROLE",
  USER = "USER",
}
export interface EntityInfo {
  Arn: string | undefined;
  Name: string | undefined;
  Type: PolicyOwnerEntityType | string | undefined;
  Id: string | undefined;
  Path?: string;
}
export interface EntityDetails {
  EntityInfo: EntityInfo | undefined;
  LastAuthenticated?: Date;
}
export interface GetServiceLastAccessedDetailsWithEntitiesResponse {
  JobStatus: JobStatusType | string | undefined;
  JobCreationDate: Date | undefined;
  JobCompletionDate: Date | undefined;
  EntityDetailsList: EntityDetails[] | undefined;
  IsTruncated?: boolean;
  Marker?: string;
  Error?: ErrorDetails;
}
export interface GetServiceLinkedRoleDeletionStatusRequest {
  DeletionTaskId: string | undefined;
}
export interface RoleUsageType {
  Region?: string;
  Resources?: string[];
}
export interface DeletionTaskFailureReasonType {
  Reason?: string;
  RoleUsageList?: RoleUsageType[];
}
export declare enum DeletionTaskStatusType {
  FAILED = "FAILED",
  IN_PROGRESS = "IN_PROGRESS",
  NOT_STARTED = "NOT_STARTED",
  SUCCEEDED = "SUCCEEDED",
}
export interface GetServiceLinkedRoleDeletionStatusResponse {
  Status: DeletionTaskStatusType | string | undefined;
  Reason?: DeletionTaskFailureReasonType;
}
export declare enum EncodingType {
  PEM = "PEM",
  SSH = "SSH",
}
export interface GetSSHPublicKeyRequest {
  UserName: string | undefined;
  SSHPublicKeyId: string | undefined;
  Encoding: EncodingType | string | undefined;
}
export interface SSHPublicKey {
  UserName: string | undefined;
  SSHPublicKeyId: string | undefined;
  Fingerprint: string | undefined;
  SSHPublicKeyBody: string | undefined;
  Status: StatusType | string | undefined;
  UploadDate?: Date;
}
export interface GetSSHPublicKeyResponse {
  SSHPublicKey?: SSHPublicKey;
}
export declare class UnrecognizedPublicKeyEncodingException extends __BaseException {
  readonly name: "UnrecognizedPublicKeyEncodingException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      UnrecognizedPublicKeyEncodingException,
      __BaseException
    >
  );
}
export interface GetUserRequest {
  UserName?: string;
}
export interface GetUserResponse {
  User: User | undefined;
}
export interface GetUserPolicyRequest {
  UserName: string | undefined;
  PolicyName: string | undefined;
}
export interface GetUserPolicyResponse {
  UserName: string | undefined;
  PolicyName: string | undefined;
  PolicyDocument: string | undefined;
}
export interface ListAccessKeysRequest {
  UserName?: string;
  Marker?: string;
  MaxItems?: number;
}
export interface ListAccessKeysResponse {
  AccessKeyMetadata: AccessKeyMetadata[] | undefined;
  IsTruncated?: boolean;
  Marker?: string;
}
export interface ListAccountAliasesRequest {
  Marker?: string;
  MaxItems?: number;
}
export interface ListAccountAliasesResponse {
  AccountAliases: string[] | undefined;
  IsTruncated?: boolean;
  Marker?: string;
}
export interface ListAttachedGroupPoliciesRequest {
  GroupName: string | undefined;
  PathPrefix?: string;
  Marker?: string;
  MaxItems?: number;
}
export interface ListAttachedGroupPoliciesResponse {
  AttachedPolicies?: AttachedPolicy[];
  IsTruncated?: boolean;
  Marker?: string;
}
export interface ListAttachedRolePoliciesRequest {
  RoleName: string | undefined;
  PathPrefix?: string;
  Marker?: string;
  MaxItems?: number;
}
export interface ListAttachedRolePoliciesResponse {
  AttachedPolicies?: AttachedPolicy[];
  IsTruncated?: boolean;
  Marker?: string;
}
export interface ListAttachedUserPoliciesRequest {
  UserName: string | undefined;
  PathPrefix?: string;
  Marker?: string;
  MaxItems?: number;
}
export interface ListAttachedUserPoliciesResponse {
  AttachedPolicies?: AttachedPolicy[];
  IsTruncated?: boolean;
  Marker?: string;
}
export declare enum PolicyUsageType {
  PermissionsBoundary = "PermissionsBoundary",
  PermissionsPolicy = "PermissionsPolicy",
}
export interface ListEntitiesForPolicyRequest {
  PolicyArn: string | undefined;
  EntityFilter?: EntityType | string;
  PathPrefix?: string;
  PolicyUsageFilter?: PolicyUsageType | string;
  Marker?: string;
  MaxItems?: number;
}
export interface PolicyGroup {
  GroupName?: string;
  GroupId?: string;
}
export interface PolicyRole {
  RoleName?: string;
  RoleId?: string;
}
export interface PolicyUser {
  UserName?: string;
  UserId?: string;
}
export interface ListEntitiesForPolicyResponse {
  PolicyGroups?: PolicyGroup[];
  PolicyUsers?: PolicyUser[];
  PolicyRoles?: PolicyRole[];
  IsTruncated?: boolean;
  Marker?: string;
}
export interface ListGroupPoliciesRequest {
  GroupName: string | undefined;
  Marker?: string;
  MaxItems?: number;
}
export interface ListGroupPoliciesResponse {
  PolicyNames: string[] | undefined;
  IsTruncated?: boolean;
  Marker?: string;
}
export interface ListGroupsRequest {
  PathPrefix?: string;
  Marker?: string;
  MaxItems?: number;
}
export interface ListGroupsResponse {
  Groups: Group[] | undefined;
  IsTruncated?: boolean;
  Marker?: string;
}
export interface ListGroupsForUserRequest {
  UserName: string | undefined;
  Marker?: string;
  MaxItems?: number;
}
export interface ListGroupsForUserResponse {
  Groups: Group[] | undefined;
  IsTruncated?: boolean;
  Marker?: string;
}
export interface ListInstanceProfilesRequest {
  PathPrefix?: string;
  Marker?: string;
  MaxItems?: number;
}
export interface ListInstanceProfilesResponse {
  InstanceProfiles: InstanceProfile[] | undefined;
  IsTruncated?: boolean;
  Marker?: string;
}
export interface ListInstanceProfilesForRoleRequest {
  RoleName: string | undefined;
  Marker?: string;
  MaxItems?: number;
}
export interface ListInstanceProfilesForRoleResponse {
  InstanceProfiles: InstanceProfile[] | undefined;
  IsTruncated?: boolean;
  Marker?: string;
}
export interface ListInstanceProfileTagsRequest {
  InstanceProfileName: string | undefined;
  Marker?: string;
  MaxItems?: number;
}
export interface ListInstanceProfileTagsResponse {
  Tags: Tag[] | undefined;
  IsTruncated?: boolean;
  Marker?: string;
}
export interface ListMFADevicesRequest {
  UserName?: string;
  Marker?: string;
  MaxItems?: number;
}
export interface MFADevice {
  UserName: string | undefined;
  SerialNumber: string | undefined;
  EnableDate: Date | undefined;
}
export interface ListMFADevicesResponse {
  MFADevices: MFADevice[] | undefined;
  IsTruncated?: boolean;
  Marker?: string;
}
export interface ListMFADeviceTagsRequest {
  SerialNumber: string | undefined;
  Marker?: string;
  MaxItems?: number;
}
export interface ListMFADeviceTagsResponse {
  Tags: Tag[] | undefined;
  IsTruncated?: boolean;
  Marker?: string;
}
export interface ListOpenIDConnectProvidersRequest {}
export interface OpenIDConnectProviderListEntry {
  Arn?: string;
}
export interface ListOpenIDConnectProvidersResponse {
  OpenIDConnectProviderList?: OpenIDConnectProviderListEntry[];
}
export interface ListOpenIDConnectProviderTagsRequest {
  OpenIDConnectProviderArn: string | undefined;
  Marker?: string;
  MaxItems?: number;
}
export interface ListOpenIDConnectProviderTagsResponse {
  Tags: Tag[] | undefined;
  IsTruncated?: boolean;
  Marker?: string;
}
export declare enum PolicyScopeType {
  AWS = "AWS",
  All = "All",
  Local = "Local",
}
export interface ListPoliciesRequest {
  Scope?: PolicyScopeType | string;
  OnlyAttached?: boolean;
  PathPrefix?: string;
  PolicyUsageFilter?: PolicyUsageType | string;
  Marker?: string;
  MaxItems?: number;
}
export interface ListPoliciesResponse {
  Policies?: Policy[];
  IsTruncated?: boolean;
  Marker?: string;
}
export interface ListPoliciesGrantingServiceAccessRequest {
  Marker?: string;
  Arn: string | undefined;
  ServiceNamespaces: string[] | undefined;
}
export declare enum PolicyType {
  INLINE = "INLINE",
  MANAGED = "MANAGED",
}
export interface PolicyGrantingServiceAccess {
  PolicyName: string | undefined;
  PolicyType: PolicyType | string | undefined;
  PolicyArn?: string;
  EntityType?: PolicyOwnerEntityType | string;
  EntityName?: string;
}
export interface ListPoliciesGrantingServiceAccessEntry {
  ServiceNamespace?: string;
  Policies?: PolicyGrantingServiceAccess[];
}
export interface ListPoliciesGrantingServiceAccessResponse {
  PoliciesGrantingServiceAccess:
    | ListPoliciesGrantingServiceAccessEntry[]
    | undefined;
  IsTruncated?: boolean;
  Marker?: string;
}
export interface ListPolicyTagsRequest {
  PolicyArn: string | undefined;
  Marker?: string;
  MaxItems?: number;
}
export interface ListPolicyTagsResponse {
  Tags: Tag[] | undefined;
  IsTruncated?: boolean;
  Marker?: string;
}
export interface ListPolicyVersionsRequest {
  PolicyArn: string | undefined;
  Marker?: string;
  MaxItems?: number;
}
export interface ListPolicyVersionsResponse {
  Versions?: PolicyVersion[];
  IsTruncated?: boolean;
  Marker?: string;
}
export interface ListRolePoliciesRequest {
  RoleName: string | undefined;
  Marker?: string;
  MaxItems?: number;
}
export interface ListRolePoliciesResponse {
  PolicyNames: string[] | undefined;
  IsTruncated?: boolean;
  Marker?: string;
}
export interface ListRolesRequest {
  PathPrefix?: string;
  Marker?: string;
  MaxItems?: number;
}
export interface ListRolesResponse {
  Roles: Role[] | undefined;
  IsTruncated?: boolean;
  Marker?: string;
}
export interface ListRoleTagsRequest {
  RoleName: string | undefined;
  Marker?: string;
  MaxItems?: number;
}
export interface ListRoleTagsResponse {
  Tags: Tag[] | undefined;
  IsTruncated?: boolean;
  Marker?: string;
}
export interface ListSAMLProvidersRequest {}
export interface SAMLProviderListEntry {
  Arn?: string;
  ValidUntil?: Date;
  CreateDate?: Date;
}
export interface ListSAMLProvidersResponse {
  SAMLProviderList?: SAMLProviderListEntry[];
}
export interface ListSAMLProviderTagsRequest {
  SAMLProviderArn: string | undefined;
  Marker?: string;
  MaxItems?: number;
}
export interface ListSAMLProviderTagsResponse {
  Tags: Tag[] | undefined;
  IsTruncated?: boolean;
  Marker?: string;
}
export interface ListServerCertificatesRequest {
  PathPrefix?: string;
  Marker?: string;
  MaxItems?: number;
}
export interface ListServerCertificatesResponse {
  ServerCertificateMetadataList: ServerCertificateMetadata[] | undefined;
  IsTruncated?: boolean;
  Marker?: string;
}
export interface ListServerCertificateTagsRequest {
  ServerCertificateName: string | undefined;
  Marker?: string;
  MaxItems?: number;
}
export interface ListServerCertificateTagsResponse {
  Tags: Tag[] | undefined;
  IsTruncated?: boolean;
  Marker?: string;
}
export interface ListServiceSpecificCredentialsRequest {
  UserName?: string;
  ServiceName?: string;
}
export interface ServiceSpecificCredentialMetadata {
  UserName: string | undefined;
  Status: StatusType | string | undefined;
  ServiceUserName: string | undefined;
  CreateDate: Date | undefined;
  ServiceSpecificCredentialId: string | undefined;
  ServiceName: string | undefined;
}
export interface ListServiceSpecificCredentialsResponse {
  ServiceSpecificCredentials?: ServiceSpecificCredentialMetadata[];
}
export interface ListSigningCertificatesRequest {
  UserName?: string;
  Marker?: string;
  MaxItems?: number;
}
export interface SigningCertificate {
  UserName: string | undefined;
  CertificateId: string | undefined;
  CertificateBody: string | undefined;
  Status: StatusType | string | undefined;
  UploadDate?: Date;
}
export interface ListSigningCertificatesResponse {
  Certificates: SigningCertificate[] | undefined;
  IsTruncated?: boolean;
  Marker?: string;
}
export interface ListSSHPublicKeysRequest {
  UserName?: string;
  Marker?: string;
  MaxItems?: number;
}
export interface SSHPublicKeyMetadata {
  UserName: string | undefined;
  SSHPublicKeyId: string | undefined;
  Status: StatusType | string | undefined;
  UploadDate: Date | undefined;
}
export interface ListSSHPublicKeysResponse {
  SSHPublicKeys?: SSHPublicKeyMetadata[];
  IsTruncated?: boolean;
  Marker?: string;
}
export interface ListUserPoliciesRequest {
  UserName: string | undefined;
  Marker?: string;
  MaxItems?: number;
}
export interface ListUserPoliciesResponse {
  PolicyNames: string[] | undefined;
  IsTruncated?: boolean;
  Marker?: string;
}
export interface ListUsersRequest {
  PathPrefix?: string;
  Marker?: string;
  MaxItems?: number;
}
export interface ListUsersResponse {
  Users: User[] | undefined;
  IsTruncated?: boolean;
  Marker?: string;
}
export interface ListUserTagsRequest {
  UserName: string | undefined;
  Marker?: string;
  MaxItems?: number;
}
export interface ListUserTagsResponse {
  Tags: Tag[] | undefined;
  IsTruncated?: boolean;
  Marker?: string;
}
export interface ListVirtualMFADevicesRequest {
  AssignmentStatus?: AssignmentStatusType | string;
  Marker?: string;
  MaxItems?: number;
}
export interface ListVirtualMFADevicesResponse {
  VirtualMFADevices: VirtualMFADevice[] | undefined;
  IsTruncated?: boolean;
  Marker?: string;
}
export interface PutGroupPolicyRequest {
  GroupName: string | undefined;
  PolicyName: string | undefined;
  PolicyDocument: string | undefined;
}
export interface PutRolePermissionsBoundaryRequest {
  RoleName: string | undefined;
  PermissionsBoundary: string | undefined;
}
export interface PutRolePolicyRequest {
  RoleName: string | undefined;
  PolicyName: string | undefined;
  PolicyDocument: string | undefined;
}
export interface PutUserPermissionsBoundaryRequest {
  UserName: string | undefined;
  PermissionsBoundary: string | undefined;
}
export interface PutUserPolicyRequest {
  UserName: string | undefined;
  PolicyName: string | undefined;
  PolicyDocument: string | undefined;
}
export interface RemoveClientIDFromOpenIDConnectProviderRequest {
  OpenIDConnectProviderArn: string | undefined;
  ClientID: string | undefined;
}
export interface RemoveRoleFromInstanceProfileRequest {
  InstanceProfileName: string | undefined;
  RoleName: string | undefined;
}
export interface RemoveUserFromGroupRequest {
  GroupName: string | undefined;
  UserName: string | undefined;
}
export interface ResetServiceSpecificCredentialRequest {
  UserName?: string;
  ServiceSpecificCredentialId: string | undefined;
}
export interface ResetServiceSpecificCredentialResponse {
  ServiceSpecificCredential?: ServiceSpecificCredential;
}
export interface ResyncMFADeviceRequest {
  UserName: string | undefined;
  SerialNumber: string | undefined;
  AuthenticationCode1: string | undefined;
  AuthenticationCode2: string | undefined;
}
export interface SetDefaultPolicyVersionRequest {
  PolicyArn: string | undefined;
  VersionId: string | undefined;
}
export declare enum GlobalEndpointTokenVersion {
  v1Token = "v1Token",
  v2Token = "v2Token",
}
export interface SetSecurityTokenServicePreferencesRequest {
  GlobalEndpointTokenVersion: GlobalEndpointTokenVersion | string | undefined;
}
export declare class PolicyEvaluationException extends __BaseException {
  readonly name: "PolicyEvaluationException";
  readonly $fault: "server";
  constructor(
    opts: __ExceptionOptionType<PolicyEvaluationException, __BaseException>
  );
}
export declare enum ContextKeyTypeEnum {
  BINARY = "binary",
  BINARY_LIST = "binaryList",
  BOOLEAN = "boolean",
  BOOLEAN_LIST = "booleanList",
  DATE = "date",
  DATE_LIST = "dateList",
  IP = "ip",
  IP_LIST = "ipList",
  NUMERIC = "numeric",
  NUMERIC_LIST = "numericList",
  STRING = "string",
  STRING_LIST = "stringList",
}
export interface ContextEntry {
  ContextKeyName?: string;
  ContextKeyValues?: string[];
  ContextKeyType?: ContextKeyTypeEnum | string;
}
export interface SimulateCustomPolicyRequest {
  PolicyInputList: string[] | undefined;
  PermissionsBoundaryPolicyInputList?: string[];
  ActionNames: string[] | undefined;
  ResourceArns?: string[];
  ResourcePolicy?: string;
  ResourceOwner?: string;
  CallerArn?: string;
  ContextEntries?: ContextEntry[];
  ResourceHandlingOption?: string;
  MaxItems?: number;
  Marker?: string;
}
export declare enum PolicyEvaluationDecisionType {
  ALLOWED = "allowed",
  EXPLICIT_DENY = "explicitDeny",
  IMPLICIT_DENY = "implicitDeny",
}
export interface Position {
  Line?: number;
  Column?: number;
}
export declare enum PolicySourceType {
  AWS_MANAGED = "aws-managed",
  GROUP = "group",
  NONE = "none",
  RESOURCE = "resource",
  ROLE = "role",
  USER = "user",
  USER_MANAGED = "user-managed",
}
export interface Statement {
  SourcePolicyId?: string;
  SourcePolicyType?: PolicySourceType | string;
  StartPosition?: Position;
  EndPosition?: Position;
}
export interface OrganizationsDecisionDetail {
  AllowedByOrganizations?: boolean;
}
export interface PermissionsBoundaryDecisionDetail {
  AllowedByPermissionsBoundary?: boolean;
}
export interface ResourceSpecificResult {
  EvalResourceName: string | undefined;
  EvalResourceDecision: PolicyEvaluationDecisionType | string | undefined;
  MatchedStatements?: Statement[];
  MissingContextValues?: string[];
  EvalDecisionDetails?: Record<string, PolicyEvaluationDecisionType | string>;
  PermissionsBoundaryDecisionDetail?: PermissionsBoundaryDecisionDetail;
}
export interface EvaluationResult {
  EvalActionName: string | undefined;
  EvalResourceName?: string;
  EvalDecision: PolicyEvaluationDecisionType | string | undefined;
  MatchedStatements?: Statement[];
  MissingContextValues?: string[];
  OrganizationsDecisionDetail?: OrganizationsDecisionDetail;
  PermissionsBoundaryDecisionDetail?: PermissionsBoundaryDecisionDetail;
  EvalDecisionDetails?: Record<string, PolicyEvaluationDecisionType | string>;
  ResourceSpecificResults?: ResourceSpecificResult[];
}
export interface SimulatePolicyResponse {
  EvaluationResults?: EvaluationResult[];
  IsTruncated?: boolean;
  Marker?: string;
}
export interface SimulatePrincipalPolicyRequest {
  PolicySourceArn: string | undefined;
  PolicyInputList?: string[];
  PermissionsBoundaryPolicyInputList?: string[];
  ActionNames: string[] | undefined;
  ResourceArns?: string[];
  ResourcePolicy?: string;
  ResourceOwner?: string;
  CallerArn?: string;
  ContextEntries?: ContextEntry[];
  ResourceHandlingOption?: string;
  MaxItems?: number;
  Marker?: string;
}
export interface TagInstanceProfileRequest {
  InstanceProfileName: string | undefined;
  Tags: Tag[] | undefined;
}
export interface TagMFADeviceRequest {
  SerialNumber: string | undefined;
  Tags: Tag[] | undefined;
}
export interface TagOpenIDConnectProviderRequest {
  OpenIDConnectProviderArn: string | undefined;
  Tags: Tag[] | undefined;
}
export interface TagPolicyRequest {
  PolicyArn: string | undefined;
  Tags: Tag[] | undefined;
}
export interface TagRoleRequest {
  RoleName: string | undefined;
  Tags: Tag[] | undefined;
}
export interface TagSAMLProviderRequest {
  SAMLProviderArn: string | undefined;
  Tags: Tag[] | undefined;
}
export interface TagServerCertificateRequest {
  ServerCertificateName: string | undefined;
  Tags: Tag[] | undefined;
}
export interface TagUserRequest {
  UserName: string | undefined;
  Tags: Tag[] | undefined;
}
export interface UntagInstanceProfileRequest {
  InstanceProfileName: string | undefined;
  TagKeys: string[] | undefined;
}
export interface UntagMFADeviceRequest {
  SerialNumber: string | undefined;
  TagKeys: string[] | undefined;
}
export interface UntagOpenIDConnectProviderRequest {
  OpenIDConnectProviderArn: string | undefined;
  TagKeys: string[] | undefined;
}
export declare const AccessDetailFilterSensitiveLog: (obj: AccessDetail) => any;
export declare const AccessKeyFilterSensitiveLog: (obj: AccessKey) => any;
export declare const AccessKeyLastUsedFilterSensitiveLog: (
  obj: AccessKeyLastUsed
) => any;
export declare const AccessKeyMetadataFilterSensitiveLog: (
  obj: AccessKeyMetadata
) => any;
export declare const AddClientIDToOpenIDConnectProviderRequestFilterSensitiveLog: (
  obj: AddClientIDToOpenIDConnectProviderRequest
) => any;
export declare const AddRoleToInstanceProfileRequestFilterSensitiveLog: (
  obj: AddRoleToInstanceProfileRequest
) => any;
export declare const AddUserToGroupRequestFilterSensitiveLog: (
  obj: AddUserToGroupRequest
) => any;
export declare const AttachedPermissionsBoundaryFilterSensitiveLog: (
  obj: AttachedPermissionsBoundary
) => any;
export declare const AttachedPolicyFilterSensitiveLog: (
  obj: AttachedPolicy
) => any;
export declare const AttachGroupPolicyRequestFilterSensitiveLog: (
  obj: AttachGroupPolicyRequest
) => any;
export declare const AttachRolePolicyRequestFilterSensitiveLog: (
  obj: AttachRolePolicyRequest
) => any;
export declare const AttachUserPolicyRequestFilterSensitiveLog: (
  obj: AttachUserPolicyRequest
) => any;
export declare const ChangePasswordRequestFilterSensitiveLog: (
  obj: ChangePasswordRequest
) => any;
export declare const CreateAccessKeyRequestFilterSensitiveLog: (
  obj: CreateAccessKeyRequest
) => any;
export declare const CreateAccessKeyResponseFilterSensitiveLog: (
  obj: CreateAccessKeyResponse
) => any;
export declare const CreateAccountAliasRequestFilterSensitiveLog: (
  obj: CreateAccountAliasRequest
) => any;
export declare const CreateGroupRequestFilterSensitiveLog: (
  obj: CreateGroupRequest
) => any;
export declare const GroupFilterSensitiveLog: (obj: Group) => any;
export declare const CreateGroupResponseFilterSensitiveLog: (
  obj: CreateGroupResponse
) => any;
export declare const TagFilterSensitiveLog: (obj: Tag) => any;
export declare const CreateInstanceProfileRequestFilterSensitiveLog: (
  obj: CreateInstanceProfileRequest
) => any;
export declare const RoleLastUsedFilterSensitiveLog: (obj: RoleLastUsed) => any;
export declare const RoleFilterSensitiveLog: (obj: Role) => any;
export declare const InstanceProfileFilterSensitiveLog: (
  obj: InstanceProfile
) => any;
export declare const CreateInstanceProfileResponseFilterSensitiveLog: (
  obj: CreateInstanceProfileResponse
) => any;
export declare const CreateLoginProfileRequestFilterSensitiveLog: (
  obj: CreateLoginProfileRequest
) => any;
export declare const LoginProfileFilterSensitiveLog: (obj: LoginProfile) => any;
export declare const CreateLoginProfileResponseFilterSensitiveLog: (
  obj: CreateLoginProfileResponse
) => any;
export declare const CreateOpenIDConnectProviderRequestFilterSensitiveLog: (
  obj: CreateOpenIDConnectProviderRequest
) => any;
export declare const CreateOpenIDConnectProviderResponseFilterSensitiveLog: (
  obj: CreateOpenIDConnectProviderResponse
) => any;
export declare const CreatePolicyRequestFilterSensitiveLog: (
  obj: CreatePolicyRequest
) => any;
export declare const PolicyFilterSensitiveLog: (obj: Policy) => any;
export declare const CreatePolicyResponseFilterSensitiveLog: (
  obj: CreatePolicyResponse
) => any;
export declare const CreatePolicyVersionRequestFilterSensitiveLog: (
  obj: CreatePolicyVersionRequest
) => any;
export declare const PolicyVersionFilterSensitiveLog: (
  obj: PolicyVersion
) => any;
export declare const CreatePolicyVersionResponseFilterSensitiveLog: (
  obj: CreatePolicyVersionResponse
) => any;
export declare const CreateRoleRequestFilterSensitiveLog: (
  obj: CreateRoleRequest
) => any;
export declare const CreateRoleResponseFilterSensitiveLog: (
  obj: CreateRoleResponse
) => any;
export declare const CreateSAMLProviderRequestFilterSensitiveLog: (
  obj: CreateSAMLProviderRequest
) => any;
export declare const CreateSAMLProviderResponseFilterSensitiveLog: (
  obj: CreateSAMLProviderResponse
) => any;
export declare const CreateServiceLinkedRoleRequestFilterSensitiveLog: (
  obj: CreateServiceLinkedRoleRequest
) => any;
export declare const CreateServiceLinkedRoleResponseFilterSensitiveLog: (
  obj: CreateServiceLinkedRoleResponse
) => any;
export declare const CreateServiceSpecificCredentialRequestFilterSensitiveLog: (
  obj: CreateServiceSpecificCredentialRequest
) => any;
export declare const ServiceSpecificCredentialFilterSensitiveLog: (
  obj: ServiceSpecificCredential
) => any;
export declare const CreateServiceSpecificCredentialResponseFilterSensitiveLog: (
  obj: CreateServiceSpecificCredentialResponse
) => any;
export declare const CreateUserRequestFilterSensitiveLog: (
  obj: CreateUserRequest
) => any;
export declare const UserFilterSensitiveLog: (obj: User) => any;
export declare const CreateUserResponseFilterSensitiveLog: (
  obj: CreateUserResponse
) => any;
export declare const CreateVirtualMFADeviceRequestFilterSensitiveLog: (
  obj: CreateVirtualMFADeviceRequest
) => any;
export declare const VirtualMFADeviceFilterSensitiveLog: (
  obj: VirtualMFADevice
) => any;
export declare const CreateVirtualMFADeviceResponseFilterSensitiveLog: (
  obj: CreateVirtualMFADeviceResponse
) => any;
export declare const DeactivateMFADeviceRequestFilterSensitiveLog: (
  obj: DeactivateMFADeviceRequest
) => any;
export declare const DeleteAccessKeyRequestFilterSensitiveLog: (
  obj: DeleteAccessKeyRequest
) => any;
export declare const DeleteAccountAliasRequestFilterSensitiveLog: (
  obj: DeleteAccountAliasRequest
) => any;
export declare const DeleteGroupRequestFilterSensitiveLog: (
  obj: DeleteGroupRequest
) => any;
export declare const DeleteGroupPolicyRequestFilterSensitiveLog: (
  obj: DeleteGroupPolicyRequest
) => any;
export declare const DeleteInstanceProfileRequestFilterSensitiveLog: (
  obj: DeleteInstanceProfileRequest
) => any;
export declare const DeleteLoginProfileRequestFilterSensitiveLog: (
  obj: DeleteLoginProfileRequest
) => any;
export declare const DeleteOpenIDConnectProviderRequestFilterSensitiveLog: (
  obj: DeleteOpenIDConnectProviderRequest
) => any;
export declare const DeletePolicyRequestFilterSensitiveLog: (
  obj: DeletePolicyRequest
) => any;
export declare const DeletePolicyVersionRequestFilterSensitiveLog: (
  obj: DeletePolicyVersionRequest
) => any;
export declare const DeleteRoleRequestFilterSensitiveLog: (
  obj: DeleteRoleRequest
) => any;
export declare const DeleteRolePermissionsBoundaryRequestFilterSensitiveLog: (
  obj: DeleteRolePermissionsBoundaryRequest
) => any;
export declare const DeleteRolePolicyRequestFilterSensitiveLog: (
  obj: DeleteRolePolicyRequest
) => any;
export declare const DeleteSAMLProviderRequestFilterSensitiveLog: (
  obj: DeleteSAMLProviderRequest
) => any;
export declare const DeleteServerCertificateRequestFilterSensitiveLog: (
  obj: DeleteServerCertificateRequest
) => any;
export declare const DeleteServiceLinkedRoleRequestFilterSensitiveLog: (
  obj: DeleteServiceLinkedRoleRequest
) => any;
export declare const DeleteServiceLinkedRoleResponseFilterSensitiveLog: (
  obj: DeleteServiceLinkedRoleResponse
) => any;
export declare const DeleteServiceSpecificCredentialRequestFilterSensitiveLog: (
  obj: DeleteServiceSpecificCredentialRequest
) => any;
export declare const DeleteSigningCertificateRequestFilterSensitiveLog: (
  obj: DeleteSigningCertificateRequest
) => any;
export declare const DeleteSSHPublicKeyRequestFilterSensitiveLog: (
  obj: DeleteSSHPublicKeyRequest
) => any;
export declare const DeleteUserRequestFilterSensitiveLog: (
  obj: DeleteUserRequest
) => any;
export declare const DeleteUserPermissionsBoundaryRequestFilterSensitiveLog: (
  obj: DeleteUserPermissionsBoundaryRequest
) => any;
export declare const DeleteUserPolicyRequestFilterSensitiveLog: (
  obj: DeleteUserPolicyRequest
) => any;
export declare const DeleteVirtualMFADeviceRequestFilterSensitiveLog: (
  obj: DeleteVirtualMFADeviceRequest
) => any;
export declare const DetachGroupPolicyRequestFilterSensitiveLog: (
  obj: DetachGroupPolicyRequest
) => any;
export declare const DetachRolePolicyRequestFilterSensitiveLog: (
  obj: DetachRolePolicyRequest
) => any;
export declare const DetachUserPolicyRequestFilterSensitiveLog: (
  obj: DetachUserPolicyRequest
) => any;
export declare const EnableMFADeviceRequestFilterSensitiveLog: (
  obj: EnableMFADeviceRequest
) => any;
export declare const GenerateCredentialReportResponseFilterSensitiveLog: (
  obj: GenerateCredentialReportResponse
) => any;
export declare const GenerateOrganizationsAccessReportRequestFilterSensitiveLog: (
  obj: GenerateOrganizationsAccessReportRequest
) => any;
export declare const GenerateOrganizationsAccessReportResponseFilterSensitiveLog: (
  obj: GenerateOrganizationsAccessReportResponse
) => any;
export declare const GenerateServiceLastAccessedDetailsRequestFilterSensitiveLog: (
  obj: GenerateServiceLastAccessedDetailsRequest
) => any;
export declare const GenerateServiceLastAccessedDetailsResponseFilterSensitiveLog: (
  obj: GenerateServiceLastAccessedDetailsResponse
) => any;
export declare const GetAccessKeyLastUsedRequestFilterSensitiveLog: (
  obj: GetAccessKeyLastUsedRequest
) => any;
export declare const GetAccessKeyLastUsedResponseFilterSensitiveLog: (
  obj: GetAccessKeyLastUsedResponse
) => any;
export declare const GetAccountAuthorizationDetailsRequestFilterSensitiveLog: (
  obj: GetAccountAuthorizationDetailsRequest
) => any;
export declare const PolicyDetailFilterSensitiveLog: (obj: PolicyDetail) => any;
export declare const GroupDetailFilterSensitiveLog: (obj: GroupDetail) => any;
export declare const ManagedPolicyDetailFilterSensitiveLog: (
  obj: ManagedPolicyDetail
) => any;
export declare const RoleDetailFilterSensitiveLog: (obj: RoleDetail) => any;
export declare const UserDetailFilterSensitiveLog: (obj: UserDetail) => any;
export declare const GetAccountAuthorizationDetailsResponseFilterSensitiveLog: (
  obj: GetAccountAuthorizationDetailsResponse
) => any;
export declare const PasswordPolicyFilterSensitiveLog: (
  obj: PasswordPolicy
) => any;
export declare const GetAccountPasswordPolicyResponseFilterSensitiveLog: (
  obj: GetAccountPasswordPolicyResponse
) => any;
export declare const GetAccountSummaryResponseFilterSensitiveLog: (
  obj: GetAccountSummaryResponse
) => any;
export declare const GetContextKeysForCustomPolicyRequestFilterSensitiveLog: (
  obj: GetContextKeysForCustomPolicyRequest
) => any;
export declare const GetContextKeysForPolicyResponseFilterSensitiveLog: (
  obj: GetContextKeysForPolicyResponse
) => any;
export declare const GetContextKeysForPrincipalPolicyRequestFilterSensitiveLog: (
  obj: GetContextKeysForPrincipalPolicyRequest
) => any;
export declare const GetCredentialReportResponseFilterSensitiveLog: (
  obj: GetCredentialReportResponse
) => any;
export declare const GetGroupRequestFilterSensitiveLog: (
  obj: GetGroupRequest
) => any;
export declare const GetGroupResponseFilterSensitiveLog: (
  obj: GetGroupResponse
) => any;
export declare const GetGroupPolicyRequestFilterSensitiveLog: (
  obj: GetGroupPolicyRequest
) => any;
export declare const GetGroupPolicyResponseFilterSensitiveLog: (
  obj: GetGroupPolicyResponse
) => any;
export declare const GetInstanceProfileRequestFilterSensitiveLog: (
  obj: GetInstanceProfileRequest
) => any;
export declare const GetInstanceProfileResponseFilterSensitiveLog: (
  obj: GetInstanceProfileResponse
) => any;
export declare const GetLoginProfileRequestFilterSensitiveLog: (
  obj: GetLoginProfileRequest
) => any;
export declare const GetLoginProfileResponseFilterSensitiveLog: (
  obj: GetLoginProfileResponse
) => any;
export declare const GetOpenIDConnectProviderRequestFilterSensitiveLog: (
  obj: GetOpenIDConnectProviderRequest
) => any;
export declare const GetOpenIDConnectProviderResponseFilterSensitiveLog: (
  obj: GetOpenIDConnectProviderResponse
) => any;
export declare const GetOrganizationsAccessReportRequestFilterSensitiveLog: (
  obj: GetOrganizationsAccessReportRequest
) => any;
export declare const ErrorDetailsFilterSensitiveLog: (obj: ErrorDetails) => any;
export declare const GetOrganizationsAccessReportResponseFilterSensitiveLog: (
  obj: GetOrganizationsAccessReportResponse
) => any;
export declare const GetPolicyRequestFilterSensitiveLog: (
  obj: GetPolicyRequest
) => any;
export declare const GetPolicyResponseFilterSensitiveLog: (
  obj: GetPolicyResponse
) => any;
export declare const GetPolicyVersionRequestFilterSensitiveLog: (
  obj: GetPolicyVersionRequest
) => any;
export declare const GetPolicyVersionResponseFilterSensitiveLog: (
  obj: GetPolicyVersionResponse
) => any;
export declare const GetRoleRequestFilterSensitiveLog: (
  obj: GetRoleRequest
) => any;
export declare const GetRoleResponseFilterSensitiveLog: (
  obj: GetRoleResponse
) => any;
export declare const GetRolePolicyRequestFilterSensitiveLog: (
  obj: GetRolePolicyRequest
) => any;
export declare const GetRolePolicyResponseFilterSensitiveLog: (
  obj: GetRolePolicyResponse
) => any;
export declare const GetSAMLProviderRequestFilterSensitiveLog: (
  obj: GetSAMLProviderRequest
) => any;
export declare const GetSAMLProviderResponseFilterSensitiveLog: (
  obj: GetSAMLProviderResponse
) => any;
export declare const GetServerCertificateRequestFilterSensitiveLog: (
  obj: GetServerCertificateRequest
) => any;
export declare const ServerCertificateMetadataFilterSensitiveLog: (
  obj: ServerCertificateMetadata
) => any;
export declare const ServerCertificateFilterSensitiveLog: (
  obj: ServerCertificate
) => any;
export declare const GetServerCertificateResponseFilterSensitiveLog: (
  obj: GetServerCertificateResponse
) => any;
export declare const GetServiceLastAccessedDetailsRequestFilterSensitiveLog: (
  obj: GetServiceLastAccessedDetailsRequest
) => any;
export declare const TrackedActionLastAccessedFilterSensitiveLog: (
  obj: TrackedActionLastAccessed
) => any;
export declare const ServiceLastAccessedFilterSensitiveLog: (
  obj: ServiceLastAccessed
) => any;
export declare const GetServiceLastAccessedDetailsResponseFilterSensitiveLog: (
  obj: GetServiceLastAccessedDetailsResponse
) => any;
export declare const GetServiceLastAccessedDetailsWithEntitiesRequestFilterSensitiveLog: (
  obj: GetServiceLastAccessedDetailsWithEntitiesRequest
) => any;
export declare const EntityInfoFilterSensitiveLog: (obj: EntityInfo) => any;
export declare const EntityDetailsFilterSensitiveLog: (
  obj: EntityDetails
) => any;
export declare const GetServiceLastAccessedDetailsWithEntitiesResponseFilterSensitiveLog: (
  obj: GetServiceLastAccessedDetailsWithEntitiesResponse
) => any;
export declare const GetServiceLinkedRoleDeletionStatusRequestFilterSensitiveLog: (
  obj: GetServiceLinkedRoleDeletionStatusRequest
) => any;
export declare const RoleUsageTypeFilterSensitiveLog: (
  obj: RoleUsageType
) => any;
export declare const DeletionTaskFailureReasonTypeFilterSensitiveLog: (
  obj: DeletionTaskFailureReasonType
) => any;
export declare const GetServiceLinkedRoleDeletionStatusResponseFilterSensitiveLog: (
  obj: GetServiceLinkedRoleDeletionStatusResponse
) => any;
export declare const GetSSHPublicKeyRequestFilterSensitiveLog: (
  obj: GetSSHPublicKeyRequest
) => any;
export declare const SSHPublicKeyFilterSensitiveLog: (obj: SSHPublicKey) => any;
export declare const GetSSHPublicKeyResponseFilterSensitiveLog: (
  obj: GetSSHPublicKeyResponse
) => any;
export declare const GetUserRequestFilterSensitiveLog: (
  obj: GetUserRequest
) => any;
export declare const GetUserResponseFilterSensitiveLog: (
  obj: GetUserResponse
) => any;
export declare const GetUserPolicyRequestFilterSensitiveLog: (
  obj: GetUserPolicyRequest
) => any;
export declare const GetUserPolicyResponseFilterSensitiveLog: (
  obj: GetUserPolicyResponse
) => any;
export declare const ListAccessKeysRequestFilterSensitiveLog: (
  obj: ListAccessKeysRequest
) => any;
export declare const ListAccessKeysResponseFilterSensitiveLog: (
  obj: ListAccessKeysResponse
) => any;
export declare const ListAccountAliasesRequestFilterSensitiveLog: (
  obj: ListAccountAliasesRequest
) => any;
export declare const ListAccountAliasesResponseFilterSensitiveLog: (
  obj: ListAccountAliasesResponse
) => any;
export declare const ListAttachedGroupPoliciesRequestFilterSensitiveLog: (
  obj: ListAttachedGroupPoliciesRequest
) => any;
export declare const ListAttachedGroupPoliciesResponseFilterSensitiveLog: (
  obj: ListAttachedGroupPoliciesResponse
) => any;
export declare const ListAttachedRolePoliciesRequestFilterSensitiveLog: (
  obj: ListAttachedRolePoliciesRequest
) => any;
export declare const ListAttachedRolePoliciesResponseFilterSensitiveLog: (
  obj: ListAttachedRolePoliciesResponse
) => any;
export declare const ListAttachedUserPoliciesRequestFilterSensitiveLog: (
  obj: ListAttachedUserPoliciesRequest
) => any;
export declare const ListAttachedUserPoliciesResponseFilterSensitiveLog: (
  obj: ListAttachedUserPoliciesResponse
) => any;
export declare const ListEntitiesForPolicyRequestFilterSensitiveLog: (
  obj: ListEntitiesForPolicyRequest
) => any;
export declare const PolicyGroupFilterSensitiveLog: (obj: PolicyGroup) => any;
export declare const PolicyRoleFilterSensitiveLog: (obj: PolicyRole) => any;
export declare const PolicyUserFilterSensitiveLog: (obj: PolicyUser) => any;
export declare const ListEntitiesForPolicyResponseFilterSensitiveLog: (
  obj: ListEntitiesForPolicyResponse
) => any;
export declare const ListGroupPoliciesRequestFilterSensitiveLog: (
  obj: ListGroupPoliciesRequest
) => any;
export declare const ListGroupPoliciesResponseFilterSensitiveLog: (
  obj: ListGroupPoliciesResponse
) => any;
export declare const ListGroupsRequestFilterSensitiveLog: (
  obj: ListGroupsRequest
) => any;
export declare const ListGroupsResponseFilterSensitiveLog: (
  obj: ListGroupsResponse
) => any;
export declare const ListGroupsForUserRequestFilterSensitiveLog: (
  obj: ListGroupsForUserRequest
) => any;
export declare const ListGroupsForUserResponseFilterSensitiveLog: (
  obj: ListGroupsForUserResponse
) => any;
export declare const ListInstanceProfilesRequestFilterSensitiveLog: (
  obj: ListInstanceProfilesRequest
) => any;
export declare const ListInstanceProfilesResponseFilterSensitiveLog: (
  obj: ListInstanceProfilesResponse
) => any;
export declare const ListInstanceProfilesForRoleRequestFilterSensitiveLog: (
  obj: ListInstanceProfilesForRoleRequest
) => any;
export declare const ListInstanceProfilesForRoleResponseFilterSensitiveLog: (
  obj: ListInstanceProfilesForRoleResponse
) => any;
export declare const ListInstanceProfileTagsRequestFilterSensitiveLog: (
  obj: ListInstanceProfileTagsRequest
) => any;
export declare const ListInstanceProfileTagsResponseFilterSensitiveLog: (
  obj: ListInstanceProfileTagsResponse
) => any;
export declare const ListMFADevicesRequestFilterSensitiveLog: (
  obj: ListMFADevicesRequest
) => any;
export declare const MFADeviceFilterSensitiveLog: (obj: MFADevice) => any;
export declare const ListMFADevicesResponseFilterSensitiveLog: (
  obj: ListMFADevicesResponse
) => any;
export declare const ListMFADeviceTagsRequestFilterSensitiveLog: (
  obj: ListMFADeviceTagsRequest
) => any;
export declare const ListMFADeviceTagsResponseFilterSensitiveLog: (
  obj: ListMFADeviceTagsResponse
) => any;
export declare const ListOpenIDConnectProvidersRequestFilterSensitiveLog: (
  obj: ListOpenIDConnectProvidersRequest
) => any;
export declare const OpenIDConnectProviderListEntryFilterSensitiveLog: (
  obj: OpenIDConnectProviderListEntry
) => any;
export declare const ListOpenIDConnectProvidersResponseFilterSensitiveLog: (
  obj: ListOpenIDConnectProvidersResponse
) => any;
export declare const ListOpenIDConnectProviderTagsRequestFilterSensitiveLog: (
  obj: ListOpenIDConnectProviderTagsRequest
) => any;
export declare const ListOpenIDConnectProviderTagsResponseFilterSensitiveLog: (
  obj: ListOpenIDConnectProviderTagsResponse
) => any;
export declare const ListPoliciesRequestFilterSensitiveLog: (
  obj: ListPoliciesRequest
) => any;
export declare const ListPoliciesResponseFilterSensitiveLog: (
  obj: ListPoliciesResponse
) => any;
export declare const ListPoliciesGrantingServiceAccessRequestFilterSensitiveLog: (
  obj: ListPoliciesGrantingServiceAccessRequest
) => any;
export declare const PolicyGrantingServiceAccessFilterSensitiveLog: (
  obj: PolicyGrantingServiceAccess
) => any;
export declare const ListPoliciesGrantingServiceAccessEntryFilterSensitiveLog: (
  obj: ListPoliciesGrantingServiceAccessEntry
) => any;
export declare const ListPoliciesGrantingServiceAccessResponseFilterSensitiveLog: (
  obj: ListPoliciesGrantingServiceAccessResponse
) => any;
export declare const ListPolicyTagsRequestFilterSensitiveLog: (
  obj: ListPolicyTagsRequest
) => any;
export declare const ListPolicyTagsResponseFilterSensitiveLog: (
  obj: ListPolicyTagsResponse
) => any;
export declare const ListPolicyVersionsRequestFilterSensitiveLog: (
  obj: ListPolicyVersionsRequest
) => any;
export declare const ListPolicyVersionsResponseFilterSensitiveLog: (
  obj: ListPolicyVersionsResponse
) => any;
export declare const ListRolePoliciesRequestFilterSensitiveLog: (
  obj: ListRolePoliciesRequest
) => any;
export declare const ListRolePoliciesResponseFilterSensitiveLog: (
  obj: ListRolePoliciesResponse
) => any;
export declare const ListRolesRequestFilterSensitiveLog: (
  obj: ListRolesRequest
) => any;
export declare const ListRolesResponseFilterSensitiveLog: (
  obj: ListRolesResponse
) => any;
export declare const ListRoleTagsRequestFilterSensitiveLog: (
  obj: ListRoleTagsRequest
) => any;
export declare const ListRoleTagsResponseFilterSensitiveLog: (
  obj: ListRoleTagsResponse
) => any;
export declare const ListSAMLProvidersRequestFilterSensitiveLog: (
  obj: ListSAMLProvidersRequest
) => any;
export declare const SAMLProviderListEntryFilterSensitiveLog: (
  obj: SAMLProviderListEntry
) => any;
export declare const ListSAMLProvidersResponseFilterSensitiveLog: (
  obj: ListSAMLProvidersResponse
) => any;
export declare const ListSAMLProviderTagsRequestFilterSensitiveLog: (
  obj: ListSAMLProviderTagsRequest
) => any;
export declare const ListSAMLProviderTagsResponseFilterSensitiveLog: (
  obj: ListSAMLProviderTagsResponse
) => any;
export declare const ListServerCertificatesRequestFilterSensitiveLog: (
  obj: ListServerCertificatesRequest
) => any;
export declare const ListServerCertificatesResponseFilterSensitiveLog: (
  obj: ListServerCertificatesResponse
) => any;
export declare const ListServerCertificateTagsRequestFilterSensitiveLog: (
  obj: ListServerCertificateTagsRequest
) => any;
export declare const ListServerCertificateTagsResponseFilterSensitiveLog: (
  obj: ListServerCertificateTagsResponse
) => any;
export declare const ListServiceSpecificCredentialsRequestFilterSensitiveLog: (
  obj: ListServiceSpecificCredentialsRequest
) => any;
export declare const ServiceSpecificCredentialMetadataFilterSensitiveLog: (
  obj: ServiceSpecificCredentialMetadata
) => any;
export declare const ListServiceSpecificCredentialsResponseFilterSensitiveLog: (
  obj: ListServiceSpecificCredentialsResponse
) => any;
export declare const ListSigningCertificatesRequestFilterSensitiveLog: (
  obj: ListSigningCertificatesRequest
) => any;
export declare const SigningCertificateFilterSensitiveLog: (
  obj: SigningCertificate
) => any;
export declare const ListSigningCertificatesResponseFilterSensitiveLog: (
  obj: ListSigningCertificatesResponse
) => any;
export declare const ListSSHPublicKeysRequestFilterSensitiveLog: (
  obj: ListSSHPublicKeysRequest
) => any;
export declare const SSHPublicKeyMetadataFilterSensitiveLog: (
  obj: SSHPublicKeyMetadata
) => any;
export declare const ListSSHPublicKeysResponseFilterSensitiveLog: (
  obj: ListSSHPublicKeysResponse
) => any;
export declare const ListUserPoliciesRequestFilterSensitiveLog: (
  obj: ListUserPoliciesRequest
) => any;
export declare const ListUserPoliciesResponseFilterSensitiveLog: (
  obj: ListUserPoliciesResponse
) => any;
export declare const ListUsersRequestFilterSensitiveLog: (
  obj: ListUsersRequest
) => any;
export declare const ListUsersResponseFilterSensitiveLog: (
  obj: ListUsersResponse
) => any;
export declare const ListUserTagsRequestFilterSensitiveLog: (
  obj: ListUserTagsRequest
) => any;
export declare const ListUserTagsResponseFilterSensitiveLog: (
  obj: ListUserTagsResponse
) => any;
export declare const ListVirtualMFADevicesRequestFilterSensitiveLog: (
  obj: ListVirtualMFADevicesRequest
) => any;
export declare const ListVirtualMFADevicesResponseFilterSensitiveLog: (
  obj: ListVirtualMFADevicesResponse
) => any;
export declare const PutGroupPolicyRequestFilterSensitiveLog: (
  obj: PutGroupPolicyRequest
) => any;
export declare const PutRolePermissionsBoundaryRequestFilterSensitiveLog: (
  obj: PutRolePermissionsBoundaryRequest
) => any;
export declare const PutRolePolicyRequestFilterSensitiveLog: (
  obj: PutRolePolicyRequest
) => any;
export declare const PutUserPermissionsBoundaryRequestFilterSensitiveLog: (
  obj: PutUserPermissionsBoundaryRequest
) => any;
export declare const PutUserPolicyRequestFilterSensitiveLog: (
  obj: PutUserPolicyRequest
) => any;
export declare const RemoveClientIDFromOpenIDConnectProviderRequestFilterSensitiveLog: (
  obj: RemoveClientIDFromOpenIDConnectProviderRequest
) => any;
export declare const RemoveRoleFromInstanceProfileRequestFilterSensitiveLog: (
  obj: RemoveRoleFromInstanceProfileRequest
) => any;
export declare const RemoveUserFromGroupRequestFilterSensitiveLog: (
  obj: RemoveUserFromGroupRequest
) => any;
export declare const ResetServiceSpecificCredentialRequestFilterSensitiveLog: (
  obj: ResetServiceSpecificCredentialRequest
) => any;
export declare const ResetServiceSpecificCredentialResponseFilterSensitiveLog: (
  obj: ResetServiceSpecificCredentialResponse
) => any;
export declare const ResyncMFADeviceRequestFilterSensitiveLog: (
  obj: ResyncMFADeviceRequest
) => any;
export declare const SetDefaultPolicyVersionRequestFilterSensitiveLog: (
  obj: SetDefaultPolicyVersionRequest
) => any;
export declare const SetSecurityTokenServicePreferencesRequestFilterSensitiveLog: (
  obj: SetSecurityTokenServicePreferencesRequest
) => any;
export declare const ContextEntryFilterSensitiveLog: (obj: ContextEntry) => any;
export declare const SimulateCustomPolicyRequestFilterSensitiveLog: (
  obj: SimulateCustomPolicyRequest
) => any;
export declare const PositionFilterSensitiveLog: (obj: Position) => any;
export declare const StatementFilterSensitiveLog: (obj: Statement) => any;
export declare const OrganizationsDecisionDetailFilterSensitiveLog: (
  obj: OrganizationsDecisionDetail
) => any;
export declare const PermissionsBoundaryDecisionDetailFilterSensitiveLog: (
  obj: PermissionsBoundaryDecisionDetail
) => any;
export declare const ResourceSpecificResultFilterSensitiveLog: (
  obj: ResourceSpecificResult
) => any;
export declare const EvaluationResultFilterSensitiveLog: (
  obj: EvaluationResult
) => any;
export declare const SimulatePolicyResponseFilterSensitiveLog: (
  obj: SimulatePolicyResponse
) => any;
export declare const SimulatePrincipalPolicyRequestFilterSensitiveLog: (
  obj: SimulatePrincipalPolicyRequest
) => any;
export declare const TagInstanceProfileRequestFilterSensitiveLog: (
  obj: TagInstanceProfileRequest
) => any;
export declare const TagMFADeviceRequestFilterSensitiveLog: (
  obj: TagMFADeviceRequest
) => any;
export declare const TagOpenIDConnectProviderRequestFilterSensitiveLog: (
  obj: TagOpenIDConnectProviderRequest
) => any;
export declare const TagPolicyRequestFilterSensitiveLog: (
  obj: TagPolicyRequest
) => any;
export declare const TagRoleRequestFilterSensitiveLog: (
  obj: TagRoleRequest
) => any;
export declare const TagSAMLProviderRequestFilterSensitiveLog: (
  obj: TagSAMLProviderRequest
) => any;
export declare const TagServerCertificateRequestFilterSensitiveLog: (
  obj: TagServerCertificateRequest
) => any;
export declare const TagUserRequestFilterSensitiveLog: (
  obj: TagUserRequest
) => any;
export declare const UntagInstanceProfileRequestFilterSensitiveLog: (
  obj: UntagInstanceProfileRequest
) => any;
export declare const UntagMFADeviceRequestFilterSensitiveLog: (
  obj: UntagMFADeviceRequest
) => any;
export declare const UntagOpenIDConnectProviderRequestFilterSensitiveLog: (
  obj: UntagOpenIDConnectProviderRequest
) => any;
