import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  IAMClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../IAMClient";
import {
  SimulateCustomPolicyRequest,
  SimulatePolicyResponse,
} from "../models/models_0";
export interface SimulateCustomPolicyCommandInput
  extends SimulateCustomPolicyRequest {}
export interface SimulateCustomPolicyCommandOutput
  extends SimulatePolicyResponse,
    __MetadataBearer {}
export declare class SimulateCustomPolicyCommand extends $Command<
  SimulateCustomPolicyCommandInput,
  SimulateCustomPolicyCommandOutput,
  IAMClientResolvedConfig
> {
  readonly input: SimulateCustomPolicyCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: SimulateCustomPolicyCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: IAMClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    SimulateCustomPolicyCommandInput,
    SimulateCustomPolicyCommandOutput
  >;
  private serialize;
  private deserialize;
}
