import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { IAMClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../IAMClient";
import { ResyncMFADeviceRequest } from "../models/models_0";
export interface ResyncMFADeviceCommandInput extends ResyncMFADeviceRequest {
}
export interface ResyncMFADeviceCommandOutput extends __MetadataBearer {
}
/**
 * <p>Synchronizes the specified MFA device with its IAM resource object on the Amazon Web Services
 *             servers.</p>
 *         <p>For more information about creating and working with virtual MFA devices, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html">Using a virtual MFA
 *                 device</a> in the <i>IAM User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { IAMClient, ResyncMFADeviceCommand } from "@aws-sdk/client-iam"; // ES Modules import
 * // const { IAMClient, ResyncMFADeviceCommand } = require("@aws-sdk/client-iam"); // CommonJS import
 * const client = new IAMClient(config);
 * const command = new ResyncMFADeviceCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link ResyncMFADeviceCommandInput} for command's `input` shape.
 * @see {@link ResyncMFADeviceCommandOutput} for command's `response` shape.
 * @see {@link IAMClientResolvedConfig | config} for IAMClient's `config` shape.
 *
 */
export declare class ResyncMFADeviceCommand extends $Command<ResyncMFADeviceCommandInput, ResyncMFADeviceCommandOutput, IAMClientResolvedConfig> {
    readonly input: ResyncMFADeviceCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: ResyncMFADeviceCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: IAMClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ResyncMFADeviceCommandInput, ResyncMFADeviceCommandOutput>;
    private serialize;
    private deserialize;
}
