import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { IAMClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../IAMClient";
import { GetLoginProfileRequest, GetLoginProfileResponse } from "../models/models_0";
export interface GetLoginProfileCommandInput extends GetLoginProfileRequest {
}
export interface GetLoginProfileCommandOutput extends GetLoginProfileResponse, __MetadataBearer {
}
/**
 * <p>Retrieves the user name for the specified IAM user. A login profile is created when
 *             you create a password for the user to access the Amazon Web Services Management Console. If the user does not exist
 *             or does not have a password, the operation returns a 404 (<code>NoSuchEntity</code>)
 *             error.</p>
 *         <p>If you create an IAM user with access to the console, the <code>CreateDate</code>
 *             reflects the date you created the initial password for the user.</p>
 *         <p>If you create an IAM user with programmatic access, and then later add a password
 *             for the user to access the Amazon Web Services Management Console, the <code>CreateDate</code> reflects the initial
 *             password creation date. A user with programmatic access does not have a login profile
 *             unless you create a password for the user to access the Amazon Web Services Management Console.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { IAMClient, GetLoginProfileCommand } from "@aws-sdk/client-iam"; // ES Modules import
 * // const { IAMClient, GetLoginProfileCommand } = require("@aws-sdk/client-iam"); // CommonJS import
 * const client = new IAMClient(config);
 * const command = new GetLoginProfileCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link GetLoginProfileCommandInput} for command's `input` shape.
 * @see {@link GetLoginProfileCommandOutput} for command's `response` shape.
 * @see {@link IAMClientResolvedConfig | config} for IAMClient's `config` shape.
 *
 */
export declare class GetLoginProfileCommand extends $Command<GetLoginProfileCommandInput, GetLoginProfileCommandOutput, IAMClientResolvedConfig> {
    readonly input: GetLoginProfileCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: GetLoginProfileCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: IAMClientResolvedConfig, options?: __HttpHandlerOptions): Handler<GetLoginProfileCommandInput, GetLoginProfileCommandOutput>;
    private serialize;
    private deserialize;
}
