import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { IAMClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../IAMClient";
import { CreateServiceSpecificCredentialRequest, CreateServiceSpecificCredentialResponse } from "../models/models_0";
export interface CreateServiceSpecificCredentialCommandInput extends CreateServiceSpecificCredentialRequest {
}
export interface CreateServiceSpecificCredentialCommandOutput extends CreateServiceSpecificCredentialResponse, __MetadataBearer {
}
/**
 * <p>Generates a set of credentials consisting of a user name and password that can be used
 *             to access the service specified in the request. These credentials are generated by
 *             IAM, and can be used only for the specified service. </p>
 *         <p>You can have a maximum of two sets of service-specific credentials for each supported
 *             service per user.</p>
 *         <p>You can create service-specific credentials for CodeCommit and Amazon Keyspaces (for Apache
 *             Cassandra).</p>
 *         <p>You can reset the password to a new service-generated value by calling <a>ResetServiceSpecificCredential</a>.</p>
 *         <p>For more information about service-specific credentials, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_ssh-keys.html">Using IAM
 *                 with CodeCommit: Git credentials, SSH keys, and Amazon Web Services access keys</a> in the
 *                 <i>IAM User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { IAMClient, CreateServiceSpecificCredentialCommand } from "@aws-sdk/client-iam"; // ES Modules import
 * // const { IAMClient, CreateServiceSpecificCredentialCommand } = require("@aws-sdk/client-iam"); // CommonJS import
 * const client = new IAMClient(config);
 * const command = new CreateServiceSpecificCredentialCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link CreateServiceSpecificCredentialCommandInput} for command's `input` shape.
 * @see {@link CreateServiceSpecificCredentialCommandOutput} for command's `response` shape.
 * @see {@link IAMClientResolvedConfig | config} for IAMClient's `config` shape.
 *
 */
export declare class CreateServiceSpecificCredentialCommand extends $Command<CreateServiceSpecificCredentialCommandInput, CreateServiceSpecificCredentialCommandOutput, IAMClientResolvedConfig> {
    readonly input: CreateServiceSpecificCredentialCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: CreateServiceSpecificCredentialCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: IAMClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateServiceSpecificCredentialCommandInput, CreateServiceSpecificCredentialCommandOutput>;
    private serialize;
    private deserialize;
}
