import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { IAMClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../IAMClient";
import { ChangePasswordRequest } from "../models/models_0";
export interface ChangePasswordCommandInput extends ChangePasswordRequest {
}
export interface ChangePasswordCommandOutput extends __MetadataBearer {
}
/**
 * <p>Changes the password of the IAM user who is calling this operation. This operation
 *             can be performed using the CLI, the Amazon Web Services API, or the <b>My
 *                 Security Credentials</b> page in the Amazon Web Services Management Console. The Amazon Web Services account root user
 *             password is not affected by this operation.</p>
 *         <p>Use <a>UpdateLoginProfile</a> to use the CLI, the Amazon Web Services API, or the
 *                 <b>Users</b> page in the IAM console to change the
 *             password for any IAM user. For more information about modifying passwords, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html">Managing
 *                 passwords</a> in the <i>IAM User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { IAMClient, ChangePasswordCommand } from "@aws-sdk/client-iam"; // ES Modules import
 * // const { IAMClient, ChangePasswordCommand } = require("@aws-sdk/client-iam"); // CommonJS import
 * const client = new IAMClient(config);
 * const command = new ChangePasswordCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link ChangePasswordCommandInput} for command's `input` shape.
 * @see {@link ChangePasswordCommandOutput} for command's `response` shape.
 * @see {@link IAMClientResolvedConfig | config} for IAMClient's `config` shape.
 *
 */
export declare class ChangePasswordCommand extends $Command<ChangePasswordCommandInput, ChangePasswordCommandOutput, IAMClientResolvedConfig> {
    readonly input: ChangePasswordCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: ChangePasswordCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: IAMClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ChangePasswordCommandInput, ChangePasswordCommandOutput>;
    private serialize;
    private deserialize;
}
