import { ListGroupsForUserCommand, } from "../commands/ListGroupsForUserCommand";
import { IAM } from "../IAM";
import { IAMClient } from "../IAMClient";
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new ListGroupsForUserCommand(input), ...args);
};
const makePagedRequest = async (client, input, ...args) => {
    return await client.listGroupsForUser(input, ...args);
};
export async function* paginateListGroupsForUser(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.Marker = token;
        input["MaxItems"] = config.pageSize;
        if (config.client instanceof IAM) {
            page = await makePagedRequest(config.client, input, ...additionalArguments);
        }
        else if (config.client instanceof IAMClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected IAM | IAMClient");
        }
        yield page;
        const prevToken = token;
        token = page.Marker;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
