"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitUntilUserExists = exports.waitForUserExists = void 0;
const util_waiter_1 = require("@aws-sdk/util-waiter");
const GetUserCommand_1 = require("../commands/GetUserCommand");
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new GetUserCommand_1.GetUserCommand(input));
        reason = result;
        return { state: util_waiter_1.WaiterState.SUCCESS, reason };
    }
    catch (exception) {
        reason = exception;
        if (exception.name && exception.name == "NoSuchEntity") {
            return { state: util_waiter_1.WaiterState.RETRY, reason };
        }
    }
    return { state: util_waiter_1.WaiterState.RETRY, reason };
};
const waitForUserExists = async (params, input) => {
    const serviceDefaults = { minDelay: 1, maxDelay: 120 };
    return (0, util_waiter_1.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
};
exports.waitForUserExists = waitForUserExists;
const waitUntilUserExists = async (params, input) => {
    const serviceDefaults = { minDelay: 1, maxDelay: 120 };
    const result = await (0, util_waiter_1.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
    return (0, util_waiter_1.checkExceptions)(result);
};
exports.waitUntilUserExists = waitUntilUserExists;
