import {
  _InstanceType,
  AccessScopeAnalysisFinding,
  AddressAttribute,
  AddressTransfer,
  AllowedPrincipal,
  AssociationStatus,
  AutoPlacement,
  CapacityReservationState,
  ClientConnectOptions,
  ClientLoginBannerOptions,
  ConnectionLogOptions,
  CurrencyCodeValues,
  EndDateType,
  HostRecovery,
  IamInstanceProfileAssociation,
  InstanceEventWindow,
  IpamPoolAllocation,
  SelfServicePortal,
  SubnetAssociation,
  SubnetIpv6CidrBlockAssociation,
  Tag,
  TagSpecification,
  TargetConfigurationRequest,
  TransitGatewayAssociation,
  TransitGatewayAssociationState,
  TransitGatewayAttachmentResourceType,
  TransitGatewayMulticastDomainAssociations,
  TransitGatewayPolicyTableAssociation,
  UnsuccessfulItem,
  VerifiedAccessInstance,
  VerifiedAccessTrustProvider,
  VpcCidrBlockAssociation,
  VpcIpv6CidrBlockAssociation,
  VpcPeeringConnection,
} from "./models_0";
import {
  AttributeValue,
  CapacityReservationPreference,
  CapacityReservationTarget,
  DiskImageFormat,
  FleetExcessCapacityTerminationPolicy,
  FleetLaunchTemplateConfigRequest,
  InstanceRequirementsRequest,
  IpamResourceTag,
  NetworkInsightsAccessScopeContent,
  Placement,
  PlatformValues,
  RequestIpamResourceTag,
  ResponseLaunchTemplateData,
  ShutdownBehavior,
  TargetCapacitySpecificationRequest,
  TargetCapacityUnitType,
  Vpc,
} from "./models_1";
import {
  DnsNameState,
  PayerResponsibility,
  ServiceConfiguration,
  ServiceConnectivityType,
  ServiceTypeDetail,
  SubnetCidrReservation,
  TransitGatewayPrefixListReference,
  VpnConnection,
  VpnGateway,
} from "./models_2";
import {
  ArchitectureValues,
  AttributeBooleanValue,
  BootModeValues,
  ConversionTask,
  ExportTaskS3Location,
  FastLaunchLaunchTemplateSpecificationResponse,
  FastLaunchResourceType,
  FastLaunchSnapshotConfigurationResponse,
  FastLaunchStateCode,
  FastSnapshotRestoreStateCode,
  Filter,
  FpgaImageAttribute,
  FpgaImageAttributeName,
  ImportImageLicenseConfigurationResponse,
  InstanceAttributeName,
  IpamPoolCidr,
  LaunchPermission,
  MetricType,
  PaymentOption,
  PeriodType,
  PermissionGroup,
  SnapshotDetail,
  SnapshotTaskDetail,
  StatisticType,
  VirtualizationType,
} from "./models_3";
import { AnalysisStatus, ArchitectureType } from "./models_4";
export interface DescribeVpcEndpointServiceConfigurationsResult {
  ServiceConfigurations?: ServiceConfiguration[];
  NextToken?: string;
}
export interface DescribeVpcEndpointServicePermissionsRequest {
  DryRun?: boolean;
  ServiceId: string | undefined;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface DescribeVpcEndpointServicePermissionsResult {
  AllowedPrincipals?: AllowedPrincipal[];
  NextToken?: string;
}
export interface DescribeVpcEndpointServicesRequest {
  DryRun?: boolean;
  ServiceNames?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface PrivateDnsDetails {
  PrivateDnsName?: string;
}
export interface ServiceDetail {
  ServiceName?: string;
  ServiceId?: string;
  ServiceType?: ServiceTypeDetail[];
  AvailabilityZones?: string[];
  Owner?: string;
  BaseEndpointDnsNames?: string[];
  PrivateDnsName?: string;
  PrivateDnsNames?: PrivateDnsDetails[];
  VpcEndpointPolicySupported?: boolean;
  AcceptanceRequired?: boolean;
  ManagesVpcEndpoints?: boolean;
  PayerResponsibility?: PayerResponsibility | string;
  Tags?: Tag[];
  PrivateDnsNameVerificationState?: DnsNameState | string;
  SupportedIpAddressTypes?: (ServiceConnectivityType | string)[];
}
export interface DescribeVpcEndpointServicesResult {
  ServiceNames?: string[];
  ServiceDetails?: ServiceDetail[];
  NextToken?: string;
}
export interface DescribeVpcPeeringConnectionsRequest {
  Filters?: Filter[];
  DryRun?: boolean;
  VpcPeeringConnectionIds?: string[];
  NextToken?: string;
  MaxResults?: number;
}
export interface DescribeVpcPeeringConnectionsResult {
  VpcPeeringConnections?: VpcPeeringConnection[];
  NextToken?: string;
}
export interface DescribeVpcsRequest {
  Filters?: Filter[];
  VpcIds?: string[];
  DryRun?: boolean;
  NextToken?: string;
  MaxResults?: number;
}
export interface DescribeVpcsResult {
  Vpcs?: Vpc[];
  NextToken?: string;
}
export interface DescribeVpnConnectionsRequest {
  Filters?: Filter[];
  VpnConnectionIds?: string[];
  DryRun?: boolean;
}
export interface DescribeVpnConnectionsResult {
  VpnConnections?: VpnConnection[];
}
export interface DescribeVpnGatewaysRequest {
  Filters?: Filter[];
  VpnGatewayIds?: string[];
  DryRun?: boolean;
}
export interface DescribeVpnGatewaysResult {
  VpnGateways?: VpnGateway[];
}
export interface DetachClassicLinkVpcRequest {
  DryRun?: boolean;
  InstanceId: string | undefined;
  VpcId: string | undefined;
}
export interface DetachClassicLinkVpcResult {
  Return?: boolean;
}
export interface DetachInternetGatewayRequest {
  DryRun?: boolean;
  InternetGatewayId: string | undefined;
  VpcId: string | undefined;
}
export interface DetachNetworkInterfaceRequest {
  AttachmentId: string | undefined;
  DryRun?: boolean;
  Force?: boolean;
}
export interface DetachVerifiedAccessTrustProviderRequest {
  VerifiedAccessInstanceId: string | undefined;
  VerifiedAccessTrustProviderId: string | undefined;
  ClientToken?: string;
  DryRun?: boolean;
}
export interface DetachVerifiedAccessTrustProviderResult {
  VerifiedAccessTrustProvider?: VerifiedAccessTrustProvider;
  VerifiedAccessInstance?: VerifiedAccessInstance;
}
export interface DetachVolumeRequest {
  Device?: string;
  Force?: boolean;
  InstanceId?: string;
  VolumeId: string | undefined;
  DryRun?: boolean;
}
export interface DetachVpnGatewayRequest {
  VpcId: string | undefined;
  VpnGatewayId: string | undefined;
  DryRun?: boolean;
}
export interface DisableAddressTransferRequest {
  AllocationId: string | undefined;
  DryRun?: boolean;
}
export interface DisableAddressTransferResult {
  AddressTransfer?: AddressTransfer;
}
export interface DisableAwsNetworkPerformanceMetricSubscriptionRequest {
  Source?: string;
  Destination?: string;
  Metric?: MetricType | string;
  Statistic?: StatisticType | string;
  DryRun?: boolean;
}
export interface DisableAwsNetworkPerformanceMetricSubscriptionResult {
  Output?: boolean;
}
export interface DisableEbsEncryptionByDefaultRequest {
  DryRun?: boolean;
}
export interface DisableEbsEncryptionByDefaultResult {
  EbsEncryptionByDefault?: boolean;
}
export interface DisableFastLaunchRequest {
  ImageId: string | undefined;
  Force?: boolean;
  DryRun?: boolean;
}
export interface DisableFastLaunchResult {
  ImageId?: string;
  ResourceType?: FastLaunchResourceType | string;
  SnapshotConfiguration?: FastLaunchSnapshotConfigurationResponse;
  LaunchTemplate?: FastLaunchLaunchTemplateSpecificationResponse;
  MaxParallelLaunches?: number;
  OwnerId?: string;
  State?: FastLaunchStateCode | string;
  StateTransitionReason?: string;
  StateTransitionTime?: Date;
}
export interface DisableFastSnapshotRestoresRequest {
  AvailabilityZones: string[] | undefined;
  SourceSnapshotIds: string[] | undefined;
  DryRun?: boolean;
}
export interface DisableFastSnapshotRestoreSuccessItem {
  SnapshotId?: string;
  AvailabilityZone?: string;
  State?: FastSnapshotRestoreStateCode | string;
  StateTransitionReason?: string;
  OwnerId?: string;
  OwnerAlias?: string;
  EnablingTime?: Date;
  OptimizingTime?: Date;
  EnabledTime?: Date;
  DisablingTime?: Date;
  DisabledTime?: Date;
}
export interface DisableFastSnapshotRestoreStateError {
  Code?: string;
  Message?: string;
}
export interface DisableFastSnapshotRestoreStateErrorItem {
  AvailabilityZone?: string;
  Error?: DisableFastSnapshotRestoreStateError;
}
export interface DisableFastSnapshotRestoreErrorItem {
  SnapshotId?: string;
  FastSnapshotRestoreStateErrors?: DisableFastSnapshotRestoreStateErrorItem[];
}
export interface DisableFastSnapshotRestoresResult {
  Successful?: DisableFastSnapshotRestoreSuccessItem[];
  Unsuccessful?: DisableFastSnapshotRestoreErrorItem[];
}
export interface DisableImageDeprecationRequest {
  ImageId: string | undefined;
  DryRun?: boolean;
}
export interface DisableImageDeprecationResult {
  Return?: boolean;
}
export interface DisableIpamOrganizationAdminAccountRequest {
  DryRun?: boolean;
  DelegatedAdminAccountId: string | undefined;
}
export interface DisableIpamOrganizationAdminAccountResult {
  Success?: boolean;
}
export interface DisableSerialConsoleAccessRequest {
  DryRun?: boolean;
}
export interface DisableSerialConsoleAccessResult {
  SerialConsoleAccessEnabled?: boolean;
}
export interface DisableTransitGatewayRouteTablePropagationRequest {
  TransitGatewayRouteTableId: string | undefined;
  TransitGatewayAttachmentId?: string;
  DryRun?: boolean;
  TransitGatewayRouteTableAnnouncementId?: string;
}
export declare enum TransitGatewayPropagationState {
  disabled = "disabled",
  disabling = "disabling",
  enabled = "enabled",
  enabling = "enabling",
}
export interface TransitGatewayPropagation {
  TransitGatewayAttachmentId?: string;
  ResourceId?: string;
  ResourceType?: TransitGatewayAttachmentResourceType | string;
  TransitGatewayRouteTableId?: string;
  State?: TransitGatewayPropagationState | string;
  TransitGatewayRouteTableAnnouncementId?: string;
}
export interface DisableTransitGatewayRouteTablePropagationResult {
  Propagation?: TransitGatewayPropagation;
}
export interface DisableVgwRoutePropagationRequest {
  GatewayId: string | undefined;
  RouteTableId: string | undefined;
  DryRun?: boolean;
}
export interface DisableVpcClassicLinkRequest {
  DryRun?: boolean;
  VpcId: string | undefined;
}
export interface DisableVpcClassicLinkResult {
  Return?: boolean;
}
export interface DisableVpcClassicLinkDnsSupportRequest {
  VpcId?: string;
}
export interface DisableVpcClassicLinkDnsSupportResult {
  Return?: boolean;
}
export interface DisassociateAddressRequest {
  AssociationId?: string;
  PublicIp?: string;
  DryRun?: boolean;
}
export interface DisassociateClientVpnTargetNetworkRequest {
  ClientVpnEndpointId: string | undefined;
  AssociationId: string | undefined;
  DryRun?: boolean;
}
export interface DisassociateClientVpnTargetNetworkResult {
  AssociationId?: string;
  Status?: AssociationStatus;
}
export interface DisassociateEnclaveCertificateIamRoleRequest {
  CertificateArn?: string;
  RoleArn?: string;
  DryRun?: boolean;
}
export interface DisassociateEnclaveCertificateIamRoleResult {
  Return?: boolean;
}
export interface DisassociateIamInstanceProfileRequest {
  AssociationId: string | undefined;
}
export interface DisassociateIamInstanceProfileResult {
  IamInstanceProfileAssociation?: IamInstanceProfileAssociation;
}
export interface InstanceEventWindowDisassociationRequest {
  InstanceIds?: string[];
  InstanceTags?: Tag[];
  DedicatedHostIds?: string[];
}
export interface DisassociateInstanceEventWindowRequest {
  DryRun?: boolean;
  InstanceEventWindowId: string | undefined;
  AssociationTarget: InstanceEventWindowDisassociationRequest | undefined;
}
export interface DisassociateInstanceEventWindowResult {
  InstanceEventWindow?: InstanceEventWindow;
}
export interface DisassociateRouteTableRequest {
  AssociationId: string | undefined;
  DryRun?: boolean;
}
export interface DisassociateSubnetCidrBlockRequest {
  AssociationId: string | undefined;
}
export interface DisassociateSubnetCidrBlockResult {
  Ipv6CidrBlockAssociation?: SubnetIpv6CidrBlockAssociation;
  SubnetId?: string;
}
export interface DisassociateTransitGatewayMulticastDomainRequest {
  TransitGatewayMulticastDomainId?: string;
  TransitGatewayAttachmentId?: string;
  SubnetIds?: string[];
  DryRun?: boolean;
}
export interface DisassociateTransitGatewayMulticastDomainResult {
  Associations?: TransitGatewayMulticastDomainAssociations;
}
export interface DisassociateTransitGatewayPolicyTableRequest {
  TransitGatewayPolicyTableId: string | undefined;
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean;
}
export interface DisassociateTransitGatewayPolicyTableResult {
  Association?: TransitGatewayPolicyTableAssociation;
}
export interface DisassociateTransitGatewayRouteTableRequest {
  TransitGatewayRouteTableId: string | undefined;
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean;
}
export interface DisassociateTransitGatewayRouteTableResult {
  Association?: TransitGatewayAssociation;
}
export interface DisassociateTrunkInterfaceRequest {
  AssociationId: string | undefined;
  ClientToken?: string;
  DryRun?: boolean;
}
export interface DisassociateTrunkInterfaceResult {
  Return?: boolean;
  ClientToken?: string;
}
export interface DisassociateVpcCidrBlockRequest {
  AssociationId: string | undefined;
}
export interface DisassociateVpcCidrBlockResult {
  Ipv6CidrBlockAssociation?: VpcIpv6CidrBlockAssociation;
  CidrBlockAssociation?: VpcCidrBlockAssociation;
  VpcId?: string;
}
export interface EnableAddressTransferRequest {
  AllocationId: string | undefined;
  TransferAccountId: string | undefined;
  DryRun?: boolean;
}
export interface EnableAddressTransferResult {
  AddressTransfer?: AddressTransfer;
}
export interface EnableAwsNetworkPerformanceMetricSubscriptionRequest {
  Source?: string;
  Destination?: string;
  Metric?: MetricType | string;
  Statistic?: StatisticType | string;
  DryRun?: boolean;
}
export interface EnableAwsNetworkPerformanceMetricSubscriptionResult {
  Output?: boolean;
}
export interface EnableEbsEncryptionByDefaultRequest {
  DryRun?: boolean;
}
export interface EnableEbsEncryptionByDefaultResult {
  EbsEncryptionByDefault?: boolean;
}
export interface FastLaunchLaunchTemplateSpecificationRequest {
  LaunchTemplateId?: string;
  LaunchTemplateName?: string;
  Version: string | undefined;
}
export interface FastLaunchSnapshotConfigurationRequest {
  TargetResourceCount?: number;
}
export interface EnableFastLaunchRequest {
  ImageId: string | undefined;
  ResourceType?: string;
  SnapshotConfiguration?: FastLaunchSnapshotConfigurationRequest;
  LaunchTemplate?: FastLaunchLaunchTemplateSpecificationRequest;
  MaxParallelLaunches?: number;
  DryRun?: boolean;
}
export interface EnableFastLaunchResult {
  ImageId?: string;
  ResourceType?: FastLaunchResourceType | string;
  SnapshotConfiguration?: FastLaunchSnapshotConfigurationResponse;
  LaunchTemplate?: FastLaunchLaunchTemplateSpecificationResponse;
  MaxParallelLaunches?: number;
  OwnerId?: string;
  State?: FastLaunchStateCode | string;
  StateTransitionReason?: string;
  StateTransitionTime?: Date;
}
export interface EnableFastSnapshotRestoresRequest {
  AvailabilityZones: string[] | undefined;
  SourceSnapshotIds: string[] | undefined;
  DryRun?: boolean;
}
export interface EnableFastSnapshotRestoreSuccessItem {
  SnapshotId?: string;
  AvailabilityZone?: string;
  State?: FastSnapshotRestoreStateCode | string;
  StateTransitionReason?: string;
  OwnerId?: string;
  OwnerAlias?: string;
  EnablingTime?: Date;
  OptimizingTime?: Date;
  EnabledTime?: Date;
  DisablingTime?: Date;
  DisabledTime?: Date;
}
export interface EnableFastSnapshotRestoreStateError {
  Code?: string;
  Message?: string;
}
export interface EnableFastSnapshotRestoreStateErrorItem {
  AvailabilityZone?: string;
  Error?: EnableFastSnapshotRestoreStateError;
}
export interface EnableFastSnapshotRestoreErrorItem {
  SnapshotId?: string;
  FastSnapshotRestoreStateErrors?: EnableFastSnapshotRestoreStateErrorItem[];
}
export interface EnableFastSnapshotRestoresResult {
  Successful?: EnableFastSnapshotRestoreSuccessItem[];
  Unsuccessful?: EnableFastSnapshotRestoreErrorItem[];
}
export interface EnableImageDeprecationRequest {
  ImageId: string | undefined;
  DeprecateAt: Date | undefined;
  DryRun?: boolean;
}
export interface EnableImageDeprecationResult {
  Return?: boolean;
}
export interface EnableIpamOrganizationAdminAccountRequest {
  DryRun?: boolean;
  DelegatedAdminAccountId: string | undefined;
}
export interface EnableIpamOrganizationAdminAccountResult {
  Success?: boolean;
}
export interface EnableReachabilityAnalyzerOrganizationSharingRequest {
  DryRun?: boolean;
}
export interface EnableReachabilityAnalyzerOrganizationSharingResult {
  ReturnValue?: boolean;
}
export interface EnableSerialConsoleAccessRequest {
  DryRun?: boolean;
}
export interface EnableSerialConsoleAccessResult {
  SerialConsoleAccessEnabled?: boolean;
}
export interface EnableTransitGatewayRouteTablePropagationRequest {
  TransitGatewayRouteTableId: string | undefined;
  TransitGatewayAttachmentId?: string;
  DryRun?: boolean;
  TransitGatewayRouteTableAnnouncementId?: string;
}
export interface EnableTransitGatewayRouteTablePropagationResult {
  Propagation?: TransitGatewayPropagation;
}
export interface EnableVgwRoutePropagationRequest {
  GatewayId: string | undefined;
  RouteTableId: string | undefined;
  DryRun?: boolean;
}
export interface EnableVolumeIORequest {
  DryRun?: boolean;
  VolumeId: string | undefined;
}
export interface EnableVpcClassicLinkRequest {
  DryRun?: boolean;
  VpcId: string | undefined;
}
export interface EnableVpcClassicLinkResult {
  Return?: boolean;
}
export interface EnableVpcClassicLinkDnsSupportRequest {
  VpcId?: string;
}
export interface EnableVpcClassicLinkDnsSupportResult {
  Return?: boolean;
}
export interface ExportClientVpnClientCertificateRevocationListRequest {
  ClientVpnEndpointId: string | undefined;
  DryRun?: boolean;
}
export declare enum ClientCertificateRevocationListStatusCode {
  active = "active",
  pending = "pending",
}
export interface ClientCertificateRevocationListStatus {
  Code?: ClientCertificateRevocationListStatusCode | string;
  Message?: string;
}
export interface ExportClientVpnClientCertificateRevocationListResult {
  CertificateRevocationList?: string;
  Status?: ClientCertificateRevocationListStatus;
}
export interface ExportClientVpnClientConfigurationRequest {
  ClientVpnEndpointId: string | undefined;
  DryRun?: boolean;
}
export interface ExportClientVpnClientConfigurationResult {
  ClientConfiguration?: string;
}
export interface ExportTaskS3LocationRequest {
  S3Bucket: string | undefined;
  S3Prefix?: string;
}
export interface ExportImageRequest {
  ClientToken?: string;
  Description?: string;
  DiskImageFormat: DiskImageFormat | string | undefined;
  DryRun?: boolean;
  ImageId: string | undefined;
  S3ExportLocation: ExportTaskS3LocationRequest | undefined;
  RoleName?: string;
  TagSpecifications?: TagSpecification[];
}
export interface ExportImageResult {
  Description?: string;
  DiskImageFormat?: DiskImageFormat | string;
  ExportImageTaskId?: string;
  ImageId?: string;
  RoleName?: string;
  Progress?: string;
  S3ExportLocation?: ExportTaskS3Location;
  Status?: string;
  StatusMessage?: string;
  Tags?: Tag[];
}
export interface ExportTransitGatewayRoutesRequest {
  TransitGatewayRouteTableId: string | undefined;
  Filters?: Filter[];
  S3Bucket: string | undefined;
  DryRun?: boolean;
}
export interface ExportTransitGatewayRoutesResult {
  S3Location?: string;
}
export interface GetAssociatedEnclaveCertificateIamRolesRequest {
  CertificateArn?: string;
  DryRun?: boolean;
}
export interface AssociatedRole {
  AssociatedRoleArn?: string;
  CertificateS3BucketName?: string;
  CertificateS3ObjectKey?: string;
  EncryptionKmsKeyId?: string;
}
export interface GetAssociatedEnclaveCertificateIamRolesResult {
  AssociatedRoles?: AssociatedRole[];
}
export interface GetAssociatedIpv6PoolCidrsRequest {
  PoolId: string | undefined;
  NextToken?: string;
  MaxResults?: number;
  DryRun?: boolean;
}
export interface Ipv6CidrAssociation {
  Ipv6Cidr?: string;
  AssociatedResource?: string;
}
export interface GetAssociatedIpv6PoolCidrsResult {
  Ipv6CidrAssociations?: Ipv6CidrAssociation[];
  NextToken?: string;
}
export interface DataQuery {
  Id?: string;
  Source?: string;
  Destination?: string;
  Metric?: MetricType | string;
  Statistic?: StatisticType | string;
  Period?: PeriodType | string;
}
export interface GetAwsNetworkPerformanceDataRequest {
  DataQueries?: DataQuery[];
  StartTime?: Date;
  EndTime?: Date;
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface MetricPoint {
  StartDate?: Date;
  EndDate?: Date;
  Value?: number;
  Status?: string;
}
export interface DataResponse {
  Id?: string;
  Source?: string;
  Destination?: string;
  Metric?: MetricType | string;
  Statistic?: StatisticType | string;
  Period?: PeriodType | string;
  MetricPoints?: MetricPoint[];
}
export interface GetAwsNetworkPerformanceDataResult {
  DataResponses?: DataResponse[];
  NextToken?: string;
}
export interface GetCapacityReservationUsageRequest {
  CapacityReservationId: string | undefined;
  NextToken?: string;
  MaxResults?: number;
  DryRun?: boolean;
}
export interface InstanceUsage {
  AccountId?: string;
  UsedInstanceCount?: number;
}
export interface GetCapacityReservationUsageResult {
  NextToken?: string;
  CapacityReservationId?: string;
  InstanceType?: string;
  TotalInstanceCount?: number;
  AvailableInstanceCount?: number;
  State?: CapacityReservationState | string;
  InstanceUsages?: InstanceUsage[];
}
export interface GetCoipPoolUsageRequest {
  PoolId: string | undefined;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface CoipAddressUsage {
  AllocationId?: string;
  AwsAccountId?: string;
  AwsService?: string;
  CoIp?: string;
}
export interface GetCoipPoolUsageResult {
  CoipPoolId?: string;
  CoipAddressUsages?: CoipAddressUsage[];
  LocalGatewayRouteTableId?: string;
}
export interface GetConsoleOutputRequest {
  InstanceId: string | undefined;
  DryRun?: boolean;
  Latest?: boolean;
}
export interface GetConsoleOutputResult {
  InstanceId?: string;
  Output?: string;
  Timestamp?: Date;
}
export interface GetConsoleScreenshotRequest {
  DryRun?: boolean;
  InstanceId: string | undefined;
  WakeUp?: boolean;
}
export interface GetConsoleScreenshotResult {
  ImageData?: string;
  InstanceId?: string;
}
export declare enum UnlimitedSupportedInstanceFamily {
  t2 = "t2",
  t3 = "t3",
  t3a = "t3a",
  t4g = "t4g",
}
export interface GetDefaultCreditSpecificationRequest {
  DryRun?: boolean;
  InstanceFamily: UnlimitedSupportedInstanceFamily | string | undefined;
}
export interface InstanceFamilyCreditSpecification {
  InstanceFamily?: UnlimitedSupportedInstanceFamily | string;
  CpuCredits?: string;
}
export interface GetDefaultCreditSpecificationResult {
  InstanceFamilyCreditSpecification?: InstanceFamilyCreditSpecification;
}
export interface GetEbsDefaultKmsKeyIdRequest {
  DryRun?: boolean;
}
export interface GetEbsDefaultKmsKeyIdResult {
  KmsKeyId?: string;
}
export interface GetEbsEncryptionByDefaultRequest {
  DryRun?: boolean;
}
export interface GetEbsEncryptionByDefaultResult {
  EbsEncryptionByDefault?: boolean;
}
export declare enum PartitionLoadFrequency {
  DAILY = "daily",
  MONTHLY = "monthly",
  NONE = "none",
  WEEKLY = "weekly",
}
export interface AthenaIntegration {
  IntegrationResultS3DestinationArn: string | undefined;
  PartitionLoadFrequency: PartitionLoadFrequency | string | undefined;
  PartitionStartDate?: Date;
  PartitionEndDate?: Date;
}
export interface IntegrateServices {
  AthenaIntegrations?: AthenaIntegration[];
}
export interface GetFlowLogsIntegrationTemplateRequest {
  DryRun?: boolean;
  FlowLogId: string | undefined;
  ConfigDeliveryS3DestinationArn: string | undefined;
  IntegrateServices: IntegrateServices | undefined;
}
export interface GetFlowLogsIntegrationTemplateResult {
  Result?: string;
}
export interface GetGroupsForCapacityReservationRequest {
  CapacityReservationId: string | undefined;
  NextToken?: string;
  MaxResults?: number;
  DryRun?: boolean;
}
export interface CapacityReservationGroup {
  GroupArn?: string;
  OwnerId?: string;
}
export interface GetGroupsForCapacityReservationResult {
  NextToken?: string;
  CapacityReservationGroups?: CapacityReservationGroup[];
}
export interface GetHostReservationPurchasePreviewRequest {
  HostIdSet: string[] | undefined;
  OfferingId: string | undefined;
}
export interface Purchase {
  CurrencyCode?: CurrencyCodeValues | string;
  Duration?: number;
  HostIdSet?: string[];
  HostReservationId?: string;
  HourlyPrice?: string;
  InstanceFamily?: string;
  PaymentOption?: PaymentOption | string;
  UpfrontPrice?: string;
}
export interface GetHostReservationPurchasePreviewResult {
  CurrencyCode?: CurrencyCodeValues | string;
  Purchase?: Purchase[];
  TotalHourlyPrice?: string;
  TotalUpfrontPrice?: string;
}
export interface GetInstanceTypesFromInstanceRequirementsRequest {
  DryRun?: boolean;
  ArchitectureTypes: (ArchitectureType | string)[] | undefined;
  VirtualizationTypes: (VirtualizationType | string)[] | undefined;
  InstanceRequirements: InstanceRequirementsRequest | undefined;
  MaxResults?: number;
  NextToken?: string;
}
export interface InstanceTypeInfoFromInstanceRequirements {
  InstanceType?: string;
}
export interface GetInstanceTypesFromInstanceRequirementsResult {
  InstanceTypes?: InstanceTypeInfoFromInstanceRequirements[];
  NextToken?: string;
}
export interface GetInstanceUefiDataRequest {
  InstanceId: string | undefined;
  DryRun?: boolean;
}
export interface GetInstanceUefiDataResult {
  InstanceId?: string;
  UefiData?: string;
}
export interface GetIpamAddressHistoryRequest {
  DryRun?: boolean;
  Cidr: string | undefined;
  IpamScopeId: string | undefined;
  VpcId?: string;
  StartTime?: Date;
  EndTime?: Date;
  MaxResults?: number;
  NextToken?: string;
}
export declare enum IpamComplianceStatus {
  compliant = "compliant",
  ignored = "ignored",
  noncompliant = "noncompliant",
  unmanaged = "unmanaged",
}
export declare enum IpamOverlapStatus {
  ignored = "ignored",
  nonoverlapping = "nonoverlapping",
  overlapping = "overlapping",
}
export declare enum IpamAddressHistoryResourceType {
  eip = "eip",
  instance = "instance",
  network_interface = "network-interface",
  subnet = "subnet",
  vpc = "vpc",
}
export interface IpamAddressHistoryRecord {
  ResourceOwnerId?: string;
  ResourceRegion?: string;
  ResourceType?: IpamAddressHistoryResourceType | string;
  ResourceId?: string;
  ResourceCidr?: string;
  ResourceName?: string;
  ResourceComplianceStatus?: IpamComplianceStatus | string;
  ResourceOverlapStatus?: IpamOverlapStatus | string;
  VpcId?: string;
  SampledStartTime?: Date;
  SampledEndTime?: Date;
}
export interface GetIpamAddressHistoryResult {
  HistoryRecords?: IpamAddressHistoryRecord[];
  NextToken?: string;
}
export interface GetIpamPoolAllocationsRequest {
  DryRun?: boolean;
  IpamPoolId: string | undefined;
  IpamPoolAllocationId?: string;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface GetIpamPoolAllocationsResult {
  IpamPoolAllocations?: IpamPoolAllocation[];
  NextToken?: string;
}
export interface GetIpamPoolCidrsRequest {
  DryRun?: boolean;
  IpamPoolId: string | undefined;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface GetIpamPoolCidrsResult {
  IpamPoolCidrs?: IpamPoolCidr[];
  NextToken?: string;
}
export declare enum IpamResourceType {
  eip = "eip",
  ipv6_pool = "ipv6-pool",
  public_ipv4_pool = "public-ipv4-pool",
  subnet = "subnet",
  vpc = "vpc",
}
export interface GetIpamResourceCidrsRequest {
  DryRun?: boolean;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  IpamScopeId: string | undefined;
  IpamPoolId?: string;
  ResourceId?: string;
  ResourceType?: IpamResourceType | string;
  ResourceTag?: RequestIpamResourceTag;
  ResourceOwner?: string;
}
export declare enum IpamManagementState {
  ignored = "ignored",
  managed = "managed",
  unmanaged = "unmanaged",
}
export interface IpamResourceCidr {
  IpamId?: string;
  IpamScopeId?: string;
  IpamPoolId?: string;
  ResourceRegion?: string;
  ResourceOwnerId?: string;
  ResourceId?: string;
  ResourceName?: string;
  ResourceCidr?: string;
  ResourceType?: IpamResourceType | string;
  ResourceTags?: IpamResourceTag[];
  IpUsage?: number;
  ComplianceStatus?: IpamComplianceStatus | string;
  ManagementState?: IpamManagementState | string;
  OverlapStatus?: IpamOverlapStatus | string;
  VpcId?: string;
}
export interface GetIpamResourceCidrsResult {
  NextToken?: string;
  IpamResourceCidrs?: IpamResourceCidr[];
}
export interface GetLaunchTemplateDataRequest {
  DryRun?: boolean;
  InstanceId: string | undefined;
}
export interface GetLaunchTemplateDataResult {
  LaunchTemplateData?: ResponseLaunchTemplateData;
}
export interface GetManagedPrefixListAssociationsRequest {
  DryRun?: boolean;
  PrefixListId: string | undefined;
  MaxResults?: number;
  NextToken?: string;
}
export interface PrefixListAssociation {
  ResourceId?: string;
  ResourceOwner?: string;
}
export interface GetManagedPrefixListAssociationsResult {
  PrefixListAssociations?: PrefixListAssociation[];
  NextToken?: string;
}
export interface GetManagedPrefixListEntriesRequest {
  DryRun?: boolean;
  PrefixListId: string | undefined;
  TargetVersion?: number;
  MaxResults?: number;
  NextToken?: string;
}
export interface PrefixListEntry {
  Cidr?: string;
  Description?: string;
}
export interface GetManagedPrefixListEntriesResult {
  Entries?: PrefixListEntry[];
  NextToken?: string;
}
export interface GetNetworkInsightsAccessScopeAnalysisFindingsRequest {
  NetworkInsightsAccessScopeAnalysisId: string | undefined;
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface GetNetworkInsightsAccessScopeAnalysisFindingsResult {
  NetworkInsightsAccessScopeAnalysisId?: string;
  AnalysisStatus?: AnalysisStatus | string;
  AnalysisFindings?: AccessScopeAnalysisFinding[];
  NextToken?: string;
}
export interface GetNetworkInsightsAccessScopeContentRequest {
  NetworkInsightsAccessScopeId: string | undefined;
  DryRun?: boolean;
}
export interface GetNetworkInsightsAccessScopeContentResult {
  NetworkInsightsAccessScopeContent?: NetworkInsightsAccessScopeContent;
}
export interface GetPasswordDataRequest {
  InstanceId: string | undefined;
  DryRun?: boolean;
}
export interface GetPasswordDataResult {
  InstanceId?: string;
  PasswordData?: string;
  Timestamp?: Date;
}
export interface GetReservedInstancesExchangeQuoteRequest {
  DryRun?: boolean;
  ReservedInstanceIds: string[] | undefined;
  TargetConfigurations?: TargetConfigurationRequest[];
}
export interface ReservationValue {
  HourlyPrice?: string;
  RemainingTotalValue?: string;
  RemainingUpfrontValue?: string;
}
export interface ReservedInstanceReservationValue {
  ReservationValue?: ReservationValue;
  ReservedInstanceId?: string;
}
export interface TargetConfiguration {
  InstanceCount?: number;
  OfferingId?: string;
}
export interface TargetReservationValue {
  ReservationValue?: ReservationValue;
  TargetConfiguration?: TargetConfiguration;
}
export interface GetReservedInstancesExchangeQuoteResult {
  CurrencyCode?: string;
  IsValidExchange?: boolean;
  OutputReservedInstancesWillExpireAt?: Date;
  PaymentDue?: string;
  ReservedInstanceValueRollup?: ReservationValue;
  ReservedInstanceValueSet?: ReservedInstanceReservationValue[];
  TargetConfigurationValueRollup?: ReservationValue;
  TargetConfigurationValueSet?: TargetReservationValue[];
  ValidationFailureReason?: string;
}
export interface GetSerialConsoleAccessStatusRequest {
  DryRun?: boolean;
}
export interface GetSerialConsoleAccessStatusResult {
  SerialConsoleAccessEnabled?: boolean;
}
export interface InstanceRequirementsWithMetadataRequest {
  ArchitectureTypes?: (ArchitectureType | string)[];
  VirtualizationTypes?: (VirtualizationType | string)[];
  InstanceRequirements?: InstanceRequirementsRequest;
}
export interface GetSpotPlacementScoresRequest {
  InstanceTypes?: string[];
  TargetCapacity: number | undefined;
  TargetCapacityUnitType?: TargetCapacityUnitType | string;
  SingleAvailabilityZone?: boolean;
  RegionNames?: string[];
  InstanceRequirementsWithMetadata?: InstanceRequirementsWithMetadataRequest;
  DryRun?: boolean;
  MaxResults?: number;
  NextToken?: string;
}
export interface SpotPlacementScore {
  Region?: string;
  AvailabilityZoneId?: string;
  Score?: number;
}
export interface GetSpotPlacementScoresResult {
  SpotPlacementScores?: SpotPlacementScore[];
  NextToken?: string;
}
export interface GetSubnetCidrReservationsRequest {
  Filters?: Filter[];
  SubnetId: string | undefined;
  DryRun?: boolean;
  NextToken?: string;
  MaxResults?: number;
}
export interface GetSubnetCidrReservationsResult {
  SubnetIpv4CidrReservations?: SubnetCidrReservation[];
  SubnetIpv6CidrReservations?: SubnetCidrReservation[];
  NextToken?: string;
}
export interface GetTransitGatewayAttachmentPropagationsRequest {
  TransitGatewayAttachmentId: string | undefined;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface TransitGatewayAttachmentPropagation {
  TransitGatewayRouteTableId?: string;
  State?: TransitGatewayPropagationState | string;
}
export interface GetTransitGatewayAttachmentPropagationsResult {
  TransitGatewayAttachmentPropagations?: TransitGatewayAttachmentPropagation[];
  NextToken?: string;
}
export interface GetTransitGatewayMulticastDomainAssociationsRequest {
  TransitGatewayMulticastDomainId?: string;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface TransitGatewayMulticastDomainAssociation {
  TransitGatewayAttachmentId?: string;
  ResourceId?: string;
  ResourceType?: TransitGatewayAttachmentResourceType | string;
  ResourceOwnerId?: string;
  Subnet?: SubnetAssociation;
}
export interface GetTransitGatewayMulticastDomainAssociationsResult {
  MulticastDomainAssociations?: TransitGatewayMulticastDomainAssociation[];
  NextToken?: string;
}
export interface GetTransitGatewayPolicyTableAssociationsRequest {
  TransitGatewayPolicyTableId: string | undefined;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface GetTransitGatewayPolicyTableAssociationsResult {
  Associations?: TransitGatewayPolicyTableAssociation[];
  NextToken?: string;
}
export interface GetTransitGatewayPolicyTableEntriesRequest {
  TransitGatewayPolicyTableId: string | undefined;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface TransitGatewayPolicyRuleMetaData {
  MetaDataKey?: string;
  MetaDataValue?: string;
}
export interface TransitGatewayPolicyRule {
  SourceCidrBlock?: string;
  SourcePortRange?: string;
  DestinationCidrBlock?: string;
  DestinationPortRange?: string;
  Protocol?: string;
  MetaData?: TransitGatewayPolicyRuleMetaData;
}
export interface TransitGatewayPolicyTableEntry {
  PolicyRuleNumber?: string;
  PolicyRule?: TransitGatewayPolicyRule;
  TargetRouteTableId?: string;
}
export interface GetTransitGatewayPolicyTableEntriesResult {
  TransitGatewayPolicyTableEntries?: TransitGatewayPolicyTableEntry[];
}
export interface GetTransitGatewayPrefixListReferencesRequest {
  TransitGatewayRouteTableId: string | undefined;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface GetTransitGatewayPrefixListReferencesResult {
  TransitGatewayPrefixListReferences?: TransitGatewayPrefixListReference[];
  NextToken?: string;
}
export interface GetTransitGatewayRouteTableAssociationsRequest {
  TransitGatewayRouteTableId: string | undefined;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface TransitGatewayRouteTableAssociation {
  TransitGatewayAttachmentId?: string;
  ResourceId?: string;
  ResourceType?: TransitGatewayAttachmentResourceType | string;
  State?: TransitGatewayAssociationState | string;
}
export interface GetTransitGatewayRouteTableAssociationsResult {
  Associations?: TransitGatewayRouteTableAssociation[];
  NextToken?: string;
}
export interface GetTransitGatewayRouteTablePropagationsRequest {
  TransitGatewayRouteTableId: string | undefined;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface TransitGatewayRouteTablePropagation {
  TransitGatewayAttachmentId?: string;
  ResourceId?: string;
  ResourceType?: TransitGatewayAttachmentResourceType | string;
  State?: TransitGatewayPropagationState | string;
  TransitGatewayRouteTableAnnouncementId?: string;
}
export interface GetTransitGatewayRouteTablePropagationsResult {
  TransitGatewayRouteTablePropagations?: TransitGatewayRouteTablePropagation[];
  NextToken?: string;
}
export interface GetVerifiedAccessEndpointPolicyRequest {
  VerifiedAccessEndpointId: string | undefined;
  DryRun?: boolean;
}
export interface GetVerifiedAccessEndpointPolicyResult {
  PolicyEnabled?: boolean;
  PolicyDocument?: string;
}
export interface GetVerifiedAccessGroupPolicyRequest {
  VerifiedAccessGroupId: string | undefined;
  DryRun?: boolean;
}
export interface GetVerifiedAccessGroupPolicyResult {
  PolicyEnabled?: boolean;
  PolicyDocument?: string;
}
export interface GetVpnConnectionDeviceSampleConfigurationRequest {
  VpnConnectionId: string | undefined;
  VpnConnectionDeviceTypeId: string | undefined;
  InternetKeyExchangeVersion?: string;
  DryRun?: boolean;
}
export interface GetVpnConnectionDeviceSampleConfigurationResult {
  VpnConnectionDeviceSampleConfiguration?: string;
}
export interface GetVpnConnectionDeviceTypesRequest {
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface VpnConnectionDeviceType {
  VpnConnectionDeviceTypeId?: string;
  Vendor?: string;
  Platform?: string;
  Software?: string;
}
export interface GetVpnConnectionDeviceTypesResult {
  VpnConnectionDeviceTypes?: VpnConnectionDeviceType[];
  NextToken?: string;
}
export interface ImportClientVpnClientCertificateRevocationListRequest {
  ClientVpnEndpointId: string | undefined;
  CertificateRevocationList: string | undefined;
  DryRun?: boolean;
}
export interface ImportClientVpnClientCertificateRevocationListResult {
  Return?: boolean;
}
export interface ClientData {
  Comment?: string;
  UploadEnd?: Date;
  UploadSize?: number;
  UploadStart?: Date;
}
export interface UserBucket {
  S3Bucket?: string;
  S3Key?: string;
}
export interface ImageDiskContainer {
  Description?: string;
  DeviceName?: string;
  Format?: string;
  SnapshotId?: string;
  Url?: string;
  UserBucket?: UserBucket;
}
export interface ImportImageLicenseConfigurationRequest {
  LicenseConfigurationArn?: string;
}
export interface ImportImageRequest {
  Architecture?: string;
  ClientData?: ClientData;
  ClientToken?: string;
  Description?: string;
  DiskContainers?: ImageDiskContainer[];
  DryRun?: boolean;
  Encrypted?: boolean;
  Hypervisor?: string;
  KmsKeyId?: string;
  LicenseType?: string;
  Platform?: string;
  RoleName?: string;
  LicenseSpecifications?: ImportImageLicenseConfigurationRequest[];
  TagSpecifications?: TagSpecification[];
  UsageOperation?: string;
  BootMode?: BootModeValues | string;
}
export interface ImportImageResult {
  Architecture?: string;
  Description?: string;
  Encrypted?: boolean;
  Hypervisor?: string;
  ImageId?: string;
  ImportTaskId?: string;
  KmsKeyId?: string;
  LicenseType?: string;
  Platform?: string;
  Progress?: string;
  SnapshotDetails?: SnapshotDetail[];
  Status?: string;
  StatusMessage?: string;
  LicenseSpecifications?: ImportImageLicenseConfigurationResponse[];
  Tags?: Tag[];
  UsageOperation?: string;
}
export interface DiskImageDetail {
  Bytes: number | undefined;
  Format: DiskImageFormat | string | undefined;
  ImportManifestUrl: string | undefined;
}
export interface VolumeDetail {
  Size: number | undefined;
}
export interface DiskImage {
  Description?: string;
  Image?: DiskImageDetail;
  Volume?: VolumeDetail;
}
export interface UserData {
  Data?: string;
}
export interface ImportInstanceLaunchSpecification {
  AdditionalInfo?: string;
  Architecture?: ArchitectureValues | string;
  GroupIds?: string[];
  GroupNames?: string[];
  InstanceInitiatedShutdownBehavior?: ShutdownBehavior | string;
  InstanceType?: _InstanceType | string;
  Monitoring?: boolean;
  Placement?: Placement;
  PrivateIpAddress?: string;
  SubnetId?: string;
  UserData?: UserData;
}
export interface ImportInstanceRequest {
  Description?: string;
  DiskImages?: DiskImage[];
  DryRun?: boolean;
  LaunchSpecification?: ImportInstanceLaunchSpecification;
  Platform: PlatformValues | string | undefined;
}
export interface ImportInstanceResult {
  ConversionTask?: ConversionTask;
}
export interface ImportKeyPairRequest {
  DryRun?: boolean;
  KeyName: string | undefined;
  PublicKeyMaterial: Uint8Array | undefined;
  TagSpecifications?: TagSpecification[];
}
export interface ImportKeyPairResult {
  KeyFingerprint?: string;
  KeyName?: string;
  KeyPairId?: string;
  Tags?: Tag[];
}
export interface SnapshotDiskContainer {
  Description?: string;
  Format?: string;
  Url?: string;
  UserBucket?: UserBucket;
}
export interface ImportSnapshotRequest {
  ClientData?: ClientData;
  ClientToken?: string;
  Description?: string;
  DiskContainer?: SnapshotDiskContainer;
  DryRun?: boolean;
  Encrypted?: boolean;
  KmsKeyId?: string;
  RoleName?: string;
  TagSpecifications?: TagSpecification[];
}
export interface ImportSnapshotResult {
  Description?: string;
  ImportTaskId?: string;
  SnapshotTaskDetail?: SnapshotTaskDetail;
  Tags?: Tag[];
}
export interface ImportVolumeRequest {
  AvailabilityZone: string | undefined;
  Description?: string;
  DryRun?: boolean;
  Image: DiskImageDetail | undefined;
  Volume: VolumeDetail | undefined;
}
export interface ImportVolumeResult {
  ConversionTask?: ConversionTask;
}
export interface ListImagesInRecycleBinRequest {
  ImageIds?: string[];
  NextToken?: string;
  MaxResults?: number;
  DryRun?: boolean;
}
export interface ImageRecycleBinInfo {
  ImageId?: string;
  Name?: string;
  Description?: string;
  RecycleBinEnterTime?: Date;
  RecycleBinExitTime?: Date;
}
export interface ListImagesInRecycleBinResult {
  Images?: ImageRecycleBinInfo[];
  NextToken?: string;
}
export interface ListSnapshotsInRecycleBinRequest {
  MaxResults?: number;
  NextToken?: string;
  SnapshotIds?: string[];
  DryRun?: boolean;
}
export interface SnapshotRecycleBinInfo {
  SnapshotId?: string;
  RecycleBinEnterTime?: Date;
  RecycleBinExitTime?: Date;
  Description?: string;
  VolumeId?: string;
}
export interface ListSnapshotsInRecycleBinResult {
  Snapshots?: SnapshotRecycleBinInfo[];
  NextToken?: string;
}
export interface ModifyAddressAttributeRequest {
  AllocationId: string | undefined;
  DomainName?: string;
  DryRun?: boolean;
}
export interface ModifyAddressAttributeResult {
  Address?: AddressAttribute;
}
export declare enum ModifyAvailabilityZoneOptInStatus {
  not_opted_in = "not-opted-in",
  opted_in = "opted-in",
}
export interface ModifyAvailabilityZoneGroupRequest {
  GroupName: string | undefined;
  OptInStatus: ModifyAvailabilityZoneOptInStatus | string | undefined;
  DryRun?: boolean;
}
export interface ModifyAvailabilityZoneGroupResult {
  Return?: boolean;
}
export interface ModifyCapacityReservationRequest {
  CapacityReservationId: string | undefined;
  InstanceCount?: number;
  EndDate?: Date;
  EndDateType?: EndDateType | string;
  Accept?: boolean;
  DryRun?: boolean;
  AdditionalInfo?: string;
}
export interface ModifyCapacityReservationResult {
  Return?: boolean;
}
export interface ModifyCapacityReservationFleetRequest {
  CapacityReservationFleetId: string | undefined;
  TotalTargetCapacity?: number;
  EndDate?: Date;
  DryRun?: boolean;
  RemoveEndDate?: boolean;
}
export interface ModifyCapacityReservationFleetResult {
  Return?: boolean;
}
export interface DnsServersOptionsModifyStructure {
  CustomDnsServers?: string[];
  Enabled?: boolean;
}
export interface ModifyClientVpnEndpointRequest {
  ClientVpnEndpointId: string | undefined;
  ServerCertificateArn?: string;
  ConnectionLogOptions?: ConnectionLogOptions;
  DnsServers?: DnsServersOptionsModifyStructure;
  VpnPort?: number;
  Description?: string;
  SplitTunnel?: boolean;
  DryRun?: boolean;
  SecurityGroupIds?: string[];
  VpcId?: string;
  SelfServicePortal?: SelfServicePortal | string;
  ClientConnectOptions?: ClientConnectOptions;
  SessionTimeoutHours?: number;
  ClientLoginBannerOptions?: ClientLoginBannerOptions;
}
export interface ModifyClientVpnEndpointResult {
  Return?: boolean;
}
export interface ModifyDefaultCreditSpecificationRequest {
  DryRun?: boolean;
  InstanceFamily: UnlimitedSupportedInstanceFamily | string | undefined;
  CpuCredits: string | undefined;
}
export interface ModifyDefaultCreditSpecificationResult {
  InstanceFamilyCreditSpecification?: InstanceFamilyCreditSpecification;
}
export interface ModifyEbsDefaultKmsKeyIdRequest {
  KmsKeyId: string | undefined;
  DryRun?: boolean;
}
export interface ModifyEbsDefaultKmsKeyIdResult {
  KmsKeyId?: string;
}
export interface ModifyFleetRequest {
  DryRun?: boolean;
  ExcessCapacityTerminationPolicy?:
    | FleetExcessCapacityTerminationPolicy
    | string;
  LaunchTemplateConfigs?: FleetLaunchTemplateConfigRequest[];
  FleetId: string | undefined;
  TargetCapacitySpecification?: TargetCapacitySpecificationRequest;
  Context?: string;
}
export interface ModifyFleetResult {
  Return?: boolean;
}
export interface LoadPermissionRequest {
  Group?: PermissionGroup | string;
  UserId?: string;
}
export interface LoadPermissionModifications {
  Add?: LoadPermissionRequest[];
  Remove?: LoadPermissionRequest[];
}
export declare enum OperationType {
  add = "add",
  remove = "remove",
}
export interface ModifyFpgaImageAttributeRequest {
  DryRun?: boolean;
  FpgaImageId: string | undefined;
  Attribute?: FpgaImageAttributeName | string;
  OperationType?: OperationType | string;
  UserIds?: string[];
  UserGroups?: string[];
  ProductCodes?: string[];
  LoadPermission?: LoadPermissionModifications;
  Description?: string;
  Name?: string;
}
export interface ModifyFpgaImageAttributeResult {
  FpgaImageAttribute?: FpgaImageAttribute;
}
export interface ModifyHostsRequest {
  AutoPlacement?: AutoPlacement | string;
  HostIds: string[] | undefined;
  HostRecovery?: HostRecovery | string;
  InstanceType?: string;
  InstanceFamily?: string;
}
export interface ModifyHostsResult {
  Successful?: string[];
  Unsuccessful?: UnsuccessfulItem[];
}
export interface ModifyIdentityIdFormatRequest {
  PrincipalArn: string | undefined;
  Resource: string | undefined;
  UseLongIds: boolean | undefined;
}
export interface ModifyIdFormatRequest {
  Resource: string | undefined;
  UseLongIds: boolean | undefined;
}
export interface LaunchPermissionModifications {
  Add?: LaunchPermission[];
  Remove?: LaunchPermission[];
}
export interface ModifyImageAttributeRequest {
  Attribute?: string;
  Description?: AttributeValue;
  ImageId: string | undefined;
  LaunchPermission?: LaunchPermissionModifications;
  OperationType?: OperationType | string;
  ProductCodes?: string[];
  UserGroups?: string[];
  UserIds?: string[];
  Value?: string;
  DryRun?: boolean;
  OrganizationArns?: string[];
  OrganizationalUnitArns?: string[];
}
export interface EbsInstanceBlockDeviceSpecification {
  DeleteOnTermination?: boolean;
  VolumeId?: string;
}
export interface InstanceBlockDeviceMappingSpecification {
  DeviceName?: string;
  Ebs?: EbsInstanceBlockDeviceSpecification;
  NoDevice?: string;
  VirtualName?: string;
}
export interface BlobAttributeValue {
  Value?: Uint8Array;
}
export interface ModifyInstanceAttributeRequest {
  SourceDestCheck?: AttributeBooleanValue;
  Attribute?: InstanceAttributeName | string;
  BlockDeviceMappings?: InstanceBlockDeviceMappingSpecification[];
  DisableApiTermination?: AttributeBooleanValue;
  DryRun?: boolean;
  EbsOptimized?: AttributeBooleanValue;
  EnaSupport?: AttributeBooleanValue;
  Groups?: string[];
  InstanceId: string | undefined;
  InstanceInitiatedShutdownBehavior?: AttributeValue;
  InstanceType?: AttributeValue;
  Kernel?: AttributeValue;
  Ramdisk?: AttributeValue;
  SriovNetSupport?: AttributeValue;
  UserData?: BlobAttributeValue;
  Value?: string;
  DisableApiStop?: AttributeBooleanValue;
}
export interface CapacityReservationSpecification {
  CapacityReservationPreference?: CapacityReservationPreference | string;
  CapacityReservationTarget?: CapacityReservationTarget;
}
export interface ModifyInstanceCapacityReservationAttributesRequest {
  InstanceId: string | undefined;
  CapacityReservationSpecification:
    | CapacityReservationSpecification
    | undefined;
  DryRun?: boolean;
}
export interface ModifyInstanceCapacityReservationAttributesResult {
  Return?: boolean;
}
export declare const DescribeVpcEndpointServiceConfigurationsResultFilterSensitiveLog: (
  obj: DescribeVpcEndpointServiceConfigurationsResult
) => any;
export declare const DescribeVpcEndpointServicePermissionsRequestFilterSensitiveLog: (
  obj: DescribeVpcEndpointServicePermissionsRequest
) => any;
export declare const DescribeVpcEndpointServicePermissionsResultFilterSensitiveLog: (
  obj: DescribeVpcEndpointServicePermissionsResult
) => any;
export declare const DescribeVpcEndpointServicesRequestFilterSensitiveLog: (
  obj: DescribeVpcEndpointServicesRequest
) => any;
export declare const PrivateDnsDetailsFilterSensitiveLog: (
  obj: PrivateDnsDetails
) => any;
export declare const ServiceDetailFilterSensitiveLog: (
  obj: ServiceDetail
) => any;
export declare const DescribeVpcEndpointServicesResultFilterSensitiveLog: (
  obj: DescribeVpcEndpointServicesResult
) => any;
export declare const DescribeVpcPeeringConnectionsRequestFilterSensitiveLog: (
  obj: DescribeVpcPeeringConnectionsRequest
) => any;
export declare const DescribeVpcPeeringConnectionsResultFilterSensitiveLog: (
  obj: DescribeVpcPeeringConnectionsResult
) => any;
export declare const DescribeVpcsRequestFilterSensitiveLog: (
  obj: DescribeVpcsRequest
) => any;
export declare const DescribeVpcsResultFilterSensitiveLog: (
  obj: DescribeVpcsResult
) => any;
export declare const DescribeVpnConnectionsRequestFilterSensitiveLog: (
  obj: DescribeVpnConnectionsRequest
) => any;
export declare const DescribeVpnConnectionsResultFilterSensitiveLog: (
  obj: DescribeVpnConnectionsResult
) => any;
export declare const DescribeVpnGatewaysRequestFilterSensitiveLog: (
  obj: DescribeVpnGatewaysRequest
) => any;
export declare const DescribeVpnGatewaysResultFilterSensitiveLog: (
  obj: DescribeVpnGatewaysResult
) => any;
export declare const DetachClassicLinkVpcRequestFilterSensitiveLog: (
  obj: DetachClassicLinkVpcRequest
) => any;
export declare const DetachClassicLinkVpcResultFilterSensitiveLog: (
  obj: DetachClassicLinkVpcResult
) => any;
export declare const DetachInternetGatewayRequestFilterSensitiveLog: (
  obj: DetachInternetGatewayRequest
) => any;
export declare const DetachNetworkInterfaceRequestFilterSensitiveLog: (
  obj: DetachNetworkInterfaceRequest
) => any;
export declare const DetachVerifiedAccessTrustProviderRequestFilterSensitiveLog: (
  obj: DetachVerifiedAccessTrustProviderRequest
) => any;
export declare const DetachVerifiedAccessTrustProviderResultFilterSensitiveLog: (
  obj: DetachVerifiedAccessTrustProviderResult
) => any;
export declare const DetachVolumeRequestFilterSensitiveLog: (
  obj: DetachVolumeRequest
) => any;
export declare const DetachVpnGatewayRequestFilterSensitiveLog: (
  obj: DetachVpnGatewayRequest
) => any;
export declare const DisableAddressTransferRequestFilterSensitiveLog: (
  obj: DisableAddressTransferRequest
) => any;
export declare const DisableAddressTransferResultFilterSensitiveLog: (
  obj: DisableAddressTransferResult
) => any;
export declare const DisableAwsNetworkPerformanceMetricSubscriptionRequestFilterSensitiveLog: (
  obj: DisableAwsNetworkPerformanceMetricSubscriptionRequest
) => any;
export declare const DisableAwsNetworkPerformanceMetricSubscriptionResultFilterSensitiveLog: (
  obj: DisableAwsNetworkPerformanceMetricSubscriptionResult
) => any;
export declare const DisableEbsEncryptionByDefaultRequestFilterSensitiveLog: (
  obj: DisableEbsEncryptionByDefaultRequest
) => any;
export declare const DisableEbsEncryptionByDefaultResultFilterSensitiveLog: (
  obj: DisableEbsEncryptionByDefaultResult
) => any;
export declare const DisableFastLaunchRequestFilterSensitiveLog: (
  obj: DisableFastLaunchRequest
) => any;
export declare const DisableFastLaunchResultFilterSensitiveLog: (
  obj: DisableFastLaunchResult
) => any;
export declare const DisableFastSnapshotRestoresRequestFilterSensitiveLog: (
  obj: DisableFastSnapshotRestoresRequest
) => any;
export declare const DisableFastSnapshotRestoreSuccessItemFilterSensitiveLog: (
  obj: DisableFastSnapshotRestoreSuccessItem
) => any;
export declare const DisableFastSnapshotRestoreStateErrorFilterSensitiveLog: (
  obj: DisableFastSnapshotRestoreStateError
) => any;
export declare const DisableFastSnapshotRestoreStateErrorItemFilterSensitiveLog: (
  obj: DisableFastSnapshotRestoreStateErrorItem
) => any;
export declare const DisableFastSnapshotRestoreErrorItemFilterSensitiveLog: (
  obj: DisableFastSnapshotRestoreErrorItem
) => any;
export declare const DisableFastSnapshotRestoresResultFilterSensitiveLog: (
  obj: DisableFastSnapshotRestoresResult
) => any;
export declare const DisableImageDeprecationRequestFilterSensitiveLog: (
  obj: DisableImageDeprecationRequest
) => any;
export declare const DisableImageDeprecationResultFilterSensitiveLog: (
  obj: DisableImageDeprecationResult
) => any;
export declare const DisableIpamOrganizationAdminAccountRequestFilterSensitiveLog: (
  obj: DisableIpamOrganizationAdminAccountRequest
) => any;
export declare const DisableIpamOrganizationAdminAccountResultFilterSensitiveLog: (
  obj: DisableIpamOrganizationAdminAccountResult
) => any;
export declare const DisableSerialConsoleAccessRequestFilterSensitiveLog: (
  obj: DisableSerialConsoleAccessRequest
) => any;
export declare const DisableSerialConsoleAccessResultFilterSensitiveLog: (
  obj: DisableSerialConsoleAccessResult
) => any;
export declare const DisableTransitGatewayRouteTablePropagationRequestFilterSensitiveLog: (
  obj: DisableTransitGatewayRouteTablePropagationRequest
) => any;
export declare const TransitGatewayPropagationFilterSensitiveLog: (
  obj: TransitGatewayPropagation
) => any;
export declare const DisableTransitGatewayRouteTablePropagationResultFilterSensitiveLog: (
  obj: DisableTransitGatewayRouteTablePropagationResult
) => any;
export declare const DisableVgwRoutePropagationRequestFilterSensitiveLog: (
  obj: DisableVgwRoutePropagationRequest
) => any;
export declare const DisableVpcClassicLinkRequestFilterSensitiveLog: (
  obj: DisableVpcClassicLinkRequest
) => any;
export declare const DisableVpcClassicLinkResultFilterSensitiveLog: (
  obj: DisableVpcClassicLinkResult
) => any;
export declare const DisableVpcClassicLinkDnsSupportRequestFilterSensitiveLog: (
  obj: DisableVpcClassicLinkDnsSupportRequest
) => any;
export declare const DisableVpcClassicLinkDnsSupportResultFilterSensitiveLog: (
  obj: DisableVpcClassicLinkDnsSupportResult
) => any;
export declare const DisassociateAddressRequestFilterSensitiveLog: (
  obj: DisassociateAddressRequest
) => any;
export declare const DisassociateClientVpnTargetNetworkRequestFilterSensitiveLog: (
  obj: DisassociateClientVpnTargetNetworkRequest
) => any;
export declare const DisassociateClientVpnTargetNetworkResultFilterSensitiveLog: (
  obj: DisassociateClientVpnTargetNetworkResult
) => any;
export declare const DisassociateEnclaveCertificateIamRoleRequestFilterSensitiveLog: (
  obj: DisassociateEnclaveCertificateIamRoleRequest
) => any;
export declare const DisassociateEnclaveCertificateIamRoleResultFilterSensitiveLog: (
  obj: DisassociateEnclaveCertificateIamRoleResult
) => any;
export declare const DisassociateIamInstanceProfileRequestFilterSensitiveLog: (
  obj: DisassociateIamInstanceProfileRequest
) => any;
export declare const DisassociateIamInstanceProfileResultFilterSensitiveLog: (
  obj: DisassociateIamInstanceProfileResult
) => any;
export declare const InstanceEventWindowDisassociationRequestFilterSensitiveLog: (
  obj: InstanceEventWindowDisassociationRequest
) => any;
export declare const DisassociateInstanceEventWindowRequestFilterSensitiveLog: (
  obj: DisassociateInstanceEventWindowRequest
) => any;
export declare const DisassociateInstanceEventWindowResultFilterSensitiveLog: (
  obj: DisassociateInstanceEventWindowResult
) => any;
export declare const DisassociateRouteTableRequestFilterSensitiveLog: (
  obj: DisassociateRouteTableRequest
) => any;
export declare const DisassociateSubnetCidrBlockRequestFilterSensitiveLog: (
  obj: DisassociateSubnetCidrBlockRequest
) => any;
export declare const DisassociateSubnetCidrBlockResultFilterSensitiveLog: (
  obj: DisassociateSubnetCidrBlockResult
) => any;
export declare const DisassociateTransitGatewayMulticastDomainRequestFilterSensitiveLog: (
  obj: DisassociateTransitGatewayMulticastDomainRequest
) => any;
export declare const DisassociateTransitGatewayMulticastDomainResultFilterSensitiveLog: (
  obj: DisassociateTransitGatewayMulticastDomainResult
) => any;
export declare const DisassociateTransitGatewayPolicyTableRequestFilterSensitiveLog: (
  obj: DisassociateTransitGatewayPolicyTableRequest
) => any;
export declare const DisassociateTransitGatewayPolicyTableResultFilterSensitiveLog: (
  obj: DisassociateTransitGatewayPolicyTableResult
) => any;
export declare const DisassociateTransitGatewayRouteTableRequestFilterSensitiveLog: (
  obj: DisassociateTransitGatewayRouteTableRequest
) => any;
export declare const DisassociateTransitGatewayRouteTableResultFilterSensitiveLog: (
  obj: DisassociateTransitGatewayRouteTableResult
) => any;
export declare const DisassociateTrunkInterfaceRequestFilterSensitiveLog: (
  obj: DisassociateTrunkInterfaceRequest
) => any;
export declare const DisassociateTrunkInterfaceResultFilterSensitiveLog: (
  obj: DisassociateTrunkInterfaceResult
) => any;
export declare const DisassociateVpcCidrBlockRequestFilterSensitiveLog: (
  obj: DisassociateVpcCidrBlockRequest
) => any;
export declare const DisassociateVpcCidrBlockResultFilterSensitiveLog: (
  obj: DisassociateVpcCidrBlockResult
) => any;
export declare const EnableAddressTransferRequestFilterSensitiveLog: (
  obj: EnableAddressTransferRequest
) => any;
export declare const EnableAddressTransferResultFilterSensitiveLog: (
  obj: EnableAddressTransferResult
) => any;
export declare const EnableAwsNetworkPerformanceMetricSubscriptionRequestFilterSensitiveLog: (
  obj: EnableAwsNetworkPerformanceMetricSubscriptionRequest
) => any;
export declare const EnableAwsNetworkPerformanceMetricSubscriptionResultFilterSensitiveLog: (
  obj: EnableAwsNetworkPerformanceMetricSubscriptionResult
) => any;
export declare const EnableEbsEncryptionByDefaultRequestFilterSensitiveLog: (
  obj: EnableEbsEncryptionByDefaultRequest
) => any;
export declare const EnableEbsEncryptionByDefaultResultFilterSensitiveLog: (
  obj: EnableEbsEncryptionByDefaultResult
) => any;
export declare const FastLaunchLaunchTemplateSpecificationRequestFilterSensitiveLog: (
  obj: FastLaunchLaunchTemplateSpecificationRequest
) => any;
export declare const FastLaunchSnapshotConfigurationRequestFilterSensitiveLog: (
  obj: FastLaunchSnapshotConfigurationRequest
) => any;
export declare const EnableFastLaunchRequestFilterSensitiveLog: (
  obj: EnableFastLaunchRequest
) => any;
export declare const EnableFastLaunchResultFilterSensitiveLog: (
  obj: EnableFastLaunchResult
) => any;
export declare const EnableFastSnapshotRestoresRequestFilterSensitiveLog: (
  obj: EnableFastSnapshotRestoresRequest
) => any;
export declare const EnableFastSnapshotRestoreSuccessItemFilterSensitiveLog: (
  obj: EnableFastSnapshotRestoreSuccessItem
) => any;
export declare const EnableFastSnapshotRestoreStateErrorFilterSensitiveLog: (
  obj: EnableFastSnapshotRestoreStateError
) => any;
export declare const EnableFastSnapshotRestoreStateErrorItemFilterSensitiveLog: (
  obj: EnableFastSnapshotRestoreStateErrorItem
) => any;
export declare const EnableFastSnapshotRestoreErrorItemFilterSensitiveLog: (
  obj: EnableFastSnapshotRestoreErrorItem
) => any;
export declare const EnableFastSnapshotRestoresResultFilterSensitiveLog: (
  obj: EnableFastSnapshotRestoresResult
) => any;
export declare const EnableImageDeprecationRequestFilterSensitiveLog: (
  obj: EnableImageDeprecationRequest
) => any;
export declare const EnableImageDeprecationResultFilterSensitiveLog: (
  obj: EnableImageDeprecationResult
) => any;
export declare const EnableIpamOrganizationAdminAccountRequestFilterSensitiveLog: (
  obj: EnableIpamOrganizationAdminAccountRequest
) => any;
export declare const EnableIpamOrganizationAdminAccountResultFilterSensitiveLog: (
  obj: EnableIpamOrganizationAdminAccountResult
) => any;
export declare const EnableReachabilityAnalyzerOrganizationSharingRequestFilterSensitiveLog: (
  obj: EnableReachabilityAnalyzerOrganizationSharingRequest
) => any;
export declare const EnableReachabilityAnalyzerOrganizationSharingResultFilterSensitiveLog: (
  obj: EnableReachabilityAnalyzerOrganizationSharingResult
) => any;
export declare const EnableSerialConsoleAccessRequestFilterSensitiveLog: (
  obj: EnableSerialConsoleAccessRequest
) => any;
export declare const EnableSerialConsoleAccessResultFilterSensitiveLog: (
  obj: EnableSerialConsoleAccessResult
) => any;
export declare const EnableTransitGatewayRouteTablePropagationRequestFilterSensitiveLog: (
  obj: EnableTransitGatewayRouteTablePropagationRequest
) => any;
export declare const EnableTransitGatewayRouteTablePropagationResultFilterSensitiveLog: (
  obj: EnableTransitGatewayRouteTablePropagationResult
) => any;
export declare const EnableVgwRoutePropagationRequestFilterSensitiveLog: (
  obj: EnableVgwRoutePropagationRequest
) => any;
export declare const EnableVolumeIORequestFilterSensitiveLog: (
  obj: EnableVolumeIORequest
) => any;
export declare const EnableVpcClassicLinkRequestFilterSensitiveLog: (
  obj: EnableVpcClassicLinkRequest
) => any;
export declare const EnableVpcClassicLinkResultFilterSensitiveLog: (
  obj: EnableVpcClassicLinkResult
) => any;
export declare const EnableVpcClassicLinkDnsSupportRequestFilterSensitiveLog: (
  obj: EnableVpcClassicLinkDnsSupportRequest
) => any;
export declare const EnableVpcClassicLinkDnsSupportResultFilterSensitiveLog: (
  obj: EnableVpcClassicLinkDnsSupportResult
) => any;
export declare const ExportClientVpnClientCertificateRevocationListRequestFilterSensitiveLog: (
  obj: ExportClientVpnClientCertificateRevocationListRequest
) => any;
export declare const ClientCertificateRevocationListStatusFilterSensitiveLog: (
  obj: ClientCertificateRevocationListStatus
) => any;
export declare const ExportClientVpnClientCertificateRevocationListResultFilterSensitiveLog: (
  obj: ExportClientVpnClientCertificateRevocationListResult
) => any;
export declare const ExportClientVpnClientConfigurationRequestFilterSensitiveLog: (
  obj: ExportClientVpnClientConfigurationRequest
) => any;
export declare const ExportClientVpnClientConfigurationResultFilterSensitiveLog: (
  obj: ExportClientVpnClientConfigurationResult
) => any;
export declare const ExportTaskS3LocationRequestFilterSensitiveLog: (
  obj: ExportTaskS3LocationRequest
) => any;
export declare const ExportImageRequestFilterSensitiveLog: (
  obj: ExportImageRequest
) => any;
export declare const ExportImageResultFilterSensitiveLog: (
  obj: ExportImageResult
) => any;
export declare const ExportTransitGatewayRoutesRequestFilterSensitiveLog: (
  obj: ExportTransitGatewayRoutesRequest
) => any;
export declare const ExportTransitGatewayRoutesResultFilterSensitiveLog: (
  obj: ExportTransitGatewayRoutesResult
) => any;
export declare const GetAssociatedEnclaveCertificateIamRolesRequestFilterSensitiveLog: (
  obj: GetAssociatedEnclaveCertificateIamRolesRequest
) => any;
export declare const AssociatedRoleFilterSensitiveLog: (
  obj: AssociatedRole
) => any;
export declare const GetAssociatedEnclaveCertificateIamRolesResultFilterSensitiveLog: (
  obj: GetAssociatedEnclaveCertificateIamRolesResult
) => any;
export declare const GetAssociatedIpv6PoolCidrsRequestFilterSensitiveLog: (
  obj: GetAssociatedIpv6PoolCidrsRequest
) => any;
export declare const Ipv6CidrAssociationFilterSensitiveLog: (
  obj: Ipv6CidrAssociation
) => any;
export declare const GetAssociatedIpv6PoolCidrsResultFilterSensitiveLog: (
  obj: GetAssociatedIpv6PoolCidrsResult
) => any;
export declare const DataQueryFilterSensitiveLog: (obj: DataQuery) => any;
export declare const GetAwsNetworkPerformanceDataRequestFilterSensitiveLog: (
  obj: GetAwsNetworkPerformanceDataRequest
) => any;
export declare const MetricPointFilterSensitiveLog: (obj: MetricPoint) => any;
export declare const DataResponseFilterSensitiveLog: (obj: DataResponse) => any;
export declare const GetAwsNetworkPerformanceDataResultFilterSensitiveLog: (
  obj: GetAwsNetworkPerformanceDataResult
) => any;
export declare const GetCapacityReservationUsageRequestFilterSensitiveLog: (
  obj: GetCapacityReservationUsageRequest
) => any;
export declare const InstanceUsageFilterSensitiveLog: (
  obj: InstanceUsage
) => any;
export declare const GetCapacityReservationUsageResultFilterSensitiveLog: (
  obj: GetCapacityReservationUsageResult
) => any;
export declare const GetCoipPoolUsageRequestFilterSensitiveLog: (
  obj: GetCoipPoolUsageRequest
) => any;
export declare const CoipAddressUsageFilterSensitiveLog: (
  obj: CoipAddressUsage
) => any;
export declare const GetCoipPoolUsageResultFilterSensitiveLog: (
  obj: GetCoipPoolUsageResult
) => any;
export declare const GetConsoleOutputRequestFilterSensitiveLog: (
  obj: GetConsoleOutputRequest
) => any;
export declare const GetConsoleOutputResultFilterSensitiveLog: (
  obj: GetConsoleOutputResult
) => any;
export declare const GetConsoleScreenshotRequestFilterSensitiveLog: (
  obj: GetConsoleScreenshotRequest
) => any;
export declare const GetConsoleScreenshotResultFilterSensitiveLog: (
  obj: GetConsoleScreenshotResult
) => any;
export declare const GetDefaultCreditSpecificationRequestFilterSensitiveLog: (
  obj: GetDefaultCreditSpecificationRequest
) => any;
export declare const InstanceFamilyCreditSpecificationFilterSensitiveLog: (
  obj: InstanceFamilyCreditSpecification
) => any;
export declare const GetDefaultCreditSpecificationResultFilterSensitiveLog: (
  obj: GetDefaultCreditSpecificationResult
) => any;
export declare const GetEbsDefaultKmsKeyIdRequestFilterSensitiveLog: (
  obj: GetEbsDefaultKmsKeyIdRequest
) => any;
export declare const GetEbsDefaultKmsKeyIdResultFilterSensitiveLog: (
  obj: GetEbsDefaultKmsKeyIdResult
) => any;
export declare const GetEbsEncryptionByDefaultRequestFilterSensitiveLog: (
  obj: GetEbsEncryptionByDefaultRequest
) => any;
export declare const GetEbsEncryptionByDefaultResultFilterSensitiveLog: (
  obj: GetEbsEncryptionByDefaultResult
) => any;
export declare const AthenaIntegrationFilterSensitiveLog: (
  obj: AthenaIntegration
) => any;
export declare const IntegrateServicesFilterSensitiveLog: (
  obj: IntegrateServices
) => any;
export declare const GetFlowLogsIntegrationTemplateRequestFilterSensitiveLog: (
  obj: GetFlowLogsIntegrationTemplateRequest
) => any;
export declare const GetFlowLogsIntegrationTemplateResultFilterSensitiveLog: (
  obj: GetFlowLogsIntegrationTemplateResult
) => any;
export declare const GetGroupsForCapacityReservationRequestFilterSensitiveLog: (
  obj: GetGroupsForCapacityReservationRequest
) => any;
export declare const CapacityReservationGroupFilterSensitiveLog: (
  obj: CapacityReservationGroup
) => any;
export declare const GetGroupsForCapacityReservationResultFilterSensitiveLog: (
  obj: GetGroupsForCapacityReservationResult
) => any;
export declare const GetHostReservationPurchasePreviewRequestFilterSensitiveLog: (
  obj: GetHostReservationPurchasePreviewRequest
) => any;
export declare const PurchaseFilterSensitiveLog: (obj: Purchase) => any;
export declare const GetHostReservationPurchasePreviewResultFilterSensitiveLog: (
  obj: GetHostReservationPurchasePreviewResult
) => any;
export declare const GetInstanceTypesFromInstanceRequirementsRequestFilterSensitiveLog: (
  obj: GetInstanceTypesFromInstanceRequirementsRequest
) => any;
export declare const InstanceTypeInfoFromInstanceRequirementsFilterSensitiveLog: (
  obj: InstanceTypeInfoFromInstanceRequirements
) => any;
export declare const GetInstanceTypesFromInstanceRequirementsResultFilterSensitiveLog: (
  obj: GetInstanceTypesFromInstanceRequirementsResult
) => any;
export declare const GetInstanceUefiDataRequestFilterSensitiveLog: (
  obj: GetInstanceUefiDataRequest
) => any;
export declare const GetInstanceUefiDataResultFilterSensitiveLog: (
  obj: GetInstanceUefiDataResult
) => any;
export declare const GetIpamAddressHistoryRequestFilterSensitiveLog: (
  obj: GetIpamAddressHistoryRequest
) => any;
export declare const IpamAddressHistoryRecordFilterSensitiveLog: (
  obj: IpamAddressHistoryRecord
) => any;
export declare const GetIpamAddressHistoryResultFilterSensitiveLog: (
  obj: GetIpamAddressHistoryResult
) => any;
export declare const GetIpamPoolAllocationsRequestFilterSensitiveLog: (
  obj: GetIpamPoolAllocationsRequest
) => any;
export declare const GetIpamPoolAllocationsResultFilterSensitiveLog: (
  obj: GetIpamPoolAllocationsResult
) => any;
export declare const GetIpamPoolCidrsRequestFilterSensitiveLog: (
  obj: GetIpamPoolCidrsRequest
) => any;
export declare const GetIpamPoolCidrsResultFilterSensitiveLog: (
  obj: GetIpamPoolCidrsResult
) => any;
export declare const GetIpamResourceCidrsRequestFilterSensitiveLog: (
  obj: GetIpamResourceCidrsRequest
) => any;
export declare const IpamResourceCidrFilterSensitiveLog: (
  obj: IpamResourceCidr
) => any;
export declare const GetIpamResourceCidrsResultFilterSensitiveLog: (
  obj: GetIpamResourceCidrsResult
) => any;
export declare const GetLaunchTemplateDataRequestFilterSensitiveLog: (
  obj: GetLaunchTemplateDataRequest
) => any;
export declare const GetLaunchTemplateDataResultFilterSensitiveLog: (
  obj: GetLaunchTemplateDataResult
) => any;
export declare const GetManagedPrefixListAssociationsRequestFilterSensitiveLog: (
  obj: GetManagedPrefixListAssociationsRequest
) => any;
export declare const PrefixListAssociationFilterSensitiveLog: (
  obj: PrefixListAssociation
) => any;
export declare const GetManagedPrefixListAssociationsResultFilterSensitiveLog: (
  obj: GetManagedPrefixListAssociationsResult
) => any;
export declare const GetManagedPrefixListEntriesRequestFilterSensitiveLog: (
  obj: GetManagedPrefixListEntriesRequest
) => any;
export declare const PrefixListEntryFilterSensitiveLog: (
  obj: PrefixListEntry
) => any;
export declare const GetManagedPrefixListEntriesResultFilterSensitiveLog: (
  obj: GetManagedPrefixListEntriesResult
) => any;
export declare const GetNetworkInsightsAccessScopeAnalysisFindingsRequestFilterSensitiveLog: (
  obj: GetNetworkInsightsAccessScopeAnalysisFindingsRequest
) => any;
export declare const GetNetworkInsightsAccessScopeAnalysisFindingsResultFilterSensitiveLog: (
  obj: GetNetworkInsightsAccessScopeAnalysisFindingsResult
) => any;
export declare const GetNetworkInsightsAccessScopeContentRequestFilterSensitiveLog: (
  obj: GetNetworkInsightsAccessScopeContentRequest
) => any;
export declare const GetNetworkInsightsAccessScopeContentResultFilterSensitiveLog: (
  obj: GetNetworkInsightsAccessScopeContentResult
) => any;
export declare const GetPasswordDataRequestFilterSensitiveLog: (
  obj: GetPasswordDataRequest
) => any;
export declare const GetPasswordDataResultFilterSensitiveLog: (
  obj: GetPasswordDataResult
) => any;
export declare const GetReservedInstancesExchangeQuoteRequestFilterSensitiveLog: (
  obj: GetReservedInstancesExchangeQuoteRequest
) => any;
export declare const ReservationValueFilterSensitiveLog: (
  obj: ReservationValue
) => any;
export declare const ReservedInstanceReservationValueFilterSensitiveLog: (
  obj: ReservedInstanceReservationValue
) => any;
export declare const TargetConfigurationFilterSensitiveLog: (
  obj: TargetConfiguration
) => any;
export declare const TargetReservationValueFilterSensitiveLog: (
  obj: TargetReservationValue
) => any;
export declare const GetReservedInstancesExchangeQuoteResultFilterSensitiveLog: (
  obj: GetReservedInstancesExchangeQuoteResult
) => any;
export declare const GetSerialConsoleAccessStatusRequestFilterSensitiveLog: (
  obj: GetSerialConsoleAccessStatusRequest
) => any;
export declare const GetSerialConsoleAccessStatusResultFilterSensitiveLog: (
  obj: GetSerialConsoleAccessStatusResult
) => any;
export declare const InstanceRequirementsWithMetadataRequestFilterSensitiveLog: (
  obj: InstanceRequirementsWithMetadataRequest
) => any;
export declare const GetSpotPlacementScoresRequestFilterSensitiveLog: (
  obj: GetSpotPlacementScoresRequest
) => any;
export declare const SpotPlacementScoreFilterSensitiveLog: (
  obj: SpotPlacementScore
) => any;
export declare const GetSpotPlacementScoresResultFilterSensitiveLog: (
  obj: GetSpotPlacementScoresResult
) => any;
export declare const GetSubnetCidrReservationsRequestFilterSensitiveLog: (
  obj: GetSubnetCidrReservationsRequest
) => any;
export declare const GetSubnetCidrReservationsResultFilterSensitiveLog: (
  obj: GetSubnetCidrReservationsResult
) => any;
export declare const GetTransitGatewayAttachmentPropagationsRequestFilterSensitiveLog: (
  obj: GetTransitGatewayAttachmentPropagationsRequest
) => any;
export declare const TransitGatewayAttachmentPropagationFilterSensitiveLog: (
  obj: TransitGatewayAttachmentPropagation
) => any;
export declare const GetTransitGatewayAttachmentPropagationsResultFilterSensitiveLog: (
  obj: GetTransitGatewayAttachmentPropagationsResult
) => any;
export declare const GetTransitGatewayMulticastDomainAssociationsRequestFilterSensitiveLog: (
  obj: GetTransitGatewayMulticastDomainAssociationsRequest
) => any;
export declare const TransitGatewayMulticastDomainAssociationFilterSensitiveLog: (
  obj: TransitGatewayMulticastDomainAssociation
) => any;
export declare const GetTransitGatewayMulticastDomainAssociationsResultFilterSensitiveLog: (
  obj: GetTransitGatewayMulticastDomainAssociationsResult
) => any;
export declare const GetTransitGatewayPolicyTableAssociationsRequestFilterSensitiveLog: (
  obj: GetTransitGatewayPolicyTableAssociationsRequest
) => any;
export declare const GetTransitGatewayPolicyTableAssociationsResultFilterSensitiveLog: (
  obj: GetTransitGatewayPolicyTableAssociationsResult
) => any;
export declare const GetTransitGatewayPolicyTableEntriesRequestFilterSensitiveLog: (
  obj: GetTransitGatewayPolicyTableEntriesRequest
) => any;
export declare const TransitGatewayPolicyRuleMetaDataFilterSensitiveLog: (
  obj: TransitGatewayPolicyRuleMetaData
) => any;
export declare const TransitGatewayPolicyRuleFilterSensitiveLog: (
  obj: TransitGatewayPolicyRule
) => any;
export declare const TransitGatewayPolicyTableEntryFilterSensitiveLog: (
  obj: TransitGatewayPolicyTableEntry
) => any;
export declare const GetTransitGatewayPolicyTableEntriesResultFilterSensitiveLog: (
  obj: GetTransitGatewayPolicyTableEntriesResult
) => any;
export declare const GetTransitGatewayPrefixListReferencesRequestFilterSensitiveLog: (
  obj: GetTransitGatewayPrefixListReferencesRequest
) => any;
export declare const GetTransitGatewayPrefixListReferencesResultFilterSensitiveLog: (
  obj: GetTransitGatewayPrefixListReferencesResult
) => any;
export declare const GetTransitGatewayRouteTableAssociationsRequestFilterSensitiveLog: (
  obj: GetTransitGatewayRouteTableAssociationsRequest
) => any;
export declare const TransitGatewayRouteTableAssociationFilterSensitiveLog: (
  obj: TransitGatewayRouteTableAssociation
) => any;
export declare const GetTransitGatewayRouteTableAssociationsResultFilterSensitiveLog: (
  obj: GetTransitGatewayRouteTableAssociationsResult
) => any;
export declare const GetTransitGatewayRouteTablePropagationsRequestFilterSensitiveLog: (
  obj: GetTransitGatewayRouteTablePropagationsRequest
) => any;
export declare const TransitGatewayRouteTablePropagationFilterSensitiveLog: (
  obj: TransitGatewayRouteTablePropagation
) => any;
export declare const GetTransitGatewayRouteTablePropagationsResultFilterSensitiveLog: (
  obj: GetTransitGatewayRouteTablePropagationsResult
) => any;
export declare const GetVerifiedAccessEndpointPolicyRequestFilterSensitiveLog: (
  obj: GetVerifiedAccessEndpointPolicyRequest
) => any;
export declare const GetVerifiedAccessEndpointPolicyResultFilterSensitiveLog: (
  obj: GetVerifiedAccessEndpointPolicyResult
) => any;
export declare const GetVerifiedAccessGroupPolicyRequestFilterSensitiveLog: (
  obj: GetVerifiedAccessGroupPolicyRequest
) => any;
export declare const GetVerifiedAccessGroupPolicyResultFilterSensitiveLog: (
  obj: GetVerifiedAccessGroupPolicyResult
) => any;
export declare const GetVpnConnectionDeviceSampleConfigurationRequestFilterSensitiveLog: (
  obj: GetVpnConnectionDeviceSampleConfigurationRequest
) => any;
export declare const GetVpnConnectionDeviceSampleConfigurationResultFilterSensitiveLog: (
  obj: GetVpnConnectionDeviceSampleConfigurationResult
) => any;
export declare const GetVpnConnectionDeviceTypesRequestFilterSensitiveLog: (
  obj: GetVpnConnectionDeviceTypesRequest
) => any;
export declare const VpnConnectionDeviceTypeFilterSensitiveLog: (
  obj: VpnConnectionDeviceType
) => any;
export declare const GetVpnConnectionDeviceTypesResultFilterSensitiveLog: (
  obj: GetVpnConnectionDeviceTypesResult
) => any;
export declare const ImportClientVpnClientCertificateRevocationListRequestFilterSensitiveLog: (
  obj: ImportClientVpnClientCertificateRevocationListRequest
) => any;
export declare const ImportClientVpnClientCertificateRevocationListResultFilterSensitiveLog: (
  obj: ImportClientVpnClientCertificateRevocationListResult
) => any;
export declare const ClientDataFilterSensitiveLog: (obj: ClientData) => any;
export declare const UserBucketFilterSensitiveLog: (obj: UserBucket) => any;
export declare const ImageDiskContainerFilterSensitiveLog: (
  obj: ImageDiskContainer
) => any;
export declare const ImportImageLicenseConfigurationRequestFilterSensitiveLog: (
  obj: ImportImageLicenseConfigurationRequest
) => any;
export declare const ImportImageRequestFilterSensitiveLog: (
  obj: ImportImageRequest
) => any;
export declare const ImportImageResultFilterSensitiveLog: (
  obj: ImportImageResult
) => any;
export declare const DiskImageDetailFilterSensitiveLog: (
  obj: DiskImageDetail
) => any;
export declare const VolumeDetailFilterSensitiveLog: (obj: VolumeDetail) => any;
export declare const DiskImageFilterSensitiveLog: (obj: DiskImage) => any;
export declare const UserDataFilterSensitiveLog: (obj: UserData) => any;
export declare const ImportInstanceLaunchSpecificationFilterSensitiveLog: (
  obj: ImportInstanceLaunchSpecification
) => any;
export declare const ImportInstanceRequestFilterSensitiveLog: (
  obj: ImportInstanceRequest
) => any;
export declare const ImportInstanceResultFilterSensitiveLog: (
  obj: ImportInstanceResult
) => any;
export declare const ImportKeyPairRequestFilterSensitiveLog: (
  obj: ImportKeyPairRequest
) => any;
export declare const ImportKeyPairResultFilterSensitiveLog: (
  obj: ImportKeyPairResult
) => any;
export declare const SnapshotDiskContainerFilterSensitiveLog: (
  obj: SnapshotDiskContainer
) => any;
export declare const ImportSnapshotRequestFilterSensitiveLog: (
  obj: ImportSnapshotRequest
) => any;
export declare const ImportSnapshotResultFilterSensitiveLog: (
  obj: ImportSnapshotResult
) => any;
export declare const ImportVolumeRequestFilterSensitiveLog: (
  obj: ImportVolumeRequest
) => any;
export declare const ImportVolumeResultFilterSensitiveLog: (
  obj: ImportVolumeResult
) => any;
export declare const ListImagesInRecycleBinRequestFilterSensitiveLog: (
  obj: ListImagesInRecycleBinRequest
) => any;
export declare const ImageRecycleBinInfoFilterSensitiveLog: (
  obj: ImageRecycleBinInfo
) => any;
export declare const ListImagesInRecycleBinResultFilterSensitiveLog: (
  obj: ListImagesInRecycleBinResult
) => any;
export declare const ListSnapshotsInRecycleBinRequestFilterSensitiveLog: (
  obj: ListSnapshotsInRecycleBinRequest
) => any;
export declare const SnapshotRecycleBinInfoFilterSensitiveLog: (
  obj: SnapshotRecycleBinInfo
) => any;
export declare const ListSnapshotsInRecycleBinResultFilterSensitiveLog: (
  obj: ListSnapshotsInRecycleBinResult
) => any;
export declare const ModifyAddressAttributeRequestFilterSensitiveLog: (
  obj: ModifyAddressAttributeRequest
) => any;
export declare const ModifyAddressAttributeResultFilterSensitiveLog: (
  obj: ModifyAddressAttributeResult
) => any;
export declare const ModifyAvailabilityZoneGroupRequestFilterSensitiveLog: (
  obj: ModifyAvailabilityZoneGroupRequest
) => any;
export declare const ModifyAvailabilityZoneGroupResultFilterSensitiveLog: (
  obj: ModifyAvailabilityZoneGroupResult
) => any;
export declare const ModifyCapacityReservationRequestFilterSensitiveLog: (
  obj: ModifyCapacityReservationRequest
) => any;
export declare const ModifyCapacityReservationResultFilterSensitiveLog: (
  obj: ModifyCapacityReservationResult
) => any;
export declare const ModifyCapacityReservationFleetRequestFilterSensitiveLog: (
  obj: ModifyCapacityReservationFleetRequest
) => any;
export declare const ModifyCapacityReservationFleetResultFilterSensitiveLog: (
  obj: ModifyCapacityReservationFleetResult
) => any;
export declare const DnsServersOptionsModifyStructureFilterSensitiveLog: (
  obj: DnsServersOptionsModifyStructure
) => any;
export declare const ModifyClientVpnEndpointRequestFilterSensitiveLog: (
  obj: ModifyClientVpnEndpointRequest
) => any;
export declare const ModifyClientVpnEndpointResultFilterSensitiveLog: (
  obj: ModifyClientVpnEndpointResult
) => any;
export declare const ModifyDefaultCreditSpecificationRequestFilterSensitiveLog: (
  obj: ModifyDefaultCreditSpecificationRequest
) => any;
export declare const ModifyDefaultCreditSpecificationResultFilterSensitiveLog: (
  obj: ModifyDefaultCreditSpecificationResult
) => any;
export declare const ModifyEbsDefaultKmsKeyIdRequestFilterSensitiveLog: (
  obj: ModifyEbsDefaultKmsKeyIdRequest
) => any;
export declare const ModifyEbsDefaultKmsKeyIdResultFilterSensitiveLog: (
  obj: ModifyEbsDefaultKmsKeyIdResult
) => any;
export declare const ModifyFleetRequestFilterSensitiveLog: (
  obj: ModifyFleetRequest
) => any;
export declare const ModifyFleetResultFilterSensitiveLog: (
  obj: ModifyFleetResult
) => any;
export declare const LoadPermissionRequestFilterSensitiveLog: (
  obj: LoadPermissionRequest
) => any;
export declare const LoadPermissionModificationsFilterSensitiveLog: (
  obj: LoadPermissionModifications
) => any;
export declare const ModifyFpgaImageAttributeRequestFilterSensitiveLog: (
  obj: ModifyFpgaImageAttributeRequest
) => any;
export declare const ModifyFpgaImageAttributeResultFilterSensitiveLog: (
  obj: ModifyFpgaImageAttributeResult
) => any;
export declare const ModifyHostsRequestFilterSensitiveLog: (
  obj: ModifyHostsRequest
) => any;
export declare const ModifyHostsResultFilterSensitiveLog: (
  obj: ModifyHostsResult
) => any;
export declare const ModifyIdentityIdFormatRequestFilterSensitiveLog: (
  obj: ModifyIdentityIdFormatRequest
) => any;
export declare const ModifyIdFormatRequestFilterSensitiveLog: (
  obj: ModifyIdFormatRequest
) => any;
export declare const LaunchPermissionModificationsFilterSensitiveLog: (
  obj: LaunchPermissionModifications
) => any;
export declare const ModifyImageAttributeRequestFilterSensitiveLog: (
  obj: ModifyImageAttributeRequest
) => any;
export declare const EbsInstanceBlockDeviceSpecificationFilterSensitiveLog: (
  obj: EbsInstanceBlockDeviceSpecification
) => any;
export declare const InstanceBlockDeviceMappingSpecificationFilterSensitiveLog: (
  obj: InstanceBlockDeviceMappingSpecification
) => any;
export declare const BlobAttributeValueFilterSensitiveLog: (
  obj: BlobAttributeValue
) => any;
export declare const ModifyInstanceAttributeRequestFilterSensitiveLog: (
  obj: ModifyInstanceAttributeRequest
) => any;
export declare const CapacityReservationSpecificationFilterSensitiveLog: (
  obj: CapacityReservationSpecification
) => any;
export declare const ModifyInstanceCapacityReservationAttributesRequestFilterSensitiveLog: (
  obj: ModifyInstanceCapacityReservationAttributesRequest
) => any;
export declare const ModifyInstanceCapacityReservationAttributesResultFilterSensitiveLog: (
  obj: ModifyInstanceCapacityReservationAttributesResult
) => any;
