import {
  _InstanceType,
  ActiveInstance,
  ActivityStatus,
  AllocationStrategy,
  AlternatePathHint,
  BatchState,
  CurrencyCodeValues,
  Explanation,
  IamInstanceProfileSpecification,
  IpPermission,
  PathComponent,
  ReservedInstancesListing,
  ResourceType,
  SecurityGroupRule,
  Tag,
  TagSpecification,
  TransitGatewayAssociationState,
  TransitGatewayAttachmentResourceType,
  TransitGatewayAttachmentState,
  TransitGatewayPeeringAttachment,
  TransitGatewayVpcAttachment,
  TrunkInterfaceAssociation,
  UserIdGroupPair,
  VerifiedAccessInstance,
  VerifiedAccessTrustProvider,
} from "./models_0";
import {
  AttributeValue,
  BlockDeviceMapping,
  FleetLaunchTemplateSpecification,
  FleetType,
  GroupIdentifier,
  InstanceInterruptionBehavior,
  InstanceIpv6Address,
  InstanceRequirements,
  InternetGateway,
  Ipam,
  IpamPool,
  IpamScope,
  Ipv4PrefixSpecificationRequest,
  Ipv6PrefixSpecificationRequest,
  KeyType,
  LaunchTemplate,
  LaunchTemplateVersion,
  LocalGatewayRouteTable,
  LocalGatewayRouteTableVirtualInterfaceGroupAssociation,
  LocalGatewayRouteTableVpcAssociation,
  ManagedPrefixList,
  NatGateway,
  NetworkAcl,
  NetworkInsightsAccessScope,
  NetworkInsightsPath,
  NetworkInterface,
  NetworkInterfaceAttachment,
  NetworkInterfacePermission,
  PlacementGroup,
  PrivateIpAddressSpecification,
  ReplaceRootVolumeTask,
  RouteTable,
  Snapshot,
  SnapshotState,
  SpotInstanceType,
  StorageTier,
  Subnet,
  TargetCapacityUnitType,
  Tenancy,
  VolumeType,
} from "./models_1";
import {
  ConnectionNotification,
  DnsEntry,
  IpAddressType,
  SpotDatafeedSubscription,
  SpotInstanceStateFault,
  State,
  TrafficMirrorFilter,
  TrafficMirrorSession,
  TrafficMirrorTarget,
  TransitGateway,
  TransitGatewayConnect,
  TransitGatewayConnectPeer,
  TransitGatewayMulticastDomain,
  TransitGatewayPolicyTable,
  TransitGatewayRouteTable,
  TransitGatewayRouteTableAnnouncement,
  VerifiedAccessEndpoint,
  VerifiedAccessGroup,
  Volume,
  VpcEndpoint,
} from "./models_2";
import {
  AttributeBooleanValue,
  EventInformation,
  Filter,
  IdFormat,
  PermissionGroup,
  ProductCode,
  VirtualizationType,
} from "./models_3";
export interface EbsOptimizedInfo {
  BaselineBandwidthInMbps?: number;
  BaselineThroughputInMBps?: number;
  BaselineIops?: number;
  MaximumBandwidthInMbps?: number;
  MaximumThroughputInMBps?: number;
  MaximumIops?: number;
}
export declare enum EbsOptimizedSupport {
  default = "default",
  supported = "supported",
  unsupported = "unsupported",
}
export declare enum EbsEncryptionSupport {
  supported = "supported",
  unsupported = "unsupported",
}
export declare enum EbsNvmeSupport {
  REQUIRED = "required",
  SUPPORTED = "supported",
  UNSUPPORTED = "unsupported",
}
export interface EbsInfo {
  EbsOptimizedSupport?: EbsOptimizedSupport | string;
  EncryptionSupport?: EbsEncryptionSupport | string;
  EbsOptimizedInfo?: EbsOptimizedInfo;
  NvmeSupport?: EbsNvmeSupport | string;
}
export interface FpgaDeviceMemoryInfo {
  SizeInMiB?: number;
}
export interface FpgaDeviceInfo {
  Name?: string;
  Manufacturer?: string;
  Count?: number;
  MemoryInfo?: FpgaDeviceMemoryInfo;
}
export interface FpgaInfo {
  Fpgas?: FpgaDeviceInfo[];
  TotalFpgaMemoryInMiB?: number;
}
export interface GpuDeviceMemoryInfo {
  SizeInMiB?: number;
}
export interface GpuDeviceInfo {
  Name?: string;
  Manufacturer?: string;
  Count?: number;
  MemoryInfo?: GpuDeviceMemoryInfo;
}
export interface GpuInfo {
  Gpus?: GpuDeviceInfo[];
  TotalGpuMemoryInMiB?: number;
}
export declare enum InstanceTypeHypervisor {
  NITRO = "nitro",
  XEN = "xen",
}
export interface InferenceDeviceInfo {
  Count?: number;
  Name?: string;
  Manufacturer?: string;
}
export interface InferenceAcceleratorInfo {
  Accelerators?: InferenceDeviceInfo[];
}
export declare enum DiskType {
  hdd = "hdd",
  ssd = "ssd",
}
export interface DiskInfo {
  SizeInGB?: number;
  Count?: number;
  Type?: DiskType | string;
}
export declare enum InstanceStorageEncryptionSupport {
  required = "required",
  unsupported = "unsupported",
}
export declare enum EphemeralNvmeSupport {
  REQUIRED = "required",
  SUPPORTED = "supported",
  UNSUPPORTED = "unsupported",
}
export interface InstanceStorageInfo {
  TotalSizeInGB?: number;
  Disks?: DiskInfo[];
  NvmeSupport?: EphemeralNvmeSupport | string;
  EncryptionSupport?: InstanceStorageEncryptionSupport | string;
}
export interface MemoryInfo {
  SizeInMiB?: number;
}
export interface EfaInfo {
  MaximumEfaInterfaces?: number;
}
export declare enum EnaSupport {
  required = "required",
  supported = "supported",
  unsupported = "unsupported",
}
export interface NetworkCardInfo {
  NetworkCardIndex?: number;
  NetworkPerformance?: string;
  MaximumNetworkInterfaces?: number;
}
export interface NetworkInfo {
  NetworkPerformance?: string;
  MaximumNetworkInterfaces?: number;
  MaximumNetworkCards?: number;
  DefaultNetworkCardIndex?: number;
  NetworkCards?: NetworkCardInfo[];
  Ipv4AddressesPerInterface?: number;
  Ipv6AddressesPerInterface?: number;
  Ipv6Supported?: boolean;
  EnaSupport?: EnaSupport | string;
  EfaSupported?: boolean;
  EfaInfo?: EfaInfo;
  EncryptionInTransitSupported?: boolean;
  EnaSrdSupported?: boolean;
}
export declare enum PlacementGroupStrategy {
  cluster = "cluster",
  partition = "partition",
  spread = "spread",
}
export interface PlacementGroupInfo {
  SupportedStrategies?: (PlacementGroupStrategy | string)[];
}
export declare enum ArchitectureType {
  arm64 = "arm64",
  arm64_mac = "arm64_mac",
  i386 = "i386",
  x86_64 = "x86_64",
  x86_64_mac = "x86_64_mac",
}
export interface ProcessorInfo {
  SupportedArchitectures?: (ArchitectureType | string)[];
  SustainedClockSpeedInGhz?: number;
}
export declare enum BootModeType {
  legacy_bios = "legacy-bios",
  uefi = "uefi",
}
export declare enum RootDeviceType {
  ebs = "ebs",
  instance_store = "instance-store",
}
export declare enum UsageClassType {
  on_demand = "on-demand",
  spot = "spot",
}
export interface VCpuInfo {
  DefaultVCpus?: number;
  DefaultCores?: number;
  DefaultThreadsPerCore?: number;
  ValidCores?: number[];
  ValidThreadsPerCore?: number[];
}
export interface InstanceTypeInfo {
  InstanceType?: _InstanceType | string;
  CurrentGeneration?: boolean;
  FreeTierEligible?: boolean;
  SupportedUsageClasses?: (UsageClassType | string)[];
  SupportedRootDeviceTypes?: (RootDeviceType | string)[];
  SupportedVirtualizationTypes?: (VirtualizationType | string)[];
  BareMetal?: boolean;
  Hypervisor?: InstanceTypeHypervisor | string;
  ProcessorInfo?: ProcessorInfo;
  VCpuInfo?: VCpuInfo;
  MemoryInfo?: MemoryInfo;
  InstanceStorageSupported?: boolean;
  InstanceStorageInfo?: InstanceStorageInfo;
  EbsInfo?: EbsInfo;
  NetworkInfo?: NetworkInfo;
  GpuInfo?: GpuInfo;
  FpgaInfo?: FpgaInfo;
  PlacementGroupInfo?: PlacementGroupInfo;
  InferenceAcceleratorInfo?: InferenceAcceleratorInfo;
  HibernationSupported?: boolean;
  BurstablePerformanceSupported?: boolean;
  DedicatedHostsSupported?: boolean;
  AutoRecoverySupported?: boolean;
  SupportedBootModes?: (BootModeType | string)[];
}
export interface DescribeInstanceTypesResult {
  InstanceTypes?: InstanceTypeInfo[];
  NextToken?: string;
}
export interface DescribeInternetGatewaysRequest {
  Filters?: Filter[];
  DryRun?: boolean;
  InternetGatewayIds?: string[];
  NextToken?: string;
  MaxResults?: number;
}
export interface DescribeInternetGatewaysResult {
  InternetGateways?: InternetGateway[];
  NextToken?: string;
}
export interface DescribeIpamPoolsRequest {
  DryRun?: boolean;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  IpamPoolIds?: string[];
}
export interface DescribeIpamPoolsResult {
  NextToken?: string;
  IpamPools?: IpamPool[];
}
export interface DescribeIpamsRequest {
  DryRun?: boolean;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  IpamIds?: string[];
}
export interface DescribeIpamsResult {
  NextToken?: string;
  Ipams?: Ipam[];
}
export interface DescribeIpamScopesRequest {
  DryRun?: boolean;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  IpamScopeIds?: string[];
}
export interface DescribeIpamScopesResult {
  NextToken?: string;
  IpamScopes?: IpamScope[];
}
export interface DescribeIpv6PoolsRequest {
  PoolIds?: string[];
  NextToken?: string;
  MaxResults?: number;
  DryRun?: boolean;
  Filters?: Filter[];
}
export interface PoolCidrBlock {
  Cidr?: string;
}
export interface Ipv6Pool {
  PoolId?: string;
  Description?: string;
  PoolCidrBlocks?: PoolCidrBlock[];
  Tags?: Tag[];
}
export interface DescribeIpv6PoolsResult {
  Ipv6Pools?: Ipv6Pool[];
  NextToken?: string;
}
export interface DescribeKeyPairsRequest {
  Filters?: Filter[];
  KeyNames?: string[];
  KeyPairIds?: string[];
  DryRun?: boolean;
  IncludePublicKey?: boolean;
}
export interface KeyPairInfo {
  KeyPairId?: string;
  KeyFingerprint?: string;
  KeyName?: string;
  KeyType?: KeyType | string;
  Tags?: Tag[];
  PublicKey?: string;
  CreateTime?: Date;
}
export interface DescribeKeyPairsResult {
  KeyPairs?: KeyPairInfo[];
}
export interface DescribeLaunchTemplatesRequest {
  DryRun?: boolean;
  LaunchTemplateIds?: string[];
  LaunchTemplateNames?: string[];
  Filters?: Filter[];
  NextToken?: string;
  MaxResults?: number;
}
export interface DescribeLaunchTemplatesResult {
  LaunchTemplates?: LaunchTemplate[];
  NextToken?: string;
}
export interface DescribeLaunchTemplateVersionsRequest {
  DryRun?: boolean;
  LaunchTemplateId?: string;
  LaunchTemplateName?: string;
  Versions?: string[];
  MinVersion?: string;
  MaxVersion?: string;
  NextToken?: string;
  MaxResults?: number;
  Filters?: Filter[];
}
export interface DescribeLaunchTemplateVersionsResult {
  LaunchTemplateVersions?: LaunchTemplateVersion[];
  NextToken?: string;
}
export interface DescribeLocalGatewayRouteTablesRequest {
  LocalGatewayRouteTableIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeLocalGatewayRouteTablesResult {
  LocalGatewayRouteTables?: LocalGatewayRouteTable[];
  NextToken?: string;
}
export interface DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest {
  LocalGatewayRouteTableVirtualInterfaceGroupAssociationIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResult {
  LocalGatewayRouteTableVirtualInterfaceGroupAssociations?: LocalGatewayRouteTableVirtualInterfaceGroupAssociation[];
  NextToken?: string;
}
export interface DescribeLocalGatewayRouteTableVpcAssociationsRequest {
  LocalGatewayRouteTableVpcAssociationIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeLocalGatewayRouteTableVpcAssociationsResult {
  LocalGatewayRouteTableVpcAssociations?: LocalGatewayRouteTableVpcAssociation[];
  NextToken?: string;
}
export interface DescribeLocalGatewaysRequest {
  LocalGatewayIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface LocalGateway {
  LocalGatewayId?: string;
  OutpostArn?: string;
  OwnerId?: string;
  State?: string;
  Tags?: Tag[];
}
export interface DescribeLocalGatewaysResult {
  LocalGateways?: LocalGateway[];
  NextToken?: string;
}
export interface DescribeLocalGatewayVirtualInterfaceGroupsRequest {
  LocalGatewayVirtualInterfaceGroupIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface LocalGatewayVirtualInterfaceGroup {
  LocalGatewayVirtualInterfaceGroupId?: string;
  LocalGatewayVirtualInterfaceIds?: string[];
  LocalGatewayId?: string;
  OwnerId?: string;
  Tags?: Tag[];
}
export interface DescribeLocalGatewayVirtualInterfaceGroupsResult {
  LocalGatewayVirtualInterfaceGroups?: LocalGatewayVirtualInterfaceGroup[];
  NextToken?: string;
}
export interface DescribeLocalGatewayVirtualInterfacesRequest {
  LocalGatewayVirtualInterfaceIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface LocalGatewayVirtualInterface {
  LocalGatewayVirtualInterfaceId?: string;
  LocalGatewayId?: string;
  Vlan?: number;
  LocalAddress?: string;
  PeerAddress?: string;
  LocalBgpAsn?: number;
  PeerBgpAsn?: number;
  OwnerId?: string;
  Tags?: Tag[];
}
export interface DescribeLocalGatewayVirtualInterfacesResult {
  LocalGatewayVirtualInterfaces?: LocalGatewayVirtualInterface[];
  NextToken?: string;
}
export interface DescribeManagedPrefixListsRequest {
  DryRun?: boolean;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  PrefixListIds?: string[];
}
export interface DescribeManagedPrefixListsResult {
  NextToken?: string;
  PrefixLists?: ManagedPrefixList[];
}
export interface DescribeMovingAddressesRequest {
  Filters?: Filter[];
  DryRun?: boolean;
  MaxResults?: number;
  NextToken?: string;
  PublicIps?: string[];
}
export declare enum MoveStatus {
  movingToVpc = "movingToVpc",
  restoringToClassic = "restoringToClassic",
}
export interface MovingAddressStatus {
  MoveStatus?: MoveStatus | string;
  PublicIp?: string;
}
export interface DescribeMovingAddressesResult {
  MovingAddressStatuses?: MovingAddressStatus[];
  NextToken?: string;
}
export interface DescribeNatGatewaysRequest {
  DryRun?: boolean;
  Filter?: Filter[];
  MaxResults?: number;
  NatGatewayIds?: string[];
  NextToken?: string;
}
export interface DescribeNatGatewaysResult {
  NatGateways?: NatGateway[];
  NextToken?: string;
}
export interface DescribeNetworkAclsRequest {
  Filters?: Filter[];
  DryRun?: boolean;
  NetworkAclIds?: string[];
  NextToken?: string;
  MaxResults?: number;
}
export interface DescribeNetworkAclsResult {
  NetworkAcls?: NetworkAcl[];
  NextToken?: string;
}
export interface DescribeNetworkInsightsAccessScopeAnalysesRequest {
  NetworkInsightsAccessScopeAnalysisIds?: string[];
  NetworkInsightsAccessScopeId?: string;
  AnalysisStartTimeBegin?: Date;
  AnalysisStartTimeEnd?: Date;
  Filters?: Filter[];
  MaxResults?: number;
  DryRun?: boolean;
  NextToken?: string;
}
export declare enum FindingsFound {
  false = "false",
  true = "true",
  unknown = "unknown",
}
export declare enum AnalysisStatus {
  failed = "failed",
  running = "running",
  succeeded = "succeeded",
}
export interface NetworkInsightsAccessScopeAnalysis {
  NetworkInsightsAccessScopeAnalysisId?: string;
  NetworkInsightsAccessScopeAnalysisArn?: string;
  NetworkInsightsAccessScopeId?: string;
  Status?: AnalysisStatus | string;
  StatusMessage?: string;
  WarningMessage?: string;
  StartDate?: Date;
  EndDate?: Date;
  FindingsFound?: FindingsFound | string;
  AnalyzedEniCount?: number;
  Tags?: Tag[];
}
export interface DescribeNetworkInsightsAccessScopeAnalysesResult {
  NetworkInsightsAccessScopeAnalyses?: NetworkInsightsAccessScopeAnalysis[];
  NextToken?: string;
}
export interface DescribeNetworkInsightsAccessScopesRequest {
  NetworkInsightsAccessScopeIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  DryRun?: boolean;
  NextToken?: string;
}
export interface DescribeNetworkInsightsAccessScopesResult {
  NetworkInsightsAccessScopes?: NetworkInsightsAccessScope[];
  NextToken?: string;
}
export interface DescribeNetworkInsightsAnalysesRequest {
  NetworkInsightsAnalysisIds?: string[];
  NetworkInsightsPathId?: string;
  AnalysisStartTime?: Date;
  AnalysisEndTime?: Date;
  Filters?: Filter[];
  MaxResults?: number;
  DryRun?: boolean;
  NextToken?: string;
}
export interface NetworkInsightsAnalysis {
  NetworkInsightsAnalysisId?: string;
  NetworkInsightsAnalysisArn?: string;
  NetworkInsightsPathId?: string;
  AdditionalAccounts?: string[];
  FilterInArns?: string[];
  StartDate?: Date;
  Status?: AnalysisStatus | string;
  StatusMessage?: string;
  WarningMessage?: string;
  NetworkPathFound?: boolean;
  ForwardPathComponents?: PathComponent[];
  ReturnPathComponents?: PathComponent[];
  Explanations?: Explanation[];
  AlternatePathHints?: AlternatePathHint[];
  SuggestedAccounts?: string[];
  Tags?: Tag[];
}
export interface DescribeNetworkInsightsAnalysesResult {
  NetworkInsightsAnalyses?: NetworkInsightsAnalysis[];
  NextToken?: string;
}
export interface DescribeNetworkInsightsPathsRequest {
  NetworkInsightsPathIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  DryRun?: boolean;
  NextToken?: string;
}
export interface DescribeNetworkInsightsPathsResult {
  NetworkInsightsPaths?: NetworkInsightsPath[];
  NextToken?: string;
}
export declare enum NetworkInterfaceAttribute {
  attachment = "attachment",
  description = "description",
  groupSet = "groupSet",
  sourceDestCheck = "sourceDestCheck",
}
export interface DescribeNetworkInterfaceAttributeRequest {
  Attribute?: NetworkInterfaceAttribute | string;
  DryRun?: boolean;
  NetworkInterfaceId: string | undefined;
}
export interface DescribeNetworkInterfaceAttributeResult {
  Attachment?: NetworkInterfaceAttachment;
  Description?: AttributeValue;
  Groups?: GroupIdentifier[];
  NetworkInterfaceId?: string;
  SourceDestCheck?: AttributeBooleanValue;
}
export interface DescribeNetworkInterfacePermissionsRequest {
  NetworkInterfacePermissionIds?: string[];
  Filters?: Filter[];
  NextToken?: string;
  MaxResults?: number;
}
export interface DescribeNetworkInterfacePermissionsResult {
  NetworkInterfacePermissions?: NetworkInterfacePermission[];
  NextToken?: string;
}
export interface DescribeNetworkInterfacesRequest {
  Filters?: Filter[];
  DryRun?: boolean;
  NetworkInterfaceIds?: string[];
  NextToken?: string;
  MaxResults?: number;
}
export interface DescribeNetworkInterfacesResult {
  NetworkInterfaces?: NetworkInterface[];
  NextToken?: string;
}
export interface DescribePlacementGroupsRequest {
  Filters?: Filter[];
  DryRun?: boolean;
  GroupNames?: string[];
  GroupIds?: string[];
}
export interface DescribePlacementGroupsResult {
  PlacementGroups?: PlacementGroup[];
}
export interface DescribePrefixListsRequest {
  DryRun?: boolean;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  PrefixListIds?: string[];
}
export interface PrefixList {
  Cidrs?: string[];
  PrefixListId?: string;
  PrefixListName?: string;
}
export interface DescribePrefixListsResult {
  NextToken?: string;
  PrefixLists?: PrefixList[];
}
export interface DescribePrincipalIdFormatRequest {
  DryRun?: boolean;
  Resources?: string[];
  MaxResults?: number;
  NextToken?: string;
}
export interface PrincipalIdFormat {
  Arn?: string;
  Statuses?: IdFormat[];
}
export interface DescribePrincipalIdFormatResult {
  Principals?: PrincipalIdFormat[];
  NextToken?: string;
}
export interface DescribePublicIpv4PoolsRequest {
  PoolIds?: string[];
  NextToken?: string;
  MaxResults?: number;
  Filters?: Filter[];
}
export interface PublicIpv4PoolRange {
  FirstAddress?: string;
  LastAddress?: string;
  AddressCount?: number;
  AvailableAddressCount?: number;
}
export interface PublicIpv4Pool {
  PoolId?: string;
  Description?: string;
  PoolAddressRanges?: PublicIpv4PoolRange[];
  TotalAddressCount?: number;
  TotalAvailableAddressCount?: number;
  NetworkBorderGroup?: string;
  Tags?: Tag[];
}
export interface DescribePublicIpv4PoolsResult {
  PublicIpv4Pools?: PublicIpv4Pool[];
  NextToken?: string;
}
export interface DescribeRegionsRequest {
  Filters?: Filter[];
  RegionNames?: string[];
  DryRun?: boolean;
  AllRegions?: boolean;
}
export interface Region {
  Endpoint?: string;
  RegionName?: string;
  OptInStatus?: string;
}
export interface DescribeRegionsResult {
  Regions?: Region[];
}
export interface DescribeReplaceRootVolumeTasksRequest {
  ReplaceRootVolumeTaskIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeReplaceRootVolumeTasksResult {
  ReplaceRootVolumeTasks?: ReplaceRootVolumeTask[];
  NextToken?: string;
}
export declare enum OfferingClassType {
  CONVERTIBLE = "convertible",
  STANDARD = "standard",
}
export declare enum OfferingTypeValues {
  All_Upfront = "All Upfront",
  Heavy_Utilization = "Heavy Utilization",
  Light_Utilization = "Light Utilization",
  Medium_Utilization = "Medium Utilization",
  No_Upfront = "No Upfront",
  Partial_Upfront = "Partial Upfront",
}
export interface DescribeReservedInstancesRequest {
  Filters?: Filter[];
  OfferingClass?: OfferingClassType | string;
  ReservedInstancesIds?: string[];
  DryRun?: boolean;
  OfferingType?: OfferingTypeValues | string;
}
export declare type RIProductDescription =
  | "Linux/UNIX"
  | "Linux/UNIX (Amazon VPC)"
  | "Windows"
  | "Windows (Amazon VPC)";
export declare enum RecurringChargeFrequency {
  Hourly = "Hourly",
}
export interface RecurringCharge {
  Amount?: number;
  Frequency?: RecurringChargeFrequency | string;
}
export declare enum Scope {
  AVAILABILITY_ZONE = "Availability Zone",
  REGIONAL = "Region",
}
export declare enum ReservedInstanceState {
  active = "active",
  payment_failed = "payment-failed",
  payment_pending = "payment-pending",
  queued = "queued",
  queued_deleted = "queued-deleted",
  retired = "retired",
}
export interface ReservedInstances {
  AvailabilityZone?: string;
  Duration?: number;
  End?: Date;
  FixedPrice?: number;
  InstanceCount?: number;
  InstanceType?: _InstanceType | string;
  ProductDescription?: RIProductDescription | string;
  ReservedInstancesId?: string;
  Start?: Date;
  State?: ReservedInstanceState | string;
  UsagePrice?: number;
  CurrencyCode?: CurrencyCodeValues | string;
  InstanceTenancy?: Tenancy | string;
  OfferingClass?: OfferingClassType | string;
  OfferingType?: OfferingTypeValues | string;
  RecurringCharges?: RecurringCharge[];
  Scope?: Scope | string;
  Tags?: Tag[];
}
export interface DescribeReservedInstancesResult {
  ReservedInstances?: ReservedInstances[];
}
export interface DescribeReservedInstancesListingsRequest {
  Filters?: Filter[];
  ReservedInstancesId?: string;
  ReservedInstancesListingId?: string;
}
export interface DescribeReservedInstancesListingsResult {
  ReservedInstancesListings?: ReservedInstancesListing[];
}
export interface DescribeReservedInstancesModificationsRequest {
  Filters?: Filter[];
  ReservedInstancesModificationIds?: string[];
  NextToken?: string;
}
export interface ReservedInstancesConfiguration {
  AvailabilityZone?: string;
  InstanceCount?: number;
  InstanceType?: _InstanceType | string;
  Platform?: string;
  Scope?: Scope | string;
}
export interface ReservedInstancesModificationResult {
  ReservedInstancesId?: string;
  TargetConfiguration?: ReservedInstancesConfiguration;
}
export interface ReservedInstancesId {
  ReservedInstancesId?: string;
}
export interface ReservedInstancesModification {
  ClientToken?: string;
  CreateDate?: Date;
  EffectiveDate?: Date;
  ModificationResults?: ReservedInstancesModificationResult[];
  ReservedInstancesIds?: ReservedInstancesId[];
  ReservedInstancesModificationId?: string;
  Status?: string;
  StatusMessage?: string;
  UpdateDate?: Date;
}
export interface DescribeReservedInstancesModificationsResult {
  NextToken?: string;
  ReservedInstancesModifications?: ReservedInstancesModification[];
}
export interface DescribeReservedInstancesOfferingsRequest {
  AvailabilityZone?: string;
  Filters?: Filter[];
  IncludeMarketplace?: boolean;
  InstanceType?: _InstanceType | string;
  MaxDuration?: number;
  MaxInstanceCount?: number;
  MinDuration?: number;
  OfferingClass?: OfferingClassType | string;
  ProductDescription?: RIProductDescription | string;
  ReservedInstancesOfferingIds?: string[];
  DryRun?: boolean;
  InstanceTenancy?: Tenancy | string;
  MaxResults?: number;
  NextToken?: string;
  OfferingType?: OfferingTypeValues | string;
}
export interface PricingDetail {
  Count?: number;
  Price?: number;
}
export interface ReservedInstancesOffering {
  AvailabilityZone?: string;
  Duration?: number;
  FixedPrice?: number;
  InstanceType?: _InstanceType | string;
  ProductDescription?: RIProductDescription | string;
  ReservedInstancesOfferingId?: string;
  UsagePrice?: number;
  CurrencyCode?: CurrencyCodeValues | string;
  InstanceTenancy?: Tenancy | string;
  Marketplace?: boolean;
  OfferingClass?: OfferingClassType | string;
  OfferingType?: OfferingTypeValues | string;
  PricingDetails?: PricingDetail[];
  RecurringCharges?: RecurringCharge[];
  Scope?: Scope | string;
}
export interface DescribeReservedInstancesOfferingsResult {
  ReservedInstancesOfferings?: ReservedInstancesOffering[];
  NextToken?: string;
}
export interface DescribeRouteTablesRequest {
  Filters?: Filter[];
  DryRun?: boolean;
  RouteTableIds?: string[];
  NextToken?: string;
  MaxResults?: number;
}
export interface DescribeRouteTablesResult {
  RouteTables?: RouteTable[];
  NextToken?: string;
}
export interface SlotDateTimeRangeRequest {
  EarliestTime: Date | undefined;
  LatestTime: Date | undefined;
}
export interface ScheduledInstanceRecurrenceRequest {
  Frequency?: string;
  Interval?: number;
  OccurrenceDays?: number[];
  OccurrenceRelativeToEnd?: boolean;
  OccurrenceUnit?: string;
}
export interface DescribeScheduledInstanceAvailabilityRequest {
  DryRun?: boolean;
  Filters?: Filter[];
  FirstSlotStartTimeRange: SlotDateTimeRangeRequest | undefined;
  MaxResults?: number;
  MaxSlotDurationInHours?: number;
  MinSlotDurationInHours?: number;
  NextToken?: string;
  Recurrence: ScheduledInstanceRecurrenceRequest | undefined;
}
export interface ScheduledInstanceRecurrence {
  Frequency?: string;
  Interval?: number;
  OccurrenceDaySet?: number[];
  OccurrenceRelativeToEnd?: boolean;
  OccurrenceUnit?: string;
}
export interface ScheduledInstanceAvailability {
  AvailabilityZone?: string;
  AvailableInstanceCount?: number;
  FirstSlotStartTime?: Date;
  HourlyPrice?: string;
  InstanceType?: string;
  MaxTermDurationInDays?: number;
  MinTermDurationInDays?: number;
  NetworkPlatform?: string;
  Platform?: string;
  PurchaseToken?: string;
  Recurrence?: ScheduledInstanceRecurrence;
  SlotDurationInHours?: number;
  TotalScheduledInstanceHours?: number;
}
export interface DescribeScheduledInstanceAvailabilityResult {
  NextToken?: string;
  ScheduledInstanceAvailabilitySet?: ScheduledInstanceAvailability[];
}
export interface SlotStartTimeRangeRequest {
  EarliestTime?: Date;
  LatestTime?: Date;
}
export interface DescribeScheduledInstancesRequest {
  DryRun?: boolean;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  ScheduledInstanceIds?: string[];
  SlotStartTimeRange?: SlotStartTimeRangeRequest;
}
export interface ScheduledInstance {
  AvailabilityZone?: string;
  CreateDate?: Date;
  HourlyPrice?: string;
  InstanceCount?: number;
  InstanceType?: string;
  NetworkPlatform?: string;
  NextSlotStartTime?: Date;
  Platform?: string;
  PreviousSlotEndTime?: Date;
  Recurrence?: ScheduledInstanceRecurrence;
  ScheduledInstanceId?: string;
  SlotDurationInHours?: number;
  TermEndDate?: Date;
  TermStartDate?: Date;
  TotalScheduledInstanceHours?: number;
}
export interface DescribeScheduledInstancesResult {
  NextToken?: string;
  ScheduledInstanceSet?: ScheduledInstance[];
}
export interface DescribeSecurityGroupReferencesRequest {
  DryRun?: boolean;
  GroupId: string[] | undefined;
}
export interface SecurityGroupReference {
  GroupId?: string;
  ReferencingVpcId?: string;
  VpcPeeringConnectionId?: string;
}
export interface DescribeSecurityGroupReferencesResult {
  SecurityGroupReferenceSet?: SecurityGroupReference[];
}
export interface DescribeSecurityGroupRulesRequest {
  Filters?: Filter[];
  SecurityGroupRuleIds?: string[];
  DryRun?: boolean;
  NextToken?: string;
  MaxResults?: number;
}
export interface DescribeSecurityGroupRulesResult {
  SecurityGroupRules?: SecurityGroupRule[];
  NextToken?: string;
}
export interface DescribeSecurityGroupsRequest {
  Filters?: Filter[];
  GroupIds?: string[];
  GroupNames?: string[];
  DryRun?: boolean;
  NextToken?: string;
  MaxResults?: number;
}
export interface SecurityGroup {
  Description?: string;
  GroupName?: string;
  IpPermissions?: IpPermission[];
  OwnerId?: string;
  GroupId?: string;
  IpPermissionsEgress?: IpPermission[];
  Tags?: Tag[];
  VpcId?: string;
}
export interface DescribeSecurityGroupsResult {
  SecurityGroups?: SecurityGroup[];
  NextToken?: string;
}
export declare enum SnapshotAttributeName {
  createVolumePermission = "createVolumePermission",
  productCodes = "productCodes",
}
export interface DescribeSnapshotAttributeRequest {
  Attribute: SnapshotAttributeName | string | undefined;
  SnapshotId: string | undefined;
  DryRun?: boolean;
}
export interface CreateVolumePermission {
  Group?: PermissionGroup | string;
  UserId?: string;
}
export interface DescribeSnapshotAttributeResult {
  CreateVolumePermissions?: CreateVolumePermission[];
  ProductCodes?: ProductCode[];
  SnapshotId?: string;
}
export interface DescribeSnapshotsRequest {
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  OwnerIds?: string[];
  RestorableByUserIds?: string[];
  SnapshotIds?: string[];
  DryRun?: boolean;
}
export interface DescribeSnapshotsResult {
  Snapshots?: Snapshot[];
  NextToken?: string;
}
export interface DescribeSnapshotTierStatusRequest {
  Filters?: Filter[];
  DryRun?: boolean;
  NextToken?: string;
  MaxResults?: number;
}
export declare enum TieringOperationStatus {
  archival_completed = "archival-completed",
  archival_failed = "archival-failed",
  archival_in_progress = "archival-in-progress",
  permanent_restore_completed = "permanent-restore-completed",
  permanent_restore_failed = "permanent-restore-failed",
  permanent_restore_in_progress = "permanent-restore-in-progress",
  temporary_restore_completed = "temporary-restore-completed",
  temporary_restore_failed = "temporary-restore-failed",
  temporary_restore_in_progress = "temporary-restore-in-progress",
}
export interface SnapshotTierStatus {
  SnapshotId?: string;
  VolumeId?: string;
  Status?: SnapshotState | string;
  OwnerId?: string;
  Tags?: Tag[];
  StorageTier?: StorageTier | string;
  LastTieringStartTime?: Date;
  LastTieringProgress?: number;
  LastTieringOperationStatus?: TieringOperationStatus | string;
  LastTieringOperationStatusDetail?: string;
  ArchivalCompleteTime?: Date;
  RestoreExpiryTime?: Date;
}
export interface DescribeSnapshotTierStatusResult {
  SnapshotTierStatuses?: SnapshotTierStatus[];
  NextToken?: string;
}
export interface DescribeSpotDatafeedSubscriptionRequest {
  DryRun?: boolean;
}
export interface DescribeSpotDatafeedSubscriptionResult {
  SpotDatafeedSubscription?: SpotDatafeedSubscription;
}
export interface DescribeSpotFleetInstancesRequest {
  DryRun?: boolean;
  MaxResults?: number;
  NextToken?: string;
  SpotFleetRequestId: string | undefined;
}
export interface DescribeSpotFleetInstancesResponse {
  ActiveInstances?: ActiveInstance[];
  NextToken?: string;
  SpotFleetRequestId?: string;
}
export declare enum EventType {
  BATCH_CHANGE = "fleetRequestChange",
  ERROR = "error",
  INFORMATION = "information",
  INSTANCE_CHANGE = "instanceChange",
}
export interface DescribeSpotFleetRequestHistoryRequest {
  DryRun?: boolean;
  EventType?: EventType | string;
  MaxResults?: number;
  NextToken?: string;
  SpotFleetRequestId: string | undefined;
  StartTime: Date | undefined;
}
export interface HistoryRecord {
  EventInformation?: EventInformation;
  EventType?: EventType | string;
  Timestamp?: Date;
}
export interface DescribeSpotFleetRequestHistoryResponse {
  HistoryRecords?: HistoryRecord[];
  LastEvaluatedTime?: Date;
  NextToken?: string;
  SpotFleetRequestId?: string;
  StartTime?: Date;
}
export interface DescribeSpotFleetRequestsRequest {
  DryRun?: boolean;
  MaxResults?: number;
  NextToken?: string;
  SpotFleetRequestIds?: string[];
}
export declare enum ExcessCapacityTerminationPolicy {
  DEFAULT = "default",
  NO_TERMINATION = "noTermination",
}
export interface SpotFleetMonitoring {
  Enabled?: boolean;
}
export interface InstanceNetworkInterfaceSpecification {
  AssociatePublicIpAddress?: boolean;
  DeleteOnTermination?: boolean;
  Description?: string;
  DeviceIndex?: number;
  Groups?: string[];
  Ipv6AddressCount?: number;
  Ipv6Addresses?: InstanceIpv6Address[];
  NetworkInterfaceId?: string;
  PrivateIpAddress?: string;
  PrivateIpAddresses?: PrivateIpAddressSpecification[];
  SecondaryPrivateIpAddressCount?: number;
  SubnetId?: string;
  AssociateCarrierIpAddress?: boolean;
  InterfaceType?: string;
  NetworkCardIndex?: number;
  Ipv4Prefixes?: Ipv4PrefixSpecificationRequest[];
  Ipv4PrefixCount?: number;
  Ipv6Prefixes?: Ipv6PrefixSpecificationRequest[];
  Ipv6PrefixCount?: number;
}
export interface SpotPlacement {
  AvailabilityZone?: string;
  GroupName?: string;
  Tenancy?: Tenancy | string;
}
export interface SpotFleetTagSpecification {
  ResourceType?: ResourceType | string;
  Tags?: Tag[];
}
export interface SpotFleetLaunchSpecification {
  SecurityGroups?: GroupIdentifier[];
  AddressingType?: string;
  BlockDeviceMappings?: BlockDeviceMapping[];
  EbsOptimized?: boolean;
  IamInstanceProfile?: IamInstanceProfileSpecification;
  ImageId?: string;
  InstanceType?: _InstanceType | string;
  KernelId?: string;
  KeyName?: string;
  Monitoring?: SpotFleetMonitoring;
  NetworkInterfaces?: InstanceNetworkInterfaceSpecification[];
  Placement?: SpotPlacement;
  RamdiskId?: string;
  SpotPrice?: string;
  SubnetId?: string;
  UserData?: string;
  WeightedCapacity?: number;
  TagSpecifications?: SpotFleetTagSpecification[];
  InstanceRequirements?: InstanceRequirements;
}
export interface LaunchTemplateOverrides {
  InstanceType?: _InstanceType | string;
  SpotPrice?: string;
  SubnetId?: string;
  AvailabilityZone?: string;
  WeightedCapacity?: number;
  Priority?: number;
  InstanceRequirements?: InstanceRequirements;
}
export interface LaunchTemplateConfig {
  LaunchTemplateSpecification?: FleetLaunchTemplateSpecification;
  Overrides?: LaunchTemplateOverrides[];
}
export interface ClassicLoadBalancer {
  Name?: string;
}
export interface ClassicLoadBalancersConfig {
  ClassicLoadBalancers?: ClassicLoadBalancer[];
}
export interface TargetGroup {
  Arn?: string;
}
export interface TargetGroupsConfig {
  TargetGroups?: TargetGroup[];
}
export interface LoadBalancersConfig {
  ClassicLoadBalancersConfig?: ClassicLoadBalancersConfig;
  TargetGroupsConfig?: TargetGroupsConfig;
}
export declare enum OnDemandAllocationStrategy {
  LOWEST_PRICE = "lowestPrice",
  PRIORITIZED = "prioritized",
}
export declare enum ReplacementStrategy {
  LAUNCH = "launch",
  LAUNCH_BEFORE_TERMINATE = "launch-before-terminate",
}
export interface SpotCapacityRebalance {
  ReplacementStrategy?: ReplacementStrategy | string;
  TerminationDelay?: number;
}
export interface SpotMaintenanceStrategies {
  CapacityRebalance?: SpotCapacityRebalance;
}
export interface SpotFleetRequestConfigData {
  AllocationStrategy?: AllocationStrategy | string;
  OnDemandAllocationStrategy?: OnDemandAllocationStrategy | string;
  SpotMaintenanceStrategies?: SpotMaintenanceStrategies;
  ClientToken?: string;
  ExcessCapacityTerminationPolicy?: ExcessCapacityTerminationPolicy | string;
  FulfilledCapacity?: number;
  OnDemandFulfilledCapacity?: number;
  IamFleetRole: string | undefined;
  LaunchSpecifications?: SpotFleetLaunchSpecification[];
  LaunchTemplateConfigs?: LaunchTemplateConfig[];
  SpotPrice?: string;
  TargetCapacity: number | undefined;
  OnDemandTargetCapacity?: number;
  OnDemandMaxTotalPrice?: string;
  SpotMaxTotalPrice?: string;
  TerminateInstancesWithExpiration?: boolean;
  Type?: FleetType | string;
  ValidFrom?: Date;
  ValidUntil?: Date;
  ReplaceUnhealthyInstances?: boolean;
  InstanceInterruptionBehavior?: InstanceInterruptionBehavior | string;
  LoadBalancersConfig?: LoadBalancersConfig;
  InstancePoolsToUseCount?: number;
  Context?: string;
  TargetCapacityUnitType?: TargetCapacityUnitType | string;
  TagSpecifications?: TagSpecification[];
}
export interface SpotFleetRequestConfig {
  ActivityStatus?: ActivityStatus | string;
  CreateTime?: Date;
  SpotFleetRequestConfig?: SpotFleetRequestConfigData;
  SpotFleetRequestId?: string;
  SpotFleetRequestState?: BatchState | string;
  Tags?: Tag[];
}
export interface DescribeSpotFleetRequestsResponse {
  NextToken?: string;
  SpotFleetRequestConfigs?: SpotFleetRequestConfig[];
}
export interface DescribeSpotInstanceRequestsRequest {
  Filters?: Filter[];
  DryRun?: boolean;
  SpotInstanceRequestIds?: string[];
  NextToken?: string;
  MaxResults?: number;
}
export interface RunInstancesMonitoringEnabled {
  Enabled: boolean | undefined;
}
export interface LaunchSpecification {
  UserData?: string;
  SecurityGroups?: GroupIdentifier[];
  AddressingType?: string;
  BlockDeviceMappings?: BlockDeviceMapping[];
  EbsOptimized?: boolean;
  IamInstanceProfile?: IamInstanceProfileSpecification;
  ImageId?: string;
  InstanceType?: _InstanceType | string;
  KernelId?: string;
  KeyName?: string;
  NetworkInterfaces?: InstanceNetworkInterfaceSpecification[];
  Placement?: SpotPlacement;
  RamdiskId?: string;
  SubnetId?: string;
  Monitoring?: RunInstancesMonitoringEnabled;
}
export declare enum SpotInstanceState {
  active = "active",
  cancelled = "cancelled",
  closed = "closed",
  failed = "failed",
  open = "open",
}
export interface SpotInstanceStatus {
  Code?: string;
  Message?: string;
  UpdateTime?: Date;
}
export interface SpotInstanceRequest {
  ActualBlockHourlyPrice?: string;
  AvailabilityZoneGroup?: string;
  BlockDurationMinutes?: number;
  CreateTime?: Date;
  Fault?: SpotInstanceStateFault;
  InstanceId?: string;
  LaunchGroup?: string;
  LaunchSpecification?: LaunchSpecification;
  LaunchedAvailabilityZone?: string;
  ProductDescription?: RIProductDescription | string;
  SpotInstanceRequestId?: string;
  SpotPrice?: string;
  State?: SpotInstanceState | string;
  Status?: SpotInstanceStatus;
  Tags?: Tag[];
  Type?: SpotInstanceType | string;
  ValidFrom?: Date;
  ValidUntil?: Date;
  InstanceInterruptionBehavior?: InstanceInterruptionBehavior | string;
}
export interface DescribeSpotInstanceRequestsResult {
  SpotInstanceRequests?: SpotInstanceRequest[];
  NextToken?: string;
}
export interface DescribeSpotPriceHistoryRequest {
  Filters?: Filter[];
  AvailabilityZone?: string;
  DryRun?: boolean;
  EndTime?: Date;
  InstanceTypes?: (_InstanceType | string)[];
  MaxResults?: number;
  NextToken?: string;
  ProductDescriptions?: string[];
  StartTime?: Date;
}
export interface SpotPrice {
  AvailabilityZone?: string;
  InstanceType?: _InstanceType | string;
  ProductDescription?: RIProductDescription | string;
  SpotPrice?: string;
  Timestamp?: Date;
}
export interface DescribeSpotPriceHistoryResult {
  NextToken?: string;
  SpotPriceHistory?: SpotPrice[];
}
export interface DescribeStaleSecurityGroupsRequest {
  DryRun?: boolean;
  MaxResults?: number;
  NextToken?: string;
  VpcId: string | undefined;
}
export interface StaleIpPermission {
  FromPort?: number;
  IpProtocol?: string;
  IpRanges?: string[];
  PrefixListIds?: string[];
  ToPort?: number;
  UserIdGroupPairs?: UserIdGroupPair[];
}
export interface StaleSecurityGroup {
  Description?: string;
  GroupId?: string;
  GroupName?: string;
  StaleIpPermissions?: StaleIpPermission[];
  StaleIpPermissionsEgress?: StaleIpPermission[];
  VpcId?: string;
}
export interface DescribeStaleSecurityGroupsResult {
  NextToken?: string;
  StaleSecurityGroupSet?: StaleSecurityGroup[];
}
export interface DescribeStoreImageTasksRequest {
  ImageIds?: string[];
  DryRun?: boolean;
  Filters?: Filter[];
  NextToken?: string;
  MaxResults?: number;
}
export interface StoreImageTaskResult {
  AmiId?: string;
  TaskStartTime?: Date;
  Bucket?: string;
  S3objectKey?: string;
  ProgressPercentage?: number;
  StoreTaskState?: string;
  StoreTaskFailureReason?: string;
}
export interface DescribeStoreImageTasksResult {
  StoreImageTaskResults?: StoreImageTaskResult[];
  NextToken?: string;
}
export interface DescribeSubnetsRequest {
  Filters?: Filter[];
  SubnetIds?: string[];
  DryRun?: boolean;
  NextToken?: string;
  MaxResults?: number;
}
export interface DescribeSubnetsResult {
  Subnets?: Subnet[];
  NextToken?: string;
}
export interface DescribeTagsRequest {
  DryRun?: boolean;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface TagDescription {
  Key?: string;
  ResourceId?: string;
  ResourceType?: ResourceType | string;
  Value?: string;
}
export interface DescribeTagsResult {
  NextToken?: string;
  Tags?: TagDescription[];
}
export interface DescribeTrafficMirrorFiltersRequest {
  TrafficMirrorFilterIds?: string[];
  DryRun?: boolean;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface DescribeTrafficMirrorFiltersResult {
  TrafficMirrorFilters?: TrafficMirrorFilter[];
  NextToken?: string;
}
export interface DescribeTrafficMirrorSessionsRequest {
  TrafficMirrorSessionIds?: string[];
  DryRun?: boolean;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface DescribeTrafficMirrorSessionsResult {
  TrafficMirrorSessions?: TrafficMirrorSession[];
  NextToken?: string;
}
export interface DescribeTrafficMirrorTargetsRequest {
  TrafficMirrorTargetIds?: string[];
  DryRun?: boolean;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface DescribeTrafficMirrorTargetsResult {
  TrafficMirrorTargets?: TrafficMirrorTarget[];
  NextToken?: string;
}
export interface DescribeTransitGatewayAttachmentsRequest {
  TransitGatewayAttachmentIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface TransitGatewayAttachmentAssociation {
  TransitGatewayRouteTableId?: string;
  State?: TransitGatewayAssociationState | string;
}
export interface TransitGatewayAttachment {
  TransitGatewayAttachmentId?: string;
  TransitGatewayId?: string;
  TransitGatewayOwnerId?: string;
  ResourceOwnerId?: string;
  ResourceType?: TransitGatewayAttachmentResourceType | string;
  ResourceId?: string;
  State?: TransitGatewayAttachmentState | string;
  Association?: TransitGatewayAttachmentAssociation;
  CreationTime?: Date;
  Tags?: Tag[];
}
export interface DescribeTransitGatewayAttachmentsResult {
  TransitGatewayAttachments?: TransitGatewayAttachment[];
  NextToken?: string;
}
export interface DescribeTransitGatewayConnectPeersRequest {
  TransitGatewayConnectPeerIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeTransitGatewayConnectPeersResult {
  TransitGatewayConnectPeers?: TransitGatewayConnectPeer[];
  NextToken?: string;
}
export interface DescribeTransitGatewayConnectsRequest {
  TransitGatewayAttachmentIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeTransitGatewayConnectsResult {
  TransitGatewayConnects?: TransitGatewayConnect[];
  NextToken?: string;
}
export interface DescribeTransitGatewayMulticastDomainsRequest {
  TransitGatewayMulticastDomainIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeTransitGatewayMulticastDomainsResult {
  TransitGatewayMulticastDomains?: TransitGatewayMulticastDomain[];
  NextToken?: string;
}
export interface DescribeTransitGatewayPeeringAttachmentsRequest {
  TransitGatewayAttachmentIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeTransitGatewayPeeringAttachmentsResult {
  TransitGatewayPeeringAttachments?: TransitGatewayPeeringAttachment[];
  NextToken?: string;
}
export interface DescribeTransitGatewayPolicyTablesRequest {
  TransitGatewayPolicyTableIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeTransitGatewayPolicyTablesResult {
  TransitGatewayPolicyTables?: TransitGatewayPolicyTable[];
  NextToken?: string;
}
export interface DescribeTransitGatewayRouteTableAnnouncementsRequest {
  TransitGatewayRouteTableAnnouncementIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeTransitGatewayRouteTableAnnouncementsResult {
  TransitGatewayRouteTableAnnouncements?: TransitGatewayRouteTableAnnouncement[];
  NextToken?: string;
}
export interface DescribeTransitGatewayRouteTablesRequest {
  TransitGatewayRouteTableIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeTransitGatewayRouteTablesResult {
  TransitGatewayRouteTables?: TransitGatewayRouteTable[];
  NextToken?: string;
}
export interface DescribeTransitGatewaysRequest {
  TransitGatewayIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeTransitGatewaysResult {
  TransitGateways?: TransitGateway[];
  NextToken?: string;
}
export interface DescribeTransitGatewayVpcAttachmentsRequest {
  TransitGatewayAttachmentIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeTransitGatewayVpcAttachmentsResult {
  TransitGatewayVpcAttachments?: TransitGatewayVpcAttachment[];
  NextToken?: string;
}
export interface DescribeTrunkInterfaceAssociationsRequest {
  AssociationIds?: string[];
  DryRun?: boolean;
  Filters?: Filter[];
  NextToken?: string;
  MaxResults?: number;
}
export interface DescribeTrunkInterfaceAssociationsResult {
  InterfaceAssociations?: TrunkInterfaceAssociation[];
  NextToken?: string;
}
export interface DescribeVerifiedAccessEndpointsRequest {
  VerifiedAccessEndpointIds?: string[];
  VerifiedAccessInstanceId?: string;
  VerifiedAccessGroupId?: string;
  MaxResults?: number;
  NextToken?: string;
  Filters?: Filter[];
  DryRun?: boolean;
}
export interface DescribeVerifiedAccessEndpointsResult {
  VerifiedAccessEndpoints?: VerifiedAccessEndpoint[];
  NextToken?: string;
}
export interface DescribeVerifiedAccessGroupsRequest {
  VerifiedAccessGroupIds?: string[];
  VerifiedAccessInstanceId?: string;
  MaxResults?: number;
  NextToken?: string;
  Filters?: Filter[];
  DryRun?: boolean;
}
export interface DescribeVerifiedAccessGroupsResult {
  VerifiedAccessGroups?: VerifiedAccessGroup[];
  NextToken?: string;
}
export interface DescribeVerifiedAccessInstanceLoggingConfigurationsRequest {
  VerifiedAccessInstanceIds?: string[];
  MaxResults?: number;
  NextToken?: string;
  Filters?: Filter[];
  DryRun?: boolean;
}
export declare enum VerifiedAccessLogDeliveryStatusCode {
  FAILED = "failed",
  SUCCESS = "success",
}
export interface VerifiedAccessLogDeliveryStatus {
  Code?: VerifiedAccessLogDeliveryStatusCode | string;
  Message?: string;
}
export interface VerifiedAccessLogCloudWatchLogsDestination {
  Enabled?: boolean;
  DeliveryStatus?: VerifiedAccessLogDeliveryStatus;
  LogGroup?: string;
}
export interface VerifiedAccessLogKinesisDataFirehoseDestination {
  Enabled?: boolean;
  DeliveryStatus?: VerifiedAccessLogDeliveryStatus;
  DeliveryStream?: string;
}
export interface VerifiedAccessLogS3Destination {
  Enabled?: boolean;
  DeliveryStatus?: VerifiedAccessLogDeliveryStatus;
  BucketName?: string;
  Prefix?: string;
  BucketOwner?: string;
}
export interface VerifiedAccessLogs {
  S3?: VerifiedAccessLogS3Destination;
  CloudWatchLogs?: VerifiedAccessLogCloudWatchLogsDestination;
  KinesisDataFirehose?: VerifiedAccessLogKinesisDataFirehoseDestination;
}
export interface VerifiedAccessInstanceLoggingConfiguration {
  VerifiedAccessInstanceId?: string;
  AccessLogs?: VerifiedAccessLogs;
}
export interface DescribeVerifiedAccessInstanceLoggingConfigurationsResult {
  LoggingConfigurations?: VerifiedAccessInstanceLoggingConfiguration[];
  NextToken?: string;
}
export interface DescribeVerifiedAccessInstancesRequest {
  VerifiedAccessInstanceIds?: string[];
  MaxResults?: number;
  NextToken?: string;
  Filters?: Filter[];
  DryRun?: boolean;
}
export interface DescribeVerifiedAccessInstancesResult {
  VerifiedAccessInstances?: VerifiedAccessInstance[];
  NextToken?: string;
}
export interface DescribeVerifiedAccessTrustProvidersRequest {
  VerifiedAccessTrustProviderIds?: string[];
  MaxResults?: number;
  NextToken?: string;
  Filters?: Filter[];
  DryRun?: boolean;
}
export interface DescribeVerifiedAccessTrustProvidersResult {
  VerifiedAccessTrustProviders?: VerifiedAccessTrustProvider[];
  NextToken?: string;
}
export declare enum VolumeAttributeName {
  autoEnableIO = "autoEnableIO",
  productCodes = "productCodes",
}
export interface DescribeVolumeAttributeRequest {
  Attribute: VolumeAttributeName | string | undefined;
  VolumeId: string | undefined;
  DryRun?: boolean;
}
export interface DescribeVolumeAttributeResult {
  AutoEnableIO?: AttributeBooleanValue;
  ProductCodes?: ProductCode[];
  VolumeId?: string;
}
export interface DescribeVolumesRequest {
  Filters?: Filter[];
  VolumeIds?: string[];
  DryRun?: boolean;
  MaxResults?: number;
  NextToken?: string;
}
export interface DescribeVolumesResult {
  Volumes?: Volume[];
  NextToken?: string;
}
export interface DescribeVolumesModificationsRequest {
  DryRun?: boolean;
  VolumeIds?: string[];
  Filters?: Filter[];
  NextToken?: string;
  MaxResults?: number;
}
export declare enum VolumeModificationState {
  completed = "completed",
  failed = "failed",
  modifying = "modifying",
  optimizing = "optimizing",
}
export interface VolumeModification {
  VolumeId?: string;
  ModificationState?: VolumeModificationState | string;
  StatusMessage?: string;
  TargetSize?: number;
  TargetIops?: number;
  TargetVolumeType?: VolumeType | string;
  TargetThroughput?: number;
  TargetMultiAttachEnabled?: boolean;
  OriginalSize?: number;
  OriginalIops?: number;
  OriginalVolumeType?: VolumeType | string;
  OriginalThroughput?: number;
  OriginalMultiAttachEnabled?: boolean;
  Progress?: number;
  StartTime?: Date;
  EndTime?: Date;
}
export interface DescribeVolumesModificationsResult {
  VolumesModifications?: VolumeModification[];
  NextToken?: string;
}
export interface DescribeVolumeStatusRequest {
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  VolumeIds?: string[];
  DryRun?: boolean;
}
export interface VolumeStatusAction {
  Code?: string;
  Description?: string;
  EventId?: string;
  EventType?: string;
}
export interface VolumeStatusAttachmentStatus {
  IoPerformance?: string;
  InstanceId?: string;
}
export interface VolumeStatusEvent {
  Description?: string;
  EventId?: string;
  EventType?: string;
  NotAfter?: Date;
  NotBefore?: Date;
  InstanceId?: string;
}
export declare enum VolumeStatusName {
  io_enabled = "io-enabled",
  io_performance = "io-performance",
}
export interface VolumeStatusDetails {
  Name?: VolumeStatusName | string;
  Status?: string;
}
export declare enum VolumeStatusInfoStatus {
  impaired = "impaired",
  insufficient_data = "insufficient-data",
  ok = "ok",
}
export interface VolumeStatusInfo {
  Details?: VolumeStatusDetails[];
  Status?: VolumeStatusInfoStatus | string;
}
export interface VolumeStatusItem {
  Actions?: VolumeStatusAction[];
  AvailabilityZone?: string;
  OutpostArn?: string;
  Events?: VolumeStatusEvent[];
  VolumeId?: string;
  VolumeStatus?: VolumeStatusInfo;
  AttachmentStatuses?: VolumeStatusAttachmentStatus[];
}
export interface DescribeVolumeStatusResult {
  NextToken?: string;
  VolumeStatuses?: VolumeStatusItem[];
}
export declare enum VpcAttributeName {
  enableDnsHostnames = "enableDnsHostnames",
  enableDnsSupport = "enableDnsSupport",
  enableNetworkAddressUsageMetrics = "enableNetworkAddressUsageMetrics",
}
export interface DescribeVpcAttributeRequest {
  Attribute: VpcAttributeName | string | undefined;
  VpcId: string | undefined;
  DryRun?: boolean;
}
export interface DescribeVpcAttributeResult {
  VpcId?: string;
  EnableDnsHostnames?: AttributeBooleanValue;
  EnableDnsSupport?: AttributeBooleanValue;
  EnableNetworkAddressUsageMetrics?: AttributeBooleanValue;
}
export interface DescribeVpcClassicLinkRequest {
  Filters?: Filter[];
  DryRun?: boolean;
  VpcIds?: string[];
}
export interface VpcClassicLink {
  ClassicLinkEnabled?: boolean;
  Tags?: Tag[];
  VpcId?: string;
}
export interface DescribeVpcClassicLinkResult {
  Vpcs?: VpcClassicLink[];
}
export interface DescribeVpcClassicLinkDnsSupportRequest {
  MaxResults?: number;
  NextToken?: string;
  VpcIds?: string[];
}
export interface ClassicLinkDnsSupport {
  ClassicLinkDnsSupported?: boolean;
  VpcId?: string;
}
export interface DescribeVpcClassicLinkDnsSupportResult {
  NextToken?: string;
  Vpcs?: ClassicLinkDnsSupport[];
}
export interface DescribeVpcEndpointConnectionNotificationsRequest {
  DryRun?: boolean;
  ConnectionNotificationId?: string;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface DescribeVpcEndpointConnectionNotificationsResult {
  ConnectionNotificationSet?: ConnectionNotification[];
  NextToken?: string;
}
export interface DescribeVpcEndpointConnectionsRequest {
  DryRun?: boolean;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface VpcEndpointConnection {
  ServiceId?: string;
  VpcEndpointId?: string;
  VpcEndpointOwner?: string;
  VpcEndpointState?: State | string;
  CreationTimestamp?: Date;
  DnsEntries?: DnsEntry[];
  NetworkLoadBalancerArns?: string[];
  GatewayLoadBalancerArns?: string[];
  IpAddressType?: IpAddressType | string;
  VpcEndpointConnectionId?: string;
  Tags?: Tag[];
}
export interface DescribeVpcEndpointConnectionsResult {
  VpcEndpointConnections?: VpcEndpointConnection[];
  NextToken?: string;
}
export interface DescribeVpcEndpointsRequest {
  DryRun?: boolean;
  VpcEndpointIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface DescribeVpcEndpointsResult {
  VpcEndpoints?: VpcEndpoint[];
  NextToken?: string;
}
export interface DescribeVpcEndpointServiceConfigurationsRequest {
  DryRun?: boolean;
  ServiceIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export declare const EbsOptimizedInfoFilterSensitiveLog: (
  obj: EbsOptimizedInfo
) => any;
export declare const EbsInfoFilterSensitiveLog: (obj: EbsInfo) => any;
export declare const FpgaDeviceMemoryInfoFilterSensitiveLog: (
  obj: FpgaDeviceMemoryInfo
) => any;
export declare const FpgaDeviceInfoFilterSensitiveLog: (
  obj: FpgaDeviceInfo
) => any;
export declare const FpgaInfoFilterSensitiveLog: (obj: FpgaInfo) => any;
export declare const GpuDeviceMemoryInfoFilterSensitiveLog: (
  obj: GpuDeviceMemoryInfo
) => any;
export declare const GpuDeviceInfoFilterSensitiveLog: (
  obj: GpuDeviceInfo
) => any;
export declare const GpuInfoFilterSensitiveLog: (obj: GpuInfo) => any;
export declare const InferenceDeviceInfoFilterSensitiveLog: (
  obj: InferenceDeviceInfo
) => any;
export declare const InferenceAcceleratorInfoFilterSensitiveLog: (
  obj: InferenceAcceleratorInfo
) => any;
export declare const DiskInfoFilterSensitiveLog: (obj: DiskInfo) => any;
export declare const InstanceStorageInfoFilterSensitiveLog: (
  obj: InstanceStorageInfo
) => any;
export declare const MemoryInfoFilterSensitiveLog: (obj: MemoryInfo) => any;
export declare const EfaInfoFilterSensitiveLog: (obj: EfaInfo) => any;
export declare const NetworkCardInfoFilterSensitiveLog: (
  obj: NetworkCardInfo
) => any;
export declare const NetworkInfoFilterSensitiveLog: (obj: NetworkInfo) => any;
export declare const PlacementGroupInfoFilterSensitiveLog: (
  obj: PlacementGroupInfo
) => any;
export declare const ProcessorInfoFilterSensitiveLog: (
  obj: ProcessorInfo
) => any;
export declare const VCpuInfoFilterSensitiveLog: (obj: VCpuInfo) => any;
export declare const InstanceTypeInfoFilterSensitiveLog: (
  obj: InstanceTypeInfo
) => any;
export declare const DescribeInstanceTypesResultFilterSensitiveLog: (
  obj: DescribeInstanceTypesResult
) => any;
export declare const DescribeInternetGatewaysRequestFilterSensitiveLog: (
  obj: DescribeInternetGatewaysRequest
) => any;
export declare const DescribeInternetGatewaysResultFilterSensitiveLog: (
  obj: DescribeInternetGatewaysResult
) => any;
export declare const DescribeIpamPoolsRequestFilterSensitiveLog: (
  obj: DescribeIpamPoolsRequest
) => any;
export declare const DescribeIpamPoolsResultFilterSensitiveLog: (
  obj: DescribeIpamPoolsResult
) => any;
export declare const DescribeIpamsRequestFilterSensitiveLog: (
  obj: DescribeIpamsRequest
) => any;
export declare const DescribeIpamsResultFilterSensitiveLog: (
  obj: DescribeIpamsResult
) => any;
export declare const DescribeIpamScopesRequestFilterSensitiveLog: (
  obj: DescribeIpamScopesRequest
) => any;
export declare const DescribeIpamScopesResultFilterSensitiveLog: (
  obj: DescribeIpamScopesResult
) => any;
export declare const DescribeIpv6PoolsRequestFilterSensitiveLog: (
  obj: DescribeIpv6PoolsRequest
) => any;
export declare const PoolCidrBlockFilterSensitiveLog: (
  obj: PoolCidrBlock
) => any;
export declare const Ipv6PoolFilterSensitiveLog: (obj: Ipv6Pool) => any;
export declare const DescribeIpv6PoolsResultFilterSensitiveLog: (
  obj: DescribeIpv6PoolsResult
) => any;
export declare const DescribeKeyPairsRequestFilterSensitiveLog: (
  obj: DescribeKeyPairsRequest
) => any;
export declare const KeyPairInfoFilterSensitiveLog: (obj: KeyPairInfo) => any;
export declare const DescribeKeyPairsResultFilterSensitiveLog: (
  obj: DescribeKeyPairsResult
) => any;
export declare const DescribeLaunchTemplatesRequestFilterSensitiveLog: (
  obj: DescribeLaunchTemplatesRequest
) => any;
export declare const DescribeLaunchTemplatesResultFilterSensitiveLog: (
  obj: DescribeLaunchTemplatesResult
) => any;
export declare const DescribeLaunchTemplateVersionsRequestFilterSensitiveLog: (
  obj: DescribeLaunchTemplateVersionsRequest
) => any;
export declare const DescribeLaunchTemplateVersionsResultFilterSensitiveLog: (
  obj: DescribeLaunchTemplateVersionsResult
) => any;
export declare const DescribeLocalGatewayRouteTablesRequestFilterSensitiveLog: (
  obj: DescribeLocalGatewayRouteTablesRequest
) => any;
export declare const DescribeLocalGatewayRouteTablesResultFilterSensitiveLog: (
  obj: DescribeLocalGatewayRouteTablesResult
) => any;
export declare const DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequestFilterSensitiveLog: (
  obj: DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest
) => any;
export declare const DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResultFilterSensitiveLog: (
  obj: DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResult
) => any;
export declare const DescribeLocalGatewayRouteTableVpcAssociationsRequestFilterSensitiveLog: (
  obj: DescribeLocalGatewayRouteTableVpcAssociationsRequest
) => any;
export declare const DescribeLocalGatewayRouteTableVpcAssociationsResultFilterSensitiveLog: (
  obj: DescribeLocalGatewayRouteTableVpcAssociationsResult
) => any;
export declare const DescribeLocalGatewaysRequestFilterSensitiveLog: (
  obj: DescribeLocalGatewaysRequest
) => any;
export declare const LocalGatewayFilterSensitiveLog: (obj: LocalGateway) => any;
export declare const DescribeLocalGatewaysResultFilterSensitiveLog: (
  obj: DescribeLocalGatewaysResult
) => any;
export declare const DescribeLocalGatewayVirtualInterfaceGroupsRequestFilterSensitiveLog: (
  obj: DescribeLocalGatewayVirtualInterfaceGroupsRequest
) => any;
export declare const LocalGatewayVirtualInterfaceGroupFilterSensitiveLog: (
  obj: LocalGatewayVirtualInterfaceGroup
) => any;
export declare const DescribeLocalGatewayVirtualInterfaceGroupsResultFilterSensitiveLog: (
  obj: DescribeLocalGatewayVirtualInterfaceGroupsResult
) => any;
export declare const DescribeLocalGatewayVirtualInterfacesRequestFilterSensitiveLog: (
  obj: DescribeLocalGatewayVirtualInterfacesRequest
) => any;
export declare const LocalGatewayVirtualInterfaceFilterSensitiveLog: (
  obj: LocalGatewayVirtualInterface
) => any;
export declare const DescribeLocalGatewayVirtualInterfacesResultFilterSensitiveLog: (
  obj: DescribeLocalGatewayVirtualInterfacesResult
) => any;
export declare const DescribeManagedPrefixListsRequestFilterSensitiveLog: (
  obj: DescribeManagedPrefixListsRequest
) => any;
export declare const DescribeManagedPrefixListsResultFilterSensitiveLog: (
  obj: DescribeManagedPrefixListsResult
) => any;
export declare const DescribeMovingAddressesRequestFilterSensitiveLog: (
  obj: DescribeMovingAddressesRequest
) => any;
export declare const MovingAddressStatusFilterSensitiveLog: (
  obj: MovingAddressStatus
) => any;
export declare const DescribeMovingAddressesResultFilterSensitiveLog: (
  obj: DescribeMovingAddressesResult
) => any;
export declare const DescribeNatGatewaysRequestFilterSensitiveLog: (
  obj: DescribeNatGatewaysRequest
) => any;
export declare const DescribeNatGatewaysResultFilterSensitiveLog: (
  obj: DescribeNatGatewaysResult
) => any;
export declare const DescribeNetworkAclsRequestFilterSensitiveLog: (
  obj: DescribeNetworkAclsRequest
) => any;
export declare const DescribeNetworkAclsResultFilterSensitiveLog: (
  obj: DescribeNetworkAclsResult
) => any;
export declare const DescribeNetworkInsightsAccessScopeAnalysesRequestFilterSensitiveLog: (
  obj: DescribeNetworkInsightsAccessScopeAnalysesRequest
) => any;
export declare const NetworkInsightsAccessScopeAnalysisFilterSensitiveLog: (
  obj: NetworkInsightsAccessScopeAnalysis
) => any;
export declare const DescribeNetworkInsightsAccessScopeAnalysesResultFilterSensitiveLog: (
  obj: DescribeNetworkInsightsAccessScopeAnalysesResult
) => any;
export declare const DescribeNetworkInsightsAccessScopesRequestFilterSensitiveLog: (
  obj: DescribeNetworkInsightsAccessScopesRequest
) => any;
export declare const DescribeNetworkInsightsAccessScopesResultFilterSensitiveLog: (
  obj: DescribeNetworkInsightsAccessScopesResult
) => any;
export declare const DescribeNetworkInsightsAnalysesRequestFilterSensitiveLog: (
  obj: DescribeNetworkInsightsAnalysesRequest
) => any;
export declare const NetworkInsightsAnalysisFilterSensitiveLog: (
  obj: NetworkInsightsAnalysis
) => any;
export declare const DescribeNetworkInsightsAnalysesResultFilterSensitiveLog: (
  obj: DescribeNetworkInsightsAnalysesResult
) => any;
export declare const DescribeNetworkInsightsPathsRequestFilterSensitiveLog: (
  obj: DescribeNetworkInsightsPathsRequest
) => any;
export declare const DescribeNetworkInsightsPathsResultFilterSensitiveLog: (
  obj: DescribeNetworkInsightsPathsResult
) => any;
export declare const DescribeNetworkInterfaceAttributeRequestFilterSensitiveLog: (
  obj: DescribeNetworkInterfaceAttributeRequest
) => any;
export declare const DescribeNetworkInterfaceAttributeResultFilterSensitiveLog: (
  obj: DescribeNetworkInterfaceAttributeResult
) => any;
export declare const DescribeNetworkInterfacePermissionsRequestFilterSensitiveLog: (
  obj: DescribeNetworkInterfacePermissionsRequest
) => any;
export declare const DescribeNetworkInterfacePermissionsResultFilterSensitiveLog: (
  obj: DescribeNetworkInterfacePermissionsResult
) => any;
export declare const DescribeNetworkInterfacesRequestFilterSensitiveLog: (
  obj: DescribeNetworkInterfacesRequest
) => any;
export declare const DescribeNetworkInterfacesResultFilterSensitiveLog: (
  obj: DescribeNetworkInterfacesResult
) => any;
export declare const DescribePlacementGroupsRequestFilterSensitiveLog: (
  obj: DescribePlacementGroupsRequest
) => any;
export declare const DescribePlacementGroupsResultFilterSensitiveLog: (
  obj: DescribePlacementGroupsResult
) => any;
export declare const DescribePrefixListsRequestFilterSensitiveLog: (
  obj: DescribePrefixListsRequest
) => any;
export declare const PrefixListFilterSensitiveLog: (obj: PrefixList) => any;
export declare const DescribePrefixListsResultFilterSensitiveLog: (
  obj: DescribePrefixListsResult
) => any;
export declare const DescribePrincipalIdFormatRequestFilterSensitiveLog: (
  obj: DescribePrincipalIdFormatRequest
) => any;
export declare const PrincipalIdFormatFilterSensitiveLog: (
  obj: PrincipalIdFormat
) => any;
export declare const DescribePrincipalIdFormatResultFilterSensitiveLog: (
  obj: DescribePrincipalIdFormatResult
) => any;
export declare const DescribePublicIpv4PoolsRequestFilterSensitiveLog: (
  obj: DescribePublicIpv4PoolsRequest
) => any;
export declare const PublicIpv4PoolRangeFilterSensitiveLog: (
  obj: PublicIpv4PoolRange
) => any;
export declare const PublicIpv4PoolFilterSensitiveLog: (
  obj: PublicIpv4Pool
) => any;
export declare const DescribePublicIpv4PoolsResultFilterSensitiveLog: (
  obj: DescribePublicIpv4PoolsResult
) => any;
export declare const DescribeRegionsRequestFilterSensitiveLog: (
  obj: DescribeRegionsRequest
) => any;
export declare const RegionFilterSensitiveLog: (obj: Region) => any;
export declare const DescribeRegionsResultFilterSensitiveLog: (
  obj: DescribeRegionsResult
) => any;
export declare const DescribeReplaceRootVolumeTasksRequestFilterSensitiveLog: (
  obj: DescribeReplaceRootVolumeTasksRequest
) => any;
export declare const DescribeReplaceRootVolumeTasksResultFilterSensitiveLog: (
  obj: DescribeReplaceRootVolumeTasksResult
) => any;
export declare const DescribeReservedInstancesRequestFilterSensitiveLog: (
  obj: DescribeReservedInstancesRequest
) => any;
export declare const RecurringChargeFilterSensitiveLog: (
  obj: RecurringCharge
) => any;
export declare const ReservedInstancesFilterSensitiveLog: (
  obj: ReservedInstances
) => any;
export declare const DescribeReservedInstancesResultFilterSensitiveLog: (
  obj: DescribeReservedInstancesResult
) => any;
export declare const DescribeReservedInstancesListingsRequestFilterSensitiveLog: (
  obj: DescribeReservedInstancesListingsRequest
) => any;
export declare const DescribeReservedInstancesListingsResultFilterSensitiveLog: (
  obj: DescribeReservedInstancesListingsResult
) => any;
export declare const DescribeReservedInstancesModificationsRequestFilterSensitiveLog: (
  obj: DescribeReservedInstancesModificationsRequest
) => any;
export declare const ReservedInstancesConfigurationFilterSensitiveLog: (
  obj: ReservedInstancesConfiguration
) => any;
export declare const ReservedInstancesModificationResultFilterSensitiveLog: (
  obj: ReservedInstancesModificationResult
) => any;
export declare const ReservedInstancesIdFilterSensitiveLog: (
  obj: ReservedInstancesId
) => any;
export declare const ReservedInstancesModificationFilterSensitiveLog: (
  obj: ReservedInstancesModification
) => any;
export declare const DescribeReservedInstancesModificationsResultFilterSensitiveLog: (
  obj: DescribeReservedInstancesModificationsResult
) => any;
export declare const DescribeReservedInstancesOfferingsRequestFilterSensitiveLog: (
  obj: DescribeReservedInstancesOfferingsRequest
) => any;
export declare const PricingDetailFilterSensitiveLog: (
  obj: PricingDetail
) => any;
export declare const ReservedInstancesOfferingFilterSensitiveLog: (
  obj: ReservedInstancesOffering
) => any;
export declare const DescribeReservedInstancesOfferingsResultFilterSensitiveLog: (
  obj: DescribeReservedInstancesOfferingsResult
) => any;
export declare const DescribeRouteTablesRequestFilterSensitiveLog: (
  obj: DescribeRouteTablesRequest
) => any;
export declare const DescribeRouteTablesResultFilterSensitiveLog: (
  obj: DescribeRouteTablesResult
) => any;
export declare const SlotDateTimeRangeRequestFilterSensitiveLog: (
  obj: SlotDateTimeRangeRequest
) => any;
export declare const ScheduledInstanceRecurrenceRequestFilterSensitiveLog: (
  obj: ScheduledInstanceRecurrenceRequest
) => any;
export declare const DescribeScheduledInstanceAvailabilityRequestFilterSensitiveLog: (
  obj: DescribeScheduledInstanceAvailabilityRequest
) => any;
export declare const ScheduledInstanceRecurrenceFilterSensitiveLog: (
  obj: ScheduledInstanceRecurrence
) => any;
export declare const ScheduledInstanceAvailabilityFilterSensitiveLog: (
  obj: ScheduledInstanceAvailability
) => any;
export declare const DescribeScheduledInstanceAvailabilityResultFilterSensitiveLog: (
  obj: DescribeScheduledInstanceAvailabilityResult
) => any;
export declare const SlotStartTimeRangeRequestFilterSensitiveLog: (
  obj: SlotStartTimeRangeRequest
) => any;
export declare const DescribeScheduledInstancesRequestFilterSensitiveLog: (
  obj: DescribeScheduledInstancesRequest
) => any;
export declare const ScheduledInstanceFilterSensitiveLog: (
  obj: ScheduledInstance
) => any;
export declare const DescribeScheduledInstancesResultFilterSensitiveLog: (
  obj: DescribeScheduledInstancesResult
) => any;
export declare const DescribeSecurityGroupReferencesRequestFilterSensitiveLog: (
  obj: DescribeSecurityGroupReferencesRequest
) => any;
export declare const SecurityGroupReferenceFilterSensitiveLog: (
  obj: SecurityGroupReference
) => any;
export declare const DescribeSecurityGroupReferencesResultFilterSensitiveLog: (
  obj: DescribeSecurityGroupReferencesResult
) => any;
export declare const DescribeSecurityGroupRulesRequestFilterSensitiveLog: (
  obj: DescribeSecurityGroupRulesRequest
) => any;
export declare const DescribeSecurityGroupRulesResultFilterSensitiveLog: (
  obj: DescribeSecurityGroupRulesResult
) => any;
export declare const DescribeSecurityGroupsRequestFilterSensitiveLog: (
  obj: DescribeSecurityGroupsRequest
) => any;
export declare const SecurityGroupFilterSensitiveLog: (
  obj: SecurityGroup
) => any;
export declare const DescribeSecurityGroupsResultFilterSensitiveLog: (
  obj: DescribeSecurityGroupsResult
) => any;
export declare const DescribeSnapshotAttributeRequestFilterSensitiveLog: (
  obj: DescribeSnapshotAttributeRequest
) => any;
export declare const CreateVolumePermissionFilterSensitiveLog: (
  obj: CreateVolumePermission
) => any;
export declare const DescribeSnapshotAttributeResultFilterSensitiveLog: (
  obj: DescribeSnapshotAttributeResult
) => any;
export declare const DescribeSnapshotsRequestFilterSensitiveLog: (
  obj: DescribeSnapshotsRequest
) => any;
export declare const DescribeSnapshotsResultFilterSensitiveLog: (
  obj: DescribeSnapshotsResult
) => any;
export declare const DescribeSnapshotTierStatusRequestFilterSensitiveLog: (
  obj: DescribeSnapshotTierStatusRequest
) => any;
export declare const SnapshotTierStatusFilterSensitiveLog: (
  obj: SnapshotTierStatus
) => any;
export declare const DescribeSnapshotTierStatusResultFilterSensitiveLog: (
  obj: DescribeSnapshotTierStatusResult
) => any;
export declare const DescribeSpotDatafeedSubscriptionRequestFilterSensitiveLog: (
  obj: DescribeSpotDatafeedSubscriptionRequest
) => any;
export declare const DescribeSpotDatafeedSubscriptionResultFilterSensitiveLog: (
  obj: DescribeSpotDatafeedSubscriptionResult
) => any;
export declare const DescribeSpotFleetInstancesRequestFilterSensitiveLog: (
  obj: DescribeSpotFleetInstancesRequest
) => any;
export declare const DescribeSpotFleetInstancesResponseFilterSensitiveLog: (
  obj: DescribeSpotFleetInstancesResponse
) => any;
export declare const DescribeSpotFleetRequestHistoryRequestFilterSensitiveLog: (
  obj: DescribeSpotFleetRequestHistoryRequest
) => any;
export declare const HistoryRecordFilterSensitiveLog: (
  obj: HistoryRecord
) => any;
export declare const DescribeSpotFleetRequestHistoryResponseFilterSensitiveLog: (
  obj: DescribeSpotFleetRequestHistoryResponse
) => any;
export declare const DescribeSpotFleetRequestsRequestFilterSensitiveLog: (
  obj: DescribeSpotFleetRequestsRequest
) => any;
export declare const SpotFleetMonitoringFilterSensitiveLog: (
  obj: SpotFleetMonitoring
) => any;
export declare const InstanceNetworkInterfaceSpecificationFilterSensitiveLog: (
  obj: InstanceNetworkInterfaceSpecification
) => any;
export declare const SpotPlacementFilterSensitiveLog: (
  obj: SpotPlacement
) => any;
export declare const SpotFleetTagSpecificationFilterSensitiveLog: (
  obj: SpotFleetTagSpecification
) => any;
export declare const SpotFleetLaunchSpecificationFilterSensitiveLog: (
  obj: SpotFleetLaunchSpecification
) => any;
export declare const LaunchTemplateOverridesFilterSensitiveLog: (
  obj: LaunchTemplateOverrides
) => any;
export declare const LaunchTemplateConfigFilterSensitiveLog: (
  obj: LaunchTemplateConfig
) => any;
export declare const ClassicLoadBalancerFilterSensitiveLog: (
  obj: ClassicLoadBalancer
) => any;
export declare const ClassicLoadBalancersConfigFilterSensitiveLog: (
  obj: ClassicLoadBalancersConfig
) => any;
export declare const TargetGroupFilterSensitiveLog: (obj: TargetGroup) => any;
export declare const TargetGroupsConfigFilterSensitiveLog: (
  obj: TargetGroupsConfig
) => any;
export declare const LoadBalancersConfigFilterSensitiveLog: (
  obj: LoadBalancersConfig
) => any;
export declare const SpotCapacityRebalanceFilterSensitiveLog: (
  obj: SpotCapacityRebalance
) => any;
export declare const SpotMaintenanceStrategiesFilterSensitiveLog: (
  obj: SpotMaintenanceStrategies
) => any;
export declare const SpotFleetRequestConfigDataFilterSensitiveLog: (
  obj: SpotFleetRequestConfigData
) => any;
export declare const SpotFleetRequestConfigFilterSensitiveLog: (
  obj: SpotFleetRequestConfig
) => any;
export declare const DescribeSpotFleetRequestsResponseFilterSensitiveLog: (
  obj: DescribeSpotFleetRequestsResponse
) => any;
export declare const DescribeSpotInstanceRequestsRequestFilterSensitiveLog: (
  obj: DescribeSpotInstanceRequestsRequest
) => any;
export declare const RunInstancesMonitoringEnabledFilterSensitiveLog: (
  obj: RunInstancesMonitoringEnabled
) => any;
export declare const LaunchSpecificationFilterSensitiveLog: (
  obj: LaunchSpecification
) => any;
export declare const SpotInstanceStatusFilterSensitiveLog: (
  obj: SpotInstanceStatus
) => any;
export declare const SpotInstanceRequestFilterSensitiveLog: (
  obj: SpotInstanceRequest
) => any;
export declare const DescribeSpotInstanceRequestsResultFilterSensitiveLog: (
  obj: DescribeSpotInstanceRequestsResult
) => any;
export declare const DescribeSpotPriceHistoryRequestFilterSensitiveLog: (
  obj: DescribeSpotPriceHistoryRequest
) => any;
export declare const SpotPriceFilterSensitiveLog: (obj: SpotPrice) => any;
export declare const DescribeSpotPriceHistoryResultFilterSensitiveLog: (
  obj: DescribeSpotPriceHistoryResult
) => any;
export declare const DescribeStaleSecurityGroupsRequestFilterSensitiveLog: (
  obj: DescribeStaleSecurityGroupsRequest
) => any;
export declare const StaleIpPermissionFilterSensitiveLog: (
  obj: StaleIpPermission
) => any;
export declare const StaleSecurityGroupFilterSensitiveLog: (
  obj: StaleSecurityGroup
) => any;
export declare const DescribeStaleSecurityGroupsResultFilterSensitiveLog: (
  obj: DescribeStaleSecurityGroupsResult
) => any;
export declare const DescribeStoreImageTasksRequestFilterSensitiveLog: (
  obj: DescribeStoreImageTasksRequest
) => any;
export declare const StoreImageTaskResultFilterSensitiveLog: (
  obj: StoreImageTaskResult
) => any;
export declare const DescribeStoreImageTasksResultFilterSensitiveLog: (
  obj: DescribeStoreImageTasksResult
) => any;
export declare const DescribeSubnetsRequestFilterSensitiveLog: (
  obj: DescribeSubnetsRequest
) => any;
export declare const DescribeSubnetsResultFilterSensitiveLog: (
  obj: DescribeSubnetsResult
) => any;
export declare const DescribeTagsRequestFilterSensitiveLog: (
  obj: DescribeTagsRequest
) => any;
export declare const TagDescriptionFilterSensitiveLog: (
  obj: TagDescription
) => any;
export declare const DescribeTagsResultFilterSensitiveLog: (
  obj: DescribeTagsResult
) => any;
export declare const DescribeTrafficMirrorFiltersRequestFilterSensitiveLog: (
  obj: DescribeTrafficMirrorFiltersRequest
) => any;
export declare const DescribeTrafficMirrorFiltersResultFilterSensitiveLog: (
  obj: DescribeTrafficMirrorFiltersResult
) => any;
export declare const DescribeTrafficMirrorSessionsRequestFilterSensitiveLog: (
  obj: DescribeTrafficMirrorSessionsRequest
) => any;
export declare const DescribeTrafficMirrorSessionsResultFilterSensitiveLog: (
  obj: DescribeTrafficMirrorSessionsResult
) => any;
export declare const DescribeTrafficMirrorTargetsRequestFilterSensitiveLog: (
  obj: DescribeTrafficMirrorTargetsRequest
) => any;
export declare const DescribeTrafficMirrorTargetsResultFilterSensitiveLog: (
  obj: DescribeTrafficMirrorTargetsResult
) => any;
export declare const DescribeTransitGatewayAttachmentsRequestFilterSensitiveLog: (
  obj: DescribeTransitGatewayAttachmentsRequest
) => any;
export declare const TransitGatewayAttachmentAssociationFilterSensitiveLog: (
  obj: TransitGatewayAttachmentAssociation
) => any;
export declare const TransitGatewayAttachmentFilterSensitiveLog: (
  obj: TransitGatewayAttachment
) => any;
export declare const DescribeTransitGatewayAttachmentsResultFilterSensitiveLog: (
  obj: DescribeTransitGatewayAttachmentsResult
) => any;
export declare const DescribeTransitGatewayConnectPeersRequestFilterSensitiveLog: (
  obj: DescribeTransitGatewayConnectPeersRequest
) => any;
export declare const DescribeTransitGatewayConnectPeersResultFilterSensitiveLog: (
  obj: DescribeTransitGatewayConnectPeersResult
) => any;
export declare const DescribeTransitGatewayConnectsRequestFilterSensitiveLog: (
  obj: DescribeTransitGatewayConnectsRequest
) => any;
export declare const DescribeTransitGatewayConnectsResultFilterSensitiveLog: (
  obj: DescribeTransitGatewayConnectsResult
) => any;
export declare const DescribeTransitGatewayMulticastDomainsRequestFilterSensitiveLog: (
  obj: DescribeTransitGatewayMulticastDomainsRequest
) => any;
export declare const DescribeTransitGatewayMulticastDomainsResultFilterSensitiveLog: (
  obj: DescribeTransitGatewayMulticastDomainsResult
) => any;
export declare const DescribeTransitGatewayPeeringAttachmentsRequestFilterSensitiveLog: (
  obj: DescribeTransitGatewayPeeringAttachmentsRequest
) => any;
export declare const DescribeTransitGatewayPeeringAttachmentsResultFilterSensitiveLog: (
  obj: DescribeTransitGatewayPeeringAttachmentsResult
) => any;
export declare const DescribeTransitGatewayPolicyTablesRequestFilterSensitiveLog: (
  obj: DescribeTransitGatewayPolicyTablesRequest
) => any;
export declare const DescribeTransitGatewayPolicyTablesResultFilterSensitiveLog: (
  obj: DescribeTransitGatewayPolicyTablesResult
) => any;
export declare const DescribeTransitGatewayRouteTableAnnouncementsRequestFilterSensitiveLog: (
  obj: DescribeTransitGatewayRouteTableAnnouncementsRequest
) => any;
export declare const DescribeTransitGatewayRouteTableAnnouncementsResultFilterSensitiveLog: (
  obj: DescribeTransitGatewayRouteTableAnnouncementsResult
) => any;
export declare const DescribeTransitGatewayRouteTablesRequestFilterSensitiveLog: (
  obj: DescribeTransitGatewayRouteTablesRequest
) => any;
export declare const DescribeTransitGatewayRouteTablesResultFilterSensitiveLog: (
  obj: DescribeTransitGatewayRouteTablesResult
) => any;
export declare const DescribeTransitGatewaysRequestFilterSensitiveLog: (
  obj: DescribeTransitGatewaysRequest
) => any;
export declare const DescribeTransitGatewaysResultFilterSensitiveLog: (
  obj: DescribeTransitGatewaysResult
) => any;
export declare const DescribeTransitGatewayVpcAttachmentsRequestFilterSensitiveLog: (
  obj: DescribeTransitGatewayVpcAttachmentsRequest
) => any;
export declare const DescribeTransitGatewayVpcAttachmentsResultFilterSensitiveLog: (
  obj: DescribeTransitGatewayVpcAttachmentsResult
) => any;
export declare const DescribeTrunkInterfaceAssociationsRequestFilterSensitiveLog: (
  obj: DescribeTrunkInterfaceAssociationsRequest
) => any;
export declare const DescribeTrunkInterfaceAssociationsResultFilterSensitiveLog: (
  obj: DescribeTrunkInterfaceAssociationsResult
) => any;
export declare const DescribeVerifiedAccessEndpointsRequestFilterSensitiveLog: (
  obj: DescribeVerifiedAccessEndpointsRequest
) => any;
export declare const DescribeVerifiedAccessEndpointsResultFilterSensitiveLog: (
  obj: DescribeVerifiedAccessEndpointsResult
) => any;
export declare const DescribeVerifiedAccessGroupsRequestFilterSensitiveLog: (
  obj: DescribeVerifiedAccessGroupsRequest
) => any;
export declare const DescribeVerifiedAccessGroupsResultFilterSensitiveLog: (
  obj: DescribeVerifiedAccessGroupsResult
) => any;
export declare const DescribeVerifiedAccessInstanceLoggingConfigurationsRequestFilterSensitiveLog: (
  obj: DescribeVerifiedAccessInstanceLoggingConfigurationsRequest
) => any;
export declare const VerifiedAccessLogDeliveryStatusFilterSensitiveLog: (
  obj: VerifiedAccessLogDeliveryStatus
) => any;
export declare const VerifiedAccessLogCloudWatchLogsDestinationFilterSensitiveLog: (
  obj: VerifiedAccessLogCloudWatchLogsDestination
) => any;
export declare const VerifiedAccessLogKinesisDataFirehoseDestinationFilterSensitiveLog: (
  obj: VerifiedAccessLogKinesisDataFirehoseDestination
) => any;
export declare const VerifiedAccessLogS3DestinationFilterSensitiveLog: (
  obj: VerifiedAccessLogS3Destination
) => any;
export declare const VerifiedAccessLogsFilterSensitiveLog: (
  obj: VerifiedAccessLogs
) => any;
export declare const VerifiedAccessInstanceLoggingConfigurationFilterSensitiveLog: (
  obj: VerifiedAccessInstanceLoggingConfiguration
) => any;
export declare const DescribeVerifiedAccessInstanceLoggingConfigurationsResultFilterSensitiveLog: (
  obj: DescribeVerifiedAccessInstanceLoggingConfigurationsResult
) => any;
export declare const DescribeVerifiedAccessInstancesRequestFilterSensitiveLog: (
  obj: DescribeVerifiedAccessInstancesRequest
) => any;
export declare const DescribeVerifiedAccessInstancesResultFilterSensitiveLog: (
  obj: DescribeVerifiedAccessInstancesResult
) => any;
export declare const DescribeVerifiedAccessTrustProvidersRequestFilterSensitiveLog: (
  obj: DescribeVerifiedAccessTrustProvidersRequest
) => any;
export declare const DescribeVerifiedAccessTrustProvidersResultFilterSensitiveLog: (
  obj: DescribeVerifiedAccessTrustProvidersResult
) => any;
export declare const DescribeVolumeAttributeRequestFilterSensitiveLog: (
  obj: DescribeVolumeAttributeRequest
) => any;
export declare const DescribeVolumeAttributeResultFilterSensitiveLog: (
  obj: DescribeVolumeAttributeResult
) => any;
export declare const DescribeVolumesRequestFilterSensitiveLog: (
  obj: DescribeVolumesRequest
) => any;
export declare const DescribeVolumesResultFilterSensitiveLog: (
  obj: DescribeVolumesResult
) => any;
export declare const DescribeVolumesModificationsRequestFilterSensitiveLog: (
  obj: DescribeVolumesModificationsRequest
) => any;
export declare const VolumeModificationFilterSensitiveLog: (
  obj: VolumeModification
) => any;
export declare const DescribeVolumesModificationsResultFilterSensitiveLog: (
  obj: DescribeVolumesModificationsResult
) => any;
export declare const DescribeVolumeStatusRequestFilterSensitiveLog: (
  obj: DescribeVolumeStatusRequest
) => any;
export declare const VolumeStatusActionFilterSensitiveLog: (
  obj: VolumeStatusAction
) => any;
export declare const VolumeStatusAttachmentStatusFilterSensitiveLog: (
  obj: VolumeStatusAttachmentStatus
) => any;
export declare const VolumeStatusEventFilterSensitiveLog: (
  obj: VolumeStatusEvent
) => any;
export declare const VolumeStatusDetailsFilterSensitiveLog: (
  obj: VolumeStatusDetails
) => any;
export declare const VolumeStatusInfoFilterSensitiveLog: (
  obj: VolumeStatusInfo
) => any;
export declare const VolumeStatusItemFilterSensitiveLog: (
  obj: VolumeStatusItem
) => any;
export declare const DescribeVolumeStatusResultFilterSensitiveLog: (
  obj: DescribeVolumeStatusResult
) => any;
export declare const DescribeVpcAttributeRequestFilterSensitiveLog: (
  obj: DescribeVpcAttributeRequest
) => any;
export declare const DescribeVpcAttributeResultFilterSensitiveLog: (
  obj: DescribeVpcAttributeResult
) => any;
export declare const DescribeVpcClassicLinkRequestFilterSensitiveLog: (
  obj: DescribeVpcClassicLinkRequest
) => any;
export declare const VpcClassicLinkFilterSensitiveLog: (
  obj: VpcClassicLink
) => any;
export declare const DescribeVpcClassicLinkResultFilterSensitiveLog: (
  obj: DescribeVpcClassicLinkResult
) => any;
export declare const DescribeVpcClassicLinkDnsSupportRequestFilterSensitiveLog: (
  obj: DescribeVpcClassicLinkDnsSupportRequest
) => any;
export declare const ClassicLinkDnsSupportFilterSensitiveLog: (
  obj: ClassicLinkDnsSupport
) => any;
export declare const DescribeVpcClassicLinkDnsSupportResultFilterSensitiveLog: (
  obj: DescribeVpcClassicLinkDnsSupportResult
) => any;
export declare const DescribeVpcEndpointConnectionNotificationsRequestFilterSensitiveLog: (
  obj: DescribeVpcEndpointConnectionNotificationsRequest
) => any;
export declare const DescribeVpcEndpointConnectionNotificationsResultFilterSensitiveLog: (
  obj: DescribeVpcEndpointConnectionNotificationsResult
) => any;
export declare const DescribeVpcEndpointConnectionsRequestFilterSensitiveLog: (
  obj: DescribeVpcEndpointConnectionsRequest
) => any;
export declare const VpcEndpointConnectionFilterSensitiveLog: (
  obj: VpcEndpointConnection
) => any;
export declare const DescribeVpcEndpointConnectionsResultFilterSensitiveLog: (
  obj: DescribeVpcEndpointConnectionsResult
) => any;
export declare const DescribeVpcEndpointsRequestFilterSensitiveLog: (
  obj: DescribeVpcEndpointsRequest
) => any;
export declare const DescribeVpcEndpointsResultFilterSensitiveLog: (
  obj: DescribeVpcEndpointsResult
) => any;
export declare const DescribeVpcEndpointServiceConfigurationsRequestFilterSensitiveLog: (
  obj: DescribeVpcEndpointServiceConfigurationsRequest
) => any;
