import {
  _InstanceType,
  AccountAttribute,
  AccountAttributeName,
  ActiveInstance,
  Address,
  AddressAttribute,
  AddressAttributeName,
  AddressTransfer,
  AllocationState,
  AllowsMultipleInstanceTypes,
  AssociationStatus,
  AttachmentStatus,
  AutoPlacement,
  BundleTask,
  ByoipCidr,
  CapacityReservation,
  CapacityReservationFleetState,
  CarrierGateway,
  ClientVpnAuthenticationType,
  ClientVpnAuthorizationRuleStatus,
  ClientVpnEndpointStatus,
  ClientVpnRouteStatus,
  CurrencyCodeValues,
  FleetCapacityReservation,
  FleetCapacityReservationTenancy,
  FleetInstanceMatchCriteria,
  HostRecovery,
  IamInstanceProfile,
  IamInstanceProfileAssociation,
  InstanceEventWindow,
  Tag,
  TransitGatewayVpcAttachment,
  TransportProtocol,
  UnsuccessfulItem,
  VerifiedAccessInstance,
  VerifiedAccessTrustProvider,
} from "./models_0";
import {
  AttributeValue,
  BlockDeviceMapping,
  CapacityReservationPreference,
  CapacityReservationTargetResponse,
  CoipPool,
  CustomerGateway,
  DefaultTargetCapacityType,
  DestinationFileFormat,
  DhcpOptions,
  DiskImageFormat,
  EgressOnlyInternetGateway,
  ExportTask,
  FleetCapacityReservationUsageStrategy,
  FleetExcessCapacityTerminationPolicy,
  FleetLaunchTemplateOverrides,
  FleetLaunchTemplateSpecification,
  FleetOnDemandAllocationStrategy,
  FleetReplacementStrategy,
  FleetType,
  GroupIdentifier,
  HostnameType,
  InstanceIpv6Address,
  InstanceLifecycle,
  LaunchTemplateAndOverridesResponse,
  LogDestinationType,
  NetworkInterfaceStatus,
  Placement,
  PlatformValues,
  SpotAllocationStrategy,
  SpotInstanceInterruptionBehavior,
  StateReason,
  TargetCapacityUnitType,
  TrafficType,
} from "./models_1";
import {
  FleetStateCode,
  TransitGatewayRoute,
  TransitGatewayRouteTable,
  TransitGatewayRouteTableAnnouncement,
  VerifiedAccessEndpoint,
  VerifiedAccessGroup,
} from "./models_2";
export interface DeleteTransitGatewayRouteResult {
  Route?: TransitGatewayRoute;
}
export interface DeleteTransitGatewayRouteTableRequest {
  TransitGatewayRouteTableId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTransitGatewayRouteTableResult {
  TransitGatewayRouteTable?: TransitGatewayRouteTable;
}
export interface DeleteTransitGatewayRouteTableAnnouncementRequest {
  TransitGatewayRouteTableAnnouncementId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTransitGatewayRouteTableAnnouncementResult {
  TransitGatewayRouteTableAnnouncement?: TransitGatewayRouteTableAnnouncement;
}
export interface DeleteTransitGatewayVpcAttachmentRequest {
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTransitGatewayVpcAttachmentResult {
  TransitGatewayVpcAttachment?: TransitGatewayVpcAttachment;
}
export interface DeleteVerifiedAccessEndpointRequest {
  VerifiedAccessEndpointId: string | undefined;
  ClientToken?: string;
  DryRun?: boolean;
}
export interface DeleteVerifiedAccessEndpointResult {
  VerifiedAccessEndpoint?: VerifiedAccessEndpoint;
}
export interface DeleteVerifiedAccessGroupRequest {
  VerifiedAccessGroupId: string | undefined;
  ClientToken?: string;
  DryRun?: boolean;
}
export interface DeleteVerifiedAccessGroupResult {
  VerifiedAccessGroup?: VerifiedAccessGroup;
}
export interface DeleteVerifiedAccessInstanceRequest {
  VerifiedAccessInstanceId: string | undefined;
  DryRun?: boolean;
  ClientToken?: string;
}
export interface DeleteVerifiedAccessInstanceResult {
  VerifiedAccessInstance?: VerifiedAccessInstance;
}
export interface DeleteVerifiedAccessTrustProviderRequest {
  VerifiedAccessTrustProviderId: string | undefined;
  DryRun?: boolean;
  ClientToken?: string;
}
export interface DeleteVerifiedAccessTrustProviderResult {
  VerifiedAccessTrustProvider?: VerifiedAccessTrustProvider;
}
export interface DeleteVolumeRequest {
  VolumeId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteVpcRequest {
  VpcId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteVpcEndpointConnectionNotificationsRequest {
  DryRun?: boolean;
  ConnectionNotificationIds: string[] | undefined;
}
export interface DeleteVpcEndpointConnectionNotificationsResult {
  Unsuccessful?: UnsuccessfulItem[];
}
export interface DeleteVpcEndpointsRequest {
  DryRun?: boolean;
  VpcEndpointIds: string[] | undefined;
}
export interface DeleteVpcEndpointsResult {
  Unsuccessful?: UnsuccessfulItem[];
}
export interface DeleteVpcEndpointServiceConfigurationsRequest {
  DryRun?: boolean;
  ServiceIds: string[] | undefined;
}
export interface DeleteVpcEndpointServiceConfigurationsResult {
  Unsuccessful?: UnsuccessfulItem[];
}
export interface DeleteVpcPeeringConnectionRequest {
  DryRun?: boolean;
  VpcPeeringConnectionId: string | undefined;
}
export interface DeleteVpcPeeringConnectionResult {
  Return?: boolean;
}
export interface DeleteVpnConnectionRequest {
  VpnConnectionId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteVpnConnectionRouteRequest {
  DestinationCidrBlock: string | undefined;
  VpnConnectionId: string | undefined;
}
export interface DeleteVpnGatewayRequest {
  VpnGatewayId: string | undefined;
  DryRun?: boolean;
}
export interface DeprovisionByoipCidrRequest {
  Cidr: string | undefined;
  DryRun?: boolean;
}
export interface DeprovisionByoipCidrResult {
  ByoipCidr?: ByoipCidr;
}
export interface DeprovisionIpamPoolCidrRequest {
  DryRun?: boolean;
  IpamPoolId: string | undefined;
  Cidr?: string;
}
export declare enum IpamPoolCidrFailureCode {
  cidr_not_available = "cidr-not-available",
}
export interface IpamPoolCidrFailureReason {
  Code?: IpamPoolCidrFailureCode | string;
  Message?: string;
}
export declare enum IpamPoolCidrState {
  deprovisioned = "deprovisioned",
  failed_deprovision = "failed-deprovision",
  failed_import = "failed-import",
  failed_provision = "failed-provision",
  pending_deprovision = "pending-deprovision",
  pending_import = "pending-import",
  pending_provision = "pending-provision",
  provisioned = "provisioned",
}
export interface IpamPoolCidr {
  Cidr?: string;
  State?: IpamPoolCidrState | string;
  FailureReason?: IpamPoolCidrFailureReason;
}
export interface DeprovisionIpamPoolCidrResult {
  IpamPoolCidr?: IpamPoolCidr;
}
export interface DeprovisionPublicIpv4PoolCidrRequest {
  DryRun?: boolean;
  PoolId: string | undefined;
  Cidr: string | undefined;
}
export interface DeprovisionPublicIpv4PoolCidrResult {
  PoolId?: string;
  DeprovisionedAddresses?: string[];
}
export interface DeregisterImageRequest {
  ImageId: string | undefined;
  DryRun?: boolean;
}
export interface DeregisterInstanceTagAttributeRequest {
  IncludeAllTagsOfInstance?: boolean;
  InstanceTagKeys?: string[];
}
export interface DeregisterInstanceEventNotificationAttributesRequest {
  DryRun?: boolean;
  InstanceTagAttribute?: DeregisterInstanceTagAttributeRequest;
}
export interface InstanceTagNotificationAttribute {
  InstanceTagKeys?: string[];
  IncludeAllTagsOfInstance?: boolean;
}
export interface DeregisterInstanceEventNotificationAttributesResult {
  InstanceTagAttribute?: InstanceTagNotificationAttribute;
}
export interface DeregisterTransitGatewayMulticastGroupMembersRequest {
  TransitGatewayMulticastDomainId?: string;
  GroupIpAddress?: string;
  NetworkInterfaceIds?: string[];
  DryRun?: boolean;
}
export interface TransitGatewayMulticastDeregisteredGroupMembers {
  TransitGatewayMulticastDomainId?: string;
  DeregisteredNetworkInterfaceIds?: string[];
  GroupIpAddress?: string;
}
export interface DeregisterTransitGatewayMulticastGroupMembersResult {
  DeregisteredMulticastGroupMembers?: TransitGatewayMulticastDeregisteredGroupMembers;
}
export interface DeregisterTransitGatewayMulticastGroupSourcesRequest {
  TransitGatewayMulticastDomainId?: string;
  GroupIpAddress?: string;
  NetworkInterfaceIds?: string[];
  DryRun?: boolean;
}
export interface TransitGatewayMulticastDeregisteredGroupSources {
  TransitGatewayMulticastDomainId?: string;
  DeregisteredNetworkInterfaceIds?: string[];
  GroupIpAddress?: string;
}
export interface DeregisterTransitGatewayMulticastGroupSourcesResult {
  DeregisteredMulticastGroupSources?: TransitGatewayMulticastDeregisteredGroupSources;
}
export interface DescribeAccountAttributesRequest {
  AttributeNames?: (AccountAttributeName | string)[];
  DryRun?: boolean;
}
export interface DescribeAccountAttributesResult {
  AccountAttributes?: AccountAttribute[];
}
export interface Filter {
  Name?: string;
  Values?: string[];
}
export interface DescribeAddressesRequest {
  Filters?: Filter[];
  PublicIps?: string[];
  AllocationIds?: string[];
  DryRun?: boolean;
}
export interface DescribeAddressesResult {
  Addresses?: Address[];
}
export interface DescribeAddressesAttributeRequest {
  AllocationIds?: string[];
  Attribute?: AddressAttributeName | string;
  NextToken?: string;
  MaxResults?: number;
  DryRun?: boolean;
}
export interface DescribeAddressesAttributeResult {
  Addresses?: AddressAttribute[];
  NextToken?: string;
}
export interface DescribeAddressTransfersRequest {
  AllocationIds?: string[];
  NextToken?: string;
  MaxResults?: number;
  DryRun?: boolean;
}
export interface DescribeAddressTransfersResult {
  AddressTransfers?: AddressTransfer[];
  NextToken?: string;
}
export interface DescribeAggregateIdFormatRequest {
  DryRun?: boolean;
}
export interface IdFormat {
  Deadline?: Date;
  Resource?: string;
  UseLongIds?: boolean;
}
export interface DescribeAggregateIdFormatResult {
  UseLongIdsAggregated?: boolean;
  Statuses?: IdFormat[];
}
export interface DescribeAvailabilityZonesRequest {
  Filters?: Filter[];
  ZoneNames?: string[];
  ZoneIds?: string[];
  AllAvailabilityZones?: boolean;
  DryRun?: boolean;
}
export interface AvailabilityZoneMessage {
  Message?: string;
}
export declare enum AvailabilityZoneOptInStatus {
  not_opted_in = "not-opted-in",
  opt_in_not_required = "opt-in-not-required",
  opted_in = "opted-in",
}
export declare enum AvailabilityZoneState {
  available = "available",
  impaired = "impaired",
  information = "information",
  unavailable = "unavailable",
}
export interface AvailabilityZone {
  State?: AvailabilityZoneState | string;
  OptInStatus?: AvailabilityZoneOptInStatus | string;
  Messages?: AvailabilityZoneMessage[];
  RegionName?: string;
  ZoneName?: string;
  ZoneId?: string;
  GroupName?: string;
  NetworkBorderGroup?: string;
  ZoneType?: string;
  ParentZoneName?: string;
  ParentZoneId?: string;
}
export interface DescribeAvailabilityZonesResult {
  AvailabilityZones?: AvailabilityZone[];
}
export interface DescribeAwsNetworkPerformanceMetricSubscriptionsRequest {
  MaxResults?: number;
  NextToken?: string;
  Filters?: Filter[];
  DryRun?: boolean;
}
export declare enum MetricType {
  aggregate_latency = "aggregate-latency",
}
export declare enum PeriodType {
  fifteen_minutes = "fifteen-minutes",
  five_minutes = "five-minutes",
  one_day = "one-day",
  one_hour = "one-hour",
  one_week = "one-week",
  three_hours = "three-hours",
}
export declare enum StatisticType {
  p50 = "p50",
}
export interface Subscription {
  Source?: string;
  Destination?: string;
  Metric?: MetricType | string;
  Statistic?: StatisticType | string;
  Period?: PeriodType | string;
}
export interface DescribeAwsNetworkPerformanceMetricSubscriptionsResult {
  NextToken?: string;
  Subscriptions?: Subscription[];
}
export interface DescribeBundleTasksRequest {
  BundleIds?: string[];
  Filters?: Filter[];
  DryRun?: boolean;
}
export interface DescribeBundleTasksResult {
  BundleTasks?: BundleTask[];
}
export interface DescribeByoipCidrsRequest {
  DryRun?: boolean;
  MaxResults: number | undefined;
  NextToken?: string;
}
export interface DescribeByoipCidrsResult {
  ByoipCidrs?: ByoipCidr[];
  NextToken?: string;
}
export interface DescribeCapacityReservationFleetsRequest {
  CapacityReservationFleetIds?: string[];
  NextToken?: string;
  MaxResults?: number;
  Filters?: Filter[];
  DryRun?: boolean;
}
export interface CapacityReservationFleet {
  CapacityReservationFleetId?: string;
  CapacityReservationFleetArn?: string;
  State?: CapacityReservationFleetState | string;
  TotalTargetCapacity?: number;
  TotalFulfilledCapacity?: number;
  Tenancy?: FleetCapacityReservationTenancy | string;
  EndDate?: Date;
  CreateTime?: Date;
  InstanceMatchCriteria?: FleetInstanceMatchCriteria | string;
  AllocationStrategy?: string;
  InstanceTypeSpecifications?: FleetCapacityReservation[];
  Tags?: Tag[];
}
export interface DescribeCapacityReservationFleetsResult {
  CapacityReservationFleets?: CapacityReservationFleet[];
  NextToken?: string;
}
export interface DescribeCapacityReservationsRequest {
  CapacityReservationIds?: string[];
  NextToken?: string;
  MaxResults?: number;
  Filters?: Filter[];
  DryRun?: boolean;
}
export interface DescribeCapacityReservationsResult {
  NextToken?: string;
  CapacityReservations?: CapacityReservation[];
}
export interface DescribeCarrierGatewaysRequest {
  CarrierGatewayIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeCarrierGatewaysResult {
  CarrierGateways?: CarrierGateway[];
  NextToken?: string;
}
export interface DescribeClassicLinkInstancesRequest {
  Filters?: Filter[];
  DryRun?: boolean;
  InstanceIds?: string[];
  MaxResults?: number;
  NextToken?: string;
}
export interface ClassicLinkInstance {
  Groups?: GroupIdentifier[];
  InstanceId?: string;
  Tags?: Tag[];
  VpcId?: string;
}
export interface DescribeClassicLinkInstancesResult {
  Instances?: ClassicLinkInstance[];
  NextToken?: string;
}
export interface DescribeClientVpnAuthorizationRulesRequest {
  ClientVpnEndpointId: string | undefined;
  DryRun?: boolean;
  NextToken?: string;
  Filters?: Filter[];
  MaxResults?: number;
}
export interface AuthorizationRule {
  ClientVpnEndpointId?: string;
  Description?: string;
  GroupId?: string;
  AccessAll?: boolean;
  DestinationCidr?: string;
  Status?: ClientVpnAuthorizationRuleStatus;
}
export interface DescribeClientVpnAuthorizationRulesResult {
  AuthorizationRules?: AuthorizationRule[];
  NextToken?: string;
}
export interface DescribeClientVpnConnectionsRequest {
  ClientVpnEndpointId: string | undefined;
  Filters?: Filter[];
  NextToken?: string;
  MaxResults?: number;
  DryRun?: boolean;
}
export declare enum ClientVpnConnectionStatusCode {
  active = "active",
  failed_to_terminate = "failed-to-terminate",
  terminated = "terminated",
  terminating = "terminating",
}
export interface ClientVpnConnectionStatus {
  Code?: ClientVpnConnectionStatusCode | string;
  Message?: string;
}
export interface ClientVpnConnection {
  ClientVpnEndpointId?: string;
  Timestamp?: string;
  ConnectionId?: string;
  Username?: string;
  ConnectionEstablishedTime?: string;
  IngressBytes?: string;
  EgressBytes?: string;
  IngressPackets?: string;
  EgressPackets?: string;
  ClientIp?: string;
  CommonName?: string;
  Status?: ClientVpnConnectionStatus;
  ConnectionEndTime?: string;
  PostureComplianceStatuses?: string[];
}
export interface DescribeClientVpnConnectionsResult {
  Connections?: ClientVpnConnection[];
  NextToken?: string;
}
export interface DescribeClientVpnEndpointsRequest {
  ClientVpnEndpointIds?: string[];
  MaxResults?: number;
  NextToken?: string;
  Filters?: Filter[];
  DryRun?: boolean;
}
export declare enum AssociatedNetworkType {
  vpc = "vpc",
}
export interface AssociatedTargetNetwork {
  NetworkId?: string;
  NetworkType?: AssociatedNetworkType | string;
}
export interface DirectoryServiceAuthentication {
  DirectoryId?: string;
}
export interface FederatedAuthentication {
  SamlProviderArn?: string;
  SelfServiceSamlProviderArn?: string;
}
export interface CertificateAuthentication {
  ClientRootCertificateChain?: string;
}
export interface ClientVpnAuthentication {
  Type?: ClientVpnAuthenticationType | string;
  ActiveDirectory?: DirectoryServiceAuthentication;
  MutualAuthentication?: CertificateAuthentication;
  FederatedAuthentication?: FederatedAuthentication;
}
export declare enum ClientVpnEndpointAttributeStatusCode {
  applied = "applied",
  applying = "applying",
}
export interface ClientVpnEndpointAttributeStatus {
  Code?: ClientVpnEndpointAttributeStatusCode | string;
  Message?: string;
}
export interface ClientConnectResponseOptions {
  Enabled?: boolean;
  LambdaFunctionArn?: string;
  Status?: ClientVpnEndpointAttributeStatus;
}
export interface ClientLoginBannerResponseOptions {
  Enabled?: boolean;
  BannerText?: string;
}
export interface ConnectionLogResponseOptions {
  Enabled?: boolean;
  CloudwatchLogGroup?: string;
  CloudwatchLogStream?: string;
}
export declare enum VpnProtocol {
  openvpn = "openvpn",
}
export interface ClientVpnEndpoint {
  ClientVpnEndpointId?: string;
  Description?: string;
  Status?: ClientVpnEndpointStatus;
  CreationTime?: string;
  DeletionTime?: string;
  DnsName?: string;
  ClientCidrBlock?: string;
  DnsServers?: string[];
  SplitTunnel?: boolean;
  VpnProtocol?: VpnProtocol | string;
  TransportProtocol?: TransportProtocol | string;
  VpnPort?: number;
  AssociatedTargetNetworks?: AssociatedTargetNetwork[];
  ServerCertificateArn?: string;
  AuthenticationOptions?: ClientVpnAuthentication[];
  ConnectionLogOptions?: ConnectionLogResponseOptions;
  Tags?: Tag[];
  SecurityGroupIds?: string[];
  VpcId?: string;
  SelfServicePortalUrl?: string;
  ClientConnectOptions?: ClientConnectResponseOptions;
  SessionTimeoutHours?: number;
  ClientLoginBannerOptions?: ClientLoginBannerResponseOptions;
}
export interface DescribeClientVpnEndpointsResult {
  ClientVpnEndpoints?: ClientVpnEndpoint[];
  NextToken?: string;
}
export interface DescribeClientVpnRoutesRequest {
  ClientVpnEndpointId: string | undefined;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface ClientVpnRoute {
  ClientVpnEndpointId?: string;
  DestinationCidr?: string;
  TargetSubnet?: string;
  Type?: string;
  Origin?: string;
  Status?: ClientVpnRouteStatus;
  Description?: string;
}
export interface DescribeClientVpnRoutesResult {
  Routes?: ClientVpnRoute[];
  NextToken?: string;
}
export interface DescribeClientVpnTargetNetworksRequest {
  ClientVpnEndpointId: string | undefined;
  AssociationIds?: string[];
  MaxResults?: number;
  NextToken?: string;
  Filters?: Filter[];
  DryRun?: boolean;
}
export interface TargetNetwork {
  AssociationId?: string;
  VpcId?: string;
  TargetNetworkId?: string;
  ClientVpnEndpointId?: string;
  Status?: AssociationStatus;
  SecurityGroups?: string[];
}
export interface DescribeClientVpnTargetNetworksResult {
  ClientVpnTargetNetworks?: TargetNetwork[];
  NextToken?: string;
}
export interface DescribeCoipPoolsRequest {
  PoolIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeCoipPoolsResult {
  CoipPools?: CoipPool[];
  NextToken?: string;
}
export interface DescribeConversionTasksRequest {
  ConversionTaskIds?: string[];
  DryRun?: boolean;
}
export interface DiskImageDescription {
  Checksum?: string;
  Format?: DiskImageFormat | string;
  ImportManifestUrl?: string;
  Size?: number;
}
export interface DiskImageVolumeDescription {
  Id?: string;
  Size?: number;
}
export interface ImportInstanceVolumeDetailItem {
  AvailabilityZone?: string;
  BytesConverted?: number;
  Description?: string;
  Image?: DiskImageDescription;
  Status?: string;
  StatusMessage?: string;
  Volume?: DiskImageVolumeDescription;
}
export interface ImportInstanceTaskDetails {
  Description?: string;
  InstanceId?: string;
  Platform?: PlatformValues | string;
  Volumes?: ImportInstanceVolumeDetailItem[];
}
export interface ImportVolumeTaskDetails {
  AvailabilityZone?: string;
  BytesConverted?: number;
  Description?: string;
  Image?: DiskImageDescription;
  Volume?: DiskImageVolumeDescription;
}
export declare enum ConversionTaskState {
  active = "active",
  cancelled = "cancelled",
  cancelling = "cancelling",
  completed = "completed",
}
export interface ConversionTask {
  ConversionTaskId?: string;
  ExpirationTime?: string;
  ImportInstance?: ImportInstanceTaskDetails;
  ImportVolume?: ImportVolumeTaskDetails;
  State?: ConversionTaskState | string;
  StatusMessage?: string;
  Tags?: Tag[];
}
export interface DescribeConversionTasksResult {
  ConversionTasks?: ConversionTask[];
}
export interface DescribeCustomerGatewaysRequest {
  CustomerGatewayIds?: string[];
  Filters?: Filter[];
  DryRun?: boolean;
}
export interface DescribeCustomerGatewaysResult {
  CustomerGateways?: CustomerGateway[];
}
export interface DescribeDhcpOptionsRequest {
  DhcpOptionsIds?: string[];
  Filters?: Filter[];
  DryRun?: boolean;
  NextToken?: string;
  MaxResults?: number;
}
export interface DescribeDhcpOptionsResult {
  DhcpOptions?: DhcpOptions[];
  NextToken?: string;
}
export interface DescribeEgressOnlyInternetGatewaysRequest {
  DryRun?: boolean;
  EgressOnlyInternetGatewayIds?: string[];
  MaxResults?: number;
  NextToken?: string;
  Filters?: Filter[];
}
export interface DescribeEgressOnlyInternetGatewaysResult {
  EgressOnlyInternetGateways?: EgressOnlyInternetGateway[];
  NextToken?: string;
}
export interface DescribeElasticGpusRequest {
  ElasticGpuIds?: string[];
  DryRun?: boolean;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export declare enum ElasticGpuStatus {
  Impaired = "IMPAIRED",
  Ok = "OK",
}
export interface ElasticGpuHealth {
  Status?: ElasticGpuStatus | string;
}
export declare enum ElasticGpuState {
  Attached = "ATTACHED",
}
export interface ElasticGpus {
  ElasticGpuId?: string;
  AvailabilityZone?: string;
  ElasticGpuType?: string;
  ElasticGpuHealth?: ElasticGpuHealth;
  ElasticGpuState?: ElasticGpuState | string;
  InstanceId?: string;
  Tags?: Tag[];
}
export interface DescribeElasticGpusResult {
  ElasticGpuSet?: ElasticGpus[];
  MaxResults?: number;
  NextToken?: string;
}
export interface DescribeExportImageTasksRequest {
  DryRun?: boolean;
  Filters?: Filter[];
  ExportImageTaskIds?: string[];
  MaxResults?: number;
  NextToken?: string;
}
export interface ExportTaskS3Location {
  S3Bucket?: string;
  S3Prefix?: string;
}
export interface ExportImageTask {
  Description?: string;
  ExportImageTaskId?: string;
  ImageId?: string;
  Progress?: string;
  S3ExportLocation?: ExportTaskS3Location;
  Status?: string;
  StatusMessage?: string;
  Tags?: Tag[];
}
export interface DescribeExportImageTasksResult {
  ExportImageTasks?: ExportImageTask[];
  NextToken?: string;
}
export interface DescribeExportTasksRequest {
  ExportTaskIds?: string[];
  Filters?: Filter[];
}
export interface DescribeExportTasksResult {
  ExportTasks?: ExportTask[];
}
export interface DescribeFastLaunchImagesRequest {
  ImageIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface FastLaunchLaunchTemplateSpecificationResponse {
  LaunchTemplateId?: string;
  LaunchTemplateName?: string;
  Version?: string;
}
export declare enum FastLaunchResourceType {
  SNAPSHOT = "snapshot",
}
export interface FastLaunchSnapshotConfigurationResponse {
  TargetResourceCount?: number;
}
export declare enum FastLaunchStateCode {
  disabling = "disabling",
  disabling_failed = "disabling-failed",
  enabled = "enabled",
  enabled_failed = "enabled-failed",
  enabling = "enabling",
  enabling_failed = "enabling-failed",
}
export interface DescribeFastLaunchImagesSuccessItem {
  ImageId?: string;
  ResourceType?: FastLaunchResourceType | string;
  SnapshotConfiguration?: FastLaunchSnapshotConfigurationResponse;
  LaunchTemplate?: FastLaunchLaunchTemplateSpecificationResponse;
  MaxParallelLaunches?: number;
  OwnerId?: string;
  State?: FastLaunchStateCode | string;
  StateTransitionReason?: string;
  StateTransitionTime?: Date;
}
export interface DescribeFastLaunchImagesResult {
  FastLaunchImages?: DescribeFastLaunchImagesSuccessItem[];
  NextToken?: string;
}
export interface DescribeFastSnapshotRestoresRequest {
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export declare enum FastSnapshotRestoreStateCode {
  disabled = "disabled",
  disabling = "disabling",
  enabled = "enabled",
  enabling = "enabling",
  optimizing = "optimizing",
}
export interface DescribeFastSnapshotRestoreSuccessItem {
  SnapshotId?: string;
  AvailabilityZone?: string;
  State?: FastSnapshotRestoreStateCode | string;
  StateTransitionReason?: string;
  OwnerId?: string;
  OwnerAlias?: string;
  EnablingTime?: Date;
  OptimizingTime?: Date;
  EnabledTime?: Date;
  DisablingTime?: Date;
  DisabledTime?: Date;
}
export interface DescribeFastSnapshotRestoresResult {
  FastSnapshotRestores?: DescribeFastSnapshotRestoreSuccessItem[];
  NextToken?: string;
}
export declare enum FleetEventType {
  FLEET_CHANGE = "fleet-change",
  INSTANCE_CHANGE = "instance-change",
  SERVICE_ERROR = "service-error",
}
export interface DescribeFleetHistoryRequest {
  DryRun?: boolean;
  EventType?: FleetEventType | string;
  MaxResults?: number;
  NextToken?: string;
  FleetId: string | undefined;
  StartTime: Date | undefined;
}
export interface EventInformation {
  EventDescription?: string;
  EventSubType?: string;
  InstanceId?: string;
}
export interface HistoryRecordEntry {
  EventInformation?: EventInformation;
  EventType?: FleetEventType | string;
  Timestamp?: Date;
}
export interface DescribeFleetHistoryResult {
  HistoryRecords?: HistoryRecordEntry[];
  LastEvaluatedTime?: Date;
  NextToken?: string;
  FleetId?: string;
  StartTime?: Date;
}
export interface DescribeFleetInstancesRequest {
  DryRun?: boolean;
  MaxResults?: number;
  NextToken?: string;
  FleetId: string | undefined;
  Filters?: Filter[];
}
export interface DescribeFleetInstancesResult {
  ActiveInstances?: ActiveInstance[];
  NextToken?: string;
  FleetId?: string;
}
export interface DescribeFleetsRequest {
  DryRun?: boolean;
  MaxResults?: number;
  NextToken?: string;
  FleetIds?: string[];
  Filters?: Filter[];
}
export declare enum FleetActivityStatus {
  ERROR = "error",
  FULFILLED = "fulfilled",
  PENDING_FULFILLMENT = "pending_fulfillment",
  PENDING_TERMINATION = "pending_termination",
}
export interface DescribeFleetError {
  LaunchTemplateAndOverrides?: LaunchTemplateAndOverridesResponse;
  Lifecycle?: InstanceLifecycle | string;
  ErrorCode?: string;
  ErrorMessage?: string;
}
export interface DescribeFleetsInstances {
  LaunchTemplateAndOverrides?: LaunchTemplateAndOverridesResponse;
  Lifecycle?: InstanceLifecycle | string;
  InstanceIds?: string[];
  InstanceType?: _InstanceType | string;
  Platform?: PlatformValues | string;
}
export interface FleetLaunchTemplateConfig {
  LaunchTemplateSpecification?: FleetLaunchTemplateSpecification;
  Overrides?: FleetLaunchTemplateOverrides[];
}
export interface CapacityReservationOptions {
  UsageStrategy?: FleetCapacityReservationUsageStrategy | string;
}
export interface OnDemandOptions {
  AllocationStrategy?: FleetOnDemandAllocationStrategy | string;
  CapacityReservationOptions?: CapacityReservationOptions;
  SingleInstanceType?: boolean;
  SingleAvailabilityZone?: boolean;
  MinTargetCapacity?: number;
  MaxTotalPrice?: string;
}
export interface FleetSpotCapacityRebalance {
  ReplacementStrategy?: FleetReplacementStrategy | string;
  TerminationDelay?: number;
}
export interface FleetSpotMaintenanceStrategies {
  CapacityRebalance?: FleetSpotCapacityRebalance;
}
export interface SpotOptions {
  AllocationStrategy?: SpotAllocationStrategy | string;
  MaintenanceStrategies?: FleetSpotMaintenanceStrategies;
  InstanceInterruptionBehavior?: SpotInstanceInterruptionBehavior | string;
  InstancePoolsToUseCount?: number;
  SingleInstanceType?: boolean;
  SingleAvailabilityZone?: boolean;
  MinTargetCapacity?: number;
  MaxTotalPrice?: string;
}
export interface TargetCapacitySpecification {
  TotalTargetCapacity?: number;
  OnDemandTargetCapacity?: number;
  SpotTargetCapacity?: number;
  DefaultTargetCapacityType?: DefaultTargetCapacityType | string;
  TargetCapacityUnitType?: TargetCapacityUnitType | string;
}
export interface FleetData {
  ActivityStatus?: FleetActivityStatus | string;
  CreateTime?: Date;
  FleetId?: string;
  FleetState?: FleetStateCode | string;
  ClientToken?: string;
  ExcessCapacityTerminationPolicy?:
    | FleetExcessCapacityTerminationPolicy
    | string;
  FulfilledCapacity?: number;
  FulfilledOnDemandCapacity?: number;
  LaunchTemplateConfigs?: FleetLaunchTemplateConfig[];
  TargetCapacitySpecification?: TargetCapacitySpecification;
  TerminateInstancesWithExpiration?: boolean;
  Type?: FleetType | string;
  ValidFrom?: Date;
  ValidUntil?: Date;
  ReplaceUnhealthyInstances?: boolean;
  SpotOptions?: SpotOptions;
  OnDemandOptions?: OnDemandOptions;
  Tags?: Tag[];
  Errors?: DescribeFleetError[];
  Instances?: DescribeFleetsInstances[];
  Context?: string;
}
export interface DescribeFleetsResult {
  NextToken?: string;
  Fleets?: FleetData[];
}
export interface DescribeFlowLogsRequest {
  DryRun?: boolean;
  Filter?: Filter[];
  FlowLogIds?: string[];
  MaxResults?: number;
  NextToken?: string;
}
export interface DestinationOptionsResponse {
  FileFormat?: DestinationFileFormat | string;
  HiveCompatiblePartitions?: boolean;
  PerHourPartition?: boolean;
}
export interface FlowLog {
  CreationTime?: Date;
  DeliverLogsErrorMessage?: string;
  DeliverLogsPermissionArn?: string;
  DeliverCrossAccountRole?: string;
  DeliverLogsStatus?: string;
  FlowLogId?: string;
  FlowLogStatus?: string;
  LogGroupName?: string;
  ResourceId?: string;
  TrafficType?: TrafficType | string;
  LogDestinationType?: LogDestinationType | string;
  LogDestination?: string;
  LogFormat?: string;
  Tags?: Tag[];
  MaxAggregationInterval?: number;
  DestinationOptions?: DestinationOptionsResponse;
}
export interface DescribeFlowLogsResult {
  FlowLogs?: FlowLog[];
  NextToken?: string;
}
export declare enum FpgaImageAttributeName {
  description = "description",
  loadPermission = "loadPermission",
  name = "name",
  productCodes = "productCodes",
}
export interface DescribeFpgaImageAttributeRequest {
  DryRun?: boolean;
  FpgaImageId: string | undefined;
  Attribute: FpgaImageAttributeName | string | undefined;
}
export declare enum PermissionGroup {
  all = "all",
}
export interface LoadPermission {
  UserId?: string;
  Group?: PermissionGroup | string;
}
export declare enum ProductCodeValues {
  devpay = "devpay",
  marketplace = "marketplace",
}
export interface ProductCode {
  ProductCodeId?: string;
  ProductCodeType?: ProductCodeValues | string;
}
export interface FpgaImageAttribute {
  FpgaImageId?: string;
  Name?: string;
  Description?: string;
  LoadPermissions?: LoadPermission[];
  ProductCodes?: ProductCode[];
}
export interface DescribeFpgaImageAttributeResult {
  FpgaImageAttribute?: FpgaImageAttribute;
}
export interface DescribeFpgaImagesRequest {
  DryRun?: boolean;
  FpgaImageIds?: string[];
  Owners?: string[];
  Filters?: Filter[];
  NextToken?: string;
  MaxResults?: number;
}
export interface PciId {
  DeviceId?: string;
  VendorId?: string;
  SubsystemId?: string;
  SubsystemVendorId?: string;
}
export declare enum FpgaImageStateCode {
  available = "available",
  failed = "failed",
  pending = "pending",
  unavailable = "unavailable",
}
export interface FpgaImageState {
  Code?: FpgaImageStateCode | string;
  Message?: string;
}
export interface FpgaImage {
  FpgaImageId?: string;
  FpgaImageGlobalId?: string;
  Name?: string;
  Description?: string;
  ShellVersion?: string;
  PciId?: PciId;
  State?: FpgaImageState;
  CreateTime?: Date;
  UpdateTime?: Date;
  OwnerId?: string;
  OwnerAlias?: string;
  ProductCodes?: ProductCode[];
  Tags?: Tag[];
  Public?: boolean;
  DataRetentionSupport?: boolean;
  InstanceTypes?: string[];
}
export interface DescribeFpgaImagesResult {
  FpgaImages?: FpgaImage[];
  NextToken?: string;
}
export interface DescribeHostReservationOfferingsRequest {
  Filter?: Filter[];
  MaxDuration?: number;
  MaxResults?: number;
  MinDuration?: number;
  NextToken?: string;
  OfferingId?: string;
}
export declare enum PaymentOption {
  ALL_UPFRONT = "AllUpfront",
  NO_UPFRONT = "NoUpfront",
  PARTIAL_UPFRONT = "PartialUpfront",
}
export interface HostOffering {
  CurrencyCode?: CurrencyCodeValues | string;
  Duration?: number;
  HourlyPrice?: string;
  InstanceFamily?: string;
  OfferingId?: string;
  PaymentOption?: PaymentOption | string;
  UpfrontPrice?: string;
}
export interface DescribeHostReservationOfferingsResult {
  NextToken?: string;
  OfferingSet?: HostOffering[];
}
export interface DescribeHostReservationsRequest {
  Filter?: Filter[];
  HostReservationIdSet?: string[];
  MaxResults?: number;
  NextToken?: string;
}
export declare enum ReservationState {
  ACTIVE = "active",
  PAYMENT_FAILED = "payment-failed",
  PAYMENT_PENDING = "payment-pending",
  RETIRED = "retired",
}
export interface HostReservation {
  Count?: number;
  CurrencyCode?: CurrencyCodeValues | string;
  Duration?: number;
  End?: Date;
  HostIdSet?: string[];
  HostReservationId?: string;
  HourlyPrice?: string;
  InstanceFamily?: string;
  OfferingId?: string;
  PaymentOption?: PaymentOption | string;
  Start?: Date;
  State?: ReservationState | string;
  UpfrontPrice?: string;
  Tags?: Tag[];
}
export interface DescribeHostReservationsResult {
  HostReservationSet?: HostReservation[];
  NextToken?: string;
}
export interface DescribeHostsRequest {
  Filter?: Filter[];
  HostIds?: string[];
  MaxResults?: number;
  NextToken?: string;
}
export interface InstanceCapacity {
  AvailableCapacity?: number;
  InstanceType?: string;
  TotalCapacity?: number;
}
export interface AvailableCapacity {
  AvailableInstanceCapacity?: InstanceCapacity[];
  AvailableVCpus?: number;
}
export interface HostProperties {
  Cores?: number;
  InstanceType?: string;
  InstanceFamily?: string;
  Sockets?: number;
  TotalVCpus?: number;
}
export interface HostInstance {
  InstanceId?: string;
  InstanceType?: string;
  OwnerId?: string;
}
export interface Host {
  AutoPlacement?: AutoPlacement | string;
  AvailabilityZone?: string;
  AvailableCapacity?: AvailableCapacity;
  ClientToken?: string;
  HostId?: string;
  HostProperties?: HostProperties;
  HostReservationId?: string;
  Instances?: HostInstance[];
  State?: AllocationState | string;
  AllocationTime?: Date;
  ReleaseTime?: Date;
  Tags?: Tag[];
  HostRecovery?: HostRecovery | string;
  AllowsMultipleInstanceTypes?: AllowsMultipleInstanceTypes | string;
  OwnerId?: string;
  AvailabilityZoneId?: string;
  MemberOfServiceLinkedResourceGroup?: boolean;
  OutpostArn?: string;
}
export interface DescribeHostsResult {
  Hosts?: Host[];
  NextToken?: string;
}
export interface DescribeIamInstanceProfileAssociationsRequest {
  AssociationIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface DescribeIamInstanceProfileAssociationsResult {
  IamInstanceProfileAssociations?: IamInstanceProfileAssociation[];
  NextToken?: string;
}
export interface DescribeIdentityIdFormatRequest {
  PrincipalArn: string | undefined;
  Resource?: string;
}
export interface DescribeIdentityIdFormatResult {
  Statuses?: IdFormat[];
}
export interface DescribeIdFormatRequest {
  Resource?: string;
}
export interface DescribeIdFormatResult {
  Statuses?: IdFormat[];
}
export declare enum ImageAttributeName {
  blockDeviceMapping = "blockDeviceMapping",
  bootMode = "bootMode",
  description = "description",
  imdsSupport = "imdsSupport",
  kernel = "kernel",
  lastLaunchedTime = "lastLaunchedTime",
  launchPermission = "launchPermission",
  productCodes = "productCodes",
  ramdisk = "ramdisk",
  sriovNetSupport = "sriovNetSupport",
  tpmSupport = "tpmSupport",
  uefiData = "uefiData",
}
export interface DescribeImageAttributeRequest {
  Attribute: ImageAttributeName | string | undefined;
  ImageId: string | undefined;
  DryRun?: boolean;
}
export interface LaunchPermission {
  Group?: PermissionGroup | string;
  UserId?: string;
  OrganizationArn?: string;
  OrganizationalUnitArn?: string;
}
export interface ImageAttribute {
  BlockDeviceMappings?: BlockDeviceMapping[];
  ImageId?: string;
  LaunchPermissions?: LaunchPermission[];
  ProductCodes?: ProductCode[];
  Description?: AttributeValue;
  KernelId?: AttributeValue;
  RamdiskId?: AttributeValue;
  SriovNetSupport?: AttributeValue;
  BootMode?: AttributeValue;
  TpmSupport?: AttributeValue;
  UefiData?: AttributeValue;
  LastLaunchedTime?: AttributeValue;
  ImdsSupport?: AttributeValue;
}
export interface DescribeImagesRequest {
  ExecutableUsers?: string[];
  Filters?: Filter[];
  ImageIds?: string[];
  Owners?: string[];
  IncludeDeprecated?: boolean;
  DryRun?: boolean;
  MaxResults?: number;
  NextToken?: string;
}
export declare enum ArchitectureValues {
  arm64 = "arm64",
  arm64_mac = "arm64_mac",
  i386 = "i386",
  x86_64 = "x86_64",
  x86_64_mac = "x86_64_mac",
}
export declare enum BootModeValues {
  legacy_bios = "legacy-bios",
  uefi = "uefi",
}
export declare enum HypervisorType {
  ovm = "ovm",
  xen = "xen",
}
export declare enum ImageTypeValues {
  kernel = "kernel",
  machine = "machine",
  ramdisk = "ramdisk",
}
export declare enum ImdsSupportValues {
  v2_0 = "v2.0",
}
export declare enum DeviceType {
  ebs = "ebs",
  instance_store = "instance-store",
}
export declare enum ImageState {
  available = "available",
  deregistered = "deregistered",
  error = "error",
  failed = "failed",
  invalid = "invalid",
  pending = "pending",
  transient = "transient",
}
export declare enum TpmSupportValues {
  v2_0 = "v2.0",
}
export declare enum VirtualizationType {
  hvm = "hvm",
  paravirtual = "paravirtual",
}
export interface Image {
  Architecture?: ArchitectureValues | string;
  CreationDate?: string;
  ImageId?: string;
  ImageLocation?: string;
  ImageType?: ImageTypeValues | string;
  Public?: boolean;
  KernelId?: string;
  OwnerId?: string;
  Platform?: PlatformValues | string;
  PlatformDetails?: string;
  UsageOperation?: string;
  ProductCodes?: ProductCode[];
  RamdiskId?: string;
  State?: ImageState | string;
  BlockDeviceMappings?: BlockDeviceMapping[];
  Description?: string;
  EnaSupport?: boolean;
  Hypervisor?: HypervisorType | string;
  ImageOwnerAlias?: string;
  Name?: string;
  RootDeviceName?: string;
  RootDeviceType?: DeviceType | string;
  SriovNetSupport?: string;
  StateReason?: StateReason;
  Tags?: Tag[];
  VirtualizationType?: VirtualizationType | string;
  BootMode?: BootModeValues | string;
  TpmSupport?: TpmSupportValues | string;
  DeprecationTime?: string;
  ImdsSupport?: ImdsSupportValues | string;
}
export interface DescribeImagesResult {
  Images?: Image[];
  NextToken?: string;
}
export interface DescribeImportImageTasksRequest {
  DryRun?: boolean;
  Filters?: Filter[];
  ImportTaskIds?: string[];
  MaxResults?: number;
  NextToken?: string;
}
export interface ImportImageLicenseConfigurationResponse {
  LicenseConfigurationArn?: string;
}
export interface UserBucketDetails {
  S3Bucket?: string;
  S3Key?: string;
}
export interface SnapshotDetail {
  Description?: string;
  DeviceName?: string;
  DiskImageSize?: number;
  Format?: string;
  Progress?: string;
  SnapshotId?: string;
  Status?: string;
  StatusMessage?: string;
  Url?: string;
  UserBucket?: UserBucketDetails;
}
export interface ImportImageTask {
  Architecture?: string;
  Description?: string;
  Encrypted?: boolean;
  Hypervisor?: string;
  ImageId?: string;
  ImportTaskId?: string;
  KmsKeyId?: string;
  LicenseType?: string;
  Platform?: string;
  Progress?: string;
  SnapshotDetails?: SnapshotDetail[];
  Status?: string;
  StatusMessage?: string;
  Tags?: Tag[];
  LicenseSpecifications?: ImportImageLicenseConfigurationResponse[];
  UsageOperation?: string;
  BootMode?: BootModeValues | string;
}
export interface DescribeImportImageTasksResult {
  ImportImageTasks?: ImportImageTask[];
  NextToken?: string;
}
export interface DescribeImportSnapshotTasksRequest {
  DryRun?: boolean;
  Filters?: Filter[];
  ImportTaskIds?: string[];
  MaxResults?: number;
  NextToken?: string;
}
export interface SnapshotTaskDetail {
  Description?: string;
  DiskImageSize?: number;
  Encrypted?: boolean;
  Format?: string;
  KmsKeyId?: string;
  Progress?: string;
  SnapshotId?: string;
  Status?: string;
  StatusMessage?: string;
  Url?: string;
  UserBucket?: UserBucketDetails;
}
export interface ImportSnapshotTask {
  Description?: string;
  ImportTaskId?: string;
  SnapshotTaskDetail?: SnapshotTaskDetail;
  Tags?: Tag[];
}
export interface DescribeImportSnapshotTasksResult {
  ImportSnapshotTasks?: ImportSnapshotTask[];
  NextToken?: string;
}
export declare enum InstanceAttributeName {
  blockDeviceMapping = "blockDeviceMapping",
  disableApiStop = "disableApiStop",
  disableApiTermination = "disableApiTermination",
  ebsOptimized = "ebsOptimized",
  enaSupport = "enaSupport",
  enclaveOptions = "enclaveOptions",
  groupSet = "groupSet",
  instanceInitiatedShutdownBehavior = "instanceInitiatedShutdownBehavior",
  instanceType = "instanceType",
  kernel = "kernel",
  productCodes = "productCodes",
  ramdisk = "ramdisk",
  rootDeviceName = "rootDeviceName",
  sourceDestCheck = "sourceDestCheck",
  sriovNetSupport = "sriovNetSupport",
  userData = "userData",
}
export interface DescribeInstanceAttributeRequest {
  Attribute: InstanceAttributeName | string | undefined;
  DryRun?: boolean;
  InstanceId: string | undefined;
}
export interface EbsInstanceBlockDevice {
  AttachTime?: Date;
  DeleteOnTermination?: boolean;
  Status?: AttachmentStatus | string;
  VolumeId?: string;
}
export interface InstanceBlockDeviceMapping {
  DeviceName?: string;
  Ebs?: EbsInstanceBlockDevice;
}
export interface AttributeBooleanValue {
  Value?: boolean;
}
export interface EnclaveOptions {
  Enabled?: boolean;
}
export interface InstanceAttribute {
  Groups?: GroupIdentifier[];
  BlockDeviceMappings?: InstanceBlockDeviceMapping[];
  DisableApiTermination?: AttributeBooleanValue;
  EnaSupport?: AttributeBooleanValue;
  EnclaveOptions?: EnclaveOptions;
  EbsOptimized?: AttributeBooleanValue;
  InstanceId?: string;
  InstanceInitiatedShutdownBehavior?: AttributeValue;
  InstanceType?: AttributeValue;
  KernelId?: AttributeValue;
  ProductCodes?: ProductCode[];
  RamdiskId?: AttributeValue;
  RootDeviceName?: AttributeValue;
  SourceDestCheck?: AttributeBooleanValue;
  SriovNetSupport?: AttributeValue;
  UserData?: AttributeValue;
  DisableApiStop?: AttributeBooleanValue;
}
export interface DescribeInstanceCreditSpecificationsRequest {
  DryRun?: boolean;
  Filters?: Filter[];
  InstanceIds?: string[];
  MaxResults?: number;
  NextToken?: string;
}
export interface InstanceCreditSpecification {
  InstanceId?: string;
  CpuCredits?: string;
}
export interface DescribeInstanceCreditSpecificationsResult {
  InstanceCreditSpecifications?: InstanceCreditSpecification[];
  NextToken?: string;
}
export interface DescribeInstanceEventNotificationAttributesRequest {
  DryRun?: boolean;
}
export interface DescribeInstanceEventNotificationAttributesResult {
  InstanceTagAttribute?: InstanceTagNotificationAttribute;
}
export interface DescribeInstanceEventWindowsRequest {
  DryRun?: boolean;
  InstanceEventWindowIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface DescribeInstanceEventWindowsResult {
  InstanceEventWindows?: InstanceEventWindow[];
  NextToken?: string;
}
export interface DescribeInstancesRequest {
  Filters?: Filter[];
  InstanceIds?: string[];
  DryRun?: boolean;
  MaxResults?: number;
  NextToken?: string;
}
export interface CapacityReservationSpecificationResponse {
  CapacityReservationPreference?: CapacityReservationPreference | string;
  CapacityReservationTarget?: CapacityReservationTargetResponse;
}
export interface CpuOptions {
  CoreCount?: number;
  ThreadsPerCore?: number;
}
export interface ElasticGpuAssociation {
  ElasticGpuId?: string;
  ElasticGpuAssociationId?: string;
  ElasticGpuAssociationState?: string;
  ElasticGpuAssociationTime?: string;
}
export interface ElasticInferenceAcceleratorAssociation {
  ElasticInferenceAcceleratorArn?: string;
  ElasticInferenceAcceleratorAssociationId?: string;
  ElasticInferenceAcceleratorAssociationState?: string;
  ElasticInferenceAcceleratorAssociationTime?: Date;
}
export interface HibernationOptions {
  Configured?: boolean;
}
export declare enum InstanceLifecycleType {
  scheduled = "scheduled",
  spot = "spot",
}
export interface LicenseConfiguration {
  LicenseConfigurationArn?: string;
}
export declare enum InstanceAutoRecoveryState {
  default = "default",
  disabled = "disabled",
}
export interface InstanceMaintenanceOptions {
  AutoRecovery?: InstanceAutoRecoveryState | string;
}
export declare enum InstanceMetadataEndpointState {
  disabled = "disabled",
  enabled = "enabled",
}
export declare enum InstanceMetadataProtocolState {
  disabled = "disabled",
  enabled = "enabled",
}
export declare enum HttpTokensState {
  optional = "optional",
  required = "required",
}
export declare enum InstanceMetadataTagsState {
  disabled = "disabled",
  enabled = "enabled",
}
export declare enum InstanceMetadataOptionsState {
  applied = "applied",
  pending = "pending",
}
export interface InstanceMetadataOptionsResponse {
  State?: InstanceMetadataOptionsState | string;
  HttpTokens?: HttpTokensState | string;
  HttpPutResponseHopLimit?: number;
  HttpEndpoint?: InstanceMetadataEndpointState | string;
  HttpProtocolIpv6?: InstanceMetadataProtocolState | string;
  InstanceMetadataTags?: InstanceMetadataTagsState | string;
}
export declare enum MonitoringState {
  disabled = "disabled",
  disabling = "disabling",
  enabled = "enabled",
  pending = "pending",
}
export interface Monitoring {
  State?: MonitoringState | string;
}
export interface InstanceNetworkInterfaceAssociation {
  CarrierIp?: string;
  CustomerOwnedIp?: string;
  IpOwnerId?: string;
  PublicDnsName?: string;
  PublicIp?: string;
}
export interface InstanceNetworkInterfaceAttachment {
  AttachTime?: Date;
  AttachmentId?: string;
  DeleteOnTermination?: boolean;
  DeviceIndex?: number;
  Status?: AttachmentStatus | string;
  NetworkCardIndex?: number;
}
export interface InstanceIpv4Prefix {
  Ipv4Prefix?: string;
}
export interface InstanceIpv6Prefix {
  Ipv6Prefix?: string;
}
export interface InstancePrivateIpAddress {
  Association?: InstanceNetworkInterfaceAssociation;
  Primary?: boolean;
  PrivateDnsName?: string;
  PrivateIpAddress?: string;
}
export interface InstanceNetworkInterface {
  Association?: InstanceNetworkInterfaceAssociation;
  Attachment?: InstanceNetworkInterfaceAttachment;
  Description?: string;
  Groups?: GroupIdentifier[];
  Ipv6Addresses?: InstanceIpv6Address[];
  MacAddress?: string;
  NetworkInterfaceId?: string;
  OwnerId?: string;
  PrivateDnsName?: string;
  PrivateIpAddress?: string;
  PrivateIpAddresses?: InstancePrivateIpAddress[];
  SourceDestCheck?: boolean;
  Status?: NetworkInterfaceStatus | string;
  SubnetId?: string;
  VpcId?: string;
  InterfaceType?: string;
  Ipv4Prefixes?: InstanceIpv4Prefix[];
  Ipv6Prefixes?: InstanceIpv6Prefix[];
}
export interface PrivateDnsNameOptionsResponse {
  HostnameType?: HostnameType | string;
  EnableResourceNameDnsARecord?: boolean;
  EnableResourceNameDnsAAAARecord?: boolean;
}
export declare enum InstanceStateName {
  pending = "pending",
  running = "running",
  shutting_down = "shutting-down",
  stopped = "stopped",
  stopping = "stopping",
  terminated = "terminated",
}
export interface InstanceState {
  Code?: number;
  Name?: InstanceStateName | string;
}
export interface Instance {
  AmiLaunchIndex?: number;
  ImageId?: string;
  InstanceId?: string;
  InstanceType?: _InstanceType | string;
  KernelId?: string;
  KeyName?: string;
  LaunchTime?: Date;
  Monitoring?: Monitoring;
  Placement?: Placement;
  Platform?: PlatformValues | string;
  PrivateDnsName?: string;
  PrivateIpAddress?: string;
  ProductCodes?: ProductCode[];
  PublicDnsName?: string;
  PublicIpAddress?: string;
  RamdiskId?: string;
  State?: InstanceState;
  StateTransitionReason?: string;
  SubnetId?: string;
  VpcId?: string;
  Architecture?: ArchitectureValues | string;
  BlockDeviceMappings?: InstanceBlockDeviceMapping[];
  ClientToken?: string;
  EbsOptimized?: boolean;
  EnaSupport?: boolean;
  Hypervisor?: HypervisorType | string;
  IamInstanceProfile?: IamInstanceProfile;
  InstanceLifecycle?: InstanceLifecycleType | string;
  ElasticGpuAssociations?: ElasticGpuAssociation[];
  ElasticInferenceAcceleratorAssociations?: ElasticInferenceAcceleratorAssociation[];
  NetworkInterfaces?: InstanceNetworkInterface[];
  OutpostArn?: string;
  RootDeviceName?: string;
  RootDeviceType?: DeviceType | string;
  SecurityGroups?: GroupIdentifier[];
  SourceDestCheck?: boolean;
  SpotInstanceRequestId?: string;
  SriovNetSupport?: string;
  StateReason?: StateReason;
  Tags?: Tag[];
  VirtualizationType?: VirtualizationType | string;
  CpuOptions?: CpuOptions;
  CapacityReservationId?: string;
  CapacityReservationSpecification?: CapacityReservationSpecificationResponse;
  HibernationOptions?: HibernationOptions;
  Licenses?: LicenseConfiguration[];
  MetadataOptions?: InstanceMetadataOptionsResponse;
  EnclaveOptions?: EnclaveOptions;
  BootMode?: BootModeValues | string;
  PlatformDetails?: string;
  UsageOperation?: string;
  UsageOperationUpdateTime?: Date;
  PrivateDnsNameOptions?: PrivateDnsNameOptionsResponse;
  Ipv6Address?: string;
  TpmSupport?: string;
  MaintenanceOptions?: InstanceMaintenanceOptions;
}
export interface Reservation {
  Groups?: GroupIdentifier[];
  Instances?: Instance[];
  OwnerId?: string;
  RequesterId?: string;
  ReservationId?: string;
}
export interface DescribeInstancesResult {
  Reservations?: Reservation[];
  NextToken?: string;
}
export interface DescribeInstanceStatusRequest {
  Filters?: Filter[];
  InstanceIds?: string[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
  IncludeAllInstances?: boolean;
}
export declare enum EventCode {
  instance_reboot = "instance-reboot",
  instance_retirement = "instance-retirement",
  instance_stop = "instance-stop",
  system_maintenance = "system-maintenance",
  system_reboot = "system-reboot",
}
export interface InstanceStatusEvent {
  InstanceEventId?: string;
  Code?: EventCode | string;
  Description?: string;
  NotAfter?: Date;
  NotBefore?: Date;
  NotBeforeDeadline?: Date;
}
export declare enum StatusName {
  reachability = "reachability",
}
export declare enum StatusType {
  failed = "failed",
  initializing = "initializing",
  insufficient_data = "insufficient-data",
  passed = "passed",
}
export interface InstanceStatusDetails {
  ImpairedSince?: Date;
  Name?: StatusName | string;
  Status?: StatusType | string;
}
export declare enum SummaryStatus {
  impaired = "impaired",
  initializing = "initializing",
  insufficient_data = "insufficient-data",
  not_applicable = "not-applicable",
  ok = "ok",
}
export interface InstanceStatusSummary {
  Details?: InstanceStatusDetails[];
  Status?: SummaryStatus | string;
}
export interface InstanceStatus {
  AvailabilityZone?: string;
  OutpostArn?: string;
  Events?: InstanceStatusEvent[];
  InstanceId?: string;
  InstanceState?: InstanceState;
  InstanceStatus?: InstanceStatusSummary;
  SystemStatus?: InstanceStatusSummary;
}
export interface DescribeInstanceStatusResult {
  InstanceStatuses?: InstanceStatus[];
  NextToken?: string;
}
export declare enum LocationType {
  availability_zone = "availability-zone",
  availability_zone_id = "availability-zone-id",
  region = "region",
}
export interface DescribeInstanceTypeOfferingsRequest {
  DryRun?: boolean;
  LocationType?: LocationType | string;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface InstanceTypeOffering {
  InstanceType?: _InstanceType | string;
  LocationType?: LocationType | string;
  Location?: string;
}
export interface DescribeInstanceTypeOfferingsResult {
  InstanceTypeOfferings?: InstanceTypeOffering[];
  NextToken?: string;
}
export interface DescribeInstanceTypesRequest {
  DryRun?: boolean;
  InstanceTypes?: (_InstanceType | string)[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export declare const DeleteTransitGatewayRouteResultFilterSensitiveLog: (
  obj: DeleteTransitGatewayRouteResult
) => any;
export declare const DeleteTransitGatewayRouteTableRequestFilterSensitiveLog: (
  obj: DeleteTransitGatewayRouteTableRequest
) => any;
export declare const DeleteTransitGatewayRouteTableResultFilterSensitiveLog: (
  obj: DeleteTransitGatewayRouteTableResult
) => any;
export declare const DeleteTransitGatewayRouteTableAnnouncementRequestFilterSensitiveLog: (
  obj: DeleteTransitGatewayRouteTableAnnouncementRequest
) => any;
export declare const DeleteTransitGatewayRouteTableAnnouncementResultFilterSensitiveLog: (
  obj: DeleteTransitGatewayRouteTableAnnouncementResult
) => any;
export declare const DeleteTransitGatewayVpcAttachmentRequestFilterSensitiveLog: (
  obj: DeleteTransitGatewayVpcAttachmentRequest
) => any;
export declare const DeleteTransitGatewayVpcAttachmentResultFilterSensitiveLog: (
  obj: DeleteTransitGatewayVpcAttachmentResult
) => any;
export declare const DeleteVerifiedAccessEndpointRequestFilterSensitiveLog: (
  obj: DeleteVerifiedAccessEndpointRequest
) => any;
export declare const DeleteVerifiedAccessEndpointResultFilterSensitiveLog: (
  obj: DeleteVerifiedAccessEndpointResult
) => any;
export declare const DeleteVerifiedAccessGroupRequestFilterSensitiveLog: (
  obj: DeleteVerifiedAccessGroupRequest
) => any;
export declare const DeleteVerifiedAccessGroupResultFilterSensitiveLog: (
  obj: DeleteVerifiedAccessGroupResult
) => any;
export declare const DeleteVerifiedAccessInstanceRequestFilterSensitiveLog: (
  obj: DeleteVerifiedAccessInstanceRequest
) => any;
export declare const DeleteVerifiedAccessInstanceResultFilterSensitiveLog: (
  obj: DeleteVerifiedAccessInstanceResult
) => any;
export declare const DeleteVerifiedAccessTrustProviderRequestFilterSensitiveLog: (
  obj: DeleteVerifiedAccessTrustProviderRequest
) => any;
export declare const DeleteVerifiedAccessTrustProviderResultFilterSensitiveLog: (
  obj: DeleteVerifiedAccessTrustProviderResult
) => any;
export declare const DeleteVolumeRequestFilterSensitiveLog: (
  obj: DeleteVolumeRequest
) => any;
export declare const DeleteVpcRequestFilterSensitiveLog: (
  obj: DeleteVpcRequest
) => any;
export declare const DeleteVpcEndpointConnectionNotificationsRequestFilterSensitiveLog: (
  obj: DeleteVpcEndpointConnectionNotificationsRequest
) => any;
export declare const DeleteVpcEndpointConnectionNotificationsResultFilterSensitiveLog: (
  obj: DeleteVpcEndpointConnectionNotificationsResult
) => any;
export declare const DeleteVpcEndpointsRequestFilterSensitiveLog: (
  obj: DeleteVpcEndpointsRequest
) => any;
export declare const DeleteVpcEndpointsResultFilterSensitiveLog: (
  obj: DeleteVpcEndpointsResult
) => any;
export declare const DeleteVpcEndpointServiceConfigurationsRequestFilterSensitiveLog: (
  obj: DeleteVpcEndpointServiceConfigurationsRequest
) => any;
export declare const DeleteVpcEndpointServiceConfigurationsResultFilterSensitiveLog: (
  obj: DeleteVpcEndpointServiceConfigurationsResult
) => any;
export declare const DeleteVpcPeeringConnectionRequestFilterSensitiveLog: (
  obj: DeleteVpcPeeringConnectionRequest
) => any;
export declare const DeleteVpcPeeringConnectionResultFilterSensitiveLog: (
  obj: DeleteVpcPeeringConnectionResult
) => any;
export declare const DeleteVpnConnectionRequestFilterSensitiveLog: (
  obj: DeleteVpnConnectionRequest
) => any;
export declare const DeleteVpnConnectionRouteRequestFilterSensitiveLog: (
  obj: DeleteVpnConnectionRouteRequest
) => any;
export declare const DeleteVpnGatewayRequestFilterSensitiveLog: (
  obj: DeleteVpnGatewayRequest
) => any;
export declare const DeprovisionByoipCidrRequestFilterSensitiveLog: (
  obj: DeprovisionByoipCidrRequest
) => any;
export declare const DeprovisionByoipCidrResultFilterSensitiveLog: (
  obj: DeprovisionByoipCidrResult
) => any;
export declare const DeprovisionIpamPoolCidrRequestFilterSensitiveLog: (
  obj: DeprovisionIpamPoolCidrRequest
) => any;
export declare const IpamPoolCidrFailureReasonFilterSensitiveLog: (
  obj: IpamPoolCidrFailureReason
) => any;
export declare const IpamPoolCidrFilterSensitiveLog: (obj: IpamPoolCidr) => any;
export declare const DeprovisionIpamPoolCidrResultFilterSensitiveLog: (
  obj: DeprovisionIpamPoolCidrResult
) => any;
export declare const DeprovisionPublicIpv4PoolCidrRequestFilterSensitiveLog: (
  obj: DeprovisionPublicIpv4PoolCidrRequest
) => any;
export declare const DeprovisionPublicIpv4PoolCidrResultFilterSensitiveLog: (
  obj: DeprovisionPublicIpv4PoolCidrResult
) => any;
export declare const DeregisterImageRequestFilterSensitiveLog: (
  obj: DeregisterImageRequest
) => any;
export declare const DeregisterInstanceTagAttributeRequestFilterSensitiveLog: (
  obj: DeregisterInstanceTagAttributeRequest
) => any;
export declare const DeregisterInstanceEventNotificationAttributesRequestFilterSensitiveLog: (
  obj: DeregisterInstanceEventNotificationAttributesRequest
) => any;
export declare const InstanceTagNotificationAttributeFilterSensitiveLog: (
  obj: InstanceTagNotificationAttribute
) => any;
export declare const DeregisterInstanceEventNotificationAttributesResultFilterSensitiveLog: (
  obj: DeregisterInstanceEventNotificationAttributesResult
) => any;
export declare const DeregisterTransitGatewayMulticastGroupMembersRequestFilterSensitiveLog: (
  obj: DeregisterTransitGatewayMulticastGroupMembersRequest
) => any;
export declare const TransitGatewayMulticastDeregisteredGroupMembersFilterSensitiveLog: (
  obj: TransitGatewayMulticastDeregisteredGroupMembers
) => any;
export declare const DeregisterTransitGatewayMulticastGroupMembersResultFilterSensitiveLog: (
  obj: DeregisterTransitGatewayMulticastGroupMembersResult
) => any;
export declare const DeregisterTransitGatewayMulticastGroupSourcesRequestFilterSensitiveLog: (
  obj: DeregisterTransitGatewayMulticastGroupSourcesRequest
) => any;
export declare const TransitGatewayMulticastDeregisteredGroupSourcesFilterSensitiveLog: (
  obj: TransitGatewayMulticastDeregisteredGroupSources
) => any;
export declare const DeregisterTransitGatewayMulticastGroupSourcesResultFilterSensitiveLog: (
  obj: DeregisterTransitGatewayMulticastGroupSourcesResult
) => any;
export declare const DescribeAccountAttributesRequestFilterSensitiveLog: (
  obj: DescribeAccountAttributesRequest
) => any;
export declare const DescribeAccountAttributesResultFilterSensitiveLog: (
  obj: DescribeAccountAttributesResult
) => any;
export declare const FilterFilterSensitiveLog: (obj: Filter) => any;
export declare const DescribeAddressesRequestFilterSensitiveLog: (
  obj: DescribeAddressesRequest
) => any;
export declare const DescribeAddressesResultFilterSensitiveLog: (
  obj: DescribeAddressesResult
) => any;
export declare const DescribeAddressesAttributeRequestFilterSensitiveLog: (
  obj: DescribeAddressesAttributeRequest
) => any;
export declare const DescribeAddressesAttributeResultFilterSensitiveLog: (
  obj: DescribeAddressesAttributeResult
) => any;
export declare const DescribeAddressTransfersRequestFilterSensitiveLog: (
  obj: DescribeAddressTransfersRequest
) => any;
export declare const DescribeAddressTransfersResultFilterSensitiveLog: (
  obj: DescribeAddressTransfersResult
) => any;
export declare const DescribeAggregateIdFormatRequestFilterSensitiveLog: (
  obj: DescribeAggregateIdFormatRequest
) => any;
export declare const IdFormatFilterSensitiveLog: (obj: IdFormat) => any;
export declare const DescribeAggregateIdFormatResultFilterSensitiveLog: (
  obj: DescribeAggregateIdFormatResult
) => any;
export declare const DescribeAvailabilityZonesRequestFilterSensitiveLog: (
  obj: DescribeAvailabilityZonesRequest
) => any;
export declare const AvailabilityZoneMessageFilterSensitiveLog: (
  obj: AvailabilityZoneMessage
) => any;
export declare const AvailabilityZoneFilterSensitiveLog: (
  obj: AvailabilityZone
) => any;
export declare const DescribeAvailabilityZonesResultFilterSensitiveLog: (
  obj: DescribeAvailabilityZonesResult
) => any;
export declare const DescribeAwsNetworkPerformanceMetricSubscriptionsRequestFilterSensitiveLog: (
  obj: DescribeAwsNetworkPerformanceMetricSubscriptionsRequest
) => any;
export declare const SubscriptionFilterSensitiveLog: (obj: Subscription) => any;
export declare const DescribeAwsNetworkPerformanceMetricSubscriptionsResultFilterSensitiveLog: (
  obj: DescribeAwsNetworkPerformanceMetricSubscriptionsResult
) => any;
export declare const DescribeBundleTasksRequestFilterSensitiveLog: (
  obj: DescribeBundleTasksRequest
) => any;
export declare const DescribeBundleTasksResultFilterSensitiveLog: (
  obj: DescribeBundleTasksResult
) => any;
export declare const DescribeByoipCidrsRequestFilterSensitiveLog: (
  obj: DescribeByoipCidrsRequest
) => any;
export declare const DescribeByoipCidrsResultFilterSensitiveLog: (
  obj: DescribeByoipCidrsResult
) => any;
export declare const DescribeCapacityReservationFleetsRequestFilterSensitiveLog: (
  obj: DescribeCapacityReservationFleetsRequest
) => any;
export declare const CapacityReservationFleetFilterSensitiveLog: (
  obj: CapacityReservationFleet
) => any;
export declare const DescribeCapacityReservationFleetsResultFilterSensitiveLog: (
  obj: DescribeCapacityReservationFleetsResult
) => any;
export declare const DescribeCapacityReservationsRequestFilterSensitiveLog: (
  obj: DescribeCapacityReservationsRequest
) => any;
export declare const DescribeCapacityReservationsResultFilterSensitiveLog: (
  obj: DescribeCapacityReservationsResult
) => any;
export declare const DescribeCarrierGatewaysRequestFilterSensitiveLog: (
  obj: DescribeCarrierGatewaysRequest
) => any;
export declare const DescribeCarrierGatewaysResultFilterSensitiveLog: (
  obj: DescribeCarrierGatewaysResult
) => any;
export declare const DescribeClassicLinkInstancesRequestFilterSensitiveLog: (
  obj: DescribeClassicLinkInstancesRequest
) => any;
export declare const ClassicLinkInstanceFilterSensitiveLog: (
  obj: ClassicLinkInstance
) => any;
export declare const DescribeClassicLinkInstancesResultFilterSensitiveLog: (
  obj: DescribeClassicLinkInstancesResult
) => any;
export declare const DescribeClientVpnAuthorizationRulesRequestFilterSensitiveLog: (
  obj: DescribeClientVpnAuthorizationRulesRequest
) => any;
export declare const AuthorizationRuleFilterSensitiveLog: (
  obj: AuthorizationRule
) => any;
export declare const DescribeClientVpnAuthorizationRulesResultFilterSensitiveLog: (
  obj: DescribeClientVpnAuthorizationRulesResult
) => any;
export declare const DescribeClientVpnConnectionsRequestFilterSensitiveLog: (
  obj: DescribeClientVpnConnectionsRequest
) => any;
export declare const ClientVpnConnectionStatusFilterSensitiveLog: (
  obj: ClientVpnConnectionStatus
) => any;
export declare const ClientVpnConnectionFilterSensitiveLog: (
  obj: ClientVpnConnection
) => any;
export declare const DescribeClientVpnConnectionsResultFilterSensitiveLog: (
  obj: DescribeClientVpnConnectionsResult
) => any;
export declare const DescribeClientVpnEndpointsRequestFilterSensitiveLog: (
  obj: DescribeClientVpnEndpointsRequest
) => any;
export declare const AssociatedTargetNetworkFilterSensitiveLog: (
  obj: AssociatedTargetNetwork
) => any;
export declare const DirectoryServiceAuthenticationFilterSensitiveLog: (
  obj: DirectoryServiceAuthentication
) => any;
export declare const FederatedAuthenticationFilterSensitiveLog: (
  obj: FederatedAuthentication
) => any;
export declare const CertificateAuthenticationFilterSensitiveLog: (
  obj: CertificateAuthentication
) => any;
export declare const ClientVpnAuthenticationFilterSensitiveLog: (
  obj: ClientVpnAuthentication
) => any;
export declare const ClientVpnEndpointAttributeStatusFilterSensitiveLog: (
  obj: ClientVpnEndpointAttributeStatus
) => any;
export declare const ClientConnectResponseOptionsFilterSensitiveLog: (
  obj: ClientConnectResponseOptions
) => any;
export declare const ClientLoginBannerResponseOptionsFilterSensitiveLog: (
  obj: ClientLoginBannerResponseOptions
) => any;
export declare const ConnectionLogResponseOptionsFilterSensitiveLog: (
  obj: ConnectionLogResponseOptions
) => any;
export declare const ClientVpnEndpointFilterSensitiveLog: (
  obj: ClientVpnEndpoint
) => any;
export declare const DescribeClientVpnEndpointsResultFilterSensitiveLog: (
  obj: DescribeClientVpnEndpointsResult
) => any;
export declare const DescribeClientVpnRoutesRequestFilterSensitiveLog: (
  obj: DescribeClientVpnRoutesRequest
) => any;
export declare const ClientVpnRouteFilterSensitiveLog: (
  obj: ClientVpnRoute
) => any;
export declare const DescribeClientVpnRoutesResultFilterSensitiveLog: (
  obj: DescribeClientVpnRoutesResult
) => any;
export declare const DescribeClientVpnTargetNetworksRequestFilterSensitiveLog: (
  obj: DescribeClientVpnTargetNetworksRequest
) => any;
export declare const TargetNetworkFilterSensitiveLog: (
  obj: TargetNetwork
) => any;
export declare const DescribeClientVpnTargetNetworksResultFilterSensitiveLog: (
  obj: DescribeClientVpnTargetNetworksResult
) => any;
export declare const DescribeCoipPoolsRequestFilterSensitiveLog: (
  obj: DescribeCoipPoolsRequest
) => any;
export declare const DescribeCoipPoolsResultFilterSensitiveLog: (
  obj: DescribeCoipPoolsResult
) => any;
export declare const DescribeConversionTasksRequestFilterSensitiveLog: (
  obj: DescribeConversionTasksRequest
) => any;
export declare const DiskImageDescriptionFilterSensitiveLog: (
  obj: DiskImageDescription
) => any;
export declare const DiskImageVolumeDescriptionFilterSensitiveLog: (
  obj: DiskImageVolumeDescription
) => any;
export declare const ImportInstanceVolumeDetailItemFilterSensitiveLog: (
  obj: ImportInstanceVolumeDetailItem
) => any;
export declare const ImportInstanceTaskDetailsFilterSensitiveLog: (
  obj: ImportInstanceTaskDetails
) => any;
export declare const ImportVolumeTaskDetailsFilterSensitiveLog: (
  obj: ImportVolumeTaskDetails
) => any;
export declare const ConversionTaskFilterSensitiveLog: (
  obj: ConversionTask
) => any;
export declare const DescribeConversionTasksResultFilterSensitiveLog: (
  obj: DescribeConversionTasksResult
) => any;
export declare const DescribeCustomerGatewaysRequestFilterSensitiveLog: (
  obj: DescribeCustomerGatewaysRequest
) => any;
export declare const DescribeCustomerGatewaysResultFilterSensitiveLog: (
  obj: DescribeCustomerGatewaysResult
) => any;
export declare const DescribeDhcpOptionsRequestFilterSensitiveLog: (
  obj: DescribeDhcpOptionsRequest
) => any;
export declare const DescribeDhcpOptionsResultFilterSensitiveLog: (
  obj: DescribeDhcpOptionsResult
) => any;
export declare const DescribeEgressOnlyInternetGatewaysRequestFilterSensitiveLog: (
  obj: DescribeEgressOnlyInternetGatewaysRequest
) => any;
export declare const DescribeEgressOnlyInternetGatewaysResultFilterSensitiveLog: (
  obj: DescribeEgressOnlyInternetGatewaysResult
) => any;
export declare const DescribeElasticGpusRequestFilterSensitiveLog: (
  obj: DescribeElasticGpusRequest
) => any;
export declare const ElasticGpuHealthFilterSensitiveLog: (
  obj: ElasticGpuHealth
) => any;
export declare const ElasticGpusFilterSensitiveLog: (obj: ElasticGpus) => any;
export declare const DescribeElasticGpusResultFilterSensitiveLog: (
  obj: DescribeElasticGpusResult
) => any;
export declare const DescribeExportImageTasksRequestFilterSensitiveLog: (
  obj: DescribeExportImageTasksRequest
) => any;
export declare const ExportTaskS3LocationFilterSensitiveLog: (
  obj: ExportTaskS3Location
) => any;
export declare const ExportImageTaskFilterSensitiveLog: (
  obj: ExportImageTask
) => any;
export declare const DescribeExportImageTasksResultFilterSensitiveLog: (
  obj: DescribeExportImageTasksResult
) => any;
export declare const DescribeExportTasksRequestFilterSensitiveLog: (
  obj: DescribeExportTasksRequest
) => any;
export declare const DescribeExportTasksResultFilterSensitiveLog: (
  obj: DescribeExportTasksResult
) => any;
export declare const DescribeFastLaunchImagesRequestFilterSensitiveLog: (
  obj: DescribeFastLaunchImagesRequest
) => any;
export declare const FastLaunchLaunchTemplateSpecificationResponseFilterSensitiveLog: (
  obj: FastLaunchLaunchTemplateSpecificationResponse
) => any;
export declare const FastLaunchSnapshotConfigurationResponseFilterSensitiveLog: (
  obj: FastLaunchSnapshotConfigurationResponse
) => any;
export declare const DescribeFastLaunchImagesSuccessItemFilterSensitiveLog: (
  obj: DescribeFastLaunchImagesSuccessItem
) => any;
export declare const DescribeFastLaunchImagesResultFilterSensitiveLog: (
  obj: DescribeFastLaunchImagesResult
) => any;
export declare const DescribeFastSnapshotRestoresRequestFilterSensitiveLog: (
  obj: DescribeFastSnapshotRestoresRequest
) => any;
export declare const DescribeFastSnapshotRestoreSuccessItemFilterSensitiveLog: (
  obj: DescribeFastSnapshotRestoreSuccessItem
) => any;
export declare const DescribeFastSnapshotRestoresResultFilterSensitiveLog: (
  obj: DescribeFastSnapshotRestoresResult
) => any;
export declare const DescribeFleetHistoryRequestFilterSensitiveLog: (
  obj: DescribeFleetHistoryRequest
) => any;
export declare const EventInformationFilterSensitiveLog: (
  obj: EventInformation
) => any;
export declare const HistoryRecordEntryFilterSensitiveLog: (
  obj: HistoryRecordEntry
) => any;
export declare const DescribeFleetHistoryResultFilterSensitiveLog: (
  obj: DescribeFleetHistoryResult
) => any;
export declare const DescribeFleetInstancesRequestFilterSensitiveLog: (
  obj: DescribeFleetInstancesRequest
) => any;
export declare const DescribeFleetInstancesResultFilterSensitiveLog: (
  obj: DescribeFleetInstancesResult
) => any;
export declare const DescribeFleetsRequestFilterSensitiveLog: (
  obj: DescribeFleetsRequest
) => any;
export declare const DescribeFleetErrorFilterSensitiveLog: (
  obj: DescribeFleetError
) => any;
export declare const DescribeFleetsInstancesFilterSensitiveLog: (
  obj: DescribeFleetsInstances
) => any;
export declare const FleetLaunchTemplateConfigFilterSensitiveLog: (
  obj: FleetLaunchTemplateConfig
) => any;
export declare const CapacityReservationOptionsFilterSensitiveLog: (
  obj: CapacityReservationOptions
) => any;
export declare const OnDemandOptionsFilterSensitiveLog: (
  obj: OnDemandOptions
) => any;
export declare const FleetSpotCapacityRebalanceFilterSensitiveLog: (
  obj: FleetSpotCapacityRebalance
) => any;
export declare const FleetSpotMaintenanceStrategiesFilterSensitiveLog: (
  obj: FleetSpotMaintenanceStrategies
) => any;
export declare const SpotOptionsFilterSensitiveLog: (obj: SpotOptions) => any;
export declare const TargetCapacitySpecificationFilterSensitiveLog: (
  obj: TargetCapacitySpecification
) => any;
export declare const FleetDataFilterSensitiveLog: (obj: FleetData) => any;
export declare const DescribeFleetsResultFilterSensitiveLog: (
  obj: DescribeFleetsResult
) => any;
export declare const DescribeFlowLogsRequestFilterSensitiveLog: (
  obj: DescribeFlowLogsRequest
) => any;
export declare const DestinationOptionsResponseFilterSensitiveLog: (
  obj: DestinationOptionsResponse
) => any;
export declare const FlowLogFilterSensitiveLog: (obj: FlowLog) => any;
export declare const DescribeFlowLogsResultFilterSensitiveLog: (
  obj: DescribeFlowLogsResult
) => any;
export declare const DescribeFpgaImageAttributeRequestFilterSensitiveLog: (
  obj: DescribeFpgaImageAttributeRequest
) => any;
export declare const LoadPermissionFilterSensitiveLog: (
  obj: LoadPermission
) => any;
export declare const ProductCodeFilterSensitiveLog: (obj: ProductCode) => any;
export declare const FpgaImageAttributeFilterSensitiveLog: (
  obj: FpgaImageAttribute
) => any;
export declare const DescribeFpgaImageAttributeResultFilterSensitiveLog: (
  obj: DescribeFpgaImageAttributeResult
) => any;
export declare const DescribeFpgaImagesRequestFilterSensitiveLog: (
  obj: DescribeFpgaImagesRequest
) => any;
export declare const PciIdFilterSensitiveLog: (obj: PciId) => any;
export declare const FpgaImageStateFilterSensitiveLog: (
  obj: FpgaImageState
) => any;
export declare const FpgaImageFilterSensitiveLog: (obj: FpgaImage) => any;
export declare const DescribeFpgaImagesResultFilterSensitiveLog: (
  obj: DescribeFpgaImagesResult
) => any;
export declare const DescribeHostReservationOfferingsRequestFilterSensitiveLog: (
  obj: DescribeHostReservationOfferingsRequest
) => any;
export declare const HostOfferingFilterSensitiveLog: (obj: HostOffering) => any;
export declare const DescribeHostReservationOfferingsResultFilterSensitiveLog: (
  obj: DescribeHostReservationOfferingsResult
) => any;
export declare const DescribeHostReservationsRequestFilterSensitiveLog: (
  obj: DescribeHostReservationsRequest
) => any;
export declare const HostReservationFilterSensitiveLog: (
  obj: HostReservation
) => any;
export declare const DescribeHostReservationsResultFilterSensitiveLog: (
  obj: DescribeHostReservationsResult
) => any;
export declare const DescribeHostsRequestFilterSensitiveLog: (
  obj: DescribeHostsRequest
) => any;
export declare const InstanceCapacityFilterSensitiveLog: (
  obj: InstanceCapacity
) => any;
export declare const AvailableCapacityFilterSensitiveLog: (
  obj: AvailableCapacity
) => any;
export declare const HostPropertiesFilterSensitiveLog: (
  obj: HostProperties
) => any;
export declare const HostInstanceFilterSensitiveLog: (obj: HostInstance) => any;
export declare const HostFilterSensitiveLog: (obj: Host) => any;
export declare const DescribeHostsResultFilterSensitiveLog: (
  obj: DescribeHostsResult
) => any;
export declare const DescribeIamInstanceProfileAssociationsRequestFilterSensitiveLog: (
  obj: DescribeIamInstanceProfileAssociationsRequest
) => any;
export declare const DescribeIamInstanceProfileAssociationsResultFilterSensitiveLog: (
  obj: DescribeIamInstanceProfileAssociationsResult
) => any;
export declare const DescribeIdentityIdFormatRequestFilterSensitiveLog: (
  obj: DescribeIdentityIdFormatRequest
) => any;
export declare const DescribeIdentityIdFormatResultFilterSensitiveLog: (
  obj: DescribeIdentityIdFormatResult
) => any;
export declare const DescribeIdFormatRequestFilterSensitiveLog: (
  obj: DescribeIdFormatRequest
) => any;
export declare const DescribeIdFormatResultFilterSensitiveLog: (
  obj: DescribeIdFormatResult
) => any;
export declare const DescribeImageAttributeRequestFilterSensitiveLog: (
  obj: DescribeImageAttributeRequest
) => any;
export declare const LaunchPermissionFilterSensitiveLog: (
  obj: LaunchPermission
) => any;
export declare const ImageAttributeFilterSensitiveLog: (
  obj: ImageAttribute
) => any;
export declare const DescribeImagesRequestFilterSensitiveLog: (
  obj: DescribeImagesRequest
) => any;
export declare const ImageFilterSensitiveLog: (obj: Image) => any;
export declare const DescribeImagesResultFilterSensitiveLog: (
  obj: DescribeImagesResult
) => any;
export declare const DescribeImportImageTasksRequestFilterSensitiveLog: (
  obj: DescribeImportImageTasksRequest
) => any;
export declare const ImportImageLicenseConfigurationResponseFilterSensitiveLog: (
  obj: ImportImageLicenseConfigurationResponse
) => any;
export declare const UserBucketDetailsFilterSensitiveLog: (
  obj: UserBucketDetails
) => any;
export declare const SnapshotDetailFilterSensitiveLog: (
  obj: SnapshotDetail
) => any;
export declare const ImportImageTaskFilterSensitiveLog: (
  obj: ImportImageTask
) => any;
export declare const DescribeImportImageTasksResultFilterSensitiveLog: (
  obj: DescribeImportImageTasksResult
) => any;
export declare const DescribeImportSnapshotTasksRequestFilterSensitiveLog: (
  obj: DescribeImportSnapshotTasksRequest
) => any;
export declare const SnapshotTaskDetailFilterSensitiveLog: (
  obj: SnapshotTaskDetail
) => any;
export declare const ImportSnapshotTaskFilterSensitiveLog: (
  obj: ImportSnapshotTask
) => any;
export declare const DescribeImportSnapshotTasksResultFilterSensitiveLog: (
  obj: DescribeImportSnapshotTasksResult
) => any;
export declare const DescribeInstanceAttributeRequestFilterSensitiveLog: (
  obj: DescribeInstanceAttributeRequest
) => any;
export declare const EbsInstanceBlockDeviceFilterSensitiveLog: (
  obj: EbsInstanceBlockDevice
) => any;
export declare const InstanceBlockDeviceMappingFilterSensitiveLog: (
  obj: InstanceBlockDeviceMapping
) => any;
export declare const AttributeBooleanValueFilterSensitiveLog: (
  obj: AttributeBooleanValue
) => any;
export declare const EnclaveOptionsFilterSensitiveLog: (
  obj: EnclaveOptions
) => any;
export declare const InstanceAttributeFilterSensitiveLog: (
  obj: InstanceAttribute
) => any;
export declare const DescribeInstanceCreditSpecificationsRequestFilterSensitiveLog: (
  obj: DescribeInstanceCreditSpecificationsRequest
) => any;
export declare const InstanceCreditSpecificationFilterSensitiveLog: (
  obj: InstanceCreditSpecification
) => any;
export declare const DescribeInstanceCreditSpecificationsResultFilterSensitiveLog: (
  obj: DescribeInstanceCreditSpecificationsResult
) => any;
export declare const DescribeInstanceEventNotificationAttributesRequestFilterSensitiveLog: (
  obj: DescribeInstanceEventNotificationAttributesRequest
) => any;
export declare const DescribeInstanceEventNotificationAttributesResultFilterSensitiveLog: (
  obj: DescribeInstanceEventNotificationAttributesResult
) => any;
export declare const DescribeInstanceEventWindowsRequestFilterSensitiveLog: (
  obj: DescribeInstanceEventWindowsRequest
) => any;
export declare const DescribeInstanceEventWindowsResultFilterSensitiveLog: (
  obj: DescribeInstanceEventWindowsResult
) => any;
export declare const DescribeInstancesRequestFilterSensitiveLog: (
  obj: DescribeInstancesRequest
) => any;
export declare const CapacityReservationSpecificationResponseFilterSensitiveLog: (
  obj: CapacityReservationSpecificationResponse
) => any;
export declare const CpuOptionsFilterSensitiveLog: (obj: CpuOptions) => any;
export declare const ElasticGpuAssociationFilterSensitiveLog: (
  obj: ElasticGpuAssociation
) => any;
export declare const ElasticInferenceAcceleratorAssociationFilterSensitiveLog: (
  obj: ElasticInferenceAcceleratorAssociation
) => any;
export declare const HibernationOptionsFilterSensitiveLog: (
  obj: HibernationOptions
) => any;
export declare const LicenseConfigurationFilterSensitiveLog: (
  obj: LicenseConfiguration
) => any;
export declare const InstanceMaintenanceOptionsFilterSensitiveLog: (
  obj: InstanceMaintenanceOptions
) => any;
export declare const InstanceMetadataOptionsResponseFilterSensitiveLog: (
  obj: InstanceMetadataOptionsResponse
) => any;
export declare const MonitoringFilterSensitiveLog: (obj: Monitoring) => any;
export declare const InstanceNetworkInterfaceAssociationFilterSensitiveLog: (
  obj: InstanceNetworkInterfaceAssociation
) => any;
export declare const InstanceNetworkInterfaceAttachmentFilterSensitiveLog: (
  obj: InstanceNetworkInterfaceAttachment
) => any;
export declare const InstanceIpv4PrefixFilterSensitiveLog: (
  obj: InstanceIpv4Prefix
) => any;
export declare const InstanceIpv6PrefixFilterSensitiveLog: (
  obj: InstanceIpv6Prefix
) => any;
export declare const InstancePrivateIpAddressFilterSensitiveLog: (
  obj: InstancePrivateIpAddress
) => any;
export declare const InstanceNetworkInterfaceFilterSensitiveLog: (
  obj: InstanceNetworkInterface
) => any;
export declare const PrivateDnsNameOptionsResponseFilterSensitiveLog: (
  obj: PrivateDnsNameOptionsResponse
) => any;
export declare const InstanceStateFilterSensitiveLog: (
  obj: InstanceState
) => any;
export declare const InstanceFilterSensitiveLog: (obj: Instance) => any;
export declare const ReservationFilterSensitiveLog: (obj: Reservation) => any;
export declare const DescribeInstancesResultFilterSensitiveLog: (
  obj: DescribeInstancesResult
) => any;
export declare const DescribeInstanceStatusRequestFilterSensitiveLog: (
  obj: DescribeInstanceStatusRequest
) => any;
export declare const InstanceStatusEventFilterSensitiveLog: (
  obj: InstanceStatusEvent
) => any;
export declare const InstanceStatusDetailsFilterSensitiveLog: (
  obj: InstanceStatusDetails
) => any;
export declare const InstanceStatusSummaryFilterSensitiveLog: (
  obj: InstanceStatusSummary
) => any;
export declare const InstanceStatusFilterSensitiveLog: (
  obj: InstanceStatus
) => any;
export declare const DescribeInstanceStatusResultFilterSensitiveLog: (
  obj: DescribeInstanceStatusResult
) => any;
export declare const DescribeInstanceTypeOfferingsRequestFilterSensitiveLog: (
  obj: DescribeInstanceTypeOfferingsRequest
) => any;
export declare const InstanceTypeOfferingFilterSensitiveLog: (
  obj: InstanceTypeOffering
) => any;
export declare const DescribeInstanceTypeOfferingsResultFilterSensitiveLog: (
  obj: DescribeInstanceTypeOfferingsResult
) => any;
export declare const DescribeInstanceTypesRequestFilterSensitiveLog: (
  obj: DescribeInstanceTypesRequest
) => any;
