import {
  ApplianceModeSupportValue,
  CarrierGateway,
  ClientVpnEndpointStatus,
  ClientVpnRouteStatus,
  CoipCidr,
  DeviceTrustProviderType,
  DnsSupportValue,
  DynamicRoutingValue,
  InstanceEventWindowState,
  Ipv6SupportValue,
  Tag,
  TagSpecification,
  TransitGatewayAttachmentResourceType,
  TransitGatewayAttachmentState,
  TransitGatewayPeeringAttachment,
  TransitGatewayVpcAttachment,
  TrustProviderType,
  UnsuccessfulItem,
  UserTrustProviderType,
  VerifiedAccessInstance,
  VerifiedAccessTrustProvider,
  VolumeAttachment,
  VpcAttachment,
  VpcPeeringConnection,
} from "./models_0";
import {
  CoipPool,
  GatewayType,
  Ipam,
  IpamPool,
  IpamScope,
  LaunchTemplate,
  LocalGatewayRoute,
  LocalGatewayRouteTable,
  LocalGatewayRouteTableVirtualInterfaceGroupAssociation,
  LocalGatewayRouteTableVpcAssociation,
  ManagedPrefixList,
  SnapshotState,
  Subnet,
  Tenancy,
  VolumeType,
  Vpc,
} from "./models_1";
export interface SnapshotInfo {
  Description?: string;
  Tags?: Tag[];
  Encrypted?: boolean;
  VolumeId?: string;
  State?: SnapshotState | string;
  VolumeSize?: number;
  StartTime?: Date;
  Progress?: string;
  OwnerId?: string;
  SnapshotId?: string;
  OutpostArn?: string;
}
export interface CreateSnapshotsResult {
  Snapshots?: SnapshotInfo[];
}
export interface CreateSpotDatafeedSubscriptionRequest {
  Bucket: string | undefined;
  DryRun?: boolean;
  Prefix?: string;
}
export interface SpotInstanceStateFault {
  Code?: string;
  Message?: string;
}
export declare enum DatafeedSubscriptionState {
  Active = "Active",
  Inactive = "Inactive",
}
export interface SpotDatafeedSubscription {
  Bucket?: string;
  Fault?: SpotInstanceStateFault;
  OwnerId?: string;
  Prefix?: string;
  State?: DatafeedSubscriptionState | string;
}
export interface CreateSpotDatafeedSubscriptionResult {
  SpotDatafeedSubscription?: SpotDatafeedSubscription;
}
export interface S3ObjectTag {
  Key?: string;
  Value?: string;
}
export interface CreateStoreImageTaskRequest {
  ImageId: string | undefined;
  Bucket: string | undefined;
  S3ObjectTags?: S3ObjectTag[];
  DryRun?: boolean;
}
export interface CreateStoreImageTaskResult {
  ObjectKey?: string;
}
export interface CreateSubnetRequest {
  TagSpecifications?: TagSpecification[];
  AvailabilityZone?: string;
  AvailabilityZoneId?: string;
  CidrBlock?: string;
  Ipv6CidrBlock?: string;
  OutpostArn?: string;
  VpcId: string | undefined;
  DryRun?: boolean;
  Ipv6Native?: boolean;
}
export interface CreateSubnetResult {
  Subnet?: Subnet;
}
export declare enum SubnetCidrReservationType {
  explicit = "explicit",
  prefix = "prefix",
}
export interface CreateSubnetCidrReservationRequest {
  SubnetId: string | undefined;
  Cidr: string | undefined;
  ReservationType: SubnetCidrReservationType | string | undefined;
  Description?: string;
  DryRun?: boolean;
  TagSpecifications?: TagSpecification[];
}
export interface SubnetCidrReservation {
  SubnetCidrReservationId?: string;
  SubnetId?: string;
  Cidr?: string;
  ReservationType?: SubnetCidrReservationType | string;
  OwnerId?: string;
  Description?: string;
  Tags?: Tag[];
}
export interface CreateSubnetCidrReservationResult {
  SubnetCidrReservation?: SubnetCidrReservation;
}
export interface CreateTagsRequest {
  DryRun?: boolean;
  Resources: string[] | undefined;
  Tags: Tag[] | undefined;
}
export interface CreateTrafficMirrorFilterRequest {
  Description?: string;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
  ClientToken?: string;
}
export interface TrafficMirrorPortRange {
  FromPort?: number;
  ToPort?: number;
}
export declare enum TrafficMirrorRuleAction {
  accept = "accept",
  reject = "reject",
}
export declare enum TrafficDirection {
  egress = "egress",
  ingress = "ingress",
}
export interface TrafficMirrorFilterRule {
  TrafficMirrorFilterRuleId?: string;
  TrafficMirrorFilterId?: string;
  TrafficDirection?: TrafficDirection | string;
  RuleNumber?: number;
  RuleAction?: TrafficMirrorRuleAction | string;
  Protocol?: number;
  DestinationPortRange?: TrafficMirrorPortRange;
  SourcePortRange?: TrafficMirrorPortRange;
  DestinationCidrBlock?: string;
  SourceCidrBlock?: string;
  Description?: string;
}
export declare enum TrafficMirrorNetworkService {
  amazon_dns = "amazon-dns",
}
export interface TrafficMirrorFilter {
  TrafficMirrorFilterId?: string;
  IngressFilterRules?: TrafficMirrorFilterRule[];
  EgressFilterRules?: TrafficMirrorFilterRule[];
  NetworkServices?: (TrafficMirrorNetworkService | string)[];
  Description?: string;
  Tags?: Tag[];
}
export interface CreateTrafficMirrorFilterResult {
  TrafficMirrorFilter?: TrafficMirrorFilter;
  ClientToken?: string;
}
export interface TrafficMirrorPortRangeRequest {
  FromPort?: number;
  ToPort?: number;
}
export interface CreateTrafficMirrorFilterRuleRequest {
  TrafficMirrorFilterId: string | undefined;
  TrafficDirection: TrafficDirection | string | undefined;
  RuleNumber: number | undefined;
  RuleAction: TrafficMirrorRuleAction | string | undefined;
  DestinationPortRange?: TrafficMirrorPortRangeRequest;
  SourcePortRange?: TrafficMirrorPortRangeRequest;
  Protocol?: number;
  DestinationCidrBlock: string | undefined;
  SourceCidrBlock: string | undefined;
  Description?: string;
  DryRun?: boolean;
  ClientToken?: string;
}
export interface CreateTrafficMirrorFilterRuleResult {
  TrafficMirrorFilterRule?: TrafficMirrorFilterRule;
  ClientToken?: string;
}
export interface CreateTrafficMirrorSessionRequest {
  NetworkInterfaceId: string | undefined;
  TrafficMirrorTargetId: string | undefined;
  TrafficMirrorFilterId: string | undefined;
  PacketLength?: number;
  SessionNumber: number | undefined;
  VirtualNetworkId?: number;
  Description?: string;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
  ClientToken?: string;
}
export interface TrafficMirrorSession {
  TrafficMirrorSessionId?: string;
  TrafficMirrorTargetId?: string;
  TrafficMirrorFilterId?: string;
  NetworkInterfaceId?: string;
  OwnerId?: string;
  PacketLength?: number;
  SessionNumber?: number;
  VirtualNetworkId?: number;
  Description?: string;
  Tags?: Tag[];
}
export interface CreateTrafficMirrorSessionResult {
  TrafficMirrorSession?: TrafficMirrorSession;
  ClientToken?: string;
}
export interface CreateTrafficMirrorTargetRequest {
  NetworkInterfaceId?: string;
  NetworkLoadBalancerArn?: string;
  Description?: string;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
  ClientToken?: string;
  GatewayLoadBalancerEndpointId?: string;
}
export declare enum TrafficMirrorTargetType {
  gateway_load_balancer_endpoint = "gateway-load-balancer-endpoint",
  network_interface = "network-interface",
  network_load_balancer = "network-load-balancer",
}
export interface TrafficMirrorTarget {
  TrafficMirrorTargetId?: string;
  NetworkInterfaceId?: string;
  NetworkLoadBalancerArn?: string;
  Type?: TrafficMirrorTargetType | string;
  Description?: string;
  OwnerId?: string;
  Tags?: Tag[];
  GatewayLoadBalancerEndpointId?: string;
}
export interface CreateTrafficMirrorTargetResult {
  TrafficMirrorTarget?: TrafficMirrorTarget;
  ClientToken?: string;
}
export declare enum AutoAcceptSharedAttachmentsValue {
  disable = "disable",
  enable = "enable",
}
export declare enum DefaultRouteTableAssociationValue {
  disable = "disable",
  enable = "enable",
}
export declare enum DefaultRouteTablePropagationValue {
  disable = "disable",
  enable = "enable",
}
export declare enum MulticastSupportValue {
  disable = "disable",
  enable = "enable",
}
export declare enum VpnEcmpSupportValue {
  disable = "disable",
  enable = "enable",
}
export interface TransitGatewayRequestOptions {
  AmazonSideAsn?: number;
  AutoAcceptSharedAttachments?: AutoAcceptSharedAttachmentsValue | string;
  DefaultRouteTableAssociation?: DefaultRouteTableAssociationValue | string;
  DefaultRouteTablePropagation?: DefaultRouteTablePropagationValue | string;
  VpnEcmpSupport?: VpnEcmpSupportValue | string;
  DnsSupport?: DnsSupportValue | string;
  MulticastSupport?: MulticastSupportValue | string;
  TransitGatewayCidrBlocks?: string[];
}
export interface CreateTransitGatewayRequest {
  Description?: string;
  Options?: TransitGatewayRequestOptions;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface TransitGatewayOptions {
  AmazonSideAsn?: number;
  TransitGatewayCidrBlocks?: string[];
  AutoAcceptSharedAttachments?: AutoAcceptSharedAttachmentsValue | string;
  DefaultRouteTableAssociation?: DefaultRouteTableAssociationValue | string;
  AssociationDefaultRouteTableId?: string;
  DefaultRouteTablePropagation?: DefaultRouteTablePropagationValue | string;
  PropagationDefaultRouteTableId?: string;
  VpnEcmpSupport?: VpnEcmpSupportValue | string;
  DnsSupport?: DnsSupportValue | string;
  MulticastSupport?: MulticastSupportValue | string;
}
export declare enum TransitGatewayState {
  available = "available",
  deleted = "deleted",
  deleting = "deleting",
  modifying = "modifying",
  pending = "pending",
}
export interface TransitGateway {
  TransitGatewayId?: string;
  TransitGatewayArn?: string;
  State?: TransitGatewayState | string;
  OwnerId?: string;
  Description?: string;
  CreationTime?: Date;
  Options?: TransitGatewayOptions;
  Tags?: Tag[];
}
export interface CreateTransitGatewayResult {
  TransitGateway?: TransitGateway;
}
export declare enum ProtocolValue {
  gre = "gre",
}
export interface CreateTransitGatewayConnectRequestOptions {
  Protocol: ProtocolValue | string | undefined;
}
export interface CreateTransitGatewayConnectRequest {
  TransportTransitGatewayAttachmentId: string | undefined;
  Options: CreateTransitGatewayConnectRequestOptions | undefined;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface TransitGatewayConnectOptions {
  Protocol?: ProtocolValue | string;
}
export interface TransitGatewayConnect {
  TransitGatewayAttachmentId?: string;
  TransportTransitGatewayAttachmentId?: string;
  TransitGatewayId?: string;
  State?: TransitGatewayAttachmentState | string;
  CreationTime?: Date;
  Options?: TransitGatewayConnectOptions;
  Tags?: Tag[];
}
export interface CreateTransitGatewayConnectResult {
  TransitGatewayConnect?: TransitGatewayConnect;
}
export interface TransitGatewayConnectRequestBgpOptions {
  PeerAsn?: number;
}
export interface CreateTransitGatewayConnectPeerRequest {
  TransitGatewayAttachmentId: string | undefined;
  TransitGatewayAddress?: string;
  PeerAddress: string | undefined;
  BgpOptions?: TransitGatewayConnectRequestBgpOptions;
  InsideCidrBlocks: string[] | undefined;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export declare enum BgpStatus {
  down = "down",
  up = "up",
}
export interface TransitGatewayAttachmentBgpConfiguration {
  TransitGatewayAsn?: number;
  PeerAsn?: number;
  TransitGatewayAddress?: string;
  PeerAddress?: string;
  BgpStatus?: BgpStatus | string;
}
export interface TransitGatewayConnectPeerConfiguration {
  TransitGatewayAddress?: string;
  PeerAddress?: string;
  InsideCidrBlocks?: string[];
  Protocol?: ProtocolValue | string;
  BgpConfigurations?: TransitGatewayAttachmentBgpConfiguration[];
}
export declare enum TransitGatewayConnectPeerState {
  available = "available",
  deleted = "deleted",
  deleting = "deleting",
  pending = "pending",
}
export interface TransitGatewayConnectPeer {
  TransitGatewayAttachmentId?: string;
  TransitGatewayConnectPeerId?: string;
  State?: TransitGatewayConnectPeerState | string;
  CreationTime?: Date;
  ConnectPeerConfiguration?: TransitGatewayConnectPeerConfiguration;
  Tags?: Tag[];
}
export interface CreateTransitGatewayConnectPeerResult {
  TransitGatewayConnectPeer?: TransitGatewayConnectPeer;
}
export declare enum AutoAcceptSharedAssociationsValue {
  disable = "disable",
  enable = "enable",
}
export declare enum Igmpv2SupportValue {
  disable = "disable",
  enable = "enable",
}
export declare enum StaticSourcesSupportValue {
  disable = "disable",
  enable = "enable",
}
export interface CreateTransitGatewayMulticastDomainRequestOptions {
  Igmpv2Support?: Igmpv2SupportValue | string;
  StaticSourcesSupport?: StaticSourcesSupportValue | string;
  AutoAcceptSharedAssociations?: AutoAcceptSharedAssociationsValue | string;
}
export interface CreateTransitGatewayMulticastDomainRequest {
  TransitGatewayId: string | undefined;
  Options?: CreateTransitGatewayMulticastDomainRequestOptions;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface TransitGatewayMulticastDomainOptions {
  Igmpv2Support?: Igmpv2SupportValue | string;
  StaticSourcesSupport?: StaticSourcesSupportValue | string;
  AutoAcceptSharedAssociations?: AutoAcceptSharedAssociationsValue | string;
}
export declare enum TransitGatewayMulticastDomainState {
  available = "available",
  deleted = "deleted",
  deleting = "deleting",
  pending = "pending",
}
export interface TransitGatewayMulticastDomain {
  TransitGatewayMulticastDomainId?: string;
  TransitGatewayId?: string;
  TransitGatewayMulticastDomainArn?: string;
  OwnerId?: string;
  Options?: TransitGatewayMulticastDomainOptions;
  State?: TransitGatewayMulticastDomainState | string;
  CreationTime?: Date;
  Tags?: Tag[];
}
export interface CreateTransitGatewayMulticastDomainResult {
  TransitGatewayMulticastDomain?: TransitGatewayMulticastDomain;
}
export interface CreateTransitGatewayPeeringAttachmentRequestOptions {
  DynamicRouting?: DynamicRoutingValue | string;
}
export interface CreateTransitGatewayPeeringAttachmentRequest {
  TransitGatewayId: string | undefined;
  PeerTransitGatewayId: string | undefined;
  PeerAccountId: string | undefined;
  PeerRegion: string | undefined;
  Options?: CreateTransitGatewayPeeringAttachmentRequestOptions;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface CreateTransitGatewayPeeringAttachmentResult {
  TransitGatewayPeeringAttachment?: TransitGatewayPeeringAttachment;
}
export interface CreateTransitGatewayPolicyTableRequest {
  TransitGatewayId: string | undefined;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export declare enum TransitGatewayPolicyTableState {
  available = "available",
  deleted = "deleted",
  deleting = "deleting",
  pending = "pending",
}
export interface TransitGatewayPolicyTable {
  TransitGatewayPolicyTableId?: string;
  TransitGatewayId?: string;
  State?: TransitGatewayPolicyTableState | string;
  CreationTime?: Date;
  Tags?: Tag[];
}
export interface CreateTransitGatewayPolicyTableResult {
  TransitGatewayPolicyTable?: TransitGatewayPolicyTable;
}
export interface CreateTransitGatewayPrefixListReferenceRequest {
  TransitGatewayRouteTableId: string | undefined;
  PrefixListId: string | undefined;
  TransitGatewayAttachmentId?: string;
  Blackhole?: boolean;
  DryRun?: boolean;
}
export declare enum TransitGatewayPrefixListReferenceState {
  available = "available",
  deleting = "deleting",
  modifying = "modifying",
  pending = "pending",
}
export interface TransitGatewayPrefixListAttachment {
  TransitGatewayAttachmentId?: string;
  ResourceType?: TransitGatewayAttachmentResourceType | string;
  ResourceId?: string;
}
export interface TransitGatewayPrefixListReference {
  TransitGatewayRouteTableId?: string;
  PrefixListId?: string;
  PrefixListOwnerId?: string;
  State?: TransitGatewayPrefixListReferenceState | string;
  Blackhole?: boolean;
  TransitGatewayAttachment?: TransitGatewayPrefixListAttachment;
}
export interface CreateTransitGatewayPrefixListReferenceResult {
  TransitGatewayPrefixListReference?: TransitGatewayPrefixListReference;
}
export interface CreateTransitGatewayRouteRequest {
  DestinationCidrBlock: string | undefined;
  TransitGatewayRouteTableId: string | undefined;
  TransitGatewayAttachmentId?: string;
  Blackhole?: boolean;
  DryRun?: boolean;
}
export declare enum TransitGatewayRouteState {
  active = "active",
  blackhole = "blackhole",
  deleted = "deleted",
  deleting = "deleting",
  pending = "pending",
}
export interface TransitGatewayRouteAttachment {
  ResourceId?: string;
  TransitGatewayAttachmentId?: string;
  ResourceType?: TransitGatewayAttachmentResourceType | string;
}
export declare enum TransitGatewayRouteType {
  propagated = "propagated",
  static = "static",
}
export interface TransitGatewayRoute {
  DestinationCidrBlock?: string;
  PrefixListId?: string;
  TransitGatewayRouteTableAnnouncementId?: string;
  TransitGatewayAttachments?: TransitGatewayRouteAttachment[];
  Type?: TransitGatewayRouteType | string;
  State?: TransitGatewayRouteState | string;
}
export interface CreateTransitGatewayRouteResult {
  Route?: TransitGatewayRoute;
}
export interface CreateTransitGatewayRouteTableRequest {
  TransitGatewayId: string | undefined;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export declare enum TransitGatewayRouteTableState {
  available = "available",
  deleted = "deleted",
  deleting = "deleting",
  pending = "pending",
}
export interface TransitGatewayRouteTable {
  TransitGatewayRouteTableId?: string;
  TransitGatewayId?: string;
  State?: TransitGatewayRouteTableState | string;
  DefaultAssociationRouteTable?: boolean;
  DefaultPropagationRouteTable?: boolean;
  CreationTime?: Date;
  Tags?: Tag[];
}
export interface CreateTransitGatewayRouteTableResult {
  TransitGatewayRouteTable?: TransitGatewayRouteTable;
}
export interface CreateTransitGatewayRouteTableAnnouncementRequest {
  TransitGatewayRouteTableId: string | undefined;
  PeeringAttachmentId: string | undefined;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export declare enum TransitGatewayRouteTableAnnouncementDirection {
  incoming = "incoming",
  outgoing = "outgoing",
}
export declare enum TransitGatewayRouteTableAnnouncementState {
  available = "available",
  deleted = "deleted",
  deleting = "deleting",
  failed = "failed",
  failing = "failing",
  pending = "pending",
}
export interface TransitGatewayRouteTableAnnouncement {
  TransitGatewayRouteTableAnnouncementId?: string;
  TransitGatewayId?: string;
  CoreNetworkId?: string;
  PeerTransitGatewayId?: string;
  PeerCoreNetworkId?: string;
  PeeringAttachmentId?: string;
  AnnouncementDirection?:
    | TransitGatewayRouteTableAnnouncementDirection
    | string;
  TransitGatewayRouteTableId?: string;
  State?: TransitGatewayRouteTableAnnouncementState | string;
  CreationTime?: Date;
  Tags?: Tag[];
}
export interface CreateTransitGatewayRouteTableAnnouncementResult {
  TransitGatewayRouteTableAnnouncement?: TransitGatewayRouteTableAnnouncement;
}
export interface CreateTransitGatewayVpcAttachmentRequestOptions {
  DnsSupport?: DnsSupportValue | string;
  Ipv6Support?: Ipv6SupportValue | string;
  ApplianceModeSupport?: ApplianceModeSupportValue | string;
}
export interface CreateTransitGatewayVpcAttachmentRequest {
  TransitGatewayId: string | undefined;
  VpcId: string | undefined;
  SubnetIds: string[] | undefined;
  Options?: CreateTransitGatewayVpcAttachmentRequestOptions;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface CreateTransitGatewayVpcAttachmentResult {
  TransitGatewayVpcAttachment?: TransitGatewayVpcAttachment;
}
export declare enum VerifiedAccessEndpointAttachmentType {
  vpc = "vpc",
}
export declare enum VerifiedAccessEndpointType {
  load_balancer = "load-balancer",
  network_interface = "network-interface",
}
export declare enum VerifiedAccessEndpointProtocol {
  http = "http",
  https = "https",
}
export interface CreateVerifiedAccessEndpointLoadBalancerOptions {
  Protocol?: VerifiedAccessEndpointProtocol | string;
  Port?: number;
  LoadBalancerArn?: string;
  SubnetIds?: string[];
}
export interface CreateVerifiedAccessEndpointEniOptions {
  NetworkInterfaceId?: string;
  Protocol?: VerifiedAccessEndpointProtocol | string;
  Port?: number;
}
export interface CreateVerifiedAccessEndpointRequest {
  VerifiedAccessGroupId: string | undefined;
  EndpointType: VerifiedAccessEndpointType | string | undefined;
  AttachmentType: VerifiedAccessEndpointAttachmentType | string | undefined;
  DomainCertificateArn: string | undefined;
  ApplicationDomain: string | undefined;
  EndpointDomainPrefix: string | undefined;
  SecurityGroupIds?: string[];
  LoadBalancerOptions?: CreateVerifiedAccessEndpointLoadBalancerOptions;
  NetworkInterfaceOptions?: CreateVerifiedAccessEndpointEniOptions;
  Description?: string;
  PolicyDocument?: string;
  TagSpecifications?: TagSpecification[];
  ClientToken?: string;
  DryRun?: boolean;
}
export interface VerifiedAccessEndpointLoadBalancerOptions {
  Protocol?: VerifiedAccessEndpointProtocol | string;
  Port?: number;
  LoadBalancerArn?: string;
  SubnetIds?: string[];
}
export interface VerifiedAccessEndpointEniOptions {
  NetworkInterfaceId?: string;
  Protocol?: VerifiedAccessEndpointProtocol | string;
  Port?: number;
}
export declare enum VerifiedAccessEndpointStatusCode {
  active = "active",
  deleted = "deleted",
  deleting = "deleting",
  pending = "pending",
  updating = "updating",
}
export interface VerifiedAccessEndpointStatus {
  Code?: VerifiedAccessEndpointStatusCode | string;
  Message?: string;
}
export interface VerifiedAccessEndpoint {
  VerifiedAccessInstanceId?: string;
  VerifiedAccessGroupId?: string;
  VerifiedAccessEndpointId?: string;
  ApplicationDomain?: string;
  EndpointType?: VerifiedAccessEndpointType | string;
  AttachmentType?: VerifiedAccessEndpointAttachmentType | string;
  DomainCertificateArn?: string;
  EndpointDomain?: string;
  DeviceValidationDomain?: string;
  SecurityGroupIds?: string[];
  LoadBalancerOptions?: VerifiedAccessEndpointLoadBalancerOptions;
  NetworkInterfaceOptions?: VerifiedAccessEndpointEniOptions;
  Status?: VerifiedAccessEndpointStatus;
  Description?: string;
  CreationTime?: string;
  LastUpdatedTime?: string;
  DeletionTime?: string;
  Tags?: Tag[];
}
export interface CreateVerifiedAccessEndpointResult {
  VerifiedAccessEndpoint?: VerifiedAccessEndpoint;
}
export interface CreateVerifiedAccessGroupRequest {
  VerifiedAccessInstanceId: string | undefined;
  Description?: string;
  PolicyDocument?: string;
  TagSpecifications?: TagSpecification[];
  ClientToken?: string;
  DryRun?: boolean;
}
export interface VerifiedAccessGroup {
  VerifiedAccessGroupId?: string;
  VerifiedAccessInstanceId?: string;
  Description?: string;
  Owner?: string;
  VerifiedAccessGroupArn?: string;
  CreationTime?: string;
  LastUpdatedTime?: string;
  DeletionTime?: string;
  Tags?: Tag[];
}
export interface CreateVerifiedAccessGroupResult {
  VerifiedAccessGroup?: VerifiedAccessGroup;
}
export interface CreateVerifiedAccessInstanceRequest {
  Description?: string;
  TagSpecifications?: TagSpecification[];
  ClientToken?: string;
  DryRun?: boolean;
}
export interface CreateVerifiedAccessInstanceResult {
  VerifiedAccessInstance?: VerifiedAccessInstance;
}
export interface CreateVerifiedAccessTrustProviderDeviceOptions {
  TenantId?: string;
}
export interface CreateVerifiedAccessTrustProviderOidcOptions {
  Issuer?: string;
  AuthorizationEndpoint?: string;
  TokenEndpoint?: string;
  UserInfoEndpoint?: string;
  ClientId?: string;
  ClientSecret?: string;
  Scope?: string;
}
export interface CreateVerifiedAccessTrustProviderRequest {
  TrustProviderType: TrustProviderType | string | undefined;
  UserTrustProviderType?: UserTrustProviderType | string;
  DeviceTrustProviderType?: DeviceTrustProviderType | string;
  OidcOptions?: CreateVerifiedAccessTrustProviderOidcOptions;
  DeviceOptions?: CreateVerifiedAccessTrustProviderDeviceOptions;
  PolicyReferenceName: string | undefined;
  Description?: string;
  TagSpecifications?: TagSpecification[];
  ClientToken?: string;
  DryRun?: boolean;
}
export interface CreateVerifiedAccessTrustProviderResult {
  VerifiedAccessTrustProvider?: VerifiedAccessTrustProvider;
}
export interface CreateVolumeRequest {
  AvailabilityZone: string | undefined;
  Encrypted?: boolean;
  Iops?: number;
  KmsKeyId?: string;
  OutpostArn?: string;
  Size?: number;
  SnapshotId?: string;
  VolumeType?: VolumeType | string;
  DryRun?: boolean;
  TagSpecifications?: TagSpecification[];
  MultiAttachEnabled?: boolean;
  Throughput?: number;
  ClientToken?: string;
}
export declare enum VolumeState {
  available = "available",
  creating = "creating",
  deleted = "deleted",
  deleting = "deleting",
  error = "error",
  in_use = "in-use",
}
export interface Volume {
  Attachments?: VolumeAttachment[];
  AvailabilityZone?: string;
  CreateTime?: Date;
  Encrypted?: boolean;
  KmsKeyId?: string;
  OutpostArn?: string;
  Size?: number;
  SnapshotId?: string;
  State?: VolumeState | string;
  VolumeId?: string;
  Iops?: number;
  Tags?: Tag[];
  VolumeType?: VolumeType | string;
  FastRestored?: boolean;
  MultiAttachEnabled?: boolean;
  Throughput?: number;
}
export interface CreateVpcRequest {
  CidrBlock?: string;
  AmazonProvidedIpv6CidrBlock?: boolean;
  Ipv6Pool?: string;
  Ipv6CidrBlock?: string;
  Ipv4IpamPoolId?: string;
  Ipv4NetmaskLength?: number;
  Ipv6IpamPoolId?: string;
  Ipv6NetmaskLength?: number;
  DryRun?: boolean;
  InstanceTenancy?: Tenancy | string;
  Ipv6CidrBlockNetworkBorderGroup?: string;
  TagSpecifications?: TagSpecification[];
}
export interface CreateVpcResult {
  Vpc?: Vpc;
}
export declare enum DnsRecordIpType {
  dualstack = "dualstack",
  ipv4 = "ipv4",
  ipv6 = "ipv6",
  service_defined = "service-defined",
}
export interface DnsOptionsSpecification {
  DnsRecordIpType?: DnsRecordIpType | string;
}
export declare enum IpAddressType {
  dualstack = "dualstack",
  ipv4 = "ipv4",
  ipv6 = "ipv6",
}
export declare enum VpcEndpointType {
  Gateway = "Gateway",
  GatewayLoadBalancer = "GatewayLoadBalancer",
  Interface = "Interface",
}
export interface CreateVpcEndpointRequest {
  DryRun?: boolean;
  VpcEndpointType?: VpcEndpointType | string;
  VpcId: string | undefined;
  ServiceName: string | undefined;
  PolicyDocument?: string;
  RouteTableIds?: string[];
  SubnetIds?: string[];
  SecurityGroupIds?: string[];
  IpAddressType?: IpAddressType | string;
  DnsOptions?: DnsOptionsSpecification;
  ClientToken?: string;
  PrivateDnsEnabled?: boolean;
  TagSpecifications?: TagSpecification[];
}
export interface DnsEntry {
  DnsName?: string;
  HostedZoneId?: string;
}
export interface DnsOptions {
  DnsRecordIpType?: DnsRecordIpType | string;
}
export interface SecurityGroupIdentifier {
  GroupId?: string;
  GroupName?: string;
}
export interface LastError {
  Message?: string;
  Code?: string;
}
export declare enum State {
  Available = "Available",
  Deleted = "Deleted",
  Deleting = "Deleting",
  Expired = "Expired",
  Failed = "Failed",
  Pending = "Pending",
  PendingAcceptance = "PendingAcceptance",
  Rejected = "Rejected",
}
export interface VpcEndpoint {
  VpcEndpointId?: string;
  VpcEndpointType?: VpcEndpointType | string;
  VpcId?: string;
  ServiceName?: string;
  State?: State | string;
  PolicyDocument?: string;
  RouteTableIds?: string[];
  SubnetIds?: string[];
  Groups?: SecurityGroupIdentifier[];
  IpAddressType?: IpAddressType | string;
  DnsOptions?: DnsOptions;
  PrivateDnsEnabled?: boolean;
  RequesterManaged?: boolean;
  NetworkInterfaceIds?: string[];
  DnsEntries?: DnsEntry[];
  CreationTimestamp?: Date;
  Tags?: Tag[];
  OwnerId?: string;
  LastError?: LastError;
}
export interface CreateVpcEndpointResult {
  VpcEndpoint?: VpcEndpoint;
  ClientToken?: string;
}
export interface CreateVpcEndpointConnectionNotificationRequest {
  DryRun?: boolean;
  ServiceId?: string;
  VpcEndpointId?: string;
  ConnectionNotificationArn: string | undefined;
  ConnectionEvents: string[] | undefined;
  ClientToken?: string;
}
export declare enum ConnectionNotificationState {
  Disabled = "Disabled",
  Enabled = "Enabled",
}
export declare enum ConnectionNotificationType {
  Topic = "Topic",
}
export interface ConnectionNotification {
  ConnectionNotificationId?: string;
  ServiceId?: string;
  VpcEndpointId?: string;
  ConnectionNotificationType?: ConnectionNotificationType | string;
  ConnectionNotificationArn?: string;
  ConnectionEvents?: string[];
  ConnectionNotificationState?: ConnectionNotificationState | string;
}
export interface CreateVpcEndpointConnectionNotificationResult {
  ConnectionNotification?: ConnectionNotification;
  ClientToken?: string;
}
export interface CreateVpcEndpointServiceConfigurationRequest {
  DryRun?: boolean;
  AcceptanceRequired?: boolean;
  PrivateDnsName?: string;
  NetworkLoadBalancerArns?: string[];
  GatewayLoadBalancerArns?: string[];
  SupportedIpAddressTypes?: string[];
  ClientToken?: string;
  TagSpecifications?: TagSpecification[];
}
export declare enum PayerResponsibility {
  ServiceOwner = "ServiceOwner",
}
export declare enum DnsNameState {
  Failed = "failed",
  PendingVerification = "pendingVerification",
  Verified = "verified",
}
export interface PrivateDnsNameConfiguration {
  State?: DnsNameState | string;
  Type?: string;
  Value?: string;
  Name?: string;
}
export declare enum ServiceState {
  Available = "Available",
  Deleted = "Deleted",
  Deleting = "Deleting",
  Failed = "Failed",
  Pending = "Pending",
}
export declare enum ServiceType {
  Gateway = "Gateway",
  GatewayLoadBalancer = "GatewayLoadBalancer",
  Interface = "Interface",
}
export interface ServiceTypeDetail {
  ServiceType?: ServiceType | string;
}
export declare enum ServiceConnectivityType {
  ipv4 = "ipv4",
  ipv6 = "ipv6",
}
export interface ServiceConfiguration {
  ServiceType?: ServiceTypeDetail[];
  ServiceId?: string;
  ServiceName?: string;
  ServiceState?: ServiceState | string;
  AvailabilityZones?: string[];
  AcceptanceRequired?: boolean;
  ManagesVpcEndpoints?: boolean;
  NetworkLoadBalancerArns?: string[];
  GatewayLoadBalancerArns?: string[];
  SupportedIpAddressTypes?: (ServiceConnectivityType | string)[];
  BaseEndpointDnsNames?: string[];
  PrivateDnsName?: string;
  PrivateDnsNameConfiguration?: PrivateDnsNameConfiguration;
  PayerResponsibility?: PayerResponsibility | string;
  Tags?: Tag[];
}
export interface CreateVpcEndpointServiceConfigurationResult {
  ServiceConfiguration?: ServiceConfiguration;
  ClientToken?: string;
}
export interface CreateVpcPeeringConnectionRequest {
  DryRun?: boolean;
  PeerOwnerId?: string;
  PeerVpcId?: string;
  VpcId?: string;
  PeerRegion?: string;
  TagSpecifications?: TagSpecification[];
}
export interface CreateVpcPeeringConnectionResult {
  VpcPeeringConnection?: VpcPeeringConnection;
}
export declare enum TunnelInsideIpVersion {
  ipv4 = "ipv4",
  ipv6 = "ipv6",
}
export interface IKEVersionsRequestListValue {
  Value?: string;
}
export interface CloudWatchLogOptionsSpecification {
  LogEnabled?: boolean;
  LogGroupArn?: string;
  LogOutputFormat?: string;
}
export interface VpnTunnelLogOptionsSpecification {
  CloudWatchLogOptions?: CloudWatchLogOptionsSpecification;
}
export interface Phase1DHGroupNumbersRequestListValue {
  Value?: number;
}
export interface Phase1EncryptionAlgorithmsRequestListValue {
  Value?: string;
}
export interface Phase1IntegrityAlgorithmsRequestListValue {
  Value?: string;
}
export interface Phase2DHGroupNumbersRequestListValue {
  Value?: number;
}
export interface Phase2EncryptionAlgorithmsRequestListValue {
  Value?: string;
}
export interface Phase2IntegrityAlgorithmsRequestListValue {
  Value?: string;
}
export interface VpnTunnelOptionsSpecification {
  TunnelInsideCidr?: string;
  TunnelInsideIpv6Cidr?: string;
  PreSharedKey?: string;
  Phase1LifetimeSeconds?: number;
  Phase2LifetimeSeconds?: number;
  RekeyMarginTimeSeconds?: number;
  RekeyFuzzPercentage?: number;
  ReplayWindowSize?: number;
  DPDTimeoutSeconds?: number;
  DPDTimeoutAction?: string;
  Phase1EncryptionAlgorithms?: Phase1EncryptionAlgorithmsRequestListValue[];
  Phase2EncryptionAlgorithms?: Phase2EncryptionAlgorithmsRequestListValue[];
  Phase1IntegrityAlgorithms?: Phase1IntegrityAlgorithmsRequestListValue[];
  Phase2IntegrityAlgorithms?: Phase2IntegrityAlgorithmsRequestListValue[];
  Phase1DHGroupNumbers?: Phase1DHGroupNumbersRequestListValue[];
  Phase2DHGroupNumbers?: Phase2DHGroupNumbersRequestListValue[];
  IKEVersions?: IKEVersionsRequestListValue[];
  StartupAction?: string;
  LogOptions?: VpnTunnelLogOptionsSpecification;
}
export interface VpnConnectionOptionsSpecification {
  EnableAcceleration?: boolean;
  StaticRoutesOnly?: boolean;
  TunnelInsideIpVersion?: TunnelInsideIpVersion | string;
  TunnelOptions?: VpnTunnelOptionsSpecification[];
  LocalIpv4NetworkCidr?: string;
  RemoteIpv4NetworkCidr?: string;
  LocalIpv6NetworkCidr?: string;
  RemoteIpv6NetworkCidr?: string;
  OutsideIpAddressType?: string;
  TransportTransitGatewayAttachmentId?: string;
}
export interface CreateVpnConnectionRequest {
  CustomerGatewayId: string | undefined;
  Type: string | undefined;
  VpnGatewayId?: string;
  TransitGatewayId?: string;
  DryRun?: boolean;
  Options?: VpnConnectionOptionsSpecification;
  TagSpecifications?: TagSpecification[];
}
export declare enum GatewayAssociationState {
  associated = "associated",
  associating = "associating",
  disassociating = "disassociating",
  not_associated = "not-associated",
}
export interface IKEVersionsListValue {
  Value?: string;
}
export interface CloudWatchLogOptions {
  LogEnabled?: boolean;
  LogGroupArn?: string;
  LogOutputFormat?: string;
}
export interface VpnTunnelLogOptions {
  CloudWatchLogOptions?: CloudWatchLogOptions;
}
export interface Phase1DHGroupNumbersListValue {
  Value?: number;
}
export interface Phase1EncryptionAlgorithmsListValue {
  Value?: string;
}
export interface Phase1IntegrityAlgorithmsListValue {
  Value?: string;
}
export interface Phase2DHGroupNumbersListValue {
  Value?: number;
}
export interface Phase2EncryptionAlgorithmsListValue {
  Value?: string;
}
export interface Phase2IntegrityAlgorithmsListValue {
  Value?: string;
}
export interface TunnelOption {
  OutsideIpAddress?: string;
  TunnelInsideCidr?: string;
  TunnelInsideIpv6Cidr?: string;
  PreSharedKey?: string;
  Phase1LifetimeSeconds?: number;
  Phase2LifetimeSeconds?: number;
  RekeyMarginTimeSeconds?: number;
  RekeyFuzzPercentage?: number;
  ReplayWindowSize?: number;
  DpdTimeoutSeconds?: number;
  DpdTimeoutAction?: string;
  Phase1EncryptionAlgorithms?: Phase1EncryptionAlgorithmsListValue[];
  Phase2EncryptionAlgorithms?: Phase2EncryptionAlgorithmsListValue[];
  Phase1IntegrityAlgorithms?: Phase1IntegrityAlgorithmsListValue[];
  Phase2IntegrityAlgorithms?: Phase2IntegrityAlgorithmsListValue[];
  Phase1DHGroupNumbers?: Phase1DHGroupNumbersListValue[];
  Phase2DHGroupNumbers?: Phase2DHGroupNumbersListValue[];
  IkeVersions?: IKEVersionsListValue[];
  StartupAction?: string;
  LogOptions?: VpnTunnelLogOptions;
}
export interface VpnConnectionOptions {
  EnableAcceleration?: boolean;
  StaticRoutesOnly?: boolean;
  LocalIpv4NetworkCidr?: string;
  RemoteIpv4NetworkCidr?: string;
  LocalIpv6NetworkCidr?: string;
  RemoteIpv6NetworkCidr?: string;
  OutsideIpAddressType?: string;
  TransportTransitGatewayAttachmentId?: string;
  TunnelInsideIpVersion?: TunnelInsideIpVersion | string;
  TunnelOptions?: TunnelOption[];
}
export declare enum VpnStaticRouteSource {
  Static = "Static",
}
export declare enum VpnState {
  available = "available",
  deleted = "deleted",
  deleting = "deleting",
  pending = "pending",
}
export interface VpnStaticRoute {
  DestinationCidrBlock?: string;
  Source?: VpnStaticRouteSource | string;
  State?: VpnState | string;
}
export declare enum TelemetryStatus {
  DOWN = "DOWN",
  UP = "UP",
}
export interface VgwTelemetry {
  AcceptedRouteCount?: number;
  LastStatusChange?: Date;
  OutsideIpAddress?: string;
  Status?: TelemetryStatus | string;
  StatusMessage?: string;
  CertificateArn?: string;
}
export interface VpnConnection {
  CustomerGatewayConfiguration?: string;
  CustomerGatewayId?: string;
  Category?: string;
  State?: VpnState | string;
  Type?: GatewayType | string;
  VpnConnectionId?: string;
  VpnGatewayId?: string;
  TransitGatewayId?: string;
  CoreNetworkArn?: string;
  CoreNetworkAttachmentArn?: string;
  GatewayAssociationState?: GatewayAssociationState | string;
  Options?: VpnConnectionOptions;
  Routes?: VpnStaticRoute[];
  Tags?: Tag[];
  VgwTelemetry?: VgwTelemetry[];
}
export interface CreateVpnConnectionResult {
  VpnConnection?: VpnConnection;
}
export interface CreateVpnConnectionRouteRequest {
  DestinationCidrBlock: string | undefined;
  VpnConnectionId: string | undefined;
}
export interface CreateVpnGatewayRequest {
  AvailabilityZone?: string;
  Type: GatewayType | string | undefined;
  TagSpecifications?: TagSpecification[];
  AmazonSideAsn?: number;
  DryRun?: boolean;
}
export interface VpnGateway {
  AvailabilityZone?: string;
  State?: VpnState | string;
  Type?: GatewayType | string;
  VpcAttachments?: VpcAttachment[];
  VpnGatewayId?: string;
  AmazonSideAsn?: number;
  Tags?: Tag[];
}
export interface CreateVpnGatewayResult {
  VpnGateway?: VpnGateway;
}
export interface DeleteCarrierGatewayRequest {
  CarrierGatewayId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteCarrierGatewayResult {
  CarrierGateway?: CarrierGateway;
}
export interface DeleteClientVpnEndpointRequest {
  ClientVpnEndpointId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteClientVpnEndpointResult {
  Status?: ClientVpnEndpointStatus;
}
export interface DeleteClientVpnRouteRequest {
  ClientVpnEndpointId: string | undefined;
  TargetVpcSubnetId?: string;
  DestinationCidrBlock: string | undefined;
  DryRun?: boolean;
}
export interface DeleteClientVpnRouteResult {
  Status?: ClientVpnRouteStatus;
}
export interface DeleteCoipCidrRequest {
  Cidr: string | undefined;
  CoipPoolId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteCoipCidrResult {
  CoipCidr?: CoipCidr;
}
export interface DeleteCoipPoolRequest {
  CoipPoolId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteCoipPoolResult {
  CoipPool?: CoipPool;
}
export interface DeleteCustomerGatewayRequest {
  CustomerGatewayId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteDhcpOptionsRequest {
  DhcpOptionsId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteEgressOnlyInternetGatewayRequest {
  DryRun?: boolean;
  EgressOnlyInternetGatewayId: string | undefined;
}
export interface DeleteEgressOnlyInternetGatewayResult {
  ReturnCode?: boolean;
}
export interface DeleteFleetsRequest {
  DryRun?: boolean;
  FleetIds: string[] | undefined;
  TerminateInstances: boolean | undefined;
}
export declare enum FleetStateCode {
  ACTIVE = "active",
  DELETED = "deleted",
  DELETED_RUNNING = "deleted_running",
  DELETED_TERMINATING_INSTANCES = "deleted_terminating",
  FAILED = "failed",
  MODIFYING = "modifying",
  SUBMITTED = "submitted",
}
export interface DeleteFleetSuccessItem {
  CurrentFleetState?: FleetStateCode | string;
  PreviousFleetState?: FleetStateCode | string;
  FleetId?: string;
}
export declare enum DeleteFleetErrorCode {
  FLEET_ID_DOES_NOT_EXIST = "fleetIdDoesNotExist",
  FLEET_ID_MALFORMED = "fleetIdMalformed",
  FLEET_NOT_IN_DELETABLE_STATE = "fleetNotInDeletableState",
  UNEXPECTED_ERROR = "unexpectedError",
}
export interface DeleteFleetError {
  Code?: DeleteFleetErrorCode | string;
  Message?: string;
}
export interface DeleteFleetErrorItem {
  Error?: DeleteFleetError;
  FleetId?: string;
}
export interface DeleteFleetsResult {
  SuccessfulFleetDeletions?: DeleteFleetSuccessItem[];
  UnsuccessfulFleetDeletions?: DeleteFleetErrorItem[];
}
export interface DeleteFlowLogsRequest {
  DryRun?: boolean;
  FlowLogIds: string[] | undefined;
}
export interface DeleteFlowLogsResult {
  Unsuccessful?: UnsuccessfulItem[];
}
export interface DeleteFpgaImageRequest {
  DryRun?: boolean;
  FpgaImageId: string | undefined;
}
export interface DeleteFpgaImageResult {
  Return?: boolean;
}
export interface DeleteInstanceEventWindowRequest {
  DryRun?: boolean;
  ForceDelete?: boolean;
  InstanceEventWindowId: string | undefined;
}
export interface InstanceEventWindowStateChange {
  InstanceEventWindowId?: string;
  State?: InstanceEventWindowState | string;
}
export interface DeleteInstanceEventWindowResult {
  InstanceEventWindowState?: InstanceEventWindowStateChange;
}
export interface DeleteInternetGatewayRequest {
  DryRun?: boolean;
  InternetGatewayId: string | undefined;
}
export interface DeleteIpamRequest {
  DryRun?: boolean;
  IpamId: string | undefined;
  Cascade?: boolean;
}
export interface DeleteIpamResult {
  Ipam?: Ipam;
}
export interface DeleteIpamPoolRequest {
  DryRun?: boolean;
  IpamPoolId: string | undefined;
}
export interface DeleteIpamPoolResult {
  IpamPool?: IpamPool;
}
export interface DeleteIpamScopeRequest {
  DryRun?: boolean;
  IpamScopeId: string | undefined;
}
export interface DeleteIpamScopeResult {
  IpamScope?: IpamScope;
}
export interface DeleteKeyPairRequest {
  KeyName?: string;
  KeyPairId?: string;
  DryRun?: boolean;
}
export interface DeleteLaunchTemplateRequest {
  DryRun?: boolean;
  LaunchTemplateId?: string;
  LaunchTemplateName?: string;
}
export interface DeleteLaunchTemplateResult {
  LaunchTemplate?: LaunchTemplate;
}
export interface DeleteLaunchTemplateVersionsRequest {
  DryRun?: boolean;
  LaunchTemplateId?: string;
  LaunchTemplateName?: string;
  Versions: string[] | undefined;
}
export interface DeleteLaunchTemplateVersionsResponseSuccessItem {
  LaunchTemplateId?: string;
  LaunchTemplateName?: string;
  VersionNumber?: number;
}
export declare enum LaunchTemplateErrorCode {
  LAUNCH_TEMPLATE_ID_DOES_NOT_EXIST = "launchTemplateIdDoesNotExist",
  LAUNCH_TEMPLATE_ID_MALFORMED = "launchTemplateIdMalformed",
  LAUNCH_TEMPLATE_NAME_DOES_NOT_EXIST = "launchTemplateNameDoesNotExist",
  LAUNCH_TEMPLATE_NAME_MALFORMED = "launchTemplateNameMalformed",
  LAUNCH_TEMPLATE_VERSION_DOES_NOT_EXIST = "launchTemplateVersionDoesNotExist",
  UNEXPECTED_ERROR = "unexpectedError",
}
export interface ResponseError {
  Code?: LaunchTemplateErrorCode | string;
  Message?: string;
}
export interface DeleteLaunchTemplateVersionsResponseErrorItem {
  LaunchTemplateId?: string;
  LaunchTemplateName?: string;
  VersionNumber?: number;
  ResponseError?: ResponseError;
}
export interface DeleteLaunchTemplateVersionsResult {
  SuccessfullyDeletedLaunchTemplateVersions?: DeleteLaunchTemplateVersionsResponseSuccessItem[];
  UnsuccessfullyDeletedLaunchTemplateVersions?: DeleteLaunchTemplateVersionsResponseErrorItem[];
}
export interface DeleteLocalGatewayRouteRequest {
  DestinationCidrBlock: string | undefined;
  LocalGatewayRouteTableId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteLocalGatewayRouteResult {
  Route?: LocalGatewayRoute;
}
export interface DeleteLocalGatewayRouteTableRequest {
  LocalGatewayRouteTableId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteLocalGatewayRouteTableResult {
  LocalGatewayRouteTable?: LocalGatewayRouteTable;
}
export interface DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest {
  LocalGatewayRouteTableVirtualInterfaceGroupAssociationId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult {
  LocalGatewayRouteTableVirtualInterfaceGroupAssociation?: LocalGatewayRouteTableVirtualInterfaceGroupAssociation;
}
export interface DeleteLocalGatewayRouteTableVpcAssociationRequest {
  LocalGatewayRouteTableVpcAssociationId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteLocalGatewayRouteTableVpcAssociationResult {
  LocalGatewayRouteTableVpcAssociation?: LocalGatewayRouteTableVpcAssociation;
}
export interface DeleteManagedPrefixListRequest {
  DryRun?: boolean;
  PrefixListId: string | undefined;
}
export interface DeleteManagedPrefixListResult {
  PrefixList?: ManagedPrefixList;
}
export interface DeleteNatGatewayRequest {
  DryRun?: boolean;
  NatGatewayId: string | undefined;
}
export interface DeleteNatGatewayResult {
  NatGatewayId?: string;
}
export interface DeleteNetworkAclRequest {
  DryRun?: boolean;
  NetworkAclId: string | undefined;
}
export interface DeleteNetworkAclEntryRequest {
  DryRun?: boolean;
  Egress: boolean | undefined;
  NetworkAclId: string | undefined;
  RuleNumber: number | undefined;
}
export interface DeleteNetworkInsightsAccessScopeRequest {
  DryRun?: boolean;
  NetworkInsightsAccessScopeId: string | undefined;
}
export interface DeleteNetworkInsightsAccessScopeResult {
  NetworkInsightsAccessScopeId?: string;
}
export interface DeleteNetworkInsightsAccessScopeAnalysisRequest {
  NetworkInsightsAccessScopeAnalysisId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteNetworkInsightsAccessScopeAnalysisResult {
  NetworkInsightsAccessScopeAnalysisId?: string;
}
export interface DeleteNetworkInsightsAnalysisRequest {
  DryRun?: boolean;
  NetworkInsightsAnalysisId: string | undefined;
}
export interface DeleteNetworkInsightsAnalysisResult {
  NetworkInsightsAnalysisId?: string;
}
export interface DeleteNetworkInsightsPathRequest {
  DryRun?: boolean;
  NetworkInsightsPathId: string | undefined;
}
export interface DeleteNetworkInsightsPathResult {
  NetworkInsightsPathId?: string;
}
export interface DeleteNetworkInterfaceRequest {
  DryRun?: boolean;
  NetworkInterfaceId: string | undefined;
}
export interface DeleteNetworkInterfacePermissionRequest {
  NetworkInterfacePermissionId: string | undefined;
  Force?: boolean;
  DryRun?: boolean;
}
export interface DeleteNetworkInterfacePermissionResult {
  Return?: boolean;
}
export interface DeletePlacementGroupRequest {
  DryRun?: boolean;
  GroupName: string | undefined;
}
export interface DeletePublicIpv4PoolRequest {
  DryRun?: boolean;
  PoolId: string | undefined;
}
export interface DeletePublicIpv4PoolResult {
  ReturnValue?: boolean;
}
export interface DeleteQueuedReservedInstancesRequest {
  DryRun?: boolean;
  ReservedInstancesIds: string[] | undefined;
}
export declare enum DeleteQueuedReservedInstancesErrorCode {
  RESERVED_INSTANCES_ID_INVALID = "reserved-instances-id-invalid",
  RESERVED_INSTANCES_NOT_IN_QUEUED_STATE = "reserved-instances-not-in-queued-state",
  UNEXPECTED_ERROR = "unexpected-error",
}
export interface DeleteQueuedReservedInstancesError {
  Code?: DeleteQueuedReservedInstancesErrorCode | string;
  Message?: string;
}
export interface FailedQueuedPurchaseDeletion {
  Error?: DeleteQueuedReservedInstancesError;
  ReservedInstancesId?: string;
}
export interface SuccessfulQueuedPurchaseDeletion {
  ReservedInstancesId?: string;
}
export interface DeleteQueuedReservedInstancesResult {
  SuccessfulQueuedPurchaseDeletions?: SuccessfulQueuedPurchaseDeletion[];
  FailedQueuedPurchaseDeletions?: FailedQueuedPurchaseDeletion[];
}
export interface DeleteRouteRequest {
  DestinationCidrBlock?: string;
  DestinationIpv6CidrBlock?: string;
  DestinationPrefixListId?: string;
  DryRun?: boolean;
  RouteTableId: string | undefined;
}
export interface DeleteRouteTableRequest {
  DryRun?: boolean;
  RouteTableId: string | undefined;
}
export interface DeleteSecurityGroupRequest {
  GroupId?: string;
  GroupName?: string;
  DryRun?: boolean;
}
export interface DeleteSnapshotRequest {
  SnapshotId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteSpotDatafeedSubscriptionRequest {
  DryRun?: boolean;
}
export interface DeleteSubnetRequest {
  SubnetId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteSubnetCidrReservationRequest {
  SubnetCidrReservationId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteSubnetCidrReservationResult {
  DeletedSubnetCidrReservation?: SubnetCidrReservation;
}
export interface DeleteTagsRequest {
  DryRun?: boolean;
  Resources: string[] | undefined;
  Tags?: Tag[];
}
export interface DeleteTrafficMirrorFilterRequest {
  TrafficMirrorFilterId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTrafficMirrorFilterResult {
  TrafficMirrorFilterId?: string;
}
export interface DeleteTrafficMirrorFilterRuleRequest {
  TrafficMirrorFilterRuleId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTrafficMirrorFilterRuleResult {
  TrafficMirrorFilterRuleId?: string;
}
export interface DeleteTrafficMirrorSessionRequest {
  TrafficMirrorSessionId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTrafficMirrorSessionResult {
  TrafficMirrorSessionId?: string;
}
export interface DeleteTrafficMirrorTargetRequest {
  TrafficMirrorTargetId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTrafficMirrorTargetResult {
  TrafficMirrorTargetId?: string;
}
export interface DeleteTransitGatewayRequest {
  TransitGatewayId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTransitGatewayResult {
  TransitGateway?: TransitGateway;
}
export interface DeleteTransitGatewayConnectRequest {
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTransitGatewayConnectResult {
  TransitGatewayConnect?: TransitGatewayConnect;
}
export interface DeleteTransitGatewayConnectPeerRequest {
  TransitGatewayConnectPeerId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTransitGatewayConnectPeerResult {
  TransitGatewayConnectPeer?: TransitGatewayConnectPeer;
}
export interface DeleteTransitGatewayMulticastDomainRequest {
  TransitGatewayMulticastDomainId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTransitGatewayMulticastDomainResult {
  TransitGatewayMulticastDomain?: TransitGatewayMulticastDomain;
}
export interface DeleteTransitGatewayPeeringAttachmentRequest {
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTransitGatewayPeeringAttachmentResult {
  TransitGatewayPeeringAttachment?: TransitGatewayPeeringAttachment;
}
export interface DeleteTransitGatewayPolicyTableRequest {
  TransitGatewayPolicyTableId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTransitGatewayPolicyTableResult {
  TransitGatewayPolicyTable?: TransitGatewayPolicyTable;
}
export interface DeleteTransitGatewayPrefixListReferenceRequest {
  TransitGatewayRouteTableId: string | undefined;
  PrefixListId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTransitGatewayPrefixListReferenceResult {
  TransitGatewayPrefixListReference?: TransitGatewayPrefixListReference;
}
export interface DeleteTransitGatewayRouteRequest {
  TransitGatewayRouteTableId: string | undefined;
  DestinationCidrBlock: string | undefined;
  DryRun?: boolean;
}
export declare const SnapshotInfoFilterSensitiveLog: (obj: SnapshotInfo) => any;
export declare const CreateSnapshotsResultFilterSensitiveLog: (
  obj: CreateSnapshotsResult
) => any;
export declare const CreateSpotDatafeedSubscriptionRequestFilterSensitiveLog: (
  obj: CreateSpotDatafeedSubscriptionRequest
) => any;
export declare const SpotInstanceStateFaultFilterSensitiveLog: (
  obj: SpotInstanceStateFault
) => any;
export declare const SpotDatafeedSubscriptionFilterSensitiveLog: (
  obj: SpotDatafeedSubscription
) => any;
export declare const CreateSpotDatafeedSubscriptionResultFilterSensitiveLog: (
  obj: CreateSpotDatafeedSubscriptionResult
) => any;
export declare const S3ObjectTagFilterSensitiveLog: (obj: S3ObjectTag) => any;
export declare const CreateStoreImageTaskRequestFilterSensitiveLog: (
  obj: CreateStoreImageTaskRequest
) => any;
export declare const CreateStoreImageTaskResultFilterSensitiveLog: (
  obj: CreateStoreImageTaskResult
) => any;
export declare const CreateSubnetRequestFilterSensitiveLog: (
  obj: CreateSubnetRequest
) => any;
export declare const CreateSubnetResultFilterSensitiveLog: (
  obj: CreateSubnetResult
) => any;
export declare const CreateSubnetCidrReservationRequestFilterSensitiveLog: (
  obj: CreateSubnetCidrReservationRequest
) => any;
export declare const SubnetCidrReservationFilterSensitiveLog: (
  obj: SubnetCidrReservation
) => any;
export declare const CreateSubnetCidrReservationResultFilterSensitiveLog: (
  obj: CreateSubnetCidrReservationResult
) => any;
export declare const CreateTagsRequestFilterSensitiveLog: (
  obj: CreateTagsRequest
) => any;
export declare const CreateTrafficMirrorFilterRequestFilterSensitiveLog: (
  obj: CreateTrafficMirrorFilterRequest
) => any;
export declare const TrafficMirrorPortRangeFilterSensitiveLog: (
  obj: TrafficMirrorPortRange
) => any;
export declare const TrafficMirrorFilterRuleFilterSensitiveLog: (
  obj: TrafficMirrorFilterRule
) => any;
export declare const TrafficMirrorFilterFilterSensitiveLog: (
  obj: TrafficMirrorFilter
) => any;
export declare const CreateTrafficMirrorFilterResultFilterSensitiveLog: (
  obj: CreateTrafficMirrorFilterResult
) => any;
export declare const TrafficMirrorPortRangeRequestFilterSensitiveLog: (
  obj: TrafficMirrorPortRangeRequest
) => any;
export declare const CreateTrafficMirrorFilterRuleRequestFilterSensitiveLog: (
  obj: CreateTrafficMirrorFilterRuleRequest
) => any;
export declare const CreateTrafficMirrorFilterRuleResultFilterSensitiveLog: (
  obj: CreateTrafficMirrorFilterRuleResult
) => any;
export declare const CreateTrafficMirrorSessionRequestFilterSensitiveLog: (
  obj: CreateTrafficMirrorSessionRequest
) => any;
export declare const TrafficMirrorSessionFilterSensitiveLog: (
  obj: TrafficMirrorSession
) => any;
export declare const CreateTrafficMirrorSessionResultFilterSensitiveLog: (
  obj: CreateTrafficMirrorSessionResult
) => any;
export declare const CreateTrafficMirrorTargetRequestFilterSensitiveLog: (
  obj: CreateTrafficMirrorTargetRequest
) => any;
export declare const TrafficMirrorTargetFilterSensitiveLog: (
  obj: TrafficMirrorTarget
) => any;
export declare const CreateTrafficMirrorTargetResultFilterSensitiveLog: (
  obj: CreateTrafficMirrorTargetResult
) => any;
export declare const TransitGatewayRequestOptionsFilterSensitiveLog: (
  obj: TransitGatewayRequestOptions
) => any;
export declare const CreateTransitGatewayRequestFilterSensitiveLog: (
  obj: CreateTransitGatewayRequest
) => any;
export declare const TransitGatewayOptionsFilterSensitiveLog: (
  obj: TransitGatewayOptions
) => any;
export declare const TransitGatewayFilterSensitiveLog: (
  obj: TransitGateway
) => any;
export declare const CreateTransitGatewayResultFilterSensitiveLog: (
  obj: CreateTransitGatewayResult
) => any;
export declare const CreateTransitGatewayConnectRequestOptionsFilterSensitiveLog: (
  obj: CreateTransitGatewayConnectRequestOptions
) => any;
export declare const CreateTransitGatewayConnectRequestFilterSensitiveLog: (
  obj: CreateTransitGatewayConnectRequest
) => any;
export declare const TransitGatewayConnectOptionsFilterSensitiveLog: (
  obj: TransitGatewayConnectOptions
) => any;
export declare const TransitGatewayConnectFilterSensitiveLog: (
  obj: TransitGatewayConnect
) => any;
export declare const CreateTransitGatewayConnectResultFilterSensitiveLog: (
  obj: CreateTransitGatewayConnectResult
) => any;
export declare const TransitGatewayConnectRequestBgpOptionsFilterSensitiveLog: (
  obj: TransitGatewayConnectRequestBgpOptions
) => any;
export declare const CreateTransitGatewayConnectPeerRequestFilterSensitiveLog: (
  obj: CreateTransitGatewayConnectPeerRequest
) => any;
export declare const TransitGatewayAttachmentBgpConfigurationFilterSensitiveLog: (
  obj: TransitGatewayAttachmentBgpConfiguration
) => any;
export declare const TransitGatewayConnectPeerConfigurationFilterSensitiveLog: (
  obj: TransitGatewayConnectPeerConfiguration
) => any;
export declare const TransitGatewayConnectPeerFilterSensitiveLog: (
  obj: TransitGatewayConnectPeer
) => any;
export declare const CreateTransitGatewayConnectPeerResultFilterSensitiveLog: (
  obj: CreateTransitGatewayConnectPeerResult
) => any;
export declare const CreateTransitGatewayMulticastDomainRequestOptionsFilterSensitiveLog: (
  obj: CreateTransitGatewayMulticastDomainRequestOptions
) => any;
export declare const CreateTransitGatewayMulticastDomainRequestFilterSensitiveLog: (
  obj: CreateTransitGatewayMulticastDomainRequest
) => any;
export declare const TransitGatewayMulticastDomainOptionsFilterSensitiveLog: (
  obj: TransitGatewayMulticastDomainOptions
) => any;
export declare const TransitGatewayMulticastDomainFilterSensitiveLog: (
  obj: TransitGatewayMulticastDomain
) => any;
export declare const CreateTransitGatewayMulticastDomainResultFilterSensitiveLog: (
  obj: CreateTransitGatewayMulticastDomainResult
) => any;
export declare const CreateTransitGatewayPeeringAttachmentRequestOptionsFilterSensitiveLog: (
  obj: CreateTransitGatewayPeeringAttachmentRequestOptions
) => any;
export declare const CreateTransitGatewayPeeringAttachmentRequestFilterSensitiveLog: (
  obj: CreateTransitGatewayPeeringAttachmentRequest
) => any;
export declare const CreateTransitGatewayPeeringAttachmentResultFilterSensitiveLog: (
  obj: CreateTransitGatewayPeeringAttachmentResult
) => any;
export declare const CreateTransitGatewayPolicyTableRequestFilterSensitiveLog: (
  obj: CreateTransitGatewayPolicyTableRequest
) => any;
export declare const TransitGatewayPolicyTableFilterSensitiveLog: (
  obj: TransitGatewayPolicyTable
) => any;
export declare const CreateTransitGatewayPolicyTableResultFilterSensitiveLog: (
  obj: CreateTransitGatewayPolicyTableResult
) => any;
export declare const CreateTransitGatewayPrefixListReferenceRequestFilterSensitiveLog: (
  obj: CreateTransitGatewayPrefixListReferenceRequest
) => any;
export declare const TransitGatewayPrefixListAttachmentFilterSensitiveLog: (
  obj: TransitGatewayPrefixListAttachment
) => any;
export declare const TransitGatewayPrefixListReferenceFilterSensitiveLog: (
  obj: TransitGatewayPrefixListReference
) => any;
export declare const CreateTransitGatewayPrefixListReferenceResultFilterSensitiveLog: (
  obj: CreateTransitGatewayPrefixListReferenceResult
) => any;
export declare const CreateTransitGatewayRouteRequestFilterSensitiveLog: (
  obj: CreateTransitGatewayRouteRequest
) => any;
export declare const TransitGatewayRouteAttachmentFilterSensitiveLog: (
  obj: TransitGatewayRouteAttachment
) => any;
export declare const TransitGatewayRouteFilterSensitiveLog: (
  obj: TransitGatewayRoute
) => any;
export declare const CreateTransitGatewayRouteResultFilterSensitiveLog: (
  obj: CreateTransitGatewayRouteResult
) => any;
export declare const CreateTransitGatewayRouteTableRequestFilterSensitiveLog: (
  obj: CreateTransitGatewayRouteTableRequest
) => any;
export declare const TransitGatewayRouteTableFilterSensitiveLog: (
  obj: TransitGatewayRouteTable
) => any;
export declare const CreateTransitGatewayRouteTableResultFilterSensitiveLog: (
  obj: CreateTransitGatewayRouteTableResult
) => any;
export declare const CreateTransitGatewayRouteTableAnnouncementRequestFilterSensitiveLog: (
  obj: CreateTransitGatewayRouteTableAnnouncementRequest
) => any;
export declare const TransitGatewayRouteTableAnnouncementFilterSensitiveLog: (
  obj: TransitGatewayRouteTableAnnouncement
) => any;
export declare const CreateTransitGatewayRouteTableAnnouncementResultFilterSensitiveLog: (
  obj: CreateTransitGatewayRouteTableAnnouncementResult
) => any;
export declare const CreateTransitGatewayVpcAttachmentRequestOptionsFilterSensitiveLog: (
  obj: CreateTransitGatewayVpcAttachmentRequestOptions
) => any;
export declare const CreateTransitGatewayVpcAttachmentRequestFilterSensitiveLog: (
  obj: CreateTransitGatewayVpcAttachmentRequest
) => any;
export declare const CreateTransitGatewayVpcAttachmentResultFilterSensitiveLog: (
  obj: CreateTransitGatewayVpcAttachmentResult
) => any;
export declare const CreateVerifiedAccessEndpointLoadBalancerOptionsFilterSensitiveLog: (
  obj: CreateVerifiedAccessEndpointLoadBalancerOptions
) => any;
export declare const CreateVerifiedAccessEndpointEniOptionsFilterSensitiveLog: (
  obj: CreateVerifiedAccessEndpointEniOptions
) => any;
export declare const CreateVerifiedAccessEndpointRequestFilterSensitiveLog: (
  obj: CreateVerifiedAccessEndpointRequest
) => any;
export declare const VerifiedAccessEndpointLoadBalancerOptionsFilterSensitiveLog: (
  obj: VerifiedAccessEndpointLoadBalancerOptions
) => any;
export declare const VerifiedAccessEndpointEniOptionsFilterSensitiveLog: (
  obj: VerifiedAccessEndpointEniOptions
) => any;
export declare const VerifiedAccessEndpointStatusFilterSensitiveLog: (
  obj: VerifiedAccessEndpointStatus
) => any;
export declare const VerifiedAccessEndpointFilterSensitiveLog: (
  obj: VerifiedAccessEndpoint
) => any;
export declare const CreateVerifiedAccessEndpointResultFilterSensitiveLog: (
  obj: CreateVerifiedAccessEndpointResult
) => any;
export declare const CreateVerifiedAccessGroupRequestFilterSensitiveLog: (
  obj: CreateVerifiedAccessGroupRequest
) => any;
export declare const VerifiedAccessGroupFilterSensitiveLog: (
  obj: VerifiedAccessGroup
) => any;
export declare const CreateVerifiedAccessGroupResultFilterSensitiveLog: (
  obj: CreateVerifiedAccessGroupResult
) => any;
export declare const CreateVerifiedAccessInstanceRequestFilterSensitiveLog: (
  obj: CreateVerifiedAccessInstanceRequest
) => any;
export declare const CreateVerifiedAccessInstanceResultFilterSensitiveLog: (
  obj: CreateVerifiedAccessInstanceResult
) => any;
export declare const CreateVerifiedAccessTrustProviderDeviceOptionsFilterSensitiveLog: (
  obj: CreateVerifiedAccessTrustProviderDeviceOptions
) => any;
export declare const CreateVerifiedAccessTrustProviderOidcOptionsFilterSensitiveLog: (
  obj: CreateVerifiedAccessTrustProviderOidcOptions
) => any;
export declare const CreateVerifiedAccessTrustProviderRequestFilterSensitiveLog: (
  obj: CreateVerifiedAccessTrustProviderRequest
) => any;
export declare const CreateVerifiedAccessTrustProviderResultFilterSensitiveLog: (
  obj: CreateVerifiedAccessTrustProviderResult
) => any;
export declare const CreateVolumeRequestFilterSensitiveLog: (
  obj: CreateVolumeRequest
) => any;
export declare const VolumeFilterSensitiveLog: (obj: Volume) => any;
export declare const CreateVpcRequestFilterSensitiveLog: (
  obj: CreateVpcRequest
) => any;
export declare const CreateVpcResultFilterSensitiveLog: (
  obj: CreateVpcResult
) => any;
export declare const DnsOptionsSpecificationFilterSensitiveLog: (
  obj: DnsOptionsSpecification
) => any;
export declare const CreateVpcEndpointRequestFilterSensitiveLog: (
  obj: CreateVpcEndpointRequest
) => any;
export declare const DnsEntryFilterSensitiveLog: (obj: DnsEntry) => any;
export declare const DnsOptionsFilterSensitiveLog: (obj: DnsOptions) => any;
export declare const SecurityGroupIdentifierFilterSensitiveLog: (
  obj: SecurityGroupIdentifier
) => any;
export declare const LastErrorFilterSensitiveLog: (obj: LastError) => any;
export declare const VpcEndpointFilterSensitiveLog: (obj: VpcEndpoint) => any;
export declare const CreateVpcEndpointResultFilterSensitiveLog: (
  obj: CreateVpcEndpointResult
) => any;
export declare const CreateVpcEndpointConnectionNotificationRequestFilterSensitiveLog: (
  obj: CreateVpcEndpointConnectionNotificationRequest
) => any;
export declare const ConnectionNotificationFilterSensitiveLog: (
  obj: ConnectionNotification
) => any;
export declare const CreateVpcEndpointConnectionNotificationResultFilterSensitiveLog: (
  obj: CreateVpcEndpointConnectionNotificationResult
) => any;
export declare const CreateVpcEndpointServiceConfigurationRequestFilterSensitiveLog: (
  obj: CreateVpcEndpointServiceConfigurationRequest
) => any;
export declare const PrivateDnsNameConfigurationFilterSensitiveLog: (
  obj: PrivateDnsNameConfiguration
) => any;
export declare const ServiceTypeDetailFilterSensitiveLog: (
  obj: ServiceTypeDetail
) => any;
export declare const ServiceConfigurationFilterSensitiveLog: (
  obj: ServiceConfiguration
) => any;
export declare const CreateVpcEndpointServiceConfigurationResultFilterSensitiveLog: (
  obj: CreateVpcEndpointServiceConfigurationResult
) => any;
export declare const CreateVpcPeeringConnectionRequestFilterSensitiveLog: (
  obj: CreateVpcPeeringConnectionRequest
) => any;
export declare const CreateVpcPeeringConnectionResultFilterSensitiveLog: (
  obj: CreateVpcPeeringConnectionResult
) => any;
export declare const IKEVersionsRequestListValueFilterSensitiveLog: (
  obj: IKEVersionsRequestListValue
) => any;
export declare const CloudWatchLogOptionsSpecificationFilterSensitiveLog: (
  obj: CloudWatchLogOptionsSpecification
) => any;
export declare const VpnTunnelLogOptionsSpecificationFilterSensitiveLog: (
  obj: VpnTunnelLogOptionsSpecification
) => any;
export declare const Phase1DHGroupNumbersRequestListValueFilterSensitiveLog: (
  obj: Phase1DHGroupNumbersRequestListValue
) => any;
export declare const Phase1EncryptionAlgorithmsRequestListValueFilterSensitiveLog: (
  obj: Phase1EncryptionAlgorithmsRequestListValue
) => any;
export declare const Phase1IntegrityAlgorithmsRequestListValueFilterSensitiveLog: (
  obj: Phase1IntegrityAlgorithmsRequestListValue
) => any;
export declare const Phase2DHGroupNumbersRequestListValueFilterSensitiveLog: (
  obj: Phase2DHGroupNumbersRequestListValue
) => any;
export declare const Phase2EncryptionAlgorithmsRequestListValueFilterSensitiveLog: (
  obj: Phase2EncryptionAlgorithmsRequestListValue
) => any;
export declare const Phase2IntegrityAlgorithmsRequestListValueFilterSensitiveLog: (
  obj: Phase2IntegrityAlgorithmsRequestListValue
) => any;
export declare const VpnTunnelOptionsSpecificationFilterSensitiveLog: (
  obj: VpnTunnelOptionsSpecification
) => any;
export declare const VpnConnectionOptionsSpecificationFilterSensitiveLog: (
  obj: VpnConnectionOptionsSpecification
) => any;
export declare const CreateVpnConnectionRequestFilterSensitiveLog: (
  obj: CreateVpnConnectionRequest
) => any;
export declare const IKEVersionsListValueFilterSensitiveLog: (
  obj: IKEVersionsListValue
) => any;
export declare const CloudWatchLogOptionsFilterSensitiveLog: (
  obj: CloudWatchLogOptions
) => any;
export declare const VpnTunnelLogOptionsFilterSensitiveLog: (
  obj: VpnTunnelLogOptions
) => any;
export declare const Phase1DHGroupNumbersListValueFilterSensitiveLog: (
  obj: Phase1DHGroupNumbersListValue
) => any;
export declare const Phase1EncryptionAlgorithmsListValueFilterSensitiveLog: (
  obj: Phase1EncryptionAlgorithmsListValue
) => any;
export declare const Phase1IntegrityAlgorithmsListValueFilterSensitiveLog: (
  obj: Phase1IntegrityAlgorithmsListValue
) => any;
export declare const Phase2DHGroupNumbersListValueFilterSensitiveLog: (
  obj: Phase2DHGroupNumbersListValue
) => any;
export declare const Phase2EncryptionAlgorithmsListValueFilterSensitiveLog: (
  obj: Phase2EncryptionAlgorithmsListValue
) => any;
export declare const Phase2IntegrityAlgorithmsListValueFilterSensitiveLog: (
  obj: Phase2IntegrityAlgorithmsListValue
) => any;
export declare const TunnelOptionFilterSensitiveLog: (obj: TunnelOption) => any;
export declare const VpnConnectionOptionsFilterSensitiveLog: (
  obj: VpnConnectionOptions
) => any;
export declare const VpnStaticRouteFilterSensitiveLog: (
  obj: VpnStaticRoute
) => any;
export declare const VgwTelemetryFilterSensitiveLog: (obj: VgwTelemetry) => any;
export declare const VpnConnectionFilterSensitiveLog: (
  obj: VpnConnection
) => any;
export declare const CreateVpnConnectionResultFilterSensitiveLog: (
  obj: CreateVpnConnectionResult
) => any;
export declare const CreateVpnConnectionRouteRequestFilterSensitiveLog: (
  obj: CreateVpnConnectionRouteRequest
) => any;
export declare const CreateVpnGatewayRequestFilterSensitiveLog: (
  obj: CreateVpnGatewayRequest
) => any;
export declare const VpnGatewayFilterSensitiveLog: (obj: VpnGateway) => any;
export declare const CreateVpnGatewayResultFilterSensitiveLog: (
  obj: CreateVpnGatewayResult
) => any;
export declare const DeleteCarrierGatewayRequestFilterSensitiveLog: (
  obj: DeleteCarrierGatewayRequest
) => any;
export declare const DeleteCarrierGatewayResultFilterSensitiveLog: (
  obj: DeleteCarrierGatewayResult
) => any;
export declare const DeleteClientVpnEndpointRequestFilterSensitiveLog: (
  obj: DeleteClientVpnEndpointRequest
) => any;
export declare const DeleteClientVpnEndpointResultFilterSensitiveLog: (
  obj: DeleteClientVpnEndpointResult
) => any;
export declare const DeleteClientVpnRouteRequestFilterSensitiveLog: (
  obj: DeleteClientVpnRouteRequest
) => any;
export declare const DeleteClientVpnRouteResultFilterSensitiveLog: (
  obj: DeleteClientVpnRouteResult
) => any;
export declare const DeleteCoipCidrRequestFilterSensitiveLog: (
  obj: DeleteCoipCidrRequest
) => any;
export declare const DeleteCoipCidrResultFilterSensitiveLog: (
  obj: DeleteCoipCidrResult
) => any;
export declare const DeleteCoipPoolRequestFilterSensitiveLog: (
  obj: DeleteCoipPoolRequest
) => any;
export declare const DeleteCoipPoolResultFilterSensitiveLog: (
  obj: DeleteCoipPoolResult
) => any;
export declare const DeleteCustomerGatewayRequestFilterSensitiveLog: (
  obj: DeleteCustomerGatewayRequest
) => any;
export declare const DeleteDhcpOptionsRequestFilterSensitiveLog: (
  obj: DeleteDhcpOptionsRequest
) => any;
export declare const DeleteEgressOnlyInternetGatewayRequestFilterSensitiveLog: (
  obj: DeleteEgressOnlyInternetGatewayRequest
) => any;
export declare const DeleteEgressOnlyInternetGatewayResultFilterSensitiveLog: (
  obj: DeleteEgressOnlyInternetGatewayResult
) => any;
export declare const DeleteFleetsRequestFilterSensitiveLog: (
  obj: DeleteFleetsRequest
) => any;
export declare const DeleteFleetSuccessItemFilterSensitiveLog: (
  obj: DeleteFleetSuccessItem
) => any;
export declare const DeleteFleetErrorFilterSensitiveLog: (
  obj: DeleteFleetError
) => any;
export declare const DeleteFleetErrorItemFilterSensitiveLog: (
  obj: DeleteFleetErrorItem
) => any;
export declare const DeleteFleetsResultFilterSensitiveLog: (
  obj: DeleteFleetsResult
) => any;
export declare const DeleteFlowLogsRequestFilterSensitiveLog: (
  obj: DeleteFlowLogsRequest
) => any;
export declare const DeleteFlowLogsResultFilterSensitiveLog: (
  obj: DeleteFlowLogsResult
) => any;
export declare const DeleteFpgaImageRequestFilterSensitiveLog: (
  obj: DeleteFpgaImageRequest
) => any;
export declare const DeleteFpgaImageResultFilterSensitiveLog: (
  obj: DeleteFpgaImageResult
) => any;
export declare const DeleteInstanceEventWindowRequestFilterSensitiveLog: (
  obj: DeleteInstanceEventWindowRequest
) => any;
export declare const InstanceEventWindowStateChangeFilterSensitiveLog: (
  obj: InstanceEventWindowStateChange
) => any;
export declare const DeleteInstanceEventWindowResultFilterSensitiveLog: (
  obj: DeleteInstanceEventWindowResult
) => any;
export declare const DeleteInternetGatewayRequestFilterSensitiveLog: (
  obj: DeleteInternetGatewayRequest
) => any;
export declare const DeleteIpamRequestFilterSensitiveLog: (
  obj: DeleteIpamRequest
) => any;
export declare const DeleteIpamResultFilterSensitiveLog: (
  obj: DeleteIpamResult
) => any;
export declare const DeleteIpamPoolRequestFilterSensitiveLog: (
  obj: DeleteIpamPoolRequest
) => any;
export declare const DeleteIpamPoolResultFilterSensitiveLog: (
  obj: DeleteIpamPoolResult
) => any;
export declare const DeleteIpamScopeRequestFilterSensitiveLog: (
  obj: DeleteIpamScopeRequest
) => any;
export declare const DeleteIpamScopeResultFilterSensitiveLog: (
  obj: DeleteIpamScopeResult
) => any;
export declare const DeleteKeyPairRequestFilterSensitiveLog: (
  obj: DeleteKeyPairRequest
) => any;
export declare const DeleteLaunchTemplateRequestFilterSensitiveLog: (
  obj: DeleteLaunchTemplateRequest
) => any;
export declare const DeleteLaunchTemplateResultFilterSensitiveLog: (
  obj: DeleteLaunchTemplateResult
) => any;
export declare const DeleteLaunchTemplateVersionsRequestFilterSensitiveLog: (
  obj: DeleteLaunchTemplateVersionsRequest
) => any;
export declare const DeleteLaunchTemplateVersionsResponseSuccessItemFilterSensitiveLog: (
  obj: DeleteLaunchTemplateVersionsResponseSuccessItem
) => any;
export declare const ResponseErrorFilterSensitiveLog: (
  obj: ResponseError
) => any;
export declare const DeleteLaunchTemplateVersionsResponseErrorItemFilterSensitiveLog: (
  obj: DeleteLaunchTemplateVersionsResponseErrorItem
) => any;
export declare const DeleteLaunchTemplateVersionsResultFilterSensitiveLog: (
  obj: DeleteLaunchTemplateVersionsResult
) => any;
export declare const DeleteLocalGatewayRouteRequestFilterSensitiveLog: (
  obj: DeleteLocalGatewayRouteRequest
) => any;
export declare const DeleteLocalGatewayRouteResultFilterSensitiveLog: (
  obj: DeleteLocalGatewayRouteResult
) => any;
export declare const DeleteLocalGatewayRouteTableRequestFilterSensitiveLog: (
  obj: DeleteLocalGatewayRouteTableRequest
) => any;
export declare const DeleteLocalGatewayRouteTableResultFilterSensitiveLog: (
  obj: DeleteLocalGatewayRouteTableResult
) => any;
export declare const DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequestFilterSensitiveLog: (
  obj: DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest
) => any;
export declare const DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResultFilterSensitiveLog: (
  obj: DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult
) => any;
export declare const DeleteLocalGatewayRouteTableVpcAssociationRequestFilterSensitiveLog: (
  obj: DeleteLocalGatewayRouteTableVpcAssociationRequest
) => any;
export declare const DeleteLocalGatewayRouteTableVpcAssociationResultFilterSensitiveLog: (
  obj: DeleteLocalGatewayRouteTableVpcAssociationResult
) => any;
export declare const DeleteManagedPrefixListRequestFilterSensitiveLog: (
  obj: DeleteManagedPrefixListRequest
) => any;
export declare const DeleteManagedPrefixListResultFilterSensitiveLog: (
  obj: DeleteManagedPrefixListResult
) => any;
export declare const DeleteNatGatewayRequestFilterSensitiveLog: (
  obj: DeleteNatGatewayRequest
) => any;
export declare const DeleteNatGatewayResultFilterSensitiveLog: (
  obj: DeleteNatGatewayResult
) => any;
export declare const DeleteNetworkAclRequestFilterSensitiveLog: (
  obj: DeleteNetworkAclRequest
) => any;
export declare const DeleteNetworkAclEntryRequestFilterSensitiveLog: (
  obj: DeleteNetworkAclEntryRequest
) => any;
export declare const DeleteNetworkInsightsAccessScopeRequestFilterSensitiveLog: (
  obj: DeleteNetworkInsightsAccessScopeRequest
) => any;
export declare const DeleteNetworkInsightsAccessScopeResultFilterSensitiveLog: (
  obj: DeleteNetworkInsightsAccessScopeResult
) => any;
export declare const DeleteNetworkInsightsAccessScopeAnalysisRequestFilterSensitiveLog: (
  obj: DeleteNetworkInsightsAccessScopeAnalysisRequest
) => any;
export declare const DeleteNetworkInsightsAccessScopeAnalysisResultFilterSensitiveLog: (
  obj: DeleteNetworkInsightsAccessScopeAnalysisResult
) => any;
export declare const DeleteNetworkInsightsAnalysisRequestFilterSensitiveLog: (
  obj: DeleteNetworkInsightsAnalysisRequest
) => any;
export declare const DeleteNetworkInsightsAnalysisResultFilterSensitiveLog: (
  obj: DeleteNetworkInsightsAnalysisResult
) => any;
export declare const DeleteNetworkInsightsPathRequestFilterSensitiveLog: (
  obj: DeleteNetworkInsightsPathRequest
) => any;
export declare const DeleteNetworkInsightsPathResultFilterSensitiveLog: (
  obj: DeleteNetworkInsightsPathResult
) => any;
export declare const DeleteNetworkInterfaceRequestFilterSensitiveLog: (
  obj: DeleteNetworkInterfaceRequest
) => any;
export declare const DeleteNetworkInterfacePermissionRequestFilterSensitiveLog: (
  obj: DeleteNetworkInterfacePermissionRequest
) => any;
export declare const DeleteNetworkInterfacePermissionResultFilterSensitiveLog: (
  obj: DeleteNetworkInterfacePermissionResult
) => any;
export declare const DeletePlacementGroupRequestFilterSensitiveLog: (
  obj: DeletePlacementGroupRequest
) => any;
export declare const DeletePublicIpv4PoolRequestFilterSensitiveLog: (
  obj: DeletePublicIpv4PoolRequest
) => any;
export declare const DeletePublicIpv4PoolResultFilterSensitiveLog: (
  obj: DeletePublicIpv4PoolResult
) => any;
export declare const DeleteQueuedReservedInstancesRequestFilterSensitiveLog: (
  obj: DeleteQueuedReservedInstancesRequest
) => any;
export declare const DeleteQueuedReservedInstancesErrorFilterSensitiveLog: (
  obj: DeleteQueuedReservedInstancesError
) => any;
export declare const FailedQueuedPurchaseDeletionFilterSensitiveLog: (
  obj: FailedQueuedPurchaseDeletion
) => any;
export declare const SuccessfulQueuedPurchaseDeletionFilterSensitiveLog: (
  obj: SuccessfulQueuedPurchaseDeletion
) => any;
export declare const DeleteQueuedReservedInstancesResultFilterSensitiveLog: (
  obj: DeleteQueuedReservedInstancesResult
) => any;
export declare const DeleteRouteRequestFilterSensitiveLog: (
  obj: DeleteRouteRequest
) => any;
export declare const DeleteRouteTableRequestFilterSensitiveLog: (
  obj: DeleteRouteTableRequest
) => any;
export declare const DeleteSecurityGroupRequestFilterSensitiveLog: (
  obj: DeleteSecurityGroupRequest
) => any;
export declare const DeleteSnapshotRequestFilterSensitiveLog: (
  obj: DeleteSnapshotRequest
) => any;
export declare const DeleteSpotDatafeedSubscriptionRequestFilterSensitiveLog: (
  obj: DeleteSpotDatafeedSubscriptionRequest
) => any;
export declare const DeleteSubnetRequestFilterSensitiveLog: (
  obj: DeleteSubnetRequest
) => any;
export declare const DeleteSubnetCidrReservationRequestFilterSensitiveLog: (
  obj: DeleteSubnetCidrReservationRequest
) => any;
export declare const DeleteSubnetCidrReservationResultFilterSensitiveLog: (
  obj: DeleteSubnetCidrReservationResult
) => any;
export declare const DeleteTagsRequestFilterSensitiveLog: (
  obj: DeleteTagsRequest
) => any;
export declare const DeleteTrafficMirrorFilterRequestFilterSensitiveLog: (
  obj: DeleteTrafficMirrorFilterRequest
) => any;
export declare const DeleteTrafficMirrorFilterResultFilterSensitiveLog: (
  obj: DeleteTrafficMirrorFilterResult
) => any;
export declare const DeleteTrafficMirrorFilterRuleRequestFilterSensitiveLog: (
  obj: DeleteTrafficMirrorFilterRuleRequest
) => any;
export declare const DeleteTrafficMirrorFilterRuleResultFilterSensitiveLog: (
  obj: DeleteTrafficMirrorFilterRuleResult
) => any;
export declare const DeleteTrafficMirrorSessionRequestFilterSensitiveLog: (
  obj: DeleteTrafficMirrorSessionRequest
) => any;
export declare const DeleteTrafficMirrorSessionResultFilterSensitiveLog: (
  obj: DeleteTrafficMirrorSessionResult
) => any;
export declare const DeleteTrafficMirrorTargetRequestFilterSensitiveLog: (
  obj: DeleteTrafficMirrorTargetRequest
) => any;
export declare const DeleteTrafficMirrorTargetResultFilterSensitiveLog: (
  obj: DeleteTrafficMirrorTargetResult
) => any;
export declare const DeleteTransitGatewayRequestFilterSensitiveLog: (
  obj: DeleteTransitGatewayRequest
) => any;
export declare const DeleteTransitGatewayResultFilterSensitiveLog: (
  obj: DeleteTransitGatewayResult
) => any;
export declare const DeleteTransitGatewayConnectRequestFilterSensitiveLog: (
  obj: DeleteTransitGatewayConnectRequest
) => any;
export declare const DeleteTransitGatewayConnectResultFilterSensitiveLog: (
  obj: DeleteTransitGatewayConnectResult
) => any;
export declare const DeleteTransitGatewayConnectPeerRequestFilterSensitiveLog: (
  obj: DeleteTransitGatewayConnectPeerRequest
) => any;
export declare const DeleteTransitGatewayConnectPeerResultFilterSensitiveLog: (
  obj: DeleteTransitGatewayConnectPeerResult
) => any;
export declare const DeleteTransitGatewayMulticastDomainRequestFilterSensitiveLog: (
  obj: DeleteTransitGatewayMulticastDomainRequest
) => any;
export declare const DeleteTransitGatewayMulticastDomainResultFilterSensitiveLog: (
  obj: DeleteTransitGatewayMulticastDomainResult
) => any;
export declare const DeleteTransitGatewayPeeringAttachmentRequestFilterSensitiveLog: (
  obj: DeleteTransitGatewayPeeringAttachmentRequest
) => any;
export declare const DeleteTransitGatewayPeeringAttachmentResultFilterSensitiveLog: (
  obj: DeleteTransitGatewayPeeringAttachmentResult
) => any;
export declare const DeleteTransitGatewayPolicyTableRequestFilterSensitiveLog: (
  obj: DeleteTransitGatewayPolicyTableRequest
) => any;
export declare const DeleteTransitGatewayPolicyTableResultFilterSensitiveLog: (
  obj: DeleteTransitGatewayPolicyTableResult
) => any;
export declare const DeleteTransitGatewayPrefixListReferenceRequestFilterSensitiveLog: (
  obj: DeleteTransitGatewayPrefixListReferenceRequest
) => any;
export declare const DeleteTransitGatewayPrefixListReferenceResultFilterSensitiveLog: (
  obj: DeleteTransitGatewayPrefixListReferenceResult
) => any;
export declare const DeleteTransitGatewayRouteRequestFilterSensitiveLog: (
  obj: DeleteTransitGatewayRouteRequest
) => any;
