import {
  _InstanceType,
  AcceleratorCount,
  AcceleratorCountRequest,
  AcceleratorManufacturer,
  AcceleratorName,
  AcceleratorTotalMemoryMiB,
  AcceleratorTotalMemoryMiBRequest,
  AcceleratorType,
  AccessScopePath,
  AccessScopePathRequest,
  AddIpamOperatingRegion,
  AddPrefixListEntry,
  AddressFamily,
  AttachmentStatus,
  CoipCidr,
  CurrencyCodeValues,
  InstanceEventWindow,
  Ipv4PrefixSpecification,
  PortRange,
  Protocol,
  ReservedInstancesListing,
  ResourceType,
  RouteTableAssociationState,
  SubnetIpv6CidrBlockAssociation,
  Tag,
  TagSpecification,
  UnsuccessfulItem,
  VpcCidrBlockAssociation,
  VpcIpv6CidrBlockAssociation,
  WeekDay,
} from "./models_0";
export interface CreateCoipCidrResult {
  CoipCidr?: CoipCidr;
}
export interface CreateCoipPoolRequest {
  LocalGatewayRouteTableId: string | undefined;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface CoipPool {
  PoolId?: string;
  PoolCidrs?: string[];
  LocalGatewayRouteTableId?: string;
  Tags?: Tag[];
  PoolArn?: string;
}
export interface CreateCoipPoolResult {
  CoipPool?: CoipPool;
}
export declare enum GatewayType {
  ipsec_1 = "ipsec.1",
}
export interface CreateCustomerGatewayRequest {
  BgpAsn: number | undefined;
  PublicIp?: string;
  CertificateArn?: string;
  Type: GatewayType | string | undefined;
  TagSpecifications?: TagSpecification[];
  DeviceName?: string;
  IpAddress?: string;
  DryRun?: boolean;
}
export interface CustomerGateway {
  BgpAsn?: string;
  CustomerGatewayId?: string;
  IpAddress?: string;
  CertificateArn?: string;
  State?: string;
  Type?: string;
  DeviceName?: string;
  Tags?: Tag[];
}
export interface CreateCustomerGatewayResult {
  CustomerGateway?: CustomerGateway;
}
export interface CreateDefaultSubnetRequest {
  AvailabilityZone: string | undefined;
  DryRun?: boolean;
  Ipv6Native?: boolean;
}
export declare enum HostnameType {
  ip_name = "ip-name",
  resource_name = "resource-name",
}
export interface PrivateDnsNameOptionsOnLaunch {
  HostnameType?: HostnameType | string;
  EnableResourceNameDnsARecord?: boolean;
  EnableResourceNameDnsAAAARecord?: boolean;
}
export declare enum SubnetState {
  available = "available",
  pending = "pending",
}
export interface Subnet {
  AvailabilityZone?: string;
  AvailabilityZoneId?: string;
  AvailableIpAddressCount?: number;
  CidrBlock?: string;
  DefaultForAz?: boolean;
  EnableLniAtDeviceIndex?: number;
  MapPublicIpOnLaunch?: boolean;
  MapCustomerOwnedIpOnLaunch?: boolean;
  CustomerOwnedIpv4Pool?: string;
  State?: SubnetState | string;
  SubnetId?: string;
  VpcId?: string;
  OwnerId?: string;
  AssignIpv6AddressOnCreation?: boolean;
  Ipv6CidrBlockAssociationSet?: SubnetIpv6CidrBlockAssociation[];
  Tags?: Tag[];
  SubnetArn?: string;
  OutpostArn?: string;
  EnableDns64?: boolean;
  Ipv6Native?: boolean;
  PrivateDnsNameOptionsOnLaunch?: PrivateDnsNameOptionsOnLaunch;
}
export interface CreateDefaultSubnetResult {
  Subnet?: Subnet;
}
export interface CreateDefaultVpcRequest {
  DryRun?: boolean;
}
export declare enum Tenancy {
  dedicated = "dedicated",
  default = "default",
  host = "host",
}
export declare enum VpcState {
  available = "available",
  pending = "pending",
}
export interface Vpc {
  CidrBlock?: string;
  DhcpOptionsId?: string;
  State?: VpcState | string;
  VpcId?: string;
  OwnerId?: string;
  InstanceTenancy?: Tenancy | string;
  Ipv6CidrBlockAssociationSet?: VpcIpv6CidrBlockAssociation[];
  CidrBlockAssociationSet?: VpcCidrBlockAssociation[];
  IsDefault?: boolean;
  Tags?: Tag[];
}
export interface CreateDefaultVpcResult {
  Vpc?: Vpc;
}
export interface NewDhcpConfiguration {
  Key?: string;
  Values?: string[];
}
export interface CreateDhcpOptionsRequest {
  DhcpConfigurations: NewDhcpConfiguration[] | undefined;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface AttributeValue {
  Value?: string;
}
export interface DhcpConfiguration {
  Key?: string;
  Values?: AttributeValue[];
}
export interface DhcpOptions {
  DhcpConfigurations?: DhcpConfiguration[];
  DhcpOptionsId?: string;
  OwnerId?: string;
  Tags?: Tag[];
}
export interface CreateDhcpOptionsResult {
  DhcpOptions?: DhcpOptions;
}
export interface CreateEgressOnlyInternetGatewayRequest {
  ClientToken?: string;
  DryRun?: boolean;
  VpcId: string | undefined;
  TagSpecifications?: TagSpecification[];
}
export interface InternetGatewayAttachment {
  State?: AttachmentStatus | string;
  VpcId?: string;
}
export interface EgressOnlyInternetGateway {
  Attachments?: InternetGatewayAttachment[];
  EgressOnlyInternetGatewayId?: string;
  Tags?: Tag[];
}
export interface CreateEgressOnlyInternetGatewayResult {
  ClientToken?: string;
  EgressOnlyInternetGateway?: EgressOnlyInternetGateway;
}
export declare enum FleetExcessCapacityTerminationPolicy {
  NO_TERMINATION = "no-termination",
  TERMINATION = "termination",
}
export interface FleetLaunchTemplateSpecificationRequest {
  LaunchTemplateId?: string;
  LaunchTemplateName?: string;
  Version?: string;
}
export declare enum BareMetal {
  EXCLUDED = "excluded",
  INCLUDED = "included",
  REQUIRED = "required",
}
export interface BaselineEbsBandwidthMbpsRequest {
  Min?: number;
  Max?: number;
}
export declare enum BurstablePerformance {
  EXCLUDED = "excluded",
  INCLUDED = "included",
  REQUIRED = "required",
}
export declare enum CpuManufacturer {
  AMAZON_WEB_SERVICES = "amazon-web-services",
  AMD = "amd",
  INTEL = "intel",
}
export declare enum InstanceGeneration {
  CURRENT = "current",
  PREVIOUS = "previous",
}
export declare enum LocalStorage {
  EXCLUDED = "excluded",
  INCLUDED = "included",
  REQUIRED = "required",
}
export declare enum LocalStorageType {
  HDD = "hdd",
  SSD = "ssd",
}
export interface MemoryGiBPerVCpuRequest {
  Min?: number;
  Max?: number;
}
export interface MemoryMiBRequest {
  Min: number | undefined;
  Max?: number;
}
export interface NetworkBandwidthGbpsRequest {
  Min?: number;
  Max?: number;
}
export interface NetworkInterfaceCountRequest {
  Min?: number;
  Max?: number;
}
export interface TotalLocalStorageGBRequest {
  Min?: number;
  Max?: number;
}
export interface VCpuCountRangeRequest {
  Min: number | undefined;
  Max?: number;
}
export interface InstanceRequirementsRequest {
  VCpuCount: VCpuCountRangeRequest | undefined;
  MemoryMiB: MemoryMiBRequest | undefined;
  CpuManufacturers?: (CpuManufacturer | string)[];
  MemoryGiBPerVCpu?: MemoryGiBPerVCpuRequest;
  ExcludedInstanceTypes?: string[];
  InstanceGenerations?: (InstanceGeneration | string)[];
  SpotMaxPricePercentageOverLowestPrice?: number;
  OnDemandMaxPricePercentageOverLowestPrice?: number;
  BareMetal?: BareMetal | string;
  BurstablePerformance?: BurstablePerformance | string;
  RequireHibernateSupport?: boolean;
  NetworkInterfaceCount?: NetworkInterfaceCountRequest;
  LocalStorage?: LocalStorage | string;
  LocalStorageTypes?: (LocalStorageType | string)[];
  TotalLocalStorageGB?: TotalLocalStorageGBRequest;
  BaselineEbsBandwidthMbps?: BaselineEbsBandwidthMbpsRequest;
  AcceleratorTypes?: (AcceleratorType | string)[];
  AcceleratorCount?: AcceleratorCountRequest;
  AcceleratorManufacturers?: (AcceleratorManufacturer | string)[];
  AcceleratorNames?: (AcceleratorName | string)[];
  AcceleratorTotalMemoryMiB?: AcceleratorTotalMemoryMiBRequest;
  NetworkBandwidthGbps?: NetworkBandwidthGbpsRequest;
  AllowedInstanceTypes?: string[];
}
export interface Placement {
  AvailabilityZone?: string;
  Affinity?: string;
  GroupName?: string;
  PartitionNumber?: number;
  HostId?: string;
  Tenancy?: Tenancy | string;
  SpreadDomain?: string;
  HostResourceGroupArn?: string;
  GroupId?: string;
}
export interface FleetLaunchTemplateOverridesRequest {
  InstanceType?: _InstanceType | string;
  MaxPrice?: string;
  SubnetId?: string;
  AvailabilityZone?: string;
  WeightedCapacity?: number;
  Priority?: number;
  Placement?: Placement;
  InstanceRequirements?: InstanceRequirementsRequest;
  ImageId?: string;
}
export interface FleetLaunchTemplateConfigRequest {
  LaunchTemplateSpecification?: FleetLaunchTemplateSpecificationRequest;
  Overrides?: FleetLaunchTemplateOverridesRequest[];
}
export declare enum FleetOnDemandAllocationStrategy {
  LOWEST_PRICE = "lowest-price",
  PRIORITIZED = "prioritized",
}
export declare enum FleetCapacityReservationUsageStrategy {
  USE_CAPACITY_RESERVATIONS_FIRST = "use-capacity-reservations-first",
}
export interface CapacityReservationOptionsRequest {
  UsageStrategy?: FleetCapacityReservationUsageStrategy | string;
}
export interface OnDemandOptionsRequest {
  AllocationStrategy?: FleetOnDemandAllocationStrategy | string;
  CapacityReservationOptions?: CapacityReservationOptionsRequest;
  SingleInstanceType?: boolean;
  SingleAvailabilityZone?: boolean;
  MinTargetCapacity?: number;
  MaxTotalPrice?: string;
}
export declare enum SpotAllocationStrategy {
  CAPACITY_OPTIMIZED = "capacity-optimized",
  CAPACITY_OPTIMIZED_PRIORITIZED = "capacity-optimized-prioritized",
  DIVERSIFIED = "diversified",
  LOWEST_PRICE = "lowest-price",
  PRICE_CAPACITY_OPTIMIZED = "price-capacity-optimized",
}
export declare enum SpotInstanceInterruptionBehavior {
  hibernate = "hibernate",
  stop = "stop",
  terminate = "terminate",
}
export declare enum FleetReplacementStrategy {
  LAUNCH = "launch",
  LAUNCH_BEFORE_TERMINATE = "launch-before-terminate",
}
export interface FleetSpotCapacityRebalanceRequest {
  ReplacementStrategy?: FleetReplacementStrategy | string;
  TerminationDelay?: number;
}
export interface FleetSpotMaintenanceStrategiesRequest {
  CapacityRebalance?: FleetSpotCapacityRebalanceRequest;
}
export interface SpotOptionsRequest {
  AllocationStrategy?: SpotAllocationStrategy | string;
  MaintenanceStrategies?: FleetSpotMaintenanceStrategiesRequest;
  InstanceInterruptionBehavior?: SpotInstanceInterruptionBehavior | string;
  InstancePoolsToUseCount?: number;
  SingleInstanceType?: boolean;
  SingleAvailabilityZone?: boolean;
  MinTargetCapacity?: number;
  MaxTotalPrice?: string;
}
export declare enum DefaultTargetCapacityType {
  ON_DEMAND = "on-demand",
  SPOT = "spot",
}
export declare enum TargetCapacityUnitType {
  MEMORY_MIB = "memory-mib",
  UNITS = "units",
  VCPU = "vcpu",
}
export interface TargetCapacitySpecificationRequest {
  TotalTargetCapacity: number | undefined;
  OnDemandTargetCapacity?: number;
  SpotTargetCapacity?: number;
  DefaultTargetCapacityType?: DefaultTargetCapacityType | string;
  TargetCapacityUnitType?: TargetCapacityUnitType | string;
}
export declare enum FleetType {
  INSTANT = "instant",
  MAINTAIN = "maintain",
  REQUEST = "request",
}
export interface CreateFleetRequest {
  DryRun?: boolean;
  ClientToken?: string;
  SpotOptions?: SpotOptionsRequest;
  OnDemandOptions?: OnDemandOptionsRequest;
  ExcessCapacityTerminationPolicy?:
    | FleetExcessCapacityTerminationPolicy
    | string;
  LaunchTemplateConfigs: FleetLaunchTemplateConfigRequest[] | undefined;
  TargetCapacitySpecification: TargetCapacitySpecificationRequest | undefined;
  TerminateInstancesWithExpiration?: boolean;
  Type?: FleetType | string;
  ValidFrom?: Date;
  ValidUntil?: Date;
  ReplaceUnhealthyInstances?: boolean;
  TagSpecifications?: TagSpecification[];
  Context?: string;
}
export interface FleetLaunchTemplateSpecification {
  LaunchTemplateId?: string;
  LaunchTemplateName?: string;
  Version?: string;
}
export interface BaselineEbsBandwidthMbps {
  Min?: number;
  Max?: number;
}
export interface MemoryGiBPerVCpu {
  Min?: number;
  Max?: number;
}
export interface MemoryMiB {
  Min?: number;
  Max?: number;
}
export interface NetworkBandwidthGbps {
  Min?: number;
  Max?: number;
}
export interface NetworkInterfaceCount {
  Min?: number;
  Max?: number;
}
export interface TotalLocalStorageGB {
  Min?: number;
  Max?: number;
}
export interface VCpuCountRange {
  Min?: number;
  Max?: number;
}
export interface InstanceRequirements {
  VCpuCount?: VCpuCountRange;
  MemoryMiB?: MemoryMiB;
  CpuManufacturers?: (CpuManufacturer | string)[];
  MemoryGiBPerVCpu?: MemoryGiBPerVCpu;
  ExcludedInstanceTypes?: string[];
  InstanceGenerations?: (InstanceGeneration | string)[];
  SpotMaxPricePercentageOverLowestPrice?: number;
  OnDemandMaxPricePercentageOverLowestPrice?: number;
  BareMetal?: BareMetal | string;
  BurstablePerformance?: BurstablePerformance | string;
  RequireHibernateSupport?: boolean;
  NetworkInterfaceCount?: NetworkInterfaceCount;
  LocalStorage?: LocalStorage | string;
  LocalStorageTypes?: (LocalStorageType | string)[];
  TotalLocalStorageGB?: TotalLocalStorageGB;
  BaselineEbsBandwidthMbps?: BaselineEbsBandwidthMbps;
  AcceleratorTypes?: (AcceleratorType | string)[];
  AcceleratorCount?: AcceleratorCount;
  AcceleratorManufacturers?: (AcceleratorManufacturer | string)[];
  AcceleratorNames?: (AcceleratorName | string)[];
  AcceleratorTotalMemoryMiB?: AcceleratorTotalMemoryMiB;
  NetworkBandwidthGbps?: NetworkBandwidthGbps;
  AllowedInstanceTypes?: string[];
}
export interface PlacementResponse {
  GroupName?: string;
}
export interface FleetLaunchTemplateOverrides {
  InstanceType?: _InstanceType | string;
  MaxPrice?: string;
  SubnetId?: string;
  AvailabilityZone?: string;
  WeightedCapacity?: number;
  Priority?: number;
  Placement?: PlacementResponse;
  InstanceRequirements?: InstanceRequirements;
  ImageId?: string;
}
export interface LaunchTemplateAndOverridesResponse {
  LaunchTemplateSpecification?: FleetLaunchTemplateSpecification;
  Overrides?: FleetLaunchTemplateOverrides;
}
export declare enum InstanceLifecycle {
  ON_DEMAND = "on-demand",
  SPOT = "spot",
}
export interface CreateFleetError {
  LaunchTemplateAndOverrides?: LaunchTemplateAndOverridesResponse;
  Lifecycle?: InstanceLifecycle | string;
  ErrorCode?: string;
  ErrorMessage?: string;
}
export declare enum PlatformValues {
  Windows = "Windows",
}
export interface CreateFleetInstance {
  LaunchTemplateAndOverrides?: LaunchTemplateAndOverridesResponse;
  Lifecycle?: InstanceLifecycle | string;
  InstanceIds?: string[];
  InstanceType?: _InstanceType | string;
  Platform?: PlatformValues | string;
}
export interface CreateFleetResult {
  FleetId?: string;
  Errors?: CreateFleetError[];
  Instances?: CreateFleetInstance[];
}
export declare enum DestinationFileFormat {
  parquet = "parquet",
  plain_text = "plain-text",
}
export interface DestinationOptionsRequest {
  FileFormat?: DestinationFileFormat | string;
  HiveCompatiblePartitions?: boolean;
  PerHourPartition?: boolean;
}
export declare enum LogDestinationType {
  cloud_watch_logs = "cloud-watch-logs",
  kinesis_data_firehose = "kinesis-data-firehose",
  s3 = "s3",
}
export declare enum FlowLogsResourceType {
  NetworkInterface = "NetworkInterface",
  Subnet = "Subnet",
  TransitGateway = "TransitGateway",
  TransitGatewayAttachment = "TransitGatewayAttachment",
  VPC = "VPC",
}
export declare enum TrafficType {
  ACCEPT = "ACCEPT",
  ALL = "ALL",
  REJECT = "REJECT",
}
export interface CreateFlowLogsRequest {
  DryRun?: boolean;
  ClientToken?: string;
  DeliverLogsPermissionArn?: string;
  DeliverCrossAccountRole?: string;
  LogGroupName?: string;
  ResourceIds: string[] | undefined;
  ResourceType: FlowLogsResourceType | string | undefined;
  TrafficType?: TrafficType | string;
  LogDestinationType?: LogDestinationType | string;
  LogDestination?: string;
  LogFormat?: string;
  TagSpecifications?: TagSpecification[];
  MaxAggregationInterval?: number;
  DestinationOptions?: DestinationOptionsRequest;
}
export interface CreateFlowLogsResult {
  ClientToken?: string;
  FlowLogIds?: string[];
  Unsuccessful?: UnsuccessfulItem[];
}
export interface StorageLocation {
  Bucket?: string;
  Key?: string;
}
export interface CreateFpgaImageRequest {
  DryRun?: boolean;
  InputStorageLocation: StorageLocation | undefined;
  LogsStorageLocation?: StorageLocation;
  Description?: string;
  Name?: string;
  ClientToken?: string;
  TagSpecifications?: TagSpecification[];
}
export interface CreateFpgaImageResult {
  FpgaImageId?: string;
  FpgaImageGlobalId?: string;
}
export declare enum VolumeType {
  gp2 = "gp2",
  gp3 = "gp3",
  io1 = "io1",
  io2 = "io2",
  sc1 = "sc1",
  st1 = "st1",
  standard = "standard",
}
export interface EbsBlockDevice {
  DeleteOnTermination?: boolean;
  Iops?: number;
  SnapshotId?: string;
  VolumeSize?: number;
  VolumeType?: VolumeType | string;
  KmsKeyId?: string;
  Throughput?: number;
  OutpostArn?: string;
  Encrypted?: boolean;
}
export interface BlockDeviceMapping {
  DeviceName?: string;
  VirtualName?: string;
  Ebs?: EbsBlockDevice;
  NoDevice?: string;
}
export interface CreateImageRequest {
  BlockDeviceMappings?: BlockDeviceMapping[];
  Description?: string;
  DryRun?: boolean;
  InstanceId: string | undefined;
  Name: string | undefined;
  NoReboot?: boolean;
  TagSpecifications?: TagSpecification[];
}
export interface CreateImageResult {
  ImageId?: string;
}
export interface InstanceEventWindowTimeRangeRequest {
  StartWeekDay?: WeekDay | string;
  StartHour?: number;
  EndWeekDay?: WeekDay | string;
  EndHour?: number;
}
export interface CreateInstanceEventWindowRequest {
  DryRun?: boolean;
  Name?: string;
  TimeRanges?: InstanceEventWindowTimeRangeRequest[];
  CronExpression?: string;
  TagSpecifications?: TagSpecification[];
}
export interface CreateInstanceEventWindowResult {
  InstanceEventWindow?: InstanceEventWindow;
}
export declare enum ContainerFormat {
  ova = "ova",
}
export declare enum DiskImageFormat {
  RAW = "RAW",
  VHD = "VHD",
  VMDK = "VMDK",
}
export interface ExportToS3TaskSpecification {
  ContainerFormat?: ContainerFormat | string;
  DiskImageFormat?: DiskImageFormat | string;
  S3Bucket?: string;
  S3Prefix?: string;
}
export declare enum ExportEnvironment {
  citrix = "citrix",
  microsoft = "microsoft",
  vmware = "vmware",
}
export interface CreateInstanceExportTaskRequest {
  Description?: string;
  ExportToS3Task: ExportToS3TaskSpecification | undefined;
  InstanceId: string | undefined;
  TargetEnvironment: ExportEnvironment | string | undefined;
  TagSpecifications?: TagSpecification[];
}
export interface ExportToS3Task {
  ContainerFormat?: ContainerFormat | string;
  DiskImageFormat?: DiskImageFormat | string;
  S3Bucket?: string;
  S3Key?: string;
}
export interface InstanceExportDetails {
  InstanceId?: string;
  TargetEnvironment?: ExportEnvironment | string;
}
export declare enum ExportTaskState {
  active = "active",
  cancelled = "cancelled",
  cancelling = "cancelling",
  completed = "completed",
}
export interface ExportTask {
  Description?: string;
  ExportTaskId?: string;
  ExportToS3Task?: ExportToS3Task;
  InstanceExportDetails?: InstanceExportDetails;
  State?: ExportTaskState | string;
  StatusMessage?: string;
  Tags?: Tag[];
}
export interface CreateInstanceExportTaskResult {
  ExportTask?: ExportTask;
}
export interface CreateInternetGatewayRequest {
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface InternetGateway {
  Attachments?: InternetGatewayAttachment[];
  InternetGatewayId?: string;
  OwnerId?: string;
  Tags?: Tag[];
}
export interface CreateInternetGatewayResult {
  InternetGateway?: InternetGateway;
}
export interface CreateIpamRequest {
  DryRun?: boolean;
  Description?: string;
  OperatingRegions?: AddIpamOperatingRegion[];
  TagSpecifications?: TagSpecification[];
  ClientToken?: string;
}
export interface IpamOperatingRegion {
  RegionName?: string;
}
export declare enum IpamState {
  create_complete = "create-complete",
  create_failed = "create-failed",
  create_in_progress = "create-in-progress",
  delete_complete = "delete-complete",
  delete_failed = "delete-failed",
  delete_in_progress = "delete-in-progress",
  isolate_complete = "isolate-complete",
  isolate_in_progress = "isolate-in-progress",
  modify_complete = "modify-complete",
  modify_failed = "modify-failed",
  modify_in_progress = "modify-in-progress",
  restore_in_progress = "restore-in-progress",
}
export interface Ipam {
  OwnerId?: string;
  IpamId?: string;
  IpamArn?: string;
  IpamRegion?: string;
  PublicDefaultScopeId?: string;
  PrivateDefaultScopeId?: string;
  ScopeCount?: number;
  Description?: string;
  OperatingRegions?: IpamOperatingRegion[];
  State?: IpamState | string;
  Tags?: Tag[];
}
export interface CreateIpamResult {
  Ipam?: Ipam;
}
export interface RequestIpamResourceTag {
  Key?: string;
  Value?: string;
}
export declare enum IpamPoolAwsService {
  ec2 = "ec2",
}
export interface CreateIpamPoolRequest {
  DryRun?: boolean;
  IpamScopeId: string | undefined;
  Locale?: string;
  SourceIpamPoolId?: string;
  Description?: string;
  AddressFamily: AddressFamily | string | undefined;
  AutoImport?: boolean;
  PubliclyAdvertisable?: boolean;
  AllocationMinNetmaskLength?: number;
  AllocationMaxNetmaskLength?: number;
  AllocationDefaultNetmaskLength?: number;
  AllocationResourceTags?: RequestIpamResourceTag[];
  TagSpecifications?: TagSpecification[];
  ClientToken?: string;
  AwsService?: IpamPoolAwsService | string;
}
export interface IpamResourceTag {
  Key?: string;
  Value?: string;
}
export declare enum IpamScopeType {
  private = "private",
  public = "public",
}
export declare enum IpamPoolState {
  create_complete = "create-complete",
  create_failed = "create-failed",
  create_in_progress = "create-in-progress",
  delete_complete = "delete-complete",
  delete_failed = "delete-failed",
  delete_in_progress = "delete-in-progress",
  isolate_complete = "isolate-complete",
  isolate_in_progress = "isolate-in-progress",
  modify_complete = "modify-complete",
  modify_failed = "modify-failed",
  modify_in_progress = "modify-in-progress",
  restore_in_progress = "restore-in-progress",
}
export interface IpamPool {
  OwnerId?: string;
  IpamPoolId?: string;
  SourceIpamPoolId?: string;
  IpamPoolArn?: string;
  IpamScopeArn?: string;
  IpamScopeType?: IpamScopeType | string;
  IpamArn?: string;
  IpamRegion?: string;
  Locale?: string;
  PoolDepth?: number;
  State?: IpamPoolState | string;
  StateMessage?: string;
  Description?: string;
  AutoImport?: boolean;
  PubliclyAdvertisable?: boolean;
  AddressFamily?: AddressFamily | string;
  AllocationMinNetmaskLength?: number;
  AllocationMaxNetmaskLength?: number;
  AllocationDefaultNetmaskLength?: number;
  AllocationResourceTags?: IpamResourceTag[];
  Tags?: Tag[];
  AwsService?: IpamPoolAwsService | string;
}
export interface CreateIpamPoolResult {
  IpamPool?: IpamPool;
}
export interface CreateIpamScopeRequest {
  DryRun?: boolean;
  IpamId: string | undefined;
  Description?: string;
  TagSpecifications?: TagSpecification[];
  ClientToken?: string;
}
export declare enum IpamScopeState {
  create_complete = "create-complete",
  create_failed = "create-failed",
  create_in_progress = "create-in-progress",
  delete_complete = "delete-complete",
  delete_failed = "delete-failed",
  delete_in_progress = "delete-in-progress",
  isolate_complete = "isolate-complete",
  isolate_in_progress = "isolate-in-progress",
  modify_complete = "modify-complete",
  modify_failed = "modify-failed",
  modify_in_progress = "modify-in-progress",
  restore_in_progress = "restore-in-progress",
}
export interface IpamScope {
  OwnerId?: string;
  IpamScopeId?: string;
  IpamScopeArn?: string;
  IpamArn?: string;
  IpamRegion?: string;
  IpamScopeType?: IpamScopeType | string;
  IsDefault?: boolean;
  Description?: string;
  PoolCount?: number;
  State?: IpamScopeState | string;
  Tags?: Tag[];
}
export interface CreateIpamScopeResult {
  IpamScope?: IpamScope;
}
export declare enum KeyFormat {
  pem = "pem",
  ppk = "ppk",
}
export declare enum KeyType {
  ed25519 = "ed25519",
  rsa = "rsa",
}
export interface CreateKeyPairRequest {
  KeyName: string | undefined;
  DryRun?: boolean;
  KeyType?: KeyType | string;
  TagSpecifications?: TagSpecification[];
  KeyFormat?: KeyFormat | string;
}
export interface KeyPair {
  KeyFingerprint?: string;
  KeyMaterial?: string;
  KeyName?: string;
  KeyPairId?: string;
  Tags?: Tag[];
}
export interface LaunchTemplateEbsBlockDeviceRequest {
  Encrypted?: boolean;
  DeleteOnTermination?: boolean;
  Iops?: number;
  KmsKeyId?: string;
  SnapshotId?: string;
  VolumeSize?: number;
  VolumeType?: VolumeType | string;
  Throughput?: number;
}
export interface LaunchTemplateBlockDeviceMappingRequest {
  DeviceName?: string;
  VirtualName?: string;
  Ebs?: LaunchTemplateEbsBlockDeviceRequest;
  NoDevice?: string;
}
export declare enum CapacityReservationPreference {
  none = "none",
  open = "open",
}
export interface CapacityReservationTarget {
  CapacityReservationId?: string;
  CapacityReservationResourceGroupArn?: string;
}
export interface LaunchTemplateCapacityReservationSpecificationRequest {
  CapacityReservationPreference?: CapacityReservationPreference | string;
  CapacityReservationTarget?: CapacityReservationTarget;
}
export interface LaunchTemplateCpuOptionsRequest {
  CoreCount?: number;
  ThreadsPerCore?: number;
}
export interface CreditSpecificationRequest {
  CpuCredits: string | undefined;
}
export interface ElasticGpuSpecification {
  Type: string | undefined;
}
export interface LaunchTemplateElasticInferenceAccelerator {
  Type: string | undefined;
  Count?: number;
}
export interface LaunchTemplateEnclaveOptionsRequest {
  Enabled?: boolean;
}
export interface LaunchTemplateHibernationOptionsRequest {
  Configured?: boolean;
}
export interface LaunchTemplateIamInstanceProfileSpecificationRequest {
  Arn?: string;
  Name?: string;
}
export declare enum ShutdownBehavior {
  stop = "stop",
  terminate = "terminate",
}
export declare enum MarketType {
  spot = "spot",
}
export declare enum InstanceInterruptionBehavior {
  hibernate = "hibernate",
  stop = "stop",
  terminate = "terminate",
}
export declare enum SpotInstanceType {
  one_time = "one-time",
  persistent = "persistent",
}
export interface LaunchTemplateSpotMarketOptionsRequest {
  MaxPrice?: string;
  SpotInstanceType?: SpotInstanceType | string;
  BlockDurationMinutes?: number;
  ValidUntil?: Date;
  InstanceInterruptionBehavior?: InstanceInterruptionBehavior | string;
}
export interface LaunchTemplateInstanceMarketOptionsRequest {
  MarketType?: MarketType | string;
  SpotOptions?: LaunchTemplateSpotMarketOptionsRequest;
}
export interface LaunchTemplateLicenseConfigurationRequest {
  LicenseConfigurationArn?: string;
}
export declare enum LaunchTemplateAutoRecoveryState {
  default = "default",
  disabled = "disabled",
}
export interface LaunchTemplateInstanceMaintenanceOptionsRequest {
  AutoRecovery?: LaunchTemplateAutoRecoveryState | string;
}
export declare enum LaunchTemplateInstanceMetadataEndpointState {
  disabled = "disabled",
  enabled = "enabled",
}
export declare enum LaunchTemplateInstanceMetadataProtocolIpv6 {
  disabled = "disabled",
  enabled = "enabled",
}
export declare enum LaunchTemplateHttpTokensState {
  optional = "optional",
  required = "required",
}
export declare enum LaunchTemplateInstanceMetadataTagsState {
  disabled = "disabled",
  enabled = "enabled",
}
export interface LaunchTemplateInstanceMetadataOptionsRequest {
  HttpTokens?: LaunchTemplateHttpTokensState | string;
  HttpPutResponseHopLimit?: number;
  HttpEndpoint?: LaunchTemplateInstanceMetadataEndpointState | string;
  HttpProtocolIpv6?: LaunchTemplateInstanceMetadataProtocolIpv6 | string;
  InstanceMetadataTags?: LaunchTemplateInstanceMetadataTagsState | string;
}
export interface LaunchTemplatesMonitoringRequest {
  Enabled?: boolean;
}
export interface Ipv4PrefixSpecificationRequest {
  Ipv4Prefix?: string;
}
export interface InstanceIpv6AddressRequest {
  Ipv6Address?: string;
}
export interface Ipv6PrefixSpecificationRequest {
  Ipv6Prefix?: string;
}
export interface PrivateIpAddressSpecification {
  Primary?: boolean;
  PrivateIpAddress?: string;
}
export interface LaunchTemplateInstanceNetworkInterfaceSpecificationRequest {
  AssociateCarrierIpAddress?: boolean;
  AssociatePublicIpAddress?: boolean;
  DeleteOnTermination?: boolean;
  Description?: string;
  DeviceIndex?: number;
  Groups?: string[];
  InterfaceType?: string;
  Ipv6AddressCount?: number;
  Ipv6Addresses?: InstanceIpv6AddressRequest[];
  NetworkInterfaceId?: string;
  PrivateIpAddress?: string;
  PrivateIpAddresses?: PrivateIpAddressSpecification[];
  SecondaryPrivateIpAddressCount?: number;
  SubnetId?: string;
  NetworkCardIndex?: number;
  Ipv4Prefixes?: Ipv4PrefixSpecificationRequest[];
  Ipv4PrefixCount?: number;
  Ipv6Prefixes?: Ipv6PrefixSpecificationRequest[];
  Ipv6PrefixCount?: number;
}
export interface LaunchTemplatePlacementRequest {
  AvailabilityZone?: string;
  Affinity?: string;
  GroupName?: string;
  HostId?: string;
  Tenancy?: Tenancy | string;
  SpreadDomain?: string;
  HostResourceGroupArn?: string;
  PartitionNumber?: number;
  GroupId?: string;
}
export interface LaunchTemplatePrivateDnsNameOptionsRequest {
  HostnameType?: HostnameType | string;
  EnableResourceNameDnsARecord?: boolean;
  EnableResourceNameDnsAAAARecord?: boolean;
}
export interface LaunchTemplateTagSpecificationRequest {
  ResourceType?: ResourceType | string;
  Tags?: Tag[];
}
export interface RequestLaunchTemplateData {
  KernelId?: string;
  EbsOptimized?: boolean;
  IamInstanceProfile?: LaunchTemplateIamInstanceProfileSpecificationRequest;
  BlockDeviceMappings?: LaunchTemplateBlockDeviceMappingRequest[];
  NetworkInterfaces?: LaunchTemplateInstanceNetworkInterfaceSpecificationRequest[];
  ImageId?: string;
  InstanceType?: _InstanceType | string;
  KeyName?: string;
  Monitoring?: LaunchTemplatesMonitoringRequest;
  Placement?: LaunchTemplatePlacementRequest;
  RamDiskId?: string;
  DisableApiTermination?: boolean;
  InstanceInitiatedShutdownBehavior?: ShutdownBehavior | string;
  UserData?: string;
  TagSpecifications?: LaunchTemplateTagSpecificationRequest[];
  ElasticGpuSpecifications?: ElasticGpuSpecification[];
  ElasticInferenceAccelerators?: LaunchTemplateElasticInferenceAccelerator[];
  SecurityGroupIds?: string[];
  SecurityGroups?: string[];
  InstanceMarketOptions?: LaunchTemplateInstanceMarketOptionsRequest;
  CreditSpecification?: CreditSpecificationRequest;
  CpuOptions?: LaunchTemplateCpuOptionsRequest;
  CapacityReservationSpecification?: LaunchTemplateCapacityReservationSpecificationRequest;
  LicenseSpecifications?: LaunchTemplateLicenseConfigurationRequest[];
  HibernationOptions?: LaunchTemplateHibernationOptionsRequest;
  MetadataOptions?: LaunchTemplateInstanceMetadataOptionsRequest;
  EnclaveOptions?: LaunchTemplateEnclaveOptionsRequest;
  InstanceRequirements?: InstanceRequirementsRequest;
  PrivateDnsNameOptions?: LaunchTemplatePrivateDnsNameOptionsRequest;
  MaintenanceOptions?: LaunchTemplateInstanceMaintenanceOptionsRequest;
  DisableApiStop?: boolean;
}
export interface CreateLaunchTemplateRequest {
  DryRun?: boolean;
  ClientToken?: string;
  LaunchTemplateName: string | undefined;
  VersionDescription?: string;
  LaunchTemplateData: RequestLaunchTemplateData | undefined;
  TagSpecifications?: TagSpecification[];
}
export interface LaunchTemplate {
  LaunchTemplateId?: string;
  LaunchTemplateName?: string;
  CreateTime?: Date;
  CreatedBy?: string;
  DefaultVersionNumber?: number;
  LatestVersionNumber?: number;
  Tags?: Tag[];
}
export interface ValidationError {
  Code?: string;
  Message?: string;
}
export interface ValidationWarning {
  Errors?: ValidationError[];
}
export interface CreateLaunchTemplateResult {
  LaunchTemplate?: LaunchTemplate;
  Warning?: ValidationWarning;
}
export interface CreateLaunchTemplateVersionRequest {
  DryRun?: boolean;
  ClientToken?: string;
  LaunchTemplateId?: string;
  LaunchTemplateName?: string;
  SourceVersion?: string;
  VersionDescription?: string;
  LaunchTemplateData: RequestLaunchTemplateData | undefined;
}
export interface LaunchTemplateEbsBlockDevice {
  Encrypted?: boolean;
  DeleteOnTermination?: boolean;
  Iops?: number;
  KmsKeyId?: string;
  SnapshotId?: string;
  VolumeSize?: number;
  VolumeType?: VolumeType | string;
  Throughput?: number;
}
export interface LaunchTemplateBlockDeviceMapping {
  DeviceName?: string;
  VirtualName?: string;
  Ebs?: LaunchTemplateEbsBlockDevice;
  NoDevice?: string;
}
export interface CapacityReservationTargetResponse {
  CapacityReservationId?: string;
  CapacityReservationResourceGroupArn?: string;
}
export interface LaunchTemplateCapacityReservationSpecificationResponse {
  CapacityReservationPreference?: CapacityReservationPreference | string;
  CapacityReservationTarget?: CapacityReservationTargetResponse;
}
export interface LaunchTemplateCpuOptions {
  CoreCount?: number;
  ThreadsPerCore?: number;
}
export interface CreditSpecification {
  CpuCredits?: string;
}
export interface ElasticGpuSpecificationResponse {
  Type?: string;
}
export interface LaunchTemplateElasticInferenceAcceleratorResponse {
  Type?: string;
  Count?: number;
}
export interface LaunchTemplateEnclaveOptions {
  Enabled?: boolean;
}
export interface LaunchTemplateHibernationOptions {
  Configured?: boolean;
}
export interface LaunchTemplateIamInstanceProfileSpecification {
  Arn?: string;
  Name?: string;
}
export interface LaunchTemplateSpotMarketOptions {
  MaxPrice?: string;
  SpotInstanceType?: SpotInstanceType | string;
  BlockDurationMinutes?: number;
  ValidUntil?: Date;
  InstanceInterruptionBehavior?: InstanceInterruptionBehavior | string;
}
export interface LaunchTemplateInstanceMarketOptions {
  MarketType?: MarketType | string;
  SpotOptions?: LaunchTemplateSpotMarketOptions;
}
export interface LaunchTemplateLicenseConfiguration {
  LicenseConfigurationArn?: string;
}
export interface LaunchTemplateInstanceMaintenanceOptions {
  AutoRecovery?: LaunchTemplateAutoRecoveryState | string;
}
export declare enum LaunchTemplateInstanceMetadataOptionsState {
  applied = "applied",
  pending = "pending",
}
export interface LaunchTemplateInstanceMetadataOptions {
  State?: LaunchTemplateInstanceMetadataOptionsState | string;
  HttpTokens?: LaunchTemplateHttpTokensState | string;
  HttpPutResponseHopLimit?: number;
  HttpEndpoint?: LaunchTemplateInstanceMetadataEndpointState | string;
  HttpProtocolIpv6?: LaunchTemplateInstanceMetadataProtocolIpv6 | string;
  InstanceMetadataTags?: LaunchTemplateInstanceMetadataTagsState | string;
}
export interface LaunchTemplatesMonitoring {
  Enabled?: boolean;
}
export interface Ipv4PrefixSpecificationResponse {
  Ipv4Prefix?: string;
}
export interface InstanceIpv6Address {
  Ipv6Address?: string;
}
export interface Ipv6PrefixSpecificationResponse {
  Ipv6Prefix?: string;
}
export interface LaunchTemplateInstanceNetworkInterfaceSpecification {
  AssociateCarrierIpAddress?: boolean;
  AssociatePublicIpAddress?: boolean;
  DeleteOnTermination?: boolean;
  Description?: string;
  DeviceIndex?: number;
  Groups?: string[];
  InterfaceType?: string;
  Ipv6AddressCount?: number;
  Ipv6Addresses?: InstanceIpv6Address[];
  NetworkInterfaceId?: string;
  PrivateIpAddress?: string;
  PrivateIpAddresses?: PrivateIpAddressSpecification[];
  SecondaryPrivateIpAddressCount?: number;
  SubnetId?: string;
  NetworkCardIndex?: number;
  Ipv4Prefixes?: Ipv4PrefixSpecificationResponse[];
  Ipv4PrefixCount?: number;
  Ipv6Prefixes?: Ipv6PrefixSpecificationResponse[];
  Ipv6PrefixCount?: number;
}
export interface LaunchTemplatePlacement {
  AvailabilityZone?: string;
  Affinity?: string;
  GroupName?: string;
  HostId?: string;
  Tenancy?: Tenancy | string;
  SpreadDomain?: string;
  HostResourceGroupArn?: string;
  PartitionNumber?: number;
  GroupId?: string;
}
export interface LaunchTemplatePrivateDnsNameOptions {
  HostnameType?: HostnameType | string;
  EnableResourceNameDnsARecord?: boolean;
  EnableResourceNameDnsAAAARecord?: boolean;
}
export interface LaunchTemplateTagSpecification {
  ResourceType?: ResourceType | string;
  Tags?: Tag[];
}
export interface ResponseLaunchTemplateData {
  KernelId?: string;
  EbsOptimized?: boolean;
  IamInstanceProfile?: LaunchTemplateIamInstanceProfileSpecification;
  BlockDeviceMappings?: LaunchTemplateBlockDeviceMapping[];
  NetworkInterfaces?: LaunchTemplateInstanceNetworkInterfaceSpecification[];
  ImageId?: string;
  InstanceType?: _InstanceType | string;
  KeyName?: string;
  Monitoring?: LaunchTemplatesMonitoring;
  Placement?: LaunchTemplatePlacement;
  RamDiskId?: string;
  DisableApiTermination?: boolean;
  InstanceInitiatedShutdownBehavior?: ShutdownBehavior | string;
  UserData?: string;
  TagSpecifications?: LaunchTemplateTagSpecification[];
  ElasticGpuSpecifications?: ElasticGpuSpecificationResponse[];
  ElasticInferenceAccelerators?: LaunchTemplateElasticInferenceAcceleratorResponse[];
  SecurityGroupIds?: string[];
  SecurityGroups?: string[];
  InstanceMarketOptions?: LaunchTemplateInstanceMarketOptions;
  CreditSpecification?: CreditSpecification;
  CpuOptions?: LaunchTemplateCpuOptions;
  CapacityReservationSpecification?: LaunchTemplateCapacityReservationSpecificationResponse;
  LicenseSpecifications?: LaunchTemplateLicenseConfiguration[];
  HibernationOptions?: LaunchTemplateHibernationOptions;
  MetadataOptions?: LaunchTemplateInstanceMetadataOptions;
  EnclaveOptions?: LaunchTemplateEnclaveOptions;
  InstanceRequirements?: InstanceRequirements;
  PrivateDnsNameOptions?: LaunchTemplatePrivateDnsNameOptions;
  MaintenanceOptions?: LaunchTemplateInstanceMaintenanceOptions;
  DisableApiStop?: boolean;
}
export interface LaunchTemplateVersion {
  LaunchTemplateId?: string;
  LaunchTemplateName?: string;
  VersionNumber?: number;
  VersionDescription?: string;
  CreateTime?: Date;
  CreatedBy?: string;
  DefaultVersion?: boolean;
  LaunchTemplateData?: ResponseLaunchTemplateData;
}
export interface CreateLaunchTemplateVersionResult {
  LaunchTemplateVersion?: LaunchTemplateVersion;
  Warning?: ValidationWarning;
}
export interface CreateLocalGatewayRouteRequest {
  DestinationCidrBlock: string | undefined;
  LocalGatewayRouteTableId: string | undefined;
  LocalGatewayVirtualInterfaceGroupId?: string;
  DryRun?: boolean;
  NetworkInterfaceId?: string;
}
export declare enum LocalGatewayRouteState {
  active = "active",
  blackhole = "blackhole",
  deleted = "deleted",
  deleting = "deleting",
  pending = "pending",
}
export declare enum LocalGatewayRouteType {
  propagated = "propagated",
  static = "static",
}
export interface LocalGatewayRoute {
  DestinationCidrBlock?: string;
  LocalGatewayVirtualInterfaceGroupId?: string;
  Type?: LocalGatewayRouteType | string;
  State?: LocalGatewayRouteState | string;
  LocalGatewayRouteTableId?: string;
  LocalGatewayRouteTableArn?: string;
  OwnerId?: string;
  SubnetId?: string;
  CoipPoolId?: string;
  NetworkInterfaceId?: string;
}
export interface CreateLocalGatewayRouteResult {
  Route?: LocalGatewayRoute;
}
export declare enum LocalGatewayRouteTableMode {
  coip = "coip",
  direct_vpc_routing = "direct-vpc-routing",
}
export interface CreateLocalGatewayRouteTableRequest {
  LocalGatewayId: string | undefined;
  Mode?: LocalGatewayRouteTableMode | string;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface StateReason {
  Code?: string;
  Message?: string;
}
export interface LocalGatewayRouteTable {
  LocalGatewayRouteTableId?: string;
  LocalGatewayRouteTableArn?: string;
  LocalGatewayId?: string;
  OutpostArn?: string;
  OwnerId?: string;
  State?: string;
  Tags?: Tag[];
  Mode?: LocalGatewayRouteTableMode | string;
  StateReason?: StateReason;
}
export interface CreateLocalGatewayRouteTableResult {
  LocalGatewayRouteTable?: LocalGatewayRouteTable;
}
export interface CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest {
  LocalGatewayRouteTableId: string | undefined;
  LocalGatewayVirtualInterfaceGroupId: string | undefined;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface LocalGatewayRouteTableVirtualInterfaceGroupAssociation {
  LocalGatewayRouteTableVirtualInterfaceGroupAssociationId?: string;
  LocalGatewayVirtualInterfaceGroupId?: string;
  LocalGatewayId?: string;
  LocalGatewayRouteTableId?: string;
  LocalGatewayRouteTableArn?: string;
  OwnerId?: string;
  State?: string;
  Tags?: Tag[];
}
export interface CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult {
  LocalGatewayRouteTableVirtualInterfaceGroupAssociation?: LocalGatewayRouteTableVirtualInterfaceGroupAssociation;
}
export interface CreateLocalGatewayRouteTableVpcAssociationRequest {
  LocalGatewayRouteTableId: string | undefined;
  VpcId: string | undefined;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface LocalGatewayRouteTableVpcAssociation {
  LocalGatewayRouteTableVpcAssociationId?: string;
  LocalGatewayRouteTableId?: string;
  LocalGatewayRouteTableArn?: string;
  LocalGatewayId?: string;
  VpcId?: string;
  OwnerId?: string;
  State?: string;
  Tags?: Tag[];
}
export interface CreateLocalGatewayRouteTableVpcAssociationResult {
  LocalGatewayRouteTableVpcAssociation?: LocalGatewayRouteTableVpcAssociation;
}
export interface CreateManagedPrefixListRequest {
  DryRun?: boolean;
  PrefixListName: string | undefined;
  Entries?: AddPrefixListEntry[];
  MaxEntries: number | undefined;
  TagSpecifications?: TagSpecification[];
  AddressFamily: string | undefined;
  ClientToken?: string;
}
export declare enum PrefixListState {
  create_complete = "create-complete",
  create_failed = "create-failed",
  create_in_progress = "create-in-progress",
  delete_complete = "delete-complete",
  delete_failed = "delete-failed",
  delete_in_progress = "delete-in-progress",
  modify_complete = "modify-complete",
  modify_failed = "modify-failed",
  modify_in_progress = "modify-in-progress",
  restore_complete = "restore-complete",
  restore_failed = "restore-failed",
  restore_in_progress = "restore-in-progress",
}
export interface ManagedPrefixList {
  PrefixListId?: string;
  AddressFamily?: string;
  State?: PrefixListState | string;
  StateMessage?: string;
  PrefixListArn?: string;
  PrefixListName?: string;
  MaxEntries?: number;
  Version?: number;
  Tags?: Tag[];
  OwnerId?: string;
}
export interface CreateManagedPrefixListResult {
  PrefixList?: ManagedPrefixList;
}
export declare enum ConnectivityType {
  PRIVATE = "private",
  PUBLIC = "public",
}
export interface CreateNatGatewayRequest {
  AllocationId?: string;
  ClientToken?: string;
  DryRun?: boolean;
  SubnetId: string | undefined;
  TagSpecifications?: TagSpecification[];
  ConnectivityType?: ConnectivityType | string;
  PrivateIpAddress?: string;
}
export interface NatGatewayAddress {
  AllocationId?: string;
  NetworkInterfaceId?: string;
  PrivateIp?: string;
  PublicIp?: string;
}
export interface ProvisionedBandwidth {
  ProvisionTime?: Date;
  Provisioned?: string;
  RequestTime?: Date;
  Requested?: string;
  Status?: string;
}
export declare enum NatGatewayState {
  AVAILABLE = "available",
  DELETED = "deleted",
  DELETING = "deleting",
  FAILED = "failed",
  PENDING = "pending",
}
export interface NatGateway {
  CreateTime?: Date;
  DeleteTime?: Date;
  FailureCode?: string;
  FailureMessage?: string;
  NatGatewayAddresses?: NatGatewayAddress[];
  NatGatewayId?: string;
  ProvisionedBandwidth?: ProvisionedBandwidth;
  State?: NatGatewayState | string;
  SubnetId?: string;
  VpcId?: string;
  Tags?: Tag[];
  ConnectivityType?: ConnectivityType | string;
}
export interface CreateNatGatewayResult {
  ClientToken?: string;
  NatGateway?: NatGateway;
}
export interface CreateNetworkAclRequest {
  DryRun?: boolean;
  VpcId: string | undefined;
  TagSpecifications?: TagSpecification[];
}
export interface NetworkAclAssociation {
  NetworkAclAssociationId?: string;
  NetworkAclId?: string;
  SubnetId?: string;
}
export interface IcmpTypeCode {
  Code?: number;
  Type?: number;
}
export declare enum RuleAction {
  allow = "allow",
  deny = "deny",
}
export interface NetworkAclEntry {
  CidrBlock?: string;
  Egress?: boolean;
  IcmpTypeCode?: IcmpTypeCode;
  Ipv6CidrBlock?: string;
  PortRange?: PortRange;
  Protocol?: string;
  RuleAction?: RuleAction | string;
  RuleNumber?: number;
}
export interface NetworkAcl {
  Associations?: NetworkAclAssociation[];
  Entries?: NetworkAclEntry[];
  IsDefault?: boolean;
  NetworkAclId?: string;
  Tags?: Tag[];
  VpcId?: string;
  OwnerId?: string;
}
export interface CreateNetworkAclResult {
  NetworkAcl?: NetworkAcl;
}
export interface CreateNetworkAclEntryRequest {
  CidrBlock?: string;
  DryRun?: boolean;
  Egress: boolean | undefined;
  IcmpTypeCode?: IcmpTypeCode;
  Ipv6CidrBlock?: string;
  NetworkAclId: string | undefined;
  PortRange?: PortRange;
  Protocol: string | undefined;
  RuleAction: RuleAction | string | undefined;
  RuleNumber: number | undefined;
}
export interface CreateNetworkInsightsAccessScopeRequest {
  MatchPaths?: AccessScopePathRequest[];
  ExcludePaths?: AccessScopePathRequest[];
  ClientToken?: string;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface NetworkInsightsAccessScope {
  NetworkInsightsAccessScopeId?: string;
  NetworkInsightsAccessScopeArn?: string;
  CreatedDate?: Date;
  UpdatedDate?: Date;
  Tags?: Tag[];
}
export interface NetworkInsightsAccessScopeContent {
  NetworkInsightsAccessScopeId?: string;
  MatchPaths?: AccessScopePath[];
  ExcludePaths?: AccessScopePath[];
}
export interface CreateNetworkInsightsAccessScopeResult {
  NetworkInsightsAccessScope?: NetworkInsightsAccessScope;
  NetworkInsightsAccessScopeContent?: NetworkInsightsAccessScopeContent;
}
export interface CreateNetworkInsightsPathRequest {
  SourceIp?: string;
  DestinationIp?: string;
  Source: string | undefined;
  Destination: string | undefined;
  Protocol: Protocol | string | undefined;
  DestinationPort?: number;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
  ClientToken?: string;
}
export interface NetworkInsightsPath {
  NetworkInsightsPathId?: string;
  NetworkInsightsPathArn?: string;
  CreatedDate?: Date;
  Source?: string;
  Destination?: string;
  SourceArn?: string;
  DestinationArn?: string;
  SourceIp?: string;
  DestinationIp?: string;
  Protocol?: Protocol | string;
  DestinationPort?: number;
  Tags?: Tag[];
}
export interface CreateNetworkInsightsPathResult {
  NetworkInsightsPath?: NetworkInsightsPath;
}
export declare enum NetworkInterfaceCreationType {
  branch = "branch",
  efa = "efa",
  trunk = "trunk",
}
export interface CreateNetworkInterfaceRequest {
  Description?: string;
  DryRun?: boolean;
  Groups?: string[];
  Ipv6AddressCount?: number;
  Ipv6Addresses?: InstanceIpv6Address[];
  PrivateIpAddress?: string;
  PrivateIpAddresses?: PrivateIpAddressSpecification[];
  SecondaryPrivateIpAddressCount?: number;
  Ipv4Prefixes?: Ipv4PrefixSpecificationRequest[];
  Ipv4PrefixCount?: number;
  Ipv6Prefixes?: Ipv6PrefixSpecificationRequest[];
  Ipv6PrefixCount?: number;
  InterfaceType?: NetworkInterfaceCreationType | string;
  SubnetId: string | undefined;
  TagSpecifications?: TagSpecification[];
  ClientToken?: string;
}
export interface NetworkInterfaceAssociation {
  AllocationId?: string;
  AssociationId?: string;
  IpOwnerId?: string;
  PublicDnsName?: string;
  PublicIp?: string;
  CustomerOwnedIp?: string;
  CarrierIp?: string;
}
export interface AttachmentEnaSrdUdpSpecification {
  EnaSrdUdpEnabled?: boolean;
}
export interface AttachmentEnaSrdSpecification {
  EnaSrdEnabled?: boolean;
  EnaSrdUdpSpecification?: AttachmentEnaSrdUdpSpecification;
}
export interface NetworkInterfaceAttachment {
  AttachTime?: Date;
  AttachmentId?: string;
  DeleteOnTermination?: boolean;
  DeviceIndex?: number;
  NetworkCardIndex?: number;
  InstanceId?: string;
  InstanceOwnerId?: string;
  Status?: AttachmentStatus | string;
  EnaSrdSpecification?: AttachmentEnaSrdSpecification;
}
export interface GroupIdentifier {
  GroupName?: string;
  GroupId?: string;
}
export declare enum NetworkInterfaceType {
  api_gateway_managed = "api_gateway_managed",
  aws_codestar_connections_managed = "aws_codestar_connections_managed",
  branch = "branch",
  efa = "efa",
  gateway_load_balancer = "gateway_load_balancer",
  gateway_load_balancer_endpoint = "gateway_load_balancer_endpoint",
  global_accelerator_managed = "global_accelerator_managed",
  interface = "interface",
  iot_rules_managed = "iot_rules_managed",
  lambda = "lambda",
  load_balancer = "load_balancer",
  natGateway = "natGateway",
  network_load_balancer = "network_load_balancer",
  quicksight = "quicksight",
  transit_gateway = "transit_gateway",
  trunk = "trunk",
  vpc_endpoint = "vpc_endpoint",
}
export interface NetworkInterfaceIpv6Address {
  Ipv6Address?: string;
}
export interface Ipv6PrefixSpecification {
  Ipv6Prefix?: string;
}
export interface NetworkInterfacePrivateIpAddress {
  Association?: NetworkInterfaceAssociation;
  Primary?: boolean;
  PrivateDnsName?: string;
  PrivateIpAddress?: string;
}
export declare enum NetworkInterfaceStatus {
  associated = "associated",
  attaching = "attaching",
  available = "available",
  detaching = "detaching",
  in_use = "in-use",
}
export interface NetworkInterface {
  Association?: NetworkInterfaceAssociation;
  Attachment?: NetworkInterfaceAttachment;
  AvailabilityZone?: string;
  Description?: string;
  Groups?: GroupIdentifier[];
  InterfaceType?: NetworkInterfaceType | string;
  Ipv6Addresses?: NetworkInterfaceIpv6Address[];
  MacAddress?: string;
  NetworkInterfaceId?: string;
  OutpostArn?: string;
  OwnerId?: string;
  PrivateDnsName?: string;
  PrivateIpAddress?: string;
  PrivateIpAddresses?: NetworkInterfacePrivateIpAddress[];
  Ipv4Prefixes?: Ipv4PrefixSpecification[];
  Ipv6Prefixes?: Ipv6PrefixSpecification[];
  RequesterId?: string;
  RequesterManaged?: boolean;
  SourceDestCheck?: boolean;
  Status?: NetworkInterfaceStatus | string;
  SubnetId?: string;
  TagSet?: Tag[];
  VpcId?: string;
  DenyAllIgwTraffic?: boolean;
  Ipv6Native?: boolean;
  Ipv6Address?: string;
}
export interface CreateNetworkInterfaceResult {
  NetworkInterface?: NetworkInterface;
  ClientToken?: string;
}
export declare enum InterfacePermissionType {
  EIP_ASSOCIATE = "EIP-ASSOCIATE",
  INSTANCE_ATTACH = "INSTANCE-ATTACH",
}
export interface CreateNetworkInterfacePermissionRequest {
  NetworkInterfaceId: string | undefined;
  AwsAccountId?: string;
  AwsService?: string;
  Permission: InterfacePermissionType | string | undefined;
  DryRun?: boolean;
}
export declare enum NetworkInterfacePermissionStateCode {
  granted = "granted",
  pending = "pending",
  revoked = "revoked",
  revoking = "revoking",
}
export interface NetworkInterfacePermissionState {
  State?: NetworkInterfacePermissionStateCode | string;
  StatusMessage?: string;
}
export interface NetworkInterfacePermission {
  NetworkInterfacePermissionId?: string;
  NetworkInterfaceId?: string;
  AwsAccountId?: string;
  AwsService?: string;
  Permission?: InterfacePermissionType | string;
  PermissionState?: NetworkInterfacePermissionState;
}
export interface CreateNetworkInterfacePermissionResult {
  InterfacePermission?: NetworkInterfacePermission;
}
export declare enum SpreadLevel {
  host = "host",
  rack = "rack",
}
export declare enum PlacementStrategy {
  cluster = "cluster",
  partition = "partition",
  spread = "spread",
}
export interface CreatePlacementGroupRequest {
  DryRun?: boolean;
  GroupName?: string;
  Strategy?: PlacementStrategy | string;
  PartitionCount?: number;
  TagSpecifications?: TagSpecification[];
  SpreadLevel?: SpreadLevel | string;
}
export declare enum PlacementGroupState {
  available = "available",
  deleted = "deleted",
  deleting = "deleting",
  pending = "pending",
}
export interface PlacementGroup {
  GroupName?: string;
  State?: PlacementGroupState | string;
  Strategy?: PlacementStrategy | string;
  PartitionCount?: number;
  GroupId?: string;
  Tags?: Tag[];
  GroupArn?: string;
  SpreadLevel?: SpreadLevel | string;
}
export interface CreatePlacementGroupResult {
  PlacementGroup?: PlacementGroup;
}
export interface CreatePublicIpv4PoolRequest {
  DryRun?: boolean;
  TagSpecifications?: TagSpecification[];
}
export interface CreatePublicIpv4PoolResult {
  PoolId?: string;
}
export interface CreateReplaceRootVolumeTaskRequest {
  InstanceId: string | undefined;
  SnapshotId?: string;
  ClientToken?: string;
  DryRun?: boolean;
  TagSpecifications?: TagSpecification[];
  ImageId?: string;
  DeleteReplacedRootVolume?: boolean;
}
export declare enum ReplaceRootVolumeTaskState {
  failed = "failed",
  failed_detached = "failed-detached",
  failing = "failing",
  in_progress = "in-progress",
  pending = "pending",
  succeeded = "succeeded",
}
export interface ReplaceRootVolumeTask {
  ReplaceRootVolumeTaskId?: string;
  InstanceId?: string;
  TaskState?: ReplaceRootVolumeTaskState | string;
  StartTime?: string;
  CompleteTime?: string;
  Tags?: Tag[];
  ImageId?: string;
  SnapshotId?: string;
  DeleteReplacedRootVolume?: boolean;
}
export interface CreateReplaceRootVolumeTaskResult {
  ReplaceRootVolumeTask?: ReplaceRootVolumeTask;
}
export interface PriceScheduleSpecification {
  CurrencyCode?: CurrencyCodeValues | string;
  Price?: number;
  Term?: number;
}
export interface CreateReservedInstancesListingRequest {
  ClientToken: string | undefined;
  InstanceCount: number | undefined;
  PriceSchedules: PriceScheduleSpecification[] | undefined;
  ReservedInstancesId: string | undefined;
}
export interface CreateReservedInstancesListingResult {
  ReservedInstancesListings?: ReservedInstancesListing[];
}
export interface CreateRestoreImageTaskRequest {
  Bucket: string | undefined;
  ObjectKey: string | undefined;
  Name?: string;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface CreateRestoreImageTaskResult {
  ImageId?: string;
}
export interface CreateRouteRequest {
  DestinationCidrBlock?: string;
  DestinationIpv6CidrBlock?: string;
  DestinationPrefixListId?: string;
  DryRun?: boolean;
  VpcEndpointId?: string;
  EgressOnlyInternetGatewayId?: string;
  GatewayId?: string;
  InstanceId?: string;
  NatGatewayId?: string;
  TransitGatewayId?: string;
  LocalGatewayId?: string;
  CarrierGatewayId?: string;
  NetworkInterfaceId?: string;
  RouteTableId: string | undefined;
  VpcPeeringConnectionId?: string;
  CoreNetworkArn?: string;
}
export interface CreateRouteResult {
  Return?: boolean;
}
export interface CreateRouteTableRequest {
  DryRun?: boolean;
  VpcId: string | undefined;
  TagSpecifications?: TagSpecification[];
}
export interface RouteTableAssociation {
  Main?: boolean;
  RouteTableAssociationId?: string;
  RouteTableId?: string;
  SubnetId?: string;
  GatewayId?: string;
  AssociationState?: RouteTableAssociationState;
}
export interface PropagatingVgw {
  GatewayId?: string;
}
export declare enum RouteOrigin {
  CreateRoute = "CreateRoute",
  CreateRouteTable = "CreateRouteTable",
  EnableVgwRoutePropagation = "EnableVgwRoutePropagation",
}
export declare enum RouteState {
  active = "active",
  blackhole = "blackhole",
}
export interface Route {
  DestinationCidrBlock?: string;
  DestinationIpv6CidrBlock?: string;
  DestinationPrefixListId?: string;
  EgressOnlyInternetGatewayId?: string;
  GatewayId?: string;
  InstanceId?: string;
  InstanceOwnerId?: string;
  NatGatewayId?: string;
  TransitGatewayId?: string;
  LocalGatewayId?: string;
  CarrierGatewayId?: string;
  NetworkInterfaceId?: string;
  Origin?: RouteOrigin | string;
  State?: RouteState | string;
  VpcPeeringConnectionId?: string;
  CoreNetworkArn?: string;
}
export interface RouteTable {
  Associations?: RouteTableAssociation[];
  PropagatingVgws?: PropagatingVgw[];
  RouteTableId?: string;
  Routes?: Route[];
  Tags?: Tag[];
  VpcId?: string;
  OwnerId?: string;
}
export interface CreateRouteTableResult {
  RouteTable?: RouteTable;
}
export interface CreateSecurityGroupRequest {
  Description: string | undefined;
  GroupName: string | undefined;
  VpcId?: string;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface CreateSecurityGroupResult {
  GroupId?: string;
  Tags?: Tag[];
}
export interface CreateSnapshotRequest {
  Description?: string;
  OutpostArn?: string;
  VolumeId: string | undefined;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export declare enum SnapshotState {
  completed = "completed",
  error = "error",
  pending = "pending",
  recoverable = "recoverable",
  recovering = "recovering",
}
export declare enum StorageTier {
  archive = "archive",
  standard = "standard",
}
export interface Snapshot {
  DataEncryptionKeyId?: string;
  Description?: string;
  Encrypted?: boolean;
  KmsKeyId?: string;
  OwnerId?: string;
  Progress?: string;
  SnapshotId?: string;
  StartTime?: Date;
  State?: SnapshotState | string;
  StateMessage?: string;
  VolumeId?: string;
  VolumeSize?: number;
  OwnerAlias?: string;
  OutpostArn?: string;
  Tags?: Tag[];
  StorageTier?: StorageTier | string;
  RestoreExpiryTime?: Date;
}
export declare enum CopyTagsFromSource {
  volume = "volume",
}
export interface InstanceSpecification {
  InstanceId?: string;
  ExcludeBootVolume?: boolean;
  ExcludeDataVolumeIds?: string[];
}
export interface CreateSnapshotsRequest {
  Description?: string;
  InstanceSpecification: InstanceSpecification | undefined;
  OutpostArn?: string;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
  CopyTagsFromSource?: CopyTagsFromSource | string;
}
export declare const CreateCoipCidrResultFilterSensitiveLog: (
  obj: CreateCoipCidrResult
) => any;
export declare const CreateCoipPoolRequestFilterSensitiveLog: (
  obj: CreateCoipPoolRequest
) => any;
export declare const CoipPoolFilterSensitiveLog: (obj: CoipPool) => any;
export declare const CreateCoipPoolResultFilterSensitiveLog: (
  obj: CreateCoipPoolResult
) => any;
export declare const CreateCustomerGatewayRequestFilterSensitiveLog: (
  obj: CreateCustomerGatewayRequest
) => any;
export declare const CustomerGatewayFilterSensitiveLog: (
  obj: CustomerGateway
) => any;
export declare const CreateCustomerGatewayResultFilterSensitiveLog: (
  obj: CreateCustomerGatewayResult
) => any;
export declare const CreateDefaultSubnetRequestFilterSensitiveLog: (
  obj: CreateDefaultSubnetRequest
) => any;
export declare const PrivateDnsNameOptionsOnLaunchFilterSensitiveLog: (
  obj: PrivateDnsNameOptionsOnLaunch
) => any;
export declare const SubnetFilterSensitiveLog: (obj: Subnet) => any;
export declare const CreateDefaultSubnetResultFilterSensitiveLog: (
  obj: CreateDefaultSubnetResult
) => any;
export declare const CreateDefaultVpcRequestFilterSensitiveLog: (
  obj: CreateDefaultVpcRequest
) => any;
export declare const VpcFilterSensitiveLog: (obj: Vpc) => any;
export declare const CreateDefaultVpcResultFilterSensitiveLog: (
  obj: CreateDefaultVpcResult
) => any;
export declare const NewDhcpConfigurationFilterSensitiveLog: (
  obj: NewDhcpConfiguration
) => any;
export declare const CreateDhcpOptionsRequestFilterSensitiveLog: (
  obj: CreateDhcpOptionsRequest
) => any;
export declare const AttributeValueFilterSensitiveLog: (
  obj: AttributeValue
) => any;
export declare const DhcpConfigurationFilterSensitiveLog: (
  obj: DhcpConfiguration
) => any;
export declare const DhcpOptionsFilterSensitiveLog: (obj: DhcpOptions) => any;
export declare const CreateDhcpOptionsResultFilterSensitiveLog: (
  obj: CreateDhcpOptionsResult
) => any;
export declare const CreateEgressOnlyInternetGatewayRequestFilterSensitiveLog: (
  obj: CreateEgressOnlyInternetGatewayRequest
) => any;
export declare const InternetGatewayAttachmentFilterSensitiveLog: (
  obj: InternetGatewayAttachment
) => any;
export declare const EgressOnlyInternetGatewayFilterSensitiveLog: (
  obj: EgressOnlyInternetGateway
) => any;
export declare const CreateEgressOnlyInternetGatewayResultFilterSensitiveLog: (
  obj: CreateEgressOnlyInternetGatewayResult
) => any;
export declare const FleetLaunchTemplateSpecificationRequestFilterSensitiveLog: (
  obj: FleetLaunchTemplateSpecificationRequest
) => any;
export declare const BaselineEbsBandwidthMbpsRequestFilterSensitiveLog: (
  obj: BaselineEbsBandwidthMbpsRequest
) => any;
export declare const MemoryGiBPerVCpuRequestFilterSensitiveLog: (
  obj: MemoryGiBPerVCpuRequest
) => any;
export declare const MemoryMiBRequestFilterSensitiveLog: (
  obj: MemoryMiBRequest
) => any;
export declare const NetworkBandwidthGbpsRequestFilterSensitiveLog: (
  obj: NetworkBandwidthGbpsRequest
) => any;
export declare const NetworkInterfaceCountRequestFilterSensitiveLog: (
  obj: NetworkInterfaceCountRequest
) => any;
export declare const TotalLocalStorageGBRequestFilterSensitiveLog: (
  obj: TotalLocalStorageGBRequest
) => any;
export declare const VCpuCountRangeRequestFilterSensitiveLog: (
  obj: VCpuCountRangeRequest
) => any;
export declare const InstanceRequirementsRequestFilterSensitiveLog: (
  obj: InstanceRequirementsRequest
) => any;
export declare const PlacementFilterSensitiveLog: (obj: Placement) => any;
export declare const FleetLaunchTemplateOverridesRequestFilterSensitiveLog: (
  obj: FleetLaunchTemplateOverridesRequest
) => any;
export declare const FleetLaunchTemplateConfigRequestFilterSensitiveLog: (
  obj: FleetLaunchTemplateConfigRequest
) => any;
export declare const CapacityReservationOptionsRequestFilterSensitiveLog: (
  obj: CapacityReservationOptionsRequest
) => any;
export declare const OnDemandOptionsRequestFilterSensitiveLog: (
  obj: OnDemandOptionsRequest
) => any;
export declare const FleetSpotCapacityRebalanceRequestFilterSensitiveLog: (
  obj: FleetSpotCapacityRebalanceRequest
) => any;
export declare const FleetSpotMaintenanceStrategiesRequestFilterSensitiveLog: (
  obj: FleetSpotMaintenanceStrategiesRequest
) => any;
export declare const SpotOptionsRequestFilterSensitiveLog: (
  obj: SpotOptionsRequest
) => any;
export declare const TargetCapacitySpecificationRequestFilterSensitiveLog: (
  obj: TargetCapacitySpecificationRequest
) => any;
export declare const CreateFleetRequestFilterSensitiveLog: (
  obj: CreateFleetRequest
) => any;
export declare const FleetLaunchTemplateSpecificationFilterSensitiveLog: (
  obj: FleetLaunchTemplateSpecification
) => any;
export declare const BaselineEbsBandwidthMbpsFilterSensitiveLog: (
  obj: BaselineEbsBandwidthMbps
) => any;
export declare const MemoryGiBPerVCpuFilterSensitiveLog: (
  obj: MemoryGiBPerVCpu
) => any;
export declare const MemoryMiBFilterSensitiveLog: (obj: MemoryMiB) => any;
export declare const NetworkBandwidthGbpsFilterSensitiveLog: (
  obj: NetworkBandwidthGbps
) => any;
export declare const NetworkInterfaceCountFilterSensitiveLog: (
  obj: NetworkInterfaceCount
) => any;
export declare const TotalLocalStorageGBFilterSensitiveLog: (
  obj: TotalLocalStorageGB
) => any;
export declare const VCpuCountRangeFilterSensitiveLog: (
  obj: VCpuCountRange
) => any;
export declare const InstanceRequirementsFilterSensitiveLog: (
  obj: InstanceRequirements
) => any;
export declare const PlacementResponseFilterSensitiveLog: (
  obj: PlacementResponse
) => any;
export declare const FleetLaunchTemplateOverridesFilterSensitiveLog: (
  obj: FleetLaunchTemplateOverrides
) => any;
export declare const LaunchTemplateAndOverridesResponseFilterSensitiveLog: (
  obj: LaunchTemplateAndOverridesResponse
) => any;
export declare const CreateFleetErrorFilterSensitiveLog: (
  obj: CreateFleetError
) => any;
export declare const CreateFleetInstanceFilterSensitiveLog: (
  obj: CreateFleetInstance
) => any;
export declare const CreateFleetResultFilterSensitiveLog: (
  obj: CreateFleetResult
) => any;
export declare const DestinationOptionsRequestFilterSensitiveLog: (
  obj: DestinationOptionsRequest
) => any;
export declare const CreateFlowLogsRequestFilterSensitiveLog: (
  obj: CreateFlowLogsRequest
) => any;
export declare const CreateFlowLogsResultFilterSensitiveLog: (
  obj: CreateFlowLogsResult
) => any;
export declare const StorageLocationFilterSensitiveLog: (
  obj: StorageLocation
) => any;
export declare const CreateFpgaImageRequestFilterSensitiveLog: (
  obj: CreateFpgaImageRequest
) => any;
export declare const CreateFpgaImageResultFilterSensitiveLog: (
  obj: CreateFpgaImageResult
) => any;
export declare const EbsBlockDeviceFilterSensitiveLog: (
  obj: EbsBlockDevice
) => any;
export declare const BlockDeviceMappingFilterSensitiveLog: (
  obj: BlockDeviceMapping
) => any;
export declare const CreateImageRequestFilterSensitiveLog: (
  obj: CreateImageRequest
) => any;
export declare const CreateImageResultFilterSensitiveLog: (
  obj: CreateImageResult
) => any;
export declare const InstanceEventWindowTimeRangeRequestFilterSensitiveLog: (
  obj: InstanceEventWindowTimeRangeRequest
) => any;
export declare const CreateInstanceEventWindowRequestFilterSensitiveLog: (
  obj: CreateInstanceEventWindowRequest
) => any;
export declare const CreateInstanceEventWindowResultFilterSensitiveLog: (
  obj: CreateInstanceEventWindowResult
) => any;
export declare const ExportToS3TaskSpecificationFilterSensitiveLog: (
  obj: ExportToS3TaskSpecification
) => any;
export declare const CreateInstanceExportTaskRequestFilterSensitiveLog: (
  obj: CreateInstanceExportTaskRequest
) => any;
export declare const ExportToS3TaskFilterSensitiveLog: (
  obj: ExportToS3Task
) => any;
export declare const InstanceExportDetailsFilterSensitiveLog: (
  obj: InstanceExportDetails
) => any;
export declare const ExportTaskFilterSensitiveLog: (obj: ExportTask) => any;
export declare const CreateInstanceExportTaskResultFilterSensitiveLog: (
  obj: CreateInstanceExportTaskResult
) => any;
export declare const CreateInternetGatewayRequestFilterSensitiveLog: (
  obj: CreateInternetGatewayRequest
) => any;
export declare const InternetGatewayFilterSensitiveLog: (
  obj: InternetGateway
) => any;
export declare const CreateInternetGatewayResultFilterSensitiveLog: (
  obj: CreateInternetGatewayResult
) => any;
export declare const CreateIpamRequestFilterSensitiveLog: (
  obj: CreateIpamRequest
) => any;
export declare const IpamOperatingRegionFilterSensitiveLog: (
  obj: IpamOperatingRegion
) => any;
export declare const IpamFilterSensitiveLog: (obj: Ipam) => any;
export declare const CreateIpamResultFilterSensitiveLog: (
  obj: CreateIpamResult
) => any;
export declare const RequestIpamResourceTagFilterSensitiveLog: (
  obj: RequestIpamResourceTag
) => any;
export declare const CreateIpamPoolRequestFilterSensitiveLog: (
  obj: CreateIpamPoolRequest
) => any;
export declare const IpamResourceTagFilterSensitiveLog: (
  obj: IpamResourceTag
) => any;
export declare const IpamPoolFilterSensitiveLog: (obj: IpamPool) => any;
export declare const CreateIpamPoolResultFilterSensitiveLog: (
  obj: CreateIpamPoolResult
) => any;
export declare const CreateIpamScopeRequestFilterSensitiveLog: (
  obj: CreateIpamScopeRequest
) => any;
export declare const IpamScopeFilterSensitiveLog: (obj: IpamScope) => any;
export declare const CreateIpamScopeResultFilterSensitiveLog: (
  obj: CreateIpamScopeResult
) => any;
export declare const CreateKeyPairRequestFilterSensitiveLog: (
  obj: CreateKeyPairRequest
) => any;
export declare const KeyPairFilterSensitiveLog: (obj: KeyPair) => any;
export declare const LaunchTemplateEbsBlockDeviceRequestFilterSensitiveLog: (
  obj: LaunchTemplateEbsBlockDeviceRequest
) => any;
export declare const LaunchTemplateBlockDeviceMappingRequestFilterSensitiveLog: (
  obj: LaunchTemplateBlockDeviceMappingRequest
) => any;
export declare const CapacityReservationTargetFilterSensitiveLog: (
  obj: CapacityReservationTarget
) => any;
export declare const LaunchTemplateCapacityReservationSpecificationRequestFilterSensitiveLog: (
  obj: LaunchTemplateCapacityReservationSpecificationRequest
) => any;
export declare const LaunchTemplateCpuOptionsRequestFilterSensitiveLog: (
  obj: LaunchTemplateCpuOptionsRequest
) => any;
export declare const CreditSpecificationRequestFilterSensitiveLog: (
  obj: CreditSpecificationRequest
) => any;
export declare const ElasticGpuSpecificationFilterSensitiveLog: (
  obj: ElasticGpuSpecification
) => any;
export declare const LaunchTemplateElasticInferenceAcceleratorFilterSensitiveLog: (
  obj: LaunchTemplateElasticInferenceAccelerator
) => any;
export declare const LaunchTemplateEnclaveOptionsRequestFilterSensitiveLog: (
  obj: LaunchTemplateEnclaveOptionsRequest
) => any;
export declare const LaunchTemplateHibernationOptionsRequestFilterSensitiveLog: (
  obj: LaunchTemplateHibernationOptionsRequest
) => any;
export declare const LaunchTemplateIamInstanceProfileSpecificationRequestFilterSensitiveLog: (
  obj: LaunchTemplateIamInstanceProfileSpecificationRequest
) => any;
export declare const LaunchTemplateSpotMarketOptionsRequestFilterSensitiveLog: (
  obj: LaunchTemplateSpotMarketOptionsRequest
) => any;
export declare const LaunchTemplateInstanceMarketOptionsRequestFilterSensitiveLog: (
  obj: LaunchTemplateInstanceMarketOptionsRequest
) => any;
export declare const LaunchTemplateLicenseConfigurationRequestFilterSensitiveLog: (
  obj: LaunchTemplateLicenseConfigurationRequest
) => any;
export declare const LaunchTemplateInstanceMaintenanceOptionsRequestFilterSensitiveLog: (
  obj: LaunchTemplateInstanceMaintenanceOptionsRequest
) => any;
export declare const LaunchTemplateInstanceMetadataOptionsRequestFilterSensitiveLog: (
  obj: LaunchTemplateInstanceMetadataOptionsRequest
) => any;
export declare const LaunchTemplatesMonitoringRequestFilterSensitiveLog: (
  obj: LaunchTemplatesMonitoringRequest
) => any;
export declare const Ipv4PrefixSpecificationRequestFilterSensitiveLog: (
  obj: Ipv4PrefixSpecificationRequest
) => any;
export declare const InstanceIpv6AddressRequestFilterSensitiveLog: (
  obj: InstanceIpv6AddressRequest
) => any;
export declare const Ipv6PrefixSpecificationRequestFilterSensitiveLog: (
  obj: Ipv6PrefixSpecificationRequest
) => any;
export declare const PrivateIpAddressSpecificationFilterSensitiveLog: (
  obj: PrivateIpAddressSpecification
) => any;
export declare const LaunchTemplateInstanceNetworkInterfaceSpecificationRequestFilterSensitiveLog: (
  obj: LaunchTemplateInstanceNetworkInterfaceSpecificationRequest
) => any;
export declare const LaunchTemplatePlacementRequestFilterSensitiveLog: (
  obj: LaunchTemplatePlacementRequest
) => any;
export declare const LaunchTemplatePrivateDnsNameOptionsRequestFilterSensitiveLog: (
  obj: LaunchTemplatePrivateDnsNameOptionsRequest
) => any;
export declare const LaunchTemplateTagSpecificationRequestFilterSensitiveLog: (
  obj: LaunchTemplateTagSpecificationRequest
) => any;
export declare const RequestLaunchTemplateDataFilterSensitiveLog: (
  obj: RequestLaunchTemplateData
) => any;
export declare const CreateLaunchTemplateRequestFilterSensitiveLog: (
  obj: CreateLaunchTemplateRequest
) => any;
export declare const LaunchTemplateFilterSensitiveLog: (
  obj: LaunchTemplate
) => any;
export declare const ValidationErrorFilterSensitiveLog: (
  obj: ValidationError
) => any;
export declare const ValidationWarningFilterSensitiveLog: (
  obj: ValidationWarning
) => any;
export declare const CreateLaunchTemplateResultFilterSensitiveLog: (
  obj: CreateLaunchTemplateResult
) => any;
export declare const CreateLaunchTemplateVersionRequestFilterSensitiveLog: (
  obj: CreateLaunchTemplateVersionRequest
) => any;
export declare const LaunchTemplateEbsBlockDeviceFilterSensitiveLog: (
  obj: LaunchTemplateEbsBlockDevice
) => any;
export declare const LaunchTemplateBlockDeviceMappingFilterSensitiveLog: (
  obj: LaunchTemplateBlockDeviceMapping
) => any;
export declare const CapacityReservationTargetResponseFilterSensitiveLog: (
  obj: CapacityReservationTargetResponse
) => any;
export declare const LaunchTemplateCapacityReservationSpecificationResponseFilterSensitiveLog: (
  obj: LaunchTemplateCapacityReservationSpecificationResponse
) => any;
export declare const LaunchTemplateCpuOptionsFilterSensitiveLog: (
  obj: LaunchTemplateCpuOptions
) => any;
export declare const CreditSpecificationFilterSensitiveLog: (
  obj: CreditSpecification
) => any;
export declare const ElasticGpuSpecificationResponseFilterSensitiveLog: (
  obj: ElasticGpuSpecificationResponse
) => any;
export declare const LaunchTemplateElasticInferenceAcceleratorResponseFilterSensitiveLog: (
  obj: LaunchTemplateElasticInferenceAcceleratorResponse
) => any;
export declare const LaunchTemplateEnclaveOptionsFilterSensitiveLog: (
  obj: LaunchTemplateEnclaveOptions
) => any;
export declare const LaunchTemplateHibernationOptionsFilterSensitiveLog: (
  obj: LaunchTemplateHibernationOptions
) => any;
export declare const LaunchTemplateIamInstanceProfileSpecificationFilterSensitiveLog: (
  obj: LaunchTemplateIamInstanceProfileSpecification
) => any;
export declare const LaunchTemplateSpotMarketOptionsFilterSensitiveLog: (
  obj: LaunchTemplateSpotMarketOptions
) => any;
export declare const LaunchTemplateInstanceMarketOptionsFilterSensitiveLog: (
  obj: LaunchTemplateInstanceMarketOptions
) => any;
export declare const LaunchTemplateLicenseConfigurationFilterSensitiveLog: (
  obj: LaunchTemplateLicenseConfiguration
) => any;
export declare const LaunchTemplateInstanceMaintenanceOptionsFilterSensitiveLog: (
  obj: LaunchTemplateInstanceMaintenanceOptions
) => any;
export declare const LaunchTemplateInstanceMetadataOptionsFilterSensitiveLog: (
  obj: LaunchTemplateInstanceMetadataOptions
) => any;
export declare const LaunchTemplatesMonitoringFilterSensitiveLog: (
  obj: LaunchTemplatesMonitoring
) => any;
export declare const Ipv4PrefixSpecificationResponseFilterSensitiveLog: (
  obj: Ipv4PrefixSpecificationResponse
) => any;
export declare const InstanceIpv6AddressFilterSensitiveLog: (
  obj: InstanceIpv6Address
) => any;
export declare const Ipv6PrefixSpecificationResponseFilterSensitiveLog: (
  obj: Ipv6PrefixSpecificationResponse
) => any;
export declare const LaunchTemplateInstanceNetworkInterfaceSpecificationFilterSensitiveLog: (
  obj: LaunchTemplateInstanceNetworkInterfaceSpecification
) => any;
export declare const LaunchTemplatePlacementFilterSensitiveLog: (
  obj: LaunchTemplatePlacement
) => any;
export declare const LaunchTemplatePrivateDnsNameOptionsFilterSensitiveLog: (
  obj: LaunchTemplatePrivateDnsNameOptions
) => any;
export declare const LaunchTemplateTagSpecificationFilterSensitiveLog: (
  obj: LaunchTemplateTagSpecification
) => any;
export declare const ResponseLaunchTemplateDataFilterSensitiveLog: (
  obj: ResponseLaunchTemplateData
) => any;
export declare const LaunchTemplateVersionFilterSensitiveLog: (
  obj: LaunchTemplateVersion
) => any;
export declare const CreateLaunchTemplateVersionResultFilterSensitiveLog: (
  obj: CreateLaunchTemplateVersionResult
) => any;
export declare const CreateLocalGatewayRouteRequestFilterSensitiveLog: (
  obj: CreateLocalGatewayRouteRequest
) => any;
export declare const LocalGatewayRouteFilterSensitiveLog: (
  obj: LocalGatewayRoute
) => any;
export declare const CreateLocalGatewayRouteResultFilterSensitiveLog: (
  obj: CreateLocalGatewayRouteResult
) => any;
export declare const CreateLocalGatewayRouteTableRequestFilterSensitiveLog: (
  obj: CreateLocalGatewayRouteTableRequest
) => any;
export declare const StateReasonFilterSensitiveLog: (obj: StateReason) => any;
export declare const LocalGatewayRouteTableFilterSensitiveLog: (
  obj: LocalGatewayRouteTable
) => any;
export declare const CreateLocalGatewayRouteTableResultFilterSensitiveLog: (
  obj: CreateLocalGatewayRouteTableResult
) => any;
export declare const CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequestFilterSensitiveLog: (
  obj: CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest
) => any;
export declare const LocalGatewayRouteTableVirtualInterfaceGroupAssociationFilterSensitiveLog: (
  obj: LocalGatewayRouteTableVirtualInterfaceGroupAssociation
) => any;
export declare const CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResultFilterSensitiveLog: (
  obj: CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult
) => any;
export declare const CreateLocalGatewayRouteTableVpcAssociationRequestFilterSensitiveLog: (
  obj: CreateLocalGatewayRouteTableVpcAssociationRequest
) => any;
export declare const LocalGatewayRouteTableVpcAssociationFilterSensitiveLog: (
  obj: LocalGatewayRouteTableVpcAssociation
) => any;
export declare const CreateLocalGatewayRouteTableVpcAssociationResultFilterSensitiveLog: (
  obj: CreateLocalGatewayRouteTableVpcAssociationResult
) => any;
export declare const CreateManagedPrefixListRequestFilterSensitiveLog: (
  obj: CreateManagedPrefixListRequest
) => any;
export declare const ManagedPrefixListFilterSensitiveLog: (
  obj: ManagedPrefixList
) => any;
export declare const CreateManagedPrefixListResultFilterSensitiveLog: (
  obj: CreateManagedPrefixListResult
) => any;
export declare const CreateNatGatewayRequestFilterSensitiveLog: (
  obj: CreateNatGatewayRequest
) => any;
export declare const NatGatewayAddressFilterSensitiveLog: (
  obj: NatGatewayAddress
) => any;
export declare const ProvisionedBandwidthFilterSensitiveLog: (
  obj: ProvisionedBandwidth
) => any;
export declare const NatGatewayFilterSensitiveLog: (obj: NatGateway) => any;
export declare const CreateNatGatewayResultFilterSensitiveLog: (
  obj: CreateNatGatewayResult
) => any;
export declare const CreateNetworkAclRequestFilterSensitiveLog: (
  obj: CreateNetworkAclRequest
) => any;
export declare const NetworkAclAssociationFilterSensitiveLog: (
  obj: NetworkAclAssociation
) => any;
export declare const IcmpTypeCodeFilterSensitiveLog: (obj: IcmpTypeCode) => any;
export declare const NetworkAclEntryFilterSensitiveLog: (
  obj: NetworkAclEntry
) => any;
export declare const NetworkAclFilterSensitiveLog: (obj: NetworkAcl) => any;
export declare const CreateNetworkAclResultFilterSensitiveLog: (
  obj: CreateNetworkAclResult
) => any;
export declare const CreateNetworkAclEntryRequestFilterSensitiveLog: (
  obj: CreateNetworkAclEntryRequest
) => any;
export declare const CreateNetworkInsightsAccessScopeRequestFilterSensitiveLog: (
  obj: CreateNetworkInsightsAccessScopeRequest
) => any;
export declare const NetworkInsightsAccessScopeFilterSensitiveLog: (
  obj: NetworkInsightsAccessScope
) => any;
export declare const NetworkInsightsAccessScopeContentFilterSensitiveLog: (
  obj: NetworkInsightsAccessScopeContent
) => any;
export declare const CreateNetworkInsightsAccessScopeResultFilterSensitiveLog: (
  obj: CreateNetworkInsightsAccessScopeResult
) => any;
export declare const CreateNetworkInsightsPathRequestFilterSensitiveLog: (
  obj: CreateNetworkInsightsPathRequest
) => any;
export declare const NetworkInsightsPathFilterSensitiveLog: (
  obj: NetworkInsightsPath
) => any;
export declare const CreateNetworkInsightsPathResultFilterSensitiveLog: (
  obj: CreateNetworkInsightsPathResult
) => any;
export declare const CreateNetworkInterfaceRequestFilterSensitiveLog: (
  obj: CreateNetworkInterfaceRequest
) => any;
export declare const NetworkInterfaceAssociationFilterSensitiveLog: (
  obj: NetworkInterfaceAssociation
) => any;
export declare const AttachmentEnaSrdUdpSpecificationFilterSensitiveLog: (
  obj: AttachmentEnaSrdUdpSpecification
) => any;
export declare const AttachmentEnaSrdSpecificationFilterSensitiveLog: (
  obj: AttachmentEnaSrdSpecification
) => any;
export declare const NetworkInterfaceAttachmentFilterSensitiveLog: (
  obj: NetworkInterfaceAttachment
) => any;
export declare const GroupIdentifierFilterSensitiveLog: (
  obj: GroupIdentifier
) => any;
export declare const NetworkInterfaceIpv6AddressFilterSensitiveLog: (
  obj: NetworkInterfaceIpv6Address
) => any;
export declare const Ipv6PrefixSpecificationFilterSensitiveLog: (
  obj: Ipv6PrefixSpecification
) => any;
export declare const NetworkInterfacePrivateIpAddressFilterSensitiveLog: (
  obj: NetworkInterfacePrivateIpAddress
) => any;
export declare const NetworkInterfaceFilterSensitiveLog: (
  obj: NetworkInterface
) => any;
export declare const CreateNetworkInterfaceResultFilterSensitiveLog: (
  obj: CreateNetworkInterfaceResult
) => any;
export declare const CreateNetworkInterfacePermissionRequestFilterSensitiveLog: (
  obj: CreateNetworkInterfacePermissionRequest
) => any;
export declare const NetworkInterfacePermissionStateFilterSensitiveLog: (
  obj: NetworkInterfacePermissionState
) => any;
export declare const NetworkInterfacePermissionFilterSensitiveLog: (
  obj: NetworkInterfacePermission
) => any;
export declare const CreateNetworkInterfacePermissionResultFilterSensitiveLog: (
  obj: CreateNetworkInterfacePermissionResult
) => any;
export declare const CreatePlacementGroupRequestFilterSensitiveLog: (
  obj: CreatePlacementGroupRequest
) => any;
export declare const PlacementGroupFilterSensitiveLog: (
  obj: PlacementGroup
) => any;
export declare const CreatePlacementGroupResultFilterSensitiveLog: (
  obj: CreatePlacementGroupResult
) => any;
export declare const CreatePublicIpv4PoolRequestFilterSensitiveLog: (
  obj: CreatePublicIpv4PoolRequest
) => any;
export declare const CreatePublicIpv4PoolResultFilterSensitiveLog: (
  obj: CreatePublicIpv4PoolResult
) => any;
export declare const CreateReplaceRootVolumeTaskRequestFilterSensitiveLog: (
  obj: CreateReplaceRootVolumeTaskRequest
) => any;
export declare const ReplaceRootVolumeTaskFilterSensitiveLog: (
  obj: ReplaceRootVolumeTask
) => any;
export declare const CreateReplaceRootVolumeTaskResultFilterSensitiveLog: (
  obj: CreateReplaceRootVolumeTaskResult
) => any;
export declare const PriceScheduleSpecificationFilterSensitiveLog: (
  obj: PriceScheduleSpecification
) => any;
export declare const CreateReservedInstancesListingRequestFilterSensitiveLog: (
  obj: CreateReservedInstancesListingRequest
) => any;
export declare const CreateReservedInstancesListingResultFilterSensitiveLog: (
  obj: CreateReservedInstancesListingResult
) => any;
export declare const CreateRestoreImageTaskRequestFilterSensitiveLog: (
  obj: CreateRestoreImageTaskRequest
) => any;
export declare const CreateRestoreImageTaskResultFilterSensitiveLog: (
  obj: CreateRestoreImageTaskResult
) => any;
export declare const CreateRouteRequestFilterSensitiveLog: (
  obj: CreateRouteRequest
) => any;
export declare const CreateRouteResultFilterSensitiveLog: (
  obj: CreateRouteResult
) => any;
export declare const CreateRouteTableRequestFilterSensitiveLog: (
  obj: CreateRouteTableRequest
) => any;
export declare const RouteTableAssociationFilterSensitiveLog: (
  obj: RouteTableAssociation
) => any;
export declare const PropagatingVgwFilterSensitiveLog: (
  obj: PropagatingVgw
) => any;
export declare const RouteFilterSensitiveLog: (obj: Route) => any;
export declare const RouteTableFilterSensitiveLog: (obj: RouteTable) => any;
export declare const CreateRouteTableResultFilterSensitiveLog: (
  obj: CreateRouteTableResult
) => any;
export declare const CreateSecurityGroupRequestFilterSensitiveLog: (
  obj: CreateSecurityGroupRequest
) => any;
export declare const CreateSecurityGroupResultFilterSensitiveLog: (
  obj: CreateSecurityGroupResult
) => any;
export declare const CreateSnapshotRequestFilterSensitiveLog: (
  obj: CreateSnapshotRequest
) => any;
export declare const SnapshotFilterSensitiveLog: (obj: Snapshot) => any;
export declare const InstanceSpecificationFilterSensitiveLog: (
  obj: InstanceSpecification
) => any;
export declare const CreateSnapshotsRequestFilterSensitiveLog: (
  obj: CreateSnapshotsRequest
) => any;
