import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  RunScheduledInstancesRequest,
  RunScheduledInstancesResult,
} from "../models/models_6";
export interface RunScheduledInstancesCommandInput
  extends RunScheduledInstancesRequest {}
export interface RunScheduledInstancesCommandOutput
  extends RunScheduledInstancesResult,
    __MetadataBearer {}
export declare class RunScheduledInstancesCommand extends $Command<
  RunScheduledInstancesCommandInput,
  RunScheduledInstancesCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: RunScheduledInstancesCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: RunScheduledInstancesCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    RunScheduledInstancesCommandInput,
    RunScheduledInstancesCommandOutput
  >;
  private serialize;
  private deserialize;
}
