import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  RevokeSecurityGroupIngressRequest,
  RevokeSecurityGroupIngressResult,
} from "../models/models_6";
export interface RevokeSecurityGroupIngressCommandInput
  extends RevokeSecurityGroupIngressRequest {}
export interface RevokeSecurityGroupIngressCommandOutput
  extends RevokeSecurityGroupIngressResult,
    __MetadataBearer {}
export declare class RevokeSecurityGroupIngressCommand extends $Command<
  RevokeSecurityGroupIngressCommandInput,
  RevokeSecurityGroupIngressCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: RevokeSecurityGroupIngressCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: RevokeSecurityGroupIngressCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    RevokeSecurityGroupIngressCommandInput,
    RevokeSecurityGroupIngressCommandOutput
  >;
  private serialize;
  private deserialize;
}
