import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  RestoreImageFromRecycleBinRequest,
  RestoreImageFromRecycleBinResult,
} from "../models/models_6";
export interface RestoreImageFromRecycleBinCommandInput
  extends RestoreImageFromRecycleBinRequest {}
export interface RestoreImageFromRecycleBinCommandOutput
  extends RestoreImageFromRecycleBinResult,
    __MetadataBearer {}
export declare class RestoreImageFromRecycleBinCommand extends $Command<
  RestoreImageFromRecycleBinCommandInput,
  RestoreImageFromRecycleBinCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: RestoreImageFromRecycleBinCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: RestoreImageFromRecycleBinCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    RestoreImageFromRecycleBinCommandInput,
    RestoreImageFromRecycleBinCommandOutput
  >;
  private serialize;
  private deserialize;
}
