import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  RestoreAddressToClassicRequest,
  RestoreAddressToClassicResult,
} from "../models/models_6";
export interface RestoreAddressToClassicCommandInput
  extends RestoreAddressToClassicRequest {}
export interface RestoreAddressToClassicCommandOutput
  extends RestoreAddressToClassicResult,
    __MetadataBearer {}
export declare class RestoreAddressToClassicCommand extends $Command<
  RestoreAddressToClassicCommandInput,
  RestoreAddressToClassicCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: RestoreAddressToClassicCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: RestoreAddressToClassicCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    RestoreAddressToClassicCommandInput,
    RestoreAddressToClassicCommandOutput
  >;
  private serialize;
  private deserialize;
}
