import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import { ReleaseAddressRequest } from "../models/models_6";
export interface ReleaseAddressCommandInput extends ReleaseAddressRequest {}
export interface ReleaseAddressCommandOutput extends __MetadataBearer {}
export declare class ReleaseAddressCommand extends $Command<
  ReleaseAddressCommandInput,
  ReleaseAddressCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: ReleaseAddressCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: ReleaseAddressCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<ReleaseAddressCommandInput, ReleaseAddressCommandOutput>;
  private serialize;
  private deserialize;
}
