import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  ModifyIpamScopeRequest,
  ModifyIpamScopeResult,
} from "../models/models_6";
export interface ModifyIpamScopeCommandInput extends ModifyIpamScopeRequest {}
export interface ModifyIpamScopeCommandOutput
  extends ModifyIpamScopeResult,
    __MetadataBearer {}
export declare class ModifyIpamScopeCommand extends $Command<
  ModifyIpamScopeCommandInput,
  ModifyIpamScopeCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: ModifyIpamScopeCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: ModifyIpamScopeCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<ModifyIpamScopeCommandInput, ModifyIpamScopeCommandOutput>;
  private serialize;
  private deserialize;
}
