import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import { ModifyIpamRequest, ModifyIpamResult } from "../models/models_6";
export interface ModifyIpamCommandInput extends ModifyIpamRequest {}
export interface ModifyIpamCommandOutput
  extends ModifyIpamResult,
    __MetadataBearer {}
export declare class ModifyIpamCommand extends $Command<
  ModifyIpamCommandInput,
  ModifyIpamCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: ModifyIpamCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: ModifyIpamCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<ModifyIpamCommandInput, ModifyIpamCommandOutput>;
  private serialize;
  private deserialize;
}
