import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  ModifyInstanceCreditSpecificationRequest,
  ModifyInstanceCreditSpecificationResult,
} from "../models/models_6";
export interface ModifyInstanceCreditSpecificationCommandInput
  extends ModifyInstanceCreditSpecificationRequest {}
export interface ModifyInstanceCreditSpecificationCommandOutput
  extends ModifyInstanceCreditSpecificationResult,
    __MetadataBearer {}
export declare class ModifyInstanceCreditSpecificationCommand extends $Command<
  ModifyInstanceCreditSpecificationCommandInput,
  ModifyInstanceCreditSpecificationCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: ModifyInstanceCreditSpecificationCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: ModifyInstanceCreditSpecificationCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    ModifyInstanceCreditSpecificationCommandInput,
    ModifyInstanceCreditSpecificationCommandOutput
  >;
  private serialize;
  private deserialize;
}
