import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  ModifyAddressAttributeRequest,
  ModifyAddressAttributeResult,
} from "../models/models_5";
export interface ModifyAddressAttributeCommandInput
  extends ModifyAddressAttributeRequest {}
export interface ModifyAddressAttributeCommandOutput
  extends ModifyAddressAttributeResult,
    __MetadataBearer {}
export declare class ModifyAddressAttributeCommand extends $Command<
  ModifyAddressAttributeCommandInput,
  ModifyAddressAttributeCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: ModifyAddressAttributeCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: ModifyAddressAttributeCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    ModifyAddressAttributeCommandInput,
    ModifyAddressAttributeCommandOutput
  >;
  private serialize;
  private deserialize;
}
