import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import { ImportImageRequest, ImportImageResult } from "../models/models_5";
export interface ImportImageCommandInput extends ImportImageRequest {}
export interface ImportImageCommandOutput
  extends ImportImageResult,
    __MetadataBearer {}
export declare class ImportImageCommand extends $Command<
  ImportImageCommandInput,
  ImportImageCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: ImportImageCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: ImportImageCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<ImportImageCommandInput, ImportImageCommandOutput>;
  private serialize;
  private deserialize;
}
