import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  GetSubnetCidrReservationsRequest,
  GetSubnetCidrReservationsResult,
} from "../models/models_5";
export interface GetSubnetCidrReservationsCommandInput
  extends GetSubnetCidrReservationsRequest {}
export interface GetSubnetCidrReservationsCommandOutput
  extends GetSubnetCidrReservationsResult,
    __MetadataBearer {}
export declare class GetSubnetCidrReservationsCommand extends $Command<
  GetSubnetCidrReservationsCommandInput,
  GetSubnetCidrReservationsCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: GetSubnetCidrReservationsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: GetSubnetCidrReservationsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    GetSubnetCidrReservationsCommandInput,
    GetSubnetCidrReservationsCommandOutput
  >;
  private serialize;
  private deserialize;
}
