import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  GetConsoleScreenshotRequest,
  GetConsoleScreenshotResult,
} from "../models/models_5";
export interface GetConsoleScreenshotCommandInput
  extends GetConsoleScreenshotRequest {}
export interface GetConsoleScreenshotCommandOutput
  extends GetConsoleScreenshotResult,
    __MetadataBearer {}
export declare class GetConsoleScreenshotCommand extends $Command<
  GetConsoleScreenshotCommandInput,
  GetConsoleScreenshotCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: GetConsoleScreenshotCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: GetConsoleScreenshotCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    GetConsoleScreenshotCommandInput,
    GetConsoleScreenshotCommandOutput
  >;
  private serialize;
  private deserialize;
}
