import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  ExportTransitGatewayRoutesRequest,
  ExportTransitGatewayRoutesResult,
} from "../models/models_5";
export interface ExportTransitGatewayRoutesCommandInput
  extends ExportTransitGatewayRoutesRequest {}
export interface ExportTransitGatewayRoutesCommandOutput
  extends ExportTransitGatewayRoutesResult,
    __MetadataBearer {}
export declare class ExportTransitGatewayRoutesCommand extends $Command<
  ExportTransitGatewayRoutesCommandInput,
  ExportTransitGatewayRoutesCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: ExportTransitGatewayRoutesCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: ExportTransitGatewayRoutesCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    ExportTransitGatewayRoutesCommandInput,
    ExportTransitGatewayRoutesCommandOutput
  >;
  private serialize;
  private deserialize;
}
